(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    112562,       1988]
NotebookOptionsPosition[    110219,       1907]
NotebookOutlinePosition[    110684,       1926]
CellTagsIndexPosition[    110641,       1923]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Setup", "Subtitle",
 CellChangeTimes->{{3.416403828173414*^9, 3.416403828643074*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Num", "=", "20"}], ";"}]], "Input",
 CellChangeTimes->{{3.543573712301256*^9, 3.543573756183413*^9}, {
  3.543574876014192*^9, 3.543574876073792*^9}, {3.543575617836536*^9, 
  3.543575637675828*^9}, {3.543575825920938*^9, 3.543575849471277*^9}, {
  3.543641115884392*^9, 3.543641115946411*^9}, {3.543641220409461*^9, 
  3.543641251383165*^9}, {3.54364181771406*^9, 3.5436418485154457`*^9}, {
  3.543643489081835*^9, 3.543643489161632*^9}, {3.543644237813822*^9, 
  3.5436442414056053`*^9}, {3.543646068074832*^9, 3.5436460881379967`*^9}, {
  3.543646348818501*^9, 3.543646360337001*^9}, {3.543647423946373*^9, 
  3.543647434576531*^9}, {3.5436533986930656`*^9, 3.543653412955246*^9}, {
  3.5436539704749107`*^9, 3.5436539763385363`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetDirectory", "[", 
  RowBox[{"\"\<~/Work/SpecTestDim6/test_A2_even_10_\>\"", "<>", 
   RowBox[{"ToString", "[", "Num", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.409835087809119*^9, 3.409835115977159*^9}, {
   3.416635847241798*^9, 3.416635847680189*^9}, {3.416751046313847*^9, 
   3.416751049251234*^9}, {3.41836232060072*^9, 3.418362320711351*^9}, {
   3.418486850393906*^9, 3.418486851779914*^9}, {3.418535577405376*^9, 
   3.418535577746089*^9}, {3.418574367565178*^9, 3.418574368706373*^9}, {
   3.4186214723269167`*^9, 3.418621472499281*^9}, {3.4192663858873158`*^9, 
   3.419266389876519*^9}, {3.419326971190641*^9, 3.419326973802593*^9}, {
   3.419605883653659*^9, 3.419605885561534*^9}, {3.4199156484205427`*^9, 
   3.419915648680475*^9}, 3.420523854010706*^9, {3.4235478181390657`*^9, 
   3.423547822240744*^9}, {3.424172940026578*^9, 3.42417294057707*^9}, {
   3.424431263258628*^9, 3.424431267504211*^9}, 3.424519386242628*^9, {
   3.424535860866909*^9, 3.4245358720246077`*^9}, {3.42499546283073*^9, 
   3.424995489603842*^9}, 3.426742538602508*^9, 3.426759496610849*^9, {
   3.4283183180535088`*^9, 3.4283183189711637`*^9}, {3.428320695235765*^9, 
   3.428320695507463*^9}, {3.4318629462543087`*^9, 3.4318629470119257`*^9}, {
   3.460303998463634*^9, 3.4603040021800823`*^9}, {3.484635971000168*^9, 
   3.484635972632184*^9}, {3.4850827099415216`*^9, 3.485082710571054*^9}, {
   3.485082845894058*^9, 3.485082853858954*^9}, {3.485084750723681*^9, 
   3.485084751419438*^9}, {3.4850847870602283`*^9, 3.485084787363426*^9}, {
   3.48508484378804*^9, 3.4850848442193947`*^9}, {3.4850853154933653`*^9, 
   3.4850853157235527`*^9}, {3.4850862979816923`*^9, 3.485086298411607*^9}, {
   3.4852379817325687`*^9, 3.485237982018005*^9}, {3.485238222820307*^9, 
   3.485238227450156*^9}, {3.485238285876103*^9, 3.485238286130093*^9}, {
   3.485492172661565*^9, 3.4854921747716303`*^9}, {3.485492586589404*^9, 
   3.4854926069003983`*^9}, {3.4854936724221067`*^9, 3.48549367973215*^9}, {
   3.485501832609168*^9, 3.4855018530829563`*^9}, {3.4856010005462933`*^9, 
   3.4856010008130407`*^9}, {3.488091756301991*^9, 3.488091761429865*^9}, 
   3.488094133694298*^9, {3.497955269653586*^9, 3.497955274461647*^9}, {
   3.497958575907033*^9, 3.497958600913637*^9}, {3.5014868931896048`*^9, 
   3.460389663369878*^9}, {3.460389704896336*^9, 3.4603897129904003`*^9}, {
   3.4603922204453993`*^9, 3.460392222344493*^9}, {3.460392266905756*^9, 
   3.460392268705435*^9}, {3.460395642267106*^9, 3.460395644287435*^9}, {
   3.460614454521058*^9, 3.4602566779379683`*^9}, {3.503228431551488*^9, 
   3.503228436524933*^9}, {3.503228542222742*^9, 3.503228547597383*^9}, {
   3.503228702822233*^9, 3.5032287080770693`*^9}, {3.5032287634326363`*^9, 
   3.5032287920373917`*^9}, {3.503299083324341*^9, 3.503299083377543*^9}, {
   3.5033154761664057`*^9, 3.460430240132947*^9}, {3.504000649484867*^9, 
   3.504000651714735*^9}, {3.50400241569261*^9, 3.5040024158027687`*^9}, 
   3.5040027171264467`*^9, {3.504002957838019*^9, 3.504002957886496*^9}, {
   3.504003228813936*^9, 3.504003233062228*^9}, {3.504005134614668*^9, 
   3.504005134676628*^9}, {3.5175503277697363`*^9, 3.517550337172287*^9}, 
   3.5176352333015833`*^9, 3.517639677724669*^9, {3.517639794622183*^9, 
   3.460393412544794*^9}, {3.4603934588614264`*^9, 3.46039345896203*^9}, {
   3.4603948227264013`*^9, 3.4603948230063047`*^9}, {3.46039592023744*^9, 
   3.4603541260154552`*^9}, {3.460367929082286*^9, 3.4603679423512897`*^9}, {
   3.460396139843549*^9, 3.460396160173218*^9}, {3.460731696071714*^9, 
   3.4603939054442244`*^9}, {3.460394059231945*^9, 3.4603384186103573`*^9}, 
   3.4603530188161173`*^9, {3.518956097590767*^9, 3.518956107182001*^9}, {
   3.539245006551964*^9, 3.539245009414372*^9}, {3.539379784340918*^9, 
   3.5393797901478987`*^9}, {3.539394718158538*^9, 3.539394719693591*^9}, {
   3.5396134068005257`*^9, 3.53961341814257*^9}, 3.539625316423122*^9, {
   3.53962615543636*^9, 3.539626155731797*^9}, {3.539640153234454*^9, 
   3.539640153345796*^9}, {3.5396496449365673`*^9, 3.5396496641372337`*^9}, {
   3.541517005127461*^9, 3.5415170071657887`*^9}, {3.54182839407207*^9, 
   3.541828420569337*^9}, {3.54183493241658*^9, 3.541834932606698*^9}, {
   3.541870768434225*^9, 3.541870779922611*^9}, {3.541912601399901*^9, 
   3.541912611920711*^9}, 3.54191615414424*^9, {3.541916755484811*^9, 
   3.541916794057083*^9}, {3.541916934946216*^9, 3.5419169350227823`*^9}, 
   3.5419185502033653`*^9, 3.5419207730830793`*^9, {3.5419211195150948`*^9, 
   3.541921122611367*^9}, 3.54192122879902*^9, 3.541921446698812*^9, {
   3.541921530214692*^9, 3.541921532982778*^9}, 3.541921895356083*^9, 
   3.5419220647825212`*^9, {3.541922368685238*^9, 3.541922371661407*^9}, {
   3.541927748036261*^9, 3.541927774997998*^9}, {3.5419302989615173`*^9, 
   3.541930327473591*^9}, {3.541930795994828*^9, 3.541930823508972*^9}, {
   3.541942944258943*^9, 3.5419429466276283`*^9}, {3.542471987893951*^9, 
   3.542471988867894*^9}, {3.542476057650881*^9, 3.542476064552965*^9}, {
   3.542477416873596*^9, 3.542477422775877*^9}, {3.542477873833375*^9, 
   3.54247787389727*^9}, {3.542510446580202*^9, 3.542510446675967*^9}, {
   3.542511062181134*^9, 3.542511062267734*^9}, 3.543562045603869*^9, {
   3.543564623638427*^9, 3.543564675931404*^9}, {3.543573715456996*^9, 
   3.543573731722975*^9}, {3.543574870638606*^9, 3.543574872414144*^9}, {
   3.543575611181177*^9, 3.543575614172964*^9}, {3.543575823795958*^9, 
   3.543575824046627*^9}, {3.543641112557247*^9, 3.5436411346999607`*^9}, {
   3.5436412401772327`*^9, 3.5436412414798203`*^9}, {3.5436418005020647`*^9, 
   3.543641833888612*^9}, {3.5436437242517357`*^9, 3.5436437256102448`*^9}, {
   3.54364400765961*^9, 3.543644011147505*^9}, {3.543646072291016*^9, 
   3.5436460753068123`*^9}, {3.543646350135909*^9, 3.543646350238619*^9}, {
   3.54364742239646*^9, 3.543647422498665*^9}, {3.543653400732394*^9, 
   3.543653402780075*^9}, {3.543653965796712*^9, 3.543653965879266*^9}}],

Cell[BoxData["\<\"/Users/tobywiseman/Work/SpecTestDim6/test_A2_even_10_20\"\>\
"], "Output",
 CellChangeTimes->{{3.543575618790861*^9, 3.54357563841511*^9}, {
   3.5435758272848*^9, 3.54357585139438*^9}, {3.543641118541388*^9, 
   3.543641139282095*^9}, {3.5436412213919477`*^9, 3.54364125230081*^9}, {
   3.543641826466329*^9, 3.543641849534585*^9}, {3.543643480443037*^9, 
   3.5436435053092623`*^9}, {3.543644014272279*^9, 3.543644065669724*^9}, 
   3.543644116699967*^9, {3.54364416917155*^9, 3.543644242130122*^9}, {
   3.543646077075473*^9, 3.54364608891046*^9}, {3.543646351329907*^9, 
   3.5436463612960033`*^9}, {3.543647425018324*^9, 3.543647435602456*^9}, {
   3.5436534039950867`*^9, 3.543653413745322*^9}, {3.543653967868322*^9, 
   3.543653977135169*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"SetDirectory", "[", "\"\<~/Work/SpecTestDim6/test\>\"", "]"}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.5435748645035143`*^9, 3.543574867390313*^9}, {
  3.5435756066301203`*^9, 3.5435756084766293`*^9}}],

Cell[CellGroupData[{

Cell["Parameters", "Subsubtitle"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"NR", "=", 
    RowBox[{"Round", "[", "Num", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NA", "=", 
   RowBox[{"Round", "[", "Num", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.424684990943314*^9, 3.424685009641644*^9}, {
   3.428318366564241*^9, 3.428318370011374*^9}, {3.428320712332115*^9, 
   3.428320715035392*^9}, {3.428321609205154*^9, 3.428321610107437*^9}, {
   3.428321674253334*^9, 3.428321675187348*^9}, {3.428321777829453*^9, 
   3.428321782491363*^9}, {3.428321839877284*^9, 3.428321840587597*^9}, {
   3.42832189311731*^9, 3.428321898123312*^9}, 3.428322313917461*^9, {
   3.428397018991701*^9, 3.428397020326198*^9}, {3.428397073942317*^9, 
   3.428397074694132*^9}, {3.460371958003951*^9, 3.460371958104797*^9}, {
   3.4603720457079563`*^9, 3.460372047763648*^9}, {3.460372291684161*^9, 
   3.4603722931075287`*^9}, {3.460373302919477*^9, 3.460373302961478*^9}, {
   3.483951885437055*^9, 3.4839518875161753`*^9}, {3.484635968744611*^9, 
   3.484635969751956*^9}, 3.484636118744149*^9, 3.4846444100228777`*^9, {
   3.48508339416341*^9, 3.485083405491086*^9}, {3.485085303245249*^9, 
   3.485085306867683*^9}, {3.485086291710342*^9, 3.485086292659472*^9}, {
   3.4857577241095247`*^9, 3.485757725149055*^9}, {3.485758783294825*^9, 
   3.485758784293087*^9}, 3.485759025703066*^9, 3.4880230790722647`*^9, 
   3.488086808303135*^9, 3.488086945397163*^9, {3.4880886681110888`*^9, 
   3.488088668973008*^9}, {3.488089655230998*^9, 3.48808967203694*^9}, {
   3.488090547486993*^9, 3.4880905489652843`*^9}, {3.488091733751837*^9, 
   3.4880917397892227`*^9}, 3.488094127399479*^9, 3.4880955406078587`*^9, {
   3.4881052425606747`*^9, 3.4603495742220793`*^9}, {3.4603772971183653`*^9, 
   3.460377297227178*^9}, 3.4979562919256783`*^9, {3.4979585224756393`*^9, 
   3.497958524569262*^9}, {3.4979585911458397`*^9, 3.497958598760956*^9}, {
   3.498203857267253*^9, 3.49820385849557*^9}, 3.4982043460411587`*^9, 
   3.501488944020187*^9, 3.501489830225535*^9, 3.5014900392614527`*^9, 
   3.501490243933486*^9, 3.501493626245994*^9, {3.501495368255561*^9, 
   3.460393880613859*^9}, {3.460425905279276*^9, 3.460425906781336*^9}, {
   3.4604263479019117`*^9, 3.460426349274165*^9}, {3.460427514603363*^9, 
   3.4604275157856207`*^9}, {3.46042835113421*^9, 3.460428353035425*^9}, {
   3.460428406350349*^9, 3.460428406483911*^9}, {3.46042878514904*^9, 
   3.460389716765705*^9}, {3.46039222478507*^9, 3.460392225887754*^9}, {
   3.4603922709392242`*^9, 3.460392272256014*^9}, {3.460395646183907*^9, 
   3.4603956484449043`*^9}, {3.460614458000266*^9, 3.4602566845177383`*^9}, {
   3.503228440852928*^9, 3.50322844168471*^9}, {3.503228700455751*^9, 
   3.503228701285274*^9}, {3.503228770421946*^9, 3.5032287869591722`*^9}, {
   3.503315601106969*^9, 3.4604302437808437`*^9}, 3.504001606028618*^9, {
   3.5040024183547163`*^9, 3.504002419426552*^9}, {3.504002718123205*^9, 
   3.504002719294922*^9}, {3.504002959579298*^9, 3.5040029603639727`*^9}, {
   3.504003234322874*^9, 3.504003235035746*^9}, {3.5040051360529833`*^9, 
   3.504005136955735*^9}, {3.5175503407724*^9, 3.517550342588212*^9}, {
   3.517551062813801*^9, 3.517551070812138*^9}, {3.517551762238002*^9, 
   3.517551763276243*^9}, {3.517552941606324*^9, 3.517552944940358*^9}, {
   3.517553307598083*^9, 3.517553308396409*^9}, {3.517553683910129*^9, 
   3.5175536888029633`*^9}, {3.517553768380892*^9, 3.517553768492237*^9}, 
   3.517577392571465*^9, 3.517578754428321*^9, 3.5175790848847923`*^9, {
   3.517581643676695*^9, 3.517581643778459*^9}, 3.517635234940303*^9, 
   3.517635534227796*^9, 3.517636363309367*^9, 3.517636442389475*^9, 
   3.5176373300849743`*^9, {3.517639450429591*^9, 3.517639452172172*^9}, {
   3.5176395531660633`*^9, 3.517639575508013*^9}, {3.51763967439633*^9, 
   3.517639674571863*^9}, 3.5176397869823837`*^9, {3.51764011045453*^9, 
   3.517640111805228*^9}, {3.517640584390574*^9, 3.517640584477027*^9}, {
   3.5176406399181757`*^9, 3.5176406774624853`*^9}, {3.517640898573501*^9, 
   3.517640913868524*^9}, {3.517640947422961*^9, 3.460393414496331*^9}, {
   3.4603934605062513`*^9, 3.4603934605698643`*^9}, {3.460394820898333*^9, 
   3.460394820974127*^9}, {3.460395922145459*^9, 3.460354124191135*^9}, {
   3.4603679310624847`*^9, 3.460367944183139*^9}, {3.460396155591207*^9, 
   3.460396155724887*^9}, 3.460439830617852*^9, {3.46045354331511*^9, 
   3.460453543461433*^9}, 3.4604560183373537`*^9, {3.4604602249050207`*^9, 
   3.460460226534424*^9}, {3.460460380780724*^9, 3.4604603808901463`*^9}, 
   3.460471936672646*^9, {3.460484026129711*^9, 3.460484027013692*^9}, 
   3.4604840582817802`*^9, {3.460484112355485*^9, 3.4604841125202007`*^9}, 
   3.460484500647767*^9, {3.4604846354686403`*^9, 3.460484636016966*^9}, 
   3.460484743552031*^9, 3.4604849156056337`*^9, 3.4607151460111113`*^9, {
   3.460715254677723*^9, 3.460715255130488*^9}, {3.460715448330154*^9, 
   3.460715448815824*^9}, {3.460716809145631*^9, 3.46071680920612*^9}, {
   3.4607188297627*^9, 3.460718830975819*^9}, {3.460731476434578*^9, 
   3.460731477631373*^9}, {3.460731535050942*^9, 3.4607315352561626`*^9}, {
   3.460731591798522*^9, 3.460731591978981*^9}, {3.460731691809689*^9, 
   3.460731694043305*^9}, {3.460736515451126*^9, 3.4603384213839273`*^9}, {
   3.460338489699533*^9, 3.460338489832295*^9}, 3.460340221148301*^9, 
   3.460340285657992*^9, 3.4603403652724752`*^9, {3.460340459731537*^9, 
   3.4603404633364153`*^9}, {3.460352931502083*^9, 3.4603529315946712`*^9}, {
   3.460353020181643*^9, 3.460353020255084*^9}, 3.51895670764672*^9, 
   3.519020014317944*^9, {3.519021381139086*^9, 3.519021381290501*^9}, {
   3.5190226040322847`*^9, 3.51902260415872*^9}, 3.5190255564670877`*^9, {
   3.519032026001388*^9, 3.51903202605582*^9}, 3.519036342972139*^9, {
   3.519036695494561*^9, 3.5190367021324778`*^9}, {3.519037572725209*^9, 
   3.519037572888605*^9}, {3.5190393466024427`*^9, 3.519039346722732*^9}, {
   3.519103601940345*^9, 3.519103604243354*^9}, {3.5191045289590816`*^9, 
   3.5191045298785553`*^9}, {3.519105638036515*^9, 3.519105641547327*^9}, 
   3.51910628414396*^9, 3.519114894247081*^9, {3.539245028581167*^9, 
   3.5392450286841516`*^9}, {3.539289457389844*^9, 3.539289457468582*^9}, 
   3.5393374768268747`*^9, {3.539338487870781*^9, 3.539338488989737*^9}, {
   3.539378710394084*^9, 3.539378719746093*^9}, {3.539378781692828*^9, 
   3.539378781931951*^9}, {3.539379405710493*^9, 3.5393794057975893`*^9}, {
   3.5393797780686283`*^9, 3.539379778118677*^9}, {3.539394710254491*^9, 
   3.5393947103492928`*^9}, {3.539394880288023*^9, 3.539394919621388*^9}, {
   3.5396134116784153`*^9, 3.539613420030156*^9}, {3.539625318640456*^9, 
   3.539625345215991*^9}, {3.5396261603605843`*^9, 3.5396261604713783`*^9}, {
   3.539649646527404*^9, 3.5396496661210127`*^9}, {3.541517009365698*^9, 
   3.541517009428812*^9}, {3.5415651682620163`*^9, 3.541565168467697*^9}, {
   3.5418284009352016`*^9, 3.5418284221530848`*^9}, 3.541870782073855*^9, {
   3.541911305687109*^9, 3.541911307198903*^9}, {3.5419115497148848`*^9, 
   3.541911549785179*^9}, {3.541912474327354*^9, 3.541912484216498*^9}, {
   3.541912599359333*^9, 3.541912613544551*^9}, {3.5419161561744537`*^9, 
   3.541916156318416*^9}, {3.5419162526035347`*^9, 3.5419162526665382`*^9}, {
   3.541916441968193*^9, 3.541916442118971*^9}, {3.541916752837326*^9, 
   3.541916796144848*^9}, {3.541918552050511*^9, 3.5419185525222387`*^9}, {
   3.5419186082170963`*^9, 3.541918608264206*^9}, {3.541919412229344*^9, 
   3.541919440431713*^9}, {3.541920769330167*^9, 3.541920769481142*^9}, {
   3.5419211178035088`*^9, 3.5419211178743973`*^9}, {3.541921225975322*^9, 
   3.541921226058124*^9}, {3.54192144430783*^9, 3.541921444409841*^9}, {
   3.5419215282309523`*^9, 3.54192152830191*^9}, {3.541921892908183*^9, 
   3.5419218929794197`*^9}, {3.541922060350636*^9, 3.541922060413685*^9}, {
   3.54192236603757*^9, 3.541922366124473*^9}, {3.5419277532356157`*^9, 
   3.541927776709906*^9}, {3.5419303023844643`*^9, 3.541930330393117*^9}, {
   3.541930801202978*^9, 3.5419308255567093`*^9}, {3.541942872604186*^9, 
   3.54194287269794*^9}, {3.541943118929317*^9, 3.5419431190320272`*^9}, {
   3.5419431822369967`*^9, 3.541943182347931*^9}, {3.541944506118176*^9, 
   3.541944506269092*^9}, {3.5419445377413893`*^9, 3.541944538140136*^9}, {
   3.541944576097782*^9, 3.5419446841610537`*^9}, {3.5419447563509283`*^9, 
   3.541944781368718*^9}, {3.5419448142973948`*^9, 3.54194491393071*^9}, {
   3.541944947125578*^9, 3.541944948380752*^9}, {3.541944982165875*^9, 
   3.541944984268785*^9}, {3.541945030079102*^9, 3.541945030150777*^9}, {
   3.541945060459507*^9, 3.541945082788033*^9}, {3.541945217989073*^9, 
   3.5419452438111973`*^9}, {3.541945274168273*^9, 3.541945274246801*^9}, {
   3.5419456085095367`*^9, 3.541945682903062*^9}, {3.541945724819084*^9, 
   3.541945741146782*^9}, {3.541945795265497*^9, 3.5419457953414383`*^9}, {
   3.541946043951415*^9, 3.5419460453993263`*^9}, {3.5420022090034523`*^9, 
   3.54200220908965*^9}, {3.542003114885702*^9, 3.54200311582909*^9}, {
   3.5420037844060593`*^9, 3.542003785953744*^9}, {3.54200443968298*^9, 
   3.5420044406759033`*^9}, {3.5420045971667967`*^9, 
   3.5420045981825523`*^9}, {3.542004648003187*^9, 3.542004678663822*^9}, {
   3.5420052644332447`*^9, 3.5420052660642223`*^9}, {3.542005376534943*^9, 
   3.542005377460844*^9}, {3.54201607394035*^9, 3.542016076420199*^9}, {
   3.54245836537558*^9, 3.542458366381887*^9}, {3.542458523117415*^9, 
   3.542458524019352*^9}, {3.5424585745670958`*^9, 3.5424586673394117`*^9}, {
   3.542458711852564*^9, 3.5424587482282763`*^9}, {3.542458815890827*^9, 
   3.5424588160097857`*^9}, {3.542458849346603*^9, 3.54245885032143*^9}, {
   3.542458915411263*^9, 3.542458915494857*^9}, {3.542459054851796*^9, 
   3.5424590549310923`*^9}, {3.542459098257523*^9, 3.542459100239826*^9}, {
   3.542459413161838*^9, 3.542459413232429*^9}, {3.54245946164228*^9, 
   3.542459462776466*^9}, {3.542459575104978*^9, 3.542459576135119*^9}, {
   3.542460076908101*^9, 3.5424600780224133`*^9}, {3.542460265954838*^9, 
   3.542460327786048*^9}, {3.5424603758362827`*^9, 3.5424603815067043`*^9}, {
   3.5424606705729628`*^9, 3.542460670635706*^9}, {3.542461436236948*^9, 
   3.5424614382034473`*^9}, {3.54247199188389*^9, 3.542471993227721*^9}, {
   3.542472284961397*^9, 3.542472286551201*^9}, {3.5424758949539223`*^9, 
   3.542475895873667*^9}, {3.5424760406018353`*^9, 3.542476062816866*^9}, {
   3.54247675671446*^9, 3.542476756769334*^9}, {3.5424767926028214`*^9, 
   3.542476792648121*^9}, {3.542476824245513*^9, 3.542476877521978*^9}, {
   3.542476925237205*^9, 3.542476958376362*^9}, {3.542477003319006*^9, 
   3.542477004989669*^9}, {3.5424770386999207`*^9, 3.542477040356597*^9}, {
   3.5424773179504843`*^9, 3.542477319444861*^9}, {3.542477418589834*^9, 
   3.542477425883668*^9}, {3.542477869387105*^9, 3.5424778716247473`*^9}, {
   3.542510448801757*^9, 3.542510450689619*^9}, {3.542511064226494*^9, 
   3.542511065914328*^9}, {3.543562041307774*^9, 3.543562043811906*^9}, {
   3.543564634132272*^9, 3.543564678627054*^9}, {3.543573725274349*^9, 
   3.543573726034134*^9}, {3.5436418101967773`*^9, 3.5436418102694893`*^9}, {
   3.543643479091014*^9, 3.5436435042896338`*^9}, {3.543643988780582*^9, 
   3.543643994529718*^9}, {3.543644030483684*^9, 3.543644064729994*^9}, {
   3.543644165826013*^9, 3.543644222390283*^9}, {3.543646070010933*^9, 
   3.543646070162805*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"EvenR", "=", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"EvenA", "=", "1"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5435620622228947`*^9, 3.54356207101924*^9}, {
   3.54357373347224*^9, 3.543573734208014*^9}, {3.5436411083893213`*^9, 
   3.543641138011436*^9}, {3.543641243295844*^9, 3.5436412445596323`*^9}, {
   3.543641805488858*^9, 3.543641807365081*^9}, {3.543643727610345*^9, 
   3.543643729186055*^9}, {3.543644001155232*^9, 3.543644004075058*^9}, 
   3.543644106617844*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Coordinates ", "Subsubtitle",
 CellChangeTimes->{{3.517556505886075*^9, 3.517556509091404*^9}, {
   3.5176375867460747`*^9, 3.517637607251473*^9}, {3.517639483331715*^9, 
   3.517639500939227*^9}, 3.541911237345125*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"EvenR", "\[NotEqual]", "1"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"NN", "=", 
       RowBox[{"NR", "-", "1"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"ChebR", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          FractionBox["1", "2"], 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"Cos", "[", 
             FractionBox[
              RowBox[{"\[Pi]", " ", "ii"}], "NN"], "]"}]}], ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "NN", ",", "0", ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"NN", "=", 
       RowBox[{
        RowBox[{"2", "*", "NR"}], "-", "1"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"tmp", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{"\[Pi]", " ", "ii"}], "NN"], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "NN", ",", "0", ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]",
       "\[IndentingNewLine]", 
      RowBox[{"ChebR", "=", 
       RowBox[{"N", "[", 
        RowBox[{"tmp", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"NR", "+", "1"}], ";;", 
           RowBox[{"NN", "+", "1"}]}], "]"}], "]"}], "]"}]}], ";"}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", "ChebR", "]"}]}], "Input",
 CellChangeTimes->{{3.542459495539332*^9, 3.542459501128222*^9}, {
  3.543562074108547*^9, 3.543562116636816*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.04026594010941514`", ",", "0.12053668025532306`", ",", 
   "0.2000256937760444`", ",", "0.27821746391645263`", ",", 
   "0.3546048870425356`", ",", "0.4286925614030542`", ",", "0.5`", ",", 
   "0.5680647467311558`", ",", "0.6324453755953773`", ",", 
   "0.6927243535095994`", ",", "0.7485107481711011`", ",", 
   "0.7994427634035012`", ",", "0.8451900855437948`", ",", 
   "0.8854560256532099`", ",", "0.9199794436588242`", ",", 
   "0.9485364419471455`", ",", "0.970941817426052`", ",", 
   "0.9870502626379128`", ",", "0.99675730813421`", ",", "1.`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.542459510831895*^9, 3.54245957712297*^9, 3.542460079993389*^9, {
   3.542460267360577*^9, 3.542460328610984*^9}, {3.5424603785943613`*^9, 
   3.542460382302911*^9}, 3.5424614395226583`*^9, 3.542471994231518*^9, 
   3.54247228752115*^9, 3.542475586765356*^9, 3.542475643338348*^9, 
   3.542475700036508*^9, 3.5424758967974243`*^9, {3.542476042558717*^9, 
   3.542476065469624*^9}, 3.5424767606344748`*^9, 3.5424767936320257`*^9, {
   3.5424768255271482`*^9, 3.54247687852031*^9}, {3.542476929613916*^9, 
   3.542476959237678*^9}, 3.5424770062124*^9, 3.542477041932147*^9, 
   3.5424773204929037`*^9, {3.542477390950469*^9, 3.5424774268696327`*^9}, 
   3.542477874850698*^9, 3.542510452286237*^9, 3.5425110673434267`*^9, 
   3.543562152441699*^9, {3.543564472701851*^9, 3.5435644976557817`*^9}, {
   3.543564636611825*^9, 3.5435646795252123`*^9}, {3.543573737071516*^9, 
   3.543573757070943*^9}, 3.543574877276758*^9, {3.543575618941721*^9, 
   3.543575638563677*^9}, {3.5435758275768833`*^9, 3.543575851722207*^9}, {
   3.5436411187069283`*^9, 3.5436411394300203`*^9}, {3.5436412215585012`*^9, 
   3.543641252451001*^9}, {3.543641827234477*^9, 3.543641849802926*^9}, {
   3.543643480612191*^9, 3.54364350547609*^9}, {3.543644014389007*^9, 
   3.5436440658051147`*^9}, 3.5436441168530397`*^9, {3.543644169287594*^9, 
   3.543644242263455*^9}, {3.543646077219479*^9, 3.543646089043387*^9}, {
   3.5436463517276382`*^9, 3.543646361634058*^9}, {3.543647425307035*^9, 
   3.543647435943115*^9}, {3.543653404149247*^9, 3.5436534139188957`*^9}, {
   3.5436539680010157`*^9, 3.54365397731957*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"EvenA", "\[NotEqual]", "1"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"NN", "=", 
       RowBox[{"NA", "-", "1"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"ChebA", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          FractionBox["1", "2"], 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"Cos", "[", 
             FractionBox[
              RowBox[{"\[Pi]", " ", "ii"}], "NN"], "]"}]}], ")"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "NN", ",", "0", ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"NN", "=", 
       RowBox[{
        RowBox[{"2", "*", "NA"}], "-", "1"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"tmp", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{"\[Pi]", " ", "ii"}], "NN"], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "NN", ",", "0", ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]",
       "\[IndentingNewLine]", 
      RowBox[{"ChebA", "=", 
       RowBox[{"N", "[", 
        RowBox[{"tmp", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"NA", "+", "1"}], ";;", 
           RowBox[{"NN", "+", "1"}]}], "]"}], "]"}], "]"}]}], ";"}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", "ChebA", "]"}]}], "Input",
 CellChangeTimes->{{3.542459495539332*^9, 3.542459501128222*^9}, {
  3.543562074108547*^9, 3.5435621435398073`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.04026594010941514`", ",", "0.12053668025532306`", ",", 
   "0.2000256937760444`", ",", "0.27821746391645263`", ",", 
   "0.3546048870425356`", ",", "0.4286925614030542`", ",", "0.5`", ",", 
   "0.5680647467311558`", ",", "0.6324453755953773`", ",", 
   "0.6927243535095994`", ",", "0.7485107481711011`", ",", 
   "0.7994427634035012`", ",", "0.8451900855437948`", ",", 
   "0.8854560256532099`", ",", "0.9199794436588242`", ",", 
   "0.9485364419471455`", ",", "0.970941817426052`", ",", 
   "0.9870502626379128`", ",", "0.99675730813421`", ",", "1.`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.5435621524776907`*^9, {3.543564472726376*^9, 3.54356449768908*^9}, {
   3.543564636668912*^9, 3.543564679562591*^9}, {3.543573737100905*^9, 
   3.54357375710744*^9}, 3.543574877316276*^9, {3.5435756189783707`*^9, 
   3.543575638602624*^9}, {3.543575827669405*^9, 3.5435758517916393`*^9}, {
   3.5436411187420053`*^9, 3.543641139468175*^9}, {3.5436412215925426`*^9, 
   3.543641252488167*^9}, {3.543641827346171*^9, 3.54364184991787*^9}, {
   3.543643480648204*^9, 3.543643505514954*^9}, {3.543644014421996*^9, 
   3.5436440658389*^9}, 3.543644116891046*^9, {3.5436441693265467`*^9, 
   3.543644242302339*^9}, {3.543646077257655*^9, 3.543646089081237*^9}, {
   3.5436463518157263`*^9, 3.543646361685334*^9}, {3.5436474253940077`*^9, 
   3.543647436004794*^9}, {3.5436534041871853`*^9, 3.543653413955193*^9}, {
   3.54365396803692*^9, 3.543653977354528*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"rarr", "=", "ChebR"}], ";"}]], "Input",
 CellChangeTimes->{{3.5419112392421103`*^9, 3.5419112505930147`*^9}, {
  3.541942999664897*^9, 3.541943000231793*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"aarr", "=", "ChebA"}], ";"}]], "Input",
 CellChangeTimes->{{3.541943057722303*^9, 3.541943059369103*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Setup patches", "Subsubtitle"],

Cell[BoxData[
 RowBox[{
  RowBox[{"patch", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"rarr", "[", 
        RowBox[{"[", "ii", "]"}], "]"}], ",", 
       RowBox[{"aarr", "[", 
        RowBox[{"[", "jj", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", "1", ",", "NR"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"jj", ",", "1", ",", "NA"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.418646820545536*^9, 3.418646822319734*^9}, {
  3.428319160860737*^9, 3.428319164787752*^9}, {3.5175542129112988`*^9, 
  3.517554218533983*^9}, {3.517554506951466*^9, 3.517554510917528*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"mask", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r", "<", "1."}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"r", "\[Rule]", 
           RowBox[{"rarr", "[", 
            RowBox[{"[", "ii", "]"}], "]"}]}], ",", 
          RowBox[{"a", "\[Rule]", 
           RowBox[{"aarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}]}]}], "}"}]}], ",", "1", ",", 
       "0"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", "1", ",", "NR"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"jj", ",", "1", ",", "NA"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.415878683028904*^9, 3.415878705834999*^9}, {
   3.415879392422065*^9, 3.415879401244133*^9}, {3.416587327360105*^9, 
   3.416587342286736*^9}, 3.418449265952444*^9, {3.4184516448017693`*^9, 
   3.4184516503039703`*^9}, {3.418451680856798*^9, 3.418451681031104*^9}, {
   3.418451733120633*^9, 3.418451756447001*^9}, {3.418451804592523*^9, 
   3.4184518059355392`*^9}, {3.418451857297715*^9, 3.4184518651215563`*^9}, {
   3.4186468242581882`*^9, 3.418646827481415*^9}, {3.4186500370661077`*^9, 
   3.418650040819312*^9}, {3.424172519127236*^9, 3.424172552797269*^9}, {
   3.4283191783676453`*^9, 3.428319182300681*^9}, {3.428319223574359*^9, 
   3.4283192354124947`*^9}, {3.460349604646447*^9, 3.4603496070172033`*^9}, 
   3.504001264078267*^9, {3.517554223960393*^9, 3.517554259176518*^9}, {
   3.517554513247904*^9, 3.517554518793303*^9}, {3.517636454495966*^9, 
   3.460453155099374*^9}, 3.460472299167761*^9, 3.460475503694417*^9, 
   3.460478870371244*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Setup vector masks and index", "Subsubtitle",
 CellChangeTimes->{{3.42417260741921*^9, 3.4241726101600018`*^9}, 
   3.424172648438816*^9, {3.42417321520971*^9, 3.424173216328911*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"disp", "[", "mat_", "]"}], ":=", 
  RowBox[{"MatrixForm", "[", 
   RowBox[{"Chop", "[", 
    RowBox[{
     RowBox[{"Reverse", "[", "mat", "]"}], ",", "2"}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.517554333398487*^9, 3.5175543357648*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"vecmask", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"mask", ",", 
     RowBox[{"{", 
      RowBox[{"var", ",", "1", ",", "5"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.424172616095664*^9, 3.42417264843913*^9}, {
   3.428319357069024*^9, 3.4283193605637503`*^9}, 3.460475516994877*^9, 
   3.460478872229726*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"disp", "[", 
   RowBox[{"vecmask", "[", 
    RowBox[{"[", "2", "]"}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"disp", "[", 
  RowBox[{"vecmask", "[", 
   RowBox[{"[", "4", "]"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.424172948110396*^9, 3.424172953744746*^9}, {
   3.424173051690943*^9, 3.4241730517514544`*^9}, {3.4241731064211473`*^9, 
   3.4241731246255627`*^9}, {3.4241731726352243`*^9, 
   3.4241731780033417`*^9}, {3.428319368387994*^9, 3.4283193749394283`*^9}, {
   3.428320726860293*^9, 3.428320728347766*^9}, 3.460475524947082*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.485491864301392*^9, {3.485492194424671*^9, 3.485492203600923*^9}, 
   3.485492614623082*^9, 3.48549368095347*^9, 3.485501840207075*^9, 
   3.4855187490858583`*^9, 3.485601005478911*^9, 3.4856010728665648`*^9, 
   3.485601563509389*^9, 3.4856016057723627`*^9, 3.485602639964013*^9, {
   3.4856041412863092`*^9, 3.4856041433110437`*^9}, 3.4856055977144327`*^9, 
   3.4857577267252398`*^9, 3.485758790011026*^9, {3.4857588554186487`*^9, 
   3.485759027118742*^9}, 3.488022992996626*^9, 3.488023082461605*^9, 
   3.4880868114960003`*^9, 3.488086946662936*^9, 3.488088673112059*^9, {
   3.488089656730801*^9, 3.488089673051313*^9}, 3.488090564156822*^9, {
   3.488091743864738*^9, 3.488091764346541*^9}, 3.488094135430737*^9, 
   3.488094339766486*^9, 3.488094390338008*^9, 3.488094661984242*^9, 
   3.488095139631012*^9, {3.488095534102748*^9, 3.488095541795362*^9}, 
   3.488100679583063*^9, 3.4881052496521463`*^9, {3.4881053804700603`*^9, 
   3.460349610440978*^9}, 3.460349689838066*^9, {3.4603497291000977`*^9, 
   3.46034977971763*^9}, 3.46034981901026*^9, 3.460349997938003*^9, {
   3.460367074095797*^9, 3.4603671353705063`*^9}, 3.460369223165945*^9, 
   3.460369797222683*^9, 3.460373147764389*^9, 3.460376301780631*^9, 
   3.46037729980206*^9, 3.4603773842721167`*^9, 3.460379557889228*^9, {
   3.460381548675118*^9, 3.4603816340233803`*^9}, {3.4603816789323473`*^9, 
   3.460381683513525*^9}, 3.460382646284061*^9, 3.460383836969322*^9, 
   3.460384010185211*^9, 3.460384080617732*^9, 3.460384182551626*^9, 
   3.460384337552655*^9, 3.460384575951867*^9, 3.460385907006112*^9, 
   3.460386052598714*^9, 3.460386427804043*^9, 3.460387410692741*^9, 
   3.4603879584961348`*^9, 3.4603886743563633`*^9, 3.460389048396307*^9, 
   3.460389646672159*^9, 3.460389963065598*^9, {3.497955260848908*^9, 
   3.497955275689596*^9}, 3.497955404576795*^9, {3.497955439691234*^9, 
   3.4979554621044903`*^9}, 3.497955596137746*^9, {3.4979556707872877`*^9, 
   3.497955684127451*^9}, 3.49795580825077*^9, 3.497956297104539*^9, {
   3.497957000681266*^9, 3.497957002562714*^9}, {3.497957572661827*^9, 
   3.4979575899678097`*^9}, 3.49795772547722*^9, 3.497957761534357*^9, 
   3.497957796014789*^9, 3.497958526075027*^9, {3.497958577187643*^9, 
   3.497958593238682*^9}, 3.4982038605705557`*^9, 3.498203902660976*^9, {
   3.498204347690165*^9, 3.4982043589273977`*^9}, 3.498204392175687*^9, 
   3.4982044341144257`*^9, 3.498204622939752*^9, {3.5014870570382433`*^9, 
   3.501487074547287*^9}, {3.5014871389281797`*^9, 3.501487147355729*^9}, {
   3.501487227562582*^9, 3.501487248015787*^9}, {3.5014872920604067`*^9, 
   3.501487308863119*^9}, 3.501488106296698*^9, 3.501488143381166*^9, 
   3.5014882223947906`*^9, 3.501488254548698*^9, {3.501488286404793*^9, 
   3.501488306587175*^9}, 3.501488382903673*^9, 3.5014885298070602`*^9, {
   3.501488565420887*^9, 3.50148859236976*^9}, {3.501488644922762*^9, 
   3.501488822716926*^9}, 3.501488945575447*^9, 3.501489833778697*^9, 
   3.501490041113618*^9, 3.501490245350789*^9, 3.5014930887213984`*^9, 
   3.5014931857353163`*^9, 3.5014932564094067`*^9, 3.501493326979061*^9, 
   3.501493405617869*^9, {3.501493627459387*^9, 3.501493652510063*^9}, {
   3.501493710286697*^9, 3.50149373564848*^9}, 3.5014942547647047`*^9, 
   3.5015025741640177`*^9, {3.5015027207188168`*^9, 3.50150273648623*^9}, 
   3.501502802963146*^9, 3.501502990031888*^9, 3.5015031675418253`*^9, {
   3.501503234067651*^9, 3.5015032809652557`*^9}, {3.501503319691927*^9, 
   3.501503340790675*^9}, {3.501503394110121*^9, 3.501503423050543*^9}, 
   3.501503491308098*^9, 3.501503542246965*^9, {3.5015035724701633`*^9, 
   3.501503591835827*^9}, {3.5015036316679707`*^9, 3.460391460778592*^9}, 
   3.460391552512026*^9, {3.460391620874823*^9, 3.460391726111676*^9}, 
   3.460391766433282*^9, 3.460391805655349*^9, {3.460391899134183*^9, 
   3.460391904423318*^9}, 3.460392449011526*^9, 3.460392491911765*^9, 
   3.460392539303013*^9, 3.460392592164415*^9, 3.4603926545201817`*^9, 
   3.460392722850359*^9, 3.460392780968513*^9, 3.46039353471695*^9, 
   3.460393828875861*^9, 3.46039388509589*^9, 3.460393944763908*^9, 
   3.460394705901523*^9, 3.460394759957761*^9, 3.460394958351165*^9, 
   3.4603950842337523`*^9, 3.4603952392886963`*^9, 3.460395389654508*^9, 
   3.460425925164006*^9, {3.46042602305262*^9, 3.460426140870483*^9}, 
   3.4604263508711576`*^9, 3.460427504771038*^9, 3.460427544505268*^9, 
   3.4604283657349453`*^9, 3.46042840800635*^9, 3.460428788724392*^9, {
   3.460428833422472*^9, 3.460389722909161*^9}, {3.4603922278406076`*^9, 
   3.4603922427047367`*^9}, 3.460392273890826*^9, 3.4603956506989603`*^9, {
   3.4606144524182587`*^9, 3.4602566908889008`*^9}, 3.4602570051447153`*^9, 
   3.503228443860219*^9, {3.5032285405059853`*^9, 3.503228548603945*^9}, {
   3.503228705371221*^9, 3.503228709267578*^9}, {3.503228774142935*^9, 
   3.5032287957631693`*^9}, {3.503299081024961*^9, 3.503299085356143*^9}, {
   3.50331561918917*^9, 3.460358821395665*^9}, 3.504000653220525*^9, {
   3.504000801904839*^9, 3.504000905340579*^9}, {3.504000958667583*^9, 
   3.5040009844387217`*^9}, {3.504001071312477*^9, 3.504001075441142*^9}, {
   3.504001269919468*^9, 3.504001274665419*^9}, 3.504001608823883*^9, 
   3.504002422596731*^9, 3.5040027233811693`*^9, 3.504002961724537*^9, {
   3.504003230741403*^9, 3.5040032361572113`*^9}, 3.504005138958823*^9, 
   3.517554265697289*^9, {3.517554337500514*^9, 3.517554351987936*^9}, {
   3.5175545231040697`*^9, 3.51755453989081*^9}, 3.517554705327265*^9, 
   3.517555341452415*^9, 3.5175683552388153`*^9, 3.517577421041807*^9, 
   3.517582231926661*^9, 3.51763524151375*^9, 3.517635556595634*^9, {
   3.5176364674651413`*^9, 3.517636493291709*^9}, 3.5176373324100533`*^9, 
   3.517639757514833*^9, 3.517640668250793*^9, 3.517640707908297*^9, {
   3.5176409047988*^9, 3.517640919785956*^9}, {3.517640953017754*^9, 
   3.4603934332944098`*^9}, 3.460393463908436*^9, 3.4603948297579393`*^9, {
   3.460395927797202*^9, 3.4603541284929256`*^9}, 3.4603556071558533`*^9, {
   3.4603679375298777`*^9, 3.460367953597089*^9}, 3.460396181975419*^9, 
   3.460439832589082*^9, 3.460453163716153*^9, 3.4604535451489058`*^9, {
   3.460456020938459*^9, 3.4604560444289217`*^9}, 3.460460228835271*^9, 
   3.4604603825066633`*^9, 3.4604719390896063`*^9, 3.460472301840584*^9, 
   3.4604755278961143`*^9, 3.4604784481075974`*^9, 3.460478527123383*^9, 
   3.460478873828088*^9, 3.460484028816951*^9, 3.460484060586214*^9, 
   3.460484114212631*^9, 3.4604845031689663`*^9, 3.4604846384876213`*^9, 
   3.460484746043729*^9, 3.4604849174940977`*^9, 3.4607151708050137`*^9, 
   3.460715257511959*^9, 3.46071546012398*^9, 3.460716811480632*^9, 
   3.460718862658382*^9, {3.460731510358283*^9, 3.460731537378489*^9}, 
   3.460731597992169*^9, {3.460731698375935*^9, 3.460393907924903*^9}, {
   3.460394070070269*^9, 3.460338444545535*^9}, 3.460338492438815*^9, 
   3.4603402915831003`*^9, 3.460340366868927*^9, 3.460340468299581*^9, 
   3.460352942615267*^9, 3.460353032121888*^9, 3.518956321045685*^9, 
   3.518956717427435*^9, 3.519020032031831*^9, 3.5190214013930492`*^9, 
   3.519022606810871*^9, 3.5190255620252*^9, 3.519032033630352*^9, 
   3.519036346937253*^9, 3.51903671225138*^9, 3.519037578841022*^9, 
   3.5190393531768*^9, 3.5191035561052237`*^9, 3.5191036086897993`*^9, 
   3.519104540989696*^9, 3.519105651285398*^9, 3.519106292148252*^9, 
   3.5191148988689623`*^9, 3.5392450405792847`*^9, 3.5392892268293467`*^9, 
   3.539289459617178*^9, 3.539337478794712*^9, {3.539378711871846*^9, 
   3.53937872115454*^9}, 3.53937878339888*^9, 3.539379407851843*^9, {
   3.5393797801219797`*^9, 3.539379791578126*^9}, {3.539394712254738*^9, 
   3.539394722506558*^9}, {3.539394882405622*^9, 3.5393949044989023`*^9}, {
   3.5396134150247383`*^9, 3.5396134227912827`*^9}, {3.53962532115784*^9, 
   3.539625346759416*^9}, 3.539626166086252*^9, {3.539649650224518*^9, 
   3.539649670297758*^9}, 3.5415170152143173`*^9, 3.541517103918021*^9, 
   3.5415651699913607`*^9, {3.541828397566525*^9, 3.5418284241223297`*^9}, {
   3.541834923396179*^9, 3.541834936226203*^9}, 3.541870783369664*^9, {
   3.5419112800415907`*^9, 3.541911308570372*^9}, 3.541911550891054*^9, {
   3.5419124756525908`*^9, 3.541912485338724*^9}, {3.541912604907995*^9, 
   3.5419126145768843`*^9}, 3.541916159338565*^9, 3.541916189584506*^9, 
   3.5419162538078547`*^9, 3.5419164430709333`*^9, {3.541916760708034*^9, 
   3.541916797254305*^9}, 3.5419169366125097`*^9, 3.541918554252759*^9, 
   3.5419186093817863`*^9, {3.541919413658525*^9, 3.541919441534745*^9}, {
   3.541920770898493*^9, 3.5419207745868692`*^9}, {3.5419211207558317`*^9, 
   3.541921123758713*^9}, {3.541921227345232*^9, 3.541921229999036*^9}, {
   3.5419214455653133`*^9, 3.5419214478856277`*^9}, {3.5419215315032063`*^9, 
   3.541921534668083*^9}, {3.54192189413622*^9, 3.541921896541644*^9}, {
   3.541922063320443*^9, 3.541922066092808*^9}, {3.541922369962749*^9, 
   3.5419223733019247`*^9}, {3.541927754322867*^9, 3.541927777722975*^9}, {
   3.5419303037076817`*^9, 3.541930331598156*^9}, {3.541930797993437*^9, 
   3.541930826814579*^9}, 3.5419430801305637`*^9, 3.5419431206281567`*^9, 
   3.5419431835005903`*^9, 3.541944507331827*^9, {3.541944565030623*^9, 
   3.541944685358245*^9}, {3.541944757675283*^9, 3.541944782420961*^9}, {
   3.541944815973489*^9, 3.54194491532349*^9}, 3.541944949458642*^9, 
   3.5419449853833637`*^9, 3.541945032058445*^9, {3.541945063439651*^9, 
   3.541945083914802*^9}, {3.541945219370872*^9, 3.541945245156946*^9}, 
   3.5419452754351673`*^9, {3.541945609942567*^9, 3.541945684076754*^9}, {
   3.541945727497978*^9, 3.541945742594751*^9}, 3.541945797039255*^9, 
   3.54194598804528*^9, {3.541946038347198*^9, 3.541946046709571*^9}, 
   3.542002210566113*^9, 3.542003117074551*^9, 3.54200378722929*^9, 
   3.542004258163628*^9, 3.542004441919438*^9, 3.542004599955748*^9, {
   3.542004650375339*^9, 3.542004679984592*^9}, 3.542005268344698*^9, 
   3.542005378749115*^9, 3.542016077738536*^9, {3.542458368102207*^9, 
   3.5424583944672832`*^9}, 3.542458525128294*^9, {3.54245857756279*^9, 
   3.542458668375346*^9}, {3.542458713581833*^9, 3.542458749269227*^9}, 
   3.542458817204043*^9, 3.5424588514239683`*^9, 3.5424589180695477`*^9, 
   3.542459056750497*^9, 3.542459101416952*^9, 3.542459414869546*^9, 
   3.5424594640828543`*^9, 3.5424595774075117`*^9, 3.542460080252501*^9, {
   3.5424602676212807`*^9, 3.5424603288756237`*^9}, {3.542460378875814*^9, 
   3.542460382633729*^9}, 3.542461439810902*^9, 3.542471994515518*^9, 
   3.542472287785638*^9, 3.5424755870369587`*^9, 3.5424756436092377`*^9, 
   3.542475700317525*^9, 3.542475897081188*^9, {3.542476042843156*^9, 
   3.542476065736722*^9}, 3.54247676090176*^9, 3.542476793882442*^9, {
   3.542476825776928*^9, 3.542476878764099*^9}, {3.542476929880746*^9, 
   3.542476959521865*^9}, 3.5424770064628057`*^9, 3.5424770422009983`*^9, 
   3.542477320760212*^9, {3.542477391197407*^9, 3.542477427141346*^9}, 
   3.542477875095582*^9, 3.542510452571542*^9, 3.5425110676150293`*^9, 
   3.543562152687889*^9, {3.5435644729882097`*^9, 3.543564497886059*^9}, {
   3.543564636891211*^9, 3.543564679744006*^9}, {3.543573737299659*^9, 
   3.543573757307667*^9}, 3.5435748775136003`*^9, {3.5435756191943617`*^9, 
   3.543575638802176*^9}, {3.54357582807406*^9, 3.543575852261279*^9}, {
   3.543641118941092*^9, 3.543641139646707*^9}, {3.543641221774456*^9, 
   3.543641252676614*^9}, {3.5436418278103724`*^9, 3.5436418502597647`*^9}, {
   3.5436434808321943`*^9, 3.543643505693367*^9}, {3.543644014602703*^9, 
   3.54364406601845*^9}, 3.543644117068633*^9, {3.543644169503365*^9, 
   3.543644242481669*^9}, {3.543646077435194*^9, 3.543646089279414*^9}, {
   3.5436463521663713`*^9, 3.5436463620694857`*^9}, {3.5436474257166033`*^9, 
   3.5436474364733562`*^9}, {3.543653404366679*^9, 3.543653414154376*^9}, {
   3.543653968237368*^9, 3.5436539775517483`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.485491864301392*^9, {3.485492194424671*^9, 3.485492203600923*^9}, 
   3.485492614623082*^9, 3.48549368095347*^9, 3.485501840207075*^9, 
   3.4855187490858583`*^9, 3.485601005478911*^9, 3.4856010728665648`*^9, 
   3.485601563509389*^9, 3.4856016057723627`*^9, 3.485602639964013*^9, {
   3.4856041412863092`*^9, 3.4856041433110437`*^9}, 3.4856055977144327`*^9, 
   3.4857577267252398`*^9, 3.485758790011026*^9, {3.4857588554186487`*^9, 
   3.485759027118742*^9}, 3.488022992996626*^9, 3.488023082461605*^9, 
   3.4880868114960003`*^9, 3.488086946662936*^9, 3.488088673112059*^9, {
   3.488089656730801*^9, 3.488089673051313*^9}, 3.488090564156822*^9, {
   3.488091743864738*^9, 3.488091764346541*^9}, 3.488094135430737*^9, 
   3.488094339766486*^9, 3.488094390338008*^9, 3.488094661984242*^9, 
   3.488095139631012*^9, {3.488095534102748*^9, 3.488095541795362*^9}, 
   3.488100679583063*^9, 3.4881052496521463`*^9, {3.4881053804700603`*^9, 
   3.460349610440978*^9}, 3.460349689838066*^9, {3.4603497291000977`*^9, 
   3.46034977971763*^9}, 3.46034981901026*^9, 3.460349997938003*^9, {
   3.460367074095797*^9, 3.4603671353705063`*^9}, 3.460369223165945*^9, 
   3.460369797222683*^9, 3.460373147764389*^9, 3.460376301780631*^9, 
   3.46037729980206*^9, 3.4603773842721167`*^9, 3.460379557889228*^9, {
   3.460381548675118*^9, 3.4603816340233803`*^9}, {3.4603816789323473`*^9, 
   3.460381683513525*^9}, 3.460382646284061*^9, 3.460383836969322*^9, 
   3.460384010185211*^9, 3.460384080617732*^9, 3.460384182551626*^9, 
   3.460384337552655*^9, 3.460384575951867*^9, 3.460385907006112*^9, 
   3.460386052598714*^9, 3.460386427804043*^9, 3.460387410692741*^9, 
   3.4603879584961348`*^9, 3.4603886743563633`*^9, 3.460389048396307*^9, 
   3.460389646672159*^9, 3.460389963065598*^9, {3.497955260848908*^9, 
   3.497955275689596*^9}, 3.497955404576795*^9, {3.497955439691234*^9, 
   3.4979554621044903`*^9}, 3.497955596137746*^9, {3.4979556707872877`*^9, 
   3.497955684127451*^9}, 3.49795580825077*^9, 3.497956297104539*^9, {
   3.497957000681266*^9, 3.497957002562714*^9}, {3.497957572661827*^9, 
   3.4979575899678097`*^9}, 3.49795772547722*^9, 3.497957761534357*^9, 
   3.497957796014789*^9, 3.497958526075027*^9, {3.497958577187643*^9, 
   3.497958593238682*^9}, 3.4982038605705557`*^9, 3.498203902660976*^9, {
   3.498204347690165*^9, 3.4982043589273977`*^9}, 3.498204392175687*^9, 
   3.4982044341144257`*^9, 3.498204622939752*^9, {3.5014870570382433`*^9, 
   3.501487074547287*^9}, {3.5014871389281797`*^9, 3.501487147355729*^9}, {
   3.501487227562582*^9, 3.501487248015787*^9}, {3.5014872920604067`*^9, 
   3.501487308863119*^9}, 3.501488106296698*^9, 3.501488143381166*^9, 
   3.5014882223947906`*^9, 3.501488254548698*^9, {3.501488286404793*^9, 
   3.501488306587175*^9}, 3.501488382903673*^9, 3.5014885298070602`*^9, {
   3.501488565420887*^9, 3.50148859236976*^9}, {3.501488644922762*^9, 
   3.501488822716926*^9}, 3.501488945575447*^9, 3.501489833778697*^9, 
   3.501490041113618*^9, 3.501490245350789*^9, 3.5014930887213984`*^9, 
   3.5014931857353163`*^9, 3.5014932564094067`*^9, 3.501493326979061*^9, 
   3.501493405617869*^9, {3.501493627459387*^9, 3.501493652510063*^9}, {
   3.501493710286697*^9, 3.50149373564848*^9}, 3.5014942547647047`*^9, 
   3.5015025741640177`*^9, {3.5015027207188168`*^9, 3.50150273648623*^9}, 
   3.501502802963146*^9, 3.501502990031888*^9, 3.5015031675418253`*^9, {
   3.501503234067651*^9, 3.5015032809652557`*^9}, {3.501503319691927*^9, 
   3.501503340790675*^9}, {3.501503394110121*^9, 3.501503423050543*^9}, 
   3.501503491308098*^9, 3.501503542246965*^9, {3.5015035724701633`*^9, 
   3.501503591835827*^9}, {3.5015036316679707`*^9, 3.460391460778592*^9}, 
   3.460391552512026*^9, {3.460391620874823*^9, 3.460391726111676*^9}, 
   3.460391766433282*^9, 3.460391805655349*^9, {3.460391899134183*^9, 
   3.460391904423318*^9}, 3.460392449011526*^9, 3.460392491911765*^9, 
   3.460392539303013*^9, 3.460392592164415*^9, 3.4603926545201817`*^9, 
   3.460392722850359*^9, 3.460392780968513*^9, 3.46039353471695*^9, 
   3.460393828875861*^9, 3.46039388509589*^9, 3.460393944763908*^9, 
   3.460394705901523*^9, 3.460394759957761*^9, 3.460394958351165*^9, 
   3.4603950842337523`*^9, 3.4603952392886963`*^9, 3.460395389654508*^9, 
   3.460425925164006*^9, {3.46042602305262*^9, 3.460426140870483*^9}, 
   3.4604263508711576`*^9, 3.460427504771038*^9, 3.460427544505268*^9, 
   3.4604283657349453`*^9, 3.46042840800635*^9, 3.460428788724392*^9, {
   3.460428833422472*^9, 3.460389722909161*^9}, {3.4603922278406076`*^9, 
   3.4603922427047367`*^9}, 3.460392273890826*^9, 3.4603956506989603`*^9, {
   3.4606144524182587`*^9, 3.4602566908889008`*^9}, 3.4602570051447153`*^9, 
   3.503228443860219*^9, {3.5032285405059853`*^9, 3.503228548603945*^9}, {
   3.503228705371221*^9, 3.503228709267578*^9}, {3.503228774142935*^9, 
   3.5032287957631693`*^9}, {3.503299081024961*^9, 3.503299085356143*^9}, {
   3.50331561918917*^9, 3.460358821395665*^9}, 3.504000653220525*^9, {
   3.504000801904839*^9, 3.504000905340579*^9}, {3.504000958667583*^9, 
   3.5040009844387217`*^9}, {3.504001071312477*^9, 3.504001075441142*^9}, {
   3.504001269919468*^9, 3.504001274665419*^9}, 3.504001608823883*^9, 
   3.504002422596731*^9, 3.5040027233811693`*^9, 3.504002961724537*^9, {
   3.504003230741403*^9, 3.5040032361572113`*^9}, 3.504005138958823*^9, 
   3.517554265697289*^9, {3.517554337500514*^9, 3.517554351987936*^9}, {
   3.5175545231040697`*^9, 3.51755453989081*^9}, 3.517554705327265*^9, 
   3.517555341452415*^9, 3.5175683552388153`*^9, 3.517577421041807*^9, 
   3.517582231926661*^9, 3.51763524151375*^9, 3.517635556595634*^9, {
   3.5176364674651413`*^9, 3.517636493291709*^9}, 3.5176373324100533`*^9, 
   3.517639757514833*^9, 3.517640668250793*^9, 3.517640707908297*^9, {
   3.5176409047988*^9, 3.517640919785956*^9}, {3.517640953017754*^9, 
   3.4603934332944098`*^9}, 3.460393463908436*^9, 3.4603948297579393`*^9, {
   3.460395927797202*^9, 3.4603541284929256`*^9}, 3.4603556071558533`*^9, {
   3.4603679375298777`*^9, 3.460367953597089*^9}, 3.460396181975419*^9, 
   3.460439832589082*^9, 3.460453163716153*^9, 3.4604535451489058`*^9, {
   3.460456020938459*^9, 3.4604560444289217`*^9}, 3.460460228835271*^9, 
   3.4604603825066633`*^9, 3.4604719390896063`*^9, 3.460472301840584*^9, 
   3.4604755278961143`*^9, 3.4604784481075974`*^9, 3.460478527123383*^9, 
   3.460478873828088*^9, 3.460484028816951*^9, 3.460484060586214*^9, 
   3.460484114212631*^9, 3.4604845031689663`*^9, 3.4604846384876213`*^9, 
   3.460484746043729*^9, 3.4604849174940977`*^9, 3.4607151708050137`*^9, 
   3.460715257511959*^9, 3.46071546012398*^9, 3.460716811480632*^9, 
   3.460718862658382*^9, {3.460731510358283*^9, 3.460731537378489*^9}, 
   3.460731597992169*^9, {3.460731698375935*^9, 3.460393907924903*^9}, {
   3.460394070070269*^9, 3.460338444545535*^9}, 3.460338492438815*^9, 
   3.4603402915831003`*^9, 3.460340366868927*^9, 3.460340468299581*^9, 
   3.460352942615267*^9, 3.460353032121888*^9, 3.518956321045685*^9, 
   3.518956717427435*^9, 3.519020032031831*^9, 3.5190214013930492`*^9, 
   3.519022606810871*^9, 3.5190255620252*^9, 3.519032033630352*^9, 
   3.519036346937253*^9, 3.51903671225138*^9, 3.519037578841022*^9, 
   3.5190393531768*^9, 3.5191035561052237`*^9, 3.5191036086897993`*^9, 
   3.519104540989696*^9, 3.519105651285398*^9, 3.519106292148252*^9, 
   3.5191148988689623`*^9, 3.5392450405792847`*^9, 3.5392892268293467`*^9, 
   3.539289459617178*^9, 3.539337478794712*^9, {3.539378711871846*^9, 
   3.53937872115454*^9}, 3.53937878339888*^9, 3.539379407851843*^9, {
   3.5393797801219797`*^9, 3.539379791578126*^9}, {3.539394712254738*^9, 
   3.539394722506558*^9}, {3.539394882405622*^9, 3.5393949044989023`*^9}, {
   3.5396134150247383`*^9, 3.5396134227912827`*^9}, {3.53962532115784*^9, 
   3.539625346759416*^9}, 3.539626166086252*^9, {3.539649650224518*^9, 
   3.539649670297758*^9}, 3.5415170152143173`*^9, 3.541517103918021*^9, 
   3.5415651699913607`*^9, {3.541828397566525*^9, 3.5418284241223297`*^9}, {
   3.541834923396179*^9, 3.541834936226203*^9}, 3.541870783369664*^9, {
   3.5419112800415907`*^9, 3.541911308570372*^9}, 3.541911550891054*^9, {
   3.5419124756525908`*^9, 3.541912485338724*^9}, {3.541912604907995*^9, 
   3.5419126145768843`*^9}, 3.541916159338565*^9, 3.541916189584506*^9, 
   3.5419162538078547`*^9, 3.5419164430709333`*^9, {3.541916760708034*^9, 
   3.541916797254305*^9}, 3.5419169366125097`*^9, 3.541918554252759*^9, 
   3.5419186093817863`*^9, {3.541919413658525*^9, 3.541919441534745*^9}, {
   3.541920770898493*^9, 3.5419207745868692`*^9}, {3.5419211207558317`*^9, 
   3.541921123758713*^9}, {3.541921227345232*^9, 3.541921229999036*^9}, {
   3.5419214455653133`*^9, 3.5419214478856277`*^9}, {3.5419215315032063`*^9, 
   3.541921534668083*^9}, {3.54192189413622*^9, 3.541921896541644*^9}, {
   3.541922063320443*^9, 3.541922066092808*^9}, {3.541922369962749*^9, 
   3.5419223733019247`*^9}, {3.541927754322867*^9, 3.541927777722975*^9}, {
   3.5419303037076817`*^9, 3.541930331598156*^9}, {3.541930797993437*^9, 
   3.541930826814579*^9}, 3.5419430801305637`*^9, 3.5419431206281567`*^9, 
   3.5419431835005903`*^9, 3.541944507331827*^9, {3.541944565030623*^9, 
   3.541944685358245*^9}, {3.541944757675283*^9, 3.541944782420961*^9}, {
   3.541944815973489*^9, 3.54194491532349*^9}, 3.541944949458642*^9, 
   3.5419449853833637`*^9, 3.541945032058445*^9, {3.541945063439651*^9, 
   3.541945083914802*^9}, {3.541945219370872*^9, 3.541945245156946*^9}, 
   3.5419452754351673`*^9, {3.541945609942567*^9, 3.541945684076754*^9}, {
   3.541945727497978*^9, 3.541945742594751*^9}, 3.541945797039255*^9, 
   3.54194598804528*^9, {3.541946038347198*^9, 3.541946046709571*^9}, 
   3.542002210566113*^9, 3.542003117074551*^9, 3.54200378722929*^9, 
   3.542004258163628*^9, 3.542004441919438*^9, 3.542004599955748*^9, {
   3.542004650375339*^9, 3.542004679984592*^9}, 3.542005268344698*^9, 
   3.542005378749115*^9, 3.542016077738536*^9, {3.542458368102207*^9, 
   3.5424583944672832`*^9}, 3.542458525128294*^9, {3.54245857756279*^9, 
   3.542458668375346*^9}, {3.542458713581833*^9, 3.542458749269227*^9}, 
   3.542458817204043*^9, 3.5424588514239683`*^9, 3.5424589180695477`*^9, 
   3.542459056750497*^9, 3.542459101416952*^9, 3.542459414869546*^9, 
   3.5424594640828543`*^9, 3.5424595774075117`*^9, 3.542460080252501*^9, {
   3.5424602676212807`*^9, 3.5424603288756237`*^9}, {3.542460378875814*^9, 
   3.542460382633729*^9}, 3.542461439810902*^9, 3.542471994515518*^9, 
   3.542472287785638*^9, 3.5424755870369587`*^9, 3.5424756436092377`*^9, 
   3.542475700317525*^9, 3.542475897081188*^9, {3.542476042843156*^9, 
   3.542476065736722*^9}, 3.54247676090176*^9, 3.542476793882442*^9, {
   3.542476825776928*^9, 3.542476878764099*^9}, {3.542476929880746*^9, 
   3.542476959521865*^9}, 3.5424770064628057`*^9, 3.5424770422009983`*^9, 
   3.542477320760212*^9, {3.542477391197407*^9, 3.542477427141346*^9}, 
   3.542477875095582*^9, 3.542510452571542*^9, 3.5425110676150293`*^9, 
   3.543562152687889*^9, {3.5435644729882097`*^9, 3.543564497886059*^9}, {
   3.543564636891211*^9, 3.543564679744006*^9}, {3.543573737299659*^9, 
   3.543573757307667*^9}, 3.5435748775136003`*^9, {3.5435756191943617`*^9, 
   3.543575638802176*^9}, {3.54357582807406*^9, 3.543575852261279*^9}, {
   3.543641118941092*^9, 3.543641139646707*^9}, {3.543641221774456*^9, 
   3.543641252676614*^9}, {3.5436418278103724`*^9, 3.5436418502597647`*^9}, {
   3.5436434808321943`*^9, 3.543643505693367*^9}, {3.543644014602703*^9, 
   3.54364406601845*^9}, 3.543644117068633*^9, {3.543644169503365*^9, 
   3.543644242481669*^9}, {3.543646077435194*^9, 3.543646089279414*^9}, {
   3.5436463521663713`*^9, 3.5436463620694857`*^9}, {3.5436474257166033`*^9, 
   3.5436474364733562`*^9}, {3.543653404366679*^9, 3.543653414154376*^9}, {
   3.543653968237368*^9, 3.543653977555038*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", "\"\<Setup indexing\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.4241732289624367`*^9, 3.424173231200769*^9}}],

Cell[BoxData["\<\"Setup indexing\"\>"], "Print",
 CellChangeTimes->{
  3.48549186444991*^9, {3.485492194596924*^9, 3.485492203751793*^9}, 
   3.4854926147737923`*^9, 3.485493681108342*^9, 3.485501840376239*^9, 
   3.4855187492266397`*^9, 3.4856010056889563`*^9, 3.485601073043092*^9, 
   3.485601563666898*^9, 3.485601605947206*^9, 3.4856026401181498`*^9, {
   3.485604141470397*^9, 3.48560414348111*^9}, 3.485605597942691*^9, 
   3.485757726909301*^9, 3.485758790164316*^9, {3.485758855586247*^9, 
   3.485759027273329*^9}, 3.488022993173729*^9, 3.48802308264497*^9, 
   3.488086811645616*^9, 3.488086946849565*^9, 3.488088673264732*^9, {
   3.4880896569006968`*^9, 3.488089673220818*^9}, 3.488090564333641*^9, {
   3.488091744047267*^9, 3.488091764510744*^9}, 3.488094135613678*^9, 
   3.488094339934761*^9, 3.488094390510603*^9, 3.488094662168508*^9, 
   3.488095139814911*^9, {3.488095534285245*^9, 3.4880955419790773`*^9}, 
   3.488100679737061*^9, 3.488105249836144*^9, {3.4881053806238213`*^9, 
   3.460349610734213*^9}, 3.460349690024995*^9, {3.460349729261188*^9, 
   3.4603497798940687`*^9}, 3.46034981916617*^9, 3.4603499981259527`*^9, {
   3.4603670742734003`*^9, 3.460367135548759*^9}, 3.460369223334889*^9, 
   3.460369797383963*^9, 3.460373147937584*^9, 3.460376301933537*^9, 
   3.460377299955887*^9, 3.460377384457337*^9, 3.4603795580641737`*^9, {
   3.460381548859643*^9, 3.4603816342141237`*^9}, {3.460381679104022*^9, 
   3.460381683664069*^9}, 3.4603826464562063`*^9, 3.460383837140031*^9, 
   3.4603840103723307`*^9, 3.460384080771638*^9, 3.460384182708193*^9, 
   3.460384337740016*^9, 3.4603845760898333`*^9, 3.460385907194635*^9, 
   3.460386052787087*^9, 3.460386427955613*^9, 3.4603874108660727`*^9, 
   3.460387958669462*^9, 3.46038867452934*^9, 3.460389048568261*^9, 
   3.460389646825343*^9, 3.460389963286134*^9, {3.497955261022197*^9, 
   3.497955275872984*^9}, 3.497955404758271*^9, {3.49795543989392*^9, 
   3.497955462325844*^9}, 3.497955596507049*^9, {3.497955670990365*^9, 
   3.497955684329842*^9}, 3.497955808475504*^9, 3.497956297278043*^9, {
   3.4979570008684387`*^9, 3.497957002749538*^9}, {3.497957572848906*^9, 
   3.49795759015147*^9}, 3.497957725682578*^9, 3.497957761717013*^9, 
   3.49795779623995*^9, 3.497958526264824*^9, {3.497958577399723*^9, 
   3.497958593418519*^9}, 3.498203860735721*^9, 3.4982039028815403`*^9, {
   3.4982043478580112`*^9, 3.498204359117839*^9}, 3.498204392361959*^9, 
   3.498204434300363*^9, 3.49820462310849*^9, {3.50148705721662*^9, 
   3.501487074733334*^9}, {3.501487139109315*^9, 3.501487147522293*^9}, {
   3.501487227734466*^9, 3.501487248197352*^9}, {3.5014872922296886`*^9, 
   3.501487309043365*^9}, 3.501488106476782*^9, 3.5014881435934277`*^9, 
   3.5014882225747423`*^9, 3.501488254729999*^9, {3.501488286585175*^9, 
   3.501488306768462*^9}, 3.5014883830836763`*^9, 3.5014885299746637`*^9, {
   3.5014885655950603`*^9, 3.501488592551371*^9}, {3.501488645103723*^9, 
   3.501488822897668*^9}, 3.501488945742882*^9, 3.501489833946011*^9, 
   3.501490041293325*^9, 3.501490245536353*^9, 3.501493088885075*^9, 
   3.50149318591581*^9, 3.501493256588037*^9, 3.501493327158307*^9, 
   3.501493405777059*^9, {3.501493627627602*^9, 3.501493652706259*^9}, {
   3.5014937104721003`*^9, 3.501493735802681*^9}, 3.5014942549443502`*^9, 
   3.50150257438236*^9, {3.5015027209089737`*^9, 3.5015027367071*^9}, 
   3.501502803151804*^9, 3.5015029902217913`*^9, 3.501503167731443*^9, {
   3.5015032342689657`*^9, 3.501503281127874*^9}, {3.50150331987696*^9, 
   3.501503340992333*^9}, {3.501503394312825*^9, 3.501503423259095*^9}, 
   3.5015034914978228`*^9, 3.501503542448709*^9, {3.50150357267264*^9, 
   3.5015035920225897`*^9}, {3.501503631875483*^9, 3.460391460970986*^9}, 
   3.460391552720172*^9, {3.460391621078779*^9, 3.460391726287615*^9}, 
   3.4603917666105967`*^9, 3.460391805827429*^9, {3.460391899287566*^9, 
   3.460391904595593*^9}, 3.460392449172194*^9, 3.460392492053596*^9, 
   3.4603925394581137`*^9, 3.460392592300302*^9, 3.460392654660954*^9, 
   3.46039272302168*^9, 3.460392781124544*^9, 3.460393534932046*^9, 
   3.46039382910993*^9, 3.460393885386883*^9, 3.460393945012211*^9, 
   3.460394706107294*^9, 3.460394760180485*^9, 3.460394958514222*^9, 
   3.4603950844079227`*^9, 3.460395239446701*^9, 3.4603953898609133`*^9, 
   3.460425925306163*^9, {3.4604260231934433`*^9, 3.460426141038088*^9}, 
   3.460426351117642*^9, 3.4604275049216633`*^9, 3.4604275446618233`*^9, 
   3.4604283658997307`*^9, 3.460428408180849*^9, 3.460428788971787*^9, {
   3.460428833682366*^9, 3.460389723071286*^9}, {3.460392228157208*^9, 
   3.460392242957851*^9}, 3.4603922742469397`*^9, 3.46039565111409*^9, {
   3.46061445290495*^9, 3.4602566911272917`*^9}, 3.460257005347209*^9, 
   3.503228443990052*^9, {3.503228540639957*^9, 3.503228548754016*^9}, {
   3.5032287055362997`*^9, 3.503228709383216*^9}, {3.503228774521452*^9, 
   3.50322879646906*^9}, {3.503299081373168*^9, 3.503299085720685*^9}, {
   3.503315619476438*^9, 3.460358821579195*^9}, 3.504000653397421*^9, {
   3.5040008020668697`*^9, 3.504000905509727*^9}, {3.504000958842523*^9, 
   3.5040009847395372`*^9}, {3.504001071509983*^9, 3.5040010756085463`*^9}, {
   3.504001270185782*^9, 3.504001274951264*^9}, 3.5040016089897203`*^9, 
   3.504002422823588*^9, 3.5040027235488358`*^9, 3.504002962135096*^9, {
   3.504003231015675*^9, 3.504003236326325*^9}, 3.504005140076313*^9, 
   3.517554540455584*^9, 3.5175547058431377`*^9, 3.517555341541911*^9, 
   3.517568355275724*^9, 3.517577421099505*^9, 3.517582231973879*^9, 
   3.5176352415720377`*^9, 3.5176355566619787`*^9, {3.517636469134677*^9, 
   3.5176364933353853`*^9}, 3.517637332463048*^9, 3.517639757645129*^9, 
   3.5176406683207693`*^9, 3.517640708001689*^9, {3.517640904876151*^9, 
   3.517640919866222*^9}, {3.517640953081418*^9, 3.4603934333728743`*^9}, 
   3.460393463961011*^9, 3.460394829811267*^9, {3.460395927893836*^9, 
   3.46035412854456*^9}, 3.460355607212244*^9, {3.4603679376121597`*^9, 
   3.460367953689075*^9}, 3.460396182031837*^9, 3.4604398326483297`*^9, 
   3.4604531637767057`*^9, 3.460453545188818*^9, {3.460456020985993*^9, 
   3.460456044494657*^9}, 3.460460228978368*^9, 3.4604603825514936`*^9, 
   3.460471939129608*^9, 3.4604723019280376`*^9, 3.460475528018701*^9, 
   3.460478448222014*^9, 3.460478527212001*^9, 3.4604788739122963`*^9, 
   3.4604840288649473`*^9, 3.460484060635577*^9, 3.4604841142653103`*^9, 
   3.4604845032243433`*^9, 3.460484638527903*^9, 3.460484746089799*^9, 
   3.460484917542013*^9, 3.460715170851823*^9, 3.4607152575590563`*^9, 
   3.460715460168688*^9, 3.4607168115240507`*^9, 3.460718862702586*^9, {
   3.46073151041184*^9, 3.4607315374393597`*^9}, 3.4607315980376387`*^9, {
   3.460731698418704*^9, 3.460393907967842*^9}, {3.4603940701163816`*^9, 
   3.46033844459739*^9}, 3.4603384924844847`*^9, 3.460340291715214*^9, 
   3.460340366915494*^9, 3.460340468344779*^9, 3.4603529426657667`*^9, 
   3.460353032185107*^9, 3.518956321091804*^9, 3.51895671752492*^9, 
   3.519020032092123*^9, 3.51902140143934*^9, 3.519022606865237*^9, 
   3.519025562084976*^9, 3.519032033712627*^9, 3.519036346993087*^9, 
   3.519036712375546*^9, 3.5190375788972673`*^9, 3.519039353220909*^9, 
   3.519103556150572*^9, 3.51910360873593*^9, 3.519104541079023*^9, 
   3.5191056513515*^9, 3.5191062922233543`*^9, 3.519114898933902*^9, 
   3.539245040615582*^9, 3.5392892268606863`*^9, 3.539289459652264*^9, 
   3.5393374788331947`*^9, {3.539378711908342*^9, 3.539378721191929*^9}, 
   3.539378783436545*^9, 3.53937940788862*^9, {3.539379780158864*^9, 
   3.539379791614255*^9}, {3.5393947122904797`*^9, 3.539394722541338*^9}, {
   3.539394882441496*^9, 3.5393949045345383`*^9}, {3.539613415082837*^9, 
   3.539613422840911*^9}, {3.5396253212121267`*^9, 3.5396253467989264`*^9}, 
   3.539626166319779*^9, {3.5396496502804956`*^9, 3.539649670350758*^9}, 
   3.54151701524925*^9, 3.5415171039536552`*^9, 3.5415651700326357`*^9, {
   3.541828397593423*^9, 3.541828424181016*^9}, {3.541834923446064*^9, 
   3.541834936278634*^9}, 3.541870783397767*^9, {3.541911281494725*^9, 
   3.541911308604541*^9}, 3.5419115509256487`*^9, {3.541912475690289*^9, 
   3.541912485374765*^9}, {3.54191260494156*^9, 3.541912614629837*^9}, 
   3.54191615937574*^9, 3.541916189620654*^9, 3.541916253870399*^9, 
   3.541916443134544*^9, {3.541916760744089*^9, 3.541916797306328*^9}, 
   3.541916936721513*^9, 3.5419185542892838`*^9, 3.5419186094339542`*^9, {
   3.5419194136946917`*^9, 3.541919441576206*^9}, {3.5419207709991293`*^9, 
   3.541920774652252*^9}, {3.541921120792405*^9, 3.5419211237945642`*^9}, {
   3.541921227428521*^9, 3.541921230051652*^9}, {3.541921445606268*^9, 
   3.5419214479212427`*^9}, {3.541921531544963*^9, 3.541921534721387*^9}, {
   3.5419218941733017`*^9, 3.541921896578391*^9}, {3.541922063362163*^9, 
   3.5419220661334352`*^9}, {3.54192237001364*^9, 3.541922373352214*^9}, {
   3.541927754358391*^9, 3.541927777775242*^9}, {3.5419303037423763`*^9, 
   3.5419303316466084`*^9}, {3.541930798045892*^9, 3.541930826851398*^9}, 
   3.541943080164021*^9, 3.541943120661324*^9, 3.5419431835376797`*^9, 
   3.541944507369646*^9, {3.541944565069969*^9, 3.5419446853982077`*^9}, {
   3.541944757710232*^9, 3.541944782462607*^9}, {3.541944816011373*^9, 
   3.541944915358026*^9}, 3.541944949505271*^9, 3.541944985420869*^9, 
   3.541945032100236*^9, {3.541945063492846*^9, 3.5419450839656153`*^9}, {
   3.5419452194084187`*^9, 3.541945245197864*^9}, 3.541945275486257*^9, {
   3.54194560997915*^9, 3.541945684122445*^9}, {3.541945727541198*^9, 
   3.5419457426365833`*^9}, 3.541945797074259*^9, 3.541945988082024*^9, {
   3.5419460383954687`*^9, 3.5419460467487*^9}, 3.542002210602557*^9, 
   3.542003117111212*^9, 3.5420037872674503`*^9, 3.542004258202499*^9, 
   3.542004441955145*^9, 3.542004599994484*^9, {3.542004650412306*^9, 
   3.542004680018811*^9}, 3.542005268380252*^9, 3.5420053787951603`*^9, 
   3.542016077790004*^9, {3.5424583681431313`*^9, 3.5424583945050383`*^9}, 
   3.5424585251945267`*^9, {3.542458577609514*^9, 3.5424586684312897`*^9}, {
   3.5424587136523*^9, 3.542458749322563*^9}, 3.542458817255862*^9, 
   3.542458851473095*^9, 3.54245891812383*^9, 3.542459056815527*^9, 
   3.542459101467355*^9, 3.54245941492446*^9, 3.542459464137498*^9, 
   3.54245957747593*^9, 3.542460080303486*^9, {3.54246026765698*^9, 
   3.5424603289334106`*^9}, {3.542460378927476*^9, 3.5424603826844997`*^9}, 
   3.54246143985962*^9, 3.542471994549802*^9, 3.5424722878232307`*^9, 
   3.5424755870709*^9, 3.542475643644227*^9, 3.5424757003517036`*^9, 
   3.5424758971132917`*^9, {3.542476042885737*^9, 3.542476065775256*^9}, 
   3.542476760937495*^9, 3.5424767939178867`*^9, {3.542476825812793*^9, 
   3.542476878799518*^9}, {3.542476929916651*^9, 3.542476959557312*^9}, 
   3.54247700649868*^9, 3.5424770422534523`*^9, 3.54247732079648*^9, {
   3.54247739123536*^9, 3.542477427220624*^9}, 3.542477875147976*^9, 
   3.542510452628099*^9, 3.542511067681423*^9, 3.543562152729919*^9, {
   3.54356447303367*^9, 3.543564497922526*^9}, {3.543564636928184*^9, 
   3.543564679779203*^9}, {3.5435737373355293`*^9, 3.543573757358801*^9}, 
   3.5435748775466757`*^9, {3.543575619228121*^9, 3.54357563885*^9}, {
   3.543575828150374*^9, 3.543575852437121*^9}, {3.543641118976651*^9, 
   3.543641139684799*^9}, {3.5436412218103857`*^9, 3.543641252719843*^9}, {
   3.5436418281035624`*^9, 3.543641850429356*^9}, {3.543643480885509*^9, 
   3.543643505729144*^9}, {3.543644014638628*^9, 3.5436440660556307`*^9}, 
   3.543644117106835*^9, {3.5436441695403957`*^9, 3.5436442425158978`*^9}, {
   3.543646077474566*^9, 3.543646089331421*^9}, {3.5436463523052893`*^9, 
   3.543646362294654*^9}, {3.543647425782648*^9, 3.5436474366651297`*^9}, {
   3.5436534044022207`*^9, 3.54365341420513*^9}, {3.543653968304658*^9, 
   3.543653977589966*^9}}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vecpos", "=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"index", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"vecmask", "[", 
          RowBox[{"[", 
           RowBox[{"var", ",", "ii", ",", "jj"}], "]"}], "]"}], "\[Equal]", 
         "1"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"vecmask", "[", 
            RowBox[{"[", 
             RowBox[{"var", ",", "ii", ",", "jj"}], "]"}], "]"}], "=", 
           "vecpos"}], ";", 
          RowBox[{"vecpos", "+=", "1"}], ";", "\[IndentingNewLine]", 
          RowBox[{"AppendTo", "[", 
           RowBox[{"index", ",", 
            RowBox[{"{", 
             RowBox[{"var", ",", "ii", ",", "jj"}], "}"}]}], "]"}], ";"}], 
         "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"vecmask", "[", 
           RowBox[{"[", 
            RowBox[{"var", ",", "ii", ",", "jj"}], "]"}], "]"}], "=", 
          RowBox[{"-", "1"}]}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"var", ",", "1", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", "1", ",", "NR"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"jj", ",", "1", ",", "NA"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vecsize", "=", "vecpos"}], ";"}]}], "Input",
 CellChangeTimes->{{3.424173246682961*^9, 3.424173388972734*^9}, {
  3.424174868655298*^9, 3.424174876214829*^9}, {3.42831944485699*^9, 
  3.42831945012503*^9}, {3.517554630104658*^9, 3.517554701601007*^9}}],

Cell[CellGroupData[{

Cell[BoxData["vecsize"], "Input",
 CellChangeTimes->{{3.424174990077484*^9, 3.424174992364398*^9}}],

Cell[BoxData["1900"], "Output",
 CellChangeTimes->{
  3.485491864499879*^9, {3.485492194659657*^9, 3.485492203802053*^9}, 
   3.485492614823539*^9, 3.4854936811705027`*^9, 3.485501840422061*^9, 
   3.4855187492729*^9, 3.485601005754499*^9, 3.4856010731089087`*^9, 
   3.485601563729447*^9, 3.4856016060086403`*^9, 3.485602640184093*^9, {
   3.485604141570228*^9, 3.4856041435480623`*^9}, 3.485605598037871*^9, 
   3.4857577269777107`*^9, 3.485758790227397*^9, {3.48575885565315*^9, 
   3.485759027336043*^9}, 3.488022993239367*^9, 3.48802308271222*^9, 
   3.488086811696905*^9, 3.488086946911653*^9, 3.4880886733272552`*^9, {
   3.488089656963088*^9, 3.488089673284503*^9}, 3.488090564400703*^9, {
   3.488091744113245*^9, 3.488091764579571*^9}, 3.488094135680079*^9, 
   3.488094340000927*^9, 3.48809439057285*^9, 3.4880946622340527`*^9, 
   3.488095139882264*^9, {3.488095534351461*^9, 3.488095542044449*^9}, 
   3.48810067978903*^9, 3.488105249915885*^9, {3.488105380686635*^9, 
   3.460349610800487*^9}, 3.460349690091467*^9, {3.460349729328854*^9, 
   3.460349779961299*^9}, 3.460349819209786*^9, 3.460349998191186*^9, {
   3.460367074339834*^9, 3.460367135616495*^9}, 3.460369223377343*^9, 
   3.460369797448278*^9, 3.460373148119031*^9, 3.460376301999527*^9, 
   3.460377300003271*^9, 3.4603773845248947`*^9, 3.460379558128873*^9, {
   3.4603815489460087`*^9, 3.46038163427836*^9}, {3.46038167917103*^9, 
   3.460381683713455*^9}, 3.460382646519182*^9, 3.46038383720644*^9, 
   3.460384010438901*^9, 3.460384080838688*^9, 3.460384182774126*^9, 
   3.4603843378075314`*^9, 3.460384576143118*^9, 3.460385907260777*^9, 
   3.460386052855343*^9, 3.460386428009042*^9, 3.4603874109295387`*^9, 
   3.4603879587338552`*^9, 3.460388674594417*^9, 3.460389048633237*^9, 
   3.4603896468919077`*^9, 3.460389963352913*^9, {3.497955261084875*^9, 
   3.497955275938571*^9}, 3.497955404824863*^9, {3.497955439972863*^9, 
   3.4979554624026327`*^9}, 3.4979555965861893`*^9, {3.497955671070225*^9, 
   3.4979556844075317`*^9}, 3.497955808548027*^9, 3.497956297340969*^9, {
   3.497957000934719*^9, 3.4979570028150167`*^9}, {3.497957572927402*^9, 
   3.4979575902169123`*^9}, 3.497957725759966*^9, 3.497957761782693*^9, 
   3.497957796315083*^9, 3.4979585263277884`*^9, {3.4979585774663486`*^9, 
   3.4979585934857616`*^9}, 3.498203860786607*^9, 3.498203902929991*^9, {
   3.49820434792102*^9, 3.498204359177663*^9}, 3.498204392424384*^9, 
   3.498204434366929*^9, 3.498204623171793*^9, {3.50148705728255*^9, 
   3.501487074799033*^9}, {3.501487139175457*^9, 3.50148714758506*^9}, {
   3.50148722779812*^9, 3.501487248264027*^9}, {3.501487292291771*^9, 
   3.501487309110154*^9}, 3.501488106543702*^9, 3.5014881436445704`*^9, 
   3.501488222640769*^9, 3.50148825479666*^9, {3.501488286651271*^9, 
   3.50148830683492*^9}, 3.501488383150793*^9, 3.501488530037619*^9, {
   3.501488565657015*^9, 3.501488592618739*^9}, {3.501488645170162*^9, 
   3.501488822964006*^9}, 3.501488945805892*^9, 3.5014898340091047`*^9, 
   3.501490041360859*^9, 3.5014902455975246`*^9, 3.501493088951889*^9, 
   3.501493185982728*^9, 3.501493256670595*^9, 3.501493327225874*^9, 
   3.5014934058387737`*^9, {3.501493627677985*^9, 3.50149365277239*^9}, {
   3.501493710539455*^9, 3.5014937358657217`*^9}, 3.501494255011202*^9, 
   3.501502574462784*^9, {3.501502720984528*^9, 3.5015027367868433`*^9}, 
   3.50150280321093*^9, 3.501502990297853*^9, 3.501503167808969*^9, {
   3.501503234366169*^9, 3.501503281179495*^9}, {3.501503319958014*^9, 
   3.5015033410556297`*^9}, {3.50150339439253*^9, 3.501503423350531*^9}, 
   3.5015034915737743`*^9, 3.501503542529114*^9, {3.5015035727528477`*^9, 
   3.5015035921024427`*^9}, {3.501503631950811*^9, 3.460391461059949*^9}, 
   3.4603915528103647`*^9, {3.460391621121441*^9, 3.4603917263463097`*^9}, 
   3.460391766684615*^9, 3.460391805889*^9, {3.4603918993338327`*^9, 
   3.4603919046565657`*^9}, 3.460392449217477*^9, 3.4603924921158037`*^9, 
   3.460392539502195*^9, 3.460392592368026*^9, 3.460392654723373*^9, 
   3.460392723068843*^9, 3.460392781186492*^9, 3.4603935349983587`*^9, 
   3.460393829177154*^9, 3.460393885481565*^9, 3.460393945078885*^9, 
   3.4603947061838093`*^9, 3.4603947602474403`*^9, 3.460394958559992*^9, 
   3.460395084475357*^9, 3.460395239497776*^9, 3.4603953899117727`*^9, 
   3.460425925368684*^9, {3.460426023256579*^9, 3.460426141102438*^9}, 
   3.4604263511829367`*^9, 3.4604275049687777`*^9, 3.4604275447282763`*^9, 
   3.460428365948271*^9, 3.460428408246579*^9, 3.460428789101941*^9, {
   3.460428833810162*^9, 3.460389723114533*^9}, {3.460392228219595*^9, 
   3.4603922430226593`*^9}, 3.4603922744316063`*^9, 3.460395651710585*^9, {
   3.460614453380598*^9, 3.460256691193602*^9}, 3.4602570053901367`*^9, 
   3.503228444039742*^9, {3.5032285406922493`*^9, 3.503228548804441*^9}, {
   3.503228705602944*^9, 3.503228709433791*^9}, {3.503228774639256*^9, 
   3.503228796890299*^9}, {3.503299082457919*^9, 3.503299086022812*^9}, {
   3.503315619570413*^9, 3.460358821642325*^9}, 3.504000653468182*^9, {
   3.5040008021309233`*^9, 3.504000905568285*^9}, {3.504000958909286*^9, 
   3.5040009848061333`*^9}, {3.50400107157432*^9, 3.504001075658141*^9}, {
   3.5040012702681293`*^9, 3.504001275028758*^9}, 3.504001609056674*^9, 
   3.5040024228910227`*^9, 3.50400272360896*^9, 3.50400296229618*^9, {
   3.504003231177822*^9, 3.50400323639686*^9}, 3.504005140936699*^9, 
   3.517554547864876*^9, {3.517554677434679*^9, 3.517554707142516*^9}, 
   3.5175553416343727`*^9, 3.517568355355501*^9, 3.5175774211741877`*^9, 
   3.517582232673287*^9, 3.517635241645693*^9, 3.517635556940659*^9, {
   3.517636471466091*^9, 3.517636493412558*^9}, 3.517637332543367*^9, 
   3.5176397582318363`*^9, 3.517640669143568*^9, 3.5176407268259163`*^9, {
   3.517640907139456*^9, 3.517640922754386*^9}, {3.517640955962098*^9, 
   3.460393433439617*^9}, 3.460393464026575*^9, 3.4603948298816423`*^9, {
   3.4603959280152617`*^9, 3.4603541286077967`*^9}, 3.460355607278473*^9, {
   3.460367939085072*^9, 3.4603679600926847`*^9}, 3.4603961821353827`*^9, 
   3.4604398327143497`*^9, 3.46045316389764*^9, 3.4604535452546673`*^9, {
   3.460456021051869*^9, 3.460456044580763*^9}, 3.4604602290494204`*^9, 
   3.460460382615521*^9, 3.46047193919445*^9, 3.460472302038213*^9, 
   3.4604755281293907`*^9, 3.460478448332489*^9, 3.46047852732279*^9, 
   3.460478874022287*^9, 3.460484028929134*^9, 3.460484060698938*^9, 
   3.460484114331842*^9, 3.4604845032908707`*^9, 3.460484638593625*^9, 
   3.46048474615514*^9, 3.460484917606554*^9, 3.460715170975029*^9, 
   3.460715257622995*^9, 3.460715460233697*^9, 3.460716811591667*^9, 
   3.4607188627444067`*^9, {3.460731510461267*^9, 3.460731537580867*^9}, 
   3.4607315981039677`*^9, {3.4607316985520897`*^9, 3.460393908062264*^9}, {
   3.4603940702674417`*^9, 3.460338444661536*^9}, 3.4603384925309887`*^9, 
   3.460340291751153*^9, 3.460340366964736*^9, 3.460340468485935*^9, 
   3.460352942723748*^9, 3.460353032989044*^9, 3.518956321748373*^9, 
   3.518956720662437*^9, 3.519020033538562*^9, 3.519021401645186*^9, 
   3.519022607523741*^9, 3.519025564940188*^9, 3.5190320344892397`*^9, 
   3.519036348383449*^9, 3.519036712813787*^9, 3.5190375817363234`*^9, 
   3.5190393534324303`*^9, 3.5191035563557863`*^9, 3.519103610943158*^9, 
   3.519104542993074*^9, 3.519105652817423*^9, 3.519106292919355*^9, 
   3.5191149004403667`*^9, 3.539245040678595*^9, 3.539289226922536*^9, 
   3.5392894597174883`*^9, 3.539337478895033*^9, {3.539378711969783*^9, 
   3.539378721254752*^9}, 3.539378783481576*^9, 3.539379407951611*^9, {
   3.539379780220991*^9, 3.539379791678053*^9}, {3.53939471235341*^9, 
   3.539394722589364*^9}, {3.539394882503873*^9, 3.539394904597978*^9}, {
   3.539613415564784*^9, 3.539613423562879*^9}, {3.539625321291978*^9, 
   3.5396253468594847`*^9}, 3.539626166465756*^9, {3.539649651242449*^9, 
   3.539649671696088*^9}, 3.541517015349262*^9, 3.5415171040511627`*^9, 
   3.541565170079391*^9, {3.5418283976312227`*^9, 3.541828424579524*^9}, {
   3.541834924152247*^9, 3.54183493696598*^9}, 3.541870783433387*^9, {
   3.541911287339384*^9, 3.5419113086524878`*^9}, 3.54191155098875*^9, {
   3.541912475806052*^9, 3.541912485438281*^9}, {3.541912605006493*^9, 
   3.541912614797728*^9}, 3.541916159494544*^9, 3.541916189719379*^9, 
   3.541916254033441*^9, 3.54191644324889*^9, {3.541916760812167*^9, 
   3.541916797973023*^9}, 3.541916939017223*^9, 3.541918554403308*^9, 
   3.541918609718408*^9, {3.541919413759678*^9, 3.541919441686675*^9}, {
   3.541920771701563*^9, 3.5419207749516087`*^9}, {3.5419211209018803`*^9, 
   3.5419211238948183`*^9}, {3.541921227711319*^9, 3.541921230336838*^9}, {
   3.54192144571662*^9, 3.541921448021222*^9}, {3.541921531830008*^9, 
   3.541921535003323*^9}, {3.541921894285726*^9, 3.541921896691044*^9}, {
   3.5419220636567297`*^9, 3.541922066410762*^9}, {3.541922370682111*^9, 
   3.5419223740202312`*^9}, {3.541927754421583*^9, 3.5419277781918173`*^9}, {
   3.541930303820683*^9, 3.541930332314447*^9}, {3.54193079872843*^9, 
   3.541930826916216*^9}, 3.541943080208783*^9, 3.541943120710951*^9, 
   3.541943183586815*^9, 3.5419445074493103`*^9, {3.541944565129271*^9, 
   3.5419446855099573`*^9}, {3.5419447578020077`*^9, 3.541944782566895*^9}, {
   3.541944816125428*^9, 3.5419449154760427`*^9}, 3.5419449496275377`*^9, 
   3.541944985516548*^9, 3.541945032228174*^9, {3.5419450639846153`*^9, 
   3.5419450843999567`*^9}, {3.541945219539925*^9, 3.541945245324975*^9}, 
   3.541945275653693*^9, {3.541945610042067*^9, 3.541945684298229*^9}, {
   3.54194572770068*^9, 3.5419457427645683`*^9}, 3.541945797241425*^9, 
   3.541945988244418*^9, {3.541946038562257*^9, 3.541946046842114*^9}, 
   3.54200221065965*^9, 3.542003117222847*^9, 3.54200378731047*^9, 
   3.542004258262534*^9, 3.542004442071697*^9, 3.542004600158127*^9, {
   3.542004650527514*^9, 3.542004680152152*^9}, 3.5420052684927063`*^9, 
   3.542005378932103*^9, 3.542016078102503*^9, {3.542458368218857*^9, 
   3.54245839456437*^9}, 3.5424585253108187`*^9, {3.542458577711586*^9, 
   3.542458668528367*^9}, {3.542458713833847*^9, 3.542458749517305*^9}, 
   3.542458817385446*^9, 3.542458851568701*^9, 3.542458918222322*^9, 
   3.542459056958088*^9, 3.5424591018356533`*^9, 3.542459415038047*^9, 
   3.542459464447118*^9, 3.542459577959444*^9, 3.54246008060365*^9, {
   3.5424602677564487`*^9, 3.542460329078587*^9}, {3.542460379294976*^9, 
   3.542460383010552*^9}, 3.542461440071253*^9, 3.542471994614184*^9, 
   3.542472287883926*^9, 3.54247558713315*^9, 3.5424756437095957`*^9, 
   3.542475700400285*^9, 3.542475897214514*^9, {3.5424760431765413`*^9, 
   3.542476065892363*^9}, 3.542476760999522*^9, 3.542476794017494*^9, {
   3.542476825876132*^9, 3.542476878966535*^9}, {3.542476930028803*^9, 
   3.5424769597236433`*^9}, 3.542477006664768*^9, 3.5424770427031183`*^9, 
   3.542477320912944*^9, {3.542477391348168*^9, 3.542477428117378*^9}, 
   3.5424778758106194`*^9, 3.5425104536179667`*^9, 3.542511069311243*^9, 
   3.5435621528289347`*^9, {3.543564473142213*^9, 3.543564498022808*^9}, {
   3.5435646369922953`*^9, 3.543564680046682*^9}, {3.543573737396884*^9, 
   3.54357375800489*^9}, 3.5435748776463633`*^9, {3.543575619291524*^9, 
   3.543575639515943*^9}, {3.543575828336568*^9, 3.543575855947826*^9}, {
   3.5436411190391407`*^9, 3.54364113972958*^9}, {3.543641221910014*^9, 
   3.543641252819869*^9}, {3.543641828421338*^9, 3.543641852594555*^9}, {
   3.543643482203175*^9, 3.543643505794553*^9}, {3.543644014703384*^9, 
   3.5436440661341887`*^9}, 3.543644117167191*^9, {3.5436441696045647`*^9, 
   3.543644242599934*^9}, {3.543646077535074*^9, 3.543646089992923*^9}, {
   3.5436463524087267`*^9, 3.543646364081938*^9}, {3.543647425883914*^9, 
   3.543647439726799*^9}, {3.543653404557008*^9, 3.543653414869619*^9}, {
   3.543653968972085*^9, 3.543653977650147*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Write Out", "Subsubtitle"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"file1", "=", 
    RowBox[{"OpenWrite", "[", 
     RowBox[{"\"\<patch.dat\>\"", ",", 
      RowBox[{"BinaryFormat", "\[Rule]", "True"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "file1", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BinaryWrite", "[", 
    RowBox[{"file1", ",", 
     RowBox[{"{", 
      RowBox[{"NR", ",", "NA"}], "}"}], ",", "\"\<Integer32\>\""}], "]"}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file1", ",", 
        RowBox[{"patch", "[", 
         RowBox[{"[", 
          RowBox[{"ii", ",", "jj"}], "]"}], "]"}], ",", "\"\<Real64\>\""}], 
       "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"BinaryWrite", "[", 
          RowBox[{"file1", ",", 
           RowBox[{"vecmask", "[", 
            RowBox[{"[", 
             RowBox[{"var", ",", "ii", ",", "jj"}], "]"}], "]"}], ",", 
           "\"\<Integer32\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
        "\[IndentingNewLine]", ",", 
        RowBox[{"{", 
         RowBox[{"var", ",", "1", ",", "5"}], "}"}]}], "]"}], ";"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", "1", ",", "NR"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"jj", ",", "1", ",", "NA"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Close", "[", "file1", "]"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.4098352392508907`*^9, {3.4241735296917467`*^9, 3.42417354366833*^9}, {
   3.424174546396842*^9, 3.424174546492543*^9}, {3.424174639487041*^9, 
   3.424174639612245*^9}, {3.428319483319551*^9, 3.42831949821423*^9}, 
   3.517555383294497*^9}],

Cell[BoxData[
 RowBox[{"OutputStream", "[", 
  RowBox[{"\<\"patch.dat\"\>", ",", "503"}], "]"}]], "Print",
 CellChangeTimes->{
  3.4854918645492983`*^9, {3.48549219471355*^9, 3.485492203839162*^9}, 
   3.485492614861432*^9, 3.485493681225198*^9, 3.48550184045982*^9, 
   3.485518749309884*^9, 3.485601005819017*^9, 3.4856010731600523`*^9, 
   3.48560156377967*^9, 3.485601606059523*^9, 3.485602640238764*^9, {
   3.485604141616178*^9, 3.48560414359846*^9}, 3.4856055981137047`*^9, 
   3.4857577270155773`*^9, 3.485758790282036*^9, {3.485758855690428*^9, 
   3.485759027373125*^9}, 3.48802299329425*^9, 3.488023082761506*^9, 
   3.48808681174655*^9, 3.4880869469653063`*^9, 3.488088673381858*^9, {
   3.488089657017668*^9, 3.488089673321178*^9}, 3.488090564450447*^9, {
   3.4880917441644077`*^9, 3.4880917646336393`*^9}, 3.488094135730473*^9, 
   3.488094340050995*^9, 3.48809439062672*^9, 3.4880946622849417`*^9, 
   3.488095139931328*^9, {3.488095534401939*^9, 3.488095542097365*^9}, 
   3.488100679832859*^9, 3.488105249969412*^9, {3.488105380741272*^9, 
   3.460349610853056*^9}, 3.460349690123514*^9, {3.46034972936548*^9, 
   3.460349779994309*^9}, 3.460349819265752*^9, 3.460349998241066*^9, {
   3.460367074390511*^9, 3.46036713565096*^9}, 3.460369223423543*^9, 
   3.460369797480749*^9, 3.4603731481723013`*^9, 3.4603763020318613`*^9, 
   3.460377300053214*^9, 3.460377384571219*^9, 3.46037955816087*^9, {
   3.4603815489949827`*^9, 3.460381634326611*^9}, {3.460381679203827*^9, 
   3.460381683762228*^9}, 3.4603826465688467`*^9, 3.4603838372543364`*^9, 
   3.4603840104877453`*^9, 3.460384080886105*^9, 3.460384182804916*^9, 
   3.460384337856057*^9, 3.460384576180641*^9, 3.460385907308751*^9, 
   3.4603860529015007`*^9, 3.460386428057003*^9, 3.460387410976676*^9, 
   3.460387958782723*^9, 3.460388674642592*^9, 3.460389048681576*^9, 
   3.460389646939399*^9, 3.460389963400716*^9, {3.4979552611346197`*^9, 
   3.4979552759888773`*^9}, 3.497955404878851*^9, {3.497955440027972*^9, 
   3.497955462440918*^9}, 3.497955596643219*^9, {3.497955671128986*^9, 
   3.497955684446039*^9}, 3.497955808586617*^9, 3.497956297391856*^9, {
   3.497957000985477*^9, 3.49795700286723*^9}, {3.497957572981833*^9, 
   3.497957590268284*^9}, 3.49795772579669*^9, 3.497957761832877*^9, 
   3.497957796351511*^9, 3.497958526377233*^9, {3.4979585775175056`*^9, 
   3.4979585935354548`*^9}, 3.498203860831514*^9, 3.498203902975028*^9, {
   3.4982043479760513`*^9, 3.498204359220125*^9}, 3.498204392479539*^9, 
   3.498204434421365*^9, 3.498204623228737*^9, {3.5014870573365297`*^9, 
   3.5014870748495617`*^9}, {3.5014871392260323`*^9, 
   3.5014871476348133`*^9}, {3.501487227852206*^9, 3.5014872483139963`*^9}, {
   3.501487292342412*^9, 3.501487309160214*^9}, 3.501488106593137*^9, 
   3.501488143697016*^9, 3.501488222691819*^9, 3.501488254846558*^9, {
   3.501488286701931*^9, 3.5014883068843613`*^9}, 3.501488383200532*^9, 
   3.501488530092507*^9, {3.5014885657111464`*^9, 3.5014885926665707`*^9}, {
   3.5014886452202673`*^9, 3.501488823015194*^9}, 3.501488945842948*^9, 
   3.501489834063323*^9, 3.5014900414158*^9, 3.501490245648302*^9, 
   3.501493089002304*^9, 3.501493186020743*^9, 3.501493256721252*^9, 
   3.501493327275485*^9, 3.501493405894359*^9, {3.501493627733333*^9, 
   3.5014936528237658`*^9}, {3.5014937105889*^9, 3.50149373592094*^9}, 
   3.501494255060707*^9, 3.501502574499866*^9, {3.5015027210201483`*^9, 
   3.5015027368407907`*^9}, 3.501502803248629*^9, 3.501502990350889*^9, 
   3.501503167865058*^9, {3.501503234419342*^9, 3.501503281233141*^9}, {
   3.501503320011099*^9, 3.5015033411139803`*^9}, {3.5015033944290247`*^9, 
   3.501503423407461*^9}, 3.501503491609754*^9, 3.5015035425656023`*^9, {
   3.501503572792142*^9, 3.501503592138995*^9}, {3.501503631987571*^9, 
   3.460391461100932*^9}, 3.4603915528512*^9, {3.460391621182597*^9, 
   3.460391726384142*^9}, 3.4603917667193413`*^9, 3.4603918059229097`*^9, {
   3.4603918993891172`*^9, 3.4603919047121763`*^9}, 3.460392449272854*^9, 
   3.4603924921560087`*^9, 3.460392539540311*^9, 3.460392592416616*^9, 
   3.460392654777666*^9, 3.4603927231049633`*^9, 3.4603927812208433`*^9, 
   3.460393535050625*^9, 3.460393829225335*^9, 3.4603938855286837`*^9, 
   3.460393945126144*^9, 3.460394706237048*^9, 3.460394760295681*^9, 
   3.460394958594301*^9, 3.4603950845065413`*^9, 3.460395239529314*^9, 
   3.46039538994477*^9, 3.460425925418676*^9, {3.4604260232866697`*^9, 
   3.46042614113664*^9}, 3.460426351231572*^9, 3.4604275050083637`*^9, 
   3.460427544777648*^9, 3.4604283659777803`*^9, 3.460428408288698*^9, 
   3.460428789150981*^9, {3.460428833864509*^9, 3.460389723150337*^9}, {
   3.460392228269724*^9, 3.460392243071309*^9}, 3.460392274476532*^9, 
   3.460395651746223*^9, {3.460614453433044*^9, 3.460256691241763*^9}, 
   3.460257005428955*^9, 3.503228444077649*^9, {3.503228540724351*^9, 
   3.503228548838046*^9}, {3.503228705637252*^9, 3.503228709486827*^9}, {
   3.5032287747107277`*^9, 3.503228796971507*^9}, {3.503299082504994*^9, 
   3.50329908617488*^9}, {3.5033156196444902`*^9, 3.460358821693692*^9}, 
   3.504000653514469*^9, {3.504000802182077*^9, 3.504000905607587*^9}, {
   3.504000958959773*^9, 3.5040009848546*^9}, {3.504001071634042*^9, 
   3.504001075695167*^9}, {3.504001270306122*^9, 3.504001275067092*^9}, 
   3.504001609106369*^9, 3.504002422942068*^9, 3.504002723663578*^9, 
   3.5040029623394823`*^9, {3.504003231216441*^9, 3.504003236445689*^9}, 
   3.5040051410279913`*^9, 3.517555404779688*^9, 3.517556640927807*^9, 
   3.517568355396585*^9, 3.51757742123337*^9, 3.517582232706675*^9, 
   3.517635241704118*^9, 3.517635557045293*^9, {3.517636472852532*^9, 
   3.517636493451439*^9}, 3.517637332601433*^9, 3.517639758302993*^9, 
   3.5176406692202673`*^9, 3.517640726883173*^9, {3.517640907189739*^9, 
   3.517640922797249*^9}, {3.517640956013267*^9, 3.46039343349259*^9}, 
   3.460393464077565*^9, 3.460394829946105*^9, {3.4603959280867968`*^9, 
   3.460354128662952*^9}, 3.4603556073296413`*^9, {3.460367939166497*^9, 
   3.460367960149581*^9}, 3.46039618220369*^9, 3.460439832764451*^9, 
   3.4604531639437838`*^9, 3.460453545304175*^9, {3.4604560211022673`*^9, 
   3.4604560446283216`*^9}, 3.460460229095767*^9, 3.4604603826664543`*^9, 
   3.4604719392442513`*^9, 3.4604723020792503`*^9, 3.460475528304225*^9, 
   3.460478448371739*^9, 3.460478527363607*^9, 3.460478874063025*^9, 
   3.4604840289805*^9, 3.460484060750099*^9, 3.460484114381403*^9, 
   3.460484503340457*^9, 3.460484638643188*^9, 3.460484746207703*^9, 
   3.460484917660537*^9, 3.460715171021275*^9, 3.460715257657908*^9, 
   3.460715460282489*^9, 3.460716811640711*^9, 3.460718862781959*^9, {
   3.4607315104972897`*^9, 3.4607315376252813`*^9}, 3.460731598154105*^9, {
   3.460731698584456*^9, 3.460393908117523*^9}, {3.460394070314364*^9, 
   3.460338444710916*^9}, 3.460338492564919*^9, 3.460340291781704*^9, 
   3.4603403670144987`*^9, 3.4603404685270443`*^9, 3.460352942764675*^9, 
   3.460353033032119*^9, 3.518956321778748*^9, 3.518956720731655*^9, 
   3.5190200335740213`*^9, 3.519021401689411*^9, 3.519022607565502*^9, 
   3.5190255649649773`*^9, 3.519032034532403*^9, 3.519036348409244*^9, 
   3.5190367129055433`*^9, 3.5190375817784853`*^9, 3.519039353470305*^9, 
   3.5191035563829403`*^9, 3.519103610968693*^9, 3.519104543034802*^9, 
   3.519105652851575*^9, 3.519106292945162*^9, 3.5191149004658737`*^9, 
   3.539245040697979*^9, 3.539289226960998*^9, 3.5392894597527103`*^9, 
   3.539337478931611*^9, {3.539378712008725*^9, 3.539378721293133*^9}, 
   3.539378783518528*^9, 3.5393794079725647`*^9, {3.539379780242848*^9, 
   3.5393797917145653`*^9}, {3.539394712374157*^9, 3.539394722607901*^9}, {
   3.539394882525867*^9, 3.539394904618844*^9}, {3.539613415727571*^9, 
   3.5396134236018543`*^9}, {3.539625321387272*^9, 3.5396253469003983`*^9}, 
   3.539626166610462*^9, {3.539649651287148*^9, 3.539649671730451*^9}, 
   3.541517015384426*^9, 3.541517104084301*^9, 3.541565170113679*^9, {
   3.541828397659676*^9, 3.541828424601201*^9}, {3.541834924352767*^9, 
   3.5418349370198317`*^9}, 3.541870783459485*^9, 3.541911308688046*^9, 
   3.54191155103024*^9, {3.54191247583851*^9, 3.541912485475387*^9}, {
   3.541912605042197*^9, 3.541912614828416*^9}, 3.5419161595257053`*^9, 
   3.541916189752795*^9, 3.541916254071097*^9, 3.5419164432828617`*^9, {
   3.541916760843177*^9, 3.5419167980051537`*^9}, 3.541916939133772*^9, 
   3.5419185544368687`*^9, 3.541918609750883*^9, {3.541919413794155*^9, 
   3.541919441720057*^9}, {3.541920771750269*^9, 3.5419207749850082`*^9}, {
   3.541921120944108*^9, 3.54192112392874*^9}, {3.541921227745586*^9, 
   3.5419212303719673`*^9}, {3.541921445750392*^9, 3.54192144805477*^9}, {
   3.5419215318628073`*^9, 3.541921535035681*^9}, {3.5419218943219833`*^9, 
   3.5419218967403927`*^9}, {3.541922063689994*^9, 3.541922066446906*^9}, {
   3.541922370712843*^9, 3.541922374057181*^9}, {3.54192775445881*^9, 
   3.5419277782245617`*^9}, {3.541930303857622*^9, 3.541930332347085*^9}, {
   3.541930798762309*^9, 3.541930826951334*^9}, 3.541943083787093*^9, 
   3.5419431207457743`*^9, 3.541943183624577*^9, 3.541944507484598*^9, {
   3.5419445651699247`*^9, 3.541944685542857*^9}, {3.541944757839568*^9, 
   3.541944782593871*^9}, {3.5419448161592712`*^9, 3.5419449155088367`*^9}, 
   3.5419449496587877`*^9, 3.5419449855498037`*^9, 3.541945032260626*^9, {
   3.54194506401264*^9, 3.5419450844336977`*^9}, {3.5419452195727386`*^9, 
   3.5419452453619843`*^9}, 3.541945275697068*^9, {3.541945610078945*^9, 
   3.541945684340642*^9}, {3.541945727735766*^9, 3.54194574279758*^9}, 
   3.541945797273992*^9, 3.541945988278036*^9, {3.541946038600054*^9, 
   3.5419460468783827`*^9}, 3.542002210696868*^9, 3.542003117264009*^9, 
   3.542003787353704*^9, 3.542004258302375*^9, 3.5420044421072187`*^9, 
   3.5420046001918917`*^9, {3.542004650562011*^9, 3.54200468018674*^9}, 
   3.542005268525847*^9, 3.5420053789689217`*^9, 3.5420160781595078`*^9, {
   3.542458368304275*^9, 3.542458394607072*^9}, 3.542458525344368*^9, {
   3.542458577749288*^9, 3.5424586685780697`*^9}, {3.542458713868422*^9, 
   3.542458749554841*^9}, 3.5424588174237757`*^9, 3.542458851609407*^9, 
   3.542458918254928*^9, 3.542459056997665*^9, 3.542459101868824*^9, 
   3.542459415072401*^9, 3.54245946448528*^9, 3.542459578022462*^9, 
   3.542460080636945*^9, {3.5424602677893*^9, 3.5424603291140833`*^9}, {
   3.542460379328947*^9, 3.5424603830317183`*^9}, 3.5424614401109447`*^9, 
   3.542471994649897*^9, 3.542472287923463*^9, 3.5424755871696568`*^9, 
   3.542475643744123*^9, 3.5424757004348917`*^9, 3.54247589724753*^9, {
   3.542476043212677*^9, 3.542476065921892*^9}, 3.542476761036665*^9, 
   3.542476794053623*^9, {3.542476825913012*^9, 3.542476878999378*^9}, {
   3.542476930068707*^9, 3.542476959756809*^9}, 3.5424770066988087`*^9, 
   3.542477042735341*^9, 3.542477320949098*^9, {3.542477391383782*^9, 
   3.5424774281765623`*^9}, 3.542477875849957*^9, 3.542510453655395*^9, 
   3.5425110693484573`*^9, 3.543562152862934*^9, {3.543564473173723*^9, 
   3.543564498056881*^9}, {3.543564637027025*^9, 3.543564680077216*^9}, {
   3.5435737374175777`*^9, 3.543573758058772*^9}, 3.543574877682753*^9, {
   3.5435756193283033`*^9, 3.5435756395682983`*^9}, {3.5435758284037952`*^9, 
   3.543575856048648*^9}, {3.543641119077779*^9, 3.543641139768704*^9}, {
   3.543641221943557*^9, 3.543641252855075*^9}, {3.543641828562212*^9, 
   3.543641852701152*^9}, {3.543643482233747*^9, 3.5436435058466587`*^9}, {
   3.543644014739128*^9, 3.543644066172144*^9}, 3.543644117190732*^9, {
   3.543644169640361*^9, 3.543644242632709*^9}, {3.543646077574403*^9, 
   3.543646090048107*^9}, {3.543646352479714*^9, 3.5436463641912527`*^9}, {
   3.543647425959134*^9, 3.543647439778153*^9}, {3.543653404585997*^9, 
   3.543653414906311*^9}, {3.5436539690048723`*^9, 3.543653977672944*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Initial data and diffeo", "Subtitle",
 CellChangeTimes->{{3.416201497074218*^9, 3.416201497824654*^9}, {
  3.416542505841861*^9, 3.416542507993703*^9}, {3.416543211651227*^9, 
  3.4165432155708933`*^9}, {3.51755655628972*^9, 3.517556557270051*^9}}],

Cell["Hmm", "Text",
 CellChangeTimes->{{3.416156133618108*^9, 3.416156155985187*^9}, {
  3.416541983733342*^9, 3.4165419838822527`*^9}, {3.416542494955113*^9, 
  3.416542495618685*^9}, {3.4165428386978407`*^9, 3.416542839025936*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{"r_", ",", "a_"}], "]"}], ":=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"A", "[", 
     RowBox[{"r_", ",", "a_"}], "]"}], ":=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"B", "[", 
     RowBox[{"r_", ",", "a_"}], "]"}], ":=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"F", "[", 
     RowBox[{"r_", ",", "a_"}], "]"}], ":=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{"r_", ",", "a_"}], "]"}], ":=", "0"}], ";"}]}], "Input",
 CellChangeTimes->{{3.50150322725357*^9, 3.4603922412792788`*^9}, {
  3.503315605433838*^9, 3.503315607959084*^9}, {3.517568343196952*^9, 
  3.517568345810051*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"cond", "[", 
     RowBox[{"ii_", ",", "jj_"}], "]"}], ":=", 
    RowBox[{"mask", "[", 
     RowBox[{"[", 
      RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TarrP", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"T", "[", 
       RowBox[{
        RowBox[{"rarr", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", 
        RowBox[{"aarr", "[", 
         RowBox[{"[", "jj", "]"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", "NR"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"jj", ",", "1", ",", "NA"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AarrP", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"A", "[", 
       RowBox[{
        RowBox[{"rarr", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", 
        RowBox[{"aarr", "[", 
         RowBox[{"[", "jj", "]"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", "NR"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"jj", ",", "1", ",", "NA"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BarrP", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"B", "[", 
       RowBox[{
        RowBox[{"rarr", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", 
        RowBox[{"aarr", "[", 
         RowBox[{"[", "jj", "]"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", "NR"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"jj", ",", "1", ",", "NA"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FarrP", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"F", "[", 
       RowBox[{
        RowBox[{"rarr", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", 
        RowBox[{"aarr", "[", 
         RowBox[{"[", "jj", "]"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", "NR"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"jj", ",", "1", ",", "NA"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SarrP", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{
        RowBox[{"rarr", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", 
        RowBox[{"aarr", "[", 
         RowBox[{"[", "jj", "]"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", "NR"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"jj", ",", "1", ",", "NA"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"T", ",", "A", ",", "B", ",", "F", ",", "S"}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.419243440769643*^9, 3.419243441126568*^9}, {
   3.41924650090946*^9, 3.419246507788535*^9}, {3.425111051261951*^9, 
   3.425111075431073*^9}, {3.425112042288032*^9, 3.425112112696601*^9}, {
   3.425112161064046*^9, 3.42511216276613*^9}, {3.4253455950042562`*^9, 
   3.425345666296413*^9}, {3.42534625280408*^9, 3.425346323534213*^9}, {
   3.4253463553201637`*^9, 3.425346419926309*^9}, {3.428320919691051*^9, 
   3.4283209276663857`*^9}, {3.460370699137353*^9, 3.4603707111641493`*^9}, {
   3.4603707568565493`*^9, 3.460370811785021*^9}, {3.460371542092176*^9, 
   3.4603715524224787`*^9}, {3.460371724929913*^9, 3.460371740207704*^9}, 
   3.460371827750123*^9, {3.4603718580066833`*^9, 3.4603718580944242`*^9}, {
   3.46037189355579*^9, 3.460371893861116*^9}, {3.460371935721509*^9, 
   3.460371935801627*^9}, {3.460372026504945*^9, 3.4603720266113033`*^9}, {
   3.46037208202713*^9, 3.4603720821124067`*^9}, {3.4603723509975967`*^9, 
   3.460372496294924*^9}, {3.460373322355191*^9, 3.460373331738413*^9}, {
   3.460374856918042*^9, 3.460374860148785*^9}, {3.483950721507805*^9, 
   3.4839507855294323`*^9}, 3.483950876847892*^9, {3.483950935064024*^9, 
   3.483950955896113*^9}, {3.483951924906913*^9, 3.483951925229123*^9}, {
   3.4846359562531567`*^9, 3.484635964922209*^9}, {3.4846360829399443`*^9, 
   3.4846361048970833`*^9}, 3.48463646990626*^9, {3.4846430018329763`*^9, 
   3.484643009613092*^9}, {3.484644413264166*^9, 3.484644414055235*^9}, {
   3.484644608675035*^9, 3.484644612856049*^9}, 3.485082784531608*^9, {
   3.485082856074562*^9, 3.485082857255785*^9}, {3.4850833163717422`*^9, 
   3.485083341399725*^9}, {3.4850847078452587`*^9, 3.460349676121657*^9}, {
   3.460349764502083*^9, 3.460349766827506*^9}, {3.5014930852749357`*^9, 
   3.501493087033044*^9}, {3.5014931419151*^9, 3.501493143410679*^9}, {
   3.501493183545929*^9, 3.501493184497134*^9}, {3.501493253610351*^9, 
   3.50149325484044*^9}, {3.5014933085461407`*^9, 3.501493325144472*^9}, {
   3.501493397585026*^9, 3.501493404276683*^9}, {3.5014936485775957`*^9, 
   3.501493651127699*^9}, {3.501493696370013*^9, 3.501493708450797*^9}, {
   3.501502136321148*^9, 3.501502152252358*^9}, {3.501502554624*^9, 
   3.5015025682493687`*^9}, {3.501502622968598*^9, 3.501502624463874*^9}, {
   3.50331561388099*^9, 3.5033156147166777`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"file2", "=", 
    RowBox[{"OpenWrite", "[", 
     RowBox[{"\"\<init.dat\>\"", ",", 
      RowBox[{"BinaryFormat", "\[Rule]", "True"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BinaryWrite", "[", 
    RowBox[{"file2", ",", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Flatten", "[", "TarrP", "]"}], ",", 
         RowBox[{"Flatten", "[", "AarrP", "]"}], ",", 
         RowBox[{"Flatten", "[", "BarrP", "]"}], ",", 
         RowBox[{"Flatten", "[", "FarrP", "]"}], ",", 
         RowBox[{"Flatten", "[", "SarrP", "]"}]}], "}"}], "]"}], "]"}], ",", 
     "\"\<Real64\>\""}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Close", "[", "file2", "]"}], ";"}]}], "Input",
 CellChangeTimes->{3.5015025322727547`*^9}]
}, Open  ]]
},
WindowSize->{867, 767},
WindowMargins->{{Automatic, 13}, {Automatic, 0}},
DockedCells->(FrontEndExecute[{
   FrontEnd`NotebookApply[
    FrontEnd`InputNotebook[], #, Placeholder]}]& ),
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 91, 1, 46, "Subtitle"],
Cell[661, 25, 772, 12, 27, "Input"],
Cell[CellGroupData[{
Cell[1458, 41, 6019, 82, 27, "Input"],
Cell[7480, 125, 769, 11, 27, "Output"]
}, Open  ]],
Cell[8264, 139, 245, 5, 27, "Input"],
Cell[CellGroupData[{
Cell[8534, 148, 33, 0, 26, "Subsubtitle"],
Cell[8570, 150, 11500, 161, 58, "Input"],
Cell[20073, 313, 573, 12, 58, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20683, 330, 225, 3, 26, "Subsubtitle"],
Cell[CellGroupData[{
Cell[20933, 337, 1890, 51, 318, "Input"],
Cell[22826, 390, 2234, 35, 43, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25097, 430, 1892, 51, 318, "Input"],
Cell[26992, 483, 1501, 25, 43, "Output"]
}, Open  ]],
Cell[28508, 511, 193, 4, 27, "Input"],
Cell[28704, 517, 140, 3, 27, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28881, 525, 36, 0, 26, "Subsubtitle"],
Cell[28920, 527, 666, 17, 27, "Input"],
Cell[29589, 546, 1667, 35, 27, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[31293, 586, 189, 2, 26, "Subsubtitle"],
Cell[31485, 590, 285, 8, 27, "Input"],
Cell[31773, 600, 364, 9, 27, "Input"],
Cell[CellGroupData[{
Cell[32162, 613, 620, 13, 58, "Input"],
Cell[32785, 628, 14771, 220, 345, "Output"],
Cell[47559, 850, 14769, 220, 345, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[62365, 1075, 147, 2, 27, "Input"],
Cell[62515, 1079, 11854, 164, 20, "Print"]
}, Open  ]],
Cell[74384, 1246, 2019, 54, 253, "Input"],
Cell[CellGroupData[{
Cell[76428, 1304, 99, 1, 27, "Input"],
Cell[76530, 1307, 11853, 164, 27, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[88432, 1477, 32, 0, 26, "Subsubtitle"],
Cell[CellGroupData[{
Cell[88489, 1481, 2100, 54, 298, "Input"],
Cell[90592, 1537, 11868, 165, 20, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[102521, 1709, 254, 3, 46, "Subtitle"],
Cell[102778, 1714, 233, 3, 26, "Text"],
Cell[103014, 1719, 959, 31, 148, "Input"],
Cell[103976, 1752, 5290, 125, 208, "Input"],
Cell[109269, 1879, 934, 25, 118, "Input"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
