(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   1366288,      35765]
NotebookOptionsPosition[   1339277,      34939]
NotebookOutlinePosition[   1341896,      35023]
CellTagsIndexPosition[   1341821,      35018]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["RS **6d** Ansatz 1", "Subtitle",
 CellChangeTimes->{{3.408796983010241*^9, 3.408796989128707*^9}, {
  3.415942197687789*^9, 3.415942199707787*^9}, {3.428318203595373*^9, 
  3.4283182110266533`*^9}, {3.4318556687961187`*^9, 3.431855668994246*^9}, {
  3.495174647742872*^9, 3.460515504326817*^9}, {3.503996600043788*^9, 
  3.503996603042028*^9}, {3.54247054384832*^9, 3.542470547950636*^9}, {
  3.543557153971836*^9, 3.543557154018488*^9}, {3.54355724987787*^9, 
  3.5435572520293093`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", "\"\<hmm\>\"", "]"}]], "Input"],

Cell[BoxData["\<\"hmm\"\>"], "Print",
 CellChangeTimes->{
  3.50331095224676*^9, {3.503311334781259*^9, 3.460515672230812*^9}, 
   3.503997004484676*^9, 3.503997193150251*^9, 3.503997258578888*^9, 
   3.504000113069686*^9, 3.517303168099127*^9, 3.5175791605471287`*^9, 
   3.517643108435388*^9, 3.517650907255109*^9, 3.517658628720002*^9, 
   3.517658688981691*^9, 3.517660935926754*^9, 3.51782364066553*^9, 
   3.517823671412335*^9, 3.517824229188287*^9, {3.517825902545436*^9, 
   3.46038825031455*^9}, 3.460392629312698*^9, 3.460392745837037*^9, 
   3.4603966818363*^9, 3.4603979115528307`*^9, {3.460444070657011*^9, 
   3.4603567749901543`*^9}, 3.460366838380539*^9, 3.460372534611771*^9, 
   3.539782997335884*^9, 3.5397851396635227`*^9, 3.539868423697628*^9, 
   3.539873662402772*^9, 3.542469992334106*^9, 3.5435574163990183`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRSetup2.nb - modified", "Subsubtitle",
 CellChangeTimes->{{3.478330969800351*^9, 3.478330971159855*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Latest", " ", "Version"}], " ", "*)"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"{", 
    RowBox[{
    "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
     "gzz"}], "}"}]}], "\n"}], "\n", 
 RowBox[{"Gd", "=", 
  RowBox[{"DiagonalMatrix", "[", "metric", "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
   "gzz"}], "}"}]], "Output",
 CellChangeTimes->{
  3.503310952791863*^9, {3.503311335284086*^9, 3.460515672380575*^9}, 
   3.503997004769865*^9, 3.503997193436174*^9, 3.5039972588799763`*^9, 
   3.504000113304111*^9, 3.5173031683490477`*^9, 3.5175791607200947`*^9, 
   3.517643108635914*^9, 3.517650907530168*^9, 3.517658628986102*^9, 
   3.5176586892509327`*^9, 3.517660936106361*^9, 3.517823641023736*^9, 
   3.517823671828333*^9, 3.517824229417685*^9, {3.5178259026967983`*^9, 
   3.4603882504778843`*^9}, 3.4603926295278473`*^9, 3.4603927460334044`*^9, 
   3.4603966820091333`*^9, 3.460397911729974*^9, {3.4604440708698473`*^9, 
   3.460356775156495*^9}, 3.4603668385912523`*^9, 3.460372534854219*^9, 
   3.5397829977463493`*^9, 3.539785139995511*^9, 3.539868423973227*^9, 
   3.539873662654141*^9, 3.542469992403655*^9, 3.5435574164483232`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"gtt", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "grr", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "g\[Theta]\[Theta]", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "g\[Phi]\[Phi]", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "gzz"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.503310952791863*^9, {3.503311335284086*^9, 3.460515672380575*^9}, 
   3.503997004769865*^9, 3.503997193436174*^9, 3.5039972588799763`*^9, 
   3.504000113304111*^9, 3.5173031683490477`*^9, 3.5175791607200947`*^9, 
   3.517643108635914*^9, 3.517650907530168*^9, 3.517658628986102*^9, 
   3.5176586892509327`*^9, 3.517660936106361*^9, 3.517823641023736*^9, 
   3.517823671828333*^9, 3.517824229417685*^9, {3.5178259026967983`*^9, 
   3.4603882504778843`*^9}, 3.4603926295278473`*^9, 3.4603927460334044`*^9, 
   3.4603966820091333`*^9, 3.460397911729974*^9, {3.4604440708698473`*^9, 
   3.460356775156495*^9}, 3.4603668385912523`*^9, 3.460372534854219*^9, 
   3.5397829977463493`*^9, 3.539785139995511*^9, 3.539868423973227*^9, 
   3.539873662654141*^9, 3.542469992403655*^9, 3.543557416450321*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Gd", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", "grt"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Gd", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "1"}], "]"}], "]"}], "=", "grt"}]}], "Input"],

Cell[BoxData["grt"], "Output",
 CellChangeTimes->{
  3.50331095292629*^9, {3.503311335372411*^9, 3.460515672510242*^9}, 
   3.503997004841145*^9, 3.503997193508582*^9, 3.5039972589761143`*^9, 
   3.504000113401451*^9, 3.5173031684297*^9, 3.517579160789398*^9, 
   3.517643108676997*^9, 3.517650907619927*^9, 3.517658629174996*^9, 
   3.517658689322502*^9, 3.517660936163856*^9, 3.5178236411046333`*^9, 
   3.517823671928771*^9, 3.5178242294717817`*^9, {3.51782590275142*^9, 
   3.460388250572813*^9}, 3.460392629592249*^9, 3.460392746087512*^9, 
   3.460396682069415*^9, 3.460397911774363*^9, {3.460444070974021*^9, 
   3.460356775229074*^9}, 3.460366838683338*^9, 3.4603725349177094`*^9, 
   3.539782997876357*^9, 3.539785140057931*^9, 3.53986842425675*^9, 
   3.539873662696342*^9, 3.542469992655013*^9, 3.543557416486944*^9}],

Cell[BoxData["grt"], "Output",
 CellChangeTimes->{
  3.50331095292629*^9, {3.503311335372411*^9, 3.460515672510242*^9}, 
   3.503997004841145*^9, 3.503997193508582*^9, 3.5039972589761143`*^9, 
   3.504000113401451*^9, 3.5173031684297*^9, 3.517579160789398*^9, 
   3.517643108676997*^9, 3.517650907619927*^9, 3.517658629174996*^9, 
   3.517658689322502*^9, 3.517660936163856*^9, 3.5178236411046333`*^9, 
   3.517823671928771*^9, 3.5178242294717817`*^9, {3.51782590275142*^9, 
   3.460388250572813*^9}, 3.460392629592249*^9, 3.460392746087512*^9, 
   3.460396682069415*^9, 3.460397911774363*^9, {3.460444070974021*^9, 
   3.460356775229074*^9}, 3.460366838683338*^9, 3.4603725349177094`*^9, 
   3.539782997876357*^9, 3.539785140057931*^9, 3.53986842425675*^9, 
   3.539873662696342*^9, 3.542469992655013*^9, 3.54355741648877*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"BuildMetric", ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Gu", "=", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{"Inverse", "[", "Gd", "]"}], "]"}]}], ";", 
    RowBox[{"G", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u", ",", "d"}], "}"}], ",", 
       RowBox[{"IdentityMatrix", "[", "Nind", "]"}]}], "}"}]}], ";"}], 
   ")"}]}]], "Input"],

Cell[BoxData["BuildMetric"], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
    "}"}]}], "\n"}], "\n", 
 RowBox[{"Nind", "=", 
  RowBox[{"Length", "[", "ind", "]"}]}]}], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.5033109583532267`*^9, {3.503311335710185*^9, 3.460515672801284*^9}, 
   3.5039970055234003`*^9, 3.503997193704561*^9, 3.503997259177459*^9, 
   3.504000113555479*^9, 3.5173031727440968`*^9, 3.517579161233733*^9, 
   3.517643120632904*^9, 3.517650908068326*^9, 3.5176586295419607`*^9, 
   3.517658689483971*^9, 3.517660936374831*^9, {3.517823645931738*^9, 
   3.5178236721550293`*^9}, 3.5178242296158333`*^9, {3.517825902915317*^9, 
   3.460388251693995*^9}, 3.460392630077626*^9, 3.460392746249144*^9, 
   3.4603966823796663`*^9, 3.4603979119319277`*^9, {3.460444071270954*^9, 
   3.46035677625375*^9}, 3.460366838836698*^9, 3.4603725351755877`*^9, 
   3.539782998253436*^9, 3.539785140231594*^9, 3.539868424542329*^9, 
   3.539873662802165*^9, 3.542469993074065*^9, 3.54355741742808*^9}],

Cell[BoxData["5"], "Output",
 CellChangeTimes->{
  3.5033109583532267`*^9, {3.503311335710185*^9, 3.460515672801284*^9}, 
   3.5039970055234003`*^9, 3.503997193704561*^9, 3.503997259177459*^9, 
   3.504000113555479*^9, 3.5173031727440968`*^9, 3.517579161233733*^9, 
   3.517643120632904*^9, 3.517650908068326*^9, 3.5176586295419607`*^9, 
   3.517658689483971*^9, 3.517660936374831*^9, {3.517823645931738*^9, 
   3.5178236721550293`*^9}, 3.5178242296158333`*^9, {3.517825902915317*^9, 
   3.460388251693995*^9}, 3.460392630077626*^9, 3.460392746249144*^9, 
   3.4603966823796663`*^9, 3.4603979119319277`*^9, {3.460444071270954*^9, 
   3.46035677625375*^9}, 3.460366838836698*^9, 3.4603725351755877`*^9, 
   3.539782998253436*^9, 3.539785140231594*^9, 3.539868424542329*^9, 
   3.539873662802165*^9, 3.542469993074065*^9, 3.5435574174294643`*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"getind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "i1", "]"}], ",", "i1", ",", 
      RowBox[{
       RowBox[{"Position", "[", 
        RowBox[{"ind", ",", "i1"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"lstind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"lsttmp2", "=", 
      RowBox[{"{", "}"}]}], ";", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"AppendTo", "[", 
        RowBox[{"lsttmp2", ",", 
         RowBox[{"getind", "[", 
          RowBox[{"i1", "[", 
           RowBox[{"[", 
            RowBox[{"lsttmp1", ",", "1"}], "]"}], "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"lsttmp1", ",", "1", ",", 
         RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
     "lsttmp2"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"up", "[", 
   RowBox[{"i1_", ",", "i2_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"lsttmp2", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"AppendTo", "[", 
       RowBox[{"lsttmp2", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"i1", "[", 
            RowBox[{"[", 
             RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "=!=", 
           RowBox[{"i2", "[", 
            RowBox[{"[", "lsttmp1", "]"}], "]"}]}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"i1", "[", 
              RowBox[{"[", 
               RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "===", "d"}], ",",
             "d", ",", "u"}], "]"}], ",", "0"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"lsttmp1", ",", "1", ",", 
        RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
    "lsttmp2"}], ")"}]}]}], "Input",
 Editable->False],

Cell[BoxData[""], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"t1_", ",", "dim_", ",", "indpos_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"MTtmp1", "=", "0"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Length", "[", "indpos", "]"}], "=!=", "dim"}], ",", 
      RowBox[{"Print", "[", "\"\<Error in index position\>\"", "]"}]}], "]"}],
     ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"MTtmp1", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"MTtmp1", ",", 
         RowBox[{"{", 
          RowBox[{"MTtmp3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"MTtmp2", ",", "1", ",", "dim"}], "}"}]}], "]"}], ";", 
    RowBox[{"t1", "=", 
     RowBox[{"{", 
      RowBox[{"indpos", ",", "MTtmp1"}], "}"}]}]}], ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ST", "[", 
    RowBox[{"t1_", ",", "tind_", ",", "val_"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"STtmp1", "=", "t1"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"up", "[", 
         RowBox[{"tind", ",", 
          RowBox[{"t1", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "=!=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"Length", "[", "tind", "]"}], "}"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Print", "[", "\"\<Error in Index Assignment!!\>\"", "]"}], 
        ";"}]}], "]"}], ";", 
     RowBox[{
      RowBox[{"STtmp1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "=", 
      RowBox[{"ReplacePart", "[", 
       RowBox[{
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", "val", ",", 
        RowBox[{"lstind", "[", "tind", "]"}]}], "]"}]}], ";", "STtmp1"}], 
    ")"}]}], "\n"}]], "Input",
 Editable->False],

Cell["\<\


Edited the expression below as 7.0 seems to complain about Sum[x] whereas 6.0 \
would just return x (ie. if there is no sum index!)

\
\>", "Text",
 CellChangeTimes->{{3.465736646430695*^9, 3.4657366879261303`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GT", "[", 
   RowBox[{"t1_", ",", "tind_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"GTtmp2", "=", 
     RowBox[{"up", "[", 
      RowBox[{"tind", ",", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
    RowBox[{"GTtmp3", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp4", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp5", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp6", "=", "t1"}], ";", "\n", "\t\t", 
    RowBox[{"Do", "[", "\n", "\t\t\t", 
     RowBox[{
      RowBox[{
       RowBox[{"Switch", "[", 
        RowBox[{
         RowBox[{"GTtmp2", "[", 
          RowBox[{"[", "GTtmp1", "]"}], "]"}], ",", "\n", "\t\t\t\t", "0", 
         ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}]}]}],
            ";"}], ")"}], ",", "\n", "\t\t\t\t", "u", ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gu[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}]}], ")"}], ",", "\n", "\t\t\t\t", "d", ",",
          "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gd[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}], ";"}], ")"}]}], "]"}], ";"}], "\n", 
      "\t\t\t", ",", 
      RowBox[{"{", 
       RowBox[{"GTtmp1", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"t1", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"GTtmp4", "===", "\"\<\>\""}], "&&", 
       RowBox[{"GTtmp5", "===", "\"\<\>\""}]}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{"\"\<GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\""}], 
       "]"}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{
       "\"\<Sum[GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\"", "<>", 
        "GTtmp4", "<>", "GTtmp5", "<>", "\"\<]\>\""}], "]"}]}], "]"}]}], 
   ")"}]}]], "Input",
 Editable->False,
 CellChangeTimes->{{3.465736640865263*^9, 3.4657366432796392`*^9}, {
  3.465736699767317*^9, 3.4657367470041943`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Trace, Outer Product and Covariant Derivative! - GREinstein.nb\
\>", "Subsubtitle",
 Editable->False],

Cell["\<\
Syntax:   trT[tensor,{{1,4},{2,3}}]   -  ie. contract 1 and 4 plus 2 and 3 \
positions\
\>", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"trT", "[", 
   RowBox[{"t1_", ",", "lst_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "tracetmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"dimt1", "===", "2"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tracetmp", "=", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"GT", "[", 
           RowBox[{"tmpt1", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"s1", ",", "d"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"s1", ",", "u"}], "}"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"s1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ";"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"MT", "[", 
        RowBox[{"tracetmp", ",", 
         RowBox[{"dimt1", "-", 
          RowBox[{"2", 
           RowBox[{"Length", "[", "lst", "]"}]}]}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{"d", ",", 
           RowBox[{"{", 
            RowBox[{"ii", ",", "1", ",", 
             RowBox[{"dimt1", "-", 
              RowBox[{"2", 
               RowBox[{"Length", "[", "lst", "]"}]}]}]}], "}"}]}], "]"}]}], 
        "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"{", "}"}], "===", 
             RowBox[{"Position", "[", 
              RowBox[{"lst", ",", "indno"}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"tmpstring1", "=", 
              RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,d},\>\""}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"tmpstring3", "=", 
              RowBox[{"tmpstring3", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,1,Nind},\>\""}]}], ";"}]}], "\[IndentingNewLine]", "]"}],
           ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}],
           ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\n", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"tmpstring4", "=", 
           RowBox[{"tmpstring4", "<>", "\"\<{s\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", 
            "\"\<,1,Nind},\>\""}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "1"}], "]"}], "]"}], "]"}]}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "2"}], "]"}], "]"}], "]"}], "<>", 
               "\"\<,d}\>\""}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,u}\>\""}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", 
           RowBox[{"Length", "[", "lst", "]"}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpeval", "=", 
        RowBox[{"\"\<Do[tracetmp=ST[tracetmp,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring1", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},Sum[GT[tmpt1,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring2", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring3", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "tracetmp"}], 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell["Syntax:   outerT[tensor1,tensor2] ", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"outerT", "[", 
   RowBox[{"t1_", ",", "t2_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    RowBox[{"dimt2", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t2", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", 
    RowBox[{"tmpt2", "=", "t2"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "outertmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"outertmp", ",", 
      RowBox[{"dimt1", "+", "dimt2"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{"d", ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"dimt1", "+", "dimt2"}]}], "}"}]}], "]"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring1", "=", 
        RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring2", "=", 
        RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", "\n", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring3", "=", 
        RowBox[{"tmpstring3", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", 
        RowBox[{"tmpstring4", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt2"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpeval", "=", 
     RowBox[{"\"\<Do[outertmp=ST[outertmp,{\>\"", "<>", "tmpstring1", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},GT[tmpt1,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring1", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]GT[tmpt2,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]],\>\"", "<>", "tmpstring2",
       "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring4", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "outertmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"scalarDT", "[", "t1_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"covDTtmp", ",", "1", ",", 
      RowBox[{"{", "d", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
    "tmpeval", "=", 
     "\"\<Do[covDTtmp=ST[covDTtmp,{{i1,d}},D[tmpt1,ind[[i1]]]],{i1,1,Nind}]\>\
\""}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "covDTtmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"covDT", "[", "t1_", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dimt1", "=", 
      RowBox[{"Length", "[", 
       RowBox[{"Dimensions", "[", 
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"MT", "[", 
      RowBox[{"covDTtmp", ",", 
       RowBox[{"dimt1", "+", "1"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{"d", ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", 
           RowBox[{"dimt1", "+", "1"}]}], "}"}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Build", " ", "expression"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring1", "=", 
         RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
        ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring2", "=", 
         RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", 
          "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring4", "=", 
         RowBox[{"\"\<-Sum[GT[tmpt1,{\>\"", "<>", 
          RowBox[{"StringDrop", "[", 
           RowBox[{"tmpstring1", ",", 
            RowBox[{"-", "1"}]}], "]"}], "<>", 
          "\"\<}]GT[\[CapitalGamma],{{REPL,d},{s1,d},{s2,u}}],{s2,1,Nind}]\>\"\
"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}], "\[Rule]", " ", 
            "\"\<s2\>\""}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"\"\<REPL\>\"", "\[Rule]", 
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring3", "=", 
         RowBox[{"tmpstring3", "<>", "tmpstring4"}]}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpeval", "=", 
      RowBox[{
      "\"\<Do[covDTtmp=ST[covDTtmp,{\>\"", "<>", "tmpstring1", "<>", 
       "\"\<{s1,d}},D[GT[tmpt1,{\>\"", "<>", 
       RowBox[{"StringDrop", "[", 
        RowBox[{"tmpstring1", ",", 
         RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],ind[[s1]]]\>\"", "<>", 
       "tmpstring3", "<>", "\"\<],\>\"", "<>", "tmpstring2", "<>", 
       "\"\<{s1,1,Nind}]\>\""}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "covDTtmp"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 Editable->False],

Cell[BoxData["."], "Input",
 CellChangeTimes->{3.399009138941909*^9},
 EmphasizeSyntaxErrors->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Buildmetric", "Subsubtitle"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
  "Print", "[", 
   "\"\<\\n\\n   \[CapitalDelta][r_,a_]=(\!\(\*FractionBox[\(\(\\\ \)\(1\)\), \
\(\((1 - a^2)\) + rh\\\ Sqrt[\((1 - r^2)\)]\)]\))^2\\n   f[r_]  =(1-r^2)\\n   \
g[a_]   =2-a^2\\n\\n\\n\\n\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.4603926036977377`*^9, 3.460392609494193*^9}, {
   3.4603964671280737`*^9, 3.460396474067587*^9}, {3.460396608649122*^9, 
   3.4603966089839687`*^9}, 3.5435573776732607`*^9, {3.543557822534987*^9, 
   3.543557822878004*^9}}],

Cell[BoxData["\<\"\\n\\n   \
\[CapitalDelta][r_,a_]=(\\!\\(\\*FractionBox[\\(\\(\\\\ \\)\\(1\\)\\), \
\\(\\((1 - a^2)\\) + rh\\\\ Sqrt[\\((1 - r^2)\\)]\\)]\\))^2\\n   f[r_]  \
=(1-r^2)\\n   g[a_]   =2-a^2\\n\\n\\n\\n\"\>"], "Print",
 CellChangeTimes->{{3.460392614803647*^9, 3.460392630773752*^9}, 
   3.4603927469544163`*^9, {3.4603965912356453`*^9, 3.460396610516452*^9}, 
   3.460396683089012*^9, 3.460397912493801*^9, {3.460444072054455*^9, 
   3.460356776865254*^9}, 3.460366839549692*^9, 3.4603725359239388`*^9, 
   3.539782999025613*^9, 3.539785140647101*^9, 3.539868426792572*^9, 
   3.539873663653604*^9, 3.5424699937927732`*^9, 3.5435573790963993`*^9, 
   3.5435574186869783`*^9, 3.543558277421892*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Gd", "=", 
   RowBox[{
    RowBox[{"\[CapitalDelta]", "[", 
     RowBox[{"r", ",", "a"}], "]"}], 
    RowBox[{"(", GridBox[{
       {
        RowBox[{
         RowBox[{"r", "^", "2"}], 
         RowBox[{"f", "[", "r", "]"}], 
         RowBox[{"Exp", "[", 
          RowBox[{"T", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], "]"}]}], "0", "0", "0", 
        "0", "0"},
       {"0", 
        RowBox[{
         FractionBox["1", 
          RowBox[{
           RowBox[{"f", "[", "r", "]"}], "^", "2"}]], 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"T", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
           RowBox[{
            RowBox[{"r", "^", "2"}], 
            RowBox[{"A", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], "]"}]}], 
        RowBox[{"a", " ", "r", " ", 
         FractionBox["1", 
          RowBox[{"f", "[", "r", "]"}]], 
         RowBox[{"F", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "0", "0", "0"},
       {"0", 
        RowBox[{"a", " ", "r", " ", 
         FractionBox["1", 
          RowBox[{"f", "[", "r", "]"}]], 
         RowBox[{"F", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], 
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
           RowBox[{
            RowBox[{"a", "^", "2"}], " ", 
            RowBox[{"B", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], "]"}], 
         FractionBox["4", 
          RowBox[{"g", "[", "a", "]"}]]}], "0", "0", "0"},
       {"0", "0", "0", 
        FractionBox[
         RowBox[{
          RowBox[{"Exp", "[", 
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "]"}], 
          RowBox[{"g", "[", "a", "]"}], 
          RowBox[{"a", "^", "2"}]}], 
         RowBox[{"1", "-", 
          RowBox[{"\[Theta]1", "^", "2"}]}]], "0", "0"},
       {"0", "0", "0", "0", 
        RowBox[{" ", 
         RowBox[{
          RowBox[{"Exp", "[", 
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "]"}], 
          RowBox[{"g", "[", "a", "]"}], 
          RowBox[{"a", "^", "2"}], 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"\[Theta]1", "^", "2"}]}], ")"}]}]}], "0"},
       {"0", "0", "0", "0", "0", 
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{"S", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], "]"}], 
         RowBox[{"g", "[", "a", "]"}], 
         RowBox[{"a", "^", "2"}], 
         RowBox[{"\[Theta]1", "^", "2"}]}]}
      }], ")"}]}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{
    "t", ",", "r", ",", "a", ",", "\[Theta]1", ",", "\[Theta]2", ",", 
     "\[Theta]3"}], "}"}]}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"Nind", "=", 
   RowBox[{"Length", "[", "ind", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"BuildMetric", ";"}]}], "Input",
 CellChangeTimes->{{3.408796998476103*^9, 3.408797030516582*^9}, {
   3.408799071597343*^9, 3.408799082644943*^9}, {3.408949739095245*^9, 
   3.408949739644734*^9}, {3.408949841695282*^9, 3.40894984293303*^9}, {
   3.415862083663703*^9, 3.4158620851642113`*^9}, {3.415862334623486*^9, 
   3.415862336021243*^9}, {3.415862388498528*^9, 3.4158623965197372`*^9}, {
   3.4158641082437763`*^9, 3.415864116357332*^9}, {3.415865034672494*^9, 
   3.415865047473855*^9}, {3.415943026431671*^9, 3.415943056090918*^9}, {
   3.42453089354659*^9, 3.424530981705195*^9}, {3.4262330694486513`*^9, 
   3.426233078224708*^9}, {3.42831552177035*^9, 3.428315531925826*^9}, {
   3.482669504390863*^9, 3.482669559589313*^9}, {3.482669593648382*^9, 
   3.4826696108221407`*^9}, {3.4826696421684*^9, 3.460306349771068*^9}, {
   3.460306681872867*^9, 3.4603066892293873`*^9}, {3.460306743915044*^9, 
   3.460306776656151*^9}, {3.4603068906726713`*^9, 3.4603069154556093`*^9}, 
   3.4606109474491568`*^9, {3.5039972414730186`*^9, 3.503997244123049*^9}, {
   3.5172982618161573`*^9, 3.517298294501769*^9}, {3.517302332920382*^9, 
   3.517302353678054*^9}, {3.51730241996021*^9, 3.517302425934087*^9}, {
   3.517302556663072*^9, 3.5173025584548187`*^9}, 3.517579091871194*^9, {
   3.517642973774815*^9, 3.517642975072443*^9}, 3.517658611602713*^9, {
   3.517660901410638*^9, 3.460392650166881*^9}, {3.4603926980532846`*^9, 
   3.460392722992764*^9}, {3.460396656885631*^9, 3.460356665674651*^9}, {
   3.460356724881654*^9, 3.4603567425493803`*^9}, 3.460372510789526*^9, {
   3.54246967191507*^9, 3.542469701786797*^9}, {3.542469881774507*^9, 
   3.5424699266914043`*^9}, {3.543557353434564*^9, 3.5435573569933662`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"T", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
      SuperscriptBox["r", "2"], " ", 
      RowBox[{"f", "[", "r", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}], ",", "0", ",", "0", ",", "0", ",", 
     "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"A", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{"T", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      SuperscriptBox[
       RowBox[{"f", "[", "r", "]"}], "2"]], ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"f", "[", "r", "]"}]], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"f", "[", "r", "]"}]], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"B", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{"S", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"g", "[", "a", "]"}]], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"1", "-", 
       SuperscriptBox["\[Theta]1", "2"]}]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"S", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
      RowBox[{"g", "[", "a", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"S", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
      SuperscriptBox["\[Theta]1", "2"], " ", 
      RowBox[{"g", "[", "a", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.503310959549301*^9, {3.503311337489339*^9, 3.460515673680585*^9}, 
   3.503996967770006*^9, 3.503997006524664*^9, 3.503997194550593*^9, 
   3.5039972601206627`*^9, 3.504000114145877*^9, 3.5173031733152313`*^9, 
   3.517579162305614*^9, 3.517643121148817*^9, 3.517650908892145*^9, 
   3.517658630210273*^9, 3.5176586899579687`*^9, 3.517660936798641*^9, {
   3.5178236465697403`*^9, 3.517823673129346*^9}, 3.517824230175544*^9, {
   3.517825903545369*^9, 3.460388252816543*^9}, 3.460392747023707*^9, 
   3.460396683141287*^9, 3.4603979125408783`*^9, {3.460444072147172*^9, 
   3.460356776913579*^9}, 3.46036683960192*^9, 3.460372536508292*^9, 
   3.539782999088622*^9, 3.539785140698571*^9, 3.539868426896636*^9, 
   3.53987366371763*^9, 3.542469993839971*^9, 3.5435574187269382`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "t", ",", "r", ",", "a", ",", "\[Theta]1", ",", "\[Theta]2", ",", 
   "\[Theta]3"}], "}"}]], "Output",
 CellChangeTimes->{
  3.503310959549301*^9, {3.503311337489339*^9, 3.460515673680585*^9}, 
   3.503996967770006*^9, 3.503997006524664*^9, 3.503997194550593*^9, 
   3.5039972601206627`*^9, 3.504000114145877*^9, 3.5173031733152313`*^9, 
   3.517579162305614*^9, 3.517643121148817*^9, 3.517650908892145*^9, 
   3.517658630210273*^9, 3.5176586899579687`*^9, 3.517660936798641*^9, {
   3.5178236465697403`*^9, 3.517823673129346*^9}, 3.517824230175544*^9, {
   3.517825903545369*^9, 3.460388252816543*^9}, 3.460392747023707*^9, 
   3.460396683141287*^9, 3.4603979125408783`*^9, {3.460444072147172*^9, 
   3.460356776913579*^9}, 3.46036683960192*^9, 3.460372536508292*^9, 
   3.539782999088622*^9, 3.539785140698571*^9, 3.539868426896636*^9, 
   3.53987366371763*^9, 3.542469993839971*^9, 3.5435574187299557`*^9}],

Cell[BoxData["6"], "Output",
 CellChangeTimes->{
  3.503310959549301*^9, {3.503311337489339*^9, 3.460515673680585*^9}, 
   3.503996967770006*^9, 3.503997006524664*^9, 3.503997194550593*^9, 
   3.5039972601206627`*^9, 3.504000114145877*^9, 3.5173031733152313`*^9, 
   3.517579162305614*^9, 3.517643121148817*^9, 3.517650908892145*^9, 
   3.517658630210273*^9, 3.5176586899579687`*^9, 3.517660936798641*^9, {
   3.5178236465697403`*^9, 3.517823673129346*^9}, 3.517824230175544*^9, {
   3.517825903545369*^9, 3.460388252816543*^9}, 3.460392747023707*^9, 
   3.460396683141287*^9, 3.4603979125408783`*^9, {3.460444072147172*^9, 
   3.460356776913579*^9}, 3.46036683960192*^9, 3.460372536508292*^9, 
   3.539782999088622*^9, 3.539785140698571*^9, 3.539868426896636*^9, 
   3.53987366371763*^9, 3.542469993839971*^9, 3.543557418731536*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Gd"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"T", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
      SuperscriptBox["r", "2"], " ", 
      RowBox[{"f", "[", "r", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}], ",", "0", ",", "0", ",", "0", ",", 
     "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"A", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{"T", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      SuperscriptBox[
       RowBox[{"f", "[", "r", "]"}], "2"]], ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"f", "[", "r", "]"}]], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"f", "[", "r", "]"}]], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"B", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{"S", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"g", "[", "a", "]"}]], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"1", "-", 
       SuperscriptBox["\[Theta]1", "2"]}]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"S", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
      RowBox[{"g", "[", "a", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"S", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
      SuperscriptBox["\[Theta]1", "2"], " ", 
      RowBox[{"g", "[", "a", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.503310960896533*^9, {3.503311337815158*^9, 3.460515673971971*^9}, 
   3.5039970068865147`*^9, 3.503997194708459*^9, 3.5039972603113403`*^9, 
   3.504000114400865*^9, 3.517303175045021*^9, 3.517579163377042*^9, 
   3.517643122943182*^9, 3.517650911147537*^9, 3.517658631401002*^9, 
   3.5176586910877733`*^9, 3.517660938714964*^9, {3.5178236483503*^9, 
   3.517823675003542*^9}, 3.517824232021847*^9, {3.517825905567346*^9, 
   3.460388255822893*^9}, 3.460392749914061*^9, 3.460396684871089*^9, 
   3.460397914257712*^9, {3.460444073869268*^9, 3.4603567785893793`*^9}, 
   3.4603668412999907`*^9, 3.4603725377778482`*^9, 3.53978299993473*^9, 
   3.539785141532104*^9, 3.539868428003755*^9, 3.539873664479189*^9, 
   3.542469994931801*^9, 3.54355741966752*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Gu"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        RowBox[{"T", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], 
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"f", "[", "r", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]], ",", "0", ",", "0", ",", "0", ",", 
     "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"f", "[", "r", "]"}], "2"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], " ", 
             RowBox[{"B", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
            RowBox[{"S", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"F", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
          RowBox[{"g", "[", "a", "]"}]}]}], ")"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]], ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"f", "[", "r", "]"}], " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"g", "[", "a", "]"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"B", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{"S", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"F", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
          RowBox[{"g", "[", "a", "]"}]}]}], ")"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]], ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"f", "[", "r", "]"}], " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"g", "[", "a", "]"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"B", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{"S", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"F", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
          RowBox[{"g", "[", "a", "]"}]}]}], ")"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]], ",", 
     FractionBox["1", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["r", "2"]}], " ", 
           RowBox[{"A", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
          RowBox[{"T", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
        SuperscriptBox["r", "2"], " ", 
        SuperscriptBox[
         RowBox[{"F", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], "+", 
       FractionBox[
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"B", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
         RowBox[{"\[CapitalDelta]", "[", 
          RowBox[{"r", ",", "a"}], "]"}]}], 
        RowBox[{"g", "[", "a", "]"}]]}]], ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", 
          RowBox[{"S", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[Theta]1", "2"]}], ")"}]}], 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"g", "[", "a", "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}]]}], ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", 
         RowBox[{"S", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
        RowBox[{"g", "[", "a", "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}]]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[Theta]1", "2"], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.503310961019191*^9, {3.503311337909677*^9, 3.4605156740447407`*^9}, 
   3.503997006988311*^9, 3.503997194814143*^9, 3.503997260416914*^9, 
   3.504000114475375*^9, 3.517303175100889*^9, 3.517579163432994*^9, 
   3.517643123023747*^9, 3.517650911238832*^9, 3.51765863146119*^9, 
   3.517658691190091*^9, 3.517660938769685*^9, {3.5178236484356413`*^9, 
   3.5178236750627403`*^9}, 3.517824232072446*^9, {3.517825905652813*^9, 
   3.4603882558830748`*^9}, 3.460392749990233*^9, 3.460396684946187*^9, 
   3.4603979143251343`*^9, {3.460444073966957*^9, 3.460356778642264*^9}, 
   3.460366841369574*^9, 3.46037253785017*^9, 3.539783000016053*^9, 
   3.539785141583846*^9, 3.5398684281973343`*^9, 3.539873664512268*^9, 
   3.5424699949810038`*^9, 3.543557419750058*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"detg", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Det", "[", "Gd", "]"}], "]"}]}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["a", "6"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"3", " ", 
      RowBox[{"S", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
     RowBox[{"T", "[", 
      RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
   SuperscriptBox["r", "2"], " ", 
   SuperscriptBox["\[Theta]1", "2"], " ", 
   SuperscriptBox[
    RowBox[{"g", "[", "a", "]"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"A", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"B", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
        RowBox[{"T", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["r", "2"], " ", 
      SuperscriptBox[
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
      RowBox[{"g", "[", "a", "]"}]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"\[CapitalDelta]", "[", 
     RowBox[{"r", ",", "a"}], "]"}], "6"]}], 
  RowBox[{"f", "[", "r", "]"}]]], "Output",
 CellChangeTimes->{
  3.503310961169602*^9, {3.50331133798626*^9, 3.460515674108046*^9}, 
   3.503997007085783*^9, 3.5039971949056797`*^9, 3.503997260515153*^9, 
   3.504000114556445*^9, 3.517303175159586*^9, 3.517579163516987*^9, 
   3.5176431231240063`*^9, 3.517650911347453*^9, 3.517658631527398*^9, 
   3.51765869125694*^9, 3.517660938861404*^9, {3.517823648499422*^9, 
   3.51782367514461*^9}, 3.5178242321377687`*^9, {3.517825905766419*^9, 
   3.460388255960024*^9}, 3.460392750055771*^9, 3.460396684996212*^9, 
   3.460397914370763*^9, {3.460444074039672*^9, 3.460356778687825*^9}, 
   3.460366841502103*^9, 3.460372537983058*^9, 3.53978300013131*^9, 
   3.539785141639271*^9, 3.539868428328937*^9, 3.539873664562046*^9, 
   3.542469995075811*^9, 3.543557419830435*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRrun2.nb", "Subsubtitle"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\[CapitalGamma]", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"\[CapitalGamma]", ",", "3", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "u"}], "}"}]}], "]"}], ";"}], "\n"}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R4", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R4", ",", "4", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "d", ",", "u"}], "}"}]}], "]"}], 
  ";"}], "\n"}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "G2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"G2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"\[CapitalGamma]", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"\[CapitalGamma]", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], 
         RowBox[{"GT", "[", 
          RowBox[{"G", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
            "}"}]}], "]"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "+", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "ss1", "]"}], "]"}]}], "]"}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalGamma]", "=", 
   RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.426232729469757*^9, 3.426232735540435*^9}}],

Cell[BoxData[
 RowBox[{"Do", "[", "\n", "\t", 
  RowBox[{
   RowBox[{"R4", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R4", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      "\n", "\t", "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "+", "\n", "\t\t\t", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}]}], "\n", 
     "\t\t", "\n", "\t\t", "]"}]}], "\n", "\t\t", ",", "\n", "\t", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i4", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R4", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"R2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"GT", "[", 
         RowBox[{"R4", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}],
          "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "\n", 
     "\t\t", "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"GT", "[", 
      RowBox[{"R2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"G2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"G2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"GT", "[", 
        RowBox[{"R2", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
        "]"}], "-", 
       RowBox[{
        FractionBox["1", "2"], 
        RowBox[{"GT", "[", 
         RowBox[{"G", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
         "]"}], "Ricci"}]}]}], "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "G2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "Ricci", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"]
}, Closed]],

Cell[CellGroupData[{

Cell["Einstein equations", "Subsubtitle"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalDelta]", "[", 
    RowBox[{"r_", ",", "a_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     FractionBox[
      RowBox[{" ", "1"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"a", "^", "2"}]}], ")"}], "+", 
       RowBox[{"rh", " ", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"r", "^", "2"}]}], ")"}], "]"}]}]}]], ")"}], "^", "2"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "r_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"r", "^", "2"}]}], ")"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g", "[", "a_", "]"}], ":=", 
  RowBox[{"2", "-", 
   RowBox[{"a", "^", "2"}]}]}]}], "Input",
 CellChangeTimes->{{3.503997037073781*^9, 3.503997076077972*^9}, {
   3.503997256891058*^9, 3.4603927524745617`*^9}, {3.460396639861096*^9, 
   3.4603966466740303`*^9}, {3.460397369545499*^9, 3.460397369641325*^9}, 
   3.542471512037649*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{"\[CapitalDelta]", "[", 
    RowBox[{"r", ",", "a"}], "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.495182286304566*^9, 3.495182316261655*^9}, {
  3.503997272569343*^9, 3.4603966815174828`*^9}}],

Cell["Power(1 - Power(a,2) + Sqrt(1 - Power(r,2))*rh,-2)", "Output",
 CellChangeTimes->{
  3.503310996102426*^9, 3.5033113741197977`*^9, 3.503997228128545*^9, {
   3.503997279270112*^9, 3.5039972907004004`*^9}, 3.517303241353507*^9, 
   3.517579191292143*^9, 3.517643158630046*^9, 3.517650952101787*^9, 
   3.517658661413351*^9, 3.517660980149918*^9, 3.517824268227845*^9, {
   3.51782594256693*^9, 3.460388309853869*^9}, 3.460392792367641*^9, 
   3.4603967346191587`*^9, 3.460396770208337*^9, 3.460397373597575*^9, 
   3.4603979637516327`*^9, {3.460444124578642*^9, 3.460356825685725*^9}, 
   3.460366890206985*^9, 3.460372585956767*^9, 3.53978301581916*^9, 
   3.542470021281004*^9, 3.5424715140103807`*^9, 3.542475296593664*^9, 
   3.543557440496995*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"\[CapitalDelta]", "[", 
      RowBox[{"r", ",", "a"}], "]"}], ",", "r"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{3.4603966934425793`*^9}],

Cell["\<\
(2*r*rh)/(Sqrt(1 - Power(r,2))*Power(1 - Power(a,2) + Sqrt(1 - \
Power(r,2))*rh,3))\
\>", "Output",
 CellChangeTimes->{
  3.4603967346894608`*^9, 3.460396771124436*^9, 3.460397374266717*^9, 
   3.4603979638301573`*^9, {3.460444124654269*^9, 3.460356825727166*^9}, 
   3.460366890263295*^9, 3.460372586008257*^9, 3.539783015858795*^9, 
   3.54247002192407*^9, 3.542471514760674*^9, 3.542475297275634*^9, 
   3.543557440533538*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"\[CapitalDelta]", "[", 
      RowBox[{"r", ",", "a"}], "]"}], ",", "a"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.495182324518956*^9, {3.503997277336896*^9, 3.460396687296332*^9}}],

Cell["(4*a)/Power(1 - Power(a,2) + Sqrt(1 - Power(r,2))*rh,3)", "Output",
 CellChangeTimes->{
  3.503310996611804*^9, 3.5033113742253036`*^9, 3.5039972306695004`*^9, 
   3.5039972912011633`*^9, 3.517303241981659*^9, 3.5175791913426123`*^9, 
   3.5176431586803913`*^9, 3.517650952166638*^9, 3.517658661473048*^9, 
   3.517660980259284*^9, 3.517824268287916*^9, {3.517825942643841*^9, 
   3.4603883098918533`*^9}, 3.460392792453087*^9, 3.460396734793695*^9, 
   3.460396771889118*^9, 3.4603973749808598`*^9, 3.4603979639137297`*^9, {
   3.460444124741806*^9, 3.460356825776784*^9}, 3.4603668903009863`*^9, 
   3.4603725860817738`*^9, 3.539783015967268*^9, 3.542470022525893*^9, 
   3.5424715154933777`*^9, 3.542475297993924*^9, 3.5435574405771637`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"\[CapitalDelta]", "[", 
      RowBox[{"r", ",", "a"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "2"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{3.460396699482765*^9}],

Cell["\<\
(2*rh*(1 - Power(a,2) + Sqrt(1 - Power(r,2))*(1 + 3*Power(r,2))*rh))/(Power(1 \
- Power(r,2),1.5)*Power(1 - Power(a,2) + Sqrt(1 - Power(r,2))*rh,4))\
\>", "Output",
 CellChangeTimes->{
  3.460396734885148*^9, 3.460396772605576*^9, 3.4603973757244453`*^9, 
   3.460397963996324*^9, {3.460444124839486*^9, 3.460356825827559*^9}, 
   3.460366890347027*^9, 3.460372586164962*^9, 3.539783016097213*^9, 
   3.5424700231614532`*^9, 3.542471516254243*^9, 3.5424752986614523`*^9, 
   3.5435574406261663`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"\[CapitalDelta]", "[", 
      RowBox[{"r", ",", "a"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "2"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.4951823290378923`*^9, 3.495182330774173*^9}, {
  3.5039972841977863`*^9, 3.460396689232386*^9}}],

Cell["\<\
(4*(1 + 5*Power(a,2) + Sqrt(1 - Power(r,2))*rh))/Power(1 - Power(a,2) + \
Sqrt(1 - Power(r,2))*rh,4)\
\>", "Output",
 CellChangeTimes->{
  3.503310996775799*^9, 3.503311374369062*^9, 3.503997232218389*^9, 
   3.503997291632564*^9, 3.517303242397684*^9, 3.5175791913918343`*^9, 
   3.517643158747458*^9, 3.517650952233596*^9, 3.517658661557768*^9, 
   3.517660980330935*^9, 3.5178242683641*^9, {3.51782594272474*^9, 
   3.460388309944561*^9}, 3.4603927925495462`*^9, 3.460396734993875*^9, 
   3.460396773237878*^9, 3.4603973763029203`*^9, 3.4603979640791597`*^9, {
   3.46044412492558*^9, 3.460356825877578*^9}, 3.460366890396433*^9, 
   3.460372586248437*^9, 3.539783016309095*^9, 3.542470023777834*^9, 
   3.542471516947101*^9, 3.542475299414824*^9, 3.543557440666037*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}], ",", "r"}], "]"}], ",", "a"}], "]"}], 
   "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.460396706059194*^9, 3.4603967153051167`*^9}}],

Cell["\<\
(12*a*r*rh)/(Sqrt(1 - Power(r,2))*Power(1 - Power(a,2) + Sqrt(1 - \
Power(r,2))*rh,4))\
\>", "Output",
 CellChangeTimes->{
  3.4603967739136333`*^9, 3.460397377015764*^9, 3.460397964162476*^9, {
   3.46044412501836*^9, 3.460356825927038*^9}, 3.460366890500286*^9, 
   3.460372586331909*^9, 3.539783016461114*^9, 3.542470024445664*^9, 
   3.542471517664502*^9, 3.542475300280547*^9, 3.543557440700095*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{"f", "[", "r", "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.495182286304566*^9, 3.495182316261655*^9}, {
  3.495182467679225*^9, 3.46039275783316*^9}}],

Cell["1 - Power(r,2)", "Output",
 CellChangeTimes->{
  3.503310996908019*^9, 3.503311374879593*^9, 3.503997233300832*^9, 
   3.503997292083259*^9, 3.517303242881014*^9, 3.5175791914423313`*^9, 
   3.517643158811143*^9, 3.517650952300398*^9, 3.517658661622953*^9, 
   3.517660980408761*^9, 3.51782426844166*^9, {3.5178259428269377`*^9, 
   3.460388310014579*^9}, 3.460392792636108*^9, 3.460396774653295*^9, 
   3.460397964245742*^9, {3.460444125086138*^9, 3.4603568259761963`*^9}, 
   3.460366890633319*^9, 3.460372586414815*^9, 3.539783016531856*^9, 
   3.5424700250801992`*^9, 3.542471518615855*^9, 3.543557440736858*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"f", "'"}], "[", "r", "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.495182472838019*^9, 3.460392760921238*^9}}],

Cell["-2*r", "Output",
 CellChangeTimes->{
  3.503310996965783*^9, 3.5033113749913073`*^9, 3.503997234248814*^9, 
   3.50399729256497*^9, 3.517303243330184*^9, 3.517579191492313*^9, 
   3.517643158880645*^9, 3.517650952366993*^9, 3.517658661688716*^9, 
   3.517660980481185*^9, 3.517824268640936*^9, {3.517825942927206*^9, 
   3.460388310080756*^9}, 3.460392792734129*^9, 3.460396775353087*^9, 
   3.4603979643580303`*^9, {3.4604441251522083`*^9, 3.460356826026689*^9}, 
   3.460366890681685*^9, 3.460372586511404*^9, 3.53978301661082*^9, 
   3.542470025764917*^9, 3.5424715191675663`*^9, 3.5435574407862673`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"f", "''"}], "[", "r", "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.495182483750815*^9, 3.4603927635933533`*^9}}],

Cell["-2", "Output",
 CellChangeTimes->{
  3.503310997024472*^9, 3.503311375066978*^9, 3.503997234849133*^9, 
   3.503997293048607*^9, 3.5173032438293867`*^9, 3.517579191555608*^9, 
   3.517643158947215*^9, 3.517650952433901*^9, 3.517658661907147*^9, 
   3.5176609807702847`*^9, 3.51782426870553*^9, {3.517825943026388*^9, 
   3.460388310147313*^9}, 3.4603927928192453`*^9, 3.4603967760685997`*^9, 
   3.460397964440173*^9, {3.460444125236292*^9, 3.460356826075963*^9}, 
   3.4603668907314177`*^9, 3.4603725865942507`*^9, 3.5397830167746143`*^9, 
   3.542470026452227*^9, 3.542471519720146*^9, 3.543557440834312*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{"g", "[", "a", "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.495182286304566*^9, 3.495182316261655*^9}, {
  3.495182467679225*^9, 3.495182507949469*^9}}],

Cell["2 - Power(a,2)", "Output",
 CellChangeTimes->{
  3.503310997266829*^9, 3.503311375422978*^9, 3.503997236530881*^9, 
   3.503997295412294*^9, 3.517303245944564*^9, 3.517579191925013*^9, 
   3.517643159296781*^9, 3.5176509528998833`*^9, 3.517658662174065*^9, 
   3.517660981145893*^9, 3.517824268963705*^9, {3.517825943568527*^9, 
   3.460388310413842*^9}, 3.4603927929015913`*^9, 3.460396777817959*^9, 
   3.4603979645404453`*^9, {3.460444125301704*^9, 3.460356826126771*^9}, 
   3.460366890777458*^9, 3.46037258667807*^9, 3.539783016794743*^9, 
   3.542470027100696*^9, 3.5424715202239037`*^9, 3.543557440874839*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"g", "'"}], "[", "a", "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.495182472838019*^9, 3.4951825108854933`*^9}}],

Cell["-2*a", "Output",
 CellChangeTimes->{
  3.503310997314372*^9, 3.5033113754864283`*^9, 3.503997237064632*^9, 
   3.503997295978795*^9, 3.517303246410819*^9, 3.517579191974955*^9, 
   3.517643159348069*^9, 3.517650952966544*^9, 3.517658662238484*^9, 
   3.517660981244028*^9, 3.517824269037717*^9, {3.517825943674107*^9, 
   3.460388310567745*^9}, 3.460392792998417*^9, 3.4603967785324717`*^9, 
   3.4603979647422323`*^9, {3.46044412538582*^9, 3.460356826176135*^9}, 
   3.460366890827784*^9, 3.460372586760797*^9, 3.539783016817659*^9, 
   3.5424700278025227`*^9, 3.5424715207036037`*^9, 3.543557440917399*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"g", "''"}], "[", "a", "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.495182483750815*^9, 3.495182512437488*^9}}],

Cell["-2", "Output",
 CellChangeTimes->{
  3.503310997402102*^9, 3.503311375577376*^9, 3.503997237546672*^9, 
   3.5039972964768867`*^9, 3.5173032469105377`*^9, 3.517579192025198*^9, 
   3.517643159398725*^9, 3.517650953033245*^9, 3.5176586623058453`*^9, 
   3.517660981325623*^9, 3.517824269109634*^9, {3.517825943759248*^9, 
   3.4603883106309137`*^9}, 3.460392793085101*^9, 3.460396779199339*^9, 
   3.460397964840487*^9, {3.4604441254687366`*^9, 3.460356826226657*^9}, 
   3.4603668908780823`*^9, 3.460372586844584*^9, 3.539783016861774*^9, 
   3.542470028519656*^9, 3.542471521288033*^9, 3.543557440956662*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{
  "\[CapitalDelta]", ",", "f", ",", "g", ",", "T", ",", "A", ",", "B", ",", 
   "S", ",", "F"}], "]"}]], "Input",
 CellChangeTimes->{{3.482669833339856*^9, 3.460307046941224*^9}, {
  3.460392774501875*^9, 3.460392775001577*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalGamma]0", "=", 
   RowBox[{"\[CapitalGamma]", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"T", "\[Rule]", "T0"}], ",", 
      RowBox[{"A", "\[Rule]", "A0"}], ",", 
      RowBox[{"B", "\[Rule]", "B0"}], ",", 
      RowBox[{"F", "\[Rule]", "F0"}], ",", 
      RowBox[{"S", "\[Rule]", "S0"}]}], "}"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4262303165893497`*^9, 3.4262303398602133`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"T0", "[", 
     RowBox[{"l_", ",", "r_", ",", "a_"}], "]"}], ":=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"A0", "[", 
     RowBox[{"l_", ",", "r_", ",", "a_"}], "]"}], ":=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"B0", "[", 
     RowBox[{"l_", ",", "r_", ",", "a_"}], "]"}], ":=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"F0", "[", 
     RowBox[{"l_", ",", "r_", ",", "a_"}], "]"}], ":=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S0", "[", 
    RowBox[{"l_", ",", "r_", ",", "a_"}], "]"}], ":=", "0"}], ";"}]}], "Input",
 CellChangeTimes->{{3.503310951416149*^9, 3.503310951601446*^9}, {
  3.503311020210663*^9, 3.503311029174612*^9}, {3.517303252550393*^9, 
  3.517303255622281*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalGamma]0", "=", 
   RowBox[{"FullSimplify", "[", "\[CapitalGamma]0", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.503312805308928*^9, 3.5033128199192266`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "d\[CapitalGamma]", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"d\[CapitalGamma]", ",", "3", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "u"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.426229921816812*^9, 3.426229934732215*^9}},
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"d\[CapitalGamma]", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"d\[CapitalGamma]", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"GT", "[", 
        RowBox[{"\[CapitalGamma]", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}], 
        "]"}], "-", 
       RowBox[{"GT", "[", 
        RowBox[{"\[CapitalGamma]0", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}], 
        "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4262299354328623`*^9, 3.42622996641691*^9}},
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "H", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"H", ",", "1", ",", 
     RowBox[{"{", "d", "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"H", "=", 
      RowBox[{"ST", "[", 
       RowBox[{"H", ",", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"i1", ",", "d"}], "}"}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"-", " ", 
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"d\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"s1", ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"s1", ",", "u"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"i1", ",", "d"}], "}"}]}], "}"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"s1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}]}], 
       "\[IndentingNewLine]", "]"}]}], ";"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4087970943172693`*^9, 3.408797098931541*^9}, {
   3.408973656013672*^9, 3.408973660142764*^9}, 3.418456476392524*^9, {
   3.426229975319216*^9, 3.426229983437986*^9}, {3.426230701065813*^9, 
   3.426230703285982*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"H", "=", 
  RowBox[{"Simplify", "[", "H", "]"}]}]], "Input",
 CellChangeTimes->{
  3.460397912220345*^9, {3.460397977077539*^9, 3.460397998480888*^9}, {
   3.460398042616012*^9, 3.460398043148725*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "d", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
          RowBox[{"T", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"r", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              SuperscriptBox["a", "2"], " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{"S", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                RowBox[{"T", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"A", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], ")"}], " ", 
              SuperscriptBox["r", "2"], " ", 
              SuperscriptBox[
               RowBox[{"F", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
              RowBox[{"g", "[", "a", "]"}], " ", 
              RowBox[{"\[CapitalDelta]", "[", 
               RowBox[{"r", ",", "a"}], "]"}], " ", 
              RowBox[{
               SuperscriptBox["f", "\[Prime]",
                MultilineFunction->None], "[", "r", "]"}]}], "+", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              SuperscriptBox["r", "3"], " ", 
              SuperscriptBox[
               RowBox[{"F", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}], "3"], " ", 
              RowBox[{"g", "[", "a", "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"3", " ", "a", " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{"T", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
                 RowBox[{"\[CapitalDelta]", "[", 
                  RowBox[{"r", ",", "a"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["g", "\[Prime]",
                   MultilineFunction->None], "[", "a", "]"}]}], "+", 
                RowBox[{
                 RowBox[{"g", "[", "a", "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"6", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
                    RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"a", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]]}]}], ")"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
             "-", 
             RowBox[{"8", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["r", "2"], " ", 
                 RowBox[{"A", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                RowBox[{"S", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                RowBox[{"2", " ", 
                 RowBox[{"T", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}]], " ", 
              RowBox[{"\[CapitalDelta]", "[", 
               RowBox[{"r", ",", "a"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], ")"}], " ", 
                 RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                   MultilineFunction->None], "[", "r", "]"}]}], "+", 
                RowBox[{"a", " ", "r", " ", 
                 RowBox[{"g", "[", "a", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["F", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{"S", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                RowBox[{"T", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", " ", 
              RowBox[{"F", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "a"}], " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                 " ", 
                 RowBox[{"\[CapitalDelta]", "[", 
                  RowBox[{"r", ",", "a"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["g", "\[Prime]",
                   MultilineFunction->None], "[", "a", "]"}]}], "-", 
                RowBox[{
                 RowBox[{"g", "[", "a", "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"a", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                    " ", 
                    RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                    RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
                    RowBox[{"a", " ", 
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                    RowBox[{"a", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                  ")"}]}]}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
           RowBox[{"f", "[", "r", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                   RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "5"}], " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}]}], 
                "-", 
                RowBox[{
                 SuperscriptBox["a", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "6"}], " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]]}], "+", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                 " ", 
                 SuperscriptBox["r", "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"F", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
                 RowBox[{"g", "[", "a", "]"}]}]}], ")"}], " ", 
              RowBox[{
               SuperscriptBox["\[CapitalDelta]", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"r", ",", "a"}], "]"}]}], "+", 
             RowBox[{
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"S", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
              RowBox[{"\[CapitalDelta]", "[", 
               RowBox[{"r", ",", "a"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"8", " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                   RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                 SuperscriptBox["r", "2"], " ", 
                 RowBox[{"A", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                   RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                   RowBox[{
                    SuperscriptBox["r", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", "r", " ", 
                    RowBox[{
                    SuperscriptBox["B", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                   RowBox[{"4", " ", "r", " ", 
                    RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}], 
                "+", 
                RowBox[{
                 SuperscriptBox["a", "2"], " ", 
                 SuperscriptBox["r", "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"F", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
                 RowBox[{"g", "[", "a", "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"2", "-", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                   RowBox[{"3", " ", "r", " ", 
                    RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
               ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"8", " ", "r", " ", 
        RowBox[{"f", "[", "r", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"A", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              RowBox[{"B", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{"S", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
             RowBox[{"T", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox[
            RowBox[{"F", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
           RowBox[{"g", "[", "a", "]"}]}]}], ")"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
          RowBox[{"T", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "12"}], " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"A", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              RowBox[{"B", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"S", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                RowBox[{"T", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], ")"}]}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               RowBox[{"B", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], ")"}], " ", 
           RowBox[{"\[CapitalDelta]", "[", 
            RowBox[{"r", ",", "a"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["g", "\[Prime]",
             MultilineFunction->None], "[", "a", "]"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox[
            RowBox[{"F", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
           SuperscriptBox[
            RowBox[{"g", "[", "a", "]"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "-", 
                   RowBox[{"6", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]]}], "+", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                 " ", 
                 RowBox[{
                  SuperscriptBox["\[CapitalDelta]", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                RowBox[{"a", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]], "+", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]]}]}], ")"}], " ",
                  "r", " ", 
                 RowBox[{"f", "[", "r", "]"}], " ", 
                 RowBox[{"F", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["\[CapitalDelta]", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"S", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
              RowBox[{"\[CapitalDelta]", "[", 
               RowBox[{"r", ",", "a"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 SuperscriptBox["a", "2"], " ", 
                 RowBox[{"f", "[", "r", "]"}], " ", 
                 RowBox[{"F", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "r", " ", 
                 RowBox[{"F", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                   MultilineFunction->None], "[", "r", "]"}]}], "+", 
                RowBox[{
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{"T", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "6"}], "+", 
                   RowBox[{"6", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
                   RowBox[{"3", " ", "a", " ", 
                    RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                   RowBox[{"a", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
               ")"}]}]}], ")"}]}], "-", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"S", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
             RowBox[{"T", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
           RowBox[{"g", "[", "a", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", "a", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "-", 
                   RowBox[{"5", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                 " ", 
                 RowBox[{
                  SuperscriptBox["\[CapitalDelta]", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                RowBox[{"a", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                 " ", "r", " ", 
                 RowBox[{"f", "[", "r", "]"}], " ", 
                 RowBox[{"F", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["\[CapitalDelta]", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"\[CapitalDelta]", "[", 
               RowBox[{"r", ",", "a"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "24"}], " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                   RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                RowBox[{"24", " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                   RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                RowBox[{"8", " ", 
                 SuperscriptBox["a", "2"], " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                   RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                 RowBox[{"B", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["a", "2"], " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", 
                 " ", 
                 RowBox[{"F", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                   MultilineFunction->None], "[", "r", "]"}]}], "+", 
                RowBox[{"3", " ", 
                 SuperscriptBox["a", "3"], " ", 
                 SuperscriptBox["r", "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"F", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
                 RowBox[{
                  SuperscriptBox["g", "\[Prime]",
                   MultilineFunction->None], "[", "a", "]"}]}], "-", 
                RowBox[{"3", " ", 
                 SuperscriptBox["a", "3"], " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                 SuperscriptBox["r", "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"F", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
                 RowBox[{
                  SuperscriptBox["g", "\[Prime]",
                   MultilineFunction->None], "[", "a", "]"}]}], "-", 
                RowBox[{"4", " ", "a", " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                   RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                 SuperscriptBox["r", "2"], " ", 
                 RowBox[{
                  SuperscriptBox["A", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["a", "3"], " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                   RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                 RowBox[{
                  SuperscriptBox["B", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                RowBox[{"8", " ", "a", " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                   RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                 RowBox[{
                  SuperscriptBox["S", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                RowBox[{"8", " ", "a", " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                   RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                 RowBox[{
                  SuperscriptBox["T", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                RowBox[{"8", " ", 
                 SuperscriptBox["a", "2"], " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                 RowBox[{"f", "[", "r", "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "r"}], " ", 
                    RowBox[{
                    SuperscriptBox["F", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{
                    RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "-", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", "r", " ", 
                    RowBox[{
                    SuperscriptBox["B", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                  ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", " ", "a", " ", 
        RowBox[{"g", "[", "a", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"A", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              RowBox[{"B", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{"S", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
             RowBox[{"T", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox[
            RowBox[{"F", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
           RowBox[{"g", "[", "a", "]"}]}]}], ")"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], ")"}]}], ",", "0", ",", "0", ",", 
     "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.4603979665130053`*^9, 3.460397988590868*^9}, {
   3.4603980408828487`*^9, 3.460398044252734*^9}, {3.46044413277184*^9, 
   3.460356833221119*^9}, 3.460366898171053*^9, 3.460372593850625*^9, 
   3.542470040921711*^9, 3.543557444921175*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Htmp", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "d", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "hr", ",", "ha", ",", "0", ",", "0", ",", "0"}], 
       "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"phi", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"trT", "[", 
    RowBox[{
     RowBox[{"outerT", "[", 
      RowBox[{"Htmp", ",", "Htmp"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.460444144767435*^9, 3.460444175048345*^9}, {
  3.542470055520176*^9, 3.5424700562158747`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"4", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"B", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
      RowBox[{"S", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
    SuperscriptBox["hr", "2"], " ", 
    SuperscriptBox[
     RowBox[{"f", "[", "r", "]"}], "2"]}], "+", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"A", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
      RowBox[{"T", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
    SuperscriptBox["ha", "2"], " ", 
    RowBox[{"g", "[", "a", "]"}]}], "-", 
   RowBox[{"2", " ", "a", " ", "ha", " ", "hr", " ", "r", " ", 
    RowBox[{"f", "[", "r", "]"}], " ", 
    RowBox[{"F", "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
    RowBox[{"g", "[", "a", "]"}]}]}], 
  RowBox[{
   RowBox[{"4", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"A", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"B", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
      RowBox[{"S", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
      RowBox[{"T", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
    RowBox[{"\[CapitalDelta]", "[", 
     RowBox[{"r", ",", "a"}], "]"}]}], "-", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox["r", "2"], " ", 
    SuperscriptBox[
     RowBox[{"F", "[", 
      RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
    RowBox[{"g", "[", "a", "]"}], " ", 
    RowBox[{"\[CapitalDelta]", "[", 
     RowBox[{"r", ",", "a"}], "]"}]}]}]]], "Output",
 CellChangeTimes->{{3.460444157205353*^9, 3.460356833417321*^9}, 
   3.460366898545617*^9, 3.460372594065666*^9, {3.5424700439024754`*^9, 
   3.542470056946002*^9}, 3.5435574450328503`*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "dH", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"dH", ",", "2", ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"dH", "=", 
      RowBox[{"ST", "[", 
       RowBox[{"dH", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i1", ",", "d"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i2", ",", "d"}], "}"}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         FractionBox["1", "2"], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"H", ",", 
               RowBox[{"{", 
                RowBox[{"{", 
                 RowBox[{"i1", ",", "d"}], "}"}], "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
           RowBox[{"Sum", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"GT", "[", 
               RowBox[{"\[CapitalGamma]", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"i1", ",", "d"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"i2", ",", "d"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"s1", ",", "u"}], "}"}]}], "}"}]}], "]"}], 
              RowBox[{"GT", "[", 
               RowBox[{"H", ",", 
                RowBox[{"{", 
                 RowBox[{"{", 
                  RowBox[{"s1", ",", "d"}], "}"}], "}"}]}], "]"}]}], ",", 
             RowBox[{"{", 
              RowBox[{"s1", ",", "1", ",", "Nind"}], "}"}]}], "]"}], 
           "\[IndentingNewLine]", "+", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"H", ",", 
               RowBox[{"{", 
                RowBox[{"{", 
                 RowBox[{"i2", ",", "d"}], "}"}], "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
           RowBox[{"Sum", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"GT", "[", 
               RowBox[{"\[CapitalGamma]", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"i2", ",", "d"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"i1", ",", "d"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"s1", ",", "u"}], "}"}]}], "}"}]}], "]"}], 
              RowBox[{"GT", "[", 
               RowBox[{"H", ",", 
                RowBox[{"{", 
                 RowBox[{"{", 
                  RowBox[{"s1", ",", "d"}], "}"}], "}"}]}], "]"}]}], ",", 
             RowBox[{"{", 
              RowBox[{"s1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], 
          ")"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.4089514759929943`*^9, {3.5178237067967873`*^9, 3.51782372377859*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "RF1", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"RF1", ",", "2", ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RF1", "=", 
      RowBox[{"ST", "[", 
       RowBox[{"RF1", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i1", ",", "d"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i2", ",", "d"}], "}"}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"G", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"i1", ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"i2", ",", "d"}], "}"}]}], "}"}]}], "]"}], ",", "l"}],
           "]"}], "+", 
         RowBox[{"2", 
          RowBox[{"(", " ", 
           RowBox[{
            RowBox[{"GT", "[", 
             RowBox[{"R2", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"i1", ",", "d"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"i2", ",", "d"}], "}"}]}], "}"}]}], "]"}], "-", 
            RowBox[{"\[CapitalLambda]", " ", 
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"i1", ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"i2", ",", "d"}], "}"}]}], "}"}]}], "]"}]}], "+", 
            " ", 
            RowBox[{"GT", "[", 
             RowBox[{"dH", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"i1", ",", "d"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"i2", ",", "d"}], "}"}]}], "}"}]}], "]"}]}], " ", 
           ")"}]}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.408797573844262*^9, 3.40879762198135*^9}, {
   3.408799327901697*^9, 3.408799351292495*^9}, {3.408800985564945*^9, 
   3.4088009869407597`*^9}, {3.415861529562262*^9, 3.415861529788752*^9}, {
   3.424671218939474*^9, 3.424671225137734*^9}, {3.424671979395668*^9, 
   3.4246719876901283`*^9}, 3.424673490236145*^9, {3.4262333235748873`*^9, 
   3.426233329767264*^9}, {3.431855626568253*^9, 3.4318556468627462`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"T", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "T"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Tl"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Tr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Ta"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Trr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Taa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Tra"}], ",", 
     RowBox[{
      RowBox[{"A", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "A"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Al"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Ar"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Aa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Arr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Aaa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Ara"}], ",", 
     RowBox[{
      RowBox[{"B", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "B"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Bl"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Br"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Ba"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Brr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Baa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Bra"}], ",", 
     RowBox[{
      RowBox[{"F", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "F"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Fl"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Fr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Fa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Frr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Faa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Fra"}], ",", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "S"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Sl"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Sr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Sa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Srr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Saa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Sra"}], ",", 
     RowBox[{
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "L"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalDelta]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "Lr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalDelta]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "Lrr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalDelta]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "La"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalDelta]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "Laa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalDelta]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "Lra"}], ",", 
     RowBox[{
      RowBox[{"f", "[", "r", "]"}], "\[Rule]", "f"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "r", "]"}], "\[Rule]", "fr"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "''"}], "[", "r", "]"}], "\[Rule]", "frr"}], ",", 
     RowBox[{
      RowBox[{"g", "[", "a", "]"}], "\[Rule]", "g"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"g", "'"}], "[", "a", "]"}], "\[Rule]", "ga"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"g", "''"}], "[", "a", "]"}], "\[Rule]", "gaa"}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.426233462410046*^9, 3.426233529934688*^9}, {
   3.426425823867654*^9, 3.426425926949801*^9}, {3.460305912394334*^9, 
   3.460306053671014*^9}, {3.460307114041431*^9, 3.460307131380796*^9}, {
   3.5033115682122517`*^9, 3.503311569834202*^9}, {3.504000155601179*^9, 
   3.504000163012282*^9}, {3.517581414802555*^9, 3.517581424098625*^9}, 
   3.517824243782352*^9, {3.5178251206831512`*^9, 3.460392807343815*^9}, {
   3.460396802022485*^9, 3.460396867528345*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"H", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "2"}], "]"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Exp", "[", "x_", "]"}], "\[Rule]", 
      RowBox[{"exp", "[", "x", "]"}]}], "}"}]}], "//.", "repl"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.460444204796074*^9, 3.460444241314095*^9}}],

Cell["\<\
(exp(-S - \
T)*(-4*f*exp(T)*(Lr*r*(-(Power(a,2)*Power(F,2)*g*Power(r,2)*(-6*exp(S) + \
exp(A*Power(r,2) + S) + 3*exp(A*Power(r,2) + T))) + 
             4*(-5*exp(Power(a,2)*B + S) + exp(Power(a,2)*B + A*Power(r,2) + \
S) + exp(A*Power(r,2) + T) + 3*exp(Power(a,2)*B + A*Power(r,2) + \
T))*exp(A*Power(r,2) + S + T)) + 
          L*exp(S)*(Power(a,2)*Power(F,2)*g*Power(r,2)*(2 + 3*r*Sr + r*Tr - \
2*exp(A*Power(r,2))) + 8*A*Power(r,2)*exp(Power(a,2)*B + A*Power(r,2) + S + \
T) + 
             4*(-2 - Power(a,2)*Br*r + Ar*Power(r,3) - 4*r*Sr + \
2*exp(A*Power(r,2)))*exp(Power(a,2)*B + A*Power(r,2) + S + T))) + 
       r*(Power(a,2)*Power(F,3)*g*Power(r,3)*(3*a*ga*L*exp(T) + g*(6*L*exp(T) \
+ a*La*(exp(S) + 3*exp(T)))) + 4*Power(a,2)*Power(F,2)*fr*g*L*Power(r,2)*(-1 \
+ exp(A*Power(r,2)))*exp(S + T) + 
          4*F*r*(-(a*ga*L*(1 + 3*exp(Power(a,2)*B))*exp(A*Power(r,2) + T)) - \
g*(2*L*(1 - a*Aa*Power(r,2) - a*Ta + 3*exp(Power(a,2)*B))*exp(A*Power(r,2) + \
T) + 
                a*La*(exp(Power(a,2)*B + S) + exp(Power(a,2)*B + A*Power(r,2) \
+ S) + exp(A*Power(r,2) + T) + 3*exp(Power(a,2)*B + A*Power(r,2) + \
T))))*exp(S + T) - 
          8*L*(a*Fa*g*r + 2*fr*(-1 + exp(A*Power(r,2)))*exp(Power(a,2)*B + \
S))*exp(A*Power(r,2) + S + 2*T))))/
   (8.*f*L*r*(-(Power(a,2)*Power(F,2)*g*Power(r,2)) + 4*exp(Power(a,2)*B + \
A*Power(r,2) + S + T)))\
\>", "Output",
 CellChangeTimes->{{3.4604442138812447`*^9, 3.460356834532833*^9}, 
   3.4603668996099*^9, 3.460372595181933*^9, 3.54247006688552*^9, 
   3.543557445405633*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"H", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "3"}], "]"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Exp", "[", "x_", "]"}], "\[Rule]", 
      RowBox[{"exp", "[", "x", "]"}]}], "}"}]}], "//.", "repl"}], 
  "]"}]], "Input",
 CellChangeTimes->{3.46044425034136*^9}],

Cell["\<\
(exp(-S - \
T)*(Power(a,2)*Power(F,2)*Power(g,2)*Power(r,2)*(L*exp(S)*(2*Power(a,2)*f*F + \
Power(a,2)*F*fr*r + (-6 - 3*a*Sa - a*Ta + 6*exp(Power(a,2)*B))*exp(T)) + 
          a*(a*f*F*Lr*r*(exp(S) + 3*exp(T)) + La*exp(S)*(exp(Power(a,2)*B + \
S) - 6*exp(T) + 3*exp(Power(a,2)*B + T)))) - 
       g*exp(S + T)*(4*a*(La*exp(Power(a,2)*B + S)*(exp(Power(a,2)*B + S) + \
exp(Power(a,2)*B + A*Power(r,2) + S) - 5*exp(A*Power(r,2) + T) + \
3*exp(Power(a,2)*B + A*Power(r,2) + T)) + 
             a*f*F*Lr*r*(exp(Power(a,2)*B + S) + exp(Power(a,2)*B + \
A*Power(r,2) + S) + exp(A*Power(r,2) + T) + 3*exp(Power(a,2)*B + A*Power(r,2) \
+ T))) + 
          L*(3*Power(a,3)*Power(F,2)*ga*Power(r,2) - \
3*Power(a,3)*Power(F,2)*ga*Power(r,2)*exp(Power(a,2)*B) - 
             8*Power(a,2)*f*(-(Fr*r) + F*(-1 + Power(a,2)*Br*r + r*Sr - \
exp(A*Power(r,2))))*exp(Power(a,2)*B + S) + \
4*Power(a,2)*F*fr*r*exp(Power(a,2)*B + A*Power(r,2) + S) - 
             24*exp(Power(a,2)*B + A*Power(r,2) + S + T) + \
8*Power(a,2)*B*exp(Power(a,2)*B + A*Power(r,2) + S + T) + \
4*Power(a,3)*Ba*exp(Power(a,2)*B + A*Power(r,2) + S + T) - 
             4*a*Aa*Power(r,2)*exp(Power(a,2)*B + A*Power(r,2) + S + T) - \
8*a*Sa*exp(Power(a,2)*B + A*Power(r,2) + S + T) - 8*a*Ta*exp(Power(a,2)*B + \
A*Power(r,2) + S + T) + 
             24*exp(2*Power(a,2)*B + A*Power(r,2) + S + T))) - 12*a*ga*L*(-1 \
+ exp(Power(a,2)*B))*exp(Power(a,2)*B + A*Power(r,2) + 2*(S + T))))/
   (2.*a*g*L*(-(Power(a,2)*Power(F,2)*g*Power(r,2)) + 4*exp(Power(a,2)*B + \
A*Power(r,2) + S + T)))\
\>", "Output",
 CellChangeTimes->{{3.4604442509221687`*^9, 3.460356834593007*^9}, 
   3.4603668996819487`*^9, 3.460372595242635*^9, 3.5424700682177362`*^9, 
   3.543557445444585*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{
   RowBox[{"phi", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Exp", "[", "x_", "]"}], "\[Rule]", 
      RowBox[{"exp", "[", "x", "]"}]}], "}"}]}], "//.", "repl"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.4604442564019127`*^9, 3.460444256594475*^9}}],

Cell["\<\
(-2*a*f*F*g*ha*hr*r + 4*Power(f,2)*Power(hr,2)*exp(Power(a,2)*B + S) + \
g*Power(ha,2)*exp(A*Power(r,2) + T))/(-(Power(a,2)*Power(F,2)*g*L*Power(r,2)) \
+ 4*L*exp(Power(a,2)*B + A*Power(r,2) + S + T))\
\>", "Output",
 CellChangeTimes->{{3.460444257172927*^9, 3.460356834643196*^9}, 
   3.460366899763846*^9, 3.4603725952920523`*^9, 3.542470070000843*^9, 
   3.5435574454921093`*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dlist\[Lambda]", "=", 
    RowBox[{"{", 
     RowBox[{"Tl", ",", "Al", ",", "Bl", ",", "Fl", ",", "Sl"}], "}"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dlistrr", "=", 
    RowBox[{"{", 
     RowBox[{"Trr", ",", "Arr", ",", "Brr", ",", "Frr", ",", "Srr"}], "}"}]}],
    ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dlistaa", "=", 
    RowBox[{"{", 
     RowBox[{"Taa", ",", "Aaa", ",", "Baa", ",", "Faa", ",", "Saa"}], "}"}]}],
    ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dlistra", "=", 
    RowBox[{"{", 
     RowBox[{"Tra", ",", "Ara", ",", "Bra", ",", "Fra", ",", "Sra"}], "}"}]}],
    ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dlist", "=", 
   RowBox[{"{", 
    RowBox[{
    "Tr", ",", "Ar", ",", "Br", ",", "Fr", ",", "Sr", ",", "Ta", ",", "Aa", 
     ",", "Ba", ",", "Fa", ",", "Sa"}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.517824939478304*^9, 3.5178249658652477`*^9}, {
  3.517825345546793*^9, 3.517825357952314*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"zerodlist", "=", 
   RowBox[{"Thread", "[", 
    RowBox[{"dlist", "\[Rule]", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", 
         RowBox[{"Length", "[", "dlist", "]"}]}], "}"}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.517827055015583*^9, 3.517827077817245*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"allderiv", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
    "dlist\[Lambda]", ",", "dlistrr", ",", "dlistaa", ",", "dlistra", ",", 
     "dlist"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.517824997155527*^9, 3.517825012540985*^9}, {
  3.51782518467982*^9, 3.5178251854111958`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"allvar", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "r", ",", "a", ",", "\[Theta]1", ",", "T", ",", "A", ",", "B", ",", "F",
        ",", "S", ",", "L", ",", "Lr", ",", "La", ",", "Lrr", ",", "Laa", ",",
        "Lra", ",", "f", ",", "fr", ",", "frr", ",", "g", ",", "ga", ",", 
       "gaa", ",", "\[CapitalLambda]"}], "}"}], ",", "allderiv"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.517825461847103*^9, 3.517825502830639*^9}, {
  3.517825546962123*^9, 3.517825549998563*^9}, {3.517825598208082*^9, 
  3.5178255990225143`*^9}, {3.5178272390735703`*^9, 3.460392829797771*^9}, {
  3.460396882947147*^9, 3.4603968873370037`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"zeroallderiv", "=", 
   RowBox[{"Thread", "[", 
    RowBox[{"allderiv", "\[Rule]", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", 
         RowBox[{"Length", "[", "allderiv", "]"}]}], "}"}]}], "]"}]}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.517828665692329*^9, 3.5178286695470448`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"dlist2", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"dlist", "[", 
        RowBox[{"[", "ii", "]"}], "]"}], 
       RowBox[{"dlist", "[", 
        RowBox[{"[", "jj", "]"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "dlist", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"jj", ",", "ii", ",", 
        RowBox[{"Length", "[", "dlist", "]"}]}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.5178269895484753`*^9, 3.5178270260336027`*^9}, {
  3.517827312763998*^9, 3.517827331395611*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"randlist", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Thread", "[", 
      RowBox[{"allvar", "->", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Random", "[", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", 
           RowBox[{"Length", "[", "allvar", "]"}]}], "}"}]}], "]"}]}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", "1", ",", "20"}], "}"}]}], "]"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"extract", "[", "expr_", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"deriv\[Lambda]", "=", 
      RowBox[{"Simplify", "[", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"expr", ",", "dlist\[Lambda]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"derivrr", "=", 
      RowBox[{"Simplify", "[", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"expr", ",", "dlistrr"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"derivaa", "=", 
      RowBox[{"Simplify", "[", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"expr", ",", "dlistaa"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"derivra", "=", 
      RowBox[{"Simplify", "[", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"expr", ",", "dlistra"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"deriv1", "=", 
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"expr", ",", "dlist"}], "]"}], "//.", "zerodlist"}], "]"}]}],
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"deriv2", "=", 
      RowBox[{"Simplify", "[", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"expr", ",", "dlist2"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"noderiv", "=", 
      RowBox[{"Simplify", "[", 
       RowBox[{"expr", "//.", "zeroallderiv"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"N", "[", 
       RowBox[{
        RowBox[{"expr", "-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"deriv\[Lambda]", ".", "dlist\[Lambda]"}], "+", 
           RowBox[{"derivrr", ".", "dlistrr"}], "+", 
           RowBox[{"derivaa", ".", "dlistaa"}], "+", 
           RowBox[{"derivra", ".", "dlistra"}], "+", 
           RowBox[{"deriv1", ".", "dlist"}], "+", 
           RowBox[{"deriv2", ".", "dlist2"}], "+", "noderiv"}], ")"}]}], "/.",
         "randlist"}], "]"}], "]"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
      "deriv\[Lambda]", ",", "derivrr", ",", "derivaa", ",", "derivra", ",", 
       "deriv1", ",", "deriv2", ",", "noderiv"}], "}"}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.517825191432572*^9, 3.5178251938533*^9}, {
  3.517828583820703*^9, 3.517828636236395*^9}, {3.517828677980176*^9, 
  3.517828696111575*^9}, {3.51782874494584*^9, 3.5178288515280733`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{
     RowBox[{"RF1", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "1", ",", "1"}], "]"}], "]"}], "//.", "repl"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"coefftt", "=", 
   RowBox[{"extract", "[", "tmp", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.517828863851482*^9, 3.4603883470901337`*^9}, 
   3.46038838109201*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.1102230246251565`*^-15"}], ",", "1.0408340855860843`*^-17",
    ",", 
   RowBox[{"-", "2.6645352591003757`*^-15"}], ",", "5.551115123125783`*^-16", 
   ",", "5.273559366969494`*^-16", ",", 
   RowBox[{"-", "8.673617379884035`*^-18"}], ",", "4.163336342344337`*^-16", 
   ",", 
   RowBox[{"-", "2.0816681711721685`*^-17"}], ",", 
   RowBox[{"-", "7.494005416219807`*^-16"}], ",", "7.771561172376096`*^-16", 
   ",", "3.984442983884229`*^-16", ",", "1.3877787807814457`*^-17", ",", 
   "5.273559366969494`*^-16", ",", 
   RowBox[{"-", "1.6653345369377348`*^-16"}], ",", 
   RowBox[{"-", "8.673617379884035`*^-19"}], ",", "9.853229343548264`*^-16", 
   ",", "1.3877787807814457`*^-16", ",", "0.`", ",", 
   "2.220446049250313`*^-16", ",", "6.591949208711867`*^-17"}], 
  "}"}]], "Print",
 CellChangeTimes->{{3.460388368246913*^9, 3.460388383729855*^9}, 
   3.460392846328475*^9, {3.460396906809197*^9, 3.4603568417356663`*^9}, 
   3.4603669070324373`*^9, 3.460372602146345*^9, 3.5424700831734877`*^9, 
   3.54355745020923*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{
     RowBox[{"RF1", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "2", ",", "2"}], "]"}], "]"}], "//.", "repl"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"coeffrr", "=", 
   RowBox[{"extract", "[", "tmp", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.460388351796958*^9, 3.460388362522346*^9}, {
  3.460388396835832*^9, 3.460388403884074*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "5.329070518200751`*^-15"}], ",", 
   RowBox[{"-", "4.164169009612806`*^-13"}], ",", 
   RowBox[{"-", "4.440892098500626`*^-15"}], ",", "1.2212453270876722`*^-14", 
   ",", 
   RowBox[{"-", "7.66053886991358`*^-15"}], ",", "7.8580342233181`*^-10", ",", 
   RowBox[{"-", "3.397282455352979`*^-14"}], ",", "3.0464519795714295`*^-13", 
   ",", "3.9968028886505635`*^-15", ",", "7.993605777301127`*^-15", ",", 
   "2.5955585987794128`*^-11", ",", 
   RowBox[{"-", "8.770761894538737`*^-15"}], ",", 
   RowBox[{"-", "1.0658141036401503`*^-14"}], ",", 
   RowBox[{"-", "9.237055564881302`*^-14"}], ",", "3.268496584496461`*^-13", 
   ",", 
   RowBox[{"-", "2.5623947408348613`*^-13"}], ",", "2.4424906541753444`*^-15",
    ",", "2.4868995751603507`*^-14", ",", "1.0658141036401503`*^-14", ",", 
   RowBox[{"-", "1.5276668818842154`*^-13"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.460389152260504*^9, 3.4603928677987013`*^9, {3.460396936603415*^9, 
   3.460356858405094*^9}, 3.46036692402672*^9, 3.460372618959271*^9, 
   3.542470092561906*^9, 3.543557459613719*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{
     RowBox[{"RF1", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "3", ",", "3"}], "]"}], "]"}], "//.", "repl"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"coeffaa", "=", 
   RowBox[{"extract", "[", "tmp", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.460388354236719*^9, 3.460388364994575*^9}, {
  3.4603883986118813`*^9, 3.460388406035945*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.3011813848606835`*^-13", ",", "6.323830348264892`*^-13", ",", 
   RowBox[{"-", "8.382183835919932`*^-14"}], ",", "1.9539925233402755`*^-14", 
   ",", 
   RowBox[{"-", "4.618527782440651`*^-14"}], ",", "3.9968028886505635`*^-15", 
   ",", "5.773159728050814`*^-14", ",", "6.328271240363392`*^-13", ",", 
   RowBox[{"-", "2.566835632933362`*^-13"}], ",", "5.684341886080802`*^-14", 
   ",", "3.2951419370874646`*^-13", ",", 
   RowBox[{"-", "9.769962616701378`*^-15"}], ",", 
   RowBox[{"-", "4.440892098500626`*^-15"}], ",", "3.197442310920451`*^-14", 
   ",", 
   RowBox[{"-", "6.661338147750939`*^-15"}], ",", "4.689582056016661`*^-13", 
   ",", "4.440892098500626`*^-16", ",", "7.127631818093505`*^-14", ",", 
   RowBox[{"-", "5.3290705182007514`*^-14"}], ",", 
   RowBox[{"-", "7.993605777301127`*^-15"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.460389268467102*^9, 3.460392888648872*^9, {3.4603969684635*^9, 
   3.460356877910128*^9}, 3.4603669435501127`*^9, 3.460372638490157*^9, 
   3.5424701037116213`*^9, 3.543557470648505*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{
     RowBox[{"RF1", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "2", ",", "3"}], "]"}], "]"}], "//.", "repl"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"coeffra", "=", 
   RowBox[{"extract", "[", "tmp", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.460388355436696*^9, 3.460388367106613*^9}, {
  3.460388401363799*^9, 3.4603884076680202`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.398081733190338`*^-14", ",", 
   RowBox[{"-", "4.3076653355456074`*^-14"}], ",", "2.1094237467877974`*^-15",
    ",", "4.107825191113079`*^-15", ",", 
   RowBox[{"-", "1.5980272660698347`*^-14"}], ",", 
   RowBox[{"-", "3.126388037344441`*^-13"}], ",", "2.3314683517128287`*^-15", 
   ",", 
   RowBox[{"-", "2.220446049250313`*^-16"}], ",", "4.440892098500626`*^-15", 
   ",", "9.43689570931383`*^-15", ",", 
   RowBox[{"-", "3.209099652679015`*^-13"}], ",", "0.`", ",", 
   RowBox[{"-", "6.286637876939949`*^-15"}], ",", "7.549516567451064`*^-15", 
   ",", "2.6645352591003757`*^-15", ",", 
   RowBox[{"-", "7.993605777301127`*^-14"}], ",", 
   RowBox[{"-", "9.2148511043888`*^-15"}], ",", "2.708944180085382`*^-14", 
   ",", "8.881784197001252`*^-15", ",", 
   RowBox[{"-", "7.549516567451064`*^-15"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.460389455684288*^9, 3.460392915610973*^9, {3.46039700838389*^9, 
   3.460356899938744*^9}, 3.460366965449085*^9, 3.460372660405279*^9, 
   3.542470115813259*^9, 3.543557482944367*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{
     RowBox[{"RF1", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "4", ",", "4"}], "]"}], "]"}], "//.", "repl"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"coeff\[Theta]\[Theta]", "=", 
   RowBox[{"extract", "[", "tmp", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.460388368517098*^9, 3.460388390820409*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.47499806707674`*^-14", ",", 
   RowBox[{"-", "7.105427357601002`*^-15"}], ",", "1.43982048506075`*^-16", 
   ",", "1.3322676295501878`*^-15", ",", "4.440892098500626`*^-16", ",", 
   "1.1102230246251565`*^-15", ",", 
   RowBox[{"-", "3.9968028886505635`*^-15"}], ",", 
   RowBox[{"-", "1.4450246554886803`*^-15"}], ",", "1.4988010832439613`*^-15",
    ",", 
   RowBox[{"-", "1.6653345369377348`*^-15"}], ",", "6.38378239159465`*^-16", 
   ",", "1.27675647831893`*^-15", ",", 
   RowBox[{"-", "1.4432899320127035`*^-15"}], ",", 
   RowBox[{"-", "2.220446049250313`*^-15"}], ",", "2.220446049250313`*^-16", 
   ",", 
   RowBox[{"-", "3.297362383136715`*^-14"}], ",", "8.881784197001252`*^-16", 
   ",", "1.0047518372857667`*^-14", ",", 
   RowBox[{"-", "2.248201624865942`*^-15"}], ",", "2.220446049250313`*^-15"}],
   "}"}]], "Print",
 CellChangeTimes->{
  3.460388421311708*^9, 3.460392922830152*^9, {3.46039701910912*^9, 
   3.460356907775153*^9}, 3.4603669733368998`*^9, 3.4603726682497597`*^9, 
   3.542470120595168*^9, 3.543557487287178*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"coeffs", "=", 
   RowBox[{"{", 
    RowBox[{
    "coefftt", ",", "coeffrr", ",", "coeffaa", ",", "coeffra", ",", 
     "coeff\[Theta]\[Theta]"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{3.460389569356962*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coeff\[Lambda]", "=", 
  RowBox[{"coeffs", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "1"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4603896237503223`*^9, 3.460389649940551*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "T"], " ", "f", " ", "L", " ", 
      SuperscriptBox["r", "2"]}], ",", "0", ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "L"}], 
      SuperscriptBox["f", "2"]], ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "L", " ", 
       SuperscriptBox["r", "2"]}], 
      SuperscriptBox["f", "2"]], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "L"}], "g"],
      ",", "0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "L"}], 
      "g"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"a", " ", "L", " ", "r"}], "f"], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", "S"], " ", "g", " ", "L"}], 
      RowBox[{"1", "-", 
       SuperscriptBox["\[Theta]1", "2"]}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.4603896291241493`*^9, 3.4603896506666527`*^9}, 
   3.460392317998266*^9, 3.460392948493086*^9, 3.460393177387624*^9, {
   3.460397019398037*^9, 3.460356907907297*^9}, 3.460366973473732*^9, 
   3.46037266839177*^9, 3.5424701208571033`*^9, 3.543557487471448*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Inverse", "[", "coeff\[Lambda]", "]"}], ".", 
  RowBox[{"coeffs", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "1"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.460389658303999*^9, 3.460389664733412*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.4603896653582773`*^9, 3.4603896929826193`*^9}, 
   3.4603923196027603`*^9, 3.4603929517489634`*^9, 3.4603931793038197`*^9, {
   3.4603970195459757`*^9, 3.4603569079636908`*^9}, 3.460366973531946*^9, 
   3.4603726684453573`*^9, 3.542470121018214*^9, 3.543557487507291*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"newcoeffrr", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Inverse", "[", "coeff\[Lambda]", "]"}], ".", 
    RowBox[{"coeffs", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "2"}], "]"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4603896732003117`*^9, 3.460389700198414*^9}, {
  3.460389973154498*^9, 3.4603899751557007`*^9}, {3.4603903858056793`*^9, 
  3.460390422230899*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
        SuperscriptBox["f", "2"]}], 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], 
        "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["F", "2"], " ", "g", " ", "L", " ", 
         SuperscriptBox["r", "2"]}]}]]}], ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
        SuperscriptBox["f", "2"]}], 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], 
        "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["F", "2"], " ", "g", " ", "L", " ", 
         SuperscriptBox["r", "2"]}]}]]}], ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
        SuperscriptBox["f", "2"]}], 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], 
        "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["F", "2"], " ", "g", " ", "L", " ", 
         SuperscriptBox["r", "2"]}]}]]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
        SuperscriptBox["f", "2"]}], 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], 
        "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["F", "2"], " ", "g", " ", "L", " ", 
         SuperscriptBox["r", "2"]}]}]]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
        SuperscriptBox["f", "2"]}], 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], 
        "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["F", "2"], " ", "g", " ", "L", " ", 
         SuperscriptBox["r", "2"]}]}]]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.460389693890481*^9, 3.460389700765806*^9}, {
   3.4603899685727262`*^9, 3.460389976419889*^9}, 3.460390380755816*^9, 
   3.4603904368514023`*^9, 3.460392324200906*^9, 3.460392953265147*^9, 
   3.4603931847409563`*^9, 3.460393221701886*^9, {3.4603970575895987`*^9, 
   3.460356908038414*^9}, 3.460366973601602*^9, 3.460372668515505*^9, 
   3.542470121102771*^9, 3.543557487571121*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"newcoeffaa", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Inverse", "[", "coeff\[Lambda]", "]"}], ".", 
    RowBox[{"coeffs", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "3"}], "]"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.4603897104017572`*^9, 3.460389982684561*^9, 3.4603903900025997`*^9, {
   3.460390427193303*^9, 3.460390428798345*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "g"}], 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], 
        "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["F", "2"], " ", "g", " ", "L", " ", 
         SuperscriptBox["r", "2"]}]}]]}], ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "g"}], 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], 
        "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["F", "2"], " ", "g", " ", "L", " ", 
         SuperscriptBox["r", "2"]}]}]]}], ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "g"}], 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], 
        "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["F", "2"], " ", "g", " ", "L", " ", 
         SuperscriptBox["r", "2"]}]}]]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "g"}], 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], 
        "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["F", "2"], " ", "g", " ", "L", " ", 
         SuperscriptBox["r", "2"]}]}]]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "g"}], 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], 
        "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["F", "2"], " ", "g", " ", "L", " ", 
         SuperscriptBox["r", "2"]}]}]]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.4603897117415943`*^9, {3.460389981859321*^9, 3.460389983870729*^9}, 
   3.4603904382349977`*^9, 3.4603923271776657`*^9, 3.460392956373383*^9, 
   3.46039318613798*^9, 3.460393222414995*^9, {3.4603970590346413`*^9, 
   3.460356908118824*^9}, 3.460366973677075*^9, 3.460372668594121*^9, 
   3.542470121266078*^9, 3.543557487618719*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"newcoeffra", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Inverse", "[", "coeff\[Lambda]", "]"}], ".", 
    RowBox[{"coeffs", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "4"}], "]"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.460389713609824*^9, 3.460389986692421*^9, 3.460390392216176*^9, {
   3.460390431786374*^9, 3.4603904338304567`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"2", " ", "a", " ", "f", " ", "F", " ", "g", " ", "r"}], 
      RowBox[{
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["F", "2"], " ", "g", " ", "L", " ", 
        SuperscriptBox["r", "2"]}]}]], ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"2", " ", "a", " ", "f", " ", "F", " ", "g", " ", "r"}], 
      RowBox[{
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["F", "2"], " ", "g", " ", "L", " ", 
        SuperscriptBox["r", "2"]}]}]], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      RowBox[{"2", " ", "a", " ", "f", " ", "F", " ", "g", " ", "r"}], 
      RowBox[{
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["F", "2"], " ", "g", " ", "L", " ", 
        SuperscriptBox["r", "2"]}]}]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"2", " ", "a", " ", "f", " ", "F", " ", "g", " ", "r"}], 
      RowBox[{
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["F", "2"], " ", "g", " ", "L", " ", 
        SuperscriptBox["r", "2"]}]}]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"2", " ", "a", " ", "f", " ", "F", " ", "g", " ", "r"}], 
      RowBox[{
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["F", "2"], " ", "g", " ", "L", " ", 
        SuperscriptBox["r", "2"]}]}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.460389714247075*^9, 3.460389989874523*^9, 3.460390439550115*^9, 
   3.46039232916503*^9, 3.460392957462525*^9, 3.460393187000842*^9, 
   3.4603932230970488`*^9, {3.460397060554915*^9, 3.4603569081962547`*^9}, 
   3.46036697375664*^9, 3.460372668670583*^9, 3.5424701214323053`*^9, 
   3.543557487666267*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"newcoeffderiv1", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Inverse", "[", "coeff\[Lambda]", "]"}], ".", 
    RowBox[{"coeffs", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "5"}], "]"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.460389768419777*^9, 3.460389994663455*^9, {3.460390026485517*^9, 
   3.4603900500866823`*^9}, 3.460390394581377*^9, {3.460390441551569*^9, 
   3.460390450191416*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "S"}], "-", "T"}]], " ", "f", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "f", " ", "Lr", " ", "r"}], "-", 
         RowBox[{"12", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "f", " ", "Lr", " ", "r"}], "-", 
         RowBox[{"2", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"S", "+", "T"}]], " ", "F", " ", "g", " ", "La", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", "T"], " ", "f", " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "Lr", " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "f", " ", "L"}], "+", 
            RowBox[{"fr", " ", "L", " ", "r"}], "+", 
            RowBox[{"f", " ", "Lr", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", "S"], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "f", " ", "L"}], "+", 
            RowBox[{"fr", " ", "L", " ", "r"}], "+", 
            RowBox[{"f", " ", "Lr", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "8"}], " ", "fr", " ", "L", " ", "r"}], "+", 
            RowBox[{"4", " ", "f", " ", "Lr", " ", "r"}]}], ")"}]}]}], 
        ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox["L", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "r"}], 
         "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["r", "3"]}]}], ")"}]}]], ",", "0", ",", "0", ",", 
     "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "S"}], "-", "T"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "g", " ", "La"}], "+", 
          RowBox[{"4", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "g", " ", "La"}], "+", 
          RowBox[{"4", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"ga", " ", "L"}], "-", 
             RowBox[{"g", " ", "La"}]}], ")"}]}], "+", 
          RowBox[{"12", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "g", " ", "L"}], "+", 
             RowBox[{"a", " ", "ga", " ", "L"}], "+", 
             RowBox[{"a", " ", "g", " ", "La"}]}], ")"}]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"S", "+", "T"}]], " ", "f", " ", "F", " ", "g", " ", "Lr",
            " ", "r"}], "-", 
          RowBox[{
           SuperscriptBox["a", "3"], " ", 
           SuperscriptBox["\[ExponentialE]", "S"], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["g", "2"], " ", "La", " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", "T"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "g", " ", "L"}], "+", 
             RowBox[{"a", " ", "ga", " ", "L"}], "+", 
             RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["L", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
          RowBox[{
           SuperscriptBox["a", "3"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}]]}], ",", "0", ",", "0", ",", 
     "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", 
       RowBox[{"4", " ", 
        SuperscriptBox["L", "2"], " ", 
        SuperscriptBox["r", "3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "A"}], " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{"2", " ", "T"}]}]], " ", "f", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"16", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]], 
          " ", "F", " ", "g", " ", "La", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"32", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"3", " ", "T"}]}]], " ", "F", " ", "g", " ", "La", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"16", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", "F", " ", "g", " ", 
          "La", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "T"}]}]], " ", "f", " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "Lr", " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["g", "2"], " ", "La", " ", 
          SuperscriptBox["r", "4"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          SuperscriptBox["F", "3"], " ", "g", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "g", " ", "L"}], "-", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["a", "5"], " ", 
          SuperscriptBox["F", "5"], " ", 
          SuperscriptBox["g", "3"], " ", "La", " ", 
          SuperscriptBox["r", "6"]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["r", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "fr", " ", "L"}], "+", 
            RowBox[{"3", " ", "f", " ", "Lr"}], "+", 
            RowBox[{"4", " ", "A", " ", "f", " ", "L", " ", "r"}]}], ")"}]}], 
         "+", 
         RowBox[{"64", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"3", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", 
            RowBox[{"3", " ", "T"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "f", " ", "L"}], "+", 
            RowBox[{"fr", " ", "L", " ", "r"}], "+", 
            RowBox[{"f", " ", "Lr", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"32", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "f", " ", "L"}], "+", 
            RowBox[{"fr", " ", "L", " ", "r"}], "+", 
            RowBox[{"f", " ", "Lr", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", "T"], " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["r", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "f", " ", "L"}], "+", 
            RowBox[{"fr", " ", "L", " ", "r"}], "+", 
            RowBox[{"f", " ", "Lr", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["r", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "f", " ", "L"}], "+", 
            RowBox[{"fr", " ", "L", " ", "r"}], "+", 
            RowBox[{"f", " ", "Lr", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"64", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", 
            RowBox[{"3", " ", "T"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "fr"}], " ", "L", " ", "r"}], "-", 
            RowBox[{"f", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Lr", " ", "r"}], "+", 
               RowBox[{"L", " ", 
                RowBox[{"(", 
                 RowBox[{"2", "-", 
                  RowBox[{"2", " ", "A", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", " ", 
        SuperscriptBox["L", "2"], " ", "r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "S"}], "-", "T"}]], " ", "f", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", 
            RowBox[{"3", " ", "T"}]}]], " ", "f", " ", "Lr", " ", "r"}], "-", 
         RowBox[{"48", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", 
            RowBox[{"3", " ", "T"}]}]], " ", "f", " ", "Lr", " ", "r"}], "+", 
         RowBox[{"8", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"3", " ", "S"}], "+", "T"}]], " ", "F", " ", "g", " ", 
          "La", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"8", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", "F", " ", "g", " ", 
          "La", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "f", " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "Lr", " ", 
          SuperscriptBox["r", "3"]}], "+", 
         RowBox[{"24", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "f", " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "Lr", " ", 
          SuperscriptBox["r", "3"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"S", "+", "T"}]], " ", 
          SuperscriptBox["F", "3"], " ", "g", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g"}], "+", 
            RowBox[{"a", " ", "ga"}]}], ")"}], " ", "L", " ", 
          SuperscriptBox["r", "4"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", "T"], " ", "f", " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", "Lr", " ", 
          SuperscriptBox["r", "5"]}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "S"}], "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "f", " ", "L"}], "+", 
            RowBox[{"fr", " ", "L", " ", "r"}], "+", 
            RowBox[{"f", " ", "Lr", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "f", " ", "L"}], "+", 
            RowBox[{"fr", " ", "L", " ", "r"}], "+", 
            RowBox[{"f", " ", "Lr", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", "S"], " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["r", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "f", " ", "L"}], "+", 
            RowBox[{"fr", " ", "L", " ", "r"}], "+", 
            RowBox[{"f", " ", "Lr", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["r", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "fr", " ", "L"}], "+", 
            RowBox[{"f", " ", 
             RowBox[{"(", 
              RowBox[{"Lr", "+", 
               RowBox[{"8", " ", "A", " ", "L", " ", "r"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "S"}], "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "fr", " ", "L", " ", "r"}], "+", 
            RowBox[{"f", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Lr", " ", "r"}], "+", 
               RowBox[{"4", " ", "L", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", 
                  RowBox[{"A", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}]}], ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "-", 
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "S", "-", "T"}]], " ", "f", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"3", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "T"}], ")"}]}]], " ", "f", 
          " ", "Lr"}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "f", " ", "Lr"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "T"}], ")"}]}]], " ", "F", 
          " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", "r"}], "+", 
         RowBox[{
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["g", "2"], " ", "La", " ", 
          SuperscriptBox["r", "3"]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "f", " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"Lr", "+", 
            RowBox[{"A", " ", "L", " ", "r"}]}], ")"}]}]}], ")"}]}], 
      RowBox[{
       SuperscriptBox["L", "2"], " ", 
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "a", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "A"}], " ", 
           SuperscriptBox["r", "2"]}], "-", "T"}]], " ", "f", " ", "g", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "La"}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "ga", " ", 
              "L"}], "+", 
             RowBox[{
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "g", 
              " ", "La"}]}], ")"}], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "3"], " ", "f", " ", 
           SuperscriptBox["F", "3"], " ", "g", " ", "Lr", " ", 
           SuperscriptBox["r", "3"]}], "+", 
          RowBox[{"2", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "F", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "f", " ", "Lr",
               " ", "r"}], "+", 
             RowBox[{"F", " ", "g", " ", "L", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "f", 
              " ", "L", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{"2", " ", "A", " ", 
                 SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       RowBox[{
        SuperscriptBox["L", "2"], " ", "r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"4", " ", 
        SuperscriptBox["L", "2"], " ", 
        SuperscriptBox["r", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "A"}], " ", 
          SuperscriptBox["r", "2"]}], "-", "S", "-", "T"}]], " ", "f", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "256"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "S"}], "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "f", " ", "Lr"}], "+", 
         RowBox[{"64", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"3", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", 
            RowBox[{"3", " ", "T"}]}]], " ", "f", " ", "Lr"}], "+", 
         RowBox[{"192", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"3", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", 
            RowBox[{"3", " ", "T"}]}]], " ", "f", " ", "Lr"}], "+", 
         RowBox[{"48", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]], 
          " ", "F", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", "r"}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]}]], 
          " ", "F", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", "r"}], "-", 
         RowBox[{"96", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "f", " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "Lr", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "S"}]}]], " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["g", "2"], " ", "La", " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"24", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
          SuperscriptBox["F", "3"], " ", "g", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"12", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", "S"], " ", "f", " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", "Lr", " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "f", " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", "Lr", " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["F", "5"], " ", 
          SuperscriptBox["g", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "5"]}], "+", 
         RowBox[{"32", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "f", " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "Lr"}], "+", 
            RowBox[{"A", " ", "L", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     FractionBox[
      RowBox[{"2", " ", "a", " ", "f", " ", "F", " ", "g", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "Lr"}], 
         "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Lr", " ", "r"}], "+", 
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"2", "-", 
               RowBox[{"2", " ", "A", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
      RowBox[{
       SuperscriptBox["L", "2"], " ", "r", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"8", " ", "a", " ", 
         SuperscriptBox["L", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["F", "2"], " ", "g", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "S"}], "-", "T"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "g", " ", "La"}], "+", 
          RowBox[{"16", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "g", " ", "La"}], "+", 
          RowBox[{"16", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"ga", " ", "L"}], "-", 
             RowBox[{"g", " ", "La"}]}], ")"}]}], "+", 
          RowBox[{"48", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "g", " ", "L"}], "+", 
             RowBox[{"a", " ", "ga", " ", "L"}], "+", 
             RowBox[{"a", " ", "g", " ", "La"}]}], ")"}]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["a", "3"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["g", "2"], " ", "La", " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["a", "3"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["g", "2"], " ", "La", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["a", "3"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "ga"}], " ", "L"}], "+", 
             RowBox[{"g", " ", "La"}]}], ")"}], " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"24", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "g", " ", "L"}], "+", 
             RowBox[{"a", " ", "ga", " ", "L"}], "+", 
             RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "5"], " ", 
           SuperscriptBox["\[ExponentialE]", "S"], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["g", "3"], " ", "La", " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["a", "4"], " ", 
           SuperscriptBox["\[ExponentialE]", "T"], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["g", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "g", " ", "L"}], "+", 
             RowBox[{"a", " ", "ga", " ", "L"}], "+", 
             RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["a", "4"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"S", "+", "T"}]], " ", "f", " ", 
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["g", "2"], " ", 
           SuperscriptBox["r", "3"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], " ", "Lr"}], "+", 
             RowBox[{"4", " ", "A", " ", "L", " ", "r"}]}], ")"}]}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", "f", " ", "F", " ", 
           "g", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", "L"}], "-", 
             RowBox[{"3", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], 
     ",", "0", ",", 
     FractionBox[
      RowBox[{"2", " ", "a", " ", "f", " ", "g", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "Lr"}], 
         "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "Lr"}], " ", "r"}], "+", 
            RowBox[{"2", " ", "L", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
      RowBox[{
       SuperscriptBox["L", "2"], " ", "r", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"2", " ", 
         SuperscriptBox["L", "2"], " ", "r", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["F", "2"], " ", "g", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "S"}], "-", "T"}]], " ", "f", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", "f", " ", "Lr", " ", "r"}], "+", 
          RowBox[{"48", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", "f", " ", "Lr", " ", "r"}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "fr", " ", "L"}], "-", 
             RowBox[{"f", " ", "Lr"}]}], ")"}], " ", "r"}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", "F", " ", "g", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", "L"}], "-", 
             RowBox[{"3", " ", "a", " ", "La"}]}], ")"}], " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "f", " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "Lr", " ", 
           SuperscriptBox["r", "3"]}], "-", 
          RowBox[{"24", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "f", " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "Lr", " ", 
           SuperscriptBox["r", "3"]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "fr", " ", "L"}], "-", 
             RowBox[{"f", " ", "Lr"}]}], ")"}], " ", 
           SuperscriptBox["r", "3"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "3"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"S", "+", "T"}]], " ", 
           SuperscriptBox["F", "3"], " ", "g", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", "a", " ", "B", " ", "g", " ", "L"}], "-", 
             RowBox[{"2", " ", "ga", " ", "L"}], "-", 
             RowBox[{"3", " ", "g", " ", "La"}]}], ")"}], " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["a", "4"], " ", 
           SuperscriptBox["\[ExponentialE]", "T"], " ", "f", " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["g", "2"], " ", "Lr", " ", 
           SuperscriptBox["r", "5"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "f", " ", "L"}], "+", 
             RowBox[{"fr", " ", "L", " ", "r"}], "+", 
             RowBox[{"f", " ", "Lr", " ", "r"}]}], ")"}]}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "f", " ", "L"}], "+", 
             RowBox[{"fr", " ", "L", " ", "r"}], "+", 
             RowBox[{"f", " ", "Lr", " ", "r"}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "4"], " ", 
           SuperscriptBox["\[ExponentialE]", "S"], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["g", "2"], " ", 
           SuperscriptBox["r", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "f", " ", "L"}], "+", 
             RowBox[{"fr", " ", "L", " ", "r"}], "+", 
             RowBox[{"f", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], 
     ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "f", " ", "g", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "La"}], 
          "+", 
          RowBox[{"a", " ", 
           SuperscriptBox["F", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", " ", "ga", " ", "L"}], "+", 
             RowBox[{"g", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "L"}], "-", 
                RowBox[{"2", " ", 
                 SuperscriptBox["a", "2"], " ", "B", " ", "L"}], "+", 
                RowBox[{"a", " ", "La"}]}], ")"}]}]}], ")"}], " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       RowBox[{"a", " ", 
        SuperscriptBox["L", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     FractionBox[
      RowBox[{"2", " ", "f", " ", "F", " ", "g", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "La"}], 
         "+", 
         RowBox[{"a", " ", 
          SuperscriptBox["F", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"g", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "L"}], "-", 
               RowBox[{"2", " ", 
                SuperscriptBox["a", "2"], " ", "B", " ", "L"}], "+", 
               RowBox[{"a", " ", "La"}]}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      RowBox[{"a", " ", 
       SuperscriptBox["L", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"4", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["L", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "2"]}], " ", "B"}], "-", "S", "-", "T"}]], " ",
        "g", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]]}], "-", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S"}]], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "T"}]]}]}], ")"}], " ", 
          "La"}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["\[ExponentialE]", "T"]}]}], ")"}], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "La", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], "-", 
            SuperscriptBox["\[ExponentialE]", "T"]}], ")"}], " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", "La", " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["a", "5"], " ", 
          SuperscriptBox["F", "5"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["r", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "f", " ", "L"}], "+", 
            RowBox[{"fr", " ", "L", " ", "r"}], "+", 
            RowBox[{"f", " ", "Lr", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"16", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", "F", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}]], " ", "fr", " ", "L", " ", "r"}], 
            "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}]]}], ")"}], " ", "f", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "L"}], "+", 
               RowBox[{"Lr", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "B", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", "S", "+", "T"}]], 
             " ", "L"}], "-", 
            RowBox[{"F", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["\[ExponentialE]", "T"]}], " ", "f", " ", 
                "Lr", " ", "r"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "f", " ", "L"}], "+", 
                  RowBox[{"fr", " ", "L", " ", "r"}], "+", 
                  RowBox[{"f", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}]}], ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "2"]}], " ", "B"}], "+", 
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "-", "S", "+", "T"}]], " ", "g", " ", 
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}], ")"}]}]], 
          " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], "-", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "T"}]]}], ")"}], " ", "La"}], 
         "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "La", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"4", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}], ")"}]}]], 
          " ", "f", " ", "F", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "L"}], "+", 
            RowBox[{"Lr", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "B", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "L"}],
             "+", 
            RowBox[{"f", " ", "F", " ", "Lr", " ", "r"}]}], ")"}]}]}], 
        ")"}]}], 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["L", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"8", " ", "a", " ", 
        SuperscriptBox["L", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "S"}], "-", "T"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "S"}], "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "g", " ", "La"}], "-", 
         RowBox[{"16", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "S"}], "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "g", " ", "La"}], "-", 
         RowBox[{"48", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", 
            RowBox[{"3", " ", "T"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", 
            RowBox[{"3", " ", "T"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "a"}], " ", "ga", " ", "L"}], "+", 
            RowBox[{"g", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", 
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", "B"}]}], ")"}], " ", "L"}], 
               "+", 
               RowBox[{"a", " ", "La"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"32", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"3", " ", "T"}]}]], " ", "f", " ", "F", " ", "g", " ", 
          "Lr", " ", "r"}], "+", 
         RowBox[{"32", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", "f", " ", "F", " ", 
          "g", " ", "Lr", " ", "r"}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"S", "+", "T"}]], " ", "f", " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["g", "2"], " ", "L", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["g", "2"], " ", "La", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["g", "2"], " ", "La", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", "a", " ", "B", " ", "g", " ", "L"}], "-", 
            RowBox[{"3", " ", "ga", " ", "L"}], "+", 
            RowBox[{"g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"24", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["a", "5"], " ", 
          SuperscriptBox["\[ExponentialE]", "S"], " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "3"], " ", "La", " ", 
          SuperscriptBox["r", "4"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", "T"], " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "4"]}]}], ")"}]}]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["a", "2"]}], " ", "B"}], "-", "S"}]], " ", "g", 
        " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "f", " ", "Lr"}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "f", 
           " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "L", " ", "r"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "F", 
           " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["a", "2"], " ", "B"}]}], ")"}], " ", "g"}], 
             "-", 
             RowBox[{"a", " ", "ga"}]}], ")"}], " ", "L", " ", "r"}], "+", 
          RowBox[{"4", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}], ")"}]}]], 
           " ", "F", " ", "g", " ", "La", " ", "r"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "f", " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "Lr", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "3"], " ", 
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["g", "2"], " ", "La", " ", 
           SuperscriptBox["r", "3"]}]}], ")"}]}], 
       RowBox[{"2", " ", "a", " ", 
        SuperscriptBox["L", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"4", " ", 
        SuperscriptBox["a", "3"], " ", 
        SuperscriptBox["L", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "2"]}], " ", "B"}], "-", 
         RowBox[{"2", " ", "S"}]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"48", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "S"}], "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "S"}], "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "3"}], " ", "a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"g", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "6"}], " ", "L"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["a", "2"], " ", "B", " ", "L"}], "-", 
               RowBox[{"3", " ", "a", " ", "La"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"48", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]], 
          " ", "f", " ", "F", " ", "g", " ", "Lr", " ", "r"}], "+", 
         RowBox[{"32", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "S"}], "+", "T"}]], " ", "f", " ", "F", " ", 
          "g", " ", "Lr", " ", "r"}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]}]], 
          " ", "f", " ", "F", " ", "g", " ", "Lr", " ", "r"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"3", " ", "S"}]}]], " ", 
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["g", "2"], " ", "La", " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{"24", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"g", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"8", " ", "L"}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox["a", "2"], " ", "B", " ", "L"}], "+", 
               RowBox[{"7", " ", "a", " ", "La"}]}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{"24", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["g", "2"], " ", "Lr", " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", "S"], " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["a", "6"], " ", "f", " ", 
          SuperscriptBox["F", "5"], " ", 
          SuperscriptBox["g", "3"], " ", "Lr", " ", 
          SuperscriptBox["r", "5"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "S"}]}]], " ", "f", " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "L"}], "+", 
            RowBox[{"Lr", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", " ", "a", " ", 
        SuperscriptBox["L", "2"], " ", "r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "T"}]], " ", "f", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "S"}], "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}]]}], ")"}], " ", "La"}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
          SuperscriptBox["F", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "g", 
             " ", "La"}], "+", 
            RowBox[{
             SuperscriptBox["\[ExponentialE]", "T"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"ga", " ", "L"}], "-", 
               RowBox[{"g", " ", "La"}]}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], "-", 
            SuperscriptBox["\[ExponentialE]", "T"]}], ")"}], " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", "La", " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["a", "5"], " ", 
          SuperscriptBox["F", "5"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["r", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "f", " ", "L"}], "+", 
            RowBox[{"fr", " ", "L", " ", "r"}], "+", 
            RowBox[{"f", " ", "Lr", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"16", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "F"}], " ", "g", " ", "L", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "f", 
             " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "L"}], "+", 
               RowBox[{"Lr", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S"}]], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "f", " ", "L"}], "+", 
               RowBox[{"fr", " ", "L", " ", "r"}], "+", 
               RowBox[{"f", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", "B", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", "S", "+", "T"}]], 
             " ", "L"}], "-", 
            RowBox[{"F", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["\[ExponentialE]", "T"]}], " ", "f", " ", 
                "Lr", " ", "r"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "f", " ", "L"}], "+", 
                  RowBox[{"fr", " ", "L", " ", "r"}], "+", 
                  RowBox[{"f", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}]}], ",", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "f", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}], ")"}]}]], 
          " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "T"}]]}], ")"}], " ", "La"}], 
         "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
          SuperscriptBox["F", "2"], " ", "ga", " ", "L", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", "B", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "L"}],
             "+", 
            RowBox[{"f", " ", "F", " ", "Lr", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "F", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "F"}], " ", "g", " ", "L", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "f", 
             " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "L"}], "+", 
               RowBox[{"Lr", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
      RowBox[{"a", " ", 
       SuperscriptBox["L", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     FractionBox[
      RowBox[{"2", " ", "a", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "f", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "8"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "La"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "T"}]]}]}], ")"}], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "La", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["a", "3"], " ", "f", " ", 
          SuperscriptBox["F", "3"], " ", "g", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "L"}], "+", 
            RowBox[{"Lr", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "B", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}],
             "+", 
            RowBox[{"f", " ", "F", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{"A", " ", 
                   SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "Lr", " ", 
                "r"}], "-", 
               RowBox[{"4", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
                "L", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  RowBox[{"A", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], 
      RowBox[{
       SuperscriptBox["L", "2"], " ", "r", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"2", " ", 
         SuperscriptBox["L", "2"], " ", "r", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["F", "2"], " ", "g", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "S"}], "-", "T"}]], " ", "f", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", "f", " ", "Lr", " ", "r"}], "+", 
          RowBox[{"48", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", "f", " ", "Lr", " ", "r"}], "+", 
          RowBox[{"8", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"3", " ", "S"}], "+", "T"}]], " ", "F", " ", "g", " ", 
           "La", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", "F", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "a"}], " ", "ga", " ", "L"}], "+", 
             RowBox[{"g", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "+", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["a", "2"], " ", "B"}]}], ")"}], " ", "L"}],
                 "+", 
                RowBox[{"a", " ", "La"}]}], ")"}]}]}], ")"}], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "f", " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "Lr", " ", 
           SuperscriptBox["r", "3"]}], "-", 
          RowBox[{"24", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "f", " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "Lr", " ", 
           SuperscriptBox["r", "3"]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["a", "4"], " ", 
           SuperscriptBox["\[ExponentialE]", "T"], " ", "f", " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["g", "2"], " ", "Lr", " ", 
           SuperscriptBox["r", "5"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "f", " ", "L"}], "+", 
             RowBox[{"fr", " ", "L", " ", "r"}], "+", 
             RowBox[{"f", " ", "Lr", " ", "r"}]}], ")"}]}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "f", " ", "L"}], "+", 
             RowBox[{"fr", " ", "L", " ", "r"}], "+", 
             RowBox[{"f", " ", "Lr", " ", "r"}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "4"], " ", 
           SuperscriptBox["\[ExponentialE]", "S"], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["g", "2"], " ", 
           SuperscriptBox["r", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "f", " ", "L"}], "+", 
             RowBox[{"fr", " ", "L", " ", "r"}], "+", 
             RowBox[{"f", " ", "Lr", " ", "r"}]}], ")"}]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", "f", " ", "L"}], "-", 
             RowBox[{"2", " ", "fr", " ", "L", " ", "r"}], "+", 
             RowBox[{"3", " ", "f", " ", "Lr", " ", "r"}]}], ")"}]}], "-", 
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "fr", " ", "L", " ", "r"}], "+", 
             RowBox[{"f", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Lr", " ", "r"}], "+", 
                RowBox[{"4", " ", "L", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   RowBox[{"A", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
            ")"}]}]}], ")"}]}]}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", "g", " ", 
        SuperscriptBox["L", "2"], " ", "r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "S"}]], " ", "f", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"48", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "S"}], "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "S"}], "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "3"}], " ", "a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"g", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "6"}], " ", "L"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["a", "2"], " ", "B", " ", "L"}], "-", 
               RowBox[{"5", " ", "a", " ", "La"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"48", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]], 
          " ", "f", " ", "F", " ", "g", " ", "Lr", " ", "r"}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]}]], 
          " ", "f", " ", "F", " ", "g", " ", "Lr", " ", "r"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"3", " ", "S"}]}]], " ", 
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["g", "2"], " ", "La", " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{"24", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "g", " ", "L"}], "+", 
            RowBox[{"2", " ", "a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"3", " ", "a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{"24", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["g", "2"], " ", "Lr", " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", "S"], " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["a", "6"], " ", "f", " ", 
          SuperscriptBox["F", "5"], " ", 
          SuperscriptBox["g", "3"], " ", "Lr", " ", 
          SuperscriptBox["r", "5"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "S"}]}]], " ", "f", " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "L"}], "+", 
            RowBox[{"Lr", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"64", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "S"}], "+", "T"}]], " ", "f", " ", "F", " ", 
          "g", " ", "L", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"8", " ", "a", " ", 
        SuperscriptBox["L", "2"], " ", 
        SuperscriptBox["r", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "T"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "32"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"3", " ", "T"}]}]], " ", "F", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}]}], ")"}], " ", "g"}], 
            "-", 
            RowBox[{"a", " ", "ga"}]}], ")"}], " ", "L", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"16", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]], 
          " ", "F", " ", "g", " ", "La", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"16", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", "F", " ", "g", " ", 
          "La", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "T"}]}]], " ", "f", " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "Lr", " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["g", "2"], " ", "La", " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          SuperscriptBox["F", "3"], " ", "g", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["a", "5"], " ", 
          SuperscriptBox["F", "5"], " ", 
          SuperscriptBox["g", "3"], " ", "La", " ", 
          SuperscriptBox["r", "6"]}], "+", 
         RowBox[{"64", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"3", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", 
            RowBox[{"3", " ", "T"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "f", " ", "L"}], "+", 
            RowBox[{"fr", " ", "L", " ", "r"}], "+", 
            RowBox[{"f", " ", "Lr", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"32", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "f", " ", "L"}], "+", 
            RowBox[{"fr", " ", "L", " ", "r"}], "+", 
            RowBox[{"f", " ", "Lr", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", "T"], " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["r", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "f", " ", "L"}], "+", 
            RowBox[{"fr", " ", "L", " ", "r"}], "+", 
            RowBox[{"f", " ", "Lr", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["r", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "f", " ", "L"}], "+", 
            RowBox[{"fr", " ", "L", " ", "r"}], "+", 
            RowBox[{"f", " ", "Lr", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "f", " ", "L"}], "+", 
            RowBox[{"2", " ", "fr", " ", "L", " ", "r"}], "+", 
            RowBox[{"5", " ", "f", " ", "Lr", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"64", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", 
            RowBox[{"3", " ", "T"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "fr"}], " ", "L", " ", "r"}], "+", 
            RowBox[{"f", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "3"}], " ", "Lr", " ", "r"}], "+", 
               RowBox[{"2", " ", "L", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  RowBox[{"A", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}]}], ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "8"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "F", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}]}], ")"}], " ", "g"}], 
            "-", 
            RowBox[{"a", " ", "ga"}]}], ")"}], " ", "L", " ", "r"}], "+", 
         RowBox[{"4", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}], ")"}]}]], 
          " ", "F", " ", "g", " ", "La", " ", "r"}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "f", " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "Lr", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "f", " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "Lr", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["F", "3"], " ", "g", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"32", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "f", " ", 
          RowBox[{"(", 
           RowBox[{"Lr", "-", 
            RowBox[{"A", " ", "L", " ", "r"}]}], ")"}]}]}], ")"}]}], 
      RowBox[{"2", " ", "a", " ", 
       SuperscriptBox["L", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     FractionBox[
      RowBox[{"a", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"3", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "T"}], ")"}]}]], " ", "f", 
          " ", "Lr"}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "f", " ", "Lr"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "T"}], ")"}]}]], " ", "F", 
          " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", "r"}], "+", 
         RowBox[{
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["g", "2"], " ", "La", " ", 
          SuperscriptBox["r", "3"]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "f", " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "L", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", 
            RowBox[{"3", " ", "A", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox["L", "2"], " ", "r", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"8", " ", "a", " ", 
         SuperscriptBox["L", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["F", "2"], " ", "g", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "S"}], "-", "T"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "g", " ", "La"}], "+", 
          RowBox[{"16", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "g", " ", "La"}], "+", 
          RowBox[{"48", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "g", " ", "L"}], "+", 
             RowBox[{"a", " ", "ga", " ", "L"}], "+", 
             RowBox[{"a", " ", "g", " ", "La"}]}], ")"}]}], "-", 
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], " ", "a", " ", "ga", " ", "L"}], "+", 
             RowBox[{"g", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", "B"}]}], ")"}], " ", "L"}],
                 "+", 
                RowBox[{"a", " ", "La"}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"3", " ", "T"}]}]], " ", "f", " ", "F", " ", "g", " ", 
           "Lr", " ", "r"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["a", "3"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["g", "2"], " ", "La", " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["a", "3"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["g", "2"], " ", "La", " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"24", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "g", " ", "L"}], "+", 
             RowBox[{"a", " ", "ga", " ", "L"}], "+", 
             RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", "g", " ", "L"}], "+", 
             RowBox[{"a", " ", "ga", " ", "L"}], "+", 
             RowBox[{"3", " ", "a", " ", "g", " ", "La"}]}], ")"}], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "5"], " ", 
           SuperscriptBox["\[ExponentialE]", "S"], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["g", "3"], " ", "La", " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["a", "4"], " ", 
           SuperscriptBox["\[ExponentialE]", "T"], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["g", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "g", " ", "L"}], "+", 
             RowBox[{"a", " ", "ga", " ", "L"}], "+", 
             RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", "f", " ", "F", " ", 
           "g", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Lr", " ", "r"}], "+", 
             RowBox[{"L", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", 
                RowBox[{"4", " ", "A", " ", 
                 SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
         ")"}]}]}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"8", " ", "a", " ", 
        SuperscriptBox["L", "2"], " ", "r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "S"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "128"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "S"}], "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "f", " ", "Lr"}], "+", 
         RowBox[{"64", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"3", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", 
            RowBox[{"3", " ", "T"}]}]], " ", "f", " ", "Lr"}], "+", 
         RowBox[{"192", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"3", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", 
            RowBox[{"3", " ", "T"}]}]], " ", "f", " ", "Lr"}], "+", 
         RowBox[{"48", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]], 
          " ", "F", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", "r"}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]}]], 
          " ", "F", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", "r"}], "-", 
         RowBox[{"96", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "f", " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "Lr", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "S"}]}]], " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["g", "2"], " ", "La", " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"24", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
          SuperscriptBox["F", "3"], " ", "g", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"12", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", "S"], " ", "f", " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", "Lr", " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "f", " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", "Lr", " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["F", "5"], " ", 
          SuperscriptBox["g", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "5"]}], "+", 
         RowBox[{"32", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "f", " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "Lr", " ", "r"}], "+", 
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", 
               RowBox[{"3", " ", "A", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "S"}], "-", "T"}]], " ", "f", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "f", " ", "Lr", " ", "r"}], "+", 
          RowBox[{"12", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "f", " ", "Lr", " ", "r"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "fr", " ", "L"}], "-", 
             RowBox[{"f", " ", "Lr"}]}], ")"}], " ", "r"}], "+", 
          RowBox[{"2", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"S", "+", "T"}]], " ", "F", " ", "g", " ", "La", " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", "T"], " ", "f", " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "Lr", " ", 
           SuperscriptBox["r", "3"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "f", " ", "L"}], "+", 
             RowBox[{"fr", " ", "L", " ", "r"}], "+", 
             RowBox[{"f", " ", "Lr", " ", "r"}]}], ")"}]}], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", "S"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "f", " ", "L"}], "+", 
             RowBox[{"fr", " ", "L", " ", "r"}], "+", 
             RowBox[{"f", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["L", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "r"}], 
          "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "3"]}]}], ")"}]}]]}], ",", "0", ",", "0", ",", 
     "0", ",", "0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "S"}], "-", "T"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "g", " ", "La"}], "-", 
         RowBox[{"4", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "g", " ", "La"}], "-", 
         RowBox[{"4", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"ga", " ", "L"}], "-", 
            RowBox[{"g", " ", "La"}]}], ")"}]}], "-", 
         RowBox[{"12", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"S", "+", "T"}]], " ", "f", " ", "F", " ", "g", " ", "Lr", 
          " ", "r"}], "+", 
         RowBox[{
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["\[ExponentialE]", "S"], " ", 
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["g", "2"], " ", "La", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", "T"], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      RowBox[{"8", " ", 
       SuperscriptBox["L", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
         RowBox[{
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.460389781388674*^9, {3.46039000355186*^9, 3.4603900790022993`*^9}, 
   3.460390455859743*^9, 3.4603923698752823`*^9, 3.460392964550579*^9, 
   3.4603931986963263`*^9, 3.460393229965225*^9, {3.460397066110239*^9, 
   3.4603569126685658`*^9}, 3.4603669781520042`*^9, 3.4603726730397673`*^9, 
   3.542470124127782*^9, 3.5435574902117453`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"newcoeffderiv2", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Inverse", "[", "coeff\[Lambda]", "]"}], ".", 
    RowBox[{"coeffs", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "6"}], "]"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.460389677337183*^9, 3.46038967741394*^9}, {
  3.460389736618752*^9, 3.460389758915694*^9}, {3.460389796733444*^9, 
  3.460389803844365*^9}, {3.460390082766027*^9, 3.460390102284062*^9}, {
  3.460390466675829*^9, 3.460390470324645*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "A"}], " ", 
           SuperscriptBox["r", "2"]}], "-", "T"}]], " ", 
        SuperscriptBox["f", "2"], " ", 
        SuperscriptBox["F", "2"], " ", "g", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "16"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       RowBox[{"2", " ", "L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     FractionBox[
      RowBox[{"8", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
       SuperscriptBox["f", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
       SuperscriptBox["f", "2"], " ", 
       SuperscriptBox["F", "2"], " ", "g"}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"16", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
        SuperscriptBox["f", "2"], " ", "F", " ", "g"}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
       SuperscriptBox["f", "2"], " ", 
       SuperscriptBox["F", "2"], " ", "g"}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        SuperscriptBox["a", "3"], " ", "f", " ", 
        SuperscriptBox["F", "3"], " ", 
        SuperscriptBox["g", "2"], " ", "r"}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        SuperscriptBox["a", "3"], " ", "f", " ", 
        SuperscriptBox["F", "3"], " ", 
        SuperscriptBox["g", "2"], " ", 
        SuperscriptBox["r", "3"]}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", "0", ",", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["a", "3"], " ", "f", " ", 
       SuperscriptBox["F", "2"], " ", 
       SuperscriptBox["g", "2"], " ", "r"}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", "0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
       SuperscriptBox["f", "2"], " ", 
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
       SuperscriptBox["f", "2"], " ", 
       SuperscriptBox["F", "2"], " ", "g", " ", 
       SuperscriptBox["r", "2"]}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"16", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
        SuperscriptBox["f", "2"], " ", "F", " ", "g", " ", 
        SuperscriptBox["r", "2"]}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
       SuperscriptBox["f", "2"], " ", 
       SuperscriptBox["F", "2"], " ", "g", " ", 
       SuperscriptBox["r", "2"]}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        SuperscriptBox["a", "3"], " ", "f", " ", 
        SuperscriptBox["F", "3"], " ", 
        SuperscriptBox["g", "2"], " ", 
        SuperscriptBox["r", "3"]}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        SuperscriptBox["a", "3"], " ", "f", " ", 
        SuperscriptBox["F", "3"], " ", 
        SuperscriptBox["g", "2"], " ", 
        SuperscriptBox["r", "5"]}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", "0", ",", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["a", "3"], " ", "f", " ", 
       SuperscriptBox["F", "2"], " ", 
       SuperscriptBox["g", "2"], " ", 
       SuperscriptBox["r", "3"]}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"8", " ", 
        SuperscriptBox["a", "4"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
        SuperscriptBox["f", "2"]}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "r"}], 
           "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "3"]}]}], ")"}], "2"]}]]}], ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"16", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
        SuperscriptBox["f", "2"]}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "r"}], 
           "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "3"]}]}], ")"}], "2"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"8", " ", 
        SuperscriptBox["a", "3"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", " ", 
        "F", " ", "g"}], 
       RowBox[{"L", " ", "r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"8", " ", 
        SuperscriptBox["a", "3"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", " ", 
        "F", " ", "g", " ", "r"}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", "0", ",", 
     FractionBox[
      RowBox[{"8", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "+", 
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", " ", 
       "g"}], 
      RowBox[{"L", " ", "r", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", "0", ",", 
     FractionBox[
      RowBox[{"8", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
       SuperscriptBox["f", "2"], " ", "g"}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", "0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "3"], " ", "f", " ", 
       SuperscriptBox["F", "2"], " ", 
       SuperscriptBox["g", "2"], " ", "r"}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "3"], " ", "f", " ", 
       SuperscriptBox["F", "2"], " ", 
       SuperscriptBox["g", "2"], " ", 
       SuperscriptBox["r", "3"]}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["a", "3"], " ", "f", " ", "F", " ", 
        SuperscriptBox["g", "2"], " ", "r"}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "A"}], " ", 
           SuperscriptBox["r", "2"]}], "-", "T"}]], " ", 
        SuperscriptBox["f", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"64", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]]}], 
          "-", 
          RowBox[{"24", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["a", "4"], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["g", "2"], " ", 
           SuperscriptBox["r", "4"]}]}], ")"}]}], 
       RowBox[{"2", " ", "L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "r"}], 
           "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "3"]}]}], ")"}], "2"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"8", " ", "a", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", " ", 
        "F", " ", "g"}], 
       RowBox[{"L", " ", "r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"8", " ", "a", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", " ", 
        "F", " ", "g", " ", "r"}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", "0", ",", 
     FractionBox[
      RowBox[{"8", " ", "a", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "+", 
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", " ", 
       "g"}], 
      RowBox[{"L", " ", "r", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"8", " ", "a", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", " ", 
        "F", " ", "g", " ", "r"}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"8", " ", "a", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", " ", 
        "F", " ", "g", " ", 
        SuperscriptBox["r", "3"]}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        SuperscriptBox["a", "5"], " ", "f", " ", 
        SuperscriptBox["F", "3"], " ", 
        SuperscriptBox["g", "2"], " ", 
        SuperscriptBox["r", "3"]}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "3"], " ", "f", " ", 
       SuperscriptBox["F", "2"], " ", 
       SuperscriptBox["g", "2"], " ", 
       SuperscriptBox["r", "3"]}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        SuperscriptBox["a", "3"], " ", "f", " ", 
        SuperscriptBox["F", "3"], " ", 
        SuperscriptBox["g", "2"], " ", 
        SuperscriptBox["r", "3"]}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", "0", ",", 
     "0", ",", 
     FractionBox[
      RowBox[{"8", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "+", 
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", " ", 
       "g", " ", "r"}], 
      RowBox[{"a", " ", "L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     FractionBox[
      RowBox[{"8", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "+", 
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", " ", 
       "g", " ", 
       SuperscriptBox["r", "3"]}], 
      RowBox[{"a", " ", "L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["a", "3"], " ", "f", " ", 
       SuperscriptBox["F", "2"], " ", 
       SuperscriptBox["g", "2"], " ", 
       SuperscriptBox["r", "3"]}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", "a", " ", "f", " ", "F", " ", 
        SuperscriptBox["g", "2"], " ", 
        SuperscriptBox["r", "3"]}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     FractionBox[
      RowBox[{"2", " ", "a", " ", "f", " ", 
       SuperscriptBox["F", "2"], " ", 
       SuperscriptBox["g", "2"], " ", 
       SuperscriptBox["r", "3"]}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"8", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", " ", 
        "F", " ", "g", " ", "r"}], 
       RowBox[{"a", " ", "L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"8", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", " ", 
        "F", " ", "g", " ", 
        SuperscriptBox["r", "3"]}], 
       RowBox[{"a", " ", "L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        SuperscriptBox["a", "3"], " ", "f", " ", 
        SuperscriptBox["F", "3"], " ", 
        SuperscriptBox["g", "2"], " ", 
        SuperscriptBox["r", "3"]}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     FractionBox[
      RowBox[{"4", " ", "a", " ", "f", " ", 
       SuperscriptBox["F", "2"], " ", 
       SuperscriptBox["g", "2"], " ", 
       SuperscriptBox["r", "3"]}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "a", " ", "f", " ", 
        SuperscriptBox["F", "3"], " ", 
        SuperscriptBox["g", "2"], " ", 
        SuperscriptBox["r", "3"]}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["a", "2"]}], " ", "B"}], "-", "S"}]], " ", "g", 
        " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"32", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]]}], 
          "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "4"], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["g", "2"], " ", 
           SuperscriptBox["r", "4"]}]}], ")"}]}], 
       RowBox[{"8", " ", "L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", "a", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "3"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"2", " ", "A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", 
          RowBox[{"2", " ", "T"}]}]], " ", "g", " ", 
        SuperscriptBox["r", "2"]}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", "a", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "3"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
       SuperscriptBox["F", "2"], " ", 
       SuperscriptBox["g", "2"], " ", 
       SuperscriptBox["r", "2"]}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", "0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
       SuperscriptBox["F", "2"], " ", 
       SuperscriptBox["g", "2"], " ", 
       SuperscriptBox["r", "2"]}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"2", " ", "A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", 
          RowBox[{"2", " ", "T"}]}]], " ", "g", " ", 
        SuperscriptBox["r", "4"]}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", "a", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "3"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
       SuperscriptBox["F", "2"], " ", 
       SuperscriptBox["g", "2"], " ", 
       SuperscriptBox["r", "4"]}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", "0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
       SuperscriptBox["F", "2"], " ", 
       SuperscriptBox["g", "2"], " ", 
       SuperscriptBox["r", "4"]}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "g", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "F", " ", 
        SuperscriptBox["g", "2"], " ", 
        SuperscriptBox["r", "2"]}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "g", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
       SuperscriptBox["g", "2"], " ", 
       SuperscriptBox["r", "2"]}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "F", " ", 
        SuperscriptBox["g", "2"], " ", 
        SuperscriptBox["r", "2"]}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["a", "2"]}], " ", "B"}], "-", "S"}]], " ", "g", 
        " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"32", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]]}], 
          "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["a", "4"], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["g", "2"], " ", 
           SuperscriptBox["r", "4"]}]}], ")"}]}], 
       RowBox[{"8", " ", "L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", "a", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "3"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"16", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
        SuperscriptBox["f", "2"], " ", "F"}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     FractionBox[
      RowBox[{"16", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", "B"}], "+", 
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
       SuperscriptBox["f", "2"]}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"16", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
        SuperscriptBox["f", "2"], " ", "F"}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"a", " ", "f", " ", 
        SuperscriptBox["F", "2"], " ", "g", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "8"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       RowBox[{"2", " ", "L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     FractionBox[
      RowBox[{"8", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]], " ", 
       "f", " ", "r"}], 
      RowBox[{"a", " ", "L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     FractionBox[
      RowBox[{"6", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "+", 
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", " ", 
       SuperscriptBox["F", "2"], " ", "g", " ", "r"}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"8", " ", "a", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", " ", 
        "F", " ", "g", " ", "r"}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     FractionBox[
      RowBox[{"6", " ", "a", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "+", 
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", " ", 
       SuperscriptBox["F", "2"], " ", "g", " ", "r"}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"16", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
        SuperscriptBox["f", "2"], " ", "F", " ", 
        SuperscriptBox["r", "2"]}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     FractionBox[
      RowBox[{"16", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", "B"}], "+", 
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
       SuperscriptBox["f", "2"], " ", 
       SuperscriptBox["r", "2"]}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"16", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
        SuperscriptBox["f", "2"], " ", "F", " ", 
        SuperscriptBox["r", "2"]}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     FractionBox[
      RowBox[{"8", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]], " ", 
       "f", " ", "r"}], 
      RowBox[{"a", " ", "L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     FractionBox[
      RowBox[{"8", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]], " ", 
       "f", " ", 
       SuperscriptBox["r", "3"]}], 
      RowBox[{"a", " ", "L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     FractionBox[
      RowBox[{"6", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "+", 
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", " ", 
       SuperscriptBox["F", "2"], " ", "g", " ", 
       SuperscriptBox["r", "3"]}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"8", " ", "a", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", " ", 
        "F", " ", "g", " ", 
        SuperscriptBox["r", "3"]}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     FractionBox[
      RowBox[{"6", " ", "a", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "+", 
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", " ", 
       SuperscriptBox["F", "2"], " ", "g", " ", 
       SuperscriptBox["r", "3"]}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"16", " ", 
        SuperscriptBox["a", "4"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
        SuperscriptBox["f", "2"], " ", "F"}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
       SuperscriptBox["f", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"32", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
        SuperscriptBox["f", "2"], " ", "F"}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "a", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       RowBox[{"L", " ", "r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "a", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", " ", 
        "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     FractionBox[
      RowBox[{"8", " ", 
       SuperscriptBox["a", "3"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]], " ", 
       "f"}], 
      RowBox[{"L", " ", "r", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", "0", ",", 
     FractionBox[
      RowBox[{"8", " ", "a", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]], " ", 
       "f"}], 
      RowBox[{"L", " ", "r", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"8", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
        SuperscriptBox["f", "2"], " ", "F", " ", "g", " ", 
        SuperscriptBox["r", "2"]}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
       SuperscriptBox["f", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", "0", ",", "0", 
     ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"8", " ", 
        SuperscriptBox["a", "3"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", " ", 
        "F", " ", "g", " ", "r"}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["a", "3"], " ", "f", " ", 
       SuperscriptBox["F", "2"], " ", 
       SuperscriptBox["g", "2"], " ", 
       SuperscriptBox["r", "3"]}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"8", " ", "a", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", " ", 
        "F", " ", "g", " ", "r"}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"16", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
        SuperscriptBox["f", "2"], " ", "F"}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       RowBox[{"a", " ", "L", " ", "r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", " ", 
        "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       RowBox[{"a", " ", "L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     FractionBox[
      RowBox[{"8", " ", "a", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]], " ", 
       "f"}], 
      RowBox[{"L", " ", "r", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", "0", ",", 
     FractionBox[
      RowBox[{"f", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "32"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]]}], 
         "+", 
         RowBox[{"24", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["r", "4"]}]}], ")"}]}], 
      RowBox[{"2", " ", "a", " ", "L", " ", "r", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"2", " ", "A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", 
          RowBox[{"2", " ", "T"}]}]], " ", "F", " ", "g"}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"8", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"2", " ", "A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", 
          RowBox[{"2", " ", "T"}]}]], " ", "F", " ", "g", " ", 
        SuperscriptBox["r", "2"]}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"2", " ", "A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", 
          RowBox[{"2", " ", "T"}]}]], " ", "F", " ", "g"}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "g", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"2", " ", "A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", 
          RowBox[{"2", " ", "T"}]}]], " ", "F", " ", "g"}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"2", " ", "A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", 
          RowBox[{"2", " ", "T"}]}]], " ", "F", " ", "g", " ", 
        SuperscriptBox["r", "4"]}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"2", " ", "A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", 
          RowBox[{"2", " ", "T"}]}]], " ", "F", " ", "g", " ", 
        SuperscriptBox["r", "2"]}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "g", " ", 
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"2", " ", "A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", 
          RowBox[{"2", " ", "T"}]}]], " ", "F", " ", "g", " ", 
        SuperscriptBox["r", "2"]}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", "0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "+", 
         RowBox[{"2", " ", "A", " ", 
          SuperscriptBox["r", "2"]}], "+", "S", "+", 
         RowBox[{"2", " ", "T"}]}]], " ", "g"}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "F", " ", 
        SuperscriptBox["g", "2"], " ", 
        SuperscriptBox["r", "2"]}], 
       RowBox[{"L", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "+", 
         RowBox[{"2", " ", "A", " ", 
          SuperscriptBox["r", "2"]}], "+", "S", "+", 
         RowBox[{"2", " ", "T"}]}]], " ", "g"}], 
      RowBox[{"L", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.460389677815357*^9, {3.460389737137396*^9, 3.4603897592620487`*^9}, 
   3.460389810587908*^9, {3.460390089264263*^9, 3.4603901069757357`*^9}, 
   3.460390471414308*^9, 3.4603923955552*^9, {3.460392977796986*^9, 
   3.4603929880974617`*^9}, 3.460393230335843*^9, {3.4603970681219587`*^9, 
   3.460356914491908*^9}, 3.460366979916485*^9, 3.4603726748853207`*^9, 
   3.542470125385207*^9, 3.5435574914490633`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"newcoeffnoderiv", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Inverse", "[", "coeff\[Lambda]", "]"}], ".", 
    RowBox[{"coeffs", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "7"}], "]"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.460389804978067*^9, {3.4603904743722563`*^9, 3.4603904787840433`*^9}, {
   3.4603920136607027`*^9, 3.460392015585368*^9}, {3.460392419386147*^9, 
   3.46039242142269*^9}, {3.460392996645005*^9, 3.4603929972181597`*^9}, {
   3.46039309162958*^9, 3.460393092124995*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"8", " ", 
       SuperscriptBox["L", "3"], " ", 
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
         RowBox[{
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}]], 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "S"}], "-", "T"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"24", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", 
           RowBox[{"2", " ", "T"}]}]], " ", "g", " ", "L", " ", "La", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["\[ExponentialE]", "T"], " ", "F", " ", "g", " ", 
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", "F", " ", "g", " ", "L", " ", "La", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["\[ExponentialE]", "S"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"fr", " ", "L", " ", "La", " ", "r"}], "+", 
              RowBox[{"2", " ", "f", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"L", " ", "La"}], "+", 
                 RowBox[{"2", " ", "La", " ", "Lr", " ", "r"}], "-", 
                 RowBox[{"L", " ", "Lra", " ", "r"}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "3"], " ", 
         SuperscriptBox["F", "2"], " ", "g", " ", 
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["\[ExponentialE]", "T"], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"La", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"ga", " ", "L"}], "+", 
                 RowBox[{"g", " ", "La"}]}], ")"}], " ", "r"}], "+", 
              RowBox[{
              "4", " ", "f", " ", "fr", " ", "L", " ", "Lr", " ", "r"}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["f", "2"], " ", "Lr", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "L"}], "+", 
                 RowBox[{"Lr", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", "S"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"4", " ", 
                  SuperscriptBox["fr", "2"], " ", 
                  SuperscriptBox["L", "2"]}], "+", 
                 RowBox[{"g", " ", 
                  SuperscriptBox["La", "2"]}]}], ")"}], " ", 
               SuperscriptBox["r", "2"]}], "+", 
              RowBox[{"8", " ", "f", " ", "fr", " ", "L", " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "L"}], "+", 
                 RowBox[{"Lr", " ", "r"}]}], ")"}]}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["f", "2"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "L"}], "+", 
                  RowBox[{"Lr", " ", "r"}]}], ")"}], "2"]}]}], ")"}]}], "+", 
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"S", "+", "T"}]], " ", 
            SuperscriptBox["L", "3"], " ", 
            SuperscriptBox["r", "2"], " ", "\[CapitalLambda]"}]}], ")"}]}], 
        "+", 
        RowBox[{"4", " ", "a", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"S", "+", "T"}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"La", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"ga", " ", "L"}], "+", 
                 RowBox[{"g", " ", "La"}]}], ")"}], " ", "r"}], "+", 
              RowBox[{
              "4", " ", "f", " ", "fr", " ", "L", " ", "Lr", " ", "r"}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["f", "2"], " ", "Lr", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "L"}], "+", 
                 RowBox[{"Lr", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"ga", " ", "L", " ", "La"}], "-", 
                 RowBox[{"3", " ", "g", " ", 
                  SuperscriptBox["La", "2"]}], "+", 
                 RowBox[{"2", " ", "g", " ", "L", " ", "Laa"}]}], ")"}], " ", 
               "r"}], "+", 
              RowBox[{
              "4", " ", "f", " ", "fr", " ", "L", " ", "Lr", " ", "r"}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["f", "2"], " ", "Lr", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "L"}], "+", 
                 RowBox[{"Lr", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S"}]], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"4", " ", 
                  SuperscriptBox["fr", "2"], " ", 
                  SuperscriptBox["L", "2"]}], "+", 
                 RowBox[{"g", " ", 
                  SuperscriptBox["La", "2"]}]}], ")"}], " ", 
               SuperscriptBox["r", "2"]}], "+", 
              RowBox[{"8", " ", "f", " ", "fr", " ", "L", " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "L"}], "+", 
                 RowBox[{"Lr", " ", "r"}]}], ")"}]}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["f", "2"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "L"}], "+", 
                  RowBox[{"Lr", " ", "r"}]}], ")"}], "2"]}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"g", " ", 
               SuperscriptBox["La", "2"], " ", 
               SuperscriptBox["r", "2"]}], "+", 
              RowBox[{"4", " ", "f", " ", "L", " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"4", " ", "fr", " ", "L"}], "+", 
                 RowBox[{"2", " ", "frr", " ", "L", " ", "r"}], "+", 
                 RowBox[{"fr", " ", "Lr", " ", "r"}]}], ")"}]}], "-", 
              RowBox[{"4", " ", 
               SuperscriptBox["f", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"4", " ", 
                  SuperscriptBox["L", "2"]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["Lr", "2"], " ", 
                  SuperscriptBox["r", "2"]}], "+", 
                 RowBox[{"2", " ", "L", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"Lr", "-", 
                    RowBox[{"Lrr", " ", "r"}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
            SuperscriptBox["L", "3"], " ", 
            SuperscriptBox["r", "2"], " ", "\[CapitalLambda]"}]}], ")"}]}]}], 
       ")"}]}]}]}], ",", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"4", " ", 
      SuperscriptBox["L", "3"], " ", 
      SuperscriptBox["r", "4"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "A"}], " ", 
        SuperscriptBox["r", "2"]}], "-", "S", "-", 
       RowBox[{"2", " ", "T"}]}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"16", " ", "a", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"2", " ", "A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"3", " ", "S"}], "+", 
          RowBox[{"2", " ", "T"}]}]], " ", "f", " ", "F", " ", "g", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "La", " ", "Lr"}], "-", 
          RowBox[{"L", " ", "Lra"}]}], ")"}], " ", 
        SuperscriptBox["r", "3"]}], "+", 
       RowBox[{"48", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"2", " ", "A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", "S"}], "+", 
          RowBox[{"3", " ", "T"}]}]], " ", "f", " ", "F", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "ga", " ", "L", " ", "Lr"}], "+", 
          RowBox[{"g", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "L", " ", "Lr"}], "+", 
             RowBox[{"2", " ", "a", " ", "La", " ", "Lr"}], "-", 
             RowBox[{"a", " ", "L", " ", "Lra"}]}], ")"}]}]}], ")"}], " ", 
        SuperscriptBox["r", "3"]}], "-", 
       RowBox[{"8", " ", 
        SuperscriptBox["a", "3"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "f", " ", 
        SuperscriptBox["F", "3"], " ", 
        SuperscriptBox["g", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "La", " ", "Lr"}], "-", 
          RowBox[{"L", " ", "Lra"}]}], ")"}], " ", 
        SuperscriptBox["r", "5"]}], "+", 
       RowBox[{"24", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", 
          RowBox[{"2", " ", "T"}]}]], " ", "f", " ", 
        SuperscriptBox["F", "3"], " ", "g", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "a"}], " ", "ga", " ", "L", " ", "Lr"}], "+", 
          RowBox[{"g", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "L", " ", "Lr"}], "-", 
             RowBox[{"2", " ", "a", " ", "La", " ", "Lr"}], "+", 
             RowBox[{"a", " ", "L", " ", "Lra"}]}], ")"}]}]}], ")"}], " ", 
        SuperscriptBox["r", "5"]}], "+", 
       RowBox[{
        SuperscriptBox["a", "5"], " ", 
        SuperscriptBox["\[ExponentialE]", "S"], " ", "f", " ", 
        SuperscriptBox["F", "5"], " ", 
        SuperscriptBox["g", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "La", " ", "Lr"}], "-", 
          RowBox[{"L", " ", "Lra"}]}], ")"}], " ", 
        SuperscriptBox["r", "7"]}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["a", "4"], " ", 
        SuperscriptBox["\[ExponentialE]", "T"], " ", "f", " ", 
        SuperscriptBox["F", "5"], " ", 
        SuperscriptBox["g", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "a"}], " ", "ga", " ", "L", " ", "Lr"}], "+", 
          RowBox[{"g", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "L", " ", "Lr"}], "-", 
             RowBox[{"2", " ", "a", " ", "La", " ", "Lr"}], "+", 
             RowBox[{"a", " ", "L", " ", "Lra"}]}], ")"}]}]}], ")"}], " ", 
        SuperscriptBox["r", "7"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["a", "3"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "f", " ", 
        SuperscriptBox["F", "3"], " ", 
        SuperscriptBox["g", "2"], " ", 
        SuperscriptBox["r", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", "L", " ", "La"}], "-", 
          RowBox[{"2", " ", "La", " ", "Lr", " ", "r"}], "+", 
          RowBox[{"L", " ", "Lra", " ", "r"}]}], ")"}]}], "+", 
       RowBox[{"16", " ", "a", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"3", " ", "S"}], "+", 
          RowBox[{"2", " ", "T"}]}]], " ", "f", " ", "F", " ", "g", " ", 
        SuperscriptBox["r", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "L"}], " ", "Lra"}], "+", 
          RowBox[{"2", " ", "La", " ", 
           RowBox[{"(", 
            RowBox[{"Lr", "+", 
             RowBox[{"A", " ", "L", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "4"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"S", "+", "T"}]], " ", 
        SuperscriptBox["F", "4"], " ", 
        SuperscriptBox["g", "2"], " ", 
        SuperscriptBox["r", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["fr", "2"], " ", 
           SuperscriptBox["L", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", "f", " ", "fr", " ", "L", " ", "r", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "L"}], "-", 
             RowBox[{"Lr", " ", "r"}]}], ")"}]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["f", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["L", "2"], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["Lr", "2"], " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"L", " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "Lr"}], "-", 
                RowBox[{"Lrr", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       "-", 
       RowBox[{"32", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"3", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]}]], 
        " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["fr", "2"]}], " ", 
           SuperscriptBox["L", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"f", " ", "L", " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "frr", " ", "L"}], "-", 
             RowBox[{"fr", " ", "Lr"}], "+", 
             RowBox[{"2", " ", "A", " ", "fr", " ", "L", " ", "r"}]}], 
            ")"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["f", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              SuperscriptBox["Lr", "2"], " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["L", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", 
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
             RowBox[{"L", " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "3"}], " ", "Lr"}], "+", 
                RowBox[{"Lrr", " ", "r"}], "+", 
                RowBox[{"A", " ", "Lr", " ", 
                 SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       "+", 
       RowBox[{"16", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]}]], 
        " ", 
        SuperscriptBox["F", "2"], " ", "g", " ", 
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["fr", "2"]}], " ", 
           SuperscriptBox["L", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"f", " ", "L", " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "frr", " ", "L"}], "-", 
             RowBox[{"fr", " ", "Lr"}], "+", 
             RowBox[{"2", " ", "A", " ", "fr", " ", "L", " ", "r"}]}], 
            ")"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["f", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              SuperscriptBox["Lr", "2"], " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["L", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", 
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
             RowBox[{"L", " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "3"}], " ", "Lr"}], "+", 
                RowBox[{"Lrr", " ", "r"}], "+", 
                RowBox[{"A", " ", "Lr", " ", 
                 SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "4"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
        SuperscriptBox["F", "4"], " ", 
        SuperscriptBox["g", "2"], " ", 
        SuperscriptBox["r", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["fr", "2"]}], " ", 
           SuperscriptBox["L", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"f", " ", "L", " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "frr", " ", "L"}], "-", 
             RowBox[{"fr", " ", "Lr"}], "+", 
             RowBox[{"2", " ", "A", " ", "fr", " ", "L", " ", "r"}]}], 
            ")"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["f", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              SuperscriptBox["Lr", "2"], " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["L", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", 
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
             RowBox[{"L", " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "3"}], " ", "Lr"}], "+", 
                RowBox[{"Lrr", " ", "r"}], "+", 
                RowBox[{"A", " ", "Lr", " ", 
                 SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       "-", 
       RowBox[{"32", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"3", " ", "A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", "S"}], "+", 
          RowBox[{"4", " ", "T"}]}]], " ", "f", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"fr", " ", "L", " ", "Lr", " ", "r"}], "+", 
          RowBox[{"2", " ", "f", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              SuperscriptBox["Lr", "2"], " ", "r"}], "+", 
             RowBox[{"L", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "Lr"}], "+", 
                RowBox[{"Lrr", " ", "r"}], "+", 
                RowBox[{"A", " ", "Lr", " ", 
                 SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       "-", 
       RowBox[{"96", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"3", " ", "A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", "S"}], "+", 
          RowBox[{"4", " ", "T"}]}]], " ", "f", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"fr", " ", "L", " ", "Lr", " ", "r"}], "+", 
          RowBox[{"2", " ", "f", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              SuperscriptBox["Lr", "2"], " ", "r"}], "+", 
             RowBox[{"L", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "Lr"}], "+", 
                RowBox[{"Lrr", " ", "r"}], "+", 
                RowBox[{"A", " ", "Lr", " ", 
                 SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       "+", 
       RowBox[{"48", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"2", " ", "A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", 
          RowBox[{"3", " ", "T"}]}]], " ", "f", " ", 
        SuperscriptBox["F", "2"], " ", "g", " ", 
        SuperscriptBox["r", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"fr", " ", "L", " ", "Lr", " ", "r"}], "+", 
          RowBox[{"2", " ", "f", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              SuperscriptBox["Lr", "2"], " ", "r"}], "+", 
             RowBox[{"L", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "Lr"}], "+", 
                RowBox[{"Lrr", " ", "r"}], "+", 
                RowBox[{"A", " ", "Lr", " ", 
                 SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       "-", 
       RowBox[{"6", " ", 
        SuperscriptBox["a", "4"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", "T"}]}]], " ", "f", " ", 
        SuperscriptBox["F", "4"], " ", 
        SuperscriptBox["g", "2"], " ", 
        SuperscriptBox["r", "5"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"fr", " ", "L", " ", "Lr", " ", "r"}], "+", 
          RowBox[{"2", " ", "f", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              SuperscriptBox["Lr", "2"], " ", "r"}], "+", 
             RowBox[{"L", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "Lr"}], "+", 
                RowBox[{"Lrr", " ", "r"}], "+", 
                RowBox[{"A", " ", "Lr", " ", 
                 SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"2", " ", "A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", 
          RowBox[{"3", " ", "T"}]}]], " ", "f", " ", 
        SuperscriptBox["F", "2"], " ", "g", " ", 
        SuperscriptBox["r", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"fr", " ", "L", " ", "Lr", " ", "r"}], "+", 
          RowBox[{"2", " ", "f", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              SuperscriptBox["Lr", "2"], " ", "r"}], "+", 
             RowBox[{"L", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "3"}], " ", "Lr"}], "+", 
                RowBox[{"Lrr", " ", "r"}], "+", 
                RowBox[{"3", " ", "A", " ", "Lr", " ", 
                 SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       "+", 
       RowBox[{"32", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"2", " ", "A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"3", " ", 
           RowBox[{"(", 
            RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["fr", "2"]}], " ", 
           SuperscriptBox["L", "2"], " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"f", " ", "L", " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "frr", " ", "L"}], "+", 
             RowBox[{"fr", " ", 
              RowBox[{"(", 
               RowBox[{"Lr", "+", 
                RowBox[{"4", " ", "A", " ", "L", " ", "r"}]}], ")"}]}]}], 
            ")"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["f", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "4"}], " ", 
              SuperscriptBox["Lr", "2"], " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"L", " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "3"}], " ", "Lr"}], "+", 
                RowBox[{"Lrr", " ", "r"}], "+", 
                RowBox[{"A", " ", "Lr", " ", 
                 SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["L", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "-", 
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", 
                RowBox[{
                 SuperscriptBox["A", "2"], " ", 
                 SuperscriptBox["r", "4"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
        SuperscriptBox["F", "2"], " ", "g", " ", 
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["fr", "2"], " ", 
           SuperscriptBox["L", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"f", " ", "L", " ", "r", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "frr", " ", "L", " ", "r"}], "+", 
             RowBox[{"fr", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", "L"}], "-", 
                RowBox[{"Lr", " ", "r"}], "+", 
                RowBox[{"4", " ", "A", " ", "L", " ", 
                 SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["f", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"10", " ", 
              SuperscriptBox["Lr", "2"], " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"L", " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"5", " ", "Lr"}], "-", 
                RowBox[{"3", " ", "Lrr", " ", "r"}], "+", 
                RowBox[{"A", " ", "Lr", " ", 
                 SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["L", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"8", "-", 
                RowBox[{"6", " ", "A", " ", 
                 SuperscriptBox["r", "2"]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["A", "2"], " ", 
                 SuperscriptBox["r", "4"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", 
          RowBox[{"2", " ", "T"}]}]], " ", 
        SuperscriptBox["F", "3"], " ", "g", " ", 
        SuperscriptBox["r", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "a"}], " ", "fr", " ", "g", " ", "L", " ", "La", " ", 
           "r"}], "+", 
          RowBox[{"f", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", " ", "ga", " ", "L", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "Lr"}], " ", "r"}], "+", 
                RowBox[{"2", " ", "L", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   RowBox[{"A", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"g", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], " ", "a", " ", "La", " ", "Lr", " ", 
                 "r"}], "+", 
                RowBox[{"L", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "2"}], " ", "a", " ", "La"}], "-", 
                   RowBox[{"2", " ", "Lr", " ", "r"}], "+", 
                   RowBox[{"a", " ", "Lra", " ", "r"}]}], ")"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["L", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   RowBox[{"A", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
            ")"}]}]}], ")"}]}], "+", 
       RowBox[{"16", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"2", " ", "A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", "S"}], "+", 
          RowBox[{"3", " ", "T"}]}]], " ", "F", " ", 
        SuperscriptBox["r", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "f", " ", "g", " ", "L", " ", "Lr"}], "+", 
          RowBox[{"a", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"fr", " ", "g", " ", "L", " ", "La"}], "+", 
             RowBox[{"f", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"ga", " ", "L", " ", "Lr"}], "+", 
                RowBox[{"g", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "L"}], " ", "Lra"}], "+", 
                   RowBox[{"2", " ", "La", " ", 
                    RowBox[{"(", 
                    RowBox[{"Lr", "+", 
                    RowBox[{"A", " ", "L", " ", "r"}]}], ")"}]}]}], ")"}]}]}],
                ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"8", " ", 
      SuperscriptBox["a", "4"], " ", "g", " ", 
      SuperscriptBox["L", "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], " ", "B"}], "-", 
       RowBox[{"2", " ", "S"}], "-", "T"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "32"}], " ", "a", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"4", " ", "S"}], "+", 
          RowBox[{"2", " ", "T"}]}]], " ", 
        SuperscriptBox["g", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", "a", " ", 
           SuperscriptBox["La", "2"]}], "+", 
          RowBox[{"L", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B"}]}], ")"}], " ", "La"}], 
             "+", 
             RowBox[{"a", " ", "Laa"}]}], ")"}]}]}], ")"}]}], "-", 
       RowBox[{"32", " ", "a", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"2", " ", "A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"4", " ", "S"}], "+", 
          RowBox[{"2", " ", "T"}]}]], " ", 
        SuperscriptBox["g", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", "a", " ", 
           SuperscriptBox["La", "2"]}], "+", 
          RowBox[{"L", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B"}]}], ")"}], " ", "La"}], 
             "+", 
             RowBox[{"a", " ", "Laa"}]}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{"32", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"2", " ", "A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"3", " ", 
           RowBox[{"(", 
            RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["ga", "2"], " ", 
           SuperscriptBox["L", "2"]}], "-", 
          RowBox[{"a", " ", "g", " ", "L", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "a"}], " ", "gaa", " ", "L"}], "+", 
             RowBox[{"ga", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"5", " ", "L"}], "+", 
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B", " ", "L"}], "+", 
                RowBox[{"3", " ", "a", " ", "La"}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["g", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "4"}], "-", 
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B"}], "+", 
                RowBox[{
                 SuperscriptBox["a", "4"], " ", 
                 SuperscriptBox["B", "2"]}]}], ")"}], " ", 
              SuperscriptBox["L", "2"]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["a", "2"], " ", 
              SuperscriptBox["La", "2"]}], "+", 
             RowBox[{"a", " ", "L", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "7"}], " ", "La"}], "+", 
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B", " ", "La"}], "+", 
                RowBox[{"a", " ", "Laa"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       "-", 
       RowBox[{"32", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"2", " ", "A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"3", " ", 
           RowBox[{"(", 
            RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"16", "+", 
             RowBox[{"6", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", 
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B"}]}], ")"}], " ", 
              SuperscriptBox["g", "2"]}], "-", 
             RowBox[{"3", " ", 
              SuperscriptBox["a", "2"], " ", 
              SuperscriptBox["ga", "2"]}], "+", 
             RowBox[{"3", " ", "a", " ", "g", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "ga"}], "+", 
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B", " ", "ga"}], "+", 
                RowBox[{"a", " ", "gaa"}]}], ")"}]}]}], ")"}], " ", 
           SuperscriptBox["L", "2"]}], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["g", "2"], " ", 
           SuperscriptBox["La", "2"]}], "+", 
          RowBox[{"3", " ", "a", " ", "g", " ", "L", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "a"}], " ", "ga", " ", "La"}], "+", 
             RowBox[{"g", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "3"}], " ", "La"}], "+", 
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B", " ", "La"}], "+", 
                RowBox[{"a", " ", "Laa"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       "+", 
       RowBox[{"96", " ", 
        SuperscriptBox["a", "3"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"2", " ", "A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", "S"}], "+", 
          RowBox[{"3", " ", "T"}]}]], " ", "f", " ", "F", " ", 
        SuperscriptBox["g", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "La", " ", "Lr"}], "-", 
          RowBox[{"L", " ", "Lra"}]}], ")"}], " ", "r"}], "+", 
       RowBox[{"32", " ", 
        SuperscriptBox["a", "3"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"2", " ", "A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", "S"}], "+", 
          RowBox[{"3", " ", "T"}]}]], " ", "f", " ", "F", " ", 
        SuperscriptBox["g", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "a", " ", "B", " ", "L", " ", "Lr"}], "+", 
          RowBox[{"2", " ", "La", " ", "Lr"}], "-", 
          RowBox[{"L", " ", "Lra"}]}], ")"}], " ", "r"}], "+", 
       RowBox[{"16", " ", 
        SuperscriptBox["a", "3"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"3", " ", "S"}], "+", "T"}]], " ", 
        SuperscriptBox["F", "2"], " ", 
        SuperscriptBox["g", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", "a", " ", 
           SuperscriptBox["La", "2"]}], "+", 
          RowBox[{"L", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B"}]}], ")"}], " ", "La"}], 
             "+", 
             RowBox[{"a", " ", "Laa"}]}], ")"}]}]}], ")"}], " ", 
        SuperscriptBox["r", "2"]}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
        SuperscriptBox["F", "2"], " ", "g", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["ga", "2"], " ", 
           SuperscriptBox["L", "2"]}], "+", 
          RowBox[{"a", " ", "g", " ", "L", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "a"}], " ", "gaa", " ", "L"}], "+", 
             RowBox[{"ga", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"13", " ", "L"}], "-", 
                RowBox[{"3", " ", 
                 SuperscriptBox["a", "2"], " ", "B", " ", "L"}], "+", 
                RowBox[{"5", " ", "a", " ", "La"}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["g", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"8", "-", 
                RowBox[{"3", " ", 
                 SuperscriptBox["a", "2"], " ", "B"}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["a", "4"], " ", 
                 SuperscriptBox["B", "2"]}]}], ")"}], " ", 
              SuperscriptBox["L", "2"]}], "+", 
             RowBox[{"10", " ", 
              SuperscriptBox["a", "2"], " ", 
              SuperscriptBox["La", "2"]}], "+", 
             RowBox[{"a", " ", "L", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"13", " ", "La"}], "+", 
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B", " ", "La"}], "-", 
                RowBox[{"3", " ", "a", " ", "Laa"}]}], ")"}]}]}], ")"}]}]}], 
         ")"}], " ", 
        SuperscriptBox["r", "2"]}], "+", 
       RowBox[{"16", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
        SuperscriptBox["F", "2"], " ", "g", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"16", "+", 
             RowBox[{"6", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", 
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B"}]}], ")"}], " ", 
              SuperscriptBox["g", "2"]}], "-", 
             RowBox[{"3", " ", 
              SuperscriptBox["a", "2"], " ", 
              SuperscriptBox["ga", "2"]}], "+", 
             RowBox[{"3", " ", "a", " ", "g", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "ga"}], "+", 
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B", " ", "ga"}], "+", 
                RowBox[{"a", " ", "gaa"}]}], ")"}]}]}], ")"}], " ", 
           SuperscriptBox["L", "2"]}], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["g", "2"], " ", 
           SuperscriptBox["La", "2"]}], "+", 
          RowBox[{"3", " ", "a", " ", "g", " ", "L", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "a"}], " ", "ga", " ", "La"}], "+", 
             RowBox[{"g", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "3"}], " ", "La"}], "+", 
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B", " ", "La"}], "+", 
                RowBox[{"a", " ", "Laa"}]}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
        SuperscriptBox["r", "2"]}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["a", "3"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"3", " ", "S"}], "+", "T"}]], " ", 
        SuperscriptBox["F", "2"], " ", 
        SuperscriptBox["g", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "a"}], " ", "ga", " ", "L", " ", "La"}], "+", 
          RowBox[{"g", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "a", " ", 
              SuperscriptBox["La", "2"]}], "+", 
             RowBox[{"L", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "3"}], " ", "La"}], "+", 
                RowBox[{"3", " ", 
                 SuperscriptBox["a", "2"], " ", "B", " ", "La"}], "+", 
                RowBox[{"a", " ", "Laa"}]}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
        SuperscriptBox["r", "2"]}], "-", 
       RowBox[{"48", " ", 
        SuperscriptBox["a", "5"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", 
          RowBox[{"2", " ", "T"}]}]], " ", "f", " ", 
        SuperscriptBox["F", "3"], " ", 
        SuperscriptBox["g", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "La", " ", "Lr"}], "-", 
          RowBox[{"L", " ", "Lra"}]}], ")"}], " ", 
        SuperscriptBox["r", "3"]}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["a", "4"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", 
          RowBox[{"2", " ", "T"}]}]], " ", "f", " ", 
        SuperscriptBox["F", "3"], " ", 
        SuperscriptBox["g", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "a"}], " ", "ga", " ", "L", " ", "Lr"}], "+", 
          RowBox[{"g", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "L", " ", "Lr"}], "-", 
             RowBox[{"2", " ", "a", " ", "La", " ", "Lr"}], "+", 
             RowBox[{"a", " ", "L", " ", "Lra"}]}], ")"}]}]}], ")"}], " ", 
        SuperscriptBox["r", "3"]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "5"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"2", " ", "S"}]}]], " ", 
        SuperscriptBox["F", "4"], " ", 
        SuperscriptBox["g", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", "a", " ", 
           SuperscriptBox["La", "2"]}], "+", 
          RowBox[{"L", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B"}]}], ")"}], " ", "La"}], 
             "+", 
             RowBox[{"a", " ", "Laa"}]}], ")"}]}]}], ")"}], " ", 
        SuperscriptBox["r", "4"]}], "+", 
       RowBox[{
        SuperscriptBox["a", "4"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"S", "+", "T"}]], " ", 
        SuperscriptBox["F", "4"], " ", 
        SuperscriptBox["g", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["ga", "2"], " ", 
           SuperscriptBox["L", "2"]}], "-", 
          RowBox[{"6", " ", "a", " ", "g", " ", "ga", " ", "L", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "L"}], "+", 
             RowBox[{"a", " ", "La"}]}], ")"}]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["g", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", 
              SuperscriptBox["L", "2"]}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["a", "2"], " ", 
              SuperscriptBox["La", "2"]}], "+", 
             RowBox[{"a", " ", "L", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", "La"}], "-", 
                RowBox[{"a", " ", "Laa"}]}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
        SuperscriptBox["r", "4"]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "4"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", "S", "+", "T"}]], " ", 
        SuperscriptBox["F", "4"], " ", 
        SuperscriptBox["g", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"16", "+", 
             RowBox[{"6", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", 
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B"}]}], ")"}], " ", 
              SuperscriptBox["g", "2"]}], "-", 
             RowBox[{"3", " ", 
              SuperscriptBox["a", "2"], " ", 
              SuperscriptBox["ga", "2"]}], "+", 
             RowBox[{"3", " ", "a", " ", "g", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "ga"}], "+", 
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B", " ", "ga"}], "+", 
                RowBox[{"a", " ", "gaa"}]}], ")"}]}]}], ")"}], " ", 
           SuperscriptBox["L", "2"]}], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["g", "2"], " ", 
           SuperscriptBox["La", "2"]}], "+", 
          RowBox[{"3", " ", "a", " ", "g", " ", "L", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "a"}], " ", "ga", " ", "La"}], "+", 
             RowBox[{"g", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "3"}], " ", "La"}], "+", 
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B", " ", "La"}], "+", 
                RowBox[{"a", " ", "Laa"}]}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
        SuperscriptBox["r", "4"]}], "+", 
       RowBox[{"6", " ", 
        SuperscriptBox["a", "7"], " ", 
        SuperscriptBox["\[ExponentialE]", "T"], " ", "f", " ", 
        SuperscriptBox["F", "5"], " ", 
        SuperscriptBox["g", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "La", " ", "Lr"}], "-", 
          RowBox[{"L", " ", "Lra"}]}], ")"}], " ", 
        SuperscriptBox["r", "5"]}], "+", 
       RowBox[{"32", " ", 
        SuperscriptBox["a", "3"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"3", " ", "S"}], "+", 
          RowBox[{"2", " ", "T"}]}]], " ", "f", " ", "F", " ", 
        SuperscriptBox["g", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "La", " ", "Lr", " ", "r"}], "+", 
          RowBox[{"L", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "La"}], "+", 
             RowBox[{"2", " ", "a", " ", "B", " ", "Lr", " ", "r"}], "-", 
             RowBox[{"Lra", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{"32", " ", 
        SuperscriptBox["a", "3"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"2", " ", "A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"3", " ", "S"}], "+", 
          RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
        SuperscriptBox["g", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"fr", " ", "L", " ", "La", " ", "r"}], "+", 
          RowBox[{"f", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "L", " ", "La"}], "+", 
             RowBox[{"2", " ", "La", " ", "Lr", " ", "r"}], "-", 
             RowBox[{"L", " ", "Lra", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
       RowBox[{"16", " ", 
        SuperscriptBox["a", "5"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
        SuperscriptBox["F", "3"], " ", 
        SuperscriptBox["g", "3"], " ", 
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"fr", " ", "L", " ", "La", " ", "r"}], "+", 
          RowBox[{"f", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "L", " ", "La"}], "+", 
             RowBox[{"2", " ", "La", " ", "Lr", " ", "r"}], "-", 
             RowBox[{"L", " ", "Lra", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "7"], " ", 
        SuperscriptBox["\[ExponentialE]", "S"], " ", 
        SuperscriptBox["F", "5"], " ", 
        SuperscriptBox["g", "4"], " ", 
        SuperscriptBox["r", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"fr", " ", "L", " ", "La", " ", "r"}], "+", 
          RowBox[{"f", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "L", " ", "La"}], "+", 
             RowBox[{"2", " ", "La", " ", "Lr", " ", "r"}], "-", 
             RowBox[{"L", " ", "Lra", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["a", "4"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "f", " ", 
        SuperscriptBox["F", "3"], " ", 
        SuperscriptBox["g", "2"], " ", 
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "a"}], " ", "ga", " ", "L", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "L"}], "+", 
             RowBox[{"Lr", " ", "r"}]}], ")"}]}], "+", 
          RowBox[{"g", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B"}]}], ")"}], " ", 
              SuperscriptBox["L", "2"]}], "-", 
             RowBox[{"2", " ", "a", " ", "La", " ", "Lr", " ", "r"}], "+", 
             RowBox[{"L", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], " ", "a", " ", "La"}], "-", 
                RowBox[{"2", " ", "Lr", " ", "r"}], "+", 
                RowBox[{"a", " ", "Lra", " ", "r"}]}], ")"}]}]}], ")"}]}]}], 
         ")"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"8", " ", "g", " ", 
      SuperscriptBox["L", "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "r"}], 
         "+", 
         RowBox[{
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["r", "3"]}]}], ")"}], "2"]}]], 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "S"}], "-", "T"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"384", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"2", " ", "A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"3", " ", 
           RowBox[{"(", 
            RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}]]}], ")"}], " ", "f", " ", 
        "g", " ", "L", " ", "Lr", " ", "r"}], "-", 
       RowBox[{
        SuperscriptBox["a", "5"], " ", 
        SuperscriptBox["F", "3"], " ", 
        SuperscriptBox["g", "2"], " ", 
        SuperscriptBox["r", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "8"}], " ", "B", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "g", " ", "L", " ", 
           "La"}], "+", 
          RowBox[{"F", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "4"}], " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B"}], "+", 
                RowBox[{"2", " ", "S"}]}]], " ", "f", " ", "g", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "La", " ", "Lr"}], "-", 
                RowBox[{"L", " ", "Lra"}]}], ")"}], " ", "r"}], "-", 
             RowBox[{"12", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", 
                RowBox[{"2", " ", "T"}]}]], " ", "f", " ", "g", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "La", " ", "Lr"}], "-", 
                RowBox[{"L", " ", "Lra"}]}], ")"}], " ", "r"}], "-", 
             RowBox[{"12", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B"}], "+", "S", "+", "T"}]], 
              " ", "f", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"ga", " ", "L", " ", "Lr"}], "+", 
                RowBox[{"2", " ", "g", " ", "La", " ", "Lr"}], "-", 
                RowBox[{"g", " ", "L", " ", "Lra"}]}], ")"}], " ", "r"}], "+", 
             RowBox[{
              SuperscriptBox["\[ExponentialE]", "S"], " ", "F", " ", 
              SuperscriptBox["g", "2"], " ", "L", " ", "La", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["\[ExponentialE]", "T"], " ", "F", " ", "g", " ",
               "L", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"3", " ", "ga", " ", "L"}], "+", 
                RowBox[{"g", " ", "La"}]}], ")"}], " ", 
              SuperscriptBox["r", "2"]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "g", 
              " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"fr", " ", "L", " ", "La", " ", "r"}], "+", 
                RowBox[{"f", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", "L", " ", "La"}], "+", 
                   RowBox[{"2", " ", "La", " ", "Lr", " ", "r"}], "-", 
                   RowBox[{"L", " ", "Lra", " ", "r"}]}], ")"}]}]}], ")"}]}], 
             "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"S", "+", "T"}]], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"fr", " ", "g", " ", "L", " ", "La", " ", "r"}], "+", 
                RowBox[{"f", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"3", " ", "ga", " ", "L", " ", "Lr", " ", "r"}], 
                   "+", 
                   RowBox[{"2", " ", "g", " ", "La", " ", 
                    RowBox[{"(", 
                    RowBox[{"L", "+", 
                    RowBox[{"2", " ", "Lr", " ", "r"}]}], ")"}]}]}], 
                  ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["a", "3"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"S", "+", "T"}]], " ", "F", " ", "g", " ", 
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8", " ", "B", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "L", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"ga", " ", "L"}], "+", 
             RowBox[{"g", " ", "La"}]}], ")"}]}], "+", 
          RowBox[{"F", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "8"}], " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{"2", " ", 
                 SuperscriptBox["a", "2"], " ", "B"}], "+", 
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", 
                RowBox[{"2", " ", "S"}]}]], " ", "f", " ", "g", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "La", " ", "Lr"}], "-", 
                RowBox[{"L", " ", "Lra"}]}], ")"}], " ", "r"}], "-", 
             RowBox[{"24", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B"}], "+", 
                RowBox[{"2", " ", "A", " ", 
                 SuperscriptBox["r", "2"]}], "+", 
                RowBox[{"2", " ", "T"}]}]], " ", "f", " ", "g", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "La", " ", "Lr"}], "-", 
                RowBox[{"L", " ", "Lra"}]}], ")"}], " ", "r"}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"A", " ", 
                   SuperscriptBox["r", "2"]}], "+", "T"}], ")"}]}]], " ", "f",
               " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"ga", " ", "L", " ", "Lr"}], "+", 
                RowBox[{"2", " ", "g", " ", "La", " ", "Lr"}], "-", 
                RowBox[{"g", " ", "L", " ", "Lra"}]}], ")"}], " ", "r"}], "-", 
             RowBox[{"24", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{"2", " ", 
                 SuperscriptBox["a", "2"], " ", "B"}], "+", 
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", 
              " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"ga", " ", "L", " ", "Lr"}], "+", 
                RowBox[{"2", " ", "g", " ", "La", " ", "Lr"}], "-", 
                RowBox[{"g", " ", "L", " ", "Lra"}]}], ")"}], " ", "r"}], "-", 
             RowBox[{
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "F", 
              " ", 
              SuperscriptBox["g", "2"], " ", "L", " ", "La", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B"}], "+", 
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "S"}]], " ", "F", " ", 
              SuperscriptBox["g", "2"], " ", "L", " ", "La", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"6", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B"}], "+", 
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "F", " ", "g", 
              " ", "L", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"3", " ", "ga", " ", "L"}], "+", 
                RowBox[{"g", " ", "La"}]}], ")"}], " ", 
              SuperscriptBox["r", "2"]}], "-", 
             RowBox[{
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "F", " ", "g", 
              " ", "L", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"ga", " ", "L"}], "+", 
                RowBox[{"3", " ", "g", " ", "La"}]}], ")"}], " ", 
              SuperscriptBox["r", "2"]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}], ")"}]}]],
               " ", "f", " ", "g", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "L", " ", "La"}], "+", 
                RowBox[{"2", " ", "La", " ", "Lr", " ", "r"}], "-", 
                RowBox[{"L", " ", "Lra", " ", "r"}]}], ")"}]}], "-", 
             RowBox[{"8", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B"}], "+", 
                RowBox[{"2", " ", "A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "g", 
              " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"fr", " ", "L", " ", "La", " ", "r"}], "+", 
                RowBox[{"f", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", "L", " ", "La"}], "+", 
                   RowBox[{"2", " ", "La", " ", "Lr", " ", "r"}], "-", 
                   RowBox[{"L", " ", "Lra", " ", "r"}]}], ")"}]}]}], ")"}]}], 
             "+", 
             RowBox[{
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B"}], "+", 
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                "8", " ", "fr", " ", "g", " ", "L", " ", "La", " ", "r"}], 
                "+", 
                RowBox[{"f", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"8", " ", "g", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"L", " ", "La"}], "+", 
                    RowBox[{"6", " ", "La", " ", "Lr", " ", "r"}], "-", 
                    RowBox[{"L", " ", "Lra", " ", "r"}]}], ")"}]}], "+", 
                   RowBox[{"4", " ", "ga", " ", "L", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", "L"}], "+", 
                    RowBox[{"5", " ", "Lr", " ", "r"}], "-", 
                    RowBox[{"4", " ", "A", " ", "L", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
               ")"}]}]}], ")"}]}]}], ")"}]}], "-", 
       RowBox[{"16", " ", "a", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}]}]], " ", "f", " ", "g", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "La", " ", "Lr"}], "-", 
             RowBox[{"L", " ", "Lra"}]}], ")"}], " ", "r"}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "T"}], ")"}]}]], " ", "f", 
           " ", "g", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "La", " ", "Lr"}], "-", 
             RowBox[{"L", " ", "Lra"}]}], ")"}], " ", "r"}], "-", 
          RowBox[{"12", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "f", " ", "g", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "La", " ", "Lr"}], "-", 
             RowBox[{"L", " ", "Lra"}]}], ")"}], " ", "r"}], "-", 
          RowBox[{"12", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", 
           " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"ga", " ", "L", " ", "Lr"}], "+", 
             RowBox[{"2", " ", "g", " ", "La", " ", "Lr"}], "-", 
             RowBox[{"g", " ", "L", " ", "Lra"}]}], ")"}], " ", "r"}], "+", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "F", 
           " ", 
           SuperscriptBox["g", "2"], " ", "L", " ", "La", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S"}]], " ", "F", " ", 
           SuperscriptBox["g", "2"], " ", "L", " ", "La", " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "F", " ", "g", 
           " ", "L", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], " ", "ga", " ", "L"}], "+", 
             RowBox[{"g", " ", "La"}]}], ")"}], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "F", " ", "g", 
           " ", "L", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", "ga", " ", "L"}], "+", 
             RowBox[{"g", " ", "La"}]}], ")"}], " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}], ")"}]}]], 
           " ", "f", " ", "g", " ", "r", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "L"}], " ", "Lra"}], "+", 
             RowBox[{"2", " ", "La", " ", 
              RowBox[{"(", 
               RowBox[{"Lr", "+", 
                RowBox[{"A", " ", "L", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "g", 
           " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"fr", " ", "L", " ", "La", " ", "r"}], "+", 
             RowBox[{"f", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "L", " ", "La"}], "+", 
                RowBox[{"2", " ", "La", " ", "Lr", " ", "r"}], "-", 
                RowBox[{"L", " ", "Lra", " ", "r"}]}], ")"}]}]}], ")"}]}], 
          "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"fr", " ", "g", " ", "L", " ", "La", " ", "r"}], "+", 
             RowBox[{"f", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"3", " ", "ga", " ", "L", " ", "Lr", " ", "r"}], "+", 
                RowBox[{"2", " ", "g", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"4", " ", "La", " ", "Lr", " ", "r"}], "+", 
                   RowBox[{"L", " ", 
                    RowBox[{"(", 
                    RowBox[{"La", "-", 
                    RowBox[{"Lra", " ", "r"}], "-", 
                    RowBox[{"A", " ", "La", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
               ")"}]}]}], ")"}]}]}], ")"}]}], "-", 
       RowBox[{
        SuperscriptBox["a", "6"], " ", 
        SuperscriptBox["F", "5"], " ", 
        SuperscriptBox["g", "3"], " ", 
        SuperscriptBox["r", "5"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["\[ExponentialE]", "T"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"gaa", " ", 
                 SuperscriptBox["L", "2"]}], "+", 
                RowBox[{"ga", " ", "L", " ", "La"}], "-", 
                RowBox[{"g", " ", 
                 SuperscriptBox["La", "2"]}], "+", 
                RowBox[{"g", " ", "L", " ", "Laa"}]}], ")"}], " ", "r"}], "+", 
             RowBox[{
             "4", " ", "f", " ", "fr", " ", "L", " ", "Lr", " ", "r"}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["f", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"L", " ", "Lr"}], "-", 
                RowBox[{
                 SuperscriptBox["Lr", "2"], " ", "r"}], "+", 
                RowBox[{"L", " ", "Lrr", " ", "r"}]}], ")"}]}]}], ")"}]}], 
          "+", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", "S"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"ga", " ", "L", " ", "La"}], "-", 
                RowBox[{"g", " ", 
                 SuperscriptBox["La", "2"]}], "+", 
                RowBox[{"g", " ", "L", " ", "Laa"}]}], ")"}], " ", "r"}], "+", 
             RowBox[{"4", " ", "f", " ", "L", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"3", " ", "fr", " ", "L"}], "+", 
                RowBox[{"frr", " ", "L", " ", "r"}], "+", 
                RowBox[{"fr", " ", "Lr", " ", "r"}]}], ")"}]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["f", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"L", " ", "Lr"}], "-", 
                RowBox[{
                 SuperscriptBox["Lr", "2"], " ", "r"}], "+", 
                RowBox[{"L", " ", "Lrr", " ", "r"}]}], ")"}]}]}], ")"}]}], 
          "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"S", "+", "T"}]], " ", 
           SuperscriptBox["L", "3"], " ", "r", " ", "\[CapitalLambda]"}]}], 
         ")"}]}], "+", 
       RowBox[{"16", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", 
          RowBox[{"2", " ", "T"}]}]], " ", "g", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8", " ", "B", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "f", " ", "L", " ", "Lr"}], "-", 
          RowBox[{"12", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "f", 
           " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "L", " ", "Lr", " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "f", " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "L", " ", "Lr", " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["g", "2"], " ", 
           SuperscriptBox["L", "2"], " ", 
           SuperscriptBox["r", "3"]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "f", 
           " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "L", " ", "r", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "5"}], " ", "Lr", " ", "r"}], "+", 
             RowBox[{"L", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", 
                RowBox[{"4", " ", "A", " ", 
                 SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "F", 
           " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"gaa", " ", 
                 SuperscriptBox["L", "2"]}], "+", 
                RowBox[{"ga", " ", "L", " ", "La"}], "-", 
                RowBox[{"g", " ", 
                 SuperscriptBox["La", "2"]}], "+", 
                RowBox[{"g", " ", "L", " ", "Laa"}]}], ")"}], " ", "r"}], "+", 
             RowBox[{
             "4", " ", "f", " ", "fr", " ", "L", " ", "Lr", " ", "r"}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["f", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["Lr", "2"]}], " ", "r"}], "+", 
                RowBox[{"L", " ", 
                 RowBox[{"(", 
                  RowBox[{"Lr", "+", 
                   RowBox[{"Lrr", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}],
           "-", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "F", 
           " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "4"}], " ", "B", " ", "g", " ", 
                 SuperscriptBox["L", "2"]}], "+", 
                RowBox[{"gaa", " ", 
                 SuperscriptBox["L", "2"]}], "+", 
                RowBox[{"ga", " ", "L", " ", "La"}], "-", 
                RowBox[{"5", " ", "g", " ", 
                 SuperscriptBox["La", "2"]}], "+", 
                RowBox[{"3", " ", "g", " ", "L", " ", "Laa"}]}], ")"}], " ", 
              "r"}], "+", 
             RowBox[{
             "4", " ", "f", " ", "fr", " ", "L", " ", "Lr", " ", "r"}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["f", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["Lr", "2"]}], " ", "r"}], "+", 
                RowBox[{"L", " ", 
                 RowBox[{"(", 
                  RowBox[{"Lr", "+", 
                   RowBox[{"Lrr", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}],
           "-", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}]}]], " ", "F", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"ga", " ", "L", " ", "La"}], "-", 
                RowBox[{"g", " ", 
                 SuperscriptBox["La", "2"]}], "+", 
                RowBox[{"g", " ", "L", " ", "Laa"}]}], ")"}], " ", "r"}], "+", 
             RowBox[{"4", " ", "f", " ", "L", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"3", " ", "fr", " ", "L"}], "+", 
                RowBox[{"frr", " ", "L", " ", "r"}], "+", 
                RowBox[{"fr", " ", "Lr", " ", "r"}]}], ")"}]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["f", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["Lr", "2"]}], " ", "r"}], "+", 
                RowBox[{"L", " ", 
                 RowBox[{"(", 
                  RowBox[{"Lr", "+", 
                   RowBox[{"Lrr", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}],
           "+", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}], ")"}]}]], 
           " ", "F", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"ga", " ", "L", " ", "La"}], "-", 
                 RowBox[{"g", " ", 
                  SuperscriptBox["La", "2"]}], "+", 
                 RowBox[{"g", " ", "L", " ", "Laa"}]}], ")"}]}], " ", "r"}], 
             "-", 
             RowBox[{"4", " ", "f", " ", "fr", " ", "L", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "L"}], "+", 
                RowBox[{"3", " ", "Lr", " ", "r"}]}], ")"}]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["f", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", "A", " ", 
                 SuperscriptBox["L", "2"], " ", "r"}], "+", 
                RowBox[{"5", " ", 
                 SuperscriptBox["Lr", "2"], " ", "r"}], "+", 
                RowBox[{"L", " ", 
                 RowBox[{"(", 
                  RowBox[{"Lr", "-", 
                   RowBox[{"3", " ", "Lrr", " ", "r"}], "+", 
                   RowBox[{"2", " ", "A", " ", "Lr", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
            ")"}]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "L", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"B", " ", "f", " ", "Lr"}], "-", 
             RowBox[{"2", " ", "F", " ", 
              SuperscriptBox["L", "2"], " ", "r", " ", "\[CapitalLambda]"}]}],
             ")"}]}]}], ")"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["a", "4"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"S", "+", "T"}]], " ", 
        SuperscriptBox["F", "2"], " ", "g", " ", 
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", "B", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", 
           " ", "g", " ", 
           SuperscriptBox["L", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "+", 
             RowBox[{"3", " ", "A", " ", 
              SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
          RowBox[{"F", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "6"}], " ", "f", " ", "F", " ", 
              SuperscriptBox["g", "2"], " ", "L", " ", "Lr", " ", 
              SuperscriptBox["r", "3"]}], "+", 
             RowBox[{"6", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}]], " ", "f", " ", "F", 
              " ", 
              SuperscriptBox["g", "2"], " ", "L", " ", "Lr", " ", 
              SuperscriptBox["r", "3"]}], "+", 
             RowBox[{
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "g", 
              " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"g", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox["La", "2"]}], "+", 
                   RowBox[{"L", " ", "Laa"}]}], ")"}], " ", 
                 SuperscriptBox["r", "2"]}], "+", 
                RowBox[{"4", " ", "f", " ", "fr", " ", "L", " ", "r", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", "L"}], "+", 
                   RowBox[{"3", " ", "Lr", " ", "r"}]}], ")"}]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["f", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"4", " ", 
                    SuperscriptBox["L", "2"]}], "+", 
                   RowBox[{"5", " ", 
                    SuperscriptBox["Lr", "2"], " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                   RowBox[{"3", " ", "L", " ", "r", " ", 
                    RowBox[{"(", 
                    RowBox[{"Lr", "-", 
                    RowBox[{"Lrr", " ", "r"}]}], ")"}]}]}], ")"}]}]}], 
               ")"}]}], "+", 
             RowBox[{"6", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B"}], "+", 
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "g", " ", "r", 
              " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"gaa", " ", 
                    SuperscriptBox["L", "2"]}], "+", 
                   RowBox[{"ga", " ", "L", " ", "La"}], "-", 
                   RowBox[{"g", " ", 
                    SuperscriptBox["La", "2"]}], "+", 
                   RowBox[{"g", " ", "L", " ", "Laa"}]}], ")"}], " ", "r"}], 
                "+", 
                RowBox[{
                "4", " ", "f", " ", "fr", " ", "L", " ", "Lr", " ", "r"}], 
                "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["f", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["Lr", "2"]}], " ", "r"}], "+", 
                   RowBox[{"L", " ", 
                    RowBox[{"(", 
                    RowBox[{"Lr", "+", 
                    RowBox[{"Lrr", " ", "r"}]}], ")"}]}]}], ")"}]}]}], 
               ")"}]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B"}], "+", 
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "S"}]], " ", "g", " ", "r", 
              " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"ga", " ", "L", " ", "La"}], "-", 
                   RowBox[{"g", " ", 
                    SuperscriptBox["La", "2"]}], "+", 
                   RowBox[{"g", " ", "L", " ", "Laa"}]}], ")"}], " ", "r"}], 
                "+", 
                RowBox[{"4", " ", "f", " ", "L", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"3", " ", "fr", " ", "L"}], "+", 
                   RowBox[{"frr", " ", "L", " ", "r"}], "+", 
                   RowBox[{"fr", " ", "Lr", " ", "r"}]}], ")"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["f", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["Lr", "2"]}], " ", "r"}], "+", 
                   RowBox[{"L", " ", 
                    RowBox[{"(", 
                    RowBox[{"Lr", "+", 
                    RowBox[{"Lrr", " ", "r"}]}], ")"}]}]}], ")"}]}]}], 
               ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["ga", "2"]}], " ", 
                    SuperscriptBox["L", "2"]}], "+", 
                   RowBox[{"g", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"gaa", " ", 
                    SuperscriptBox["L", "2"]}], "-", 
                    RowBox[{"5", " ", "g", " ", 
                    SuperscriptBox["La", "2"]}], "+", 
                    RowBox[{"3", " ", "g", " ", "L", " ", "Laa"}]}], 
                    ")"}]}]}], ")"}], " ", "r"}], "+", 
                RowBox[{
                "4", " ", "f", " ", "fr", " ", "g", " ", "L", " ", "Lr", " ", 
                 "r"}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["f", "2"], " ", "g", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["Lr", "2"], " ", "r"}], "+", 
                   RowBox[{"L", " ", 
                    RowBox[{"(", 
                    RowBox[{"Lr", "-", 
                    RowBox[{"Lrr", " ", "r"}], "-", 
                    RowBox[{"2", " ", "A", " ", "Lr", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
               ")"}]}], "+", 
             RowBox[{"32", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B"}], "+", 
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "g", 
              " ", 
              SuperscriptBox["L", "3"], " ", 
              SuperscriptBox["r", "2"], " ", "\[CapitalLambda]"}]}], 
            ")"}]}]}], ")"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"8", " ", 
      SuperscriptBox["a", "2"], " ", "g", " ", 
      SuperscriptBox["L", "3"], " ", "r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["F", "2"], " ", "g", " ", 
         SuperscriptBox["r", "2"]}]}], ")"}]}]], 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "S"}], "-", "T"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "16"}], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", 
          RowBox[{"2", " ", "T"}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["g", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "8"}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["g", "2"]}]}], ")"}]}]}], ")"}], " ", 
        SuperscriptBox["L", "2"], " ", "r"}], "-", 
       RowBox[{"8", " ", "a", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"S", "+", "T"}]], " ", "g", " ", "L", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "g", 
           " ", "La"}], "+", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S"}]], " ", "g", " ", "La"}], 
          "+", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"ga", " ", "L"}], "-", 
             RowBox[{"g", " ", "La"}]}], ")"}]}], "+", 
          RowBox[{"6", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"ga", " ", "L"}], "+", 
             RowBox[{"g", " ", "La"}]}], ")"}]}]}], ")"}], " ", "r"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "3"], " ", "F", " ", "g", " ", 
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"S", "+", "T"}]], " ", "f", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"ga", " ", "L", " ", "Lr"}], "+", 
             RowBox[{"4", " ", "g", " ", "La", " ", "Lr"}], "-", 
             RowBox[{"2", " ", "g", " ", "L", " ", "Lra"}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", "S"], " ", "F", " ", 
           SuperscriptBox["g", "2"], " ", "L", " ", "La", " ", "r"}], "+", 
          RowBox[{"6", " ", 
           SuperscriptBox["\[ExponentialE]", "T"], " ", "F", " ", "g", " ", 
           "L", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"ga", " ", "L"}], "+", 
             RowBox[{"g", " ", "La"}]}], ")"}], " ", "r"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["a", "4"], " ", 
        SuperscriptBox["F", "2"], " ", "g", " ", 
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["\[ExponentialE]", "T"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["ga", "2"], " ", 
              SuperscriptBox["L", "2"]}], "+", 
             RowBox[{"2", " ", "g", " ", "ga", " ", "L", " ", "La"}], "+", 
             RowBox[{"g", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"g", " ", 
                 SuperscriptBox["La", "2"]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["f", "2"], " ", 
                 SuperscriptBox["Lr", "2"]}]}], ")"}]}]}], ")"}], " ", "r"}], 
          "+", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", "S"], " ", "g", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"La", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"ga", " ", "L"}], "+", 
                RowBox[{"g", " ", "La"}]}], ")"}], " ", "r"}], "+", 
             RowBox[{
             "4", " ", "f", " ", "fr", " ", "L", " ", "Lr", " ", "r"}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["f", "2"], " ", "Lr", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "L"}], "+", 
                RowBox[{"Lr", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"S", "+", "T"}]], " ", "g", " ", 
           SuperscriptBox["L", "3"], " ", "r", " ", "\[CapitalLambda]"}]}], 
         ")"}]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", "T"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["ga", "2"], " ", 
              SuperscriptBox["L", "2"]}], "+", 
             RowBox[{"2", " ", "g", " ", "ga", " ", "L", " ", "La"}], "+", 
             RowBox[{"g", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"g", " ", 
                 SuperscriptBox["La", "2"]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["f", "2"], " ", 
                 SuperscriptBox["Lr", "2"]}]}], ")"}]}]}], ")"}], " ", "r"}], 
          "-", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["ga", "2"], " ", 
              SuperscriptBox["L", "2"]}], "-", 
             RowBox[{"g", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "gaa", " ", 
                 SuperscriptBox["L", "2"]}], "-", 
                RowBox[{"3", " ", "g", " ", 
                 SuperscriptBox["La", "2"]}], "+", 
                RowBox[{"2", " ", "g", " ", "L", " ", "Laa"}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["f", "2"], " ", 
                 SuperscriptBox["Lr", "2"]}]}], ")"}]}]}], ")"}], " ", "r"}], 
          "+", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "S"}]}]], " ", "g", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"ga", " ", "L", " ", "La"}], "+", 
             RowBox[{"g", " ", 
              SuperscriptBox["La", "2"]}], "+", 
             RowBox[{"4", " ", "f", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "fr", " ", "L", " ", "Lr"}], "-", 
                RowBox[{"3", " ", "f", " ", 
                 SuperscriptBox["Lr", "2"]}], "+", 
                RowBox[{"2", " ", "f", " ", "L", " ", "Lrr"}]}], ")"}]}]}], 
            ")"}], " ", "r"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", "S"], " ", "f", " ", "F", " ", 
           SuperscriptBox["g", "2"], " ", "L", " ", "Lr", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["F", "2"], " ", "g", " ", 
           RowBox[{"(", 
            RowBox[{"8", "-", 
             RowBox[{"3", " ", 
              SuperscriptBox["g", "2"]}]}], ")"}], " ", 
           SuperscriptBox["L", "2"], " ", 
           SuperscriptBox["r", "3"]}], "+", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}]}]], " ", "g", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"La", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"ga", " ", "L"}], "+", 
                RowBox[{"g", " ", "La"}]}], ")"}], " ", "r"}], "+", 
             RowBox[{
             "4", " ", "f", " ", "fr", " ", "L", " ", "Lr", " ", "r"}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["f", "2"], " ", "Lr", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "L"}], "+", 
                RowBox[{"Lr", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "g", " ", 
           SuperscriptBox["L", "3"], " ", "r", " ", "\[CapitalLambda]"}]}], 
         ")"}]}]}], ")"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.4603899655729094`*^9, 3.4603903770956907`*^9, {3.460392011872798*^9, 
   3.460392016762642*^9}, 3.460392415370453*^9, {3.46039298338251*^9, 
   3.460392991049645*^9}, {3.4603930874834547`*^9, 3.460393092754335*^9}, 
   3.4603932361833487`*^9, {3.460397075784021*^9, 3.460356921427402*^9}, 
   3.460366986675694*^9, 3.460372681705605*^9, 3.542470130105186*^9, 
   3.543557495978466*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Linearize", "Subsubtitle",
 CellChangeTimes->{{3.460389558463635*^9, 3.460389558896888*^9}, {
  3.518329365085441*^9, 3.51832936765899*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffrrT", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffrr", ",", "T"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffrrA", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffrr", ",", "A"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffrrB", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffrr", ",", "B"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffrrF", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffrr", ",", "F"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"newcoeffrrS", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"D", "[", 
     RowBox[{"newcoeffrr", ",", "S"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5183297400699463`*^9, 3.5183297643107977`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffaaT", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffaa", ",", "T"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffaaA", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffaa", ",", "A"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffaaB", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffaa", ",", "B"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffaaF", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffaa", ",", "F"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"newcoeffaaS", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"D", "[", 
     RowBox[{"newcoeffaa", ",", "S"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.518329772304187*^9, 3.51832978387881*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffraT", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffra", ",", "T"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffraA", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffra", ",", "A"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffraB", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffra", ",", "B"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffraF", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffra", ",", "F"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"newcoeffraS", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"D", "[", 
     RowBox[{"newcoeffra", ",", "S"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5183297888002996`*^9, 3.518329800494968*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffderiv1T", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffderiv1", ",", "T"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffderiv1A", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffderiv1", ",", "A"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffderiv1B", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffderiv1", ",", "B"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffderiv1F", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffderiv1", ",", "F"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"newcoeffderiv1S", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"D", "[", 
     RowBox[{"newcoeffderiv1", ",", "S"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.518329626902732*^9, 3.518329652758658*^9}, {
  3.518329701795911*^9, 3.518329711829796*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffderiv2T", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffderiv2", ",", "T"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffderiv2A", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffderiv2", ",", "A"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffderiv2B", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffderiv2", ",", "B"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffderiv2F", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffderiv2", ",", "F"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"newcoeffderiv2S", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"D", "[", 
     RowBox[{"newcoeffderiv2", ",", "S"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.518329626902732*^9, 3.518329652758658*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffnoderivT", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffnoderiv", ",", "T"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffnoderivA", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffnoderiv", ",", "A"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffnoderivB", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffnoderiv", ",", "B"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffnoderivF", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffnoderiv", ",", "F"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"newcoeffnoderivS", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"D", "[", 
     RowBox[{"newcoeffnoderiv", ",", "S"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5183294084056883`*^9, 3.5183294568601093`*^9}, {
  3.5183295077344646`*^9, 3.518329537734762*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Process", "Subsubtitle",
 CellChangeTimes->{{3.518333016771228*^9, 3.518333021644429*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"EqX", "=", 
   RowBox[{
    RowBox[{"newcoeffrr", ".", "dlistrr"}], "+", 
    RowBox[{"newcoeffaa", ".", "dlistaa"}], "+", 
    RowBox[{"newcoeffra", ".", "dlistra"}], "+", 
    RowBox[{"newcoeffderiv1", ".", "dlist"}], "+", 
    RowBox[{"newcoeffderiv2", ".", "dlist2"}], "+", "newcoeffnoderiv"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.518339740784905*^9, 3.518339769191586*^9}, {
   3.518340396834127*^9, 3.5183404128166924`*^9}, 3.518340475609181*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"coeffrr", "=", 
   RowBox[{"newcoeffrr", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"coeffaa", "=", 
   RowBox[{"newcoeffaa", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"coeffra", "=", 
  RowBox[{"newcoeffra", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "1"}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.518330025606043*^9, 3.5183300270315247`*^9}, {
  3.518331587749983*^9, 3.518331596094022*^9}, {3.5183316290062847`*^9, 
  3.518331649941944*^9}, {3.518333008639085*^9, 3.5183330096254272`*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"4", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
    SuperscriptBox["f", "2"]}], 
   RowBox[{
    RowBox[{"4", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "2"], " ", "B"}], "+", 
       RowBox[{"A", " ", 
        SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["F", "2"], " ", "g", " ", "L", " ", 
     SuperscriptBox["r", "2"]}]}]]}]], "Output",
 CellChangeTimes->{{3.518333010312241*^9, 3.5183330361242123`*^9}, {
   3.51833361028717*^9, 3.460457355118911*^9}, {3.4604717911792088`*^9, 
   3.460357079552693*^9}, 3.460367402300655*^9, 3.4603675249971647`*^9, 
   3.4603731128665*^9, 3.518956147093726*^9, {3.542470283791575*^9, 
   3.542470303510756*^9}, 3.5435575727875*^9}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"A", " ", 
       SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "g"}], 
   RowBox[{
    RowBox[{"4", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "2"], " ", "B"}], "+", 
       RowBox[{"A", " ", 
        SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["F", "2"], " ", "g", " ", "L", " ", 
     SuperscriptBox["r", "2"]}]}]]}]], "Output",
 CellChangeTimes->{{3.518333010312241*^9, 3.5183330361242123`*^9}, {
   3.51833361028717*^9, 3.460457355118911*^9}, {3.4604717911792088`*^9, 
   3.460357079552693*^9}, 3.460367402300655*^9, 3.4603675249971647`*^9, 
   3.4603731128665*^9, 3.518956147093726*^9, {3.542470283791575*^9, 
   3.542470303510756*^9}, 3.543557572789269*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "a", " ", "f", " ", "F", " ", "g", " ", "r"}], 
  RowBox[{
   RowBox[{"4", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], " ", "B"}], "+", 
      RowBox[{"A", " ", 
       SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], "-", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox["F", "2"], " ", "g", " ", "L", " ", 
    SuperscriptBox["r", "2"]}]}]]], "Output",
 CellChangeTimes->{{3.518333010312241*^9, 3.5183330361242123`*^9}, {
   3.51833361028717*^9, 3.460457355118911*^9}, {3.4604717911792088`*^9, 
   3.460357079552693*^9}, 3.460367402300655*^9, 3.4603675249971647`*^9, 
   3.4603731128665*^9, 3.518956147093726*^9, {3.542470283791575*^9, 
   3.542470303510756*^9}, 3.5435575727907047`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"newcoeffrr", "/", "coeffrr"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"newcoeffaa", "/", "coeffaa"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"newcoeffra", "/", "coeffra"}]}], "Input",
 CellChangeTimes->{{3.518331616405706*^9, 3.518331616595892*^9}, {
  3.518331651932749*^9, 3.518331663484849*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.518333003950869*^9, 3.5183330367075863`*^9}, {
   3.518333611034684*^9, 3.4604573551783657`*^9}, {3.4604717912409773`*^9, 
   3.460357079602758*^9}, 3.460367402437673*^9, 3.460367525710491*^9, 
   3.460373112923148*^9, 3.518956147225301*^9, {3.542470283871984*^9, 
   3.542470304494123*^9}, 3.5435575728471813`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.518333003950869*^9, 3.5183330367075863`*^9}, {
   3.518333611034684*^9, 3.4604573551783657`*^9}, {3.4604717912409773`*^9, 
   3.460357079602758*^9}, 3.460367402437673*^9, 3.460367525710491*^9, 
   3.460373112923148*^9, 3.518956147225301*^9, {3.542470283871984*^9, 
   3.542470304494123*^9}, 3.543557572848886*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.518333003950869*^9, 3.5183330367075863`*^9}, {
   3.518333611034684*^9, 3.4604573551783657`*^9}, {3.4604717912409773`*^9, 
   3.460357079602758*^9}, 3.460367402437673*^9, 3.460367525710491*^9, 
   3.460373112923148*^9, 3.518956147225301*^9, {3.542470283871984*^9, 
   3.542470304494123*^9}, 3.543557572850223*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"dlist", "[", 
   RowBox[{"[", 
    RowBox[{"1", ";;", "5"}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dEqdXr", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"Table", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"var", "=", 
        RowBox[{"dlist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"newcoeffderiv1", ".", 
         RowBox[{"D", "[", 
          RowBox[{"dlist", ",", "var"}], "]"}]}], "+", 
        RowBox[{"newcoeffderiv2", ".", 
         RowBox[{"D", "[", 
          RowBox[{"dlist2", ",", "var"}], "]"}]}]}]}], "\[IndentingNewLine]", 
      ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", "5"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{
  3.518333227103704*^9, {3.518333480232041*^9, 3.4604594574152613`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Tr", ",", "Ar", ",", "Br", ",", "Fr", ",", "Sr"}], "}"}]], "Output",
 CellChangeTimes->{{3.5183335027955914`*^9, 3.518333514685808*^9}, {
   3.518333611590702*^9, 3.460457355237709*^9}, 3.4604594586574097`*^9, {
   3.460471688422566*^9, 3.460471691951612*^9}, {3.460471791311347*^9, 
   3.460357079654398*^9}, 3.460367526557815*^9, 3.460373112970373*^9, 
   3.518956147358429*^9, {3.5424702839364567`*^9, 3.5424703054125977`*^9}, 
   3.54355757289009*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"dlist", "[", 
   RowBox[{"[", 
    RowBox[{"6", ";;", "10"}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dEqdXa", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"Table", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"var", "=", 
        RowBox[{"dlist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"newcoeffderiv1", ".", 
         RowBox[{"D", "[", 
          RowBox[{"dlist", ",", "var"}], "]"}]}], "+", 
        RowBox[{"newcoeffderiv2", ".", 
         RowBox[{"D", "[", 
          RowBox[{"dlist2", ",", "var"}], "]"}]}]}]}], "\[IndentingNewLine]", 
      ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "6", ",", "10"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.5183334883182907`*^9, 3.46045946456726*^9}, 
   3.460471775277463*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Ta", ",", "Aa", ",", "Ba", ",", "Fa", ",", "Sa"}], "}"}]], "Output",
 CellChangeTimes->{{3.518333510222447*^9, 3.518333515401684*^9}, {
   3.5183336121660957`*^9, 3.460457355286152*^9}, 3.460459465202958*^9, {
   3.460471791406118*^9, 3.460357079722847*^9}, 3.460367527423367*^9, 
   3.46037311302251*^9, 3.518956147424861*^9, {3.54247028410785*^9, 
   3.5424703062303*^9}, 3.543557572930814*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dEqdT", "=", 
    RowBox[{
     RowBox[{"newcoeffrrT", ".", "dlistrr"}], "+", 
     RowBox[{"newcoeffaaT", ".", "dlistaa"}], "+", 
     RowBox[{"newcoeffraT", ".", "dlistra"}], "+", 
     RowBox[{"newcoeffderiv1T", ".", "dlist"}], "+", 
     RowBox[{"newcoeffderiv2T", ".", "dlist2"}], "+", "newcoeffnoderivT"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dEqdA", "=", 
    RowBox[{
     RowBox[{"newcoeffrrA", ".", "dlistrr"}], "+", 
     RowBox[{"newcoeffaaA", ".", "dlistaa"}], "+", 
     RowBox[{"newcoeffraA", ".", "dlistra"}], "+", 
     RowBox[{"newcoeffderiv1A", ".", "dlist"}], "+", 
     RowBox[{"newcoeffderiv2A", ".", "dlist2"}], "+", "newcoeffnoderivA"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dEqdB", "=", 
    RowBox[{
     RowBox[{"newcoeffrrB", ".", "dlistrr"}], "+", 
     RowBox[{"newcoeffaaB", ".", "dlistaa"}], "+", 
     RowBox[{"newcoeffraB", ".", "dlistra"}], "+", 
     RowBox[{"newcoeffderiv1B", ".", "dlist"}], "+", 
     RowBox[{"newcoeffderiv2B", ".", "dlist2"}], "+", "newcoeffnoderivB"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dEqdF", "=", 
    RowBox[{
     RowBox[{"newcoeffrrF", ".", "dlistrr"}], "+", 
     RowBox[{"newcoeffaaF", ".", "dlistaa"}], "+", 
     RowBox[{"newcoeffraF", ".", "dlistra"}], "+", 
     RowBox[{"newcoeffderiv1F", ".", "dlist"}], "+", 
     RowBox[{"newcoeffderiv2F", ".", "dlist2"}], "+", "newcoeffnoderivF"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dEqdS", "=", 
   RowBox[{
    RowBox[{"newcoeffrrS", ".", "dlistrr"}], "+", 
    RowBox[{"newcoeffaaS", ".", "dlistaa"}], "+", 
    RowBox[{"newcoeffraS", ".", "dlistra"}], "+", 
    RowBox[{"newcoeffderiv1S", ".", "dlist"}], "+", 
    RowBox[{"newcoeffderiv2S", ".", "dlist2"}], "+", "newcoeffnoderivS"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.518332672762429*^9, 3.518332703948852*^9}, {
  3.518332739919044*^9, 3.518332764548563*^9}, {3.518333064991692*^9, 
  3.518333065422656*^9}, {3.5183331259113207`*^9, 3.518333196997417*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", "dEqdXr", "]"}]], "Input",
 CellChangeTimes->{{3.5183337577506247`*^9, 3.518333767948503*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "5"}], "}"}]], "Output",
 CellChangeTimes->{{3.518333760834996*^9, 3.5183337683749638`*^9}, {
   3.5183347447146187`*^9, 3.46045735536334*^9}, {3.4604717915311832`*^9, 
   3.460357079819146*^9}, 3.460367529233252*^9, 3.460373113082575*^9, 
   3.518956147524436*^9, {3.542470284375291*^9, 3.5424703077710733`*^9}, 
   3.543557573004772*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Writeout", "Subsubtitle",
 CellChangeTimes->{{3.460389558463635*^9, 3.460389558896888*^9}, {
  3.460389609430746*^9, 3.4603896114348288`*^9}, {3.5183299969175587`*^9, 
  3.5183299978831244`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", "x_", "]"}], "\[Rule]", 
      RowBox[{"exp", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"r", "^", "2"}], "\[Rule]", "r2"}], ",", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "\[Rule]", "a2"}], ",", 
     RowBox[{"\[CapitalLambda]", "\[Rule]", "Lambda"}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.5183318727983723`*^9, 3.5183319048853703`*^9}, 
   3.5183326520968113`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetDirectory", "[", "\"\<~/Work/SpecTestDim6/\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.518335047259989*^9, 3.4604575247587214`*^9}, {
  3.518956058181387*^9, 3.518956058460064*^9}, {3.542470251559609*^9, 
  3.542470265311243*^9}}],

Cell[BoxData["\<\"/Users/tobywiseman/Work/SpecTestDim6\"\>"], "Output",
 CellChangeTimes->{
  3.518335050661092*^9, 3.5183350829328203`*^9, {3.518340606630434*^9, 
   3.46045735603988*^9}, {3.4604575278540783`*^9, 3.460457531990162*^9}, 
   3.460459469128682*^9, 3.460471794549274*^9, {3.460476255038741*^9, 
   3.460357079884597*^9}, 3.460367534747438*^9, 3.4603731131518297`*^9, 
   3.5189561477075033`*^9, 3.542470310037469*^9, 3.5424715445227633`*^9, 
   3.5435577056635227`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"string", "=", "\"\<\\n\\n\>\""}], ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stringtmp", "=", 
      RowBox[{"ToString", "[", 
       RowBox[{"CForm", "[", 
        RowBox[{
         RowBox[{"EqX", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], "//.", "repl"}], "]"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"stringtmp", "=", 
      RowBox[{"\"\<EqX[\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"ii", "-", "1"}], "]"}], "<>", "\"\<] = \>\"", "<>", 
       "stringtmp", "<>", "\"\< ;\\n\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"string", "=", 
      RowBox[{"string", "<>", "stringtmp"}]}], ";"}], "\[IndentingNewLine]", 
    ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", "5"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"string", "=", 
   RowBox[{"string", "<>", "\"\<\\n\>\""}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.518340465803512*^9, 3.518340491929764*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<EqnAnsatz1.c\>\"", ",", "string", ",", "\"\<Text\>\""}], 
   "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.5183405071532507`*^9, 3.518340509007971*^9}, {
  3.5435574336584*^9, 3.543557435017489*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"string", "=", "\"\<\\n\\n\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.518333647605736*^9, 3.518333649032753*^9}, {
  3.518333725854959*^9, 3.5183337278449717`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"string", "=", 
    RowBox[{"string", "<>", "\"\<coeffrr = \>\"", "<>", 
     RowBox[{"ToString", "[", 
      RowBox[{"CForm", "[", 
       RowBox[{"coeffrr", "//.", "repl"}], "]"}], "]"}], "<>", 
     "\"\< ; \\n\>\""}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"string", "=", 
    RowBox[{"string", "<>", "\"\<coeffaa = \>\"", "<>", 
     RowBox[{"ToString", "[", 
      RowBox[{"CForm", "[", 
       RowBox[{"coeffaa", "//.", "repl"}], "]"}], "]"}], "<>", 
     "\"\< ; \\n\>\""}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"string", "=", 
   RowBox[{"string", "<>", "\"\<coeffra = \>\"", "<>", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{"coeffra", "//.", "repl"}], "]"}], "]"}], "<>", 
    "\"\< ; \\n\\n\>\""}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.518333650719015*^9, 3.460457184086981*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stringtmp", "=", 
      RowBox[{"ToString", "[", 
       RowBox[{"CForm", "[", 
        RowBox[{
         RowBox[{"dEqdXr", "[", 
          RowBox[{"[", 
           RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "//.", "repl"}], "]"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"stringtmp", "=", 
      RowBox[{"\"\<dEqXr[\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"ii", "-", "1"}], "]"}], "<>", "\"\<][\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"jj", "-", "1"}], "]"}], "<>", "\"\<] = \>\"", "<>", 
       "stringtmp", "<>", "\"\< ;\\n\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"string", "=", 
      RowBox[{"string", "<>", "stringtmp"}]}], ";"}], "\[IndentingNewLine]", 
    ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"jj", ",", "1", ",", "5"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"string", "=", 
   RowBox[{"string", "<>", "\"\<\\n\>\""}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.518331809661859*^9, 3.518332028823266*^9}, {
  3.518332086975601*^9, 3.518332107464229*^9}, {3.518332211916683*^9, 
  3.5183322173586197`*^9}, {3.51833477610849*^9, 3.5183348288545113`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stringtmp", "=", 
      RowBox[{"ToString", "[", 
       RowBox[{"CForm", "[", 
        RowBox[{
         RowBox[{"dEqdXa", "[", 
          RowBox[{"[", 
           RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "//.", "repl"}], "]"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"stringtmp", "=", 
      RowBox[{"\"\<dEqXa[\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"ii", "-", "1"}], "]"}], "<>", "\"\<][\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"jj", "-", "1"}], "]"}], "<>", "\"\<] = \>\"", "<>", 
       "stringtmp", "<>", "\"\< ;\\n\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"string", "=", 
      RowBox[{"string", "<>", "stringtmp"}]}], ";"}], "\[IndentingNewLine]", 
    ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"jj", ",", "1", ",", "5"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"string", "=", 
   RowBox[{"string", "<>", "\"\<\\n\>\""}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.518334835075614*^9, 3.5183348365946302`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stringtmp", "=", 
      RowBox[{"ToString", "[", 
       RowBox[{"CForm", "[", 
        RowBox[{
         RowBox[{"dEqdT", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], "//.", "repl"}], "]"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"stringtmp", "=", 
      RowBox[{"\"\<dEqT[\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"ii", "-", "1"}], "]"}], "<>", "\"\<] = \>\"", "<>", 
       "stringtmp", "<>", "\"\< ;\\n\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"string", "=", 
      RowBox[{"string", "<>", "stringtmp"}]}], ";"}], "\[IndentingNewLine]", 
    ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", "5"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"string", "=", 
   RowBox[{"string", "<>", "\"\<\\n\>\""}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.518334872457034*^9, 3.518334909666383*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stringtmp", "=", 
      RowBox[{"ToString", "[", 
       RowBox[{"CForm", "[", 
        RowBox[{
         RowBox[{"dEqdA", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], "//.", "repl"}], "]"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"stringtmp", "=", 
      RowBox[{"\"\<dEqA[\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"ii", "-", "1"}], "]"}], "<>", "\"\<] = \>\"", "<>", 
       "stringtmp", "<>", "\"\< ;\\n\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"string", "=", 
      RowBox[{"string", "<>", "stringtmp"}]}], ";"}], "\[IndentingNewLine]", 
    ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", "5"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"string", "=", 
    RowBox[{"string", "<>", "\"\<\\n\>\""}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stringtmp", "=", 
      RowBox[{"ToString", "[", 
       RowBox[{"CForm", "[", 
        RowBox[{
         RowBox[{"dEqdB", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], "//.", "repl"}], "]"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"stringtmp", "=", 
      RowBox[{"\"\<dEqB[\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"ii", "-", "1"}], "]"}], "<>", "\"\<] = \>\"", "<>", 
       "stringtmp", "<>", "\"\< ;\\n\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"string", "=", 
      RowBox[{"string", "<>", "stringtmp"}]}], ";"}], "\[IndentingNewLine]", 
    ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", "5"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"string", "=", 
    RowBox[{"string", "<>", "\"\<\\n\>\""}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stringtmp", "=", 
      RowBox[{"ToString", "[", 
       RowBox[{"CForm", "[", 
        RowBox[{
         RowBox[{"dEqdF", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], "//.", "repl"}], "]"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"stringtmp", "=", 
      RowBox[{"\"\<dEqF[\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"ii", "-", "1"}], "]"}], "<>", "\"\<] = \>\"", "<>", 
       "stringtmp", "<>", "\"\< ;\\n\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"string", "=", 
      RowBox[{"string", "<>", "stringtmp"}]}], ";"}], "\[IndentingNewLine]", 
    ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", "5"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"string", "=", 
    RowBox[{"string", "<>", "\"\<\\n\>\""}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stringtmp", "=", 
      RowBox[{"ToString", "[", 
       RowBox[{"CForm", "[", 
        RowBox[{
         RowBox[{"dEqdS", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], "//.", "repl"}], "]"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"stringtmp", "=", 
      RowBox[{"\"\<dEqS[\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"ii", "-", "1"}], "]"}], "<>", "\"\<] = \>\"", "<>", 
       "stringtmp", "<>", "\"\< ;\\n\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"string", "=", 
      RowBox[{"string", "<>", "stringtmp"}]}], ";"}], "\[IndentingNewLine]", 
    ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", "5"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"string", "=", 
   RowBox[{"string", "<>", "\"\<\\n\>\""}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.518334917457026*^9, 3.518334955500956*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<LicheqAnsatz1.c\>\"", ",", "string", ",", "\"\<Text\>\""}], 
   "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.518335089624618*^9, 3.5183350904782057`*^9}, {
   3.5183351461684113`*^9, 3.518335183038703*^9}, 3.5435574420749207`*^9}],

Cell[CellGroupData[{

Cell[BoxData["dlist"], "Input",
 CellChangeTimes->{{3.460459077169083*^9, 3.46045907770472*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Tr", ",", "Ar", ",", "Br", ",", "Fr", ",", "Sr", ",", "Ta", ",", "Aa", ",",
    "Ba", ",", "Fa", ",", "Sa"}], "}"}]], "Output",
 CellChangeTimes->{
  3.460459078258154*^9, 3.460459469773625*^9, {3.460471795168087*^9, 
   3.4603570809992857`*^9}, 3.460367535414236*^9, 3.4603731138951397`*^9, 
   3.518956148340263*^9, 3.542470323998266*^9, 3.543557706097444*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"newcoeffderiv1", "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", "4"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.460459088025856*^9, 3.460459097969833*^9}, 
   3.460459170231216*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.460459090641872*^9, 3.460459099754526*^9}, {
   3.460459170618367*^9, 3.460459174014978*^9}, 3.4604594698295927`*^9, {
   3.460471795223578*^9, 3.4603570810490723`*^9}, 3.4603675354564877`*^9, 
   3.460373113937702*^9, 3.5189561483812*^9, 3.542470324783177*^9, 
   3.543557706139058*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"dEqdXr", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "4"}], "]"}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"F", "\[Rule]", "0"}], ",", 
     RowBox[{"A", "\[Rule]", "0"}], ",", 
     RowBox[{"T", "\[Rule]", "0"}], ",", 
     RowBox[{"S", "\[Rule]", "0"}], ",", 
     RowBox[{"B", "\[Rule]", "0"}], ",", 
     RowBox[{"Fr", "\[Rule]", "0"}], ",", 
     RowBox[{"Aa", "\[Rule]", "0"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4604591928764257`*^9, 3.4604591929805098`*^9}, {
  3.4604592730025387`*^9, 3.460459313594109*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.460459278944747*^9, 3.460459317877679*^9}, 
   3.46045946995273*^9, {3.4604717952682047`*^9, 3.460357081103486*^9}, 
   3.460367535508625*^9, 3.4603731139742193`*^9, 3.518956148427936*^9, 
   3.542470325819332*^9, 3.543557706172864*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Invariants", "Subsubtitle",
 CellChangeTimes->{{3.460389558463635*^9, 3.460389558896888*^9}, {
  3.460389609430746*^9, 3.4603896114348288`*^9}, {3.5183299969175587`*^9, 
  3.5183299978831244`*^9}, {3.5397830191049967`*^9, 3.539783022455769*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Simplify", "[", "Ricci", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.539875736597961*^9, 3.539875741759275*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"R2", "=", 
   RowBox[{"Simplify", "[", "R2", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.539868949198064*^9, 3.539868956381056*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"R4", "=", 
   RowBox[{"Simplify", "[", "R4", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.539868958941936*^9, 3.539868962927821*^9}, {
  3.539873633269683*^9, 3.5398736355164633`*^9}, {3.539875345607072*^9, 
  3.539875348366993*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "C4", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"C4", ",", "4", ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "d", ",", "d", ",", "d"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"C4", "=", 
      RowBox[{"ST", "[", 
       RowBox[{"C4", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i1", ",", "d"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i2", ",", "d"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i3", ",", "d"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i4", ",", "d"}], "}"}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"R4", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"i1", ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"i2", ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"i3", ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"i4", ",", "d"}], "}"}]}], "}"}]}], "]"}], "-", 
         RowBox[{
          FractionBox["1", "4"], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"Gd", "[", 
              RowBox[{"[", 
               RowBox[{"i1", ",", "i3"}], "]"}], "]"}], 
             RowBox[{"GT", "[", 
              RowBox[{"R2", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"i2", ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"i4", ",", "d"}], "}"}]}], "}"}]}], "]"}]}], "-", 
            RowBox[{
             RowBox[{"Gd", "[", 
              RowBox[{"[", 
               RowBox[{"i1", ",", "i4"}], "]"}], "]"}], 
             RowBox[{"GT", "[", 
              RowBox[{"R2", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"i2", ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"i3", ",", "d"}], "}"}]}], "}"}]}], "]"}]}], "-", 
            RowBox[{
             RowBox[{"Gd", "[", 
              RowBox[{"[", 
               RowBox[{"i2", ",", "i3"}], "]"}], "]"}], 
             RowBox[{"GT", "[", 
              RowBox[{"R2", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"i1", ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"i4", ",", "d"}], "}"}]}], "}"}]}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"Gd", "[", 
              RowBox[{"[", 
               RowBox[{"i2", ",", "i4"}], "]"}], "]"}], 
             RowBox[{"GT", "[", 
              RowBox[{"R2", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"i1", ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"i3", ",", "d"}], "}"}]}], "}"}]}], "]"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          FractionBox["1", 
           RowBox[{"5", "*", "4"}]], "Ricci", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"Gd", "[", 
              RowBox[{"[", 
               RowBox[{"i1", ",", "i3"}], "]"}], "]"}], 
             RowBox[{"Gd", "[", 
              RowBox[{"[", 
               RowBox[{"i2", ",", "i4"}], "]"}], "]"}]}], "-", 
            RowBox[{
             RowBox[{"Gd", "[", 
              RowBox[{"[", 
               RowBox[{"i1", ",", "i4"}], "]"}], "]"}], 
             RowBox[{"Gd", "[", 
              RowBox[{"[", 
               RowBox[{"i2", ",", "i3"}], "]"}], "]"}]}]}], ")"}]}]}]}], 
       "\[IndentingNewLine]", "]"}]}], ";"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i4", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5398731927466583`*^9, 3.5398732399145308`*^9}, {
  3.5398732894972343`*^9, 3.53987340283033*^9}, {3.539873443732388*^9, 
  3.539873496579793*^9}, {3.539873596517035*^9, 3.539873608106615*^9}, {
  3.54247038872611*^9, 3.542470391908834*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"T", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "T"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Tl"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Tr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Ta"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Trr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Taa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Tra"}], ",", 
     RowBox[{
      RowBox[{"A", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "A"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Al"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Ar"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Aa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Arr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Aaa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Ara"}], ",", 
     RowBox[{
      RowBox[{"B", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "B"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Bl"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Br"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Ba"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Brr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Baa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Bra"}], ",", 
     RowBox[{
      RowBox[{"F", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "F"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Fl"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Fr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Fa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Frr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Faa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Fra"}], ",", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "S"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Sl"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Sr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Sa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Srr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Saa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Sra"}], ",", 
     RowBox[{
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "L"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalDelta]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "Lr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalDelta]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "Lrr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalDelta]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "La"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalDelta]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "Laa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalDelta]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "Lra"}], ",", 
     RowBox[{
      RowBox[{"f", "[", "r", "]"}], "\[Rule]", "f"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "r", "]"}], "\[Rule]", "fr"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "''"}], "[", "r", "]"}], "\[Rule]", "frr"}], ",", 
     RowBox[{
      RowBox[{"g", "[", "a", "]"}], "\[Rule]", "g"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"g", "'"}], "[", "a", "]"}], "\[Rule]", "ga"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"g", "''"}], "[", "a", "]"}], "\[Rule]", "gaa"}], ",", 
     RowBox[{
      RowBox[{"Exp", "[", "x_", "]"}], "\[Rule]", 
      RowBox[{"expl", "[", "x", "]"}]}], ",", 
     RowBox[{"\[Theta]1", "\[Rule]", "theta"}], ",", 
     RowBox[{"\[Theta]2", "\[Rule]", "theta2"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.426233462410046*^9, 3.426233529934688*^9}, {
   3.426425823867654*^9, 3.426425926949801*^9}, {3.460305912394334*^9, 
   3.460306053671014*^9}, {3.460307114041431*^9, 3.460307131380796*^9}, {
   3.5033115682122517`*^9, 3.503311569834202*^9}, {3.504000155601179*^9, 
   3.504000163012282*^9}, {3.517581414802555*^9, 3.517581424098625*^9}, 
   3.517824243782352*^9, {3.5178251206831512`*^9, 3.460392807343815*^9}, {
   3.460396802022485*^9, 3.460396867528345*^9}, {3.539783320610353*^9, 
   3.5397833270607758`*^9}, {3.539816624416975*^9, 3.53981663155166*^9}, {
   3.542470460764052*^9, 3.542470464658218*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetDirectory", "[", "\"\<~/Work/SpecTestDim6/\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.518335047259989*^9, 3.4604575247587214`*^9}, {
   3.518956058181387*^9, 3.518956058460064*^9}, {3.5398163390954742`*^9, 
   3.53981634105991*^9}, 3.542470294843143*^9}],

Cell[BoxData["\<\"/Users/tobywiseman/Work/SpecTestDim6\"\>"], "Output",
 CellChangeTimes->{
  3.518335050661092*^9, 3.5183350829328203`*^9, {3.518340606630434*^9, 
   3.46045735603988*^9}, {3.4604575278540783`*^9, 3.460457531990162*^9}, 
   3.460459469128682*^9, 3.460471794549274*^9, {3.460476255038741*^9, 
   3.460357079884597*^9}, 3.460367534747438*^9, 3.4603731131518297`*^9, 
   3.5189561477075033`*^9, 3.5398163425514393`*^9, {3.539816459059843*^9, 
   3.539816480498577*^9}, 3.539816637906023*^9, 3.539868512209516*^9, {
   3.539868680044777*^9, 3.5398686884966383`*^9}, 3.5398702287801237`*^9, 
   3.5398738241171722`*^9, 3.5398755197640667`*^9, 3.539875860303957*^9, 
   3.542470798999097*^9, 3.5435580219642363`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"string", "=", "\"\<\\n\\n\>\""}], ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stringtmp", "=", 
      RowBox[{"ToString", "[", 
       RowBox[{"CForm", "[", 
        RowBox[{
         RowBox[{"Gd", "[", 
          RowBox[{"[", 
           RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "//.", "repl"}], "]"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"stringtmp", "=", 
      RowBox[{"\"\<gd[\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"ii", "-", "1"}], "]"}], "<>", "\"\<][\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"jj", "-", "1"}], "]"}], "<>", "\"\<] = \>\"", "<>", 
       "stringtmp", "<>", "\"\< ;\\n\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"string", "=", 
      RowBox[{"string", "<>", "stringtmp", "<>", "\"\<\\n\>\""}]}], ";"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", "Nind"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"jj", ",", "1", ",", "Nind"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"string", "=", 
   RowBox[{"string", "<>", "\"\<\\n\>\""}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.518340465803512*^9, 3.518340491929764*^9}, {
  3.5398163805013123`*^9, 3.539816437514002*^9}, {3.539868518460724*^9, 
  3.539868574470571*^9}, {3.539868606350236*^9, 3.539868616907847*^9}, {
  3.53986869866046*^9, 3.539868699979281*^9}, {3.539868893791936*^9, 
  3.539868896510894*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stringtmp", "=", 
      RowBox[{"ToString", "[", 
       RowBox[{"CForm", "[", 
        RowBox[{
         RowBox[{"Gu", "[", 
          RowBox[{"[", 
           RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "//.", "repl"}], "]"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"stringtmp", "=", 
      RowBox[{"\"\<gu[\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"ii", "-", "1"}], "]"}], "<>", "\"\<][\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"jj", "-", "1"}], "]"}], "<>", "\"\<] = \>\"", "<>", 
       "stringtmp", "<>", "\"\< ;\\n\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"string", "=", 
      RowBox[{"string", "<>", "stringtmp", "<>", "\"\<\\n\>\""}]}], ";"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", "Nind"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"jj", ",", "1", ",", "Nind"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"string", "=", 
   RowBox[{"string", "<>", "\"\<\\n\>\""}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.518340465803512*^9, 3.518340491929764*^9}, {
  3.5398163805013123`*^9, 3.539816437514002*^9}, {3.539868518460724*^9, 
  3.539868574470571*^9}, {3.539868606350236*^9, 3.539868627325491*^9}, {
  3.539868709539381*^9, 3.539868710763042*^9}, {3.539868899329043*^9, 
  3.539868901934766*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stringtmp", "=", 
      RowBox[{"ToString", "[", 
       RowBox[{"CForm", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"R2", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "//.", "repl"}], "]"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"stringtmp", "=", 
      RowBox[{"\"\<R2[\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"ii", "-", "1"}], "]"}], "<>", "\"\<][\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"jj", "-", "1"}], "]"}], "<>", "\"\<] = \>\"", "<>", 
       "stringtmp", "<>", "\"\< ;\\n\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"string", "=", 
      RowBox[{"string", "<>", "stringtmp", "<>", "\"\<\\n\>\""}]}], ";"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", "Nind"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"jj", ",", "1", ",", "Nind"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"string", "=", 
   RowBox[{"string", "<>", "\"\<\\n\>\""}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.518340465803512*^9, 3.518340491929764*^9}, {
  3.5398163805013123`*^9, 3.539816437514002*^9}, {3.539868518460724*^9, 
  3.539868574470571*^9}, {3.539868606350236*^9, 3.539868627325491*^9}, {
  3.539868713554957*^9, 3.539868715194871*^9}, {3.5398687745146427`*^9, 
  3.539868778392296*^9}, {3.539868908127057*^9, 3.53986891066252*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stringtmp", "=", 
      RowBox[{"ToString", "[", 
       RowBox[{"CForm", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"C4", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"ii", ",", "jj", ",", "kk", ",", "ll"}], "]"}], "]"}], "//.",
          "repl"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"stringtmp", "=", 
      RowBox[{"\"\<C4[\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"ii", "-", "1"}], "]"}], "<>", "\"\<][\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"jj", "-", "1"}], "]"}], "<>", "\"\<][\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"kk", "-", "1"}], "]"}], "<>", "\"\<][\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"ll", "-", "1"}], "]"}], "<>", "\"\<] = \>\"", "<>", 
       "stringtmp", "<>", "\"\< ;\\n\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"string", "=", 
      RowBox[{"string", "<>", "stringtmp", "<>", "\"\<\\n\>\""}]}], ";"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", "Nind"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"jj", ",", "1", ",", "Nind"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"kk", ",", "1", ",", "Nind"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"ll", ",", "1", ",", "Nind"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"string", "=", 
   RowBox[{"string", "<>", "\"\<\\n\>\""}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.518340465803512*^9, 3.518340491929764*^9}, {
  3.5398163805013123`*^9, 3.539816437514002*^9}, {3.539868518460724*^9, 
  3.539868574470571*^9}, {3.539868606350236*^9, 3.539868627325491*^9}, {
  3.539868713554957*^9, 3.539868715194871*^9}, {3.5398687745146427`*^9, 
  3.539868833305031*^9}, {3.539868912679419*^9, 3.539868919759419*^9}, {
  3.5398736402954473`*^9, 3.539873644807032*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<CurvAnsatz1.c\>\"", ",", "string", ",", "\"\<Text\>\""}], 
   "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.5183405071532507`*^9, 3.518340509007971*^9}, {
   3.539816446282407*^9, 3.5398164467134743`*^9}, 3.5435574581704397`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Brane BC", "Subsubtitle",
 CellChangeTimes->{{3.460389558463635*^9, 3.460389558896888*^9}, {
  3.460389609430746*^9, 3.4603896114348288`*^9}, {3.5183299969175587`*^9, 
  3.460476078379003*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", "x_", "]"}], "\[Rule]", 
      RowBox[{"exp", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"r", "^", "2"}], "\[Rule]", "r2"}], ",", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "\[Rule]", "a2"}], ",", 
     RowBox[{"\[CapitalLambda]", "\[Rule]", "Lambda"}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.426233462410046*^9, 3.426233529934688*^9}, {
   3.426425823867654*^9, 3.426425926949801*^9}, {3.460305912394334*^9, 
   3.460306053671014*^9}, {3.460307114041431*^9, 3.460307131380796*^9}, {
   3.5033115682122517`*^9, 3.503311569834202*^9}, {3.504000155601179*^9, 
   3.504000163012282*^9}, {3.517581414802555*^9, 3.517581424098625*^9}, 
   3.517824243782352*^9, {3.5178251206831512`*^9, 3.460392807343815*^9}, {
   3.460396802022485*^9, 3.460396867528345*^9}, 3.543561708259016*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dlist\[Lambda]", "=", 
    RowBox[{"{", 
     RowBox[{"Tl", ",", "Al", ",", "Bl", ",", "Fl", ",", "Sl"}], "}"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dlistrr", "=", 
    RowBox[{"{", 
     RowBox[{"Trr", ",", "Arr", ",", "Brr", ",", "Frr", ",", "Srr"}], "}"}]}],
    ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dlistaa", "=", 
    RowBox[{"{", 
     RowBox[{"Taa", ",", "Aaa", ",", "Baa", ",", "Faa", ",", "Saa"}], "}"}]}],
    ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dlistra", "=", 
    RowBox[{"{", 
     RowBox[{"Tra", ",", "Ara", ",", "Bra", ",", "Fra", ",", "Sra"}], "}"}]}],
    ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dlist", "=", 
   RowBox[{"{", 
    RowBox[{
    "Tr", ",", "Ar", ",", "Br", ",", "Fr", ",", "Sr", ",", "Ta", ",", "Aa", 
     ",", "Ba", ",", "Fa", ",", "Sa"}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.517824939478304*^9, 3.5178249658652477`*^9}, {
  3.517825345546793*^9, 3.517825357952314*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"allderiv", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
    "dlist\[Lambda]", ",", "dlistrr", ",", "dlistaa", ",", "dlistra", ",", 
     "dlist"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.517824997155527*^9, 3.517825012540985*^9}, {
  3.51782518467982*^9, 3.5178251854111958`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"dlist2", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"dlist", "[", 
        RowBox[{"[", "ii", "]"}], "]"}], 
       RowBox[{"dlist", "[", 
        RowBox[{"[", "jj", "]"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "dlist", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"jj", ",", "ii", ",", 
        RowBox[{"Length", "[", "dlist", "]"}]}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.5178269895484753`*^9, 3.5178270260336027`*^9}, {
  3.517827312763998*^9, 3.517827331395611*^9}, {3.5435587421996403`*^9, 
  3.54355874417587*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetDirectory", "[", "\"\<~/Work/SpecTestDim6/\>\"", "]"}]], "Input"],

Cell[BoxData["\<\"/Users/tobywiseman/Work/SpecTestDim6\"\>"], "Output",
 CellChangeTimes->{3.5424716207669077`*^9, 3.543558666297194*^9, 
  3.543558745358375*^9, 3.543561711346139*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dTIsreal3", "=", 
    FractionBox[
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox[
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", "S"}]]]}], ")"}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["r", "2"]}]], " ", "rh"}]]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dSIsreal3", "=", 
    FractionBox[
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox[
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", "S"}]]]}], ")"}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["r", "2"]}]], " ", "rh"}]]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dBIsreal3", "=", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["r", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"8", " ", 
           SuperscriptBox["\[ExponentialE]", 
            FractionBox[
             RowBox[{"B", "+", "S"}], "2"]]}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "-", 
             SuperscriptBox["r", "2"]}], ")"}], 
           RowBox[{"3", "/", "2"}]]]}], "+", 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["\[ExponentialE]", "B"]}], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", "S", "-", "T"}]], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "-", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "-", "T"}]]}], ")"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SuperscriptBox["r", "2"]}], ")"}], 
          RowBox[{"3", "/", "2"}]]], "+", 
        FractionBox[
         RowBox[{"B", " ", "rh"}], 
         RowBox[{"1", "-", 
          SuperscriptBox["r", "2"]}]]}], ")"}]}], "rh"]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.543558590552661*^9, 3.543558622571598*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"EqBrn", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Ta", "-", "dTIsreal3"}], ",", "Aa", ",", 
     RowBox[{"Ba", "-", 
      RowBox[{"(", "dBIsreal3", ")"}]}], ",", "F", ",", 
     RowBox[{"Sa", "-", 
      RowBox[{"(", "dSIsreal3", ")"}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.460475964391651*^9, 3.46047604870152*^9}, {
   3.46047612707681*^9, 3.4604761655799723`*^9}, 3.460476281500486*^9, {
   3.460476395357801*^9, 3.46047639630765*^9}, {3.4604764268003473`*^9, 
   3.4603663756321583`*^9}, 3.460366410207906*^9, {3.4603664733631268`*^9, 
   3.460366474166729*^9}, 3.460373902092013*^9, {3.54247156895044*^9, 
   3.542471617957204*^9}, {3.543558584496375*^9, 3.5435585975027437`*^9}, {
   3.5435586284603786`*^9, 3.543558631876522*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"string", "=", "\"\<\\n\\n\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.518333647605736*^9, 3.518333649032753*^9}, {
  3.518333725854959*^9, 3.5183337278449717`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stringtmp", "=", 
      RowBox[{"ToString", "[", 
       RowBox[{"CForm", "[", 
        RowBox[{
         RowBox[{"EqBrn", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], "//.", "repl"}], "]"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"stringtmp", "=", 
      RowBox[{"\"\<EqBrn[\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"ii", "-", "1"}], "]"}], "<>", "\"\<] = \>\"", "<>", 
       "stringtmp", "<>", "\"\< ;\\n\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"string", "=", 
      RowBox[{"string", "<>", "stringtmp"}]}], ";"}], "\[IndentingNewLine]", 
    ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", "5"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"string", "=", 
   RowBox[{"string", "<>", "\"\<\\n\>\""}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.518340465803512*^9, 3.460476290381116*^9}, 
   3.460476400933316*^9, 3.4604764358858852`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<BrnAnsatz1.c\>\"", ",", "string", ",", "\"\<Text\>\""}], 
   "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.5183405071532507`*^9, 3.460476297043269*^9}, 
   3.543557469986451*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dBrndT", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"D", "[", 
    RowBox[{"EqBrn", ",", "T"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4604766441783524`*^9, 3.4604766682868023`*^9}, {
  3.460476781423028*^9, 3.460476784299148*^9}, {3.460476930747554*^9, 
  3.46047693251164*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"B", "-", 
        RowBox[{"A", " ", 
         SuperscriptBox["r", "2"]}], "+", "S", "-", "T"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}]]}], ")"}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["r", "2"]}]], " ", "rh"}]]}], ",", "0", ",", "0"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.460476669008933*^9, 3.460476701843594*^9, 3.4604768014626904`*^9, {
   3.460476932937365*^9, 3.460366426379178*^9}, 3.4603664774046717`*^9, 
   3.460367541970667*^9, 3.5189561486906223`*^9, 3.5424716256460257`*^9, 
   3.543558752807665*^9, 3.5435617115142927`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dBrndA", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"D", "[", 
    RowBox[{"EqBrn", ",", "A"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.460476688754343*^9, {3.4604767879595757`*^9, 3.460476798747305*^9}, {
   3.460476935668138*^9, 3.4604769367198477`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"B", "-", 
        RowBox[{"A", " ", 
         SuperscriptBox["r", "2"]}], "+", "S", "-", "T"}]], " ", 
      SuperscriptBox["r", "2"]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["r", "2"]}]], " ", "rh"}]]}], ",", "0", ",", "0"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.460476689601845*^9, 3.460476702474887*^9}, 
   3.460476802328149*^9, {3.4604769371258287`*^9, 3.460366478181157*^9}, 
   3.46036754202604*^9, 3.518956148744828*^9, 3.542471626561208*^9, 
   3.543558753824936*^9, 3.5435617115531263`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dBrndB", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"D", "[", 
    RowBox[{"EqBrn", ",", "B"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.4604766972109222`*^9, {3.4604767890952997`*^9, 3.460476796715781*^9}, {
   3.460476939420917*^9, 3.46047694086395*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      SqrtBox[
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"B", "+", "S"}]]]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["r", "2"]}]], " ", "rh"}]]}], ",", "0", ",", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["r", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", 
           FractionBox[
            RowBox[{"B", "+", "S"}], "2"]]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SuperscriptBox["r", "2"]}], ")"}], 
          RowBox[{"3", "/", "2"}]]]}], "+", 
       FractionBox[
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", "B"], " ", 
         RowBox[{"(", 
          RowBox[{"3", "+", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"S", "-", "T"}]], "+", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "A"}], " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "-", "T"}]]}], ")"}]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           SuperscriptBox["r", "2"]}], ")"}], 
         RowBox[{"3", "/", "2"}]]], "+", 
       FractionBox["rh", 
        RowBox[{"1", "-", 
         SuperscriptBox["r", "2"]}]]}], ")"}]}], "rh"], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      SqrtBox[
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"B", "+", "S"}]]]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["r", "2"]}]], " ", "rh"}]]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.4604767030579367`*^9, 3.4604768031780024`*^9, {3.460476941988902*^9, 
   3.460366485711464*^9}, 3.460367542172348*^9, 3.518956148833517*^9, 
   3.542471627639512*^9, 3.5435587551666393`*^9, 3.5435617116896677`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dBrndF", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"D", "[", 
    RowBox[{"EqBrn", ",", "F"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.460476698600466*^9, {3.460476790350932*^9, 3.460476794699287*^9}, {
   3.460476944204464*^9, 3.46047694527234*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.460476703739608*^9, 3.460476804475659*^9, {3.460476945705949*^9, 
   3.460366489117013*^9}, 3.460367542242334*^9, 3.518956148877571*^9, 
   3.542471628718856*^9, 3.543558756581945*^9, 3.543561711724502*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dBrndS", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"D", "[", 
    RowBox[{"EqBrn", ",", "S"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.460476699880625*^9, {3.4604767913912983`*^9, 3.4604767927551823`*^9}, {
   3.460476947644761*^9, 3.460476948912462*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      SqrtBox[
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"B", "+", "S"}]]]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["r", "2"]}]], " ", "rh"}]]}], ",", "0", ",", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "8"}], " ", 
      SuperscriptBox["\[ExponentialE]", 
       FractionBox[
        RowBox[{"B", "+", "S"}], "2"]]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"B", "+", "S", "-", "T"}]]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"B", "-", 
        RowBox[{"A", " ", 
         SuperscriptBox["r", "2"]}], "+", "S", "-", "T"}]]}]}], 
    RowBox[{
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["r", "2"]}]], " ", "rh"}]], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      SqrtBox[
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"B", "+", "S"}]]]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["r", "2"]}]], " ", "rh"}]]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.4604767044236097`*^9, 3.460476805393095*^9, {3.460476949413457*^9, 
   3.460366491743512*^9}, 3.460367542358202*^9, 3.518956148928899*^9, 
   3.542471629602553*^9, 3.543558757574271*^9, 3.543561711766356*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"string", "=", "\"\<\\n\\n\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.518333647605736*^9, 3.518333649032753*^9}, {
  3.518333725854959*^9, 3.5183337278449717`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stringtmp", "=", 
      RowBox[{"ToString", "[", 
       RowBox[{"CForm", "[", 
        RowBox[{
         RowBox[{"dBrndT", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], "//.", "repl"}], "]"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"stringtmp", "=", 
      RowBox[{"\"\<dBrnT[\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"ii", "-", "1"}], "]"}], "<>", "\"\<] = \>\"", "<>", 
       "stringtmp", "<>", "\"\< ;\\n\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"string", "=", 
      RowBox[{"string", "<>", "stringtmp"}]}], ";"}], "\[IndentingNewLine]", 
    ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", "5"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"string", "=", 
   RowBox[{"string", "<>", "\"\<\\n\>\""}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.518334872457034*^9, 3.4604768307587357`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stringtmp", "=", 
      RowBox[{"ToString", "[", 
       RowBox[{"CForm", "[", 
        RowBox[{
         RowBox[{"dBrndA", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], "//.", "repl"}], "]"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"stringtmp", "=", 
      RowBox[{"\"\<dBrnA[\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"ii", "-", "1"}], "]"}], "<>", "\"\<] = \>\"", "<>", 
       "stringtmp", "<>", "\"\< ;\\n\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"string", "=", 
      RowBox[{"string", "<>", "stringtmp"}]}], ";"}], "\[IndentingNewLine]", 
    ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", "5"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"string", "=", 
    RowBox[{"string", "<>", "\"\<\\n\>\""}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stringtmp", "=", 
      RowBox[{"ToString", "[", 
       RowBox[{"CForm", "[", 
        RowBox[{
         RowBox[{"dBrndB", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], "//.", "repl"}], "]"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"stringtmp", "=", 
      RowBox[{"\"\<dBrnB[\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"ii", "-", "1"}], "]"}], "<>", "\"\<] = \>\"", "<>", 
       "stringtmp", "<>", "\"\< ;\\n\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"string", "=", 
      RowBox[{"string", "<>", "stringtmp"}]}], ";"}], "\[IndentingNewLine]", 
    ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", "5"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"string", "=", 
    RowBox[{"string", "<>", "\"\<\\n\>\""}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stringtmp", "=", 
      RowBox[{"ToString", "[", 
       RowBox[{"CForm", "[", 
        RowBox[{
         RowBox[{"dBrndF", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], "//.", "repl"}], "]"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"stringtmp", "=", 
      RowBox[{"\"\<dBrnF[\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"ii", "-", "1"}], "]"}], "<>", "\"\<] = \>\"", "<>", 
       "stringtmp", "<>", "\"\< ;\\n\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"string", "=", 
      RowBox[{"string", "<>", "stringtmp"}]}], ";"}], "\[IndentingNewLine]", 
    ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", "5"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"string", "=", 
    RowBox[{"string", "<>", "\"\<\\n\>\""}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stringtmp", "=", 
      RowBox[{"ToString", "[", 
       RowBox[{"CForm", "[", 
        RowBox[{
         RowBox[{"dBrndS", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], "//.", "repl"}], "]"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"stringtmp", "=", 
      RowBox[{"\"\<dBrnS[\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"ii", "-", "1"}], "]"}], "<>", "\"\<] = \>\"", "<>", 
       "stringtmp", "<>", "\"\< ;\\n\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"string", "=", 
      RowBox[{"string", "<>", "stringtmp"}]}], ";"}], "\[IndentingNewLine]", 
    ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", "5"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"string", "=", 
   RowBox[{"string", "<>", "\"\<\\n\>\""}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.518334917457026*^9, 3.460476846024438*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<LichbrnAnsatz1.c\>\"", ",", "string", ",", "\"\<Text\>\""}], 
   "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.5183405071532507`*^9, 3.460476297043269*^9}, {
   3.460476901914504*^9, 3.4604769068880167`*^9}, 3.543557464018671*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["RS **6d** Ansatz 2", "Subtitle",
 CellChangeTimes->{{3.408796983010241*^9, 3.408796989128707*^9}, {
   3.415942197687789*^9, 3.415942199707787*^9}, {3.428318203595373*^9, 
   3.4283182110266533`*^9}, {3.4318556687961187`*^9, 3.431855668994246*^9}, {
   3.495174647742872*^9, 3.460515504326817*^9}, {3.503996600043788*^9, 
   3.503996603042028*^9}, {3.54247054384832*^9, 3.542470547950636*^9}, {
   3.543557153971836*^9, 3.543557154018488*^9}, {3.54355724987787*^9, 
   3.5435572520293093`*^9}, 3.5435587743501472`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", "\"\<hmm\>\"", "]"}]], "Input"],

Cell[BoxData["\<\"hmm\"\>"], "Print",
 CellChangeTimes->{
  3.50331095224676*^9, {3.503311334781259*^9, 3.460515672230812*^9}, 
   3.503997004484676*^9, 3.503997193150251*^9, 3.503997258578888*^9, 
   3.504000113069686*^9, 3.517303168099127*^9, 3.5175791605471287`*^9, 
   3.517643108435388*^9, 3.517650907255109*^9, 3.517658628720002*^9, 
   3.517658688981691*^9, 3.517660935926754*^9, 3.51782364066553*^9, 
   3.517823671412335*^9, 3.517824229188287*^9, {3.517825902545436*^9, 
   3.46038825031455*^9}, 3.460392629312698*^9, 3.460392745837037*^9, 
   3.4603966818363*^9, 3.4603979115528307`*^9, {3.460444070657011*^9, 
   3.4603567749901543`*^9}, 3.460366838380539*^9, 3.460372534611771*^9, 
   3.539782997335884*^9, 3.5397851396635227`*^9, 3.539868423697628*^9, 
   3.539873662402772*^9, 3.542469992334106*^9, 3.5435574163990183`*^9, 
   3.5435592437486477`*^9, 3.543559404245193*^9, 3.543562964560061*^9, 
   3.543563908652639*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRSetup2.nb - modified", "Subsubtitle",
 CellChangeTimes->{{3.478330969800351*^9, 3.478330971159855*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Latest", " ", "Version"}], " ", "*)"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"{", 
    RowBox[{
    "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
     "gzz"}], "}"}]}], "\n"}], "\n", 
 RowBox[{"Gd", "=", 
  RowBox[{"DiagonalMatrix", "[", "metric", "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
   "gzz"}], "}"}]], "Output",
 CellChangeTimes->{
  3.503310952791863*^9, {3.503311335284086*^9, 3.460515672380575*^9}, 
   3.503997004769865*^9, 3.503997193436174*^9, 3.5039972588799763`*^9, 
   3.504000113304111*^9, 3.5173031683490477`*^9, 3.5175791607200947`*^9, 
   3.517643108635914*^9, 3.517650907530168*^9, 3.517658628986102*^9, 
   3.5176586892509327`*^9, 3.517660936106361*^9, 3.517823641023736*^9, 
   3.517823671828333*^9, 3.517824229417685*^9, {3.5178259026967983`*^9, 
   3.4603882504778843`*^9}, 3.4603926295278473`*^9, 3.4603927460334044`*^9, 
   3.4603966820091333`*^9, 3.460397911729974*^9, {3.4604440708698473`*^9, 
   3.460356775156495*^9}, 3.4603668385912523`*^9, 3.460372534854219*^9, 
   3.5397829977463493`*^9, 3.539785139995511*^9, 3.539868423973227*^9, 
   3.539873662654141*^9, 3.542469992403655*^9, 3.5435574164483232`*^9, 
   3.5435592438748083`*^9, 3.543559404351172*^9, 3.543562964641814*^9, 
   3.543563908762868*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"gtt", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "grr", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "g\[Theta]\[Theta]", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "g\[Phi]\[Phi]", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "gzz"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.503310952791863*^9, {3.503311335284086*^9, 3.460515672380575*^9}, 
   3.503997004769865*^9, 3.503997193436174*^9, 3.5039972588799763`*^9, 
   3.504000113304111*^9, 3.5173031683490477`*^9, 3.5175791607200947`*^9, 
   3.517643108635914*^9, 3.517650907530168*^9, 3.517658628986102*^9, 
   3.5176586892509327`*^9, 3.517660936106361*^9, 3.517823641023736*^9, 
   3.517823671828333*^9, 3.517824229417685*^9, {3.5178259026967983`*^9, 
   3.4603882504778843`*^9}, 3.4603926295278473`*^9, 3.4603927460334044`*^9, 
   3.4603966820091333`*^9, 3.460397911729974*^9, {3.4604440708698473`*^9, 
   3.460356775156495*^9}, 3.4603668385912523`*^9, 3.460372534854219*^9, 
   3.5397829977463493`*^9, 3.539785139995511*^9, 3.539868423973227*^9, 
   3.539873662654141*^9, 3.542469992403655*^9, 3.5435574164483232`*^9, 
   3.5435592438748083`*^9, 3.543559404351172*^9, 3.543562964641814*^9, 
   3.543563908764702*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Gd", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", "grt"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Gd", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "1"}], "]"}], "]"}], "=", "grt"}]}], "Input"],

Cell[BoxData["grt"], "Output",
 CellChangeTimes->{
  3.50331095292629*^9, {3.503311335372411*^9, 3.460515672510242*^9}, 
   3.503997004841145*^9, 3.503997193508582*^9, 3.5039972589761143`*^9, 
   3.504000113401451*^9, 3.5173031684297*^9, 3.517579160789398*^9, 
   3.517643108676997*^9, 3.517650907619927*^9, 3.517658629174996*^9, 
   3.517658689322502*^9, 3.517660936163856*^9, 3.5178236411046333`*^9, 
   3.517823671928771*^9, 3.5178242294717817`*^9, {3.51782590275142*^9, 
   3.460388250572813*^9}, 3.460392629592249*^9, 3.460392746087512*^9, 
   3.460396682069415*^9, 3.460397911774363*^9, {3.460444070974021*^9, 
   3.460356775229074*^9}, 3.460366838683338*^9, 3.4603725349177094`*^9, 
   3.539782997876357*^9, 3.539785140057931*^9, 3.53986842425675*^9, 
   3.539873662696342*^9, 3.542469992655013*^9, 3.543557416486944*^9, 
   3.543559244067841*^9, 3.5435594045473213`*^9, 3.543562964679289*^9, 
   3.543563908805059*^9}],

Cell[BoxData["grt"], "Output",
 CellChangeTimes->{
  3.50331095292629*^9, {3.503311335372411*^9, 3.460515672510242*^9}, 
   3.503997004841145*^9, 3.503997193508582*^9, 3.5039972589761143`*^9, 
   3.504000113401451*^9, 3.5173031684297*^9, 3.517579160789398*^9, 
   3.517643108676997*^9, 3.517650907619927*^9, 3.517658629174996*^9, 
   3.517658689322502*^9, 3.517660936163856*^9, 3.5178236411046333`*^9, 
   3.517823671928771*^9, 3.5178242294717817`*^9, {3.51782590275142*^9, 
   3.460388250572813*^9}, 3.460392629592249*^9, 3.460392746087512*^9, 
   3.460396682069415*^9, 3.460397911774363*^9, {3.460444070974021*^9, 
   3.460356775229074*^9}, 3.460366838683338*^9, 3.4603725349177094`*^9, 
   3.539782997876357*^9, 3.539785140057931*^9, 3.53986842425675*^9, 
   3.539873662696342*^9, 3.542469992655013*^9, 3.543557416486944*^9, 
   3.543559244067841*^9, 3.5435594045473213`*^9, 3.543562964679289*^9, 
   3.543563908806737*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"BuildMetric", ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Gu", "=", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{"Inverse", "[", "Gd", "]"}], "]"}]}], ";", 
    RowBox[{"G", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u", ",", "d"}], "}"}], ",", 
       RowBox[{"IdentityMatrix", "[", "Nind", "]"}]}], "}"}]}], ";"}], 
   ")"}]}]], "Input"],

Cell[BoxData["BuildMetric"], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
    "}"}]}], "\n"}], "\n", 
 RowBox[{"Nind", "=", 
  RowBox[{"Length", "[", "ind", "]"}]}]}], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.5033109583532267`*^9, {3.503311335710185*^9, 3.460515672801284*^9}, 
   3.5039970055234003`*^9, 3.503997193704561*^9, 3.503997259177459*^9, 
   3.504000113555479*^9, 3.5173031727440968`*^9, 3.517579161233733*^9, 
   3.517643120632904*^9, 3.517650908068326*^9, 3.5176586295419607`*^9, 
   3.517658689483971*^9, 3.517660936374831*^9, {3.517823645931738*^9, 
   3.5178236721550293`*^9}, 3.5178242296158333`*^9, {3.517825902915317*^9, 
   3.460388251693995*^9}, 3.460392630077626*^9, 3.460392746249144*^9, 
   3.4603966823796663`*^9, 3.4603979119319277`*^9, {3.460444071270954*^9, 
   3.46035677625375*^9}, 3.460366838836698*^9, 3.4603725351755877`*^9, 
   3.539782998253436*^9, 3.539785140231594*^9, 3.539868424542329*^9, 
   3.539873662802165*^9, 3.542469993074065*^9, 3.54355741742808*^9, 
   3.543559244199732*^9, 3.543559404695554*^9, 3.543562965109687*^9, 
   3.5435639092358637`*^9}],

Cell[BoxData["5"], "Output",
 CellChangeTimes->{
  3.5033109583532267`*^9, {3.503311335710185*^9, 3.460515672801284*^9}, 
   3.5039970055234003`*^9, 3.503997193704561*^9, 3.503997259177459*^9, 
   3.504000113555479*^9, 3.5173031727440968`*^9, 3.517579161233733*^9, 
   3.517643120632904*^9, 3.517650908068326*^9, 3.5176586295419607`*^9, 
   3.517658689483971*^9, 3.517660936374831*^9, {3.517823645931738*^9, 
   3.5178236721550293`*^9}, 3.5178242296158333`*^9, {3.517825902915317*^9, 
   3.460388251693995*^9}, 3.460392630077626*^9, 3.460392746249144*^9, 
   3.4603966823796663`*^9, 3.4603979119319277`*^9, {3.460444071270954*^9, 
   3.46035677625375*^9}, 3.460366838836698*^9, 3.4603725351755877`*^9, 
   3.539782998253436*^9, 3.539785140231594*^9, 3.539868424542329*^9, 
   3.539873662802165*^9, 3.542469993074065*^9, 3.54355741742808*^9, 
   3.543559244199732*^9, 3.543559404695554*^9, 3.543562965109687*^9, 
   3.5435639092375*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"getind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "i1", "]"}], ",", "i1", ",", 
      RowBox[{
       RowBox[{"Position", "[", 
        RowBox[{"ind", ",", "i1"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"lstind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"lsttmp2", "=", 
      RowBox[{"{", "}"}]}], ";", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"AppendTo", "[", 
        RowBox[{"lsttmp2", ",", 
         RowBox[{"getind", "[", 
          RowBox[{"i1", "[", 
           RowBox[{"[", 
            RowBox[{"lsttmp1", ",", "1"}], "]"}], "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"lsttmp1", ",", "1", ",", 
         RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
     "lsttmp2"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"up", "[", 
   RowBox[{"i1_", ",", "i2_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"lsttmp2", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"AppendTo", "[", 
       RowBox[{"lsttmp2", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"i1", "[", 
            RowBox[{"[", 
             RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "=!=", 
           RowBox[{"i2", "[", 
            RowBox[{"[", "lsttmp1", "]"}], "]"}]}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"i1", "[", 
              RowBox[{"[", 
               RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "===", "d"}], ",",
             "d", ",", "u"}], "]"}], ",", "0"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"lsttmp1", ",", "1", ",", 
        RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
    "lsttmp2"}], ")"}]}]}], "Input",
 Editable->False],

Cell[BoxData[""], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"t1_", ",", "dim_", ",", "indpos_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"MTtmp1", "=", "0"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Length", "[", "indpos", "]"}], "=!=", "dim"}], ",", 
      RowBox[{"Print", "[", "\"\<Error in index position\>\"", "]"}]}], "]"}],
     ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"MTtmp1", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"MTtmp1", ",", 
         RowBox[{"{", 
          RowBox[{"MTtmp3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"MTtmp2", ",", "1", ",", "dim"}], "}"}]}], "]"}], ";", 
    RowBox[{"t1", "=", 
     RowBox[{"{", 
      RowBox[{"indpos", ",", "MTtmp1"}], "}"}]}]}], ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ST", "[", 
    RowBox[{"t1_", ",", "tind_", ",", "val_"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"STtmp1", "=", "t1"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"up", "[", 
         RowBox[{"tind", ",", 
          RowBox[{"t1", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "=!=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"Length", "[", "tind", "]"}], "}"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Print", "[", "\"\<Error in Index Assignment!!\>\"", "]"}], 
        ";"}]}], "]"}], ";", 
     RowBox[{
      RowBox[{"STtmp1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "=", 
      RowBox[{"ReplacePart", "[", 
       RowBox[{
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", "val", ",", 
        RowBox[{"lstind", "[", "tind", "]"}]}], "]"}]}], ";", "STtmp1"}], 
    ")"}]}], "\n"}]], "Input",
 Editable->False],

Cell["\<\


Edited the expression below as 7.0 seems to complain about Sum[x] whereas 6.0 \
would just return x (ie. if there is no sum index!)

\
\>", "Text",
 CellChangeTimes->{{3.465736646430695*^9, 3.4657366879261303`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GT", "[", 
   RowBox[{"t1_", ",", "tind_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"GTtmp2", "=", 
     RowBox[{"up", "[", 
      RowBox[{"tind", ",", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
    RowBox[{"GTtmp3", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp4", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp5", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp6", "=", "t1"}], ";", "\n", "\t\t", 
    RowBox[{"Do", "[", "\n", "\t\t\t", 
     RowBox[{
      RowBox[{
       RowBox[{"Switch", "[", 
        RowBox[{
         RowBox[{"GTtmp2", "[", 
          RowBox[{"[", "GTtmp1", "]"}], "]"}], ",", "\n", "\t\t\t\t", "0", 
         ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}]}]}],
            ";"}], ")"}], ",", "\n", "\t\t\t\t", "u", ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gu[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}]}], ")"}], ",", "\n", "\t\t\t\t", "d", ",",
          "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gd[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}], ";"}], ")"}]}], "]"}], ";"}], "\n", 
      "\t\t\t", ",", 
      RowBox[{"{", 
       RowBox[{"GTtmp1", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"t1", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"GTtmp4", "===", "\"\<\>\""}], "&&", 
       RowBox[{"GTtmp5", "===", "\"\<\>\""}]}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{"\"\<GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\""}], 
       "]"}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{
       "\"\<Sum[GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\"", "<>", 
        "GTtmp4", "<>", "GTtmp5", "<>", "\"\<]\>\""}], "]"}]}], "]"}]}], 
   ")"}]}]], "Input",
 Editable->False,
 CellChangeTimes->{{3.465736640865263*^9, 3.4657366432796392`*^9}, {
  3.465736699767317*^9, 3.4657367470041943`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Trace, Outer Product and Covariant Derivative! - GREinstein.nb\
\>", "Subsubtitle",
 Editable->False],

Cell["\<\
Syntax:   trT[tensor,{{1,4},{2,3}}]   -  ie. contract 1 and 4 plus 2 and 3 \
positions\
\>", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"trT", "[", 
   RowBox[{"t1_", ",", "lst_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "tracetmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"dimt1", "===", "2"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tracetmp", "=", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"GT", "[", 
           RowBox[{"tmpt1", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"s1", ",", "d"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"s1", ",", "u"}], "}"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"s1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ";"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"MT", "[", 
        RowBox[{"tracetmp", ",", 
         RowBox[{"dimt1", "-", 
          RowBox[{"2", 
           RowBox[{"Length", "[", "lst", "]"}]}]}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{"d", ",", 
           RowBox[{"{", 
            RowBox[{"ii", ",", "1", ",", 
             RowBox[{"dimt1", "-", 
              RowBox[{"2", 
               RowBox[{"Length", "[", "lst", "]"}]}]}]}], "}"}]}], "]"}]}], 
        "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"{", "}"}], "===", 
             RowBox[{"Position", "[", 
              RowBox[{"lst", ",", "indno"}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"tmpstring1", "=", 
              RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,d},\>\""}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"tmpstring3", "=", 
              RowBox[{"tmpstring3", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,1,Nind},\>\""}]}], ";"}]}], "\[IndentingNewLine]", "]"}],
           ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}],
           ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\n", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"tmpstring4", "=", 
           RowBox[{"tmpstring4", "<>", "\"\<{s\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", 
            "\"\<,1,Nind},\>\""}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "1"}], "]"}], "]"}], "]"}]}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "2"}], "]"}], "]"}], "]"}], "<>", 
               "\"\<,d}\>\""}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,u}\>\""}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", 
           RowBox[{"Length", "[", "lst", "]"}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpeval", "=", 
        RowBox[{"\"\<Do[tracetmp=ST[tracetmp,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring1", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},Sum[GT[tmpt1,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring2", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring3", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "tracetmp"}], 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell["Syntax:   outerT[tensor1,tensor2] ", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"outerT", "[", 
   RowBox[{"t1_", ",", "t2_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    RowBox[{"dimt2", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t2", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", 
    RowBox[{"tmpt2", "=", "t2"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "outertmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"outertmp", ",", 
      RowBox[{"dimt1", "+", "dimt2"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{"d", ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"dimt1", "+", "dimt2"}]}], "}"}]}], "]"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring1", "=", 
        RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring2", "=", 
        RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", "\n", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring3", "=", 
        RowBox[{"tmpstring3", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", 
        RowBox[{"tmpstring4", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt2"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpeval", "=", 
     RowBox[{"\"\<Do[outertmp=ST[outertmp,{\>\"", "<>", "tmpstring1", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},GT[tmpt1,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring1", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]GT[tmpt2,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]],\>\"", "<>", "tmpstring2",
       "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring4", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "outertmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"scalarDT", "[", "t1_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"covDTtmp", ",", "1", ",", 
      RowBox[{"{", "d", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
    "tmpeval", "=", 
     "\"\<Do[covDTtmp=ST[covDTtmp,{{i1,d}},D[tmpt1,ind[[i1]]]],{i1,1,Nind}]\>\
\""}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "covDTtmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"covDT", "[", "t1_", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dimt1", "=", 
      RowBox[{"Length", "[", 
       RowBox[{"Dimensions", "[", 
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"MT", "[", 
      RowBox[{"covDTtmp", ",", 
       RowBox[{"dimt1", "+", "1"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{"d", ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", 
           RowBox[{"dimt1", "+", "1"}]}], "}"}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Build", " ", "expression"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring1", "=", 
         RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
        ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring2", "=", 
         RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", 
          "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring4", "=", 
         RowBox[{"\"\<-Sum[GT[tmpt1,{\>\"", "<>", 
          RowBox[{"StringDrop", "[", 
           RowBox[{"tmpstring1", ",", 
            RowBox[{"-", "1"}]}], "]"}], "<>", 
          "\"\<}]GT[\[CapitalGamma],{{REPL,d},{s1,d},{s2,u}}],{s2,1,Nind}]\>\"\
"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}], "\[Rule]", " ", 
            "\"\<s2\>\""}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"\"\<REPL\>\"", "\[Rule]", 
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring3", "=", 
         RowBox[{"tmpstring3", "<>", "tmpstring4"}]}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpeval", "=", 
      RowBox[{
      "\"\<Do[covDTtmp=ST[covDTtmp,{\>\"", "<>", "tmpstring1", "<>", 
       "\"\<{s1,d}},D[GT[tmpt1,{\>\"", "<>", 
       RowBox[{"StringDrop", "[", 
        RowBox[{"tmpstring1", ",", 
         RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],ind[[s1]]]\>\"", "<>", 
       "tmpstring3", "<>", "\"\<],\>\"", "<>", "tmpstring2", "<>", 
       "\"\<{s1,1,Nind}]\>\""}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "covDTtmp"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 Editable->False],

Cell[BoxData["."], "Input",
 CellChangeTimes->{3.399009138941909*^9},
 EmphasizeSyntaxErrors->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Buildmetric", "Subsubtitle"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
  "Print", "[", 
   "\"\<\\n\\n   \[CapitalDelta][r_,a_]=(\!\(\*FractionBox[\(\(\\\ \)\(1\)\), \
\(\((1 - a^2)\) + rh\\\ \((1 - r^2)\)^2\)]\))^2\\n   f[r_]  =(1-r^2)\\n   \
g[a_]   =2-a^2\\n\\n\\n\\n\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.4603926036977377`*^9, 3.460392609494193*^9}, {
   3.4603964671280737`*^9, 3.460396474067587*^9}, {3.460396608649122*^9, 
   3.4603966089839687`*^9}, 3.5435573776732607`*^9, {3.543557822534987*^9, 
   3.543557822878004*^9}, {3.5435590064393377`*^9, 3.5435590094656467`*^9}}],

Cell[BoxData["\<\"\\n\\n   \
\[CapitalDelta][r_,a_]=(\\!\\(\\*FractionBox[\\(\\(\\\\ \\)\\(1\\)\\), \
\\(\\((1 - a^2)\\) + rh\\\\ \\((1 - r^2)\\)^2\\)]\\))^2\\n   f[r_]  \
=(1-r^2)\\n   g[a_]   =2-a^2\\n\\n\\n\\n\"\>"], "Print",
 CellChangeTimes->{{3.460392614803647*^9, 3.460392630773752*^9}, 
   3.4603927469544163`*^9, {3.4603965912356453`*^9, 3.460396610516452*^9}, 
   3.460396683089012*^9, 3.460397912493801*^9, {3.460444072054455*^9, 
   3.460356776865254*^9}, 3.460366839549692*^9, 3.4603725359239388`*^9, 
   3.539782999025613*^9, 3.539785140647101*^9, 3.539868426792572*^9, 
   3.539873663653604*^9, 3.5424699937927732`*^9, 3.5435573790963993`*^9, 
   3.5435574186869783`*^9, 3.543558277421892*^9, 3.543559244672468*^9, 
   3.5435594051838093`*^9, 3.543562965647613*^9, 3.543563909727687*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Gd", "=", 
   RowBox[{
    RowBox[{"\[CapitalDelta]", "[", 
     RowBox[{"r", ",", "a"}], "]"}], 
    RowBox[{"(", GridBox[{
       {
        RowBox[{
         RowBox[{"r", "^", "2"}], 
         RowBox[{
          RowBox[{"f", "[", "r", "]"}], "^", "2"}], 
         RowBox[{"j", "[", "r", "]"}], 
         RowBox[{"Exp", "[", 
          RowBox[{"T", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], "]"}]}], "0", "0", "0", 
        "0", "0"},
       {"0", 
        RowBox[{
         FractionBox["4", 
          RowBox[{
           RowBox[{
            RowBox[{"f", "[", "r", "]"}], "^", "2"}], 
           RowBox[{"j", "[", "r", "]"}]}]], 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"T", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
           RowBox[{
            RowBox[{"r", "^", "2"}], 
            RowBox[{"A", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], "]"}]}], 
        RowBox[{"a", " ", "r", " ", 
         FractionBox["1", 
          RowBox[{"f", "[", "r", "]"}]], 
         RowBox[{"F", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "0", "0", "0"},
       {"0", 
        RowBox[{"a", " ", "r", " ", 
         FractionBox["1", 
          RowBox[{"f", "[", "r", "]"}]], 
         RowBox[{"F", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], 
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
           RowBox[{
            RowBox[{"a", "^", "2"}], " ", 
            RowBox[{"B", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], "]"}], 
         FractionBox["4", 
          RowBox[{"g", "[", "a", "]"}]]}], "0", "0", "0"},
       {"0", "0", "0", 
        FractionBox[
         RowBox[{
          RowBox[{"Exp", "[", 
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "]"}], 
          RowBox[{"g", "[", "a", "]"}], 
          RowBox[{"a", "^", "2"}]}], 
         RowBox[{"1", "-", 
          RowBox[{"\[Theta]1", "^", "2"}]}]], "0", "0"},
       {"0", "0", "0", "0", 
        RowBox[{" ", 
         RowBox[{
          RowBox[{"Exp", "[", 
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "]"}], 
          RowBox[{"g", "[", "a", "]"}], 
          RowBox[{"a", "^", "2"}], 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"\[Theta]1", "^", "2"}]}], ")"}]}]}], "0"},
       {"0", "0", "0", "0", "0", 
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{"S", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], "]"}], 
         RowBox[{"g", "[", "a", "]"}], 
         RowBox[{"a", "^", "2"}], 
         RowBox[{"\[Theta]1", "^", "2"}]}]}
      }], ")"}]}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{
    "t", ",", "r", ",", "a", ",", "\[Theta]1", ",", "\[Theta]2", ",", 
     "\[Theta]3"}], "}"}]}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"Nind", "=", 
   RowBox[{"Length", "[", "ind", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"BuildMetric", ";"}]}], "Input",
 CellChangeTimes->{{3.408796998476103*^9, 3.408797030516582*^9}, {
   3.408799071597343*^9, 3.408799082644943*^9}, {3.408949739095245*^9, 
   3.408949739644734*^9}, {3.408949841695282*^9, 3.40894984293303*^9}, {
   3.415862083663703*^9, 3.4158620851642113`*^9}, {3.415862334623486*^9, 
   3.415862336021243*^9}, {3.415862388498528*^9, 3.4158623965197372`*^9}, {
   3.4158641082437763`*^9, 3.415864116357332*^9}, {3.415865034672494*^9, 
   3.415865047473855*^9}, {3.415943026431671*^9, 3.415943056090918*^9}, {
   3.42453089354659*^9, 3.424530981705195*^9}, {3.4262330694486513`*^9, 
   3.426233078224708*^9}, {3.42831552177035*^9, 3.428315531925826*^9}, {
   3.482669504390863*^9, 3.482669559589313*^9}, {3.482669593648382*^9, 
   3.4826696108221407`*^9}, {3.4826696421684*^9, 3.460306349771068*^9}, {
   3.460306681872867*^9, 3.4603066892293873`*^9}, {3.460306743915044*^9, 
   3.460306776656151*^9}, {3.4603068906726713`*^9, 3.4603069154556093`*^9}, 
   3.4606109474491568`*^9, {3.5039972414730186`*^9, 3.503997244123049*^9}, {
   3.5172982618161573`*^9, 3.517298294501769*^9}, {3.517302332920382*^9, 
   3.517302353678054*^9}, {3.51730241996021*^9, 3.517302425934087*^9}, {
   3.517302556663072*^9, 3.5173025584548187`*^9}, 3.517579091871194*^9, {
   3.517642973774815*^9, 3.517642975072443*^9}, 3.517658611602713*^9, {
   3.517660901410638*^9, 3.460392650166881*^9}, {3.4603926980532846`*^9, 
   3.460392722992764*^9}, {3.460396656885631*^9, 3.460356665674651*^9}, {
   3.460356724881654*^9, 3.4603567425493803`*^9}, 3.460372510789526*^9, {
   3.54246967191507*^9, 3.542469701786797*^9}, {3.542469881774507*^9, 
   3.5424699266914043`*^9}, {3.543557353434564*^9, 3.5435573569933662`*^9}, {
   3.543558817218278*^9, 3.543558856001135*^9}, {3.543559354714594*^9, 
   3.543559356590616*^9}, {3.543559387432591*^9, 3.543559389477353*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"T", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
      SuperscriptBox["r", "2"], " ", 
      SuperscriptBox[
       RowBox[{"f", "[", "r", "]"}], "2"], " ", 
      RowBox[{"j", "[", "r", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}], ",", "0", ",", "0", ",", "0", ",", 
     "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"A", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{"T", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"f", "[", "r", "]"}], "2"], " ", 
       RowBox[{"j", "[", "r", "]"}]}]], ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"f", "[", "r", "]"}]], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"f", "[", "r", "]"}]], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"B", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{"S", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"g", "[", "a", "]"}]], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"1", "-", 
       SuperscriptBox["\[Theta]1", "2"]}]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"S", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
      RowBox[{"g", "[", "a", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"S", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
      SuperscriptBox["\[Theta]1", "2"], " ", 
      RowBox[{"g", "[", "a", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.503310959549301*^9, {3.503311337489339*^9, 3.460515673680585*^9}, 
   3.503996967770006*^9, 3.503997006524664*^9, 3.503997194550593*^9, 
   3.5039972601206627`*^9, 3.504000114145877*^9, 3.5173031733152313`*^9, 
   3.517579162305614*^9, 3.517643121148817*^9, 3.517650908892145*^9, 
   3.517658630210273*^9, 3.5176586899579687`*^9, 3.517660936798641*^9, {
   3.5178236465697403`*^9, 3.517823673129346*^9}, 3.517824230175544*^9, {
   3.517825903545369*^9, 3.460388252816543*^9}, 3.460392747023707*^9, 
   3.460396683141287*^9, 3.4603979125408783`*^9, {3.460444072147172*^9, 
   3.460356776913579*^9}, 3.46036683960192*^9, 3.460372536508292*^9, 
   3.539782999088622*^9, 3.539785140698571*^9, 3.539868426896636*^9, 
   3.53987366371763*^9, 3.542469993839971*^9, 3.5435574187269382`*^9, 
   3.5435592447201557`*^9, 3.543559405221655*^9, 3.543562965688491*^9, 
   3.5435639098323917`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "t", ",", "r", ",", "a", ",", "\[Theta]1", ",", "\[Theta]2", ",", 
   "\[Theta]3"}], "}"}]], "Output",
 CellChangeTimes->{
  3.503310959549301*^9, {3.503311337489339*^9, 3.460515673680585*^9}, 
   3.503996967770006*^9, 3.503997006524664*^9, 3.503997194550593*^9, 
   3.5039972601206627`*^9, 3.504000114145877*^9, 3.5173031733152313`*^9, 
   3.517579162305614*^9, 3.517643121148817*^9, 3.517650908892145*^9, 
   3.517658630210273*^9, 3.5176586899579687`*^9, 3.517660936798641*^9, {
   3.5178236465697403`*^9, 3.517823673129346*^9}, 3.517824230175544*^9, {
   3.517825903545369*^9, 3.460388252816543*^9}, 3.460392747023707*^9, 
   3.460396683141287*^9, 3.4603979125408783`*^9, {3.460444072147172*^9, 
   3.460356776913579*^9}, 3.46036683960192*^9, 3.460372536508292*^9, 
   3.539782999088622*^9, 3.539785140698571*^9, 3.539868426896636*^9, 
   3.53987366371763*^9, 3.542469993839971*^9, 3.5435574187269382`*^9, 
   3.5435592447201557`*^9, 3.543559405221655*^9, 3.543562965688491*^9, 
   3.543563909835726*^9}],

Cell[BoxData["6"], "Output",
 CellChangeTimes->{
  3.503310959549301*^9, {3.503311337489339*^9, 3.460515673680585*^9}, 
   3.503996967770006*^9, 3.503997006524664*^9, 3.503997194550593*^9, 
   3.5039972601206627`*^9, 3.504000114145877*^9, 3.5173031733152313`*^9, 
   3.517579162305614*^9, 3.517643121148817*^9, 3.517650908892145*^9, 
   3.517658630210273*^9, 3.5176586899579687`*^9, 3.517660936798641*^9, {
   3.5178236465697403`*^9, 3.517823673129346*^9}, 3.517824230175544*^9, {
   3.517825903545369*^9, 3.460388252816543*^9}, 3.460392747023707*^9, 
   3.460396683141287*^9, 3.4603979125408783`*^9, {3.460444072147172*^9, 
   3.460356776913579*^9}, 3.46036683960192*^9, 3.460372536508292*^9, 
   3.539782999088622*^9, 3.539785140698571*^9, 3.539868426896636*^9, 
   3.53987366371763*^9, 3.542469993839971*^9, 3.5435574187269382`*^9, 
   3.5435592447201557`*^9, 3.543559405221655*^9, 3.543562965688491*^9, 
   3.543563909837517*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Gd"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"T", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
      SuperscriptBox["r", "2"], " ", 
      SuperscriptBox[
       RowBox[{"f", "[", "r", "]"}], "2"], " ", 
      RowBox[{"j", "[", "r", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}], ",", "0", ",", "0", ",", "0", ",", 
     "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"A", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{"T", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"f", "[", "r", "]"}], "2"], " ", 
       RowBox[{"j", "[", "r", "]"}]}]], ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"f", "[", "r", "]"}]], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"f", "[", "r", "]"}]], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"B", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{"S", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"g", "[", "a", "]"}]], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"1", "-", 
       SuperscriptBox["\[Theta]1", "2"]}]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"S", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
      RowBox[{"g", "[", "a", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"S", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
      SuperscriptBox["\[Theta]1", "2"], " ", 
      RowBox[{"g", "[", "a", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.503310960896533*^9, {3.503311337815158*^9, 3.460515673971971*^9}, 
   3.5039970068865147`*^9, 3.503997194708459*^9, 3.5039972603113403`*^9, 
   3.504000114400865*^9, 3.517303175045021*^9, 3.517579163377042*^9, 
   3.517643122943182*^9, 3.517650911147537*^9, 3.517658631401002*^9, 
   3.5176586910877733`*^9, 3.517660938714964*^9, {3.5178236483503*^9, 
   3.517823675003542*^9}, 3.517824232021847*^9, {3.517825905567346*^9, 
   3.460388255822893*^9}, 3.460392749914061*^9, 3.460396684871089*^9, 
   3.460397914257712*^9, {3.460444073869268*^9, 3.4603567785893793`*^9}, 
   3.4603668412999907`*^9, 3.4603725377778482`*^9, 3.53978299993473*^9, 
   3.539785141532104*^9, 3.539868428003755*^9, 3.539873664479189*^9, 
   3.542469994931801*^9, 3.54355741966752*^9, 3.54355924580442*^9, 
   3.543559406310856*^9, 3.543562966758774*^9, 3.543563910790313*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Gu"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        RowBox[{"T", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], 
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox[
        RowBox[{"f", "[", "r", "]"}], "2"], " ", 
       RowBox[{"j", "[", "r", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]], ",", "0", ",", "0", ",", "0", ",", 
     "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"f", "[", "r", "]"}], "2"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "2"]}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], " ", 
             RowBox[{"B", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
            RowBox[{"S", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"F", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
          RowBox[{"g", "[", "a", "]"}]}], "+", 
         FractionBox[
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"A", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{"T", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
          RowBox[{"j", "[", "r", "]"}]]}], ")"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]], ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"f", "[", "r", "]"}], " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"j", "[", "r", "]"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"B", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{"S", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"F", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
          RowBox[{"g", "[", "a", "]"}], " ", 
          RowBox[{"j", "[", "r", "]"}]}]}], ")"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]], ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"f", "[", "r", "]"}], " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"j", "[", "r", "]"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"B", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{"S", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"F", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
          RowBox[{"g", "[", "a", "]"}], " ", 
          RowBox[{"j", "[", "r", "]"}]}]}], ")"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]], ",", 
     FractionBox["1", 
      RowBox[{
       FractionBox[
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"B", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
         RowBox[{"\[CapitalDelta]", "[", 
          RowBox[{"r", ",", "a"}], "]"}]}], 
        RowBox[{"g", "[", "a", "]"}]], "-", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["r", "2"]}], " ", 
           RowBox[{"A", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
          RowBox[{"T", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
        SuperscriptBox["r", "2"], " ", 
        SuperscriptBox[
         RowBox[{"F", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
        RowBox[{"j", "[", "r", "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}]}]], ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", 
          RowBox[{"S", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[Theta]1", "2"]}], ")"}]}], 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"g", "[", "a", "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}]]}], ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", 
         RowBox[{"S", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
        RowBox[{"g", "[", "a", "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}]]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[Theta]1", "2"], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.503310961019191*^9, {3.503311337909677*^9, 3.4605156740447407`*^9}, 
   3.503997006988311*^9, 3.503997194814143*^9, 3.503997260416914*^9, 
   3.504000114475375*^9, 3.517303175100889*^9, 3.517579163432994*^9, 
   3.517643123023747*^9, 3.517650911238832*^9, 3.51765863146119*^9, 
   3.517658691190091*^9, 3.517660938769685*^9, {3.5178236484356413`*^9, 
   3.5178236750627403`*^9}, 3.517824232072446*^9, {3.517825905652813*^9, 
   3.4603882558830748`*^9}, 3.460392749990233*^9, 3.460396684946187*^9, 
   3.4603979143251343`*^9, {3.460444073966957*^9, 3.460356778642264*^9}, 
   3.460366841369574*^9, 3.46037253785017*^9, 3.539783000016053*^9, 
   3.539785141583846*^9, 3.5398684281973343`*^9, 3.539873664512268*^9, 
   3.5424699949810038`*^9, 3.543557419750058*^9, 3.543559245860187*^9, 
   3.543559406378563*^9, 3.543562966841469*^9, 3.543563910849177*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"detg", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Det", "[", "Gd", "]"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "6"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"3", " ", 
     RowBox[{"S", "[", 
      RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
    RowBox[{"T", "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
  SuperscriptBox["r", "2"], " ", 
  SuperscriptBox["\[Theta]1", "2"], " ", 
  SuperscriptBox[
   RowBox[{"g", "[", "a", "]"}], "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"16", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"A", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"B", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
       RowBox[{"S", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
       RowBox[{"T", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["r", "2"], " ", 
     SuperscriptBox[
      RowBox[{"F", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
     RowBox[{"g", "[", "a", "]"}], " ", 
     RowBox[{"j", "[", "r", "]"}]}]}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{"\[CapitalDelta]", "[", 
    RowBox[{"r", ",", "a"}], "]"}], "6"]}]], "Output",
 CellChangeTimes->{
  3.503310961169602*^9, {3.50331133798626*^9, 3.460515674108046*^9}, 
   3.503997007085783*^9, 3.5039971949056797`*^9, 3.503997260515153*^9, 
   3.504000114556445*^9, 3.517303175159586*^9, 3.517579163516987*^9, 
   3.5176431231240063`*^9, 3.517650911347453*^9, 3.517658631527398*^9, 
   3.51765869125694*^9, 3.517660938861404*^9, {3.517823648499422*^9, 
   3.51782367514461*^9}, 3.5178242321377687`*^9, {3.517825905766419*^9, 
   3.460388255960024*^9}, 3.460392750055771*^9, 3.460396684996212*^9, 
   3.460397914370763*^9, {3.460444074039672*^9, 3.460356778687825*^9}, 
   3.460366841502103*^9, 3.460372537983058*^9, 3.53978300013131*^9, 
   3.539785141639271*^9, 3.539868428328937*^9, 3.539873664562046*^9, 
   3.542469995075811*^9, 3.543557419830435*^9, 3.543559245947221*^9, 
   3.543559406453742*^9, 3.54356296691649*^9, 3.543563910897275*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRrun2.nb", "Subsubtitle"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\[CapitalGamma]", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"\[CapitalGamma]", ",", "3", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "u"}], "}"}]}], "]"}], ";"}], "\n"}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R4", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R4", ",", "4", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "d", ",", "u"}], "}"}]}], "]"}], 
  ";"}], "\n"}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "G2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"G2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"\[CapitalGamma]", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"\[CapitalGamma]", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], 
         RowBox[{"GT", "[", 
          RowBox[{"G", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
            "}"}]}], "]"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "+", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "ss1", "]"}], "]"}]}], "]"}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalGamma]", "=", 
   RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.426232729469757*^9, 3.426232735540435*^9}}],

Cell[BoxData[
 RowBox[{"Do", "[", "\n", "\t", 
  RowBox[{
   RowBox[{"R4", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R4", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      "\n", "\t", "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "+", "\n", "\t\t\t", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}]}], "\n", 
     "\t\t", "\n", "\t\t", "]"}]}], "\n", "\t\t", ",", "\n", "\t", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i4", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R4", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"R2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"GT", "[", 
         RowBox[{"R4", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}],
          "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "\n", 
     "\t\t", "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"GT", "[", 
      RowBox[{"R2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"G2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"G2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"GT", "[", 
        RowBox[{"R2", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
        "]"}], "-", 
       RowBox[{
        FractionBox["1", "2"], 
        RowBox[{"GT", "[", 
         RowBox[{"G", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
         "]"}], "Ricci"}]}]}], "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "G2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "Ricci", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"]
}, Closed]],

Cell[CellGroupData[{

Cell["Einstein equations", "Subsubtitle"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalDelta]", "[", 
    RowBox[{"r_", ",", "a_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     FractionBox[
      RowBox[{" ", "1"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"a", "^", "2"}]}], ")"}], "+", 
       RowBox[{"rh", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"r", "^", "2"}]}], ")"}]}]}]], ")"}], "^", "2"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "r_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"r", "^", "2"}]}], ")"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g", "[", "a_", "]"}], ":=", 
  RowBox[{"2", "-", 
   RowBox[{"a", "^", "2"}]}]}]}], "Input",
 CellChangeTimes->{{3.503997037073781*^9, 3.503997076077972*^9}, {
   3.503997256891058*^9, 3.4603927524745617`*^9}, {3.460396639861096*^9, 
   3.4603966466740303`*^9}, {3.460397369545499*^9, 3.460397369641325*^9}, 
   3.542471512037649*^9, {3.543559216532257*^9, 3.543559218804895*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{"\[CapitalDelta]", "[", 
    RowBox[{"r", ",", "a"}], "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.495182286304566*^9, 3.495182316261655*^9}, {
  3.503997272569343*^9, 3.4603966815174828`*^9}}],

Cell["Power(-1 + Power(a,2) + (-1 + Power(r,2))*rh,-2)", "Output",
 CellChangeTimes->{
  3.503310996102426*^9, 3.5033113741197977`*^9, 3.503997228128545*^9, {
   3.503997279270112*^9, 3.5039972907004004`*^9}, 3.517303241353507*^9, 
   3.517579191292143*^9, 3.517643158630046*^9, 3.517650952101787*^9, 
   3.517658661413351*^9, 3.517660980149918*^9, 3.517824268227845*^9, {
   3.51782594256693*^9, 3.460388309853869*^9}, 3.460392792367641*^9, 
   3.4603967346191587`*^9, 3.460396770208337*^9, 3.460397373597575*^9, 
   3.4603979637516327`*^9, {3.460444124578642*^9, 3.460356825685725*^9}, 
   3.460366890206985*^9, 3.460372585956767*^9, 3.53978301581916*^9, 
   3.542470021281004*^9, 3.5424715140103807`*^9, 3.542475296593664*^9, 
   3.543557440496995*^9, 3.543559269532526*^9, 3.543559430328608*^9, 
   3.5435629904594717`*^9, 3.54356393386189*^9, 3.543575139872683*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"\[CapitalDelta]", "[", 
      RowBox[{"r", ",", "a"}], "]"}], ",", "r"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{3.4603966934425793`*^9}],

Cell["(-4*r*rh)/Power(-1 + Power(a,2) + (-1 + Power(r,2))*rh,3)", "Output",
 CellChangeTimes->{
  3.4603967346894608`*^9, 3.460396771124436*^9, 3.460397374266717*^9, 
   3.4603979638301573`*^9, {3.460444124654269*^9, 3.460356825727166*^9}, 
   3.460366890263295*^9, 3.460372586008257*^9, 3.539783015858795*^9, 
   3.54247002192407*^9, 3.542471514760674*^9, 3.542475297275634*^9, 
   3.543557440533538*^9, 3.5435592695675793`*^9, 3.54355943036462*^9, 
   3.543562990502612*^9, 3.5435639339224997`*^9, 3.543575140578014*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"\[CapitalDelta]", "[", 
      RowBox[{"r", ",", "a"}], "]"}], ",", "a"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.495182324518956*^9, {3.503997277336896*^9, 3.460396687296332*^9}}],

Cell["(-4*a)/Power(-1 + Power(a,2) + (-1 + Power(r,2))*rh,3)", "Output",
 CellChangeTimes->{
  3.503310996611804*^9, 3.5033113742253036`*^9, 3.5039972306695004`*^9, 
   3.5039972912011633`*^9, 3.517303241981659*^9, 3.5175791913426123`*^9, 
   3.5176431586803913`*^9, 3.517650952166638*^9, 3.517658661473048*^9, 
   3.517660980259284*^9, 3.517824268287916*^9, {3.517825942643841*^9, 
   3.4603883098918533`*^9}, 3.460392792453087*^9, 3.460396734793695*^9, 
   3.460396771889118*^9, 3.4603973749808598`*^9, 3.4603979639137297`*^9, {
   3.460444124741806*^9, 3.460356825776784*^9}, 3.4603668903009863`*^9, 
   3.4603725860817738`*^9, 3.539783015967268*^9, 3.542470022525893*^9, 
   3.5424715154933777`*^9, 3.542475297993924*^9, 3.5435574405771637`*^9, 
   3.5435592696029663`*^9, 3.543559430407667*^9, 3.543562990545559*^9, 
   3.5435639339768457`*^9, 3.5435751411741734`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"\[CapitalDelta]", "[", 
      RowBox[{"r", ",", "a"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "2"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{3.460396699482765*^9}],

Cell["\<\
(4*rh*(1 - Power(a,2) + rh + 5*Power(r,2)*rh))/Power(-1 + Power(a,2) + (-1 + \
Power(r,2))*rh,4)\
\>", "Output",
 CellChangeTimes->{
  3.460396734885148*^9, 3.460396772605576*^9, 3.4603973757244453`*^9, 
   3.460397963996324*^9, {3.460444124839486*^9, 3.460356825827559*^9}, 
   3.460366890347027*^9, 3.460372586164962*^9, 3.539783016097213*^9, 
   3.5424700231614532`*^9, 3.542471516254243*^9, 3.5424752986614523`*^9, 
   3.5435574406261663`*^9, 3.543559269650885*^9, 3.543559430448341*^9, 
   3.543562990606011*^9, 3.543563934021467*^9, 3.543575141792557*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"\[CapitalDelta]", "[", 
      RowBox[{"r", ",", "a"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "2"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.4951823290378923`*^9, 3.495182330774173*^9}, {
  3.5039972841977863`*^9, 3.460396689232386*^9}}],

Cell["\<\
(4*(1 + 5*Power(a,2) + rh - Power(r,2)*rh))/Power(-1 + Power(a,2) + (-1 + \
Power(r,2))*rh,4)\
\>", "Output",
 CellChangeTimes->{
  3.503310996775799*^9, 3.503311374369062*^9, 3.503997232218389*^9, 
   3.503997291632564*^9, 3.517303242397684*^9, 3.5175791913918343`*^9, 
   3.517643158747458*^9, 3.517650952233596*^9, 3.517658661557768*^9, 
   3.517660980330935*^9, 3.5178242683641*^9, {3.51782594272474*^9, 
   3.460388309944561*^9}, 3.4603927925495462`*^9, 3.460396734993875*^9, 
   3.460396773237878*^9, 3.4603973763029203`*^9, 3.4603979640791597`*^9, {
   3.46044412492558*^9, 3.460356825877578*^9}, 3.460366890396433*^9, 
   3.460372586248437*^9, 3.539783016309095*^9, 3.542470023777834*^9, 
   3.542471516947101*^9, 3.542475299414824*^9, 3.543557440666037*^9, 
   3.543559269690914*^9, 3.543559430486239*^9, 3.5435629906456213`*^9, 
   3.543563934077783*^9, 3.543575142427227*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}], ",", "r"}], "]"}], ",", "a"}], "]"}], 
   "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.460396706059194*^9, 3.4603967153051167`*^9}}],

Cell["(24*a*r*rh)/Power(-1 + Power(a,2) + (-1 + Power(r,2))*rh,4)", "Output",
 CellChangeTimes->{
  3.4603967739136333`*^9, 3.460397377015764*^9, 3.460397964162476*^9, {
   3.46044412501836*^9, 3.460356825927038*^9}, 3.460366890500286*^9, 
   3.460372586331909*^9, 3.539783016461114*^9, 3.542470024445664*^9, 
   3.542471517664502*^9, 3.542475300280547*^9, 3.543557440700095*^9, 
   3.54355926973425*^9, 3.543559430532082*^9, 3.543562990702317*^9, 
   3.5435639341212063`*^9, 3.543575143044348*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{"f", "[", "r", "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.495182286304566*^9, 3.495182316261655*^9}, {
  3.495182467679225*^9, 3.46039275783316*^9}}],

Cell["1 - Power(r,2)", "Output",
 CellChangeTimes->{
  3.503310996908019*^9, 3.503311374879593*^9, 3.503997233300832*^9, 
   3.503997292083259*^9, 3.517303242881014*^9, 3.5175791914423313`*^9, 
   3.517643158811143*^9, 3.517650952300398*^9, 3.517658661622953*^9, 
   3.517660980408761*^9, 3.51782426844166*^9, {3.5178259428269377`*^9, 
   3.460388310014579*^9}, 3.460392792636108*^9, 3.460396774653295*^9, 
   3.460397964245742*^9, {3.460444125086138*^9, 3.4603568259761963`*^9}, 
   3.460366890633319*^9, 3.460372586414815*^9, 3.539783016531856*^9, 
   3.5424700250801992`*^9, 3.542471518615855*^9, 3.543557440736858*^9, 
   3.54355926979055*^9, 3.543559430587611*^9, 3.543562990746614*^9, 
   3.5435639341773787`*^9, 3.543575143645583*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"f", "'"}], "[", "r", "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.495182472838019*^9, 3.460392760921238*^9}}],

Cell["-2*r", "Output",
 CellChangeTimes->{
  3.503310996965783*^9, 3.5033113749913073`*^9, 3.503997234248814*^9, 
   3.50399729256497*^9, 3.517303243330184*^9, 3.517579191492313*^9, 
   3.517643158880645*^9, 3.517650952366993*^9, 3.517658661688716*^9, 
   3.517660980481185*^9, 3.517824268640936*^9, {3.517825942927206*^9, 
   3.460388310080756*^9}, 3.460392792734129*^9, 3.460396775353087*^9, 
   3.4603979643580303`*^9, {3.4604441251522083`*^9, 3.460356826026689*^9}, 
   3.460366890681685*^9, 3.460372586511404*^9, 3.53978301661082*^9, 
   3.542470025764917*^9, 3.5424715191675663`*^9, 3.5435574407862673`*^9, 
   3.543559269834806*^9, 3.5435594306319437`*^9, 3.5435629908016787`*^9, 
   3.543563934221838*^9, 3.54357514421603*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"f", "''"}], "[", "r", "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.495182483750815*^9, 3.4603927635933533`*^9}}],

Cell["-2", "Output",
 CellChangeTimes->{
  3.503310997024472*^9, 3.503311375066978*^9, 3.503997234849133*^9, 
   3.503997293048607*^9, 3.5173032438293867`*^9, 3.517579191555608*^9, 
   3.517643158947215*^9, 3.517650952433901*^9, 3.517658661907147*^9, 
   3.5176609807702847`*^9, 3.51782426870553*^9, {3.517825943026388*^9, 
   3.460388310147313*^9}, 3.4603927928192453`*^9, 3.4603967760685997`*^9, 
   3.460397964440173*^9, {3.460444125236292*^9, 3.460356826075963*^9}, 
   3.4603668907314177`*^9, 3.4603725865942507`*^9, 3.5397830167746143`*^9, 
   3.542470026452227*^9, 3.542471519720146*^9, 3.543557440834312*^9, 
   3.543559269873208*^9, 3.543559430666624*^9, 3.54356299083568*^9, 
   3.5435639342784443`*^9, 3.543575144832553*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{"g", "[", "a", "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.495182286304566*^9, 3.495182316261655*^9}, {
  3.495182467679225*^9, 3.495182507949469*^9}}],

Cell["2 - Power(a,2)", "Output",
 CellChangeTimes->{
  3.503310997266829*^9, 3.503311375422978*^9, 3.503997236530881*^9, 
   3.503997295412294*^9, 3.517303245944564*^9, 3.517579191925013*^9, 
   3.517643159296781*^9, 3.5176509528998833`*^9, 3.517658662174065*^9, 
   3.517660981145893*^9, 3.517824268963705*^9, {3.517825943568527*^9, 
   3.460388310413842*^9}, 3.4603927929015913`*^9, 3.460396777817959*^9, 
   3.4603979645404453`*^9, {3.460444125301704*^9, 3.460356826126771*^9}, 
   3.460366890777458*^9, 3.46037258667807*^9, 3.539783016794743*^9, 
   3.542470027100696*^9, 3.5424715202239037`*^9, 3.543557440874839*^9, 
   3.543559269917926*^9, 3.54355943070295*^9, 3.543562990881846*^9, 
   3.543563934321892*^9, 3.543575145449684*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"g", "'"}], "[", "a", "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.495182472838019*^9, 3.4951825108854933`*^9}}],

Cell["-2*a", "Output",
 CellChangeTimes->{
  3.503310997314372*^9, 3.5033113754864283`*^9, 3.503997237064632*^9, 
   3.503997295978795*^9, 3.517303246410819*^9, 3.517579191974955*^9, 
   3.517643159348069*^9, 3.517650952966544*^9, 3.517658662238484*^9, 
   3.517660981244028*^9, 3.517824269037717*^9, {3.517825943674107*^9, 
   3.460388310567745*^9}, 3.460392792998417*^9, 3.4603967785324717`*^9, 
   3.4603979647422323`*^9, {3.46044412538582*^9, 3.460356826176135*^9}, 
   3.460366890827784*^9, 3.460372586760797*^9, 3.539783016817659*^9, 
   3.5424700278025227`*^9, 3.5424715207036037`*^9, 3.543557440917399*^9, 
   3.5435592699541407`*^9, 3.5435594307485123`*^9, 3.543562990929577*^9, 
   3.543563934378789*^9, 3.543575146067918*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"g", "''"}], "[", "a", "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.495182483750815*^9, 3.495182512437488*^9}}],

Cell["-2", "Output",
 CellChangeTimes->{
  3.503310997402102*^9, 3.503311375577376*^9, 3.503997237546672*^9, 
   3.5039972964768867`*^9, 3.5173032469105377`*^9, 3.517579192025198*^9, 
   3.517643159398725*^9, 3.517650953033245*^9, 3.5176586623058453`*^9, 
   3.517660981325623*^9, 3.517824269109634*^9, {3.517825943759248*^9, 
   3.4603883106309137`*^9}, 3.460392793085101*^9, 3.460396779199339*^9, 
   3.460397964840487*^9, {3.4604441254687366`*^9, 3.460356826226657*^9}, 
   3.4603668908780823`*^9, 3.460372586844584*^9, 3.539783016861774*^9, 
   3.542470028519656*^9, 3.542471521288033*^9, 3.543557440956662*^9, 
   3.5435592700033712`*^9, 3.5435594307873363`*^9, 3.543562990993388*^9, 
   3.54356393442204*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{
  "\[CapitalDelta]", ",", "f", ",", "g", ",", "T", ",", "A", ",", "B", ",", 
   "S", ",", "F"}], "]"}]], "Input",
 CellChangeTimes->{{3.482669833339856*^9, 3.460307046941224*^9}, {
  3.460392774501875*^9, 3.460392775001577*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalGamma]0", "=", 
   RowBox[{"\[CapitalGamma]", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"T", "\[Rule]", "T0"}], ",", 
      RowBox[{"A", "\[Rule]", "A0"}], ",", 
      RowBox[{"B", "\[Rule]", "B0"}], ",", 
      RowBox[{"F", "\[Rule]", "F0"}], ",", 
      RowBox[{"S", "\[Rule]", "S0"}]}], "}"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4262303165893497`*^9, 3.4262303398602133`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"T0", "[", 
     RowBox[{"l_", ",", "r_", ",", "a_"}], "]"}], ":=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"A0", "[", 
     RowBox[{"l_", ",", "r_", ",", "a_"}], "]"}], ":=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"B0", "[", 
     RowBox[{"l_", ",", "r_", ",", "a_"}], "]"}], ":=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"F0", "[", 
     RowBox[{"l_", ",", "r_", ",", "a_"}], "]"}], ":=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S0", "[", 
    RowBox[{"l_", ",", "r_", ",", "a_"}], "]"}], ":=", "0"}], ";"}]}], "Input",
 CellChangeTimes->{{3.503310951416149*^9, 3.503310951601446*^9}, {
  3.503311020210663*^9, 3.503311029174612*^9}, {3.517303252550393*^9, 
  3.517303255622281*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalGamma]0", "=", 
   RowBox[{"FullSimplify", "[", "\[CapitalGamma]0", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.503312805308928*^9, 3.5033128199192266`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "d\[CapitalGamma]", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"d\[CapitalGamma]", ",", "3", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "u"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.426229921816812*^9, 3.426229934732215*^9}},
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"d\[CapitalGamma]", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"d\[CapitalGamma]", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"GT", "[", 
        RowBox[{"\[CapitalGamma]", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}], 
        "]"}], "-", 
       RowBox[{"GT", "[", 
        RowBox[{"\[CapitalGamma]0", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}], 
        "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4262299354328623`*^9, 3.42622996641691*^9}},
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "H", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"H", ",", "1", ",", 
     RowBox[{"{", "d", "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"H", "=", 
      RowBox[{"ST", "[", 
       RowBox[{"H", ",", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"i1", ",", "d"}], "}"}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"-", " ", 
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"d\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"s1", ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"s1", ",", "u"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"i1", ",", "d"}], "}"}]}], "}"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"s1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}]}], 
       "\[IndentingNewLine]", "]"}]}], ";"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4087970943172693`*^9, 3.408797098931541*^9}, {
   3.408973656013672*^9, 3.408973660142764*^9}, 3.418456476392524*^9, {
   3.426229975319216*^9, 3.426229983437986*^9}, {3.426230701065813*^9, 
   3.426230703285982*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"H", "=", 
  RowBox[{"Simplify", "[", "H", "]"}]}]], "Input",
 CellChangeTimes->{
  3.460397912220345*^9, {3.460397977077539*^9, 3.460397998480888*^9}, {
   3.460398042616012*^9, 3.460398043148725*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "d", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
          RowBox[{"T", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"r", " ", 
           RowBox[{"j", "[", "r", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"8", " ", 
              SuperscriptBox["a", "2"], " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{"S", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                RowBox[{"T", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"A", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], ")"}], " ", 
              SuperscriptBox["r", "2"], " ", 
              SuperscriptBox[
               RowBox[{"F", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
              RowBox[{"g", "[", "a", "]"}], " ", 
              RowBox[{"j", "[", "r", "]"}], " ", 
              RowBox[{"\[CapitalDelta]", "[", 
               RowBox[{"r", ",", "a"}], "]"}], " ", 
              RowBox[{
               SuperscriptBox["f", "\[Prime]",
                MultilineFunction->None], "[", "r", "]"}]}], "+", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              SuperscriptBox["r", "3"], " ", 
              SuperscriptBox[
               RowBox[{"F", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}], "3"], " ", 
              RowBox[{"g", "[", "a", "]"}], " ", 
              RowBox[{"j", "[", "r", "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"3", " ", "a", " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{"T", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
                 RowBox[{"\[CapitalDelta]", "[", 
                  RowBox[{"r", ",", "a"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["g", "\[Prime]",
                   MultilineFunction->None], "[", "a", "]"}]}], "+", 
                RowBox[{
                 RowBox[{"g", "[", "a", "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"6", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
                    RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"a", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]]}]}], ")"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
             "-", 
             RowBox[{"32", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["r", "2"], " ", 
                 RowBox[{"A", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                RowBox[{"S", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                RowBox[{"2", " ", 
                 RowBox[{"T", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}]], " ", 
              RowBox[{"\[CapitalDelta]", "[", 
               RowBox[{"r", ",", "a"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], ")"}], " ", 
                 RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                   MultilineFunction->None], "[", "r", "]"}]}], "+", 
                RowBox[{"a", " ", "r", " ", 
                 RowBox[{"g", "[", "a", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["F", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
             RowBox[{"16", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{"S", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                RowBox[{"T", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", " ", 
              RowBox[{"F", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "a"}], " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                 " ", 
                 RowBox[{"\[CapitalDelta]", "[", 
                  RowBox[{"r", ",", "a"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["g", "\[Prime]",
                   MultilineFunction->None], "[", "a", "]"}]}], "-", 
                RowBox[{
                 RowBox[{"g", "[", "a", "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"a", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                    " ", 
                    RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                    RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
                    RowBox[{"a", " ", 
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                    RowBox[{"a", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                  ")"}]}]}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
           RowBox[{"f", "[", "r", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"16", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["r", "2"], " ", 
                 RowBox[{"A", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                RowBox[{
                 SuperscriptBox["a", "2"], " ", 
                 RowBox[{"B", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                RowBox[{"2", " ", 
                 RowBox[{"S", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                RowBox[{"T", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"A", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], ")"}], " ", 
              "r", " ", 
              RowBox[{"\[CapitalDelta]", "[", 
               RowBox[{"r", ",", "a"}], "]"}], " ", 
              RowBox[{
               SuperscriptBox["j", "\[Prime]",
                MultilineFunction->None], "[", "r", "]"}]}], "+", 
             RowBox[{
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"S", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
              RowBox[{"j", "[", "r", "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"16", " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "5"}], " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                 " ", "r", " ", 
                 RowBox[{
                  SuperscriptBox["\[CapitalDelta]", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                RowBox[{
                 RowBox[{"\[CapitalDelta]", "[", 
                  RowBox[{"r", ",", "a"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"32", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], ")"}], " ", 
                    SuperscriptBox["r", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
                    RowBox[{"g", "[", "a", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["j", "\[Prime]",
                    MultilineFunction->None], "[", "r", "]"}]}], "+", 
                   RowBox[{"16", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                    RowBox[{
                    SuperscriptBox["r", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", "r", " ", 
                    RowBox[{
                    SuperscriptBox["B", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                    RowBox[{"4", " ", "r", " ", 
                    RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                  ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              SuperscriptBox["r", "2"], " ", 
              SuperscriptBox[
               RowBox[{"F", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
              RowBox[{"g", "[", "a", "]"}], " ", 
              SuperscriptBox[
               RowBox[{"j", "[", "r", "]"}], "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "6"}], " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]]}], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}]}], 
                 " ", "r", " ", 
                 RowBox[{
                  SuperscriptBox["\[CapitalDelta]", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"r", ",", "a"}], "]"}]}], "-", 
                RowBox[{
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
                 RowBox[{"\[CapitalDelta]", "[", 
                  RowBox[{"r", ",", "a"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
                   RowBox[{"3", " ", "r", " ", 
                    RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                   RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
               ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"8", " ", "r", " ", 
        RowBox[{"f", "[", "r", "]"}], " ", 
        RowBox[{"j", "[", "r", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"A", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              RowBox[{"B", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{"S", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
             RowBox[{"T", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox[
            RowBox[{"F", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
           RowBox[{"g", "[", "a", "]"}], " ", 
           RowBox[{"j", "[", "r", "]"}]}]}], ")"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
          RowBox[{"T", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "192"}], " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"A", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              RowBox[{"B", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"S", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                RowBox[{"T", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], ")"}]}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               RowBox[{"B", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], ")"}], " ", 
           RowBox[{"\[CapitalDelta]", "[", 
            RowBox[{"r", ",", "a"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["g", "\[Prime]",
             MultilineFunction->None], "[", "a", "]"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox[
            RowBox[{"F", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
           SuperscriptBox[
            RowBox[{"g", "[", "a", "]"}], "2"], " ", 
           RowBox[{"j", "[", "r", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "-", 
                   RowBox[{"6", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]]}], "+", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                 " ", 
                 RowBox[{
                  SuperscriptBox["\[CapitalDelta]", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                RowBox[{"a", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]], "+", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]]}]}], ")"}], " ",
                  "r", " ", 
                 RowBox[{"f", "[", "r", "]"}], " ", 
                 RowBox[{"F", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                 RowBox[{"j", "[", "r", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["\[CapitalDelta]", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"S", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
              RowBox[{"\[CapitalDelta]", "[", 
               RowBox[{"r", ",", "a"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", 
                 RowBox[{"f", "[", "r", "]"}], " ", 
                 RowBox[{"F", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", 
                    RowBox[{"j", "[", "r", "]"}]}], "+", 
                   RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["j", "\[Prime]",
                    MultilineFunction->None], "[", "r", "]"}]}]}], ")"}]}], 
                "+", 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", "r", " ", 
                    RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                    RowBox[{"j", "[", "r", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "r", "]"}]}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "6"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
                    RowBox[{"3", " ", "a", " ", 
                    RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                    RowBox[{"a", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                  ")"}]}]}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"S", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
             RowBox[{"T", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
           RowBox[{"g", "[", "a", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", "a", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "-", 
                   RowBox[{"5", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                 " ", 
                 RowBox[{
                  SuperscriptBox["\[CapitalDelta]", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                RowBox[{"a", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                 " ", "r", " ", 
                 RowBox[{"f", "[", "r", "]"}], " ", 
                 RowBox[{"F", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                 RowBox[{"j", "[", "r", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["\[CapitalDelta]", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"\[CapitalDelta]", "[", 
               RowBox[{"r", ",", "a"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "96"}], " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                   RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                RowBox[{"96", " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                   RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                RowBox[{"32", " ", 
                 SuperscriptBox["a", "2"], " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                   RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                 RowBox[{"B", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                RowBox[{"8", " ", 
                 SuperscriptBox["a", "2"], " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", 
                 " ", 
                 RowBox[{"F", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                 RowBox[{"j", "[", "r", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                   MultilineFunction->None], "[", "r", "]"}]}], "+", 
                RowBox[{"3", " ", 
                 SuperscriptBox["a", "3"], " ", 
                 SuperscriptBox["r", "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"F", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
                 RowBox[{"j", "[", "r", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["g", "\[Prime]",
                   MultilineFunction->None], "[", "a", "]"}]}], "-", 
                RowBox[{"3", " ", 
                 SuperscriptBox["a", "3"], " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                 SuperscriptBox["r", "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"F", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
                 RowBox[{"j", "[", "r", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["g", "\[Prime]",
                   MultilineFunction->None], "[", "a", "]"}]}], "-", 
                RowBox[{"16", " ", "a", " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                   RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                 SuperscriptBox["r", "2"], " ", 
                 RowBox[{
                  SuperscriptBox["A", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                RowBox[{"16", " ", 
                 SuperscriptBox["a", "3"], " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                   RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                 RowBox[{
                  SuperscriptBox["B", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                RowBox[{"32", " ", "a", " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                   RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                 RowBox[{
                  SuperscriptBox["S", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                RowBox[{"32", " ", "a", " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                   RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                 RowBox[{
                  SuperscriptBox["T", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["a", "2"], " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                 RowBox[{"f", "[", "r", "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "2"}], " ", "r", " ", 
                    RowBox[{"j", "[", "r", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["F", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                   RowBox[{
                    RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], ")"}], " ",
                     "r", " ", 
                    RowBox[{
                    SuperscriptBox["j", "\[Prime]",
                    MultilineFunction->None], "[", "r", "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"j", "[", "r", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "-", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", "r", " ", 
                    RowBox[{
                    SuperscriptBox["B", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                    RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"8", " ", "a", " ", 
        RowBox[{"g", "[", "a", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"A", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              RowBox[{"B", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{"S", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
             RowBox[{"T", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox[
            RowBox[{"F", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
           RowBox[{"g", "[", "a", "]"}], " ", 
           RowBox[{"j", "[", "r", "]"}]}]}], ")"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], ")"}]}], ",", "0", ",", "0", ",", 
     "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.4603979665130053`*^9, 3.460397988590868*^9}, {
   3.4603980408828487`*^9, 3.460398044252734*^9}, {3.46044413277184*^9, 
   3.460356833221119*^9}, 3.460366898171053*^9, 3.460372593850625*^9, 
   3.542470040921711*^9, 3.543557444921175*^9, 3.5435592750963984`*^9, 
   3.5435594358087187`*^9, 3.543562996017728*^9, 3.5435639393415422`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Htmp", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "d", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "hr", ",", "ha", ",", "0", ",", "0", ",", "0"}], 
       "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"phi", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"trT", "[", 
    RowBox[{
     RowBox[{"outerT", "[", 
      RowBox[{"Htmp", ",", "Htmp"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.460444144767435*^9, 3.460444175048345*^9}, {
  3.542470055520176*^9, 3.5424700562158747`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"4", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"B", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
      RowBox[{"S", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
    SuperscriptBox["hr", "2"], " ", 
    SuperscriptBox[
     RowBox[{"f", "[", "r", "]"}], "2"], " ", 
    RowBox[{"j", "[", "r", "]"}]}], "+", 
   RowBox[{"2", " ", "ha", " ", 
    RowBox[{"g", "[", "a", "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"A", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{"T", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "ha"}], "-", 
      RowBox[{"a", " ", "hr", " ", "r", " ", 
       RowBox[{"f", "[", "r", "]"}], " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"j", "[", "r", "]"}]}]}], ")"}]}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"16", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"A", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"B", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
        RowBox[{"T", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["r", "2"], " ", 
      SuperscriptBox[
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
      RowBox[{"g", "[", "a", "]"}], " ", 
      RowBox[{"j", "[", "r", "]"}]}]}], ")"}], " ", 
   RowBox[{"\[CapitalDelta]", "[", 
    RowBox[{"r", ",", "a"}], "]"}]}]]], "Output",
 CellChangeTimes->{{3.460444157205353*^9, 3.460356833417321*^9}, 
   3.460366898545617*^9, 3.460372594065666*^9, {3.5424700439024754`*^9, 
   3.542470056946002*^9}, 3.5435574450328503`*^9, 3.5435592752930202`*^9, 
   3.543559436022681*^9, 3.543562996189949*^9, 3.543563939531681*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "dH", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"dH", ",", "2", ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"dH", "=", 
      RowBox[{"ST", "[", 
       RowBox[{"dH", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i1", ",", "d"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i2", ",", "d"}], "}"}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         FractionBox["1", "2"], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"H", ",", 
               RowBox[{"{", 
                RowBox[{"{", 
                 RowBox[{"i1", ",", "d"}], "}"}], "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
           RowBox[{"Sum", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"GT", "[", 
               RowBox[{"\[CapitalGamma]", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"i1", ",", "d"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"i2", ",", "d"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"s1", ",", "u"}], "}"}]}], "}"}]}], "]"}], 
              RowBox[{"GT", "[", 
               RowBox[{"H", ",", 
                RowBox[{"{", 
                 RowBox[{"{", 
                  RowBox[{"s1", ",", "d"}], "}"}], "}"}]}], "]"}]}], ",", 
             RowBox[{"{", 
              RowBox[{"s1", ",", "1", ",", "Nind"}], "}"}]}], "]"}], 
           "\[IndentingNewLine]", "+", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"H", ",", 
               RowBox[{"{", 
                RowBox[{"{", 
                 RowBox[{"i2", ",", "d"}], "}"}], "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
           RowBox[{"Sum", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"GT", "[", 
               RowBox[{"\[CapitalGamma]", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"i2", ",", "d"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"i1", ",", "d"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"s1", ",", "u"}], "}"}]}], "}"}]}], "]"}], 
              RowBox[{"GT", "[", 
               RowBox[{"H", ",", 
                RowBox[{"{", 
                 RowBox[{"{", 
                  RowBox[{"s1", ",", "d"}], "}"}], "}"}]}], "]"}]}], ",", 
             RowBox[{"{", 
              RowBox[{"s1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], 
          ")"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.4089514759929943`*^9, {3.5178237067967873`*^9, 3.51782372377859*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "RF1", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"RF1", ",", "2", ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RF1", "=", 
      RowBox[{"ST", "[", 
       RowBox[{"RF1", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i1", ",", "d"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i2", ",", "d"}], "}"}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"G", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"i1", ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"i2", ",", "d"}], "}"}]}], "}"}]}], "]"}], ",", "l"}],
           "]"}], "+", 
         RowBox[{"2", 
          RowBox[{"(", " ", 
           RowBox[{
            RowBox[{"GT", "[", 
             RowBox[{"R2", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"i1", ",", "d"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"i2", ",", "d"}], "}"}]}], "}"}]}], "]"}], "-", 
            RowBox[{"\[CapitalLambda]", " ", 
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"i1", ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"i2", ",", "d"}], "}"}]}], "}"}]}], "]"}]}], "+", 
            " ", 
            RowBox[{"GT", "[", 
             RowBox[{"dH", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"i1", ",", "d"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"i2", ",", "d"}], "}"}]}], "}"}]}], "]"}]}], " ", 
           ")"}]}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.408797573844262*^9, 3.40879762198135*^9}, {
   3.408799327901697*^9, 3.408799351292495*^9}, {3.408800985564945*^9, 
   3.4088009869407597`*^9}, {3.415861529562262*^9, 3.415861529788752*^9}, {
   3.424671218939474*^9, 3.424671225137734*^9}, {3.424671979395668*^9, 
   3.4246719876901283`*^9}, 3.424673490236145*^9, {3.4262333235748873`*^9, 
   3.426233329767264*^9}, {3.431855626568253*^9, 3.4318556468627462`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"T", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "T"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Tl"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Tr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Ta"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Trr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Taa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Tra"}], ",", 
     RowBox[{
      RowBox[{"A", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "A"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Al"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Ar"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Aa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Arr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Aaa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Ara"}], ",", 
     RowBox[{
      RowBox[{"B", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "B"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Bl"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Br"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Ba"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Brr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Baa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Bra"}], ",", 
     RowBox[{
      RowBox[{"F", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "F"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Fl"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Fr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Fa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Frr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Faa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Fra"}], ",", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "S"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Sl"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Sr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Sa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Srr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Saa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Sra"}], ",", 
     RowBox[{
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "L"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalDelta]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "Lr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalDelta]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "Lrr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalDelta]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "La"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalDelta]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "Laa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalDelta]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "Lra"}], ",", 
     RowBox[{
      RowBox[{"f", "[", "r", "]"}], "\[Rule]", "f"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "r", "]"}], "\[Rule]", "fr"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "''"}], "[", "r", "]"}], "\[Rule]", "frr"}], ",", 
     RowBox[{
      RowBox[{"g", "[", "a", "]"}], "\[Rule]", "g"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"g", "'"}], "[", "a", "]"}], "\[Rule]", "ga"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"g", "''"}], "[", "a", "]"}], "\[Rule]", "gaa"}], ",", 
     RowBox[{
      RowBox[{"j", "[", "r", "]"}], "\[Rule]", "j"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"j", "'"}], "[", "r", "]"}], "\[Rule]", "jr"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"j", "''"}], "[", "r", "]"}], "\[Rule]", "jrr"}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.426233462410046*^9, 3.426233529934688*^9}, {
   3.426425823867654*^9, 3.426425926949801*^9}, {3.460305912394334*^9, 
   3.460306053671014*^9}, {3.460307114041431*^9, 3.460307131380796*^9}, {
   3.5033115682122517`*^9, 3.503311569834202*^9}, {3.504000155601179*^9, 
   3.504000163012282*^9}, {3.517581414802555*^9, 3.517581424098625*^9}, 
   3.517824243782352*^9, {3.5178251206831512`*^9, 3.460392807343815*^9}, {
   3.460396802022485*^9, 3.460396867528345*^9}, {3.543559411270792*^9, 
   3.543559421654997*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"H", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "2"}], "]"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Exp", "[", "x_", "]"}], "\[Rule]", 
      RowBox[{"exp", "[", "x", "]"}]}], "}"}]}], "//.", "repl"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.460444204796074*^9, 3.460444241314095*^9}}],

Cell["\<\
(exp(-S - \
T)*(-4*f*exp(T)*(Power(a,2)*Power(F,2)*g*Power(j,2)*Power(r,2)*(-(L*(-2 - \
3*r*Sr - r*Tr + 2*exp(A*Power(r,2)))*exp(S)) - Lr*r*(-6*exp(S) + \
exp(A*Power(r,2) + S) + 3*exp(A*Power(r,2) + T))) + 
          j*exp(S)*(16*Lr*r*exp(A*Power(r,2) + T)*(-5*exp(Power(a,2)*B + S) + \
exp(Power(a,2)*B + A*Power(r,2) + S) + exp(A*Power(r,2) + T) + \
3*exp(Power(a,2)*B + A*Power(r,2) + T)) + 
             L*(-(Power(a,2)*Power(F,2)*g*jr*Power(r,3)*(-1 + \
exp(A*Power(r,2)))) + 32*A*Power(r,2)*exp(Power(a,2)*B + A*Power(r,2) + S + \
T) + 
                16*(-2 - Power(a,2)*Br*r + Ar*Power(r,3) - 4*r*Sr + \
2*exp(A*Power(r,2)))*exp(Power(a,2)*B + A*Power(r,2) + S + T))) + 
          16*jr*L*r*(-1 + exp(A*Power(r,2)))*exp(Power(a,2)*B + A*Power(r,2) \
+ 2*S + T)) + 
       j*r*(Power(a,2)*Power(F,3)*g*j*Power(r,3)*(3*a*ga*L*exp(T) + \
g*(6*L*exp(T) + a*La*(exp(S) + 3*exp(T)))) + \
8*Power(a,2)*Power(F,2)*fr*g*j*L*Power(r,2)*(-1 + exp(A*Power(r,2)))*exp(S + \
T) + 
          16*F*r*(-(a*ga*L*(1 + 3*exp(Power(a,2)*B))*exp(A*Power(r,2) + T)) - \
g*(2*L*(1 - a*Aa*Power(r,2) - a*Ta + 3*exp(Power(a,2)*B))*exp(A*Power(r,2) + \
T) + 
                a*La*(exp(Power(a,2)*B + S) + exp(Power(a,2)*B + A*Power(r,2) \
+ S) + exp(A*Power(r,2) + T) + 3*exp(Power(a,2)*B + A*Power(r,2) + \
T))))*exp(S + T) - 
          32*L*(a*Fa*g*r + 4*fr*(-1 + exp(A*Power(r,2)))*exp(Power(a,2)*B + \
S))*exp(A*Power(r,2) + S + 2*T))))/
   (8.*f*j*L*r*(-(Power(a,2)*Power(F,2)*g*j*Power(r,2)) + 16*exp(Power(a,2)*B \
+ A*Power(r,2) + S + T)))\
\>", "Output",
 CellChangeTimes->{{3.4604442138812447`*^9, 3.460356834532833*^9}, 
   3.4603668996099*^9, 3.460372595181933*^9, 3.54247006688552*^9, 
   3.543557445405633*^9, 3.5435592757432127`*^9, 3.5435594366235456`*^9, 
   3.5435629966211033`*^9, 3.543563939964781*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"H", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "3"}], "]"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Exp", "[", "x_", "]"}], "\[Rule]", 
      RowBox[{"exp", "[", "x", "]"}]}], "}"}]}], "//.", "repl"}], 
  "]"}]], "Input",
 CellChangeTimes->{3.46044425034136*^9}],

Cell["\<\
(exp(-S - \
T)*(Power(a,2)*Power(F,2)*Power(g,2)*j*Power(r,2)*(L*exp(S)*(Power(a,2)*f*F*(\
2*j + jr*r) + 2*(Power(a,2)*F*fr*j*r + 2*(-6 - 3*a*Sa - a*Ta + \
6*exp(Power(a,2)*B))*exp(T))) + 
          a*(a*f*F*j*Lr*r*(exp(S) + 3*exp(T)) + 4*La*exp(S)*(exp(Power(a,2)*B \
+ S) - 6*exp(T) + 3*exp(Power(a,2)*B + T)))) - 
       4*g*exp(S + T)*(4*a*(4*La*exp(Power(a,2)*B + S)*(exp(Power(a,2)*B + S) \
+ exp(Power(a,2)*B + A*Power(r,2) + S) - 5*exp(A*Power(r,2) + T) + \
3*exp(Power(a,2)*B + A*Power(r,2) + T)) + 
             a*f*F*j*Lr*r*(exp(Power(a,2)*B + S) + exp(Power(a,2)*B + \
A*Power(r,2) + S) + exp(A*Power(r,2) + T) + 3*exp(Power(a,2)*B + A*Power(r,2) \
+ T))) + 
          L*(3*Power(a,3)*Power(F,2)*ga*j*Power(r,2) - \
3*Power(a,3)*Power(F,2)*ga*j*Power(r,2)*exp(Power(a,2)*B) - 
             4*Power(a,2)*f*(-2*Fr*j*r - F*(jr*r*(1 + exp(A*Power(r,2))) + \
2*j*(1 - Power(a,2)*Br*r - r*Sr + exp(A*Power(r,2)))))*exp(Power(a,2)*B + S) + 
             8*Power(a,2)*F*fr*j*r*exp(Power(a,2)*B + A*Power(r,2) + S) - \
96*exp(Power(a,2)*B + A*Power(r,2) + S + T) + \
32*Power(a,2)*B*exp(Power(a,2)*B + A*Power(r,2) + S + T) + 
             16*Power(a,3)*Ba*exp(Power(a,2)*B + A*Power(r,2) + S + T) - \
16*a*Aa*Power(r,2)*exp(Power(a,2)*B + A*Power(r,2) + S + T) - \
32*a*Sa*exp(Power(a,2)*B + A*Power(r,2) + S + T) - 
             32*a*Ta*exp(Power(a,2)*B + A*Power(r,2) + S + T) + \
96*exp(2*Power(a,2)*B + A*Power(r,2) + S + T))) - 192*a*ga*L*(-1 + \
exp(Power(a,2)*B))*exp(Power(a,2)*B + A*Power(r,2) + 2*(S + T))))/
   (8.*a*g*L*(-(Power(a,2)*Power(F,2)*g*j*Power(r,2)) + 16*exp(Power(a,2)*B + \
A*Power(r,2) + S + T)))\
\>", "Output",
 CellChangeTimes->{{3.4604442509221687`*^9, 3.460356834593007*^9}, 
   3.4603668996819487`*^9, 3.460372595242635*^9, 3.5424700682177362`*^9, 
   3.543557445444585*^9, 3.5435592757851954`*^9, 3.543559436757618*^9, 
   3.5435629966581383`*^9, 3.5435639400208893`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{
   RowBox[{"phi", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Exp", "[", "x_", "]"}], "\[Rule]", 
      RowBox[{"exp", "[", "x", "]"}]}], "}"}]}], "//.", "repl"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.4604442564019127`*^9, 3.460444256594475*^9}}],

Cell["\<\
(4*Power(f,2)*Power(hr,2)*j*exp(Power(a,2)*B + S) + 2*g*ha*(-(a*f*F*hr*j*r) + \
2*ha*exp(A*Power(r,2) + T)))/(L*(-(Power(a,2)*Power(F,2)*g*j*Power(r,2)) + \
16*exp(Power(a,2)*B + A*Power(r,2) + S + T)))\
\>", "Output",
 CellChangeTimes->{{3.460444257172927*^9, 3.460356834643196*^9}, 
   3.460366899763846*^9, 3.4603725952920523`*^9, 3.542470070000843*^9, 
   3.5435574454921093`*^9, 3.5435592758292303`*^9, 3.543559436824161*^9, 
   3.543562996693828*^9, 3.5435639400683823`*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dlist\[Lambda]", "=", 
    RowBox[{"{", 
     RowBox[{"Tl", ",", "Al", ",", "Bl", ",", "Fl", ",", "Sl"}], "}"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dlistrr", "=", 
    RowBox[{"{", 
     RowBox[{"Trr", ",", "Arr", ",", "Brr", ",", "Frr", ",", "Srr"}], "}"}]}],
    ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dlistaa", "=", 
    RowBox[{"{", 
     RowBox[{"Taa", ",", "Aaa", ",", "Baa", ",", "Faa", ",", "Saa"}], "}"}]}],
    ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dlistra", "=", 
    RowBox[{"{", 
     RowBox[{"Tra", ",", "Ara", ",", "Bra", ",", "Fra", ",", "Sra"}], "}"}]}],
    ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dlist", "=", 
   RowBox[{"{", 
    RowBox[{
    "Tr", ",", "Ar", ",", "Br", ",", "Fr", ",", "Sr", ",", "Ta", ",", "Aa", 
     ",", "Ba", ",", "Fa", ",", "Sa"}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.517824939478304*^9, 3.5178249658652477`*^9}, {
  3.517825345546793*^9, 3.517825357952314*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"zerodlist", "=", 
   RowBox[{"Thread", "[", 
    RowBox[{"dlist", "\[Rule]", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", 
         RowBox[{"Length", "[", "dlist", "]"}]}], "}"}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.517827055015583*^9, 3.517827077817245*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"allderiv", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
    "dlist\[Lambda]", ",", "dlistrr", ",", "dlistaa", ",", "dlistra", ",", 
     "dlist"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.517824997155527*^9, 3.517825012540985*^9}, {
  3.51782518467982*^9, 3.5178251854111958`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"allvar", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "r", ",", "a", ",", "\[Theta]1", ",", "T", ",", "A", ",", "B", ",", "F",
        ",", "S", ",", "L", ",", "Lr", ",", "La", ",", "Lrr", ",", "Laa", ",",
        "Lra", ",", "f", ",", "fr", ",", "frr", ",", "g", ",", "ga", ",", 
       "gaa", ",", "j", ",", "jr", ",", "jrr", ",", "\[CapitalLambda]"}], 
      "}"}], ",", "allderiv"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.517825461847103*^9, 3.517825502830639*^9}, {
  3.517825546962123*^9, 3.517825549998563*^9}, {3.517825598208082*^9, 
  3.5178255990225143`*^9}, {3.5178272390735703`*^9, 3.460392829797771*^9}, {
  3.460396882947147*^9, 3.4603968873370037`*^9}, {3.543559434856298*^9, 
  3.5435594369272957`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"zeroallderiv", "=", 
   RowBox[{"Thread", "[", 
    RowBox[{"allderiv", "\[Rule]", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", 
         RowBox[{"Length", "[", "allderiv", "]"}]}], "}"}]}], "]"}]}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.517828665692329*^9, 3.5178286695470448`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"dlist2", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"dlist", "[", 
        RowBox[{"[", "ii", "]"}], "]"}], 
       RowBox[{"dlist", "[", 
        RowBox[{"[", "jj", "]"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "dlist", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"jj", ",", "ii", ",", 
        RowBox[{"Length", "[", "dlist", "]"}]}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.5178269895484753`*^9, 3.5178270260336027`*^9}, {
  3.517827312763998*^9, 3.517827331395611*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"randlist", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Thread", "[", 
      RowBox[{"allvar", "->", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Random", "[", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", 
           RowBox[{"Length", "[", "allvar", "]"}]}], "}"}]}], "]"}]}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", "1", ",", "20"}], "}"}]}], "]"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"extract", "[", "expr_", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"deriv\[Lambda]", "=", 
      RowBox[{"Simplify", "[", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"expr", ",", "dlist\[Lambda]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"derivrr", "=", 
      RowBox[{"Simplify", "[", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"expr", ",", "dlistrr"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"derivaa", "=", 
      RowBox[{"Simplify", "[", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"expr", ",", "dlistaa"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"derivra", "=", 
      RowBox[{"Simplify", "[", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"expr", ",", "dlistra"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"deriv1", "=", 
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"expr", ",", "dlist"}], "]"}], "//.", "zerodlist"}], "]"}]}],
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"deriv2", "=", 
      RowBox[{"Simplify", "[", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"expr", ",", "dlist2"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"noderiv", "=", 
      RowBox[{"Simplify", "[", 
       RowBox[{"expr", "//.", "zeroallderiv"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"N", "[", 
       RowBox[{
        RowBox[{"expr", "-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"deriv\[Lambda]", ".", "dlist\[Lambda]"}], "+", 
           RowBox[{"derivrr", ".", "dlistrr"}], "+", 
           RowBox[{"derivaa", ".", "dlistaa"}], "+", 
           RowBox[{"derivra", ".", "dlistra"}], "+", 
           RowBox[{"deriv1", ".", "dlist"}], "+", 
           RowBox[{"deriv2", ".", "dlist2"}], "+", "noderiv"}], ")"}]}], "/.",
         "randlist"}], "]"}], "]"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
      "deriv\[Lambda]", ",", "derivrr", ",", "derivaa", ",", "derivra", ",", 
       "deriv1", ",", "deriv2", ",", "noderiv"}], "}"}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.517825191432572*^9, 3.5178251938533*^9}, {
  3.517828583820703*^9, 3.517828636236395*^9}, {3.517828677980176*^9, 
  3.517828696111575*^9}, {3.51782874494584*^9, 3.5178288515280733`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{
     RowBox[{"RF1", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "1", ",", "1"}], "]"}], "]"}], "//.", "repl"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"coefftt", "=", 
   RowBox[{"extract", "[", "tmp", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.517828863851482*^9, 3.4603883470901337`*^9}, 
   3.46038838109201*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.1102230246251565`*^-16", ",", "5.551115123125783`*^-16", ",", 
   "5.551115123125783`*^-17", ",", "0.`", ",", "6.071532165918825`*^-18", ",",
    "4.5102810375396984`*^-17", ",", 
   RowBox[{"-", "2.1510571102112408`*^-16"}], ",", 
   RowBox[{"-", "6.938893903907228`*^-17"}], ",", 
   RowBox[{"-", "3.9968028886505635`*^-15"}], ",", 
   RowBox[{"-", "4.336808689942018`*^-18"}], ",", "1.3010426069826053`*^-18", 
   ",", "1.249000902703301`*^-16", ",", 
   RowBox[{"-", "2.983724378680108`*^-16"}], ",", 
   RowBox[{"-", "2.710505431213761`*^-19"}], ",", "6.938893903907228`*^-17", 
   ",", 
   RowBox[{"-", "8.326672684688674`*^-17"}], ",", "0.`", ",", 
   "9.540979117872439`*^-18", ",", "1.942890293094024`*^-16", ",", 
   "1.0842021724855044`*^-18"}], "}"}]], "Print",
 CellChangeTimes->{{3.460388368246913*^9, 3.460388383729855*^9}, 
   3.460392846328475*^9, {3.460396906809197*^9, 3.4603568417356663`*^9}, 
   3.4603669070324373`*^9, 3.460372602146345*^9, 3.5424700831734877`*^9, 
   3.54355745020923*^9, 3.543559284286159*^9, {3.543559453602375*^9, 
   3.543559468620966*^9}, 3.5435630038498383`*^9, 3.543563947017034*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{
     RowBox[{"RF1", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "2", ",", "2"}], "]"}], "]"}], "//.", "repl"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"coeffrr", "=", 
   RowBox[{"extract", "[", "tmp", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.460388351796958*^9, 3.460388362522346*^9}, {
  3.460388396835832*^9, 3.460388403884074*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6.750155989720952`*^-14", ",", "2.220446049250313`*^-14", ",", 
   RowBox[{"-", "2.1316282072803006`*^-14"}], ",", 
   RowBox[{"-", "2.842170943040401`*^-14"}], ",", "1.580957587066223`*^-13", 
   ",", 
   RowBox[{"-", "1.709743457922741`*^-14"}], ",", "1.2434497875801753`*^-14", 
   ",", 
   RowBox[{"-", "3.694822225952521`*^-13"}], ",", "2.8421709430404007`*^-13", 
   ",", 
   RowBox[{"-", "1.5987211554602254`*^-14"}], ",", "5.4569682106375694`*^-12",
    ",", "1.865174681370263`*^-14", ",", 
   RowBox[{"-", "4.408917675391422`*^-12"}], ",", 
   RowBox[{"-", "1.8044374883174896`*^-9"}], ",", "6.110667527536862`*^-13", 
   ",", "3.410605131648481`*^-13", ",", "1.7053025658242404`*^-12", ",", 
   "2.842170943040401`*^-14", ",", "7.549516567451064`*^-14", ",", 
   "5.5706550483591855`*^-12"}], "}"}]], "Print",
 CellChangeTimes->{
  3.460389152260504*^9, 3.4603928677987013`*^9, {3.460396936603415*^9, 
   3.460356858405094*^9}, 3.46036692402672*^9, 3.460372618959271*^9, 
   3.542470092561906*^9, 3.543557459613719*^9, 3.543559482379065*^9, 
   3.5435630165328093`*^9, 3.543563959393545*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{
     RowBox[{"RF1", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "3", ",", "3"}], "]"}], "]"}], "//.", "repl"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"coeffaa", "=", 
   RowBox[{"extract", "[", "tmp", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.460388354236719*^9, 3.460388364994575*^9}, {
  3.4603883986118813`*^9, 3.460388406035945*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.3322676295501878`*^-14", ",", 
   RowBox[{"-", "3.1086244689504383`*^-15"}], ",", 
   RowBox[{"-", "3.9968028886505635`*^-14"}], ",", 
   RowBox[{"-", "2.4424906541753444`*^-14"}], ",", "2.6645352591003757`*^-15",
    ",", "1.0658141036401503`*^-14", ",", "6.750155989720952`*^-14", ",", 
   "2.564060075371799`*^-13", ",", 
   RowBox[{"-", "1.680877659282487`*^-13"}], ",", "7.105427357601002`*^-15", 
   ",", 
   RowBox[{"-", "1.199040866595169`*^-14"}], ",", "8.104628079763643`*^-15", 
   ",", "2.1245227799226996`*^-12", ",", "9.841710779667778`*^-12", ",", 
   "5.329070518200751`*^-15", ",", "1.007499639271714`*^-12", ",", 
   "1.8207657603852567`*^-14", ",", "3.2085445411667024`*^-14", ",", 
   RowBox[{"-", "2.1316282072803006`*^-14"}], ",", 
   RowBox[{"-", "1.6830981053317373`*^-13"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.460389268467102*^9, 3.460392888648872*^9, {3.4603969684635*^9, 
   3.460356877910128*^9}, 3.4603669435501127`*^9, 3.460372638490157*^9, 
   3.5424701037116213`*^9, 3.543557470648505*^9, 3.54355949601747*^9, 
   3.543563030264681*^9, 3.5435639728515377`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{
     RowBox[{"RF1", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "2", ",", "3"}], "]"}], "]"}], "//.", "repl"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"coeffra", "=", 
   RowBox[{"extract", "[", "tmp", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.460388355436696*^9, 3.460388367106613*^9}, {
  3.460388401363799*^9, 3.4603884076680202`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.608224830031759`*^-15", ",", 
   RowBox[{"-", "1.1546319456101628`*^-14"}], ",", 
   RowBox[{"-", "3.552713678800501`*^-15"}], ",", 
   RowBox[{"-", "8.576472865229334`*^-15"}], ",", 
   RowBox[{"-", "2.8033131371785203`*^-15"}], ",", "4.440892098500626`*^-16", 
   ",", 
   RowBox[{"-", "1.1102230246251565`*^-16"}], ",", "3.824718319833664`*^-14", 
   ",", "6.803446694902959`*^-13", ",", 
   RowBox[{"-", "7.993605777301127`*^-15"}], ",", "1.305622276959184`*^-13", 
   ",", "1.9158286068687858`*^-14", ",", 
   RowBox[{"-", "3.1530333899354446`*^-13"}], ",", "4.3028081098128723`*^-13",
    ",", 
   RowBox[{"-", "4.440892098500626`*^-15"}], ",", "7.840950111415168`*^-14", 
   ",", "3.58567342484406`*^-15", ",", 
   RowBox[{"-", "1.0269562977782698`*^-14"}], ",", "1.5210055437364645`*^-14",
    ",", "5.234701561107613`*^-14"}], "}"}]], "Print",
 CellChangeTimes->{
  3.460389455684288*^9, 3.460392915610973*^9, {3.46039700838389*^9, 
   3.460356899938744*^9}, 3.460366965449085*^9, 3.460372660405279*^9, 
   3.542470115813259*^9, 3.543557482944367*^9, 3.543559512249228*^9, 
   3.543563046346766*^9, 3.5435639888922853`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{
     RowBox[{"RF1", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "4", ",", "4"}], "]"}], "]"}], "//.", "repl"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"coeff\[Theta]\[Theta]", "=", 
   RowBox[{"extract", "[", "tmp", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.460388368517098*^9, 3.460388390820409*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2.2898349882893854`*^-16"}], ",", "2.4424906541753444`*^-15",
    ",", "8.881784197001252`*^-16", ",", 
   RowBox[{"-", "5.88418203051333`*^-15"}], ",", "7.389922007661198`*^-16", 
   ",", 
   RowBox[{"-", "1.1102230246251565`*^-16"}], ",", "3.3306690738754696`*^-16",
    ",", 
   RowBox[{"-", "5.342948306008566`*^-16"}], ",", "2.0816681711721685`*^-16", 
   ",", "8.881784197001252`*^-16", ",", "6.661338147750939`*^-16", ",", 
   "1.6542323066914832`*^-14", ",", 
   RowBox[{"-", "1.1601830607332886`*^-14"}], ",", "4.0442011583130197`*^-16",
    ",", "1.1102230246251565`*^-15", ",", 
   RowBox[{"-", "8.206629820151079`*^-14"}], ",", "1.0824674490095276`*^-15", 
   ",", "4.40619762898109`*^-16", ",", "1.8041124150158794`*^-15", ",", 
   "6.858402734621905`*^-14"}], "}"}]], "Print",
 CellChangeTimes->{
  3.460388421311708*^9, 3.460392922830152*^9, {3.46039701910912*^9, 
   3.460356907775153*^9}, 3.4603669733368998`*^9, 3.4603726682497597`*^9, 
   3.542470120595168*^9, 3.543557487287178*^9, 3.5435595179592333`*^9, 
   3.5435630519822206`*^9, 3.5435639945479317`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"coeffs", "=", 
   RowBox[{"{", 
    RowBox[{
    "coefftt", ",", "coeffrr", ",", "coeffaa", ",", "coeffra", ",", 
     "coeff\[Theta]\[Theta]"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{3.460389569356962*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coeff\[Lambda]", "=", 
  RowBox[{"coeffs", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "1"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4603896237503223`*^9, 3.460389649940551*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "T"], " ", 
      SuperscriptBox["f", "2"], " ", "j", " ", "L", " ", 
      SuperscriptBox["r", "2"]}], ",", "0", ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "L"}], 
      RowBox[{
       SuperscriptBox["f", "2"], " ", "j"}]], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "L", " ", 
       SuperscriptBox["r", "2"]}], 
      RowBox[{
       SuperscriptBox["f", "2"], " ", "j"}]], ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "L"}], "g"],
      ",", "0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "L"}], 
      "g"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"a", " ", "L", " ", "r"}], "f"], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", "S"], " ", "g", " ", "L"}], 
      RowBox[{"1", "-", 
       SuperscriptBox["\[Theta]1", "2"]}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.4603896291241493`*^9, 3.4603896506666527`*^9}, 
   3.460392317998266*^9, 3.460392948493086*^9, 3.460393177387624*^9, {
   3.460397019398037*^9, 3.460356907907297*^9}, 3.460366973473732*^9, 
   3.46037266839177*^9, 3.5424701208571033`*^9, 3.543557487471448*^9, 
   3.543559518233389*^9, 3.543563052116591*^9, 3.543563994689644*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Inverse", "[", "coeff\[Lambda]", "]"}], ".", 
  RowBox[{"coeffs", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "1"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.460389658303999*^9, 3.460389664733412*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.4603896653582773`*^9, 3.4603896929826193`*^9}, 
   3.4603923196027603`*^9, 3.4603929517489634`*^9, 3.4603931793038197`*^9, {
   3.4603970195459757`*^9, 3.4603569079636908`*^9}, 3.460366973531946*^9, 
   3.4603726684453573`*^9, 3.542470121018214*^9, 3.543557487507291*^9, 
   3.543559518368712*^9, 3.543563052151598*^9, 3.543563994744111*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"newcoeffrr", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Inverse", "[", "coeff\[Lambda]", "]"}], ".", 
    RowBox[{"coeffs", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "2"}], "]"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4603896732003117`*^9, 3.460389700198414*^9}, {
  3.460389973154498*^9, 3.4603899751557007`*^9}, {3.4603903858056793`*^9, 
  3.460390422230899*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
        SuperscriptBox["f", "2"], " ", "j"}], 
       RowBox[{
        RowBox[{"16", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], 
        "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", "L", " ", 
         SuperscriptBox["r", "2"]}]}]]}], ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
        SuperscriptBox["f", "2"], " ", "j"}], 
       RowBox[{
        RowBox[{"16", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], 
        "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", "L", " ", 
         SuperscriptBox["r", "2"]}]}]]}], ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
        SuperscriptBox["f", "2"], " ", "j"}], 
       RowBox[{
        RowBox[{"16", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], 
        "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", "L", " ", 
         SuperscriptBox["r", "2"]}]}]]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
        SuperscriptBox["f", "2"], " ", "j"}], 
       RowBox[{
        RowBox[{"16", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], 
        "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", "L", " ", 
         SuperscriptBox["r", "2"]}]}]]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
        SuperscriptBox["f", "2"], " ", "j"}], 
       RowBox[{
        RowBox[{"16", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], 
        "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", "L", " ", 
         SuperscriptBox["r", "2"]}]}]]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.460389693890481*^9, 3.460389700765806*^9}, {
   3.4603899685727262`*^9, 3.460389976419889*^9}, 3.460390380755816*^9, 
   3.4603904368514023`*^9, 3.460392324200906*^9, 3.460392953265147*^9, 
   3.4603931847409563`*^9, 3.460393221701886*^9, {3.4603970575895987`*^9, 
   3.460356908038414*^9}, 3.460366973601602*^9, 3.460372668515505*^9, 
   3.542470121102771*^9, 3.543557487571121*^9, 3.543559518454917*^9, 
   3.543563052199345*^9, 3.5435639947963552`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"newcoeffaa", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Inverse", "[", "coeff\[Lambda]", "]"}], ".", 
    RowBox[{"coeffs", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "3"}], "]"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.4603897104017572`*^9, 3.460389982684561*^9, 3.4603903900025997`*^9, {
   3.460390427193303*^9, 3.460390428798345*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "g"}], 
       RowBox[{
        RowBox[{"16", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], 
        "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", "L", " ", 
         SuperscriptBox["r", "2"]}]}]]}], ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "g"}], 
       RowBox[{
        RowBox[{"16", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], 
        "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", "L", " ", 
         SuperscriptBox["r", "2"]}]}]]}], ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "g"}], 
       RowBox[{
        RowBox[{"16", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], 
        "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", "L", " ", 
         SuperscriptBox["r", "2"]}]}]]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "g"}], 
       RowBox[{
        RowBox[{"16", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], 
        "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", "L", " ", 
         SuperscriptBox["r", "2"]}]}]]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "g"}], 
       RowBox[{
        RowBox[{"16", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], 
        "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", "L", " ", 
         SuperscriptBox["r", "2"]}]}]]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.4603897117415943`*^9, {3.460389981859321*^9, 3.460389983870729*^9}, 
   3.4603904382349977`*^9, 3.4603923271776657`*^9, 3.460392956373383*^9, 
   3.46039318613798*^9, 3.460393222414995*^9, {3.4603970590346413`*^9, 
   3.460356908118824*^9}, 3.460366973677075*^9, 3.460372668594121*^9, 
   3.542470121266078*^9, 3.543557487618719*^9, 3.543559518630109*^9, 
   3.543563052250599*^9, 3.543563994849399*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"newcoeffra", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Inverse", "[", "coeff\[Lambda]", "]"}], ".", 
    RowBox[{"coeffs", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "4"}], "]"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.460389713609824*^9, 3.460389986692421*^9, 3.460390392216176*^9, {
   3.460390431786374*^9, 3.4603904338304567`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
      "2", " ", "a", " ", "f", " ", "F", " ", "g", " ", "j", " ", "r"}], 
      RowBox[{
       RowBox[{"16", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", "L", " ", 
        SuperscriptBox["r", "2"]}]}]], ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{
      "2", " ", "a", " ", "f", " ", "F", " ", "g", " ", "j", " ", "r"}], 
      RowBox[{
       RowBox[{"16", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", "L", " ", 
        SuperscriptBox["r", "2"]}]}]], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      RowBox[{
      "2", " ", "a", " ", "f", " ", "F", " ", "g", " ", "j", " ", "r"}], 
      RowBox[{
       RowBox[{"16", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", "L", " ", 
        SuperscriptBox["r", "2"]}]}]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{
      "2", " ", "a", " ", "f", " ", "F", " ", "g", " ", "j", " ", "r"}], 
      RowBox[{
       RowBox[{"16", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", "L", " ", 
        SuperscriptBox["r", "2"]}]}]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{
      "2", " ", "a", " ", "f", " ", "F", " ", "g", " ", "j", " ", "r"}], 
      RowBox[{
       RowBox[{"16", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}], "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", "L", " ", 
        SuperscriptBox["r", "2"]}]}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.460389714247075*^9, 3.460389989874523*^9, 3.460390439550115*^9, 
   3.46039232916503*^9, 3.460392957462525*^9, 3.460393187000842*^9, 
   3.4603932230970488`*^9, {3.460397060554915*^9, 3.4603569081962547`*^9}, 
   3.46036697375664*^9, 3.460372668670583*^9, 3.5424701214323053`*^9, 
   3.543557487666267*^9, 3.543559518783061*^9, 3.543563052308391*^9, 
   3.5435639949082212`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"newcoeffderiv1", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Inverse", "[", "coeff\[Lambda]", "]"}], ".", 
    RowBox[{"coeffs", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "5"}], "]"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.460389768419777*^9, 3.460389994663455*^9, {3.460390026485517*^9, 
   3.4603900500866823`*^9}, 3.460390394581377*^9, {3.460390441551569*^9, 
   3.460390450191416*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"8", " ", 
         SuperscriptBox["L", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "r"}], 
           "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}]], 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "S"}], "-", "T"}]], " ", "f", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "f", " ", "j", " ", "Lr", " ", 
           "r"}], "+", 
          RowBox[{"48", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "f", " ", "j", " ", "Lr", " ", 
           "r"}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "fr", " ", "j", " ", "L"}], "+", 
             RowBox[{"f", " ", "jr", " ", "L"}], "-", 
             RowBox[{"f", " ", "j", " ", "Lr"}]}], ")"}], " ", "r"}], "+", 
          RowBox[{"8", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"S", "+", "T"}]], " ", "F", " ", "g", " ", "j", " ", "La",
            " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", "T"], " ", "f", " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["j", "2"], " ", "Lr", " ", 
           SuperscriptBox["r", "3"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "fr", " ", "j", " ", "L", " ", "r"}], "+", 
             RowBox[{"f", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "j", " ", "L"}], "+", 
                RowBox[{"jr", " ", "L", " ", "r"}], "+", 
                RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", "S"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "fr", " ", "j", " ", "L", " ", "r"}], "+", 
             RowBox[{"f", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "j", " ", "L"}], "+", 
                RowBox[{"jr", " ", "L", " ", "r"}], "+", 
                RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}]}], 
         ")"}]}]}]}], ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "S"}], "-", "T"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "g", " ", "La"}], "+", 
          RowBox[{"16", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "g", " ", "La"}], "+", 
          RowBox[{"16", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"ga", " ", "L"}], "-", 
             RowBox[{"g", " ", "La"}]}], ")"}]}], "+", 
          RowBox[{"48", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "g", " ", "L"}], "+", 
             RowBox[{"a", " ", "ga", " ", "L"}], "+", 
             RowBox[{"a", " ", "g", " ", "La"}]}], ")"}]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"S", "+", "T"}]], " ", "f", " ", "F", " ", "g", " ", "j", 
           " ", "Lr", " ", "r"}], "-", 
          RowBox[{
           SuperscriptBox["a", "3"], " ", 
           SuperscriptBox["\[ExponentialE]", "S"], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["g", "2"], " ", "j", " ", "La", " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", "T"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "g", " ", "L"}], "+", 
             RowBox[{"a", " ", "ga", " ", "L"}], "+", 
             RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["L", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
          RowBox[{
           SuperscriptBox["a", "3"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}]]}], ",", "0", ",", "0", ",", 
     "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", 
       RowBox[{"16", " ", 
        SuperscriptBox["L", "2"], " ", 
        SuperscriptBox["r", "3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "16"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "A"}], " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{"2", " ", "T"}]}]], " ", "f", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"256", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]], 
          " ", "F", " ", "g", " ", "j", " ", "La", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"512", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"3", " ", "T"}]}]], " ", "F", " ", "g", " ", "j", " ", 
          "La", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"256", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", "F", " ", "g", " ", 
          "j", " ", "La", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"64", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "T"}]}]], " ", "f", " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["j", "2"], " ", "Lr", " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"32", " ", 
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["j", "2"], " ", "La", " ", 
          SuperscriptBox["r", "4"]}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          SuperscriptBox["F", "3"], " ", "g", " ", 
          SuperscriptBox["j", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "g", " ", "L"}], "-", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["a", "5"], " ", 
          SuperscriptBox["F", "5"], " ", 
          SuperscriptBox["g", "3"], " ", 
          SuperscriptBox["j", "3"], " ", "La", " ", 
          SuperscriptBox["r", "6"]}], "+", 
         RowBox[{"64", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["j", "2"], " ", 
          SuperscriptBox["r", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "fr", " ", "L"}], "+", 
            RowBox[{"3", " ", "f", " ", "Lr"}], "+", 
            RowBox[{"4", " ", "A", " ", "f", " ", "L", " ", "r"}]}], ")"}]}], 
         "+", 
         RowBox[{"1024", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"3", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", 
            RowBox[{"3", " ", "T"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "fr", " ", "j", " ", "L", " ", "r"}], "+", 
            RowBox[{"f", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "j", " ", "L"}], "+", 
               RowBox[{"jr", " ", "L", " ", "r"}], "+", 
               RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"128", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "fr", " ", "j", " ", "L", " ", "r"}], "+", 
            RowBox[{"f", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "j", " ", "L"}], "+", 
               RowBox[{"jr", " ", "L", " ", "r"}], "+", 
               RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", "T"], " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["j", "2"], " ", 
          SuperscriptBox["r", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "fr", " ", "j", " ", "L", " ", "r"}], "+", 
            RowBox[{"f", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "j", " ", "L"}], "+", 
               RowBox[{"jr", " ", "L", " ", "r"}], "+", 
               RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["j", "2"], " ", 
          SuperscriptBox["r", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "fr", " ", "j", " ", "L", " ", "r"}], "+", 
            RowBox[{"f", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "j", " ", "L"}], "+", 
               RowBox[{"jr", " ", "L", " ", "r"}], "+", 
               RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"1024", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", 
            RowBox[{"3", " ", "T"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "fr", " ", "j", " ", "L", " ", "r"}], 
            "-", 
            RowBox[{"f", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"jr", " ", "L", " ", "r"}], "+", 
               RowBox[{"j", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "L"}], "+", 
                  RowBox[{"Lr", " ", "r"}], "-", 
                  RowBox[{"2", " ", "A", " ", "L", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{"-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"8", " ", 
         SuperscriptBox["L", "2"], " ", "r", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "16"}], " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "S"}], "-", "T"}]], " ", "f", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", "f", " ", "j", " ", "Lr", " ", 
           "r"}], "+", 
          RowBox[{"768", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", "f", " ", "j", " ", "Lr", " ", 
           "r"}], "-", 
          RowBox[{"128", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"3", " ", "S"}], "+", "T"}]], " ", "F", " ", "g", " ", 
           "j", " ", "La", " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"128", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", "F", " ", "g", " ", 
           "j", " ", "La", " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"48", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "f", " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["j", "2"], " ", "Lr", " ", 
           SuperscriptBox["r", "3"]}], "-", 
          RowBox[{"96", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "f", " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["j", "2"], " ", "Lr", " ", 
           SuperscriptBox["r", "3"]}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"S", "+", "T"}]], " ", 
           SuperscriptBox["F", "3"], " ", "g", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "g"}], "+", 
             RowBox[{"a", " ", "ga"}]}], ")"}], " ", 
           SuperscriptBox["j", "2"], " ", "L", " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["a", "4"], " ", 
           SuperscriptBox["\[ExponentialE]", "T"], " ", "f", " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["g", "2"], " ", 
           SuperscriptBox["j", "3"], " ", "Lr", " ", 
           SuperscriptBox["r", "5"]}], "+", 
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "fr", " ", "j", " ", "L", " ", "r"}], "+", 
             RowBox[{"f", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "j", " ", "L"}], "+", 
                RowBox[{"jr", " ", "L", " ", "r"}], "+", 
                RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "fr", " ", "j", " ", "L", " ", "r"}], "+", 
             RowBox[{"f", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "j", " ", "L"}], "+", 
                RowBox[{"jr", " ", "L", " ", "r"}], "+", 
                RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "4"], " ", 
           SuperscriptBox["\[ExponentialE]", "S"], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["g", "2"], " ", 
           SuperscriptBox["j", "2"], " ", 
           SuperscriptBox["r", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "fr", " ", "j", " ", "L", " ", "r"}], "+", 
             RowBox[{"f", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "j", " ", "L"}], "+", 
                RowBox[{"jr", " ", "L", " ", "r"}], "+", 
                RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{"16", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
           SuperscriptBox["r", "3"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "fr", " ", "j", " ", "L"}], "+", 
             RowBox[{"f", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "3"}], " ", "jr", " ", "L"}], "+", 
                RowBox[{"j", " ", 
                 RowBox[{"(", 
                  RowBox[{"Lr", "+", 
                   RowBox[{"8", " ", "A", " ", "L", " ", "r"}]}], ")"}]}]}], 
               ")"}]}]}], ")"}]}], "-", 
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "fr", " ", "j", " ", "L", " ", "r"}], 
             "+", 
             RowBox[{"f", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "jr"}], " ", "L", " ", "r"}], "+", 
                RowBox[{"j", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "8"}], " ", "L"}], "+", 
                   RowBox[{"Lr", " ", "r"}], "+", 
                   RowBox[{"4", " ", "A", " ", "L", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
            ")"}]}]}], ")"}]}]}]}], ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "-", 
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "S", "-", "T"}]], " ", "f", " ", 
       "j", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"64", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"3", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "T"}], ")"}]}]], " ", "f", 
          " ", "Lr"}], "-", 
         RowBox[{"64", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "f", " ", "Lr"}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "T"}], ")"}]}]], " ", "F", 
          " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", "r"}], "+", 
         RowBox[{
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["g", "2"], " ", "j", " ", "La", " ", 
          SuperscriptBox["r", "3"]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "f", " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"Lr", "+", 
            RowBox[{"A", " ", "L", " ", "r"}]}], ")"}]}]}], ")"}]}], 
      RowBox[{
       SuperscriptBox["L", "2"], " ", 
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "16"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"a", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "A"}], " ", 
           SuperscriptBox["r", "2"]}], "-", "T"}]], " ", "f", " ", "g", " ", 
        "j", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"64", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "La"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "j", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "ga", " ", 
              "L"}], "+", 
             RowBox[{
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "g", 
              " ", "La"}]}], ")"}], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "3"], " ", "f", " ", 
           SuperscriptBox["F", "3"], " ", "g", " ", 
           SuperscriptBox["j", "2"], " ", "Lr", " ", 
           SuperscriptBox["r", "3"]}], "+", 
          RowBox[{"8", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "F", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "f", " ", "j", 
              " ", "Lr", " ", "r"}], "+", 
             RowBox[{"F", " ", "g", " ", "j", " ", "L", " ", 
              SuperscriptBox["r", "2"]}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "f", 
              " ", "L", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"jr", " ", "r"}], "+", 
                RowBox[{"j", " ", 
                 RowBox[{"(", 
                  RowBox[{"2", "-", 
                   RowBox[{"4", " ", "A", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
            ")"}]}]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["L", "2"], " ", "r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "16"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"16", " ", 
        SuperscriptBox["L", "2"], " ", 
        SuperscriptBox["r", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "16"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "A"}], " ", 
          SuperscriptBox["r", "2"]}], "-", "S", "-", "T"}]], " ", "f", " ", 
       "j", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4096"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "S"}], "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "f", " ", "Lr"}], "+", 
         RowBox[{"1024", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"3", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", 
            RowBox[{"3", " ", "T"}]}]], " ", "f", " ", "Lr"}], "+", 
         RowBox[{"3072", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"3", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", 
            RowBox[{"3", " ", "T"}]}]], " ", "f", " ", "Lr"}], "+", 
         RowBox[{"768", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]], 
          " ", "F", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", "r"}], "+", 
         RowBox[{"256", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]}]], 
          " ", "F", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", "r"}], "-", 
         RowBox[{"384", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "f", " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", "Lr", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "S"}]}]], " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["g", "2"], " ", "j", " ", "La", " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"96", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
          SuperscriptBox["F", "3"], " ", "g", " ", "j", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"12", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", "S"], " ", "f", " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["j", "2"], " ", "Lr", " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "f", " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["j", "2"], " ", "Lr", " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["F", "5"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["j", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "5"]}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "f", " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "Lr"}], "+", 
            RowBox[{"A", " ", "L", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     FractionBox[
      RowBox[{"2", " ", "a", " ", "f", " ", "F", " ", "g", " ", "j", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "Lr"}], 
         "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"jr", " ", "L", " ", "r"}], "+", 
            RowBox[{"j", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "L"}], "+", 
               RowBox[{"Lr", " ", "r"}], "-", 
               RowBox[{"2", " ", "A", " ", "L", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
      RowBox[{
       SuperscriptBox["L", "2"], " ", "r", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "16"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"8", " ", "a", " ", 
         SuperscriptBox["L", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "16"}], " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "S"}], "-", "T"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"256", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "g", " ", "La"}], "+", 
          RowBox[{"256", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "g", " ", "La"}], "+", 
          RowBox[{"256", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"ga", " ", "L"}], "-", 
             RowBox[{"g", " ", "La"}]}], ")"}]}], "+", 
          RowBox[{"768", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "g", " ", "L"}], "+", 
             RowBox[{"a", " ", "ga", " ", "L"}], "+", 
             RowBox[{"a", " ", "g", " ", "La"}]}], ")"}]}], "-", 
          RowBox[{"16", " ", 
           SuperscriptBox["a", "3"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["g", "2"], " ", "j", " ", "La", " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["a", "3"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["g", "2"], " ", "j", " ", "La", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["a", "3"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "ga"}], " ", "L"}], "+", 
             RowBox[{"g", " ", "La"}]}], ")"}], " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"96", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "g", " ", "L"}], "+", 
             RowBox[{"a", " ", "ga", " ", "L"}], "+", 
             RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "5"], " ", 
           SuperscriptBox["\[ExponentialE]", "S"], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["g", "3"], " ", 
           SuperscriptBox["j", "2"], " ", "La", " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["a", "4"], " ", 
           SuperscriptBox["\[ExponentialE]", "T"], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["g", "2"], " ", 
           SuperscriptBox["j", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "g", " ", "L"}], "+", 
             RowBox[{"a", " ", "ga", " ", "L"}], "+", 
             RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["a", "4"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"S", "+", "T"}]], " ", "f", " ", 
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["g", "2"], " ", "j", " ", 
           SuperscriptBox["r", "3"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "jr", " ", "L"}], "-", 
             RowBox[{"3", " ", "j", " ", "Lr"}], "+", 
             RowBox[{"4", " ", "A", " ", "j", " ", "L", " ", "r"}]}], ")"}]}],
           "-", 
          RowBox[{"128", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", "f", " ", "F", " ", 
           "g", " ", "j", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", "L"}], "-", 
             RowBox[{"3", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], 
     ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "a", " ", "f", " ", "g", " ", "j", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "16"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "Lr"}], 
          "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "r", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"jr", " ", "L", " ", "r"}], "+", 
             RowBox[{"j", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "L"}], "+", 
                RowBox[{"Lr", " ", "r"}], "-", 
                RowBox[{"2", " ", "A", " ", "L", " ", 
                 SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       RowBox[{
        SuperscriptBox["L", "2"], " ", "r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "16"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", "0"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"8", " ", 
         SuperscriptBox["L", "2"], " ", "r", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "16"}], " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "S"}], "-", "T"}]], " ", "f", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", "f", " ", "j", " ", "Lr", " ", 
           "r"}], "+", 
          RowBox[{"768", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", "f", " ", "j", " ", "Lr", " ", 
           "r"}], "+", 
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "fr", " ", "j", " ", "L"}], "+", 
             RowBox[{"f", " ", "jr", " ", "L"}], "-", 
             RowBox[{"f", " ", "j", " ", "Lr"}]}], ")"}], " ", "r"}], "-", 
          RowBox[{"128", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", "F", " ", "g", " ", 
           "j", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", "L"}], "-", 
             RowBox[{"3", " ", "a", " ", "La"}]}], ")"}], " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"16", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "f", " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["j", "2"], " ", "Lr", " ", 
           SuperscriptBox["r", "3"]}], "-", 
          RowBox[{"96", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "f", " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["j", "2"], " ", "Lr", " ", 
           SuperscriptBox["r", "3"]}], "-", 
          RowBox[{"16", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "fr", " ", "j", " ", "L"}], "+", 
             RowBox[{"f", " ", "jr", " ", "L"}], "-", 
             RowBox[{"f", " ", "j", " ", "Lr"}]}], ")"}], " ", 
           SuperscriptBox["r", "3"]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["a", "3"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"S", "+", "T"}]], " ", 
           SuperscriptBox["F", "3"], " ", "g", " ", 
           SuperscriptBox["j", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", "a", " ", "B", " ", "g", " ", "L"}], "-", 
             RowBox[{"2", " ", "ga", " ", "L"}], "-", 
             RowBox[{"3", " ", "g", " ", "La"}]}], ")"}], " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["a", "4"], " ", 
           SuperscriptBox["\[ExponentialE]", "T"], " ", "f", " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["g", "2"], " ", 
           SuperscriptBox["j", "3"], " ", "Lr", " ", 
           SuperscriptBox["r", "5"]}], "+", 
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "fr", " ", "j", " ", "L", " ", "r"}], "+", 
             RowBox[{"f", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "j", " ", "L"}], "+", 
                RowBox[{"jr", " ", "L", " ", "r"}], "+", 
                RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "fr", " ", "j", " ", "L", " ", "r"}], "+", 
             RowBox[{"f", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "j", " ", "L"}], "+", 
                RowBox[{"jr", " ", "L", " ", "r"}], "+", 
                RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "4"], " ", 
           SuperscriptBox["\[ExponentialE]", "S"], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["g", "2"], " ", 
           SuperscriptBox["j", "2"], " ", 
           SuperscriptBox["r", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "fr", " ", "j", " ", "L", " ", "r"}], "+", 
             RowBox[{"f", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "j", " ", "L"}], "+", 
                RowBox[{"jr", " ", "L", " ", "r"}], "+", 
                RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}]}], 
         ")"}]}]}]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "f", " ", "g", " ", "j", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "16"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "La"}], 
          "+", 
          RowBox[{"a", " ", 
           SuperscriptBox["F", "2"], " ", "j", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", " ", "ga", " ", "L"}], "+", 
             RowBox[{"g", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "L"}], "-", 
                RowBox[{"2", " ", 
                 SuperscriptBox["a", "2"], " ", "B", " ", "L"}], "+", 
                RowBox[{"a", " ", "La"}]}], ")"}]}]}], ")"}], " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       RowBox[{"a", " ", 
        SuperscriptBox["L", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "16"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     FractionBox[
      RowBox[{"2", " ", "f", " ", "F", " ", "g", " ", "j", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "La"}], 
         "+", 
         RowBox[{"a", " ", 
          SuperscriptBox["F", "2"], " ", "j", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"g", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "L"}], "-", 
               RowBox[{"2", " ", 
                SuperscriptBox["a", "2"], " ", "B", " ", "L"}], "+", 
               RowBox[{"a", " ", "La"}]}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      RowBox[{"a", " ", 
       SuperscriptBox["L", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "16"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"16", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["L", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "16"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "2"]}], " ", "B"}], "-", "S", "-", "T"}]], " ",
        "g", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1024"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]]}], "-", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S"}]], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "T"}]]}]}], ")"}], " ", 
          "La"}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["\[ExponentialE]", "T"]}]}], ")"}], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", "La", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], "-", 
            SuperscriptBox["\[ExponentialE]", "T"]}], ")"}], " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["j", "2"], " ", "La", " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["a", "5"], " ", 
          SuperscriptBox["F", "5"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["j", "2"], " ", 
          SuperscriptBox["r", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "fr", " ", "j", " ", "L", " ", "r"}], "+", 
            RowBox[{"f", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "j", " ", "L"}], "+", 
               RowBox[{"jr", " ", "L", " ", "r"}], "+", 
               RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"256", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", "F", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}]], " ", "fr", " ", "j", " ", "L", 
             " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}]]}], ")"}], " ", "f", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "j", " ", "L"}], "+", 
               RowBox[{"jr", " ", "L", " ", "r"}], "+", 
               RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", "B", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", "S", "+", "T"}]], 
             " ", "L"}], "-", 
            RowBox[{"F", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["\[ExponentialE]", "T"]}], " ", "f", " ", "j",
                 " ", "Lr", " ", "r"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "f", " ", "j", " ", "L"}], "+", 
                  RowBox[{"2", " ", "fr", " ", "j", " ", "L", " ", "r"}], "+", 
                  RowBox[{"f", " ", "jr", " ", "L", " ", "r"}], "+", 
                  RowBox[{"f", " ", "j", " ", "Lr", " ", "r"}]}], ")"}]}]}], 
              ")"}]}]}], ")"}]}]}], ")"}]}]}], ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "2"]}], " ", "B"}], "+", 
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "-", "S", "+", "T"}]], " ", "g", " ", 
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"64", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}], ")"}]}]], 
          " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], "-", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "T"}]]}], ")"}], " ", "La"}], 
         "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", "La", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"16", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}], ")"}]}]], 
          " ", "f", " ", "F", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "j", " ", "L"}], "+", 
            RowBox[{"jr", " ", "L", " ", "r"}], "+", 
            RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", "B", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "L"}],
             "+", 
            RowBox[{"f", " ", "F", " ", "j", " ", "Lr", " ", "r"}]}], 
           ")"}]}]}], ")"}]}], 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["L", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "16"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"8", " ", "a", " ", 
        SuperscriptBox["L", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "16"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "S"}], "-", "T"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "256"}], " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "S"}], "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "g", " ", "La"}], "-", 
         RowBox[{"256", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "S"}], "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "g", " ", "La"}], "-", 
         RowBox[{"768", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", 
            RowBox[{"3", " ", "T"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}]}], "+", 
         RowBox[{"256", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", 
            RowBox[{"3", " ", "T"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "a"}], " ", "ga", " ", "L"}], "+", 
            RowBox[{"g", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", 
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", "B"}]}], ")"}], " ", "L"}], 
               "+", 
               RowBox[{"a", " ", "La"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"3", " ", "T"}]}]], " ", "f", " ", "F", " ", "g", " ", 
          "j", " ", "Lr", " ", "r"}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", "f", " ", "F", " ", 
          "g", " ", "j", " ", "Lr", " ", "r"}], "+", 
         RowBox[{"48", " ", 
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["g", "2"], " ", "j", " ", "La", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"32", " ", 
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["g", "2"], " ", "j", " ", "La", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", "a", " ", "B", " ", "g", " ", "L"}], "-", 
            RowBox[{"3", " ", "ga", " ", "L"}], "+", 
            RowBox[{"g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"96", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["a", "5"], " ", 
          SuperscriptBox["\[ExponentialE]", "S"], " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "3"], " ", 
          SuperscriptBox["j", "2"], " ", "La", " ", 
          SuperscriptBox["r", "4"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", "T"], " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["j", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"S", "+", "T"}]], " ", "f", " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["g", "2"], " ", "j", " ", "L", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "j"}], "+", 
            RowBox[{"jr", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["a", "2"]}], " ", "B"}], "-", "S"}]], " ", "g", 
        " ", "j", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"64", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "f", " ", "Lr"}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "F", 
           " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["a", "2"], " ", "B"}]}], ")"}], " ", "g"}], 
             "-", 
             RowBox[{"a", " ", "ga"}]}], ")"}], " ", "L", " ", "r"}], "+", 
          RowBox[{"16", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}], ")"}]}]], 
           " ", "F", " ", "g", " ", "La", " ", "r"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "f", " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", "Lr", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "3"], " ", 
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["g", "2"], " ", "j", " ", "La", " ", 
           SuperscriptBox["r", "3"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "f", 
           " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "L", " ", "r", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "j"}], "+", 
             RowBox[{"jr", " ", "r"}]}], ")"}]}]}], ")"}]}], 
       RowBox[{"2", " ", "a", " ", 
        SuperscriptBox["L", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "16"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"16", " ", 
        SuperscriptBox["a", "3"], " ", 
        SuperscriptBox["L", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "16"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "2"]}], " ", "B"}], "-", 
         RowBox[{"2", " ", "S"}]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3072", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "S"}], "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}]}], "+", 
         RowBox[{"1024", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "S"}], "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "3"}], " ", "a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"g", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "6"}], " ", "L"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["a", "2"], " ", "B", " ", "L"}], "-", 
               RowBox[{"3", " ", "a", " ", "La"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"768", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]], 
          " ", "f", " ", "F", " ", "g", " ", "j", " ", "Lr", " ", "r"}], "+", 
         RowBox[{"512", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "S"}], "+", "T"}]], " ", "f", " ", "F", " ", 
          "g", " ", "j", " ", "Lr", " ", "r"}], "+", 
         RowBox[{"256", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]}]], 
          " ", "f", " ", "F", " ", "g", " ", "j", " ", "Lr", " ", "r"}], "+", 
         RowBox[{"64", " ", 
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"3", " ", "S"}]}]], " ", 
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["g", "2"], " ", "j", " ", "La", " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{"384", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"64", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"g", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"8", " ", "L"}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox["a", "2"], " ", "B", " ", "L"}], "+", 
               RowBox[{"7", " ", "a", " ", "La"}]}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{"96", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["j", "2"], " ", "Lr", " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"12", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", "S"], " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["j", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["j", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["a", "6"], " ", "f", " ", 
          SuperscriptBox["F", "5"], " ", 
          SuperscriptBox["g", "3"], " ", 
          SuperscriptBox["j", "3"], " ", "Lr", " ", 
          SuperscriptBox["r", "5"]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "S"}]}]], " ", "f", " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["g", "2"], " ", "j", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "j", " ", "L"}], "+", 
            RowBox[{"jr", " ", "L", " ", "r"}], "-", 
            RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", 
       RowBox[{"8", " ", "a", " ", 
        SuperscriptBox["L", "2"], " ", "r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "16"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "T"}]], " ", "f", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1024", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "S"}], "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}]]}], ")"}], " ", "La"}], "-", 
         RowBox[{"128", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
          SuperscriptBox["F", "2"], " ", "j", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "g", 
             " ", "La"}], "+", 
            RowBox[{
             SuperscriptBox["\[ExponentialE]", "T"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"ga", " ", "L"}], "-", 
               RowBox[{"g", " ", "La"}]}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], "-", 
            SuperscriptBox["\[ExponentialE]", "T"]}], ")"}], " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["j", "2"], " ", "La", " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["a", "5"], " ", 
          SuperscriptBox["F", "5"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["j", "2"], " ", 
          SuperscriptBox["r", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "fr", " ", "j", " ", "L", " ", "r"}], "+", 
            RowBox[{"f", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "j", " ", "L"}], "+", 
               RowBox[{"jr", " ", "L", " ", "r"}], "+", 
               RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"256", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "F"}], " ", "g", " ", "j", " ", "L", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "f", 
             " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "j", " ", "L"}], "+", 
               RowBox[{"jr", " ", "L", " ", "r"}], "+", 
               RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S"}]], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "fr", " ", "j", " ", "L", " ", "r"}], "+", 
               RowBox[{"f", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "j", " ", "L"}], "+", 
                  RowBox[{"jr", " ", "L", " ", "r"}], "+", 
                  RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"24", " ", "B", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", "S", "+", "T"}]], 
             " ", "L"}], "-", 
            RowBox[{"F", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["\[ExponentialE]", "T"]}], " ", "f", " ", "j",
                 " ", "Lr", " ", "r"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "f", " ", "j", " ", "L"}], "+", 
                  RowBox[{"2", " ", "fr", " ", "j", " ", "L", " ", "r"}], "+", 
                  RowBox[{"f", " ", "jr", " ", "L", " ", "r"}], "+", 
                  RowBox[{"f", " ", "j", " ", "Lr", " ", "r"}]}], ")"}]}]}], 
              ")"}]}]}], ")"}]}]}], ")"}]}]}], ",", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "f", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"64", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}], ")"}]}]], 
          " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], "+", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "T"}]]}], ")"}], " ", "La"}], 
         "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
          SuperscriptBox["F", "2"], " ", "ga", " ", "j", " ", "L", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"24", " ", "B", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "L"}],
             "+", 
            RowBox[{"f", " ", "F", " ", "j", " ", "Lr", " ", "r"}]}], ")"}]}],
          "+", 
         RowBox[{"16", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "F", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "F"}], " ", "g", " ", "j", " ", "L", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "f", 
             " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "j", " ", "L"}], "+", 
               RowBox[{"jr", " ", "L", " ", "r"}], "+", 
               RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}]}], 
        ")"}]}], 
      RowBox[{"a", " ", 
       SuperscriptBox["L", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "16"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     FractionBox[
      RowBox[{"2", " ", "a", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "f", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "128"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "La"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "T"}]]}]}], ")"}], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", "La", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["a", "3"], " ", "f", " ", 
          SuperscriptBox["F", "3"], " ", "g", " ", "j", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "j", " ", "L"}], "+", 
            RowBox[{"jr", " ", "L", " ", "r"}], "+", 
            RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"16", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", "B", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "L"}],
             "+", 
            RowBox[{"f", " ", "F", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{"A", " ", 
                   SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "j", " ", 
                "Lr", " ", "r"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
                "L", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "j"}], "+", 
                  RowBox[{"jr", " ", "r"}], "-", 
                  RowBox[{"2", " ", "A", " ", "j", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], 
      RowBox[{
       SuperscriptBox["L", "2"], " ", "r", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "16"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"8", " ", 
         SuperscriptBox["L", "2"], " ", "r", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "16"}], " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "S"}], "-", "T"}]], " ", "f", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", "f", " ", "j", " ", "Lr", " ", 
           "r"}], "+", 
          RowBox[{"768", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", "f", " ", "j", " ", "Lr", " ", 
           "r"}], "+", 
          RowBox[{"128", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"3", " ", "S"}], "+", "T"}]], " ", "F", " ", "g", " ", 
           "j", " ", "La", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"128", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", "F", " ", "j", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "a"}], " ", "ga", " ", "L"}], "+", 
             RowBox[{"g", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "+", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["a", "2"], " ", "B"}]}], ")"}], " ", "L"}],
                 "+", 
                RowBox[{"a", " ", "La"}]}], ")"}]}]}], ")"}], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "f", " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["j", "2"], " ", "Lr", " ", 
           SuperscriptBox["r", "3"]}], "-", 
          RowBox[{"96", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "f", " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", 
           SuperscriptBox["j", "2"], " ", "Lr", " ", 
           SuperscriptBox["r", "3"]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["a", "4"], " ", 
           SuperscriptBox["\[ExponentialE]", "T"], " ", "f", " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["g", "2"], " ", 
           SuperscriptBox["j", "3"], " ", "Lr", " ", 
           SuperscriptBox["r", "5"]}], "+", 
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "fr", " ", "j", " ", "L", " ", "r"}], "+", 
             RowBox[{"f", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "j", " ", "L"}], "+", 
                RowBox[{"jr", " ", "L", " ", "r"}], "+", 
                RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "fr", " ", "j", " ", "L", " ", "r"}], "+", 
             RowBox[{"f", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "j", " ", "L"}], "+", 
                RowBox[{"jr", " ", "L", " ", "r"}], "+", 
                RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "4"], " ", 
           SuperscriptBox["\[ExponentialE]", "S"], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["g", "2"], " ", 
           SuperscriptBox["j", "2"], " ", 
           SuperscriptBox["r", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "fr", " ", "j", " ", "L", " ", "r"}], "+", 
             RowBox[{"f", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "j", " ", "L"}], "+", 
                RowBox[{"jr", " ", "L", " ", "r"}], "+", 
                RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "fr", " ", "j", " ", "L", " ", "r"}], 
             "+", 
             RowBox[{"f", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", "j", " ", "L"}], "+", 
                RowBox[{"jr", " ", "L", " ", "r"}], "+", 
                RowBox[{"3", " ", "j", " ", "Lr", " ", "r"}]}], ")"}]}]}], 
            ")"}]}], "-", 
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "fr", " ", "j", " ", "L", " ", "r"}], 
             "+", 
             RowBox[{"f", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "3"}], " ", "jr", " ", "L", " ", "r"}], "+", 
                RowBox[{"j", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "4"}], " ", "L"}], "+", 
                   RowBox[{"Lr", " ", "r"}], "+", 
                   RowBox[{"4", " ", "A", " ", "L", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
            ")"}]}]}], ")"}]}]}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"8", " ", 
        SuperscriptBox["a", "2"], " ", "g", " ", 
        SuperscriptBox["L", "2"], " ", "r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "16"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "S"}]], " ", "f", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3072", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "S"}], "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}]}], "+", 
         RowBox[{"1024", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "S"}], "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "3"}], " ", "a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"g", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "6"}], " ", "L"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["a", "2"], " ", "B", " ", "L"}], "-", 
               RowBox[{"5", " ", "a", " ", "La"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"768", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]], 
          " ", "f", " ", "F", " ", "g", " ", "j", " ", "Lr", " ", "r"}], "+", 
         RowBox[{"256", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]}]], 
          " ", "f", " ", "F", " ", "g", " ", "j", " ", "Lr", " ", "r"}], "+", 
         RowBox[{"64", " ", 
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"3", " ", "S"}]}]], " ", 
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["g", "2"], " ", "j", " ", "La", " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{"384", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"192", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "g", " ", "L"}], "+", 
            RowBox[{"2", " ", "a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"3", " ", "a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{"96", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "f", " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["j", "2"], " ", "Lr", " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"12", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", "S"], " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["j", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["j", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["a", "6"], " ", "f", " ", 
          SuperscriptBox["F", "5"], " ", 
          SuperscriptBox["g", "3"], " ", 
          SuperscriptBox["j", "3"], " ", "Lr", " ", 
          SuperscriptBox["r", "5"]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "S"}]}]], " ", "f", " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["g", "2"], " ", "j", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "j", " ", "L"}], "+", 
            RowBox[{"jr", " ", "L", " ", "r"}], "+", 
            RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"512", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "S"}], "+", "T"}]], " ", "f", " ", "F", " ", 
          "g", " ", "L", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "jr"}], " ", "r"}], "+", 
            RowBox[{"2", " ", "j", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}],
      ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"8", " ", "a", " ", "j", " ", 
        SuperscriptBox["L", "2"], " ", 
        SuperscriptBox["r", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "16"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "T"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "512"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"3", " ", "T"}]}]], " ", "F", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}]}], ")"}], " ", "g"}], 
            "-", 
            RowBox[{"a", " ", "ga"}]}], ")"}], " ", "j", " ", "L", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"256", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]], 
          " ", "F", " ", "g", " ", "j", " ", "La", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"256", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", "F", " ", "g", " ", 
          "j", " ", "La", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"64", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "T"}]}]], " ", "f", " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", 
          SuperscriptBox["j", "2"], " ", "Lr", " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"32", " ", 
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["j", "2"], " ", "La", " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          SuperscriptBox["F", "3"], " ", "g", " ", 
          SuperscriptBox["j", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["a", "5"], " ", 
          SuperscriptBox["F", "5"], " ", 
          SuperscriptBox["g", "3"], " ", 
          SuperscriptBox["j", "3"], " ", "La", " ", 
          SuperscriptBox["r", "6"]}], "+", 
         RowBox[{"1024", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"3", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", 
            RowBox[{"3", " ", "T"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "fr", " ", "j", " ", "L", " ", "r"}], "+", 
            RowBox[{"f", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "j", " ", "L"}], "+", 
               RowBox[{"jr", " ", "L", " ", "r"}], "+", 
               RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"128", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "fr", " ", "j", " ", "L", " ", "r"}], "+", 
            RowBox[{"f", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "j", " ", "L"}], "+", 
               RowBox[{"jr", " ", "L", " ", "r"}], "+", 
               RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", "T"], " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["j", "2"], " ", 
          SuperscriptBox["r", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "fr", " ", "j", " ", "L", " ", "r"}], "+", 
            RowBox[{"f", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "j", " ", "L"}], "+", 
               RowBox[{"jr", " ", "L", " ", "r"}], "+", 
               RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["j", "2"], " ", 
          SuperscriptBox["r", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "fr", " ", "j", " ", "L", " ", "r"}], "+", 
            RowBox[{"f", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "j", " ", "L"}], "+", 
               RowBox[{"jr", " ", "L", " ", "r"}], "+", 
               RowBox[{"j", " ", "Lr", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"64", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "fr", " ", "j", " ", "L", " ", "r"}], "+", 
            RowBox[{"f", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "j", " ", "L"}], "+", 
               RowBox[{"2", " ", "jr", " ", "L", " ", "r"}], "+", 
               RowBox[{"5", " ", "j", " ", "Lr", " ", "r"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"1024", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", 
            RowBox[{"3", " ", "T"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "fr", " ", "j", " ", "L", " ", "r"}], 
            "-", 
            RowBox[{"f", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"jr", " ", "L", " ", "r"}], "+", 
               RowBox[{"j", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "L"}], "+", 
                  RowBox[{"3", " ", "Lr", " ", "r"}], "-", 
                  RowBox[{"2", " ", "A", " ", "L", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}]}], ",", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "32"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "F", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}]}], ")"}], " ", "g"}], 
            "-", 
            RowBox[{"a", " ", "ga"}]}], ")"}], " ", "L", " ", "r"}], "+", 
         RowBox[{"16", " ", "a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}], ")"}]}]], 
          " ", "F", " ", "g", " ", "La", " ", "r"}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", "f", " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", "Lr", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "f", " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", "Lr", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["F", "3"], " ", "g", " ", "j", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"128", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "f", " ", 
          RowBox[{"(", 
           RowBox[{"Lr", "-", 
            RowBox[{"A", " ", "L", " ", "r"}]}], ")"}]}]}], ")"}]}], 
      RowBox[{"a", " ", 
       SuperscriptBox["L", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "16"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     FractionBox[
      RowBox[{"2", " ", "a", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B"}], "+", "S"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"64", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"3", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "T"}], ")"}]}]], " ", "f", 
          " ", "Lr"}], "+", 
         RowBox[{"64", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "f", " ", "Lr"}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "T"}], ")"}]}]], " ", "F", 
          " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", "r"}], "+", 
         RowBox[{
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["g", "2"], " ", "j", " ", "La", " ", 
          SuperscriptBox["r", "3"]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "f", " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "L", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "jr"}], " ", "r"}], "+", 
            RowBox[{"j", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", 
               RowBox[{"3", " ", "A", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
      RowBox[{
       SuperscriptBox["L", "2"], " ", "r", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "16"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], ",", 
     RowBox[{"-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"8", " ", "a", " ", 
         SuperscriptBox["L", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "16"}], " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", "B"}], "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "S"}], "-", "T"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"256", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "g", " ", "La"}], "+", 
          RowBox[{"256", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "g", " ", "La"}], "+", 
          RowBox[{"768", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "g", " ", "L"}], "+", 
             RowBox[{"a", " ", "ga", " ", "L"}], "+", 
             RowBox[{"a", " ", "g", " ", "La"}]}], ")"}]}], "-", 
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], " ", "a", " ", "ga", " ", "L"}], "+", 
             RowBox[{"g", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", "B"}]}], ")"}], " ", "L"}],
                 "+", 
                RowBox[{"a", " ", "La"}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"128", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"3", " ", "T"}]}]], " ", "f", " ", "F", " ", "g", " ", 
           "j", " ", "Lr", " ", "r"}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["a", "3"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["g", "2"], " ", "j", " ", "La", " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["a", "3"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["g", "2"], " ", "j", " ", "La", " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"96", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "g", " ", "L"}], "+", 
             RowBox[{"a", " ", "ga", " ", "L"}], "+", 
             RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", "g", " ", "L"}], "+", 
             RowBox[{"a", " ", "ga", " ", "L"}], "+", 
             RowBox[{"3", " ", "a", " ", "g", " ", "La"}]}], ")"}], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "5"], " ", 
           SuperscriptBox["\[ExponentialE]", "S"], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["g", "3"], " ", 
           SuperscriptBox["j", "2"], " ", "La", " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["a", "4"], " ", 
           SuperscriptBox["\[ExponentialE]", "T"], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["g", "2"], " ", 
           SuperscriptBox["j", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "g", " ", "L"}], "+", 
             RowBox[{"a", " ", "ga", " ", "L"}], "+", 
             RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"128", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", "f", " ", "F", " ", 
           "g", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "jr"}], " ", "L", " ", "r"}], "+", 
             RowBox[{"j", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Lr", " ", "r"}], "+", 
                RowBox[{"L", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "+", 
                   RowBox[{"4", " ", "A", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
            ")"}]}]}], ")"}]}]}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"8", " ", "a", " ", 
        SuperscriptBox["L", "2"], " ", "r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "16"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "2"]}]], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "S"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2048"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "S"}], "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "f", " ", "Lr"}], "+", 
         RowBox[{"1024", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"3", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", 
            RowBox[{"3", " ", "T"}]}]], " ", "f", " ", "Lr"}], "+", 
         RowBox[{"3072", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"3", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", 
            RowBox[{"3", " ", "T"}]}]], " ", "f", " ", "Lr"}], "+", 
         RowBox[{"768", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]], 
          " ", "F", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", "r"}], "+", 
         RowBox[{"256", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]}]], 
          " ", "F", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", "r"}], "-", 
         RowBox[{"384", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "f", " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", "Lr", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"2", " ", "S"}]}]], " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["g", "2"], " ", "j", " ", "La", " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"96", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
          SuperscriptBox["F", "3"], " ", "g", " ", "j", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"12", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", "S"], " ", "f", " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["j", "2"], " ", "Lr", " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "f", " ", 
          SuperscriptBox["F", "4"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["j", "2"], " ", "Lr", " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["F", "5"], " ", 
          SuperscriptBox["g", "2"], " ", 
          SuperscriptBox["j", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "L"}], "+", 
            RowBox[{"a", " ", "ga", " ", "L"}], "+", 
            RowBox[{"a", " ", "g", " ", "La"}]}], ")"}], " ", 
          SuperscriptBox["r", "5"]}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "f", " ", 
          SuperscriptBox["F", "2"], " ", "g", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "jr"}], " ", "L", " ", "r"}], "+", 
            RowBox[{"j", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", "L"}], "+", 
               RowBox[{"3", " ", "Lr", " ", "r"}], "+", 
               RowBox[{"3", " ", "A", " ", "L", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"8", " ", 
         SuperscriptBox["L", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "r"}], 
           "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["F", "2"], " ", "g", " ", "j", " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}]], 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "S"}], "-", "T"}]], " ", "f", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "f", " ", "j", " ", "Lr", " ", 
           "r"}], "+", 
          RowBox[{"48", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "f", " ", "j", " ", "Lr", " ", 
           "r"}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "B"}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "fr", " ", "j", " ", "L"}], "+", 
             RowBox[{"f", " ", "jr", " ", "L"}], "-", 
             RowBox[{"f", " ", "j", " ", "Lr"}]}], ")"}], " ", "r"}], "+", 
          RowBox[{"8", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowB