(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     93436,       2693]
NotebookOptionsPosition[     86849,       2473]
NotebookOutlinePosition[     88202,       2521]
CellTagsIndexPosition[     88130,       2516]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Dim = 5", "Subsubtitle",
 CellChangeTimes->{{3.5424689375634613`*^9, 3.542468943624091*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", "R", "]"}]], "Input",
 CellChangeTimes->{{3.54246867825386*^9, 3.5424686803456707`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"met", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["1", "R"]}], ")"}], 
    RowBox[{
     RowBox[{"Dt", "[", "t", "]"}], "^", "2"}]}], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"Dt", "[", "R", "]"}], "^", "2"}], 
    RowBox[{"1", "-", 
     FractionBox["1", "R"]}]], "+", 
   RowBox[{
    RowBox[{"R", "^", "2"}], " ", 
    RowBox[{"d\[CapitalOmega]", "^", "2"}]}]}]}]], "Input",
 CellChangeTimes->{{3.5424685613392477`*^9, 3.542468592236486*^9}, {
  3.542468954775082*^9, 3.542468957455955*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["d\[CapitalOmega]", "2"], " ", 
   SuperscriptBox["R", "2"]}], "+", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"Dt", "[", "R", "]"}], "2"], 
   RowBox[{"1", "-", 
    FractionBox["1", "R"]}]], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", 
     FractionBox["1", "R"]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"Dt", "[", "t", "]"}], "2"]}]}]], "Output",
 CellChangeTimes->{{3.542468587931896*^9, 3.542468592785099*^9}, 
   3.542468681811693*^9, {3.542468961470426*^9, 3.542468989405037*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"R", "=", 
   FractionBox["1", 
    RowBox[{"1", "-", 
     RowBox[{"r", "^", "2"}]}]]}], ";"}]], "Input",
 CellChangeTimes->{{3.542468594220639*^9, 3.5424686084838047`*^9}, {
  3.542468963051991*^9, 3.54246896547331*^9}}],

Cell[CellGroupData[{

Cell[BoxData["met"], "Input",
 CellChangeTimes->{{3.5424686098470583`*^9, 3.542468610027326*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["d\[CapitalOmega]", "2"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["r", "2"]}], ")"}], "2"]], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    SuperscriptBox[
     RowBox[{"Dt", "[", "r", "]"}], "2"]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["r", "2"]}], ")"}], "4"]], "+", 
  RowBox[{
   SuperscriptBox["r", "2"], " ", 
   SuperscriptBox[
    RowBox[{"Dt", "[", "t", "]"}], "2"]}]}]], "Output",
 CellChangeTimes->{
  3.542468610489233*^9, 3.54246868339974*^9, {3.5424689666897984`*^9, 
   3.542468990636868*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"met2", "=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       RowBox[{"f", "[", "r", "]"}], "^", "2"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"r", "^", "2"}], 
        RowBox[{
         RowBox[{"f", "[", "r", "]"}], "^", "2"}], 
        RowBox[{
         RowBox[{"Dt", "[", "t", "]"}], "^", "2"}]}], "+", 
       FractionBox[
        RowBox[{"4", 
         RowBox[{
          RowBox[{"Dt", "[", "r", "]"}], "^", "2"}]}], 
        RowBox[{
         RowBox[{"f", "[", "r", "]"}], "^", "2"}]], "+", " ", 
       RowBox[{"d\[CapitalOmega]", "^", "2"}]}], ")"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "r_", "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{"r", "^", "2"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"met", "-", "met2"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Clear", "[", 
  RowBox[{"f", ",", "R"}], "]"}]}], "Input",
 CellChangeTimes->{{3.542468637498145*^9, 3.542468732835088*^9}, {
  3.542468924553206*^9, 3.542468924841144*^9}, {3.54246897120874*^9, 
  3.542468984361513*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.5424686713405437`*^9, 3.54246873630204*^9}, {
  3.542468977509922*^9, 3.5424689911729813`*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"z", ",", "R", ",", "f", ",", "g"}], "]"}]], "Input",
 CellChangeTimes->{{3.54246877236017*^9, 3.542468775880884*^9}, {
  3.542468920519703*^9, 3.542468921407802*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"metAdS", "=", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"z", "^", "2"}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Dt", "[", "z", "]"}], "^", "2"}], "+", 
     RowBox[{
      RowBox[{"Dt", "[", "R", "]"}], "^", "2"}], "+", 
     RowBox[{
      RowBox[{"R", "^", "2"}], 
      RowBox[{"d\[CapitalOmega]", "^", "2"}]}], "-", 
     RowBox[{
      RowBox[{"Dt", "[", "t", "]"}], "^", "2"}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.542468747857313*^9, 3.542468796993431*^9}, {
  3.5424689176333323`*^9, 3.5424689178641977`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["d\[CapitalOmega]", "2"], " ", 
    SuperscriptBox["R", "2"]}], "+", 
   SuperscriptBox[
    RowBox[{"Dt", "[", "R", "]"}], "2"], "-", 
   SuperscriptBox[
    RowBox[{"Dt", "[", "t", "]"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"Dt", "[", "z", "]"}], "2"]}], 
  SuperscriptBox["z", "2"]]], "Output",
 CellChangeTimes->{3.542468798236312*^9, 3.542468927646105*^9, 
  3.542468997900627*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"z", "=", 
    FractionBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"x", "^", "2"}]}], ")"}], 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"r", "^", "2"}]}], ")"}]]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R", "=", 
   RowBox[{"x", " ", 
    FractionBox[
     RowBox[{"Sqrt", "[", 
      RowBox[{"2", "-", 
       RowBox[{"x", "^", "2"}]}], "]"}], 
     RowBox[{"1", "-", 
      RowBox[{"r", "^", "2"}]}]]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5424688006951838`*^9, 3.542468824057055*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "metAdS", "]"}]], "Input",
 CellChangeTimes->{{3.542468826362404*^9, 3.5424688327204*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"4", " ", 
    SuperscriptBox["r", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      SuperscriptBox["x", "2"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Dt", "[", "r", "]"}], "2"]}], "-", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["d\[CapitalOmega]", "2"], " ", 
       SuperscriptBox["x", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", 
          SuperscriptBox["x", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         SuperscriptBox["x", "2"]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"Dt", "[", "t", "]"}], "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"Dt", "[", "x", "]"}], "2"]}]}], ")"}]}]}], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     SuperscriptBox["x", "2"]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["x", "2"]}], ")"}], "2"]}]]], "Output",
 CellChangeTimes->{{3.542468828925357*^9, 3.5424688331594887`*^9}, 
   3.5424689293488417`*^9, 3.542468999350233*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"metAdS2", "=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"x", "^", "2"}]}], ")"}], "^", "2"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{
          RowBox[{"f", "[", "r", "]"}], "^", "2"}]}], 
        RowBox[{
         RowBox[{"Dt", "[", "t", "]"}], "^", "2"}]}], "+", 
       FractionBox[
        RowBox[{"4", 
         RowBox[{"r", "^", "2"}], 
         RowBox[{
          RowBox[{"Dt", "[", "r", "]"}], "^", "2"}]}], 
        RowBox[{
         RowBox[{"f", "[", "r", "]"}], "^", "2"}]], "+", 
       RowBox[{
        FractionBox["4", 
         RowBox[{"g", "[", "x", "]"}]], 
        RowBox[{
         RowBox[{"Dt", "[", "x", "]"}], "^", "2"}]}], "+", 
       RowBox[{
        RowBox[{"x", "^", "2"}], 
        RowBox[{"g", "[", "x", "]"}], " ", 
        RowBox[{"d\[CapitalOmega]", "^", "2"}]}]}], ")"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "r_", "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{"r", "^", "2"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", "x_", "]"}], ":=", 
   RowBox[{"2", "-", 
    RowBox[{"x", "^", "2"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"metAdS", "-", "metAdS2"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Clear", "[", "f", "]"}]}], "Input",
 CellChangeTimes->{{3.542468848515709*^9, 3.5424689112505407`*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.542468913142782*^9, 3.54246893030013*^9}, 
   3.542469000037732*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dim = 6", "Subsubtitle",
 CellChangeTimes->{{3.5424689375634613`*^9, 3.542468947655562*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", "R", "]"}]], "Input",
 CellChangeTimes->{{3.54246867825386*^9, 3.5424686803456707`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"met", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["1", 
       RowBox[{"R", "^", "2"}]]}], ")"}], 
    RowBox[{
     RowBox[{"Dt", "[", "t", "]"}], "^", "2"}]}], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"Dt", "[", "R", "]"}], "^", "2"}], 
    RowBox[{"1", "-", 
     FractionBox["1", 
      RowBox[{"R", "^", "2"}]]}]], "+", 
   RowBox[{
    RowBox[{"R", "^", "2"}], " ", 
    RowBox[{"d\[CapitalOmega]", "^", "2"}]}]}]}]], "Input",
 CellChangeTimes->{{3.5424685613392477`*^9, 3.542468592236486*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["d\[CapitalOmega]", "2"], " ", 
   SuperscriptBox["R", "2"]}], "+", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"Dt", "[", "R", "]"}], "2"], 
   RowBox[{"1", "-", 
    FractionBox["1", 
     SuperscriptBox["R", "2"]]}]], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", 
     FractionBox["1", 
      SuperscriptBox["R", "2"]]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"Dt", "[", "t", "]"}], "2"]}]}]], "Output",
 CellChangeTimes->{{3.542468587931896*^9, 3.542468592785099*^9}, 
   3.542468681811693*^9, 3.542469034659177*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"R", "=", 
   FractionBox["1", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", "-", 
      RowBox[{"r", "^", "2"}]}], "]"}]]}], ";"}]], "Input",
 CellChangeTimes->{{3.542468594220639*^9, 3.5424686084838047`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["met"], "Input",
 CellChangeTimes->{{3.5424686098470583`*^9, 3.542468610027326*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["d\[CapitalOmega]", "2"], 
   RowBox[{"1", "-", 
    SuperscriptBox["r", "2"]}]], "+", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"Dt", "[", "r", "]"}], "2"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["r", "2"]}], ")"}], "3"]], "+", 
  RowBox[{
   SuperscriptBox["r", "2"], " ", 
   SuperscriptBox[
    RowBox[{"Dt", "[", "t", "]"}], "2"]}]}]], "Output",
 CellChangeTimes->{3.542468610489233*^9, 3.54246868339974*^9, 
  3.5424690363078413`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"met2", "=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"f", "[", "r", "]"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"r", "^", "2"}], 
        RowBox[{"f", "[", "r", "]"}], 
        RowBox[{
         RowBox[{"Dt", "[", "t", "]"}], "^", "2"}]}], "+", 
       FractionBox[
        RowBox[{
         RowBox[{"Dt", "[", "r", "]"}], "^", "2"}], 
        RowBox[{
         RowBox[{"f", "[", "r", "]"}], "^", "2"}]], "+", " ", 
       RowBox[{"d\[CapitalOmega]", "^", "2"}]}], ")"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "r_", "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{"r", "^", "2"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"met", "-", "met2"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Clear", "[", 
  RowBox[{"f", ",", "R"}], "]"}]}], "Input",
 CellChangeTimes->{{3.542468637498145*^9, 3.542468732835088*^9}, {
  3.542468924553206*^9, 3.542468924841144*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.5424686713405437`*^9, 3.54246873630204*^9}, 
   3.542469036910452*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"z", ",", "R", ",", "f", ",", "g"}], "]"}]], "Input",
 CellChangeTimes->{{3.54246877236017*^9, 3.542468775880884*^9}, {
  3.542468920519703*^9, 3.542468921407802*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"metAdS", "=", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"z", "^", "2"}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Dt", "[", "z", "]"}], "^", "2"}], "+", 
     RowBox[{
      RowBox[{"Dt", "[", "R", "]"}], "^", "2"}], "+", 
     RowBox[{
      RowBox[{"R", "^", "2"}], 
      RowBox[{"d\[CapitalOmega]", "^", "2"}]}], "-", 
     RowBox[{
      RowBox[{"Dt", "[", "t", "]"}], "^", "2"}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.542468747857313*^9, 3.542468796993431*^9}, {
  3.5424689176333323`*^9, 3.5424689178641977`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["d\[CapitalOmega]", "2"], " ", 
    SuperscriptBox["R", "2"]}], "+", 
   SuperscriptBox[
    RowBox[{"Dt", "[", "R", "]"}], "2"], "-", 
   SuperscriptBox[
    RowBox[{"Dt", "[", "t", "]"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"Dt", "[", "z", "]"}], "2"]}], 
  SuperscriptBox["z", "2"]]], "Output",
 CellChangeTimes->{
  3.542468798236312*^9, 3.542468927646105*^9, 3.542469038396502*^9, {
   3.542469078442212*^9, 3.5424691133608294`*^9}}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"z", "=", 
    FractionBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"x", "^", "2"}]}], ")"}], 
     RowBox[{"Sqrt", "[", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"r", "^", "2"}]}], ")"}], "]"}]]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R", "=", 
   RowBox[{"x", " ", 
    FractionBox[
     RowBox[{"Sqrt", "[", 
      RowBox[{"2", "-", 
       RowBox[{"x", "^", "2"}]}], "]"}], 
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "-", 
       RowBox[{"r", "^", "2"}]}], "]"}]]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5424688006951838`*^9, 3.542468824057055*^9}, {
  3.542469071615794*^9, 3.542469074678821*^9}, {3.542469117174827*^9, 
  3.542469119222418*^9}, {3.54246937503799*^9, 3.542469377349967*^9}, {
  3.54246950597675*^9, 3.542469508872629*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 FractionBox[
  RowBox[{"R", "^", "2"}], 
  RowBox[{"z", "^", "2"}]]], "Input",
 CellChangeTimes->{{3.542469264226233*^9, 3.54246926656905*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"2", "-", 
     SuperscriptBox["x", "2"]}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}], ")"}], "2"]]], "Output",
 CellChangeTimes->{3.542469267679927*^9, 3.542469378866371*^9, 
  3.542469510578093*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "metAdS", "]"}]], "Input",
 CellChangeTimes->{{3.542468826362404*^9, 3.5424688327204*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["r", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      SuperscriptBox["x", "2"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"Dt", "[", "r", "]"}], "2"]}], "-", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["d\[CapitalOmega]", "2"], " ", 
       SuperscriptBox["x", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", 
          SuperscriptBox["x", "2"]}], ")"}], "2"]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         SuperscriptBox["x", "2"]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"Dt", "[", "t", "]"}], "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"Dt", "[", "x", "]"}], "2"]}]}], ")"}]}]}], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     SuperscriptBox["x", "2"]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["x", "2"]}], ")"}], "2"]}]]], "Output",
 CellChangeTimes->{{3.542468828925357*^9, 3.5424688331594887`*^9}, 
   3.5424689293488417`*^9, 3.5424690402208643`*^9, {3.542469080035535*^9, 
   3.542469120540991*^9}, 3.542469380771676*^9, 3.542469511307975*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"metAdS2", "=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"x", "^", "2"}]}], ")"}], "^", "2"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"f", "[", "r", "]"}]}], 
        RowBox[{
         RowBox[{"Dt", "[", "t", "]"}], "^", "2"}]}], "+", 
       FractionBox[
        RowBox[{" ", 
         RowBox[{
          RowBox[{"r", "^", "2"}], 
          RowBox[{
           RowBox[{"Dt", "[", "r", "]"}], "^", "2"}]}]}], 
        RowBox[{
         RowBox[{"f", "[", "r", "]"}], "^", "2"}]], "+", 
       RowBox[{
        FractionBox["4", 
         RowBox[{"g", "[", "x", "]"}]], 
        RowBox[{
         RowBox[{"Dt", "[", "x", "]"}], "^", "2"}]}], "+", " ", 
       RowBox[{
        RowBox[{"x", "^", "2"}], 
        RowBox[{"g", "[", "x", "]"}], " ", 
        RowBox[{"d\[CapitalOmega]", "^", "2"}]}]}], ")"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "r_", "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{"r", "^", "2"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", "x_", "]"}], ":=", 
   RowBox[{"2", "-", 
    RowBox[{"x", "^", "2"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"metAdS", "-", "metAdS2"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Clear", "[", 
  RowBox[{"f", ",", "g"}], "]"}]}], "Input",
 CellChangeTimes->{{3.542468848515709*^9, 3.5424689112505407`*^9}, {
  3.5424690872816343`*^9, 3.542469135647924*^9}, {3.542469415179956*^9, 
  3.5424695320326233`*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.542468913142782*^9, 3.54246893030013*^9}, 
   3.542469041434691*^9, {3.54246908236005*^9, 3.542469136038044*^9}, {
   3.542469407404006*^9, 3.542469532548642*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["RS **6d**", "Subtitle",
 CellChangeTimes->{{3.408796983010241*^9, 3.408796989128707*^9}, {
  3.415942197687789*^9, 3.415942199707787*^9}, {3.428318203595373*^9, 
  3.4283182110266533`*^9}, {3.4318556687961187`*^9, 3.431855668994246*^9}, {
  3.495174647742872*^9, 3.460515504326817*^9}, {3.503996600043788*^9, 
  3.503996603042028*^9}, {3.54247054384832*^9, 3.542470547950636*^9}, {
  3.542476697777088*^9, 3.5424766978801613`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", "\"\<hmm\>\"", "]"}]], "Input"],

Cell[BoxData["\<\"hmm\"\>"], "Print",
 CellChangeTimes->{
  3.50331095224676*^9, {3.503311334781259*^9, 3.460515672230812*^9}, 
   3.503997004484676*^9, 3.503997193150251*^9, 3.503997258578888*^9, 
   3.504000113069686*^9, 3.517303168099127*^9, 3.5175791605471287`*^9, 
   3.517643108435388*^9, 3.517650907255109*^9, 3.517658628720002*^9, 
   3.517658688981691*^9, 3.517660935926754*^9, 3.51782364066553*^9, 
   3.517823671412335*^9, 3.517824229188287*^9, {3.517825902545436*^9, 
   3.46038825031455*^9}, 3.460392629312698*^9, 3.460392745837037*^9, 
   3.4603966818363*^9, 3.4603979115528307`*^9, {3.460444070657011*^9, 
   3.4603567749901543`*^9}, 3.460366838380539*^9, 3.460372534611771*^9, 
   3.539782997335884*^9, 3.5397851396635227`*^9, 3.539868423697628*^9, 
   3.539873662402772*^9, 3.542469992334106*^9, 3.5424766349539423`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRSetup2.nb - modified", "Subsubtitle",
 CellChangeTimes->{{3.478330969800351*^9, 3.478330971159855*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Latest", " ", "Version"}], " ", "*)"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"{", 
    RowBox[{
    "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
     "gzz"}], "}"}]}], "\n"}], "\n", 
 RowBox[{"Gd", "=", 
  RowBox[{"DiagonalMatrix", "[", "metric", "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
   "gzz"}], "}"}]], "Output",
 CellChangeTimes->{
  3.503310952791863*^9, {3.503311335284086*^9, 3.460515672380575*^9}, 
   3.503997004769865*^9, 3.503997193436174*^9, 3.5039972588799763`*^9, 
   3.504000113304111*^9, 3.5173031683490477`*^9, 3.5175791607200947`*^9, 
   3.517643108635914*^9, 3.517650907530168*^9, 3.517658628986102*^9, 
   3.5176586892509327`*^9, 3.517660936106361*^9, 3.517823641023736*^9, 
   3.517823671828333*^9, 3.517824229417685*^9, {3.5178259026967983`*^9, 
   3.4603882504778843`*^9}, 3.4603926295278473`*^9, 3.4603927460334044`*^9, 
   3.4603966820091333`*^9, 3.460397911729974*^9, {3.4604440708698473`*^9, 
   3.460356775156495*^9}, 3.4603668385912523`*^9, 3.460372534854219*^9, 
   3.5397829977463493`*^9, 3.539785139995511*^9, 3.539868423973227*^9, 
   3.539873662654141*^9, 3.542469992403655*^9, 3.542476635277412*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"gtt", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "grr", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "g\[Theta]\[Theta]", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "g\[Phi]\[Phi]", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "gzz"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.503310952791863*^9, {3.503311335284086*^9, 3.460515672380575*^9}, 
   3.503997004769865*^9, 3.503997193436174*^9, 3.5039972588799763`*^9, 
   3.504000113304111*^9, 3.5173031683490477`*^9, 3.5175791607200947`*^9, 
   3.517643108635914*^9, 3.517650907530168*^9, 3.517658628986102*^9, 
   3.5176586892509327`*^9, 3.517660936106361*^9, 3.517823641023736*^9, 
   3.517823671828333*^9, 3.517824229417685*^9, {3.5178259026967983`*^9, 
   3.4603882504778843`*^9}, 3.4603926295278473`*^9, 3.4603927460334044`*^9, 
   3.4603966820091333`*^9, 3.460397911729974*^9, {3.4604440708698473`*^9, 
   3.460356775156495*^9}, 3.4603668385912523`*^9, 3.460372534854219*^9, 
   3.5397829977463493`*^9, 3.539785139995511*^9, 3.539868423973227*^9, 
   3.539873662654141*^9, 3.542469992403655*^9, 3.5424766352800922`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Gd", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", "grt"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Gd", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "1"}], "]"}], "]"}], "=", "grt"}]}], "Input"],

Cell[BoxData["grt"], "Output",
 CellChangeTimes->{
  3.50331095292629*^9, {3.503311335372411*^9, 3.460515672510242*^9}, 
   3.503997004841145*^9, 3.503997193508582*^9, 3.5039972589761143`*^9, 
   3.504000113401451*^9, 3.5173031684297*^9, 3.517579160789398*^9, 
   3.517643108676997*^9, 3.517650907619927*^9, 3.517658629174996*^9, 
   3.517658689322502*^9, 3.517660936163856*^9, 3.5178236411046333`*^9, 
   3.517823671928771*^9, 3.5178242294717817`*^9, {3.51782590275142*^9, 
   3.460388250572813*^9}, 3.460392629592249*^9, 3.460392746087512*^9, 
   3.460396682069415*^9, 3.460397911774363*^9, {3.460444070974021*^9, 
   3.460356775229074*^9}, 3.460366838683338*^9, 3.4603725349177094`*^9, 
   3.539782997876357*^9, 3.539785140057931*^9, 3.53986842425675*^9, 
   3.539873662696342*^9, 3.542469992655013*^9, 3.542476635309106*^9}],

Cell[BoxData["grt"], "Output",
 CellChangeTimes->{
  3.50331095292629*^9, {3.503311335372411*^9, 3.460515672510242*^9}, 
   3.503997004841145*^9, 3.503997193508582*^9, 3.5039972589761143`*^9, 
   3.504000113401451*^9, 3.5173031684297*^9, 3.517579160789398*^9, 
   3.517643108676997*^9, 3.517650907619927*^9, 3.517658629174996*^9, 
   3.517658689322502*^9, 3.517660936163856*^9, 3.5178236411046333`*^9, 
   3.517823671928771*^9, 3.5178242294717817`*^9, {3.51782590275142*^9, 
   3.460388250572813*^9}, 3.460392629592249*^9, 3.460392746087512*^9, 
   3.460396682069415*^9, 3.460397911774363*^9, {3.460444070974021*^9, 
   3.460356775229074*^9}, 3.460366838683338*^9, 3.4603725349177094`*^9, 
   3.539782997876357*^9, 3.539785140057931*^9, 3.53986842425675*^9, 
   3.539873662696342*^9, 3.542469992655013*^9, 3.542476635310486*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"BuildMetric", ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Gu", "=", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{"Inverse", "[", "Gd", "]"}], "]"}]}], ";", 
    RowBox[{"G", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u", ",", "d"}], "}"}], ",", 
       RowBox[{"IdentityMatrix", "[", "Nind", "]"}]}], "}"}]}], ";"}], 
   ")"}]}]], "Input"],

Cell[BoxData["BuildMetric"], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
    "}"}]}], "\n"}], "\n", 
 RowBox[{"Nind", "=", 
  RowBox[{"Length", "[", "ind", "]"}]}]}], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.5033109583532267`*^9, {3.503311335710185*^9, 3.460515672801284*^9}, 
   3.5039970055234003`*^9, 3.503997193704561*^9, 3.503997259177459*^9, 
   3.504000113555479*^9, 3.5173031727440968`*^9, 3.517579161233733*^9, 
   3.517643120632904*^9, 3.517650908068326*^9, 3.5176586295419607`*^9, 
   3.517658689483971*^9, 3.517660936374831*^9, {3.517823645931738*^9, 
   3.5178236721550293`*^9}, 3.5178242296158333`*^9, {3.517825902915317*^9, 
   3.460388251693995*^9}, 3.460392630077626*^9, 3.460392746249144*^9, 
   3.4603966823796663`*^9, 3.4603979119319277`*^9, {3.460444071270954*^9, 
   3.46035677625375*^9}, 3.460366838836698*^9, 3.4603725351755877`*^9, 
   3.539782998253436*^9, 3.539785140231594*^9, 3.539868424542329*^9, 
   3.539873662802165*^9, 3.542469993074065*^9, 3.542476635429062*^9}],

Cell[BoxData["5"], "Output",
 CellChangeTimes->{
  3.5033109583532267`*^9, {3.503311335710185*^9, 3.460515672801284*^9}, 
   3.5039970055234003`*^9, 3.503997193704561*^9, 3.503997259177459*^9, 
   3.504000113555479*^9, 3.5173031727440968`*^9, 3.517579161233733*^9, 
   3.517643120632904*^9, 3.517650908068326*^9, 3.5176586295419607`*^9, 
   3.517658689483971*^9, 3.517660936374831*^9, {3.517823645931738*^9, 
   3.5178236721550293`*^9}, 3.5178242296158333`*^9, {3.517825902915317*^9, 
   3.460388251693995*^9}, 3.460392630077626*^9, 3.460392746249144*^9, 
   3.4603966823796663`*^9, 3.4603979119319277`*^9, {3.460444071270954*^9, 
   3.46035677625375*^9}, 3.460366838836698*^9, 3.4603725351755877`*^9, 
   3.539782998253436*^9, 3.539785140231594*^9, 3.539868424542329*^9, 
   3.539873662802165*^9, 3.542469993074065*^9, 3.542476635430398*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"getind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "i1", "]"}], ",", "i1", ",", 
      RowBox[{
       RowBox[{"Position", "[", 
        RowBox[{"ind", ",", "i1"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"lstind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"lsttmp2", "=", 
      RowBox[{"{", "}"}]}], ";", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"AppendTo", "[", 
        RowBox[{"lsttmp2", ",", 
         RowBox[{"getind", "[", 
          RowBox[{"i1", "[", 
           RowBox[{"[", 
            RowBox[{"lsttmp1", ",", "1"}], "]"}], "]"}], "]"}]}], "]"}], ",", 
       
       RowBox[{"{", 
        RowBox[{"lsttmp1", ",", "1", ",", 
         RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
     "lsttmp2"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"up", "[", 
   RowBox[{"i1_", ",", "i2_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"lsttmp2", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"AppendTo", "[", 
       RowBox[{"lsttmp2", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"i1", "[", 
            RowBox[{"[", 
             RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "=!=", 
           RowBox[{"i2", "[", 
            RowBox[{"[", "lsttmp1", "]"}], "]"}]}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"i1", "[", 
              RowBox[{"[", 
               RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "===", "d"}], ",",
             "d", ",", "u"}], "]"}], ",", "0"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"lsttmp1", ",", "1", ",", 
        RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
    "lsttmp2"}], ")"}]}]}], "Input",
 Editable->False],

Cell[BoxData[""], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"t1_", ",", "dim_", ",", "indpos_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"MTtmp1", "=", "0"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Length", "[", "indpos", "]"}], "=!=", "dim"}], ",", 
      RowBox[{"Print", "[", "\"\<Error in index position\>\"", "]"}]}], "]"}],
     ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"MTtmp1", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"MTtmp1", ",", 
         RowBox[{"{", 
          RowBox[{"MTtmp3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"MTtmp2", ",", "1", ",", "dim"}], "}"}]}], "]"}], ";", 
    RowBox[{"t1", "=", 
     RowBox[{"{", 
      RowBox[{"indpos", ",", "MTtmp1"}], "}"}]}]}], ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ST", "[", 
    RowBox[{"t1_", ",", "tind_", ",", "val_"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"STtmp1", "=", "t1"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"up", "[", 
         RowBox[{"tind", ",", 
          RowBox[{"t1", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "=!=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"Length", "[", "tind", "]"}], "}"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Print", "[", "\"\<Error in Index Assignment!!\>\"", "]"}], 
        ";"}]}], "]"}], ";", 
     RowBox[{
      RowBox[{"STtmp1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "=", 
      RowBox[{"ReplacePart", "[", 
       RowBox[{
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", "val", ",", 
        RowBox[{"lstind", "[", "tind", "]"}]}], "]"}]}], ";", "STtmp1"}], 
    ")"}]}], "\n"}]], "Input",
 Editable->False],

Cell["\<\


Edited the expression below as 7.0 seems to complain about Sum[x] whereas 6.0 \
would just return x (ie. if there is no sum index!)

\
\>", "Text",
 CellChangeTimes->{{3.465736646430695*^9, 3.4657366879261303`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GT", "[", 
   RowBox[{"t1_", ",", "tind_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"GTtmp2", "=", 
     RowBox[{"up", "[", 
      RowBox[{"tind", ",", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
    RowBox[{"GTtmp3", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp4", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp5", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp6", "=", "t1"}], ";", "\n", "\t\t", 
    RowBox[{"Do", "[", "\n", "\t\t\t", 
     RowBox[{
      RowBox[{
       RowBox[{"Switch", "[", 
        RowBox[{
         RowBox[{"GTtmp2", "[", 
          RowBox[{"[", "GTtmp1", "]"}], "]"}], ",", "\n", "\t\t\t\t", "0", 
         ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}]}]}],
            ";"}], ")"}], ",", "\n", "\t\t\t\t", "u", ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gu[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}]}], ")"}], ",", "\n", "\t\t\t\t", "d", ",",
          "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gd[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}], ";"}], ")"}]}], "]"}], ";"}], "\n", 
      "\t\t\t", ",", 
      RowBox[{"{", 
       RowBox[{"GTtmp1", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"t1", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"GTtmp4", "===", "\"\<\>\""}], "&&", 
       RowBox[{"GTtmp5", "===", "\"\<\>\""}]}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{"\"\<GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\""}], 
       "]"}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{
       "\"\<Sum[GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\"", "<>", 
        "GTtmp4", "<>", "GTtmp5", "<>", "\"\<]\>\""}], "]"}]}], "]"}]}], 
   ")"}]}]], "Input",
 Editable->False,
 CellChangeTimes->{{3.465736640865263*^9, 3.4657366432796392`*^9}, {
  3.465736699767317*^9, 3.4657367470041943`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Trace, Outer Product and Covariant Derivative! - GREinstein.nb\
\>", "Subsubtitle",
 Editable->False],

Cell["\<\
Syntax:   trT[tensor,{{1,4},{2,3}}]   -  ie. contract 1 and 4 plus 2 and 3 \
positions\
\>", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"trT", "[", 
   RowBox[{"t1_", ",", "lst_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "tracetmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"dimt1", "===", "2"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tracetmp", "=", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"GT", "[", 
           RowBox[{"tmpt1", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"s1", ",", "d"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"s1", ",", "u"}], "}"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"s1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ";"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"MT", "[", 
        RowBox[{"tracetmp", ",", 
         RowBox[{"dimt1", "-", 
          RowBox[{"2", 
           RowBox[{"Length", "[", "lst", "]"}]}]}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{"d", ",", 
           RowBox[{"{", 
            RowBox[{"ii", ",", "1", ",", 
             RowBox[{"dimt1", "-", 
              RowBox[{"2", 
               RowBox[{"Length", "[", "lst", "]"}]}]}]}], "}"}]}], "]"}]}], 
        "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"{", "}"}], "===", 
             RowBox[{"Position", "[", 
              RowBox[{"lst", ",", "indno"}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"tmpstring1", "=", 
              RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,d},\>\""}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"tmpstring3", "=", 
              RowBox[{"tmpstring3", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,1,Nind},\>\""}]}], ";"}]}], "\[IndentingNewLine]", "]"}],
           ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}],
           ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\n", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"tmpstring4", "=", 
           RowBox[{"tmpstring4", "<>", "\"\<{s\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", 
            "\"\<,1,Nind},\>\""}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "1"}], "]"}], "]"}], "]"}]}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "2"}], "]"}], "]"}], "]"}], "<>", 
               "\"\<,d}\>\""}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,u}\>\""}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", 
           RowBox[{"Length", "[", "lst", "]"}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpeval", "=", 
        RowBox[{"\"\<Do[tracetmp=ST[tracetmp,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring1", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},Sum[GT[tmpt1,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring2", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring3", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "tracetmp"}], 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell["Syntax:   outerT[tensor1,tensor2] ", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"outerT", "[", 
   RowBox[{"t1_", ",", "t2_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    RowBox[{"dimt2", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t2", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", 
    RowBox[{"tmpt2", "=", "t2"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "outertmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"outertmp", ",", 
      RowBox[{"dimt1", "+", "dimt2"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{"d", ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"dimt1", "+", "dimt2"}]}], "}"}]}], "]"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring1", "=", 
        RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring2", "=", 
        RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", "\n", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring3", "=", 
        RowBox[{"tmpstring3", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", 
        RowBox[{"tmpstring4", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt2"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpeval", "=", 
     RowBox[{"\"\<Do[outertmp=ST[outertmp,{\>\"", "<>", "tmpstring1", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},GT[tmpt1,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring1", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]GT[tmpt2,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]],\>\"", "<>", "tmpstring2",
       "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring4", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "outertmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"scalarDT", "[", "t1_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"covDTtmp", ",", "1", ",", 
      RowBox[{"{", "d", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
    "tmpeval", "=", 
     "\"\<Do[covDTtmp=ST[covDTtmp,{{i1,d}},D[tmpt1,ind[[i1]]]],{i1,1,Nind}]\>\
\""}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "covDTtmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"covDT", "[", "t1_", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dimt1", "=", 
      RowBox[{"Length", "[", 
       RowBox[{"Dimensions", "[", 
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"MT", "[", 
      RowBox[{"covDTtmp", ",", 
       RowBox[{"dimt1", "+", "1"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{"d", ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", 
           RowBox[{"dimt1", "+", "1"}]}], "}"}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Build", " ", "expression"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring1", "=", 
         RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
        ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring2", "=", 
         RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", 
          "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring4", "=", 
         RowBox[{"\"\<-Sum[GT[tmpt1,{\>\"", "<>", 
          RowBox[{"StringDrop", "[", 
           RowBox[{"tmpstring1", ",", 
            RowBox[{"-", "1"}]}], "]"}], "<>", 
          "\"\<}]GT[\[CapitalGamma],{{REPL,d},{s1,d},{s2,u}}],{s2,1,Nind}]\>\"\
"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}], "\[Rule]", " ", 
            "\"\<s2\>\""}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"\"\<REPL\>\"", "\[Rule]", 
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring3", "=", 
         RowBox[{"tmpstring3", "<>", "tmpstring4"}]}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpeval", "=", 
      RowBox[{
      "\"\<Do[covDTtmp=ST[covDTtmp,{\>\"", "<>", "tmpstring1", "<>", 
       "\"\<{s1,d}},D[GT[tmpt1,{\>\"", "<>", 
       RowBox[{"StringDrop", "[", 
        RowBox[{"tmpstring1", ",", 
         RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],ind[[s1]]]\>\"", "<>", 
       "tmpstring3", "<>", "\"\<],\>\"", "<>", "tmpstring2", "<>", 
       "\"\<{s1,1,Nind}]\>\""}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "covDTtmp"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 Editable->False],

Cell[BoxData["."], "Input",
 CellChangeTimes->{3.399009138941909*^9},
 EmphasizeSyntaxErrors->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Buildmetric", "Subsubtitle"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
  "Print", "[", 
   "\"\<\\n\\n   \[CapitalDelta][r_,a_]=(\!\(\*FractionBox[\(\(\\\ \)\(1\)\), \
\((1 - a^2)\)]\))^2\\n   f[r_]  =(1-r^2)\\n   g[a_]   =2-a^2\\n\\n\\n\\n\>\"",
    "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.4603926036977377`*^9, 3.460392609494193*^9}, {
  3.4603964671280737`*^9, 3.460396474067587*^9}, {3.460396608649122*^9, 
  3.4603966089839687`*^9}, {3.5424766225848637`*^9, 3.542476624056772*^9}}],

Cell[BoxData["\<\"\\n\\n   \
\[CapitalDelta][r_,a_]=(\\!\\(\\*FractionBox[\\(\\(\\\\ \\)\\(1\\)\\), \\((1 \
- a^2)\\)]\\))^2\\n   f[r_]  =(1-r^2)\\n   g[a_]   =2-a^2\\n\\n\\n\\n\"\>"], \
"Print",
 CellChangeTimes->{{3.460392614803647*^9, 3.460392630773752*^9}, 
   3.4603927469544163`*^9, {3.4603965912356453`*^9, 3.460396610516452*^9}, 
   3.460396683089012*^9, 3.460397912493801*^9, {3.460444072054455*^9, 
   3.460356776865254*^9}, 3.460366839549692*^9, 3.4603725359239388`*^9, 
   3.539782999025613*^9, 3.539785140647101*^9, 3.539868426792572*^9, 
   3.539873663653604*^9, 3.5424699937927732`*^9, {3.542476625473093*^9, 
   3.542476635651379*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Gd", "=", 
   RowBox[{
    RowBox[{"\[CapitalDelta]", "[", 
     RowBox[{"r", ",", "a"}], "]"}], 
    RowBox[{"(", GridBox[{
       {
        RowBox[{"f", "[", "r", "]"}], "0", "0", "0", "0", "0"},
       {"0", 
        FractionBox[
         RowBox[{"r", "^", "2"}], 
         RowBox[{
          RowBox[{"f", "[", "r", "]"}], "^", "2"}]], "0", "0", "0", "0"},
       {"0", "0", 
        FractionBox["4", 
         RowBox[{"g", "[", "a", "]"}]], "0", "0", "0"},
       {"0", "0", "0", 
        FractionBox[
         RowBox[{
          RowBox[{"g", "[", "a", "]"}], 
          RowBox[{"a", "^", "2"}]}], 
         RowBox[{"1", "-", 
          RowBox[{"\[Theta]1", "^", "2"}]}]], "0", "0"},
       {"0", "0", "0", "0", 
        RowBox[{
         RowBox[{"g", "[", "a", "]"}], 
         RowBox[{"a", "^", "2"}], 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"\[Theta]1", "^", "2"}]}], ")"}]}], "0"},
       {"0", "0", "0", "0", "0", 
        RowBox[{
         RowBox[{"g", "[", "a", "]"}], 
         RowBox[{"a", "^", "2"}], 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"\[Theta]1", "^", "2"}]}], ")"}], 
         RowBox[{
          RowBox[{"Sin", "[", "\[Theta]2", "]"}], "^", "2"}]}]}
      }], ")"}]}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{
    "t", ",", "r", ",", "a", ",", "\[Theta]1", ",", "\[Theta]2", ",", 
     "\[Theta]3"}], "}"}]}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Nind", "=", 
   RowBox[{"Length", "[", "ind", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"BuildMetric", ";"}]}], "Input",
 CellChangeTimes->{{3.408796998476103*^9, 3.408797030516582*^9}, {
   3.408799071597343*^9, 3.408799082644943*^9}, {3.408949739095245*^9, 
   3.408949739644734*^9}, {3.408949841695282*^9, 3.40894984293303*^9}, {
   3.415862083663703*^9, 3.4158620851642113`*^9}, {3.415862334623486*^9, 
   3.415862336021243*^9}, {3.415862388498528*^9, 3.4158623965197372`*^9}, {
   3.4158641082437763`*^9, 3.415864116357332*^9}, {3.415865034672494*^9, 
   3.415865047473855*^9}, {3.415943026431671*^9, 3.415943056090918*^9}, {
   3.42453089354659*^9, 3.424530981705195*^9}, {3.4262330694486513`*^9, 
   3.426233078224708*^9}, {3.42831552177035*^9, 3.428315531925826*^9}, {
   3.482669504390863*^9, 3.482669559589313*^9}, {3.482669593648382*^9, 
   3.4826696108221407`*^9}, {3.4826696421684*^9, 3.460306349771068*^9}, {
   3.460306681872867*^9, 3.4603066892293873`*^9}, {3.460306743915044*^9, 
   3.460306776656151*^9}, {3.4603068906726713`*^9, 3.4603069154556093`*^9}, 
   3.4606109474491568`*^9, {3.5039972414730186`*^9, 3.503997244123049*^9}, {
   3.5172982618161573`*^9, 3.517298294501769*^9}, {3.517302332920382*^9, 
   3.517302353678054*^9}, {3.51730241996021*^9, 3.517302425934087*^9}, {
   3.517302556663072*^9, 3.5173025584548187`*^9}, 3.517579091871194*^9, {
   3.517642973774815*^9, 3.517642975072443*^9}, 3.517658611602713*^9, {
   3.517660901410638*^9, 3.460392650166881*^9}, {3.4603926980532846`*^9, 
   3.460392722992764*^9}, {3.460396656885631*^9, 3.460356665674651*^9}, {
   3.460356724881654*^9, 3.4603567425493803`*^9}, 3.460372510789526*^9, {
   3.54246967191507*^9, 3.542469701786797*^9}, {3.542469881774507*^9, 
   3.5424699266914043`*^9}, {3.542476527209447*^9, 3.5424765751877117`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "r", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}], ",", "0", ",", "0", ",", "0", ",", 
     "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      SuperscriptBox[
       RowBox[{"f", "[", "r", "]"}], "2"]], ",", "0", ",", "0", ",", "0", ",",
      "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"g", "[", "a", "]"}]], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"1", "-", 
       SuperscriptBox["\[Theta]1", "2"]}]], ",", "0", ",", "0"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
      RowBox[{"g", "[", "a", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
      RowBox[{"g", "[", "a", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "\[Theta]2", "]"}], "2"], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.503310959549301*^9, {3.503311337489339*^9, 3.460515673680585*^9}, 
   3.503996967770006*^9, 3.503997006524664*^9, 3.503997194550593*^9, 
   3.5039972601206627`*^9, 3.504000114145877*^9, 3.5173031733152313`*^9, 
   3.517579162305614*^9, 3.517643121148817*^9, 3.517650908892145*^9, 
   3.517658630210273*^9, 3.5176586899579687`*^9, 3.517660936798641*^9, {
   3.5178236465697403`*^9, 3.517823673129346*^9}, 3.517824230175544*^9, {
   3.517825903545369*^9, 3.460388252816543*^9}, 3.460392747023707*^9, 
   3.460396683141287*^9, 3.4603979125408783`*^9, {3.460444072147172*^9, 
   3.460356776913579*^9}, 3.46036683960192*^9, 3.460372536508292*^9, 
   3.539782999088622*^9, 3.539785140698571*^9, 3.539868426896636*^9, 
   3.53987366371763*^9, 3.542469993839971*^9, 3.54247663567483*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "t", ",", "r", ",", "a", ",", "\[Theta]1", ",", "\[Theta]2", ",", 
   "\[Theta]3"}], "}"}]], "Output",
 CellChangeTimes->{
  3.503310959549301*^9, {3.503311337489339*^9, 3.460515673680585*^9}, 
   3.503996967770006*^9, 3.503997006524664*^9, 3.503997194550593*^9, 
   3.5039972601206627`*^9, 3.504000114145877*^9, 3.5173031733152313`*^9, 
   3.517579162305614*^9, 3.517643121148817*^9, 3.517650908892145*^9, 
   3.517658630210273*^9, 3.5176586899579687`*^9, 3.517660936798641*^9, {
   3.5178236465697403`*^9, 3.517823673129346*^9}, 3.517824230175544*^9, {
   3.517825903545369*^9, 3.460388252816543*^9}, 3.460392747023707*^9, 
   3.460396683141287*^9, 3.4603979125408783`*^9, {3.460444072147172*^9, 
   3.460356776913579*^9}, 3.46036683960192*^9, 3.460372536508292*^9, 
   3.539782999088622*^9, 3.539785140698571*^9, 3.539868426896636*^9, 
   3.53987366371763*^9, 3.542469993839971*^9, 3.542476635677498*^9}],

Cell[BoxData["6"], "Output",
 CellChangeTimes->{
  3.503310959549301*^9, {3.503311337489339*^9, 3.460515673680585*^9}, 
   3.503996967770006*^9, 3.503997006524664*^9, 3.503997194550593*^9, 
   3.5039972601206627`*^9, 3.504000114145877*^9, 3.5173031733152313`*^9, 
   3.517579162305614*^9, 3.517643121148817*^9, 3.517650908892145*^9, 
   3.517658630210273*^9, 3.5176586899579687`*^9, 3.517660936798641*^9, {
   3.5178236465697403`*^9, 3.517823673129346*^9}, 3.517824230175544*^9, {
   3.517825903545369*^9, 3.460388252816543*^9}, 3.460392747023707*^9, 
   3.460396683141287*^9, 3.4603979125408783`*^9, {3.460444072147172*^9, 
   3.460356776913579*^9}, 3.46036683960192*^9, 3.460372536508292*^9, 
   3.539782999088622*^9, 3.539785140698571*^9, 3.539868426896636*^9, 
   3.53987366371763*^9, 3.542469993839971*^9, 3.5424766356791153`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Gd"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "r", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}], ",", "0", ",", "0", ",", "0", ",", 
     "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      SuperscriptBox[
       RowBox[{"f", "[", "r", "]"}], "2"]], ",", "0", ",", "0", ",", "0", ",",
      "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"g", "[", "a", "]"}]], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"1", "-", 
       SuperscriptBox["\[Theta]1", "2"]}]], ",", "0", ",", "0"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
      RowBox[{"g", "[", "a", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
      RowBox[{"g", "[", "a", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "\[Theta]2", "]"}], "2"], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.503310960896533*^9, {3.503311337815158*^9, 3.460515673971971*^9}, 
   3.5039970068865147`*^9, 3.503997194708459*^9, 3.5039972603113403`*^9, 
   3.504000114400865*^9, 3.517303175045021*^9, 3.517579163377042*^9, 
   3.517643122943182*^9, 3.517650911147537*^9, 3.517658631401002*^9, 
   3.5176586910877733`*^9, 3.517660938714964*^9, {3.5178236483503*^9, 
   3.517823675003542*^9}, 3.517824232021847*^9, {3.517825905567346*^9, 
   3.460388255822893*^9}, 3.460392749914061*^9, 3.460396684871089*^9, 
   3.460397914257712*^9, {3.460444073869268*^9, 3.4603567785893793`*^9}, 
   3.4603668412999907`*^9, 3.4603725377778482`*^9, 3.53978299993473*^9, 
   3.539785141532104*^9, 3.539868428003755*^9, 3.539873664479189*^9, 
   3.542469994931801*^9, 3.54247663574369*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Gu"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       RowBox[{"f", "[", "r", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]], ",", "0", ",", "0", ",", "0", ",", 
     "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"f", "[", "r", "]"}], "2"], 
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]], ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      RowBox[{"g", "[", "a", "]"}], 
      RowBox[{"4", " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]], ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"1", "-", 
       SuperscriptBox["\[Theta]1", "2"]}], 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     FractionBox["1", 
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"g", "[", "a", "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[Theta]1", "2"], " ", 
        RowBox[{"g", "[", "a", "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}]}]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"Csc", "[", "\[Theta]2", "]"}], "2"], 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
        RowBox[{"g", "[", "a", "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}]]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.503310961019191*^9, {3.503311337909677*^9, 3.4605156740447407`*^9}, 
   3.503997006988311*^9, 3.503997194814143*^9, 3.503997260416914*^9, 
   3.504000114475375*^9, 3.517303175100889*^9, 3.517579163432994*^9, 
   3.517643123023747*^9, 3.517650911238832*^9, 3.51765863146119*^9, 
   3.517658691190091*^9, 3.517660938769685*^9, {3.5178236484356413`*^9, 
   3.5178236750627403`*^9}, 3.517824232072446*^9, {3.517825905652813*^9, 
   3.4603882558830748`*^9}, 3.460392749990233*^9, 3.460396684946187*^9, 
   3.4603979143251343`*^9, {3.460444073966957*^9, 3.460356778642264*^9}, 
   3.460366841369574*^9, 3.46037253785017*^9, 3.539783000016053*^9, 
   3.539785141583846*^9, 3.5398684281973343`*^9, 3.539873664512268*^9, 
   3.5424699949810038`*^9, 3.5424766357700853`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"detg", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Det", "[", "Gd", "]"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"4", " ", 
    SuperscriptBox["a", "6"], " ", 
    SuperscriptBox["r", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"g", "[", "a", "]"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "\[Theta]2", "]"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"\[CapitalDelta]", "[", 
      RowBox[{"r", ",", "a"}], "]"}], "6"]}], 
   RowBox[{"f", "[", "r", "]"}]]}]], "Output",
 CellChangeTimes->{
  3.503310961169602*^9, {3.50331133798626*^9, 3.460515674108046*^9}, 
   3.503997007085783*^9, 3.5039971949056797`*^9, 3.503997260515153*^9, 
   3.504000114556445*^9, 3.517303175159586*^9, 3.517579163516987*^9, 
   3.5176431231240063`*^9, 3.517650911347453*^9, 3.517658631527398*^9, 
   3.51765869125694*^9, 3.517660938861404*^9, {3.517823648499422*^9, 
   3.51782367514461*^9}, 3.5178242321377687`*^9, {3.517825905766419*^9, 
   3.460388255960024*^9}, 3.460392750055771*^9, 3.460396684996212*^9, 
   3.460397914370763*^9, {3.460444074039672*^9, 3.460356778687825*^9}, 
   3.460366841502103*^9, 3.460372537983058*^9, 3.53978300013131*^9, 
   3.539785141639271*^9, 3.539868428328937*^9, 3.539873664562046*^9, 
   3.542469995075811*^9, 3.5424766357911*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRrun2.nb", "Subsubtitle"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\[CapitalGamma]", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"\[CapitalGamma]", ",", "3", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "u"}], "}"}]}], "]"}], ";"}], "\n"}], "Input",\

 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R4", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R4", ",", "4", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "d", ",", "u"}], "}"}]}], "]"}], 
  ";"}], "\n"}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "G2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"G2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"\[CapitalGamma]", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"\[CapitalGamma]", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], 
         RowBox[{"GT", "[", 
          RowBox[{"G", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
            "}"}]}], "]"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "+", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "ss1", "]"}], "]"}]}], "]"}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}], " ", "*)"}]], "Input",\

 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalGamma]", "=", 
   RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.426232729469757*^9, 3.426232735540435*^9}}],

Cell[BoxData[
 RowBox[{"Do", "[", "\n", "\t", 
  RowBox[{
   RowBox[{"R4", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R4", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      "\n", "\t", "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "+", "\n", "\t\t\t", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}]}], "\n", 
     "\t\t", "\n", "\t\t", "]"}]}], "\n", "\t\t", ",", "\n", "\t", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i4", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R4", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"R2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"GT", "[", 
         RowBox[{"R4", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}],
          "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "\n", 
     "\t\t", "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"GT", "[", 
      RowBox[{"R2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"G2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"G2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"GT", "[", 
        RowBox[{"R2", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
        "]"}], "-", 
       RowBox[{
        FractionBox["1", "2"], 
        RowBox[{"GT", "[", 
         RowBox[{"G", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
         "]"}], "Ricci"}]}]}], "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "G2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "Ricci", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"]
}, Closed]],

Cell[CellGroupData[{

Cell["Einstein equations", "Subsubtitle"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalDelta]", "[", 
    RowBox[{"r_", ",", "a_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     FractionBox[
      RowBox[{" ", "1"}], 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"a", "^", "2"}]}], ")"}]], ")"}], "^", "2"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "r_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"r", "^", "2"}]}], ")"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g", "[", "a_", "]"}], ":=", 
  RowBox[{"2", "-", 
   RowBox[{"a", "^", "2"}]}]}]}], "Input",
 CellChangeTimes->{{3.503997037073781*^9, 3.503997076077972*^9}, {
   3.503997256891058*^9, 3.4603927524745617`*^9}, {3.460396639861096*^9, 
   3.4603966466740303`*^9}, {3.460397369545499*^9, 3.460397369641325*^9}, 
   3.542471512037649*^9, 3.542475294942463*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"R2", "[", 
    RowBox[{"[", "2", "]"}], "]"}], "+", 
   RowBox[{"5", "Gd"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5424766513228827`*^9, 3.5424766811059437`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.542476651974782*^9, 3.542476681566162*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{740, 839},
WindowMargins->{{7, Automatic}, {Automatic, 7}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "calcgeom"->{
  Cell[69645, 1935, 308, 10, 73, "Input",
   CellTags->"calcgeom"],
  Cell[69956, 1947, 293, 10, 73, "Input",
   CellTags->"calcgeom"],
  Cell[70252, 1959, 264, 9, 58, "Input",
   CellTags->"calcgeom"],
  Cell[70519, 1970, 264, 9, 58, "Input",
   CellTags->"calcgeom"],
  Cell[70786, 1981, 3569, 101, 152, "Input",
   CellTags->"calcgeom"],
  Cell[74358, 2084, 157, 5, 27, "Input",
   CellTags->"calcgeom"],
  Cell[74722, 2097, 5599, 153, 178, "Input",
   CellTags->"calcgeom"],
  Cell[80324, 2252, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[80469, 2258, 1615, 48, 88, "Input",
   CellTags->"calcgeom"],
  Cell[82087, 2308, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[82232, 2314, 633, 22, 27, "Input",
   CellTags->"calcgeom"],
  Cell[82868, 2338, 1648, 51, 115, "Input",
   CellTags->"calcgeom"],
  Cell[84519, 2391, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[84664, 2397, 145, 4, 27, "Input",
   CellTags->"calcgeom"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"calcgeom", 87152, 2484}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 98, 1, 26, "Subsubtitle"],
Cell[680, 25, 125, 2, 27, "Input"],
Cell[CellGroupData[{
Cell[830, 31, 570, 18, 56, "Input"],
Cell[1403, 51, 562, 17, 58, "Output"]
}, Open  ]],
Cell[1980, 71, 256, 7, 46, "Input"],
Cell[CellGroupData[{
Cell[2261, 82, 97, 1, 27, "Input"],
Cell[2361, 85, 654, 22, 56, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3052, 112, 1238, 38, 142, "Input"],
Cell[4293, 152, 146, 2, 27, "Output"]
}, Open  ]],
Cell[4454, 157, 215, 4, 27, "Input"],
Cell[CellGroupData[{
Cell[4694, 165, 574, 17, 46, "Input"],
Cell[5271, 184, 463, 14, 50, "Output"]
}, Open  ]],
Cell[5749, 201, 619, 21, 100, "Input"],
Cell[CellGroupData[{
Cell[6393, 226, 130, 2, 27, "Input"],
Cell[6526, 230, 1723, 58, 59, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8286, 293, 1631, 52, 173, "Input"],
Cell[9920, 347, 119, 2, 27, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10088, 355, 98, 1, 26, "Subsubtitle"],
Cell[10189, 358, 125, 2, 27, "Input"],
Cell[CellGroupData[{
Cell[10339, 364, 576, 19, 56, "Input"],
Cell[10918, 385, 593, 19, 59, "Output"]
}, Open  ]],
Cell[11526, 407, 243, 7, 49, "Input"],
Cell[CellGroupData[{
Cell[11794, 418, 97, 1, 27, "Input"],
Cell[11894, 421, 546, 18, 56, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12477, 444, 1106, 34, 142, "Input"],
Cell[13586, 480, 121, 2, 27, "Output"]
}, Open  ]],
Cell[13722, 485, 215, 4, 27, "Input"],
Cell[CellGroupData[{
Cell[13962, 493, 574, 17, 46, "Input"],
Cell[14539, 512, 515, 15, 50, "Output"]
}, Open  ]],
Cell[15069, 530, 883, 26, 104, "Input"],
Cell[CellGroupData[{
Cell[15977, 560, 158, 4, 46, "Input"],
Cell[16138, 566, 361, 12, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16536, 583, 130, 2, 27, "Input"],
Cell[16669, 587, 1776, 58, 59, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18482, 650, 1753, 55, 173, "Input"],
Cell[20238, 707, 214, 3, 27, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20501, 716, 437, 6, 46, "Subtitle"],
Cell[CellGroupData[{
Cell[20963, 726, 68, 1, 27, "Input"],
Cell[21034, 729, 837, 12, 20, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21908, 746, 111, 1, 26, "Subsubtitle"],
Cell[22022, 749, 95, 2, 27, "Input"],
Cell[CellGroupData[{
Cell[22142, 755, 279, 8, 58, "Input"],
Cell[22424, 765, 963, 16, 70, "Output"],
Cell[23390, 783, 1365, 27, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24792, 815, 266, 9, 58, "Input"],
Cell[25061, 826, 828, 12, 70, "Output"],
Cell[25892, 840, 828, 12, 70, "Output"]
}, Open  ]],
Cell[26735, 855, 407, 13, 27, "Input"],
Cell[27145, 870, 37, 0, 27, "Input"],
Cell[CellGroupData[{
Cell[27207, 874, 257, 8, 58, "Input"],
Cell[27467, 884, 932, 15, 70, "Output"],
Cell[28402, 901, 842, 12, 70, "Output"]
}, Open  ]],
Cell[29259, 916, 2028, 63, 103, "Input"],
Cell[31290, 981, 26, 0, 27, "Input"],
Cell[31319, 983, 841, 25, 43, "Input"],
Cell[32163, 1010, 1026, 31, 58, "Input"],
Cell[33192, 1043, 227, 8, 86, "Text"],
Cell[33422, 1053, 4015, 95, 238, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[37474, 1153, 111, 3, 26, "Subsubtitle"],
Cell[37588, 1158, 128, 4, 26, "Text"],
Cell[37719, 1164, 6139, 139, 718, "Input"],
Cell[43861, 1305, 68, 1, 26, "Text"],
Cell[43932, 1308, 3727, 84, 523, "Input"],
Cell[47662, 1394, 824, 18, 208, "Input"],
Cell[48489, 1414, 4051, 89, 583, "Input"],
Cell[52543, 1505, 99, 2, 27, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[52679, 1512, 34, 0, 26, "Subsubtitle"],
Cell[CellGroupData[{
Cell[52738, 1516, 456, 9, 49, "Input"],
Cell[53197, 1527, 651, 10, 164, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53885, 1542, 3399, 74, 243, "Input"],
Cell[57287, 1618, 2869, 72, 124, "Output"],
Cell[60159, 1692, 949, 16, 27, "Output"],
Cell[61111, 1710, 835, 12, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61983, 1727, 28, 0, 27, "Input"],
Cell[62014, 1729, 2848, 72, 124, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[64899, 1806, 28, 0, 27, "Input"],
Cell[64930, 1808, 3145, 80, 144, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[68112, 1893, 119, 3, 27, "Input"],
Cell[68234, 1898, 1327, 29, 53, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[69610, 1933, 32, 0, 26, "Subsubtitle"],
Cell[69645, 1935, 308, 10, 73, "Input",
 CellTags->"calcgeom"],
Cell[69956, 1947, 293, 10, 73, "Input",
 CellTags->"calcgeom"],
Cell[70252, 1959, 264, 9, 58, "Input",
 CellTags->"calcgeom"],
Cell[70519, 1970, 264, 9, 58, "Input",
 CellTags->"calcgeom"],
Cell[70786, 1981, 3569, 101, 152, "Input",
 CellTags->"calcgeom"],
Cell[74358, 2084, 157, 5, 27, "Input",
 CellTags->"calcgeom"],
Cell[74518, 2091, 201, 4, 27, "Input"],
Cell[74722, 2097, 5599, 153, 178, "Input",
 CellTags->"calcgeom"],
Cell[80324, 2252, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[80469, 2258, 1615, 48, 88, "Input",
 CellTags->"calcgeom"],
Cell[82087, 2308, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[82232, 2314, 633, 22, 27, "Input",
 CellTags->"calcgeom"],
Cell[82868, 2338, 1648, 51, 115, "Input",
 CellTags->"calcgeom"],
Cell[84519, 2391, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[84664, 2397, 145, 4, 27, "Input",
 CellTags->"calcgeom"]
}, Closed]],
Cell[CellGroupData[{
Cell[84846, 2406, 41, 0, 26, "Subsubtitle"],
Cell[84890, 2408, 926, 27, 112, "Input"],
Cell[CellGroupData[{
Cell[85841, 2439, 229, 6, 27, "Input"],
Cell[86073, 2447, 736, 21, 43, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
