(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    616833,      16051]
NotebookOptionsPosition[    604202,      15653]
NotebookOutlinePosition[    605557,      15701]
CellTagsIndexPosition[    605483,      15696]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["RS 5d - Isreal conditions", "Subtitle",
 CellChangeTimes->{{3.408796983010241*^9, 3.408796989128707*^9}, {
  3.415942197687789*^9, 3.415942199707787*^9}, {3.428318203595373*^9, 
  3.4283182110266533`*^9}, {3.4318556687961187`*^9, 3.431855668994246*^9}, {
  3.48266555323216*^9, 3.482665557150345*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", "\"\<hmm\>\"", "]"}]], "Input"],

Cell[BoxData["\<\"hmm\"\>"], "Print",
 CellChangeTimes->{
  3.426737013194791*^9, 3.4283151938180532`*^9, 3.428315553265912*^9, 
   3.428316879668502*^9, 3.4284038946466827`*^9, 3.4318556782327433`*^9, 
   3.431863726574562*^9, 3.482645295101799*^9, 3.4826453579432173`*^9, 
   3.482645464070413*^9, 3.4826465354634857`*^9, 3.482646576278145*^9, 
   3.4826543007333717`*^9, 3.482660738510792*^9, {3.482665665778748*^9, 
   3.460345345005185*^9}, 3.482732899833189*^9, 3.4832683038376827`*^9, 
   3.483274829836521*^9, 3.483355830278619*^9, 3.495174822655376*^9, 
   3.497953162440522*^9, 3.497953487871752*^9, 3.501484207182074*^9, {
   3.501486522498592*^9, 3.4603905367302732`*^9}, 3.460429409024069*^9, 
   3.460429476669972*^9, {3.503999598758216*^9, 3.460343345971778*^9}, 
   3.460397493489051*^9, 3.4603981921980867`*^9, {3.460625262680915*^9, 
   3.4603659342380543`*^9}, 3.46037335064213*^9, 3.54143569407403*^9, 
   3.5414410133826447`*^9, 3.541999845932349*^9, 3.542001525695931*^9, 
   3.542294088957677*^9, 3.542431693020376*^9, 3.542434092559815*^9, 
   3.542516264263172*^9, 3.542516573152875*^9, 3.5425166773414*^9, 
   3.542529833751082*^9, 3.543226743119319*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRSetup2.nb - modified", "Subsubtitle",
 CellChangeTimes->{{3.478330969800351*^9, 3.478330971159855*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Latest", " ", "Version"}], " ", "*)"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"{", 
    RowBox[{
    "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
     "gzz"}], "}"}]}], "\n"}], "\n", 
 RowBox[{"Gd", "=", 
  RowBox[{"DiagonalMatrix", "[", "metric", "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
   "gzz"}], "}"}]], "Output",
 CellChangeTimes->{
  3.466315297140045*^9, 3.478330988195435*^9, 3.478416452606082*^9, 
   3.478847548608172*^9, {3.478929911283174*^9, 3.4603055225664177`*^9}, 
   3.4604526704446363`*^9, 3.482471496252235*^9, 3.482471611406439*^9, 
   3.482645358035461*^9, 3.482645464253499*^9, 3.482646535695998*^9, 
   3.4826465764442587`*^9, 3.482654300949271*^9, 3.4826607387014923`*^9, {
   3.482665666027986*^9, 3.460345345197377*^9}, 3.482732900019106*^9, 
   3.4832683040504923`*^9, 3.483274830169456*^9, 3.4833558305609293`*^9, 
   3.495174822972555*^9, 3.497953162624474*^9, 3.49795348812144*^9, 
   3.501484207532778*^9, {3.501486522848439*^9, 3.460390536999611*^9}, 
   3.460429409196727*^9, 3.460429476861683*^9, {3.503999599120948*^9, 
   3.460343346107972*^9}, 3.460397493671178*^9, 3.460398192423341*^9, {
   3.460625263005105*^9, 3.460365934424306*^9}, 3.4603733508385*^9, 
   3.541435694240285*^9, 3.541441013451647*^9, 3.541999846000835*^9, 
   3.542001525764724*^9, 3.54229408902534*^9, 3.542431693251051*^9, 
   3.542434092626645*^9, 3.542516264330453*^9, 3.542516573220199*^9, 
   3.5425166774104137`*^9, 3.542529833912911*^9, 3.543226743264523*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"gtt", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "grr", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "g\[Theta]\[Theta]", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "g\[Phi]\[Phi]", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "gzz"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.466315297140045*^9, 3.478330988195435*^9, 3.478416452606082*^9, 
   3.478847548608172*^9, {3.478929911283174*^9, 3.4603055225664177`*^9}, 
   3.4604526704446363`*^9, 3.482471496252235*^9, 3.482471611406439*^9, 
   3.482645358035461*^9, 3.482645464253499*^9, 3.482646535695998*^9, 
   3.4826465764442587`*^9, 3.482654300949271*^9, 3.4826607387014923`*^9, {
   3.482665666027986*^9, 3.460345345197377*^9}, 3.482732900019106*^9, 
   3.4832683040504923`*^9, 3.483274830169456*^9, 3.4833558305609293`*^9, 
   3.495174822972555*^9, 3.497953162624474*^9, 3.49795348812144*^9, 
   3.501484207532778*^9, {3.501486522848439*^9, 3.460390536999611*^9}, 
   3.460429409196727*^9, 3.460429476861683*^9, {3.503999599120948*^9, 
   3.460343346107972*^9}, 3.460397493671178*^9, 3.460398192423341*^9, {
   3.460625263005105*^9, 3.460365934424306*^9}, 3.4603733508385*^9, 
   3.541435694240285*^9, 3.541441013451647*^9, 3.541999846000835*^9, 
   3.542001525764724*^9, 3.54229408902534*^9, 3.542431693251051*^9, 
   3.542434092626645*^9, 3.542516264330453*^9, 3.542516573220199*^9, 
   3.5425166774104137`*^9, 3.542529833912911*^9, 3.543226743265892*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Gd", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", "grt"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Gd", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "1"}], "]"}], "]"}], "=", "grt"}]}], "Input"],

Cell[BoxData["grt"], "Output",
 CellChangeTimes->{
  3.466315297179295*^9, 3.478330988245845*^9, 3.4784164526461287`*^9, 
   3.478847548682302*^9, {3.4789299113562927`*^9, 3.46030552262118*^9}, 
   3.460452670511849*^9, 3.4824714962922277`*^9, 3.48247161146406*^9, 
   3.482645358070859*^9, 3.482645464319662*^9, 3.4826465357796783`*^9, 
   3.482646576527176*^9, 3.482654301033062*^9, 3.4826607387838*^9, {
   3.482665666129422*^9, 3.4603453452845716`*^9}, 3.482732900099493*^9, 
   3.483268304133985*^9, 3.483274830260374*^9, 3.4833558306436863`*^9, 
   3.495174823024794*^9, 3.497953162683668*^9, 3.497953488221377*^9, 
   3.5014842076813087`*^9, {3.501486522964305*^9, 3.460390537094163*^9}, 
   3.4604294092484293`*^9, 3.460429476963196*^9, {3.503999599186805*^9, 
   3.460343346168922*^9}, 3.4603974937499847`*^9, 3.460398192516327*^9, {
   3.460625263064344*^9, 3.46036593446181*^9}, 3.4603733508933983`*^9, 
   3.54143569430737*^9, 3.541441013666492*^9, 3.54199984608576*^9, 
   3.542001525794325*^9, 3.542294089189588*^9, 3.542431693298534*^9, 
   3.542434092665059*^9, 3.542516264397684*^9, 3.542516573286585*^9, 
   3.542516677461295*^9, 3.542529833996008*^9, 3.543226743302022*^9}],

Cell[BoxData["grt"], "Output",
 CellChangeTimes->{
  3.466315297179295*^9, 3.478330988245845*^9, 3.4784164526461287`*^9, 
   3.478847548682302*^9, {3.4789299113562927`*^9, 3.46030552262118*^9}, 
   3.460452670511849*^9, 3.4824714962922277`*^9, 3.48247161146406*^9, 
   3.482645358070859*^9, 3.482645464319662*^9, 3.4826465357796783`*^9, 
   3.482646576527176*^9, 3.482654301033062*^9, 3.4826607387838*^9, {
   3.482665666129422*^9, 3.4603453452845716`*^9}, 3.482732900099493*^9, 
   3.483268304133985*^9, 3.483274830260374*^9, 3.4833558306436863`*^9, 
   3.495174823024794*^9, 3.497953162683668*^9, 3.497953488221377*^9, 
   3.5014842076813087`*^9, {3.501486522964305*^9, 3.460390537094163*^9}, 
   3.4604294092484293`*^9, 3.460429476963196*^9, {3.503999599186805*^9, 
   3.460343346168922*^9}, 3.4603974937499847`*^9, 3.460398192516327*^9, {
   3.460625263064344*^9, 3.46036593446181*^9}, 3.4603733508933983`*^9, 
   3.54143569430737*^9, 3.541441013666492*^9, 3.54199984608576*^9, 
   3.542001525794325*^9, 3.542294089189588*^9, 3.542431693298534*^9, 
   3.542434092665059*^9, 3.542516264397684*^9, 3.542516573286585*^9, 
   3.542516677461295*^9, 3.542529833996008*^9, 3.543226743303273*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"BuildMetric", ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Gu", "=", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{"Inverse", "[", "Gd", "]"}], "]"}]}], ";", 
    RowBox[{"G", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u", ",", "d"}], "}"}], ",", 
       RowBox[{"IdentityMatrix", "[", "Nind", "]"}]}], "}"}]}], ";"}], 
   ")"}]}]], "Input"],

Cell[BoxData["BuildMetric"], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
    "}"}]}], "\n"}], "\n", 
 RowBox[{"Nind", "=", 
  RowBox[{"Length", "[", "ind", "]"}]}]}], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.466315297712317*^9, 3.4783309883547897`*^9, 3.4784164529457827`*^9, 
   3.478847549205242*^9, {3.478929911603554*^9, 3.4603055237326612`*^9}, 
   3.460452671089712*^9, 3.4824714964364767`*^9, 3.482471611595883*^9, 
   3.482645358224825*^9, 3.482645464457198*^9, 3.4826465359168453`*^9, 
   3.482646576664466*^9, 3.482654301186666*^9, 3.4826607389382544`*^9, {
   3.482665666280961*^9, 3.460345345463394*^9}, 3.482732900239039*^9, 
   3.483268305021481*^9, 3.483274830556378*^9, 3.4833558308940907`*^9, 
   3.4951748231727*^9, 3.497953163012686*^9, 3.4979534884757023`*^9, 
   3.501484207899385*^9, {3.501486523197439*^9, 3.4603905372989473`*^9}, 
   3.460429409494135*^9, 3.460429477939843*^9, {3.503999599454533*^9, 
   3.4603433469419613`*^9}, 3.460397493927754*^9, 3.460398192702785*^9, {
   3.460625263273443*^9, 3.460365934618382*^9}, 3.4603733510389843`*^9, 
   3.5414356944615593`*^9, 3.541441013783738*^9, 3.541999846405352*^9, 
   3.5420015260770597`*^9, 3.542294089359178*^9, 3.542431693555004*^9, 
   3.5424340932934637`*^9, 3.5425162646834393`*^9, 3.542516573426014*^9, 
   3.54251667760752*^9, 3.542529834483963*^9, 3.543226743613982*^9}],

Cell[BoxData["5"], "Output",
 CellChangeTimes->{
  3.466315297712317*^9, 3.4783309883547897`*^9, 3.4784164529457827`*^9, 
   3.478847549205242*^9, {3.478929911603554*^9, 3.4603055237326612`*^9}, 
   3.460452671089712*^9, 3.4824714964364767`*^9, 3.482471611595883*^9, 
   3.482645358224825*^9, 3.482645464457198*^9, 3.4826465359168453`*^9, 
   3.482646576664466*^9, 3.482654301186666*^9, 3.4826607389382544`*^9, {
   3.482665666280961*^9, 3.460345345463394*^9}, 3.482732900239039*^9, 
   3.483268305021481*^9, 3.483274830556378*^9, 3.4833558308940907`*^9, 
   3.4951748231727*^9, 3.497953163012686*^9, 3.4979534884757023`*^9, 
   3.501484207899385*^9, {3.501486523197439*^9, 3.4603905372989473`*^9}, 
   3.460429409494135*^9, 3.460429477939843*^9, {3.503999599454533*^9, 
   3.4603433469419613`*^9}, 3.460397493927754*^9, 3.460398192702785*^9, {
   3.460625263273443*^9, 3.460365934618382*^9}, 3.4603733510389843`*^9, 
   3.5414356944615593`*^9, 3.541441013783738*^9, 3.541999846405352*^9, 
   3.5420015260770597`*^9, 3.542294089359178*^9, 3.542431693555004*^9, 
   3.5424340932934637`*^9, 3.5425162646834393`*^9, 3.542516573426014*^9, 
   3.54251667760752*^9, 3.542529834483963*^9, 3.5432267436152477`*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"getind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "i1", "]"}], ",", "i1", ",", 
      RowBox[{
       RowBox[{"Position", "[", 
        RowBox[{"ind", ",", "i1"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"lstind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"lsttmp2", "=", 
      RowBox[{"{", "}"}]}], ";", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"AppendTo", "[", 
        RowBox[{"lsttmp2", ",", 
         RowBox[{"getind", "[", 
          RowBox[{"i1", "[", 
           RowBox[{"[", 
            RowBox[{"lsttmp1", ",", "1"}], "]"}], "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"lsttmp1", ",", "1", ",", 
         RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
     "lsttmp2"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"up", "[", 
   RowBox[{"i1_", ",", "i2_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"lsttmp2", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"AppendTo", "[", 
       RowBox[{"lsttmp2", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"i1", "[", 
            RowBox[{"[", 
             RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "=!=", 
           RowBox[{"i2", "[", 
            RowBox[{"[", "lsttmp1", "]"}], "]"}]}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"i1", "[", 
              RowBox[{"[", 
               RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "===", "d"}], ",",
             "d", ",", "u"}], "]"}], ",", "0"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"lsttmp1", ",", "1", ",", 
        RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
    "lsttmp2"}], ")"}]}]}], "Input",
 Editable->False],

Cell[BoxData[""], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"t1_", ",", "dim_", ",", "indpos_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"MTtmp1", "=", "0"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Length", "[", "indpos", "]"}], "=!=", "dim"}], ",", 
      RowBox[{"Print", "[", "\"\<Error in index position\>\"", "]"}]}], "]"}],
     ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"MTtmp1", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"MTtmp1", ",", 
         RowBox[{"{", 
          RowBox[{"MTtmp3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"MTtmp2", ",", "1", ",", "dim"}], "}"}]}], "]"}], ";", 
    RowBox[{"t1", "=", 
     RowBox[{"{", 
      RowBox[{"indpos", ",", "MTtmp1"}], "}"}]}]}], ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ST", "[", 
    RowBox[{"t1_", ",", "tind_", ",", "val_"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"STtmp1", "=", "t1"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"up", "[", 
         RowBox[{"tind", ",", 
          RowBox[{"t1", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "=!=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"Length", "[", "tind", "]"}], "}"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Print", "[", "\"\<Error in Index Assignment!!\>\"", "]"}], 
        ";"}]}], "]"}], ";", 
     RowBox[{
      RowBox[{"STtmp1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "=", 
      RowBox[{"ReplacePart", "[", 
       RowBox[{
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", "val", ",", 
        RowBox[{"lstind", "[", "tind", "]"}]}], "]"}]}], ";", "STtmp1"}], 
    ")"}]}], "\n"}]], "Input",
 Editable->False],

Cell["\<\


Edited the expression below as 7.0 seems to complain about Sum[x] whereas 6.0 \
would just return x (ie. if there is no sum index!)

\
\>", "Text",
 CellChangeTimes->{{3.465736646430695*^9, 3.4657366879261303`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GT", "[", 
   RowBox[{"t1_", ",", "tind_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"GTtmp2", "=", 
     RowBox[{"up", "[", 
      RowBox[{"tind", ",", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
    RowBox[{"GTtmp3", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp4", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp5", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp6", "=", "t1"}], ";", "\n", "\t\t", 
    RowBox[{"Do", "[", "\n", "\t\t\t", 
     RowBox[{
      RowBox[{
       RowBox[{"Switch", "[", 
        RowBox[{
         RowBox[{"GTtmp2", "[", 
          RowBox[{"[", "GTtmp1", "]"}], "]"}], ",", "\n", "\t\t\t\t", "0", 
         ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}]}]}],
            ";"}], ")"}], ",", "\n", "\t\t\t\t", "u", ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gu[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}]}], ")"}], ",", "\n", "\t\t\t\t", "d", ",",
          "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gd[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}], ";"}], ")"}]}], "]"}], ";"}], "\n", 
      "\t\t\t", ",", 
      RowBox[{"{", 
       RowBox[{"GTtmp1", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"t1", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"GTtmp4", "===", "\"\<\>\""}], "&&", 
       RowBox[{"GTtmp5", "===", "\"\<\>\""}]}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{"\"\<GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\""}], 
       "]"}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{
       "\"\<Sum[GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\"", "<>", 
        "GTtmp4", "<>", "GTtmp5", "<>", "\"\<]\>\""}], "]"}]}], "]"}]}], 
   ")"}]}]], "Input",
 Editable->False,
 CellChangeTimes->{{3.465736640865263*^9, 3.4657366432796392`*^9}, {
  3.465736699767317*^9, 3.4657367470041943`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Trace, Outer Product and Covariant Derivative! - GREinstein.nb\
\>", "Subsubtitle",
 Editable->False],

Cell["\<\
Syntax:   trT[tensor,{{1,4},{2,3}}]   -  ie. contract 1 and 4 plus 2 and 3 \
positions\
\>", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"trT", "[", 
   RowBox[{"t1_", ",", "lst_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "tracetmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"dimt1", "===", "2"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tracetmp", "=", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"GT", "[", 
           RowBox[{"tmpt1", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"s1", ",", "d"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"s1", ",", "u"}], "}"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"s1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ";"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"MT", "[", 
        RowBox[{"tracetmp", ",", 
         RowBox[{"dimt1", "-", 
          RowBox[{"2", 
           RowBox[{"Length", "[", "lst", "]"}]}]}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{"d", ",", 
           RowBox[{"{", 
            RowBox[{"ii", ",", "1", ",", 
             RowBox[{"dimt1", "-", 
              RowBox[{"2", 
               RowBox[{"Length", "[", "lst", "]"}]}]}]}], "}"}]}], "]"}]}], 
        "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"{", "}"}], "===", 
             RowBox[{"Position", "[", 
              RowBox[{"lst", ",", "indno"}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"tmpstring1", "=", 
              RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,d},\>\""}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"tmpstring3", "=", 
              RowBox[{"tmpstring3", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,1,Nind},\>\""}]}], ";"}]}], "\[IndentingNewLine]", "]"}],
           ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}],
           ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\n", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"tmpstring4", "=", 
           RowBox[{"tmpstring4", "<>", "\"\<{s\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", 
            "\"\<,1,Nind},\>\""}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "1"}], "]"}], "]"}], "]"}]}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "2"}], "]"}], "]"}], "]"}], "<>", 
               "\"\<,d}\>\""}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,u}\>\""}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", 
           RowBox[{"Length", "[", "lst", "]"}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpeval", "=", 
        RowBox[{"\"\<Do[tracetmp=ST[tracetmp,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring1", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},Sum[GT[tmpt1,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring2", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring3", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "tracetmp"}], 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell["Syntax:   outerT[tensor1,tensor2] ", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"outerT", "[", 
   RowBox[{"t1_", ",", "t2_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    RowBox[{"dimt2", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t2", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", 
    RowBox[{"tmpt2", "=", "t2"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "outertmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"outertmp", ",", 
      RowBox[{"dimt1", "+", "dimt2"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{"d", ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"dimt1", "+", "dimt2"}]}], "}"}]}], "]"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring1", "=", 
        RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring2", "=", 
        RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", "\n", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring3", "=", 
        RowBox[{"tmpstring3", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", 
        RowBox[{"tmpstring4", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt2"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpeval", "=", 
     RowBox[{"\"\<Do[outertmp=ST[outertmp,{\>\"", "<>", "tmpstring1", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},GT[tmpt1,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring1", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]GT[tmpt2,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]],\>\"", "<>", "tmpstring2",
       "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring4", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "outertmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"scalarDT", "[", "t1_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"covDTtmp", ",", "1", ",", 
      RowBox[{"{", "d", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
    "tmpeval", "=", 
     "\"\<Do[covDTtmp=ST[covDTtmp,{{i1,d}},D[tmpt1,ind[[i1]]]],{i1,1,Nind}]\>\
\""}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "covDTtmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"covDT", "[", "t1_", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dimt1", "=", 
      RowBox[{"Length", "[", 
       RowBox[{"Dimensions", "[", 
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"MT", "[", 
      RowBox[{"covDTtmp", ",", 
       RowBox[{"dimt1", "+", "1"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{"d", ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", 
           RowBox[{"dimt1", "+", "1"}]}], "}"}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Build", " ", "expression"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring1", "=", 
         RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
        ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring2", "=", 
         RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", 
          "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring4", "=", 
         RowBox[{"\"\<-Sum[GT[tmpt1,{\>\"", "<>", 
          RowBox[{"StringDrop", "[", 
           RowBox[{"tmpstring1", ",", 
            RowBox[{"-", "1"}]}], "]"}], "<>", 
          "\"\<}]GT[\[CapitalGamma],{{REPL,d},{s1,d},{s2,u}}],{s2,1,Nind}]\>\"\
"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}], "\[Rule]", " ", 
            "\"\<s2\>\""}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"\"\<REPL\>\"", "\[Rule]", 
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring3", "=", 
         RowBox[{"tmpstring3", "<>", "tmpstring4"}]}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpeval", "=", 
      RowBox[{
      "\"\<Do[covDTtmp=ST[covDTtmp,{\>\"", "<>", "tmpstring1", "<>", 
       "\"\<{s1,d}},D[GT[tmpt1,{\>\"", "<>", 
       RowBox[{"StringDrop", "[", 
        RowBox[{"tmpstring1", ",", 
         RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],ind[[s1]]]\>\"", "<>", 
       "tmpstring3", "<>", "\"\<],\>\"", "<>", "tmpstring2", "<>", 
       "\"\<{s1,1,Nind}]\>\""}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "covDTtmp"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 Editable->False],

Cell[BoxData["."], "Input",
 CellChangeTimes->{3.399009138941909*^9},
 EmphasizeSyntaxErrors->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Buildmetric", "Subsubtitle"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
  "Print", "[", 
   "\"\<\\n\\n   \[CapitalDelta][r_,a_]=(\!\(\*FractionBox[\(\(\\\ \)\(1\)\), \
\(\((1 - a^2)\) + eps\\\ \((1 - r^2)\)\)]\))^2\\n   f[r_]  =(1-r^2)\\n   \
g[a_]   =2-a^2\\n\\n\\n\\n\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.4603926036977377`*^9, 3.460392609494193*^9}, {
   3.4603964671280737`*^9, 3.460396474067587*^9}, {3.460396608649122*^9, 
   3.4603966089839687`*^9}, 3.5419998044826803`*^9, {3.542431675861126*^9, 
   3.5424316770911827`*^9}}],

Cell[BoxData["\<\"\\n\\n   \
\[CapitalDelta][r_,a_]=(\\!\\(\\*FractionBox[\\(\\(\\\\ \\)\\(1\\)\\), \
\\(\\((1 - a^2)\\) + eps\\\\ \\((1 - r^2)\\)\\)]\\))^2\\n   f[r_]  \
=(1-r^2)\\n   g[a_]   =2-a^2\\n\\n\\n\\n\"\>"], "Print",
 CellChangeTimes->{{3.460392614803647*^9, 3.460392630773752*^9}, 
   3.4603927469544163`*^9, {3.4603965912356453`*^9, 3.460396610516452*^9}, 
   3.460396683089012*^9, 3.460397494611452*^9, 3.460398193436068*^9, {
   3.460625264043165*^9, 3.460365935173661*^9}, 3.46037335159484*^9, 
   3.5414356949795847`*^9, 3.541441014225822*^9, 3.541999805034693*^9, 
   3.541999846874145*^9, 3.542001526515849*^9, 3.542294089822762*^9, {
   3.542431682844673*^9, 3.542431693986787*^9}, 3.542434093766657*^9, 
   3.5425162652026987`*^9, 3.542516573974695*^9, 3.542516678231814*^9, 
   3.542529834995153*^9, 3.543226744016018*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Gd", "=", 
   RowBox[{
    RowBox[{"\[CapitalDelta]", "[", 
     RowBox[{"r", ",", "a"}], "]"}], 
    RowBox[{"(", GridBox[{
       {
        RowBox[{"4", 
         RowBox[{"r", "^", "2"}], 
         RowBox[{
          RowBox[{"f", "[", "r", "]"}], "^", "2"}], 
         RowBox[{"Exp", "[", 
          RowBox[{"T", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], "]"}]}], "0", "0", "0", 
        "0"},
       {"0", 
        RowBox[{
         FractionBox["4", 
          RowBox[{
           RowBox[{"f", "[", "r", "]"}], "^", "2"}]], 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"T", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
           RowBox[{
            RowBox[{"r", "^", "2"}], 
            RowBox[{"A", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], "]"}]}], 
        RowBox[{"a", " ", "r", " ", 
         FractionBox["1", 
          RowBox[{"f", "[", "r", "]"}]], 
         RowBox[{"F", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "0", "0"},
       {"0", 
        RowBox[{"a", " ", "r", " ", 
         FractionBox["1", 
          RowBox[{"f", "[", "r", "]"}]], 
         RowBox[{"F", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], 
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
           RowBox[{
            RowBox[{"a", "^", "2"}], " ", 
            RowBox[{"B", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], "]"}], 
         FractionBox["4", 
          RowBox[{"g", "[", "a", "]"}]]}], "0", "0"},
       {"0", "0", "0", 
        FractionBox[
         RowBox[{
          RowBox[{"Exp", "[", 
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "]"}], 
          RowBox[{"g", "[", "a", "]"}], 
          RowBox[{"a", "^", "2"}]}], 
         RowBox[{"1", "-", 
          RowBox[{"\[Theta]1", "^", "2"}]}]], "0"},
       {"0", "0", "0", "0", 
        RowBox[{" ", 
         RowBox[{
          RowBox[{"Exp", "[", 
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "]"}], 
          RowBox[{"g", "[", "a", "]"}], 
          RowBox[{"a", "^", "2"}], 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"\[Theta]1", "^", "2"}]}], ")"}]}]}]}
      }], ")"}]}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"t", ",", "r", ",", "a", ",", "\[Theta]1", ",", "\[Theta]2"}], 
    "}"}]}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"Nind", "=", 
   RowBox[{"Length", "[", "ind", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"BuildMetric", ";"}]}], "Input",
 CellChangeTimes->{{3.408796998476103*^9, 3.408797030516582*^9}, {
   3.408799071597343*^9, 3.408799082644943*^9}, {3.408949739095245*^9, 
   3.408949739644734*^9}, {3.408949841695282*^9, 3.40894984293303*^9}, {
   3.415862083663703*^9, 3.4158620851642113`*^9}, {3.415862334623486*^9, 
   3.415862336021243*^9}, {3.415862388498528*^9, 3.4158623965197372`*^9}, {
   3.4158641082437763`*^9, 3.415864116357332*^9}, {3.415865034672494*^9, 
   3.415865047473855*^9}, {3.415943026431671*^9, 3.415943056090918*^9}, {
   3.42453089354659*^9, 3.424530981705195*^9}, {3.4262330694486513`*^9, 
   3.426233078224708*^9}, {3.42831552177035*^9, 3.428315531925826*^9}, {
   3.482669504390863*^9, 3.482669559589313*^9}, {3.482669593648382*^9, 
   3.4826696108221407`*^9}, {3.4826696421684*^9, 3.460306349771068*^9}, {
   3.460306681872867*^9, 3.4603066892293873`*^9}, {3.460306743915044*^9, 
   3.460306776656151*^9}, {3.4603068906726713`*^9, 3.4603069154556093`*^9}, 
   3.4606109474491568`*^9, {3.5039972414730186`*^9, 3.503997244123049*^9}, {
   3.5172982618161573`*^9, 3.517298294501769*^9}, {3.517302332920382*^9, 
   3.517302353678054*^9}, {3.51730241996021*^9, 3.517302425934087*^9}, {
   3.517302556663072*^9, 3.5173025584548187`*^9}, 3.517579091871194*^9, {
   3.517642973774815*^9, 3.517642975072443*^9}, 3.517658611602713*^9, {
   3.517660901410638*^9, 3.460392650166881*^9}, {3.4603926980532846`*^9, 
   3.460392722992764*^9}, {3.460396656885631*^9, 3.460365914334594*^9}, 
   3.4603730032477007`*^9, 3.541418531306069*^9, {3.5414186577964907`*^9, 
   3.541418666209071*^9}, {3.541419858433352*^9, 3.541419859474297*^9}, 
   3.541999830424646*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"T", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
      SuperscriptBox["r", "2"], " ", 
      SuperscriptBox[
       RowBox[{"f", "[", "r", "]"}], "2"], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}], ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"A", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{"T", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      SuperscriptBox[
       RowBox[{"f", "[", "r", "]"}], "2"]], ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"f", "[", "r", "]"}]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"f", "[", "r", "]"}]], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"B", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{"S", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"g", "[", "a", "]"}]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"1", "-", 
       SuperscriptBox["\[Theta]1", "2"]}]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"S", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
      RowBox[{"g", "[", "a", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.4603966209647903`*^9, 3.460343347499749*^9}, 
   3.460397494661582*^9, 3.460398193510704*^9, {3.46062526408989*^9, 
   3.460365935224835*^9}, 3.460373351645671*^9, 3.541435695010681*^9, 
   3.541441014255809*^9, 3.5419998469070473`*^9, 3.542001526550147*^9, 
   3.542294089858276*^9, 3.542431694034216*^9, 3.542434093814403*^9, 
   3.542516265239091*^9, 3.5425165740131817`*^9, 3.5425166782637253`*^9, 
   3.542529835054676*^9, 3.543226744050332*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"t", ",", "r", ",", "a", ",", "\[Theta]1", ",", "\[Theta]2"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.4603966209647903`*^9, 3.460343347499749*^9}, 
   3.460397494661582*^9, 3.460398193510704*^9, {3.46062526408989*^9, 
   3.460365935224835*^9}, 3.460373351645671*^9, 3.541435695010681*^9, 
   3.541441014255809*^9, 3.5419998469070473`*^9, 3.542001526550147*^9, 
   3.542294089858276*^9, 3.542431694034216*^9, 3.542434093814403*^9, 
   3.542516265239091*^9, 3.5425165740131817`*^9, 3.5425166782637253`*^9, 
   3.542529835054676*^9, 3.54322674405368*^9}],

Cell[BoxData["5"], "Output",
 CellChangeTimes->{{3.4603966209647903`*^9, 3.460343347499749*^9}, 
   3.460397494661582*^9, 3.460398193510704*^9, {3.46062526408989*^9, 
   3.460365935224835*^9}, 3.460373351645671*^9, 3.541435695010681*^9, 
   3.541441014255809*^9, 3.5419998469070473`*^9, 3.542001526550147*^9, 
   3.542294089858276*^9, 3.542431694034216*^9, 3.542434093814403*^9, 
   3.542516265239091*^9, 3.5425165740131817`*^9, 3.5425166782637253`*^9, 
   3.542529835054676*^9, 3.543226744055319*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Gd"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"T", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
      SuperscriptBox["r", "2"], " ", 
      SuperscriptBox[
       RowBox[{"f", "[", "r", "]"}], "2"], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}], ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"A", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{"T", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      SuperscriptBox[
       RowBox[{"f", "[", "r", "]"}], "2"]], ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"f", "[", "r", "]"}]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"f", "[", "r", "]"}]], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"B", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{"S", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"g", "[", "a", "]"}]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"1", "-", 
       SuperscriptBox["\[Theta]1", "2"]}]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"S", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
      RowBox[{"g", "[", "a", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.426737013947981*^9, 3.42831519475591*^9, 3.428315553704377*^9, 
   3.42831688012332*^9, 3.428403895402966*^9, 3.428404282812348*^9, 
   3.431855679361175*^9, 3.431863727521323*^9, 3.482645295470035*^9, 
   3.482645359355171*^9, 3.482645465220532*^9, 3.482646536463307*^9, 
   3.4826465772437983`*^9, 3.4826543017657003`*^9, 3.482660739570448*^9, {
   3.4826656670958242`*^9, 3.460345346563177*^9}, 3.482732901086844*^9, 
   3.483268305672525*^9, 3.483274831485346*^9, 3.483355831699278*^9, 
   3.4951748242050257`*^9, 3.497953163855152*^9, 3.497953489287703*^9, 
   3.5014842100803003`*^9, {3.5014865241306953`*^9, 3.4603905383513203`*^9}, 
   3.4604294104843483`*^9, 3.46042947896661*^9, {3.503999600339315*^9, 
   3.4603433478172483`*^9}, 3.460397496352495*^9, 3.460398195234408*^9, {
   3.4606252658864193`*^9, 3.4603659368972*^9}, 3.4603733533587*^9, 
   3.5414356961283913`*^9, 3.54144101540274*^9, 3.5419998477583447`*^9, 
   3.542001527431053*^9, 3.542294090728849*^9, 3.54243169485117*^9, 
   3.542434094649781*^9, 3.542516266100519*^9, 3.54251657482975*^9, 
   3.542516679148966*^9, 3.542529835915996*^9, 3.543226744863751*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Gu"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        RowBox[{"T", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], 
      RowBox[{"4", " ", 
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox[
        RowBox[{"f", "[", "r", "]"}], "2"], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]], ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"f", "[", "r", "]"}], "2"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], " ", 
             RowBox[{"B", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
            RowBox[{"S", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"F", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
          RowBox[{"g", "[", "a", "]"}]}]}], ")"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]], ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"f", "[", "r", "]"}], " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"g", "[", "a", "]"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"B", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{"S", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"F", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
          RowBox[{"g", "[", "a", "]"}]}]}], ")"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"f", "[", "r", "]"}], " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"g", "[", "a", "]"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"B", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{"S", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"F", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
          RowBox[{"g", "[", "a", "]"}]}]}], ")"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]], ",", 
     FractionBox["1", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "4"]}], " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["r", "2"]}], " ", 
           RowBox[{"A", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
          RowBox[{"T", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
        SuperscriptBox["r", "2"], " ", 
        SuperscriptBox[
         RowBox[{"F", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], "+", 
       FractionBox[
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"B", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
         RowBox[{"\[CapitalDelta]", "[", 
          RowBox[{"r", ",", "a"}], "]"}]}], 
        RowBox[{"g", "[", "a", "]"}]]}]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", 
          RowBox[{"S", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[Theta]1", "2"]}], ")"}]}], 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"g", "[", "a", "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}]]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", 
         RowBox[{"S", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
        RowBox[{"g", "[", "a", "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}]]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.426737013996367*^9, 3.428315194823951*^9, 3.42831555372094*^9, 
   3.428316880162258*^9, 3.428403895438301*^9, 3.42840428286333*^9, 
   3.431855679506925*^9, 3.431863727579101*^9, 3.482645295502652*^9, 
   3.482645359398937*^9, 3.482645465282672*^9, 3.4826465365215797`*^9, 
   3.482646577301097*^9, 3.482654301950992*^9, 3.482660739739355*^9, {
   3.482665667186685*^9, 3.4603453466175222`*^9}, 3.4827329011606503`*^9, 
   3.483268305726141*^9, 3.483274831596257*^9, 3.4833558317557917`*^9, 
   3.49517482426343*^9, 3.497953163911227*^9, 3.497953489425228*^9, 
   3.501484210221078*^9, {3.5014865242391787`*^9, 3.460390538438959*^9}, 
   3.460429410533709*^9, 3.460429479043961*^9, {3.5039996003967047`*^9, 
   3.4603433478632727`*^9}, 3.460397496429948*^9, 3.4603981953136177`*^9, {
   3.460625265957264*^9, 3.4603659369408827`*^9}, 3.4603733534335823`*^9, 
   3.5414356961843777`*^9, 3.541441015458969*^9, 3.541999847822082*^9, 
   3.542001527468235*^9, 3.5422940907587423`*^9, 3.5424316948897657`*^9, 
   3.542434094700303*^9, 3.542516266188373*^9, 3.542516574912799*^9, 
   3.5425166791825733`*^9, 3.5425298360450974`*^9, 3.543226744902025*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"detg", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Det", "[", "Gd", "]"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"4", " ", 
  SuperscriptBox["a", "4"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"S", "[", 
      RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
    RowBox[{"T", "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
  SuperscriptBox["r", "2"], " ", 
  RowBox[{"g", "[", "a", "]"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"16", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"A", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"B", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
       RowBox[{"S", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
       RowBox[{"T", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["r", "2"], " ", 
     SuperscriptBox[
      RowBox[{"F", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
     RowBox[{"g", "[", "a", "]"}]}]}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{"\[CapitalDelta]", "[", 
    RowBox[{"r", ",", "a"}], "]"}], "5"]}]], "Output",
 CellChangeTimes->{
  3.426737014038818*^9, 3.428315194987363*^9, 3.428315553807802*^9, 
   3.428316880199193*^9, 3.4284038954693108`*^9, 3.428404282950614*^9, 
   3.431855679578286*^9, 3.4318637276288977`*^9, 3.482645295534935*^9, 
   3.482645359432629*^9, 3.482645465322057*^9, 3.482646536679943*^9, 
   3.482646577444168*^9, 3.482654302025573*^9, 3.482660739810965*^9, {
   3.4826656672687674`*^9, 3.460345346748376*^9}, 3.482732901244331*^9, 
   3.483268305791041*^9, 3.483274831689481*^9, 3.4833558318200827`*^9, 
   3.495174824307178*^9, 3.497953163960969*^9, 3.497953489575306*^9, 
   3.501484210316465*^9, {3.5014865243333797`*^9, 3.4603905385408373`*^9}, 
   3.4604294106016273`*^9, 3.460429479111375*^9, {3.503999600438518*^9, 
   3.460343347915853*^9}, 3.460397496568387*^9, 3.460398195393688*^9, {
   3.4606252661078997`*^9, 3.460365937009363*^9}, 3.4603733535789757`*^9, 
   3.5414356962284184`*^9, 3.54144101549096*^9, 3.541999847874116*^9, 
   3.542001527498621*^9, 3.5422940907905283`*^9, 3.54243169492347*^9, 
   3.542434094738538*^9, 3.54251626621988*^9, 3.5425165749712057`*^9, 
   3.5425166792342157`*^9, 3.542529836103292*^9, 3.543226744933688*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRrun2.nb", "Subsubtitle"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\[CapitalGamma]", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"\[CapitalGamma]", ",", "3", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "u"}], "}"}]}], "]"}], ";"}], "\n"}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R4", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R4", ",", "4", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "d", ",", "u"}], "}"}]}], "]"}], 
  ";"}], "\n"}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "G2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"G2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"\[CapitalGamma]", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"\[CapitalGamma]", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], 
         RowBox[{"GT", "[", 
          RowBox[{"G", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
            "}"}]}], "]"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "+", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "ss1", "]"}], "]"}]}], "]"}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalGamma]", "=", 
   RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.426232729469757*^9, 3.426232735540435*^9}}],

Cell[BoxData[
 RowBox[{"Do", "[", "\n", "\t", 
  RowBox[{
   RowBox[{"R4", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R4", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      "\n", "\t", "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "+", "\n", "\t\t\t", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}]}], "\n", 
     "\t\t", "\n", "\t\t", "]"}]}], "\n", "\t\t", ",", "\n", "\t", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i4", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R4", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"R2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"GT", "[", 
         RowBox[{"R4", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}],
          "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "\n", 
     "\t\t", "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"GT", "[", 
      RowBox[{"R2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"G2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"G2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"GT", "[", 
        RowBox[{"R2", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
        "]"}], "-", 
       RowBox[{
        FractionBox["1", "2"], 
        RowBox[{"GT", "[", 
         RowBox[{"G", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
         "]"}], "Ricci"}]}]}], "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "G2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "Ricci", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"]
}, Closed]],

Cell[CellGroupData[{

Cell["Einstein equations", "Subsubtitle"],

Cell[CellGroupData[{

Cell[BoxData["ind"], "Input",
 CellChangeTimes->{{3.482645378412899*^9, 3.4826453786609163`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"t", ",", "r", ",", "a", ",", "\[Theta]1", ",", "\[Theta]2"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.482645396895133*^9, 3.482645499809284*^9, 3.482646611846545*^9, 
   3.48265433638922*^9, {3.482665675369759*^9, 3.460345373817977*^9}, 
   3.482732919598102*^9, 3.4832683242802143`*^9, 3.483274850617939*^9, 
   3.483355850660965*^9, 3.495174843468848*^9, 3.497953181922439*^9, 
   3.497953507686852*^9, 3.5014842285458813`*^9, {3.501486543945709*^9, 
   3.4603905641391706`*^9}, 3.460429437199853*^9, 3.4604295045078793`*^9, {
   3.503999615054343*^9, 3.4603433738186502`*^9}, 3.460397545985814*^9, 
   3.460398244813052*^9, {3.460625316134089*^9, 3.4603659842036743`*^9}, 
   3.460373401256411*^9, 3.541435714343343*^9, 3.541441033648178*^9, 
   3.54199986288216*^9, 3.542001542433325*^9, 3.5422941058672333`*^9, 
   3.542431709780489*^9, 3.5424341098784037`*^9, 3.542516281261557*^9, 
   3.542516590109642*^9, 3.5425166940060062`*^9, 3.542529866633142*^9, 
   3.543226759501643*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TangVec", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "u", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
   "}"}]}]], "Input",
 CellChangeTimes->{{3.482645319964726*^9, 3.482645321420919*^9}, {
  3.482645369742679*^9, 3.482645398774542*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "u", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.4826453938568697`*^9, 3.482645399209482*^9}, 
   3.48264549990095*^9, 3.4826466119131927`*^9, 3.482654336461301*^9, 
   3.482661037405292*^9, 3.4826611049629107`*^9, {3.4826656754454536`*^9, 
   3.460345373890777*^9}, 3.48273291967444*^9, 3.4832683243369207`*^9, 
   3.483274850726749*^9, 3.48335585071898*^9, 3.49517484354065*^9, 
   3.497953181977542*^9, 3.49795350775769*^9, 3.501484228646851*^9, {
   3.501486544055847*^9, 3.460390564238563*^9}, 3.4604294372576113`*^9, 
   3.460429504591004*^9, {3.503999615107829*^9, 3.460343373920657*^9}, 
   3.460397546066593*^9, 3.4603976151938047`*^9, 3.4603977205260897`*^9, 
   3.460398244895062*^9, {3.4606253161639013`*^9, 3.460365984260375*^9}, 
   3.460373401309203*^9, 3.541435714381008*^9, 3.5414410336888742`*^9, 
   3.5419998629384117`*^9, 3.542001542477748*^9, 3.5422941059023037`*^9, 
   3.5424317098483953`*^9, 3.542434109910468*^9, 3.542516281297637*^9, 
   3.542516590139367*^9, 3.542516694048871*^9, 3.542529866689437*^9, 
   3.543226759539151*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NormVec", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "u", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "c", ",", "1", ",", "0", ",", "0"}], "}"}]}], 
   "}"}]}]], "Input",
 CellChangeTimes->{{3.482645401975491*^9, 3.482645411285253*^9}, {
  3.4826458546230803`*^9, 3.482645859613565*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "u", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "c", ",", "1", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.482645412231688*^9, 3.4826454147952023`*^9}, 
   3.482645499988126*^9, {3.482645855809843*^9, 3.482645883352165*^9}, 
   3.482646611979519*^9, 3.482654336511277*^9, 3.482661038021718*^9, 
   3.482661105445985*^9, {3.48266567551117*^9, 3.460345383768354*^9}, 
   3.482732919741027*^9, 3.483268324387245*^9, 3.4832748508268423`*^9, 
   3.483355850769663*^9, 3.495174843607183*^9, 3.497953182026888*^9, 
   3.497953507824995*^9, 3.501484228748543*^9, {3.5014865441560593`*^9, 
   3.4603905643381643`*^9}, 3.46042943731177*^9, 3.460429504658307*^9, {
   3.503999615158149*^9, 3.460343374012308*^9}, {3.460397546116476*^9, 
   3.460397554586464*^9}, 3.460397616057626*^9, 3.460397721507806*^9, 
   3.4603982449627333`*^9, {3.460625316191557*^9, 3.4603659843147182`*^9}, 
   3.460373401362619*^9, 3.541435714413704*^9, 3.541441033726552*^9, 
   3.541999862990693*^9, 3.542001542517255*^9, 3.54229410593953*^9, 
   3.5424317098814907`*^9, 3.542434109946207*^9, 3.5425162813354177`*^9, 
   3.542516590175214*^9, 3.542516694081388*^9, 3.542529866740209*^9, 
   3.5432267595731363`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"trT", "[", 
    RowBox[{
     RowBox[{"outerT", "[", 
      RowBox[{"NormVec", ",", "TangVec"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.482645418577425*^9, 3.482645427289304*^9}, {
  3.482645468181383*^9, 3.482645476589221*^9}, {3.482645843815053*^9, 
  3.482645847782482*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", "c", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"A", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
        RowBox[{"T", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
     RowBox[{"a", " ", "r", " ", 
      RowBox[{"f", "[", "r", "]"}], " ", 
      RowBox[{"F", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}], " ", 
   RowBox[{"\[CapitalDelta]", "[", 
    RowBox[{"r", ",", "a"}], "]"}]}], 
  SuperscriptBox[
   RowBox[{"f", "[", "r", "]"}], "2"]]], "Output",
 CellChangeTimes->{{3.482645500150728*^9, 3.482645500248397*^9}, {
   3.482645848182082*^9, 3.482645884001075*^9}, 3.4826466120466337`*^9, 
   3.482654336578025*^9, 3.4826610385554256`*^9, 3.48266110607915*^9, {
   3.4826656755777893`*^9, 3.4603453844097233`*^9}, 3.4827329198242073`*^9, 
   3.483268324437192*^9, 3.483274850926392*^9, 3.4833558508365517`*^9, 
   3.495174843674325*^9, 3.497953182092972*^9, 3.497953507891675*^9, 
   3.501484228848415*^9, {3.50148654425138*^9, 3.460390564454529*^9}, 
   3.460429437396255*^9, 3.4604295047416677`*^9, {3.5039996152234488`*^9, 
   3.460343374113392*^9}, {3.460397546195798*^9, 3.460397556094911*^9}, {
   3.460397612427554*^9, 3.4603976186530657`*^9}, 3.460397722451044*^9, 
   3.4603982450435953`*^9, {3.460625316245699*^9, 3.460365984388968*^9}, 
   3.460373401431588*^9, 3.541435714454726*^9, 3.5414410337725983`*^9, 
   3.541999863034059*^9, 3.542001542564604*^9, 3.5422941059718018`*^9, 
   3.5424317099376907`*^9, 3.54243411003511*^9, 3.542516281383116*^9, 
   3.542516590206789*^9, 3.54251669412939*^9, 3.542529866790287*^9, 
   3.5432267596266947`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"solc", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"tmp", "\[Equal]", "0"}], ",", "c"}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4826458619731216`*^9, 3.482645885469399*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"c", "\[Rule]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", "a", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["r", "2"]}], " ", 
       RowBox[{"A", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
      RowBox[{"T", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", " ", 
    RowBox[{"f", "[", "r", "]"}], " ", 
    RowBox[{"F", "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.482645866916765*^9, 3.482645885850039*^9}, 
   3.482646612112681*^9, 3.482654336644636*^9, 3.48266103912289*^9, 
   3.482661106661934*^9, {3.482665675773703*^9, 3.4603453850827007`*^9}, 
   3.482732919892187*^9, 3.4832683244871187`*^9, 3.483274851026471*^9, 
   3.483355850902607*^9, 3.495174843797553*^9, 3.497953182236517*^9, 
   3.497953507962245*^9, 3.501484228947846*^9, {3.501486544367445*^9, 
   3.460390564571981*^9}, 3.4604294374785643`*^9, 3.4604295052381477`*^9, {
   3.503999615273387*^9, 3.46034337432885*^9}, {3.4603975464008017`*^9, 
   3.460397559265963*^9}, {3.460397608269051*^9, 3.460397619840056*^9}, 
   3.460397723756569*^9, 3.460398245129245*^9, {3.460625316305313*^9, 
   3.460365984499096*^9}, 3.460373401538006*^9, 3.541435714497484*^9, 
   3.5414410338127327`*^9, 3.541999863090201*^9, 3.542001542611764*^9, 
   3.542294106020125*^9, 3.542431709982963*^9, 3.542434110097982*^9, 
   3.542516281513195*^9, 3.542516590243993*^9, 3.542516694177763*^9, 
   3.542529866864648*^9, 3.54322675967332*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"norm", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"trT", "[", 
     RowBox[{
      RowBox[{"outerT", "[", 
       RowBox[{"NormVec", ",", "NormVec"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "]"}], "/.", "solc"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.482645887033798*^9, 3.482645944381516*^9}, 
   3.482646520071669*^9, {3.4826610549294243`*^9, 3.482661055727974*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "4"]}], " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["r", "2"]}], " ", 
      RowBox[{"A", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
     RowBox[{"T", "[", 
      RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
   SuperscriptBox["r", "2"], " ", 
   SuperscriptBox[
    RowBox[{"F", "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
   RowBox[{"\[CapitalDelta]", "[", 
    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"B", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
      RowBox[{"S", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
    RowBox[{"\[CapitalDelta]", "[", 
     RowBox[{"r", ",", "a"}], "]"}]}], 
   RowBox[{"g", "[", "a", "]"}]]}]], "Output",
 CellChangeTimes->{{3.4826459114463377`*^9, 3.482645946064207*^9}, 
   3.482646521174985*^9, 3.482646612179653*^9, 3.4826543367113037`*^9, {
   3.482661039770041*^9, 3.482661057205875*^9}, 3.482661107310892*^9, {
   3.482665675844986*^9, 3.460345385891876*^9}, 3.482732919959566*^9, 
   3.483268324537109*^9, 3.483274851126627*^9, 3.48335585096931*^9, 
   3.495174843861245*^9, 3.4979531822934227`*^9, 3.4979535080257998`*^9, 
   3.501484229049124*^9, {3.501486544483901*^9, 3.4603905646877317`*^9}, 
   3.460429437562561*^9, 3.460429505307798*^9, {3.503999615328701*^9, 
   3.460343374428726*^9}, {3.460397546467606*^9, 3.460397560792774*^9}, {
   3.4603976234983683`*^9, 3.460397639647757*^9}, {3.460397714992196*^9, 
   3.460397724666641*^9}, 3.4603982452107267`*^9, {3.460625316353703*^9, 
   3.4603659845427628`*^9}, 3.460373401583537*^9, 3.541435714536965*^9, 
   3.541441033856237*^9, 3.5419998783147707`*^9, 3.542001542654808*^9, 
   3.54229410605821*^9, 3.542431710031953*^9, 3.542434110212654*^9, 
   3.542516281556142*^9, 3.542516590289789*^9, 3.542516694226733*^9, 
   3.542529866923061*^9, 3.543226759727509*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NormVec", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "u", "}"}], ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"Sqrt", "[", "norm", "]"}]], 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", "4"]}], " ", "a", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["r", "2"]}], " ", 
            RowBox[{"A", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
           RowBox[{"T", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", " ", 
         RowBox[{"f", "[", "r", "]"}], " ", 
         RowBox[{"F", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], ",", "1", ",", "0", ",",
         "0"}], "}"}]}], "]"}]}], "}"}]}]], "Input",
 CellChangeTimes->{
  3.4826458784255457`*^9, {3.4826459516081743`*^9, 3.482645973654932*^9}, {
   3.482646535197999*^9, 3.4826465537111883`*^9}, {3.4826610604906797`*^9, 
   3.460345405029395*^9}, 3.4832683401604548`*^9, {3.4979535355921383`*^9, 
   3.460397584552984*^9}, {3.460397713227003*^9, 3.460366049162068*^9}, 
   3.541441069057948*^9, {3.541999902156464*^9, 3.5419999028934383`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "u", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"a", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["r", "2"]}], " ", 
           RowBox[{"A", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
          RowBox[{"T", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", " ", 
        RowBox[{"f", "[", "r", "]"}], " ", 
        RowBox[{"F", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], 
       RowBox[{"2", " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["r", "2"]}], " ", 
                RowBox[{"A", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
               RowBox[{"T", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
             SuperscriptBox["r", "2"], " ", 
             SuperscriptBox[
              RowBox[{"F", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
            FractionBox[
             RowBox[{"16", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", 
                 RowBox[{"B", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                RowBox[{"S", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
             RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
          RowBox[{"\[CapitalDelta]", "[", 
           RowBox[{"r", ",", "a"}], "]"}]}]]}]]}], ",", 
     FractionBox["2", 
      SqrtBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["a", "2"]}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["r", "2"]}], " ", 
              RowBox[{"A", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
             RowBox[{"T", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox[
            RowBox[{"F", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
          FractionBox[
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               RowBox[{"B", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
              RowBox[{"S", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
           RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}]]], ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.482645879356182*^9, {3.482645961553833*^9, 3.482645974077807*^9}, 
   3.482646612245695*^9, 3.482654336777485*^9, {3.482661040321257*^9, 
   3.482661062939979*^9}, 3.482661109026106*^9, {3.482665675938364*^9, 
   3.460345405768785*^9}, 3.4827329202064533`*^9, 3.483268341264225*^9, 
   3.483274851436404*^9, 3.4833558512792063`*^9, 3.495174844184272*^9, 
   3.497953182665312*^9, 3.497953538324436*^9, 3.501484229381893*^9, {
   3.501486544818342*^9, 3.460390565416277*^9}, 3.46042943833361*^9, 
   3.460429506062654*^9, {3.50399961569064*^9, 3.460343375184429*^9}, {
   3.460397567778631*^9, 3.4603975855753593`*^9}, {3.46039764461899*^9, 
   3.460397647414546*^9}, 3.4603977312320147`*^9, 3.460398247315359*^9, {
   3.460625318355755*^9, 3.460366050527224*^9}, 3.460373403563223*^9, 
   3.541435715780294*^9, 3.541441072499552*^9, 3.541999904665681*^9, 
   3.5420015435324783`*^9, 3.542294106936494*^9, 3.542431711028059*^9, 
   3.542434111101059*^9, 3.542516282439705*^9, 3.54251659117076*^9, 
   3.54251669511514*^9, 3.542529867967723*^9, 3.543226760593914*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"trT", "[", 
   RowBox[{
    RowBox[{"outerT", "[", 
     RowBox[{"NormVec", ",", "NormVec"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.482661065734774*^9, 3.4826610789595137`*^9}}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{
  3.4826610793363543`*^9, 3.482661109925275*^9, {3.482665675994561*^9, 
   3.460345406663004*^9}, 3.4827329202736473`*^9, 3.483268342771421*^9, 
   3.483268383662122*^9, 3.483274851751947*^9, 3.483355851334548*^9, 
   3.495174844626775*^9, 3.497953182736599*^9, 3.4979535393096867`*^9, 
   3.501484229641233*^9, {3.5014865451460876`*^9, 3.460390565682083*^9}, 
   3.4604294385425787`*^9, 3.460429506244069*^9, {3.503999615763026*^9, 
   3.46034337543242*^9}, 3.4603977334598703`*^9, 3.460398247593706*^9, {
   3.46062531857738*^9, 3.46036605146989*^9}, 3.460373403796906*^9, 
   3.5414357160380907`*^9, 3.541441073950495*^9, 3.541999906169791*^9, 
   3.542001543647773*^9, 3.542294107051548*^9, 3.54243171109612*^9, 
   3.5424341112307*^9, 3.542516282533437*^9, 3.542516591313944*^9, 
   3.542516695243012*^9, 3.542529868098463*^9, 3.54322676068855*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"trT", "[", 
   RowBox[{
    RowBox[{"outerT", "[", 
     RowBox[{"TangVec", ",", "NormVec"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{3.482661116857547*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.48266111728564*^9, {3.4826656760602818`*^9, 3.460345407972846*^9}, 
   3.4827329203405867`*^9, 3.483268343566309*^9, 3.483268384244651*^9, 
   3.483274851858819*^9, 3.483355851401087*^9, 3.49517484474189*^9, 
   3.497953182835265*^9, 3.497953540192875*^9, 3.501484229735509*^9, {
   3.501486545266227*^9, 3.460390565785603*^9}, 3.460429438666939*^9, 
   3.460429506302597*^9, {3.50399961586336*^9, 3.4603433755067387`*^9}, 
   3.460397734590137*^9, 3.460398247777378*^9, {3.460625318633223*^9, 
   3.460366052308152*^9}, 3.4603734039171886`*^9, 3.5414357162502317`*^9, 
   3.541441074853291*^9, 3.541999906896966*^9, 3.542001543680332*^9, 
   3.542294107087545*^9, 3.542431711178936*^9, 3.542434111265913*^9, 
   3.542516282572522*^9, 3.5425165913783197`*^9, 3.542516695278946*^9, 
   3.5425298681556597`*^9, 3.543226760725486*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"q", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"d", ",", "d"}], "}"}], ",", 
       RowBox[{"Gd", "-", 
        RowBox[{
         RowBox[{"outerT", "[", 
          RowBox[{"NormVec", ",", "NormVec"}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MatrixForm", "[", "Gd", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", 
  RowBox[{"q", "[", 
   RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.482661126460228*^9, 3.4826611805206537`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"T", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox[
        RowBox[{"f", "[", "r", "]"}], "2"], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], "0", "0", "0", "0"},
     {"0", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"A", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
          RowBox[{"T", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], 
       SuperscriptBox[
        RowBox[{"f", "[", "r", "]"}], "2"]], 
      FractionBox[
       RowBox[{"a", " ", "r", " ", 
        RowBox[{"F", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], 
       RowBox[{"f", "[", "r", "]"}]], "0", "0"},
     {"0", 
      FractionBox[
       RowBox[{"a", " ", "r", " ", 
        RowBox[{"F", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], 
       RowBox[{"f", "[", "r", "]"}]], 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"B", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
          RowBox[{"S", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], 
       RowBox[{"g", "[", "a", "]"}]], "0", "0"},
     {"0", "0", "0", 
      FractionBox[
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"S", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
        RowBox[{"g", "[", "a", "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], 
       RowBox[{"1", "-", 
        SuperscriptBox["\[Theta]1", "2"]}]], "0"},
     {"0", "0", "0", "0", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.482661147027567*^9, 3.4826611807315187`*^9}, {
   3.4826656761300983`*^9, 3.4603454098331013`*^9}, 3.4827329204079514`*^9, 
   3.48326838558283*^9, 3.483274851960454*^9, 3.483355851470969*^9, 
   3.495174844808804*^9, 3.497953183117558*^9, 3.497953541537301*^9, 
   3.501484229835047*^9, {3.501486545371581*^9, 3.460390565903183*^9}, 
   3.460429438778407*^9, 3.460429506389037*^9, {3.503999615962226*^9, 
   3.4603433755939074`*^9}, 3.460397739642098*^9, 3.460398247939376*^9, {
   3.4606253186910763`*^9, 3.4603660533651037`*^9}, 3.4603734040724487`*^9, 
   3.541435716778173*^9, 3.541441075915968*^9, 3.5419999078299932`*^9, 
   3.5420015437151937`*^9, 3.5422941071287117`*^9, 3.54243171125905*^9, 
   3.54243411131523*^9, 3.5425162826052*^9, 3.5425165914305058`*^9, 
   3.542516695336603*^9, 3.542529868211382*^9, 3.54322676078063*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"T", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox[
        RowBox[{"f", "[", "r", "]"}], "2"], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], "0", "0", "0", "0"},
     {"0", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"A", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
          RowBox[{"T", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], 
       SuperscriptBox[
        RowBox[{"f", "[", "r", "]"}], "2"]], 
      FractionBox[
       RowBox[{"a", " ", "r", " ", 
        RowBox[{"F", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], 
       RowBox[{"f", "[", "r", "]"}]], "0", "0"},
     {"0", 
      FractionBox[
       RowBox[{"a", " ", "r", " ", 
        RowBox[{"F", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], 
       RowBox[{"f", "[", "r", "]"}]], 
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["r", "2"]}], " ", 
          RowBox[{"A", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
         RowBox[{"T", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox[
        RowBox[{"F", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], "0", "0"},
     {"0", "0", "0", 
      FractionBox[
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"S", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
        RowBox[{"g", "[", "a", "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], 
       RowBox[{"1", "-", 
        SuperscriptBox["\[Theta]1", "2"]}]], "0"},
     {"0", "0", "0", "0", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "2"]}], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.482661147027567*^9, 3.4826611807315187`*^9}, {
   3.4826656761300983`*^9, 3.4603454098331013`*^9}, 3.4827329204079514`*^9, 
   3.48326838558283*^9, 3.483274851960454*^9, 3.483355851470969*^9, 
   3.495174844808804*^9, 3.497953183117558*^9, 3.497953541537301*^9, 
   3.501484229835047*^9, {3.501486545371581*^9, 3.460390565903183*^9}, 
   3.460429438778407*^9, 3.460429506389037*^9, {3.503999615962226*^9, 
   3.4603433755939074`*^9}, 3.460397739642098*^9, 3.460398247939376*^9, {
   3.4606253186910763`*^9, 3.4603660533651037`*^9}, 3.4603734040724487`*^9, 
   3.541435716778173*^9, 3.541441075915968*^9, 3.5419999078299932`*^9, 
   3.5420015437151937`*^9, 3.5422941071287117`*^9, 3.54243171125905*^9, 
   3.54243411131523*^9, 3.5425162826052*^9, 3.5425165914305058`*^9, 
   3.542516695336603*^9, 3.542529868211382*^9, 3.543226760785295*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"trT", "[", 
    RowBox[{
     RowBox[{"outerT", "[", 
      RowBox[{"q", ",", "NormVec"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"trT", "[", 
    RowBox[{
     RowBox[{"outerT", "[", 
      RowBox[{"q", ",", "TangVec"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"trT", "[", 
   RowBox[{
    RowBox[{"outerT", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"d", ",", "d"}], "}"}], ",", "Gd"}], "}"}], ",", "TangVec"}],
      "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.4826611936232367`*^9, 3.482661223289483*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "d", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.482661206242777*^9, 3.4826612240707273`*^9}, {
   3.482665676264707*^9, 3.460345436476618*^9}, 3.482732920482984*^9, 
   3.4832683872309437`*^9, 3.4832748520751867`*^9, 3.483355851783144*^9, 
   3.495174844893948*^9, 3.497953183445979*^9, 3.4979535425295963`*^9, 
   3.501484229967771*^9, {3.5014865454883547`*^9, 3.460390566032054*^9}, 
   3.4604294389890823`*^9, 3.460429506493195*^9, {3.503999616253805*^9, 
   3.4603433757070503`*^9}, 3.460397743066276*^9, 3.460398248143712*^9, {
   3.460625318805606*^9, 3.4603660544298983`*^9}, 3.4603734042813787`*^9, 
   3.541435717627144*^9, 3.541441077040722*^9, 3.5419999091531487`*^9, 
   3.542001543768545*^9, 3.54229410718285*^9, 3.542431711415169*^9, 
   3.5424341114188843`*^9, 3.5425162826614447`*^9, 3.5425165915124063`*^9, 
   3.5425166953916807`*^9, 3.542529868303076*^9, 3.5432267608363657`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "d", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"A", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{"T", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      SuperscriptBox[
       RowBox[{"f", "[", "r", "]"}], "2"]], ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"f", "[", "r", "]"}]], ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.482661206242777*^9, 3.4826612240707273`*^9}, {
   3.482665676264707*^9, 3.460345436476618*^9}, 3.482732920482984*^9, 
   3.4832683872309437`*^9, 3.4832748520751867`*^9, 3.483355851783144*^9, 
   3.495174844893948*^9, 3.497953183445979*^9, 3.4979535425295963`*^9, 
   3.501484229967771*^9, {3.5014865454883547`*^9, 3.460390566032054*^9}, 
   3.4604294389890823`*^9, 3.460429506493195*^9, {3.503999616253805*^9, 
   3.4603433757070503`*^9}, 3.460397743066276*^9, 3.460398248143712*^9, {
   3.460625318805606*^9, 3.4603660544298983`*^9}, 3.4603734042813787`*^9, 
   3.541435717627144*^9, 3.541441077040722*^9, 3.5419999091531487`*^9, 
   3.542001543768545*^9, 3.54229410718285*^9, 3.542431711415169*^9, 
   3.5424341114188843`*^9, 3.5425162826614447`*^9, 3.5425165915124063`*^9, 
   3.5425166953916807`*^9, 3.542529868303076*^9, 3.543226760875607*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "d", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"A", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{"T", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      SuperscriptBox[
       RowBox[{"f", "[", "r", "]"}], "2"]], ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"f", "[", "r", "]"}]], ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.482661206242777*^9, 3.4826612240707273`*^9}, {
   3.482665676264707*^9, 3.460345436476618*^9}, 3.482732920482984*^9, 
   3.4832683872309437`*^9, 3.4832748520751867`*^9, 3.483355851783144*^9, 
   3.495174844893948*^9, 3.497953183445979*^9, 3.4979535425295963`*^9, 
   3.501484229967771*^9, {3.5014865454883547`*^9, 3.460390566032054*^9}, 
   3.4604294389890823`*^9, 3.460429506493195*^9, {3.503999616253805*^9, 
   3.4603433757070503`*^9}, 3.460397743066276*^9, 3.460398248143712*^9, {
   3.460625318805606*^9, 3.4603660544298983`*^9}, 3.4603734042813787`*^9, 
   3.541435717627144*^9, 3.541441077040722*^9, 3.5419999091531487`*^9, 
   3.542001543768545*^9, 3.54229410718285*^9, 3.542431711415169*^9, 
   3.5424341114188843`*^9, 3.5425162826614447`*^9, 3.5425165915124063`*^9, 
   3.5425166953916807`*^9, 3.542529868303076*^9, 3.543226760909976*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"K", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"trT", "[", 
    RowBox[{
     RowBox[{"outerT", "[", 
      RowBox[{"q", ",", 
       RowBox[{"trT", "[", 
        RowBox[{
         RowBox[{"outerT", "[", 
          RowBox[{"q", ",", 
           RowBox[{"covDT", "[", "NormVec", "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"2", ",", "4"}], "}"}], "}"}]}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2", ",", "4"}], "}"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.482661293018702*^9, 3.4826613845439863`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"d", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["r", "2"]}], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox[
            RowBox[{"f", "[", "r", "]"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "a", " ", "r", " ", 
              RowBox[{"F", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
              RowBox[{"\[CapitalDelta]", "[", 
               RowBox[{"r", ",", "a"}], "]"}], " ", 
              RowBox[{
               SuperscriptBox["f", "\[Prime]",
                MultilineFunction->None], "[", "r", "]"}]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["r", "2"], " ", 
                 RowBox[{"A", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                RowBox[{"T", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["\[CapitalDelta]", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"r", ",", "a"}], "]"}], "+", 
                RowBox[{
                 RowBox[{"\[CapitalDelta]", "[", 
                  RowBox[{"r", ",", "a"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["T", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
             RowBox[{"a", " ", 
              RowBox[{"f", "[", "r", "]"}], " ", 
              RowBox[{"F", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"r", " ", 
                 RowBox[{
                  SuperscriptBox["\[CapitalDelta]", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                RowBox[{
                 RowBox[{"\[CapitalDelta]", "[", 
                  RowBox[{"r", ",", "a"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", 
                   RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
               ")"}]}]}], ")"}]}], ")"}], "/", 
         RowBox[{"(", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["r", "2"]}], " ", 
                  RowBox[{"A", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                 RowBox[{"T", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
               SuperscriptBox["r", "2"], " ", 
               SuperscriptBox[
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
              FractionBox[
               RowBox[{"16", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
               RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"r", ",", "a"}], "]"}]}]], ")"}]}]}], ",", "0", ",", "0",
        ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"A", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{"T", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["\[CapitalDelta]", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"r", ",", "a"}], "]"}], "+", 
             RowBox[{
              RowBox[{"\[CapitalDelta]", "[", 
               RowBox[{"r", ",", "a"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["r", "2"], " ", 
                 RowBox[{
                  SuperscriptBox["A", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                RowBox[{
                 SuperscriptBox["T", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], ")"}]}]}], 
            ")"}]}], "+", 
          RowBox[{"a", " ", 
           RowBox[{"f", "[", "r", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "r", " ", 
              RowBox[{"\[CapitalDelta]", "[", 
               RowBox[{"r", ",", "a"}], "]"}], " ", 
              RowBox[{
               SuperscriptBox["F", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{
              RowBox[{"F", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "r"}], " ", 
                 RowBox[{
                  SuperscriptBox["\[CapitalDelta]", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                RowBox[{
                 RowBox[{"\[CapitalDelta]", "[", 
                  RowBox[{"r", ",", "a"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{
                    SuperscriptBox["r", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
               ")"}]}]}], ")"}]}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"f", "[", "r", "]"}], "2"], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["r", "2"]}], " ", 
                  RowBox[{"A", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                 RowBox[{"T", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
               SuperscriptBox["r", "2"], " ", 
               SuperscriptBox[
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
              FractionBox[
               RowBox[{"16", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
               RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["r", "2"]}], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", " ", 
          RowBox[{"F", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["r", "2"], " ", 
                RowBox[{"A", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{"T", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["\[CapitalDelta]", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"r", ",", "a"}], "]"}], "+", 
               RowBox[{
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["r", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{"a", " ", 
             RowBox[{"f", "[", "r", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", "r", " ", 
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{
                 SuperscriptBox["F", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "r"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{
                   RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["r", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                 ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"4", " ", 
          RowBox[{"f", "[", "r", "]"}], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["r", "2"]}], " ", 
                  RowBox[{"A", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                 RowBox[{"T", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
               SuperscriptBox["r", "2"], " ", 
               SuperscriptBox[
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
              FractionBox[
               RowBox[{"16", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
               RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}], ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["r", "2"]}], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", " ", 
          RowBox[{"F", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["r", "2"], " ", 
                RowBox[{"A", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{"T", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["\[CapitalDelta]", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"r", ",", "a"}], "]"}], "+", 
               RowBox[{
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["r", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{"a", " ", 
             RowBox[{"f", "[", "r", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", "r", " ", 
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{
                 SuperscriptBox["F", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "r"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{
                   RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["r", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                 ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"4", " ", 
          RowBox[{"f", "[", "r", "]"}], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["r", "2"]}], " ", 
                  RowBox[{"A", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                 RowBox[{"T", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
               SuperscriptBox["r", "2"], " ", 
               SuperscriptBox[
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
              FractionBox[
               RowBox[{"16", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
               RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["r", "2"], " ", 
               RowBox[{"A", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
              RowBox[{"T", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], ")"}]}]], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"F", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["r", "2"], " ", 
                RowBox[{"A", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{"T", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["\[CapitalDelta]", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"r", ",", "a"}], "]"}], "+", 
               RowBox[{
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["r", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{"a", " ", 
             RowBox[{"f", "[", "r", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", "r", " ", 
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{
                 SuperscriptBox["F", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "r"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{
                   RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["r", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                 ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"16", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["r", "2"]}], " ", 
                  RowBox[{"A", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                 RowBox[{"T", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
               SuperscriptBox["r", "2"], " ", 
               SuperscriptBox[
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
              FractionBox[
               RowBox[{"16", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
               RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}], ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["r", "2"]}], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{"S", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], "-", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", "a", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["r", "2"], " ", 
                RowBox[{"A", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{"T", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
             RowBox[{"\[CapitalDelta]", "[", 
              RowBox[{"r", ",", "a"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["g", "\[Prime]",
               MultilineFunction->None], "[", "a", "]"}]}], "+", 
            RowBox[{
             RowBox[{"g", "[", "a", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "4"}], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"a", " ", "r", " ", 
                   RowBox[{"f", "[", "r", "]"}], " ", 
                   RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "8"}], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
                  RowBox[{"4", " ", "a", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", "r", " ", 
                   RowBox[{"f", "[", "r", "]"}], " ", 
                   RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
              ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["r", "2"]}], " ", 
                  RowBox[{"A", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                 RowBox[{"T", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
               SuperscriptBox["r", "2"], " ", 
               SuperscriptBox[
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
              FractionBox[
               RowBox[{"16", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
               RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}], ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["r", "2"]}], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{"S", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], "-", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", "a", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["r", "2"], " ", 
                RowBox[{"A", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{"T", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
             RowBox[{"\[CapitalDelta]", "[", 
              RowBox[{"r", ",", "a"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["g", "\[Prime]",
               MultilineFunction->None], "[", "a", "]"}]}], "+", 
            RowBox[{
             RowBox[{"g", "[", "a", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "4"}], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"a", " ", "r", " ", 
                   RowBox[{"f", "[", "r", "]"}], " ", 
                   RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "8"}], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
                  RowBox[{"4", " ", "a", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", "r", " ", 
                   RowBox[{"f", "[", "r", "]"}], " ", 
                   RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
              ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"4", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["r", "2"]}], " ", 
                  RowBox[{"A", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                 RowBox[{"T", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
               SuperscriptBox["r", "2"], " ", 
               SuperscriptBox[
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
              FractionBox[
               RowBox[{"16", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
               RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}]}], "}"}]}], "}"}]}],
   "}"}]], "Output",
 CellChangeTimes->{
  3.482661298062799*^9, {3.4826613789254103`*^9, 3.482661407354897*^9}, {
   3.482665680028101*^9, 3.4603454460941763`*^9}, 3.482732930365775*^9, 
   3.483268398775249*^9, 3.483274861473762*^9, 3.48335586118395*^9, 
   3.495174854349127*^9, 3.4979532134025087`*^9, 3.497953553172243*^9, 
   3.501484239811926*^9, {3.501486555298568*^9, 3.460390578166481*^9}, 
   3.4604294518046227`*^9, 3.4604295186905117`*^9, {3.503999633797913*^9, 
   3.460343388099977*^9}, {3.4603977842107477`*^9, 3.460397798548231*^9}, 
   3.460398265784686*^9, {3.4606253370668373`*^9, 3.460366073190826*^9}, 
   3.460373420824457*^9, 3.5414359951685543`*^9, 3.541441086697323*^9, 
   3.541999916758959*^9, 3.542001550117902*^9, 3.5422941135773077`*^9, 
   3.542431717995531*^9, 3.542434117865362*^9, 3.542516289058359*^9, 
   3.542516598017516*^9, 3.542516701777505*^9, 3.542529881773465*^9, 
   3.543226767264955*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Isreal", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"K", "-", 
     RowBox[{"kappa", " ", "q"}]}], ")"}], "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.482661408999899*^9, 3.460345429549082*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"T", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", "kappa", " ", 
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox[
        RowBox[{"f", "[", "r", "]"}], "2"], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["r", "2"]}], " ", 
           RowBox[{"A", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox[
          RowBox[{"f", "[", "r", "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "a", " ", "r", " ", 
            RowBox[{"F", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"r", ",", "a"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["f", "\[Prime]",
              MultilineFunction->None], "[", "r", "]"}]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["r", "2"], " ", 
               RowBox[{"A", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
              RowBox[{"T", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["\[CapitalDelta]", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"r", ",", "a"}], "]"}], "+", 
              RowBox[{
               RowBox[{"\[CapitalDelta]", "[", 
                RowBox[{"r", ",", "a"}], "]"}], " ", 
               RowBox[{
                SuperscriptBox["T", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{"a", " ", 
            RowBox[{"f", "[", "r", "]"}], " ", 
            RowBox[{"F", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"r", " ", 
               RowBox[{
                SuperscriptBox["\[CapitalDelta]", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"r", ",", "a"}], "]"}]}], "+", 
              RowBox[{
               RowBox[{"\[CapitalDelta]", "[", 
                RowBox[{"r", ",", "a"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{"2", "+", 
                 RowBox[{"r", " ", 
                  RowBox[{
                   SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], ")"}], "/", 
       RowBox[{"(", 
        SqrtBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["r", "2"]}], " ", 
                RowBox[{"A", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
               RowBox[{"T", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
             SuperscriptBox["r", "2"], " ", 
             SuperscriptBox[
              RowBox[{"F", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
            FractionBox[
             RowBox[{"16", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", 
                 RowBox[{"B", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                RowBox[{"S", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
             RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
          RowBox[{"\[CapitalDelta]", "[", 
           RowBox[{"r", ",", "a"}], "]"}]}]], ")"}]}]}], ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["r", "2"], " ", 
            RowBox[{"A", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
           RowBox[{"T", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "kappa", " ", 
         RowBox[{"\[CapitalDelta]", "[", 
          RowBox[{"r", ",", "a"}], "]"}]}], 
        SuperscriptBox[
         RowBox[{"f", "[", "r", "]"}], "2"]]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["\[CapitalDelta]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"r", ",", "a"}], "]"}], "+", 
            RowBox[{
             RowBox[{"\[CapitalDelta]", "[", 
              RowBox[{"r", ",", "a"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["r", "2"], " ", 
                RowBox[{
                 SuperscriptBox["A", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{
                SuperscriptBox["T", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"a", " ", 
          RowBox[{"f", "[", "r", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "r", " ", 
             RowBox[{"\[CapitalDelta]", "[", 
              RowBox[{"r", ",", "a"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["F", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"F", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "r"}], " ", 
                RowBox[{
                 SuperscriptBox["\[CapitalDelta]", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"r", ",", "a"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", 
                  RowBox[{"2", " ", 
                   SuperscriptBox["r", "2"], " ", 
                   RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["r", "3"], " ", 
                   RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"r", " ", 
                   RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
              ")"}]}]}], ")"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"f", "[", "r", "]"}], "2"], " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["a", "2"]}], " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["r", "2"]}], " ", 
                 RowBox[{"A", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                RowBox[{"T", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
              SuperscriptBox["r", "2"], " ", 
              SuperscriptBox[
               RowBox[{"F", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
             FractionBox[
              RowBox[{"16", " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["a", "2"], " ", 
                  RowBox[{"B", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                 RowBox[{"S", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
              RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
           RowBox[{"\[CapitalDelta]", "[", 
            RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}]}], ",", "0"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"S", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", "kappa", " ", 
         RowBox[{"g", "[", "a", "]"}], " ", 
         RowBox[{"\[CapitalDelta]", "[", 
          RowBox[{"r", ",", "a"}], "]"}]}], 
        RowBox[{"1", "-", 
         SuperscriptBox["\[Theta]1", "2"]}]]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["r", "2"]}], " ", 
            RowBox[{"A", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "-", 
           RowBox[{"T", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", "a", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["r", "2"], " ", 
               RowBox[{"A", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
              RowBox[{"T", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"r", ",", "a"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["g", "\[Prime]",
              MultilineFunction->None], "[", "a", "]"}]}], "+", 
           RowBox[{
            RowBox[{"g", "[", "a", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "4"}], " ", 
                  SuperscriptBox["\[ExponentialE]", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                  RowBox[{
                   SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                 RowBox[{"a", " ", "r", " ", 
                  RowBox[{"f", "[", "r", "]"}], " ", 
                  RowBox[{"F", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"\[CapitalDelta]", "[", 
                RowBox[{"r", ",", "a"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "8"}], " ", 
                  SuperscriptBox["\[ExponentialE]", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
                 RowBox[{"4", " ", "a", " ", 
                  SuperscriptBox["\[ExponentialE]", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                  RowBox[{
                   SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["a", "2"], " ", "r", " ", 
                  RowBox[{"f", "[", "r", "]"}], " ", 
                  RowBox[{"F", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["a", "2"]}], " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["r", "2"]}], " ", 
                 RowBox[{"A", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                RowBox[{"T", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
              SuperscriptBox["r", "2"], " ", 
              SuperscriptBox[
               RowBox[{"F", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
             FractionBox[
              RowBox[{"16", " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["a", "2"], " ", 
                  RowBox[{"B", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                 RowBox[{"S", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
              RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
           RowBox[{"\[CapitalDelta]", "[", 
            RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.482661417014008*^9, 3.4826614533611383`*^9}, {
   3.4826656802370787`*^9, 3.460345448910265*^9}, 3.482732930558614*^9, 
   3.483268399038637*^9, 3.483274861778748*^9, 3.483355861490382*^9, 
   3.4951748546348877`*^9, 3.4979532137836933`*^9, 3.497953553404372*^9, 
   3.5014842401084003`*^9, {3.501486555592925*^9, 3.4603905784484367`*^9}, 
   3.460429452117546*^9, 3.460429518846084*^9, {3.5039996340815783`*^9, 
   3.460343388292631*^9}, 3.460397799787715*^9, 3.4603982659972563`*^9, {
   3.4606253373449287`*^9, 3.460366073407278*^9}, 3.460373421073736*^9, 
   3.541435995372622*^9, 3.5414410868945427`*^9, 3.541999916909121*^9, 
   3.542001550292705*^9, 3.542294113754004*^9, 3.542431718183317*^9, 
   3.5424341180289516`*^9, 3.542516289215925*^9, 3.542516598306775*^9, 
   3.5425167019448957`*^9, 3.542529882883307*^9, 3.5432267674989862`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"solIsreal", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"Isreal", "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["A", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.482665723842639*^9, 3.48266575809789*^9}, 
   3.482665845723934*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["T", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"4", " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]], 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["r", "2"]}], " ", 
         RowBox[{"A", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
        RowBox[{"T", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"\[CapitalDelta]", "[", 
          RowBox[{"r", ",", "a"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["r", "2"], " ", 
               RowBox[{"A", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
              RowBox[{"T", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "kappa", " ", 
            SqrtBox[
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}], " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["r", "2"]}], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                   RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                 SuperscriptBox["r", "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"F", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
                FractionBox[
                 RowBox[{"16", " ", 
                  SuperscriptBox["\[ExponentialE]", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
                 RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
              RowBox[{"\[CapitalDelta]", "[", 
               RowBox[{"r", ",", "a"}], "]"}]}]]}], "+", 
           RowBox[{"2", " ", "a", " ", "r", " ", 
            RowBox[{"F", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["f", "\[Prime]",
              MultilineFunction->None], "[", "r", "]"}]}]}], ")"}]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["r", "2"], " ", 
            RowBox[{"A", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
           RowBox[{"T", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
         RowBox[{
          SuperscriptBox["\[CapitalDelta]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"r", ",", "a"}], "]"}]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"f", "[", "r", "]"}], " ", 
         RowBox[{"F", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"r", " ", 
            RowBox[{
             SuperscriptBox["\[CapitalDelta]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"r", ",", "a"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"r", ",", "a"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{"2", "+", 
              RowBox[{"r", " ", 
               RowBox[{
                SuperscriptBox["T", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
          ")"}]}]}], ")"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["A", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"a", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["r", "2"]}], " ", 
          RowBox[{"A", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
         RowBox[{"T", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "r", " ", 
          RowBox[{"A", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
          RowBox[{"f", "[", "r", "]"}], " ", 
          RowBox[{"F", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{"f", "[", "r", "]"}], " ", 
          RowBox[{
           SuperscriptBox["F", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"F", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{
              SuperscriptBox["f", "\[Prime]",
               MultilineFunction->None], "[", "r", "]"}]}], "+", 
            RowBox[{
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"f", "[", "r", "]"}], " ", 
             RowBox[{
              SuperscriptBox["A", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"f", "[", "r", "]"}], " ", 
             RowBox[{
              SuperscriptBox["T", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
        ")"}]}], 
      RowBox[{"4", " ", "r"}]]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["S", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["2", "a"]}], "+", 
     RowBox[{"kappa", " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["a", "2"]}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["r", "2"]}], " ", 
              RowBox[{"A", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
             RowBox[{"T", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox[
            RowBox[{"F", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
          FractionBox[
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               RowBox[{"B", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
              RowBox[{"S", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
           RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}]]}], "-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["g", "\[Prime]",
        MultilineFunction->None], "[", "a", "]"}], 
      RowBox[{"g", "[", "a", "]"}]], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"-", 
        RowBox[{
         SuperscriptBox["\[CapitalDelta]", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], "+", 
       RowBox[{
        FractionBox["1", "4"], " ", "a", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["r", "2"]}], " ", 
           RowBox[{"A", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
          RowBox[{"T", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", " ", 
        RowBox[{"f", "[", "r", "]"}], " ", 
        RowBox[{"F", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[CapitalDelta]", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"r", ",", "a"}], "]"}]}]}], 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]], "+", 
     RowBox[{
      FractionBox["1", "4"], " ", "a", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["r", "2"]}], " ", 
         RowBox[{"A", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
        RowBox[{"T", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", " ", 
      RowBox[{"f", "[", "r", "]"}], " ", 
      RowBox[{"F", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.482661462470347*^9, 3.482665680535009*^9, {3.482665759555162*^9, 
   3.4826657871545973`*^9}, {3.4826658483017178`*^9, 3.482665871597815*^9}, {
   3.482665919066064*^9, 3.460345454837998*^9}, 3.482732931482266*^9, 
   3.483268401446496*^9, 3.4832748627169867`*^9, 3.4833558624325027`*^9, 
   3.495174855633503*^9, 3.4979532237953367`*^9, 3.4979535545760937`*^9, 
   3.501484241110568*^9, {3.50148655658468*^9, 3.460390579727603*^9}, 
   3.460429453533163*^9, 3.460429520249406*^9, {3.5039996354994087`*^9, 
   3.4603433896990547`*^9}, 3.4603978066877623`*^9, {3.460398268575706*^9, 
   3.460398291311727*^9}, {3.46062534023184*^9, 3.460366076033289*^9}, 
   3.460373423557117*^9, 3.5414360808393583`*^9, 3.541441088813385*^9, 
   3.541999918323587*^9, 3.5420015516235657`*^9, 3.542294115070724*^9, 
   3.542431727024172*^9, 3.5424341193589897`*^9, 3.542516290560801*^9, 
   3.542516599637721*^9, 3.542516703260708*^9, 3.542529884601677*^9, 
   3.5432267688360233`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"K", "-", 
      RowBox[{"kappa", " ", "q"}]}], ")"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}], "/.", "solIsreal"}], "]"}]], "Input",
 CellChangeTimes->{{3.482661472912682*^9, 3.482661480239296*^9}, 
   3.482665792043179*^9, {3.482665876225696*^9, 3.4603454642184143`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.482661476077997*^9, 3.4826614806459503`*^9}, 
   3.4826655401226187`*^9, 3.482665680753159*^9, {3.482665784118093*^9, 
   3.4826657925393353`*^9}, {3.482665873049391*^9, 3.482665876638081*^9}, {
   3.482665928655641*^9, 3.4603454649726057`*^9}, 3.482732931690959*^9, 
   3.4832684029767427`*^9, 3.48327486292334*^9, 3.483355862815412*^9, 
   3.495174856040447*^9, 3.497953286747328*^9, 3.4979535548150263`*^9, 
   3.501484241321064*^9, {3.501486556802676*^9, 3.460390579921055*^9}, 
   3.460429453805388*^9, 3.460429520440114*^9, {3.5039996358618603`*^9, 
   3.460343389903619*^9}, 3.46039780914758*^9, {3.4603982689*^9, 
   3.460398293591243*^9}, {3.460625340550242*^9, 3.460366076280569*^9}, 
   3.460373423870085*^9, 3.541436104665827*^9, 3.541441089112986*^9, 
   3.541441308541874*^9, 3.541999918517839*^9, 3.542001551796496*^9, 
   3.542294115236533*^9, 3.54243172717981*^9, 3.542434119527686*^9, 
   3.542516290729314*^9, 3.542516599843924*^9, 3.542516703420561*^9, 
   3.5425298848530407`*^9, 3.5432267689832287`*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dTIsreal", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["T", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"l", ",", "r", ",", "a"}], "]"}], "-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["T", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], "/.", "solIsreal"}], 
      ")"}]}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dAIsreal", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["A", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"l", ",", "r", ",", "a"}], "]"}], "-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["A", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], "/.", "solIsreal"}], 
      ")"}]}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dSIsreal", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["S", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "/.", "solIsreal"}], 
     ")"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.482665930411491*^9, 3.482665957890201*^9}, {
  3.542431737579021*^9, 3.542431751145574*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{
  "T", ",", "A", ",", "B", ",", "F", ",", "S", ",", "\[CapitalDelta]", ",", 
   "f", ",", "g"}], "]"}]], "Input",
 CellChangeTimes->{{3.460345516539507*^9, 3.4603455189072943`*^9}, {
  3.483268409588434*^9, 3.4603983316148863`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalDelta]", "[", 
    RowBox[{"r_", ",", "a_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     FractionBox[
      RowBox[{" ", "1"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"a", "^", "2"}]}], ")"}], "+", 
       RowBox[{"rh", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"r", "^", "2"}]}], ")"}]}]}]], ")"}], "^", "2"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "r_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"r", "^", "2"}]}], ")"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g", "[", "a_", "]"}], ":=", 
  RowBox[{"2", "-", 
   RowBox[{"a", "^", "2"}]}]}]}], "Input",
 CellChangeTimes->{{3.503997037073781*^9, 3.503997076077972*^9}, {
   3.503997256891058*^9, 3.4603927524745617`*^9}, {3.460396639861096*^9, 
   3.4603966466740303`*^9}, {3.460397369545499*^9, 3.460397369641325*^9}, 
   3.5419999360283546`*^9, {3.542001574213739*^9, 3.542001627282452*^9}, {
   3.542294092063689*^9, 3.542294100910776*^9}, {3.542294616680974*^9, 
   3.5422946383648977`*^9}, {3.542431757711411*^9, 3.5424317598887653`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"l_", ",", "r_", ",", "a_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"A", "[", 
    RowBox[{"l_", ",", "r_", ",", "a_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"B", "[", 
    RowBox[{"l_", ",", "r_", ",", "a_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{"l_", ",", "r_", ",", "a_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"F", "[", 
   RowBox[{"l_", ",", "r_", ",", "a_"}], "]"}], ":=", "0"}]}], "Input",
 CellChangeTimes->{{3.431856555245702*^9, 3.4318566047651167`*^9}, {
   3.431856648542349*^9, 3.431856678878977*^9}, 3.431856754902734*^9, {
   3.431856846342795*^9, 3.4318568575753117`*^9}, {3.431857245071002*^9, 
   3.431857306175378*^9}, {3.482669748664126*^9, 3.460345702164336*^9}, {
   3.4603458536450377`*^9, 3.4603458601381617`*^9}, {3.482733288623783*^9, 
   3.482733290614155*^9}, {3.483269034046699*^9, 3.46039835095335*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"PowerExpand", "[", 
   RowBox[{"dTIsreal", "/.", 
    RowBox[{"{", 
     RowBox[{"a", "\[Rule]", "1"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.4826660049695663`*^9, 3.460345583983425*^9}, {
  3.48326906127791*^9, 3.483269063052622*^9}, {3.503999655173497*^9, 
  3.503999664163814*^9}, {3.542431796744762*^9, 3.542431797120315*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"4", "-", 
   RowBox[{"4", " ", "kappa"}]}], 
  RowBox[{"rh", "-", 
   RowBox[{
    SuperscriptBox["r", "2"], " ", "rh"}]}]]], "Output",
 CellChangeTimes->{{3.482666002998753*^9, 3.460345545267086*^9}, 
   3.460345584500978*^9, {3.482732966257142*^9, 3.482732974068698*^9}, 
   3.483268434285424*^9, {3.4832690509261723`*^9, 3.48326907357321*^9}, 
   3.483274864505567*^9, 3.483355864520975*^9, 3.495175868068644*^9, 
   3.497953575877347*^9, 3.501484242821018*^9, {3.501486558436138*^9, 
   3.460390581570344*^9}, 3.460429455591792*^9, 3.4604295223896513`*^9, {
   3.503999641076478*^9, 3.4603966687086887`*^9}, 3.460398365846327*^9, {
   3.460625342966423*^9, 3.460366080949621*^9}, 3.4603736388557873`*^9, 
   3.541436115376383*^9, 3.541441101832201*^9, 3.541441321888905*^9, 
   3.5419999618200607`*^9, {3.542001616660657*^9, 3.542001631821885*^9}, 
   3.542294131466785*^9, {3.5422946078788*^9, 3.542294647671533*^9}, {
   3.542431793649922*^9, 3.5424317976673317`*^9}, 3.5424341196773033`*^9, 
   3.542516290881377*^9, 3.542516600128106*^9, 3.542516703541638*^9, 
   3.542529884983465*^9, 3.5432267841220703`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"PowerExpand", "[", 
   RowBox[{"dAIsreal", "/.", 
    RowBox[{"{", 
     RowBox[{"a", "\[Rule]", "1"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.482666070226741*^9, 3.460345587991267*^9}, {
  3.48326906858265*^9, 3.483269071190339*^9}, {3.5424317993127193`*^9, 
  3.542431799672666*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.48266607923127*^9, 3.4603455465431137`*^9}, 
   3.460345588475593*^9, {3.482732967356728*^9, 3.482732974550373*^9}, 
   3.4832684377323523`*^9, {3.483269051825616*^9, 3.483269074588484*^9}, 
   3.483274864614605*^9, 3.4833558645901203`*^9, 3.495175874063829*^9, 
   3.49795357656045*^9, 3.501484242904517*^9, {3.5014865585208*^9, 
   3.460390581654023*^9}, 3.460429455658146*^9, {3.4604295224678373`*^9, 
   3.460396670035489*^9}, 3.4603983667031393`*^9, {3.4606253431911573`*^9, 
   3.460366081696137*^9}, 3.460373639587226*^9, 3.5414361166147013`*^9, 
   3.541441102586293*^9, 3.541441322749959*^9, 3.54199996658967*^9, 
   3.542001634293983*^9, 3.54229413231758*^9, {3.5422946094461727`*^9, 
   3.542294651211956*^9}, 3.542431800175071*^9, 3.542434119713855*^9, 
   3.542516290917972*^9, 3.542516600175232*^9, 3.542516703582637*^9, 
   3.542529885026095*^9, 3.543226784742022*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{"PowerExpand", "[", 
    RowBox[{"dSIsreal", "/.", 
     RowBox[{"{", 
      RowBox[{"a", "\[Rule]", "1"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.482666075081551*^9, 3.460345592223567*^9}, {
  3.483269070046768*^9, 3.483269071988899*^9}, {3.542431801920711*^9, 
  3.5424318022404222`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"4", "-", 
   RowBox[{"4", " ", "kappa"}]}], 
  RowBox[{"rh", "-", 
   RowBox[{
    SuperscriptBox["r", "2"], " ", "rh"}]}]]], "Output",
 CellChangeTimes->{{3.482666077667183*^9, 3.46034559271469*^9}, 
   3.482732974983457*^9, 3.4832684392141113`*^9, {3.4832690526244993`*^9, 
   3.4832690752212152`*^9}, 3.483274864692976*^9, 3.483355864658546*^9, 
   3.495175875146338*^9, 3.497953577241666*^9, 3.501484242988212*^9, {
   3.501486558604127*^9, 3.460390581770792*^9}, 3.460429455741763*^9, {
   3.460429522539503*^9, 3.4603966708779287`*^9}, 3.460398372597919*^9, {
   3.46062534345389*^9, 3.46036608277871*^9}, 3.460373640202993*^9, 
   3.541436117831047*^9, 3.541441103588262*^9, 3.541441323734899*^9, 
   3.541999967658757*^9, 3.542001635245036*^9, 3.5422941333036118`*^9, {
   3.5422946101469793`*^9, 3.5422946237249393`*^9}, 3.542294655329307*^9, 
   3.542431802713397*^9, 3.5424341197538013`*^9, 3.5425162909746532`*^9, 
   3.542516600208893*^9, 3.5425167036105347`*^9, 3.542529885059185*^9, 
   3.543226785275853*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{
  "T", ",", "A", ",", "B", ",", "F", ",", "S", ",", "\[CapitalDelta]", ",", 
   "f", ",", "g"}], "]"}]], "Input",
 CellChangeTimes->{{3.4826661330887327`*^9, 3.460345623870998*^9}, {
   3.483269105684589*^9, 3.4603983849632893`*^9}, 3.5424318510806217`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"T", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "T"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Tr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Ta"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Trr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Taa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Tra"}], ",", 
     RowBox[{
      RowBox[{"A", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "A"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Ar"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Aa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Arr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Aaa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Ara"}], ",", 
     RowBox[{
      RowBox[{"B", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "B"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Br"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Ba"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Brr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Baa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Bra"}], ",", 
     RowBox[{
      RowBox[{"F", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "F"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Fr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Fa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Frr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Faa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Fra"}], ",", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "S"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Sr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Sa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Srr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Saa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Sra"}]}], 
    "}"}]}], ";"}]], "Input",
 CellChangeTimes->{3.542431927139188*^9, 3.54243216589651*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalDelta]", "[", 
    RowBox[{"r_", ",", "a_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     FractionBox[
      RowBox[{" ", "1"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"a", "^", "2"}]}], ")"}], "+", 
       RowBox[{"rh", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"r", "^", "2"}]}], ")"}]}]}]], ")"}], "^", "2"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "r_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"r", "^", "2"}]}], ")"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g", "[", "a_", "]"}], ":=", 
  RowBox[{"2", "-", 
   RowBox[{"a", "^", "2"}]}]}]}], "Input",
 CellChangeTimes->{{3.503997037073781*^9, 3.503997076077972*^9}, {
   3.503997256891058*^9, 3.4603927524745617`*^9}, {3.460396639861096*^9, 
   3.4603966466740303`*^9}, {3.460397369545499*^9, 3.460397369641325*^9}, 
   3.5419999360283546`*^9, {3.542001574213739*^9, 3.542001627282452*^9}, {
   3.542294092063689*^9, 3.542294100910776*^9}, {3.542294616680974*^9, 
   3.5422946383648977`*^9}, {3.542431757711411*^9, 3.5424317598887653`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dTIsreal2", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"dTIsreal", "//.", "repl"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "1"}], ",", 
       RowBox[{"kappa", "\[Rule]", "1"}]}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"0", "<", "r", "<", "1"}], ",", 
      RowBox[{"rh", ">", "0"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5424318892558393`*^9, 3.5424319029917593`*^9}, {
   3.542431933280034*^9, 3.5424319346960497`*^9}, {3.5424319765270357`*^9, 
   3.542432051256751*^9}, {3.5424320891467943`*^9, 3.5424322043672113`*^9}, 
   3.542434056447547*^9, 3.543226800737067*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "A"}], " ", 
      SuperscriptBox["r", "2"]}], "-", "T"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"A", " ", 
         SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "16"}], "+", 
        RowBox[{"4", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", "S"}]]}], "-", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "A"}], " ", 
               SuperscriptBox["r", "2"]}], "-", "T"}]], " ", 
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}]]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", "rh", " ", "Ta"}]}], 
       ")"}]}], "+", 
     RowBox[{"F", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"r", " ", "Tr"}]}], ")"}]}]}], ")"}]}], 
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]]], "Output",
 CellChangeTimes->{{3.542431855553132*^9, 3.542431935730267*^9}, {
   3.542431983080635*^9, 3.542432052092555*^9}, {3.54243209055392*^9, 
   3.5424322048903933`*^9}, 3.542434119895548*^9, 3.542516291325679*^9, 
   3.542516600390951*^9, 3.542516703799882*^9, 3.542529885335547*^9, 
   3.5432268018591843`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dSIsreal2", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"dSIsreal", "//.", "repl"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "1"}], ",", 
       RowBox[{"kappa", "\[Rule]", "1"}]}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"0", "<", "r", "<", "1"}], ",", 
      RowBox[{"rh", ">", "0"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.542432057265994*^9, 3.542432064296983*^9}, {
   3.542432217577454*^9, 3.542432219095482*^9}, 3.542434058463503*^9, 
   3.543226805894876*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "A"}], " ", 
      SuperscriptBox["r", "2"]}], "-", "T"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"A", " ", 
         SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "16"}], "+", 
        RowBox[{"4", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", "S"}]]}], "-", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "A"}], " ", 
               SuperscriptBox["r", "2"]}], "-", "T"}]], " ", 
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}]]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", "rh", " ", "Sa"}]}], 
       ")"}]}], "+", 
     RowBox[{"F", " ", "r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["r", "2"]}], ")"}], " ", "rh", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", "r"}], "-", "Sr", "+", 
        RowBox[{
         SuperscriptBox["r", "2"], " ", "Sr"}]}], ")"}]}]}], ")"}]}], 
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]]], "Output",
 CellChangeTimes->{3.5424320647714148`*^9, 3.5424322196410923`*^9, 
  3.542434119931579*^9, 3.54251629135707*^9, 3.542516600427463*^9, 
  3.542516703847907*^9, 3.542529885371791*^9, 3.543226806450897*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dAIsreal2", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"dAIsreal", "//.", "repl"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "1"}], ",", 
       RowBox[{"kappa", "\[Rule]", "1"}]}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"0", "<", "r", "<", "1"}], ",", 
      RowBox[{"rh", ">", "0"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.542432066473955*^9, 3.542432069249004*^9}, {
   3.542432223425321*^9, 3.542432224687211*^9}, 3.5424340603035107`*^9, 
   3.543226809164391*^9}],

Cell[BoxData[
 RowBox[{"Aa", "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "A"}], " ", 
       SuperscriptBox["r", "2"]}], "-", "T"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "Fr", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], "+", 
      RowBox[{"F", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", "A"}], ")"}], " ", "r"}], "-", 
         RowBox[{"2", " ", "A", " ", 
          SuperscriptBox["r", "3"]}], "-", 
         RowBox[{"Ar", " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"Ar", "-", 
            RowBox[{"2", " ", "Tr"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "Tr"}]}], ")"}]}]}], ")"}]}], 
   RowBox[{"4", " ", "r"}]]}]], "Output",
 CellChangeTimes->{3.542432070257152*^9, 3.542432225122881*^9, 
  3.542434119965711*^9, 3.5425162913860703`*^9, 3.542516600475965*^9, 
  3.542516703895502*^9, 3.542529885408449*^9, 3.543226809697073*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"zeroF", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"F", "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}], "//.", "repl"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.5424345139209337`*^9, 3.5424345279368267`*^9}}],

Cell[BoxData["F"], "Output",
 CellChangeTimes->{
  3.5424345284066877`*^9, 3.5425162914189663`*^9, 3.54251660053263*^9, 
   3.542516703952183*^9, 3.542529885454652*^9, {3.543226813204576*^9, 
   3.5432268222687607`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"zeroF2", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"F", "[", 
      RowBox[{"l", ",", "r", ",", "a"}], "]"}], "^", "2"}], "//.", "repl"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.543228182780006*^9, 3.5432281862349167`*^9}}],

Cell[BoxData[
 SuperscriptBox["F", "2"]], "Output",
 CellChangeTimes->{3.543228189879258*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"H", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "d", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"S", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"8", " ", 
                SuperscriptBox["a", "2"], " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                  RowBox[{"T", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  SuperscriptBox["\[ExponentialE]", 
                   RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], ")"}], " ", 
                SuperscriptBox["r", "2"], " ", 
                SuperscriptBox[
                 RowBox[{"F", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
                RowBox[{"g", "[", "a", "]"}], " ", 
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{
                 SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "r", "]"}]}], "+", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                SuperscriptBox["r", "3"], " ", 
                SuperscriptBox[
                 RowBox[{"F", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}], "3"], " ", 
                RowBox[{"g", "[", "a", "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "a", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
                   RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["g", "\[Prime]",
                    MultilineFunction->None], "[", "a", "]"}]}], "+", 
                  RowBox[{
                   RowBox[{"g", "[", "a", "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
                    RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"a", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]]}]}], ")"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
               "-", 
               RowBox[{"32", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["r", "2"], " ", 
                   RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                  RowBox[{"2", " ", 
                   RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}]], " ", 
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"4", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], ")"}], " ", 
                   RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "r", "]"}]}], "+", 
                  RowBox[{"a", " ", "r", " ", 
                   RowBox[{"g", "[", "a", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["F", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}], 
               "+", 
               RowBox[{"16", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                  RowBox[{"T", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", " ", 
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "a"}], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                   " ", 
                   RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["g", "\[Prime]",
                    MultilineFunction->None], "[", "a", "]"}]}], "-", 
                  RowBox[{
                   RowBox[{"g", "[", "a", "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"a", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                    " ", 
                    RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                    RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
                    RowBox[{"a", " ", 
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                    RowBox[{"a", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"T", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
             RowBox[{"f", "[", "r", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"16", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "4"}], " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}]}], 
                  "-", 
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "5"}], " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]]}], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                   " ", 
                   SuperscriptBox["r", "2"], " ", 
                   SuperscriptBox[
                    RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
                   RowBox[{"g", "[", "a", "]"}]}]}], ")"}], " ", 
                RowBox[{
                 SuperscriptBox["\[CapitalDelta]", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"r", ",", "a"}], "]"}]}], "+", 
               RowBox[{
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{"S", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"32", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   SuperscriptBox["r", "2"], " ", 
                   RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"16", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                    RowBox[{
                    SuperscriptBox["r", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", "r", " ", 
                    RowBox[{
                    SuperscriptBox["B", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                    RowBox[{"3", " ", "r", " ", 
                    RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}], 
                  "+", 
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   SuperscriptBox["r", "2"], " ", 
                   SuperscriptBox[
                    RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
                   RowBox[{"g", "[", "a", "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"2", "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                    RowBox[{"2", " ", "r", " ", 
                    RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                 ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"8", " ", "r", " ", 
          RowBox[{"f", "[", "r", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["r", "2"], " ", 
                RowBox[{"A", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                RowBox[{"B", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{"S", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
               RowBox[{"T", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["r", "2"], " ", 
             SuperscriptBox[
              RowBox[{"F", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
             RowBox[{"g", "[", "a", "]"}]}]}], ")"}], " ", 
          RowBox[{"\[CapitalDelta]", "[", 
           RowBox[{"r", ",", "a"}], "]"}]}], ")"}]}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"S", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "128"}], " ", "a", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["r", "2"], " ", 
                RowBox[{"A", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                RowBox[{"B", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                  RowBox[{"T", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], ")"}]}]}]], 
             " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 SuperscriptBox["a", "2"], " ", 
                 RowBox[{"B", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], ")"}], " ", 
             RowBox[{"\[CapitalDelta]", "[", 
              RowBox[{"r", ",", "a"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["g", "\[Prime]",
               MultilineFunction->None], "[", "a", "]"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["r", "2"], " ", 
             SuperscriptBox[
              RowBox[{"F", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
             SuperscriptBox[
              RowBox[{"g", "[", "a", "]"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"4", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "-", 
                    RowBox[{"5", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]]}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                   " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"a", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]]}]}], ")"}], " ",
                    "r", " ", 
                   RowBox[{"f", "[", "r", "]"}], " ", 
                   RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{"S", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"f", "[", "r", "]"}], " ", 
                   RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", "r", " ", 
                   RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "r", "]"}]}], "+", 
                  RowBox[{"2", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "4"}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
                    RowBox[{"2", " ", "a", " ", 
                    RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                    RowBox[{"a", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                 ")"}]}]}], ")"}]}], "-", 
            RowBox[{"8", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"S", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
               RowBox[{"T", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
             RowBox[{"g", "[", "a", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "a", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"4", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "-", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                   " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"a", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                   " ", "r", " ", 
                   RowBox[{"f", "[", "r", "]"}], " ", 
                   RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "32"}], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                  RowBox[{"32", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                  RowBox[{"16", " ", 
                   SuperscriptBox["a", "2"], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"4", " ", 
                   SuperscriptBox["a", "2"], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", 
                   " ", 
                   RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "r", "]"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["a", "3"], " ", 
                   SuperscriptBox["r", "2"], " ", 
                   SuperscriptBox[
                    RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
                   RowBox[{
                    SuperscriptBox["g", "\[Prime]",
                    MultilineFunction->None], "[", "a", "]"}]}], "-", 
                  RowBox[{
                   SuperscriptBox["a", "3"], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   SuperscriptBox["r", "2"], " ", 
                   SuperscriptBox[
                    RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
                   RowBox[{
                    SuperscriptBox["g", "\[Prime]",
                    MultilineFunction->None], "[", "a", "]"}]}], "-", 
                  RowBox[{"8", " ", "a", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   SuperscriptBox["r", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"8", " ", 
                   SuperscriptBox["a", "3"], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{
                    SuperscriptBox["B", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                  RowBox[{"8", " ", "a", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                  RowBox[{"16", " ", "a", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                  RowBox[{"4", " ", 
                   SuperscriptBox["a", "2"], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{"f", "[", "r", "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "r"}], " ", 
                    RowBox[{
                    SuperscriptBox["F", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "-", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", "r", " ", 
                    RowBox[{
                    SuperscriptBox["B", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"8", " ", "a", " ", 
          RowBox[{"g", "[", "a", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["r", "2"], " ", 
                RowBox[{"A", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                RowBox[{"B", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{"S", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
               RowBox[{"T", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["r", "2"], " ", 
             SuperscriptBox[
              RowBox[{"F", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
             RowBox[{"g", "[", "a", "]"}]}]}], ")"}], " ", 
          RowBox[{"\[CapitalDelta]", "[", 
           RowBox[{"r", ",", "a"}], "]"}]}], ")"}]}], ",", "0", ",", "0"}], 
      "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.460398407838149*^9, 3.460366119400321*^9}, {
  3.46037366281181*^9, 3.4603736643764067`*^9}, {3.541422183301118*^9, 
  3.541422183837064*^9}, {3.5414361552517653`*^9, 3.5414361557525*^9}, {
  3.542000002539564*^9, 3.542000002979475*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"H2", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"H", "//.", "repl"}], "/.", 
    RowBox[{"{", 
     RowBox[{"a", "\[Rule]", "1"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.542432276137328*^9, 3.5424323218866158`*^9}, {
   3.54243235945338*^9, 3.542432362028145*^9}, 3.5432268358394423`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "d", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", " ", "r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
          RowBox[{
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], " ", "rh"}]], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "S"}], "-", "T"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "F", " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "F", " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{"32", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", "S"], " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", "T"], " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["r", "4"]}], "+", 
         RowBox[{"64", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"3", " ", "T"}]}]], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"3", " ", "T"}]}]], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["r", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
         RowBox[{"32", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]}]], 
          " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], " ", "rh", " ", 
          RowBox[{"(", 
           RowBox[{"2", "-", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5"}], "+", "A"}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "4"]}], "+", 
            RowBox[{"Ar", " ", 
             SuperscriptBox["r", "5"]}], "+", 
            RowBox[{"Br", " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", 
               SuperscriptBox["r", "3"]}], ")"}]}], "+", 
            RowBox[{"3", " ", "r", " ", "Sr"}], "-", 
            RowBox[{
             SuperscriptBox["r", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"Ar", "+", 
               RowBox[{"3", " ", "Sr"}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "Fa"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
            RowBox[{"F", " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", 
               RowBox[{"Aa", " ", 
                SuperscriptBox["r", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  SuperscriptBox["r", "2"]}], ")"}], " ", "rh", " ", "Ta"}]}],
               ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"S", "+", "T"}]], " ", 
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], " ", "rh", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "-", 
            RowBox[{"14", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "Sr"}], "+", "Tr"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["r", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "Sr"}], "+", "Tr"}], ")"}]}]}], ")"}]}]}], 
        ")"}]}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
          RowBox[{
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], " ", "rh"}]], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "S"}], "-", "T"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"128", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", "B"}], "+", 
            RowBox[{"3", " ", "S"}], "+", "T"}]]}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "S"}], "+", "T"}]]}], "+", 
         RowBox[{"256", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"S", "+", "T"}], ")"}]}]}]]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"2", " ", "S"}]}]], " ", 
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", "S", "+", "T"}]], " ", 
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{"32", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
         RowBox[{"64", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", "T"], " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["r", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "F", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", "S"], " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], " ", "rh", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Fr", " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", 
               SuperscriptBox["r", "3"]}], ")"}]}], "+", 
            RowBox[{"F", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               SuperscriptBox["r", "2"], "+", 
               RowBox[{"Br", " ", "r", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  SuperscriptBox["r", "2"]}], ")"}]}], "-", 
               RowBox[{"r", " ", "Sr"}], "+", 
               RowBox[{
                SuperscriptBox["r", "3"], " ", "Sr"}]}], ")"}]}]}], ")"}]}], 
         "-", 
         RowBox[{"32", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
          RowBox[{"(", 
           RowBox[{"16", "+", 
            RowBox[{"Aa", " ", 
             SuperscriptBox["r", "2"], " ", "rh"}], "-", 
            RowBox[{"Aa", " ", 
             SuperscriptBox["r", "4"], " ", "rh"}], "+", 
            RowBox[{"2", " ", "B", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
            RowBox[{"Ba", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
            RowBox[{"rh", " ", "Sa"}], "-", 
            RowBox[{
             SuperscriptBox["r", "2"], " ", "rh", " ", "Sa"}], "+", 
            RowBox[{"2", " ", "rh", " ", "Ta"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"], " ", "rh", " ", "Ta"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"S", "+", "T"}]], " ", 
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "20"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}], " ", "rh", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "Sa"}], "+", "Ta"}], ")"}]}]}], ")"}]}]}], 
        ")"}]}]}], ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.542432276647036*^9, 3.542432322525732*^9}, 
   3.5424323626898403`*^9, 3.542434120404299*^9, 3.542516291679181*^9, 
   3.542516600796343*^9, 3.5425167042154303`*^9, 3.542529885792017*^9, 
   3.543226837204838*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hr", "=", 
  RowBox[{"H2", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "2"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.542432366145173*^9, 3.54243238153165*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", " ", "r", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"16", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"B", "+", 
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
      RowBox[{
       SuperscriptBox["F", "2"], " ", 
       SuperscriptBox["r", "2"]}]}], ")"}], " ", "rh"}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "S"}], "-", "T"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "16"}], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"B", "+", 
        RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "F", " ", 
      SuperscriptBox["r", "2"]}], "-", 
     RowBox[{"16", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"B", "+", 
        RowBox[{"A", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "F", " ", 
      SuperscriptBox["r", "2"]}], "-", 
     RowBox[{"32", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"B", "+", 
        RowBox[{"A", " ", 
         SuperscriptBox["r", "2"]}], "+", "S", "+", 
        RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
      SuperscriptBox["r", "2"]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "S"], " ", 
      SuperscriptBox["F", "3"], " ", 
      SuperscriptBox["r", "4"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", "T"], " ", 
      SuperscriptBox["F", "3"], " ", 
      SuperscriptBox["r", "4"]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"2", " ", "A", " ", 
         SuperscriptBox["r", "2"]}], "+", "S", "+", 
        RowBox[{"3", " ", "T"}]}]], " ", 
      SuperscriptBox["r", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"B", "+", 
        RowBox[{"2", " ", "A", " ", 
         SuperscriptBox["r", "2"]}], "+", "S", "+", 
        RowBox[{"3", " ", "T"}]}]], " ", 
      SuperscriptBox["r", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"A", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"2", " ", "T"}]}]], " ", 
      SuperscriptBox["F", "2"], " ", 
      SuperscriptBox["r", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
     RowBox[{"32", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"B", "+", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"A", " ", 
         SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
      SuperscriptBox["F", "2"], " ", 
      SuperscriptBox["r", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
     RowBox[{"16", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"B", "+", 
        RowBox[{"A", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["r", "2"]}], ")"}], " ", "rh", " ", 
      RowBox[{"(", 
       RowBox[{"2", "-", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5"}], "+", "A"}], ")"}], " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"2", " ", "A", " ", 
         SuperscriptBox["r", "4"]}], "+", 
        RowBox[{"Ar", " ", 
         SuperscriptBox["r", "5"]}], "+", 
        RowBox[{"Br", " ", 
         RowBox[{"(", 
          RowBox[{"r", "-", 
           SuperscriptBox["r", "3"]}], ")"}]}], "+", 
        RowBox[{"3", " ", "r", " ", "Sr"}], "-", 
        RowBox[{
         SuperscriptBox["r", "3"], " ", 
         RowBox[{"(", 
          RowBox[{"Ar", "+", 
           RowBox[{"3", " ", "Sr"}]}], ")"}]}]}], ")"}]}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"A", " ", 
         SuperscriptBox["r", "2"]}], "+", "S", "+", 
        RowBox[{"2", " ", "T"}]}]], " ", 
      SuperscriptBox["r", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "Fa"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
        RowBox[{"F", " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", 
           RowBox[{"Aa", " ", 
            SuperscriptBox["r", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], " ", "rh", " ", "Ta"}]}], 
          ")"}]}]}], ")"}]}], "-", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"S", "+", "T"}]], " ", 
      SuperscriptBox["F", "2"], " ", 
      SuperscriptBox["r", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["r", "2"]}], ")"}], " ", "rh", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "-", 
        RowBox[{"14", " ", 
         SuperscriptBox["r", "2"]}], "-", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "Sr"}], "+", "Tr"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["r", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "Sr"}], "+", "Tr"}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{{3.542432377063899*^9, 3.542432381873447*^9}, 
   3.542434120512718*^9, 3.5425162918373413`*^9, 3.542516600982215*^9, 
   3.542516704248808*^9, 3.542529885900138*^9, 3.54322683892463*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ha", "=", 
  RowBox[{"H2", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "3"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{3.542432383299802*^9, 3.5425166933067207`*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["r", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"16", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"B", "+", 
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
      RowBox[{
       SuperscriptBox["F", "2"], " ", 
       SuperscriptBox["r", "2"]}]}], ")"}], " ", "rh"}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "S"}], "-", "T"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"128", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"2", " ", "B"}], "+", 
        RowBox[{"3", " ", "S"}], "+", "T"}]]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"2", " ", "B"}], "+", 
        RowBox[{"A", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"3", " ", "S"}], "+", "T"}]]}], "+", 
     RowBox[{"256", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"2", " ", "B"}], "+", 
        RowBox[{"A", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"S", "+", "T"}], ")"}]}]}]]}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"B", "+", 
        RowBox[{"2", " ", "S"}]}]], " ", 
      SuperscriptBox["F", "2"], " ", 
      SuperscriptBox["r", "2"]}], "-", 
     RowBox[{"16", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"B", "+", "S", "+", "T"}]], " ", 
      SuperscriptBox["F", "2"], " ", 
      SuperscriptBox["r", "2"]}], "-", 
     RowBox[{"32", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"A", " ", 
         SuperscriptBox["r", "2"]}], "+", "S", "+", 
        RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
      SuperscriptBox["r", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
     RowBox[{"64", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"B", "+", 
        RowBox[{"A", " ", 
         SuperscriptBox["r", "2"]}], "+", "S", "+", 
        RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
      SuperscriptBox["r", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["\[ExponentialE]", "T"], " ", 
      SuperscriptBox["F", "3"], " ", 
      SuperscriptBox["r", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
     RowBox[{"16", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"B", "+", 
        RowBox[{"A", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "F", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "S"], " ", 
      SuperscriptBox["F", "3"], " ", 
      SuperscriptBox["r", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
     RowBox[{"16", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"B", "+", 
        RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["r", "2"]}], ")"}], " ", "rh", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Fr", " ", 
         RowBox[{"(", 
          RowBox[{"r", "-", 
           SuperscriptBox["r", "3"]}], ")"}]}], "+", 
        RowBox[{"F", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SuperscriptBox["r", "2"], "+", 
           RowBox[{"Br", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}]}], "-", 
           RowBox[{"r", " ", "Sr"}], "+", 
           RowBox[{
            SuperscriptBox["r", "3"], " ", "Sr"}]}], ")"}]}]}], ")"}]}], "-", 
     RowBox[{"32", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"B", "+", 
        RowBox[{"A", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
      RowBox[{"(", 
       RowBox[{"16", "+", 
        RowBox[{"Aa", " ", 
         SuperscriptBox["r", "2"], " ", "rh"}], "-", 
        RowBox[{"Aa", " ", 
         SuperscriptBox["r", "4"], " ", "rh"}], "+", 
        RowBox[{"2", " ", "B", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
        RowBox[{"Ba", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
        RowBox[{"rh", " ", "Sa"}], "-", 
        RowBox[{
         SuperscriptBox["r", "2"], " ", "rh", " ", "Sa"}], "+", 
        RowBox[{"2", " ", "rh", " ", "Ta"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["r", "2"], " ", "rh", " ", "Ta"}]}], ")"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"S", "+", "T"}]], " ", 
      SuperscriptBox["F", "2"], " ", 
      SuperscriptBox["r", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "20"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", "rh", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "Sa"}], "+", "Ta"}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{3.5424323836268787`*^9, 3.54243412062992*^9, 
  3.5425162919080057`*^9, 3.5425166010508327`*^9, 3.542516704280961*^9, 
  3.5425298859380302`*^9, 3.543226839961266*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"phi", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"trT", "[", 
      RowBox[{
       RowBox[{"outerT", "[", 
        RowBox[{"H", ",", "H"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "]"}], "//.", "repl"}], "/.", 
    RowBox[{"{", 
     RowBox[{"a", "\[Rule]", "1"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.542432326817968*^9, 3.5424323440331707`*^9}, 
   3.543226845888138*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"4", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["r", "2"]}], ")"}], "4"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "16"}], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"B", "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
       RowBox[{
        SuperscriptBox["F", "2"], " ", 
        SuperscriptBox["r", "2"]}]}], ")"}], "3"], " ", 
    SuperscriptBox["rh", "4"]}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     RowBox[{"(", 
      RowBox[{"S", "+", "T"}], ")"}]}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"rh", "-", 
      RowBox[{
       SuperscriptBox["r", "2"], " ", "rh"}]}], ")"}], "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "T"}]]}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "128"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", "B"}], "+", 
            RowBox[{"3", " ", "S"}], "+", "T"}]]}], "-", 
         RowBox[{"128", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "S"}], "+", "T"}]]}], "-", 
         RowBox[{"256", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"S", "+", "T"}], ")"}]}]}]]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"2", " ", "S"}]}]], " ", 
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", "S", "+", "T"}]], " ", 
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"32", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
         RowBox[{"64", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", "T"], " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["r", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "F", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "+", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", "S"], " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], " ", "rh", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Fr", " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", 
               SuperscriptBox["r", "3"]}], ")"}]}], "+", 
            RowBox[{"F", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               SuperscriptBox["r", "2"], "+", 
               RowBox[{"Br", " ", "r", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  SuperscriptBox["r", "2"]}], ")"}]}], "-", 
               RowBox[{"r", " ", "Sr"}], "+", 
               RowBox[{
                SuperscriptBox["r", "3"], " ", "Sr"}]}], ")"}]}]}], ")"}]}], 
         "+", 
         RowBox[{"32", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
          RowBox[{"(", 
           RowBox[{"16", "+", 
            RowBox[{"Aa", " ", 
             SuperscriptBox["r", "2"], " ", "rh"}], "-", 
            RowBox[{"Aa", " ", 
             SuperscriptBox["r", "4"], " ", "rh"}], "+", 
            RowBox[{"2", " ", "B", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
            RowBox[{"Ba", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
            RowBox[{"rh", " ", "Sa"}], "-", 
            RowBox[{
             SuperscriptBox["r", "2"], " ", "rh", " ", "Sa"}], "+", 
            RowBox[{"2", " ", "rh", " ", "Ta"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"], " ", "rh", " ", "Ta"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"S", "+", "T"}]], " ", 
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "20"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}], " ", "rh", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "Sa"}], "+", "Ta"}], ")"}]}]}], ")"}]}]}], 
        ")"}], "2"]}], "-", 
     RowBox[{"F", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"128", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"2", " ", "B"}], "+", 
           RowBox[{"3", " ", "S"}], "+", "T"}]]}], "+", 
        RowBox[{"128", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"2", " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"3", " ", "S"}], "+", "T"}]]}], "+", 
        RowBox[{"256", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"2", " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"S", "+", "T"}], ")"}]}]}]]}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"2", " ", "S"}]}]], " ", 
         SuperscriptBox["F", "2"], " ", 
         SuperscriptBox["r", "2"]}], "-", 
        RowBox[{"16", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", "S", "+", "T"}]], " ", 
         SuperscriptBox["F", "2"], " ", 
         SuperscriptBox["r", "2"]}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", 
           RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
        RowBox[{"64", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", 
           RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", "T"], " ", 
         SuperscriptBox["F", "3"], " ", 
         SuperscriptBox["r", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "F", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", "S"], " ", 
         SuperscriptBox["F", "3"], " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
        RowBox[{"16", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", "rh", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Fr", " ", 
            RowBox[{"(", 
             RowBox[{"r", "-", 
              SuperscriptBox["r", "3"]}], ")"}]}], "+", 
           RowBox[{"F", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              SuperscriptBox["r", "2"], "+", 
              RowBox[{"Br", " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 SuperscriptBox["r", "2"]}], ")"}]}], "-", 
              RowBox[{"r", " ", "Sr"}], "+", 
              RowBox[{
               SuperscriptBox["r", "3"], " ", "Sr"}]}], ")"}]}]}], ")"}]}], 
        "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
         RowBox[{"(", 
          RowBox[{"16", "+", 
           RowBox[{"Aa", " ", 
            SuperscriptBox["r", "2"], " ", "rh"}], "-", 
           RowBox[{"Aa", " ", 
            SuperscriptBox["r", "4"], " ", "rh"}], "+", 
           RowBox[{"2", " ", "B", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
           RowBox[{"Ba", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
           RowBox[{"rh", " ", "Sa"}], "-", 
           RowBox[{
            SuperscriptBox["r", "2"], " ", "rh", " ", "Sa"}], "+", 
           RowBox[{"2", " ", "rh", " ", "Ta"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"], " ", "rh", " ", "Ta"}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"S", "+", "T"}]], " ", 
         SuperscriptBox["F", "2"], " ", 
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "20"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], " ", "rh", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "Sa"}], "+", "Ta"}], ")"}]}]}], ")"}]}]}], 
       ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "16"}], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "F", " ", 
         SuperscriptBox["r", "2"]}], "-", 
        RowBox[{"16", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "F", " ", 
         SuperscriptBox["r", "2"]}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", 
           RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", "S"], " ", 
         SuperscriptBox["F", "3"], " ", 
         SuperscriptBox["r", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", "T"], " ", 
         SuperscriptBox["F", "3"], " ", 
         SuperscriptBox["r", "4"]}], "+", 
        RowBox[{"64", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"2", " ", "A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", 
           RowBox[{"3", " ", "T"}]}]], " ", 
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
        RowBox[{"128", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"2", " ", "A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", 
           RowBox[{"3", " ", "T"}]}]], " ", 
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "T"}]}]], " ", 
         SuperscriptBox["F", "2"], " ", 
         SuperscriptBox["r", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]}]], 
         " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
         SuperscriptBox["F", "2"], " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
        RowBox[{"16", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", "rh", " ", 
         RowBox[{"(", 
          RowBox[{"2", "-", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "5"}], "+", "A"}], ")"}], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "A", " ", 
            SuperscriptBox["r", "4"]}], "+", 
           RowBox[{"Ar", " ", 
            SuperscriptBox["r", "5"]}], "+", 
           RowBox[{"Br", " ", 
            RowBox[{"(", 
             RowBox[{"r", "-", 
              SuperscriptBox["r", "3"]}], ")"}]}], "+", 
           RowBox[{"3", " ", "r", " ", "Sr"}], "-", 
           RowBox[{
            SuperscriptBox["r", "3"], " ", 
            RowBox[{"(", 
             RowBox[{"Ar", "+", 
              RowBox[{"3", " ", "Sr"}]}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", 
           RowBox[{"2", " ", "T"}]}]], " ", 
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "Fa"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
           RowBox[{"F", " ", 
            RowBox[{"(", 
             RowBox[{"2", "+", 
              RowBox[{"Aa", " ", 
               SuperscriptBox["r", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 SuperscriptBox["r", "2"]}], ")"}], " ", "rh", " ", "Ta"}]}], 
             ")"}]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"S", "+", "T"}]], " ", 
         SuperscriptBox["F", "2"], " ", 
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", "rh", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "-", 
           RowBox[{"14", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "Sr"}], "+", "Tr"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["r", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "Sr"}], "+", "Tr"}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], "-", 
     RowBox[{
      RowBox[{"1", "/", 
       SuperscriptBox["r", "2"]}], 
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"B", "+", "S"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "F", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "F", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", "S"], " ", 
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["r", "4"]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["\[ExponentialE]", "T"], " ", 
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["r", "4"]}], "-", 
          RowBox[{"64", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"128", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]}]],
            " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh", " ", 
           RowBox[{"(", 
            RowBox[{"2", "-", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "5"}], "+", "A"}], ")"}], " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "4"]}], "+", 
             RowBox[{"Ar", " ", 
              SuperscriptBox["r", "5"]}], "+", 
             RowBox[{"Br", " ", 
              RowBox[{"(", 
               RowBox[{"r", "-", 
                SuperscriptBox["r", "3"]}], ")"}]}], "+", 
             RowBox[{"3", " ", "r", " ", "Sr"}], "-", 
             RowBox[{
              SuperscriptBox["r", "3"], " ", 
              RowBox[{"(", 
               RowBox[{"Ar", "+", 
                RowBox[{"3", " ", "Sr"}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "Fa"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
             RowBox[{"F", " ", 
              RowBox[{"(", 
               RowBox[{"2", "+", 
                RowBox[{"Aa", " ", 
                 SuperscriptBox["r", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   SuperscriptBox["r", "2"]}], ")"}], " ", "rh", " ", 
                 "Ta"}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"S", "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "-", 
             RowBox[{"14", " ", 
              SuperscriptBox["r", "2"]}], "-", 
             RowBox[{"r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "Sr"}], "+", "Tr"}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["r", "3"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "Sr"}], "+", "Tr"}], ")"}]}]}], ")"}]}]}], 
         ")"}], "2"]}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{{3.542432330916016*^9, 3.5424323458054037`*^9}, 
   3.54243238439679*^9, 3.542434121961823*^9, 3.542516293151264*^9, 
   3.5425166022824087`*^9, 3.542516705604699*^9, 3.542529887845447*^9, 
   3.543226861979871*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dlistrr", "=", 
    RowBox[{"{", 
     RowBox[{"Trr", ",", "Arr", ",", "Brr", ",", "Frr", ",", "Srr"}], "}"}]}],
    ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dlistaa", "=", 
    RowBox[{"{", 
     RowBox[{"Taa", ",", "Aaa", ",", "Baa", ",", "Faa", ",", "Saa"}], "}"}]}],
    ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dlistra", "=", 
    RowBox[{"{", 
     RowBox[{"Tra", ",", "Ara", ",", "Bra", ",", "Fra", ",", "Sra"}], "}"}]}],
    ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dlist", "=", 
   RowBox[{"{", 
    RowBox[{
    "Tr", ",", "Ar", ",", "Br", ",", "Fr", ",", "Sr", ",", "Ta", ",", "Aa", 
     ",", "Ba", ",", "Fa", ",", "Sa"}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.517824939478304*^9, 3.5178249658652477`*^9}, {
   3.517825345546793*^9, 3.517825357952314*^9}, 3.542432428308229*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"zerodlist", "=", 
   RowBox[{"Thread", "[", 
    RowBox[{"dlist", "\[Rule]", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", 
         RowBox[{"Length", "[", "dlist", "]"}]}], "}"}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.517827055015583*^9, 3.517827077817245*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"allderiv", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"dlistrr", ",", "dlistaa", ",", "dlistra", ",", "dlist"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.517824997155527*^9, 3.517825012540985*^9}, {
  3.51782518467982*^9, 3.5178251854111958`*^9}, {3.542433998891629*^9, 
  3.542433999475575*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"allvar", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "r", ",", "a", ",", "\[Theta]1", ",", "T", ",", "A", ",", "B", ",", "F",
        ",", "S", ",", "L", ",", "Lr", ",", "La", ",", "Lrr", ",", "Laa", ",",
        "Lra", ",", "f", ",", "fr", ",", "frr", ",", "g", ",", "ga", ",", 
       "gaa", ",", "\[CapitalLambda]", ",", "rh"}], "}"}], ",", "allderiv"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.517825461847103*^9, 3.517825502830639*^9}, {
  3.517825546962123*^9, 3.517825549998563*^9}, {3.517825598208082*^9, 
  3.5178255990225143`*^9}, {3.5178272390735703`*^9, 3.460392829797771*^9}, {
  3.460396882947147*^9, 3.4603968873370037`*^9}, {3.5424340344212713`*^9, 
  3.542434034844249*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"zeroallderiv", "=", 
   RowBox[{"Thread", "[", 
    RowBox[{"allderiv", "\[Rule]", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", 
         RowBox[{"Length", "[", "allderiv", "]"}]}], "}"}]}], "]"}]}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.517828665692329*^9, 3.5178286695470448`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"dlist2", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"dlist", "[", 
        RowBox[{"[", "ii", "]"}], "]"}], 
       RowBox[{"dlist", "[", 
        RowBox[{"[", "jj", "]"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "dlist", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"jj", ",", "ii", ",", 
        RowBox[{"Length", "[", "dlist", "]"}]}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.5178269895484753`*^9, 3.5178270260336027`*^9}, {
  3.517827312763998*^9, 3.517827331395611*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"randlist", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Thread", "[", 
      RowBox[{"allvar", "->", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Random", "[", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", 
           RowBox[{"Length", "[", "allvar", "]"}]}], "}"}]}], "]"}]}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", "1", ",", "20"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.542433989724678*^9, 3.5424339943478317`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"extract", "[", "expr_", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"derivrr", "=", 
      RowBox[{"Simplify", "[", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"expr", ",", "dlistrr"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"derivaa", "=", 
      RowBox[{"Simplify", "[", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"expr", ",", "dlistaa"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"derivra", "=", 
      RowBox[{"Simplify", "[", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"expr", ",", "dlistra"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"deriv1", "=", 
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"expr", ",", "dlist"}], "]"}], "//.", "zerodlist"}], "]"}]}],
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"deriv2", "=", 
      RowBox[{"Simplify", "[", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"expr", ",", "dlist2"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"noderiv", "=", 
      RowBox[{"Simplify", "[", 
       RowBox[{"expr", "//.", "zeroallderiv"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"N", "[", 
       RowBox[{
        RowBox[{"expr", "-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"derivrr", ".", "dlistrr"}], "+", 
           RowBox[{"derivaa", ".", "dlistaa"}], "+", 
           RowBox[{"derivra", ".", "dlistra"}], "+", 
           RowBox[{"deriv1", ".", "dlist"}], "+", 
           RowBox[{"deriv2", ".", "dlist2"}], "+", "noderiv"}], ")"}]}], "/.",
         "randlist"}], "]"}], "]"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
      "derivrr", ",", "derivaa", ",", "derivra", ",", "deriv1", ",", "deriv2",
        ",", "noderiv"}], "}"}]}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.517825191432572*^9, 3.5178251938533*^9}, {
  3.517828583820703*^9, 3.517828636236395*^9}, {3.517828677980176*^9, 
  3.517828696111575*^9}, {3.51782874494584*^9, 3.5178288515280733`*^9}, {
  3.542432440621809*^9, 3.542432448572708*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"coeffIT", "=", 
   RowBox[{"extract", "[", "dTIsreal2", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.542434178456335*^9, 3.5424341881113977`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.7763568394002505`*^-15"}], ",", "0.`", ",", 
   RowBox[{"-", "1.4210854715202004`*^-14"}], ",", 
   RowBox[{"-", "2.842170943040401`*^-14"}], ",", "0.`", ",", "0.`", ",", 
   "1.4210854715202004`*^-14", ",", "0.`", ",", 
   RowBox[{"-", "4.440892098500626`*^-16"}], ",", "1.1102230246251565`*^-16", 
   ",", 
   RowBox[{"-", "5.684341886080802`*^-14"}], ",", "0.`", ",", 
   RowBox[{"-", "1.7763568394002505`*^-15"}], ",", 
   RowBox[{"-", "1.3322676295501878`*^-15"}], ",", "0.`", ",", "0.`", ",", 
   "2.842170943040401`*^-14", ",", "0.`", ",", "3.552713678800501`*^-15", ",", 
   RowBox[{"-", "3.552713678800501`*^-15"}]}], "}"}]], "Print",
 CellChangeTimes->{3.542434188463779*^9, 3.54251629347324*^9, 
  3.542516602576118*^9, 3.542516705963129*^9, 3.542529888164365*^9, 
  3.543226877172893*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"coeffIS", "=", 
   RowBox[{"extract", "[", "dSIsreal2", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.542434193344296*^9, 3.542434195839529*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.7763568394002505`*^-15", ",", "3.552713678800501`*^-15", ",", 
   RowBox[{"-", "2.1316282072803006`*^-14"}], ",", "0.`", ",", 
   "7.105427357601002`*^-15", ",", "0.`", ",", 
   RowBox[{"-", "1.4210854715202004`*^-14"}], ",", "2.220446049250313`*^-16", 
   ",", "0.`", ",", "1.6653345369377348`*^-16", ",", "0.`", ",", 
   "3.552713678800501`*^-15", ",", "0.`", ",", 
   RowBox[{"-", "8.881784197001252`*^-16"}], ",", "8.881784197001252`*^-16", 
   ",", "0.`", ",", "0.`", ",", "0.`", ",", "3.552713678800501`*^-15", ",", 
   "0.`"}], "}"}]], "Print",
 CellChangeTimes->{3.5424341962302933`*^9, 3.5425162935700493`*^9, 
  3.542516602616797*^9, 3.542516706004201*^9, 3.542529888235239*^9, 
  3.543226878523868*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"coeffIA", "=", 
   RowBox[{"extract", "[", "dAIsreal2", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.542434200096389*^9, 3.5424342029674683`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "7.105427357601002`*^-15"}], ",", "0.`", ",", 
   "5.551115123125783`*^-17", ",", "0.`", ",", 
   RowBox[{"-", "1.3877787807814457`*^-17"}], ",", "0.`", ",", 
   "2.7755575615628914`*^-17", ",", "2.220446049250313`*^-16", ",", 
   "2.220446049250313`*^-16", ",", "1.1102230246251565`*^-16", ",", 
   "1.1102230246251565`*^-16", ",", "0.`", ",", "2.7755575615628914`*^-17", 
   ",", 
   RowBox[{"-", "1.1102230246251565`*^-16"}], ",", "1.1102230246251565`*^-16",
    ",", "0.`", ",", "0.`", ",", "0.`", ",", "5.551115123125783`*^-17", ",", 
   "5.551115123125783`*^-17"}], "}"}]], "Print",
 CellChangeTimes->{3.542434203453147*^9, 3.542516293740306*^9, 
  3.542516602648576*^9, 3.5425167060398207`*^9, 3.5425298882902813`*^9, 
  3.543226879617586*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"coeffzeroF", "=", 
   RowBox[{"extract", "[", "zeroF", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.542434538888093*^9, 3.5424345505765543`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`"}], "}"}]], "Print",
 CellChangeTimes->{{3.542434548075254*^9, 3.542434551315259*^9}, 
   3.54251629387462*^9, 3.542516602684005*^9, 3.542516706083169*^9, 
   3.542529888335701*^9, 3.543226880669332*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"coeffzeroF2", "=", 
   RowBox[{"extract", "[", "zeroF2", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.543228205235176*^9, 3.543228207882256*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`"}], "}"}]], "Print",
 CellChangeTimes->{3.543228208296612*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"coeffHa", "=", 
   RowBox[{"extract", "[", "Ha", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.542432452946488*^9, 3.542432454681962*^9}, {
  3.5424337738310204`*^9, 3.542433776557912*^9}, {3.542433875694503*^9, 
  3.5424338818213167`*^9}, {3.5424341293121023`*^9, 3.542434155015231*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "7.105427357601002`*^-15"}], ",", "1.4210854715202004`*^-14", 
   ",", 
   RowBox[{"-", "1.021405182655144`*^-14"}], ",", "0.`", ",", 
   "1.4210854715202004`*^-14", ",", "7.105427357601002`*^-15", ",", 
   RowBox[{"-", "4.263256414560601`*^-14"}], ",", "0.`", ",", 
   RowBox[{"-", "1.7763568394002505`*^-15"}], ",", 
   RowBox[{"-", "2.220446049250313`*^-16"}], ",", 
   RowBox[{"-", "2.2737367544323206`*^-13"}], ",", "0.`", ",", 
   "7.105427357601002`*^-15", ",", "1.0658141036401503`*^-14", ",", 
   RowBox[{"-", "8.881784197001252`*^-16"}], ",", "7.105427357601002`*^-15", 
   ",", 
   RowBox[{"-", "7.460698725481052`*^-14"}], ",", "3.637978807091713`*^-12", 
   ",", 
   RowBox[{"-", "7.105427357601002`*^-15"}], ",", 
   RowBox[{"-", "1.0658141036401503`*^-13"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.5424324551931267`*^9, 3.542433777138095*^9, 3.54243388238529*^9, {
   3.54243400542056*^9, 3.542434039055501*^9}, {3.542434123068047*^9, 
   3.5424341558834267`*^9}, 3.542434204913229*^9, 3.542516294040379*^9, 
   3.542516602781538*^9, 3.542516706176454*^9, 3.542529888462583*^9, 
   3.543226881694648*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"coeffHr", "=", 
   RowBox[{"extract", "[", "Hr", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5424341604964*^9, 3.5424341620713787`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.7478019859472624`*^-14", ",", "1.4210854715202004`*^-14", ",", "0.`", 
   ",", "0.`", ",", "3.552713678800501`*^-15", ",", "0.`", ",", 
   RowBox[{"-", "7.105427357601002`*^-15"}], ",", 
   RowBox[{"-", "1.3322676295501878`*^-15"}], ",", 
   RowBox[{"-", "5.551115123125783`*^-16"}], ",", 
   RowBox[{"-", "2.6645352591003757`*^-15"}], ",", "0.`", ",", 
   RowBox[{"-", "1.8596235662471372`*^-15"}], ",", "0.`", ",", 
   RowBox[{"-", "4.440892098500626`*^-16"}], ",", "8.881784197001252`*^-16", 
   ",", "2.6645352591003757`*^-15", ",", 
   RowBox[{"-", "4.547473508864641`*^-13"}], ",", "1.862645149230957`*^-9", 
   ",", 
   RowBox[{"-", "5.329070518200751`*^-15"}], ",", 
   RowBox[{"-", "2.2737367544323206`*^-13"}]}], "}"}]], "Print",
 CellChangeTimes->{3.542434172181508*^9, 3.54243420573209*^9, 
  3.542516294139567*^9, 3.542516602813321*^9, 3.5425167062731657`*^9, 
  3.5425298885909843`*^9, 3.543226882796328*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"coeffphi", "=", 
   RowBox[{"extract", "[", "phi", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.54243416542423*^9, 3.542434169423316*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.7763568394002505`*^-15"}], ",", 
   RowBox[{"-", "1.7763568394002505`*^-15"}], ",", "2.7755575615628914`*^-17",
    ",", "3.552713678800501`*^-15", ",", 
   RowBox[{"-", "8.881784197001252`*^-16"}], ",", "1.1102230246251565`*^-15", 
   ",", "7.771561172376096`*^-16", ",", "9.71445146547012`*^-17", ",", 
   RowBox[{"-", "8.881784197001252`*^-16"}], ",", "4.440892098500626`*^-16", 
   ",", "4.440892098500626`*^-15", ",", 
   RowBox[{"-", "1.7763568394002505`*^-15"}], ",", 
   RowBox[{"-", "1.7763568394002505`*^-15"}], ",", 
   RowBox[{"-", "3.0531133177191805`*^-16"}], ",", "1.1102230246251565`*^-16",
    ",", 
   RowBox[{"-", "4.440892098500626`*^-16"}], ",", 
   RowBox[{"-", "4.85722573273506`*^-17"}], ",", 
   RowBox[{"-", "4.996003610813204`*^-16"}], ",", "8.881784197001252`*^-16", 
   ",", "5.551115123125783`*^-16"}], "}"}]], "Print",
 CellChangeTimes->{3.542434173748083*^9, 3.542434206541093*^9, 
  3.542516295027487*^9, 3.5425166036427193`*^9, 3.542516707078085*^9, 
  3.5425298897435703`*^9, 3.5432268905368032`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Load", "Subsubtitle",
 CellChangeTimes->{{3.542529945644623*^9, 3.542529945947256*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dlistrr", "=", 
    RowBox[{"{", 
     RowBox[{"Trr", ",", "Arr", ",", "Brr", ",", "Frr", ",", "Srr"}], "}"}]}],
    ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dlistaa", "=", 
    RowBox[{"{", 
     RowBox[{"Taa", ",", "Aaa", ",", "Baa", ",", "Faa", ",", "Saa"}], "}"}]}],
    ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dlistra", "=", 
    RowBox[{"{", 
     RowBox[{"Tra", ",", "Ara", ",", "Bra", ",", "Fra", ",", "Sra"}], "}"}]}],
    ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dlist", "=", 
   RowBox[{"{", 
    RowBox[{
    "Tr", ",", "Ar", ",", "Br", ",", "Fr", ",", "Sr", ",", "Ta", ",", "Aa", 
     ",", "Ba", ",", "Fa", ",", "Sa"}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.542530207652843*^9, 3.542530211845208*^9}, 
   3.5425302481954403`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"dlist2", "=", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["Tr", "2"], ",", 
     RowBox[{"Ar", " ", "Tr"}], ",", 
     RowBox[{"Br", " ", "Tr"}], ",", 
     RowBox[{"Fr", " ", "Tr"}], ",", 
     RowBox[{"Sr", " ", "Tr"}], ",", 
     RowBox[{"Ta", " ", "Tr"}], ",", 
     RowBox[{"Aa", " ", "Tr"}], ",", 
     RowBox[{"Ba", " ", "Tr"}], ",", 
     RowBox[{"Fa", " ", "Tr"}], ",", 
     RowBox[{"Sa", " ", "Tr"}], ",", 
     SuperscriptBox["Ar", "2"], ",", 
     RowBox[{"Ar", " ", "Br"}], ",", 
     RowBox[{"Ar", " ", "Fr"}], ",", 
     RowBox[{"Ar", " ", "Sr"}], ",", 
     RowBox[{"Ar", " ", "Ta"}], ",", 
     RowBox[{"Aa", " ", "Ar"}], ",", 
     RowBox[{"Ar", " ", "Ba"}], ",", 
     RowBox[{"Ar", " ", "Fa"}], ",", 
     RowBox[{"Ar", " ", "Sa"}], ",", 
     SuperscriptBox["Br", "2"], ",", 
     RowBox[{"Br", " ", "Fr"}], ",", 
     RowBox[{"Br", " ", "Sr"}], ",", 
     RowBox[{"Br", " ", "Ta"}], ",", 
     RowBox[{"Aa", " ", "Br"}], ",", 
     RowBox[{"Ba", " ", "Br"}], ",", 
     RowBox[{"Br", " ", "Fa"}], ",", 
     RowBox[{"Br", " ", "Sa"}], ",", 
     SuperscriptBox["Fr", "2"], ",", 
     RowBox[{"Fr", " ", "Sr"}], ",", 
     RowBox[{"Fr", " ", "Ta"}], ",", 
     RowBox[{"Aa", " ", "Fr"}], ",", 
     RowBox[{"Ba", " ", "Fr"}], ",", 
     RowBox[{"Fa", " ", "Fr"}], ",", 
     RowBox[{"Fr", " ", "Sa"}], ",", 
     SuperscriptBox["Sr", "2"], ",", 
     RowBox[{"Sr", " ", "Ta"}], ",", 
     RowBox[{"Aa", " ", "Sr"}], ",", 
     RowBox[{"Ba", " ", "Sr"}], ",", 
     RowBox[{"Fa", " ", "Sr"}], ",", 
     RowBox[{"Sa", " ", "Sr"}], ",", 
     SuperscriptBox["Ta", "2"], ",", 
     RowBox[{"Aa", " ", "Ta"}], ",", 
     RowBox[{"Ba", " ", "Ta"}], ",", 
     RowBox[{"Fa", " ", "Ta"}], ",", 
     RowBox[{"Sa", " ", "Ta"}], ",", 
     SuperscriptBox["Aa", "2"], ",", 
     RowBox[{"Aa", " ", "Ba"}], ",", 
     RowBox[{"Aa", " ", "Fa"}], ",", 
     RowBox[{"Aa", " ", "Sa"}], ",", 
     SuperscriptBox["Ba", "2"], ",", 
     RowBox[{"Ba", " ", "Fa"}], ",", 
     RowBox[{"Ba", " ", "Sa"}], ",", 
     SuperscriptBox["Fa", "2"], ",", 
     RowBox[{"Fa", " ", "Sa"}], ",", 
     SuperscriptBox["Sa", "2"]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.542530313876471*^9, 3.542530317424692*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"coeffIT", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        FractionBox["1", "4"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "A"}], " ", 
           SuperscriptBox["r", "2"]}], "-", "T"}]], " ", "F", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["r", "2"]}], ")"}]}], ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "A"}], " ", 
          SuperscriptBox["r", "2"]}], "-", "T"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "8"}], "+", 
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{
               RowBox[{"16", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{"B", "+", "S"}]]}], "-", 
               RowBox[{
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "A"}], " ", 
                   SuperscriptBox["r", "2"]}], "-", "T"}]], " ", 
                SuperscriptBox["F", "2"], " ", 
                SuperscriptBox["r", "2"]}]}]]}]}], ")"}]}], "+", 
         RowBox[{"F", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}]}], ")"}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.542529942167356*^9, 3.5425299427703037`*^9}, 
   3.543226900220793*^9, {3.543226934782283*^9, 3.5432269368341846`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"coeffIS", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "A"}], " ", 
           SuperscriptBox["r", "2"]}], "-", "T"}]], " ", "F", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["r", "2"]}], ")"}]}], ",", "0", ",", "0", ",", "0", 
       ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "A"}], " ", 
          SuperscriptBox["r", "2"]}], "-", "T"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "4"}], "+", 
            SqrtBox[
             RowBox[{
              RowBox[{"16", " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"B", "+", "S"}]]}], "-", 
              RowBox[{
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "A"}], " ", 
                  SuperscriptBox["r", "2"]}], "-", "T"}]], " ", 
               SuperscriptBox["F", "2"], " ", 
               SuperscriptBox["r", "2"]}]}]]}], ")"}]}], "-", 
         RowBox[{"F", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.5425299386852627`*^9, 3.542529939305862*^9}, 
   3.543226903044661*^9, {3.5432269408773537`*^9, 3.543226941505526*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"coeffIA", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "A"}], " ", 
             SuperscriptBox["r", "2"]}], "-", "T"}]], " ", "F", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}]}], 
         RowBox[{"2", " ", "r"}]]}], ",", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "4"]}], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "A"}], " ", 
           SuperscriptBox["r", "2"]}], "-", "T"}]], " ", "F", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["r", "2"]}], ")"}]}], ",", "0", ",", 
       FractionBox[
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "A"}], " ", 
            SuperscriptBox["r", "2"]}], "-", "T"}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], 
        RowBox[{"2", " ", "r"}]], ",", "0", ",", "0", ",", "1", ",", "0", ",",
        "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "A"}], " ", 
         SuperscriptBox["r", "2"]}], "-", "T"}]], " ", "F", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"A", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.542529934525259*^9, 3.5425299351250896`*^9}, 
   3.543226905612363*^9, {3.543226946485059*^9, 3.543226947168971*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"coeffzeroF", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     "F"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5425299311676683`*^9, 3.542529931794753*^9}, 
   3.543226907901411*^9, {3.5432269512530737`*^9, 3.5432269520069933`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"coeffzeroF2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     SuperscriptBox["F", "2"]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.543228229938426*^9, 3.543228230556302*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"coeffHa", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", "S"}]], " ", "F", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}]}], 
         RowBox[{
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
          RowBox[{
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}]}]]}], ",", 
       FractionBox[
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", "S"}]], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], 
        RowBox[{
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
         RowBox[{
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["r", "2"]}]}]], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", "S"}]], " ", "F", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}]}], 
         RowBox[{
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
          RowBox[{
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}]}]]}], ",", 
       FractionBox[
        RowBox[{
         RowBox[{"32", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
         RowBox[{
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["r", "2"]}]}], 
        RowBox[{
         RowBox[{"32", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["r", "2"]}]}]], ",", 
       FractionBox[
        RowBox[{"8", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
         SuperscriptBox["r", "2"]}], 
        RowBox[{
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
         RowBox[{
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["r", "2"]}]}]], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"8", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], 
         RowBox[{
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
          RowBox[{
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}]}]]}], ",", "0", ",", 
       FractionBox[
        RowBox[{
         RowBox[{"8", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
         RowBox[{
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["r", "2"]}]}], 
        RowBox[{
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
         RowBox[{
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["r", "2"]}]}]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
          RowBox[{
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], " ", "rh"}]], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "S"}], "-", "T"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"128", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"2", " ", "B"}], "+", 
           RowBox[{"3", " ", "S"}], "+", "T"}]]}], "+", 
        RowBox[{"128", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"2", " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"3", " ", "S"}], "+", "T"}]]}], "+", 
        RowBox[{"256", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"2", " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"S", "+", "T"}], ")"}]}]}]]}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"2", " ", "S"}]}]], " ", 
         SuperscriptBox["F", "2"], " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"40", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"S", "+", "T"}]], " ", 
         SuperscriptBox["F", "2"], " ", 
         SuperscriptBox["r", "2"]}], "-", 
        RowBox[{"16", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", "S", "+", "T"}]], " ", 
         SuperscriptBox["F", "2"], " ", 
         SuperscriptBox["r", "2"]}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", 
           RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
        RowBox[{"64", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", 
           RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", "T"], " ", 
         SuperscriptBox["F", "3"], " ", 
         SuperscriptBox["r", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "F", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", "S"], " ", 
         SuperscriptBox["F", "3"], " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
        RowBox[{"16", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "F", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "4"]}], ")"}], " ", "rh"}], "-", 
        RowBox[{"64", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
         RowBox[{"(", 
          RowBox[{"8", "+", 
           RowBox[{"B", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}]}]}], 
       ")"}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.542529927757346*^9, 3.542529928366632*^9}, 
   3.543226912156705*^9, {3.5432269592607937`*^9, 3.543226959953426*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"coeffHr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox["F", "2"], " ", 
         SuperscriptBox["r", "2"]}], 
        RowBox[{
         RowBox[{
          RowBox[{"-", "32"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["r", "2"]}]}]], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"8", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
          RowBox[{
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}]}]]}], ",", 
       FractionBox[
        RowBox[{"8", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], 
        RowBox[{
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
         RowBox[{
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["r", "2"]}]}]], ",", "0", ",", 
       FractionBox[
        RowBox[{
         RowBox[{"24", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
         RowBox[{
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["r", "2"]}]}], 
        RowBox[{
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
         RowBox[{
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["r", "2"]}]}]], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "F", " ", "r"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]]}], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "F", " ", 
          SuperscriptBox["r", "3"]}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]]}], ",", "0", ",", 
       FractionBox[
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "r"}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}]], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", " ", "r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
          RowBox[{
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], " ", "rh"}]], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "S"}], "-", "T"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "16"}], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "F", " ", 
         SuperscriptBox["r", "2"]}], "-", 
        RowBox[{"16", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "F", " ", 
         SuperscriptBox["r", "2"]}], "-", 
        RowBox[{"16", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", 
           RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
         SuperscriptBox["r", "2"]}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", 
           RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", "S"], " ", 
         SuperscriptBox["F", "3"], " ", 
         SuperscriptBox["r", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", "T"], " ", 
         SuperscriptBox["F", "3"], " ", 
         SuperscriptBox["r", "4"]}], "+", 
        RowBox[{"64", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"2", " ", "A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", 
           RowBox[{"3", " ", "T"}]}]], " ", 
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
        RowBox[{"128", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"2", " ", "A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", 
           RowBox[{"3", " ", "T"}]}]], " ", 
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "T"}]}]], " ", 
         SuperscriptBox["F", "2"], " ", 
         SuperscriptBox["r", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]}]], 
         " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
         SuperscriptBox["F", "2"], " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"S", "+", "T"}]], " ", 
         SuperscriptBox["F", "2"], " ", 
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["r", "4"]}]}], ")"}], " ", "rh"}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "5"}], "+", "A"}], ")"}], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "4"]}]}], ")"}], " ", "rh"}]}], ")"}]}]}], 
    "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.542529907916905*^9, 3.5425299246372423`*^9}, 
   3.543226917115231*^9, {3.543226965140644*^9, 3.5432269658743267`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"coeffphi", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"16", " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"B", "+", 
                 RowBox[{"A", " ", 
                  SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
              RowBox[{
               SuperscriptBox["F", "2"], " ", 
               SuperscriptBox["r", "2"]}]}], ")"}], "3"]}]]}], 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "S"}], "-", "T"}]], " ", 
        SuperscriptBox["F", "2"], " ", "r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"40", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"S", "+", "T"}]], " ", 
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"512", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
          RowBox[{"1024", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
          RowBox[{"96", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"128", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", "T"], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["r", "6"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", "S"], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["r", "4"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "5"}], "+", "A"}], ")"}], " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "4"]}]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"64", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", "F", " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"10", "+", 
             RowBox[{"B", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}]}]}], 
         ")"}]}], ",", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"16", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"B", "+", 
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
             RowBox[{
              SuperscriptBox["F", "2"], " ", 
              SuperscriptBox["r", "2"]}]}], ")"}], "3"]]}], "4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"B", "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}]}]], " ", "r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"40", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"S", "+", "T"}]], " ", 
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"512", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
          RowBox[{"1024", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
          RowBox[{"96", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"128", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", "T"], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["r", "6"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", "S"], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["r", "4"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "5"}], "+", "A"}], ")"}], " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "4"]}]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"64", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", "F", " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"10", "+", 
             RowBox[{"B", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}]}]}], 
         ")"}]}], ",", 
       RowBox[{
        FractionBox["1", 
         RowBox[{"r", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"16", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"B", "+", 
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
             RowBox[{
              SuperscriptBox["F", "2"], " ", 
              SuperscriptBox["r", "2"]}]}], ")"}], "3"]}]], "4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"B", "-", "T"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "256"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"512", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", "F", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["r", "4"]}], "-", 
          RowBox[{"24", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"64", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["r", "4"]}], "-", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", "S"], " ", 
           SuperscriptBox["F", "5"], " ", 
           SuperscriptBox["r", "6"]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["\[ExponentialE]", "T"], " ", 
           SuperscriptBox["F", "5"], " ", 
           SuperscriptBox["r", "6"]}], "+", 
          RowBox[{"512", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"3", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"4", " ", "T"}]}]], " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
          RowBox[{"1024", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"3", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"4", " ", "T"}]}]], " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"128", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["r", "6"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"3", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]}]],
            " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]}]],
            " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["r", "4"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"S", "+", "T"}]], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["r", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "-", 
             RowBox[{"6", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"7", " ", 
              SuperscriptBox["r", "4"]}]}], ")"}], " ", "rh"}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"2", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "9"}], "+", "A"}], ")"}], " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "4"]}]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "5"}], "+", "A"}], ")"}], " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "4"]}]}], ")"}], " ", "rh"}], "+", 
          RowBox[{"64", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", "F", " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"6", "+", 
             RowBox[{"B", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}]}]}], 
         ")"}]}], ",", 
       RowBox[{
        FractionBox["1", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "3"]], "4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"B", "-", "T"}]], " ", "r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]]}], "+", 
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]]}], "+", 
          RowBox[{"512", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]]}], "-", 
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"64", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"64", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", "S"], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["\[ExponentialE]", "T"], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"S", "+", "T"}]], " ", 
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "-", 
             RowBox[{"6", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"7", " ", 
              SuperscriptBox["r", "4"]}]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", "F", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"2", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "6"}], "+", "A"}], ")"}], " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "4"]}]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"128", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{"8", "+", 
             RowBox[{"B", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}]}]}], 
         ")"}]}], ",", 
       RowBox[{
        FractionBox["1", 
         RowBox[{"2", " ", "r", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"16", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"B", "+", 
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
             RowBox[{
              SuperscriptBox["F", "2"], " ", 
              SuperscriptBox["r", "2"]}]}], ")"}], "3"]}]], 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "S"}], "-", "T"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2048"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"3", " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"4", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"2048", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"3", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"4", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"4096", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"3", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", "F", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"128", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"3", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"512", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["r", "4"]}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", "S"}]}]], " ", 
           SuperscriptBox["F", "5"], " ", 
           SuperscriptBox["r", "6"]}], "-", 
          RowBox[{"40", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"S", "+", "T"}]], " ", 
           SuperscriptBox["F", "5"], " ", 
           SuperscriptBox["r", "6"]}], "-", 
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", "S", "+", "T"}]], " ", 
           SuperscriptBox["F", "5"], " ", 
           SuperscriptBox["r", "6"]}], "+", 
          RowBox[{"12288", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"3", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"4", " ", "T"}]}]], " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
          RowBox[{"24576", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"3", " ", "B"}], "+", 
             RowBox[{"3", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"4", " ", "T"}]}]], " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"1280", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"4096", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["r", "6"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
          RowBox[{"224", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["r", "6"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", "T"], " ", 
           SuperscriptBox["F", "6"], " ", 
           SuperscriptBox["r", "8"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"6144", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"3", " ", "B"}], "+", 
             RowBox[{"3", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"4", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "+", 
          RowBox[{"1024", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
          RowBox[{"56", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["r", "4"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "+", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", "S"], " ", 
           SuperscriptBox["F", "6"], " ", 
           SuperscriptBox["r", "6"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["r", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "-", 
             RowBox[{"12", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"13", " ", 
              SuperscriptBox["r", "4"]}]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"6144", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"3", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"4", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "5"}], "+", "A"}], ")"}], " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "4"]}]}], ")"}], " ", "rh"}], "+", 
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"3", "-", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "10"}], "+", "A"}], ")"}], " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "4"]}]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"512", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", "F", " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"14", "+", 
             RowBox[{"B", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}]}], 
          "+", 
          RowBox[{"64", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["r", "4"], " ", 
           RowBox[{"(", 
            RowBox[{"17", "+", 
             RowBox[{"B", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}]}]}], 
         ")"}]}], ",", 
       RowBox[{
        FractionBox["1", 
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"16", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"B", "+", 
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
             RowBox[{
              SuperscriptBox["F", "2"], " ", 
              SuperscriptBox["r", "2"]}]}], ")"}], "3"]}]], 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "S"}], "-", "T"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["r", "2"]}], ")"}], " ", "rh", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8192", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"3", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"4", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]]}], "+", 
          RowBox[{"8192", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"3", " ", "B"}], "+", 
             RowBox[{"3", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"4", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]]}], "+", 
          RowBox[{"16384", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"3", " ", "B"}], "+", 
             RowBox[{"3", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"4", " ", "T"}]}]]}], "-", 
          RowBox[{"768", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"1280", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"2560", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"64", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["r", "4"]}], "-", 
          RowBox[{"224", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"128", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["r", "4"]}], "-", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", "S"], " ", 
           SuperscriptBox["F", "6"], " ", 
           SuperscriptBox["r", "6"]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["\[ExponentialE]", "T"], " ", 
           SuperscriptBox["F", "6"], " ", 
           SuperscriptBox["r", "6"]}], "-", 
          RowBox[{"2048", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"3", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"4", " ", "T"}]}]], " ", "F", " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"4096", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"3", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"4", " ", "T"}]}]], " ", "F", " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
          RowBox[{"128", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["r", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
          RowBox[{"512", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["r", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "5"], " ", 
           SuperscriptBox["r", "6"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
          RowBox[{"1024", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"3", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]}]],
            " ", "F", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
          RowBox[{"128", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]}]],
            " ", 
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
           SuperscriptBox["F", "5"], " ", 
           SuperscriptBox["r", "4"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
          RowBox[{"1024", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", "F", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "4"]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"S", "+", "T"}]], " ", 
           SuperscriptBox["F", "5"], " ", 
           SuperscriptBox["r", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "-", 
             RowBox[{"6", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"7", " ", 
              SuperscriptBox["r", "4"]}]}], ")"}], " ", "rh"}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"4", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "8"}], "+", "A"}], ")"}], " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "4"]}]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"4096", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"3", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"4", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{"8", "+", 
             RowBox[{"B", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}]}], 
          "+", 
          RowBox[{"128", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"44", "+", 
             RowBox[{"3", " ", "B", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}]}]}], 
         ")"}]}], ",", 
       RowBox[{
        FractionBox["1", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "3"]], "2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "-", "S"}]], " ", 
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["r", "2"]}], ")"}], " ", "rh", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"1024", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"3", " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"4", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]]}], "+", 
          RowBox[{"1024", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"3", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"4", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]]}], "+", 
          RowBox[{"2048", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"3", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}]]}], "-", 
          RowBox[{"64", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"3", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"128", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", "S"}]}]], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["r", "4"]}], "-", 
          RowBox[{"40", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"S", "+", "T"}]], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", "S", "+", "T"}]], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["r", "4"]}], "-", 
          RowBox[{"512", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", "F", " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"1024", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", "F", " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["r", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
          RowBox[{"128", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["r", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", "T"], " ", 
           SuperscriptBox["F", "5"], " ", 
           SuperscriptBox["r", "6"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "+", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", "S"], " ", 
           SuperscriptBox["F", "5"], " ", 
           SuperscriptBox["r", "4"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"6", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"5", " ", 
              SuperscriptBox["r", "4"]}]}], ")"}], " ", "rh"}], "+", 
          RowBox[{"128", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"4", "+", 
             RowBox[{"A", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}], " ", "rh"}], 
          "-", 
          RowBox[{"512", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
           RowBox[{"(", 
            RowBox[{"8", "+", 
             RowBox[{"B", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}]}], 
          "+", 
          RowBox[{"64", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"14", "+", 
             RowBox[{"B", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}]}]}], 
         ")"}]}], ",", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"16", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"B", "+", 
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
             RowBox[{
              SuperscriptBox["F", "2"], " ", 
              SuperscriptBox["r", "2"]}]}], ")"}], "3"]]}], "8", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"B", "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["r", "2"]}], ")"}], " ", "rh", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]]}], "+", 
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]]}], "+", 
          RowBox[{"512", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]]}], "-", 
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"64", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"64", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", "S"], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["\[ExponentialE]", "T"], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"S", "+", "T"}]], " ", 
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "-", 
             RowBox[{"6", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"7", " ", 
              SuperscriptBox["r", "4"]}]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", "F", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"2", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "6"}], "+", "A"}], ")"}], " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "4"]}]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"128", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{"8", "+", 
             RowBox[{"B", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}]}]}], 
         ")"}]}], ",", 
       RowBox[{
        FractionBox["1", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "3"]], "2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "-", "S"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["r", "2"]}], ")"}], " ", "rh", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"40", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"S", "+", "T"}]], " ", 
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"512", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
          RowBox[{"1024", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
          RowBox[{"96", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"128", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", "T"], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["r", "6"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", "S"], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["r", "4"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "5"}], "+", "A"}], ")"}], " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "4"]}]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"64", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", "F", " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"10", "+", 
             RowBox[{"B", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}]}]}], 
         ")"}]}], ",", 
       RowBox[{
        FractionBox["1", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "3"]], 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "S"}], "-", "T"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
          RowBox[{
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}]}], ")"}], " ", "rh", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]]}], "+", 
          RowBox[{"256", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"3", " ", "S"}], "+", 
             RowBox[{"2", " ", "T"}]}]]}], "+", 
          RowBox[{"512", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"2", " ", "B"}], "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]]}], "-", 
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"64", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"64", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", 
             RowBox[{"2", " ", "T"}]}]], " ", 
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", "S"], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["\[ExponentialE]", "T"], " ", 
           SuperscriptBox["F", "4"], " ", 
           SuperscriptBox["r", "4"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"S", "+", "T"}]], " ", 
           SuperscriptBox["F", "3"], " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "-", 
             RowBox[{"6", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"7", " ", 
              SuperscriptBox["r", "4"]}]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", "F", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"2", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "6"}], "+", "A"}], ")"}], " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "4"]}]}], ")"}], " ", "rh"}], "-", 
          RowBox[{"128", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"2", " ", "A", " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"2", " ", "S"}], "+", 
             RowBox[{"3", " ", "T"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{"8", "+", 
             RowBox[{"B", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}]}]}], 
         ")"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", "S"}]], " ", 
         SuperscriptBox["F", "4"], " ", 
         SuperscriptBox["r", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "4"], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       FractionBox[
        RowBox[{"32", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"2", " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
         SuperscriptBox["F", "2"], " ", 
         SuperscriptBox["r", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "4"], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", "S"}]], " ", 
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          SuperscriptBox["rh", "2"]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "3"]]}], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", "S"}]], " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["r", "4"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "4"], " ", 
          SuperscriptBox["rh", "2"]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "3"]]}], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"8", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", "S"}]], " ", 
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"12", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          SuperscriptBox["rh", "2"]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "3"]]}], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["F", "5"], " ", 
          SuperscriptBox["r", "5"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "3"], " ", 
          SuperscriptBox["rh", "2"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "16"}], " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"B", "+", 
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
             RowBox[{
              SuperscriptBox["F", "2"], " ", 
              SuperscriptBox["r", "2"]}]}], ")"}], "3"]}]]}], ",", 
       FractionBox[
        RowBox[{"8", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
         SuperscriptBox["F", "3"], " ", 
         SuperscriptBox["r", "5"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "3"], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       FractionBox[
        RowBox[{"8", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
         SuperscriptBox["F", "3"], " ", 
         SuperscriptBox["r", "3"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "3"], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["r", "3"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "3"], " ", 
          SuperscriptBox["rh", "2"]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "3"]]}], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["r", "3"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "8"}], " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          SuperscriptBox["rh", "2"]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "16"}], " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "3"]]}], ",", 
       FractionBox[
        RowBox[{"256", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"3", " ", "B"}], "+", 
           RowBox[{"2", " ", "A", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"3", " ", "S"}], "+", 
           RowBox[{"2", " ", "T"}]}]], " ", 
         SuperscriptBox["r", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "4"], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"64", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          SuperscriptBox["rh", "2"]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "3"]]}], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"64", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "F", " ", 
          SuperscriptBox["r", "4"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "4"], " ", 
          SuperscriptBox["rh", "2"]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "3"]]}], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"128", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"12", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          SuperscriptBox["rh", "2"]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "3"]]}], ",", 
       FractionBox[
        RowBox[{"8", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
         SuperscriptBox["F", "3"], " ", 
         SuperscriptBox["r", "5"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "3"], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       FractionBox[
        RowBox[{"128", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]], " ",
          "F", " ", 
         SuperscriptBox["r", "5"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "3"], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       FractionBox[
        RowBox[{"128", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]], " ",
          "F", " ", 
         SuperscriptBox["r", "3"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "3"], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"256", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]], 
          " ", 
          SuperscriptBox["r", "3"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "3"], " ", 
          SuperscriptBox["rh", "2"]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "3"]]}], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "F", " ", 
          SuperscriptBox["r", "3"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          SuperscriptBox["rh", "2"]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "3"]]}], ",", 
       FractionBox[
        RowBox[{"256", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"3", " ", "B"}], "+", 
           RowBox[{"2", " ", "A", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"3", " ", "S"}], "+", 
           RowBox[{"2", " ", "T"}]}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "4"], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"64", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"2", " ", "B"}], "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "F", " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "4"], " ", 
          SuperscriptBox["rh", "2"]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "3"]]}], ",", 
       FractionBox[
        RowBox[{"8", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", "S"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"192", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"B", "+", 
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]]}],
            "-", 
           RowBox[{"24", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["F", "4"], " ", 
            SuperscriptBox["r", "4"]}]}], ")"}], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"8", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "F", " ",
           "r", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"64", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{"5", " ", 
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          SuperscriptBox["rh", "2"]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "3"]]}], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"32", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "F", " ", 
          SuperscriptBox["r", "3"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"12", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          SuperscriptBox["rh", "2"]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "3"]]}], ",", 
       FractionBox[
        RowBox[{"128", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]], " ",
          "F", " ", "r", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "3"], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       FractionBox[
        RowBox[{"32", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "r", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "F", " ",
           "r", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          SuperscriptBox["rh", "2"]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "3"]]}], ",", 
       FractionBox[
        RowBox[{"64", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"2", " ", "B"}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "S"}], "+", "T"}]], " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "4"], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       FractionBox[
        RowBox[{"8", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", "S"}]], " ", "F", " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       FractionBox[
        RowBox[{"16", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "r", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"32", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       FractionBox[
        RowBox[{"32", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
         SuperscriptBox["r", "3"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"256", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]], 
          " ", "r", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "3"], " ", 
          SuperscriptBox["rh", "2"]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "3"]]}], ",", 
       FractionBox[
        RowBox[{"32", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "F", " ", 
         SuperscriptBox["r", "3"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "3"], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       FractionBox[
        RowBox[{"32", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "r", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       FractionBox[
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", "S"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"576", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"B", "+", 
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]]}],
            "-", 
           RowBox[{"80", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["F", "4"], " ", 
            SuperscriptBox["r", "4"]}]}], ")"}], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       FractionBox[
        RowBox[{"F", " ", "r", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "512"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"B", "+", 
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]]}],
            "+", 
           RowBox[{"24", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["F", "4"], " ", 
            SuperscriptBox["r", "4"]}]}], ")"}], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "F", " ", 
          SuperscriptBox["r", "3"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"40", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          SuperscriptBox["rh", "2"]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "3"]]}], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "F", " ",
           "r", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          SuperscriptBox["rh", "2"]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "3"]]}], ",", 
       FractionBox[
        RowBox[{"64", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", "r", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"12", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"2", " ", "F", " ", "r", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "3"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "8"}], " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"B", "+", 
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
             RowBox[{
              SuperscriptBox["F", "2"], " ", 
              SuperscriptBox["r", "2"]}]}], ")"}], "2"], " ", 
          SuperscriptBox["rh", "2"]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "16"}], " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "3"]]}], ",", 
       FractionBox[
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"1024", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"B", "+", 
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]]}],
            "-", 
           RowBox[{"128", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["F", "4"], " ", 
            SuperscriptBox["r", "4"]}]}], ")"}], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       FractionBox[
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"256", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"B", "+", 
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]]}],
            "-", 
           RowBox[{"24", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["F", "4"], " ", 
            SuperscriptBox["r", "4"]}]}], ")"}], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"32", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"32", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          SuperscriptBox["rh", "2"]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "3"]]}], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
          SuperscriptBox["F", "3"], " ", 
          SuperscriptBox["r", "4"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
          SuperscriptBox["rh", "2"]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "3"]]}], ",", 
       FractionBox[
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"256", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"B", "+", 
                RowBox[{"A", " ", 
                 SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]]}],
            "-", 
           RowBox[{"56", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["F", "4"], " ", 
            SuperscriptBox["r", "4"]}]}], ")"}], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       FractionBox[
        RowBox[{"256", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"2", " ", "B"}], "+", 
           RowBox[{"3", " ", "A", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "S"}], "+", 
           RowBox[{"3", " ", "T"}]}]], " ", 
         SuperscriptBox["r", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"64", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          SuperscriptBox["rh", "2"]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "3"]]}], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"64", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
          SuperscriptBox["r", "4"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
          SuperscriptBox["rh", "2"]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "3"]]}], ",", 
       FractionBox[
        RowBox[{"8", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "8"}], " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "2"], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       FractionBox[
        RowBox[{"256", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"2", " ", "B"}], "+", 
           RowBox[{"3", " ", "A", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "S"}], "+", 
           RowBox[{"3", " ", "T"}]}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"64", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
          SuperscriptBox["rh", "2"]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "3"]]}], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"64", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"2", " ", "A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", 
            RowBox[{"2", " ", "T"}]}]], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          SuperscriptBox["rh", "2"]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "3"]]}], ",", 
       FractionBox[
        RowBox[{"64", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"2", " ", "A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", 
           RowBox[{"2", " ", "T"}]}]], " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       FractionBox[
        RowBox[{"8", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "F", " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]], ",", 
       FractionBox[
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "8"}], " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
            RowBox[{
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "2"], " ", 
         SuperscriptBox["rh", "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"]]}], "}"}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "4"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "16"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
           RowBox[{
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], "3"], " ", 
        SuperscriptBox["rh", "4"]}]], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        RowBox[{"(", 
         RowBox[{"S", "+", "T"}], ")"}]}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"rh", "-", 
         RowBox[{
          SuperscriptBox["r", "2"], " ", "rh"}]}], ")"}], "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "/", 
          SuperscriptBox["r", "2"]}], "4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", "S"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "F", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", 
               RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "F", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", 
               RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"32", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", 
               RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["\[ExponentialE]", "S"], " ", 
             SuperscriptBox["F", "3"], " ", 
             SuperscriptBox["r", "4"]}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["\[ExponentialE]", "T"], " ", 
             SuperscriptBox["F", "3"], " ", 
             SuperscriptBox["r", "4"]}], "-", 
            RowBox[{"64", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"2", " ", "A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", 
               RowBox[{"3", " ", "T"}]}]], " ", 
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
            RowBox[{"128", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"2", " ", "A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", 
               RowBox[{"3", " ", "T"}]}]], " ", 
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
            RowBox[{"8", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", 
               RowBox[{"2", " ", "T"}]}]], " ", 
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
            RowBox[{"32", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"A", " ", 
                   SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], 
                 ")"}]}]}]], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"S", "+", "T"}]], " ", 
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "-", 
               RowBox[{"6", " ", 
                SuperscriptBox["r", "2"]}], "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["r", "4"]}]}], ")"}], " ", "rh"}], "+", 
            RowBox[{"32", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "5"}], "+", "A"}], ")"}], " ", 
                SuperscriptBox["r", "2"]}], "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "4"]}]}], ")"}], " ", "rh"}]}], ")"}], 
          "2"]}], "-", 
        RowBox[{"F", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "16"}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "F", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", 
              RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "F", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", 
              RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"32", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", 
              RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", "S"], " ", 
            SuperscriptBox["F", "3"], " ", 
            SuperscriptBox["r", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["\[ExponentialE]", "T"], " ", 
            SuperscriptBox["F", "3"], " ", 
            SuperscriptBox["r", "4"]}], "+", 
           RowBox[{"64", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"2", " ", "A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", 
              RowBox[{"3", " ", "T"}]}]], " ", 
            SuperscriptBox["r", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
           RowBox[{"128", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"2", " ", "A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", 
              RowBox[{"3", " ", "T"}]}]], " ", 
            SuperscriptBox["r", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
           RowBox[{"8", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", 
              RowBox[{"2", " ", "T"}]}]], " ", 
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
           RowBox[{"32", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"A", " ", 
                  SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], 
                ")"}]}]}]], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"S", "+", "T"}]], " ", 
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"7", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}], " ", "rh"}], "-", 
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "5"}], "+", "A"}], ")"}], " ", 
               SuperscriptBox["r", "2"]}], "+", 
              RowBox[{"2", " ", "A", " ", 
               SuperscriptBox["r", "4"]}]}], ")"}], " ", "rh"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"128", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"2", " ", "B"}], "+", 
              RowBox[{"3", " ", "S"}], "+", "T"}]]}], "+", 
           RowBox[{"128", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"2", " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", 
              RowBox[{"3", " ", "S"}], "+", "T"}]]}], "+", 
           RowBox[{"256", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"2", " ", "B"}], "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{"S", "+", "T"}], ")"}]}]}]]}], "-", 
           RowBox[{"8", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"2", " ", "S"}]}]], " ", 
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"40", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"S", "+", "T"}]], " ", 
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", "S", "+", "T"}]], " ", 
            SuperscriptBox["F", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"32", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", 
              RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
            SuperscriptBox["r", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
           RowBox[{"64", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", "S", "+", 
              RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
            SuperscriptBox["r", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["\[ExponentialE]", "T"], " ", 
            SuperscriptBox["F", "3"], " ", 
            SuperscriptBox["r", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", 
              RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "F", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", "S"], " ", 
            SuperscriptBox["F", "3"], " ", 
            SuperscriptBox["r", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "-", 
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "F", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "4"]}], ")"}], " ", "rh"}], "-", 
           RowBox[{"64", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"B", "+", 
              RowBox[{"A", " ", 
               SuperscriptBox["r", "2"]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
            RowBox[{"(", 
             RowBox[{"8", "+", 
              RowBox[{"B", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}]}]}], 
          ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "128"}], " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"2", " ", "B"}], "+", 
               RowBox[{"3", " ", "S"}], "+", "T"}]]}], "-", 
            RowBox[{"128", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"2", " ", "B"}], "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", 
               RowBox[{"3", " ", "S"}], "+", "T"}]]}], "-", 
            RowBox[{"256", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"2", " ", "B"}], "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{"S", "+", "T"}], ")"}]}]}]]}], "+", 
            RowBox[{"8", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"2", " ", "S"}]}]], " ", 
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"40", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"S", "+", "T"}]], " ", 
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", "S", "+", "T"}]], " ", 
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"32", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", 
               RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
            RowBox[{"64", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", "S", "+", 
               RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["\[ExponentialE]", "T"], " ", 
             SuperscriptBox["F", "3"], " ", 
             SuperscriptBox["r", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", 
               RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "F", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "+", 
            RowBox[{
             SuperscriptBox["\[ExponentialE]", "S"], " ", 
             SuperscriptBox["F", "3"], " ", 
             SuperscriptBox["r", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "+", 
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "F", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["r", "4"]}], ")"}], " ", "rh"}], "+", 
            RowBox[{"64", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", 
               RowBox[{"A", " ", 
                SuperscriptBox["r", "2"]}], "+", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
             RowBox[{"(", 
              RowBox[{"8", "+", 
               RowBox[{"B", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}]}]}],
            ")"}], "2"]}]}], ")"}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.542529911463223*^9, 3.542529919197894*^9}, 
   3.5432269253426456`*^9, {3.5432269886439037`*^9, 3.543226989687953*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Choose equations", "Subsubtitle",
 CellChangeTimes->{{3.460389558463635*^9, 3.460389558896888*^9}, {
  3.460389609430746*^9, 3.4603896114348288`*^9}, {3.5183299969175587`*^9, 
  3.5183299978831244`*^9}, {3.5425166321454277`*^9, 3.542516634216238*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"coeffs", "=", 
   RowBox[{"{", 
    RowBox[{
    "coeffIT", ",", "coeffIS", ",", "coeffIA", ",", "coeffzeroF", ",", 
     "coeffHa"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.542434481394114*^9, 3.542434490506403*^9}, {
  3.5424345578255167`*^9, 3.542434560016334*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"coeffs", "=", 
   RowBox[{"{", 
    RowBox[{
    "coeffIT", ",", "coeffIS", ",", "coeffIA", ",", "coeffzeroF", ",", 
     "coeffHr"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.542516921656436*^9, 3.542516921735289*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"coeffs", "=", 
   RowBox[{"{", 
    RowBox[{
    "coeffIT", ",", "coeffIS", ",", "coeffIA", ",", "coeffzeroF", ",", 
     "coeffphi"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.542532308620303*^9, 3.5425323157730217`*^9}, {
  3.5425357747034817`*^9, 3.54253577847812*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"coeffs", "=", 
   RowBox[{"{", 
    RowBox[{
    "coeffIT", ",", "coeffIS", ",", "coeffIA", ",", "coeffzeroF", ",", 
     "coeffHr"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.543227524574533*^9, 3.543227525492544*^9}, 
   3.543227737538726*^9, {3.543228097738264*^9, 3.543228098929448*^9}, 
   3.5432282425308447`*^9, {3.543228320122718*^9, 3.543228326523291*^9}, {
   3.543229207007332*^9, 3.543229210790758*^9}, {3.543229663129097*^9, 
   3.543229682770186*^9}, 3.543229954951517*^9, {3.543230647064898*^9, 
   3.543230656119505*^9}, 3.543231168868951*^9, {3.543231457271205*^9, 
   3.543231457396624*^9}, 3.543231642997213*^9, {3.543237253394926*^9, 
   3.5432372544980383`*^9}, {3.5432375140583057`*^9, 
   3.5432375156776533`*^9}, {3.543237661334475*^9, 3.54323766609324*^9}, {
   3.5432377093581743`*^9, 3.543237714604002*^9}, {3.543237997574506*^9, 
   3.543237999941072*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Process", "Subsubtitle",
 CellChangeTimes->{{3.542434754898597*^9, 3.5424347596026077`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"newcoeffrr", "=", 
   RowBox[{"coeffs", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "1"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"newcoeffaa", "=", 
   RowBox[{"coeffs", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"newcoeffra", "=", 
  RowBox[{"coeffs", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "3"}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.542434599734383*^9, 3.542434644730691*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.542434600295046*^9, 3.542434645216639*^9}, 
   3.5425162966622553`*^9, 3.542516346776931*^9, 3.542516389366436*^9, 
   3.5425164214271317`*^9, 3.542516460959085*^9, 3.542516496404757*^9, 
   3.542516531934021*^9, 3.542516603762073*^9, 3.542516707198958*^9, 
   3.542516924793713*^9, 3.5425170686273413`*^9, 3.542530100790053*^9, 
   3.542530153763361*^9, 3.542530224651846*^9, 3.542530259363885*^9, 
   3.542530324318509*^9, 3.5425323259320107`*^9, 3.542533458539773*^9, 
   3.542535790179215*^9, 3.542535868877576*^9, 3.5425382645953407`*^9, 
   3.543227022141005*^9, 3.5432270633874493`*^9, 3.5432272009601507`*^9, 
   3.543227533869466*^9, 3.543227758042472*^9, 3.5432281226477413`*^9, 
   3.543228249405427*^9, 3.5432283423029633`*^9, 3.543229229834753*^9, 
   3.543229565947241*^9, 3.543229707332026*^9, 3.543229972049404*^9, 
   3.543230671475618*^9, 3.5432311824502563`*^9, 3.543231468365082*^9, 
   3.543231657899173*^9, 3.543237270874639*^9, 3.543237678122531*^9, 
   3.543237727701024*^9, 3.543238010064238*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.542434600295046*^9, 3.542434645216639*^9}, 
   3.5425162966622553`*^9, 3.542516346776931*^9, 3.542516389366436*^9, 
   3.5425164214271317`*^9, 3.542516460959085*^9, 3.542516496404757*^9, 
   3.542516531934021*^9, 3.542516603762073*^9, 3.542516707198958*^9, 
   3.542516924793713*^9, 3.5425170686273413`*^9, 3.542530100790053*^9, 
   3.542530153763361*^9, 3.542530224651846*^9, 3.542530259363885*^9, 
   3.542530324318509*^9, 3.5425323259320107`*^9, 3.542533458539773*^9, 
   3.542535790179215*^9, 3.542535868877576*^9, 3.5425382645953407`*^9, 
   3.543227022141005*^9, 3.5432270633874493`*^9, 3.5432272009601507`*^9, 
   3.543227533869466*^9, 3.543227758042472*^9, 3.5432281226477413`*^9, 
   3.543228249405427*^9, 3.5432283423029633`*^9, 3.543229229834753*^9, 
   3.543229565947241*^9, 3.543229707332026*^9, 3.543229972049404*^9, 
   3.543230671475618*^9, 3.5432311824502563`*^9, 3.543231468365082*^9, 
   3.543231657899173*^9, 3.543237270874639*^9, 3.543237678122531*^9, 
   3.543237727701024*^9, 3.543238010067814*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.542434600295046*^9, 3.542434645216639*^9}, 
   3.5425162966622553`*^9, 3.542516346776931*^9, 3.542516389366436*^9, 
   3.5425164214271317`*^9, 3.542516460959085*^9, 3.542516496404757*^9, 
   3.542516531934021*^9, 3.542516603762073*^9, 3.542516707198958*^9, 
   3.542516924793713*^9, 3.5425170686273413`*^9, 3.542530100790053*^9, 
   3.542530153763361*^9, 3.542530224651846*^9, 3.542530259363885*^9, 
   3.542530324318509*^9, 3.5425323259320107`*^9, 3.542533458539773*^9, 
   3.542535790179215*^9, 3.542535868877576*^9, 3.5425382645953407`*^9, 
   3.543227022141005*^9, 3.5432270633874493`*^9, 3.5432272009601507`*^9, 
   3.543227533869466*^9, 3.543227758042472*^9, 3.5432281226477413`*^9, 
   3.543228249405427*^9, 3.5432283423029633`*^9, 3.543229229834753*^9, 
   3.543229565947241*^9, 3.543229707332026*^9, 3.543229972049404*^9, 
   3.543230671475618*^9, 3.5432311824502563`*^9, 3.543231468365082*^9, 
   3.543231657899173*^9, 3.543237270874639*^9, 3.543237678122531*^9, 
   3.543237727701024*^9, 3.543238010069254*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"newcoeffderiv1", "=", 
  RowBox[{"coeffs", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "4"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.542434654266938*^9, 3.542434655538323*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "4"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "A"}], " ", 
         SuperscriptBox["r", "2"]}], "-", "T"}]], " ", "F", " ", "r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["r", "2"]}], ")"}]}], ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "A"}], " ", 
         SuperscriptBox["r", "2"]}], "-", "T"}]], " ", "F", " ", "r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["r", "2"]}], ")"}]}], ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "A"}], " ", 
           SuperscriptBox["r", "2"]}], "-", "T"}]], " ", "F", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["r", "2"]}], ")"}]}], 
       RowBox[{"2", " ", "r"}]]}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "4"]}], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "A"}], " ", 
         SuperscriptBox["r", "2"]}], "-", "T"}]], " ", "F", " ", "r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["r", "2"]}], ")"}]}], ",", "0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "A"}], " ", 
          SuperscriptBox["r", "2"]}], "-", "T"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      RowBox[{"2", " ", "r"}]], ",", "0", ",", "0", ",", "1", ",", "0", ",", 
     "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["F", "2"], " ", 
       SuperscriptBox["r", "2"]}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "32"}], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"B", "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["F", "2"], " ", 
        SuperscriptBox["r", "2"]}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"8", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"B", "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
        SuperscriptBox["r", "2"]}], 
       RowBox[{
        RowBox[{"16", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
        RowBox[{
         SuperscriptBox["F", "2"], " ", 
         SuperscriptBox["r", "2"]}]}]]}], ",", 
     FractionBox[
      RowBox[{"8", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"B", "+", 
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], 
      RowBox[{
       RowBox[{"16", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"B", "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
       RowBox[{
        SuperscriptBox["F", "2"], " ", 
        SuperscriptBox["r", "2"]}]}]], ",", "0", ",", 
     FractionBox[
      RowBox[{
       RowBox[{"24", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"B", "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
       RowBox[{
        SuperscriptBox["F", "2"], " ", 
        SuperscriptBox["r", "2"]}]}], 
      RowBox[{
       RowBox[{"16", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"B", "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
       RowBox[{
        SuperscriptBox["F", "2"], " ", 
        SuperscriptBox["r", "2"]}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "F", " ", "r"}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
          RowBox[{
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "F", " ", 
        SuperscriptBox["r", "3"]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "+", 
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
          RowBox[{
           SuperscriptBox["F", "2"], " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}]]}], ",", "0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"A", " ", 
          SuperscriptBox["r", "2"]}], "+", "T"}]], " ", "r"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
         RowBox[{
          SuperscriptBox["F", "2"], " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}]], ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAuJnS/9nr0h55dgVIe55AUhvWB3lD6JnfV0TAqJDjqyL
ANE3Zs2PBdEHZfmSQHSjQUMaiHaaVpkPoh3npdeAaA6d2dNB9LZdU1eCzVs0
j+06kN5z1pYXRJvmi4uBaL+f+VIg2m5fnxKIVvE/IHMDZF9jxCoQnfr/+Nmb
QPq68qLrIPpblijzbSDdxncqUDsNqH/6xzAQLTRVOQNE2+3ePxFEK105vhZE
t3lF3gbRk2sNXoNoEcNz30D0Kak9qTpA+tz//f0gOqopZyGIfhTbfAhEc2l9
lNQF8W+fjwTRYm29tSCa4YzdVBAdY3g3yABIL1p2rBVEx+j96Abzr7iuB9EA
Asasmg==
  "]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"newcoeffderiv2", "=", 
  RowBox[{"coeffs", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "5"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.542434666403298*^9, 3.542434667770391*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAuK1S5tzV6S8cjxVJeF5AUiLLIr2B9GZ/9eGgOiUA+sj
QPS5OQtiQfQ2Gf4kEK1U2ZgGot9wVeeD6EDDzBoQPe/wnOkgWuXStJUgumH7
ArbrQHrNDnteEM2eIykGog05i6RAdJf+BCUQHfXsoMwNIP25JGoViC6ZdvLs
TSA9x3vJdRC9Q1Wc+TaQnnL3dKB22ivHa+8+h4HorkbVDBD95s+BiSC6rPfk
WhBtdSv6Nog2Xmr4GkTL9Jz/BqInGexN1QHSKjkH+0G0LEveQhC94XvLIRCd
ZvVJUhdIK/25HAmiPcMn1oLo1vuOU0G0mPO9IAMgPWX5iVYQvSHzVzeIts53
Xw+iAXKorIs=
  "]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"newcoeffnoderiv", "=", 
  RowBox[{"coeffs", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "6"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5424346780603*^9, 3.542434679178388*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "A"}], " ", 
        SuperscriptBox["r", "2"]}], "-", "T"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "8"}], "+", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"16", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"B", "+", "S"}]]}], "-", 
             RowBox[{
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "A"}], " ", 
                 SuperscriptBox["r", "2"]}], "-", "T"}]], " ", 
              SuperscriptBox["F", "2"], " ", 
              SuperscriptBox["r", "2"]}]}]]}]}], ")"}]}], "+", 
       RowBox[{"F", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}]}], ")"}]}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]], ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "A"}], " ", 
        SuperscriptBox["r", "2"]}], "-", "T"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "T"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "4"}], "+", 
          SqrtBox[
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"B", "+", "S"}]]}], "-", 
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "A"}], " ", 
                SuperscriptBox["r", "2"]}], "-", "T"}]], " ", 
             SuperscriptBox["F", "2"], " ", 
             SuperscriptBox["r", "2"]}]}]]}], ")"}]}], "-", 
       RowBox[{"F", " ", 
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "A"}], " ", 
       SuperscriptBox["r", "2"]}], "-", "T"}]], " ", "F", " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", 
      RowBox[{"A", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], ",", "F", ",", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", "r", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"16", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]]}], "-", 
        RowBox[{
         SuperscriptBox["F", "2"], " ", 
         SuperscriptBox["r", "2"]}]}], ")"}], " ", "rh"}]], 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "S"}], "-", "T"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "16"}], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"B", "+", 
          RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "F", " ", 
        SuperscriptBox["r", "2"]}], "-", 
       RowBox[{"16", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"B", "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", "S"}], "+", "T"}]], " ", "F", " ", 
        SuperscriptBox["r", "2"]}], "-", 
       RowBox[{"16", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", 
          RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
        SuperscriptBox["r", "2"]}], "-", 
       RowBox[{"32", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"B", "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", 
          RowBox[{"2", " ", "T"}]}]], " ", "F", " ", 
        SuperscriptBox["r", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", "S"], " ", 
        SuperscriptBox["F", "3"], " ", 
        SuperscriptBox["r", "4"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", "T"], " ", 
        SuperscriptBox["F", "3"], " ", 
        SuperscriptBox["r", "4"]}], "+", 
       RowBox[{"64", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"2", " ", "A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", 
          RowBox[{"3", " ", "T"}]}]], " ", 
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "+", 
       RowBox[{"128", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"B", "+", 
          RowBox[{"2", " ", "A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", 
          RowBox[{"3", " ", "T"}]}]], " ", 
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
       RowBox[{"8", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", "T"}]}]], " ", 
        SuperscriptBox["F", "2"], " ", 
        SuperscriptBox["r", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}], "-", 
       RowBox[{"32", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"B", "+", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"A", " ", 
              SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}], ")"}]}]}]], 
        " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", "S", "+", "T"}]], " ", 
        SuperscriptBox["F", "2"], " ", 
        SuperscriptBox["r", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"S", "+", "T"}]], " ", 
        SuperscriptBox["F", "2"], " ", 
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"7", " ", 
           SuperscriptBox["r", "4"]}]}], ")"}], " ", "rh"}], "-", 
       RowBox[{"32", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"B", "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"S", "+", "T"}], ")"}]}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "5"}], "+", "A"}], ")"}], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"A", " ", 
           SuperscriptBox["r", "4"]}]}], ")"}], " ", "rh"}]}], ")"}]}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQAmJNg095K1JeOSbWSXpeANIXVsT4g2iuNRtCQLTtkw0R
IPrIgYWxIHqSrkASiOYoaEoD0SlONfkg2uRqVg2I/tIzbzqI5rw3fSWI1rFb
xHYdSFecd+QF0XHfpMRANNuCYikQPe3MRCUQrbfgsMwNIJ0VELMKRBeZnzl7
E0jPclt2HUT7mEoy3wbSIqfPBmqnvXLs2vE1DETHfFfLANGp6ocmguh5L0+t
BdErSmNvg+iHs4xeg+jCZxe+gehZy/el6gDpgPpD/SC6a0L+QhCdtaztEIg2
PfJZUhdI+3pfiwTRf+5NqgXRNq+cpoLo1X4PgwyAdJDm6VYQzXf9dzeI3rvC
Yz2IBgBBXq1K
  "]]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffrrT", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffrr", ",", "T"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffrrA", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffrr", ",", "A"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffrrB", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffrr", ",", "B"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffrrF", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffrr", ",", "F"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"newcoeffrrS", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"D", "[", 
     RowBox[{"newcoeffrr", ",", "S"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5183297400699463`*^9, 3.5183297643107977`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffaaT", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffaa", ",", "T"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffaaA", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffaa", ",", "A"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffaaB", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffaa", ",", "B"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffaaF", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffaa", ",", "F"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"newcoeffaaS", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"D", "[", 
     RowBox[{"newcoeffaa", ",", "S"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.518329772304187*^9, 3.51832978387881*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffraT", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffra", ",", "T"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffraA", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffra", ",", "A"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffraB", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffra", ",", "B"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffraF", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffra", ",", "F"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"newcoeffraS", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"D", "[", 
     RowBox[{"newcoeffra", ",", "S"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5183297888002996`*^9, 3.518329800494968*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffderiv1T", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffderiv1", ",", "T"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffderiv1A", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffderiv1", ",", "A"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffderiv1B", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffderiv1", ",", "B"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffderiv1F", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffderiv1", ",", "F"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"newcoeffderiv1S", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"D", "[", 
     RowBox[{"newcoeffderiv1", ",", "S"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.518329626902732*^9, 3.518329652758658*^9}, {
  3.518329701795911*^9, 3.518329711829796*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffderiv2T", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffderiv2", ",", "T"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffderiv2A", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffderiv2", ",", "A"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffderiv2B", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffderiv2", ",", "B"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffderiv2F", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffderiv2", ",", "F"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"newcoeffderiv2S", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"D", "[", 
     RowBox[{"newcoeffderiv2", ",", "S"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.518329626902732*^9, 3.518329652758658*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffnoderivT", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffnoderiv", ",", "T"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffnoderivA", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffnoderiv", ",", "A"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffnoderivB", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffnoderiv", ",", "B"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newcoeffnoderivF", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"newcoeffnoderiv", ",", "F"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"newcoeffnoderivS", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"D", "[", 
     RowBox[{"newcoeffnoderiv", ",", "S"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5183294084056883`*^9, 3.5183294568601093`*^9}, {
  3.5183295077344646`*^9, 3.518329537734762*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"EqX", "=", 
   RowBox[{
    RowBox[{"newcoeffrr", ".", "dlistrr"}], "+", 
    RowBox[{"newcoeffaa", ".", "dlistaa"}], "+", 
    RowBox[{"newcoeffra", ".", "dlistra"}], "+", 
    RowBox[{"newcoeffderiv1", ".", "dlist"}], "+", 
    RowBox[{"newcoeffderiv2", ".", "dlist2"}], "+", "newcoeffnoderiv"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.518339740784905*^9, 3.518339769191586*^9}, {
   3.518340396834127*^9, 3.5183404128166924`*^9}, 3.518340475609181*^9, {
   3.542434748657091*^9, 3.542434751857176*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"newcoeffrr", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"newcoeffaa", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", "newcoeffra"}], "Input",
 CellChangeTimes->{{3.542435167345427*^9, 3.5424351703533077`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.542435170755563*^9, 3.542435176000436*^9}, 
   3.542516297146452*^9, 3.542516348703*^9, 3.542516389761208*^9, 
   3.542516421743861*^9, 3.542516461265211*^9, 3.5425164967217207`*^9, 
   3.542516532272767*^9, 3.542516604148576*^9, 3.5425167076931*^9, 
   3.542516882277425*^9, 3.542516928519596*^9, 3.542517068855761*^9, 
   3.542530101311637*^9, 3.542530154295855*^9, 3.542530225174115*^9, 
   3.542530259842001*^9, 3.542530324715086*^9, 3.5425323268792267`*^9, 
   3.5425334591127577`*^9, 3.542535793250162*^9, 3.5425358694466743`*^9, 
   3.5425382676930857`*^9, 3.5432271190485697`*^9, 3.54322720309652*^9, 
   3.543227536989602*^9, 3.5432278146702337`*^9, 3.543228251326727*^9, 
   3.5432283974889603`*^9, 3.543229233237349*^9, 3.543229569414188*^9, 
   3.5432297106107683`*^9, 3.543229975379259*^9, 3.5432306741092043`*^9, 
   3.543231185171878*^9, 3.5432314711089478`*^9, 3.543231660585148*^9, 
   3.543237274347554*^9, 3.543237730327239*^9, 3.543238012331531*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.542435170755563*^9, 3.542435176000436*^9}, 
   3.542516297146452*^9, 3.542516348703*^9, 3.542516389761208*^9, 
   3.542516421743861*^9, 3.542516461265211*^9, 3.5425164967217207`*^9, 
   3.542516532272767*^9, 3.542516604148576*^9, 3.5425167076931*^9, 
   3.542516882277425*^9, 3.542516928519596*^9, 3.542517068855761*^9, 
   3.542530101311637*^9, 3.542530154295855*^9, 3.542530225174115*^9, 
   3.542530259842001*^9, 3.542530324715086*^9, 3.5425323268792267`*^9, 
   3.5425334591127577`*^9, 3.542535793250162*^9, 3.5425358694466743`*^9, 
   3.5425382676930857`*^9, 3.5432271190485697`*^9, 3.54322720309652*^9, 
   3.543227536989602*^9, 3.5432278146702337`*^9, 3.543228251326727*^9, 
   3.5432283974889603`*^9, 3.543229233237349*^9, 3.543229569414188*^9, 
   3.5432297106107683`*^9, 3.543229975379259*^9, 3.5432306741092043`*^9, 
   3.543231185171878*^9, 3.5432314711089478`*^9, 3.543231660585148*^9, 
   3.543237274347554*^9, 3.543237730327239*^9, 3.543238012333324*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.542435170755563*^9, 3.542435176000436*^9}, 
   3.542516297146452*^9, 3.542516348703*^9, 3.542516389761208*^9, 
   3.542516421743861*^9, 3.542516461265211*^9, 3.5425164967217207`*^9, 
   3.542516532272767*^9, 3.542516604148576*^9, 3.5425167076931*^9, 
   3.542516882277425*^9, 3.542516928519596*^9, 3.542517068855761*^9, 
   3.542530101311637*^9, 3.542530154295855*^9, 3.542530225174115*^9, 
   3.542530259842001*^9, 3.542530324715086*^9, 3.5425323268792267`*^9, 
   3.5425334591127577`*^9, 3.542535793250162*^9, 3.5425358694466743`*^9, 
   3.5425382676930857`*^9, 3.5432271190485697`*^9, 3.54322720309652*^9, 
   3.543227536989602*^9, 3.5432278146702337`*^9, 3.543228251326727*^9, 
   3.5432283974889603`*^9, 3.543229233237349*^9, 3.543229569414188*^9, 
   3.5432297106107683`*^9, 3.543229975379259*^9, 3.5432306741092043`*^9, 
   3.543231185171878*^9, 3.5432314711089478`*^9, 3.543231660585148*^9, 
   3.543237274347554*^9, 3.543237730327239*^9, 3.5432380123346243`*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"coeffrr", "=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"coeffaa", "=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"coeffra", "=", "0"}], ";"}]}], "Input",
 CellChangeTimes->{{3.542516869787109*^9, 3.542516878639744*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"dlist", "[", 
   RowBox[{"[", 
    RowBox[{"1", ";;", "5"}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dEqdXr", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"Table", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"var", "=", 
        RowBox[{"dlist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"newcoeffderiv1", ".", 
         RowBox[{"D", "[", 
          RowBox[{"dlist", ",", "var"}], "]"}]}], "+", 
        RowBox[{"newcoeffderiv2", ".", 
         RowBox[{"D", "[", 
          RowBox[{"dlist2", ",", "var"}], "]"}]}]}]}], "\[IndentingNewLine]", 
      ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", "5"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{
  3.518333227103704*^9, {3.518333480232041*^9, 3.4604594574152613`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Tr", ",", "Ar", ",", "Br", ",", "Fr", ",", "Sr"}], "}"}]], "Output",
 CellChangeTimes->{{3.5183335027955914`*^9, 3.518333514685808*^9}, {
   3.518333611590702*^9, 3.460457355237709*^9}, 3.4604594586574097`*^9, {
   3.460471688422566*^9, 3.460471691951612*^9}, {3.460471791311347*^9, 
   3.460357079654398*^9}, 3.460367526557815*^9, 3.460373112970373*^9, 
   3.518956147358429*^9, 3.54243478464705*^9, 3.542435176036922*^9, 
   3.54251629721658*^9, 3.54251634878564*^9, 3.542516389795765*^9, 
   3.542516421797529*^9, 3.542516461303207*^9, 3.542516496759042*^9, 
   3.542516532309124*^9, 3.542516604183103*^9, 3.542516707757595*^9, 
   3.542516882347352*^9, 3.542516928582838*^9, 3.542517068884495*^9, 
   3.542530101600554*^9, 3.5425301543670063`*^9, 3.54253022536585*^9, 
   3.542530259920228*^9, 3.542530324785985*^9, 3.542532326941893*^9, 
   3.542533459177269*^9, 3.542535793326435*^9, 3.542535869511393*^9, 
   3.542538267763361*^9, 3.54322711911604*^9, 3.543227203148481*^9, 
   3.543227537083107*^9, 3.543227814727807*^9, 3.543228251375413*^9, 
   3.5432283975708923`*^9, 3.5432292333063173`*^9, 3.5432295694521503`*^9, 
   3.543229710675146*^9, 3.543229975438821*^9, 3.5432306741933317`*^9, 
   3.543231185206362*^9, 3.543231471193706*^9, 3.543231660666534*^9, 
   3.543237274424471*^9, 3.543237730363048*^9, 3.5432380124136467`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"dlist", "[", 
   RowBox[{"[", 
    RowBox[{"6", ";;", "10"}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dEqdXa", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"Table", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"var", "=", 
        RowBox[{"dlist", "[", 
         RowBox[{"[", "ii", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"newcoeffderiv1", ".", 
         RowBox[{"D", "[", 
          RowBox[{"dlist", ",", "var"}], "]"}]}], "+", 
        RowBox[{"newcoeffderiv2", ".", 
         RowBox[{"D", "[", 
          RowBox[{"dlist2", ",", "var"}], "]"}]}]}]}], "\[IndentingNewLine]", 
      ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "6", ",", "10"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.5183334883182907`*^9, 3.46045946456726*^9}, 
   3.460471775277463*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Ta", ",", "Aa", ",", "Ba", ",", "Fa", ",", "Sa"}], "}"}]], "Output",
 CellChangeTimes->{{3.518333510222447*^9, 3.518333515401684*^9}, {
   3.5183336121660957`*^9, 3.460457355286152*^9}, 3.460459465202958*^9, {
   3.460471791406118*^9, 3.460357079722847*^9}, 3.460367527423367*^9, 
   3.46037311302251*^9, 3.518956147424861*^9, 3.542434788939064*^9, 
   3.542435176100087*^9, 3.542516297316999*^9, 3.542516348896669*^9, 
   3.54251638983055*^9, 3.5425164218591833`*^9, 3.542516461338551*^9, 
   3.542516496789392*^9, 3.542516532344325*^9, 3.542516604222144*^9, 
   3.542516707822665*^9, 3.542516882379819*^9, 3.5425169286196423`*^9, 
   3.5425170689124937`*^9, 3.5425301017383823`*^9, 3.542530154395658*^9, 
   3.542530225584155*^9, 3.542530260022365*^9, 3.5425303248397207`*^9, 
   3.542532326995818*^9, 3.542533459235272*^9, 3.542535793381068*^9, 
   3.5425358695659513`*^9, 3.5425382678179827`*^9, 3.543227119155592*^9, 
   3.5432272032075768`*^9, 3.543227537140168*^9, 3.543227814765408*^9, 
   3.54322825143532*^9, 3.543228397601366*^9, 3.543229233367285*^9, 
   3.543229569503343*^9, 3.54322971070916*^9, 3.543229975476405*^9, 
   3.54323067424737*^9, 3.5432311852360992`*^9, 3.543231471229332*^9, 
   3.5432316606928377`*^9, 3.543237274481082*^9, 3.543237730393539*^9, 
   3.543238012438734*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dEqdT", "=", 
    RowBox[{
     RowBox[{"newcoeffrrT", ".", "dlistrr"}], "+", 
     RowBox[{"newcoeffaaT", ".", "dlistaa"}], "+", 
     RowBox[{"newcoeffraT", ".", "dlistra"}], "+", 
     RowBox[{"newcoeffderiv1T", ".", "dlist"}], "+", 
     RowBox[{"newcoeffderiv2T", ".", "dlist2"}], "+", "newcoeffnoderivT"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dEqdA", "=", 
    RowBox[{
     RowBox[{"newcoeffrrA", ".", "dlistrr"}], "+", 
     RowBox[{"newcoeffaaA", ".", "dlistaa"}], "+", 
     RowBox[{"newcoeffraA", ".", "dlistra"}], "+", 
     RowBox[{"newcoeffderiv1A", ".", "dlist"}], "+", 
     RowBox[{"newcoeffderiv2A", ".", "dlist2"}], "+", "newcoeffnoderivA"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dEqdB", "=", 
    RowBox[{
     RowBox[{"newcoeffrrB", ".", "dlistrr"}], "+", 
     RowBox[{"newcoeffaaB", ".", "dlistaa"}], "+", 
     RowBox[{"newcoeffraB", ".", "dlistra"}], "+", 
     RowBox[{"newcoeffderiv1B", ".", "dlist"}], "+", 
     RowBox[{"newcoeffderiv2B", ".", "dlist2"}], "+", "newcoeffnoderivB"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dEqdF", "=", 
    RowBox[{
     RowBox[{"newcoeffrrF", ".", "dlistrr"}], "+", 
     RowBox[{"newcoeffaaF", ".", "dlistaa"}], "+", 
     RowBox[{"newcoeffraF", ".", "dlistra"}], "+", 
     RowBox[{"newcoeffderiv1F", ".", "dlist"}], "+", 
     RowBox[{"newcoeffderiv2F", ".", "dlist2"}], "+", "newcoeffnoderivF"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dEqdS", "=", 
   RowBox[{
    RowBox[{"newcoeffrrS", ".", "dlistrr"}], "+", 
    RowBox[{"newcoeffaaS", ".", "dlistaa"}], "+", 
    RowBox[{"newcoeffraS", ".", "dlistra"}], "+", 
    RowBox[{"newcoeffderiv1S", ".", "dlist"}], "+", 
    RowBox[{"newcoeffderiv2S", ".", "dlist2"}], "+", "newcoeffnoderivS"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.518332672762429*^9, 3.518332703948852*^9}, {
  3.518332739919044*^9, 3.518332764548563*^9}, {3.518333064991692*^9, 
  3.518333065422656*^9}, {3.5183331259113207`*^9, 3.518333196997417*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", "dEqdXr", "]"}]], "Input",
 CellChangeTimes->{{3.5183337577506247`*^9, 3.518333767948503*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "5"}], "}"}]], "Output",
 CellChangeTimes->{{3.518333760834996*^9, 3.5183337683749638`*^9}, {
   3.5183347447146187`*^9, 3.46045735536334*^9}, {3.4604717915311832`*^9, 
   3.460357079819146*^9}, 3.460367529233252*^9, 3.460373113082575*^9, 
   3.518956147524436*^9, 3.542434801660528*^9, 3.54243517617052*^9, 
   3.542516297430407*^9, 3.54251634896082*^9, 3.542516389895276*^9, 
   3.54251642201338*^9, 3.5425164613992443`*^9, 3.5425164968573103`*^9, 
   3.5425165324056787`*^9, 3.5425166042797127`*^9, 3.5425167078831*^9, 
   3.542516882444251*^9, 3.542516928686721*^9, 3.542517068962821*^9, 
   3.542530101906518*^9, 3.542530154445816*^9, 3.5425302256478443`*^9, 
   3.5425302601104593`*^9, 3.54253032492974*^9, 3.542532327057564*^9, 
   3.542533459314301*^9, 3.542535793443853*^9, 3.5425358696291313`*^9, 
   3.542538267897251*^9, 3.543227119216072*^9, 3.543227203257403*^9, 
   3.543227537217*^9, 3.5432278148120537`*^9, 3.543228251497447*^9, 
   3.5432283976518183`*^9, 3.5432292334117937`*^9, 3.543229569550366*^9, 
   3.5432297107583523`*^9, 3.5432299755218*^9, 3.54323067432554*^9, 
   3.543231185282589*^9, 3.543231471289651*^9, 3.54323166074255*^9, 
   3.543237274557509*^9, 3.543237730437982*^9, 3.543238012490753*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Writeout", "Subsubtitle",
 CellChangeTimes->{{3.460389558463635*^9, 3.460389558896888*^9}, {
  3.460389609430746*^9, 3.4603896114348288`*^9}, {3.5183299969175587`*^9, 
  3.5183299978831244`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", "x_", "]"}], "\[Rule]", 
      RowBox[{"expl", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"r", "^", "2"}], "\[Rule]", "r2"}], ",", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "\[Rule]", "a2"}], ",", 
     RowBox[{"\[CapitalLambda]", "\[Rule]", "Lambda"}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.5183318727983723`*^9, 3.5183319048853703`*^9}, 
   3.5183326520968113`*^9, 3.5424348861195803`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetDirectory", "[", "\"\<~/Work/SpecTest7/\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.518335047259989*^9, 3.4604575247587214`*^9}, {
  3.518956058181387*^9, 3.518956058460064*^9}, {3.542000269369132*^9, 
  3.542000271111362*^9}, {3.542434829238646*^9, 3.542434829397575*^9}}],

Cell[BoxData["\<\"/Users/tobywiseman/Work/SpecTest7\"\>"], "Output",
 CellChangeTimes->{
  3.518335050661092*^9, 3.5183350829328203`*^9, {3.518340606630434*^9, 
   3.46045735603988*^9}, {3.4604575278540783`*^9, 3.460457531990162*^9}, 
   3.460459469128682*^9, 3.460471794549274*^9, {3.460476255038741*^9, 
   3.460357079884597*^9}, 3.460367534747438*^9, 3.4603731131518297`*^9, 
   3.5189561477075033`*^9, 3.542000272925541*^9, 3.5424348312369347`*^9, 
   3.542434887370686*^9, 3.5424352007697887`*^9, 3.542516297571138*^9, 
   3.54251634901048*^9, 3.54251638996205*^9, 3.542516422127781*^9, 
   3.542516461464931*^9, 3.5425164969228153`*^9, 3.542516532456366*^9, 
   3.5425166043480473`*^9, 3.542516707935233*^9, 3.542516884346484*^9, 
   3.542516931188425*^9, 3.542517069001357*^9, 3.542530101980385*^9, 
   3.5425301572273283`*^9, 3.542530261518136*^9, 3.542530325038323*^9, 
   3.5425323271370363`*^9, 3.542533459392127*^9, 3.542535793511261*^9, 
   3.542535869707488*^9, 3.5425382679923162`*^9, 3.543227161400237*^9, 
   3.543227203554367*^9, 3.543227537300289*^9, 3.5432278149582853`*^9, 
   3.543228251542356*^9, 3.543228397711084*^9, 3.54322923347416*^9, 
   3.543229569615254*^9, 3.543229710823258*^9, 3.5432299755711813`*^9, 
   3.5432306743662*^9, 3.543231185329549*^9, 3.543231471337224*^9, 
   3.543231660806027*^9, 3.5432372746231623`*^9, 3.5432377304860697`*^9, 
   3.543238012536297*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"string", "=", "\"\<\\n\\n\>\""}], ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stringtmp", "=", 
      RowBox[{"ToString", "[", 
       RowBox[{"CForm", "[", 
        RowBox[{
         RowBox[{"EqX", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], "//.", "repl"}], "]"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"stringtmp", "=", 
      RowBox[{"\"\<EqX[\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"ii", "-", "1"}], "]"}], "<>", "\"\<] = \>\"", "<>", 
       "stringtmp", "<>", "\"\< ;\\n\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"string", "=", 
      RowBox[{"string", "<>", "stringtmp"}]}], ";"}], "\[IndentingNewLine]", 
    ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", "5"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"string", "=", 
   RowBox[{"string", "<>", "\"\<\\n\>\""}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.518340465803512*^9, 3.518340491929764*^9}, {
  3.542434856567995*^9, 3.5424348572148647`*^9}, {3.542434917615266*^9, 
  3.542434918487101*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<Brn.c\>\"", ",", "string", ",", "\"\<Text\>\""}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.5183405071532507`*^9, 3.518340509007971*^9}, {
  3.5424348425905447`*^9, 3.542434842925764*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"string", "=", "\"\<\\n\\n\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.518333647605736*^9, 3.518333649032753*^9}, {
  3.518333725854959*^9, 3.5183337278449717`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"string", "=", 
    RowBox[{"string", "<>", "\"\<coeffrr = \>\"", "<>", 
     RowBox[{"ToString", "[", 
      RowBox[{"CForm", "[", 
       RowBox[{"coeffrr", "//.", "repl"}], "]"}], "]"}], "<>", 
     "\"\< ; \\n\>\""}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"string", "=", 
    RowBox[{"string", "<>", "\"\<coeffaa = \>\"", "<>", 
     RowBox[{"ToString", "[", 
      RowBox[{"CForm", "[", 
       RowBox[{"coeffaa", "//.", "repl"}], "]"}], "]"}], "<>", 
     "\"\< ; \\n\>\""}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"string", "=", 
   RowBox[{"string", "<>", "\"\<coeffra = \>\"", "<>", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{"coeffra", "//.", "repl"}], "]"}], "]"}], "<>", 
    "\"\< ; \\n\\n\>\""}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.518333650719015*^9, 3.460457184086981*^9}, {
  3.542516832939807*^9, 3.542516867217577*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stringtmp", "=", 
      RowBox[{"ToString", "[", 
       RowBox[{"CForm", "[", 
        RowBox[{
         RowBox[{"dEqdXr", "[", 
          RowBox[{"[", 
           RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "//.", "repl"}], "]"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"stringtmp", "=", 
      RowBox[{"\"\<dEqXr[\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"ii", "-", "1"}], "]"}], "<>", "\"\<][\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"jj", "-", "1"}], "]"}], "<>", "\"\<] = \>\"", "<>", 
       "stringtmp", "<>", "\"\< ;\\n\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"string", "=", 
      RowBox[{"string", "<>", "stringtmp"}]}], ";"}], "\[IndentingNewLine]", 
    ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"jj", ",", "1", ",", "5"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"string", "=", 
   RowBox[{"string", "<>", "\"\<\\n\>\""}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.518331809661859*^9, 3.518332028823266*^9}, {
  3.518332086975601*^9, 3.518332107464229*^9}, {3.518332211916683*^9, 
  3.5183322173586197`*^9}, {3.51833477610849*^9, 3.5183348288545113`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stringtmp", "=", 
      RowBox[{"ToString", "[", 
       RowBox[{"CForm", "[", 
        RowBox[{
         RowBox[{"dEqdXa", "[", 
          RowBox[{"[", 
           RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "//.", "repl"}], "]"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"stringtmp", "=", 
      RowBox[{"\"\<dEqXa[\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"ii", "-", "1"}], "]"}], "<>", "\"\<][\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"jj", "-", "1"}], "]"}], "<>", "\"\<] = \>\"", "<>", 
       "stringtmp", "<>", "\"\< ;\\n\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"string", "=", 
      RowBox[{"string", "<>", "stringtmp"}]}], ";"}], "\[IndentingNewLine]", 
    ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"jj", ",", "1", ",", "5"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"string", "=", 
   RowBox[{"string", "<>", "\"\<\\n\>\""}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.518334835075614*^9, 3.5183348365946302`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stringtmp", "=", 
      RowBox[{"ToString", "[", 
       RowBox[{"CForm", "[", 
        RowBox[{
         RowBox[{"dEqdT", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], "//.", "repl"}], "]"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"stringtmp", "=", 
      RowBox[{"\"\<dEqT[\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"ii", "-", "1"}], "]"}], "<>", "\"\<] = \>\"", "<>", 
       "stringtmp", "<>", "\"\< ;\\n\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"string", "=", 
      RowBox[{"string", "<>", "stringtmp"}]}], ";"}], "\[IndentingNewLine]", 
    ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", "5"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"string", "=", 
   RowBox[{"string", "<>", "\"\<\\n\>\""}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.518334872457034*^9, 3.518334909666383*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stringtmp", "=", 
      RowBox[{"ToString", "[", 
       RowBox[{"CForm", "[", 
        RowBox[{
         RowBox[{"dEqdA", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], "//.", "repl"}], "]"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"stringtmp", "=", 
      RowBox[{"\"\<dEqA[\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"ii", "-", "1"}], "]"}], "<>", "\"\<] = \>\"", "<>", 
       "stringtmp", "<>", "\"\< ;\\n\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"string", "=", 
      RowBox[{"string", "<>", "stringtmp"}]}], ";"}], "\[IndentingNewLine]", 
    ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", "5"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"string", "=", 
    RowBox[{"string", "<>", "\"\<\\n\>\""}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stringtmp", "=", 
      RowBox[{"ToString", "[", 
       RowBox[{"CForm", "[", 
        RowBox[{
         RowBox[{"dEqdB", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], "//.", "repl"}], "]"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"stringtmp", "=", 
      RowBox[{"\"\<dEqB[\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"ii", "-", "1"}], "]"}], "<>", "\"\<] = \>\"", "<>", 
       "stringtmp", "<>", "\"\< ;\\n\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"string", "=", 
      RowBox[{"string", "<>", "stringtmp"}]}], ";"}], "\[IndentingNewLine]", 
    ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", "5"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"string", "=", 
    RowBox[{"string", "<>", "\"\<\\n\>\""}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stringtmp", "=", 
      RowBox[{"ToString", "[", 
       RowBox[{"CForm", "[", 
        RowBox[{
         RowBox[{"dEqdF", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], "//.", "repl"}], "]"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"stringtmp", "=", 
      RowBox[{"\"\<dEqF[\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"ii", "-", "1"}], "]"}], "<>", "\"\<] = \>\"", "<>", 
       "stringtmp", "<>", "\"\< ;\\n\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"string", "=", 
      RowBox[{"string", "<>", "stringtmp"}]}], ";"}], "\[IndentingNewLine]", 
    ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", "5"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"string", "=", 
    RowBox[{"string", "<>", "\"\<\\n\>\""}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"stringtmp", "=", 
      RowBox[{"ToString", "[", 
       RowBox[{"CForm", "[", 
        RowBox[{
         RowBox[{"dEqdS", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], "//.", "repl"}], "]"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"stringtmp", "=", 
      RowBox[{"\"\<dEqS[\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"ii", "-", "1"}], "]"}], "<>", "\"\<] = \>\"", "<>", 
       "stringtmp", "<>", "\"\< ;\\n\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"string", "=", 
      RowBox[{"string", "<>", "stringtmp"}]}], ";"}], "\[IndentingNewLine]", 
    ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", "5"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"string", "=", 
   RowBox[{"string", "<>", "\"\<\\n\>\""}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.518334917457026*^9, 3.518334955500956*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<Lichbrn.c\>\"", ",", "string", ",", "\"\<Text\>\""}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.518335089624618*^9, 3.5183350904782057`*^9}, {
  3.5183351461684113`*^9, 3.518335183038703*^9}, {3.542434949055004*^9, 
  3.542434949613772*^9}}],

Cell[CellGroupData[{

Cell[BoxData["dlist"], "Input",
 CellChangeTimes->{{3.460459077169083*^9, 3.46045907770472*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Tr", ",", "Ar", ",", "Br", ",", "Fr", ",", "Sr", ",", "Ta", ",", "Aa", ",",
    "Ba", ",", "Fa", ",", "Sa"}], "}"}]], "Output",
 CellChangeTimes->{
  3.460459078258154*^9, 3.460459469773625*^9, {3.460471795168087*^9, 
   3.4603570809992857`*^9}, 3.460367535414236*^9, 3.4603731138951397`*^9, 
   3.518956148340263*^9, 3.542434952290597*^9, 3.542435201066937*^9, 
   3.5425162981610937`*^9, 3.5425163492957478`*^9, 3.542516390295899*^9, 
   3.542516422405699*^9, 3.542516461900502*^9, 3.542516497419458*^9, 
   3.54251653275725*^9, 3.542516604647121*^9, 3.542516708326668*^9, 
   3.542516884663422*^9, 3.542516931538761*^9, 3.5425170690980663`*^9, 
   3.542530102426352*^9, 3.542530184951477*^9, 3.542530267297059*^9, 
   3.542530325561935*^9, 3.5425323275030737`*^9, 3.542533459967124*^9, 
   3.542535793856935*^9, 3.542535870256658*^9, 3.542538268324422*^9, 
   3.543227161916617*^9, 3.5432272039323463`*^9, 3.543227537583954*^9, 
   3.543227815308153*^9, 3.543228252009791*^9, 3.543228398061005*^9, 
   3.543229233790842*^9, 3.5432295698965263`*^9, 3.54322971113794*^9, 
   3.543229975871396*^9, 3.543230674665799*^9, 3.5432311856150837`*^9, 
   3.543231471604127*^9, 3.543231661092606*^9, 3.543237275499701*^9, 
   3.543237730792997*^9, 3.543238012836413*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1276, 837},
WindowMargins->{{Automatic, 8}, {Automatic, 0}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "calcgeom"->{
  Cell[60771, 1500, 306, 9, 73, "Input",
   CellTags->"calcgeom"],
  Cell[61080, 1511, 293, 10, 73, "Input",
   CellTags->"calcgeom"],
  Cell[61376, 1523, 264, 9, 58, "Input",
   CellTags->"calcgeom"],
  Cell[61643, 1534, 264, 9, 58, "Input",
   CellTags->"calcgeom"],
  Cell[61910, 1545, 3551, 100, 139, "Input",
   CellTags->"calcgeom"],
  Cell[65464, 1647, 155, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[65826, 1659, 5599, 153, 178, "Input",
   CellTags->"calcgeom"],
  Cell[71428, 1814, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[71573, 1820, 1615, 48, 88, "Input",
   CellTags->"calcgeom"],
  Cell[73191, 1870, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[73336, 1876, 633, 22, 27, "Input",
   CellTags->"calcgeom"],
  Cell[73972, 1900, 1648, 51, 113, "Input",
   CellTags->"calcgeom"],
  Cell[75623, 1953, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[75768, 1959, 145, 4, 27, "Input",
   CellTags->"calcgeom"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"calcgeom", 604506, 15664}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 307, 4, 46, "Subtitle"],
Cell[CellGroupData[{
Cell[899, 30, 68, 1, 27, "Input"],
Cell[970, 33, 1180, 17, 20, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2187, 55, 111, 1, 26, "Subsubtitle"],
Cell[2301, 58, 95, 2, 27, "Input"],
Cell[CellGroupData[{
Cell[2421, 64, 279, 8, 58, "Input"],
Cell[2703, 74, 1303, 21, 70, "Output"],
Cell[4009, 97, 1703, 32, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5749, 134, 266, 9, 58, "Input"],
Cell[6018, 145, 1192, 17, 70, "Output"],
Cell[7213, 164, 1192, 17, 70, "Output"]
}, Open  ]],
Cell[8420, 184, 407, 13, 27, "Input"],
Cell[8830, 199, 37, 0, 27, "Input"],
Cell[CellGroupData[{
Cell[8892, 203, 257, 8, 58, "Input"],
Cell[9152, 213, 1294, 20, 70, "Output"],
Cell[10449, 235, 1206, 17, 70, "Output"]
}, Open  ]],
Cell[11670, 255, 2020, 62, 163, "Input"],
Cell[13693, 319, 26, 0, 27, "Input"],
Cell[13722, 321, 841, 25, 58, "Input"],
Cell[14566, 348, 1026, 31, 88, "Input"],
Cell[15595, 381, 227, 8, 86, "Text"],
Cell[15825, 391, 4015, 95, 313, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[19877, 491, 111, 3, 26, "Subsubtitle"],
Cell[19991, 496, 128, 4, 26, "Text"],
Cell[20122, 502, 6139, 139, 718, "Input"],
Cell[26264, 643, 68, 1, 26, "Text"],
Cell[26335, 646, 3727, 84, 523, "Input"],
Cell[30065, 732, 824, 18, 208, "Input"],
Cell[30892, 752, 4051, 89, 583, "Input"],
Cell[34946, 843, 99, 2, 27, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[35082, 850, 34, 0, 26, "Subsubtitle"],
Cell[CellGroupData[{
Cell[35141, 854, 511, 10, 49, "Input"],
Cell[35655, 866, 844, 12, 165, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36536, 883, 4458, 105, 227, "Input"],
Cell[40997, 990, 3542, 92, 105, "Output"],
Cell[44542, 1084, 594, 10, 27, "Output"],
Cell[45139, 1096, 501, 7, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45677, 1108, 28, 0, 27, "Input"],
Cell[45708, 1110, 4230, 102, 105, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49975, 1217, 28, 0, 27, "Input"],
Cell[50006, 1219, 8067, 208, 218, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[58110, 1432, 119, 3, 27, "Input"],
Cell[58232, 1437, 2455, 55, 40, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[60736, 1498, 32, 0, 26, "Subsubtitle"],
Cell[60771, 1500, 306, 9, 73, "Input",
 CellTags->"calcgeom"],
Cell[61080, 1511, 293, 10, 73, "Input",
 CellTags->"calcgeom"],
Cell[61376, 1523, 264, 9, 58, "Input",
 CellTags->"calcgeom"],
Cell[61643, 1534, 264, 9, 58, "Input",
 CellTags->"calcgeom"],
Cell[61910, 1545, 3551, 100, 139, "Input",
 CellTags->"calcgeom"],
Cell[65464, 1647, 155, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[65622, 1653, 201, 4, 27, "Input"],
Cell[65826, 1659, 5599, 153, 178, "Input",
 CellTags->"calcgeom"],
Cell[71428, 1814, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[71573, 1820, 1615, 48, 88, "Input",
 CellTags->"calcgeom"],
Cell[73191, 1870, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[73336, 1876, 633, 22, 27, "Input",
 CellTags->"calcgeom"],
Cell[73972, 1900, 1648, 51, 113, "Input",
 CellTags->"calcgeom"],
Cell[75623, 1953, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[75768, 1959, 145, 4, 27, "Input",
 CellTags->"calcgeom"]
}, Closed]],
Cell[CellGroupData[{
Cell[75950, 1968, 41, 0, 26, "Subsubtitle"],
Cell[CellGroupData[{
Cell[76016, 1972, 97, 1, 27, "Input"],
Cell[76116, 1975, 1031, 17, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[77184, 1997, 327, 9, 27, "Input"],
Cell[77514, 2008, 1210, 21, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[78761, 2034, 329, 9, 27, "Input"],
Cell[79093, 2045, 1278, 22, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[80408, 2072, 462, 12, 27, "Input"],
Cell[80873, 2086, 1815, 37, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[82725, 2128, 265, 7, 27, "Input"],
Cell[82993, 2137, 1616, 32, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[84646, 2174, 478, 13, 27, "Input"],
Cell[85127, 2189, 2187, 49, 56, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[87351, 2243, 1309, 32, 49, "Input"],
Cell[88663, 2277, 4361, 105, 90, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[93061, 2387, 334, 9, 27, "Input"],
Cell[93398, 2398, 902, 13, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[94337, 2416, 308, 9, 27, "Input"],
Cell[94648, 2427, 884, 13, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[95569, 2445, 720, 21, 88, "Input"],
Cell[96292, 2468, 4210, 104, 169, "Output"],
Cell[100505, 2574, 4435, 111, 163, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[104977, 2690, 1065, 34, 88, "Input"],
Cell[106045, 2726, 1052, 18, 27, "Output"],
Cell[107100, 2746, 1787, 39, 57, "Output"],
Cell[108890, 2787, 1787, 39, 57, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[110714, 2831, 627, 18, 27, "Input"],
Cell[111344, 2851, 43880, 1074, 790, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[155261, 3930, 412, 12, 27, "Input"],
Cell[155676, 3944, 18942, 476, 325, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[174655, 4425, 1172, 35, 33, "Input"],
Cell[175830, 4462, 11967, 322, 234, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[187834, 4789, 369, 9, 27, "Input"],
Cell[188206, 4800, 1549, 28, 27, "Output"]
}, Open  ]],
Cell[189770, 4831, 2123, 70, 105, "Input"],
Cell[191896, 4903, 281, 6, 27, "Input"],
Cell[192180, 4911, 1251, 34, 112, "Input"],
Cell[193434, 4947, 1182, 29, 148, "Input"],
Cell[CellGroupData[{
Cell[194641, 4980, 399, 8, 27, "Input"],
Cell[195043, 4990, 1157, 20, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[196237, 5015, 353, 8, 27, "Input"],
Cell[196593, 5025, 934, 13, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[197564, 5043, 393, 9, 27, "Input"],
Cell[197960, 5054, 1063, 19, 47, "Output"]
}, Open  ]],
Cell[199038, 5076, 306, 6, 27, "Input"],
Cell[199347, 5084, 7842, 246, 89, "Input"],
Cell[207192, 5332, 1251, 34, 112, "Input"],
Cell[CellGroupData[{
Cell[208468, 5370, 693, 17, 27, "Input"],
Cell[209164, 5389, 1888, 56, 74, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[211089, 5450, 585, 16, 27, "Input"],
Cell[211677, 5468, 1858, 56, 74, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[213572, 5529, 587, 16, 27, "Input"],
Cell[214162, 5547, 1242, 36, 55, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[215441, 5588, 257, 7, 27, "Input"],
Cell[215701, 5597, 220, 4, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[215958, 5606, 283, 8, 27, "Input"],
Cell[216244, 5616, 93, 2, 30, "Output"]
}, Open  ]],
Cell[216352, 5621, 49410, 1101, 545, "Input"],
Cell[CellGroupData[{
Cell[265787, 6726, 338, 8, 27, "Input"],
Cell[266128, 6736, 14618, 387, 233, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[280783, 7128, 193, 5, 27, "Input"],
Cell[280979, 7135, 6865, 201, 127, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[287881, 7341, 194, 5, 27, "Input"],
Cell[288078, 7348, 6266, 181, 119, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[294381, 7534, 506, 15, 27, "Input"],
Cell[294890, 7551, 27097, 723, 319, "Output"]
}, Open  ]],
Cell[322002, 8277, 981, 26, 118, "Input"],
Cell[322986, 8305, 387, 11, 27, "Input"],
Cell[323376, 8318, 343, 8, 27, "Input"],
Cell[323722, 8328, 779, 16, 27, "Input"],
Cell[324504, 8346, 400, 11, 27, "Input"],
Cell[324907, 8359, 674, 19, 27, "Input"],
Cell[325584, 8380, 560, 16, 27, "Input"],
Cell[326147, 8398, 2453, 57, 298, "Input"],
Cell[CellGroupData[{
Cell[328625, 8459, 184, 4, 27, "Input"],
Cell[328812, 8465, 859, 16, 26, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[329708, 8486, 182, 4, 27, "Input"],
Cell[329893, 8492, 755, 13, 26, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[330685, 8510, 184, 4, 27, "Input"],
Cell[330872, 8516, 806, 15, 26, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[331715, 8536, 183, 4, 27, "Input"],
Cell[331901, 8542, 490, 9, 20, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[332428, 8556, 183, 4, 27, "Input"],
Cell[332614, 8562, 349, 7, 20, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[333000, 8574, 325, 6, 27, "Input"],
Cell[333328, 8582, 1179, 23, 46, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[334544, 8610, 175, 4, 27, "Input"],
Cell[334722, 8616, 967, 18, 46, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[335726, 8639, 176, 4, 27, "Input"],
Cell[335905, 8645, 1094, 20, 46, "Print"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[337048, 8671, 93, 1, 26, "Subsubtitle"],
Cell[337144, 8674, 935, 26, 118, "Input"],
Cell[338082, 8702, 2257, 60, 53, "Input"],
Cell[340342, 8764, 3149, 80, 115, "Input"],
Cell[343494, 8846, 3093, 78, 115, "Input"],
Cell[346590, 8926, 2982, 78, 92, "Input"],
Cell[349575, 9006, 1358, 27, 43, "Input"],
Cell[350936, 9035, 1302, 26, 53, "Input"],
Cell[352241, 9063, 10588, 280, 158, "Input"],
Cell[362832, 9345, 11506, 307, 216, "Input"],
Cell[374341, 9654, 165920, 4337, 2219, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[540298, 13996, 257, 3, 26, "Subsubtitle"],
Cell[540558, 14001, 312, 8, 27, "Input"],
Cell[540873, 14011, 261, 7, 27, "Input"],
Cell[541137, 14020, 314, 8, 27, "Input"],
Cell[541454, 14030, 926, 17, 27, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[542417, 14052, 98, 1, 26, "Subsubtitle"],
Cell[CellGroupData[{
Cell[542540, 14057, 580, 17, 88, "Input"],
Cell[543123, 14076, 1545, 28, 70, "Output"],
Cell[544671, 14106, 1545, 28, 70, "Output"],
Cell[546219, 14136, 1545, 28, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[547801, 14169, 212, 5, 27, "Input"],
Cell[548016, 14176, 7347, 217, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[555400, 14398, 212, 5, 27, "Input"],
Cell[555615, 14405, 3658, 62, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[559310, 14472, 211, 5, 27, "Input"],
Cell[559524, 14479, 9009, 262, 70, "Output"]
}, Open  ]],
Cell[568548, 14744, 1138, 34, 148, "Input"],
Cell[569689, 14780, 1133, 34, 148, "Input"],
Cell[570825, 14816, 1136, 34, 148, "Input"],
Cell[571964, 14852, 1223, 35, 148, "Input"],
Cell[573190, 14889, 1174, 34, 148, "Input"],
Cell[574367, 14925, 1239, 35, 148, "Input"],
Cell[575609, 14962, 545, 12, 27, "Input"],
Cell[CellGroupData[{
Cell[576179, 14978, 253, 4, 88, "Input"],
Cell[576435, 14984, 1493, 27, 70, "Output"],
Cell[577931, 15013, 1493, 27, 70, "Output"],
Cell[579427, 15042, 1495, 27, 70, "Output"]
}, Open  ]],
Cell[580937, 15072, 369, 11, 88, "Input"],
Cell[CellGroupData[{
Cell[581331, 15087, 940, 27, 103, "Input"],
Cell[582274, 15116, 1381, 20, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[583692, 15141, 942, 27, 103, "Input"],
Cell[584637, 15170, 1341, 20, 70, "Output"]
}, Open  ]],
Cell[585993, 15193, 2209, 52, 148, "Input"],
Cell[CellGroupData[{
Cell[588227, 15249, 136, 2, 27, "Input"],
Cell[588366, 15253, 1277, 19, 70, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[589692, 15278, 201, 3, 26, "Subsubtitle"],
Cell[589896, 15283, 538, 15, 27, "Input"],
Cell[CellGroupData[{
Cell[590459, 15302, 301, 4, 27, "Input"],
Cell[590763, 15308, 1403, 20, 27, "Output"]
}, Open  ]],
Cell[592181, 15331, 85, 2, 27, "Input"],
Cell[592269, 15335, 1104, 28, 118, "Input"],
Cell[593376, 15365, 261, 6, 27, "Input"],
Cell[593640, 15373, 202, 4, 27, "Input"],
Cell[593845, 15379, 1019, 27, 88, "Input"],
Cell[594867, 15408, 1364, 33, 118, "Input"],
Cell[596234, 15443, 1219, 31, 118, "Input"],
Cell[597456, 15476, 1007, 26, 118, "Input"],
Cell[598466, 15504, 3950, 107, 478, "Input"],
Cell[602419, 15613, 314, 7, 27, "Input"],
Cell[CellGroupData[{
Cell[602758, 15624, 96, 1, 27, "Input"],
Cell[602857, 15627, 1305, 21, 27, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
