(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    700255,      18079]
NotebookOptionsPosition[    680533,      17454]
NotebookOutlinePosition[    682870,      17530]
CellTagsIndexPosition[    682796,      17525]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
RS **6d** - Isreal conditions - Ansatz 1\
\>", "Subtitle",
 CellChangeTimes->{{3.408796983010241*^9, 3.408796989128707*^9}, {
  3.415942197687789*^9, 3.415942199707787*^9}, {3.428318203595373*^9, 
  3.4283182110266533`*^9}, {3.4318556687961187`*^9, 3.431855668994246*^9}, {
  3.48266555323216*^9, 3.482665557150345*^9}, {3.54247053787271*^9, 
  3.5424705411027308`*^9}, {3.543558985731655*^9, 3.5435589875998583`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", "\"\<hmm\>\"", "]"}]], "Input"],

Cell[BoxData["\<\"hmm\"\>"], "Print",
 CellChangeTimes->{
  3.426737013194791*^9, 3.4283151938180532`*^9, 3.428315553265912*^9, 
   3.428316879668502*^9, 3.4284038946466827`*^9, 3.4318556782327433`*^9, 
   3.431863726574562*^9, 3.482645295101799*^9, 3.4826453579432173`*^9, 
   3.482645464070413*^9, 3.4826465354634857`*^9, 3.482646576278145*^9, 
   3.4826543007333717`*^9, 3.482660738510792*^9, {3.482665665778748*^9, 
   3.460345345005185*^9}, 3.482732899833189*^9, 3.4832683038376827`*^9, 
   3.483274829836521*^9, 3.483355830278619*^9, 3.495174822655376*^9, 
   3.497953162440522*^9, 3.497953487871752*^9, 3.501484207182074*^9, {
   3.501486522498592*^9, 3.4603905367302732`*^9}, 3.460429409024069*^9, 
   3.460429476669972*^9, {3.503999598758216*^9, 3.460343345971778*^9}, 
   3.460397493489051*^9, 3.4603981921980867`*^9, {3.460625262680915*^9, 
   3.4603659342380543`*^9}, 3.46037335064213*^9, 3.54143569407403*^9, 
   3.5414410133826447`*^9, 3.541999845932349*^9, 3.542001525695931*^9, 
   3.542470829342547*^9, 3.5435582916327868`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRSetup2.nb - modified", "Subsubtitle",
 CellChangeTimes->{{3.478330969800351*^9, 3.478330971159855*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Latest", " ", "Version"}], " ", "*)"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"{", 
    RowBox[{
    "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
     "gzz"}], "}"}]}], "\n"}], "\n", 
 RowBox[{"Gd", "=", 
  RowBox[{"DiagonalMatrix", "[", "metric", "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
   "gzz"}], "}"}]], "Output",
 CellChangeTimes->{
  3.466315297140045*^9, 3.478330988195435*^9, 3.478416452606082*^9, 
   3.478847548608172*^9, {3.478929911283174*^9, 3.4603055225664177`*^9}, 
   3.4604526704446363`*^9, 3.482471496252235*^9, 3.482471611406439*^9, 
   3.482645358035461*^9, 3.482645464253499*^9, 3.482646535695998*^9, 
   3.4826465764442587`*^9, 3.482654300949271*^9, 3.4826607387014923`*^9, {
   3.482665666027986*^9, 3.460345345197377*^9}, 3.482732900019106*^9, 
   3.4832683040504923`*^9, 3.483274830169456*^9, 3.4833558305609293`*^9, 
   3.495174822972555*^9, 3.497953162624474*^9, 3.49795348812144*^9, 
   3.501484207532778*^9, {3.501486522848439*^9, 3.460390536999611*^9}, 
   3.460429409196727*^9, 3.460429476861683*^9, {3.503999599120948*^9, 
   3.460343346107972*^9}, 3.460397493671178*^9, 3.460398192423341*^9, {
   3.460625263005105*^9, 3.460365934424306*^9}, 3.4603733508385*^9, 
   3.541435694240285*^9, 3.541441013451647*^9, 3.541999846000835*^9, 
   3.542001525764724*^9, 3.5424708295924597`*^9, 3.5435582917930317`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"gtt", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "grr", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "g\[Theta]\[Theta]", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "g\[Phi]\[Phi]", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "gzz"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.466315297140045*^9, 3.478330988195435*^9, 3.478416452606082*^9, 
   3.478847548608172*^9, {3.478929911283174*^9, 3.4603055225664177`*^9}, 
   3.4604526704446363`*^9, 3.482471496252235*^9, 3.482471611406439*^9, 
   3.482645358035461*^9, 3.482645464253499*^9, 3.482646535695998*^9, 
   3.4826465764442587`*^9, 3.482654300949271*^9, 3.4826607387014923`*^9, {
   3.482665666027986*^9, 3.460345345197377*^9}, 3.482732900019106*^9, 
   3.4832683040504923`*^9, 3.483274830169456*^9, 3.4833558305609293`*^9, 
   3.495174822972555*^9, 3.497953162624474*^9, 3.49795348812144*^9, 
   3.501484207532778*^9, {3.501486522848439*^9, 3.460390536999611*^9}, 
   3.460429409196727*^9, 3.460429476861683*^9, {3.503999599120948*^9, 
   3.460343346107972*^9}, 3.460397493671178*^9, 3.460398192423341*^9, {
   3.460625263005105*^9, 3.460365934424306*^9}, 3.4603733508385*^9, 
   3.541435694240285*^9, 3.541441013451647*^9, 3.541999846000835*^9, 
   3.542001525764724*^9, 3.5424708295924597`*^9, 3.543558291794425*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Gd", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", "grt"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Gd", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "1"}], "]"}], "]"}], "=", "grt"}]}], "Input"],

Cell[BoxData["grt"], "Output",
 CellChangeTimes->{
  3.466315297179295*^9, 3.478330988245845*^9, 3.4784164526461287`*^9, 
   3.478847548682302*^9, {3.4789299113562927`*^9, 3.46030552262118*^9}, 
   3.460452670511849*^9, 3.4824714962922277`*^9, 3.48247161146406*^9, 
   3.482645358070859*^9, 3.482645464319662*^9, 3.4826465357796783`*^9, 
   3.482646576527176*^9, 3.482654301033062*^9, 3.4826607387838*^9, {
   3.482665666129422*^9, 3.4603453452845716`*^9}, 3.482732900099493*^9, 
   3.483268304133985*^9, 3.483274830260374*^9, 3.4833558306436863`*^9, 
   3.495174823024794*^9, 3.497953162683668*^9, 3.497953488221377*^9, 
   3.5014842076813087`*^9, {3.501486522964305*^9, 3.460390537094163*^9}, 
   3.4604294092484293`*^9, 3.460429476963196*^9, {3.503999599186805*^9, 
   3.460343346168922*^9}, 3.4603974937499847`*^9, 3.460398192516327*^9, {
   3.460625263064344*^9, 3.46036593446181*^9}, 3.4603733508933983`*^9, 
   3.54143569430737*^9, 3.541441013666492*^9, 3.54199984608576*^9, 
   3.542001525794325*^9, 3.542470829642406*^9, 3.543558291827272*^9}],

Cell[BoxData["grt"], "Output",
 CellChangeTimes->{
  3.466315297179295*^9, 3.478330988245845*^9, 3.4784164526461287`*^9, 
   3.478847548682302*^9, {3.4789299113562927`*^9, 3.46030552262118*^9}, 
   3.460452670511849*^9, 3.4824714962922277`*^9, 3.48247161146406*^9, 
   3.482645358070859*^9, 3.482645464319662*^9, 3.4826465357796783`*^9, 
   3.482646576527176*^9, 3.482654301033062*^9, 3.4826607387838*^9, {
   3.482665666129422*^9, 3.4603453452845716`*^9}, 3.482732900099493*^9, 
   3.483268304133985*^9, 3.483274830260374*^9, 3.4833558306436863`*^9, 
   3.495174823024794*^9, 3.497953162683668*^9, 3.497953488221377*^9, 
   3.5014842076813087`*^9, {3.501486522964305*^9, 3.460390537094163*^9}, 
   3.4604294092484293`*^9, 3.460429476963196*^9, {3.503999599186805*^9, 
   3.460343346168922*^9}, 3.4603974937499847`*^9, 3.460398192516327*^9, {
   3.460625263064344*^9, 3.46036593446181*^9}, 3.4603733508933983`*^9, 
   3.54143569430737*^9, 3.541441013666492*^9, 3.54199984608576*^9, 
   3.542001525794325*^9, 3.542470829642406*^9, 3.543558291828539*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"BuildMetric", ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Gu", "=", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{"Inverse", "[", "Gd", "]"}], "]"}]}], ";", 
    RowBox[{"G", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u", ",", "d"}], "}"}], ",", 
       RowBox[{"IdentityMatrix", "[", "Nind", "]"}]}], "}"}]}], ";"}], 
   ")"}]}]], "Input"],

Cell[BoxData["BuildMetric"], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
    "}"}]}], "\n"}], "\n", 
 RowBox[{"Nind", "=", 
  RowBox[{"Length", "[", "ind", "]"}]}]}], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.466315297712317*^9, 3.4783309883547897`*^9, 3.4784164529457827`*^9, 
   3.478847549205242*^9, {3.478929911603554*^9, 3.4603055237326612`*^9}, 
   3.460452671089712*^9, 3.4824714964364767`*^9, 3.482471611595883*^9, 
   3.482645358224825*^9, 3.482645464457198*^9, 3.4826465359168453`*^9, 
   3.482646576664466*^9, 3.482654301186666*^9, 3.4826607389382544`*^9, {
   3.482665666280961*^9, 3.460345345463394*^9}, 3.482732900239039*^9, 
   3.483268305021481*^9, 3.483274830556378*^9, 3.4833558308940907`*^9, 
   3.4951748231727*^9, 3.497953163012686*^9, 3.4979534884757023`*^9, 
   3.501484207899385*^9, {3.501486523197439*^9, 3.4603905372989473`*^9}, 
   3.460429409494135*^9, 3.460429477939843*^9, {3.503999599454533*^9, 
   3.4603433469419613`*^9}, 3.460397493927754*^9, 3.460398192702785*^9, {
   3.460625263273443*^9, 3.460365934618382*^9}, 3.4603733510389843`*^9, 
   3.5414356944615593`*^9, 3.541441013783738*^9, 3.541999846405352*^9, 
   3.5420015260770597`*^9, 3.5424708297817163`*^9, 3.543558291925331*^9}],

Cell[BoxData["5"], "Output",
 CellChangeTimes->{
  3.466315297712317*^9, 3.4783309883547897`*^9, 3.4784164529457827`*^9, 
   3.478847549205242*^9, {3.478929911603554*^9, 3.4603055237326612`*^9}, 
   3.460452671089712*^9, 3.4824714964364767`*^9, 3.482471611595883*^9, 
   3.482645358224825*^9, 3.482645464457198*^9, 3.4826465359168453`*^9, 
   3.482646576664466*^9, 3.482654301186666*^9, 3.4826607389382544`*^9, {
   3.482665666280961*^9, 3.460345345463394*^9}, 3.482732900239039*^9, 
   3.483268305021481*^9, 3.483274830556378*^9, 3.4833558308940907`*^9, 
   3.4951748231727*^9, 3.497953163012686*^9, 3.4979534884757023`*^9, 
   3.501484207899385*^9, {3.501486523197439*^9, 3.4603905372989473`*^9}, 
   3.460429409494135*^9, 3.460429477939843*^9, {3.503999599454533*^9, 
   3.4603433469419613`*^9}, 3.460397493927754*^9, 3.460398192702785*^9, {
   3.460625263273443*^9, 3.460365934618382*^9}, 3.4603733510389843`*^9, 
   3.5414356944615593`*^9, 3.541441013783738*^9, 3.541999846405352*^9, 
   3.5420015260770597`*^9, 3.5424708297817163`*^9, 3.54355829192659*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"getind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "i1", "]"}], ",", "i1", ",", 
      RowBox[{
       RowBox[{"Position", "[", 
        RowBox[{"ind", ",", "i1"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"lstind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"lsttmp2", "=", 
      RowBox[{"{", "}"}]}], ";", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"AppendTo", "[", 
        RowBox[{"lsttmp2", ",", 
         RowBox[{"getind", "[", 
          RowBox[{"i1", "[", 
           RowBox[{"[", 
            RowBox[{"lsttmp1", ",", "1"}], "]"}], "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"lsttmp1", ",", "1", ",", 
         RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
     "lsttmp2"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"up", "[", 
   RowBox[{"i1_", ",", "i2_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"lsttmp2", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"AppendTo", "[", 
       RowBox[{"lsttmp2", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"i1", "[", 
            RowBox[{"[", 
             RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "=!=", 
           RowBox[{"i2", "[", 
            RowBox[{"[", "lsttmp1", "]"}], "]"}]}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"i1", "[", 
              RowBox[{"[", 
               RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "===", "d"}], ",",
             "d", ",", "u"}], "]"}], ",", "0"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"lsttmp1", ",", "1", ",", 
        RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
    "lsttmp2"}], ")"}]}]}], "Input",
 Editable->False],

Cell[BoxData[""], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"t1_", ",", "dim_", ",", "indpos_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"MTtmp1", "=", "0"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Length", "[", "indpos", "]"}], "=!=", "dim"}], ",", 
      RowBox[{"Print", "[", "\"\<Error in index position\>\"", "]"}]}], "]"}],
     ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"MTtmp1", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"MTtmp1", ",", 
         RowBox[{"{", 
          RowBox[{"MTtmp3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"MTtmp2", ",", "1", ",", "dim"}], "}"}]}], "]"}], ";", 
    RowBox[{"t1", "=", 
     RowBox[{"{", 
      RowBox[{"indpos", ",", "MTtmp1"}], "}"}]}]}], ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ST", "[", 
    RowBox[{"t1_", ",", "tind_", ",", "val_"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"STtmp1", "=", "t1"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"up", "[", 
         RowBox[{"tind", ",", 
          RowBox[{"t1", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "=!=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"Length", "[", "tind", "]"}], "}"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Print", "[", "\"\<Error in Index Assignment!!\>\"", "]"}], 
        ";"}]}], "]"}], ";", 
     RowBox[{
      RowBox[{"STtmp1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "=", 
      RowBox[{"ReplacePart", "[", 
       RowBox[{
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", "val", ",", 
        RowBox[{"lstind", "[", "tind", "]"}]}], "]"}]}], ";", "STtmp1"}], 
    ")"}]}], "\n"}]], "Input",
 Editable->False],

Cell["\<\


Edited the expression below as 7.0 seems to complain about Sum[x] whereas 6.0 \
would just return x (ie. if there is no sum index!)

\
\>", "Text",
 CellChangeTimes->{{3.465736646430695*^9, 3.4657366879261303`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GT", "[", 
   RowBox[{"t1_", ",", "tind_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"GTtmp2", "=", 
     RowBox[{"up", "[", 
      RowBox[{"tind", ",", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
    RowBox[{"GTtmp3", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp4", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp5", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp6", "=", "t1"}], ";", "\n", "\t\t", 
    RowBox[{"Do", "[", "\n", "\t\t\t", 
     RowBox[{
      RowBox[{
       RowBox[{"Switch", "[", 
        RowBox[{
         RowBox[{"GTtmp2", "[", 
          RowBox[{"[", "GTtmp1", "]"}], "]"}], ",", "\n", "\t\t\t\t", "0", 
         ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}]}]}],
            ";"}], ")"}], ",", "\n", "\t\t\t\t", "u", ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gu[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}]}], ")"}], ",", "\n", "\t\t\t\t", "d", ",",
          "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gd[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}], ";"}], ")"}]}], "]"}], ";"}], "\n", 
      "\t\t\t", ",", 
      RowBox[{"{", 
       RowBox[{"GTtmp1", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"t1", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"GTtmp4", "===", "\"\<\>\""}], "&&", 
       RowBox[{"GTtmp5", "===", "\"\<\>\""}]}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{"\"\<GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\""}], 
       "]"}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{
       "\"\<Sum[GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\"", "<>", 
        "GTtmp4", "<>", "GTtmp5", "<>", "\"\<]\>\""}], "]"}]}], "]"}]}], 
   ")"}]}]], "Input",
 Editable->False,
 CellChangeTimes->{{3.465736640865263*^9, 3.4657366432796392`*^9}, {
  3.465736699767317*^9, 3.4657367470041943`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Trace, Outer Product and Covariant Derivative! - GREinstein.nb\
\>", "Subsubtitle",
 Editable->False],

Cell["\<\
Syntax:   trT[tensor,{{1,4},{2,3}}]   -  ie. contract 1 and 4 plus 2 and 3 \
positions\
\>", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"trT", "[", 
   RowBox[{"t1_", ",", "lst_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "tracetmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"dimt1", "===", "2"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tracetmp", "=", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"GT", "[", 
           RowBox[{"tmpt1", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"s1", ",", "d"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"s1", ",", "u"}], "}"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"s1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ";"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"MT", "[", 
        RowBox[{"tracetmp", ",", 
         RowBox[{"dimt1", "-", 
          RowBox[{"2", 
           RowBox[{"Length", "[", "lst", "]"}]}]}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{"d", ",", 
           RowBox[{"{", 
            RowBox[{"ii", ",", "1", ",", 
             RowBox[{"dimt1", "-", 
              RowBox[{"2", 
               RowBox[{"Length", "[", "lst", "]"}]}]}]}], "}"}]}], "]"}]}], 
        "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"{", "}"}], "===", 
             RowBox[{"Position", "[", 
              RowBox[{"lst", ",", "indno"}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"tmpstring1", "=", 
              RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,d},\>\""}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"tmpstring3", "=", 
              RowBox[{"tmpstring3", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,1,Nind},\>\""}]}], ";"}]}], "\[IndentingNewLine]", "]"}],
           ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}],
           ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\n", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"tmpstring4", "=", 
           RowBox[{"tmpstring4", "<>", "\"\<{s\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", 
            "\"\<,1,Nind},\>\""}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "1"}], "]"}], "]"}], "]"}]}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "2"}], "]"}], "]"}], "]"}], "<>", 
               "\"\<,d}\>\""}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,u}\>\""}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", 
           RowBox[{"Length", "[", "lst", "]"}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpeval", "=", 
        RowBox[{"\"\<Do[tracetmp=ST[tracetmp,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring1", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},Sum[GT[tmpt1,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring2", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring3", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "tracetmp"}], 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell["Syntax:   outerT[tensor1,tensor2] ", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"outerT", "[", 
   RowBox[{"t1_", ",", "t2_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    RowBox[{"dimt2", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t2", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", 
    RowBox[{"tmpt2", "=", "t2"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "outertmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"outertmp", ",", 
      RowBox[{"dimt1", "+", "dimt2"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{"d", ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"dimt1", "+", "dimt2"}]}], "}"}]}], "]"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring1", "=", 
        RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring2", "=", 
        RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", "\n", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring3", "=", 
        RowBox[{"tmpstring3", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", 
        RowBox[{"tmpstring4", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt2"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpeval", "=", 
     RowBox[{"\"\<Do[outertmp=ST[outertmp,{\>\"", "<>", "tmpstring1", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},GT[tmpt1,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring1", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]GT[tmpt2,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]],\>\"", "<>", "tmpstring2",
       "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring4", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "outertmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"scalarDT", "[", "t1_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"covDTtmp", ",", "1", ",", 
      RowBox[{"{", "d", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
    "tmpeval", "=", 
     "\"\<Do[covDTtmp=ST[covDTtmp,{{i1,d}},D[tmpt1,ind[[i1]]]],{i1,1,Nind}]\>\
\""}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "covDTtmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"covDT", "[", "t1_", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dimt1", "=", 
      RowBox[{"Length", "[", 
       RowBox[{"Dimensions", "[", 
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"MT", "[", 
      RowBox[{"covDTtmp", ",", 
       RowBox[{"dimt1", "+", "1"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{"d", ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", 
           RowBox[{"dimt1", "+", "1"}]}], "}"}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Build", " ", "expression"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring1", "=", 
         RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
        ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring2", "=", 
         RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", 
          "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring4", "=", 
         RowBox[{"\"\<-Sum[GT[tmpt1,{\>\"", "<>", 
          RowBox[{"StringDrop", "[", 
           RowBox[{"tmpstring1", ",", 
            RowBox[{"-", "1"}]}], "]"}], "<>", 
          "\"\<}]GT[\[CapitalGamma],{{REPL,d},{s1,d},{s2,u}}],{s2,1,Nind}]\>\"\
"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}], "\[Rule]", " ", 
            "\"\<s2\>\""}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"\"\<REPL\>\"", "\[Rule]", 
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring3", "=", 
         RowBox[{"tmpstring3", "<>", "tmpstring4"}]}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpeval", "=", 
      RowBox[{
      "\"\<Do[covDTtmp=ST[covDTtmp,{\>\"", "<>", "tmpstring1", "<>", 
       "\"\<{s1,d}},D[GT[tmpt1,{\>\"", "<>", 
       RowBox[{"StringDrop", "[", 
        RowBox[{"tmpstring1", ",", 
         RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],ind[[s1]]]\>\"", "<>", 
       "tmpstring3", "<>", "\"\<],\>\"", "<>", "tmpstring2", "<>", 
       "\"\<{s1,1,Nind}]\>\""}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "covDTtmp"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 Editable->False],

Cell[BoxData["."], "Input",
 CellChangeTimes->{3.399009138941909*^9},
 EmphasizeSyntaxErrors->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Buildmetric", "Subsubtitle"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
  "Print", "[", 
   "\"\<\\n\\n   \[CapitalDelta][r_,a_]=(\!\(\*FractionBox[\(\(\\\ \)\(1\)\), \
\(\((1 - a^2)\) + rh\\\ Sqrt[\((1 - r^2)\)]\)]\))^2\\n   f[r_]  =(1-r^2)\\n   \
g[a_]   =2-a^2\\n\\n\\n\\n\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.4603926036977377`*^9, 3.460392609494193*^9}, {
   3.4603964671280737`*^9, 3.460396474067587*^9}, {3.460396608649122*^9, 
   3.4603966089839687`*^9}, 3.5435573776732607`*^9, {3.5435578326785097`*^9, 
   3.543557833045549*^9}}],

Cell[BoxData["\<\"\\n\\n   \
\[CapitalDelta][r_,a_]=(\\!\\(\\*FractionBox[\\(\\(\\\\ \\)\\(1\\)\\), \
\\(\\((1 - a^2)\\) + rh\\\\ Sqrt[\\((1 - r^2)\\)]\\)]\\))^2\\n   f[r_]  \
=(1-r^2)\\n   g[a_]   =2-a^2\\n\\n\\n\\n\"\>"], "Print",
 CellChangeTimes->{{3.460392614803647*^9, 3.460392630773752*^9}, 
   3.4603927469544163`*^9, {3.4603965912356453`*^9, 3.460396610516452*^9}, 
   3.460396683089012*^9, 3.460397912493801*^9, {3.460444072054455*^9, 
   3.460356776865254*^9}, 3.460366839549692*^9, 3.4603725359239388`*^9, 
   3.539782999025613*^9, 3.539785140647101*^9, 3.539868426792572*^9, 
   3.539873663653604*^9, 3.5424699937927732`*^9, 3.5435573790963993`*^9, 
   3.5435574186869783`*^9, 3.543558292294627*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Gd", "=", 
   RowBox[{
    RowBox[{"\[CapitalDelta]", "[", 
     RowBox[{"r", ",", "a"}], "]"}], 
    RowBox[{"(", GridBox[{
       {
        RowBox[{
         RowBox[{"r", "^", "2"}], 
         RowBox[{"f", "[", "r", "]"}], 
         RowBox[{"Exp", "[", 
          RowBox[{"T", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], "]"}]}], "0", "0", "0", 
        "0", "0"},
       {"0", 
        RowBox[{
         FractionBox["1", 
          RowBox[{
           RowBox[{"f", "[", "r", "]"}], "^", "2"}]], 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"T", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
           RowBox[{
            RowBox[{"r", "^", "2"}], 
            RowBox[{"A", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], "]"}]}], 
        RowBox[{"a", " ", "r", " ", 
         FractionBox["1", 
          RowBox[{"f", "[", "r", "]"}]], 
         RowBox[{"F", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "0", "0", "0"},
       {"0", 
        RowBox[{"a", " ", "r", " ", 
         FractionBox["1", 
          RowBox[{"f", "[", "r", "]"}]], 
         RowBox[{"F", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], 
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
           RowBox[{
            RowBox[{"a", "^", "2"}], " ", 
            RowBox[{"B", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], "]"}], 
         FractionBox["4", 
          RowBox[{"g", "[", "a", "]"}]]}], "0", "0", "0"},
       {"0", "0", "0", 
        FractionBox[
         RowBox[{
          RowBox[{"Exp", "[", 
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "]"}], 
          RowBox[{"g", "[", "a", "]"}], 
          RowBox[{"a", "^", "2"}]}], 
         RowBox[{"1", "-", 
          RowBox[{"\[Theta]1", "^", "2"}]}]], "0", "0"},
       {"0", "0", "0", "0", 
        RowBox[{" ", 
         RowBox[{
          RowBox[{"Exp", "[", 
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "]"}], 
          RowBox[{"g", "[", "a", "]"}], 
          RowBox[{"a", "^", "2"}], 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"\[Theta]1", "^", "2"}]}], ")"}]}]}], "0"},
       {"0", "0", "0", "0", "0", 
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{"S", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], "]"}], 
         RowBox[{"g", "[", "a", "]"}], 
         RowBox[{"a", "^", "2"}], 
         RowBox[{"\[Theta]1", "^", "2"}]}]}
      }], ")"}]}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{
    "t", ",", "r", ",", "a", ",", "\[Theta]1", ",", "\[Theta]2", ",", 
     "\[Theta]3"}], "}"}]}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"Nind", "=", 
   RowBox[{"Length", "[", "ind", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"BuildMetric", ";"}]}], "Input",
 CellChangeTimes->{{3.408796998476103*^9, 3.408797030516582*^9}, {
   3.408799071597343*^9, 3.408799082644943*^9}, {3.408949739095245*^9, 
   3.408949739644734*^9}, {3.408949841695282*^9, 3.40894984293303*^9}, {
   3.415862083663703*^9, 3.4158620851642113`*^9}, {3.415862334623486*^9, 
   3.415862336021243*^9}, {3.415862388498528*^9, 3.4158623965197372`*^9}, {
   3.4158641082437763`*^9, 3.415864116357332*^9}, {3.415865034672494*^9, 
   3.415865047473855*^9}, {3.415943026431671*^9, 3.415943056090918*^9}, {
   3.42453089354659*^9, 3.424530981705195*^9}, {3.4262330694486513`*^9, 
   3.426233078224708*^9}, {3.42831552177035*^9, 3.428315531925826*^9}, {
   3.482669504390863*^9, 3.482669559589313*^9}, {3.482669593648382*^9, 
   3.4826696108221407`*^9}, {3.4826696421684*^9, 3.460306349771068*^9}, {
   3.460306681872867*^9, 3.4603066892293873`*^9}, {3.460306743915044*^9, 
   3.460306776656151*^9}, {3.4603068906726713`*^9, 3.4603069154556093`*^9}, 
   3.4606109474491568`*^9, {3.5039972414730186`*^9, 3.503997244123049*^9}, {
   3.5172982618161573`*^9, 3.517298294501769*^9}, {3.517302332920382*^9, 
   3.517302353678054*^9}, {3.51730241996021*^9, 3.517302425934087*^9}, {
   3.517302556663072*^9, 3.5173025584548187`*^9}, 3.517579091871194*^9, {
   3.517642973774815*^9, 3.517642975072443*^9}, 3.517658611602713*^9, {
   3.517660901410638*^9, 3.460392650166881*^9}, {3.4603926980532846`*^9, 
   3.460392722992764*^9}, {3.460396656885631*^9, 3.460356665674651*^9}, {
   3.460356724881654*^9, 3.4603567425493803`*^9}, 3.460372510789526*^9, {
   3.54246967191507*^9, 3.542469701786797*^9}, {3.542469881774507*^9, 
   3.5424699266914043`*^9}, {3.543557353434564*^9, 3.5435573569933662`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"T", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
      SuperscriptBox["r", "2"], " ", 
      RowBox[{"f", "[", "r", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}], ",", "0", ",", "0", ",", "0", ",", 
     "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"A", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{"T", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      SuperscriptBox[
       RowBox[{"f", "[", "r", "]"}], "2"]], ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"f", "[", "r", "]"}]], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"f", "[", "r", "]"}]], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"B", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{"S", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"g", "[", "a", "]"}]], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"1", "-", 
       SuperscriptBox["\[Theta]1", "2"]}]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"S", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
      RowBox[{"g", "[", "a", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"S", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
      SuperscriptBox["\[Theta]1", "2"], " ", 
      RowBox[{"g", "[", "a", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.503310959549301*^9, {3.503311337489339*^9, 3.460515673680585*^9}, 
   3.503996967770006*^9, 3.503997006524664*^9, 3.503997194550593*^9, 
   3.5039972601206627`*^9, 3.504000114145877*^9, 3.5173031733152313`*^9, 
   3.517579162305614*^9, 3.517643121148817*^9, 3.517650908892145*^9, 
   3.517658630210273*^9, 3.5176586899579687`*^9, 3.517660936798641*^9, {
   3.5178236465697403`*^9, 3.517823673129346*^9}, 3.517824230175544*^9, {
   3.517825903545369*^9, 3.460388252816543*^9}, 3.460392747023707*^9, 
   3.460396683141287*^9, 3.4603979125408783`*^9, {3.460444072147172*^9, 
   3.460356776913579*^9}, 3.46036683960192*^9, 3.460372536508292*^9, 
   3.539782999088622*^9, 3.539785140698571*^9, 3.539868426896636*^9, 
   3.53987366371763*^9, 3.542469993839971*^9, 3.5435574187269382`*^9, 
   3.5435582923288794`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "t", ",", "r", ",", "a", ",", "\[Theta]1", ",", "\[Theta]2", ",", 
   "\[Theta]3"}], "}"}]], "Output",
 CellChangeTimes->{
  3.503310959549301*^9, {3.503311337489339*^9, 3.460515673680585*^9}, 
   3.503996967770006*^9, 3.503997006524664*^9, 3.503997194550593*^9, 
   3.5039972601206627`*^9, 3.504000114145877*^9, 3.5173031733152313`*^9, 
   3.517579162305614*^9, 3.517643121148817*^9, 3.517650908892145*^9, 
   3.517658630210273*^9, 3.5176586899579687`*^9, 3.517660936798641*^9, {
   3.5178236465697403`*^9, 3.517823673129346*^9}, 3.517824230175544*^9, {
   3.517825903545369*^9, 3.460388252816543*^9}, 3.460392747023707*^9, 
   3.460396683141287*^9, 3.4603979125408783`*^9, {3.460444072147172*^9, 
   3.460356776913579*^9}, 3.46036683960192*^9, 3.460372536508292*^9, 
   3.539782999088622*^9, 3.539785140698571*^9, 3.539868426896636*^9, 
   3.53987366371763*^9, 3.542469993839971*^9, 3.5435574187269382`*^9, 
   3.543558292332073*^9}],

Cell[BoxData["6"], "Output",
 CellChangeTimes->{
  3.503310959549301*^9, {3.503311337489339*^9, 3.460515673680585*^9}, 
   3.503996967770006*^9, 3.503997006524664*^9, 3.503997194550593*^9, 
   3.5039972601206627`*^9, 3.504000114145877*^9, 3.5173031733152313`*^9, 
   3.517579162305614*^9, 3.517643121148817*^9, 3.517650908892145*^9, 
   3.517658630210273*^9, 3.5176586899579687`*^9, 3.517660936798641*^9, {
   3.5178236465697403`*^9, 3.517823673129346*^9}, 3.517824230175544*^9, {
   3.517825903545369*^9, 3.460388252816543*^9}, 3.460392747023707*^9, 
   3.460396683141287*^9, 3.4603979125408783`*^9, {3.460444072147172*^9, 
   3.460356776913579*^9}, 3.46036683960192*^9, 3.460372536508292*^9, 
   3.539782999088622*^9, 3.539785140698571*^9, 3.539868426896636*^9, 
   3.53987366371763*^9, 3.542469993839971*^9, 3.5435574187269382`*^9, 
   3.5435582923339043`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Gd"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"T", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
      SuperscriptBox["r", "2"], " ", 
      RowBox[{"f", "[", "r", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}], ",", "0", ",", "0", ",", "0", ",", 
     "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"A", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{"T", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      SuperscriptBox[
       RowBox[{"f", "[", "r", "]"}], "2"]], ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"f", "[", "r", "]"}]], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"f", "[", "r", "]"}]], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"B", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{"S", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"g", "[", "a", "]"}]], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"1", "-", 
       SuperscriptBox["\[Theta]1", "2"]}]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"S", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
      RowBox[{"g", "[", "a", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"S", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
      SuperscriptBox["\[Theta]1", "2"], " ", 
      RowBox[{"g", "[", "a", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.426737013947981*^9, 3.42831519475591*^9, 3.428315553704377*^9, 
   3.42831688012332*^9, 3.428403895402966*^9, 3.428404282812348*^9, 
   3.431855679361175*^9, 3.431863727521323*^9, 3.482645295470035*^9, 
   3.482645359355171*^9, 3.482645465220532*^9, 3.482646536463307*^9, 
   3.4826465772437983`*^9, 3.4826543017657003`*^9, 3.482660739570448*^9, {
   3.4826656670958242`*^9, 3.460345346563177*^9}, 3.482732901086844*^9, 
   3.483268305672525*^9, 3.483274831485346*^9, 3.483355831699278*^9, 
   3.4951748242050257`*^9, 3.497953163855152*^9, 3.497953489287703*^9, 
   3.5014842100803003`*^9, {3.5014865241306953`*^9, 3.4603905383513203`*^9}, 
   3.4604294104843483`*^9, 3.46042947896661*^9, {3.503999600339315*^9, 
   3.4603433478172483`*^9}, 3.460397496352495*^9, 3.460398195234408*^9, {
   3.4606252658864193`*^9, 3.4603659368972*^9}, 3.4603733533587*^9, 
   3.5414356961283913`*^9, 3.54144101540274*^9, 3.5419998477583447`*^9, 
   3.542001527431053*^9, 3.5424708313203497`*^9, 3.5435582931767483`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Gu"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        RowBox[{"T", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], 
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"f", "[", "r", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]], ",", "0", ",", "0", ",", "0", ",", 
     "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"f", "[", "r", "]"}], "2"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], " ", 
             RowBox[{"B", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
            RowBox[{"S", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"F", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
          RowBox[{"g", "[", "a", "]"}]}]}], ")"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]], ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"f", "[", "r", "]"}], " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"g", "[", "a", "]"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"B", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{"S", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"F", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
          RowBox[{"g", "[", "a", "]"}]}]}], ")"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]], ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"f", "[", "r", "]"}], " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"g", "[", "a", "]"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"B", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{"S", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"F", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
          RowBox[{"g", "[", "a", "]"}]}]}], ")"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]], ",", 
     FractionBox["1", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["r", "2"]}], " ", 
           RowBox[{"A", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
          RowBox[{"T", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
        SuperscriptBox["r", "2"], " ", 
        SuperscriptBox[
         RowBox[{"F", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], "+", 
       FractionBox[
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"B", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
         RowBox[{"\[CapitalDelta]", "[", 
          RowBox[{"r", ",", "a"}], "]"}]}], 
        RowBox[{"g", "[", "a", "]"}]]}]], ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", 
          RowBox[{"S", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[Theta]1", "2"]}], ")"}]}], 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"g", "[", "a", "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}]]}], ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", 
         RowBox[{"S", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
        RowBox[{"g", "[", "a", "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}]]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[Theta]1", "2"], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.426737013996367*^9, 3.428315194823951*^9, 3.42831555372094*^9, 
   3.428316880162258*^9, 3.428403895438301*^9, 3.42840428286333*^9, 
   3.431855679506925*^9, 3.431863727579101*^9, 3.482645295502652*^9, 
   3.482645359398937*^9, 3.482645465282672*^9, 3.4826465365215797`*^9, 
   3.482646577301097*^9, 3.482654301950992*^9, 3.482660739739355*^9, {
   3.482665667186685*^9, 3.4603453466175222`*^9}, 3.4827329011606503`*^9, 
   3.483268305726141*^9, 3.483274831596257*^9, 3.4833558317557917`*^9, 
   3.49517482426343*^9, 3.497953163911227*^9, 3.497953489425228*^9, 
   3.501484210221078*^9, {3.5014865242391787`*^9, 3.460390538438959*^9}, 
   3.460429410533709*^9, 3.460429479043961*^9, {3.5039996003967047`*^9, 
   3.4603433478632727`*^9}, 3.460397496429948*^9, 3.4603981953136177`*^9, {
   3.460625265957264*^9, 3.4603659369408827`*^9}, 3.4603733534335823`*^9, 
   3.5414356961843777`*^9, 3.541441015458969*^9, 3.541999847822082*^9, 
   3.542001527468235*^9, 3.5424708313831263`*^9, 3.543558293237279*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"detg", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Det", "[", "Gd", "]"}], "]"}]}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["a", "6"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"3", " ", 
      RowBox[{"S", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
     RowBox[{"T", "[", 
      RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
   SuperscriptBox["r", "2"], " ", 
   SuperscriptBox["\[Theta]1", "2"], " ", 
   SuperscriptBox[
    RowBox[{"g", "[", "a", "]"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"A", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"B", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
        RowBox[{"T", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["r", "2"], " ", 
      SuperscriptBox[
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
      RowBox[{"g", "[", "a", "]"}]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"\[CapitalDelta]", "[", 
     RowBox[{"r", ",", "a"}], "]"}], "6"]}], 
  RowBox[{"f", "[", "r", "]"}]]], "Output",
 CellChangeTimes->{
  3.426737014038818*^9, 3.428315194987363*^9, 3.428315553807802*^9, 
   3.428316880199193*^9, 3.4284038954693108`*^9, 3.428404282950614*^9, 
   3.431855679578286*^9, 3.4318637276288977`*^9, 3.482645295534935*^9, 
   3.482645359432629*^9, 3.482645465322057*^9, 3.482646536679943*^9, 
   3.482646577444168*^9, 3.482654302025573*^9, 3.482660739810965*^9, {
   3.4826656672687674`*^9, 3.460345346748376*^9}, 3.482732901244331*^9, 
   3.483268305791041*^9, 3.483274831689481*^9, 3.4833558318200827`*^9, 
   3.495174824307178*^9, 3.497953163960969*^9, 3.497953489575306*^9, 
   3.501484210316465*^9, {3.5014865243333797`*^9, 3.4603905385408373`*^9}, 
   3.4604294106016273`*^9, 3.460429479111375*^9, {3.503999600438518*^9, 
   3.460343347915853*^9}, 3.460397496568387*^9, 3.460398195393688*^9, {
   3.4606252661078997`*^9, 3.460365937009363*^9}, 3.4603733535789757`*^9, 
   3.5414356962284184`*^9, 3.54144101549096*^9, 3.541999847874116*^9, 
   3.542001527498621*^9, 3.5424708314772873`*^9, 3.543558293269396*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRrun2.nb", "Subsubtitle"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\[CapitalGamma]", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"\[CapitalGamma]", ",", "3", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "u"}], "}"}]}], "]"}], ";"}], "\n"}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R4", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R4", ",", "4", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "d", ",", "u"}], "}"}]}], "]"}], 
  ";"}], "\n"}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "G2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"G2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"\[CapitalGamma]", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"\[CapitalGamma]", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], 
         RowBox[{"GT", "[", 
          RowBox[{"G", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
            "}"}]}], "]"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "+", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "ss1", "]"}], "]"}]}], "]"}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalGamma]", "=", 
   RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.426232729469757*^9, 3.426232735540435*^9}}],

Cell[BoxData[
 RowBox[{"Do", "[", "\n", "\t", 
  RowBox[{
   RowBox[{"R4", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R4", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      "\n", "\t", "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "+", "\n", "\t\t\t", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}]}], "\n", 
     "\t\t", "\n", "\t\t", "]"}]}], "\n", "\t\t", ",", "\n", "\t", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i4", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R4", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"R2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"GT", "[", 
         RowBox[{"R4", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}],
          "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "\n", 
     "\t\t", "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"GT", "[", 
      RowBox[{"R2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"G2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"G2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"GT", "[", 
        RowBox[{"R2", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
        "]"}], "-", 
       RowBox[{
        FractionBox["1", "2"], 
        RowBox[{"GT", "[", 
         RowBox[{"G", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
         "]"}], "Ricci"}]}]}], "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "G2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "Ricci", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"]
}, Closed]],

Cell[CellGroupData[{

Cell["Einstein equations", "Subsubtitle"],

Cell[CellGroupData[{

Cell[BoxData["ind"], "Input",
 CellChangeTimes->{{3.482645378412899*^9, 3.4826453786609163`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "t", ",", "r", ",", "a", ",", "\[Theta]1", ",", "\[Theta]2", ",", 
   "\[Theta]3"}], "}"}]], "Output",
 CellChangeTimes->{
  3.482645396895133*^9, 3.482645499809284*^9, 3.482646611846545*^9, 
   3.48265433638922*^9, {3.482665675369759*^9, 3.460345373817977*^9}, 
   3.482732919598102*^9, 3.4832683242802143`*^9, 3.483274850617939*^9, 
   3.483355850660965*^9, 3.495174843468848*^9, 3.497953181922439*^9, 
   3.497953507686852*^9, 3.5014842285458813`*^9, {3.501486543945709*^9, 
   3.4603905641391706`*^9}, 3.460429437199853*^9, 3.4604295045078793`*^9, {
   3.503999615054343*^9, 3.4603433738186502`*^9}, 3.460397545985814*^9, 
   3.460398244813052*^9, {3.460625316134089*^9, 3.4603659842036743`*^9}, 
   3.460373401256411*^9, 3.541435714343343*^9, 3.541441033648178*^9, 
   3.54199986288216*^9, 3.542001542433325*^9, 3.542470853023415*^9, 
   3.543558313783145*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TangVec", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "u", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
    "}"}]}]], "Input",
 CellChangeTimes->{{3.482645319964726*^9, 3.482645321420919*^9}, {
  3.482645369742679*^9, 3.482645398774542*^9}, {3.5424708600316677`*^9, 
  3.5424708602227488`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "u", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.4826453938568697`*^9, 3.482645399209482*^9}, 
   3.48264549990095*^9, 3.4826466119131927`*^9, 3.482654336461301*^9, 
   3.482661037405292*^9, 3.4826611049629107`*^9, {3.4826656754454536`*^9, 
   3.460345373890777*^9}, 3.48273291967444*^9, 3.4832683243369207`*^9, 
   3.483274850726749*^9, 3.48335585071898*^9, 3.49517484354065*^9, 
   3.497953181977542*^9, 3.49795350775769*^9, 3.501484228646851*^9, {
   3.501486544055847*^9, 3.460390564238563*^9}, 3.4604294372576113`*^9, 
   3.460429504591004*^9, {3.503999615107829*^9, 3.460343373920657*^9}, 
   3.460397546066593*^9, 3.4603976151938047`*^9, 3.4603977205260897`*^9, 
   3.460398244895062*^9, {3.4606253161639013`*^9, 3.460365984260375*^9}, 
   3.460373401309203*^9, 3.541435714381008*^9, 3.5414410336888742`*^9, 
   3.5419998629384117`*^9, 3.542001542477748*^9, {3.5424708530839157`*^9, 
   3.542470864088642*^9}, 3.5435583138089333`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NormVec", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "u", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "c", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}]}],
    "}"}]}]], "Input",
 CellChangeTimes->{{3.482645401975491*^9, 3.482645411285253*^9}, {
  3.4826458546230803`*^9, 3.482645859613565*^9}, {3.542470862086911*^9, 
  3.542470862334997*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "u", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "c", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.482645412231688*^9, 3.4826454147952023`*^9}, 
   3.482645499988126*^9, {3.482645855809843*^9, 3.482645883352165*^9}, 
   3.482646611979519*^9, 3.482654336511277*^9, 3.482661038021718*^9, 
   3.482661105445985*^9, {3.48266567551117*^9, 3.460345383768354*^9}, 
   3.482732919741027*^9, 3.483268324387245*^9, 3.4832748508268423`*^9, 
   3.483355850769663*^9, 3.495174843607183*^9, 3.497953182026888*^9, 
   3.497953507824995*^9, 3.501484228748543*^9, {3.5014865441560593`*^9, 
   3.4603905643381643`*^9}, 3.46042943731177*^9, 3.460429504658307*^9, {
   3.503999615158149*^9, 3.460343374012308*^9}, {3.460397546116476*^9, 
   3.460397554586464*^9}, 3.460397616057626*^9, 3.460397721507806*^9, 
   3.4603982449627333`*^9, {3.460625316191557*^9, 3.4603659843147182`*^9}, 
   3.460373401362619*^9, 3.541435714413704*^9, 3.541441033726552*^9, 
   3.541999862990693*^9, 3.542001542517255*^9, {3.5424708532359457`*^9, 
   3.542470864890204*^9}, 3.543558313840075*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"trT", "[", 
    RowBox[{
     RowBox[{"outerT", "[", 
      RowBox[{"NormVec", ",", "TangVec"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.482645418577425*^9, 3.482645427289304*^9}, {
  3.482645468181383*^9, 3.482645476589221*^9}, {3.482645843815053*^9, 
  3.482645847782482*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"c", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"A", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
        RowBox[{"T", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
     RowBox[{"a", " ", "r", " ", 
      RowBox[{"f", "[", "r", "]"}], " ", 
      RowBox[{"F", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}], " ", 
   RowBox[{"\[CapitalDelta]", "[", 
    RowBox[{"r", ",", "a"}], "]"}]}], 
  SuperscriptBox[
   RowBox[{"f", "[", "r", "]"}], "2"]]], "Output",
 CellChangeTimes->{{3.482645500150728*^9, 3.482645500248397*^9}, {
   3.482645848182082*^9, 3.482645884001075*^9}, 3.4826466120466337`*^9, 
   3.482654336578025*^9, 3.4826610385554256`*^9, 3.48266110607915*^9, {
   3.4826656755777893`*^9, 3.4603453844097233`*^9}, 3.4827329198242073`*^9, 
   3.483268324437192*^9, 3.483274850926392*^9, 3.4833558508365517`*^9, 
   3.495174843674325*^9, 3.497953182092972*^9, 3.497953507891675*^9, 
   3.501484228848415*^9, {3.50148654425138*^9, 3.460390564454529*^9}, 
   3.460429437396255*^9, 3.4604295047416677`*^9, {3.5039996152234488`*^9, 
   3.460343374113392*^9}, {3.460397546195798*^9, 3.460397556094911*^9}, {
   3.460397612427554*^9, 3.4603976186530657`*^9}, 3.460397722451044*^9, 
   3.4603982450435953`*^9, {3.460625316245699*^9, 3.460365984388968*^9}, 
   3.460373401431588*^9, 3.541435714454726*^9, 3.5414410337725983`*^9, 
   3.541999863034059*^9, 3.542001542564604*^9, {3.542470853584126*^9, 
   3.542470865954557*^9}, 3.54355831387562*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"solc", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"tmp", "\[Equal]", "0"}], ",", "c"}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4826458619731216`*^9, 3.482645885469399*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"c", "\[Rule]", 
   RowBox[{
    RowBox[{"-", "a"}], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["r", "2"]}], " ", 
       RowBox[{"A", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
      RowBox[{"T", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", " ", 
    RowBox[{"f", "[", "r", "]"}], " ", 
    RowBox[{"F", "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.482645866916765*^9, 3.482645885850039*^9}, 
   3.482646612112681*^9, 3.482654336644636*^9, 3.48266103912289*^9, 
   3.482661106661934*^9, {3.482665675773703*^9, 3.4603453850827007`*^9}, 
   3.482732919892187*^9, 3.4832683244871187`*^9, 3.483274851026471*^9, 
   3.483355850902607*^9, 3.495174843797553*^9, 3.497953182236517*^9, 
   3.497953507962245*^9, 3.501484228947846*^9, {3.501486544367445*^9, 
   3.460390564571981*^9}, 3.4604294374785643`*^9, 3.4604295052381477`*^9, {
   3.503999615273387*^9, 3.46034337432885*^9}, {3.4603975464008017`*^9, 
   3.460397559265963*^9}, {3.460397608269051*^9, 3.460397619840056*^9}, 
   3.460397723756569*^9, 3.460398245129245*^9, {3.460625316305313*^9, 
   3.460365984499096*^9}, 3.460373401538006*^9, 3.541435714497484*^9, 
   3.5414410338127327`*^9, 3.541999863090201*^9, 3.542001542611764*^9, {
   3.542470853926465*^9, 3.54247086697196*^9}, 3.5435583139586277`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"norm", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"trT", "[", 
     RowBox[{
      RowBox[{"outerT", "[", 
       RowBox[{"NormVec", ",", "NormVec"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "]"}], "/.", "solc"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.482645887033798*^9, 3.482645944381516*^9}, 
   3.482646520071669*^9, {3.4826610549294243`*^9, 3.482661055727974*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["a", "2"]}], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["r", "2"]}], " ", 
        RowBox[{"A", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
       RowBox[{"T", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
     SuperscriptBox["r", "2"], " ", 
     SuperscriptBox[
      RowBox[{"F", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"B", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
     RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
  RowBox[{"\[CapitalDelta]", "[", 
   RowBox[{"r", ",", "a"}], "]"}]}]], "Output",
 CellChangeTimes->{{3.4826459114463377`*^9, 3.482645946064207*^9}, 
   3.482646521174985*^9, 3.482646612179653*^9, 3.4826543367113037`*^9, {
   3.482661039770041*^9, 3.482661057205875*^9}, 3.482661107310892*^9, {
   3.482665675844986*^9, 3.460345385891876*^9}, 3.482732919959566*^9, 
   3.483268324537109*^9, 3.483274851126627*^9, 3.48335585096931*^9, 
   3.495174843861245*^9, 3.4979531822934227`*^9, 3.4979535080257998`*^9, 
   3.501484229049124*^9, {3.501486544483901*^9, 3.4603905646877317`*^9}, 
   3.460429437562561*^9, 3.460429505307798*^9, {3.503999615328701*^9, 
   3.460343374428726*^9}, {3.460397546467606*^9, 3.460397560792774*^9}, {
   3.4603976234983683`*^9, 3.460397639647757*^9}, {3.460397714992196*^9, 
   3.460397724666641*^9}, 3.4603982452107267`*^9, {3.460625316353703*^9, 
   3.4603659845427628`*^9}, 3.460373401583537*^9, 3.541435714536965*^9, 
   3.541441033856237*^9, 3.5419998783147707`*^9, 3.542001542654808*^9, {
   3.5424708546472063`*^9, 3.542470878483901*^9}, 3.543558313991535*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NormVec", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "u", "}"}], ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"Sqrt", "[", "norm", "]"}]], 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{
         RowBox[{"-", "a"}], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["r", "2"]}], " ", 
            RowBox[{"A", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
           RowBox[{"T", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", " ", 
         RowBox[{"f", "[", "r", "]"}], " ", 
         RowBox[{"F", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], ",", "1", ",", "0", ",",
         "0", ",", "0"}], "}"}]}], "]"}]}], "}"}]}]], "Input",
 CellChangeTimes->{
  3.4826458784255457`*^9, {3.4826459516081743`*^9, 3.482645973654932*^9}, {
   3.482646535197999*^9, 3.4826465537111883`*^9}, {3.4826610604906797`*^9, 
   3.460345405029395*^9}, 3.4832683401604548`*^9, {3.4979535355921383`*^9, 
   3.460397584552984*^9}, {3.460397713227003*^9, 3.460366049162068*^9}, 
   3.541441069057948*^9, {3.541999902156464*^9, 3.5419999028934383`*^9}, {
   3.542470877241432*^9, 3.542470884534902*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "u", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"a", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["r", "2"]}], " ", 
           RowBox[{"A", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
          RowBox[{"T", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", " ", 
        RowBox[{"f", "[", "r", "]"}], " ", 
        RowBox[{"F", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], 
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["r", "2"]}], " ", 
               RowBox[{"A", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
              RowBox[{"T", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
            SuperscriptBox["r", "2"], " ", 
            SuperscriptBox[
             RowBox[{"F", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
           FractionBox[
            RowBox[{"4", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                RowBox[{"B", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{"S", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
            RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
         RowBox[{"\[CapitalDelta]", "[", 
          RowBox[{"r", ",", "a"}], "]"}]}]]]}], ",", 
     FractionBox["1", 
      SqrtBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["a", "2"]}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["r", "2"]}], " ", 
              RowBox[{"A", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
             RowBox[{"T", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox[
            RowBox[{"F", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               RowBox[{"B", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
              RowBox[{"S", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
           RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}]]], ",", "0", ",", "0", ",", "0"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.482645879356182*^9, {3.482645961553833*^9, 3.482645974077807*^9}, 
   3.482646612245695*^9, 3.482654336777485*^9, {3.482661040321257*^9, 
   3.482661062939979*^9}, 3.482661109026106*^9, {3.482665675938364*^9, 
   3.460345405768785*^9}, 3.4827329202064533`*^9, 3.483268341264225*^9, 
   3.483274851436404*^9, 3.4833558512792063`*^9, 3.495174844184272*^9, 
   3.497953182665312*^9, 3.497953538324436*^9, 3.501484229381893*^9, {
   3.501486544818342*^9, 3.460390565416277*^9}, 3.46042943833361*^9, 
   3.460429506062654*^9, {3.50399961569064*^9, 3.460343375184429*^9}, {
   3.460397567778631*^9, 3.4603975855753593`*^9}, {3.46039764461899*^9, 
   3.460397647414546*^9}, 3.4603977312320147`*^9, 3.460398247315359*^9, {
   3.460625318355755*^9, 3.460366050527224*^9}, 3.460373403563223*^9, 
   3.541435715780294*^9, 3.541441072499552*^9, 3.541999904665681*^9, 
   3.5420015435324783`*^9, {3.542470879969433*^9, 3.542470885114746*^9}, 
   3.543558314663939*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"trT", "[", 
   RowBox[{
    RowBox[{"outerT", "[", 
     RowBox[{"NormVec", ",", "NormVec"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.482661065734774*^9, 3.4826610789595137`*^9}}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{
  3.4826610793363543`*^9, 3.482661109925275*^9, {3.482665675994561*^9, 
   3.460345406663004*^9}, 3.4827329202736473`*^9, 3.483268342771421*^9, 
   3.483268383662122*^9, 3.483274851751947*^9, 3.483355851334548*^9, 
   3.495174844626775*^9, 3.497953182736599*^9, 3.4979535393096867`*^9, 
   3.501484229641233*^9, {3.5014865451460876`*^9, 3.460390565682083*^9}, 
   3.4604294385425787`*^9, 3.460429506244069*^9, {3.503999615763026*^9, 
   3.46034337543242*^9}, 3.4603977334598703`*^9, 3.460398247593706*^9, {
   3.46062531857738*^9, 3.46036605146989*^9}, 3.460373403796906*^9, 
   3.5414357160380907`*^9, 3.541441073950495*^9, 3.541999906169791*^9, 
   3.542001543647773*^9, {3.5424708814372797`*^9, 3.542470886084831*^9}, 
   3.5435583147070503`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"trT", "[", 
   RowBox[{
    RowBox[{"outerT", "[", 
     RowBox[{"TangVec", ",", "NormVec"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{3.482661116857547*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.48266111728564*^9, {3.4826656760602818`*^9, 3.460345407972846*^9}, 
   3.4827329203405867`*^9, 3.483268343566309*^9, 3.483268384244651*^9, 
   3.483274851858819*^9, 3.483355851401087*^9, 3.49517484474189*^9, 
   3.497953182835265*^9, 3.497953540192875*^9, 3.501484229735509*^9, {
   3.501486545266227*^9, 3.460390565785603*^9}, 3.460429438666939*^9, 
   3.460429506302597*^9, {3.50399961586336*^9, 3.4603433755067387`*^9}, 
   3.460397734590137*^9, 3.460398247777378*^9, {3.460625318633223*^9, 
   3.460366052308152*^9}, 3.4603734039171886`*^9, 3.5414357162502317`*^9, 
   3.541441074853291*^9, 3.541999906896966*^9, 3.542001543680332*^9, 
   3.542470887012957*^9, 3.543558314853552*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"q", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"d", ",", "d"}], "}"}], ",", 
       RowBox[{"Gd", "-", 
        RowBox[{
         RowBox[{"outerT", "[", 
          RowBox[{"NormVec", ",", "NormVec"}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MatrixForm", "[", "Gd", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", 
  RowBox[{"q", "[", 
   RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.482661126460228*^9, 3.4826611805206537`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"T", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"f", "[", "r", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], "0", "0", "0", "0", "0"},
     {"0", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"A", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
          RowBox[{"T", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], 
       SuperscriptBox[
        RowBox[{"f", "[", "r", "]"}], "2"]], 
      FractionBox[
       RowBox[{"a", " ", "r", " ", 
        RowBox[{"F", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], 
       RowBox[{"f", "[", "r", "]"}]], "0", "0", "0"},
     {"0", 
      FractionBox[
       RowBox[{"a", " ", "r", " ", 
        RowBox[{"F", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], 
       RowBox[{"f", "[", "r", "]"}]], 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"B", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
          RowBox[{"S", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], 
       RowBox[{"g", "[", "a", "]"}]], "0", "0", "0"},
     {"0", "0", "0", 
      FractionBox[
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"S", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
        RowBox[{"g", "[", "a", "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], 
       RowBox[{"1", "-", 
        SuperscriptBox["\[Theta]1", "2"]}]], "0", "0"},
     {"0", "0", "0", "0", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], "0"},
     {"0", "0", "0", "0", "0", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
       SuperscriptBox["\[Theta]1", "2"], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.482661147027567*^9, 3.4826611807315187`*^9}, {
   3.4826656761300983`*^9, 3.4603454098331013`*^9}, 3.4827329204079514`*^9, 
   3.48326838558283*^9, 3.483274851960454*^9, 3.483355851470969*^9, 
   3.495174844808804*^9, 3.497953183117558*^9, 3.497953541537301*^9, 
   3.501484229835047*^9, {3.501486545371581*^9, 3.460390565903183*^9}, 
   3.460429438778407*^9, 3.460429506389037*^9, {3.503999615962226*^9, 
   3.4603433755939074`*^9}, 3.460397739642098*^9, 3.460398247939376*^9, {
   3.4606253186910763`*^9, 3.4603660533651037`*^9}, 3.4603734040724487`*^9, 
   3.541435716778173*^9, 3.541441075915968*^9, 3.5419999078299932`*^9, 
   3.5420015437151937`*^9, 3.542470888023245*^9, 3.543558332985569*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"T", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"f", "[", "r", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], "0", "0", "0", "0", "0"},
     {"0", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"A", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
          RowBox[{"T", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], 
       SuperscriptBox[
        RowBox[{"f", "[", "r", "]"}], "2"]], 
      FractionBox[
       RowBox[{"a", " ", "r", " ", 
        RowBox[{"F", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], 
       RowBox[{"f", "[", "r", "]"}]], "0", "0", "0"},
     {"0", 
      FractionBox[
       RowBox[{"a", " ", "r", " ", 
        RowBox[{"F", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], 
       RowBox[{"f", "[", "r", "]"}]], 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["r", "2"]}], " ", 
          RowBox[{"A", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
         RowBox[{"T", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox[
        RowBox[{"F", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], "0", "0", "0"},
     {"0", "0", "0", 
      FractionBox[
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"S", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
        RowBox[{"g", "[", "a", "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], 
       RowBox[{"1", "-", 
        SuperscriptBox["\[Theta]1", "2"]}]], "0", "0"},
     {"0", "0", "0", "0", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "2"]}], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], "0"},
     {"0", "0", "0", "0", "0", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
       SuperscriptBox["\[Theta]1", "2"], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.482661147027567*^9, 3.4826611807315187`*^9}, {
   3.4826656761300983`*^9, 3.4603454098331013`*^9}, 3.4827329204079514`*^9, 
   3.48326838558283*^9, 3.483274851960454*^9, 3.483355851470969*^9, 
   3.495174844808804*^9, 3.497953183117558*^9, 3.497953541537301*^9, 
   3.501484229835047*^9, {3.501486545371581*^9, 3.460390565903183*^9}, 
   3.460429438778407*^9, 3.460429506389037*^9, {3.503999615962226*^9, 
   3.4603433755939074`*^9}, 3.460397739642098*^9, 3.460398247939376*^9, {
   3.4606253186910763`*^9, 3.4603660533651037`*^9}, 3.4603734040724487`*^9, 
   3.541435716778173*^9, 3.541441075915968*^9, 3.5419999078299932`*^9, 
   3.5420015437151937`*^9, 3.542470888023245*^9, 3.5435583329889383`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"trT", "[", 
    RowBox[{
     RowBox[{"outerT", "[", 
      RowBox[{"q", ",", "NormVec"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"trT", "[", 
    RowBox[{
     RowBox[{"outerT", "[", 
      RowBox[{"q", ",", "TangVec"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"trT", "[", 
   RowBox[{
    RowBox[{"outerT", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"d", ",", "d"}], "}"}], ",", "Gd"}], "}"}], ",", "TangVec"}],
      "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.4826611936232367`*^9, 3.482661223289483*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "d", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.482661206242777*^9, 3.4826612240707273`*^9}, {
   3.482665676264707*^9, 3.460345436476618*^9}, 3.482732920482984*^9, 
   3.4832683872309437`*^9, 3.4832748520751867`*^9, 3.483355851783144*^9, 
   3.495174844893948*^9, 3.497953183445979*^9, 3.4979535425295963`*^9, 
   3.501484229967771*^9, {3.5014865454883547`*^9, 3.460390566032054*^9}, 
   3.4604294389890823`*^9, 3.460429506493195*^9, {3.503999616253805*^9, 
   3.4603433757070503`*^9}, 3.460397743066276*^9, 3.460398248143712*^9, {
   3.460625318805606*^9, 3.4603660544298983`*^9}, 3.4603734042813787`*^9, 
   3.541435717627144*^9, 3.541441077040722*^9, 3.5419999091531487`*^9, 
   3.542001543768545*^9, 3.542470889806849*^9, 3.5435583341576567`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "d", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"A", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{"T", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      SuperscriptBox[
       RowBox[{"f", "[", "r", "]"}], "2"]], ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"f", "[", "r", "]"}]], ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.482661206242777*^9, 3.4826612240707273`*^9}, {
   3.482665676264707*^9, 3.460345436476618*^9}, 3.482732920482984*^9, 
   3.4832683872309437`*^9, 3.4832748520751867`*^9, 3.483355851783144*^9, 
   3.495174844893948*^9, 3.497953183445979*^9, 3.4979535425295963`*^9, 
   3.501484229967771*^9, {3.5014865454883547`*^9, 3.460390566032054*^9}, 
   3.4604294389890823`*^9, 3.460429506493195*^9, {3.503999616253805*^9, 
   3.4603433757070503`*^9}, 3.460397743066276*^9, 3.460398248143712*^9, {
   3.460625318805606*^9, 3.4603660544298983`*^9}, 3.4603734042813787`*^9, 
   3.541435717627144*^9, 3.541441077040722*^9, 3.5419999091531487`*^9, 
   3.542001543768545*^9, 3.542470889806849*^9, 3.543558334209552*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "d", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"A", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{"T", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      SuperscriptBox[
       RowBox[{"f", "[", "r", "]"}], "2"]], ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"f", "[", "r", "]"}]], ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.482661206242777*^9, 3.4826612240707273`*^9}, {
   3.482665676264707*^9, 3.460345436476618*^9}, 3.482732920482984*^9, 
   3.4832683872309437`*^9, 3.4832748520751867`*^9, 3.483355851783144*^9, 
   3.495174844893948*^9, 3.497953183445979*^9, 3.4979535425295963`*^9, 
   3.501484229967771*^9, {3.5014865454883547`*^9, 3.460390566032054*^9}, 
   3.4604294389890823`*^9, 3.460429506493195*^9, {3.503999616253805*^9, 
   3.4603433757070503`*^9}, 3.460397743066276*^9, 3.460398248143712*^9, {
   3.460625318805606*^9, 3.4603660544298983`*^9}, 3.4603734042813787`*^9, 
   3.541435717627144*^9, 3.541441077040722*^9, 3.5419999091531487`*^9, 
   3.542001543768545*^9, 3.542470889806849*^9, 3.543558334254154*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"K", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"trT", "[", 
    RowBox[{
     RowBox[{"outerT", "[", 
      RowBox[{"q", ",", 
       RowBox[{"trT", "[", 
        RowBox[{
         RowBox[{"outerT", "[", 
          RowBox[{"q", ",", 
           RowBox[{"covDT", "[", "NormVec", "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"2", ",", "4"}], "}"}], "}"}]}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2", ",", "4"}], "}"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.482661293018702*^9, 3.4826613845439863`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"d", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["r", "2"]}], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"f", "[", "r", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", " ", "r", " ", 
              RowBox[{"F", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
              RowBox[{"\[CapitalDelta]", "[", 
               RowBox[{"r", ",", "a"}], "]"}], " ", 
              RowBox[{
               SuperscriptBox["f", "\[Prime]",
                MultilineFunction->None], "[", "r", "]"}]}], "-", 
             RowBox[{
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["r", "2"], " ", 
                 RowBox[{"A", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                RowBox[{"T", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["\[CapitalDelta]", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"r", ",", "a"}], "]"}], "+", 
                RowBox[{
                 RowBox[{"\[CapitalDelta]", "[", 
                  RowBox[{"r", ",", "a"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["T", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
             RowBox[{"a", " ", 
              RowBox[{"f", "[", "r", "]"}], " ", 
              RowBox[{"F", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"r", " ", 
                 RowBox[{
                  SuperscriptBox["\[CapitalDelta]", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                RowBox[{
                 RowBox[{"\[CapitalDelta]", "[", 
                  RowBox[{"r", ",", "a"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", 
                   RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
               ")"}]}]}], ")"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["a", "2"]}], " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox["r", "2"]}], " ", 
                   RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                  RowBox[{"T", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                SuperscriptBox["r", "2"], " ", 
                SuperscriptBox[
                 RowBox[{"F", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
               FractionBox[
                RowBox[{"4", " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
                RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
             RowBox[{"\[CapitalDelta]", "[", 
              RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}]}], ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"A", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{"T", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["\[CapitalDelta]", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"r", ",", "a"}], "]"}], "+", 
             RowBox[{
              RowBox[{"\[CapitalDelta]", "[", 
               RowBox[{"r", ",", "a"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["r", "2"], " ", 
                 RowBox[{
                  SuperscriptBox["A", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                RowBox[{
                 SuperscriptBox["T", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], ")"}]}]}], 
            ")"}]}], "+", 
          RowBox[{"a", " ", 
           RowBox[{"f", "[", "r", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "r", " ", 
              RowBox[{"\[CapitalDelta]", "[", 
               RowBox[{"r", ",", "a"}], "]"}], " ", 
              RowBox[{
               SuperscriptBox["F", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{
              RowBox[{"F", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "r"}], " ", 
                 RowBox[{
                  SuperscriptBox["\[CapitalDelta]", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                RowBox[{
                 RowBox[{"\[CapitalDelta]", "[", 
                  RowBox[{"r", ",", "a"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{
                    SuperscriptBox["r", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
               ")"}]}]}], ")"}]}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"f", "[", "r", "]"}], "2"], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["r", "2"]}], " ", 
                  RowBox[{"A", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                 RowBox[{"T", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
               SuperscriptBox["r", "2"], " ", 
               SuperscriptBox[
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
              FractionBox[
               RowBox[{"4", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
               RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["r", "2"]}], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", " ", 
          RowBox[{"F", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["r", "2"], " ", 
                RowBox[{"A", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{"T", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["\[CapitalDelta]", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"r", ",", "a"}], "]"}], "+", 
               RowBox[{
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["r", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{"a", " ", 
             RowBox[{"f", "[", "r", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", "r", " ", 
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{
                 SuperscriptBox["F", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "r"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{
                   RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["r", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                 ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", " ", 
          RowBox[{"f", "[", "r", "]"}], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["r", "2"]}], " ", 
                  RowBox[{"A", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                 RowBox[{"T", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
               SuperscriptBox["r", "2"], " ", 
               SuperscriptBox[
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
              FractionBox[
               RowBox[{"4", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
               RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}], ",", "0", ",", "0",
        ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["r", "2"]}], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", " ", 
          RowBox[{"F", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["r", "2"], " ", 
                RowBox[{"A", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{"T", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["\[CapitalDelta]", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"r", ",", "a"}], "]"}], "+", 
               RowBox[{
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["r", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{"a", " ", 
             RowBox[{"f", "[", "r", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", "r", " ", 
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{
                 SuperscriptBox["F", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "r"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{
                   RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["r", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                 ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", " ", 
          RowBox[{"f", "[", "r", "]"}], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["r", "2"]}], " ", 
                  RowBox[{"A", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                 RowBox[{"T", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
               SuperscriptBox["r", "2"], " ", 
               SuperscriptBox[
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
              FractionBox[
               RowBox[{"4", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
               RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["r", "2"], " ", 
               RowBox[{"A", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
              RowBox[{"T", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], ")"}]}]], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"F", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["r", "2"], " ", 
                RowBox[{"A", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{"T", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["\[CapitalDelta]", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"r", ",", "a"}], "]"}], "+", 
               RowBox[{
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["r", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{"a", " ", 
             RowBox[{"f", "[", "r", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", "r", " ", 
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{
                 SuperscriptBox["F", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "r"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{
                   RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["r", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                 ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["r", "2"]}], " ", 
                  RowBox[{"A", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                 RowBox[{"T", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
               SuperscriptBox["r", "2"], " ", 
               SuperscriptBox[
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
              FractionBox[
               RowBox[{"4", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
               RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}], ",", "0", ",", "0",
        ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", 
       RowBox[{"-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["r", "2"]}], " ", 
              RowBox[{"A", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{"S", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}], "-", 
             RowBox[{"T", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["r", "2"], " ", 
                 RowBox[{"A", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                RowBox[{"T", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
              RowBox[{"\[CapitalDelta]", "[", 
               RowBox[{"r", ",", "a"}], "]"}], " ", 
              RowBox[{
               SuperscriptBox["g", "\[Prime]",
                MultilineFunction->None], "[", "a", "]"}]}], "+", 
             RowBox[{
              RowBox[{"g", "[", "a", "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"a", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                    RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "-", 
                   RowBox[{"a", " ", "r", " ", 
                    RowBox[{"f", "[", "r", "]"}], " ", 
                    RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"\[CapitalDelta]", "[", 
                  RowBox[{"r", ",", "a"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                   RowBox[{"a", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                    RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", "r", " ", 
                    RowBox[{"f", "[", "r", "]"}], " ", 
                    RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
               ")"}]}]}], ")"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["a", "2"]}], " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox["r", "2"]}], " ", 
                   RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                  RowBox[{"T", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                SuperscriptBox["r", "2"], " ", 
                SuperscriptBox[
                 RowBox[{"F", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
               FractionBox[
                RowBox[{"4", " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
                RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
             RowBox[{"\[CapitalDelta]", "[", 
              RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}]}], ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["r", "2"]}], " ", 
              RowBox[{"A", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{"S", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}], "-", 
             RowBox[{"T", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["r", "2"], " ", 
                 RowBox[{"A", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                RowBox[{"T", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
              RowBox[{"\[CapitalDelta]", "[", 
               RowBox[{"r", ",", "a"}], "]"}], " ", 
              RowBox[{
               SuperscriptBox["g", "\[Prime]",
                MultilineFunction->None], "[", "a", "]"}]}], "+", 
             RowBox[{
              RowBox[{"g", "[", "a", "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"a", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                    RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "-", 
                   RowBox[{"a", " ", "r", " ", 
                    RowBox[{"f", "[", "r", "]"}], " ", 
                    RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"\[CapitalDelta]", "[", 
                  RowBox[{"r", ",", "a"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                   RowBox[{"a", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                    RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", "r", " ", 
                    RowBox[{"f", "[", "r", "]"}], " ", 
                    RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
               ")"}]}]}], ")"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["a", "2"]}], " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox["r", "2"]}], " ", 
                   RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                  RowBox[{"T", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                SuperscriptBox["r", "2"], " ", 
                SuperscriptBox[
                 RowBox[{"F", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
               FractionBox[
                RowBox[{"4", " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
                RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
             RowBox[{"\[CapitalDelta]", "[", 
              RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}]}], ",", "0"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["r", "2"]}], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{"S", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], "-", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
          SuperscriptBox["\[Theta]1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["r", "2"], " ", 
                RowBox[{"A", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{"T", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
             RowBox[{"\[CapitalDelta]", "[", 
              RowBox[{"r", ",", "a"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["g", "\[Prime]",
               MultilineFunction->None], "[", "a", "]"}]}], "+", 
            RowBox[{
             RowBox[{"g", "[", "a", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "-", 
                  RowBox[{"a", " ", "r", " ", 
                   RowBox[{"f", "[", "r", "]"}], " ", 
                   RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                  RowBox[{"a", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", "r", " ", 
                   RowBox[{"f", "[", "r", "]"}], " ", 
                   RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
              ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["r", "2"]}], " ", 
                  RowBox[{"A", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                 RowBox[{"T", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
               SuperscriptBox["r", "2"], " ", 
               SuperscriptBox[
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
              FractionBox[
               RowBox[{"4", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
               RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}]}], "}"}]}], "}"}]}],
   "}"}]], "Output",
 CellChangeTimes->{
  3.482661298062799*^9, {3.4826613789254103`*^9, 3.482661407354897*^9}, {
   3.482665680028101*^9, 3.4603454460941763`*^9}, 3.482732930365775*^9, 
   3.483268398775249*^9, 3.483274861473762*^9, 3.48335586118395*^9, 
   3.495174854349127*^9, 3.4979532134025087`*^9, 3.497953553172243*^9, 
   3.501484239811926*^9, {3.501486555298568*^9, 3.460390578166481*^9}, 
   3.4604294518046227`*^9, 3.4604295186905117`*^9, {3.503999633797913*^9, 
   3.460343388099977*^9}, {3.4603977842107477`*^9, 3.460397798548231*^9}, 
   3.460398265784686*^9, {3.4606253370668373`*^9, 3.460366073190826*^9}, 
   3.460373420824457*^9, 3.5414359951685543`*^9, 3.541441086697323*^9, 
   3.541999916758959*^9, 3.542001550117902*^9, 3.542470901348476*^9, 
   3.543558345123048*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Isreal", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"K", "-", 
     RowBox[{"kappa", " ", "q"}]}], ")"}], "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.482661408999899*^9, 3.460345429549082*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"T", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]]}], " ", "kappa", " ", 
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"f", "[", "r", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["r", "2"]}], " ", 
           RowBox[{"A", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"f", "[", "r", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "r", " ", 
            RowBox[{"F", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"r", ",", "a"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["f", "\[Prime]",
              MultilineFunction->None], "[", "r", "]"}]}], "-", 
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["r", "2"], " ", 
               RowBox[{"A", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
              RowBox[{"T", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["\[CapitalDelta]", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"r", ",", "a"}], "]"}], "+", 
              RowBox[{
               RowBox[{"\[CapitalDelta]", "[", 
                RowBox[{"r", ",", "a"}], "]"}], " ", 
               RowBox[{
                SuperscriptBox["T", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{"a", " ", 
            RowBox[{"f", "[", "r", "]"}], " ", 
            RowBox[{"F", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"r", " ", 
               RowBox[{
                SuperscriptBox["\[CapitalDelta]", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"r", ",", "a"}], "]"}]}], "+", 
              RowBox[{
               RowBox[{"\[CapitalDelta]", "[", 
                RowBox[{"r", ",", "a"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{"2", "+", 
                 RowBox[{"r", " ", 
                  RowBox[{
                   SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["a", "2"]}], " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["r", "2"]}], " ", 
                 RowBox[{"A", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                RowBox[{"T", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
              SuperscriptBox["r", "2"], " ", 
              SuperscriptBox[
               RowBox[{"F", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
             FractionBox[
              RowBox[{"4", " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["a", "2"], " ", 
                  RowBox[{"B", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                 RowBox[{"S", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
              RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
           RowBox[{"\[CapitalDelta]", "[", 
            RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}]}], ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["r", "2"], " ", 
            RowBox[{"A", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
           RowBox[{"T", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "kappa", " ", 
         RowBox[{"\[CapitalDelta]", "[", 
          RowBox[{"r", ",", "a"}], "]"}]}], 
        SuperscriptBox[
         RowBox[{"f", "[", "r", "]"}], "2"]]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["\[CapitalDelta]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"r", ",", "a"}], "]"}], "+", 
            RowBox[{
             RowBox[{"\[CapitalDelta]", "[", 
              RowBox[{"r", ",", "a"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["r", "2"], " ", 
                RowBox[{
                 SuperscriptBox["A", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{
                SuperscriptBox["T", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"a", " ", 
          RowBox[{"f", "[", "r", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "r", " ", 
             RowBox[{"\[CapitalDelta]", "[", 
              RowBox[{"r", ",", "a"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["F", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"F", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "r"}], " ", 
                RowBox[{
                 SuperscriptBox["\[CapitalDelta]", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"r", ",", "a"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", 
                  RowBox[{"2", " ", 
                   SuperscriptBox["r", "2"], " ", 
                   RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["r", "3"], " ", 
                   RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"r", " ", 
                   RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
              ")"}]}]}], ")"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"f", "[", "r", "]"}], "2"], " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["a", "2"]}], " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["r", "2"]}], " ", 
                 RowBox[{"A", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                RowBox[{"T", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
              SuperscriptBox["r", "2"], " ", 
              SuperscriptBox[
               RowBox[{"F", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
             FractionBox[
              RowBox[{"4", " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["a", "2"], " ", 
                  RowBox[{"B", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                 RowBox[{"S", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
              RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
           RowBox[{"\[CapitalDelta]", "[", 
            RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}]}], ",", "0"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"S", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", "kappa", " ", 
         RowBox[{"g", "[", "a", "]"}], " ", 
         RowBox[{"\[CapitalDelta]", "[", 
          RowBox[{"r", ",", "a"}], "]"}]}], 
        RowBox[{"1", "-", 
         SuperscriptBox["\[Theta]1", "2"]}]]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["r", "2"]}], " ", 
            RowBox[{"A", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "-", 
           RowBox[{"T", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["r", "2"], " ", 
               RowBox[{"A", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
              RowBox[{"T", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"r", ",", "a"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["g", "\[Prime]",
              MultilineFunction->None], "[", "a", "]"}]}], "+", 
           RowBox[{
            RowBox[{"g", "[", "a", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["\[ExponentialE]", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                  RowBox[{
                   SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"r", ",", "a"}], "]"}]}], "-", 
                 RowBox[{"a", " ", "r", " ", 
                  RowBox[{"f", "[", "r", "]"}], " ", 
                  RowBox[{"F", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"\[CapitalDelta]", "[", 
                RowBox[{"r", ",", "a"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", 
                  SuperscriptBox["\[ExponentialE]", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                 RowBox[{"a", " ", 
                  SuperscriptBox["\[ExponentialE]", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                  RowBox[{
                   SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                 RowBox[{
                  SuperscriptBox["a", "2"], " ", "r", " ", 
                  RowBox[{"f", "[", "r", "]"}], " ", 
                  RowBox[{"F", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["a", "2"]}], " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["r", "2"]}], " ", 
                 RowBox[{"A", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                RowBox[{"T", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
              SuperscriptBox["r", "2"], " ", 
              SuperscriptBox[
               RowBox[{"F", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
             FractionBox[
              RowBox[{"4", " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["a", "2"], " ", 
                  RowBox[{"B", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                 RowBox[{"S", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
              RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
           RowBox[{"\[CapitalDelta]", "[", 
            RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.482661417014008*^9, 3.4826614533611383`*^9}, {
   3.4826656802370787`*^9, 3.460345448910265*^9}, 3.482732930558614*^9, 
   3.483268399038637*^9, 3.483274861778748*^9, 3.483355861490382*^9, 
   3.4951748546348877`*^9, 3.4979532137836933`*^9, 3.497953553404372*^9, 
   3.5014842401084003`*^9, {3.501486555592925*^9, 3.4603905784484367`*^9}, 
   3.460429452117546*^9, 3.460429518846084*^9, {3.5039996340815783`*^9, 
   3.460343388292631*^9}, 3.460397799787715*^9, 3.4603982659972563`*^9, {
   3.4606253373449287`*^9, 3.460366073407278*^9}, 3.460373421073736*^9, 
   3.541435995372622*^9, 3.5414410868945427`*^9, 3.541999916909121*^9, 
   3.542001550292705*^9, 3.542470901536786*^9, 3.543558345298501*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"solIsreal", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"Isreal", "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["A", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.482665723842639*^9, 3.48266575809789*^9}, 
   3.482665845723934*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["T", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]], 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["r", "2"]}], " ", 
         RowBox[{"A", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
        RowBox[{"T", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"\[CapitalDelta]", "[", 
          RowBox[{"r", ",", "a"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["r", "2"], " ", 
               RowBox[{"A", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
              RowBox[{"T", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "kappa", " ", 
            SqrtBox[
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}], " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["r", "2"]}], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                   RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                 SuperscriptBox["r", "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"F", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
                FractionBox[
                 RowBox[{"4", " ", 
                  SuperscriptBox["\[ExponentialE]", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
                 RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
              RowBox[{"\[CapitalDelta]", "[", 
               RowBox[{"r", ",", "a"}], "]"}]}]]}], "+", 
           RowBox[{"a", " ", "r", " ", 
            RowBox[{"F", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["f", "\[Prime]",
              MultilineFunction->None], "[", "r", "]"}]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["r", "2"], " ", 
            RowBox[{"A", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
           RowBox[{"T", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
         RowBox[{
          SuperscriptBox["\[CapitalDelta]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"r", ",", "a"}], "]"}]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"f", "[", "r", "]"}], " ", 
         RowBox[{"F", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"r", " ", 
            RowBox[{
             SuperscriptBox["\[CapitalDelta]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"r", ",", "a"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"r", ",", "a"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{"2", "+", 
              RowBox[{"r", " ", 
               RowBox[{
                SuperscriptBox["T", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
          ")"}]}]}], ")"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["A", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"a", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["r", "2"]}], " ", 
          RowBox[{"A", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
         RowBox[{"T", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "r", " ", 
          RowBox[{"A", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
          RowBox[{"f", "[", "r", "]"}], " ", 
          RowBox[{"F", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{"f", "[", "r", "]"}], " ", 
          RowBox[{
           SuperscriptBox["F", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"F", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["f", "\[Prime]",
              MultilineFunction->None], "[", "r", "]"}], "+", 
            RowBox[{
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"f", "[", "r", "]"}], " ", 
             RowBox[{
              SuperscriptBox["A", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"f", "[", "r", "]"}], " ", 
             RowBox[{
              SuperscriptBox["T", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
        ")"}]}], "r"]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["S", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["2", "a"]}], "+", 
     RowBox[{"2", " ", "kappa", " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["a", "2"]}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["r", "2"]}], " ", 
              RowBox[{"A", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
             RowBox[{"T", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox[
            RowBox[{"F", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"]}], "+", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               RowBox[{"B", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
              RowBox[{"S", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
           RowBox[{"g", "[", "a", "]"}]]}], ")"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}]]}], "-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["g", "\[Prime]",
        MultilineFunction->None], "[", "a", "]"}], 
      RowBox[{"g", "[", "a", "]"}]], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"-", 
        RowBox[{
         SuperscriptBox["\[CapitalDelta]", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], "+", 
       RowBox[{"a", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["r", "2"]}], " ", 
           RowBox[{"A", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
          RowBox[{"T", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", " ", 
        RowBox[{"f", "[", "r", "]"}], " ", 
        RowBox[{"F", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[CapitalDelta]", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"r", ",", "a"}], "]"}]}]}], 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]], "+", 
     RowBox[{"a", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["r", "2"]}], " ", 
         RowBox[{"A", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
        RowBox[{"T", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", " ", 
      RowBox[{"f", "[", "r", "]"}], " ", 
      RowBox[{"F", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.482661462470347*^9, 3.482665680535009*^9, {3.482665759555162*^9, 
   3.4826657871545973`*^9}, {3.4826658483017178`*^9, 3.482665871597815*^9}, {
   3.482665919066064*^9, 3.460345454837998*^9}, 3.482732931482266*^9, 
   3.483268401446496*^9, 3.4832748627169867`*^9, 3.4833558624325027`*^9, 
   3.495174855633503*^9, 3.4979532237953367`*^9, 3.4979535545760937`*^9, 
   3.501484241110568*^9, {3.50148655658468*^9, 3.460390579727603*^9}, 
   3.460429453533163*^9, 3.460429520249406*^9, {3.5039996354994087`*^9, 
   3.4603433896990547`*^9}, 3.4603978066877623`*^9, {3.460398268575706*^9, 
   3.460398291311727*^9}, {3.46062534023184*^9, 3.460366076033289*^9}, 
   3.460373423557117*^9, 3.5414360808393583`*^9, 3.541441088813385*^9, 
   3.541999918323587*^9, 3.5420015516235657`*^9, 3.54247090303239*^9, 
   3.543558346755443*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"K", "-", 
      RowBox[{"kappa", " ", "q"}]}], ")"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}], "/.", "solIsreal"}], "]"}]], "Input",
 CellChangeTimes->{{3.482661472912682*^9, 3.482661480239296*^9}, 
   3.482665792043179*^9, {3.482665876225696*^9, 3.4603454642184143`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.482661476077997*^9, 3.4826614806459503`*^9}, 
   3.4826655401226187`*^9, 3.482665680753159*^9, {3.482665784118093*^9, 
   3.4826657925393353`*^9}, {3.482665873049391*^9, 3.482665876638081*^9}, {
   3.482665928655641*^9, 3.4603454649726057`*^9}, 3.482732931690959*^9, 
   3.4832684029767427`*^9, 3.48327486292334*^9, 3.483355862815412*^9, 
   3.495174856040447*^9, 3.497953286747328*^9, 3.4979535548150263`*^9, 
   3.501484241321064*^9, {3.501486556802676*^9, 3.460390579921055*^9}, 
   3.460429453805388*^9, 3.460429520440114*^9, {3.5039996358618603`*^9, 
   3.460343389903619*^9}, 3.46039780914758*^9, {3.4603982689*^9, 
   3.460398293591243*^9}, {3.460625340550242*^9, 3.460366076280569*^9}, 
   3.460373423870085*^9, 3.541436104665827*^9, 3.541441089112986*^9, 
   3.541441308541874*^9, 3.541999918517839*^9, 3.542001551796496*^9, 
   3.542470903238531*^9, 3.5435583469416533`*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dTIsreal", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["T", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"l", ",", "r", ",", "a"}], "]"}], "/.", "solIsreal"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dAIsreal", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["A", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"l", ",", "r", ",", "a"}], "]"}], "/.", "solIsreal"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dSIsreal", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["S", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}], "/.", "solIsreal"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.482665930411491*^9, 3.482665957890201*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{
  "T", ",", "A", ",", "B", ",", "F", ",", "S", ",", "\[CapitalDelta]", ",", 
   "f", ",", "g"}], "]"}]], "Input",
 CellChangeTimes->{{3.460345516539507*^9, 3.4603455189072943`*^9}, {
  3.483268409588434*^9, 3.4603983316148863`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalDelta]", "[", 
    RowBox[{"r_", ",", "a_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     FractionBox[
      RowBox[{" ", "1"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"a", "^", "2"}]}], ")"}], "+", 
       RowBox[{"rh", " ", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"r", "^", "2"}]}], ")"}], "]"}]}]}]], ")"}], "^", "2"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "r_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"r", "^", "2"}]}], ")"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g", "[", "a_", "]"}], ":=", 
  RowBox[{"2", "-", 
   RowBox[{"a", "^", "2"}]}]}]}], "Input",
 CellChangeTimes->{{3.503997037073781*^9, 3.503997076077972*^9}, {
   3.503997256891058*^9, 3.4603927524745617`*^9}, {3.460396639861096*^9, 
   3.4603966466740303`*^9}, {3.460397369545499*^9, 3.460397369641325*^9}, 
   3.5419999360283546`*^9, {3.542001574213739*^9, 3.542001627282452*^9}, {
   3.5424710054251957`*^9, 3.5424710055999823`*^9}, {3.542471038151218*^9, 
   3.542471097336067*^9}, {3.542471239152217*^9, 3.54247124238334*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"l_", ",", "r_", ",", "a_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"A", "[", 
    RowBox[{"l_", ",", "r_", ",", "a_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"B", "[", 
    RowBox[{"l_", ",", "r_", ",", "a_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{"l_", ",", "r_", ",", "a_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"F", "[", 
   RowBox[{"l_", ",", "r_", ",", "a_"}], "]"}], ":=", "0"}]}], "Input",
 CellChangeTimes->{{3.431856555245702*^9, 3.4318566047651167`*^9}, {
   3.431856648542349*^9, 3.431856678878977*^9}, 3.431856754902734*^9, {
   3.431856846342795*^9, 3.4318568575753117`*^9}, {3.431857245071002*^9, 
   3.431857306175378*^9}, {3.482669748664126*^9, 3.460345702164336*^9}, {
   3.4603458536450377`*^9, 3.4603458601381617`*^9}, {3.482733288623783*^9, 
   3.482733290614155*^9}, {3.483269034046699*^9, 3.46039835095335*^9}}],

Cell[CellGroupData[{

Cell[BoxData["Gd"], "Input",
 CellChangeTimes->{{3.4318562990518847`*^9, 3.4318563040834017`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["a", "2"], "+", 
         RowBox[{
          SqrtBox[
           RowBox[{"1", "-", 
            SuperscriptBox["r", "2"]}]], " ", "rh"}]}], ")"}], "2"]], ",", 
     "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox["1", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["a", "2"], "+", 
          RowBox[{
           SqrtBox[
            RowBox[{"1", "-", 
             SuperscriptBox["r", "2"]}]], " ", "rh"}]}], ")"}], "2"]}]], ",", 
     "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox["4", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "-", 
         SuperscriptBox["a", "2"]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["a", "2"], "+", 
          RowBox[{
           SqrtBox[
            RowBox[{"1", "-", 
             SuperscriptBox["r", "2"]}]], " ", "rh"}]}], ")"}], "2"]}]], ",", 
     "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "-", 
         SuperscriptBox["a", "2"]}], ")"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["a", "2"], "+", 
          RowBox[{
           SqrtBox[
            RowBox[{"1", "-", 
             SuperscriptBox["r", "2"]}]], " ", "rh"}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["\[Theta]1", "2"]}], ")"}]}]], ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "-", 
         SuperscriptBox["a", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["\[Theta]1", "2"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["a", "2"], "+", 
         RowBox[{
          SqrtBox[
           RowBox[{"1", "-", 
            SuperscriptBox["r", "2"]}]], " ", "rh"}]}], ")"}], "2"]], ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "-", 
         SuperscriptBox["a", "2"]}], ")"}], " ", 
       SuperscriptBox["\[Theta]1", "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["a", "2"], "+", 
         RowBox[{
          SqrtBox[
           RowBox[{"1", "-", 
            SuperscriptBox["r", "2"]}]], " ", "rh"}]}], ")"}], "2"]]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.431856299806117*^9, 3.431856304611355*^9}, 
   3.43185660646094*^9, {3.431856668146028*^9, 3.4318566798239098`*^9}, 
   3.431856756281083*^9, {3.431856851378639*^9, 3.4318568587390823`*^9}, 
   3.4318572796440897`*^9, 3.431857310614151*^9, 3.431857488475541*^9, 
   3.43186383046841*^9, {3.431864575945343*^9, 3.43186459225721*^9}, {
   3.4826697534554987`*^9, 3.4603058857155447`*^9}, 3.460345524905094*^9, {
   3.460345710014978*^9, 3.460345720395001*^9}, {3.460345766370194*^9, 
   3.460345898323473*^9}, 3.482733059260737*^9, {3.482733168248206*^9, 
   3.4827332202860317`*^9}, {3.4827332931225*^9, 3.482733303696246*^9}, 
   3.4832690369399757`*^9, 3.48327486352393*^9, 3.483355863435315*^9, 
   3.4951749890930567`*^9, 3.4951757302248774`*^9, 3.4979535731642513`*^9, 
   3.501484241984761*^9, {3.501486557501039*^9, 3.460390580561969*^9}, 
   3.460429454468693*^9, 3.460429521052533*^9, {3.5039996365546293`*^9, 
   3.460396665470531*^9}, {3.4603983376171103`*^9, 3.460398352352344*^9}, {
   3.460625341604653*^9, 3.460366077926231*^9}, 3.4603734240132103`*^9, 
   3.541436110032339*^9, 3.541441099367689*^9, 3.541441318493517*^9, 
   3.541999939835178*^9, {3.5420016099777203`*^9, 3.5420016293558903`*^9}, 
   3.542470909176784*^9, 3.5424710081112556`*^9, {3.542471040687715*^9, 
   3.542471055415699*^9}, 3.542471099637774*^9, 3.5424712467689657`*^9, 
   3.543558351557426*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"R2", "[", 
    RowBox[{"[", "2", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.43185661165845*^9, 3.431856617115055*^9}, {
  3.495175743829801*^9, 3.495175748260107*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         RowBox[{"12", " ", 
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}]}], "+", 
         SuperscriptBox["rh", "2"], "+", 
         RowBox[{
          SuperscriptBox["r", "4"], " ", 
          SuperscriptBox["rh", "2"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "3"}], "+", 
            SuperscriptBox["rh", "2"]}], ")"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["a", "2"], "+", 
         RowBox[{
          SqrtBox[
           RowBox[{"1", "-", 
            SuperscriptBox["r", "2"]}]], " ", "rh"}]}], ")"}], "2"]], ",", 
     "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        RowBox[{"12", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], "+", 
        SuperscriptBox["rh", "2"], "+", 
        RowBox[{
         SuperscriptBox["r", "4"], " ", 
         SuperscriptBox["rh", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "+", 
           SuperscriptBox["rh", "2"]}], ")"}]}]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           SuperscriptBox["a", "2"], "+", 
           RowBox[{
            SqrtBox[
             RowBox[{"1", "-", 
              SuperscriptBox["r", "2"]}]], " ", "rh"}]}], ")"}], "2"]}]]}], 
     ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "5"}], " ", 
           SqrtBox[
            RowBox[{"1", "-", 
             SuperscriptBox["r", "2"]}]]}], "+", 
          RowBox[{"4", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["a", "2"]}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "-", 
              SuperscriptBox["r", "2"]}], ")"}], 
            RowBox[{"5", "/", "2"}]], " ", 
           SuperscriptBox["rh", "2"]}]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", 
          SuperscriptBox["a", "2"]}], ")"}], " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          SuperscriptBox["r", "2"]}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           SuperscriptBox["a", "2"], "+", 
           RowBox[{
            SqrtBox[
             RowBox[{"1", "-", 
              SuperscriptBox["r", "2"]}]], " ", "rh"}]}], ")"}], "2"]}]]}], 
     ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         SuperscriptBox["a", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "5"}], " ", 
          SqrtBox[
           RowBox[{"1", "-", 
            SuperscriptBox["r", "2"]}]]}], "+", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["a", "2"]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "+", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "-", 
             SuperscriptBox["r", "2"]}], ")"}], 
           RowBox[{"5", "/", "2"}]], " ", 
          SuperscriptBox["rh", "2"]}]}], ")"}]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["r", "2"]}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["a", "2"], "+", 
          RowBox[{
           SqrtBox[
            RowBox[{"1", "-", 
             SuperscriptBox["r", "2"]}]], " ", "rh"}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[Theta]1", "2"]}], ")"}]}]], ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         SuperscriptBox["a", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "5"}], " ", 
          SqrtBox[
           RowBox[{"1", "-", 
            SuperscriptBox["r", "2"]}]]}], "+", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["a", "2"]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "+", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "-", 
             SuperscriptBox["r", "2"]}], ")"}], 
           RowBox[{"5", "/", "2"}]], " ", 
          SuperscriptBox["rh", "2"]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[Theta]1", "2"]}], ")"}]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["r", "2"]}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["a", "2"], "+", 
          RowBox[{
           SqrtBox[
            RowBox[{"1", "-", 
             SuperscriptBox["r", "2"]}]], " ", "rh"}]}], ")"}], "2"]}]], ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", 
          SuperscriptBox["a", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "5"}], " ", 
           SqrtBox[
            RowBox[{"1", "-", 
             SuperscriptBox["r", "2"]}]]}], "+", 
          RowBox[{"4", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["a", "2"]}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "2"], " ", "rh"}], "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "-", 
              SuperscriptBox["r", "2"]}], ")"}], 
            RowBox[{"5", "/", "2"}]], " ", 
           SuperscriptBox["rh", "2"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]1", "2"]}], 
       RowBox[{
        SqrtBox[
         RowBox[{"1", "-", 
          SuperscriptBox["r", "2"]}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           SuperscriptBox["a", "2"], "+", 
           RowBox[{
            SqrtBox[
             RowBox[{"1", "-", 
              SuperscriptBox["r", "2"]}]], " ", "rh"}]}], ")"}], "2"]}]]}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.431856612109056*^9, 3.431856617545108*^9}, {
   3.431856669110338*^9, 3.43185668056047*^9}, 3.4318567570686903`*^9, {
   3.43185685195039*^9, 3.431856859536584*^9}, 3.431857281994296*^9, 
   3.431857312269294*^9, 3.431857489402048*^9, 3.431863830741754*^9, {
   3.431864576559948*^9, 3.431864592971705*^9}, {3.482669754343588*^9, 
   3.460305885813504*^9}, 3.460345525658946*^9, {3.460345711044471*^9, 
   3.460345721250018*^9}, {3.4603457674496717`*^9, 3.4603458992770357`*^9}, 
   3.482733060910022*^9, {3.482733169058887*^9, 3.482733220990528*^9}, {
   3.482733294643722*^9, 3.4827333050289383`*^9}, 3.483269038429679*^9, 
   3.48327486429948*^9, 3.483355864232212*^9, {3.495175731817585*^9, 
   3.495175748940889*^9}, 3.4979535743164053`*^9, 3.501484242511442*^9, {
   3.501486558026291*^9, 3.460390581308337*^9}, 3.460429455226699*^9, 
   3.4604295218053217`*^9, {3.5039996369471693`*^9, 3.460396666231761*^9}, {
   3.4603983427130003`*^9, 3.460398354334934*^9}, {3.46062534233778*^9, 
   3.46036607911327*^9}, 3.4603734245461884`*^9, 3.541436112478109*^9, 
   3.541441101315751*^9, 3.5414413196570873`*^9, 3.541999940842259*^9, {
   3.542001612432392*^9, 3.542001630402379*^9}, 3.542470911661105*^9, 
   3.54247100941222*^9, {3.5424710422383757`*^9, 3.542471056275379*^9}, 
   3.5424711006623*^9, 3.542471250029956*^9, 3.5435583529482327`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Gd", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], "/", 
      RowBox[{"tmp", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "1", ",", "0"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Gd", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "2"}], "]"}], "]"}], "/", 
      RowBox[{"tmp", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "2"}], "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "1", ",", "0"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Gd", "[", 
       RowBox[{"[", 
        RowBox[{"3", ",", "3"}], "]"}], "]"}], "/", 
      RowBox[{"tmp", "[", 
       RowBox[{"[", 
        RowBox[{"3", ",", "3"}], "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "1", ",", "0"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Gd", "[", 
      RowBox[{"[", 
       RowBox[{"4", ",", "4"}], "]"}], "]"}], "/", 
     RowBox[{"tmp", "[", 
      RowBox[{"[", 
       RowBox[{"4", ",", "4"}], "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"r", ",", "1", ",", "0"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.495175750171129*^9, 3.495175863118318*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"r", "-", "1"}], "]"}], "1"],
    SeriesData[$CellContext`r, 1, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`r, 1, {
    Rational[-1, 5]}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.4951757555592823`*^9, 3.4951758634933643`*^9}, 
   3.497953575186244*^9, 3.5014842427337017`*^9, {3.501486558279105*^9, 
   3.460390581448168*^9}, 3.46042945545509*^9, 3.4604295222411613`*^9, {
   3.503999637223979*^9, 3.460396666725266*^9}, 3.460398360564671*^9, {
   3.460625342732732*^9, 3.460366079539329*^9}, 3.460373424618619*^9, 
   3.5414361141450157`*^9, 3.541441101425157*^9, 3.5414413210290823`*^9, 
   3.5419999416881332`*^9, {3.5420016150506773`*^9, 3.542001630956348*^9}, 
   3.542470915380619*^9, 3.542471010506748*^9, {3.542471042438725*^9, 
   3.5424710565844173`*^9}, 3.542471101568067*^9, 3.542471250944379*^9, 
   3.54355835396172*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"r", "-", "1"}], "]"}], "1"],
    SeriesData[$CellContext`r, 1, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`r, 1, {
    Rational[-1, 5]}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.4951757555592823`*^9, 3.4951758634933643`*^9}, 
   3.497953575186244*^9, 3.5014842427337017`*^9, {3.501486558279105*^9, 
   3.460390581448168*^9}, 3.46042945545509*^9, 3.4604295222411613`*^9, {
   3.503999637223979*^9, 3.460396666725266*^9}, 3.460398360564671*^9, {
   3.460625342732732*^9, 3.460366079539329*^9}, 3.460373424618619*^9, 
   3.5414361141450157`*^9, 3.541441101425157*^9, 3.5414413210290823`*^9, 
   3.5419999416881332`*^9, {3.5420016150506773`*^9, 3.542001630956348*^9}, 
   3.542470915380619*^9, 3.542471010506748*^9, {3.542471042438725*^9, 
   3.5424710565844173`*^9}, 3.542471101568067*^9, 3.542471250944379*^9, 
   3.543558353983008*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"r", "-", "1"}], "]"}], "1"],
    SeriesData[$CellContext`r, 1, {}, 0, 2, 2],
    Editable->False]}],
  SeriesData[$CellContext`r, 1, {
    Rational[-1, 5]}, 0, 2, 2],
  Editable->False]], "Output",
 CellChangeTimes->{{3.4951757555592823`*^9, 3.4951758634933643`*^9}, 
   3.497953575186244*^9, 3.5014842427337017`*^9, {3.501486558279105*^9, 
   3.460390581448168*^9}, 3.46042945545509*^9, 3.4604295222411613`*^9, {
   3.503999637223979*^9, 3.460396666725266*^9}, 3.460398360564671*^9, {
   3.460625342732732*^9, 3.460366079539329*^9}, 3.460373424618619*^9, 
   3.5414361141450157`*^9, 3.541441101425157*^9, 3.5414413210290823`*^9, 
   3.5419999416881332`*^9, {3.5420016150506773`*^9, 3.542001630956348*^9}, 
   3.542470915380619*^9, 3.542471010506748*^9, {3.542471042438725*^9, 
   3.5424710565844173`*^9}, 3.542471101568067*^9, 3.542471250944379*^9, 
   3.5435583540483227`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"r", "-", "1"}], "]"}], "1"],
    SeriesData[$CellContext`r, 1, {}, 0, 2, 2],
    Editable->False]}],
  SeriesData[$CellContext`r, 1, {
    Rational[-1, 5]}, 0, 2, 2],
  Editable->False]], "Output",
 CellChangeTimes->{{3.4951757555592823`*^9, 3.4951758634933643`*^9}, 
   3.497953575186244*^9, 3.5014842427337017`*^9, {3.501486558279105*^9, 
   3.460390581448168*^9}, 3.46042945545509*^9, 3.4604295222411613`*^9, {
   3.503999637223979*^9, 3.460396666725266*^9}, 3.460398360564671*^9, {
   3.460625342732732*^9, 3.460366079539329*^9}, 3.460373424618619*^9, 
   3.5414361141450157`*^9, 3.541441101425157*^9, 3.5414413210290823`*^9, 
   3.5419999416881332`*^9, {3.5420016150506773`*^9, 3.542001630956348*^9}, 
   3.542470915380619*^9, 3.542471010506748*^9, {3.542471042438725*^9, 
   3.5424710565844173`*^9}, 3.542471101568067*^9, 3.542471250944379*^9, 
   3.543558354049765*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"PowerExpand", "[", 
    RowBox[{"dTIsreal", "/.", 
     RowBox[{"{", 
      RowBox[{"a", "\[Rule]", "1"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SuperscriptBox["T", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "0", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"l", ",", "r", ",", "a"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", "1"}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.4826660049695663`*^9, 3.460345583983425*^9}, {
  3.48326906127791*^9, 3.483269063052622*^9}, {3.503999655173497*^9, 
  3.503999664163814*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "kappa"}], ")"}]}], 
  RowBox[{
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["r", "2"]}]], " ", "rh"}]]], "Output",
 CellChangeTimes->{{3.482666002998753*^9, 3.460345545267086*^9}, 
   3.460345584500978*^9, {3.482732966257142*^9, 3.482732974068698*^9}, 
   3.483268434285424*^9, {3.4832690509261723`*^9, 3.48326907357321*^9}, 
   3.483274864505567*^9, 3.483355864520975*^9, 3.495175868068644*^9, 
   3.497953575877347*^9, 3.501484242821018*^9, {3.501486558436138*^9, 
   3.460390581570344*^9}, 3.460429455591792*^9, 3.4604295223896513`*^9, {
   3.503999641076478*^9, 3.4603966687086887`*^9}, 3.460398365846327*^9, {
   3.460625342966423*^9, 3.460366080949621*^9}, 3.4603736388557873`*^9, 
   3.541436115376383*^9, 3.541441101832201*^9, 3.541441321888905*^9, 
   3.5419999618200607`*^9, {3.542001616660657*^9, 3.542001631821885*^9}, 
   3.5424709173093157`*^9, 3.542471011558948*^9, {3.542471043841131*^9, 
   3.5424710574994373`*^9}, 3.542471102587323*^9, 3.542471251996591*^9, 
   3.543558356365718*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.482666002998753*^9, 3.460345545267086*^9}, 
   3.460345584500978*^9, {3.482732966257142*^9, 3.482732974068698*^9}, 
   3.483268434285424*^9, {3.4832690509261723`*^9, 3.48326907357321*^9}, 
   3.483274864505567*^9, 3.483355864520975*^9, 3.495175868068644*^9, 
   3.497953575877347*^9, 3.501484242821018*^9, {3.501486558436138*^9, 
   3.460390581570344*^9}, 3.460429455591792*^9, 3.4604295223896513`*^9, {
   3.503999641076478*^9, 3.4603966687086887`*^9}, 3.460398365846327*^9, {
   3.460625342966423*^9, 3.460366080949621*^9}, 3.4603736388557873`*^9, 
   3.541436115376383*^9, 3.541441101832201*^9, 3.541441321888905*^9, 
   3.5419999618200607`*^9, {3.542001616660657*^9, 3.542001631821885*^9}, 
   3.5424709173093157`*^9, 3.542471011558948*^9, {3.542471043841131*^9, 
   3.5424710574994373`*^9}, 3.542471102587323*^9, 3.542471251996591*^9, 
   3.543558356367547*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"PowerExpand", "[", 
    RowBox[{"dAIsreal", "/.", 
     RowBox[{"{", 
      RowBox[{"a", "\[Rule]", "1"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SuperscriptBox["A", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "0", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"l", ",", "r", ",", "a"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", "1"}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.482666070226741*^9, 3.460345587991267*^9}, {
  3.48326906858265*^9, 3.483269071190339*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.48266607923127*^9, 3.4603455465431137`*^9}, 
   3.460345588475593*^9, {3.482732967356728*^9, 3.482732974550373*^9}, 
   3.4832684377323523`*^9, {3.483269051825616*^9, 3.483269074588484*^9}, 
   3.483274864614605*^9, 3.4833558645901203`*^9, 3.495175874063829*^9, 
   3.49795357656045*^9, 3.501484242904517*^9, {3.5014865585208*^9, 
   3.460390581654023*^9}, 3.460429455658146*^9, {3.4604295224678373`*^9, 
   3.460396670035489*^9}, 3.4603983667031393`*^9, {3.4606253431911573`*^9, 
   3.460366081696137*^9}, 3.460373639587226*^9, 3.5414361166147013`*^9, 
   3.541441102586293*^9, 3.541441322749959*^9, 3.54199996658967*^9, 
   3.542001634293983*^9, 3.542470918729003*^9, 3.542471013196254*^9, 
   3.542471045344537*^9, 3.542471103689702*^9, 3.542471253314855*^9, 
   3.543558357403185*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.48266607923127*^9, 3.4603455465431137`*^9}, 
   3.460345588475593*^9, {3.482732967356728*^9, 3.482732974550373*^9}, 
   3.4832684377323523`*^9, {3.483269051825616*^9, 3.483269074588484*^9}, 
   3.483274864614605*^9, 3.4833558645901203`*^9, 3.495175874063829*^9, 
   3.49795357656045*^9, 3.501484242904517*^9, {3.5014865585208*^9, 
   3.460390581654023*^9}, 3.460429455658146*^9, {3.4604295224678373`*^9, 
   3.460396670035489*^9}, 3.4603983667031393`*^9, {3.4606253431911573`*^9, 
   3.460366081696137*^9}, 3.460373639587226*^9, 3.5414361166147013`*^9, 
   3.541441102586293*^9, 3.541441322749959*^9, 3.54199996658967*^9, 
   3.542001634293983*^9, 3.542470918729003*^9, 3.542471013196254*^9, 
   3.542471045344537*^9, 3.542471103689702*^9, 3.542471253314855*^9, 
   3.543558357404941*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"Simplify", "[", 
    RowBox[{"PowerExpand", "[", 
     RowBox[{"dSIsreal", "/.", 
      RowBox[{"{", 
       RowBox[{"a", "\[Rule]", "1"}], "}"}]}], "]"}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SuperscriptBox["S", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "0", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"l", ",", "r", ",", "a"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", "1"}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.482666075081551*^9, 3.460345592223567*^9}, {
  3.483269070046768*^9, 3.483269071988899*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "kappa"}], ")"}]}], 
  RowBox[{
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["r", "2"]}]], " ", "rh"}]]], "Output",
 CellChangeTimes->{{3.482666077667183*^9, 3.46034559271469*^9}, 
   3.482732974983457*^9, 3.4832684392141113`*^9, {3.4832690526244993`*^9, 
   3.4832690752212152`*^9}, 3.483274864692976*^9, 3.483355864658546*^9, 
   3.495175875146338*^9, 3.497953577241666*^9, 3.501484242988212*^9, {
   3.501486558604127*^9, 3.460390581770792*^9}, 3.460429455741763*^9, {
   3.460429522539503*^9, 3.4603966708779287`*^9}, 3.460398372597919*^9, {
   3.46062534345389*^9, 3.46036608277871*^9}, 3.460373640202993*^9, 
   3.541436117831047*^9, 3.541441103588262*^9, 3.541441323734899*^9, 
   3.541999967658757*^9, 3.542001635245036*^9, 3.542470919747148*^9, 
   3.542471013980155*^9, 3.542471046127033*^9, 3.542471104725322*^9, 
   3.542471254200082*^9, 3.543558358320311*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.482666077667183*^9, 3.46034559271469*^9}, 
   3.482732974983457*^9, 3.4832684392141113`*^9, {3.4832690526244993`*^9, 
   3.4832690752212152`*^9}, 3.483274864692976*^9, 3.483355864658546*^9, 
   3.495175875146338*^9, 3.497953577241666*^9, 3.501484242988212*^9, {
   3.501486558604127*^9, 3.460390581770792*^9}, 3.460429455741763*^9, {
   3.460429522539503*^9, 3.4603966708779287`*^9}, 3.460398372597919*^9, {
   3.46062534345389*^9, 3.46036608277871*^9}, 3.460373640202993*^9, 
   3.541436117831047*^9, 3.541441103588262*^9, 3.541441323734899*^9, 
   3.541999967658757*^9, 3.542001635245036*^9, 3.542470919747148*^9, 
   3.542471013980155*^9, 3.542471046127033*^9, 3.542471104725322*^9, 
   3.542471254200082*^9, 3.543558358322178*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{
  "T", ",", "A", ",", "B", ",", "F", ",", "S", ",", "\[CapitalDelta]", ",", 
   "f", ",", "g"}], "]"}]], "Input",
 CellChangeTimes->{{3.4826661330887327`*^9, 3.460345623870998*^9}, {
  3.483269105684589*^9, 3.4603983849632893`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"H", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "d", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"S", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", 
                SuperscriptBox["a", "2"], " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                  RowBox[{"T", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  SuperscriptBox["\[ExponentialE]", 
                   RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], ")"}], " ", 
                SuperscriptBox["r", "2"], " ", 
                SuperscriptBox[
                 RowBox[{"F", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
                RowBox[{"g", "[", "a", "]"}], " ", 
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{
                 SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "r", "]"}]}], "+", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                SuperscriptBox["r", "3"], " ", 
                SuperscriptBox[
                 RowBox[{"F", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}], "3"], " ", 
                RowBox[{"g", "[", "a", "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"3", " ", "a", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
                   RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["g", "\[Prime]",
                    MultilineFunction->None], "[", "a", "]"}]}], "+", 
                  RowBox[{
                   RowBox[{"g", "[", "a", "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
                    RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"a", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]]}]}], ")"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
               "-", 
               RowBox[{"8", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["r", "2"], " ", 
                   RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                  RowBox[{"2", " ", 
                   RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}]], " ", 
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], ")"}], " ", 
                   RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "r", "]"}]}], "+", 
                  RowBox[{"a", " ", "r", " ", 
                   RowBox[{"g", "[", "a", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["F", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}], 
               "+", 
               RowBox[{"4", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                  RowBox[{"T", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", " ", 
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "a"}], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                   " ", 
                   RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["g", "\[Prime]",
                    MultilineFunction->None], "[", "a", "]"}]}], "-", 
                  RowBox[{
                   RowBox[{"g", "[", "a", "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"a", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                    " ", 
                    RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                    RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
                    RowBox[{"a", " ", 
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                    RowBox[{"a", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"T", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
             RowBox[{"f", "[", "r", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"4", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "5"}], " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}]}], 
                  "-", 
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "6"}], " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]]}], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                   " ", 
                   SuperscriptBox["r", "2"], " ", 
                   SuperscriptBox[
                    RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
                   RowBox[{"g", "[", "a", "]"}]}]}], ")"}], " ", 
                RowBox[{
                 SuperscriptBox["\[CapitalDelta]", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"r", ",", "a"}], "]"}]}], "+", 
               RowBox[{
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{"S", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"8", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   SuperscriptBox["r", "2"], " ", 
                   RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"4", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                    RowBox[{
                    SuperscriptBox["r", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", "r", " ", 
                    RowBox[{
                    SuperscriptBox["B", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                    RowBox[{"4", " ", "r", " ", 
                    RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}], 
                  "+", 
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   SuperscriptBox["r", "2"], " ", 
                   SuperscriptBox[
                    RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
                   RowBox[{"g", "[", "a", "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"2", "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                    RowBox[{"3", " ", "r", " ", 
                    RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                 ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"8", " ", "r", " ", 
          RowBox[{"f", "[", "r", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["r", "2"], " ", 
                RowBox[{"A", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                RowBox[{"B", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{"S", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
               RowBox[{"T", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["r", "2"], " ", 
             SuperscriptBox[
              RowBox[{"F", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
             RowBox[{"g", "[", "a", "]"}]}]}], ")"}], " ", 
          RowBox[{"\[CapitalDelta]", "[", 
           RowBox[{"r", ",", "a"}], "]"}]}], ")"}]}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"S", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "12"}], " ", "a", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["r", "2"], " ", 
                RowBox[{"A", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                RowBox[{"B", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                  RowBox[{"T", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], ")"}]}]}]], 
             " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 SuperscriptBox["a", "2"], " ", 
                 RowBox[{"B", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], ")"}], " ", 
             RowBox[{"\[CapitalDelta]", "[", 
              RowBox[{"r", ",", "a"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["g", "\[Prime]",
               MultilineFunction->None], "[", "a", "]"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["r", "2"], " ", 
             SuperscriptBox[
              RowBox[{"F", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
             SuperscriptBox[
              RowBox[{"g", "[", "a", "]"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "-", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]]}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                   " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"a", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]]}]}], ")"}], " ",
                    "r", " ", 
                   RowBox[{"f", "[", "r", "]"}], " ", 
                   RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{"S", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", 
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"f", "[", "r", "]"}], " ", 
                   RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", "r", " ", 
                   RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "r", "]"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "6"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
                    RowBox[{"3", " ", "a", " ", 
                    RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                    RowBox[{"a", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                 ")"}]}]}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"S", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
               RowBox[{"T", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
             RowBox[{"g", "[", "a", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "a", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "-", 
                    RowBox[{"5", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                   " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"a", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                   " ", "r", " ", 
                   RowBox[{"f", "[", "r", "]"}], " ", 
                   RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "24"}], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                  RowBox[{"24", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                  RowBox[{"8", " ", 
                   SuperscriptBox["a", "2"], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"4", " ", 
                   SuperscriptBox["a", "2"], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", 
                   " ", 
                   RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "r", "]"}]}], "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["a", "3"], " ", 
                   SuperscriptBox["r", "2"], " ", 
                   SuperscriptBox[
                    RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
                   RowBox[{
                    SuperscriptBox["g", "\[Prime]",
                    MultilineFunction->None], "[", "a", "]"}]}], "-", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["a", "3"], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   SuperscriptBox["r", "2"], " ", 
                   SuperscriptBox[
                    RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
                   RowBox[{
                    SuperscriptBox["g", "\[Prime]",
                    MultilineFunction->None], "[", "a", "]"}]}], "-", 
                  RowBox[{"4", " ", "a", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   SuperscriptBox["r", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"4", " ", 
                   SuperscriptBox["a", "3"], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{
                    SuperscriptBox["B", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                  RowBox[{"8", " ", "a", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                  RowBox[{"8", " ", "a", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                  RowBox[{"8", " ", 
                   SuperscriptBox["a", "2"], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{"f", "[", "r", "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "r"}], " ", 
                    RowBox[{
                    SuperscriptBox["F", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "-", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", "r", " ", 
                    RowBox[{
                    SuperscriptBox["B", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", " ", "a", " ", 
          RowBox[{"g", "[", "a", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["r", "2"], " ", 
                RowBox[{"A", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                RowBox[{"B", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{"S", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
               RowBox[{"T", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["r", "2"], " ", 
             SuperscriptBox[
              RowBox[{"F", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
             RowBox[{"g", "[", "a", "]"}]}]}], ")"}], " ", 
          RowBox[{"\[CapitalDelta]", "[", 
           RowBox[{"r", ",", "a"}], "]"}]}], ")"}]}], ",", "0", ",", "0", ",",
        "0"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.460398407838149*^9, 3.460366119400321*^9}, {
  3.46037366281181*^9, 3.4603736643764067`*^9}, {3.541422183301118*^9, 
  3.541422183837064*^9}, {3.5414361552517653`*^9, 3.5414361557525*^9}, {
  3.542000002539564*^9, 3.542000002979475*^9}, {3.542471274648193*^9, 
  3.5424712755677834`*^9}, {3.543557861940983*^9, 3.543557862811747*^9}, {
  3.543558362854939*^9, 3.543558363158985*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ha", "=", 
   RowBox[{"H", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "3"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.46039841150086*^9, 3.460398426585657*^9}, 
   3.542001657814129*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", "x_", "]"}], "\[Rule]", 
      RowBox[{"exp", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"T", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "T"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Tr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Ta"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Trr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Taa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Tra"}], ",", 
     RowBox[{
      RowBox[{"A", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "A"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Ar"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Aa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Arr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Aaa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Ara"}], ",", 
     RowBox[{
      RowBox[{"B", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "B"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Br"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Ba"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Brr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Baa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Bra"}], ",", 
     RowBox[{
      RowBox[{"F", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "F"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Fr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Fa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Frr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Faa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Fra"}], ",", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "S"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Sr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Sa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Srr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Saa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Sra"}], ",", 
     RowBox[{
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "L"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalDelta]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "Lr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalDelta]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "La"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalDelta]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "Lrr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalDelta]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "Laa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalDelta]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "Lra"}], ",", 
     RowBox[{
      RowBox[{"f", "[", "r", "]"}], "\[Rule]", "f"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "r", "]"}], "\[Rule]", "fr"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "''"}], "[", "r", "]"}], "\[Rule]", "frr"}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.4832692136536627`*^9, 3.483269213987788*^9}, {
   3.4832751292507677`*^9, 3.460398454774333*^9}, {3.4603985280494967`*^9, 
   3.460398532910939*^9}, 3.543558400648905*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "a_", "]"}], ":=", 
  RowBox[{"2", "-", 
   RowBox[{"a", "^", "2"}]}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"branebc", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Isreal", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "1"}], "]"}], "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"Isreal", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "2"}], "]"}], "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"Isreal", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "3"}], "]"}], "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{"Ha", "\[Equal]", "0"}]}], "}"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"F", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "0"}], ",", 
         " ", 
         RowBox[{
          RowBox[{
           SuperscriptBox["F", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "0"}], ",", 
         RowBox[{
          RowBox[{"F0", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "0"}], ",", 
         " ", 
         RowBox[{
          RowBox[{
           SuperscriptBox["F0", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "0"}]}], 
        "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["A", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["B", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.48266707001136*^9, 3.4826670844041433`*^9}, {
   3.482667139406938*^9, 3.482667230523843*^9}, {3.482667309733137*^9, 
   3.482667312371079*^9}, {3.4827334667867727`*^9, 3.482733467968947*^9}, 
   3.4832751207407207`*^9, {3.501486536145075*^9, 3.5014865400704603`*^9}, {
   3.5014866074003057`*^9, 3.501486607695694*^9}, {3.501486760018717*^9, 
   3.46039061266012*^9}, {3.46039075054535*^9, 3.460390754575364*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["T", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"4", " ", "kappa", " ", 
      SqrtBox[
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"B", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{"S", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
          RowBox[{"\[CapitalDelta]", "[", 
           RowBox[{"r", ",", "a"}], "]"}]}], 
         RowBox[{
          RowBox[{"-", "2"}], "+", 
          SuperscriptBox["a", "2"]}]]}]]}], "-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[CapitalDelta]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "a"}], "]"}], 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["A", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["S", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"4", " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["a", "2"], "-", 
         RowBox[{"2", " ", "a", " ", "kappa", " ", 
          SqrtBox[
           RowBox[{"-", 
            FractionBox[
             RowBox[{
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", 
                 RowBox[{"B", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                RowBox[{"S", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
              RowBox[{"\[CapitalDelta]", "[", 
               RowBox[{"r", ",", "a"}], "]"}]}], 
             RowBox[{
              RowBox[{"-", "2"}], "+", 
              SuperscriptBox["a", "2"]}]]}]]}], "+", 
         RowBox[{
          SuperscriptBox["a", "3"], " ", "kappa", " ", 
          SqrtBox[
           RowBox[{"-", 
            FractionBox[
             RowBox[{
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", 
                 RowBox[{"B", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                RowBox[{"S", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
              RowBox[{"\[CapitalDelta]", "[", 
               RowBox[{"r", ",", "a"}], "]"}]}], 
             RowBox[{
              RowBox[{"-", "2"}], "+", 
              SuperscriptBox["a", "2"]}]]}]]}]}], ")"}]}], "-", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         SuperscriptBox["a", "2"]}], ")"}], " ", 
       RowBox[{
        SuperscriptBox["\[CapitalDelta]", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]}], 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        SuperscriptBox["a", "2"]}], ")"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}]]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["B", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         SuperscriptBox["a", "2"]}], ")"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]], 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["r", "2"]}], " ", 
         RowBox[{"A", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
        RowBox[{"T", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["r", "2"], " ", 
            RowBox[{"A", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
           RowBox[{"T", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
         RowBox[{"\[CapitalDelta]", "[", 
          RowBox[{"r", ",", "a"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{"2", "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              RowBox[{"B", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "+", 
              RowBox[{"6", " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 SuperscriptBox["a", "2"], " ", 
                 RowBox[{"B", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}]}], 
           "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "+", 
              SuperscriptBox["a", "2"]}], ")"}], " ", 
            RowBox[{"B", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
           RowBox[{"16", " ", "a", " ", "kappa", " ", 
            SqrtBox[
             RowBox[{"-", 
              FractionBox[
               RowBox[{
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}]}], 
               RowBox[{
                RowBox[{"-", "2"}], "+", 
                SuperscriptBox["a", "2"]}]]}]]}], "-", 
           RowBox[{"8", " ", 
            SuperscriptBox["a", "3"], " ", "kappa", " ", 
            SqrtBox[
             RowBox[{"-", 
              FractionBox[
               RowBox[{
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}]}], 
               RowBox[{
                RowBox[{"-", "2"}], "+", 
                SuperscriptBox["a", "2"]}]]}]]}]}], ")"}]}], "-", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", 
           SuperscriptBox["a", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              RowBox[{"B", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{"S", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"A", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              RowBox[{"B", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{"S", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "-", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"A", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{"T", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["r", "2"], " ", 
               RowBox[{"A", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               RowBox[{"B", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
              RowBox[{"T", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["\[CapitalDelta]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"r", ",", "a"}], "]"}]}]}], ")"}]}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.482667044653289*^9, 3.482667085776701*^9, {3.482667203639865*^9, 
   3.482667231503536*^9}, {3.482667286507393*^9, 3.482667316247881*^9}, 
   3.482733809152215*^9, 3.483271718085187*^9, 3.4832751464180317`*^9, 
   3.4832752168022413`*^9, 3.497953801728058*^9, 3.5014865732368526`*^9, {
   3.501486608530643*^9, 3.501486615435408*^9}, {3.501486763855647*^9, 
   3.460390616769381*^9}, 3.46039075566882*^9, 3.460429456543686*^9, {
   3.460429523346076*^9, 3.460343390661408*^9}, 3.460398470949234*^9, {
   3.460625345509058*^9, 3.460366127059011*^9}, 3.460373669784206*^9, 
   3.541436165643277*^9, 3.5414411143518972`*^9, {3.541441336571858*^9, 
   3.541441365717493*^9}, 3.542000029785453*^9, 3.542001661764587*^9, {
   3.542471282771441*^9, 3.542471299806711*^9}, 3.543558374666609*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dTIsreal2", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], "/.", "branebc"}], ")"}], "/.", 
      RowBox[{"{", 
       RowBox[{"a", "\[Rule]", "1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dAIsreal2", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["A", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], "/.", "branebc"}], ")"}], "/.", 
      RowBox[{"{", 
       RowBox[{"a", "\[Rule]", "1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dSIsreal2", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], "/.", "branebc"}], ")"}], "/.", 
      RowBox[{"{", 
       RowBox[{"a", "\[Rule]", "1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dBIsreal2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["B", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], "/.", "branebc"}], ")"}], "/.", 
     RowBox[{"{", 
      RowBox[{"a", "\[Rule]", "1"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.482666329233589*^9, 3.482666346144124*^9}, {
  3.482667277855012*^9, 3.4826672960017023`*^9}, {3.483275159232574*^9, 
  3.483275197339058*^9}, {3.501486620352169*^9, 3.460390660146793*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"dTIsreal2", "//.", 
   RowBox[{"(", 
    RowBox[{"repl", "/.", 
     RowBox[{"{", 
      RowBox[{"a", "\[Rule]", "1"}], "}"}]}], ")"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.48266641384594*^9, 3.48266641504587*^9}, {
  3.482667322967722*^9, 3.482667327781455*^9}, {3.483275266606483*^9, 
  3.460398537128461*^9}}],

Cell["-(La/L) + 4*kappa*Sqrt(L*exp(B + S))", "Output",
 CellChangeTimes->{
  3.482666415517602*^9, 3.482666794568019*^9, 3.4826673280987673`*^9, 
   3.483275228496613*^9, {3.483275272880875*^9, 3.483275281805859*^9}, 
   3.497953815252033*^9, 3.501486623598599*^9, {3.5014867656342916`*^9, 
   3.460390662135989*^9}, {3.460390758239129*^9, 3.4603907831759243`*^9}, 
   3.460429456971951*^9, {3.460429523718811*^9, 3.460396744662808*^9}, 
   3.460398481675511*^9, {3.460398537638631*^9, 3.460398567326332*^9}, 
   3.460398721528507*^9, 3.4603987926405373`*^9, {3.46044333699896*^9, 
   3.4604433581229143`*^9}, {3.460443424124359*^9, 3.4603661334955597`*^9}, 
   3.460373674134122*^9, 3.541436172738799*^9, 3.541441120955653*^9, 
   3.542000048922336*^9, 3.542001668751718*^9, 3.542471304298812*^9, 
   3.5435583815488462`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"dAIsreal2", "//.", 
   RowBox[{"(", 
    RowBox[{"repl", "/.", 
     RowBox[{"{", 
      RowBox[{"a", "\[Rule]", "1"}], "}"}]}], ")"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4826673376389227`*^9, 3.482667337989561*^9}, {
  3.483275278518462*^9, 3.460398539589919*^9}}],

Cell["0", "Output",
 CellChangeTimes->{
  3.482667338373866*^9, 3.483275228535616*^9, 3.483275282171975*^9, 
   3.4979538153504343`*^9, 3.501486624558921*^9, {3.501486766050523*^9, 
   3.460390662683133*^9}, {3.46039075875778*^9, 3.4603907836909*^9}, 
   3.460429457025646*^9, {3.4604295238021*^9, 3.460396745416786*^9}, 
   3.4603984832414103`*^9, {3.4603985401685*^9, 3.4603985679761667`*^9}, 
   3.4603987224440737`*^9, 3.4603987932752523`*^9, 3.4604433595028353`*^9, {
   3.4604434247562847`*^9, 3.4603661345595903`*^9}, 3.4603736749474277`*^9, 
   3.541436173974338*^9, 3.5414411218567953`*^9, 3.542000050224688*^9, 
   3.542001669553392*^9, 3.54247130526659*^9, 3.54355838258361*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"dSIsreal2", "//.", 
   RowBox[{"(", 
    RowBox[{"repl", "/.", 
     RowBox[{"{", 
      RowBox[{"a", "\[Rule]", "1"}], "}"}]}], ")"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.482667340605547*^9, 3.4826673412141447`*^9}, {
  3.48327527959868*^9, 3.4603985424379396`*^9}}],

Cell["-(La/L) + 4*kappa*Sqrt(L*exp(B + S))", "Output",
 CellChangeTimes->{
  3.482667342536359*^9, 3.483275228573588*^9, 3.483275282554603*^9, 
   3.497953815435*^9, 3.5014866253402767`*^9, {3.5014867665165863`*^9, 
   3.460390663214652*^9}, {3.460390759490076*^9, 3.460390784224037*^9}, 
   3.460429457070241*^9, {3.460429523885563*^9, 3.46039674606059*^9}, 
   3.460398509648984*^9, {3.460398542949649*^9, 3.460398568542313*^9}, 
   3.46039872322698*^9, 3.460398793908359*^9, {3.4604434345359907`*^9, 
   3.460366135191689*^9}, 3.460373675530223*^9, 3.541436176517158*^9, 
   3.5414411227589617`*^9, 3.542000051644436*^9, 3.542001670186236*^9, 
   3.542471306369401*^9, 3.543558383419289*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"dBIsreal2", "//.", 
   RowBox[{"(", 
    RowBox[{"repl", "/.", 
     RowBox[{"{", 
      RowBox[{"a", "\[Rule]", "1"}], "}"}]}], ")"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4603906688163757`*^9, 3.460390669142168*^9}, 
   3.4603985449821978`*^9}],

Cell["\<\
-((2*B*L - 16*kappa*L*Sqrt(L*exp(B + S)) + La*(-1 + 3*exp(B) + exp(B + S - T) \
+ exp(B - A*Power(r,2) + S - T)))/L)\
\>", "Output",
 CellChangeTimes->{
  3.460390669821198*^9, {3.460390760055357*^9, 3.460390784721488*^9}, 
   3.460429457117324*^9, {3.4604295239956408`*^9, 3.460396746677823*^9}, {
   3.460398521386175*^9, 3.46039856914085*^9}, 3.460398724058107*^9, 
   3.460398794522999*^9, {3.460443435183792*^9, 3.460366135788519*^9}, 
   3.460373678491181*^9, 3.541436177381538*^9, 3.5414411252476254`*^9, 
   3.541441447125638*^9, 3.54200005252204*^9, 3.542001670922904*^9, 
   3.5424713074054613`*^9, 3.54355838425366*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalDelta]", "[", 
    RowBox[{"r_", ",", "a_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     FractionBox[
      RowBox[{" ", "1"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"a", "^", "2"}]}], ")"}], "+", 
       RowBox[{"rh", " ", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"r", "^", "2"}]}], ")"}], "]"}]}]}]], ")"}], "^", "2"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "r_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"r", "^", "2"}]}], ")"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g", "[", "a_", "]"}], ":=", 
  RowBox[{"2", "-", 
   RowBox[{"a", "^", "2"}]}]}]}], "Input",
 CellChangeTimes->{{3.503997037073781*^9, 3.503997076077972*^9}, {
   3.503997256891058*^9, 3.4603927524745617`*^9}, {3.460396639861096*^9, 
   3.4603966466740303`*^9}, {3.460397369545499*^9, 3.460397369641325*^9}, 
   3.542000056801694*^9, 3.542001682249229*^9, {3.542471312494042*^9, 
   3.542471313029801*^9}, 3.542471348925845*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "dTIsreal2", "]"}]], "Input",
 CellChangeTimes->{{3.4606255120118237`*^9, 3.460625512400996*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"4", " ", "kappa", " ", 
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"B", "[", 
         RowBox[{"l", ",", "r", ",", "1"}], "]"}], "+", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "1"}], "]"}]}]], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SuperscriptBox["rh", "2"]}]]}]]}], "-", 
  FractionBox["4", 
   RowBox[{
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["r", "2"]}]], " ", "rh"}]]}]], "Output",
 CellChangeTimes->{{3.460625512843505*^9, 3.460366173436043*^9}, 
   3.460373683679315*^9, 3.5414362046277647`*^9, 3.541436280218103*^9, 
   3.541441487607409*^9, 3.5420000583587313`*^9, 3.542001684194853*^9, 
   3.5424713512329683`*^9, 3.5435584082606153`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "dBIsreal2", "]"}]], "Input",
 CellChangeTimes->{{3.460625523249559*^9, 3.460625527177558*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["r", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "[", 
             RowBox[{"l", ",", "r", ",", "1"}], "]"}]]}], "+", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"B", "[", 
             RowBox[{"l", ",", "r", ",", "1"}], "]"}], "+", 
            RowBox[{"S", "[", 
             RowBox[{"l", ",", "r", ",", "1"}], "]"}], "-", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "1"}], "]"}]}]], "+", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["r", "2"]}], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "1"}], "]"}]}], "+", 
            RowBox[{"B", "[", 
             RowBox[{"l", ",", "r", ",", "1"}], "]"}], "+", 
            RowBox[{"S", "[", 
             RowBox[{"l", ",", "r", ",", "1"}], "]"}], "-", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "1"}], "]"}]}]]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["r", "2"]}], ")"}], 
        RowBox[{"3", "/", "2"}]]], "+", 
      FractionBox[
       RowBox[{"8", " ", "kappa", " ", 
        SqrtBox[
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"B", "[", 
              RowBox[{"l", ",", "r", ",", "1"}], "]"}], "+", 
             RowBox[{"S", "[", 
              RowBox[{"l", ",", "r", ",", "1"}], "]"}]}]], 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], " ", 
            SuperscriptBox["rh", "2"]}]]}]], " ", "rh"}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["r", "2"]}]], "+", 
      FractionBox[
       RowBox[{"rh", " ", 
        RowBox[{"B", "[", 
         RowBox[{"l", ",", "r", ",", "1"}], "]"}]}], 
       RowBox[{"1", "-", 
        SuperscriptBox["r", "2"]}]]}], ")"}]}], "rh"]}]], "Output",
 CellChangeTimes->{{3.4606255239717083`*^9, 3.460366178022009*^9}, 
   3.46037368609914*^9, 3.54143620618091*^9, 3.541436280903458*^9, 
   3.5414414935721893`*^9, 3.542000060053234*^9, 3.5420016860981693`*^9, 
   3.542471352689063*^9, 3.543558409465165*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "dSIsreal2", "]"}]], "Input",
 CellChangeTimes->{{3.460625520788066*^9, 3.4606255211132517`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"4", " ", "kappa", " ", 
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"B", "[", 
         RowBox[{"l", ",", "r", ",", "1"}], "]"}], "+", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "1"}], "]"}]}]], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SuperscriptBox["rh", "2"]}]]}]]}], "-", 
  FractionBox["4", 
   RowBox[{
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["r", "2"]}]], " ", "rh"}]]}]], "Output",
 CellChangeTimes->{{3.460625524704646*^9, 3.4603661835630198`*^9}, 
   3.460373686956915*^9, 3.5414362123672247`*^9, 3.541436281952195*^9, 
   3.541441494919517*^9, 3.542000061214082*^9, 3.542001691375708*^9, 
   3.54247135419643*^9, 3.54355841033806*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dTIsreal3", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"dTIsreal2", "/.", 
     RowBox[{"{", 
      RowBox[{"kappa", "\[Rule]", "1"}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"0", "<", "r", "<", "1"}], ",", 
      RowBox[{"rh", ">", "0"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.460625536756385*^9, 3.460625568437166*^9}, {
   3.460625604973116*^9, 3.460625648343101*^9}, {3.541436297202507*^9, 
   3.5414363166615887`*^9}, {3.541436346981732*^9, 3.541436357092629*^9}, {
   3.542000071973475*^9, 3.542000091226808*^9}, {3.542001707227441*^9, 
   3.542001731860798*^9}, {3.5424713627909946`*^9, 3.542471380412365*^9}, {
   3.542471438596756*^9, 3.54247144109974*^9}, 3.543558452326651*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox[
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"B", "[", 
         RowBox[{"l", ",", "r", ",", "1"}], "]"}], "+", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "1"}], "]"}]}]]]}], ")"}]}], 
  RowBox[{
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["r", "2"]}]], " ", "rh"}]]], "Output",
 CellChangeTimes->{{3.460625648971847*^9, 3.4603662250124826`*^9}, 
   3.460366321055632*^9, 3.4603737283245907`*^9, 3.541436358251173*^9, 
   3.541441501104067*^9, 3.542000093870826*^9, 3.542000159245166*^9, {
   3.54200173290197*^9, 3.5420017442673264`*^9}, 3.5420017816417847`*^9, 
   3.542471381705497*^9, {3.542471441885741*^9, 3.5424714688291903`*^9}, 
   3.5435584560245132`*^9, 3.5435585471555862`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dBIsreal3", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"dBIsreal2", "/.", 
     RowBox[{"{", 
      RowBox[{"kappa", "\[Rule]", "1"}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"0", "<", "r", "<", "1"}], ",", 
      RowBox[{"rh", ">", "0"}], ",", 
      RowBox[{
       RowBox[{"B", "[", 
        RowBox[{"l", ",", "r", ",", "1"}], "]"}], ">", "0"}], ",", 
      RowBox[{
       RowBox[{"S", "[", 
        RowBox[{"l", ",", "r", ",", "1"}], "]"}], ">", "0"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.460625549187962*^9, 3.460625575258387*^9}, {
  3.460625641361923*^9, 3.4603662186320887`*^9}, {3.460373784286346*^9, 
  3.460373868359831*^9}, {3.541436365656349*^9, 3.541436414753993*^9}, {
  3.542000100670162*^9, 3.542000137744828*^9}, {3.5420017479170847`*^9, 
  3.542001778692506*^9}, {3.5424713988131332`*^9, 3.542471411447419*^9}, {
  3.54247146023982*^9, 3.542471464207798*^9}, {3.543558461893446*^9, 
  3.5435585380168533`*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["r", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"8", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"B", "[", 
              RowBox[{"l", ",", "r", ",", "1"}], "]"}], "+", 
             RowBox[{"S", "[", 
              RowBox[{"l", ",", "r", ",", "1"}], "]"}]}], ")"}]}]]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           SuperscriptBox["r", "2"]}], ")"}], 
         RowBox[{"3", "/", "2"}]]]}], "+", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"B", "[", 
             RowBox[{"l", ",", "r", ",", "1"}], "]"}]]}], "+", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"B", "[", 
             RowBox[{"l", ",", "r", ",", "1"}], "]"}], "+", 
            RowBox[{"S", "[", 
             RowBox[{"l", ",", "r", ",", "1"}], "]"}], "-", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "1"}], "]"}]}]], "+", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["r", "2"]}], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "1"}], "]"}]}], "+", 
            RowBox[{"B", "[", 
             RowBox[{"l", ",", "r", ",", "1"}], "]"}], "+", 
            RowBox[{"S", "[", 
             RowBox[{"l", ",", "r", ",", "1"}], "]"}], "-", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "1"}], "]"}]}]]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["r", "2"]}], ")"}], 
        RowBox[{"3", "/", "2"}]]], "+", 
      FractionBox[
       RowBox[{"rh", " ", 
        RowBox[{"B", "[", 
         RowBox[{"l", ",", "r", ",", "1"}], "]"}]}], 
       RowBox[{"1", "-", 
        SuperscriptBox["r", "2"]}]]}], ")"}]}], "rh"]}]], "Output",
 CellChangeTimes->{{3.460625662125121*^9, 3.460366230839263*^9}, 
   3.460366321805863*^9, {3.460373728065942*^9, 3.460373728502384*^9}, {
   3.460373800413118*^9, 3.460373823992545*^9}, 3.46037386929993*^9, 
   3.541436417251422*^9, 3.5414415035596237`*^9, {3.542000116139043*^9, 
   3.542000159933257*^9}, {3.542001779433329*^9, 3.542001782629992*^9}, 
   3.542471416903139*^9, {3.542471465303051*^9, 3.542471469527287*^9}, {
   3.543558466181735*^9, 3.543558547804779*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dSIsreal3", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"dSIsreal2", "/.", 
     RowBox[{"{", 
      RowBox[{"kappa", "\[Rule]", "1"}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"0", "<", "r", "<", "1"}], ",", 
      RowBox[{"rh", ">", "0"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4606255540100203`*^9, 3.4606255707253733`*^9}, {
   3.4606256289083157`*^9, 3.460625657113338*^9}, {3.542000134498847*^9, 
   3.542000157140596*^9}, 3.54200174261581*^9, {3.54247142633399*^9, 
   3.542471435900934*^9}, {3.543558542850759*^9, 3.543558544424521*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox[
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"B", "[", 
         RowBox[{"l", ",", "r", ",", "1"}], "]"}], "+", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "1"}], "]"}]}]]]}], ")"}]}], 
  RowBox[{
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["r", "2"]}]], " ", "rh"}]]], "Output",
 CellChangeTimes->{
  3.46062565762213*^9, {3.460628959979411*^9, 3.460366237022523*^9}, 
   3.46036632247007*^9, 3.460373728736845*^9, 3.460373870876129*^9, 
   3.541436430841872*^9, 3.541441504278008*^9, {3.542000157709217*^9, 
   3.542000160815113*^9}, 3.542001745785475*^9, 3.542001783378298*^9, 
   3.542471427372732*^9, {3.542471466516295*^9, 3.5424714702605543`*^9}, {
   3.543558544889427*^9, 3.543558548377769*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", "dTIsreal3", "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"kappa", "\[Rule]", "1"}], ",", 
    RowBox[{
     RowBox[{"T", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"B", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"S", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{"rh", "\[Rule]", "0.1"}], ",", 
    RowBox[{"r", "\[Rule]", "0.4"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.4606254077699423`*^9, 3.460625435956171*^9}, {
  3.460625493401075*^9, 3.460625494994617*^9}, {3.460625681515357*^9, 
  3.460625681616694*^9}}],

Cell[BoxData["0.`"], "Output",
 CellChangeTimes->{{3.460625414026751*^9, 3.460625445961567*^9}, 
   3.460625495427803*^9, {3.460625681990081*^9, 3.4603662397990313`*^9}, 
   3.460373729723818*^9, 3.46037387159062*^9, 3.541436436286734*^9, 
   3.541441505306881*^9, 3.542000164112796*^9, 3.542001785598373*^9, 
   3.542471473562339*^9, 3.543558552568088*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", "dBIsreal3", "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"kappa", "\[Rule]", "1"}], ",", 
    RowBox[{
     RowBox[{"T", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"B", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"S", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{"rh", "\[Rule]", "0.1"}], ",", 
    RowBox[{"r", "\[Rule]", "0.4"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.460625454755323*^9, 3.4606254816132298`*^9}, {
  3.46062568361998*^9, 3.460625683699692*^9}}],

Cell[BoxData["0.`"], "Output",
 CellChangeTimes->{{3.460625466018849*^9, 3.4606254964589977`*^9}, {
   3.460625684260768*^9, 3.460366240688037*^9}, 3.460373730415722*^9, 
   3.460373872313497*^9, 3.541436438184041*^9, 3.541441507037529*^9, 
   3.542000166098158*^9, 3.542471480660482*^9, 3.543558556488125*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", "dSIsreal3", "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"kappa", "\[Rule]", "1"}], ",", 
    RowBox[{
     RowBox[{"T", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"B", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"S", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{"rh", "\[Rule]", "0.1"}], ",", 
    RowBox[{"r", "\[Rule]", "0.4"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.46062545974542*^9, 3.460625487938364*^9}, {
  3.460625685700068*^9, 3.4606256858647614`*^9}}],

Cell[BoxData["0.`"], "Output",
 CellChangeTimes->{{3.46062546628301*^9, 3.4606254969425983`*^9}, 
   3.460625686629319*^9, {3.460626903293795*^9, 3.460366241492592*^9}, 
   3.460373731020234*^9, 3.460373872988452*^9, 3.541436439342022*^9, 
   3.5414415070940847`*^9, 3.542000166159018*^9, 3.542471480743539*^9, 
   3.543558556573065*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dTIsreal3", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"T", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "T"}], ",", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "A"}], ",", 
    RowBox[{
     RowBox[{"B", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "B"}], ",", 
    RowBox[{
     RowBox[{"S", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "S"}]}], 
   "}"}]}]], "Input",
 CellChangeTimes->{{3.460366326404954*^9, 3.460366343806595*^9}, {
  3.460366440854886*^9, 3.460366459298997*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox[
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"B", "+", "S"}]]]}], ")"}]}], 
  RowBox[{
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["r", "2"]}]], " ", "rh"}]]], "Output",
 CellChangeTimes->{3.4603663443754873`*^9, 3.460366465176065*^9, 
  3.46037373175141*^9, 3.4603738736664762`*^9, 3.54143644301832*^9, 
  3.54144150782841*^9, 3.542000167528801*^9, 3.542471490029846*^9, 
  3.543558562150971*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dSIsreal3", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"T", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "T"}], ",", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "A"}], ",", 
    RowBox[{
     RowBox[{"B", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "B"}], ",", 
    RowBox[{
     RowBox[{"S", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "S"}]}], 
   "}"}]}]], "Input",
 CellChangeTimes->{{3.460366353302204*^9, 3.460366361406906*^9}, {
  3.46036644791894*^9, 3.460366462758285*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox[
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"B", "+", "S"}]]]}], ")"}]}], 
  RowBox[{
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["r", "2"]}]], " ", "rh"}]]], "Output",
 CellChangeTimes->{3.460366361872528*^9, 3.460366465847497*^9, 
  3.460373732381997*^9, 3.460373874583239*^9, 3.541436444003272*^9, 
  3.541441508547065*^9, 3.54200016866442*^9, 3.542471491981908*^9, 
  3.543558563053483*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"dBIsreal3", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"T", "[", 
       RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "T"}], ",", 
     RowBox[{
      RowBox[{"A", "[", 
       RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "A"}], ",", 
     RowBox[{
      RowBox[{"B", "[", 
       RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "B"}], ",", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "S"}]}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.4603663549147167`*^9, 3.460366355238681*^9}, {
  3.46036644907089*^9, 3.460366463895072*^9}, {3.460373882356413*^9, 
  3.4603738840598507`*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["r", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"8", " ", 
         SuperscriptBox["\[ExponentialE]", 
          FractionBox[
           RowBox[{"B", "+", "S"}], "2"]]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           SuperscriptBox["r", "2"]}], ")"}], 
         RowBox[{"3", "/", "2"}]]]}], "+", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["\[ExponentialE]", "B"]}], "+", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "+", "S", "-", "T"}]], "+", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "-", 
            RowBox[{"A", " ", 
             SuperscriptBox["r", "2"]}], "+", "S", "-", "T"}]]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["r", "2"]}], ")"}], 
        RowBox[{"3", "/", "2"}]]], "+", 
      FractionBox[
       RowBox[{"B", " ", "rh"}], 
       RowBox[{"1", "-", 
        SuperscriptBox["r", "2"]}]]}], ")"}]}], "rh"]}]], "Output",
 CellChangeTimes->{{3.460366358112462*^9, 3.460366362736011*^9}, 
   3.4603664664965277`*^9, 3.460373733047374*^9, {3.460373879873641*^9, 
   3.4603738846336823`*^9}, 3.54143644592511*^9, 3.541441509444298*^9, 
   3.5420001705037394`*^9, 3.54247149316492*^9, 3.543558564152191*^9}]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
RS **6d** - Isreal conditions - Ansatz 2\
\>", "Subtitle",
 CellChangeTimes->{{3.408796983010241*^9, 3.408796989128707*^9}, {
  3.415942197687789*^9, 3.415942199707787*^9}, {3.428318203595373*^9, 
  3.4283182110266533`*^9}, {3.4318556687961187`*^9, 3.431855668994246*^9}, {
  3.48266555323216*^9, 3.482665557150345*^9}, {3.54247053787271*^9, 
  3.5424705411027308`*^9}, {3.543558985731655*^9, 3.543558991880467*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", "\"\<hmm\>\"", "]"}]], "Input"],

Cell[BoxData["\<\"hmm\"\>"], "Print",
 CellChangeTimes->{
  3.426737013194791*^9, 3.4283151938180532`*^9, 3.428315553265912*^9, 
   3.428316879668502*^9, 3.4284038946466827`*^9, 3.4318556782327433`*^9, 
   3.431863726574562*^9, 3.482645295101799*^9, 3.4826453579432173`*^9, 
   3.482645464070413*^9, 3.4826465354634857`*^9, 3.482646576278145*^9, 
   3.4826543007333717`*^9, 3.482660738510792*^9, {3.482665665778748*^9, 
   3.460345345005185*^9}, 3.482732899833189*^9, 3.4832683038376827`*^9, 
   3.483274829836521*^9, 3.483355830278619*^9, 3.495174822655376*^9, 
   3.497953162440522*^9, 3.497953487871752*^9, 3.501484207182074*^9, {
   3.501486522498592*^9, 3.4603905367302732`*^9}, 3.460429409024069*^9, 
   3.460429476669972*^9, {3.503999598758216*^9, 3.460343345971778*^9}, 
   3.460397493489051*^9, 3.4603981921980867`*^9, {3.460625262680915*^9, 
   3.4603659342380543`*^9}, 3.46037335064213*^9, 3.54143569407403*^9, 
   3.5414410133826447`*^9, 3.541999845932349*^9, 3.542001525695931*^9, 
   3.542470829342547*^9, 3.5435582916327868`*^9, 3.543559040434317*^9, 
   3.543560091671659*^9, 3.543560243298805*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRSetup2.nb - modified", "Subsubtitle",
 CellChangeTimes->{{3.478330969800351*^9, 3.478330971159855*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Latest", " ", "Version"}], " ", "*)"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"{", 
    RowBox[{
    "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
     "gzz"}], "}"}]}], "\n"}], "\n", 
 RowBox[{"Gd", "=", 
  RowBox[{"DiagonalMatrix", "[", "metric", "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
   "gzz"}], "}"}]], "Output",
 CellChangeTimes->{
  3.466315297140045*^9, 3.478330988195435*^9, 3.478416452606082*^9, 
   3.478847548608172*^9, {3.478929911283174*^9, 3.4603055225664177`*^9}, 
   3.4604526704446363`*^9, 3.482471496252235*^9, 3.482471611406439*^9, 
   3.482645358035461*^9, 3.482645464253499*^9, 3.482646535695998*^9, 
   3.4826465764442587`*^9, 3.482654300949271*^9, 3.4826607387014923`*^9, {
   3.482665666027986*^9, 3.460345345197377*^9}, 3.482732900019106*^9, 
   3.4832683040504923`*^9, 3.483274830169456*^9, 3.4833558305609293`*^9, 
   3.495174822972555*^9, 3.497953162624474*^9, 3.49795348812144*^9, 
   3.501484207532778*^9, {3.501486522848439*^9, 3.460390536999611*^9}, 
   3.460429409196727*^9, 3.460429476861683*^9, {3.503999599120948*^9, 
   3.460343346107972*^9}, 3.460397493671178*^9, 3.460398192423341*^9, {
   3.460625263005105*^9, 3.460365934424306*^9}, 3.4603733508385*^9, 
   3.541435694240285*^9, 3.541441013451647*^9, 3.541999846000835*^9, 
   3.542001525764724*^9, 3.5424708295924597`*^9, 3.5435582917930317`*^9, 
   3.5435590405864887`*^9, 3.5435600917556868`*^9, 3.543560243517604*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"gtt", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "grr", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "g\[Theta]\[Theta]", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "g\[Phi]\[Phi]", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "gzz"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.466315297140045*^9, 3.478330988195435*^9, 3.478416452606082*^9, 
   3.478847548608172*^9, {3.478929911283174*^9, 3.4603055225664177`*^9}, 
   3.4604526704446363`*^9, 3.482471496252235*^9, 3.482471611406439*^9, 
   3.482645358035461*^9, 3.482645464253499*^9, 3.482646535695998*^9, 
   3.4826465764442587`*^9, 3.482654300949271*^9, 3.4826607387014923`*^9, {
   3.482665666027986*^9, 3.460345345197377*^9}, 3.482732900019106*^9, 
   3.4832683040504923`*^9, 3.483274830169456*^9, 3.4833558305609293`*^9, 
   3.495174822972555*^9, 3.497953162624474*^9, 3.49795348812144*^9, 
   3.501484207532778*^9, {3.501486522848439*^9, 3.460390536999611*^9}, 
   3.460429409196727*^9, 3.460429476861683*^9, {3.503999599120948*^9, 
   3.460343346107972*^9}, 3.460397493671178*^9, 3.460398192423341*^9, {
   3.460625263005105*^9, 3.460365934424306*^9}, 3.4603733508385*^9, 
   3.541435694240285*^9, 3.541441013451647*^9, 3.541999846000835*^9, 
   3.542001525764724*^9, 3.5424708295924597`*^9, 3.5435582917930317`*^9, 
   3.5435590405864887`*^9, 3.5435600917556868`*^9, 3.543560243520424*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Gd", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", "grt"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Gd", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "1"}], "]"}], "]"}], "=", "grt"}]}], "Input"],

Cell[BoxData["grt"], "Output",
 CellChangeTimes->{
  3.466315297179295*^9, 3.478330988245845*^9, 3.4784164526461287`*^9, 
   3.478847548682302*^9, {3.4789299113562927`*^9, 3.46030552262118*^9}, 
   3.460452670511849*^9, 3.4824714962922277`*^9, 3.48247161146406*^9, 
   3.482645358070859*^9, 3.482645464319662*^9, 3.4826465357796783`*^9, 
   3.482646576527176*^9, 3.482654301033062*^9, 3.4826607387838*^9, {
   3.482665666129422*^9, 3.4603453452845716`*^9}, 3.482732900099493*^9, 
   3.483268304133985*^9, 3.483274830260374*^9, 3.4833558306436863`*^9, 
   3.495174823024794*^9, 3.497953162683668*^9, 3.497953488221377*^9, 
   3.5014842076813087`*^9, {3.501486522964305*^9, 3.460390537094163*^9}, 
   3.4604294092484293`*^9, 3.460429476963196*^9, {3.503999599186805*^9, 
   3.460343346168922*^9}, 3.4603974937499847`*^9, 3.460398192516327*^9, {
   3.460625263064344*^9, 3.46036593446181*^9}, 3.4603733508933983`*^9, 
   3.54143569430737*^9, 3.541441013666492*^9, 3.54199984608576*^9, 
   3.542001525794325*^9, 3.542470829642406*^9, 3.543558291827272*^9, 
   3.543559040625779*^9, 3.543560091935977*^9, 3.5435602436023493`*^9}],

Cell[BoxData["grt"], "Output",
 CellChangeTimes->{
  3.466315297179295*^9, 3.478330988245845*^9, 3.4784164526461287`*^9, 
   3.478847548682302*^9, {3.4789299113562927`*^9, 3.46030552262118*^9}, 
   3.460452670511849*^9, 3.4824714962922277`*^9, 3.48247161146406*^9, 
   3.482645358070859*^9, 3.482645464319662*^9, 3.4826465357796783`*^9, 
   3.482646576527176*^9, 3.482654301033062*^9, 3.4826607387838*^9, {
   3.482665666129422*^9, 3.4603453452845716`*^9}, 3.482732900099493*^9, 
   3.483268304133985*^9, 3.483274830260374*^9, 3.4833558306436863`*^9, 
   3.495174823024794*^9, 3.497953162683668*^9, 3.497953488221377*^9, 
   3.5014842076813087`*^9, {3.501486522964305*^9, 3.460390537094163*^9}, 
   3.4604294092484293`*^9, 3.460429476963196*^9, {3.503999599186805*^9, 
   3.460343346168922*^9}, 3.4603974937499847`*^9, 3.460398192516327*^9, {
   3.460625263064344*^9, 3.46036593446181*^9}, 3.4603733508933983`*^9, 
   3.54143569430737*^9, 3.541441013666492*^9, 3.54199984608576*^9, 
   3.542001525794325*^9, 3.542470829642406*^9, 3.543558291827272*^9, 
   3.543559040625779*^9, 3.543560091935977*^9, 3.5435602436038837`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"BuildMetric", ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Gu", "=", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{"Inverse", "[", "Gd", "]"}], "]"}]}], ";", 
    RowBox[{"G", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u", ",", "d"}], "}"}], ",", 
       RowBox[{"IdentityMatrix", "[", "Nind", "]"}]}], "}"}]}], ";"}], 
   ")"}]}]], "Input"],

Cell[BoxData["BuildMetric"], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
    "}"}]}], "\n"}], "\n", 
 RowBox[{"Nind", "=", 
  RowBox[{"Length", "[", "ind", "]"}]}]}], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.466315297712317*^9, 3.4783309883547897`*^9, 3.4784164529457827`*^9, 
   3.478847549205242*^9, {3.478929911603554*^9, 3.4603055237326612`*^9}, 
   3.460452671089712*^9, 3.4824714964364767`*^9, 3.482471611595883*^9, 
   3.482645358224825*^9, 3.482645464457198*^9, 3.4826465359168453`*^9, 
   3.482646576664466*^9, 3.482654301186666*^9, 3.4826607389382544`*^9, {
   3.482665666280961*^9, 3.460345345463394*^9}, 3.482732900239039*^9, 
   3.483268305021481*^9, 3.483274830556378*^9, 3.4833558308940907`*^9, 
   3.4951748231727*^9, 3.497953163012686*^9, 3.4979534884757023`*^9, 
   3.501484207899385*^9, {3.501486523197439*^9, 3.4603905372989473`*^9}, 
   3.460429409494135*^9, 3.460429477939843*^9, {3.503999599454533*^9, 
   3.4603433469419613`*^9}, 3.460397493927754*^9, 3.460398192702785*^9, {
   3.460625263273443*^9, 3.460365934618382*^9}, 3.4603733510389843`*^9, 
   3.5414356944615593`*^9, 3.541441013783738*^9, 3.541999846405352*^9, 
   3.5420015260770597`*^9, 3.5424708297817163`*^9, 3.543558291925331*^9, 
   3.5435590407384863`*^9, 3.543560092074004*^9, 3.543560243734569*^9}],

Cell[BoxData["5"], "Output",
 CellChangeTimes->{
  3.466315297712317*^9, 3.4783309883547897`*^9, 3.4784164529457827`*^9, 
   3.478847549205242*^9, {3.478929911603554*^9, 3.4603055237326612`*^9}, 
   3.460452671089712*^9, 3.4824714964364767`*^9, 3.482471611595883*^9, 
   3.482645358224825*^9, 3.482645464457198*^9, 3.4826465359168453`*^9, 
   3.482646576664466*^9, 3.482654301186666*^9, 3.4826607389382544`*^9, {
   3.482665666280961*^9, 3.460345345463394*^9}, 3.482732900239039*^9, 
   3.483268305021481*^9, 3.483274830556378*^9, 3.4833558308940907`*^9, 
   3.4951748231727*^9, 3.497953163012686*^9, 3.4979534884757023`*^9, 
   3.501484207899385*^9, {3.501486523197439*^9, 3.4603905372989473`*^9}, 
   3.460429409494135*^9, 3.460429477939843*^9, {3.503999599454533*^9, 
   3.4603433469419613`*^9}, 3.460397493927754*^9, 3.460398192702785*^9, {
   3.460625263273443*^9, 3.460365934618382*^9}, 3.4603733510389843`*^9, 
   3.5414356944615593`*^9, 3.541441013783738*^9, 3.541999846405352*^9, 
   3.5420015260770597`*^9, 3.5424708297817163`*^9, 3.543558291925331*^9, 
   3.5435590407384863`*^9, 3.543560092074004*^9, 3.543560243736125*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"getind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "i1", "]"}], ",", "i1", ",", 
      RowBox[{
       RowBox[{"Position", "[", 
        RowBox[{"ind", ",", "i1"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"lstind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"lsttmp2", "=", 
      RowBox[{"{", "}"}]}], ";", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"AppendTo", "[", 
        RowBox[{"lsttmp2", ",", 
         RowBox[{"getind", "[", 
          RowBox[{"i1", "[", 
           RowBox[{"[", 
            RowBox[{"lsttmp1", ",", "1"}], "]"}], "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"lsttmp1", ",", "1", ",", 
         RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
     "lsttmp2"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"up", "[", 
   RowBox[{"i1_", ",", "i2_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"lsttmp2", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"AppendTo", "[", 
       RowBox[{"lsttmp2", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"i1", "[", 
            RowBox[{"[", 
             RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "=!=", 
           RowBox[{"i2", "[", 
            RowBox[{"[", "lsttmp1", "]"}], "]"}]}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"i1", "[", 
              RowBox[{"[", 
               RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "===", "d"}], ",",
             "d", ",", "u"}], "]"}], ",", "0"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"lsttmp1", ",", "1", ",", 
        RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
    "lsttmp2"}], ")"}]}]}], "Input",
 Editable->False],

Cell[BoxData[""], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"t1_", ",", "dim_", ",", "indpos_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"MTtmp1", "=", "0"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Length", "[", "indpos", "]"}], "=!=", "dim"}], ",", 
      RowBox[{"Print", "[", "\"\<Error in index position\>\"", "]"}]}], "]"}],
     ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"MTtmp1", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"MTtmp1", ",", 
         RowBox[{"{", 
          RowBox[{"MTtmp3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"MTtmp2", ",", "1", ",", "dim"}], "}"}]}], "]"}], ";", 
    RowBox[{"t1", "=", 
     RowBox[{"{", 
      RowBox[{"indpos", ",", "MTtmp1"}], "}"}]}]}], ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ST", "[", 
    RowBox[{"t1_", ",", "tind_", ",", "val_"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"STtmp1", "=", "t1"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"up", "[", 
         RowBox[{"tind", ",", 
          RowBox[{"t1", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "=!=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"Length", "[", "tind", "]"}], "}"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Print", "[", "\"\<Error in Index Assignment!!\>\"", "]"}], 
        ";"}]}], "]"}], ";", 
     RowBox[{
      RowBox[{"STtmp1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "=", 
      RowBox[{"ReplacePart", "[", 
       RowBox[{
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", "val", ",", 
        RowBox[{"lstind", "[", "tind", "]"}]}], "]"}]}], ";", "STtmp1"}], 
    ")"}]}], "\n"}]], "Input",
 Editable->False],

Cell["\<\


Edited the expression below as 7.0 seems to complain about Sum[x] whereas 6.0 \
would just return x (ie. if there is no sum index!)

\
\>", "Text",
 CellChangeTimes->{{3.465736646430695*^9, 3.4657366879261303`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GT", "[", 
   RowBox[{"t1_", ",", "tind_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"GTtmp2", "=", 
     RowBox[{"up", "[", 
      RowBox[{"tind", ",", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
    RowBox[{"GTtmp3", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp4", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp5", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp6", "=", "t1"}], ";", "\n", "\t\t", 
    RowBox[{"Do", "[", "\n", "\t\t\t", 
     RowBox[{
      RowBox[{
       RowBox[{"Switch", "[", 
        RowBox[{
         RowBox[{"GTtmp2", "[", 
          RowBox[{"[", "GTtmp1", "]"}], "]"}], ",", "\n", "\t\t\t\t", "0", 
         ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}]}]}],
            ";"}], ")"}], ",", "\n", "\t\t\t\t", "u", ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gu[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}]}], ")"}], ",", "\n", "\t\t\t\t", "d", ",",
          "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gd[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}], ";"}], ")"}]}], "]"}], ";"}], "\n", 
      "\t\t\t", ",", 
      RowBox[{"{", 
       RowBox[{"GTtmp1", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"t1", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"GTtmp4", "===", "\"\<\>\""}], "&&", 
       RowBox[{"GTtmp5", "===", "\"\<\>\""}]}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{"\"\<GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\""}], 
       "]"}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{
       "\"\<Sum[GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\"", "<>", 
        "GTtmp4", "<>", "GTtmp5", "<>", "\"\<]\>\""}], "]"}]}], "]"}]}], 
   ")"}]}]], "Input",
 Editable->False,
 CellChangeTimes->{{3.465736640865263*^9, 3.4657366432796392`*^9}, {
  3.465736699767317*^9, 3.4657367470041943`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Trace, Outer Product and Covariant Derivative! - GREinstein.nb\
\>", "Subsubtitle",
 Editable->False],

Cell["\<\
Syntax:   trT[tensor,{{1,4},{2,3}}]   -  ie. contract 1 and 4 plus 2 and 3 \
positions\
\>", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"trT", "[", 
   RowBox[{"t1_", ",", "lst_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "tracetmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"dimt1", "===", "2"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tracetmp", "=", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"GT", "[", 
           RowBox[{"tmpt1", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"s1", ",", "d"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"s1", ",", "u"}], "}"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"s1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ";"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"MT", "[", 
        RowBox[{"tracetmp", ",", 
         RowBox[{"dimt1", "-", 
          RowBox[{"2", 
           RowBox[{"Length", "[", "lst", "]"}]}]}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{"d", ",", 
           RowBox[{"{", 
            RowBox[{"ii", ",", "1", ",", 
             RowBox[{"dimt1", "-", 
              RowBox[{"2", 
               RowBox[{"Length", "[", "lst", "]"}]}]}]}], "}"}]}], "]"}]}], 
        "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"{", "}"}], "===", 
             RowBox[{"Position", "[", 
              RowBox[{"lst", ",", "indno"}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"tmpstring1", "=", 
              RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,d},\>\""}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"tmpstring3", "=", 
              RowBox[{"tmpstring3", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,1,Nind},\>\""}]}], ";"}]}], "\[IndentingNewLine]", "]"}],
           ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}],
           ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\n", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"tmpstring4", "=", 
           RowBox[{"tmpstring4", "<>", "\"\<{s\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", 
            "\"\<,1,Nind},\>\""}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "1"}], "]"}], "]"}], "]"}]}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "2"}], "]"}], "]"}], "]"}], "<>", 
               "\"\<,d}\>\""}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,u}\>\""}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", 
           RowBox[{"Length", "[", "lst", "]"}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpeval", "=", 
        RowBox[{"\"\<Do[tracetmp=ST[tracetmp,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring1", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},Sum[GT[tmpt1,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring2", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring3", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "tracetmp"}], 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell["Syntax:   outerT[tensor1,tensor2] ", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"outerT", "[", 
   RowBox[{"t1_", ",", "t2_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    RowBox[{"dimt2", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t2", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", 
    RowBox[{"tmpt2", "=", "t2"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "outertmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"outertmp", ",", 
      RowBox[{"dimt1", "+", "dimt2"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{"d", ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"dimt1", "+", "dimt2"}]}], "}"}]}], "]"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring1", "=", 
        RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring2", "=", 
        RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", "\n", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring3", "=", 
        RowBox[{"tmpstring3", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", 
        RowBox[{"tmpstring4", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt2"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpeval", "=", 
     RowBox[{"\"\<Do[outertmp=ST[outertmp,{\>\"", "<>", "tmpstring1", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},GT[tmpt1,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring1", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]GT[tmpt2,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]],\>\"", "<>", "tmpstring2",
       "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring4", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "outertmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"scalarDT", "[", "t1_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"covDTtmp", ",", "1", ",", 
      RowBox[{"{", "d", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
    "tmpeval", "=", 
     "\"\<Do[covDTtmp=ST[covDTtmp,{{i1,d}},D[tmpt1,ind[[i1]]]],{i1,1,Nind}]\>\
\""}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "covDTtmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"covDT", "[", "t1_", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dimt1", "=", 
      RowBox[{"Length", "[", 
       RowBox[{"Dimensions", "[", 
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"MT", "[", 
      RowBox[{"covDTtmp", ",", 
       RowBox[{"dimt1", "+", "1"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{"d", ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", 
           RowBox[{"dimt1", "+", "1"}]}], "}"}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Build", " ", "expression"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring1", "=", 
         RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
        ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring2", "=", 
         RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", 
          "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring4", "=", 
         RowBox[{"\"\<-Sum[GT[tmpt1,{\>\"", "<>", 
          RowBox[{"StringDrop", "[", 
           RowBox[{"tmpstring1", ",", 
            RowBox[{"-", "1"}]}], "]"}], "<>", 
          "\"\<}]GT[\[CapitalGamma],{{REPL,d},{s1,d},{s2,u}}],{s2,1,Nind}]\>\"\
"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}], "\[Rule]", " ", 
            "\"\<s2\>\""}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"\"\<REPL\>\"", "\[Rule]", 
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring3", "=", 
         RowBox[{"tmpstring3", "<>", "tmpstring4"}]}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpeval", "=", 
      RowBox[{
      "\"\<Do[covDTtmp=ST[covDTtmp,{\>\"", "<>", "tmpstring1", "<>", 
       "\"\<{s1,d}},D[GT[tmpt1,{\>\"", "<>", 
       RowBox[{"StringDrop", "[", 
        RowBox[{"tmpstring1", ",", 
         RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],ind[[s1]]]\>\"", "<>", 
       "tmpstring3", "<>", "\"\<],\>\"", "<>", "tmpstring2", "<>", 
       "\"\<{s1,1,Nind}]\>\""}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "covDTtmp"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 Editable->False],

Cell[BoxData["."], "Input",
 CellChangeTimes->{3.399009138941909*^9},
 EmphasizeSyntaxErrors->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Buildmetric", "Subsubtitle"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
  "Print", "[", 
   "\"\<\\n\\n   \[CapitalDelta][r_,a_]=(\!\(\*FractionBox[\(\(\\\ \)\(1\)\), \
\(\((1 - a^2)\) + rh\\\ \((1 - r^2)\)^2\)]\))^2\\n   f[r_]  =(1-r^2)\\n   \
g[a_]   =2-a^2\\n\\n\\n\\n\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.4603926036977377`*^9, 3.460392609494193*^9}, {
   3.4603964671280737`*^9, 3.460396474067587*^9}, {3.460396608649122*^9, 
   3.4603966089839687`*^9}, 3.5435573776732607`*^9, {3.543557822534987*^9, 
   3.543557822878004*^9}, {3.5435590064393377`*^9, 3.5435590094656467`*^9}}],

Cell[BoxData["\<\"\\n\\n   \
\[CapitalDelta][r_,a_]=(\\!\\(\\*FractionBox[\\(\\(\\\\ \\)\\(1\\)\\), \
\\(\\((1 - a^2)\\) + rh\\\\ \\((1 - r^2)\\)^2\\)]\\))^2\\n   f[r_]  \
=(1-r^2)\\n   g[a_]   =2-a^2\\n\\n\\n\\n\"\>"], "Print",
 CellChangeTimes->{{3.460392614803647*^9, 3.460392630773752*^9}, 
   3.4603927469544163`*^9, {3.4603965912356453`*^9, 3.460396610516452*^9}, 
   3.460396683089012*^9, 3.460397912493801*^9, {3.460444072054455*^9, 
   3.460356776865254*^9}, 3.460366839549692*^9, 3.4603725359239388`*^9, 
   3.539782999025613*^9, 3.539785140647101*^9, 3.539868426792572*^9, 
   3.539873663653604*^9, 3.5424699937927732`*^9, 3.5435573790963993`*^9, 
   3.5435574186869783`*^9, 3.543558277421892*^9, 3.5435590414399853`*^9, 
   3.5435600925409107`*^9, 3.543560244189734*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Gd", "=", 
   RowBox[{
    RowBox[{"\[CapitalDelta]", "[", 
     RowBox[{"r", ",", "a"}], "]"}], 
    RowBox[{"(", GridBox[{
       {
        RowBox[{
         RowBox[{"r", "^", "2"}], 
         RowBox[{
          RowBox[{"f", "[", "r", "]"}], "^", "2"}], 
         RowBox[{"j", "[", "r", "]"}], 
         RowBox[{"Exp", "[", 
          RowBox[{"T", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], "]"}]}], "0", "0", "0", 
        "0", "0"},
       {"0", 
        RowBox[{
         FractionBox["4", 
          RowBox[{
           RowBox[{
            RowBox[{"f", "[", "r", "]"}], "^", "2"}], 
           RowBox[{"j", "[", "r", "]"}]}]], 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"T", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
           RowBox[{
            RowBox[{"r", "^", "2"}], 
            RowBox[{"A", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], "]"}]}], 
        RowBox[{"a", " ", "r", " ", 
         FractionBox["1", 
          RowBox[{"f", "[", "r", "]"}]], 
         RowBox[{"F", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "0", "0", "0"},
       {"0", 
        RowBox[{"a", " ", "r", " ", 
         FractionBox["1", 
          RowBox[{"f", "[", "r", "]"}]], 
         RowBox[{"F", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], 
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
           RowBox[{
            RowBox[{"a", "^", "2"}], " ", 
            RowBox[{"B", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], "]"}], 
         FractionBox["4", 
          RowBox[{"g", "[", "a", "]"}]]}], "0", "0", "0"},
       {"0", "0", "0", 
        FractionBox[
         RowBox[{
          RowBox[{"Exp", "[", 
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "]"}], 
          RowBox[{"g", "[", "a", "]"}], 
          RowBox[{"a", "^", "2"}]}], 
         RowBox[{"1", "-", 
          RowBox[{"\[Theta]1", "^", "2"}]}]], "0", "0"},
       {"0", "0", "0", "0", 
        RowBox[{" ", 
         RowBox[{
          RowBox[{"Exp", "[", 
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "]"}], 
          RowBox[{"g", "[", "a", "]"}], 
          RowBox[{"a", "^", "2"}], 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"\[Theta]1", "^", "2"}]}], ")"}]}]}], "0"},
       {"0", "0", "0", "0", "0", 
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{"S", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], "]"}], 
         RowBox[{"g", "[", "a", "]"}], 
         RowBox[{"a", "^", "2"}], 
         RowBox[{"\[Theta]1", "^", "2"}]}]}
      }], ")"}]}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{
    "t", ",", "r", ",", "a", ",", "\[Theta]1", ",", "\[Theta]2", ",", 
     "\[Theta]3"}], "}"}]}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"Nind", "=", 
   RowBox[{"Length", "[", "ind", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"BuildMetric", ";"}]}], "Input",
 CellChangeTimes->{{3.408796998476103*^9, 3.408797030516582*^9}, {
   3.408799071597343*^9, 3.408799082644943*^9}, {3.408949739095245*^9, 
   3.408949739644734*^9}, {3.408949841695282*^9, 3.40894984293303*^9}, {
   3.415862083663703*^9, 3.4158620851642113`*^9}, {3.415862334623486*^9, 
   3.415862336021243*^9}, {3.415862388498528*^9, 3.4158623965197372`*^9}, {
   3.4158641082437763`*^9, 3.415864116357332*^9}, {3.415865034672494*^9, 
   3.415865047473855*^9}, {3.415943026431671*^9, 3.415943056090918*^9}, {
   3.42453089354659*^9, 3.424530981705195*^9}, {3.4262330694486513`*^9, 
   3.426233078224708*^9}, {3.42831552177035*^9, 3.428315531925826*^9}, {
   3.482669504390863*^9, 3.482669559589313*^9}, {3.482669593648382*^9, 
   3.4826696108221407`*^9}, {3.4826696421684*^9, 3.460306349771068*^9}, {
   3.460306681872867*^9, 3.4603066892293873`*^9}, {3.460306743915044*^9, 
   3.460306776656151*^9}, {3.4603068906726713`*^9, 3.4603069154556093`*^9}, 
   3.4606109474491568`*^9, {3.5039972414730186`*^9, 3.503997244123049*^9}, {
   3.5172982618161573`*^9, 3.517298294501769*^9}, {3.517302332920382*^9, 
   3.517302353678054*^9}, {3.51730241996021*^9, 3.517302425934087*^9}, {
   3.517302556663072*^9, 3.5173025584548187`*^9}, 3.517579091871194*^9, {
   3.517642973774815*^9, 3.517642975072443*^9}, 3.517658611602713*^9, {
   3.517660901410638*^9, 3.460392650166881*^9}, {3.4603926980532846`*^9, 
   3.460392722992764*^9}, {3.460396656885631*^9, 3.460356665674651*^9}, {
   3.460356724881654*^9, 3.4603567425493803`*^9}, 3.460372510789526*^9, {
   3.54246967191507*^9, 3.542469701786797*^9}, {3.542469881774507*^9, 
   3.5424699266914043`*^9}, {3.543557353434564*^9, 3.5435573569933662`*^9}, {
   3.543558817218278*^9, 3.543558856001135*^9}, {3.543559354714594*^9, 
   3.543559356590616*^9}, {3.543559387432591*^9, 3.543559389477353*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"T", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
      SuperscriptBox["r", "2"], " ", 
      SuperscriptBox[
       RowBox[{"f", "[", "r", "]"}], "2"], " ", 
      RowBox[{"j", "[", "r", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}], ",", "0", ",", "0", ",", "0", ",", 
     "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"A", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{"T", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"f", "[", "r", "]"}], "2"], " ", 
       RowBox[{"j", "[", "r", "]"}]}]], ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"f", "[", "r", "]"}]], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"f", "[", "r", "]"}]], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"B", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{"S", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"g", "[", "a", "]"}]], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"1", "-", 
       SuperscriptBox["\[Theta]1", "2"]}]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"S", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
      RowBox[{"g", "[", "a", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"S", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
      SuperscriptBox["\[Theta]1", "2"], " ", 
      RowBox[{"g", "[", "a", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.503310959549301*^9, {3.503311337489339*^9, 3.460515673680585*^9}, 
   3.503996967770006*^9, 3.503997006524664*^9, 3.503997194550593*^9, 
   3.5039972601206627`*^9, 3.504000114145877*^9, 3.5173031733152313`*^9, 
   3.517579162305614*^9, 3.517643121148817*^9, 3.517650908892145*^9, 
   3.517658630210273*^9, 3.5176586899579687`*^9, 3.517660936798641*^9, {
   3.5178236465697403`*^9, 3.517823673129346*^9}, 3.517824230175544*^9, {
   3.517825903545369*^9, 3.460388252816543*^9}, 3.460392747023707*^9, 
   3.460396683141287*^9, 3.4603979125408783`*^9, {3.460444072147172*^9, 
   3.460356776913579*^9}, 3.46036683960192*^9, 3.460372536508292*^9, 
   3.539782999088622*^9, 3.539785140698571*^9, 3.539868426896636*^9, 
   3.53987366371763*^9, 3.542469993839971*^9, 3.5435574187269382`*^9, 
   3.543559041476474*^9, 3.543560092575436*^9, 3.543560244224978*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "t", ",", "r", ",", "a", ",", "\[Theta]1", ",", "\[Theta]2", ",", 
   "\[Theta]3"}], "}"}]], "Output",
 CellChangeTimes->{
  3.503310959549301*^9, {3.503311337489339*^9, 3.460515673680585*^9}, 
   3.503996967770006*^9, 3.503997006524664*^9, 3.503997194550593*^9, 
   3.5039972601206627`*^9, 3.504000114145877*^9, 3.5173031733152313`*^9, 
   3.517579162305614*^9, 3.517643121148817*^9, 3.517650908892145*^9, 
   3.517658630210273*^9, 3.5176586899579687`*^9, 3.517660936798641*^9, {
   3.5178236465697403`*^9, 3.517823673129346*^9}, 3.517824230175544*^9, {
   3.517825903545369*^9, 3.460388252816543*^9}, 3.460392747023707*^9, 
   3.460396683141287*^9, 3.4603979125408783`*^9, {3.460444072147172*^9, 
   3.460356776913579*^9}, 3.46036683960192*^9, 3.460372536508292*^9, 
   3.539782999088622*^9, 3.539785140698571*^9, 3.539868426896636*^9, 
   3.53987366371763*^9, 3.542469993839971*^9, 3.5435574187269382`*^9, 
   3.543559041476474*^9, 3.543560092575436*^9, 3.543560244228334*^9}],

Cell[BoxData["6"], "Output",
 CellChangeTimes->{
  3.503310959549301*^9, {3.503311337489339*^9, 3.460515673680585*^9}, 
   3.503996967770006*^9, 3.503997006524664*^9, 3.503997194550593*^9, 
   3.5039972601206627`*^9, 3.504000114145877*^9, 3.5173031733152313`*^9, 
   3.517579162305614*^9, 3.517643121148817*^9, 3.517650908892145*^9, 
   3.517658630210273*^9, 3.5176586899579687`*^9, 3.517660936798641*^9, {
   3.5178236465697403`*^9, 3.517823673129346*^9}, 3.517824230175544*^9, {
   3.517825903545369*^9, 3.460388252816543*^9}, 3.460392747023707*^9, 
   3.460396683141287*^9, 3.4603979125408783`*^9, {3.460444072147172*^9, 
   3.460356776913579*^9}, 3.46036683960192*^9, 3.460372536508292*^9, 
   3.539782999088622*^9, 3.539785140698571*^9, 3.539868426896636*^9, 
   3.53987366371763*^9, 3.542469993839971*^9, 3.5435574187269382`*^9, 
   3.543559041476474*^9, 3.543560092575436*^9, 3.5435602442302237`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Gd"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"T", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
      SuperscriptBox["r", "2"], " ", 
      SuperscriptBox[
       RowBox[{"f", "[", "r", "]"}], "2"], " ", 
      RowBox[{"j", "[", "r", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}], ",", "0", ",", "0", ",", "0", ",", 
     "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"A", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{"T", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"f", "[", "r", "]"}], "2"], " ", 
       RowBox[{"j", "[", "r", "]"}]}]], ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"f", "[", "r", "]"}]], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"f", "[", "r", "]"}]], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"B", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{"S", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"g", "[", "a", "]"}]], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"1", "-", 
       SuperscriptBox["\[Theta]1", "2"]}]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"S", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
      RowBox[{"g", "[", "a", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"S", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
      SuperscriptBox["\[Theta]1", "2"], " ", 
      RowBox[{"g", "[", "a", "]"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.426737013947981*^9, 3.42831519475591*^9, 3.428315553704377*^9, 
   3.42831688012332*^9, 3.428403895402966*^9, 3.428404282812348*^9, 
   3.431855679361175*^9, 3.431863727521323*^9, 3.482645295470035*^9, 
   3.482645359355171*^9, 3.482645465220532*^9, 3.482646536463307*^9, 
   3.4826465772437983`*^9, 3.4826543017657003`*^9, 3.482660739570448*^9, {
   3.4826656670958242`*^9, 3.460345346563177*^9}, 3.482732901086844*^9, 
   3.483268305672525*^9, 3.483274831485346*^9, 3.483355831699278*^9, 
   3.4951748242050257`*^9, 3.497953163855152*^9, 3.497953489287703*^9, 
   3.5014842100803003`*^9, {3.5014865241306953`*^9, 3.4603905383513203`*^9}, 
   3.4604294104843483`*^9, 3.46042947896661*^9, {3.503999600339315*^9, 
   3.4603433478172483`*^9}, 3.460397496352495*^9, 3.460398195234408*^9, {
   3.4606252658864193`*^9, 3.4603659368972*^9}, 3.4603733533587*^9, 
   3.5414356961283913`*^9, 3.54144101540274*^9, 3.5419998477583447`*^9, 
   3.542001527431053*^9, 3.5424708313203497`*^9, 3.5435582931767483`*^9, 
   3.5435590425266314`*^9, 3.5435600936096478`*^9, 3.5435602452720337`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Gu"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        RowBox[{"T", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], 
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox[
        RowBox[{"f", "[", "r", "]"}], "2"], " ", 
       RowBox[{"j", "[", "r", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]], ",", "0", ",", "0", ",", "0", ",", 
     "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"f", "[", "r", "]"}], "2"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "2"]}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], " ", 
             RowBox[{"B", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
            RowBox[{"S", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"F", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
          RowBox[{"g", "[", "a", "]"}]}], "+", 
         FractionBox[
          RowBox[{"16", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"A", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{"T", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
          RowBox[{"j", "[", "r", "]"}]]}], ")"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]], ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"f", "[", "r", "]"}], " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"j", "[", "r", "]"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"B", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{"S", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"F", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
          RowBox[{"g", "[", "a", "]"}], " ", 
          RowBox[{"j", "[", "r", "]"}]}]}], ")"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]], ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"f", "[", "r", "]"}], " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"j", "[", "r", "]"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"B", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{"S", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"F", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
          RowBox[{"g", "[", "a", "]"}], " ", 
          RowBox[{"j", "[", "r", "]"}]}]}], ")"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]], ",", 
     FractionBox["1", 
      RowBox[{
       FractionBox[
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"B", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
         RowBox[{"\[CapitalDelta]", "[", 
          RowBox[{"r", ",", "a"}], "]"}]}], 
        RowBox[{"g", "[", "a", "]"}]], "-", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["r", "2"]}], " ", 
           RowBox[{"A", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
          RowBox[{"T", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
        SuperscriptBox["r", "2"], " ", 
        SuperscriptBox[
         RowBox[{"F", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
        RowBox[{"j", "[", "r", "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}]}]], ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", 
          RowBox[{"S", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[Theta]1", "2"]}], ")"}]}], 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"g", "[", "a", "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}]]}], ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", 
         RowBox[{"S", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
        RowBox[{"g", "[", "a", "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}]]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[Theta]1", "2"], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.426737013996367*^9, 3.428315194823951*^9, 3.42831555372094*^9, 
   3.428316880162258*^9, 3.428403895438301*^9, 3.42840428286333*^9, 
   3.431855679506925*^9, 3.431863727579101*^9, 3.482645295502652*^9, 
   3.482645359398937*^9, 3.482645465282672*^9, 3.4826465365215797`*^9, 
   3.482646577301097*^9, 3.482654301950992*^9, 3.482660739739355*^9, {
   3.482665667186685*^9, 3.4603453466175222`*^9}, 3.4827329011606503`*^9, 
   3.483268305726141*^9, 3.483274831596257*^9, 3.4833558317557917`*^9, 
   3.49517482426343*^9, 3.497953163911227*^9, 3.497953489425228*^9, 
   3.501484210221078*^9, {3.5014865242391787`*^9, 3.460390538438959*^9}, 
   3.460429410533709*^9, 3.460429479043961*^9, {3.5039996003967047`*^9, 
   3.4603433478632727`*^9}, 3.460397496429948*^9, 3.4603981953136177`*^9, {
   3.460625265957264*^9, 3.4603659369408827`*^9}, 3.4603733534335823`*^9, 
   3.5414356961843777`*^9, 3.541441015458969*^9, 3.541999847822082*^9, 
   3.542001527468235*^9, 3.5424708313831263`*^9, 3.543558293237279*^9, 
   3.543559042562801*^9, 3.543560093643661*^9, 3.543560245328039*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"detg", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Det", "[", "Gd", "]"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "6"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"3", " ", 
     RowBox[{"S", "[", 
      RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
    RowBox[{"T", "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
  SuperscriptBox["r", "2"], " ", 
  SuperscriptBox["\[Theta]1", "2"], " ", 
  SuperscriptBox[
   RowBox[{"g", "[", "a", "]"}], "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"16", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"A", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"B", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
       RowBox[{"S", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
       RowBox[{"T", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["r", "2"], " ", 
     SuperscriptBox[
      RowBox[{"F", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
     RowBox[{"g", "[", "a", "]"}], " ", 
     RowBox[{"j", "[", "r", "]"}]}]}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{"\[CapitalDelta]", "[", 
    RowBox[{"r", ",", "a"}], "]"}], "6"]}]], "Output",
 CellChangeTimes->{
  3.426737014038818*^9, 3.428315194987363*^9, 3.428315553807802*^9, 
   3.428316880199193*^9, 3.4284038954693108`*^9, 3.428404282950614*^9, 
   3.431855679578286*^9, 3.4318637276288977`*^9, 3.482645295534935*^9, 
   3.482645359432629*^9, 3.482645465322057*^9, 3.482646536679943*^9, 
   3.482646577444168*^9, 3.482654302025573*^9, 3.482660739810965*^9, {
   3.4826656672687674`*^9, 3.460345346748376*^9}, 3.482732901244331*^9, 
   3.483268305791041*^9, 3.483274831689481*^9, 3.4833558318200827`*^9, 
   3.495174824307178*^9, 3.497953163960969*^9, 3.497953489575306*^9, 
   3.501484210316465*^9, {3.5014865243333797`*^9, 3.4603905385408373`*^9}, 
   3.4604294106016273`*^9, 3.460429479111375*^9, {3.503999600438518*^9, 
   3.460343347915853*^9}, 3.460397496568387*^9, 3.460398195393688*^9, {
   3.4606252661078997`*^9, 3.460365937009363*^9}, 3.4603733535789757`*^9, 
   3.5414356962284184`*^9, 3.54144101549096*^9, 3.541999847874116*^9, 
   3.542001527498621*^9, 3.5424708314772873`*^9, 3.543558293269396*^9, 
   3.543559042611936*^9, 3.543560093695202*^9, 3.5435602453751583`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRrun2.nb", "Subsubtitle"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\[CapitalGamma]", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"\[CapitalGamma]", ",", "3", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "u"}], "}"}]}], "]"}], ";"}], "\n"}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R4", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R4", ",", "4", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "d", ",", "u"}], "}"}]}], "]"}], 
  ";"}], "\n"}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "G2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"G2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"\[CapitalGamma]", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"\[CapitalGamma]", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], 
         RowBox[{"GT", "[", 
          RowBox[{"G", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
            "}"}]}], "]"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "+", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "ss1", "]"}], "]"}]}], "]"}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalGamma]", "=", 
   RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.426232729469757*^9, 3.426232735540435*^9}}],

Cell[BoxData[
 RowBox[{"Do", "[", "\n", "\t", 
  RowBox[{
   RowBox[{"R4", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R4", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      "\n", "\t", "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "+", "\n", "\t\t\t", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}]}], "\n", 
     "\t\t", "\n", "\t\t", "]"}]}], "\n", "\t\t", ",", "\n", "\t", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i4", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R4", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"R2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"GT", "[", 
         RowBox[{"R4", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}],
          "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "\n", 
     "\t\t", "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"GT", "[", 
      RowBox[{"R2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"G2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"G2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"GT", "[", 
        RowBox[{"R2", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
        "]"}], "-", 
       RowBox[{
        FractionBox["1", "2"], 
        RowBox[{"GT", "[", 
         RowBox[{"G", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
         "]"}], "Ricci"}]}]}], "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "G2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "Ricci", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"]
}, Closed]],

Cell[CellGroupData[{

Cell["Einstein equations", "Subsubtitle"],

Cell[CellGroupData[{

Cell[BoxData["ind"], "Input",
 CellChangeTimes->{{3.482645378412899*^9, 3.4826453786609163`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "t", ",", "r", ",", "a", ",", "\[Theta]1", ",", "\[Theta]2", ",", 
   "\[Theta]3"}], "}"}]], "Output",
 CellChangeTimes->{
  3.482645396895133*^9, 3.482645499809284*^9, 3.482646611846545*^9, 
   3.48265433638922*^9, {3.482665675369759*^9, 3.460345373817977*^9}, 
   3.482732919598102*^9, 3.4832683242802143`*^9, 3.483274850617939*^9, 
   3.483355850660965*^9, 3.495174843468848*^9, 3.497953181922439*^9, 
   3.497953507686852*^9, 3.5014842285458813`*^9, {3.501486543945709*^9, 
   3.4603905641391706`*^9}, 3.460429437199853*^9, 3.4604295045078793`*^9, {
   3.503999615054343*^9, 3.4603433738186502`*^9}, 3.460397545985814*^9, 
   3.460398244813052*^9, {3.460625316134089*^9, 3.4603659842036743`*^9}, 
   3.460373401256411*^9, 3.541435714343343*^9, 3.541441033648178*^9, 
   3.54199986288216*^9, 3.542001542433325*^9, 3.542470853023415*^9, 
   3.543558313783145*^9, 3.543559065792738*^9, 3.543560117253235*^9, 
   3.543560268500874*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TangVec", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "u", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
    "}"}]}]], "Input",
 CellChangeTimes->{{3.482645319964726*^9, 3.482645321420919*^9}, {
  3.482645369742679*^9, 3.482645398774542*^9}, {3.5424708600316677`*^9, 
  3.5424708602227488`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "u", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.4826453938568697`*^9, 3.482645399209482*^9}, 
   3.48264549990095*^9, 3.4826466119131927`*^9, 3.482654336461301*^9, 
   3.482661037405292*^9, 3.4826611049629107`*^9, {3.4826656754454536`*^9, 
   3.460345373890777*^9}, 3.48273291967444*^9, 3.4832683243369207`*^9, 
   3.483274850726749*^9, 3.48335585071898*^9, 3.49517484354065*^9, 
   3.497953181977542*^9, 3.49795350775769*^9, 3.501484228646851*^9, {
   3.501486544055847*^9, 3.460390564238563*^9}, 3.4604294372576113`*^9, 
   3.460429504591004*^9, {3.503999615107829*^9, 3.460343373920657*^9}, 
   3.460397546066593*^9, 3.4603976151938047`*^9, 3.4603977205260897`*^9, 
   3.460398244895062*^9, {3.4606253161639013`*^9, 3.460365984260375*^9}, 
   3.460373401309203*^9, 3.541435714381008*^9, 3.5414410336888742`*^9, 
   3.5419998629384117`*^9, 3.542001542477748*^9, {3.5424708530839157`*^9, 
   3.542470864088642*^9}, 3.5435583138089333`*^9, 3.5435590658377867`*^9, 
   3.543560117289991*^9, 3.543560268534121*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NormVec", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "u", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "c", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}]}],
    "}"}]}]], "Input",
 CellChangeTimes->{{3.482645401975491*^9, 3.482645411285253*^9}, {
  3.4826458546230803`*^9, 3.482645859613565*^9}, {3.542470862086911*^9, 
  3.542470862334997*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "u", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "c", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.482645412231688*^9, 3.4826454147952023`*^9}, 
   3.482645499988126*^9, {3.482645855809843*^9, 3.482645883352165*^9}, 
   3.482646611979519*^9, 3.482654336511277*^9, 3.482661038021718*^9, 
   3.482661105445985*^9, {3.48266567551117*^9, 3.460345383768354*^9}, 
   3.482732919741027*^9, 3.483268324387245*^9, 3.4832748508268423`*^9, 
   3.483355850769663*^9, 3.495174843607183*^9, 3.497953182026888*^9, 
   3.497953507824995*^9, 3.501484228748543*^9, {3.5014865441560593`*^9, 
   3.4603905643381643`*^9}, 3.46042943731177*^9, 3.460429504658307*^9, {
   3.503999615158149*^9, 3.460343374012308*^9}, {3.460397546116476*^9, 
   3.460397554586464*^9}, 3.460397616057626*^9, 3.460397721507806*^9, 
   3.4603982449627333`*^9, {3.460625316191557*^9, 3.4603659843147182`*^9}, 
   3.460373401362619*^9, 3.541435714413704*^9, 3.541441033726552*^9, 
   3.541999862990693*^9, 3.542001542517255*^9, {3.5424708532359457`*^9, 
   3.542470864890204*^9}, 3.543558313840075*^9, 3.543559065877087*^9, 
   3.5435601173356943`*^9, 3.543560268572084*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"trT", "[", 
    RowBox[{
     RowBox[{"outerT", "[", 
      RowBox[{"NormVec", ",", "TangVec"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.482645418577425*^9, 3.482645427289304*^9}, {
  3.482645468181383*^9, 3.482645476589221*^9}, {3.482645843815053*^9, 
  3.482645847782482*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", "c", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"A", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
        RowBox[{"T", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
     RowBox[{"a", " ", "r", " ", 
      RowBox[{"f", "[", "r", "]"}], " ", 
      RowBox[{"F", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
      RowBox[{"j", "[", "r", "]"}]}]}], ")"}], " ", 
   RowBox[{"\[CapitalDelta]", "[", 
    RowBox[{"r", ",", "a"}], "]"}]}], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"f", "[", "r", "]"}], "2"], " ", 
   RowBox[{"j", "[", "r", "]"}]}]]], "Output",
 CellChangeTimes->{{3.482645500150728*^9, 3.482645500248397*^9}, {
   3.482645848182082*^9, 3.482645884001075*^9}, 3.4826466120466337`*^9, 
   3.482654336578025*^9, 3.4826610385554256`*^9, 3.48266110607915*^9, {
   3.4826656755777893`*^9, 3.4603453844097233`*^9}, 3.4827329198242073`*^9, 
   3.483268324437192*^9, 3.483274850926392*^9, 3.4833558508365517`*^9, 
   3.495174843674325*^9, 3.497953182092972*^9, 3.497953507891675*^9, 
   3.501484228848415*^9, {3.50148654425138*^9, 3.460390564454529*^9}, 
   3.460429437396255*^9, 3.4604295047416677`*^9, {3.5039996152234488`*^9, 
   3.460343374113392*^9}, {3.460397546195798*^9, 3.460397556094911*^9}, {
   3.460397612427554*^9, 3.4603976186530657`*^9}, 3.460397722451044*^9, 
   3.4603982450435953`*^9, {3.460625316245699*^9, 3.460365984388968*^9}, 
   3.460373401431588*^9, 3.541435714454726*^9, 3.5414410337725983`*^9, 
   3.541999863034059*^9, 3.542001542564604*^9, {3.542470853584126*^9, 
   3.542470865954557*^9}, 3.54355831387562*^9, 3.543559065921431*^9, 
   3.543560117374753*^9, 3.543560268617474*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"solc", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"tmp", "\[Equal]", "0"}], ",", "c"}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4826458619731216`*^9, 3.482645885469399*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"c", "\[Rule]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", "a", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["r", "2"]}], " ", 
       RowBox[{"A", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
      RowBox[{"T", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", " ", 
    RowBox[{"f", "[", "r", "]"}], " ", 
    RowBox[{"F", "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
    RowBox[{"j", "[", "r", "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.482645866916765*^9, 3.482645885850039*^9}, 
   3.482646612112681*^9, 3.482654336644636*^9, 3.48266103912289*^9, 
   3.482661106661934*^9, {3.482665675773703*^9, 3.4603453850827007`*^9}, 
   3.482732919892187*^9, 3.4832683244871187`*^9, 3.483274851026471*^9, 
   3.483355850902607*^9, 3.495174843797553*^9, 3.497953182236517*^9, 
   3.497953507962245*^9, 3.501484228947846*^9, {3.501486544367445*^9, 
   3.460390564571981*^9}, 3.4604294374785643`*^9, 3.4604295052381477`*^9, {
   3.503999615273387*^9, 3.46034337432885*^9}, {3.4603975464008017`*^9, 
   3.460397559265963*^9}, {3.460397608269051*^9, 3.460397619840056*^9}, 
   3.460397723756569*^9, 3.460398245129245*^9, {3.460625316305313*^9, 
   3.460365984499096*^9}, 3.460373401538006*^9, 3.541435714497484*^9, 
   3.5414410338127327`*^9, 3.541999863090201*^9, 3.542001542611764*^9, {
   3.542470853926465*^9, 3.54247086697196*^9}, 3.5435583139586277`*^9, 
   3.543559066050992*^9, 3.543560117419382*^9, 3.543560268674528*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"norm", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"trT", "[", 
     RowBox[{
      RowBox[{"outerT", "[", 
       RowBox[{"NormVec", ",", "NormVec"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "]"}], "/.", "solc"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.482645887033798*^9, 3.482645944381516*^9}, 
   3.482646520071669*^9, {3.4826610549294243`*^9, 3.482661055727974*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"4", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"B", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
      RowBox[{"S", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
    RowBox[{"\[CapitalDelta]", "[", 
     RowBox[{"r", ",", "a"}], "]"}]}], 
   RowBox[{"g", "[", "a", "]"}]], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SuperscriptBox["a", "2"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["r", "2"]}], " ", 
      RowBox[{"A", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
     RowBox[{"T", "[", 
      RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
   SuperscriptBox["r", "2"], " ", 
   SuperscriptBox[
    RowBox[{"F", "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
   RowBox[{"j", "[", "r", "]"}], " ", 
   RowBox[{"\[CapitalDelta]", "[", 
    RowBox[{"r", ",", "a"}], "]"}]}]}]], "Output",
 CellChangeTimes->{{3.4826459114463377`*^9, 3.482645946064207*^9}, 
   3.482646521174985*^9, 3.482646612179653*^9, 3.4826543367113037`*^9, {
   3.482661039770041*^9, 3.482661057205875*^9}, 3.482661107310892*^9, {
   3.482665675844986*^9, 3.460345385891876*^9}, 3.482732919959566*^9, 
   3.483268324537109*^9, 3.483274851126627*^9, 3.48335585096931*^9, 
   3.495174843861245*^9, 3.4979531822934227`*^9, 3.4979535080257998`*^9, 
   3.501484229049124*^9, {3.501486544483901*^9, 3.4603905646877317`*^9}, 
   3.460429437562561*^9, 3.460429505307798*^9, {3.503999615328701*^9, 
   3.460343374428726*^9}, {3.460397546467606*^9, 3.460397560792774*^9}, {
   3.4603976234983683`*^9, 3.460397639647757*^9}, {3.460397714992196*^9, 
   3.460397724666641*^9}, 3.4603982452107267`*^9, {3.460625316353703*^9, 
   3.4603659845427628`*^9}, 3.460373401583537*^9, 3.541435714536965*^9, 
   3.541441033856237*^9, 3.5419998783147707`*^9, 3.542001542654808*^9, {
   3.5424708546472063`*^9, 3.542470878483901*^9}, 3.543558313991535*^9, 
   3.543559066183305*^9, 3.5435601174636393`*^9, 3.543560268718308*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NormVec", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "u", "}"}], ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"Sqrt", "[", "norm", "]"}]], 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", "4"]}], " ", "a", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["r", "2"]}], " ", 
            RowBox[{"A", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
           RowBox[{"T", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", " ", 
         RowBox[{"f", "[", "r", "]"}], " ", 
         RowBox[{"F", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
         RowBox[{"j", "[", "r", "]"}]}], ",", "1", ",", "0", ",", "0", ",", 
        "0"}], "}"}]}], "]"}]}], "}"}]}]], "Input",
 CellChangeTimes->{
  3.4826458784255457`*^9, {3.4826459516081743`*^9, 3.482645973654932*^9}, {
   3.482646535197999*^9, 3.4826465537111883`*^9}, {3.4826610604906797`*^9, 
   3.460345405029395*^9}, 3.4832683401604548`*^9, {3.4979535355921383`*^9, 
   3.460397584552984*^9}, {3.460397713227003*^9, 3.460366049162068*^9}, 
   3.541441069057948*^9, {3.541999902156464*^9, 3.5419999028934383`*^9}, {
   3.542470877241432*^9, 3.542470884534902*^9}, 3.543559158392921*^9, {
   3.5435602464656982`*^9, 3.543560246576253*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "u", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"a", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["r", "2"]}], " ", 
           RowBox[{"A", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
          RowBox[{"T", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", " ", 
        RowBox[{"f", "[", "r", "]"}], " ", 
        RowBox[{"F", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
        RowBox[{"j", "[", "r", "]"}]}], 
       RowBox[{"2", " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{"16", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", 
                 RowBox[{"B", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                RowBox[{"S", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
             RowBox[{"g", "[", "a", "]"}]], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["r", "2"]}], " ", 
                RowBox[{"A", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
               RowBox[{"T", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
             SuperscriptBox["r", "2"], " ", 
             SuperscriptBox[
              RowBox[{"F", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
             RowBox[{"j", "[", "r", "]"}]}]}], ")"}], " ", 
          RowBox[{"\[CapitalDelta]", "[", 
           RowBox[{"r", ",", "a"}], "]"}]}]]}]]}], ",", 
     FractionBox["2", 
      SqrtBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               RowBox[{"B", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
              RowBox[{"S", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
           RowBox[{"g", "[", "a", "]"}]], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["r", "2"]}], " ", 
              RowBox[{"A", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
             RowBox[{"T", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox[
            RowBox[{"F", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
           RowBox[{"j", "[", "r", "]"}]}]}], ")"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}]]], ",", "0", ",", "0", ",", "0"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.482645879356182*^9, {3.482645961553833*^9, 3.482645974077807*^9}, 
   3.482646612245695*^9, 3.482654336777485*^9, {3.482661040321257*^9, 
   3.482661062939979*^9}, 3.482661109026106*^9, {3.482665675938364*^9, 
   3.460345405768785*^9}, 3.4827329202064533`*^9, 3.483268341264225*^9, 
   3.483274851436404*^9, 3.4833558512792063`*^9, 3.495174844184272*^9, 
   3.497953182665312*^9, 3.497953538324436*^9, 3.501484229381893*^9, {
   3.501486544818342*^9, 3.460390565416277*^9}, 3.46042943833361*^9, 
   3.460429506062654*^9, {3.50399961569064*^9, 3.460343375184429*^9}, {
   3.460397567778631*^9, 3.4603975855753593`*^9}, {3.46039764461899*^9, 
   3.460397647414546*^9}, 3.4603977312320147`*^9, 3.460398247315359*^9, {
   3.460625318355755*^9, 3.460366050527224*^9}, 3.460373403563223*^9, 
   3.541435715780294*^9, 3.541441072499552*^9, 3.541999904665681*^9, 
   3.5420015435324783`*^9, {3.542470879969433*^9, 3.542470885114746*^9}, 
   3.543558314663939*^9, 3.543559160204678*^9, 3.543560118484927*^9, 
   3.543560269849351*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"trT", "[", 
   RowBox[{
    RowBox[{"outerT", "[", 
     RowBox[{"NormVec", ",", "NormVec"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.482661065734774*^9, 3.4826610789595137`*^9}}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{
  3.4826610793363543`*^9, 3.482661109925275*^9, {3.482665675994561*^9, 
   3.460345406663004*^9}, 3.4827329202736473`*^9, 3.483268342771421*^9, 
   3.483268383662122*^9, 3.483274851751947*^9, 3.483355851334548*^9, 
   3.495174844626775*^9, 3.497953182736599*^9, 3.4979535393096867`*^9, 
   3.501484229641233*^9, {3.5014865451460876`*^9, 3.460390565682083*^9}, 
   3.4604294385425787`*^9, 3.460429506244069*^9, {3.503999615763026*^9, 
   3.46034337543242*^9}, 3.4603977334598703`*^9, 3.460398247593706*^9, {
   3.46062531857738*^9, 3.46036605146989*^9}, 3.460373403796906*^9, 
   3.5414357160380907`*^9, 3.541441073950495*^9, 3.541999906169791*^9, 
   3.542001543647773*^9, {3.5424708814372797`*^9, 3.542470886084831*^9}, 
   3.5435583147070503`*^9, 3.543559161773851*^9, 3.543560118691104*^9, 
   3.543560269916297*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"trT", "[", 
   RowBox[{
    RowBox[{"outerT", "[", 
     RowBox[{"TangVec", ",", "NormVec"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{3.482661116857547*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.48266111728564*^9, {3.4826656760602818`*^9, 3.460345407972846*^9}, 
   3.4827329203405867`*^9, 3.483268343566309*^9, 3.483268384244651*^9, 
   3.483274851858819*^9, 3.483355851401087*^9, 3.49517484474189*^9, 
   3.497953182835265*^9, 3.497953540192875*^9, 3.501484229735509*^9, {
   3.501486545266227*^9, 3.460390565785603*^9}, 3.460429438666939*^9, 
   3.460429506302597*^9, {3.50399961586336*^9, 3.4603433755067387`*^9}, 
   3.460397734590137*^9, 3.460398247777378*^9, {3.460625318633223*^9, 
   3.460366052308152*^9}, 3.4603734039171886`*^9, 3.5414357162502317`*^9, 
   3.541441074853291*^9, 3.541999906896966*^9, 3.542001543680332*^9, 
   3.542470887012957*^9, 3.543558314853552*^9, 3.543559162805441*^9, 
   3.5435601188576527`*^9, 3.5435602699860907`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"q", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"d", ",", "d"}], "}"}], ",", 
       RowBox[{"Gd", "-", 
        RowBox[{
         RowBox[{"outerT", "[", 
          RowBox[{"NormVec", ",", "NormVec"}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MatrixForm", "[", "Gd", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", 
  RowBox[{"q", "[", 
   RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.482661126460228*^9, 3.4826611805206537`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"T", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox[
        RowBox[{"f", "[", "r", "]"}], "2"], " ", 
       RowBox[{"j", "[", "r", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], "0", "0", "0", "0", "0"},
     {"0", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"A", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
          RowBox[{"T", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"f", "[", "r", "]"}], "2"], " ", 
        RowBox[{"j", "[", "r", "]"}]}]], 
      FractionBox[
       RowBox[{"a", " ", "r", " ", 
        RowBox[{"F", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], 
       RowBox[{"f", "[", "r", "]"}]], "0", "0", "0"},
     {"0", 
      FractionBox[
       RowBox[{"a", " ", "r", " ", 
        RowBox[{"F", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], 
       RowBox[{"f", "[", "r", "]"}]], 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"B", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
          RowBox[{"S", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], 
       RowBox[{"g", "[", "a", "]"}]], "0", "0", "0"},
     {"0", "0", "0", 
      FractionBox[
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"S", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
        RowBox[{"g", "[", "a", "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], 
       RowBox[{"1", "-", 
        SuperscriptBox["\[Theta]1", "2"]}]], "0", "0"},
     {"0", "0", "0", "0", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], "0"},
     {"0", "0", "0", "0", "0", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
       SuperscriptBox["\[Theta]1", "2"], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.482661147027567*^9, 3.4826611807315187`*^9}, {
   3.4826656761300983`*^9, 3.4603454098331013`*^9}, 3.4827329204079514`*^9, 
   3.48326838558283*^9, 3.483274851960454*^9, 3.483355851470969*^9, 
   3.495174844808804*^9, 3.497953183117558*^9, 3.497953541537301*^9, 
   3.501484229835047*^9, {3.501486545371581*^9, 3.460390565903183*^9}, 
   3.460429438778407*^9, 3.460429506389037*^9, {3.503999615962226*^9, 
   3.4603433755939074`*^9}, 3.460397739642098*^9, 3.460398247939376*^9, {
   3.4606253186910763`*^9, 3.4603660533651037`*^9}, 3.4603734040724487`*^9, 
   3.541435716778173*^9, 3.541441075915968*^9, 3.5419999078299932`*^9, 
   3.5420015437151937`*^9, 3.542470888023245*^9, 3.543558332985569*^9, 
   3.543559163773695*^9, 3.54356011910111*^9, 3.5435602700606422`*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"T", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox[
        RowBox[{"f", "[", "r", "]"}], "2"], " ", 
       RowBox[{"j", "[", "r", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], "0", "0", "0", "0", "0"},
     {"0", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"A", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
          RowBox[{"T", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"f", "[", "r", "]"}], "2"], " ", 
        RowBox[{"j", "[", "r", "]"}]}]], 
      FractionBox[
       RowBox[{"a", " ", "r", " ", 
        RowBox[{"F", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], 
       RowBox[{"f", "[", "r", "]"}]], "0", "0", "0"},
     {"0", 
      FractionBox[
       RowBox[{"a", " ", "r", " ", 
        RowBox[{"F", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], 
       RowBox[{"f", "[", "r", "]"}]], 
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["r", "2"]}], " ", 
          RowBox[{"A", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
         RowBox[{"T", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox[
        RowBox[{"F", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
       RowBox[{"j", "[", "r", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], "0", "0", "0"},
     {"0", "0", "0", 
      FractionBox[
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"S", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
        RowBox[{"g", "[", "a", "]"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], 
       RowBox[{"1", "-", 
        SuperscriptBox["\[Theta]1", "2"]}]], "0", "0"},
     {"0", "0", "0", "0", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "2"]}], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], "0"},
     {"0", "0", "0", "0", "0", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"S", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
       SuperscriptBox["\[Theta]1", "2"], " ", 
       RowBox[{"g", "[", "a", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.482661147027567*^9, 3.4826611807315187`*^9}, {
   3.4826656761300983`*^9, 3.4603454098331013`*^9}, 3.4827329204079514`*^9, 
   3.48326838558283*^9, 3.483274851960454*^9, 3.483355851470969*^9, 
   3.495174844808804*^9, 3.497953183117558*^9, 3.497953541537301*^9, 
   3.501484229835047*^9, {3.501486545371581*^9, 3.460390565903183*^9}, 
   3.460429438778407*^9, 3.460429506389037*^9, {3.503999615962226*^9, 
   3.4603433755939074`*^9}, 3.460397739642098*^9, 3.460398247939376*^9, {
   3.4606253186910763`*^9, 3.4603660533651037`*^9}, 3.4603734040724487`*^9, 
   3.541435716778173*^9, 3.541441075915968*^9, 3.5419999078299932`*^9, 
   3.5420015437151937`*^9, 3.542470888023245*^9, 3.543558332985569*^9, 
   3.543559163773695*^9, 3.54356011910111*^9, 3.543560270064352*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"trT", "[", 
    RowBox[{
     RowBox[{"outerT", "[", 
      RowBox[{"q", ",", "NormVec"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"trT", "[", 
    RowBox[{
     RowBox[{"outerT", "[", 
      RowBox[{"q", ",", "TangVec"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"trT", "[", 
   RowBox[{
    RowBox[{"outerT", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"d", ",", "d"}], "}"}], ",", "Gd"}], "}"}], ",", "TangVec"}],
      "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.4826611936232367`*^9, 3.482661223289483*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "d", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.482661206242777*^9, 3.4826612240707273`*^9}, {
   3.482665676264707*^9, 3.460345436476618*^9}, 3.482732920482984*^9, 
   3.4832683872309437`*^9, 3.4832748520751867`*^9, 3.483355851783144*^9, 
   3.495174844893948*^9, 3.497953183445979*^9, 3.4979535425295963`*^9, 
   3.501484229967771*^9, {3.5014865454883547`*^9, 3.460390566032054*^9}, 
   3.4604294389890823`*^9, 3.460429506493195*^9, {3.503999616253805*^9, 
   3.4603433757070503`*^9}, 3.460397743066276*^9, 3.460398248143712*^9, {
   3.460625318805606*^9, 3.4603660544298983`*^9}, 3.4603734042813787`*^9, 
   3.541435717627144*^9, 3.541441077040722*^9, 3.5419999091531487`*^9, 
   3.542001543768545*^9, 3.542470889806849*^9, 3.5435583341576567`*^9, 
   3.543559165014237*^9, 3.5435601195869713`*^9, 3.5435602702554607`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "d", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"A", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{"T", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"f", "[", "r", "]"}], "2"], " ", 
       RowBox[{"j", "[", "r", "]"}]}]], ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"f", "[", "r", "]"}]], ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.482661206242777*^9, 3.4826612240707273`*^9}, {
   3.482665676264707*^9, 3.460345436476618*^9}, 3.482732920482984*^9, 
   3.4832683872309437`*^9, 3.4832748520751867`*^9, 3.483355851783144*^9, 
   3.495174844893948*^9, 3.497953183445979*^9, 3.4979535425295963`*^9, 
   3.501484229967771*^9, {3.5014865454883547`*^9, 3.460390566032054*^9}, 
   3.4604294389890823`*^9, 3.460429506493195*^9, {3.503999616253805*^9, 
   3.4603433757070503`*^9}, 3.460397743066276*^9, 3.460398248143712*^9, {
   3.460625318805606*^9, 3.4603660544298983`*^9}, 3.4603734042813787`*^9, 
   3.541435717627144*^9, 3.541441077040722*^9, 3.5419999091531487`*^9, 
   3.542001543768545*^9, 3.542470889806849*^9, 3.5435583341576567`*^9, 
   3.543559165014237*^9, 3.5435601195869713`*^9, 3.543560270309209*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "d", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"A", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{"T", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"f", "[", "r", "]"}], "2"], " ", 
       RowBox[{"j", "[", "r", "]"}]}]], ",", 
     FractionBox[
      RowBox[{"a", " ", "r", " ", 
       RowBox[{"F", "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], 
      RowBox[{"f", "[", "r", "]"}]], ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.482661206242777*^9, 3.4826612240707273`*^9}, {
   3.482665676264707*^9, 3.460345436476618*^9}, 3.482732920482984*^9, 
   3.4832683872309437`*^9, 3.4832748520751867`*^9, 3.483355851783144*^9, 
   3.495174844893948*^9, 3.497953183445979*^9, 3.4979535425295963`*^9, 
   3.501484229967771*^9, {3.5014865454883547`*^9, 3.460390566032054*^9}, 
   3.4604294389890823`*^9, 3.460429506493195*^9, {3.503999616253805*^9, 
   3.4603433757070503`*^9}, 3.460397743066276*^9, 3.460398248143712*^9, {
   3.460625318805606*^9, 3.4603660544298983`*^9}, 3.4603734042813787`*^9, 
   3.541435717627144*^9, 3.541441077040722*^9, 3.5419999091531487`*^9, 
   3.542001543768545*^9, 3.542470889806849*^9, 3.5435583341576567`*^9, 
   3.543559165014237*^9, 3.5435601195869713`*^9, 3.543560270355609*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"K", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"trT", "[", 
    RowBox[{
     RowBox[{"outerT", "[", 
      RowBox[{"q", ",", 
       RowBox[{"trT", "[", 
        RowBox[{
         RowBox[{"outerT", "[", 
          RowBox[{"q", ",", 
           RowBox[{"covDT", "[", "NormVec", "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"2", ",", "4"}], "}"}], "}"}]}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2", ",", "4"}], "}"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.482661293018702*^9, 3.4826613845439863`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"d", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["r", "2"]}], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox[
            RowBox[{"f", "[", "r", "]"}], "2"], " ", 
           RowBox[{"j", "[", "r", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "a", " ", "r", " ", 
              RowBox[{"F", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
              RowBox[{"j", "[", "r", "]"}], " ", 
              RowBox[{"\[CapitalDelta]", "[", 
               RowBox[{"r", ",", "a"}], "]"}], " ", 
              RowBox[{
               SuperscriptBox["f", "\[Prime]",
                MultilineFunction->None], "[", "r", "]"}]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["r", "2"], " ", 
                 RowBox[{"A", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                RowBox[{"T", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["\[CapitalDelta]", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"r", ",", "a"}], "]"}], "+", 
                RowBox[{
                 RowBox[{"\[CapitalDelta]", "[", 
                  RowBox[{"r", ",", "a"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["T", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
             RowBox[{"a", " ", 
              RowBox[{"f", "[", "r", "]"}], " ", 
              RowBox[{"F", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"r", " ", 
                 RowBox[{"\[CapitalDelta]", "[", 
                  RowBox[{"r", ",", "a"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["j", "\[Prime]",
                   MultilineFunction->None], "[", "r", "]"}]}], "+", 
                RowBox[{
                 RowBox[{"j", "[", "r", "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{
                    RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", 
                    RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                  ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"4", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               FractionBox[
                RowBox[{"16", " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
                RowBox[{"g", "[", "a", "]"}]], "-", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox["r", "2"]}], " ", 
                   RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                  RowBox[{"T", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                SuperscriptBox["r", "2"], " ", 
                SuperscriptBox[
                 RowBox[{"F", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
                RowBox[{"j", "[", "r", "]"}]}]}], ")"}], " ", 
             RowBox[{"\[CapitalDelta]", "[", 
              RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}]}], ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"A", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{"T", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["\[CapitalDelta]", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"r", ",", "a"}], "]"}], "+", 
             RowBox[{
              RowBox[{"\[CapitalDelta]", "[", 
               RowBox[{"r", ",", "a"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["r", "2"], " ", 
                 RowBox[{
                  SuperscriptBox["A", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                RowBox[{
                 SuperscriptBox["T", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], ")"}]}]}], 
            ")"}]}], "+", 
          RowBox[{"a", " ", 
           RowBox[{"f", "[", "r", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "r", " ", 
              RowBox[{"j", "[", "r", "]"}], " ", 
              RowBox[{"\[CapitalDelta]", "[", 
               RowBox[{"r", ",", "a"}], "]"}], " ", 
              RowBox[{
               SuperscriptBox["F", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{
              RowBox[{"F", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "r"}], " ", 
                 RowBox[{"\[CapitalDelta]", "[", 
                  RowBox[{"r", ",", "a"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["j", "\[Prime]",
                   MultilineFunction->None], "[", "r", "]"}]}], "+", 
                RowBox[{
                 RowBox[{"j", "[", "r", "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "r"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                   RowBox[{
                    RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["r", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                  ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"f", "[", "r", "]"}], "2"], " ", 
          RowBox[{"j", "[", "r", "]"}], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              FractionBox[
               RowBox[{"16", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
               RowBox[{"g", "[", "a", "]"}]], "-", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["r", "2"]}], " ", 
                  RowBox[{"A", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                 RowBox[{"T", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
               SuperscriptBox["r", "2"], " ", 
               SuperscriptBox[
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
               RowBox[{"j", "[", "r", "]"}]}]}], ")"}], " ", 
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["r", "2"]}], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", " ", 
          RowBox[{"F", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["r", "2"], " ", 
                RowBox[{"A", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{"T", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["\[CapitalDelta]", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"r", ",", "a"}], "]"}], "+", 
               RowBox[{
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["r", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{"a", " ", 
             RowBox[{"f", "[", "r", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", "r", " ", 
                RowBox[{"j", "[", "r", "]"}], " ", 
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{
                 SuperscriptBox["F", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "r"}], " ", 
                   RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["j", "\[Prime]",
                    MultilineFunction->None], "[", "r", "]"}]}], "+", 
                  RowBox[{
                   RowBox[{"j", "[", "r", "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "r"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["r", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"4", " ", 
          RowBox[{"f", "[", "r", "]"}], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              FractionBox[
               RowBox[{"16", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
               RowBox[{"g", "[", "a", "]"}]], "-", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["r", "2"]}], " ", 
                  RowBox[{"A", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                 RowBox[{"T", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
               SuperscriptBox["r", "2"], " ", 
               SuperscriptBox[
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
               RowBox[{"j", "[", "r", "]"}]}]}], ")"}], " ", 
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}], ",", "0", ",", "0",
        ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["r", "2"]}], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", " ", 
          RowBox[{"F", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["r", "2"], " ", 
                RowBox[{"A", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{"T", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["\[CapitalDelta]", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"r", ",", "a"}], "]"}], "+", 
               RowBox[{
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["r", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{"a", " ", 
             RowBox[{"f", "[", "r", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", "r", " ", 
                RowBox[{"j", "[", "r", "]"}], " ", 
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{
                 SuperscriptBox["F", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "r"}], " ", 
                   RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["j", "\[Prime]",
                    MultilineFunction->None], "[", "r", "]"}]}], "+", 
                  RowBox[{
                   RowBox[{"j", "[", "r", "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "r"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["r", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"4", " ", 
          RowBox[{"f", "[", "r", "]"}], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              FractionBox[
               RowBox[{"16", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
               RowBox[{"g", "[", "a", "]"}]], "-", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["r", "2"]}], " ", 
                  RowBox[{"A", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                 RowBox[{"T", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
               SuperscriptBox["r", "2"], " ", 
               SuperscriptBox[
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
               RowBox[{"j", "[", "r", "]"}]}]}], ")"}], " ", 
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["r", "2"], " ", 
               RowBox[{"A", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
              RowBox[{"T", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], ")"}]}]], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"F", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
          RowBox[{"j", "[", "r", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["r", "2"], " ", 
                RowBox[{"A", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{"T", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["\[CapitalDelta]", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"r", ",", "a"}], "]"}], "+", 
               RowBox[{
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["r", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{"a", " ", 
             RowBox[{"f", "[", "r", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", "r", " ", 
                RowBox[{"j", "[", "r", "]"}], " ", 
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{
                 SuperscriptBox["F", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "r"}], " ", 
                   RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["j", "\[Prime]",
                    MultilineFunction->None], "[", "r", "]"}]}], "+", 
                  RowBox[{
                   RowBox[{"j", "[", "r", "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "r"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["r", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"16", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              FractionBox[
               RowBox[{"16", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
               RowBox[{"g", "[", "a", "]"}]], "-", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["r", "2"]}], " ", 
                  RowBox[{"A", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                 RowBox[{"T", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
               SuperscriptBox["r", "2"], " ", 
               SuperscriptBox[
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
               RowBox[{"j", "[", "r", "]"}]}]}], ")"}], " ", 
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}], ",", "0", ",", "0",
        ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["r", "2"]}], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{"S", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], "-", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", "a", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["r", "2"], " ", 
                RowBox[{"A", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{"T", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
             RowBox[{"\[CapitalDelta]", "[", 
              RowBox[{"r", ",", "a"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["g", "\[Prime]",
               MultilineFunction->None], "[", "a", "]"}]}], "+", 
            RowBox[{
             RowBox[{"g", "[", "a", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "4"}], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"a", " ", "r", " ", 
                   RowBox[{"f", "[", "r", "]"}], " ", 
                   RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                   RowBox[{"j", "[", "r", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "8"}], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
                  RowBox[{"4", " ", "a", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", "r", " ", 
                   RowBox[{"f", "[", "r", "]"}], " ", 
                   RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                   RowBox[{"j", "[", "r", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
              ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              FractionBox[
               RowBox[{"16", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
               RowBox[{"g", "[", "a", "]"}]], "-", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["r", "2"]}], " ", 
                  RowBox[{"A", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                 RowBox[{"T", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
               SuperscriptBox["r", "2"], " ", 
               SuperscriptBox[
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
               RowBox[{"j", "[", "r", "]"}]}]}], ")"}], " ", 
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}], ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["r", "2"]}], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{"S", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], "-", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", "a", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["r", "2"], " ", 
                RowBox[{"A", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{"T", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
             RowBox[{"\[CapitalDelta]", "[", 
              RowBox[{"r", ",", "a"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["g", "\[Prime]",
               MultilineFunction->None], "[", "a", "]"}]}], "+", 
            RowBox[{
             RowBox[{"g", "[", "a", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "4"}], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"a", " ", "r", " ", 
                   RowBox[{"f", "[", "r", "]"}], " ", 
                   RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                   RowBox[{"j", "[", "r", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "8"}], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
                  RowBox[{"4", " ", "a", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", "r", " ", 
                   RowBox[{"f", "[", "r", "]"}], " ", 
                   RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                   RowBox[{"j", "[", "r", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
              ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"4", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              FractionBox[
               RowBox[{"16", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
               RowBox[{"g", "[", "a", "]"}]], "-", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["r", "2"]}], " ", 
                  RowBox[{"A", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                 RowBox[{"T", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
               SuperscriptBox["r", "2"], " ", 
               SuperscriptBox[
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
               RowBox[{"j", "[", "r", "]"}]}]}], ")"}], " ", 
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}], ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["r", "2"]}], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{"S", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], "-", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
          SuperscriptBox["\[Theta]1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "a", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["r", "2"], " ", 
                RowBox[{"A", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{"T", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
             RowBox[{"\[CapitalDelta]", "[", 
              RowBox[{"r", ",", "a"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["g", "\[Prime]",
               MultilineFunction->None], "[", "a", "]"}]}], "+", 
            RowBox[{
             RowBox[{"g", "[", "a", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"4", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "-", 
                  RowBox[{"a", " ", "r", " ", 
                   RowBox[{"f", "[", "r", "]"}], " ", 
                   RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                   RowBox[{"j", "[", "r", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"8", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                  RowBox[{"4", " ", "a", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", "r", " ", 
                   RowBox[{"f", "[", "r", "]"}], " ", 
                   RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                   RowBox[{"j", "[", "r", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
              ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"4", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              FractionBox[
               RowBox[{"16", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
               RowBox[{"g", "[", "a", "]"}]], "-", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["r", "2"]}], " ", 
                  RowBox[{"A", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                 RowBox[{"T", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
               SuperscriptBox["r", "2"], " ", 
               SuperscriptBox[
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
               RowBox[{"j", "[", "r", "]"}]}]}], ")"}], " ", 
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}]}], "}"}]}], "}"}]}],
   "}"}]], "Output",
 CellChangeTimes->{
  3.482661298062799*^9, {3.4826613789254103`*^9, 3.482661407354897*^9}, {
   3.482665680028101*^9, 3.4603454460941763`*^9}, 3.482732930365775*^9, 
   3.483268398775249*^9, 3.483274861473762*^9, 3.48335586118395*^9, 
   3.495174854349127*^9, 3.4979532134025087`*^9, 3.497953553172243*^9, 
   3.501484239811926*^9, {3.501486555298568*^9, 3.460390578166481*^9}, 
   3.4604294518046227`*^9, 3.4604295186905117`*^9, {3.503999633797913*^9, 
   3.460343388099977*^9}, {3.4603977842107477`*^9, 3.460397798548231*^9}, 
   3.460398265784686*^9, {3.4606253370668373`*^9, 3.460366073190826*^9}, 
   3.460373420824457*^9, 3.5414359951685543`*^9, 3.541441086697323*^9, 
   3.541999916758959*^9, 3.542001550117902*^9, 3.542470901348476*^9, 
   3.543558345123048*^9, 3.543559177229846*^9, 3.5435601787178297`*^9, 
   3.543560281546606*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Isreal", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"K", "-", 
     RowBox[{"kappa", " ", "q"}]}], ")"}], "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.482661408999899*^9, 3.460345429549082*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"T", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]]}], " ", "kappa", " ", 
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox[
        RowBox[{"f", "[", "r", "]"}], "2"], " ", 
       RowBox[{"j", "[", "r", "]"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["r", "2"]}], " ", 
           RowBox[{"A", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox[
          RowBox[{"f", "[", "r", "]"}], "2"], " ", 
         RowBox[{"j", "[", "r", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "a", " ", "r", " ", 
            RowBox[{"F", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
            RowBox[{"j", "[", "r", "]"}], " ", 
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"r", ",", "a"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["f", "\[Prime]",
              MultilineFunction->None], "[", "r", "]"}]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["r", "2"], " ", 
               RowBox[{"A", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
              RowBox[{"T", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["\[CapitalDelta]", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"r", ",", "a"}], "]"}], "+", 
              RowBox[{
               RowBox[{"\[CapitalDelta]", "[", 
                RowBox[{"r", ",", "a"}], "]"}], " ", 
               RowBox[{
                SuperscriptBox["T", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{"a", " ", 
            RowBox[{"f", "[", "r", "]"}], " ", 
            RowBox[{"F", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"r", " ", 
               RowBox[{"\[CapitalDelta]", "[", 
                RowBox[{"r", ",", "a"}], "]"}], " ", 
               RowBox[{
                SuperscriptBox["j", "\[Prime]",
                 MultilineFunction->None], "[", "r", "]"}]}], "+", 
              RowBox[{
               RowBox[{"j", "[", "r", "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"r", " ", 
                  RowBox[{
                   SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                 RowBox[{
                  RowBox[{"\[CapitalDelta]", "[", 
                   RowBox[{"r", ",", "a"}], "]"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"2", "+", 
                    RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"4", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             FractionBox[
              RowBox[{"16", " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["a", "2"], " ", 
                  RowBox[{"B", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                 RowBox[{"S", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
              RowBox[{"g", "[", "a", "]"}]], "-", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["r", "2"]}], " ", 
                 RowBox[{"A", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                RowBox[{"T", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
              SuperscriptBox["r", "2"], " ", 
              SuperscriptBox[
               RowBox[{"F", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
              RowBox[{"j", "[", "r", "]"}]}]}], ")"}], " ", 
           RowBox[{"\[CapitalDelta]", "[", 
            RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}]}], ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["r", "2"], " ", 
            RowBox[{"A", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
           RowBox[{"T", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "kappa", " ", 
         RowBox[{"\[CapitalDelta]", "[", 
          RowBox[{"r", ",", "a"}], "]"}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"f", "[", "r", "]"}], "2"], " ", 
         RowBox[{"j", "[", "r", "]"}]}]]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"A", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["\[CapitalDelta]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"r", ",", "a"}], "]"}], "+", 
            RowBox[{
             RowBox[{"\[CapitalDelta]", "[", 
              RowBox[{"r", ",", "a"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["r", "2"], " ", 
                RowBox[{
                 SuperscriptBox["A", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{
                SuperscriptBox["T", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"a", " ", 
          RowBox[{"f", "[", "r", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "r", " ", 
             RowBox[{"j", "[", "r", "]"}], " ", 
             RowBox[{"\[CapitalDelta]", "[", 
              RowBox[{"r", ",", "a"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["F", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"F", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "r"}], " ", 
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{
                 SuperscriptBox["j", "\[Prime]",
                  MultilineFunction->None], "[", "r", "]"}]}], "+", 
               RowBox[{
                RowBox[{"j", "[", "r", "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "r"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{
                   RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["r", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                 ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"f", "[", "r", "]"}], "2"], " ", 
         RowBox[{"j", "[", "r", "]"}], " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             FractionBox[
              RowBox[{"16", " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["a", "2"], " ", 
                  RowBox[{"B", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                 RowBox[{"S", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
              RowBox[{"g", "[", "a", "]"}]], "-", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["r", "2"]}], " ", 
                 RowBox[{"A", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                RowBox[{"T", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
              SuperscriptBox["r", "2"], " ", 
              SuperscriptBox[
               RowBox[{"F", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
              RowBox[{"j", "[", "r", "]"}]}]}], ")"}], " ", 
           RowBox[{"\[CapitalDelta]", "[", 
            RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}]}], ",", "0"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"S", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", "kappa", " ", 
         RowBox[{"g", "[", "a", "]"}], " ", 
         RowBox[{"\[CapitalDelta]", "[", 
          RowBox[{"r", ",", "a"}], "]"}]}], 
        RowBox[{"1", "-", 
         SuperscriptBox["\[Theta]1", "2"]}]]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["r", "2"]}], " ", 
            RowBox[{"A", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}], "-", 
           RowBox[{"T", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", "a", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["r", "2"], " ", 
               RowBox[{"A", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
              RowBox[{"T", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"r", ",", "a"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["g", "\[Prime]",
              MultilineFunction->None], "[", "a", "]"}]}], "+", 
           RowBox[{
            RowBox[{"g", "[", "a", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "4"}], " ", 
                  SuperscriptBox["\[ExponentialE]", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                  RowBox[{
                   SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                 RowBox[{"a", " ", "r", " ", 
                  RowBox[{"f", "[", "r", "]"}], " ", 
                  RowBox[{"F", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                  RowBox[{"j", "[", "r", "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"\[CapitalDelta]", "[", 
                RowBox[{"r", ",", "a"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "8"}], " ", 
                  SuperscriptBox["\[ExponentialE]", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
                 RowBox[{"4", " ", "a", " ", 
                  SuperscriptBox["\[ExponentialE]", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                  RowBox[{
                   SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["a", "2"], " ", "r", " ", 
                  RowBox[{"f", "[", "r", "]"}], " ", 
                  RowBox[{"F", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                  RowBox[{"j", "[", "r", "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["\[Theta]1", "2"]}], ")"}], " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             FractionBox[
              RowBox[{"16", " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["a", "2"], " ", 
                  RowBox[{"B", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                 RowBox[{"S", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
              RowBox[{"g", "[", "a", "]"}]], "-", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["r", "2"]}], " ", 
                 RowBox[{"A", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                RowBox[{"T", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
              SuperscriptBox["r", "2"], " ", 
              SuperscriptBox[
               RowBox[{"F", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
              RowBox[{"j", "[", "r", "]"}]}]}], ")"}], " ", 
           RowBox[{"\[CapitalDelta]", "[", 
            RowBox[{"r", ",", "a"}], "]"}]}]]}], ")"}]}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.482661417014008*^9, 3.4826614533611383`*^9}, {
   3.4826656802370787`*^9, 3.460345448910265*^9}, 3.482732930558614*^9, 
   3.483268399038637*^9, 3.483274861778748*^9, 3.483355861490382*^9, 
   3.4951748546348877`*^9, 3.4979532137836933`*^9, 3.497953553404372*^9, 
   3.5014842401084003`*^9, {3.501486555592925*^9, 3.4603905784484367`*^9}, 
   3.460429452117546*^9, 3.460429518846084*^9, {3.5039996340815783`*^9, 
   3.460343388292631*^9}, 3.460397799787715*^9, 3.4603982659972563`*^9, {
   3.4606253373449287`*^9, 3.460366073407278*^9}, 3.460373421073736*^9, 
   3.541435995372622*^9, 3.5414410868945427`*^9, 3.541999916909121*^9, 
   3.542001550292705*^9, 3.542470901536786*^9, 3.543558345298501*^9, 
   3.5435591773729773`*^9, 3.543560178908337*^9, 3.543560281661913*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"solIsreal", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"Isreal", "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["A", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.482665723842639*^9, 3.48266575809789*^9}, 
   3.482665845723934*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["T", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"4", " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]], 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["r", "2"]}], " ", 
         RowBox[{"A", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
        RowBox[{"T", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"\[CapitalDelta]", "[", 
          RowBox[{"r", ",", "a"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["r", "2"], " ", 
               RowBox[{"A", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
              RowBox[{"T", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "kappa", " ", 
            SqrtBox[
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                FractionBox[
                 RowBox[{"16", " ", 
                  SuperscriptBox["\[ExponentialE]", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
                 RowBox[{"g", "[", "a", "]"}]], "-", 
                RowBox[{
                 SuperscriptBox["a", "2"], " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["r", "2"]}], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                   RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                 SuperscriptBox["r", "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"F", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
                 RowBox[{"j", "[", "r", "]"}]}]}], ")"}], " ", 
              RowBox[{"\[CapitalDelta]", "[", 
               RowBox[{"r", ",", "a"}], "]"}]}]]}], "+", 
           RowBox[{"2", " ", "a", " ", "r", " ", 
            RowBox[{"F", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
            RowBox[{"j", "[", "r", "]"}], " ", 
            RowBox[{
             SuperscriptBox["f", "\[Prime]",
              MultilineFunction->None], "[", "r", "]"}]}]}], ")"}]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["r", "2"], " ", 
            RowBox[{"A", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
           RowBox[{"T", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
         RowBox[{
          SuperscriptBox["\[CapitalDelta]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"r", ",", "a"}], "]"}]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"f", "[", "r", "]"}], " ", 
         RowBox[{"F", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"r", " ", 
            RowBox[{"\[CapitalDelta]", "[", 
             RowBox[{"r", ",", "a"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["j", "\[Prime]",
              MultilineFunction->None], "[", "r", "]"}]}], "+", 
           RowBox[{
            RowBox[{"j", "[", "r", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"r", " ", 
               RowBox[{
                SuperscriptBox["\[CapitalDelta]", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"r", ",", "a"}], "]"}]}], "+", 
              RowBox[{
               RowBox[{"\[CapitalDelta]", "[", 
                RowBox[{"r", ",", "a"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{"2", "+", 
                 RowBox[{"r", " ", 
                  RowBox[{
                   SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}]}], ")"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["A", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", 
    RowBox[{"-", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"4", " ", "r"}]], 
      RowBox[{"a", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["r", "2"]}], " ", 
          RowBox[{"A", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
         RowBox[{"T", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
       RowBox[{"j", "[", "r", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "r", " ", 
          RowBox[{"A", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
          RowBox[{"f", "[", "r", "]"}], " ", 
          RowBox[{"F", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{"f", "[", "r", "]"}], " ", 
          RowBox[{
           SuperscriptBox["F", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"F", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{
              SuperscriptBox["f", "\[Prime]",
               MultilineFunction->None], "[", "r", "]"}]}], "+", 
            RowBox[{
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"f", "[", "r", "]"}], " ", 
             RowBox[{
              SuperscriptBox["A", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"f", "[", "r", "]"}], " ", 
             RowBox[{
              SuperscriptBox["T", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
        ")"}]}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["S", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["2", "a"]}], "+", 
     RowBox[{"kappa", " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{"16", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               RowBox[{"B", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
              RowBox[{"S", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], 
           RowBox[{"g", "[", "a", "]"}]], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["r", "2"]}], " ", 
              RowBox[{"A", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
             RowBox[{"T", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox[
            RowBox[{"F", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
           RowBox[{"j", "[", "r", "]"}]}]}], ")"}], " ", 
        RowBox[{"\[CapitalDelta]", "[", 
         RowBox[{"r", ",", "a"}], "]"}]}]]}], "-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["g", "\[Prime]",
        MultilineFunction->None], "[", "a", "]"}], 
      RowBox[{"g", "[", "a", "]"}]], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"-", 
        RowBox[{
         SuperscriptBox["\[CapitalDelta]", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"r", ",", "a"}], "]"}]}], "+", 
       RowBox[{
        FractionBox["1", "4"], " ", "a", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["r", "2"]}], " ", 
           RowBox[{"A", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
          RowBox[{"T", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", " ", 
        RowBox[{"f", "[", "r", "]"}], " ", 
        RowBox[{"F", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
        RowBox[{"j", "[", "r", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[CapitalDelta]", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"r", ",", "a"}], "]"}]}]}], 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]], "+", 
     RowBox[{
      FractionBox["1", "4"], " ", "a", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["r", "2"]}], " ", 
         RowBox[{"A", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
        RowBox[{"T", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", " ", 
      RowBox[{"f", "[", "r", "]"}], " ", 
      RowBox[{"F", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
      RowBox[{"j", "[", "r", "]"}], " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.482661462470347*^9, 3.482665680535009*^9, {3.482665759555162*^9, 
   3.4826657871545973`*^9}, {3.4826658483017178`*^9, 3.482665871597815*^9}, {
   3.482665919066064*^9, 3.460345454837998*^9}, 3.482732931482266*^9, 
   3.483268401446496*^9, 3.4832748627169867`*^9, 3.4833558624325027`*^9, 
   3.495174855633503*^9, 3.4979532237953367`*^9, 3.4979535545760937`*^9, 
   3.501484241110568*^9, {3.50148655658468*^9, 3.460390579727603*^9}, 
   3.460429453533163*^9, 3.460429520249406*^9, {3.5039996354994087`*^9, 
   3.4603433896990547`*^9}, 3.4603978066877623`*^9, {3.460398268575706*^9, 
   3.460398291311727*^9}, {3.46062534023184*^9, 3.460366076033289*^9}, 
   3.460373423557117*^9, 3.5414360808393583`*^9, 3.541441088813385*^9, 
   3.541999918323587*^9, 3.5420015516235657`*^9, 3.54247090303239*^9, 
   3.543558346755443*^9, 3.543559179027829*^9, 3.5435601955575113`*^9, 
   3.5435602832984667`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"K", "-", 
      RowBox[{"kappa", " ", "q"}]}], ")"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}], "/.", "solIsreal"}], "]"}]], "Input",
 CellChangeTimes->{{3.482661472912682*^9, 3.482661480239296*^9}, 
   3.482665792043179*^9, {3.482665876225696*^9, 3.4603454642184143`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.482661476077997*^9, 3.4826614806459503`*^9}, 
   3.4826655401226187`*^9, 3.482665680753159*^9, {3.482665784118093*^9, 
   3.4826657925393353`*^9}, {3.482665873049391*^9, 3.482665876638081*^9}, {
   3.482665928655641*^9, 3.4603454649726057`*^9}, 3.482732931690959*^9, 
   3.4832684029767427`*^9, 3.48327486292334*^9, 3.483355862815412*^9, 
   3.495174856040447*^9, 3.497953286747328*^9, 3.4979535548150263`*^9, 
   3.501484241321064*^9, {3.501486556802676*^9, 3.460390579921055*^9}, 
   3.460429453805388*^9, 3.460429520440114*^9, {3.5039996358618603`*^9, 
   3.460343389903619*^9}, 3.46039780914758*^9, {3.4603982689*^9, 
   3.460398293591243*^9}, {3.460625340550242*^9, 3.460366076280569*^9}, 
   3.460373423870085*^9, 3.541436104665827*^9, 3.541441089112986*^9, 
   3.541441308541874*^9, 3.541999918517839*^9, 3.542001551796496*^9, 
   3.542470903238531*^9, 3.5435583469416533`*^9, 3.543559179244226*^9, 
   3.543560226884519*^9, 3.543560283483569*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dTIsreal", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["T", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"l", ",", "r", ",", "a"}], "]"}], "/.", "solIsreal"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dAIsreal", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["A", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"l", ",", "r", ",", "a"}], "]"}], "/.", "solIsreal"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dSIsreal", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["S", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}], "/.", "solIsreal"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.482665930411491*^9, 3.482665957890201*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{
  "T", ",", "A", ",", "B", ",", "F", ",", "S", ",", "\[CapitalDelta]", ",", 
   "f", ",", "g", ",", "j"}], "]"}]], "Input",
 CellChangeTimes->{{3.460345516539507*^9, 3.4603455189072943`*^9}, {
  3.483268409588434*^9, 3.4603983316148863`*^9}, {3.543560106433859*^9, 
  3.5435601067376633`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalDelta]", "[", 
    RowBox[{"r_", ",", "a_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     FractionBox[
      RowBox[{" ", "1"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"a", "^", "2"}]}], ")"}], "+", 
       RowBox[{"rh", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"r", "^", "2"}]}], ")"}]}]}]], ")"}], "^", "2"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "r_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"r", "^", "2"}]}], ")"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", "a_", "]"}], ":=", 
   RowBox[{"2", "-", 
    RowBox[{"a", "^", "2"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"j", "[", "r_", "]"}], ":=", 
  RowBox[{"2", "-", 
   RowBox[{"r", "^", "2"}]}]}]}], "Input",
 CellChangeTimes->{{3.503997037073781*^9, 3.503997076077972*^9}, {
   3.503997256891058*^9, 3.4603927524745617`*^9}, {3.460396639861096*^9, 
   3.4603966466740303`*^9}, {3.460397369545499*^9, 3.460397369641325*^9}, 
   3.5419999360283546`*^9, {3.542001574213739*^9, 3.542001627282452*^9}, {
   3.5424710054251957`*^9, 3.5424710055999823`*^9}, {3.542471038151218*^9, 
   3.542471097336067*^9}, {3.542471239152217*^9, 3.54247124238334*^9}, {
   3.543559175317336*^9, 3.5435591795826263`*^9}, {3.543560094170699*^9, 
   3.5435601003550787`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"l_", ",", "r_", ",", "a_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"A", "[", 
    RowBox[{"l_", ",", "r_", ",", "a_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"B", "[", 
    RowBox[{"l_", ",", "r_", ",", "a_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{"l_", ",", "r_", ",", "a_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"F", "[", 
   RowBox[{"l_", ",", "r_", ",", "a_"}], "]"}], ":=", "0"}]}], "Input",
 CellChangeTimes->{{3.431856555245702*^9, 3.4318566047651167`*^9}, {
   3.431856648542349*^9, 3.431856678878977*^9}, 3.431856754902734*^9, {
   3.431856846342795*^9, 3.4318568575753117`*^9}, {3.431857245071002*^9, 
   3.431857306175378*^9}, {3.482669748664126*^9, 3.460345702164336*^9}, {
   3.4603458536450377`*^9, 3.4603458601381617`*^9}, {3.482733288623783*^9, 
   3.482733290614155*^9}, {3.483269034046699*^9, 3.46039835095335*^9}}],

Cell[CellGroupData[{

Cell[BoxData["Gd"], "Input",
 CellChangeTimes->{{3.4318562990518847`*^9, 3.4318563040834017`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "-", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["a", "2"], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}], "2"]], 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox["4", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["a", "2"], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}], "2"]}]],
      ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox["4", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "-", 
         SuperscriptBox["a", "2"]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["a", "2"], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}], "2"]}]],
      ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "-", 
         SuperscriptBox["a", "2"]}], ")"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["a", "2"], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}], "2"], 
       " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["\[Theta]1", "2"]}], ")"}]}]], ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "-", 
         SuperscriptBox["a", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["\[Theta]1", "2"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["a", "2"], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}], "2"]], 
     ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "-", 
         SuperscriptBox["a", "2"]}], ")"}], " ", 
       SuperscriptBox["\[Theta]1", "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["a", "2"], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}], "2"]]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.431856299806117*^9, 3.431856304611355*^9}, 
   3.43185660646094*^9, {3.431856668146028*^9, 3.4318566798239098`*^9}, 
   3.431856756281083*^9, {3.431856851378639*^9, 3.4318568587390823`*^9}, 
   3.4318572796440897`*^9, 3.431857310614151*^9, 3.431857488475541*^9, 
   3.43186383046841*^9, {3.431864575945343*^9, 3.43186459225721*^9}, {
   3.4826697534554987`*^9, 3.4603058857155447`*^9}, 3.460345524905094*^9, {
   3.460345710014978*^9, 3.460345720395001*^9}, {3.460345766370194*^9, 
   3.460345898323473*^9}, 3.482733059260737*^9, {3.482733168248206*^9, 
   3.4827332202860317`*^9}, {3.4827332931225*^9, 3.482733303696246*^9}, 
   3.4832690369399757`*^9, 3.48327486352393*^9, 3.483355863435315*^9, 
   3.4951749890930567`*^9, 3.4951757302248774`*^9, 3.4979535731642513`*^9, 
   3.501484241984761*^9, {3.501486557501039*^9, 3.460390580561969*^9}, 
   3.460429454468693*^9, 3.460429521052533*^9, {3.5039996365546293`*^9, 
   3.460396665470531*^9}, {3.4603983376171103`*^9, 3.460398352352344*^9}, {
   3.460625341604653*^9, 3.460366077926231*^9}, 3.4603734240132103`*^9, 
   3.541436110032339*^9, 3.541441099367689*^9, 3.541441318493517*^9, 
   3.541999939835178*^9, {3.5420016099777203`*^9, 3.5420016293558903`*^9}, 
   3.542470909176784*^9, 3.5424710081112556`*^9, {3.542471040687715*^9, 
   3.542471055415699*^9}, 3.542471099637774*^9, 3.5424712467689657`*^9, 
   3.543558351557426*^9, 3.5435591855345783`*^9, 3.5435602921765327`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"R2", "[", 
    RowBox[{"[", "2", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.43185661165845*^9, 3.431856617115055*^9}, {
  3.495175743829801*^9, 3.495175748260107*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "2"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "2"]}], "+", 
         SuperscriptBox["rh", "2"], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["r", "6"], " ", 
          SuperscriptBox["rh", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["r", "8"], " ", 
          SuperscriptBox["rh", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "3"}], "+", 
            SuperscriptBox["rh", "2"]}], ")"}]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["r", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["rh", "2"]}], ")"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["a", "2"], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}], "2"]], 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "2"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "2"]}], "+", 
         SuperscriptBox["rh", "2"], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["r", "6"], " ", 
          SuperscriptBox["rh", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["r", "8"], " ", 
          SuperscriptBox["rh", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "3"}], "+", 
            SuperscriptBox["rh", "2"]}], ")"}]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["r", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["rh", "2"]}], ")"}]}]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["a", "2"], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}], "2"]}]],
      ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["a", "2"]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "3"], " ", "rh"}], "-", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "4"], " ", 
          SuperscriptBox["rh", "2"]}]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         SuperscriptBox["a", "2"]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["a", "2"], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}], "2"]}]],
      ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", 
          SuperscriptBox["a", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", 
          RowBox[{"4", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["a", "2"]}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "3"], " ", "rh"}], "-", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "4"], " ", 
           SuperscriptBox["rh", "2"]}]}], ")"}]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["a", "2"], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}], "2"], 
        " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[Theta]1", "2"]}], ")"}]}]]}], ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", 
          SuperscriptBox["a", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", 
          RowBox[{"4", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["a", "2"]}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "3"], " ", "rh"}], "-", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SuperscriptBox["r", "2"]}], ")"}], "4"], " ", 
           SuperscriptBox["rh", "2"]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[Theta]1", "2"]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["a", "2"], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}], "2"]]}],
      ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         SuperscriptBox["a", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["a", "2"]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "3"], " ", "rh"}], "-", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "4"], " ", 
          SuperscriptBox["rh", "2"]}]}], ")"}], " ", 
       SuperscriptBox["\[Theta]1", "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["a", "2"], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]}], ")"}], "2"]]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.431856612109056*^9, 3.431856617545108*^9}, {
   3.431856669110338*^9, 3.43185668056047*^9}, 3.4318567570686903`*^9, {
   3.43185685195039*^9, 3.431856859536584*^9}, 3.431857281994296*^9, 
   3.431857312269294*^9, 3.431857489402048*^9, 3.431863830741754*^9, {
   3.431864576559948*^9, 3.431864592971705*^9}, {3.482669754343588*^9, 
   3.460305885813504*^9}, 3.460345525658946*^9, {3.460345711044471*^9, 
   3.460345721250018*^9}, {3.4603457674496717`*^9, 3.4603458992770357`*^9}, 
   3.482733060910022*^9, {3.482733169058887*^9, 3.482733220990528*^9}, {
   3.482733294643722*^9, 3.4827333050289383`*^9}, 3.483269038429679*^9, 
   3.48327486429948*^9, 3.483355864232212*^9, {3.495175731817585*^9, 
   3.495175748940889*^9}, 3.4979535743164053`*^9, 3.501484242511442*^9, {
   3.501486558026291*^9, 3.460390581308337*^9}, 3.460429455226699*^9, 
   3.4604295218053217`*^9, {3.5039996369471693`*^9, 3.460396666231761*^9}, {
   3.4603983427130003`*^9, 3.460398354334934*^9}, {3.46062534233778*^9, 
   3.46036607911327*^9}, 3.4603734245461884`*^9, 3.541436112478109*^9, 
   3.541441101315751*^9, 3.5414413196570873`*^9, 3.541999940842259*^9, {
   3.542001612432392*^9, 3.542001630402379*^9}, 3.542470911661105*^9, 
   3.54247100941222*^9, {3.5424710422383757`*^9, 3.542471056275379*^9}, 
   3.5424711006623*^9, 3.542471250029956*^9, 3.5435583529482327`*^9, 
   3.5435591874291267`*^9, 3.543560293426546*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Gd", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], "/", 
      RowBox[{"tmp", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "1", ",", "0"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Gd", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "2"}], "]"}], "]"}], "/", 
      RowBox[{"tmp", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "2"}], "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "1", ",", "0"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Gd", "[", 
       RowBox[{"[", 
        RowBox[{"3", ",", "3"}], "]"}], "]"}], "/", 
      RowBox[{"tmp", "[", 
       RowBox[{"[", 
        RowBox[{"3", ",", "3"}], "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "1", ",", "0"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Gd", "[", 
      RowBox[{"[", 
       RowBox[{"4", ",", "4"}], "]"}], "]"}], "/", 
     RowBox[{"tmp", "[", 
      RowBox[{"[", 
       RowBox[{"4", ",", "4"}], "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"r", ",", "1", ",", "0"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.495175750171129*^9, 3.495175863118318*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"r", "-", "1"}], "]"}], "1"],
    SeriesData[$CellContext`r, 1, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`r, 1, {
    Rational[-1, 5]}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.4951757555592823`*^9, 3.4951758634933643`*^9}, 
   3.497953575186244*^9, 3.5014842427337017`*^9, {3.501486558279105*^9, 
   3.460390581448168*^9}, 3.46042945545509*^9, 3.4604295222411613`*^9, {
   3.503999637223979*^9, 3.460396666725266*^9}, 3.460398360564671*^9, {
   3.460625342732732*^9, 3.460366079539329*^9}, 3.460373424618619*^9, 
   3.5414361141450157`*^9, 3.541441101425157*^9, 3.5414413210290823`*^9, 
   3.5419999416881332`*^9, {3.5420016150506773`*^9, 3.542001630956348*^9}, 
   3.542470915380619*^9, 3.542471010506748*^9, {3.542471042438725*^9, 
   3.5424710565844173`*^9}, 3.542471101568067*^9, 3.542471250944379*^9, 
   3.54355835396172*^9, 3.5435591909367647`*^9, 3.543560294371807*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"r", "-", "1"}], "]"}], "1"],
    SeriesData[$CellContext`r, 1, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`r, 1, {
    Rational[-1, 5]}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.4951757555592823`*^9, 3.4951758634933643`*^9}, 
   3.497953575186244*^9, 3.5014842427337017`*^9, {3.501486558279105*^9, 
   3.460390581448168*^9}, 3.46042945545509*^9, 3.4604295222411613`*^9, {
   3.503999637223979*^9, 3.460396666725266*^9}, 3.460398360564671*^9, {
   3.460625342732732*^9, 3.460366079539329*^9}, 3.460373424618619*^9, 
   3.5414361141450157`*^9, 3.541441101425157*^9, 3.5414413210290823`*^9, 
   3.5419999416881332`*^9, {3.5420016150506773`*^9, 3.542001630956348*^9}, 
   3.542470915380619*^9, 3.542471010506748*^9, {3.542471042438725*^9, 
   3.5424710565844173`*^9}, 3.542471101568067*^9, 3.542471250944379*^9, 
   3.54355835396172*^9, 3.5435591909367647`*^9, 3.543560294373698*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"r", "-", "1"}], "]"}], "1"],
    SeriesData[$CellContext`r, 1, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`r, 1, {
    Rational[-1, 5]}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.4951757555592823`*^9, 3.4951758634933643`*^9}, 
   3.497953575186244*^9, 3.5014842427337017`*^9, {3.501486558279105*^9, 
   3.460390581448168*^9}, 3.46042945545509*^9, 3.4604295222411613`*^9, {
   3.503999637223979*^9, 3.460396666725266*^9}, 3.460398360564671*^9, {
   3.460625342732732*^9, 3.460366079539329*^9}, 3.460373424618619*^9, 
   3.5414361141450157`*^9, 3.541441101425157*^9, 3.5414413210290823`*^9, 
   3.5419999416881332`*^9, {3.5420016150506773`*^9, 3.542001630956348*^9}, 
   3.542470915380619*^9, 3.542471010506748*^9, {3.542471042438725*^9, 
   3.5424710565844173`*^9}, 3.542471101568067*^9, 3.542471250944379*^9, 
   3.54355835396172*^9, 3.5435591909367647`*^9, 3.5435602944012613`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"r", "-", "1"}], "]"}], "1"],
    SeriesData[$CellContext`r, 1, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`r, 1, {
    Rational[-1, 5]}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.4951757555592823`*^9, 3.4951758634933643`*^9}, 
   3.497953575186244*^9, 3.5014842427337017`*^9, {3.501486558279105*^9, 
   3.460390581448168*^9}, 3.46042945545509*^9, 3.4604295222411613`*^9, {
   3.503999637223979*^9, 3.460396666725266*^9}, 3.460398360564671*^9, {
   3.460625342732732*^9, 3.460366079539329*^9}, 3.460373424618619*^9, 
   3.5414361141450157`*^9, 3.541441101425157*^9, 3.5414413210290823`*^9, 
   3.5419999416881332`*^9, {3.5420016150506773`*^9, 3.542001630956348*^9}, 
   3.542470915380619*^9, 3.542471010506748*^9, {3.542471042438725*^9, 
   3.5424710565844173`*^9}, 3.542471101568067*^9, 3.542471250944379*^9, 
   3.54355835396172*^9, 3.5435591909367647`*^9, 3.543560294403146*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"PowerExpand", "[", 
    RowBox[{"dTIsreal", "/.", 
     RowBox[{"{", 
      RowBox[{"a", "\[Rule]", "1"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SuperscriptBox["T", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "0", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"l", ",", "r", ",", "a"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", "1"}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.4826660049695663`*^9, 3.460345583983425*^9}, {
  3.48326906127791*^9, 3.483269063052622*^9}, {3.503999655173497*^9, 
  3.503999664163814*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "kappa"}], ")"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]]}]], "Output",
 CellChangeTimes->{{3.482666002998753*^9, 3.460345545267086*^9}, 
   3.460345584500978*^9, {3.482732966257142*^9, 3.482732974068698*^9}, 
   3.483268434285424*^9, {3.4832690509261723`*^9, 3.48326907357321*^9}, 
   3.483274864505567*^9, 3.483355864520975*^9, 3.495175868068644*^9, 
   3.497953575877347*^9, 3.501484242821018*^9, {3.501486558436138*^9, 
   3.460390581570344*^9}, 3.460429455591792*^9, 3.4604295223896513`*^9, {
   3.503999641076478*^9, 3.4603966687086887`*^9}, 3.460398365846327*^9, {
   3.460625342966423*^9, 3.460366080949621*^9}, 3.4603736388557873`*^9, 
   3.541436115376383*^9, 3.541441101832201*^9, 3.541441321888905*^9, 
   3.5419999618200607`*^9, {3.542001616660657*^9, 3.542001631821885*^9}, 
   3.5424709173093157`*^9, 3.542471011558948*^9, {3.542471043841131*^9, 
   3.5424710574994373`*^9}, 3.542471102587323*^9, 3.542471251996591*^9, 
   3.543558356365718*^9, 3.543559193291366*^9, 3.543560295659408*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.482666002998753*^9, 3.460345545267086*^9}, 
   3.460345584500978*^9, {3.482732966257142*^9, 3.482732974068698*^9}, 
   3.483268434285424*^9, {3.4832690509261723`*^9, 3.48326907357321*^9}, 
   3.483274864505567*^9, 3.483355864520975*^9, 3.495175868068644*^9, 
   3.497953575877347*^9, 3.501484242821018*^9, {3.501486558436138*^9, 
   3.460390581570344*^9}, 3.460429455591792*^9, 3.4604295223896513`*^9, {
   3.503999641076478*^9, 3.4603966687086887`*^9}, 3.460398365846327*^9, {
   3.460625342966423*^9, 3.460366080949621*^9}, 3.4603736388557873`*^9, 
   3.541436115376383*^9, 3.541441101832201*^9, 3.541441321888905*^9, 
   3.5419999618200607`*^9, {3.542001616660657*^9, 3.542001631821885*^9}, 
   3.5424709173093157`*^9, 3.542471011558948*^9, {3.542471043841131*^9, 
   3.5424710574994373`*^9}, 3.542471102587323*^9, 3.542471251996591*^9, 
   3.543558356365718*^9, 3.543559193291366*^9, 3.5435602956614647`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"PowerExpand", "[", 
    RowBox[{"dAIsreal", "/.", 
     RowBox[{"{", 
      RowBox[{"a", "\[Rule]", "1"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SuperscriptBox["A", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "0", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"l", ",", "r", ",", "a"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", "1"}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.482666070226741*^9, 3.460345587991267*^9}, {
  3.48326906858265*^9, 3.483269071190339*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.48266607923127*^9, 3.4603455465431137`*^9}, 
   3.460345588475593*^9, {3.482732967356728*^9, 3.482732974550373*^9}, 
   3.4832684377323523`*^9, {3.483269051825616*^9, 3.483269074588484*^9}, 
   3.483274864614605*^9, 3.4833558645901203`*^9, 3.495175874063829*^9, 
   3.49795357656045*^9, 3.501484242904517*^9, {3.5014865585208*^9, 
   3.460390581654023*^9}, 3.460429455658146*^9, {3.4604295224678373`*^9, 
   3.460396670035489*^9}, 3.4603983667031393`*^9, {3.4606253431911573`*^9, 
   3.460366081696137*^9}, 3.460373639587226*^9, 3.5414361166147013`*^9, 
   3.541441102586293*^9, 3.541441322749959*^9, 3.54199996658967*^9, 
   3.542001634293983*^9, 3.542470918729003*^9, 3.542471013196254*^9, 
   3.542471045344537*^9, 3.542471103689702*^9, 3.542471253314855*^9, 
   3.543558357403185*^9, 3.543559195136736*^9, 3.543560296885316*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.48266607923127*^9, 3.4603455465431137`*^9}, 
   3.460345588475593*^9, {3.482732967356728*^9, 3.482732974550373*^9}, 
   3.4832684377323523`*^9, {3.483269051825616*^9, 3.483269074588484*^9}, 
   3.483274864614605*^9, 3.4833558645901203`*^9, 3.495175874063829*^9, 
   3.49795357656045*^9, 3.501484242904517*^9, {3.5014865585208*^9, 
   3.460390581654023*^9}, 3.460429455658146*^9, {3.4604295224678373`*^9, 
   3.460396670035489*^9}, 3.4603983667031393`*^9, {3.4606253431911573`*^9, 
   3.460366081696137*^9}, 3.460373639587226*^9, 3.5414361166147013`*^9, 
   3.541441102586293*^9, 3.541441322749959*^9, 3.54199996658967*^9, 
   3.542001634293983*^9, 3.542470918729003*^9, 3.542471013196254*^9, 
   3.542471045344537*^9, 3.542471103689702*^9, 3.542471253314855*^9, 
   3.543558357403185*^9, 3.543559195136736*^9, 3.5435602968872766`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"Simplify", "[", 
    RowBox[{"PowerExpand", "[", 
     RowBox[{"dSIsreal", "/.", 
      RowBox[{"{", 
       RowBox[{"a", "\[Rule]", "1"}], "}"}]}], "]"}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SuperscriptBox["S", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "0", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"l", ",", "r", ",", "a"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", "1"}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.482666075081551*^9, 3.460345592223567*^9}, {
  3.483269070046768*^9, 3.483269071988899*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "kappa"}], ")"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]]}]], "Output",
 CellChangeTimes->{{3.482666077667183*^9, 3.46034559271469*^9}, 
   3.482732974983457*^9, 3.4832684392141113`*^9, {3.4832690526244993`*^9, 
   3.4832690752212152`*^9}, 3.483274864692976*^9, 3.483355864658546*^9, 
   3.495175875146338*^9, 3.497953577241666*^9, 3.501484242988212*^9, {
   3.501486558604127*^9, 3.460390581770792*^9}, 3.460429455741763*^9, {
   3.460429522539503*^9, 3.4603966708779287`*^9}, 3.460398372597919*^9, {
   3.46062534345389*^9, 3.46036608277871*^9}, 3.460373640202993*^9, 
   3.541436117831047*^9, 3.541441103588262*^9, 3.541441323734899*^9, 
   3.541999967658757*^9, 3.542001635245036*^9, 3.542470919747148*^9, 
   3.542471013980155*^9, 3.542471046127033*^9, 3.542471104725322*^9, 
   3.542471254200082*^9, 3.543558358320311*^9, 3.543559196205158*^9, 
   3.543560297804161*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.482666077667183*^9, 3.46034559271469*^9}, 
   3.482732974983457*^9, 3.4832684392141113`*^9, {3.4832690526244993`*^9, 
   3.4832690752212152`*^9}, 3.483274864692976*^9, 3.483355864658546*^9, 
   3.495175875146338*^9, 3.497953577241666*^9, 3.501484242988212*^9, {
   3.501486558604127*^9, 3.460390581770792*^9}, 3.460429455741763*^9, {
   3.460429522539503*^9, 3.4603966708779287`*^9}, 3.460398372597919*^9, {
   3.46062534345389*^9, 3.46036608277871*^9}, 3.460373640202993*^9, 
   3.541436117831047*^9, 3.541441103588262*^9, 3.541441323734899*^9, 
   3.541999967658757*^9, 3.542001635245036*^9, 3.542470919747148*^9, 
   3.542471013980155*^9, 3.542471046127033*^9, 3.542471104725322*^9, 
   3.542471254200082*^9, 3.543558358320311*^9, 3.543559196205158*^9, 
   3.543560297806162*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{
  "T", ",", "A", ",", "B", ",", "F", ",", "S", ",", "\[CapitalDelta]", ",", 
   "f", ",", "g", ",", "j"}], "]"}]], "Input",
 CellChangeTimes->{{3.4826661330887327`*^9, 3.460345623870998*^9}, {
  3.483269105684589*^9, 3.4603983849632893`*^9}, {3.543560154640729*^9, 
  3.5435601548723993`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"H", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "d", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"S", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"r", " ", 
             RowBox[{"j", "[", "r", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"8", " ", 
                SuperscriptBox["a", "2"], " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                  RowBox[{"T", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  SuperscriptBox["\[ExponentialE]", 
                   RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], ")"}], " ", 
                SuperscriptBox["r", "2"], " ", 
                SuperscriptBox[
                 RowBox[{"F", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
                RowBox[{"g", "[", "a", "]"}], " ", 
                RowBox[{"j", "[", "r", "]"}], " ", 
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{
                 SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "r", "]"}]}], "+", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                SuperscriptBox["r", "3"], " ", 
                SuperscriptBox[
                 RowBox[{"F", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}], "3"], " ", 
                RowBox[{"g", "[", "a", "]"}], " ", 
                RowBox[{"j", "[", "r", "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"3", " ", "a", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
                   RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["g", "\[Prime]",
                    MultilineFunction->None], "[", "a", "]"}]}], "+", 
                  RowBox[{
                   RowBox[{"g", "[", "a", "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
                    RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"a", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]]}]}], ")"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
               "-", 
               RowBox[{"32", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["r", "2"], " ", 
                   RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                  RowBox[{"2", " ", 
                   RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}]], " ", 
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"4", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], ")"}], " ", 
                   RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "r", "]"}]}], "+", 
                  RowBox[{"a", " ", "r", " ", 
                   RowBox[{"g", "[", "a", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["F", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}], 
               "+", 
               RowBox[{"16", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                  RowBox[{"T", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", " ", 
                RowBox[{"F", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "a"}], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                   " ", 
                   RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["g", "\[Prime]",
                    MultilineFunction->None], "[", "a", "]"}]}], "-", 
                  RowBox[{
                   RowBox[{"g", "[", "a", "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"a", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                    " ", 
                    RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                    RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
                    RowBox[{"a", " ", 
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                    RowBox[{"a", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"T", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
             RowBox[{"f", "[", "r", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"16", " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["r", "2"], " ", 
                   RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"2", " ", 
                   RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"T", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  SuperscriptBox["\[ExponentialE]", 
                   RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], ")"}], " ",
                 "r", " ", 
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{
                 SuperscriptBox["j", "\[Prime]",
                  MultilineFunction->None], "[", "r", "]"}]}], "+", 
               RowBox[{
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{"S", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
                RowBox[{"j", "[", "r", "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"16", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "5"}], " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                   " ", "r", " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{
                   RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"32", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], ")"}], " ", 
                    SuperscriptBox["r", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
                    RowBox[{"g", "[", "a", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["j", "\[Prime]",
                    MultilineFunction->None], "[", "r", "]"}]}], "+", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                    RowBox[{
                    SuperscriptBox["r", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", "r", " ", 
                    RowBox[{
                    SuperscriptBox["B", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                    RowBox[{"4", " ", "r", " ", 
                    RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                SuperscriptBox["r", "2"], " ", 
                SuperscriptBox[
                 RowBox[{"F", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
                RowBox[{"g", "[", "a", "]"}], " ", 
                SuperscriptBox[
                 RowBox[{"j", "[", "r", "]"}], "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "6"}], " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]]}], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}]}], 
                   " ", "r", " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "-", 
                  RowBox[{
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
                   RowBox[{"\[CapitalDelta]", "[", 
                    RowBox[{"r", ",", "a"}], "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
                    RowBox[{"3", " ", "r", " ", 
                    RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                    RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                 ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"8", " ", "r", " ", 
          RowBox[{"f", "[", "r", "]"}], " ", 
          RowBox[{"j", "[", "r", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["r", "2"], " ", 
                RowBox[{"A", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                RowBox[{"B", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{"S", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
               RowBox[{"T", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["r", "2"], " ", 
             SuperscriptBox[
              RowBox[{"F", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
             RowBox[{"g", "[", "a", "]"}], " ", 
             RowBox[{"j", "[", "r", "]"}]}]}], ")"}], " ", 
          RowBox[{"\[CapitalDelta]", "[", 
           RowBox[{"r", ",", "a"}], "]"}]}], ")"}]}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"S", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
            RowBox[{"T", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "192"}], " ", "a", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["r", "2"], " ", 
                RowBox[{"A", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                RowBox[{"B", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                  RowBox[{"T", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], ")"}]}]}]], 
             " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 SuperscriptBox["a", "2"], " ", 
                 RowBox[{"B", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], ")"}], " ", 
             RowBox[{"\[CapitalDelta]", "[", 
              RowBox[{"r", ",", "a"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["g", "\[Prime]",
               MultilineFunction->None], "[", "a", "]"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["r", "2"], " ", 
             SuperscriptBox[
              RowBox[{"F", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
             SuperscriptBox[
              RowBox[{"g", "[", "a", "]"}], "2"], " ", 
             RowBox[{"j", "[", "r", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"4", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "-", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]]}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                   " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"a", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]]}]}], ")"}], " ",
                    "r", " ", 
                   RowBox[{"f", "[", "r", "]"}], " ", 
                   RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                   RowBox[{"j", "[", "r", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{"S", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"f", "[", "r", "]"}], " ", 
                   RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", 
                    RowBox[{"j", "[", "r", "]"}]}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["j", "\[Prime]",
                    MultilineFunction->None], "[", "r", "]"}]}]}], ")"}]}], 
                  "+", 
                  RowBox[{"2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", "r", " ", 
                    RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                    RowBox[{"j", "[", "r", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "r", "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "6"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
                    RowBox[{"3", " ", "a", " ", 
                    RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                    RowBox[{"a", " ", 
                    RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"S", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
               RowBox[{"T", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
             RowBox[{"g", "[", "a", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "a", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"4", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "-", 
                    RowBox[{"5", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                   " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"a", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], 
                   " ", "r", " ", 
                   RowBox[{"f", "[", "r", "]"}], " ", 
                   RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                   RowBox[{"j", "[", "r", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[CapitalDelta]", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"r", ",", "a"}], "]"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "96"}], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                  RowBox[{"96", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
                  RowBox[{"32", " ", 
                   SuperscriptBox["a", "2"], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"8", " ", 
                   SuperscriptBox["a", "2"], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", "r", 
                   " ", 
                   RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                   RowBox[{"j", "[", "r", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "r", "]"}]}], "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["a", "3"], " ", 
                   SuperscriptBox["r", "2"], " ", 
                   SuperscriptBox[
                    RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
                   RowBox[{"j", "[", "r", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["g", "\[Prime]",
                    MultilineFunction->None], "[", "a", "]"}]}], "-", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["a", "3"], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   SuperscriptBox["r", "2"], " ", 
                   SuperscriptBox[
                    RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
                   RowBox[{"j", "[", "r", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["g", "\[Prime]",
                    MultilineFunction->None], "[", "a", "]"}]}], "-", 
                  RowBox[{"16", " ", "a", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   SuperscriptBox["r", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["A", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"16", " ", 
                   SuperscriptBox["a", "3"], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{
                    SuperscriptBox["B", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                  RowBox[{"32", " ", "a", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                  RowBox[{"32", " ", "a", " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
                    RowBox[{"T", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{
                    SuperscriptBox["T", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                  RowBox[{"4", " ", 
                   SuperscriptBox["a", "2"], " ", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", 
                    RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                    RowBox[{"S", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                   RowBox[{"f", "[", "r", "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", "r", " ", 
                    RowBox[{"j", "[", "r", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["F", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                    RowBox[{
                    RowBox[{"F", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], ")"}], " ",
                     "r", " ", 
                    RowBox[{
                    SuperscriptBox["j", "\[Prime]",
                    MultilineFunction->None], "[", "r", "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"j", "[", "r", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    SuperscriptBox["r", "2"], " ", 
                    RowBox[{"A", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "-", 
                    RowBox[{
                    SuperscriptBox["a", "2"], " ", "r", " ", 
                    RowBox[{
                    SuperscriptBox["B", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
                    RowBox[{"r", " ", 
                    RowBox[{
                    SuperscriptBox["S", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
         ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"8", " ", "a", " ", 
          RowBox[{"g", "[", "a", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{
                SuperscriptBox["r", "2"], " ", 
                RowBox[{"A", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                RowBox[{"B", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
               RowBox[{"S", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}], "+", 
               RowBox[{"T", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["r", "2"], " ", 
             SuperscriptBox[
              RowBox[{"F", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}], "2"], " ", 
             RowBox[{"g", "[", "a", "]"}], " ", 
             RowBox[{"j", "[", "r", "]"}]}]}], ")"}], " ", 
          RowBox[{"\[CapitalDelta]", "[", 
           RowBox[{"r", ",", "a"}], "]"}]}], ")"}]}], ",", "0", ",", "0", ",",
        "0"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.460398407838149*^9, 3.460366119400321*^9}, {
  3.46037366281181*^9, 3.4603736643764067`*^9}, {3.541422183301118*^9, 
  3.541422183837064*^9}, {3.5414361552517653`*^9, 3.5414361557525*^9}, {
  3.542000002539564*^9, 3.542000002979475*^9}, {3.542471274648193*^9, 
  3.5424712755677834`*^9}, {3.543557861940983*^9, 3.543557862811747*^9}, {
  3.543558362854939*^9, 3.543558363158985*^9}, {3.543560312531601*^9, 
  3.543560313339264*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ha", "=", 
   RowBox[{"H", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "3"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.46039841150086*^9, 3.460398426585657*^9}, 
   3.542001657814129*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", "x_", "]"}], "\[Rule]", 
      RowBox[{"exp", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"T", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "T"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Tr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Ta"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Trr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Taa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["T", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Tra"}], ",", 
     RowBox[{
      RowBox[{"A", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "A"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Ar"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Aa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Arr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Aaa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["A", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Ara"}], ",", 
     RowBox[{
      RowBox[{"B", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "B"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Br"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Ba"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Brr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Baa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["B", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Bra"}], ",", 
     RowBox[{
      RowBox[{"F", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "F"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Fr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Fa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Frr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Faa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Fra"}], ",", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "S"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Sr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Sa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Srr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Saa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "Sra"}], ",", 
     RowBox[{
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "L"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalDelta]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "Lr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalDelta]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "La"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalDelta]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "Lrr"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalDelta]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "Laa"}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[CapitalDelta]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "a"}], "]"}], "\[Rule]", "Lra"}], ",", 
     RowBox[{
      RowBox[{"f", "[", "r", "]"}], "\[Rule]", "f"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "r", "]"}], "\[Rule]", "fr"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "''"}], "[", "r", "]"}], "\[Rule]", "frr"}], ",", 
     RowBox[{
      RowBox[{"j", "[", "r", "]"}], "\[Rule]", "j"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"j", "'"}], "[", "r", "]"}], "\[Rule]", "jr"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"j", "''"}], "[", "r", "]"}], "\[Rule]", "jrr"}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.4832692136536627`*^9, 3.483269213987788*^9}, {
   3.4832751292507677`*^9, 3.460398454774333*^9}, {3.4603985280494967`*^9, 
   3.460398532910939*^9}, 3.543558400648905*^9, {3.5435603221377583`*^9, 
   3.5435603301132183`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "a_", "]"}], ":=", 
  RowBox[{"2", "-", 
   RowBox[{"a", "^", "2"}]}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"branebc", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Isreal", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "1"}], "]"}], "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"Isreal", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "2"}], "]"}], "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"Isreal", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "3"}], "]"}], "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{"Ha", "\[Equal]", "0"}]}], "}"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"F", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "0"}], ",", 
         " ", 
         RowBox[{
          RowBox[{
           SuperscriptBox["F", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "0"}], ",", 
         RowBox[{
          RowBox[{"F0", "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "0"}], ",", 
         " ", 
         RowBox[{
          RowBox[{
           SuperscriptBox["F0", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "0"}]}], 
        "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["A", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["B", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.48266707001136*^9, 3.4826670844041433`*^9}, {
   3.482667139406938*^9, 3.482667230523843*^9}, {3.482667309733137*^9, 
   3.482667312371079*^9}, {3.4827334667867727`*^9, 3.482733467968947*^9}, 
   3.4832751207407207`*^9, {3.501486536145075*^9, 3.5014865400704603`*^9}, {
   3.5014866074003057`*^9, 3.501486607695694*^9}, {3.501486760018717*^9, 
   3.46039061266012*^9}, {3.46039075054535*^9, 3.460390754575364*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["T", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"4", " ", "kappa", " ", 
      SqrtBox[
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"B", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
            RowBox[{"S", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
          RowBox[{"\[CapitalDelta]", "[", 
           RowBox[{"r", ",", "a"}], "]"}]}], 
         RowBox[{
          RowBox[{"-", "2"}], "+", 
          SuperscriptBox["a", "2"]}]]}]]}], "-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[CapitalDelta]", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "a"}], "]"}], 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["A", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["S", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"4", " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["a", "2"], "-", 
         RowBox[{"2", " ", "a", " ", "kappa", " ", 
          SqrtBox[
           RowBox[{"-", 
            FractionBox[
             RowBox[{
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", 
                 RowBox[{"B", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                RowBox[{"S", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
              RowBox[{"\[CapitalDelta]", "[", 
               RowBox[{"r", ",", "a"}], "]"}]}], 
             RowBox[{
              RowBox[{"-", "2"}], "+", 
              SuperscriptBox["a", "2"]}]]}]]}], "+", 
         RowBox[{
          SuperscriptBox["a", "3"], " ", "kappa", " ", 
          SqrtBox[
           RowBox[{"-", 
            FractionBox[
             RowBox[{
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", 
                 RowBox[{"B", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                RowBox[{"S", "[", 
                 RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
              RowBox[{"\[CapitalDelta]", "[", 
               RowBox[{"r", ",", "a"}], "]"}]}], 
             RowBox[{
              RowBox[{"-", "2"}], "+", 
              SuperscriptBox["a", "2"]}]]}]]}]}], ")"}]}], "-", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         SuperscriptBox["a", "2"]}], ")"}], " ", 
       RowBox[{
        SuperscriptBox["\[CapitalDelta]", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]}], 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        SuperscriptBox["a", "2"]}], ")"}], " ", 
      RowBox[{"\[CapitalDelta]", "[", 
       RowBox[{"r", ",", "a"}], "]"}]}]]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["B", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"l", ",", "r", ",", "a"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         SuperscriptBox["a", "2"]}], ")"}], " ", 
       RowBox[{"\[CapitalDelta]", "[", 
        RowBox[{"r", ",", "a"}], "]"}]}]], 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["r", "2"]}], " ", 
         RowBox[{"A", "[", 
          RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "-", 
        RowBox[{"T", "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["r", "2"], " ", 
            RowBox[{"A", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
           RowBox[{"T", "[", 
            RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
         RowBox[{"\[CapitalDelta]", "[", 
          RowBox[{"r", ",", "a"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{"2", "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              RowBox[{"B", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "+", 
              RowBox[{"6", " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 SuperscriptBox["a", "2"], " ", 
                 RowBox[{"B", "[", 
                  RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}]}], 
           "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "+", 
              SuperscriptBox["a", "2"]}], ")"}], " ", 
            RowBox[{"B", "[", 
             RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
           RowBox[{"16", " ", "a", " ", "kappa", " ", 
            SqrtBox[
             RowBox[{"-", 
              FractionBox[
               RowBox[{
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}]}], 
               RowBox[{
                RowBox[{"-", "2"}], "+", 
                SuperscriptBox["a", "2"]}]]}]]}], "-", 
           RowBox[{"8", " ", 
            SuperscriptBox["a", "3"], " ", "kappa", " ", 
            SqrtBox[
             RowBox[{"-", 
              FractionBox[
               RowBox[{
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["a", "2"], " ", 
                   RowBox[{"B", "[", 
                    RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
                  RowBox[{"S", "[", 
                   RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], " ", 
                RowBox[{"\[CapitalDelta]", "[", 
                 RowBox[{"r", ",", "a"}], "]"}]}], 
               RowBox[{
                RowBox[{"-", "2"}], "+", 
                SuperscriptBox["a", "2"]}]]}]]}]}], ")"}]}], "-", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", 
           SuperscriptBox["a", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              RowBox[{"B", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{"S", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"A", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              RowBox[{"B", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{"S", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "-", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"A", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
             RowBox[{"T", "[", 
              RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               SuperscriptBox["r", "2"], " ", 
               RowBox[{"A", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               RowBox[{"B", "[", 
                RowBox[{"l", ",", "r", ",", "a"}], "]"}]}], "+", 
              RowBox[{"T", "[", 
               RowBox[{"l", ",", "r", ",", "a"}], "]"}]}]]}]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["\[CapitalDelta]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"r", ",", "a"}], "]"}]}]}], ")"}]}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.482667044653289*^9, 3.482667085776701*^9, {3.482667203639865*^9, 
   3.482667231503536*^9}, {3.482667286507393*^9, 3.482667316247881*^9}, 
   3.482733809152215*^9, 3.483271718085187*^9, 3.4832751464180317`*^9, 
   3.4832752168022413`*^9, 3.497953801728058*^9, 3.5014865732368526`*^9, {
   3.501486608530643*^9, 3.501486615435408*^9}, {3.501486763855647*^9, 
   3.460390616769381*^9}, 3.46039075566882*^9, 3.460429456543686*^9, {
   3.460429523346076*^9, 3.460343390661408*^9}, 3.460398470949234*^9, {
   3.460625345509058*^9, 3.460366127059011*^9}, 3.460373669784206*^9, 
   3.541436165643277*^9, 3.5414411143518972`*^9, {3.541441336571858*^9, 
   3.541441365717493*^9}, 3.542000029785453*^9, 3.542001661764587*^9, {
   3.542471282771441*^9, 3.542471299806711*^9}, 3.543558374666609*^9, 
   3.543560346588325*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dTIsreal2", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], "/.", "branebc"}], ")"}], "/.", 
      RowBox[{"{", 
       RowBox[{"a", "\[Rule]", "1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dAIsreal2", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["A", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], "/.", "branebc"}], ")"}], "/.", 
      RowBox[{"{", 
       RowBox[{"a", "\[Rule]", "1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dSIsreal2", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"l", ",", "r", ",", "a"}], "]"}], "/.", "branebc"}], ")"}], "/.", 
      RowBox[{"{", 
       RowBox[{"a", "\[Rule]", "1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dBIsreal2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["B", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"l", ",", "r", ",", "a"}], "]"}], "/.", "branebc"}], ")"}], "/.", 
     RowBox[{"{", 
      RowBox[{"a", "\[Rule]", "1"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.482666329233589*^9, 3.482666346144124*^9}, {
  3.482667277855012*^9, 3.4826672960017023`*^9}, {3.483275159232574*^9, 
  3.483275197339058*^9}, {3.501486620352169*^9, 3.460390660146793*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"dTIsreal2", "//.", 
   RowBox[{"(", 
    RowBox[{"repl", "/.", 
     RowBox[{"{", 
      RowBox[{"a", "\[Rule]", "1"}], "}"}]}], ")"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.48266641384594*^9, 3.48266641504587*^9}, {
  3.482667322967722*^9, 3.482667327781455*^9}, {3.483275266606483*^9, 
  3.460398537128461*^9}}],

Cell["-(La/L) + 4*kappa*Sqrt(L*exp(B + S))", "Output",
 CellChangeTimes->{
  3.482666415517602*^9, 3.482666794568019*^9, 3.4826673280987673`*^9, 
   3.483275228496613*^9, {3.483275272880875*^9, 3.483275281805859*^9}, 
   3.497953815252033*^9, 3.501486623598599*^9, {3.5014867656342916`*^9, 
   3.460390662135989*^9}, {3.460390758239129*^9, 3.4603907831759243`*^9}, 
   3.460429456971951*^9, {3.460429523718811*^9, 3.460396744662808*^9}, 
   3.460398481675511*^9, {3.460398537638631*^9, 3.460398567326332*^9}, 
   3.460398721528507*^9, 3.4603987926405373`*^9, {3.46044333699896*^9, 
   3.4604433581229143`*^9}, {3.460443424124359*^9, 3.4603661334955597`*^9}, 
   3.460373674134122*^9, 3.541436172738799*^9, 3.541441120955653*^9, 
   3.542000048922336*^9, 3.542001668751718*^9, 3.542471304298812*^9, 
   3.5435583815488462`*^9, 3.543560349837936*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"dAIsreal2", "//.", 
   RowBox[{"(", 
    RowBox[{"repl", "/.", 
     RowBox[{"{", 
      RowBox[{"a", "\[Rule]", "1"}], "}"}]}], ")"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4826673376389227`*^9, 3.482667337989561*^9}, {
  3.483275278518462*^9, 3.460398539589919*^9}}],

Cell["0", "Output",
 CellChangeTimes->{
  3.482667338373866*^9, 3.483275228535616*^9, 3.483275282171975*^9, 
   3.4979538153504343`*^9, 3.501486624558921*^9, {3.501486766050523*^9, 
   3.460390662683133*^9}, {3.46039075875778*^9, 3.4603907836909*^9}, 
   3.460429457025646*^9, {3.4604295238021*^9, 3.460396745416786*^9}, 
   3.4603984832414103`*^9, {3.4603985401685*^9, 3.4603985679761667`*^9}, 
   3.4603987224440737`*^9, 3.4603987932752523`*^9, 3.4604433595028353`*^9, {
   3.4604434247562847`*^9, 3.4603661345595903`*^9}, 3.4603736749474277`*^9, 
   3.541436173974338*^9, 3.5414411218567953`*^9, 3.542000050224688*^9, 
   3.542001669553392*^9, 3.54247130526659*^9, 3.54355838258361*^9, 
   3.543560350890068*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"dSIsreal2", "//.", 
   RowBox[{"(", 
    RowBox[{"repl", "/.", 
     RowBox[{"{", 
      RowBox[{"a", "\[Rule]", "1"}], "}"}]}], ")"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.482667340605547*^9, 3.4826673412141447`*^9}, {
  3.48327527959868*^9, 3.4603985424379396`*^9}}],

Cell["-(La/L) + 4*kappa*Sqrt(L*exp(B + S))", "Output",
 CellChangeTimes->{
  3.482667342536359*^9, 3.483275228573588*^9, 3.483275282554603*^9, 
   3.497953815435*^9, 3.5014866253402767`*^9, {3.5014867665165863`*^9, 
   3.460390663214652*^9}, {3.460390759490076*^9, 3.460390784224037*^9}, 
   3.460429457070241*^9, {3.460429523885563*^9, 3.46039674606059*^9}, 
   3.460398509648984*^9, {3.460398542949649*^9, 3.460398568542313*^9}, 
   3.46039872322698*^9, 3.460398793908359*^9, {3.4604434345359907`*^9, 
   3.460366135191689*^9}, 3.460373675530223*^9, 3.541436176517158*^9, 
   3.5414411227589617`*^9, 3.542000051644436*^9, 3.542001670186236*^9, 
   3.542471306369401*^9, 3.543558383419289*^9, 3.5435603516249027`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"dBIsreal2", "//.", 
   RowBox[{"(", 
    RowBox[{"repl", "/.", 
     RowBox[{"{", 
      RowBox[{"a", "\[Rule]", "1"}], "}"}]}], ")"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4603906688163757`*^9, 3.460390669142168*^9}, 
   3.4603985449821978`*^9}],

Cell["\<\
-((2*B*L - 16*kappa*L*Sqrt(L*exp(B + S)) + La*(-1 + 3*exp(B) + exp(B + S - T) \
+ exp(B - A*Power(r,2) + S - T)))/L)\
\>", "Output",
 CellChangeTimes->{
  3.460390669821198*^9, {3.460390760055357*^9, 3.460390784721488*^9}, 
   3.460429457117324*^9, {3.4604295239956408`*^9, 3.460396746677823*^9}, {
   3.460398521386175*^9, 3.46039856914085*^9}, 3.460398724058107*^9, 
   3.460398794522999*^9, {3.460443435183792*^9, 3.460366135788519*^9}, 
   3.460373678491181*^9, 3.541436177381538*^9, 3.5414411252476254`*^9, 
   3.541441447125638*^9, 3.54200005252204*^9, 3.542001670922904*^9, 
   3.5424713074054613`*^9, 3.54355838425366*^9, 3.5435603523454523`*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalDelta]", "[", 
    RowBox[{"r_", ",", "a_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     FractionBox[
      RowBox[{" ", "1"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"a", "^", "2"}]}], ")"}], "+", 
       RowBox[{"rh", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"r", "^", "2"}]}], ")"}]}]}]], ")"}], "^", "2"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "r_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"r", "^", "2"}]}], ")"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", "a_", "]"}], ":=", 
   RowBox[{"2", "-", 
    RowBox[{"a", "^", "2"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"j", "[", "r_", "]"}], ":=", 
  RowBox[{"2", "-", 
   RowBox[{"r", "^", "2"}]}]}]}], "Input",
 CellChangeTimes->{{3.503997037073781*^9, 3.503997076077972*^9}, {
   3.503997256891058*^9, 3.4603927524745617`*^9}, {3.460396639861096*^9, 
   3.4603966466740303`*^9}, {3.460397369545499*^9, 3.460397369641325*^9}, 
   3.542000056801694*^9, 3.542001682249229*^9, {3.542471312494042*^9, 
   3.542471313029801*^9}, 3.542471348925845*^9, {3.54356035510252*^9, 
   3.543560365267411*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "dTIsreal2", "]"}]], "Input",
 CellChangeTimes->{{3.4606255120118237`*^9, 3.460625512400996*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"4", " ", "kappa", " ", 
   SqrtBox[
    FractionBox[
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"B", "[", 
        RowBox[{"l", ",", "r", ",", "1"}], "]"}], "+", 
       RowBox[{"S", "[", 
        RowBox[{"l", ",", "r", ",", "1"}], "]"}]}]], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
      SuperscriptBox["rh", "2"]}]]]}], "-", 
  FractionBox["4", 
   RowBox[{"rh", "-", 
    RowBox[{
     SuperscriptBox["r", "2"], " ", "rh"}]}]]}]], "Output",
 CellChangeTimes->{{3.460625512843505*^9, 3.460366173436043*^9}, 
   3.460373683679315*^9, 3.5414362046277647`*^9, 3.541436280218103*^9, 
   3.541441487607409*^9, 3.5420000583587313`*^9, 3.542001684194853*^9, 
   3.5424713512329683`*^9, 3.5435584082606153`*^9, 3.5435603722539997`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "dBIsreal2", "]"}]], "Input",
 CellChangeTimes->{{3.460625523249559*^9, 3.460625527177558*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "[", 
            RowBox[{"l", ",", "r", ",", "1"}], "]"}]]}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"B", "[", 
            RowBox[{"l", ",", "r", ",", "1"}], "]"}], "+", 
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "1"}], "]"}], "-", 
           RowBox[{"T", "[", 
            RowBox[{"l", ",", "r", ",", "1"}], "]"}]}]], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["r", "2"]}], " ", 
            RowBox[{"A", "[", 
             RowBox[{"l", ",", "r", ",", "1"}], "]"}]}], "+", 
           RowBox[{"B", "[", 
            RowBox[{"l", ",", "r", ",", "1"}], "]"}], "+", 
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "1"}], "]"}], "-", 
           RowBox[{"T", "[", 
            RowBox[{"l", ",", "r", ",", "1"}], "]"}]}]]}], ")"}]}], "+", 
      RowBox[{"8", " ", "kappa", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"B", "[", 
            RowBox[{"l", ",", "r", ",", "1"}], "]"}], "+", 
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "1"}], "]"}]}]], 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
          SuperscriptBox["rh", "2"]}]]], " ", "rh"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}], " ", "rh", " ", 
       RowBox[{"B", "[", 
        RowBox[{"l", ",", "r", ",", "1"}], "]"}]}]}], ")"}]}], 
   RowBox[{"rh", "-", 
    RowBox[{
     SuperscriptBox["r", "2"], " ", "rh"}]}]]}]], "Output",
 CellChangeTimes->{{3.4606255239717083`*^9, 3.460366178022009*^9}, 
   3.46037368609914*^9, 3.54143620618091*^9, 3.541436280903458*^9, 
   3.5414414935721893`*^9, 3.542000060053234*^9, 3.5420016860981693`*^9, 
   3.542471352689063*^9, 3.543558409465165*^9, 3.5435603736257553`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "dSIsreal2", "]"}]], "Input",
 CellChangeTimes->{{3.460625520788066*^9, 3.4606255211132517`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"4", " ", "kappa", " ", 
   SqrtBox[
    FractionBox[
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"B", "[", 
        RowBox[{"l", ",", "r", ",", "1"}], "]"}], "+", 
       RowBox[{"S", "[", 
        RowBox[{"l", ",", "r", ",", "1"}], "]"}]}]], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "2"], " ", 
      SuperscriptBox["rh", "2"]}]]]}], "-", 
  FractionBox["4", 
   RowBox[{"rh", "-", 
    RowBox[{
     SuperscriptBox["r", "2"], " ", "rh"}]}]]}]], "Output",
 CellChangeTimes->{{3.460625524704646*^9, 3.4603661835630198`*^9}, 
   3.460373686956915*^9, 3.5414362123672247`*^9, 3.541436281952195*^9, 
   3.541441494919517*^9, 3.542000061214082*^9, 3.542001691375708*^9, 
   3.54247135419643*^9, 3.54355841033806*^9, 3.543560374486946*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dTIsreal3", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"dTIsreal2", "/.", 
     RowBox[{"{", 
      RowBox[{"kappa", "\[Rule]", "1"}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"0", "<", "r", "<", "1"}], ",", 
      RowBox[{"rh", ">", "0"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.460625536756385*^9, 3.460625568437166*^9}, {
   3.460625604973116*^9, 3.460625648343101*^9}, {3.541436297202507*^9, 
   3.5414363166615887`*^9}, {3.541436346981732*^9, 3.541436357092629*^9}, {
   3.542000071973475*^9, 3.542000091226808*^9}, {3.542001707227441*^9, 
   3.542001731860798*^9}, {3.5424713627909946`*^9, 3.542471380412365*^9}, {
   3.542471438596756*^9, 3.54247144109974*^9}, 3.543558452326651*^9}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox[
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"B", "[", 
          RowBox[{"l", ",", "r", ",", "1"}], "]"}], "+", 
         RowBox[{"S", "[", 
          RowBox[{"l", ",", "r", ",", "1"}], "]"}]}]]]}], ")"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]]}]], "Output",
 CellChangeTimes->{{3.460625648971847*^9, 3.4603662250124826`*^9}, 
   3.460366321055632*^9, 3.4603737283245907`*^9, 3.541436358251173*^9, 
   3.541441501104067*^9, 3.542000093870826*^9, 3.542000159245166*^9, {
   3.54200173290197*^9, 3.5420017442673264`*^9}, 3.5420017816417847`*^9, 
   3.542471381705497*^9, {3.542471441885741*^9, 3.5424714688291903`*^9}, 
   3.5435584560245132`*^9, 3.5435585471555862`*^9, 3.543560375699044*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dBIsreal3", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"dBIsreal2", "/.", 
     RowBox[{"{", 
      RowBox[{"kappa", "\[Rule]", "1"}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"0", "<", "r", "<", "1"}], ",", 
      RowBox[{"rh", ">", "0"}], ",", 
      RowBox[{
       RowBox[{"B", "[", 
        RowBox[{"l", ",", "r", ",", "1"}], "]"}], ">", "0"}], ",", 
      RowBox[{
       RowBox[{"S", "[", 
        RowBox[{"l", ",", "r", ",", "1"}], "]"}], ">", "0"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.460625549187962*^9, 3.460625575258387*^9}, {
  3.460625641361923*^9, 3.4603662186320887`*^9}, {3.460373784286346*^9, 
  3.460373868359831*^9}, {3.541436365656349*^9, 3.541436414753993*^9}, {
  3.542000100670162*^9, 3.542000137744828*^9}, {3.5420017479170847`*^9, 
  3.542001778692506*^9}, {3.5424713988131332`*^9, 3.542471411447419*^9}, {
  3.54247146023982*^9, 3.542471464207798*^9}, {3.543558461893446*^9, 
  3.5435585380168533`*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"B", "[", 
            RowBox[{"l", ",", "r", ",", "1"}], "]"}]]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            FractionBox["1", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"B", "[", 
               RowBox[{"l", ",", "r", ",", "1"}], "]"}], "+", 
              RowBox[{"S", "[", 
               RowBox[{"l", ",", "r", ",", "1"}], "]"}]}], ")"}]}]]}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"B", "[", 
            RowBox[{"l", ",", "r", ",", "1"}], "]"}], "+", 
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "1"}], "]"}], "-", 
           RowBox[{"T", "[", 
            RowBox[{"l", ",", "r", ",", "1"}], "]"}]}]], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["r", "2"]}], " ", 
            RowBox[{"A", "[", 
             RowBox[{"l", ",", "r", ",", "1"}], "]"}]}], "+", 
           RowBox[{"B", "[", 
            RowBox[{"l", ",", "r", ",", "1"}], "]"}], "+", 
           RowBox[{"S", "[", 
            RowBox[{"l", ",", "r", ",", "1"}], "]"}], "-", 
           RowBox[{"T", "[", 
            RowBox[{"l", ",", "r", ",", "1"}], "]"}]}]]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"rh", "-", 
         RowBox[{
          SuperscriptBox["r", "2"], " ", "rh"}]}], ")"}], " ", 
       RowBox[{"B", "[", 
        RowBox[{"l", ",", "r", ",", "1"}], "]"}]}]}], ")"}]}], 
   RowBox[{"rh", "-", 
    RowBox[{
     SuperscriptBox["r", "2"], " ", "rh"}]}]]}]], "Output",
 CellChangeTimes->{{3.460625662125121*^9, 3.460366230839263*^9}, 
   3.460366321805863*^9, {3.460373728065942*^9, 3.460373728502384*^9}, {
   3.460373800413118*^9, 3.460373823992545*^9}, 3.46037386929993*^9, 
   3.541436417251422*^9, 3.5414415035596237`*^9, {3.542000116139043*^9, 
   3.542000159933257*^9}, {3.542001779433329*^9, 3.542001782629992*^9}, 
   3.542471416903139*^9, {3.542471465303051*^9, 3.542471469527287*^9}, {
   3.543558466181735*^9, 3.543558547804779*^9}, 3.543560377362821*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dSIsreal3", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"dSIsreal2", "/.", 
     RowBox[{"{", 
      RowBox[{"kappa", "\[Rule]", "1"}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"0", "<", "r", "<", "1"}], ",", 
      RowBox[{"rh", ">", "0"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4606255540100203`*^9, 3.4606255707253733`*^9}, {
   3.4606256289083157`*^9, 3.460625657113338*^9}, {3.542000134498847*^9, 
   3.542000157140596*^9}, 3.54200174261581*^9, {3.54247142633399*^9, 
   3.542471435900934*^9}, {3.543558542850759*^9, 3.543558544424521*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox[
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"B", "[", 
          RowBox[{"l", ",", "r", ",", "1"}], "]"}], "+", 
         RowBox[{"S", "[", 
          RowBox[{"l", ",", "r", ",", "1"}], "]"}]}]]]}], ")"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]]}]], "Output",
 CellChangeTimes->{
  3.46062565762213*^9, {3.460628959979411*^9, 3.460366237022523*^9}, 
   3.46036632247007*^9, 3.460373728736845*^9, 3.460373870876129*^9, 
   3.541436430841872*^9, 3.541441504278008*^9, {3.542000157709217*^9, 
   3.542000160815113*^9}, 3.542001745785475*^9, 3.542001783378298*^9, 
   3.542471427372732*^9, {3.542471466516295*^9, 3.5424714702605543`*^9}, {
   3.543558544889427*^9, 3.543558548377769*^9}, 3.543560379064086*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", "dTIsreal3", "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"kappa", "\[Rule]", "1"}], ",", 
    RowBox[{
     RowBox[{"T", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"B", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"S", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{"rh", "\[Rule]", "0.1"}], ",", 
    RowBox[{"r", "\[Rule]", "0.4"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.4606254077699423`*^9, 3.460625435956171*^9}, {
  3.460625493401075*^9, 3.460625494994617*^9}, {3.460625681515357*^9, 
  3.460625681616694*^9}}],

Cell[BoxData["0.`"], "Output",
 CellChangeTimes->{{3.460625414026751*^9, 3.460625445961567*^9}, 
   3.460625495427803*^9, {3.460625681990081*^9, 3.4603662397990313`*^9}, 
   3.460373729723818*^9, 3.46037387159062*^9, 3.541436436286734*^9, 
   3.541441505306881*^9, 3.542000164112796*^9, 3.542001785598373*^9, 
   3.542471473562339*^9, 3.543558552568088*^9, 3.54356038181142*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", "dBIsreal3", "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"kappa", "\[Rule]", "1"}], ",", 
    RowBox[{
     RowBox[{"T", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"B", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"S", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{"rh", "\[Rule]", "0.1"}], ",", 
    RowBox[{"r", "\[Rule]", "0.4"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.460625454755323*^9, 3.4606254816132298`*^9}, {
  3.46062568361998*^9, 3.460625683699692*^9}}],

Cell[BoxData["0.`"], "Output",
 CellChangeTimes->{{3.460625466018849*^9, 3.4606254964589977`*^9}, {
   3.460625684260768*^9, 3.460366240688037*^9}, 3.460373730415722*^9, 
   3.460373872313497*^9, 3.541436438184041*^9, 3.541441507037529*^9, 
   3.542000166098158*^9, 3.542471480660482*^9, 3.543558556488125*^9, 
   3.5435603844570923`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", "dSIsreal3", "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"kappa", "\[Rule]", "1"}], ",", 
    RowBox[{
     RowBox[{"T", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"B", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"S", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{"rh", "\[Rule]", "0.1"}], ",", 
    RowBox[{"r", "\[Rule]", "0.4"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.46062545974542*^9, 3.460625487938364*^9}, {
  3.460625685700068*^9, 3.4606256858647614`*^9}}],

Cell[BoxData["0.`"], "Output",
 CellChangeTimes->{{3.46062546628301*^9, 3.4606254969425983`*^9}, 
   3.460625686629319*^9, {3.460626903293795*^9, 3.460366241492592*^9}, 
   3.460373731020234*^9, 3.460373872988452*^9, 3.541436439342022*^9, 
   3.5414415070940847`*^9, 3.542000166159018*^9, 3.542471480743539*^9, 
   3.543558556573065*^9, 3.543560384522317*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dTIsreal3", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"T", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "T"}], ",", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "A"}], ",", 
    RowBox[{
     RowBox[{"B", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "B"}], ",", 
    RowBox[{
     RowBox[{"S", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "S"}]}], 
   "}"}]}]], "Input",
 CellChangeTimes->{{3.460366326404954*^9, 3.460366343806595*^9}, {
  3.460366440854886*^9, 3.460366459298997*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox[
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"B", "+", "S"}]]]}], ")"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]]}]], "Output",
 CellChangeTimes->{3.4603663443754873`*^9, 3.460366465176065*^9, 
  3.46037373175141*^9, 3.4603738736664762`*^9, 3.54143644301832*^9, 
  3.54144150782841*^9, 3.542000167528801*^9, 3.542471490029846*^9, 
  3.543558562150971*^9, 3.5435603845901823`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dSIsreal3", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"T", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "T"}], ",", 
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "A"}], ",", 
    RowBox[{
     RowBox[{"B", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "B"}], ",", 
    RowBox[{
     RowBox[{"S", "[", 
      RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "S"}]}], 
   "}"}]}]], "Input",
 CellChangeTimes->{{3.460366353302204*^9, 3.460366361406906*^9}, {
  3.46036644791894*^9, 3.460366462758285*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox[
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"B", "+", "S"}]]]}], ")"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["r", "2"]}], ")"}], " ", "rh"}]]}]], "Output",
 CellChangeTimes->{3.460366361872528*^9, 3.460366465847497*^9, 
  3.460373732381997*^9, 3.460373874583239*^9, 3.541436444003272*^9, 
  3.541441508547065*^9, 3.54200016866442*^9, 3.542471491981908*^9, 
  3.543558563053483*^9, 3.5435603855080423`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"dBIsreal3", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"T", "[", 
       RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "T"}], ",", 
     RowBox[{
      RowBox[{"A", "[", 
       RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "A"}], ",", 
     RowBox[{
      RowBox[{"B", "[", 
       RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "B"}], ",", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"l", ",", "r", ",", "1"}], "]"}], "\[Rule]", "S"}]}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.4603663549147167`*^9, 3.460366355238681*^9}, {
  3.46036644907089*^9, 3.460366463895072*^9}, {3.460373882356413*^9, 
  3.4603738840598507`*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["\[ExponentialE]", "B"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", 
           FractionBox[
            RowBox[{"B", "+", "S"}], "2"]]}], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "+", "S", "-", "T"}]], "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"B", "-", 
           RowBox[{"A", " ", 
            SuperscriptBox["r", "2"]}], "+", "S", "-", "T"}]]}], ")"}]}], "+", 
      RowBox[{"B", " ", 
       RowBox[{"(", 
        RowBox[{"rh", "-", 
         RowBox[{
          SuperscriptBox["r", "2"], " ", "rh"}]}], ")"}]}]}], ")"}]}], 
   RowBox[{"rh", "-", 
    RowBox[{
     SuperscriptBox["r", "2"], " ", "rh"}]}]]}]], "Output",
 CellChangeTimes->{{3.460366358112462*^9, 3.460366362736011*^9}, 
   3.4603664664965277`*^9, 3.460373733047374*^9, {3.460373879873641*^9, 
   3.4603738846336823`*^9}, 3.54143644592511*^9, 3.541441509444298*^9, 
   3.5420001705037394`*^9, 3.54247149316492*^9, 3.543558564152191*^9, 
   3.543560386569736*^9}]
}, Open  ]]
}, Open  ]]
}, Closed]]
},
WindowSize->{1106, 750},
WindowMargins->{{Automatic, -7}, {Automatic, 0}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "calcgeom"->{
  Cell[62334, 1550, 306, 9, 73, "Input",
   CellTags->"calcgeom"],
  Cell[62643, 1561, 293, 10, 73, "Input",
   CellTags->"calcgeom"],
  Cell[62939, 1573, 264, 9, 58, "Input",
   CellTags->"calcgeom"],
  Cell[63206, 1584, 264, 9, 58, "Input",
   CellTags->"calcgeom"],
  Cell[63473, 1595, 3551, 100, 141, "Input",
   CellTags->"calcgeom"],
  Cell[67027, 1697, 155, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[67389, 1709, 5599, 153, 193, "Input",
   CellTags->"calcgeom"],
  Cell[72991, 1864, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[73136, 1870, 1615, 48, 88, "Input",
   CellTags->"calcgeom"],
  Cell[74754, 1920, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[74899, 1926, 633, 22, 27, "Input",
   CellTags->"calcgeom"],
  Cell[75535, 1950, 1648, 51, 115, "Input",
   CellTags->"calcgeom"],
  Cell[77186, 2003, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[77331, 2009, 145, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[395689, 10131, 306, 9, 73, "Input",
   CellTags->"calcgeom"],
  Cell[395998, 10142, 293, 10, 73, "Input",
   CellTags->"calcgeom"],
  Cell[396294, 10154, 264, 9, 58, "Input",
   CellTags->"calcgeom"],
  Cell[396561, 10165, 264, 9, 58, "Input",
   CellTags->"calcgeom"],
  Cell[396828, 10176, 3551, 100, 141, "Input",
   CellTags->"calcgeom"],
  Cell[400382, 10278, 155, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[400744, 10290, 5599, 153, 193, "Input",
   CellTags->"calcgeom"],
  Cell[406346, 10445, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[406491, 10451, 1615, 48, 88, "Input",
   CellTags->"calcgeom"],
  Cell[408109, 10501, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[408254, 10507, 633, 22, 27, "Input",
   CellTags->"calcgeom"],
  Cell[408890, 10531, 1648, 51, 115, "Input",
   CellTags->"calcgeom"],
  Cell[410541, 10584, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[410686, 10590, 145, 4, 27, "Input",
   CellTags->"calcgeom"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"calcgeom", 680838, 17465}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 428, 7, 46, "Subtitle"],
Cell[CellGroupData[{
Cell[1020, 33, 68, 1, 27, "Input"],
Cell[1091, 36, 1044, 15, 20, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2172, 56, 111, 1, 26, "Subsubtitle"],
Cell[2286, 59, 95, 2, 27, "Input"],
Cell[CellGroupData[{
Cell[2406, 65, 279, 8, 58, "Input"],
Cell[2688, 75, 1166, 19, 70, "Output"],
Cell[3857, 96, 1564, 30, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5458, 131, 266, 9, 58, "Input"],
Cell[5727, 142, 1052, 15, 70, "Output"],
Cell[6782, 159, 1052, 15, 70, "Output"]
}, Open  ]],
Cell[7849, 177, 407, 13, 27, "Input"],
Cell[8259, 192, 37, 0, 27, "Input"],
Cell[CellGroupData[{
Cell[8321, 196, 257, 8, 58, "Input"],
Cell[8581, 206, 1153, 18, 70, "Output"],
Cell[9737, 226, 1062, 15, 70, "Output"]
}, Open  ]],
Cell[10814, 244, 2020, 62, 163, "Input"],
Cell[12837, 308, 26, 0, 27, "Input"],
Cell[12866, 310, 841, 25, 58, "Input"],
Cell[13710, 337, 1026, 31, 88, "Input"],
Cell[14739, 370, 227, 8, 86, "Text"],
Cell[14969, 380, 4015, 95, 313, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[19021, 480, 111, 3, 26, "Subsubtitle"],
Cell[19135, 485, 128, 4, 26, "Text"],
Cell[19266, 491, 6139, 139, 718, "Input"],
Cell[25408, 632, 68, 1, 26, "Text"],
Cell[25479, 635, 3727, 84, 523, "Input"],
Cell[29209, 721, 824, 18, 208, "Input"],
Cell[30036, 741, 4051, 89, 583, "Input"],
Cell[34090, 832, 99, 2, 27, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[34226, 839, 34, 0, 26, "Subsubtitle"],
Cell[CellGroupData[{
Cell[34285, 843, 516, 10, 49, "Input"],
Cell[34804, 855, 712, 10, 165, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35553, 870, 4811, 113, 427, "Input"],
Cell[40367, 985, 4352, 110, 133, "Output"],
Cell[44722, 1097, 977, 17, 27, "Output"],
Cell[45702, 1116, 863, 13, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46602, 1134, 28, 0, 27, "Input"],
Cell[46633, 1136, 4544, 112, 133, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51214, 1253, 28, 0, 27, "Input"],
Cell[51245, 1255, 8389, 220, 223, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[59671, 1480, 119, 3, 27, "Input"],
Cell[59793, 1485, 2457, 57, 60, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[62299, 1548, 32, 0, 26, "Subsubtitle"],
Cell[62334, 1550, 306, 9, 73, "Input",
 CellTags->"calcgeom"],
Cell[62643, 1561, 293, 10, 73, "Input",
 CellTags->"calcgeom"],
Cell[62939, 1573, 264, 9, 58, "Input",
 CellTags->"calcgeom"],
Cell[63206, 1584, 264, 9, 58, "Input",
 CellTags->"calcgeom"],
Cell[63473, 1595, 3551, 100, 141, "Input",
 CellTags->"calcgeom"],
Cell[67027, 1697, 155, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[67185, 1703, 201, 4, 27, "Input"],
Cell[67389, 1709, 5599, 153, 193, "Input",
 CellTags->"calcgeom"],
Cell[72991, 1864, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[73136, 1870, 1615, 48, 88, "Input",
 CellTags->"calcgeom"],
Cell[74754, 1920, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[74899, 1926, 633, 22, 27, "Input",
 CellTags->"calcgeom"],
Cell[75535, 1950, 1648, 51, 115, "Input",
 CellTags->"calcgeom"],
Cell[77186, 2003, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[77331, 2009, 145, 4, 27, "Input",
 CellTags->"calcgeom"]
}, Closed]],
Cell[CellGroupData[{
Cell[77513, 2018, 41, 0, 26, "Subsubtitle"],
Cell[CellGroupData[{
Cell[77579, 2022, 97, 1, 27, "Input"],
Cell[77679, 2025, 907, 16, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[78623, 2046, 390, 10, 27, "Input"],
Cell[79016, 2058, 1104, 19, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[80157, 2082, 388, 10, 27, "Input"],
Cell[80548, 2094, 1169, 20, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[81754, 2119, 462, 12, 27, "Input"],
Cell[82219, 2133, 1684, 35, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[83940, 2173, 265, 7, 27, "Input"],
Cell[84208, 2182, 1468, 29, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[85713, 2216, 478, 13, 27, "Input"],
Cell[86194, 2231, 2051, 46, 59, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[88282, 2282, 1330, 32, 49, "Input"],
Cell[89615, 2316, 4200, 103, 174, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[93852, 2424, 334, 9, 27, "Input"],
Cell[94189, 2435, 798, 12, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[95024, 2452, 308, 9, 27, "Input"],
Cell[95335, 2463, 740, 11, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[96112, 2479, 720, 21, 88, "Input"],
Cell[96835, 2502, 4432, 111, 189, "Output"],
Cell[101270, 2615, 4622, 117, 183, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[105929, 2737, 1065, 34, 88, "Input"],
Cell[106997, 2773, 915, 16, 27, "Output"],
Cell[107915, 2791, 1640, 37, 57, "Output"],
Cell[109558, 2830, 1640, 37, 57, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[111235, 2872, 627, 18, 27, "Input"],
Cell[111865, 2892, 50028, 1218, 1060, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[161930, 4115, 412, 12, 27, "Input"],
Cell[162345, 4129, 18631, 470, 426, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[181013, 4604, 1172, 35, 33, "Input"],
Cell[182188, 4641, 11646, 315, 354, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[193871, 4961, 369, 9, 27, "Input"],
Cell[194243, 4972, 1577, 33, 27, "Output"]
}, Open  ]],
Cell[195835, 5008, 1167, 39, 99, "Input"],
Cell[197005, 5049, 281, 6, 27, "Input"],
Cell[197289, 5057, 1290, 35, 113, "Input"],
Cell[198582, 5094, 1182, 29, 148, "Input"],
Cell[CellGroupData[{
Cell[199789, 5127, 98, 1, 27, "Input"],
Cell[199890, 5130, 4829, 131, 135, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[204756, 5266, 255, 6, 27, "Input"],
Cell[205014, 5274, 10347, 301, 450, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[215398, 5580, 1737, 55, 118, "Input"],
Cell[217138, 5637, 1053, 23, 47, "Output"],
Cell[218194, 5662, 1054, 23, 47, "Output"],
Cell[219251, 5687, 1056, 23, 47, "Output"],
Cell[220310, 5712, 1054, 23, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[221401, 5740, 711, 21, 61, "Input"],
Cell[222115, 5763, 1123, 22, 56, "Output"],
Cell[223241, 5787, 917, 13, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[224195, 5805, 660, 20, 61, "Input"],
Cell[224858, 5827, 839, 12, 27, "Output"],
Cell[225700, 5841, 839, 12, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[226576, 5858, 701, 21, 61, "Input"],
Cell[227280, 5881, 991, 20, 56, "Output"],
Cell[228274, 5903, 785, 11, 27, "Output"]
}, Open  ]],
Cell[229074, 5917, 281, 6, 27, "Input"],
Cell[229358, 5925, 49537, 1103, 821, "Input"],
Cell[278898, 7030, 239, 7, 27, "Input"],
Cell[279140, 7039, 9863, 307, 142, "Input"],
Cell[289006, 7348, 126, 4, 27, "Input"],
Cell[CellGroupData[{
Cell[289157, 7356, 3280, 91, 107, "Input"],
Cell[292440, 7449, 11079, 300, 372, "Output"]
}, Open  ]],
Cell[303534, 7752, 2399, 73, 141, "Input"],
Cell[CellGroupData[{
Cell[305958, 7829, 365, 9, 27, "Input"],
Cell[306326, 7840, 826, 12, 39, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[307189, 7857, 320, 8, 27, "Input"],
Cell[307512, 7867, 689, 10, 39, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[308238, 7882, 321, 8, 27, "Input"],
Cell[308562, 7892, 694, 10, 39, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[309293, 7907, 299, 8, 27, "Input"],
Cell[309595, 7917, 640, 11, 39, "Output"]
}, Open  ]],
Cell[310250, 7931, 1187, 34, 113, "Input"],
Cell[CellGroupData[{
Cell[311462, 7969, 137, 2, 27, "Input"],
Cell[311602, 7973, 908, 26, 66, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[312547, 8004, 135, 2, 27, "Input"],
Cell[312685, 8008, 2692, 73, 118, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[315414, 8086, 137, 2, 27, "Input"],
Cell[315554, 8090, 902, 26, 66, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[316493, 8121, 762, 16, 27, "Input"],
Cell[317258, 8139, 874, 22, 72, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[318169, 8166, 1010, 24, 27, "Input"],
Cell[319182, 8192, 2801, 73, 84, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[322020, 8270, 617, 14, 27, "Input"],
Cell[322640, 8286, 888, 23, 72, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[323565, 8314, 858, 22, 27, "Input"],
Cell[324426, 8338, 357, 5, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[324820, 8348, 808, 21, 27, "Input"],
Cell[325631, 8371, 310, 4, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[325978, 8380, 808, 21, 27, "Input"],
Cell[326789, 8403, 337, 5, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[327163, 8413, 640, 18, 27, "Input"],
Cell[327806, 8433, 543, 16, 72, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[328386, 8454, 639, 18, 27, "Input"],
Cell[329028, 8474, 541, 16, 72, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[329606, 8495, 740, 20, 27, "Input"],
Cell[330349, 8517, 1611, 45, 84, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[332021, 8569, 426, 7, 46, "Subtitle"],
Cell[CellGroupData[{
Cell[332472, 8580, 68, 1, 27, "Input"],
Cell[332543, 8583, 1114, 16, 20, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[333694, 8604, 111, 1, 26, "Subsubtitle"],
Cell[333808, 8607, 95, 2, 27, "Input"],
Cell[CellGroupData[{
Cell[333928, 8613, 279, 8, 58, "Input"],
Cell[334210, 8623, 1240, 20, 70, "Output"],
Cell[335453, 8645, 1640, 31, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[337130, 8681, 266, 9, 58, "Input"],
Cell[337399, 8692, 1124, 16, 70, "Output"],
Cell[338526, 8710, 1124, 16, 70, "Output"]
}, Open  ]],
Cell[339665, 8729, 407, 13, 27, "Input"],
Cell[340075, 8744, 37, 0, 27, "Input"],
Cell[CellGroupData[{
Cell[340137, 8748, 257, 8, 58, "Input"],
Cell[340397, 8758, 1225, 19, 70, "Output"],
Cell[341625, 8779, 1135, 16, 70, "Output"]
}, Open  ]],
Cell[342775, 8798, 2020, 62, 163, "Input"],
Cell[344798, 8862, 26, 0, 27, "Input"],
Cell[344827, 8864, 841, 25, 58, "Input"],
Cell[345671, 8891, 1026, 31, 88, "Input"],
Cell[346700, 8924, 227, 8, 86, "Text"],
Cell[346930, 8934, 4015, 95, 313, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[350982, 9034, 111, 3, 26, "Subsubtitle"],
Cell[351096, 9039, 128, 4, 26, "Text"],
Cell[351227, 9045, 6139, 139, 718, "Input"],
Cell[357369, 9186, 68, 1, 26, "Text"],
Cell[357440, 9189, 3727, 84, 523, "Input"],
Cell[361170, 9275, 824, 18, 208, "Input"],
Cell[361997, 9295, 4051, 89, 583, "Input"],
Cell[366051, 9386, 99, 2, 27, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[366187, 9393, 34, 0, 26, "Subsubtitle"],
Cell[CellGroupData[{
Cell[366246, 9397, 560, 10, 49, "Input"],
Cell[366809, 9409, 782, 11, 164, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[367628, 9425, 5093, 119, 427, "Input"],
Cell[372724, 9546, 4537, 114, 133, "Output"],
Cell[377264, 9662, 1021, 17, 27, "Output"],
Cell[378288, 9681, 907, 13, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[379232, 9699, 28, 0, 27, "Input"],
Cell[379263, 9701, 4763, 117, 133, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[384063, 9823, 28, 0, 27, "Input"],
Cell[384094, 9825, 8869, 231, 286, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[393000, 10061, 119, 3, 27, "Input"],
Cell[393122, 10066, 2483, 57, 40, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[395654, 10129, 32, 0, 26, "Subsubtitle"],
Cell[395689, 10131, 306, 9, 73, "Input",
 CellTags->"calcgeom"],
Cell[395998, 10142, 293, 10, 73, "Input",
 CellTags->"calcgeom"],
Cell[396294, 10154, 264, 9, 58, "Input",
 CellTags->"calcgeom"],
Cell[396561, 10165, 264, 9, 58, "Input",
 CellTags->"calcgeom"],
Cell[396828, 10176, 3551, 100, 141, "Input",
 CellTags->"calcgeom"],
Cell[400382, 10278, 155, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[400540, 10284, 201, 4, 27, "Input"],
Cell[400744, 10290, 5599, 153, 193, "Input",
 CellTags->"calcgeom"],
Cell[406346, 10445, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[406491, 10451, 1615, 48, 88, "Input",
 CellTags->"calcgeom"],
Cell[408109, 10501, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[408254, 10507, 633, 22, 27, "Input",
 CellTags->"calcgeom"],
Cell[408890, 10531, 1648, 51, 115, "Input",
 CellTags->"calcgeom"],
Cell[410541, 10584, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[410686, 10590, 145, 4, 27, "Input",
 CellTags->"calcgeom"]
}, Closed]],
Cell[CellGroupData[{
Cell[410868, 10599, 41, 0, 26, "Subsubtitle"],
Cell[CellGroupData[{
Cell[410934, 10603, 97, 1, 27, "Input"],
Cell[411034, 10606, 977, 17, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[412048, 10628, 390, 10, 27, "Input"],
Cell[412441, 10640, 1176, 20, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[413654, 10665, 388, 10, 27, "Input"],
Cell[414045, 10677, 1241, 21, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[415323, 10703, 462, 12, 27, "Input"],
Cell[415788, 10717, 1860, 39, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[417685, 10761, 265, 7, 27, "Input"],
Cell[417953, 10770, 1612, 32, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[419602, 10807, 478, 13, 27, "Input"],
Cell[420083, 10822, 2165, 48, 56, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[422285, 10875, 1488, 35, 49, "Input"],
Cell[423776, 10912, 4415, 106, 174, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[428228, 11023, 334, 9, 27, "Input"],
Cell[428565, 11034, 868, 13, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[429470, 11052, 308, 9, 27, "Input"],
Cell[429781, 11063, 814, 12, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[430632, 11080, 720, 21, 88, "Input"],
Cell[431355, 11103, 4650, 116, 189, "Output"],
Cell[436008, 11221, 4915, 124, 183, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[440960, 11350, 1065, 34, 88, "Input"],
Cell[442028, 11386, 989, 17, 27, "Output"],
Cell[443020, 11405, 1786, 40, 57, "Output"],
Cell[444809, 11447, 1786, 40, 57, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[446632, 11492, 627, 18, 27, "Input"],
Cell[447262, 11512, 53577, 1292, 1116, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[500876, 12809, 412, 12, 27, "Input"],
Cell[501291, 12823, 20355, 506, 438, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[521683, 13334, 1172, 35, 33, "Input"],
Cell[522858, 13371, 12586, 336, 369, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[535481, 13712, 369, 9, 27, "Input"],
Cell[535853, 13723, 1647, 34, 27, "Output"]
}, Open  ]],
Cell[537515, 13760, 1167, 39, 99, "Input"],
Cell[538685, 13801, 342, 7, 27, "Input"],
Cell[539030, 13810, 1523, 42, 142, "Input"],
Cell[540556, 13854, 1182, 29, 148, "Input"],
Cell[CellGroupData[{
Cell[541763, 13887, 98, 1, 27, "Input"],
Cell[541864, 13890, 5179, 139, 110, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[547080, 14034, 255, 6, 27, "Input"],
Cell[547338, 14042, 10926, 313, 267, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[558301, 14360, 1737, 55, 118, "Input"],
Cell[560041, 14417, 1099, 23, 47, "Output"],
Cell[561143, 14442, 1099, 23, 47, "Output"],
Cell[562245, 14467, 1101, 23, 47, "Output"],
Cell[563349, 14492, 1099, 23, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[564485, 14520, 711, 21, 61, "Input"],
Cell[565199, 14543, 1226, 24, 52, "Output"],
Cell[566428, 14569, 963, 13, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[567428, 14587, 660, 20, 61, "Input"],
Cell[568091, 14609, 883, 12, 27, "Output"],
Cell[568977, 14623, 885, 12, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[569899, 14640, 701, 21, 61, "Input"],
Cell[570603, 14663, 1098, 23, 52, "Output"],
Cell[571704, 14688, 833, 12, 27, "Output"]
}, Open  ]],
Cell[572552, 14703, 342, 7, 27, "Input"],
Cell[572897, 14712, 54312, 1207, 888, "Input"],
Cell[627212, 15921, 239, 7, 27, "Input"],
Cell[627454, 15930, 10189, 316, 142, "Input"],
Cell[637646, 16248, 126, 4, 27, "Input"],
Cell[CellGroupData[{
Cell[637797, 16256, 3280, 91, 107, "Input"],
Cell[641080, 16349, 11105, 301, 372, "Output"]
}, Open  ]],
Cell[652200, 16653, 2399, 73, 141, "Input"],
Cell[CellGroupData[{
Cell[654624, 16730, 365, 9, 27, "Input"],
Cell[654992, 16741, 848, 12, 39, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[655877, 16758, 320, 8, 27, "Input"],
Cell[656200, 16768, 715, 11, 39, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[656952, 16784, 321, 8, 27, "Input"],
Cell[657276, 16794, 718, 10, 39, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[658031, 16809, 299, 8, 27, "Input"],
Cell[658333, 16819, 664, 11, 39, "Output"]
}, Open  ]],
Cell[659012, 16833, 1365, 40, 142, "Input"],
Cell[CellGroupData[{
Cell[660402, 16877, 137, 2, 27, "Input"],
Cell[660542, 16881, 916, 25, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[661495, 16911, 135, 2, 27, "Input"],
Cell[661633, 16915, 2537, 68, 84, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[664207, 16988, 137, 2, 27, "Input"],
Cell[664347, 16992, 908, 25, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[665292, 17022, 762, 16, 27, "Input"],
Cell[666057, 17040, 962, 24, 68, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[667056, 17069, 1010, 24, 27, "Input"],
Cell[668069, 17095, 2450, 61, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[670556, 17161, 617, 14, 27, "Input"],
Cell[671176, 17177, 976, 25, 68, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[672189, 17207, 858, 22, 27, "Input"],
Cell[673050, 17231, 378, 5, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[673465, 17241, 808, 21, 27, "Input"],
Cell[674276, 17264, 338, 5, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[674651, 17274, 808, 21, 27, "Input"],
Cell[675462, 17297, 359, 5, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[675858, 17307, 640, 18, 27, "Input"],
Cell[676501, 17327, 629, 18, 68, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[677167, 17350, 639, 18, 27, "Input"],
Cell[677809, 17370, 627, 18, 68, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[678473, 17393, 740, 20, 27, "Input"],
Cell[679216, 17415, 1277, 34, 69, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]]
}
]
*)

(* End of internal cache information *)
