(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     30133,        761]
NotebookOptionsPosition[     28506,        707]
NotebookOutlinePosition[     28861,        723]
CellTagsIndexPosition[     28818,        720]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"NR", "=", "10"}], ";"}]], "Input",
 CellChangeTimes->{{3.54186620903804*^9, 3.541866210724594*^9}, {
   3.541867418021255*^9, 3.54186744037554*^9}, {3.5418678927528563`*^9, 
   3.541867913770398*^9}, 3.541869036942782*^9, 3.5418708395050383`*^9, {
   3.542438939278158*^9, 3.542438939397189*^9}}],

Cell[CellGroupData[{

Cell["Coordinates & Differentiation - precomputed", "Subsubtitle",
 CellChangeTimes->{{3.517556505886075*^9, 3.517556509091404*^9}, {
  3.5176375867460747`*^9, 3.517637607251473*^9}, {3.517639483331715*^9, 
  3.517639500939227*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"calcCheb", "[", "NR_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{
      RowBox[{"2", "*", "NR"}], "-", "1"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"ChebR", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Cos", "[", 
        FractionBox[
         RowBox[{"\[Pi]", " ", "ii"}], "NN"], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "NN", ",", "0", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"x", "[", "ii_", "]"}], ":=", 
     RowBox[{"ChebR", "[", 
      RowBox[{"[", 
       RowBox[{"ii", "+", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Dmat", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ii", "!=", "jj"}], ",", 
         RowBox[{
          FractionBox[
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"ii", "\[Equal]", "0"}], "||", 
              RowBox[{"ii", "\[Equal]", "NN"}]}], ",", "2", ",", "1"}], "]"}], 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"jj", "\[Equal]", "0"}], "||", 
              RowBox[{"jj", "\[Equal]", "NN"}]}], ",", "2", ",", "1"}], 
            "]"}]], 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"ii", "+", "jj"}], ")"}]}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"x", "[", "ii", "]"}], "-", 
             RowBox[{"x", "[", "jj", "]"}]}], ")"}]]}], ",", "0"}], "]"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "0", ",", "NN"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"jj", ",", "0", ",", "NN"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Dmat", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"ii", "+", "1"}], ",", 
           RowBox[{"ii", "+", "1"}]}], "]"}], "]"}], "=", 
        FractionBox[
         RowBox[{"-", 
          RowBox[{"x", "[", "ii", "]"}]}], 
         RowBox[{"2", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{
             RowBox[{"x", "[", "ii", "]"}], "^", "2"}]}], ")"}]}]]}], ";"}], 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"NN", "-", "1"}]}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Dmat", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"2", 
         SuperscriptBox["NN", "2"]}], "+", "1"}], "6"]}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Dmat", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"NN", "+", "1"}], ",", 
        RowBox[{"NN", "+", "1"}]}], "]"}], "]"}], "=", 
     FractionBox[
      RowBox[{
       RowBox[{"2", 
        SuperscriptBox["NN", "2"]}], "+", "1"}], "6"]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"D2mat", "=", 
     RowBox[{"Dmat", ".", "Dmat"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 CellChangeTimes->{{3.542439326633896*^9, 3.542439372378118*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Check", "Subsubtitle",
 CellChangeTimes->{{3.517556505886075*^9, 3.517556509091404*^9}, {
  3.5176375867460747`*^9, 3.517637607251473*^9}, {3.517639483331715*^9, 
  3.517639500939227*^9}, {3.541867151446308*^9, 3.5418671525252123`*^9}, {
  3.541867301843873*^9, 3.541867302971129*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "y_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"y", "^", "2"}], "]"}], 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "^", "2"}], "-", 
          FractionBox["1", "3"]}], ")"}], "^", "2"}], 
       RowBox[{"Log", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"y", "^", "2"}], "-", 
           FractionBox["1", "3"]}], ")"}], "^", "2"}], "]"}]}]}], ")"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.541867155568058*^9, 3.5418671681920233`*^9}, {
  3.541867351103572*^9, 3.5418673531506643`*^9}, {3.541867425454322*^9, 
  3.541867427870324*^9}, {3.542438055861205*^9, 3.542438056221323*^9}, {
  3.542439302280672*^9, 3.542439303789591*^9}, {3.5424396444684896`*^9, 
  3.542439644724331*^9}, {3.5424397013086987`*^9, 3.54243971893307*^9}, {
  3.542439758892009*^9, 3.5424397901532707`*^9}, {3.542439834016374*^9, 
  3.542439843994628*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "y_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"y", "^", "2"}], "]"}], 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "^", "2"}], "-", 
          FractionBox["4", "3"]}], ")"}], "^", "2"}], 
       RowBox[{"Log", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"y", "^", "2"}], "-", 
           FractionBox["4", "3"]}], ")"}], "^", "2"}], "]"}]}]}], ")"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.541867155568058*^9, 3.5418671681920233`*^9}, {
  3.541867351103572*^9, 3.5418673531506643`*^9}, {3.541867425454322*^9, 
  3.541867427870324*^9}, {3.542438055861205*^9, 3.542438056221323*^9}, {
  3.542439302280672*^9, 3.542439303789591*^9}, {3.5424396444684896`*^9, 
  3.542439644724331*^9}, {3.5424397013086987`*^9, 3.54243971893307*^9}, {
  3.542439758892009*^9, 3.5424397901532707`*^9}, {3.542439834016374*^9, 
  3.542439843994628*^9}, {3.542440123388782*^9, 3.542440124908036*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "y_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"y", "^", "2"}], "]"}], 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"y", "^", "2"}], "-", 
         FractionBox["4", "3"]}], ")"}], "^", "2"}]}], ")"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{3.542440262600729*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "y_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"y", "^", "2"}], "]"}], 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "^", "2"}], "-", 
          FractionBox["4", "3"]}], ")"}], "^", "2"}], "]"}]}], ")"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{3.542440552128457*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dat", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Table", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"calcCheb", "[", "num", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"fdat", "=", 
       RowBox[{"f", "[", "ChebR", "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"val", "=", 
       RowBox[{"Max", "[", 
        RowBox[{"N", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Dmat", ".", "fdat"}], "-", 
           RowBox[{
            RowBox[{"f", "'"}], "[", "ChebR", "]"}]}], ",", "30"}], "]"}], 
        "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"tmp", "=", 
       RowBox[{"{", 
        RowBox[{"num", ",", 
         RowBox[{"Log", "[", 
          RowBox[{"10", ",", "val"}], "]"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", "tmp", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"dat", ",", "tmp"}], "]"}], ";"}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"num", ",", "4", ",", "40", ",", "2"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", "dat"}], "Input",
 CellChangeTimes->{{3.54243939502806*^9, 3.5424393958902397`*^9}, {
  3.5424394270431767`*^9, 3.542439619944044*^9}, {3.542439657957962*^9, 
  3.542439658005857*^9}, {3.5424396882311697`*^9, 3.542439690790414*^9}, {
  3.5424398714484386`*^9, 3.542439883871389*^9}, {3.542440013266395*^9, 
  3.542440054950939*^9}, {3.542440180756946*^9, 3.5424401822210617`*^9}, {
  3.542440252640078*^9, 3.542440252691436*^9}, {3.542440311724319*^9, 
  3.542440325036264*^9}, {3.5424403935529337`*^9, 3.542440393640502*^9}, {
  3.542440435977427*^9, 3.5424404842610073`*^9}, {3.542440582785005*^9, 
  3.542440631638846*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", 
   RowBox[{
   "-", "0.7068479100807699714227370820002874294068449517119237039248`30.\
21154166696845"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.5424394851501427`*^9, 3.542439532397585*^9}, {
   3.5424395665714493`*^9, 3.542439658504505*^9}, 3.542439691281197*^9, {
   3.542439847140839*^9, 3.542439884350123*^9}, {3.542440014501698*^9, 
   3.5424400554759703`*^9}, 3.542440126861392*^9, 3.5424401829093027`*^9, 
   3.5424402643500643`*^9, {3.542440313016077*^9, 3.5424403331908283`*^9}, {
   3.5424403945635138`*^9, 3.542440452217819*^9}, {3.5424404850746307`*^9, 
   3.542440506464432*^9}, {3.5424405541840467`*^9, 3.542440651342806*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", 
   RowBox[{
   "-", "1.5728048318479322487449702507416736806752943484841656075876`30.\
558890523395096"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.5424394851501427`*^9, 3.542439532397585*^9}, {
   3.5424395665714493`*^9, 3.542439658504505*^9}, 3.542439691281197*^9, {
   3.542439847140839*^9, 3.542439884350123*^9}, {3.542440014501698*^9, 
   3.5424400554759703`*^9}, 3.542440126861392*^9, 3.5424401829093027`*^9, 
   3.5424402643500643`*^9, {3.542440313016077*^9, 3.5424403331908283`*^9}, {
   3.5424403945635138`*^9, 3.542440452217819*^9}, {3.5424404850746307`*^9, 
   3.542440506464432*^9}, {3.5424405541840467`*^9, 3.542440651387792*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8", ",", 
   RowBox[{
   "-", "2.8930923787451744324462625289806286354842961439116667904227`30.\
823577989937746"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.5424394851501427`*^9, 3.542439532397585*^9}, {
   3.5424395665714493`*^9, 3.542439658504505*^9}, 3.542439691281197*^9, {
   3.542439847140839*^9, 3.542439884350123*^9}, {3.542440014501698*^9, 
   3.5424400554759703`*^9}, 3.542440126861392*^9, 3.5424401829093027`*^9, 
   3.5424402643500643`*^9, {3.542440313016077*^9, 3.5424403331908283`*^9}, {
   3.5424403945635138`*^9, 3.542440452217819*^9}, {3.5424404850746307`*^9, 
   3.542440506464432*^9}, {3.5424405541840467`*^9, 3.542440651415023*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", 
   RowBox[{
   "-", "4.1178235714111032501473332620035423971392342628201656667855`30.\
976883423986816"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.5424394851501427`*^9, 3.542439532397585*^9}, {
   3.5424395665714493`*^9, 3.542439658504505*^9}, 3.542439691281197*^9, {
   3.542439847140839*^9, 3.542439884350123*^9}, {3.542440014501698*^9, 
   3.5424400554759703`*^9}, 3.542440126861392*^9, 3.5424401829093027`*^9, 
   3.5424402643500643`*^9, {3.542440313016077*^9, 3.5424403331908283`*^9}, {
   3.5424403945635138`*^9, 3.542440452217819*^9}, {3.5424404850746307`*^9, 
   3.542440506464432*^9}, {3.5424405541840467`*^9, 3.542440651458943*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"12", ",", 
   RowBox[{
   "-", "5.2686112837419701338301949854772161029386806691227967966299`31.\
08391184636251"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.5424394851501427`*^9, 3.542439532397585*^9}, {
   3.5424395665714493`*^9, 3.542439658504505*^9}, 3.542439691281197*^9, {
   3.542439847140839*^9, 3.542439884350123*^9}, {3.542440014501698*^9, 
   3.5424400554759703`*^9}, 3.542440126861392*^9, 3.5424401829093027`*^9, 
   3.5424402643500643`*^9, {3.542440313016077*^9, 3.5424403331908283`*^9}, {
   3.5424403945635138`*^9, 3.542440452217819*^9}, {3.5424404850746307`*^9, 
   3.542440506464432*^9}, {3.5424405541840467`*^9, 3.542440651537922*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"14", ",", 
   RowBox[{
   "-", "6.3792278926443575395577216158878668225625146914500856083729`31.\
1669838059385"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.5424394851501427`*^9, 3.542439532397585*^9}, {
   3.5424395665714493`*^9, 3.542439658504505*^9}, 3.542439691281197*^9, {
   3.542439847140839*^9, 3.542439884350123*^9}, {3.542440014501698*^9, 
   3.5424400554759703`*^9}, 3.542440126861392*^9, 3.5424401829093027`*^9, 
   3.5424402643500643`*^9, {3.542440313016077*^9, 3.5424403331908283`*^9}, {
   3.5424403945635138`*^9, 3.542440452217819*^9}, {3.5424404850746307`*^9, 
   3.542440506464432*^9}, {3.5424405541840467`*^9, 3.542440651644362*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"16", ",", 
   RowBox[{
   "-", "7.4642793024684574188204449456755870292895785898051989966966`31.\
23520357040941"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.5424394851501427`*^9, 3.542439532397585*^9}, {
   3.5424395665714493`*^9, 3.542439658504505*^9}, 3.542439691281197*^9, {
   3.542439847140839*^9, 3.542439884350123*^9}, {3.542440014501698*^9, 
   3.5424400554759703`*^9}, 3.542440126861392*^9, 3.5424401829093027`*^9, 
   3.5424402643500643`*^9, {3.542440313016077*^9, 3.5424403331908283`*^9}, {
   3.5424403945635138`*^9, 3.542440452217819*^9}, {3.5424404850746307`*^9, 
   3.542440506464432*^9}, {3.5424405541840467`*^9, 3.542440651787861*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"18", ",", 
   RowBox[{
   "-", "8.5313091249446878969966120792762381992881437532584884064396`31.\
293231367242818"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.5424394851501427`*^9, 3.542439532397585*^9}, {
   3.5424395665714493`*^9, 3.542439658504505*^9}, 3.542439691281197*^9, {
   3.542439847140839*^9, 3.542439884350123*^9}, {3.542440014501698*^9, 
   3.5424400554759703`*^9}, 3.542440126861392*^9, 3.5424401829093027`*^9, 
   3.5424402643500643`*^9, {3.542440313016077*^9, 3.5424403331908283`*^9}, {
   3.5424403945635138`*^9, 3.542440452217819*^9}, {3.5424404850746307`*^9, 
   3.542440506464432*^9}, {3.5424405541840467`*^9, 3.542440651974728*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"20", ",", 
   RowBox[{
   "-", "9.5848470892617032342607374988340780155139929256786086611044`31.\
34380087750253"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.5424394851501427`*^9, 3.542439532397585*^9}, {
   3.5424395665714493`*^9, 3.542439658504505*^9}, 3.542439691281197*^9, {
   3.542439847140839*^9, 3.542439884350123*^9}, {3.542440014501698*^9, 
   3.5424400554759703`*^9}, 3.542440126861392*^9, 3.5424401829093027`*^9, 
   3.5424402643500643`*^9, {3.542440313016077*^9, 3.5424403331908283`*^9}, {
   3.5424403945635138`*^9, 3.542440452217819*^9}, {3.5424404850746307`*^9, 
   3.542440506464432*^9}, {3.5424405541840467`*^9, 3.542440652213603*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"22", ",", 
   RowBox[{
   "-", "10.6278635828018591894174725629393003713493016993183497247627`31.\
38866165995365"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.5424394851501427`*^9, 3.542439532397585*^9}, {
   3.5424395665714493`*^9, 3.542439658504505*^9}, 3.542439691281197*^9, {
   3.542439847140839*^9, 3.542439884350123*^9}, {3.542440014501698*^9, 
   3.5424400554759703`*^9}, 3.542440126861392*^9, 3.5424401829093027`*^9, 
   3.5424402643500643`*^9, {3.542440313016077*^9, 3.5424403331908283`*^9}, {
   3.5424403945635138`*^9, 3.542440452217819*^9}, {3.5424404850746307`*^9, 
   3.542440506464432*^9}, {3.5424405541840467`*^9, 3.542440652524823*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"24", ",", 
   RowBox[{
   "-", "11.6624251694763945765294867985664246335780858374923034622658`31.\
42900455886558"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.5424394851501427`*^9, 3.542439532397585*^9}, {
   3.5424395665714493`*^9, 3.542439658504505*^9}, 3.542439691281197*^9, {
   3.542439847140839*^9, 3.542439884350123*^9}, {3.542440014501698*^9, 
   3.5424400554759703`*^9}, 3.542440126861392*^9, 3.5424401829093027`*^9, 
   3.5424402643500643`*^9, {3.542440313016077*^9, 3.5424403331908283`*^9}, {
   3.5424403945635138`*^9, 3.542440452217819*^9}, {3.5424404850746307`*^9, 
   3.542440506464432*^9}, {3.5424405541840467`*^9, 3.542440652906178*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"26", ",", 
   RowBox[{
   "-", "12.6900333340743195785558964550158495398565529686923196941337`31.\
46567845159682"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.5424394851501427`*^9, 3.542439532397585*^9}, {
   3.5424395665714493`*^9, 3.542439658504505*^9}, 3.542439691281197*^9, {
   3.542439847140839*^9, 3.542439884350123*^9}, {3.542440014501698*^9, 
   3.5424400554759703`*^9}, 3.542440126861392*^9, 3.5424401829093027`*^9, 
   3.5424402643500643`*^9, {3.542440313016077*^9, 3.5424403331908283`*^9}, {
   3.5424403945635138`*^9, 3.542440452217819*^9}, {3.5424404850746307`*^9, 
   3.542440506464432*^9}, {3.5424405541840467`*^9, 3.542440653367146*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"28", ",", 
   RowBox[{
   "-", "13.7118161316191545538246082274089778157201115924088655253405`31.\
499310669652665"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.5424394851501427`*^9, 3.542439532397585*^9}, {
   3.5424395665714493`*^9, 3.542439658504505*^9}, 3.542439691281197*^9, {
   3.542439847140839*^9, 3.542439884350123*^9}, {3.542440014501698*^9, 
   3.5424400554759703`*^9}, 3.542440126861392*^9, 3.5424401829093027`*^9, 
   3.5424402643500643`*^9, {3.542440313016077*^9, 3.5424403331908283`*^9}, {
   3.5424403945635138`*^9, 3.542440452217819*^9}, {3.5424404850746307`*^9, 
   3.542440506464432*^9}, {3.5424405541840467`*^9, 3.5424406539339857`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"30", ",", 
   RowBox[{
   "-", "14.7286440431025180446096561325045318780369196972550896657009`31.\
530378455114096"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.5424394851501427`*^9, 3.542439532397585*^9}, {
   3.5424395665714493`*^9, 3.542439658504505*^9}, 3.542439691281197*^9, {
   3.542439847140839*^9, 3.542439884350123*^9}, {3.542440014501698*^9, 
   3.5424400554759703`*^9}, 3.542440126861392*^9, 3.5424401829093027`*^9, 
   3.5424402643500643`*^9, {3.542440313016077*^9, 3.5424403331908283`*^9}, {
   3.5424403945635138`*^9, 3.542440452217819*^9}, {3.5424404850746307`*^9, 
   3.542440506464432*^9}, {3.5424405541840467`*^9, 3.542440654603889*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"32", ",", 
   RowBox[{
   "-", "15.7412036937875768606322406483137350721138766768274570122747`31.\
559253627496478"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.5424394851501427`*^9, 3.542439532397585*^9}, {
   3.5424395665714493`*^9, 3.542439658504505*^9}, 3.542439691281197*^9, {
   3.542439847140839*^9, 3.542439884350123*^9}, {3.542440014501698*^9, 
   3.5424400554759703`*^9}, 3.542440126861392*^9, 3.5424401829093027`*^9, 
   3.5424402643500643`*^9, {3.542440313016077*^9, 3.5424403331908283`*^9}, {
   3.5424403945635138`*^9, 3.542440452217819*^9}, {3.5424404850746307`*^9, 
   3.542440506464432*^9}, {3.5424405541840467`*^9, 3.54244065539048*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"34", ",", 
   RowBox[{
   "-", "16.7500467262530780371116118310448117109745035957267907927259`31.\
586231711590273"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.5424394851501427`*^9, 3.542439532397585*^9}, {
   3.5424395665714493`*^9, 3.542439658504505*^9}, 3.542439691281197*^9, {
   3.542439847140839*^9, 3.542439884350123*^9}, {3.542440014501698*^9, 
   3.5424400554759703`*^9}, 3.542440126861392*^9, 3.5424401829093027`*^9, 
   3.5424402643500643`*^9, {3.542440313016077*^9, 3.5424403331908283`*^9}, {
   3.5424403945635138`*^9, 3.542440452217819*^9}, {3.5424404850746307`*^9, 
   3.542440506464432*^9}, {3.5424405541840467`*^9, 3.5424406563281307`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"36", ",", 
   RowBox[{
   "-", "17.7556233156371487216838365381651827483566301656954773788622`31.\
61155161162209"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.5424394851501427`*^9, 3.542439532397585*^9}, {
   3.5424395665714493`*^9, 3.542439658504505*^9}, 3.542439691281197*^9, {
   3.542439847140839*^9, 3.542439884350123*^9}, {3.542440014501698*^9, 
   3.5424400554759703`*^9}, 3.542440126861392*^9, 3.5424401829093027`*^9, 
   3.5424402643500643`*^9, {3.542440313016077*^9, 3.5424403331908283`*^9}, {
   3.5424403945635138`*^9, 3.542440452217819*^9}, {3.5424404850746307`*^9, 
   3.542440506464432*^9}, {3.5424405541840467`*^9, 3.542440657420624*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"38", ",", 
   RowBox[{
   "-", "18.758305814711571988636376165699345106350232100052790894145`31.\
635409300538488"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.5424394851501427`*^9, 3.542439532397585*^9}, {
   3.5424395665714493`*^9, 3.542439658504505*^9}, 3.542439691281197*^9, {
   3.542439847140839*^9, 3.542439884350123*^9}, {3.542440014501698*^9, 
   3.5424400554759703`*^9}, 3.542440126861392*^9, 3.5424401829093027`*^9, 
   3.5424402643500643`*^9, {3.542440313016077*^9, 3.5424403331908283`*^9}, {
   3.5424403945635138`*^9, 3.542440452217819*^9}, {3.5424404850746307`*^9, 
   3.542440506464432*^9}, {3.5424405541840467`*^9, 3.5424406586920424`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"40", ",", 
   RowBox[{
   "-", "19.7584058443833900635191480134871766125544231164175813652689`31.\
657967590443157"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.5424394851501427`*^9, 3.542439532397585*^9}, {
   3.5424395665714493`*^9, 3.542439658504505*^9}, 3.542439691281197*^9, {
   3.542439847140839*^9, 3.542439884350123*^9}, {3.542440014501698*^9, 
   3.5424400554759703`*^9}, 3.542440126861392*^9, 3.5424401829093027`*^9, 
   3.5424402643500643`*^9, {3.542440313016077*^9, 3.5424403331908283`*^9}, {
   3.5424403945635138`*^9, 3.542440452217819*^9}, {3.5424404850746307`*^9, 
   3.542440506464432*^9}, {3.5424405541840467`*^9, 3.542440660163188*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{
     "-", "0.7068479100807699714227370820002874294068449517119237039248`30.\
21154166696845"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", 
     RowBox[{
     "-", "1.5728048318479322487449702507416736806752943484841656075876`30.\
558890523395096"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", 
     RowBox[{
     "-", "2.8930923787451744324462625289806286354842961439116667904227`30.\
823577989937746"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", 
     RowBox[{
     "-", "4.1178235714111032501473332620035423971392342628201656667855`30.\
976883423986816"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", 
     RowBox[{
     "-", "5.2686112837419701338301949854772161029386806691227967966299`31.\
08391184636251"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", 
     RowBox[{
     "-", "6.3792278926443575395577216158878668225625146914500856083729`31.\
1669838059385"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", 
     RowBox[{
     "-", "7.4642793024684574188204449456755870292895785898051989966966`31.\
23520357040941"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", 
     RowBox[{
     "-", "8.5313091249446878969966120792762381992881437532584884064396`31.\
293231367242818"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", 
     RowBox[{
     "-", "9.5848470892617032342607374988340780155139929256786086611044`31.\
34380087750253"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", 
     RowBox[{
     "-", "10.6278635828018591894174725629393003713493016993183497247627`31.\
38866165995365"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", 
     RowBox[{
     "-", "11.6624251694763945765294867985664246335780858374923034622658`31.\
42900455886558"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", 
     RowBox[{
     "-", "12.6900333340743195785558964550158495398565529686923196941337`31.\
46567845159682"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", 
     RowBox[{
     "-", "13.7118161316191545538246082274089778157201115924088655253405`31.\
499310669652665"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30", ",", 
     RowBox[{
     "-", "14.7286440431025180446096561325045318780369196972550896657009`31.\
530378455114096"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", 
     RowBox[{
     "-", "15.7412036937875768606322406483137350721138766768274570122747`31.\
559253627496478"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"34", ",", 
     RowBox[{
     "-", "16.7500467262530780371116118310448117109745035957267907927259`31.\
586231711590273"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"36", ",", 
     RowBox[{
     "-", "17.7556233156371487216838365381651827483566301656954773788622`31.\
61155161162209"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"38", ",", 
     RowBox[{
     "-", "18.758305814711571988636376165699345106350232100052790894145`31.\
635409300538488"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", 
     RowBox[{
     "-", "19.7584058443833900635191480134871766125544231164175813652689`31.\
657967590443157"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.542439467031706*^9, 3.542439532990829*^9}, {
   3.54243956720413*^9, 3.542439661468419*^9}, 3.542439692125061*^9, {
   3.542439848172826*^9, 3.542439897155281*^9}, {3.542440027209516*^9, 
   3.5424400693034554`*^9}, 3.542440140621011*^9, 3.5424402365779133`*^9, {
   3.542440290869213*^9, 3.542440316935504*^9}, {3.5424403761869793`*^9, 
   3.542440508236067*^9}, {3.542440555864685*^9, 3.542440660166201*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "dat", "]"}]], "Input",
 CellChangeTimes->{{3.542439537693778*^9, 3.542439539905177*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQDQECDsLxik31857th/AlHOwLbdJMtX5C+QoOk5V/
zOVVZT8A4as4ZC1i37esQgDK13Do4pC5xicsCuXrOFzvFQoMaZGE8g0cjO0n
cuTcloXyjRyiMp7vZxdQhPJNHJJEHgsXaitD+WYOtd+fhJY7qkL5Fg4Tn/qm
aAarQ/lWDs3/p/L4JGpC+TYO05T/aBbnaEP5dg73Jf9fESjVhfIdHN7+/sBT
X60P5Ts6TN31np/5gAGU7+Sw+eCU9oKDhlC+s0N7b1GIwiEjKN/F4cKOVY/U
DhkfAAC2sFF/
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 40.}, {-19.75840584438339, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.5424395407524967`*^9, 3.5424396620048103`*^9}, 
   3.542439693082519*^9, {3.5424398491910763`*^9, 3.54243989810741*^9}, {
   3.5424400281474323`*^9, 3.542440069393412*^9}, 3.5424401414859324`*^9, 
   3.542440236701893*^9, 3.54244029221804*^9, 3.542440376284565*^9, {
   3.542440407981001*^9, 3.542440431126359*^9}, {3.542440462704761*^9, 
   3.5424405091632423`*^9}, 3.542440556941846*^9, {3.5424405875692787`*^9, 
   3.5424406611980953`*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1507, 862},
WindowMargins->{{5, Automatic}, {Automatic, 10}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 331, 6, 27, "Input"],
Cell[CellGroupData[{
Cell[913, 30, 232, 3, 26, "Subsubtitle"],
Cell[1148, 35, 3657, 106, 520, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[4842, 146, 291, 4, 26, "Subsubtitle"],
Cell[5136, 152, 1046, 28, 47, "Input"],
Cell[6185, 182, 1092, 28, 47, "Input"],
Cell[7280, 212, 413, 15, 47, "Input"],
Cell[7696, 229, 452, 16, 47, "Input"],
Cell[CellGroupData[{
Cell[8173, 249, 2067, 47, 298, "Input"],
Cell[CellGroupData[{
Cell[10265, 300, 692, 12, 20, "Print"],
Cell[10960, 314, 693, 12, 20, "Print"],
Cell[11656, 328, 693, 12, 20, "Print"],
Cell[12352, 342, 694, 12, 20, "Print"],
Cell[13049, 356, 693, 12, 20, "Print"],
Cell[13745, 370, 692, 12, 20, "Print"],
Cell[14440, 384, 693, 12, 20, "Print"],
Cell[15136, 398, 694, 12, 20, "Print"],
Cell[15833, 412, 693, 12, 20, "Print"],
Cell[16529, 426, 694, 12, 20, "Print"],
Cell[17226, 440, 694, 12, 20, "Print"],
Cell[17923, 454, 694, 12, 20, "Print"],
Cell[18620, 468, 697, 12, 20, "Print"],
Cell[19320, 482, 695, 12, 20, "Print"],
Cell[20018, 496, 694, 12, 20, "Print"],
Cell[20715, 510, 697, 12, 20, "Print"],
Cell[21415, 524, 694, 12, 20, "Print"],
Cell[22112, 538, 696, 12, 20, "Print"],
Cell[22811, 552, 695, 12, 20, "Print"]
}, Open  ]],
Cell[23521, 567, 3655, 103, 88, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27213, 675, 129, 2, 27, "Input"],
Cell[27345, 679, 1133, 24, 235, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
