(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     32798,        907]
NotebookOptionsPosition[     30363,        820]
NotebookOutlinePosition[     30718,        836]
CellTagsIndexPosition[     30675,        833]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"NR", "=", "4"}], ";"}]], "Input",
 CellChangeTimes->{{3.54186620903804*^9, 3.541866210724594*^9}, {
   3.541867418021255*^9, 3.54186744037554*^9}, {3.5418678927528563`*^9, 
   3.541867913770398*^9}, 3.541869036942782*^9, 3.5418708395050383`*^9}],

Cell[CellGroupData[{

Cell["Coordinates & Differentiation - precomputed", "Subsubtitle",
 CellChangeTimes->{{3.517556505886075*^9, 3.517556509091404*^9}, {
  3.5176375867460747`*^9, 3.517637607251473*^9}, {3.517639483331715*^9, 
  3.517639500939227*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NN", "=", 
   RowBox[{
    RowBox[{"2", "*", "NR"}], "-", "1"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.51763841954007*^9, 3.517638421220167*^9}, {
  3.541867909490724*^9, 3.541867909737905*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ChebR", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Cos", "[", 
       FractionBox[
        RowBox[{"\[Pi]", " ", "ii"}], "NN"], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "NN", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", "ChebR", "]"}]}], "Input",
 CellChangeTimes->{{3.5175504275379143`*^9, 3.517550473868642*^9}, {
   3.5175505088539352`*^9, 3.51755057150263*^9}, {3.5175531815270977`*^9, 
   3.517553182781066*^9}, {3.5175532841430807`*^9, 3.517553285717567*^9}, {
   3.5175533447190742`*^9, 3.517553345933249*^9}, {3.517553478839162*^9, 
   3.5175534801413918`*^9}, {3.517553697086974*^9, 3.5175537300535307`*^9}, {
   3.517636043667302*^9, 3.517636082342285*^9}, {3.517636156121964*^9, 
   3.517636163909718*^9}, 3.517636245951754*^9, {3.517637708503521*^9, 
   3.517637710805746*^9}, {3.5176384245898523`*^9, 3.5176384266140013`*^9}, {
   3.517639920088458*^9, 3.517639921413632*^9}, {3.517639981975692*^9, 
   3.517640027901559*^9}, {3.541866466359578*^9, 3.541866474631075*^9}, {
   3.541867064951294*^9, 3.54186708120842*^9}, {3.541867294404078*^9, 
   3.541867297420402*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.`"}], ",", 
   RowBox[{"-", "0.9009688679024191`"}], ",", 
   RowBox[{"-", "0.6234898018587335`"}], ",", 
   RowBox[{"-", "0.2225209339563144`"}], ",", "0.2225209339563144`", ",", 
   "0.6234898018587335`", ",", "0.9009688679024191`", ",", "1.`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.517640028276527*^9, 3.5176400307574472`*^9}, 
   3.5176401192797947`*^9, 3.517640187400107*^9, 3.5176403286587887`*^9, 
   3.51764054665143*^9, 3.5176405877817802`*^9, {3.517640651778982*^9, 
   3.5176406971378527`*^9}, {3.517640900375371*^9, 3.517640914846417*^9}, {
   3.5176409484999027`*^9, 3.4603934316299887`*^9}, 3.4603934620571413`*^9, 
   3.46039482839856*^9, {3.4603959236531153`*^9, 3.4603541273622*^9}, 
   3.460355606391925*^9, {3.460367932321252*^9, 3.460367945459139*^9}, 
   3.460396180756915*^9, 3.460439831890929*^9, 3.4604531632344923`*^9, 
   3.460453544514656*^9, {3.4604560202941093`*^9, 3.460456043888818*^9}, 
   3.460460227643118*^9, 3.46046038187729*^9, 3.4604719384546957`*^9, 
   3.460472301309268*^9, 3.4604755273342113`*^9, 3.460478447533989*^9, 
   3.460478526543737*^9, 3.460478873323823*^9, 3.460484028240882*^9, 
   3.460484059977518*^9, 3.460484113541607*^9, 3.4604845025668097`*^9, 
   3.460484637836646*^9, 3.460484745433052*^9, 3.4604849169178057`*^9, {
   3.460715149005042*^9, 3.4607151699749002`*^9}, 3.460715256955172*^9, 
   3.460715458533717*^9, 3.460716810853174*^9, {3.460718833272346*^9, 
   3.460718862160503*^9}, {3.460731479852737*^9, 3.460731536591123*^9}, 
   3.460731597465933*^9, {3.4607316975834703`*^9, 3.460393906745388*^9}, {
   3.460394069276783*^9, 3.4603384430378428`*^9}, 3.460338491846697*^9, 
   3.4603402907480507`*^9, 3.460340366294363*^9, 3.460340467475129*^9, 
   3.460352940974895*^9, 3.460353029735114*^9, 3.51895631918708*^9, 
   3.518956712523686*^9, 3.519020027793808*^9, 3.519021391497527*^9, 
   3.5190226052121983`*^9, 3.519025557684658*^9, 3.519032027695396*^9, 
   3.519036344158661*^9, 3.5190367081589527`*^9, 3.519037574162319*^9, 
   3.51903934818014*^9, 3.5191035518500757`*^9, 3.519103605153915*^9, 
   3.5191045359008713`*^9, 3.519105646498334*^9, 3.5191062882302017`*^9, 
   3.519114895485839*^9, 3.539245039974567*^9, 3.539289226094124*^9, 
   3.5392894586001577`*^9, 3.539337478349811*^9, {3.539378711449586*^9, 
   3.539378720733491*^9}, 3.5393787828777523`*^9, 3.539379407431119*^9, {
   3.539379779566827*^9, 3.539379791040307*^9}, {3.5393947112938957`*^9, 
   3.539394721485684*^9}, {3.539394881921783*^9, 3.539394904071868*^9}, {
   3.539613413403973*^9, 3.539613420833047*^9}, {3.539625320509782*^9, 
   3.53962534614544*^9}, 3.5396261634623413`*^9, {3.5396496480165*^9, 
   3.539649667334529*^9}, 3.539972213379868*^9, {3.5407346098597813`*^9, 
   3.540734625085709*^9}, 3.540734788554344*^9, 3.54073506626033*^9, 
   3.5407353233160343`*^9, 3.540735543949161*^9, 3.540735681231738*^9, 
   3.54073574218594*^9, 3.5407359147213383`*^9, 3.540735959686926*^9, {
   3.5407359950249233`*^9, 3.5407360473153477`*^9}, 3.540736239157056*^9, {
   3.540736274473997*^9, 3.540736303081781*^9}, 3.540736358623269*^9, 
   3.540736718946526*^9, 3.540736795074223*^9, 3.5407368394776163`*^9, 
   3.540745828204028*^9, {3.540745861936976*^9, 3.540745903032221*^9}, {
   3.540746001867158*^9, 3.540746039975122*^9}, {3.5407460908901978`*^9, 
   3.540746113734376*^9}, 3.541314843963317*^9, 3.5413149873599443`*^9, 
   3.541315341483013*^9, 3.541315792911289*^9, 3.541317806230768*^9, 
   3.5413178717741547`*^9, 3.541317967707746*^9, 3.541318196139876*^9, 
   3.541318345113411*^9, 3.54131846429566*^9, 3.5413185558751163`*^9, 
   3.5414804660950413`*^9, 3.541500626438019*^9, 3.541507802060275*^9, 
   3.541752699274287*^9, 3.54186648491119*^9, 3.5418670393088617`*^9, {
   3.541867069403451*^9, 3.541867081722392*^9}, {3.541867298326605*^9, 
   3.541867319542163*^9}, {3.541867419811458*^9, 3.541867441374737*^9}, 
   3.541867916401897*^9, 3.541867949732029*^9, 3.5418690378665237`*^9, 
   3.541869797318714*^9, {3.541870844951251*^9, 3.5418708615909777`*^9}, 
   3.5419096401686277`*^9, 3.542438054426462*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "[", "ii_", "]"}], ":=", 
  RowBox[{"ChebR", "[", 
   RowBox[{"[", 
    RowBox[{"ii", "+", "1"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.517637784093897*^9, 3.517637792704556*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Dmat", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ii", "!=", "jj"}], ",", 
       RowBox[{
        FractionBox[
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"ii", "\[Equal]", "0"}], "||", 
            RowBox[{"ii", "\[Equal]", "NN"}]}], ",", "2", ",", "1"}], "]"}], 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"jj", "\[Equal]", "0"}], "||", 
            RowBox[{"jj", "\[Equal]", "NN"}]}], ",", "2", ",", "1"}], "]"}]], 
        
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"ii", "+", "jj"}], ")"}]}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"x", "[", "ii", "]"}], "-", 
           RowBox[{"x", "[", "jj", "]"}]}], ")"}]]}], ",", "0"}], "]"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"ii", ",", "0", ",", "NN"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"jj", ",", "0", ",", "NN"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.541866721493359*^9, 3.541866806954913*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Dmat", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"ii", "+", "1"}], ",", 
         RowBox[{"ii", "+", "1"}]}], "]"}], "]"}], "=", 
      FractionBox[
       RowBox[{"-", 
        RowBox[{"x", "[", "ii", "]"}]}], 
       RowBox[{"2", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{
           RowBox[{"x", "[", "ii", "]"}], "^", "2"}]}], ")"}]}]]}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", 
      RowBox[{"NN", "-", "1"}]}], "}"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.54186687311628*^9, 3.54186695872265*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Dmat", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"2", 
        SuperscriptBox["NN", "2"]}], "+", "1"}], "6"]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Dmat", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"NN", "+", "1"}], ",", 
      RowBox[{"NN", "+", "1"}]}], "]"}], "]"}], "=", 
   FractionBox[
    RowBox[{
     RowBox[{"2", 
      SuperscriptBox["NN", "2"]}], "+", "1"}], "6"]}], ";"}]}], "Input",
 CellChangeTimes->{{3.541866943692552*^9, 3.5418670183740387`*^9}, {
  3.542438069295436*^9, 3.542438071438416*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"N", "[", "Dmat", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.541870854329073*^9, 3.541870870169176*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "16.5`"}], "20.195669358089226`", 
      RowBox[{"-", "5.311941110422726`"}], "2.572416528431162`", 
      RowBox[{"-", "1.6359638059755859`"}], "1.2319141134796165`", 
      RowBox[{"-", "1.0520950836016871`"}], "0.5`"},
     {
      RowBox[{"-", "5.048917339522307`"}], "2.392946784310942`", 
      "3.6038754716096757`", 
      RowBox[{"-", "1.4739524581991565`"}], "0.8900837358252576`", 
      RowBox[{"-", "0.6559705552113635`"}], "0.5549581320873712`", 
      RowBox[{"-", "0.2630237709004218`"}]},
     {"1.3279852776056815`", 
      RowBox[{"-", "3.6038754716096757`"}], "0.5100033746178887`", 
      "2.4939592074349344`", 
      RowBox[{"-", "1.182018097012207`"}], "0.8019377358048383`", 
      RowBox[{"-", "0.6559705552113635`"}], "0.30797852836990414`"},
     {
      RowBox[{"-", "0.6431041321077905`"}], "1.4739524581991565`", 
      RowBox[{"-", "2.4939592074349344`"}], "0.11705659030694704`", 
      "2.246979603717467`", 
      RowBox[{"-", "1.182018097012207`"}], "0.8900837358252576`", 
      RowBox[{"-", "0.40899095149389647`"}]},
     {"0.40899095149389647`", 
      RowBox[{"-", "0.8900837358252576`"}], "1.182018097012207`", 
      RowBox[{"-", "2.246979603717467`"}], 
      RowBox[{"-", "0.11705659030694704`"}], "2.4939592074349344`", 
      RowBox[{"-", "1.4739524581991565`"}], "0.6431041321077905`"},
     {
      RowBox[{"-", "0.30797852836990414`"}], "0.6559705552113635`", 
      RowBox[{"-", "0.8019377358048383`"}], "1.182018097012207`", 
      RowBox[{"-", "2.4939592074349344`"}], 
      RowBox[{"-", "0.5100033746178887`"}], "3.6038754716096757`", 
      RowBox[{"-", "1.3279852776056815`"}]},
     {"0.2630237709004218`", 
      RowBox[{"-", "0.5549581320873712`"}], "0.6559705552113635`", 
      RowBox[{"-", "0.8900837358252576`"}], "1.4739524581991565`", 
      RowBox[{"-", "3.6038754716096757`"}], 
      RowBox[{"-", "2.392946784310942`"}], "5.048917339522307`"},
     {
      RowBox[{"-", "0.5`"}], "1.0520950836016871`", 
      RowBox[{"-", "1.2319141134796165`"}], "1.6359638059755859`", 
      RowBox[{"-", "2.572416528431162`"}], "5.311941110422726`", 
      RowBox[{"-", "20.195669358089226`"}], "16.5`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.541870861857564*^9, 3.541870870609165*^9}, 
   3.5419096404866047`*^9, {3.542438054594273*^9, 3.542438072975333*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"D2mat", "=", 
   RowBox[{"Dmat", ".", "Dmat"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.541909625994932*^9, 3.5419096502069807`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Check", "Subsubtitle",
 CellChangeTimes->{{3.517556505886075*^9, 3.517556509091404*^9}, {
  3.5176375867460747`*^9, 3.517637607251473*^9}, {3.517639483331715*^9, 
  3.517639500939227*^9}, {3.541867151446308*^9, 3.5418671525252123`*^9}, {
  3.541867301843873*^9, 3.541867302971129*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "y_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"y", "^", "2"}]}], ")"}], "^", "2"}], "+", "y"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.541867155568058*^9, 3.5418671681920233`*^9}, {
  3.541867351103572*^9, 3.5418673531506643`*^9}, {3.541867425454322*^9, 
  3.541867427870324*^9}, {3.542438055861205*^9, 3.542438056221323*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fdat", "=", 
  RowBox[{"f", "[", "ChebR", "]"}]}]], "Input",
 CellChangeTimes->{{3.541867174224258*^9, 3.541867241099173*^9}, {
  3.5418673627207317`*^9, 3.541867394323229*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Cos", "[", 
      FractionBox["\[Pi]", "7"], "]"}]}], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox[
        RowBox[{"Cos", "[", 
         FractionBox["\[Pi]", "7"], "]"}], "2"]}], ")"}], "2"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Sin", "[", 
      FractionBox[
       RowBox[{"3", " ", "\[Pi]"}], "14"], "]"}]}], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         FractionBox[
          RowBox[{"3", " ", "\[Pi]"}], "14"], "]"}], "2"]}], ")"}], "2"]}], 
   ",", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Sin", "[", 
      FractionBox["\[Pi]", "14"], "]"}]}], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         FractionBox["\[Pi]", "14"], "]"}], "2"]}], ")"}], "2"]}], ",", 
   RowBox[{
    RowBox[{"Sin", "[", 
     FractionBox["\[Pi]", "14"], "]"}], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         FractionBox["\[Pi]", "14"], "]"}], "2"]}], ")"}], "2"]}], ",", 
   RowBox[{
    RowBox[{"Sin", "[", 
     FractionBox[
      RowBox[{"3", " ", "\[Pi]"}], "14"], "]"}], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         FractionBox[
          RowBox[{"3", " ", "\[Pi]"}], "14"], "]"}], "2"]}], ")"}], "2"]}], 
   ",", 
   RowBox[{
    RowBox[{"Cos", "[", 
     FractionBox["\[Pi]", "7"], "]"}], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox[
        RowBox[{"Cos", "[", 
         FractionBox["\[Pi]", "7"], "]"}], "2"]}], ")"}], "2"]}], ",", "1"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5418672350552263`*^9, 3.54186724219002*^9}, {
   3.541867304904125*^9, 3.541867322190239*^9}, 3.5418673548425407`*^9, {
   3.541867385450185*^9, 3.541867441540947*^9}, 3.5418679166640882`*^9, 
   3.541867949956738*^9, 3.541869038067895*^9, 3.54186979760312*^9, 
   3.5418708451546803`*^9, 3.5418715071692333`*^9, 3.54190965385332*^9, {
   3.5424380581455193`*^9, 3.5424380781499853`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"Dmat", ".", "fdat"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"f", "'"}], "[", "ChebR", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5418672437138233`*^9, 3.541867272878737*^9}, {
  3.541867406134797*^9, 3.541867408094153*^9}, {3.5419096649368258`*^9, 
  3.5419096670400047`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.9999999999999949`", ",", "1.6784479339461058`", ",", 
   "2.524458669761153`", ",", "1.8460107358150473`", ",", 
   "0.15398926418495223`", ",", 
   RowBox[{"-", "0.5244586697611529`"}], ",", "0.3215520660538962`", ",", 
   "0.9999999999999942`"}], "}"}]], "Output",
 CellChangeTimes->{{3.541867265154687*^9, 3.54186727332436*^9}, 
   3.541867343167253*^9, {3.541867411392692*^9, 3.5418674415824623`*^9}, 
   3.5418679167062893`*^9, 3.541867949988481*^9, 3.541869038126253*^9, 
   3.541869797641121*^9, 3.541870845212141*^9, 3.541871507201551*^9, {
   3.5419096546222887`*^9, 3.541909667601655*^9}, {3.5424380601646023`*^9, 
   3.542438078693763*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.`", ",", "1.6784479339461047`", ",", "2.5244586697611524`", ",", 
   "1.8460107358150477`", ",", "0.15398926418495218`", ",", 
   RowBox[{"-", "0.5244586697611526`"}], ",", "0.3215520660538954`", ",", 
   "1.`"}], "}"}]], "Output",
 CellChangeTimes->{{3.541867265154687*^9, 3.54186727332436*^9}, 
   3.541867343167253*^9, {3.541867411392692*^9, 3.5418674415824623`*^9}, 
   3.5418679167062893`*^9, 3.541867949988481*^9, 3.541869038126253*^9, 
   3.541869797641121*^9, 3.541870845212141*^9, 3.541871507201551*^9, {
   3.5419096546222887`*^9, 3.541909667601655*^9}, {3.5424380601646023`*^9, 
   3.542438078695788*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"D2mat", ".", "fdat"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"f", "''"}], "[", "ChebR", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.541909673841563*^9, 3.541909675013225*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "8.000000000000114`", ",", "5.740938811152404`", ",", "0.6648743962620918`",
    ",", 
   RowBox[{"-", "3.4058132074145107`"}], ",", 
   RowBox[{"-", "3.4058132074145258`"}], ",", "0.6648743962621264`", ",", 
   "5.740938811152404`", ",", "7.999999999999886`"}], "}"}]], "Output",
 CellChangeTimes->{3.541909675481307*^9, 3.542438080614483*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8.`", ",", "5.740938811152402`", ",", "0.6648743962621126`", ",", 
   RowBox[{"-", "3.4058132074145147`"}], ",", 
   RowBox[{"-", "3.4058132074145147`"}], ",", "0.6648743962621126`", ",", 
   "5.740938811152402`", ",", "8.`"}], "}"}]], "Output",
 CellChangeTimes->{3.541909675481307*^9, 3.542438080616434*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Coordinates & Differentiation - precomputed", "Subsubtitle",
 CellChangeTimes->{{3.517556505886075*^9, 3.517556509091404*^9}, {
  3.5176375867460747`*^9, 3.517637607251473*^9}, {3.517639483331715*^9, 
  3.517639500939227*^9}}],

Cell[CellGroupData[{

Cell[BoxData["ChebR"], "Input",
 CellChangeTimes->{{3.541867942275467*^9, 3.5418679430693607`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", 
    RowBox[{"Cos", "[", 
     FractionBox["\[Pi]", "7"], "]"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"Sin", "[", 
     FractionBox[
      RowBox[{"3", " ", "\[Pi]"}], "14"], "]"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"Sin", "[", 
     FractionBox["\[Pi]", "14"], "]"}]}], ",", 
   RowBox[{"Sin", "[", 
    FractionBox["\[Pi]", "14"], "]"}], ",", 
   RowBox[{"Sin", "[", 
    FractionBox[
     RowBox[{"3", " ", "\[Pi]"}], "14"], "]"}], ",", 
   RowBox[{"Cos", "[", 
    FractionBox["\[Pi]", "7"], "]"}], ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{{3.541867943519191*^9, 3.541867969422625*^9}, 
   3.541868296344208*^9, 3.541868887458722*^9, 3.5418689629265823`*^9, 
   3.541869038160481*^9, 3.541869797692322*^9, 3.541870845358844*^9, 
   3.54187151316094*^9, 3.54190968378605*^9, 3.5424380847033033`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChebR2", "=", 
  RowBox[{"ChebR", "[", 
   RowBox[{"[", 
    RowBox[{
     RowBox[{"NR", "+", "1"}], ";;", 
     RowBox[{"2", "NR"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.541867939661672*^9, {3.541868244069571*^9, 3.541868285821741*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sin", "[", 
    FractionBox["\[Pi]", "14"], "]"}], ",", 
   RowBox[{"Sin", "[", 
    FractionBox[
     RowBox[{"3", " ", "\[Pi]"}], "14"], "]"}], ",", 
   RowBox[{"Cos", "[", 
    FractionBox["\[Pi]", "7"], "]"}], ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{{3.541868275635933*^9, 3.541868297908592*^9}, 
   3.54186888756364*^9, 3.541868963010812*^9, 3.541869038207778*^9, 
   3.541869797739642*^9, 3.5418708453943853`*^9, 3.54187151326189*^9, 
   3.541909685519315*^9, 3.542438085488586*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Dmat2", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Dmat", "[", 
        RowBox[{"[", 
         RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "+", 
       RowBox[{"Dmat", "[", 
        RowBox[{"[", 
         RowBox[{"ii", ",", 
          RowBox[{
           RowBox[{"2", "NR"}], "+", "1", "-", "jj"}]}], "]"}], "]"}]}], ",", 
      
      RowBox[{"{", 
       RowBox[{"ii", ",", 
        RowBox[{"NR", "+", "1"}], ",", 
        RowBox[{"2", "NR"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"jj", ",", 
        RowBox[{"NR", "+", "1"}], ",", 
        RowBox[{"2", "NR"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"D2mat2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"D2mat", "[", 
       RowBox[{"[", 
        RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "+", 
      RowBox[{"D2mat", "[", 
       RowBox[{"[", 
        RowBox[{"ii", ",", 
         RowBox[{
          RowBox[{"2", "NR"}], "+", "1", "-", "jj"}]}], "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", 
       RowBox[{"NR", "+", "1"}], ",", 
       RowBox[{"2", "NR"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"jj", ",", 
       RowBox[{"NR", "+", "1"}], ",", 
       RowBox[{"2", "NR"}]}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.541868993306526*^9, 3.5418690065571003`*^9}, 
   3.541869048257558*^9, {3.541909692036151*^9, 3.54190969820532*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"N", "[", "Dmat2", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.541870854329073*^9, 3.541870870169176*^9}, 
   3.541871516158042*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "2.3640361940244143`"}], "3.6759773044471413`", 
      RowBox[{"-", "2.364036194024414`"}], "1.052095083601687`"},
     {
      RowBox[{"-", "1.3119411104227274`"}], 
      RowBox[{"-", "1.311941110422727`"}], "4.259846026821039`", 
      RowBox[{"-", "1.6359638059755857`"}]},
     {"0.583868722373899`", 
      RowBox[{"-", "2.947904916398312`"}], 
      RowBox[{"-", "2.9479049163983135`"}], "5.311941110422729`"},
     {
      RowBox[{"-", "0.9364527224555761`"}], "4.0800269969431096`", 
      RowBox[{"-", "19.143574274487538`"}], "16.`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.541870861857564*^9, 3.541870870609165*^9}, 
   3.541871516705204*^9, 3.5419097006368237`*^9, 3.542438087094393*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"N", "[", "D2mat2", "]"}], "]"}]], "Input",
 CellChangeTimes->{3.541909708293324*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "7.316543181720382`"}], "8.78473675476164`", 
      RowBox[{"-", "2.2071215520319605`"}], "0.7389279789906933`"},
     {"10.983520280601311`", 
      RowBox[{"-", "26.74760830286812`"}], "20.770170393068454`", 
      RowBox[{"-", "5.006082370801641`"}]},
     {
      RowBox[{"-", "5.5549071478300975`"}], "39.22360127143065`", 
      RowBox[{"-", "109.93584851541152`"}], "76.26715439181096`"},
     {
      RowBox[{"-", "26.96199061975031`"}], "107.94178492151389`", 
      RowBox[{"-", "224.97979430176366`"}], "144.`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.541909708704832*^9, 3.542438089755343*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Check", "Subsubtitle",
 CellChangeTimes->{{3.517556505886075*^9, 3.517556509091404*^9}, {
  3.5176375867460747`*^9, 3.517637607251473*^9}, {3.517639483331715*^9, 
  3.517639500939227*^9}, {3.541867151446308*^9, 3.5418671525252123`*^9}, {
  3.541867301843873*^9, 3.541867302971129*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "y_", "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"y", "^", "2"}]}], ")"}], "^", "2"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.541867155568058*^9, 3.5418671681920233`*^9}, {
  3.541867351103572*^9, 3.5418673531506643`*^9}, {3.541867425454322*^9, 
  3.541867427870324*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fdat", "=", 
  RowBox[{"f", "[", "ChebR2", "]"}]}]], "Input",
 CellChangeTimes->{{3.541867174224258*^9, 3.541867241099173*^9}, {
   3.5418673627207317`*^9, 3.541867394323229*^9}, 3.54186886310647*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        FractionBox["\[Pi]", "14"], "]"}], "2"]}], ")"}], "2"], ",", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        FractionBox[
         RowBox[{"3", " ", "\[Pi]"}], "14"], "]"}], "2"]}], ")"}], "2"], ",", 
   
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"Cos", "[", 
        FractionBox["\[Pi]", "7"], "]"}], "2"]}], ")"}], "2"], ",", "0"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5418672350552263`*^9, 3.54186724219002*^9}, {
   3.541867304904125*^9, 3.541867322190239*^9}, 3.5418673548425407`*^9, {
   3.541867385450185*^9, 3.541867441540947*^9}, 3.5418679166640882`*^9, 
   3.541867949956738*^9, {3.541868863773922*^9, 3.5418688877082043`*^9}, 
   3.541868970241372*^9, {3.5418690110442*^9, 3.541869038434059*^9}, 
   3.541869797834176*^9, 3.54187084548687*^9, 3.541909720227604*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"Dmat2", ".", "fdat"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"f", "'"}], "[", "ChebR2", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5418672437138233`*^9, 3.541867272878737*^9}, {
  3.541867406134797*^9, 3.541867408094153*^9}, {3.541868867035177*^9, 
  3.541868869419272*^9}, {3.541868972851404*^9, 3.54186897841194*^9}, {
  3.541869014556242*^9, 3.54186901635627*^9}, {3.5419097228285217`*^9, 
  3.541909724948797*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.8460107358150477`"}], ",", 
   RowBox[{"-", "1.524458669761153`"}], ",", 
   RowBox[{"-", "0.6784479339461047`"}], ",", "2.220446049250313`*^-16"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.541867265154687*^9, 3.54186727332436*^9}, 
   3.541867343167253*^9, {3.541867411392692*^9, 3.5418674415824623`*^9}, 
   3.5418679167062893`*^9, 3.541867949988481*^9, {3.541868869817286*^9, 
   3.5418688877900057`*^9}, {3.5418689733872633`*^9, 3.541868978895892*^9}, {
   3.5418690168766527`*^9, 3.541869038478533*^9}, 3.541869797894071*^9, 
   3.541870845525893*^9, 3.541909725527734*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.8460107358150478`"}], ",", 
   RowBox[{"-", "1.5244586697611526`"}], ",", 
   RowBox[{"-", "0.6784479339461046`"}], ",", "0.`"}], "}"}]], "Output",
 CellChangeTimes->{{3.541867265154687*^9, 3.54186727332436*^9}, 
   3.541867343167253*^9, {3.541867411392692*^9, 3.5418674415824623`*^9}, 
   3.5418679167062893`*^9, 3.541867949988481*^9, {3.541868869817286*^9, 
   3.5418688877900057`*^9}, {3.5418689733872633`*^9, 3.541868978895892*^9}, {
   3.5418690168766527`*^9, 3.541869038478533*^9}, 3.541869797894071*^9, 
   3.541870845525893*^9, 3.541909725529162*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"D2mat2", ".", "fdat"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"f", "''"}], "[", "ChebR2", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.54190972967785*^9, 3.541909731181264*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3.4058132074145164`"}], ",", "0.6648743962621104`", ",", 
   "5.740938811152407`", ",", "8.000000000000005`"}], "}"}]], "Output",
 CellChangeTimes->{3.541909731669739*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3.4058132074145147`"}], ",", "0.6648743962621126`", ",", 
   "5.740938811152402`", ",", "8.`"}], "}"}]], "Output",
 CellChangeTimes->{3.541909731670505*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1625, 890},
WindowMargins->{{Automatic, 13}, {Automatic, 0}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 280, 5, 27, "Input"],
Cell[CellGroupData[{
Cell[862, 29, 232, 3, 26, "Subsubtitle"],
Cell[1097, 34, 232, 6, 27, "Input"],
Cell[CellGroupData[{
Cell[1354, 44, 1266, 25, 79, "Input"],
Cell[2623, 71, 4140, 61, 27, "Output"]
}, Open  ]],
Cell[6778, 135, 228, 6, 27, "Input"],
Cell[7009, 143, 1202, 36, 49, "Input"],
Cell[8214, 181, 736, 23, 102, "Input"],
Cell[8953, 206, 741, 25, 107, "Input"],
Cell[CellGroupData[{
Cell[9719, 235, 160, 3, 27, "Input"],
Cell[9882, 240, 2878, 60, 153, "Output"]
}, Open  ]],
Cell[12775, 303, 169, 4, 27, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12981, 312, 291, 4, 26, "Subsubtitle"],
Cell[13275, 318, 445, 12, 27, "Input"],
Cell[CellGroupData[{
Cell[13745, 334, 201, 4, 27, "Input"],
Cell[13949, 340, 2325, 73, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16311, 418, 401, 10, 58, "Input"],
Cell[16715, 430, 696, 13, 27, "Output"],
Cell[17414, 445, 661, 12, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18112, 462, 299, 8, 58, "Input"],
Cell[18414, 472, 386, 8, 27, "Output"],
Cell[18803, 482, 349, 6, 27, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19201, 494, 232, 3, 26, "Subsubtitle"],
Cell[CellGroupData[{
Cell[19458, 501, 99, 1, 27, "Input"],
Cell[19560, 504, 898, 24, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20495, 533, 276, 8, 27, "Input"],
Cell[20774, 543, 549, 13, 46, "Output"]
}, Open  ]],
Cell[21338, 559, 1519, 47, 58, "Input"],
Cell[CellGroupData[{
Cell[22882, 610, 187, 4, 27, "Input"],
Cell[23072, 616, 1261, 30, 89, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24370, 651, 138, 3, 27, "Input"],
Cell[24511, 656, 1165, 28, 89, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25725, 690, 291, 4, 26, "Subsubtitle"],
Cell[26019, 696, 368, 10, 27, "Input"],
Cell[CellGroupData[{
Cell[26412, 710, 224, 4, 27, "Input"],
Cell[26639, 716, 1070, 29, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27746, 750, 543, 12, 58, "Input"],
Cell[28292, 764, 639, 12, 33, "Output"],
Cell[28934, 778, 617, 11, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29588, 794, 300, 8, 58, "Input"],
Cell[29891, 804, 228, 5, 27, "Output"],
Cell[30122, 811, 213, 5, 27, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
