(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    156612,       3721]
NotebookOptionsPosition[    152582,       3592]
NotebookOutlinePosition[    152937,       3608]
CellTagsIndexPosition[    152894,       3605]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Load Routine - RS", "Subsubtitle",
 CellChangeTimes->{{3.539899260141288*^9, 3.53989929032763*^9}, {
  3.542451227865471*^9, 3.542451228546563*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"analyse", "[", "filename_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", "\"\<~/Work\>\"", "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"SetDirectory", "[", "filename", "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"file1", "=", 
     RowBox[{"OpenRead", "[", 
      RowBox[{"\"\<patch.dat\>\"", ",", 
       RowBox[{"BinaryFormat", "\[Rule]", "True"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"NR", ",", "NA"}], "}"}], "=", 
     RowBox[{"BinaryReadList", "[", 
      RowBox[{"file1", ",", "\"\<Integer32\>\"", ",", "2"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmplist", "=", 
     RowBox[{"Partition", "[", 
      RowBox[{
       RowBox[{"BinaryReadList", "[", 
        RowBox[{"file1", ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<Real64\>\"", ",", "\"\<Real64\>\"", ",", "\"\<Integer32\>\"", 
           ",", "\"\<Integer32\>\"", ",", "\"\<Integer32\>\"", ",", 
           "\"\<Integer32\>\"", ",", "\"\<Integer32\>\""}], "}"}]}], "]"}], 
       ",", "NA"}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Close", "[", "file1", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"rpatch", "=", 
     RowBox[{"tmplist", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "All", ",", "1"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"apatch", "=", 
     RowBox[{"tmplist", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "All", ",", "2"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"rarr", "=", 
     RowBox[{"rpatch", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"aarr", "=", 
     RowBox[{"apatch", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "All"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"garr", "=", 
     RowBox[{"Import", "[", 
      RowBox[{"\"\<data.out\>\"", ",", "\"\<Real64\>\""}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"garr", "=", 
     RowBox[{"Partition", "[", 
      RowBox[{
       RowBox[{"Partition", "[", 
        RowBox[{
         RowBox[{"Partition", "[", 
          RowBox[{"garr", ",", "NA"}], "]"}], ",", "NR"}], "]"}], ",", "5"}], 
      "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"sizedata", "=", 
     RowBox[{"Length", "[", "garr", "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"\[Phi]2arr", "=", 
     RowBox[{"Import", "[", 
      RowBox[{"\"\<phi.out\>\"", ",", "\"\<Real64\>\""}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"\[Phi]2arr", "=", 
     RowBox[{"Partition", "[", 
      RowBox[{
       RowBox[{"Partition", "[", 
        RowBox[{"\[Phi]2arr", ",", "NA"}], "]"}], ",", "NR"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Ricciarr", "=", 
     RowBox[{"Import", "[", 
      RowBox[{"\"\<Ricci.out\>\"", ",", "\"\<Real64\>\""}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Ricciarr", "=", 
     RowBox[{"Partition", "[", 
      RowBox[{
       RowBox[{"Partition", "[", 
        RowBox[{"Ricciarr", ",", "NA"}], "]"}], ",", "NR"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"R2sqrarr", "=", 
     RowBox[{"Import", "[", 
      RowBox[{"\"\<R2sqr.out\>\"", ",", "\"\<Real64\>\""}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"R2sqrarr", "=", 
     RowBox[{"Partition", "[", 
      RowBox[{
       RowBox[{"Partition", "[", 
        RowBox[{"R2sqrarr", ",", "NA"}], "]"}], ",", "NR"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"R4sqrarr", "=", 
     RowBox[{"Import", "[", 
      RowBox[{"\"\<R4sqr.out\>\"", ",", "\"\<Real64\>\""}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"R4sqrarr", "=", 
     RowBox[{"Partition", "[", 
      RowBox[{
       RowBox[{"Partition", "[", 
        RowBox[{"R4sqrarr", ",", "NA"}], "]"}], ",", "NR"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tval", "=", 
     RowBox[{"-", "1"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    
    RowBox[{"gdat", "=", 
     RowBox[{"garr", "[", 
      RowBox[{"[", "tval", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"sqr\[Phi]", "=", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"\[Phi]2arr", "[", 
       RowBox[{"[", "tval", "]"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", 
    RowBox[{"Riccidat", "=", 
     RowBox[{"Ricciarr", "[", 
      RowBox[{"[", "tval", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"R2dat", "=", 
     RowBox[{"R2sqrarr", "[", 
      RowBox[{"[", "tval", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"R4dat", "=", 
     RowBox[{"R4sqrarr", "[", 
      RowBox[{"[", "tval", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"newg", "=", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{"Table", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"ii", ">", "NR"}], ",", 
              RowBox[{
               RowBox[{"posr", "=", 
                RowBox[{"ii", "-", "NR"}]}], ";", 
               RowBox[{"valr", "=", "1"}]}], ",", 
              RowBox[{
               RowBox[{"posr", "=", 
                RowBox[{"NR", "+", "1", "-", "ii"}]}], ";", 
               RowBox[{"valr", "=", 
                RowBox[{"-", "1"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"jj", ">", "NA"}], ",", 
              RowBox[{
               RowBox[{"posa", "=", 
                RowBox[{"jj", "-", "NA"}]}], ";", 
               RowBox[{"vala", "=", "1"}]}], ",", 
              RowBox[{
               RowBox[{"posa", "=", 
                RowBox[{"NA", "+", "1", "-", "jj"}]}], ";", 
               RowBox[{"vala", "=", 
                RowBox[{"-", "1"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"valr", "*", 
               RowBox[{"rarr", "[", 
                RowBox[{"[", "posr", "]"}], "]"}]}], ",", 
              RowBox[{"vala", "*", 
               RowBox[{"aarr", "[", 
                RowBox[{"[", "posa", "]"}], "]"}]}], ",", 
              RowBox[{"gdat", "[", 
               RowBox[{"[", 
                RowBox[{"var", ",", "posr", ",", "posa"}], "]"}], "]"}]}], 
             "}"}]}], "\[IndentingNewLine]", ",", 
           RowBox[{"{", 
            RowBox[{"ii", ",", "1", ",", 
             RowBox[{"2", "*", "NR"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"jj", ",", "1", ",", 
             RowBox[{"2", "*", "NA"}]}], "}"}]}], "]"}], ",", "1"}], "]"}], 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"var", ",", "1", ",", "5"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"newgfn", "=", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Interpolation", "[", 
        RowBox[{"newg", "[", 
         RowBox[{"[", "var", "]"}], "]"}], "]"}], "\[IndentingNewLine]", ",", 
       
       RowBox[{"{", 
        RowBox[{"var", ",", "1", ",", "5"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"newsqr\[Phi]CUT", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"ii", ">", "NR"}], ",", 
            RowBox[{
             RowBox[{"posr", "=", 
              RowBox[{"ii", "-", "NR"}]}], ";", 
             RowBox[{"valr", "=", "1"}]}], ",", 
            RowBox[{
             RowBox[{"posr", "=", 
              RowBox[{"NR", "+", "1", "-", "ii"}]}], ";", 
             RowBox[{"valr", "=", 
              RowBox[{"-", "1"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"jj", ">", "NA"}], ",", 
            RowBox[{
             RowBox[{"posa", "=", 
              RowBox[{"jj", "-", "NA"}]}], ";", 
             RowBox[{"vala", "=", "1"}]}], ",", 
            RowBox[{
             RowBox[{"posa", "=", 
              RowBox[{"NA", "+", "1", "-", "jj"}]}], ";", 
             RowBox[{"vala", "=", 
              RowBox[{"-", "1"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"valr", "*", 
             RowBox[{"rarr", "[", 
              RowBox[{"[", "posr", "]"}], "]"}]}], ",", 
            RowBox[{"vala", "*", 
             RowBox[{"aarr", "[", 
              RowBox[{"[", "posa", "]"}], "]"}]}], ",", 
            RowBox[{"sqr\[Phi]", "[", 
             RowBox[{"[", 
              RowBox[{"posr", ",", "posa"}], "]"}], "]"}]}], "}"}]}], 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", 
           RowBox[{"1", "+", "1"}], ",", 
           RowBox[{
            RowBox[{"2", "*", "NR"}], "-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"jj", ",", "1", ",", 
           RowBox[{"2", "*", "NA"}]}], "}"}]}], "]"}], ",", "1"}], "]"}]}], 
    ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"newRicciCUT", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"ii", ">", "NR"}], ",", 
            RowBox[{
             RowBox[{"posr", "=", 
              RowBox[{"ii", "-", "NR"}]}], ";", 
             RowBox[{"valr", "=", "1"}]}], ",", 
            RowBox[{
             RowBox[{"posr", "=", 
              RowBox[{"NR", "+", "1", "-", "ii"}]}], ";", 
             RowBox[{"valr", "=", 
              RowBox[{"-", "1"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"jj", ">", "NA"}], ",", 
            RowBox[{
             RowBox[{"posa", "=", 
              RowBox[{"jj", "-", "NA"}]}], ";", 
             RowBox[{"vala", "=", "1"}]}], ",", 
            RowBox[{
             RowBox[{"posa", "=", 
              RowBox[{"NA", "+", "1", "-", "jj"}]}], ";", 
             RowBox[{"vala", "=", 
              RowBox[{"-", "1"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"valr", "*", 
             RowBox[{"rarr", "[", 
              RowBox[{"[", "posr", "]"}], "]"}]}], ",", 
            RowBox[{"vala", "*", 
             RowBox[{"aarr", "[", 
              RowBox[{"[", "posa", "]"}], "]"}]}], ",", 
            RowBox[{"Abs", "[", 
             RowBox[{
              RowBox[{
               FractionBox["1", "20"], 
               RowBox[{"Riccidat", "[", 
                RowBox[{"[", 
                 RowBox[{"posr", ",", "posa"}], "]"}], "]"}]}], "+", "1"}], 
             "]"}]}], "}"}]}], "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", 
           RowBox[{"1", "+", "1"}], ",", 
           RowBox[{
            RowBox[{"2", "*", "NR"}], "-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"jj", ",", "1", ",", 
           RowBox[{"2", "*", "NA"}]}], "}"}]}], "]"}], ",", "1"}], "]"}]}], 
    ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"newR2CUT", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"ii", ">", "NR"}], ",", 
            RowBox[{
             RowBox[{"posr", "=", 
              RowBox[{"ii", "-", "NR"}]}], ";", 
             RowBox[{"valr", "=", "1"}]}], ",", 
            RowBox[{
             RowBox[{"posr", "=", 
              RowBox[{"NR", "+", "1", "-", "ii"}]}], ";", 
             RowBox[{"valr", "=", 
              RowBox[{"-", "1"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"jj", ">", "NA"}], ",", 
            RowBox[{
             RowBox[{"posa", "=", 
              RowBox[{"jj", "-", "NA"}]}], ";", 
             RowBox[{"vala", "=", "1"}]}], ",", 
            RowBox[{
             RowBox[{"posa", "=", 
              RowBox[{"NA", "+", "1", "-", "jj"}]}], ";", 
             RowBox[{"vala", "=", 
              RowBox[{"-", "1"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"valr", "*", 
             RowBox[{"rarr", "[", 
              RowBox[{"[", "posr", "]"}], "]"}]}], ",", 
            RowBox[{"vala", "*", 
             RowBox[{"aarr", "[", 
              RowBox[{"[", "posa", "]"}], "]"}]}], ",", 
            RowBox[{"Abs", "[", 
             RowBox[{
              RowBox[{
               FractionBox["1", "80"], 
               RowBox[{"R2dat", "[", 
                RowBox[{"[", 
                 RowBox[{"posr", ",", "posa"}], "]"}], "]"}]}], "-", "1"}], 
             "]"}]}], "}"}]}], "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", 
           RowBox[{"1", "+", "1"}], ",", 
           RowBox[{
            RowBox[{"2", "*", "NR"}], "-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"jj", ",", "1", ",", 
           RowBox[{"2", "*", "NA"}]}], "}"}]}], "]"}], ",", "1"}], "]"}]}], 
    ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"newR4CUT", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"ii", ">", "NR"}], ",", 
            RowBox[{
             RowBox[{"posr", "=", 
              RowBox[{"ii", "-", "NR"}]}], ";", 
             RowBox[{"valr", "=", "1"}]}], ",", 
            RowBox[{
             RowBox[{"posr", "=", 
              RowBox[{"NR", "+", "1", "-", "ii"}]}], ";", 
             RowBox[{"valr", "=", 
              RowBox[{"-", "1"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"jj", ">", "NA"}], ",", 
            RowBox[{
             RowBox[{"posa", "=", 
              RowBox[{"jj", "-", "NA"}]}], ";", 
             RowBox[{"vala", "=", "1"}]}], ",", 
            RowBox[{
             RowBox[{"posa", "=", 
              RowBox[{"NA", "+", "1", "-", "jj"}]}], ";", 
             RowBox[{"vala", "=", 
              RowBox[{"-", "1"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"valr", "*", 
             RowBox[{"rarr", "[", 
              RowBox[{"[", "posr", "]"}], "]"}]}], ",", 
            RowBox[{"vala", "*", 
             RowBox[{"aarr", "[", 
              RowBox[{"[", "posa", "]"}], "]"}]}], ",", 
            RowBox[{"R4dat", "[", 
             RowBox[{"[", 
              RowBox[{"posr", ",", "posa"}], "]"}], "]"}]}], "}"}]}], 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", 
           RowBox[{"1", "+", "1"}], ",", 
           RowBox[{
            RowBox[{"2", "*", "NR"}], "-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"jj", ",", "1", ",", 
           RowBox[{"2", "*", "NA"}]}], "}"}]}], "]"}], ",", "1"}], "]"}]}], 
    ";", "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    
    RowBox[{"newsqr\[Phi]fn", "=", 
     RowBox[{"Interpolation", "[", "newsqr\[Phi]CUT", "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"newRiccifn", "=", 
     RowBox[{"Interpolation", "[", "newRicciCUT", "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"newR2fn", "=", 
     RowBox[{"Interpolation", "[", "newR2CUT", "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"newR4fn", "=", 
     RowBox[{"Interpolation", "[", "newR4CUT", "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"errPhi", "=", 
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{"newsqr\[Phi]fn", "[", 
        RowBox[{"r", ",", "a"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"r", ",", "0", ",", 
         RowBox[{"rarr", "[", 
          RowBox[{"[", 
           RowBox[{"-", "2"}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"errRicci", "=", 
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{"newRiccifn", "[", 
        RowBox[{"r", ",", "a"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"r", ",", "0", ",", 
         RowBox[{"rarr", "[", 
          RowBox[{"[", 
           RowBox[{"-", "2"}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"errR2", "=", 
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{"newR2fn", "[", 
        RowBox[{"r", ",", "a"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"r", ",", "0", ",", 
         RowBox[{"rarr", "[", 
          RowBox[{"[", 
           RowBox[{"-", "2"}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"errlist", "=", 
     RowBox[{"{", 
      RowBox[{"NR", ",", 
       RowBox[{"Max", "[", 
        RowBox[{"newsqr\[Phi]CUT", "[", 
         RowBox[{"[", 
          RowBox[{"All", ",", "3"}], "]"}], "]"}], "]"}], ",", 
       RowBox[{"Max", "[", 
        RowBox[{"newRicciCUT", "[", 
         RowBox[{"[", 
          RowBox[{"All", ",", "3"}], "]"}], "]"}], "]"}], ",", 
       RowBox[{"Max", "[", 
        RowBox[{"newR2CUT", "[", 
         RowBox[{"[", 
          RowBox[{"All", ",", "3"}], "]"}], "]"}], "]"}], ",", "errPhi", ",", 
       "errRicci", ",", "errR2", ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"newgfn", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], "[", 
          RowBox[{"0", ",", "0"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", "5"}], "}"}]}], "]"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"newgfn", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], "[", 
          RowBox[{"0", ",", "1"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", "5"}], "}"}]}], "]"}]}], "}"}]}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}]], "Input",
 CellChangeTimes->{{3.539899030396741*^9, 3.5398990443893137`*^9}, {
   3.5398991023021727`*^9, 3.5398992264442663`*^9}, {3.539899333317923*^9, 
   3.539899333749195*^9}, {3.539899500962047*^9, 3.539899531604052*^9}, {
   3.5399011372972927`*^9, 3.539901169990121*^9}, {3.539901200012993*^9, 
   3.539901223636487*^9}, {3.539901636607029*^9, 3.539901637019285*^9}, {
   3.539901677444491*^9, 3.539901677595982*^9}, {3.539949578760297*^9, 
   3.539949580863264*^9}, {3.53998661392113*^9, 3.53998666371027*^9}, {
   3.539986845981512*^9, 3.539986848235993*^9}, {3.5400405601054583`*^9, 
   3.54004060240615*^9}, {3.540751064031855*^9, 3.54075112588262*^9}, {
   3.541397418339259*^9, 3.541397433892971*^9}, {3.541397480594281*^9, 
   3.541397480989303*^9}, {3.541840407130921*^9, 3.5418404099301777`*^9}, {
   3.5419279388387527`*^9, 3.541927944025823*^9}, {3.544167944267465*^9, 
   3.544167961736866*^9}, {3.544168012937026*^9, 3.54416804457837*^9}, {
   3.544168077258277*^9, 3.544168180746848*^9}, 3.544168222309011*^9, {
   3.5441682574663258`*^9, 3.54416840187044*^9}, {3.544168619621807*^9, 
   3.5441686325304623`*^9}, {3.5441693946579943`*^9, 
   3.5441693963132563`*^9}, {3.544169557849247*^9, 3.5441695625172033`*^9}, {
   3.5441730738331347`*^9, 3.544173084434465*^9}, {3.544175813812549*^9, 
   3.5441758472489653`*^9}, 3.5441761312795362`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Run New", "Subsubtitle",
 CellChangeTimes->{{3.539899260141288*^9, 3.539899297289146*^9}, {
  3.541840445367931*^9, 3.541840450071163*^9}, {3.5424448759337378`*^9, 
  3.542444876074532*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"dir", "=", "\"\<SpecTest4/\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.541840483485058*^9, 3.541840488677471*^9}, {
  3.541840570225803*^9, 3.541840572312664*^9}, {3.5419279027094297`*^9, 
  3.5419279027506657`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"\"\<~/Work/\>\"", "<>", "dir"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.542449058767048*^9, 3.542449063874609*^9}, {
   3.542449117626239*^9, 3.5424491230075617`*^9}, 3.542449185263421*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"filelist", "=", 
  RowBox[{"FileNames", "[", "\"\<test_even_03_*\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.542449026399249*^9, 3.54244903840585*^9}, {
   3.542449071418521*^9, 3.542449083130803*^9}, {3.5424491337890987`*^9, 
   3.5424491770316563`*^9}, {3.5424493575869713`*^9, 3.542449445412077*^9}, {
   3.542449490803844*^9, 3.542449491080214*^9}, 3.542450981702395*^9, {
   3.542451353301111*^9, 3.542451353516149*^9}, {3.542451410215209*^9, 
   3.54245141033298*^9}, {3.5424516122247458`*^9, 3.5424516123493633`*^9}, {
   3.54245257154423*^9, 3.542452571725466*^9}, {3.542453041437951*^9, 
   3.542453041624668*^9}, {3.5424553548092203`*^9, 3.542455354894165*^9}, {
   3.5424553853276854`*^9, 3.542455388879409*^9}, {3.5424554215624647`*^9, 
   3.542455421925193*^9}, {3.5424554896354103`*^9, 3.542455489971911*^9}, {
   3.542455861797517*^9, 3.542455861932611*^9}, {3.542456813941805*^9, 
   3.5424568140533457`*^9}, {3.5424568604449863`*^9, 3.542456860620646*^9}, {
   3.542456900989393*^9, 3.542456901690639*^9}, {3.542457136717547*^9, 
   3.5424571367979383`*^9}, {3.542457893387538*^9, 3.5424578939206657`*^9}, {
   3.543666895163241*^9, 3.543666895258054*^9}, {3.5436682888360367`*^9, 
   3.543668288930764*^9}, {3.5441677357344723`*^9, 3.544167735796743*^9}, {
   3.544167875360806*^9, 3.5441678913926487`*^9}, {3.544174020387671*^9, 
   3.5441740205056257`*^9}, {3.544174721587332*^9, 3.544174721650179*^9}, {
   3.544175636249854*^9, 3.544175636328619*^9}, {3.544176250499465*^9, 
   3.544176250603422*^9}, {3.544176313608917*^9, 3.544176313704702*^9}, {
   3.5441764412607393`*^9, 3.544176441320705*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"test_even_03_20\"\>", ",", "\<\"test_even_03_22\"\>", 
   ",", "\<\"test_even_03_24\"\>", ",", "\<\"test_even_03_26\"\>", 
   ",", "\<\"test_even_03_28\"\>", ",", "\<\"test_even_03_30\"\>", 
   ",", "\<\"test_even_03_32\"\>", ",", "\<\"test_even_03_34\"\>", 
   ",", "\<\"test_even_03_36\"\>", ",", "\<\"test_even_03_38\"\>", 
   ",", "\<\"test_even_03_40\"\>", ",", "\<\"test_even_03_42\"\>", 
   ",", "\<\"test_even_03_44\"\>", ",", "\<\"test_even_03_45\"\>", 
   ",", "\<\"test_even_03_46\"\>", ",", "\<\"test_even_03_48\"\>", 
   ",", "\<\"test_even_03_50\"\>", ",", "\<\"test_even_03_55\"\>", 
   ",", "\<\"test_even_03_60\"\>"}], "}"}]], "Output",
 CellChangeTimes->{{3.542449029368087*^9, 3.542449083635357*^9}, {
   3.5424491348820677`*^9, 3.542449146835939*^9}, 3.542449189906624*^9, {
   3.5424493581542997`*^9, 3.5424493792601347`*^9}, {3.542449412597877*^9, 
   3.542449448815455*^9}, 3.542449494587245*^9, {3.542450480007914*^9, 
   3.542450512192162*^9}, 3.54245099241393*^9, 3.542451181683421*^9, 
   3.54245128475766*^9, 3.542451374824274*^9, 3.542451414583747*^9, 
   3.5424516152286777`*^9, 3.5424525785646677`*^9, 3.5424530535579653`*^9, 
   3.5424539113135767`*^9, 3.5424553605803013`*^9, 3.542455394038323*^9, 
   3.5424554246559887`*^9, 3.5424554971249723`*^9, 3.542455878480865*^9, 
   3.542456562056175*^9, 3.54245682389496*^9, 3.542456869459092*^9, 
   3.542456910695994*^9, 3.542457143920931*^9, 3.5424579018118963`*^9, 
   3.543666907050514*^9, 3.543667148352335*^9, 3.543668298089851*^9, 
   3.54416773624928*^9, {3.544167875877253*^9, 3.544167891726021*^9}, {
   3.5441683889641438`*^9, 3.544168409854641*^9}, 3.544168636480432*^9, 
   3.544169409021413*^9, 3.544169570637829*^9, 3.544173089978462*^9, 
   3.544174024453529*^9, 3.544174725444808*^9, 3.544175640559684*^9, 
   3.544175859223112*^9, 3.544176137563102*^9, 3.544176255640172*^9, 
   3.544176357411972*^9, 3.544176444176318*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"datnew", "=", 
   RowBox[{"Table", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"analyse", "[", 
      RowBox[{"dir", "<>", 
       RowBox[{"filelist", "[", 
        RowBox[{"[", "ii", "]"}], "]"}]}], "]"}], "\[IndentingNewLine]", ",", 
     
     RowBox[{"{", 
      RowBox[{"ii", ",", "1", ",", 
       RowBox[{"Length", "[", "filelist", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.54184045916241*^9, 3.54184052697576*^9}, {
   3.5418405621280603`*^9, 3.541840584867428*^9}, {3.542456906237458*^9, 
   3.542456907029269*^9}, {3.542457140444964*^9, 3.542457140748765*^9}, 
   3.544168449131302*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "\"\<Max Sqrt[\[Phi]]\>\"", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datnew", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "\"\<Int Sqrt[\[Phi]]\>\"", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"datnew", "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "5"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.54244087777771*^9, 3.542440884872513*^9}, {
  3.542450538146228*^9, 3.542450539311035*^9}, {3.544168452178689*^9, 
  3.544168469986676*^9}, {3.544168528530305*^9, 3.544168528897997*^9}}],

Cell[BoxData["\<\"Max Sqrt[\[Phi]]\"\>"], "Print",
 CellChangeTimes->{
  3.544168470756919*^9, {3.544168529320632*^9, 3.544168551882367*^9}, 
   3.544168643509564*^9, 3.544169415467709*^9, 3.5441695771334667`*^9, 
   3.544174033572074*^9, 3.544174732952333*^9, 3.544175650948368*^9, 
   3.544175870141096*^9, 3.544176147219226*^9, 3.544176262231501*^9, 
   3.544176364776875*^9, 3.5441764529428263`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"20", ",", "0.005001369804579243`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "0.0024716681699014365`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "0.0012004090881623513`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", "0.0005785794542110594`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "0.0002837694372888766`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30", ",", "0.00021668522276416035`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", "0.0000666979918973611`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"34", ",", "0.00003264652237820606`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"36", ",", "0.000015887069052424998`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"38", ",", "7.69611875133289`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "3.7644791266289643`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"42", ",", "1.8356107880422602`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"44", ",", "8.929090380175393`*^-7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"45", ",", "6.262093489365853`*^-7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"46", ",", "4.3740119917009654`*^-7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"48", ",", "3.0779505980437527`*^-7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"50", ",", "3.466570472703435`*^-7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"55", ",", "8.951368555519978`*^-7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"60", ",", "2.445388985761299`*^-6"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.542440885280212*^9, {3.542444913036989*^9, 3.5424449551586514`*^9}, 
   3.5424450461187267`*^9, 3.542447069537778*^9, 3.542447103696225*^9, 
   3.542447194259089*^9, 3.5424474134892397`*^9, 3.54244915190106*^9, 
   3.542449195995562*^9, 3.542449385515627*^9, {3.542449416017282*^9, 
   3.542449451669491*^9}, 3.542449564622425*^9, {3.5424504976924477`*^9, 
   3.5424505403006353`*^9}, 3.5424509968721457`*^9, 3.54245130230337*^9, 
   3.542451380200798*^9, 3.542451428893146*^9, 3.542451618958194*^9, 
   3.5424525933568287`*^9, 3.542453064131105*^9, 3.54245391313307*^9, {
   3.5424554059472857`*^9, 3.542455429873788*^9}, 3.542455513083509*^9, 
   3.5424558975459337`*^9, 3.5424565675228777`*^9, 3.5424568270871162`*^9, 
   3.5424568703204823`*^9, 3.542456911747376*^9, 3.5424571447096453`*^9, 
   3.542457905757406*^9, 3.543666924452667*^9, 3.543667152115453*^9, 
   3.5436683016277637`*^9, 3.544167742069665*^9, 3.544167896319153*^9, 
   3.544168419472928*^9, 3.5441684707587957`*^9, {3.544168529323167*^9, 
   3.544168551884857*^9}, 3.544168643511458*^9, 3.544169415469726*^9, 
   3.544169577135623*^9, 3.5441740335744953`*^9, 3.544174732954473*^9, 
   3.5441756509506493`*^9, 3.544175870143145*^9, 3.544176147221594*^9, 
   3.544176262233058*^9, 3.544176364778043*^9, 3.544176452944417*^9}],

Cell[BoxData["\<\"Int Sqrt[\[Phi]]\"\>"], "Print",
 CellChangeTimes->{
  3.544168470756919*^9, {3.544168529320632*^9, 3.544168551882367*^9}, 
   3.544168643509564*^9, 3.544169415467709*^9, 3.5441695771334667`*^9, 
   3.544174033572074*^9, 3.544174732952333*^9, 3.544175650948368*^9, 
   3.544175870141096*^9, 3.544176147219226*^9, 3.544176262231501*^9, 
   3.544176364776875*^9, 3.544176452945554*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"20", ",", "0.0013116751528075641`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "0.0006172377018793982`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "0.00029101269508143864`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", "0.00013755606803851929`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "0.00006517431404246784`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30", ",", "0.000032871230763247775`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", "0.000014743730024190576`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"34", ",", "7.02456651628535`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"36", ",", "3.3541081587601273`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"38", ",", "1.60492622020929`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "7.70842723684545`*^-7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"42", ",", "3.732721460521147`*^-7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"44", ",", "1.8340631819723047`*^-7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"45", ",", "1.3009223523494841`*^-7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"46", ",", "9.26796973435529`*^-8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"48", ",", "4.987791015242932`*^-8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"50", ",", "2.9799979231612354`*^-8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"55", ",", "2.166125146612805`*^-8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"60", ",", "5.5944575005527204`*^-8"}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{
  3.542440885280212*^9, {3.542444913036989*^9, 3.5424449551586514`*^9}, 
   3.5424450461187267`*^9, 3.542447069537778*^9, 3.542447103696225*^9, 
   3.542447194259089*^9, 3.5424474134892397`*^9, 3.54244915190106*^9, 
   3.542449195995562*^9, 3.542449385515627*^9, {3.542449416017282*^9, 
   3.542449451669491*^9}, 3.542449564622425*^9, {3.5424504976924477`*^9, 
   3.5424505403006353`*^9}, 3.5424509968721457`*^9, 3.54245130230337*^9, 
   3.542451380200798*^9, 3.542451428893146*^9, 3.542451618958194*^9, 
   3.5424525933568287`*^9, 3.542453064131105*^9, 3.54245391313307*^9, {
   3.5424554059472857`*^9, 3.542455429873788*^9}, 3.542455513083509*^9, 
   3.5424558975459337`*^9, 3.5424565675228777`*^9, 3.5424568270871162`*^9, 
   3.5424568703204823`*^9, 3.542456911747376*^9, 3.5424571447096453`*^9, 
   3.542457905757406*^9, 3.543666924452667*^9, 3.543667152115453*^9, 
   3.5436683016277637`*^9, 3.544167742069665*^9, 3.544167896319153*^9, 
   3.544168419472928*^9, 3.5441684707587957`*^9, {3.544168529323167*^9, 
   3.544168551884857*^9}, 3.544168643511458*^9, 3.544169415469726*^9, 
   3.544169577135623*^9, 3.5441740335744953`*^9, 3.544174732954473*^9, 
   3.5441756509506493`*^9, 3.544175870143145*^9, 3.544176147221594*^9, 
   3.544176262233058*^9, 3.544176364778043*^9, 3.544176452946681*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "\"\<Max | Ricci |\>\"", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datnew", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "\"\<Int | Ricci |\>\"", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"datnew", "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "6"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5441684783553333`*^9, 3.5441684836846933`*^9}, {
  3.5441685373461523`*^9, 3.5441685420737467`*^9}}],

Cell[BoxData["\<\"Max | Ricci |\"\>"], "Print",
 CellChangeTimes->{3.5441684841522293`*^9, 3.544168552535282*^9, 
  3.544168643577313*^9, 3.544169415513589*^9, 3.544169577167574*^9, 
  3.544174034893983*^9, 3.544174733018476*^9, 3.5441756510203323`*^9, 
  3.544175870244341*^9, 3.544176147300061*^9, 3.544176262264209*^9, 
  3.5441763648122797`*^9, 3.544176452989414*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"20", ",", "0.007575185560749764`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "0.003910869396560157`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "0.0019909910057849256`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", "0.0010033731387844025`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "0.000504314048932919`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30", ",", "0.00025714513512808956`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", "0.00013020814998276897`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"34", ",", "0.00006553772805262259`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"36", ",", "0.0000328261875700564`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"38", ",", "0.000016491399644991134`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "8.3156408192675`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"42", ",", "4.1756627038314065`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"44", ",", "2.089005683103551`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"45", ",", "1.4785142814499608`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"46", ",", "1.0415193991697436`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"48", ",", "5.233939901483353`*^-7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"50", ",", "2.6304463240922615`*^-7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"55", ",", "8.52314036015045`*^-8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"60", ",", "2.4590967884208226`*^-7"}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{3.544168484154233*^9, 3.544168552538094*^9, 
  3.544168643579797*^9, 3.544169415515473*^9, 3.544169577169613*^9, 
  3.544174034896463*^9, 3.54417473302044*^9, 3.544175651022459*^9, 
  3.5441758702470913`*^9, 3.544176147302229*^9, 3.544176262265847*^9, 
  3.544176364813415*^9, 3.54417645299104*^9}],

Cell[BoxData["\<\"Int | Ricci |\"\>"], "Print",
 CellChangeTimes->{3.5441684841522293`*^9, 3.544168552535282*^9, 
  3.544168643577313*^9, 3.544169415513589*^9, 3.544169577167574*^9, 
  3.544174034893983*^9, 3.544174733018476*^9, 3.5441756510203323`*^9, 
  3.544175870244341*^9, 3.544176147300061*^9, 3.544176262264209*^9, 
  3.5441763648122797`*^9, 3.544176452992194*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"20", ",", "0.0009079887555931024`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "0.00044036702786816827`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "0.00021321344655601286`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", "0.00010317380081150569`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "0.00004997519123249072`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30", ",", "0.000024540293506882748`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", "0.00001177613936790081`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"34", ",", "5.7237720608774304`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"36", ",", "2.7837958042690854`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"38", ",", "1.355367390118426`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "6.60891364271197`*^-7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"42", ",", "3.22753049358792`*^-7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"44", ",", "1.5798946964796655`*^-7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"45", ",", "1.1078511576932887`*^-7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"46", ",", "7.773966251404551`*^-8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"48", ",", "3.873128667300274`*^-8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"50", ",", "1.974723799224399`*^-8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"55", ",", "5.705226660626252`*^-9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"60", ",", "5.768152341283815`*^-9"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.544168484154233*^9, 3.544168552538094*^9, 
  3.544168643579797*^9, 3.544169415515473*^9, 3.544169577169613*^9, 
  3.544174034896463*^9, 3.54417473302044*^9, 3.544175651022459*^9, 
  3.5441758702470913`*^9, 3.544176147302229*^9, 3.544176262265847*^9, 
  3.544176364813415*^9, 3.544176452993326*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "\"\<Max | R2 |\>\"", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datnew", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "\"\<Int | R2 |\>\"", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"datnew", "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "7"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5441684879152193`*^9, 3.5441684902103357`*^9}, {
  3.544168545449679*^9, 3.5441685491294613`*^9}}],

Cell[BoxData["\<\"Max | R2 |\"\>"], "Print",
 CellChangeTimes->{
  3.544168490831792*^9, {3.5441685495771837`*^9, 3.5441685531886463`*^9}, 
   3.544168643661378*^9, 3.544169415554109*^9, 3.544169577218935*^9, 
   3.544174036710723*^9, 3.544174733086213*^9, 3.544175651102086*^9, 
   3.544175870307888*^9, 3.5441761473674088`*^9, 3.544176262294302*^9, 
   3.5441763648416023`*^9, 3.544176453033619*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"20", ",", "0.01524674225436784`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "0.007847642526238374`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "0.003988745514803771`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", "0.002008475666615439`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "0.0010081892674873583`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30", ",", "0.0005141752690898116`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", "0.00026038674414430307`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"34", ",", "0.00013106793415174067`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"36", ",", "0.00006565047981554883`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"38", ",", "0.000032983276602394085`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "0.000016631403572553438`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"42", ",", "8.351356353797357`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"44", ",", "4.178019218370466`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"45", ",", "2.9570325590366764`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"46", ",", "2.083040830269667`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"48", ",", "1.046787423963913`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"50", ",", "5.260890805214302`*^-7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"55", ",", "1.7042699873570655`*^-7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"60", ",", "4.914722905313695`*^-7"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.544168490833706*^9, {3.5441685495794764`*^9, 3.54416855319034*^9}, 
   3.544168643663768*^9, 3.544169415556418*^9, 3.544169577220847*^9, 
   3.544174036712447*^9, 3.544174733088717*^9, 3.54417565110417*^9, 
   3.544175870310556*^9, 3.544176147369442*^9, 3.544176262295869*^9, 
   3.544176364842841*^9, 3.544176453035235*^9}],

Cell[BoxData["\<\"Int | R2 |\"\>"], "Print",
 CellChangeTimes->{
  3.544168490831792*^9, {3.5441685495771837`*^9, 3.5441685531886463`*^9}, 
   3.544168643661378*^9, 3.544169415554109*^9, 3.544169577218935*^9, 
   3.544174036710723*^9, 3.544174733086213*^9, 3.544175651102086*^9, 
   3.544175870307888*^9, 3.5441761473674088`*^9, 3.544176262294302*^9, 
   3.5441763648416023`*^9, 3.544176453036374*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"20", ",", "0.0018160222561380657`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "0.000880732519364326`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "0.0004264270199516293`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", "0.00020634772954971055`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "0.00009995047183269506`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30", ",", "0.00004908085500486506`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", "0.00002355228157950789`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"34", ",", "0.000011447544279194421`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"36", ",", "5.567591636167078`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"38", ",", "2.7107347743112116`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "1.3217827531371505`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"42", ",", "6.455061052246923`*^-7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"44", ",", "3.159789386928278`*^-7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"45", ",", "2.215702293697842`*^-7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"46", ",", "1.5547932598115786`*^-7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"48", ",", "7.746257461743156`*^-8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"50", ",", "3.949447802795248`*^-8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"55", ",", "1.1410445448163512`*^-8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"60", ",", "1.153629782506312`*^-8"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.544168490833706*^9, {3.5441685495794764`*^9, 3.54416855319034*^9}, 
   3.544168643663768*^9, 3.544169415556418*^9, 3.544169577220847*^9, 
   3.544174036712447*^9, 3.544174733088717*^9, 3.54417565110417*^9, 
   3.544175870310556*^9, 3.544176147369442*^9, 3.544176262295869*^9, 
   3.544176364842841*^9, 3.5441764530375*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "\"\<{ T, S... (0,0)\>\"", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"datnew", "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "8"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.544168508978951*^9, 3.544168512721817*^9}, {
  3.544168558232966*^9, 3.544168563016733*^9}, {3.544169412143813*^9, 
  3.5441694157084703`*^9}, {3.544175867319207*^9, 3.544175885694311*^9}}],

Cell[BoxData["\<\"{ T, S... (0,0)\"\>"], "Print",
 CellChangeTimes->{
  3.544168513005147*^9, 3.54416856525819*^9, 3.544168645881674*^9, {
   3.54416941558848*^9, 3.544169422565727*^9}, 3.544169577269559*^9, 
   3.544174037710104*^9, 3.544174733185989*^9, 3.5441756512187843`*^9, {
   3.5441758742327557`*^9, 3.544175886373219*^9}, 3.544176147467499*^9, 
   3.5441762623535833`*^9, 3.544176364914214*^9, 3.5441764530991707`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"20", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.0542438709019337`"}], ",", "0.05555105450536114`", ",", 
       RowBox[{"-", "8.882666497212512`"}], ",", 
       RowBox[{"-", "8.615594691831443`"}], ",", "1.260455765331497`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.0560221195854447`"}], ",", "0.052859302659066895`", 
       ",", 
       RowBox[{"-", "8.915938658689136`"}], ",", 
       RowBox[{"-", "8.656302345490463`"}], ",", "1.2620956957069898`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.057002475744293`"}], ",", "0.05074622284230745`", ",", 
       
       RowBox[{"-", "8.936530762323995`"}], ",", 
       RowBox[{"-", "8.680696512921179`"}], ",", "1.2629547974707511`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.057579168767612`"}], ",", "0.049115101737811626`", ",", 
       RowBox[{"-", "8.949951536421532`"}], ",", 
       RowBox[{"-", "8.696221080614652`"}], ",", "1.2634328885053394`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.057939677851781`"}], ",", "0.047865054770246225`", ",", 
       RowBox[{"-", "8.959077977396182`"}], ",", 
       RowBox[{"-", "8.706643722714949`"}], ",", "1.2637181801276607`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.0582063475130354`"}], ",", "0.04691223850226413`", ",", 
       RowBox[{"-", "8.96581305618296`"}], ",", 
       RowBox[{"-", "8.712570826444471`"}], ",", "1.263808057007009`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.0583459973256457`"}], ",", "0.046174884066934097`", 
       ",", 
       RowBox[{"-", "8.970195237931904`"}], ",", 
       RowBox[{"-", "8.719007153281943`"}], ",", "1.2640083122932422`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"34", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.058463660352525`"}], ",", "0.04560892894884497`", ",", 
       
       RowBox[{"-", "8.973635939881776`"}], ",", 
       RowBox[{"-", "8.722898703190682`"}], ",", "1.2640933756049098`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"36", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.058550617311512`"}], ",", "0.04516968274193596`", ",", 
       
       RowBox[{"-", "8.976233068099944`"}], ",", 
       RowBox[{"-", "8.725823158052835`"}], ",", "1.264154297536264`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"38", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.0586162313061442`"}], ",", "0.04482616128650121`", ",", 
       RowBox[{"-", "8.978223220836306`"}], ",", 
       RowBox[{"-", "8.728063564350185`"}], ",", "1.2641995479100347`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.0586666376195155`"}], ",", "0.04455531593709931`", ",", 
       RowBox[{"-", "8.979769079616029`"}], ",", 
       RowBox[{"-", "8.729805239298221`"}], ",", "1.264233982382184`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"42", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.058705954766482`"}], ",", "0.04433999670064334`", ",", 
       
       RowBox[{"-", "8.980984491450407`"}], ",", 
       RowBox[{"-", "8.73117617567738`"}], ",", "1.264260679784945`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"44", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.05873701922856`"}], ",", "0.04416740853732385`", ",", 
       RowBox[{"-", "8.981950512117965`"}], ",", 
       RowBox[{"-", "8.732267079826125`"}], ",", "1.2642816869574616`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"45", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.0587502859526663`"}], ",", "0.044094077280413`", ",", 
       RowBox[{"-", "8.982361075280483`"}], ",", 
       RowBox[{"-", "8.73273278811618`"}], ",", "1.264290725493836`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"46", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.0587618422048237`"}], ",", "0.04402795997438966`", ",", 
       RowBox[{"-", "8.982725939274646`"}], ",", 
       RowBox[{"-", "8.733143664704254`"}], ",", "1.2642984215982869`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"48", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.05878187533248`"}], ",", "0.04391441762738076`", ",", 
       RowBox[{"-", "8.98335399230616`"}], ",", 
       RowBox[{"-", "8.733854226871632`"}], ",", "1.2643118892143794`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"50", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.058798198677498`"}], ",", "0.0438212877920616`", ",", 
       RowBox[{"-", "8.983867047521278`"}], ",", 
       RowBox[{"-", "8.73443493803134`"}], ",", "1.2643228280232421`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"55", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.058827571212641`"}], ",", "0.043652504654583445`", ",", 
       RowBox[{"-", "8.9847923892006`"}], ",", 
       RowBox[{"-", "8.735479795428516`"}], ",", "1.2643422196352803`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"60", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.0588456780698228`"}], ",", "0.043543725885373155`", 
       ",", 
       RowBox[{"-", "8.985378091126162`"}], ",", 
       RowBox[{"-", "8.736177808789758`"}], ",", "1.2643564626549966`"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.544168513007102*^9, 3.5441685652604227`*^9, 3.544168645883996*^9, {
   3.5441694155907497`*^9, 3.544169422567996*^9}, 3.544169577271614*^9, 
   3.5441740377120028`*^9, 3.544174733188348*^9, 3.5441756512213583`*^9, {
   3.544175874236843*^9, 3.544175886377187*^9}, 3.544176147471731*^9, 
   3.544176262355722*^9, 3.544176364915814*^9, 3.544176453101461*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "\"\<R4(0,0)\>\"", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"datnew", "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "9"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.544168661510317*^9, 3.544168664693377*^9}, {
   3.54416942026315*^9, 3.544169420351262*^9}, 3.544175895150226*^9}],

Cell[BoxData["\<\"R4(0,0)\"\>"], "Print",
 CellChangeTimes->{
  3.5441686662713223`*^9, {3.5441694156395903`*^9, 3.5441694234000607`*^9}, 
   3.5441695773072653`*^9, 3.544174038812009*^9, 3.544174733255677*^9, 
   3.544175651334993*^9, {3.544175892134185*^9, 3.544175895410177*^9}, 
   3.544176147534342*^9, 3.544176262381097*^9, 3.5441763649758797`*^9, 
   3.544176453162486*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"20", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.054465642038616`"}], ",", "0.04257030568297808`", ",", 
       
       RowBox[{"-", "0.05019197316333411`"}], ",", "0.`", ",", 
       "0.029583227546802687`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0496889780189335`"}], ",", "0.04401441909635096`", ",", 
       RowBox[{"-", "0.0478690362523506`"}], ",", 
       RowBox[{"-", "3.3569930612570716`*^-25"}], ",", 
       "0.03478927353893008`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.04748921606342233`"}], ",", "0.044738795589115594`", 
       ",", 
       RowBox[{"-", "0.046790585291845245`"}], ",", "0.`", ",", 
       "0.037173723731336296`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.046476027907717224`"}], ",", "0.045098012419355675`", 
       ",", 
       RowBox[{"-", "0.04629029390354623`"}], ",", "0.`", ",", 
       "0.03826733206708616`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.04599071864597089`"}], ",", "0.04527481611670107`", 
       ",", 
       RowBox[{"-", "0.04604974490468196`"}], ",", "0.`", ",", 
       "0.038788171953351123`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.046837478220776316`"}], ",", "0.045398039311600184`", 
       ",", 
       RowBox[{"-", "0.046432063145721965`"}], ",", 
       RowBox[{"-", "4.113983285251722`*^-24"}], ",", 
       "0.037954470785331096`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0457788965568852`"}], ",", "0.04540894224734903`", ",", 
       RowBox[{"-", "0.04593960413705033`"}], ",", "0.`", ",", 
       "0.03902287233374016`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"34", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.045714253137836024`"}], ",", "0.045429609330265686`", 
       ",", 
       RowBox[{"-", "0.04590776699575545`"}], ",", "4.326481084229612`*^-25", 
       ",", "0.039090902062703665`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"36", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.04568790983867313`"}], ",", "0.045439944306264746`", 
       ",", 
       RowBox[{"-", "0.04589464340650832`"}], ",", "0.`", ",", 
       "0.03911884588185645`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"38", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.045676363045359075`"}], ",", "0.04544507205239757`", 
       ",", 
       RowBox[{"-", "0.04588885847613329`"}], ",", "0.`", ",", 
       "0.039131179312992884`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.045671396833373415`"}], ",", "0.04544761901434653`", 
       ",", 
       RowBox[{"-", "0.04588635874932734`"}], ",", "0.`", ",", 
       "0.03913655200224723`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"42", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.04566948489369639`"}], ",", "0.045448891724580914`", 
       ",", 
       RowBox[{"-", "0.04588538891084501`"}], ",", "0.`", ",", 
       "0.03913869164171571`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"44", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.045669023909078274`"}], ",", "0.04544953666459296`", 
       ",", 
       RowBox[{"-", "0.04588514512921152`"}], ",", 
       RowBox[{"-", "4.8545657193518895`*^-24"}], ",", 
       "0.03913929036262026`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"45", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.04566791115426266`"}], ",", "0.04545057069967043`", 
       ",", 
       RowBox[{"-", "0.045884543887403414`"}], ",", "5.86255085997899`*^-23", 
       ",", "0.03914052291327405`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"46", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.04566927574768472`"}], ",", "0.04544987316641788`", 
       ",", 
       RowBox[{"-", "0.04588525625520222`"}], ",", 
       RowBox[{"-", "9.068596457163472`*^-25"}], ",", 
       "0.039139129851970385`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"48", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.04566990969296381`"}], ",", "0.04545005961907844`", 
       ",", 
       RowBox[{"-", "0.045885554337660436`"}], ",", "9.917222075418604`*^-23",
        ",", "0.03913855937745367`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"50", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.04567081437305114`"}], ",", "0.045450175573315856`", 
       ",", 
       RowBox[{"-", "0.045885983075927825`"}], ",", 
       "1.0712122236426056`*^-23", ",", "0.03913770748762746`"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"55", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.045675381003285234`"}], ",", "0.04545042992986422`", 
       ",", 
       RowBox[{"-", "0.045888113672699994`"}], ",", 
       RowBox[{"-", "3.0606868169512212`*^-25"}], ",", 
       "0.03913322162088818`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"60", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.04565609626224707`"}], ",", "0.045449609893351194`", 
       ",", 
       RowBox[{"-", "0.045879230879355325`"}], ",", 
       RowBox[{"-", "3.5179850896925015`*^-23"}], ",", 
       "0.03915261443351277`"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.54416866627306*^9, {3.544169415641795*^9, 3.5441694234022503`*^9}, 
   3.544169577309226*^9, 3.5441740388142138`*^9, 3.5441747332579317`*^9, 
   3.544175651337496*^9, {3.54417589213896*^9, 3.544175895412653*^9}, 
   3.544176147538883*^9, 3.544176262383236*^9, 3.544176364977504*^9, 
   3.544176453164624*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "\"\<{ T, S... (0,1)\>\"", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"datnew", "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "10"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.544175900350803*^9, 3.5441759027820387`*^9}}],

Cell[BoxData["\<\"{ T, S... (0,1)\"\>"], "Print",
 CellChangeTimes->{3.544175903255414*^9, 3.544176147601343*^9, 
  3.544176262464189*^9, 3.544176365042775*^9, 3.544176453202056*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Part", "::", "partw"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Part \[NoBreak]\\!\\({1, 10}\\)\[NoBreak] of \[NoBreak]\\!\
\\({20, 0.005001369804579243`, 0.007575185560749764`, 0.01524674225436784`, \
0.0013116751528075641`, 0.0009079887555931024`, 0.0018160222561380657`, \
\\(\\({\\(\\(-2.0542438709019337`\\)\\), 0.05555105450536114`, \
\\(\\(-8.882666497212512`\\)\\), \\(\\(-8.615594691831443`\\)\\), \
1.260455765331497`}\\)\\), \\(\\({\\(\\(-0.054465642038616`\\)\\), \
0.04257030568297808`, \\(\\(-0.05019197316333411`\\)\\), 0.`, \
0.029583227546802687`}\\)\\)}\\)\[NoBreak] does not exist. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/partw\\\", \
ButtonNote -> \\\"Part::partw\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.544176147604539*^9, 3.544176262465687*^9, 
  3.544176365043953*^9, 3.544176453203549*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "20", ",", "0.005001369804579243`", ",", "0.007575185560749764`", ",", 
      "0.01524674225436784`", ",", "0.0013116751528075641`", ",", 
      "0.0009079887555931024`", ",", "0.0018160222561380657`", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.0542438709019337`"}], ",", "0.05555105450536114`", 
        ",", 
        RowBox[{"-", "8.882666497212512`"}], ",", 
        RowBox[{"-", "8.615594691831443`"}], ",", "1.260455765331497`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.054465642038616`"}], ",", "0.04257030568297808`", ",", 
        RowBox[{"-", "0.05019197316333411`"}], ",", "0.`", ",", 
        "0.029583227546802687`"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "22", ",", "0.0024716681699014365`", ",", "0.003910869396560157`", ",", 
      "0.007847642526238374`", ",", "0.0006172377018793982`", ",", 
      "0.00044036702786816827`", ",", "0.000880732519364326`", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.0560221195854447`"}], ",", "0.052859302659066895`", 
        ",", 
        RowBox[{"-", "8.915938658689136`"}], ",", 
        RowBox[{"-", "8.656302345490463`"}], ",", "1.2620956957069898`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.0496889780189335`"}], ",", "0.04401441909635096`", 
        ",", 
        RowBox[{"-", "0.0478690362523506`"}], ",", 
        RowBox[{"-", "3.3569930612570716`*^-25"}], ",", 
        "0.03478927353893008`"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "24", ",", "0.0012004090881623513`", ",", "0.0019909910057849256`", ",", 
      "0.003988745514803771`", ",", "0.00029101269508143864`", ",", 
      "0.00021321344655601286`", ",", "0.0004264270199516293`", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.057002475744293`"}], ",", "0.05074622284230745`", ",", 
        RowBox[{"-", "8.936530762323995`"}], ",", 
        RowBox[{"-", "8.680696512921179`"}], ",", "1.2629547974707511`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.04748921606342233`"}], ",", "0.044738795589115594`", 
        ",", 
        RowBox[{"-", "0.046790585291845245`"}], ",", "0.`", ",", 
        "0.037173723731336296`"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "26", ",", "0.0005785794542110594`", ",", "0.0010033731387844025`", ",", 
      "0.002008475666615439`", ",", "0.00013755606803851929`", ",", 
      "0.00010317380081150569`", ",", "0.00020634772954971055`", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.057579168767612`"}], ",", "0.049115101737811626`", 
        ",", 
        RowBox[{"-", "8.949951536421532`"}], ",", 
        RowBox[{"-", "8.696221080614652`"}], ",", "1.2634328885053394`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.046476027907717224`"}], ",", "0.045098012419355675`", 
        ",", 
        RowBox[{"-", "0.04629029390354623`"}], ",", "0.`", ",", 
        "0.03826733206708616`"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "28", ",", "0.0002837694372888766`", ",", "0.000504314048932919`", ",", 
      "0.0010081892674873583`", ",", "0.00006517431404246784`", ",", 
      "0.00004997519123249072`", ",", "0.00009995047183269506`", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.057939677851781`"}], ",", "0.047865054770246225`", 
        ",", 
        RowBox[{"-", "8.959077977396182`"}], ",", 
        RowBox[{"-", "8.706643722714949`"}], ",", "1.2637181801276607`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.04599071864597089`"}], ",", "0.04527481611670107`", 
        ",", 
        RowBox[{"-", "0.04604974490468196`"}], ",", "0.`", ",", 
        "0.038788171953351123`"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "30", ",", "0.00021668522276416035`", ",", "0.00025714513512808956`", 
      ",", "0.0005141752690898116`", ",", "0.000032871230763247775`", ",", 
      "0.000024540293506882748`", ",", "0.00004908085500486506`", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.0582063475130354`"}], ",", "0.04691223850226413`", 
        ",", 
        RowBox[{"-", "8.96581305618296`"}], ",", 
        RowBox[{"-", "8.712570826444471`"}], ",", "1.263808057007009`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.046837478220776316`"}], ",", "0.045398039311600184`", 
        ",", 
        RowBox[{"-", "0.046432063145721965`"}], ",", 
        RowBox[{"-", "4.113983285251722`*^-24"}], ",", 
        "0.037954470785331096`"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "32", ",", "0.0000666979918973611`", ",", "0.00013020814998276897`", ",",
       "0.00026038674414430307`", ",", "0.000014743730024190576`", ",", 
      "0.00001177613936790081`", ",", "0.00002355228157950789`", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.0583459973256457`"}], ",", "0.046174884066934097`", 
        ",", 
        RowBox[{"-", "8.970195237931904`"}], ",", 
        RowBox[{"-", "8.719007153281943`"}], ",", "1.2640083122932422`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.0457788965568852`"}], ",", "0.04540894224734903`", 
        ",", 
        RowBox[{"-", "0.04593960413705033`"}], ",", "0.`", ",", 
        "0.03902287233374016`"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "34", ",", "0.00003264652237820606`", ",", "0.00006553772805262259`", 
      ",", "0.00013106793415174067`", ",", "7.02456651628535`*^-6", ",", 
      "5.7237720608774304`*^-6", ",", "0.000011447544279194421`", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.058463660352525`"}], ",", "0.04560892894884497`", ",", 
        RowBox[{"-", "8.973635939881776`"}], ",", 
        RowBox[{"-", "8.722898703190682`"}], ",", "1.2640933756049098`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.045714253137836024`"}], ",", "0.045429609330265686`", 
        ",", 
        RowBox[{"-", "0.04590776699575545`"}], ",", "4.326481084229612`*^-25",
         ",", "0.039090902062703665`"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "36", ",", "0.000015887069052424998`", ",", "0.0000328261875700564`", 
      ",", "0.00006565047981554883`", ",", "3.3541081587601273`*^-6", ",", 
      "2.7837958042690854`*^-6", ",", "5.567591636167078`*^-6", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.058550617311512`"}], ",", "0.04516968274193596`", ",", 
        RowBox[{"-", "8.976233068099944`"}], ",", 
        RowBox[{"-", "8.725823158052835`"}], ",", "1.264154297536264`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.04568790983867313`"}], ",", "0.045439944306264746`", 
        ",", 
        RowBox[{"-", "0.04589464340650832`"}], ",", "0.`", ",", 
        "0.03911884588185645`"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "38", ",", "7.69611875133289`*^-6", ",", "0.000016491399644991134`", ",",
       "0.000032983276602394085`", ",", "1.60492622020929`*^-6", ",", 
      "1.355367390118426`*^-6", ",", "2.7107347743112116`*^-6", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.0586162313061442`"}], ",", "0.04482616128650121`", 
        ",", 
        RowBox[{"-", "8.978223220836306`"}], ",", 
        RowBox[{"-", "8.728063564350185`"}], ",", "1.2641995479100347`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.045676363045359075`"}], ",", "0.04544507205239757`", 
        ",", 
        RowBox[{"-", "0.04588885847613329`"}], ",", "0.`", ",", 
        "0.039131179312992884`"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "40", ",", "3.7644791266289643`*^-6", ",", "8.3156408192675`*^-6", ",", 
      "0.000016631403572553438`", ",", "7.70842723684545`*^-7", ",", 
      "6.60891364271197`*^-7", ",", "1.3217827531371505`*^-6", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.0586666376195155`"}], ",", "0.04455531593709931`", 
        ",", 
        RowBox[{"-", "8.979769079616029`"}], ",", 
        RowBox[{"-", "8.729805239298221`"}], ",", "1.264233982382184`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.045671396833373415`"}], ",", "0.04544761901434653`", 
        ",", 
        RowBox[{"-", "0.04588635874932734`"}], ",", "0.`", ",", 
        "0.03913655200224723`"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "42", ",", "1.8356107880422602`*^-6", ",", "4.1756627038314065`*^-6", 
      ",", "8.351356353797357`*^-6", ",", "3.732721460521147`*^-7", ",", 
      "3.22753049358792`*^-7", ",", "6.455061052246923`*^-7", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.058705954766482`"}], ",", "0.04433999670064334`", ",", 
        RowBox[{"-", "8.980984491450407`"}], ",", 
        RowBox[{"-", "8.73117617567738`"}], ",", "1.264260679784945`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.04566948489369639`"}], ",", "0.045448891724580914`", 
        ",", 
        RowBox[{"-", "0.04588538891084501`"}], ",", "0.`", ",", 
        "0.03913869164171571`"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "44", ",", "8.929090380175393`*^-7", ",", "2.089005683103551`*^-6", ",", 
      "4.178019218370466`*^-6", ",", "1.8340631819723047`*^-7", ",", 
      "1.5798946964796655`*^-7", ",", "3.159789386928278`*^-7", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.05873701922856`"}], ",", "0.04416740853732385`", ",", 
        
        RowBox[{"-", "8.981950512117965`"}], ",", 
        RowBox[{"-", "8.732267079826125`"}], ",", "1.2642816869574616`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.045669023909078274`"}], ",", "0.04544953666459296`", 
        ",", 
        RowBox[{"-", "0.04588514512921152`"}], ",", 
        RowBox[{"-", "4.8545657193518895`*^-24"}], ",", 
        "0.03913929036262026`"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "45", ",", "6.262093489365853`*^-7", ",", "1.4785142814499608`*^-6", ",",
       "2.9570325590366764`*^-6", ",", "1.3009223523494841`*^-7", ",", 
      "1.1078511576932887`*^-7", ",", "2.215702293697842`*^-7", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.0587502859526663`"}], ",", "0.044094077280413`", ",", 
        
        RowBox[{"-", "8.982361075280483`"}], ",", 
        RowBox[{"-", "8.73273278811618`"}], ",", "1.264290725493836`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.04566791115426266`"}], ",", "0.04545057069967043`", 
        ",", 
        RowBox[{"-", "0.045884543887403414`"}], ",", "5.86255085997899`*^-23",
         ",", "0.03914052291327405`"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "46", ",", "4.3740119917009654`*^-7", ",", "1.0415193991697436`*^-6", 
      ",", "2.083040830269667`*^-6", ",", "9.26796973435529`*^-8", ",", 
      "7.773966251404551`*^-8", ",", "1.5547932598115786`*^-7", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.0587618422048237`"}], ",", "0.04402795997438966`", 
        ",", 
        RowBox[{"-", "8.982725939274646`"}], ",", 
        RowBox[{"-", "8.733143664704254`"}], ",", "1.2642984215982869`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.04566927574768472`"}], ",", "0.04544987316641788`", 
        ",", 
        RowBox[{"-", "0.04588525625520222`"}], ",", 
        RowBox[{"-", "9.068596457163472`*^-25"}], ",", 
        "0.039139129851970385`"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "48", ",", "3.0779505980437527`*^-7", ",", "5.233939901483353`*^-7", ",",
       "1.046787423963913`*^-6", ",", "4.987791015242932`*^-8", ",", 
      "3.873128667300274`*^-8", ",", "7.746257461743156`*^-8", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.05878187533248`"}], ",", "0.04391441762738076`", ",", 
        
        RowBox[{"-", "8.98335399230616`"}], ",", 
        RowBox[{"-", "8.733854226871632`"}], ",", "1.2643118892143794`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.04566990969296381`"}], ",", "0.04545005961907844`", 
        ",", 
        RowBox[{"-", "0.045885554337660436`"}], ",", 
        "9.917222075418604`*^-23", ",", "0.03913855937745367`"}], "}"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "50", ",", "3.466570472703435`*^-7", ",", "2.6304463240922615`*^-7", ",",
       "5.260890805214302`*^-7", ",", "2.9799979231612354`*^-8", ",", 
      "1.974723799224399`*^-8", ",", "3.949447802795248`*^-8", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.058798198677498`"}], ",", "0.0438212877920616`", ",", 
        
        RowBox[{"-", "8.983867047521278`"}], ",", 
        RowBox[{"-", "8.73443493803134`"}], ",", "1.2643228280232421`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.04567081437305114`"}], ",", "0.045450175573315856`", 
        ",", 
        RowBox[{"-", "0.045885983075927825`"}], ",", 
        "1.0712122236426056`*^-23", ",", "0.03913770748762746`"}], "}"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "55", ",", "8.951368555519978`*^-7", ",", "8.52314036015045`*^-8", ",", 
      "1.7042699873570655`*^-7", ",", "2.166125146612805`*^-8", ",", 
      "5.705226660626252`*^-9", ",", "1.1410445448163512`*^-8", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.058827571212641`"}], ",", "0.043652504654583445`", 
        ",", 
        RowBox[{"-", "8.9847923892006`"}], ",", 
        RowBox[{"-", "8.735479795428516`"}], ",", "1.2643422196352803`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.045675381003285234`"}], ",", "0.04545042992986422`", 
        ",", 
        RowBox[{"-", "0.045888113672699994`"}], ",", 
        RowBox[{"-", "3.0606868169512212`*^-25"}], ",", 
        "0.03913322162088818`"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "60", ",", "2.445388985761299`*^-6", ",", "2.4590967884208226`*^-7", ",",
       "4.914722905313695`*^-7", ",", "5.5944575005527204`*^-8", ",", 
      "5.768152341283815`*^-9", ",", "1.153629782506312`*^-8", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.0588456780698228`"}], ",", "0.043543725885373155`", 
        ",", 
        RowBox[{"-", "8.985378091126162`"}], ",", 
        RowBox[{"-", "8.736177808789758`"}], ",", "1.2643564626549966`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.04565609626224707`"}], ",", "0.045449609893351194`", 
        ",", 
        RowBox[{"-", "0.045879230879355325`"}], ",", 
        RowBox[{"-", "3.5179850896925015`*^-23"}], ",", 
        "0.03915261443351277`"}], "}"}]}], "}"}]}], "}"}], 
  "\[LeftDoubleBracket]", 
  RowBox[{"All", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "10"}], "}"}]}], "\[RightDoubleBracket]"}]], "Output",
 CellChangeTimes->{3.54417590325896*^9, 3.544176147613625*^9, 
  3.544176262468114*^9, 3.5441763650461493`*^9, 3.544176453206171*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Process", "Subsubtitle",
 CellChangeTimes->{{3.539899260141288*^9, 3.539899297289146*^9}, {
  3.541840445367931*^9, 3.541840450071163*^9}, {3.541840628970079*^9, 
  3.5418406299368773`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"datlist", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "\"\<N\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "\"\<Max |\[Phi]|\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "\"\<Max |Ricci|\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "\"\<Max |R2|\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "\"\<Int |\[Phi]|\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "\"\<Int |Ricci|\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "\"\<Int |R2|\>\""}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.541840702890521*^9, 3.5418407245534763`*^9}, 
   3.541840791667498*^9, {3.541843007465967*^9, 3.541843019433546*^9}, {
   3.541843086288761*^9, 3.541843141797089*^9}, {3.5419279543755293`*^9, 
   3.5419279588970203`*^9}, {3.544168733916223*^9, 3.544168761363316*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"fn", "=", 
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Log", "[", 
        RowBox[{"10", ",", "y"}], "]"}]}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5398967726403*^9, 3.539896811850618*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos1", "=", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"plt2", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"fn", "@@@", 
        RowBox[{"Thread", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"datnew", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", 
              RowBox[{"datlist", "[", 
               RowBox[{"[", 
                RowBox[{"pos1", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}], ",", 
           RowBox[{"datnew", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", 
              RowBox[{"datlist", "[", 
               RowBox[{"[", 
                RowBox[{"pos2", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}]}], 
          "}"}], "]"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Hue", "[", "0.6", "]"}], "}"}]}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"Show", "[", 
      RowBox[{"plt2", ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"datlist", "[", 
           RowBox[{"[", 
            RowBox[{"pos1", ",", "2"}], "]"}], "]"}], ",", 
          RowBox[{"datlist", "[", 
           RowBox[{"[", 
            RowBox[{"pos2", ",", "2"}], "]"}], "]"}]}], "}"}]}]}], "]"}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
   RowBox[{"{", 
    RowBox[{"pos2", ",", "2", ",", "4"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.5398967561531057`*^9, 3.539896796444601*^9}, 
   3.539898439637827*^9, {3.539949826885099*^9, 3.539949847532065*^9}, {
   3.539949905899968*^9, 3.53994995217867*^9}, {3.539957734047173*^9, 
   3.539957797230307*^9}, {3.53995950255326*^9, 3.539959514617424*^9}, {
   3.5399812304344473`*^9, 3.5399812530821333`*^9}, {3.5399839966998158`*^9, 
   3.5399840134090977`*^9}, {3.5400464442327843`*^9, 3.540046458208152*^9}, {
   3.541840665888206*^9, 3.541840676823649*^9}, {3.54184072921821*^9, 
   3.541840913286421*^9}, {3.5418429139676533`*^9, 3.541842928335372*^9}, {
   3.541842971005507*^9, 3.541842990671466*^9}, {3.541843026803639*^9, 
   3.541843033133144*^9}, {3.541843159575173*^9, 3.5418431984702673`*^9}, {
   3.541843229468863*^9, 3.541843241358378*^9}, 3.541843276700141*^9, {
   3.541843357315482*^9, 3.541843361355706*^9}, {3.542441082905068*^9, 
   3.542441129430141*^9}, {3.5424417361283703`*^9, 3.542441736262867*^9}, {
   3.542450559283257*^9, 3.542450570852919*^9}, {3.5441687741156073`*^9, 
   3.544168776243391*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQDQEmDht+CXO7ZDAdgPDNHCYLff2hfpsFyrdwOBn0
a05HLDuUb+VwQtzKct0zTijfxuHYw4P9wQk8UL6dw4+3PLstAnihfAcH3R1f
T0hvEYDyHR0+Pli6+8pHQSjfyWH5JIkpikbCUL6zQ6zPT53SEhEo38Vh3Y1Z
WVWbRKF8VwfO1Lr6xx/FoHw3B5Eny6fHG0lA+A1uDsUrXA5oXIDyGdwdHC56
a+7Nl4TyPRyM7Fcrs/JIQfmeDjMkRIpUrkPlG7wdDA/LPHU2hOn3c4idJ/cq
pEjsAAAawlTe
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"N\"", TraditionalForm], 
    FormBox["\"Max |\[Phi]|\"", TraditionalForm]},
  AxesOrigin->{20., 0},
  PlotRange->{{20., 60.}, {-6.511738354994849, 0}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Print",
 CellChangeTimes->{{3.541843199097535*^9, 3.5418432102216597`*^9}, 
   3.5418432429247828`*^9, 3.541843277588459*^9, 3.541843361923048*^9, 
   3.541928833511001*^9, 3.5419290218013697`*^9, {3.5424410652305613`*^9, 
   3.542441130079093*^9}, 3.542441737278977*^9, {3.5424505501332912`*^9, 
   3.542450571556435*^9}, 3.5424513230920763`*^9, 3.54245138744206*^9, 
   3.542451461837307*^9, 3.542451621567634*^9, 3.542452596658401*^9, 
   3.5424530833657427`*^9, 3.542453917214725*^9, {3.542455409583921*^9, 
   3.542455435053499*^9}, 3.54245551385142*^9, 3.542455904501981*^9, 
   3.54245656793717*^9, 3.542456701501598*^9, 3.5424568273830976`*^9, 
   3.542456870552787*^9, 3.542456916977112*^9, 3.542457149437358*^9, 
   3.542457914936095*^9, 3.543666936803714*^9, 3.543667184793209*^9, 
   3.5436683103964767`*^9, {3.5441677611361027`*^9, 3.544167770454155*^9}, 
   3.544167903598267*^9, 3.544168715101201*^9, {3.544168763630713*^9, 
   3.544168776633271*^9}, 3.5441694288201237`*^9, 3.544174047045714*^9, 
   3.5441747344224157`*^9, 3.544175656142761*^9, 3.544175909630094*^9, 
   3.544176151040691*^9, 3.544176262574931*^9, 3.544176365175351*^9, 
   3.544176453416044*^9}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQDQEmDvyNzSsYvjMcgPDNHNRMp5qyOTND+RYOQk1e
fY2zWaF8KwcW+R47xr/sUL6Nw+95sc73ErigfDuHQtureV+280D5Dg7h32un
WojyQ/mODsYBT9a93C0A5Ts5+N20e5H8XhDKd3bQXvjIrl1RGMp3cbjPJnSb
LUgEynd1EFtxvS+hRRTKd3NgDC7Zn7hDDMJvcHM4vZfZSTJIHCrv7jDtt9/s
F29hfA+HP7xZMa/lJaF8T4eejepnHwdKQfV7O4haeT4WcJeByvs5GMo/br6R
L3UAABQhUYU=
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"N\"", TraditionalForm], 
    FormBox["\"Max |Ricci|\"", TraditionalForm]},
  AxesOrigin->{20., 0},
  PlotRange->{{20., 60.}, {-7.069400359482207, 0}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Print",
 CellChangeTimes->{{3.541843199097535*^9, 3.5418432102216597`*^9}, 
   3.5418432429247828`*^9, 3.541843277588459*^9, 3.541843361923048*^9, 
   3.541928833511001*^9, 3.5419290218013697`*^9, {3.5424410652305613`*^9, 
   3.542441130079093*^9}, 3.542441737278977*^9, {3.5424505501332912`*^9, 
   3.542450571556435*^9}, 3.5424513230920763`*^9, 3.54245138744206*^9, 
   3.542451461837307*^9, 3.542451621567634*^9, 3.542452596658401*^9, 
   3.5424530833657427`*^9, 3.542453917214725*^9, {3.542455409583921*^9, 
   3.542455435053499*^9}, 3.54245551385142*^9, 3.542455904501981*^9, 
   3.54245656793717*^9, 3.542456701501598*^9, 3.5424568273830976`*^9, 
   3.542456870552787*^9, 3.542456916977112*^9, 3.542457149437358*^9, 
   3.542457914936095*^9, 3.543666936803714*^9, 3.543667184793209*^9, 
   3.5436683103964767`*^9, {3.5441677611361027`*^9, 3.544167770454155*^9}, 
   3.544167903598267*^9, 3.544168715101201*^9, {3.544168763630713*^9, 
   3.544168776633271*^9}, 3.5441694288201237`*^9, 3.544174047045714*^9, 
   3.5441747344224157`*^9, 3.544175656142761*^9, 3.544175909630094*^9, 
   3.544176151040691*^9, 3.544176262574931*^9, 3.544176365175351*^9, 
   3.544176453422041*^9}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQDQEmDrlCe99tEfy7H8I3c9Bdd/H7pOsMByB8C4fL
07l21hgyQ/lWDvynazbsmswK5ds4vEvOeb/vBzuUb+fwt6jtwxJ/LijfweEF
bzLzhTU8UL6jg9Ke2yxx/PxQvpPD9Suz/6juFoDynR1aUoVTXN4KQvkuDtV2
UReOyApD+a4OvzzOvZULEIHy3RyOvV4crNAiCuE3uDn0nZn29LqsGFTe3WHr
12uey3fC+B4OV3Lumq16LQ7lezrUVQQvWiQrCdXv7RBu7TrzuZA0VN7P4cAa
zbXPrSUPAAC831uh
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"N\"", TraditionalForm], 
    FormBox["\"Max |R2|\"", TraditionalForm]},
  AxesOrigin->{20., 0},
  PlotRange->{{20., 60.}, {-6.768461603975843, 0}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Print",
 CellChangeTimes->{{3.541843199097535*^9, 3.5418432102216597`*^9}, 
   3.5418432429247828`*^9, 3.541843277588459*^9, 3.541843361923048*^9, 
   3.541928833511001*^9, 3.5419290218013697`*^9, {3.5424410652305613`*^9, 
   3.542441130079093*^9}, 3.542441737278977*^9, {3.5424505501332912`*^9, 
   3.542450571556435*^9}, 3.5424513230920763`*^9, 3.54245138744206*^9, 
   3.542451461837307*^9, 3.542451621567634*^9, 3.542452596658401*^9, 
   3.5424530833657427`*^9, 3.542453917214725*^9, {3.542455409583921*^9, 
   3.542455435053499*^9}, 3.54245551385142*^9, 3.542455904501981*^9, 
   3.54245656793717*^9, 3.542456701501598*^9, 3.5424568273830976`*^9, 
   3.542456870552787*^9, 3.542456916977112*^9, 3.542457149437358*^9, 
   3.542457914936095*^9, 3.543666936803714*^9, 3.543667184793209*^9, 
   3.5436683103964767`*^9, {3.5441677611361027`*^9, 3.544167770454155*^9}, 
   3.544167903598267*^9, 3.544168715101201*^9, {3.544168763630713*^9, 
   3.544168776633271*^9}, 3.5441694288201237`*^9, 3.544174047045714*^9, 
   3.5441747344224157`*^9, 3.544175656142761*^9, 3.544175909630094*^9, 
   3.544176151040691*^9, 3.544176262574931*^9, 3.544176365175351*^9, 
   3.544176453428071*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos1", "=", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"plt2", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"fn", "@@@", 
        RowBox[{"Thread", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"datnew", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", 
              RowBox[{"datlist", "[", 
               RowBox[{"[", 
                RowBox[{"pos1", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}], ",", 
           RowBox[{"datnew", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", 
              RowBox[{"datlist", "[", 
               RowBox[{"[", 
                RowBox[{"pos2", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}]}], 
          "}"}], "]"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Hue", "[", "0.6", "]"}], "}"}]}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"Show", "[", 
      RowBox[{"plt2", ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"datlist", "[", 
           RowBox[{"[", 
            RowBox[{"pos1", ",", "2"}], "]"}], "]"}], ",", 
          RowBox[{"datlist", "[", 
           RowBox[{"[", 
            RowBox[{"pos2", ",", "2"}], "]"}], "]"}]}], "}"}]}]}], "]"}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
   RowBox[{"{", 
    RowBox[{"pos2", ",", "5", ",", "7"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.5398967561531057`*^9, 3.539896796444601*^9}, 
   3.539898439637827*^9, {3.539949826885099*^9, 3.539949847532065*^9}, {
   3.539949905899968*^9, 3.53994995217867*^9}, {3.539957734047173*^9, 
   3.539957797230307*^9}, {3.53995950255326*^9, 3.539959514617424*^9}, {
   3.5399812304344473`*^9, 3.5399812530821333`*^9}, {3.5399839966998158`*^9, 
   3.5399840134090977`*^9}, {3.5400464442327843`*^9, 3.540046458208152*^9}, {
   3.541840665888206*^9, 3.541840676823649*^9}, {3.54184072921821*^9, 
   3.541840913286421*^9}, {3.5418429139676533`*^9, 3.541842928335372*^9}, {
   3.541842971005507*^9, 3.541842990671466*^9}, {3.541843026803639*^9, 
   3.541843033133144*^9}, {3.541843159575173*^9, 3.5418431984702673`*^9}, {
   3.541843229468863*^9, 3.541843241358378*^9}, 3.541843276700141*^9, {
   3.541843357315482*^9, 3.541843361355706*^9}, {3.542441082905068*^9, 
   3.542441129430141*^9}, {3.5424417361283703`*^9, 3.542441736262867*^9}, {
   3.542450559283257*^9, 3.542450570852919*^9}, {3.5441687741156073`*^9, 
   3.54416879023277*^9}, {3.54416884961057*^9, 3.544168850586046*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQDQEmDt0Ml8U28rEfgPDNHOZkrXBRX8sJ5Vs4+CVK
dL3w5IHyrRxWFqjsSnnCB+XbOPixfduTtE8Ayrdz4PVce/r4O0Eo38FBQODz
tIhgYSjf0cFIU/0o/1wRKN/JYc6DKIXzT0WhfGcHtqA6/bm64lC+i0P4TXe7
/cUSUL6rw0f952/stklC+W4OfH18bc6fpCD8BjeHR2bf1jN2S0Pl3R2W3mw7
eU5RBsr3cMhXcu4KN5WF8j0d/CS6FNOl5KD6vR327N4wyWkFlM/g57B6VfVu
bybZAwC5tVGL
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"N\"", TraditionalForm], 
    FormBox["\"Int |\[Phi]|\"", TraditionalForm]},
  AxesOrigin->{20., 0},
  PlotRange->{{20., 60.}, {-7.6643164558763, 0}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Print",
 CellChangeTimes->{3.544168790833075*^9, 3.544168851224454*^9, 
  3.5441694295626087`*^9, 3.5441740554143467`*^9, 3.544174735624606*^9, 
  3.544175656200448*^9, 3.544175910286021*^9, 3.544176151093034*^9, 
  3.544176262632235*^9, 3.5441763652292337`*^9, 3.5441764534750147`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQDQEmDmEzOV7cDOU4AOGbOVyZJLaw/CYXlG/hcKZ9
V8m0OF4o38ohU/j7VtMn/FC+jcPPrSu3VpoIQvl2DrNmbY45XCAE5Ts4pMtM
YvTeLgzlOzpoRHTIK/0QgfKdHCIVz//aYCEG5Ts7WB6exHWsQhzKd3HwZDe6
pL9DAsp3dbD5M3vDq2+SUL6bQ84M0cuzTKQh/AY3BxnvbWXFl6B8BneH1rTy
+N/5MlC+h4NIpqvE5aWyUL6ng4P97eNpF+Wg+r0dPlX5njlZowCV93NgWS+Q
GlmlcAAANvVVyQ==
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"N\"", TraditionalForm], 
    FormBox["\"Int |Ricci|\"", TraditionalForm]},
  AxesOrigin->{20., 0},
  PlotRange->{{20., 60.}, {-8.243727096994437, 0}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Print",
 CellChangeTimes->{3.544168790833075*^9, 3.544168851224454*^9, 
  3.5441694295626087`*^9, 3.5441740554143467`*^9, 3.544174735624606*^9, 
  3.544175656200448*^9, 3.544175910286021*^9, 3.544176151093034*^9, 
  3.544176262632235*^9, 3.5441763652292337`*^9, 3.544176453481112*^9}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQDQEmDp6yux8GvmU9AOGbORhHb5zztYADyrdwMGIO
+Cn8jQvKt3JI/LtffXM1L5Rv4yAza0KaBYMAlG/n4BLa1tFoIwjlOzhEeDKf
5GwWgvIdHTIOi796cFgYyndyMFVecDSfRRTKd3b4KDXzaouLGJTv4vDKau6c
d83iUL6rg8I5t+qVhySgfDeH6nuS8yIZpCD8BjcH15ivjkbzoHwGd4eJm+y1
dllLQ/keDly/DzyaWCgD5Xs6nLHxn6g6Vxaq39thudja8qCj8lB5P4cNDVnL
Cg/IHwAAkHZTfA==
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"N\"", TraditionalForm], 
    FormBox["\"Int |R2|\"", TraditionalForm]},
  AxesOrigin->{20., 0},
  PlotRange->{{20., 60.}, {-7.942697400989039, 0}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Print",
 CellChangeTimes->{3.544168790833075*^9, 3.544168851224454*^9, 
  3.5441694295626087`*^9, 3.5441740554143467`*^9, 3.544174735624606*^9, 
  3.544175656200448*^9, 3.544175910286021*^9, 3.544176151093034*^9, 
  3.544176262632235*^9, 3.5441763652292337`*^9, 3.544176453486415*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{"Fit", "[", 
    RowBox[{
     RowBox[{"fn", "@@@", 
      RowBox[{"Thread", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"datnew", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", 
            RowBox[{"datlist", "[", 
             RowBox[{"[", 
              RowBox[{"pos1", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}], ",", 
         RowBox[{"datnew", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", 
            RowBox[{"datlist", "[", 
             RowBox[{"[", 
              RowBox[{"3", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}]}], "}"}], 
       "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "x"}], "}"}], ",", "x"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{"tmp", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "20", ",", "50"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"fn", "@@@", 
       RowBox[{"Thread", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"datnew", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", 
             RowBox[{"datlist", "[", 
              RowBox[{"[", 
               RowBox[{"pos1", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}], ",", 
          
          RowBox[{"datnew", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", 
             RowBox[{"datlist", "[", 
              RowBox[{"[", 
               RowBox[{"3", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}]}], "}"}],
         "]"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Hue", "[", "0.6", "]"}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.54245674720265*^9, 3.5424568034490767`*^9}, {
  3.5424569232397614`*^9, 3.542456923303692*^9}, {3.543666947760214*^9, 
  3.543666951628304*^9}}],

Cell[BoxData[
 RowBox[{"0.36891993964962183`", "\[VeryThinSpace]", "-", 
  RowBox[{"0.1332659812819676`", " ", "x"}]}]], "Output",
 CellChangeTimes->{
  3.5424568350034533`*^9, 3.542456870688485*^9, {3.542456917066584*^9, 
   3.542456923825878*^9}, 3.542457149874111*^9, 3.54245791500002*^9, {
   3.54366694080194*^9, 3.543666952219605*^9}, 3.543667188447228*^9, 
   3.54366831045052*^9, 3.544167763076189*^9, 3.544167904900423*^9, 
   3.54416882262676*^9, 3.544168879523032*^9, 3.544169430563725*^9, 
   3.544174058217558*^9, 3.5441747364454517`*^9, 3.5441756562488947`*^9, 
   3.54417591102251*^9, 3.544176151148263*^9, 3.544176262678536*^9, 
   3.5441763652754793`*^9, 3.544176453517528*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVkGtUjAkYgJuZZlRSzTQ1820i20xq0pTO0E31Npfmk5VBIaTL5hCO2CVd
1mbJpXI704pk2Ek6ReLMpG1r5V1dLAmhJlKRoutol9Jl0tofz3l+Puc882IT
Vm2mGhkZLf/K/45VysyMjERwfkesjhFFRbaju8kGqgg4D4S3MmKoWKflMsqN
RZA9f1JpHkdF5+YByg5TEZzoyg5lxVNRz1GO61giSFtXV2f/IxWTVR29N/gi
iJM6l4mOUvF00b57UctEIJytPx17g4p3qovT7+SIoKYhOaR6mop+e0K+cfNd
BItaxb9MXKfhsGq7sP7pIuA0ZXVeVRjjgaFlI9FbF8ONUUupYNgY3eu36orN
vCD7vmyHUEVHrjXDe06+F/Qcm6wqDGCgQ1+nFoK94eBI7OPLQwyk9SR1xb33
hpaT9L6E3Bk4N1x5qmy/D+SynQU3fUxwfWjvWo2DLxTKDcK9703wUVX1xbYK
X5i3RbGhNMMU7VeEnWOE+kGYtvNEubMZZm13ut75wQ+aShzSJc1m6GlIgu4j
S+C28o1amjgTx2xMPuQI/OFfftihBzxzzA1fo1jW4A+veyjb5z4xxz2mfA/X
mADwV7qn9CbMwp3BHq5/0ALh7YDF8sX2Fqj+XFXwQ14gjC/cKR+rtsBx7t3Z
Q3MB1vLT6IE7LdHq/mFU7wL4Pb8nTjDLCiXaDMfBKoCJoob1CZFWyOhy/fXE
rCB4ezhTk1hmhe9CLGprI4KAFmE6p4LORG2wovGngiD4+e4V85hwJlod9ejO
GgmCS1S7yIfXmJhBWVnpESSGz96Kv3YbmKhEy4sLssXwSbbp6IvVLDzGEm4o
fiuG5X0ZT4qKWZh38biuSiiB9oN73TTjLPRPyIjhH5AA66PP4H6FNRqS66/y
HkogLaK6+pDaGos43zcW2EpBviaa/c+wNXaPq6ZSt0jhlktbg4OcjUtsiaFe
jRQiPtqczTzLRt4+z/4SYxlcznapLdez0YV1vJCxUgY8wZSxPdigHciWvMmT
AWWt/u/+Uzao0lzoZA3JIH19hT7lnQ36RYnEL72DwT9M7CzzssV4xTbNWGYw
XOBdqWk6aYvpz6cnz7YFw5osflddty3+qWw2bnSSA9m7mf1JxMFDZ5baRSTJ
ocMurag7i4Nbnk4Np9TKoUS2TmHZzkHvfOZv9pYktNBXpKoXcDG3vGYjJ5qE
KxfmmIwe5CKHXt5aeI2Eay6lRenPuNihDvAfKyHB27x14+BzLhYE3FMvLSWh
Vk9hhrVw0TOpddvgTRI6tOHJji+4GDowYVhYTgIzYGrp3Q4uHm4KnHcbSUha
9d3AdB8XP6ruxz9rJkGa2u+WakRgpe+qRzwdCU2R7K4uCoEHdC89E1tJiISA
nBAagRbMwUluGwn76MovBINAQbrFyU2vSbh6yudxxUwCY7at1vT1k2BVcGzX
qC2BzjNe2foNkqA6ouFt4hKovxyXenyIBJf4V611BIE/te+Vug+TIBF6BJ2Z
TeA5xbmWPSMkJFbomKJvCYwacvCrHyWBlkepz3Mk0Cmz+BJnjITT+11TaHwC
y2oqt1ZOfO2L07qezicwNVrSONNAghe/OMfXhUDxVMPCyKmvf2Y8C8kXEGhy
Piyn9AsJin7DF9MFBD5e3D4xPU1C+0Mn7W43Av8DnTg00g==
      "]]}}, {{}, 
    {Hue[0.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQDQEmDvyNzSsYvjMcgPDNHNRMp5qyOTND+RYOQk1e
fY2zWaF8KwcW+R47xr/sUL6Nw+95sc73ErigfDuHQtureV+280D5Dg7h32un
WojyQ/mODsYBT9a93C0A5Ts5+N20e5H8XhDKd3bQXvjIrl1RGMp3cbjPJnSb
LUgEynd1EFtxvS+hRRTKd3NgDC7Zn7hDDMJvcHM4vZfZSTJIHCrv7jDtt9/s
F29hfA+HP7xZMa/lJaF8T4eejepnHwdKQfV7O4haeT4WcJeByvs5GMo/br6R
L3UAABQhUYU=
      "]]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{20., -6.300000000000001},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5424568350034533`*^9, 3.542456870688485*^9, {3.542456917066584*^9, 
   3.542456923825878*^9}, 3.542457149874111*^9, 3.54245791500002*^9, {
   3.54366694080194*^9, 3.543666952219605*^9}, 3.543667188447228*^9, 
   3.54366831045052*^9, 3.544167763076189*^9, 3.544167904900423*^9, 
   3.54416882262676*^9, 3.544168879523032*^9, 3.544169430563725*^9, 
   3.544174058217558*^9, 3.5441747364454517`*^9, 3.5441756562488947`*^9, 
   3.54417591102251*^9, 3.544176151148263*^9, 3.544176262678536*^9, 
   3.5441763652754793`*^9, 3.544176453519353*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{"Fit", "[", 
    RowBox[{
     RowBox[{"fn", "@@@", 
      RowBox[{"Thread", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"datnew", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", 
            RowBox[{"datlist", "[", 
             RowBox[{"[", 
              RowBox[{"pos1", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}], ",", 
         RowBox[{"datnew", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", 
            RowBox[{"datlist", "[", 
             RowBox[{"[", 
              RowBox[{"3", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}]}], "}"}], 
       "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "x"}], "}"}], ",", "x"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{"tmp", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "30", ",", "50"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"fn", "@@@", 
       RowBox[{"Thread", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"datnew", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", 
             RowBox[{"datlist", "[", 
              RowBox[{"[", 
               RowBox[{"pos1", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}], ",", 
          
          RowBox[{"datnew", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", 
             RowBox[{"datlist", "[", 
              RowBox[{"[", 
               RowBox[{"3", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}]}], "}"}],
         "]"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Hue", "[", "0.6", "]"}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.54245674720265*^9, 3.5424568034490767`*^9}, {
  3.543666957948079*^9, 3.54366696265212*^9}}],

Cell[BoxData[
 RowBox[{"0.36891993964962183`", "\[VeryThinSpace]", "-", 
  RowBox[{"0.1332659812819676`", " ", "x"}]}]], "Output",
 CellChangeTimes->{{3.542456773379547*^9, 3.5424568039193974`*^9}, 
   3.542457149977521*^9, 3.542457915076902*^9, {3.543666955002363*^9, 
   3.543666963287323*^9}, 3.543667191069242*^9, 3.543668310504661*^9, 
   3.544167906287181*^9, 3.544168823779394*^9, 3.5441688807249804`*^9, 
   3.544169431499054*^9, 3.544174060287393*^9, 3.5441747373457813`*^9, 
   3.5441756562899237`*^9, 3.54417591247311*^9, 3.544176151190658*^9, 
   3.5441762627090282`*^9, 3.544176365313611*^9, 3.5441764535499573`*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVjHs41XccgFmmXA7nfs6vXHYk1kq5pSWOz7l/uxyNLhRWWioq0mGxCqsV
c2rMpZ71RKVcyqwUuXXaZ6EyspFIF+R2qtXcxszO0eyP93mf959XsD3KP+wD
AwMD5Qz/W2zeaWxgIASPScNtn82hocXdmA8zDIXQre4e05nQsPMg3ch+lhBO
2GqSr5jRcH+fwpAYC6FDHnftA0sanq++9W+auRDis/+cLuPQULc7a9iWEoLG
9VkONZ+Gt+rXPfVxFYJkX9mzXm8aLkq8V5K4Qwh+vTsDYlU0TFA+36lqEcL5
N28P5Whp+Dcrp2HJch9Qp1vTWRssMCDX1fePsz4wNP2rftcdC2SI40ZPzQL4
Vv0DH10s0aT0R6apB8DP5cxLYTmWeEs5vhL3ArASNznNNqFjwNqPJ77MA/hm
du+yNWI6mt13Pv59G0B9l3ii/CAdY6KU1oOmIrCVuSvzSuk4nOmTmustAjI1
FVSupeO2uVYpAVEi+ImVxKu0YuDxZvO01fkiWHI7O9xrEwM1060RFztEcORm
kkqrZuDV4JJ1rhZi6F+hY7HvMTDV6kB9rUQMKfYeoc7vGZgQaE6vihWDPkS2
U+XORMe71V+8KhZDqsOA4aeRTOwrFJ481CUGrfeWjfMvM3FDTbuGcCQQ0r/V
J72LiZXOm5O4ayRgOTS//S2PhUvtSnnkiATSicZ+v5KFQSLryps3JbDIRWsS
m8zCs88/dzo2KIGs3YMFFzQsfNiZ6raeLwUvo8vDNaMsLDdqFIf4SkG3ZPT3
wMVsvF7c49CYJAV1ESfcajsbtyWZslUVUnArbTgTeo6NRhU2GfPeSYGy8VKd
fszGmvA5A462MmjuPGY8aspBx9XGosiNMjhnH+z8m5SDBQWd0fwUGXjeMWE+
+oqDVNgZt9oqGXBux164d42DIr/w6cIhGcxZdaB+5WsOHq6i5w4L5NBkL83r
sOHi3nVNclWgHIrSCjjjgVyMCg2p26yWw/pVXbAijYthj5+0gkYOK3e18ffV
cZF+cPeb0LGZZgcl201zsTnrYfvgAgWY0StKpt14KOqRN+UHK+Cvs5cigiN5
WHTqqn9YhgLmpfq2XSnkoV1FX0lKnQLoD5rHrV/w0M/ChTk4pQDb7O4SFo+P
mS/Xryl0IqC/Xm/trORjAzeUE76VAOUS4el1lI9l8Udf7cgmoITz7xpq+Hgj
MD697j4Bv9wrgQkjfFz+y8KE/AcEjHrmOkSO8vH2wqd7TjQQqBScHAsZ42P9
lKeCNBKwyY/8znucj0/O6fSNzQTeFrvV6Sb5qO9J3PPoMYHjVZqlhwwoJOEn
5L19BKrbWozjLCl82OLhXttPIJIradtFp9DfUyu4PEBAEFh2MYBBYZAZ0Ydp
CaQ8O+21nEVhZIlJ2es3BDb2Bh2Y4FKYNXJSMDJCYHho4EWMDYXUFm/L1lEC
l1wCinfYUph7953uxhiBANWDuA0fUViY6fskZpyAZuIqy92Owupl9LTJSQJq
fdSqsQUUCnPxcOc/BLx9XnL7HCisNY6OqJ4iMJLk39/qSGFTR4vssG7mZ7Qs
8cZCCv3gqFuInoCZvGBt3icUthe5CoTTBO4k8+ZmLKJwC6PPwvY9geiGFO3X
iynsjs/UvZ/pBWZTZdFOFP4H274yBA==
      "]]}}, {{}, 
    {Hue[0.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQDQEmDvyNzSsYvjMcgPDNHNRMp5qyOTND+RYOQk1e
fY2zWaF8KwcW+R47xr/sUL6Nw+95sc73ErigfDuHQtureV+280D5Dg7h32un
WojyQ/mODsYBT9a93C0A5Ts5+N20e5H8XhDKd3bQXvjIrl1RGMp3cbjPJnSb
LUgEynd1EFtxvS+hRRTKd3NgDC7Zn7hDDMJvcHM4vZfZSTJIHCrv7jDtt9/s
F29hfA+HP7xZMa/lJaF8T4eejepnHwdKQfV7O4haeT4WcJeByvs5GMo/br6R
L3UAABQhUYU=
      "]]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{30., -6.300000000000001},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.542456773379547*^9, 3.5424568039193974`*^9}, 
   3.542457149977521*^9, 3.542457915076902*^9, {3.543666955002363*^9, 
   3.543666963287323*^9}, 3.543667191069242*^9, 3.543668310504661*^9, 
   3.544167906287181*^9, 3.544168823779394*^9, 3.5441688807249804`*^9, 
   3.544169431499054*^9, 3.544174060287393*^9, 3.5441747373457813`*^9, 
   3.5441756562899237`*^9, 3.54417591247311*^9, 3.544176151190658*^9, 
   3.5441762627090282`*^9, 3.544176365313611*^9, 3.544176453551663*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"datnew", "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "8"}], "}"}]}], "]"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"20", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.0542438709019337`"}], ",", "0.05555105450536114`", ",", 
       RowBox[{"-", "8.882666497212512`"}], ",", 
       RowBox[{"-", "8.615594691831443`"}], ",", "1.260455765331497`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.0560221195854447`"}], ",", "0.052859302659066895`", 
       ",", 
       RowBox[{"-", "8.915938658689136`"}], ",", 
       RowBox[{"-", "8.656302345490463`"}], ",", "1.2620956957069898`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.057002475744293`"}], ",", "0.05074622284230745`", ",", 
       
       RowBox[{"-", "8.936530762323995`"}], ",", 
       RowBox[{"-", "8.680696512921179`"}], ",", "1.2629547974707511`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.057579168767612`"}], ",", "0.049115101737811626`", ",", 
       RowBox[{"-", "8.949951536421532`"}], ",", 
       RowBox[{"-", "8.696221080614652`"}], ",", "1.2634328885053394`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.057939677851781`"}], ",", "0.047865054770246225`", ",", 
       RowBox[{"-", "8.959077977396182`"}], ",", 
       RowBox[{"-", "8.706643722714949`"}], ",", "1.2637181801276607`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.0582063475130354`"}], ",", "0.04691223850226413`", ",", 
       RowBox[{"-", "8.96581305618296`"}], ",", 
       RowBox[{"-", "8.712570826444471`"}], ",", "1.263808057007009`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.0583459973256457`"}], ",", "0.046174884066934097`", 
       ",", 
       RowBox[{"-", "8.970195237931904`"}], ",", 
       RowBox[{"-", "8.719007153281943`"}], ",", "1.2640083122932422`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"34", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.058463660352525`"}], ",", "0.04560892894884497`", ",", 
       
       RowBox[{"-", "8.973635939881776`"}], ",", 
       RowBox[{"-", "8.722898703190682`"}], ",", "1.2640933756049098`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"36", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.058550617311512`"}], ",", "0.04516968274193596`", ",", 
       
       RowBox[{"-", "8.976233068099944`"}], ",", 
       RowBox[{"-", "8.725823158052835`"}], ",", "1.264154297536264`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"38", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.0586162313061442`"}], ",", "0.04482616128650121`", ",", 
       RowBox[{"-", "8.978223220836306`"}], ",", 
       RowBox[{"-", "8.728063564350185`"}], ",", "1.2641995479100347`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.0586666376195155`"}], ",", "0.04455531593709931`", ",", 
       RowBox[{"-", "8.979769079616029`"}], ",", 
       RowBox[{"-", "8.729805239298221`"}], ",", "1.264233982382184`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"42", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.058705954766482`"}], ",", "0.04433999670064334`", ",", 
       
       RowBox[{"-", "8.980984491450407`"}], ",", 
       RowBox[{"-", "8.73117617567738`"}], ",", "1.264260679784945`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"44", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.05873701922856`"}], ",", "0.04416740853732385`", ",", 
       RowBox[{"-", "8.981950512117965`"}], ",", 
       RowBox[{"-", "8.732267079826125`"}], ",", "1.2642816869574616`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"45", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.0587502859526663`"}], ",", "0.044094077280413`", ",", 
       RowBox[{"-", "8.982361075280483`"}], ",", 
       RowBox[{"-", "8.73273278811618`"}], ",", "1.264290725493836`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"46", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.0587618422048237`"}], ",", "0.04402795997438966`", ",", 
       RowBox[{"-", "8.982725939274646`"}], ",", 
       RowBox[{"-", "8.733143664704254`"}], ",", "1.2642984215982869`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"48", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.05878187533248`"}], ",", "0.04391441762738076`", ",", 
       RowBox[{"-", "8.98335399230616`"}], ",", 
       RowBox[{"-", "8.733854226871632`"}], ",", "1.2643118892143794`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"50", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.058798198677498`"}], ",", "0.0438212877920616`", ",", 
       RowBox[{"-", "8.983867047521278`"}], ",", 
       RowBox[{"-", "8.73443493803134`"}], ",", "1.2643228280232421`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"55", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.058827571212641`"}], ",", "0.043652504654583445`", ",", 
       RowBox[{"-", "8.9847923892006`"}], ",", 
       RowBox[{"-", "8.735479795428516`"}], ",", "1.2643422196352803`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"60", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.0588456780698228`"}], ",", "0.043543725885373155`", 
       ",", 
       RowBox[{"-", "8.985378091126162`"}], ",", 
       RowBox[{"-", "8.736177808789758`"}], ",", "1.2643564626549966`"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.544169037563737*^9, 3.54416943260242*^9, 
  3.54417407029139*^9, 3.544174738296486*^9, 3.544175656332954*^9, 
  3.544175913950276*^9, 3.544176151225545*^9, 3.5441762627411213`*^9, 
  3.5441763653726463`*^9, 3.5441764535844316`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
   "Print", "[", 
    "\"\<\\n\\nSimple EXP convergence plot for: T,A...(0,0)\\n\\n\>\"", "]"}],
    ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varlist", "=", 
    RowBox[{"{", 
     RowBox[{
     "\"\<T\>\"", ",", "\"\<A\>\"", ",", "\"\<B\>\"", ",", "\"\<F\>\"", ",", 
      "\"\<S\>\""}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"tmp", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"datnew", "[", 
         RowBox[{"[", 
          RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
        RowBox[{"datnew", "[", 
         RowBox[{"[", 
          RowBox[{"All", ",", "8", ",", "ii"}], "]"}], "]"}]}], "}"}], 
      "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"lastval", "=", 
     RowBox[{"tmp", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "2"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp2", "=", 
     RowBox[{"N", "[", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"Log", "[", 
            RowBox[{"10", ",", 
             RowBox[{"Abs", "[", 
              RowBox[{"y", "-", "lastval"}], "]"}]}], "]"}]}], "}"}]}], "]"}],
        "@@@", 
       RowBox[{"tmp", "[", 
        RowBox[{"[", 
         RowBox[{"1", ";;", 
          RowBox[{"-", "2"}]}], "]"}], "]"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpfit", "=", 
     RowBox[{"Fit", "[", 
      RowBox[{
       RowBox[{"tmp2", "[", 
        RowBox[{"[", 
         RowBox[{"1", ";;", 
          RowBox[{"-", "5"}]}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "x"}], "}"}], ",", "x"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"plt1", "=", 
     RowBox[{"ListPlot", "[", "tmp2", "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"plt2", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{"tmpfit", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "20", ",", "50"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<var = \>\"", ",", 
      RowBox[{"varlist", "[", 
       RowBox[{"[", "ii", "]"}], "]"}], ",", "\"\<\\n\\nFit = \>\"", ",", 
      "tmpfit", ",", "\"\<\\n\>\""}], "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"Show", "[", 
      RowBox[{"plt1", ",", "plt2", ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
   RowBox[{"{", 
    RowBox[{"ii", ",", "1", ",", "5"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.544174988043232*^9, 3.544175140416996*^9}, {
  3.544175190968801*^9, 3.544175204863388*^9}, {3.544175242432678*^9, 
  3.5441752432563257`*^9}, {3.544175513713191*^9, 3.544175533383417*^9}, {
  3.544175930871953*^9, 3.5441760916138077`*^9}, {3.5441763274675627`*^9, 
  3.5441763400516577`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"\\n\\nSimple EXP convergence plot for: \
T,A...(0,0)\\n\\n\"\>"], "Print",
 CellChangeTimes->{{3.5441751879919243`*^9, 3.5441752054444103`*^9}, 
   3.5441752438433313`*^9, 3.544175277034851*^9, 3.544175401074678*^9, {
   3.544175516200308*^9, 3.544175533818831*^9}, 3.544175656359126*^9, {
   3.5441759476258907`*^9, 3.544176010351519*^9}, {3.544176069534834*^9, 
   3.544176092015217*^9}, 3.5441761512649717`*^9, 3.544176262780559*^9, {
   3.544176334386072*^9, 3.544176365413699*^9}, 3.5441764536227493`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"var = \"\>", "\[InvisibleSpace]", "\<\"T\"\>", 
   "\[InvisibleSpace]", "\<\"\\n\\nFit = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "1.1861867853388608`"}], "-", 
    RowBox[{"0.06425912705138677`", " ", "x"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[
  "var = ", "T", "\n\nFit = ", -1.1861867853388608` - 
   0.06425912705138677 $CellContext`x, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.5441751879919243`*^9, 3.5441752054444103`*^9}, 
   3.5441752438433313`*^9, 3.544175277034851*^9, 3.544175401074678*^9, {
   3.544175516200308*^9, 3.544175533818831*^9}, 3.544175656359126*^9, {
   3.5441759476258907`*^9, 3.544176010351519*^9}, {3.544176069534834*^9, 
   3.544176092015217*^9}, 3.5441761512649717`*^9, 3.544176262780559*^9, {
   3.544176334386072*^9, 3.544176365413699*^9}, 3.544176453624206*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{20., -2.3370715837717473`}, {22., -2.5492032122906103`}, {
      24., -2.7344269903163}, {26., -2.897391616071616}, {
      28., -3.0428716978041166`}, {30., -3.194274537976611}, {
      32., -3.30130738631643}, {34., -3.4179164948204783`}, {
      36., -3.530088545777334}, {38., -3.6393180636022167`}, {
      40., -3.747048838513948}, {42., -3.854731155315636}, {
      44., -3.963934930590923}, {45., -4.020487512265408}, {
      46., -4.076570150355361}, {48., -4.195160688248327}, {
      50., -4.3234948480925635`}, {
      55., -4.742156923906079}}]}, {}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVz3081AccwHE5zuM9/PSAUITWsnLZke48fA+nX4kklwkV68HDUi8TwjYb
J9KDqc6VEZdyWrU8TDql70Z0ayc1cqVchUVcWSUPsdvtj+/r+3r/8/28vnYx
+0J26ero6ARq5/8dU8Q31tFhQ3dScGDUbQrOs3c2jNBlQ4HlRfJEGwVv11lQ
G/TYwEOKn7ydgsu6R+Z8ZcSGy7RrHNc/KPjavGiqx4wNuVKbZbR7FDxY2jf0
iyMb3Ppe6d5UUrBQmtq+PYANonXCRutRCt5qrs65JWLDF7Yy+ydmeshNXr9w
BccVvnuX3qDarYdjpQkr2x64wjO5hhLyqx5mqQPGd8S6QVm4QwxHVx+d22J7
qo1Xgw6jPLNKoI8Wc6nuiySrobRdtSn7nD7aDqvqwN8d+s6n9PdP6CNlMO3F
zpfukOl5WShbT8XFgqLj9d+sgVBl1QtNMRW3Bg2F1dpyoFM89VE+QsWOpuay
3kYOCCMZnbocA7TZGCqmBnFB/Ki1vibXAAsSll5WveFCUOZ9weAjA3SZSYOB
XA/wXiKpOfSJIU7ON3wjWu4JXWq5/EqGIZ4WbAkOuOsJbUk/vg3oMMRkI0eW
U7QXvJ22fhhmZYSJ/iyn6xRvaJFqDgwlGmHFRFNlUok3KMIvdL68YYRTFr9b
qxcDZLAqXyYQxsiUC7FiP0Ae8hi7dxqjb12+/WgTgGLzuX86aoyR+sLp5FEa
D66ZRhbe0DfBv9fTW1vDedB7RzlsEWqCdf7BisxKHkR6jW8eKTdB5iHWQME4
D354FJvu894E8+dskrF4PvA8tTzC0McUi5BR9tkJHxjgOk+FiEwxz2xlRHW/
D/CvR1XNHTbFkrIjPU0rfUG1Jpjp60ZDz3350Y5ZvmDz7LTrRD4NZw62XXT4
0xdE+VXzFyppKDX/UlG5wA8SRkOpdQ50HJgqnc3Y4weDyeF1nal09FhgqR6q
9QOxzhKrqNt0dEh1eXVJjw9jNTzvREsGfmp25AJ1Ex++3+246PUeBloB3+N5
CR/2d0lpA/UMLK39SWWm5oNu/W+RznpM5G5n+zx294dYDZPp4MTEuOD42snD
/lD+tMAuQsDEnC7Nx+Jef8gTb+EqvmXijaJuPcXStWAqyK5NOc/E7FPrrMLT
1kJMZe+hmHtM3PNgdiy9dS0Ixk/JhB+Y6C4hym0YJHxYUj7eb03g6YaWSPMd
JMT3dx/L8SfQXL9BeeFnEtLP7xVG7iWwr8LLc/ISCbYlqyeMEgms9GqvWHeF
hLbCOXHXtHZJU8aPXiWByDy1wWw/gUEj0zOrGkiQhtyceyeJQOF9b7ubSEK3
xlTyeRqB70rlcX91k8DaeqnZOJtAGSekw6GHhIcbU1iNWmf1PHZJUWr7fJDs
yiGQTox+tOjV9lhdQhQSuDyHfmzbMxKiDGY2pOQRGB2/uXb4FQmH6wN6nx8l
cJnBkwXcUe39i/MDjx8j8PW5nRlH1Nr+WVWzx3ECM58e8HMe0/5T8LWkuJBA
cbD4YfI4CY3RJXGBJwjcrrbltn0gYVvYrt5prZcerj5rPkkCJdA5UHqSwPoW
WaxsmoQg9xYWRURgxg5fhckMCe9XHJVc1dpn9u6qqFkSztiHzdtWTKDhmVDR
lX9J8La0yzURE3jP7em0RkPCIH1kolHr/wDerTx3
      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{20., 0},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Print",
 CellChangeTimes->{{3.5441751879919243`*^9, 3.5441752054444103`*^9}, 
   3.5441752438433313`*^9, 3.544175277034851*^9, 3.544175401074678*^9, {
   3.544175516200308*^9, 3.544175533818831*^9}, 3.544175656359126*^9, {
   3.5441759476258907`*^9, 3.544176010351519*^9}, {3.544176069534834*^9, 
   3.544176092015217*^9}, 3.5441761512649717`*^9, 3.544176262780559*^9, {
   3.544176334386072*^9, 3.544176365413699*^9}, 3.544176453626395*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"var = \"\>", "\[InvisibleSpace]", "\<\"A\"\>", 
   "\[InvisibleSpace]", "\<\"\\n\\nFit = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "0.8654564257335289`"}], "-", 
    RowBox[{"0.0533026671050557`", " ", "x"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[
  "var = ", "A", "\n\nFit = ", -0.8654564257335289 - 
   0.0533026671050557 $CellContext`x, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.5441751879919243`*^9, 3.5441752054444103`*^9}, 
   3.5441752438433313`*^9, 3.544175277034851*^9, 3.544175401074678*^9, {
   3.544175516200308*^9, 3.544175533818831*^9}, 3.544175656359126*^9, {
   3.5441759476258907`*^9, 3.544176010351519*^9}, {3.544176069534834*^9, 
   3.544176092015217*^9}, 3.5441761512649717`*^9, 3.544176262780559*^9, {
   3.544176334386072*^9, 3.544176365413699*^9}, 3.54417645363218*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{20., -1.9205536033085868`}, {22., -2.0307902506037228`}, {
      24., -2.1425169165375766`}, {26., -2.2540375424678523`}, {
      28., -2.3643826794304723`}, {30., -2.472561821641905}, {
      32., -2.5798530419507775`}, {34., -2.6850372394025035`}, {
      36., -2.7888909822384367`}, {38., -2.891964501958995}, {
      40., -2.9949954502861917`}, {42., -3.098939201640802}, {
      44., -3.2050363359021583`}, {45., -3.2593599283301184`}, {
      46., -3.314944640440258}, {48., -3.4309870887491654`}, {
      50., -3.5566401378216717`}, {
      55., -3.963455859367176}}]}, {}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVj3041AccwM8d9+J+O1JhSTTnsrx7zut5+bpzd79YXiopWWgqsdKLldAz
z5RSrLqWxK6QksganluxuW+pk3lZaSHmpaIoFz0mp3CzPz7P58/P81m5LWnd
diqFQlm7wP/eJhPrUyh88KzidBx8Pa9cYuXI3ELlwz2D4cWHR+eVD2pM6Qpd
PgTtqw9PezuvtHn6VudbFh+28uOffT8+r3xnIpvpMuJDZt3dwRPT88rD8v6R
X6z50KpKHi9gaJVnrh9qig7iQ8xAD6FcpVUqG8qPKvP4cMKwTMqI1yoFyYHL
7L1cYYux2CZ+UquckCc6qDpcIdBaK1R5UTBDHTQVE+8G+5Xbb55NpaCjKr6r
XN8domxD1j5QUtB0Md1jRYk7pDqoKiIpOmg5OlADEg/YTEO/TRIdpA2nvIh7
7QHibpGBwSkdtAiXna494glxAeHyVS06GBk8ElFt6QUBP4zGXDekYnt9w6Xe
216wMYL98mQYFc1DNuTTgwVw0O63It5ZKp5K5N0cGBdAxJPhc6s7qegymwJD
Wd6QuKhEfMaYhpqlzPG81T4AK5/bbY2i4cXwjaFBLT7whfONkOEiGiazrJ1s
Y33Bo5vi3D5Iwz0SJ9s7ND/ghPVILXi6WDxdX7q/0A9MY/3NO3bo4ozpveVq
C4AXQlsbdaUuGjYfw+K9AHXcy3vuvtdFUU221Vg9wAN50YFpZz2kv7D9Kfcz
f5CNcKvOH9LDV4Gc+/c3+8PZP93Kzt/WwxpJaFt6qT/IKzt6gzV6aHjcaejU
lD8kxrwX7/WhY7ZOWJ2TvxASK+R7Jo/QUYYGl+zOCcH+YWtrfyMdTxg5bCl/
KYTZoWM7MpkMLLyU01XvIIK5/NaGbJKBPknZsdYZIsAVeV9pchk4e1h1g9sq
AoVAnf+wnYHXTb5pKzUOgNub2i3XcZg4NCOfS9sZAOlSl37ReiZ6G3+uHqkO
gANtVpEXzjGRe8jlTaWuGGyt89nrnzHxS6Oca/QwMZgsKUjbu4yFZiD2fl4o
Bg6Nt0oayUJ59c8DRmoxPGzkM7Mus1AQzRf2eEig1uxxGW+QhbtCE6o1JyWw
TTyR7sjTx6N/az9d6JWAedLF3PcJ+vi77KluG08K+k6PopZW6GPm+TVmm1Ok
cOdedmzxhD7u7JibSL0vhcKxR9zTzmz0KFlUZG5AQrZxiZXbPjZeVDRGmcSQ
4Gn0IUKsYKOJnqL7WgUJy692BSo+sLG/2NdHU0kCNZrO6pxmY6lvU/GaKhJe
mbo2TWnY6JLSnTB2i4RbOTKR6yc2Br/9OOusIEGcvNa7VsvGY4/9Vv6BJOwW
NdpXMwmclDfvevKUhIbnVYZVywis81rXzu0i4UphX3ubGYEZXT0uB7tJOB5O
5KqXE8hZNPbJtJeEsOZdLHsLAlcf5fy4dXChf4tLrbQiMDZhffXoGxI4GQWT
5XYE2jD+MRaMkfCvZ/OvzfYEvrsSl5ajJqF7cjpp1IHA9L7vAhwnSCjZGT5m
40xgfmh+Z/IUCe4hhsNlrgRGqy0Fqg8L/yy/K01uBPJOll820ZCg07g79rU7
gbWNdfF1H0locWvp43kRmBYjamPPLvxPzBRKBAQK51qcv54jIe+GTeQObwKZ
BRvyquZJSI2LMM3yIfAvt76PWi0J0SuyOq/6Evgf8Ds1zQ==
      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{20., 0},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Print",
 CellChangeTimes->{{3.5441751879919243`*^9, 3.5441752054444103`*^9}, 
   3.5441752438433313`*^9, 3.544175277034851*^9, 3.544175401074678*^9, {
   3.544175516200308*^9, 3.544175533818831*^9}, 3.544175656359126*^9, {
   3.5441759476258907`*^9, 3.544176010351519*^9}, {3.544176069534834*^9, 
   3.544176092015217*^9}, 3.5441761512649717`*^9, 3.544176262780559*^9, {
   3.544176334386072*^9, 3.544176365413699*^9}, 3.544176453634263*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"var = \"\>", "\[InvisibleSpace]", "\<\"B\"\>", 
    "\[InvisibleSpace]", "\<\"\\n\\nFit = \"\>", "\[InvisibleSpace]", 
    "0.11808725387571034`"}], "\[VeryThinSpace]", "-", 
   RowBox[{
    RowBox[{"0.059386612623449825`", " ", "x"}], 
    "\[InvisibleSpace]", "\<\"\\n\"\>"}]}],
  SequenceForm[
  "var = ", "B", "\n\nFit = ", 0.11808725387571034` - 
   0.059386612623449825` $CellContext`x, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.5441751879919243`*^9, 3.5441752054444103`*^9}, 
   3.5441752438433313`*^9, 3.544175277034851*^9, 3.544175401074678*^9, {
   3.544175516200308*^9, 3.544175533818831*^9}, 3.544175656359126*^9, {
   3.5441759476258907`*^9, 3.544176010351519*^9}, {3.544176069534834*^9, 
   3.544176092015217*^9}, 3.5441761512649717`*^9, 3.544176262780559*^9, {
   3.544176334386072*^9, 3.544176365413699*^9}, 3.54417645363974*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{20., -0.9883805311979484}, {22., -1.1583938375215872`}, {
      24., -1.3111591805265415`}, {26., -1.4506710815229606`}, {
      28., -1.580042373479991}, {30., -1.708519372111559}, {
      32., -1.8186466072228191`}, {34., -1.9302523300068004`}, {
      36., -2.038815196677817}, {38., -2.1453982351271783`}, {
      40., -2.2511136687831135`}, {42., -2.3571795164940372`}, {
      44., -2.4650125256184707`}, {45., -2.5204224088596128`}, {
      46., -2.576401613605376}, {48., -2.6937682883076763`}, {
      50., -2.820723002843472}, {55., -3.232323348176832}}]}, {}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVxXk41GkcAPBhZl606yxMuZ+GLcrVFLn6Ymb8sIXowNpI68g+XRQtWyoq
VyJNtUIym6ZU60hFet8txyNRaRkPiw27ORtTETMju/vH5/mY7d6/9QdlGo22
+T//vzuft4RG44CJ3QNDrpEUL1tpoxqqzIHoTLr2CRMpbqpmoVoGB+4N+zGf
mEnxqq4JpR/VOOAmGJ1ysJDi9/r582IdDoTJl2MrGyk+WjQwes+cA4VNKRFL
3aX4/M3Ell2+HNAL8bgxtEeK8RNRGhZwQPNUu82JCil2TvBZsdZpPZj1h916
7vUBTxfFWTd3rgeVN6W4tecDTp3ynQmP2QB9Z/uqp6M+YpvmGLFoiQN08nM1
2UqfMGspcjS+7gDF12aZ6nmfsOnYYDXwHSFbuSdSee0Mpv+dNLTnnSPEsu9d
M2mewSbb8nNrft4IrKGNSR+CZnHIltEdVaZOMFHu9uC1ZBZ31D8p7nvoBPlq
n89HpX7GRn5Bl9EWZ7Cw+tV7pcYczoqzuDMocYb+oPbYyfI5bK9IgpHTLhCz
QsSOc5jHc7qqEoGlK+iNfuHPds7jK9u2+/u2uULlYR9KFCfDCWrmtlYRbmBW
4j2iLZPhfXxbq0f0TXD/1dN3pwvkuPRzvfBQ4SYwKJakV7IVeJ711HDKBEAY
L8gaJQqs1ZpOSg8AGKmtO+AVsoA9qzNWTtYDRDudkoSOLWA0ZFWQo+4O3fGb
u1PSvuB/fDQaG4PdYYV3245A3UVczfdvTxG6g8+A28OAskWsdcZ2JGvGHV66
6sFdYxrJUAqos3X3gMjeqIPnomgkn2gWr7ngAarJCd0JNTRyVsc6VDTsAUK5
wlJCUyKFxdniemtPsPQZ/JZLKRHX/RkR5qme8PvVY9dLLioRxdHmW+wXnuDZ
kNjU1a9EbupHtgv1uFDXMCEuYSuTkfmiheRoLnCfGhofOKhMXPSWT41WceFB
QbmdwSNlwk60H69g8MA1TpL0AtHJap3sGyiABxWaeTk7/ejEAHgubwt5oFNw
Jy9JQCdFVVcHdaZ4kGF4prV4mE6cd3E8eh35MH6orqPEikFi/fdWzWXyIaz9
lkr5UQZJ+2NRfqmPDy0qerYezQzyOL+L0W7hBQZafeYP1Znk1EVvg+AkLzhu
GObHCWWS6M6F6Z8avaBj1pGfVcYkjte1rxlpUrCsMnfNkXEmuVL77Dv9cAri
9pfxox0Q0WfW9ty4TcEduZb1uuOIDJS6uc5VUOCYymyMT0VE6NZS6n2XgmcM
WXDNCUTsk3r2Tv5GQa/6cPr6NES2TMgUdrUUqJre73fIQCT99SazBkJBJDc4
x+UCIh+LWmPfdFHAyimd5JUjUue0tYMtpkCoLTh5+iYiqeJe+yM9FFgLMlkt
IkQ0tCflrD4KeCXxXKoCEcs0jXPf/0VBfCXvqk8lIhF7A6vGxino6Brz9atH
ZJXKn3rOkxSEhAy8zX2MyPuyPcnZUxSMDHQmvmpAJKX/MNdmmgL5u/qyAILI
Zf/L3QkzFKyW5cgDmxDZNWXq3DxLwf1jJ/MKmhGxyBSV6M9RAPTEb7paEKl5
VhdTJ6Ngx9fhgdufI5Ic7tn+lYKC4fNBY4I2RDwW2uzCFijYp+t9XPwCEdVf
ggR3v1Awf8VVl9WByMsN/bLFRQrSjO1v73yJyL+8VU+V
      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{20., 0},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Print",
 CellChangeTimes->{{3.5441751879919243`*^9, 3.5441752054444103`*^9}, 
   3.5441752438433313`*^9, 3.544175277034851*^9, 3.544175401074678*^9, {
   3.544175516200308*^9, 3.544175533818831*^9}, 3.544175656359126*^9, {
   3.5441759476258907`*^9, 3.544176010351519*^9}, {3.544176069534834*^9, 
   3.544176092015217*^9}, 3.5441761512649717`*^9, 3.544176262780559*^9, {
   3.544176334386072*^9, 3.544176365413699*^9}, 3.544176453641995*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"var = \"\>", "\[InvisibleSpace]", "\<\"F\"\>", 
    "\[InvisibleSpace]", "\<\"\\n\\nFit = \"\>", "\[InvisibleSpace]", 
    "0.18448363661676498`"}], "\[VeryThinSpace]", "-", 
   RowBox[{
    RowBox[{"0.05964155159852413`", " ", "x"}], 
    "\[InvisibleSpace]", "\<\"\\n\"\>"}]}],
  SequenceForm[
  "var = ", "F", "\n\nFit = ", 0.18448363661676498` - 
   0.05964155159852413 $CellContext`x, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.5441751879919243`*^9, 3.5441752054444103`*^9}, 
   3.5441752438433313`*^9, 3.544175277034851*^9, 3.544175401074678*^9, {
   3.544175516200308*^9, 3.544175533818831*^9}, 3.544175656359126*^9, {
   3.5441759476258907`*^9, 3.544176010351519*^9}, {3.544176069534834*^9, 
   3.544176092015217*^9}, 3.5441761512649717`*^9, 3.544176262780559*^9, {
   3.544176334386072*^9, 3.544176365413699*^9}, 3.544176453648219*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{20., -0.9187134942283315}, {22., -1.097586609800756}, {
      24., -1.2558534037270705`}, {26., -1.3984100808482494`}, {
      28., -1.5296764637365625`}, {30., -1.6269595247615842`}, {
      32., -1.7652131248744414`}, {34., -1.876831175454937}, {
      36., -1.984864545306018}, {38., -2.090751913422563}, {
      40., -2.195685419942392}, {42., -2.3008881684858253`}, {
      44., -2.407742282149925}, {45., -2.4628081675462656`}, {
      46., -2.5179637992732595`}, {48., -2.6338420118172468`}, {
      50., -2.7587348165542505`}, {
      55., -3.156136264112635}}]}, {}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVxX081HccAPA7D18hkuah5CHd6UG7ZBe68/Dh3PlFJJNIHquFVNaIoq1t
ZGRt3Zo8dEqsZUXlpHbi+y3SLHoQY4lLWtNxdc3Tcc5t++P9ei+LPxCyW4tG
owX+5//jhXwDGo0N9bY1Mid7Bf5g+dp5kVpskM1VhKYwFPie2BLV67DBZqC4
6aqDAq/sHqEn67Ph+NkcIctRgd9aCKd7TNkQtjiKs4atwIdFA8NXmWyYNJ2f
v0KgwN9fSr8fE8AGF5S0yiZJgXFTVTYuZMPNUWaCYa0Cc1P9l3zIWQ/uga35
msD3WCHay2rtXA9MLaVSJH2Pj8kDJmITXKAzTc6M2/8PXtua0FNl4AraRw2V
Hvpj2HIRcrO54AolvRKze8Vj2O6NVAwCNxDfF/budhnH2n9lvNz1txucSmNt
d3w8jm23Cr+rO7oButIjV5TGTODtQcPbau04UGJ0vZihmsAPG5rK+m5xoGXq
zLbwgklsvTm0CAVxQXzep+vakil8Yq9DtfQdF5j9ZpP2N6aw82wGvDruDqp9
R3Z68ZVYaTbvXeFqDwgT6h1KG1Ti4q1hwQEPPCA1Ldzv8ZFpnKrPdHKM84Sp
K5xd3fozeL/AyfFXbS/QpPMdxitncPlUQ+XBUi9IOjP4UeN6FZ62vLtUbgsQ
7n/x9blOFTZpyyHlKQBGt1nhPyfPYp44b/loAwDjK8osYnYWo5eOp7818oY7
ffnpjCI1fu1v3NIS4Q3NedHMklVzWCwI7siq9IbcyYlT7Ftz2CTX6dWJCW94
MnmjYjhEg/PoWyRO3j5wNECP7jekwUKyoGzNDz7QW0y+lHrRyDemrMiqIR8I
2RfzsrqARkrLCnoaWDzQyFoTtnTRiMeBvDjmMR7sq717h25PJ7OHW39htPPA
mJELuUl0csliZ0eluS+YpFXbnLtOJ6+mRerMPb7QvSDhUfMcnbibL5YP1/pC
e+jIT40CLcJId5Zd0eFD9pDW5pbTWmSVacFFtIUPKUuHrM/3axEr4LsPlvKh
kc3cZMzUJqLas1JTOR/aC1Wb8g5qE24M2+eZmwCMKko++1OiTRKDk2qV+QJY
ON2R7KKvQ7K7NKozfQJIY+28xwzTIbeF3TodDn5gZHyHJxPpkK9/3GgVkeEH
n7iKTzeM6JA9nWrFkRY/eG+w3zCerUvcLiw8b72AAmlj/mBJpi4prm/eYRFL
wUkJN//Fb7rEQre+9+JlClLiboSrTBAZKPf0UF6hIPL6TJCHKSKVnvfLN9ZQ
wKcD/4tFiDhn9CaNXqPAqvz3ddrmiASNzMyuq6eg9YXUwNAKkZwnXssaCQXW
sQaNS5iIjInaEp92U9AWHbOMswERCSfkIaOHgrqaSossDiLHep45H+qloGzu
jVETFxHjhaMqyz4KUstSZ7w9EVmdbXwy+gUFtgN5TzfyEIlL+rj2jYyCQ1F1
ORGBiKzUe27OHaUgtno6szQIkbcVuzIL5BT4qz0P9m9GJKs/zXetggI7UVt0
XAgiRcFFf6ROUND+fMA1cRsiMXI7buskBTfXMFiXwxFxyK86Z6Gk4EJWIkMe
gUhdsyRBMkNB+tJxk093IJIZy+swnKUgPnmDnjgKER/1g3VRagoCb3+uHo9G
ZF5JaGHNHAWu81vGXGIReeTSP6PRUGC/Q1+WEYfIv1fqS5I=
      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{20., 0},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Print",
 CellChangeTimes->{{3.5441751879919243`*^9, 3.5441752054444103`*^9}, 
   3.5441752438433313`*^9, 3.544175277034851*^9, 3.544175401074678*^9, {
   3.544175516200308*^9, 3.544175533818831*^9}, 3.544175656359126*^9, {
   3.5441759476258907`*^9, 3.544176010351519*^9}, {3.544176069534834*^9, 
   3.544176092015217*^9}, 3.5441761512649717`*^9, 3.544176262780559*^9, {
   3.544176334386072*^9, 3.544176365413699*^9}, 3.544176453650263*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"var = \"\>", "\[InvisibleSpace]", "\<\"S\"\>", 
   "\[InvisibleSpace]", "\<\"\\n\\nFit = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "1.2196926752371222`"}], "-", 
    RowBox[{"0.06745881097023036`", " ", "x"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[
  "var = ", "S", "\n\nFit = ", -1.2196926752371222` - 
   0.06745881097023036 $CellContext`x, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.5441751879919243`*^9, 3.5441752054444103`*^9}, 
   3.5441752438433313`*^9, 3.544175277034851*^9, 3.544175401074678*^9, {
   3.544175516200308*^9, 3.544175533818831*^9}, 3.544175656359126*^9, {
   3.5441759476258907`*^9, 3.544176010351519*^9}, {3.544176069534834*^9, 
   3.544176092015217*^9}, 3.5441761512649717`*^9, 3.544176262780559*^9, {
   3.544176334386072*^9, 3.544176365413699*^9}, 3.544176453656188*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{20., -2.4088577476717443`}, {22., -2.645744204753826}, {
      24., -2.853355713901566}, {26., -3.034528231253306}, {
      28., -3.1949870440011363`}, {30., -3.2608980810939876`}, {
      32., -3.4582331492235543`}, {34., -3.5799005286313252`}, {
      36., -3.694293774802349}, {38., -3.8043362447197766`}, {
      40., -3.9119338549610947`}, {42., -4.018712153836411}, {
      44., -4.126239527020295}, {45., -4.182189054725543}, {
      46., -4.2362646892905635`}, {48., -4.350923841494499}, {
      50., -4.4732133227870055`}, {
      55., -4.846397924526565}}]}, {}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx3080wkcwHG0zTxvv6voUq1XhlIe1m5k5Gvz8LMuKXInD0PKQ4/npVKW
0ys6Vuluh9aJjuioLl7jJKp9L6XzKutBJiY6pVSGq/MUq9v98Xl9Xu+l8Xs2
bTMyMDBYr+//x8v8TQ0MuCCpsXU0O0nBuctc6JFGXMjtUctC8il4p86G1kDh
QgH1J13hKQo6dr4z3GnChUuR1A6WjIIj1rLpLoILPcYjh3mnKXiwpG+ohs0F
j1hlR1wZBX+sOnBXvI4LE4z47xv/oKDyZnW2sogLe1N/U2/royA/TfTlKs+v
QOG5OELOo+JYyQ7n1sd65/iUvs+lYpZ23XhsEg8mM/eH13RT0aU1qava1B2k
h88MCN1oaPMFzWNxuTv0ftruZnCUhqw3/XUQ4AGSHFZYgYaGcwbTBxJee0Bs
0+gbKccYl2yWnao/vAaMUpMF1UeNcUvw0DcKlid8cH6w+5zGGFXNN0s1jZ5Q
vrs/+sYqOi7aECanBfOhMIqK3pl0PL7D/vf+UT6oN1hPFHbSkTObDi+PeYH6
TsfIPAcTnJpHHy1a4Q1sX0nzru9N8Mzm8JB197yhIcVzxkFtgmkmbFenuLVA
tz6vM3Ewxd0Brk7X5vhA1V+THS2Zplg22VyRWuwDNN3EzsqHpjhtc8tWuwRA
wRvojlluhoy2HCzbC1C++MW1Q1lmKKzLWzbcDBCSlx9185EZ0gacCk5a+ELw
NLuje7k5vhJZ3r4d4Qumw4nmiyTmWBcQ0i6p0PuksvHWfXNk/OD68vi4L3y7
es4asLPAPMONTa6+AkiI+idjcJ8FytCqdOXPAkDpPVm8ygJzCefI6hcCiEls
thWwLbG49ERXs7MQrrduTg7ab4nee/Li2FlCSHLqzXNUWeLswdaLdveF8Jiw
2OXCssIq663tFfP9IKsqtEW+1wpfTpfoMhL9QCI8pu2+a4Ve8xdohxR+UFzr
tqvMnIF2BzhvL1P8gSUoav/Tg4HLiRMXaBv9gTIvxGoijoELwd/r72J/MFUW
SCOlDCxRnO0ntP5wdceD0ZUNDOSLuYIejwBoiRDziH4GJoekKKakAXBANLh9
qxkTs598njmtCYCviYmHgzwmXpd1UtrtA+HIwihbiZiJRwuDFkakB0K0Q+PG
zONMTHysGzt0OxDkaclJBfVM9Chn/rrIioRxeWWjppeJZxpaoqxjSZhWdr3P
pxNoTW14euESCdGOYstwNwL7ytZ6T10m4bX33GXmHAIr1t4tC7pCwnehbe63
9OakP00ZriXhWObqOGcugcHvPs66NZBQ88S4nuZOYM4jn6U3kATDI7URV70I
/FDSltzRSUJlt2GlDUlgk+cmlV0XCa6jDddUemd19XD2PyWhibJTlR1EoCVz
eMZGQ4LKRT05JiJwRbZlfsxzEqZyLora1hMYlxKqePOWBBEndOxgKIGOxr3z
+cMkPAmkU13DCBw5n5BxQktCTPSNBa/0ljzb5+cyRkJqroNwUziB8hC5Om2c
hLN9M4UrIggUa1n81gkS7P+tvfhcb3tp9TnrKRJqTbYri7YQWN/SlNT0kYQ7
3IdDRlEEZsQK281mSdggytE16i3Q3XOL1pHQI/Yk9kQTSP8lrOjKJxIS9o3a
s2MIfMB79vHzZxJGpBV8jd7/AY7fM8k=
      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{20., 0},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Print",
 CellChangeTimes->{{3.5441751879919243`*^9, 3.5441752054444103`*^9}, 
   3.5441752438433313`*^9, 3.544175277034851*^9, 3.544175401074678*^9, {
   3.544175516200308*^9, 3.544175533818831*^9}, 3.544175656359126*^9, {
   3.5441759476258907`*^9, 3.544176010351519*^9}, {3.544176069534834*^9, 
   3.544176092015217*^9}, 3.5441761512649717`*^9, 3.544176262780559*^9, {
   3.544176334386072*^9, 3.544176365413699*^9}, 3.54417645365818*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
   "Print", "[", 
    "\"\<\\n\\nSimple EXP convergence plot for: T,A...(0,1)\\n\\n\>\"", "]"}],
    ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varlist", "=", 
    RowBox[{"{", 
     RowBox[{
     "\"\<T\>\"", ",", "\"\<A\>\"", ",", "\"\<B\>\"", ",", "\"\<F\>\"", ",", 
      "\"\<S\>\""}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"ii", "\[NotEqual]", "4"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tmp", "=", 
        RowBox[{"Transpose", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"datnew", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
           RowBox[{"datnew", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", "9", ",", "ii"}], "]"}], "]"}]}], "}"}], 
         "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"lastval", "=", 
        RowBox[{"tmp", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "2"}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmp2", "=", 
        RowBox[{"N", "[", 
         RowBox[{
          RowBox[{"Function", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x", ",", "y"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"Log", "[", 
               RowBox[{"10", ",", 
                RowBox[{"Abs", "[", 
                 RowBox[{"y", "-", "lastval"}], "]"}]}], "]"}]}], "}"}]}], 
           "]"}], "@@@", 
          RowBox[{"tmp", "[", 
           RowBox[{"[", 
            RowBox[{"1", ";;", 
             RowBox[{"-", "2"}]}], "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpfit", "=", 
        RowBox[{"Fit", "[", 
         RowBox[{
          RowBox[{"tmp2", "[", 
           RowBox[{"[", 
            RowBox[{"1", ";;", 
             RowBox[{"-", "5"}]}], "]"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "x"}], "}"}], ",", "x"}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"plt1", "=", 
        RowBox[{"ListPlot", "[", "tmp2", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"plt2", "=", 
        RowBox[{"Plot", "[", 
         RowBox[{"tmpfit", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "20", ",", "50"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<var = \>\"", ",", 
         RowBox[{"varlist", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], ",", "\"\<\\n\\nFit = \>\"", ",", 
         "tmpfit", ",", "\"\<\\n\>\""}], "]"}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Print", "[", 
        RowBox[{"Show", "[", 
         RowBox[{"plt1", ",", "plt2", ",", 
          RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], "]"}], ";"}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
   RowBox[{"{", 
    RowBox[{"ii", ",", "1", ",", "5"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.544174988043232*^9, 3.544175140416996*^9}, {
   3.544175190968801*^9, 3.544175204863388*^9}, {3.544175242432678*^9, 
   3.5441752432563257`*^9}, {3.544175513713191*^9, 3.544175533383417*^9}, {
   3.544175930871953*^9, 3.5441761257336197`*^9}, {3.544176281438539*^9, 
   3.544176289713296*^9}, 3.5441763461653757`*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\"\\n\\nSimple EXP convergence plot for: \
T,A...(0,1)\\n\\n\"\>"], "Print",
 CellChangeTimes->{
  3.544176109899528*^9, {3.544176151352537*^9, 3.544176163498295*^9}, {
   3.544176262846974*^9, 3.544176290228776*^9}, {3.544176347281579*^9, 
   3.544176365487884*^9}, 3.5441764537043324`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"var = \"\>", "\[InvisibleSpace]", "\<\"T\"\>", 
    "\[InvisibleSpace]", "\<\"\\n\\nFit = \"\>", "\[InvisibleSpace]", 
    "0.1264046154256426`"}], "\[VeryThinSpace]", "-", 
   RowBox[{
    RowBox[{"0.11992752914582758`", " ", "x"}], 
    "\[InvisibleSpace]", "\<\"\\n\"\>"}]}],
  SequenceForm[
  "var = ", "T", "\n\nFit = ", 0.1264046154256426 - 
   0.11992752914582758` $CellContext`x, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.544176109899528*^9, {3.544176151352537*^9, 3.544176163498295*^9}, {
   3.544176262846974*^9, 3.544176290228776*^9}, {3.544176347281579*^9, 
   3.544176365487884*^9}, 3.5441764537055483`*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{20., -2.0550464834042987`}, {22., -2.3943845112359763`}, {
      24., -2.7368091513557538`}, {26., -3.08622235155835}, {
      28., -3.4754450113634765`}, {30., -2.92760966575437}, {
      32., -3.910800591178901}, {34., -4.235398933492312}, {
      36., -4.497387505529747}, {38., -4.693215180146497}, {
      40., -4.815292357915072}, {42., -4.873263813158593}, {
      44., -4.888480520845089}, {45., -4.927570243329094}, {
      46., -4.8801015454287615`}, {48., -4.8596984462357895`}, {
      50., -4.832147931847833}, {55., -4.714786188607742}}]}, {}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV0vs7lHkYgHENTYwajJn5qlbJaZXTcL2YHB8zhlc2K5VCm8gWppJTEXUR
HUhbtKTVOJQwOmwRhdSzhWrFbu2KSJZsKgZXm02O2/5wX59/4F4REun7PUNJ
SWntl/43JFvCUlKiYNl9r8EAcwZyDSxVAxkUmG7W3i2zZGBTlQ6zRoUC4UjX
h14rBpq0D83bpUaB75KI2VBbBo6Q7M8dHAqORB/nRbowMEH26u3PRhQM6zeJ
U9cx8HT5/odBXhTUpjoXXY5j4L278rR7uRT4Saz8pxsY6BC7Zom5vQ1kS8PM
HgUo45hMatH8zAb8H3OVBAplTFZ4jW8Ls4VDh1cV3k5SQcvmsA45yw7KXmUV
SnXmo442U7jsgh1sid5TVCefj3rveqvAXQg8+XkG5cFE5b/j+0MHhWDmQAna
+pi4fGP2qZsHV0ObiutWlegFGOD9dlOlnj3ERhUqQtmq2FZ/t6D7tj1c4sUc
DC5SRd1vN+QxvR2A4l3vPGSphiekxld7Rx3g4S3nnOZf1dB6Oh4GjjrCQJbI
tyKQhRM81dHcVU7A1Mjbe3uChec2+vl4tTjB0UG/gMFsdYxVMxKYBjtD1qcM
t0r9hbjHXWBaq+wCxRWap8vuLsTiT/Ul0fku4Jij/lLoswg/69z/SrEc4IX+
5vSPikWo+fgIFu8F6FBnM54eZ6O4Kt1guB4gyGx1oudiDWT2m/54cpErDI1W
bxyu1sA3a9iNjf6ukDK+Po9nqIlV7j6tSSWucKcoRdok1UTNY4KBE+OukKC7
OTKjVhPT562rE7iKYMomPEaXoYXZqFFgdkYESnoG5U0+WnicYxEofy2CqltZ
olmZFuYXZHbUW4jBbMi+R+WNFjpFpgcbJYvBeCyzXI/i4HRCc4XhEzEMnl4c
yzrIwXKyvbWE7wZ+vQGX0ho5OPBZNpO40w3oObcFXI42OvIXK95WusFsXXh4
VIA2Gu63fn9FRQJ2tN3063JtXMnJLGWuk4BtlMspww/auBQkjn35EhjwmD42
vpqLssrzvRyFBLhjwTe6j3HRIYgSdQndQZVidJ/6nYvhPhGVExnukOzpZeO/
nIdpf85Nne12h9KFnuOVu3h4J7tdpdXY48uPKdVdN3mYmuO51D/eA+byQ0qJ
Mh93PpsZO9DoAdZhh87qf8NH4QWtIl0NGrj93iMNZ/h4rubBFrKNhgTzR3F7
+vhI5td0ll6m4SI3aWZ4JcFXxc5OE1doKDvMuiEwJVji/LDY8xoNFWN5obFm
BK3jOyOGr9NQ9aS6ZcqCoPfQ5LRVDQ2NaaPnWBTBI09dVjQgDW8+htiaOBP8
R/Y4/I92GkzaPSO3+xKss/dtM+ygwVzcqV+2nmByR5f1vk4aBDd2PH+/gSBb
a3hKp5sG4clUp+hNBFelsX/Y+hcNayQN6ilbCAZHrK98954GabWgvGAHQZMF
L/kOwzREGtwL7N9JcORiaGKmgoaYrLUaxuEEk3ri3CzHaEjcHbHvqpRgnk/e
89hxGjKNStzu7CUYpNBzaP6Xhqwz1hNzUQSNM+SFZIKGnHm/XBbHELz5oC6s
bpIGWU8PpyWOYOI2cav6NA0XvHY1s/cTFM20WH03Q0Np7WSCbzxB1Z825F6b
pUH+dbp5bgLB32x7JufmaLiWQ/peHCD4H7WwLzo=
      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{20., 0},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Print",
 CellChangeTimes->{
  3.544176109899528*^9, {3.544176151352537*^9, 3.544176163498295*^9}, {
   3.544176262846974*^9, 3.544176290228776*^9}, {3.544176347281579*^9, 
   3.544176365487884*^9}, 3.544176453707467*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"var = \"\>", "\[InvisibleSpace]", "\<\"A\"\>", 
    "\[InvisibleSpace]", "\<\"\\n\\nFit = \"\>", "\[InvisibleSpace]", 
    "0.7568068803718664`"}], "\[VeryThinSpace]", "-", 
   RowBox[{
    RowBox[{"0.16284471054615798`", " ", "x"}], 
    "\[InvisibleSpace]", "\<\"\\n\"\>"}]}],
  SequenceForm[
  "var = ", "A", "\n\nFit = ", 0.7568068803718664 - 
   0.16284471054615798` $CellContext`x, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.544176109899528*^9, {3.544176151352537*^9, 3.544176163498295*^9}, {
   3.544176262846974*^9, 3.544176290228776*^9}, {3.544176347281579*^9, 
   3.544176365487884*^9}, 3.544176453712502*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{20., -2.54071244769337}, {22., -2.8430903591556342`}, {
      24., -3.1482438411536218`}, {26., -3.4539542537170034`}, {
      28., -3.7574740340278363`}, {30., -4.287597969430436}, {
      32., -4.390750965482275}, {34., -4.698957777261692}, {
      36., -5.014771761846377}, {38., -5.343150729732141}, {
      40., -5.700955133345164}, {42., -6.143773484186667}, {
      44., -7.135318330304813}, {45., -6.01736414923567}, {
      46., -6.579593567734866}, {48., -6.347052267240693}, {
      50., -6.247429202894465}, {55., -6.086166809746478}}]}, {}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVyX080wkcwHFlDUuYYfPwy4pcTJIbxjJfD5ufXE7JqchzJd3rdJIm6lyR
lqeiFq15yhUucuylmuJbaV49SOXEK6W7SicP4S4Oebjuj8/r/cdnRVT85p2L
1dTUNn7pf6PyhTQ1NS40S+uer1GjoIHFWs2QxVzIPkKPcVen4L0GFrWRwoWt
uxLGA6gUXN01tOh7LS787cjVTtSm4Edm/nS3Phesuq55KFkUTJb3DVxdxYVc
RssV0ToKnqo82Bbux4XQU+1Hw6Mo2NJcld4i5cKMZNDudCsF+YkbTNa4OoLy
wnxcctESHJPvtVM9cwTerc4WYQQV00b8JiJinUAhSlBxLDRwrSq2u4rmDNdH
B+ukkxrIYlB5y8ud4dAlS0V/kyayP7xuABEPMJUnu3FaC9X7xW9i/uKB5k1D
7uVoGpoH5ecpDruAtpaiX/zVUtzuPxBcz3aFwgO2KR2fl+Ljpubi3uuu0De6
05p2RxuJb7cUUv35YNUZKwlLX4ZZe61qXo/y4VOXsN05WAcdZsXw7vh6OPL+
rfWEqS5OGWqOSm3cINcoNM55XBeLgr4L8HvoBh3d/rW+kXqYqLXKnhMpACfO
k4YPd/TwB5E954a6O0TkCjiPbOlY9m9TRYLMHfaIl10tzaPjNOuO2Yg5wNcJ
9yuuzdBR734Glu0DSGPH7e+N1kevBonFcBNAddBe//F7+kh9wzmTs8wDzp3f
JvO1Z+D7DTqtrds8IGZX5aeCAgY2iALaUys8oO59r9XQJwbqZdq/y5rwAEya
fZAeZoCSRZuU9h6eUJtzOEXvtgHmo26xbYEnhCuG5H0cQzyhbxdS9dYT8vIE
RTfOGKKsOLu7yc4LSsbHS49PGqJbvCRyVZoX/BidbyKNMMLZZFW15SMvWBla
UHrurhFWMqPbK4y8IVAreeEXSya+m5bPpez2Bh+V35PJHCauNzIeGaj3Bhbt
pxqXMSZaHnQYvEIRQu2Oktnm7Sy01s++RN0kBAsee6tTMwtNQbj+T5kQmG0Z
2UpzY5TXX3itPyKExzt7HH6WGCM/nOv5gieCmKysfpdhY9wTEFc/dVIEt5BD
cww2wfTfFz6f6xXB2eo6DTc0wZv5XZR2Kx/4xlRKd15pisfO+ppuE/uAShab
sz/bFHc/mxs71OoD5hdlhuWjpsgrp5cSuiRMhTUkvQoww6LGu6HMCBIKbK77
hijNkLmksefSryToHiasH5oR2FcmcJu6QoLLy8KGo8sJrBC0lfnWkhDJNxC4
sgl0EPfEDdeRcG2aFlhlQaD/0MzsusYvP2kqNdOGwIyn7ituIQm/xXc+8eIR
+I/8/p7OLhKCoiTim4EEKl03P7bsJuGn2xT1xCAC07pfOCT1kFDFTsvhBBOo
Qx/+zOolYa4vqfz8dgJt0nVyw/4g4XJIzCNxJIGRcYH1HwZJmN7iznaMJ3C1
xksj/jAJFgpl9fA+Aj9ejEnJHiFhI8PJsSKBwNRXB7zXjpFQ9tR2AyOJwMKA
wueJEyT4+ZskjqcSGD7C5qsmSThQc3a+8giBVierSphTJJRo0yURaQQq7ipj
lTMkTDzQKO44RmBKhFf70lkSzG2Orc7MINBz7uG6HXMk+Erm6wWZBGqe3yKt
nSdh/0Cy2+QJAjucXs0sLJAg95loqzlJ4H/OWTjN
      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{20., 0},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Print",
 CellChangeTimes->{
  3.544176109899528*^9, {3.544176151352537*^9, 3.544176163498295*^9}, {
   3.544176262846974*^9, 3.544176290228776*^9}, {3.544176347281579*^9, 
   3.544176365487884*^9}, 3.544176453713525*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"var = \"\>", "\[InvisibleSpace]", "\<\"B\"\>", 
   "\[InvisibleSpace]", "\<\"\\n\\nFit = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "0.1379189012748543`"}], "-", 
    RowBox[{"0.12156257924217527`", " ", "x"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[
  "var = ", "B", "\n\nFit = ", -0.1379189012748543 - 
   0.12156257924217527` $CellContext`x, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.544176109899528*^9, {3.544176151352537*^9, 3.544176163498295*^9}, {
   3.544176262846974*^9, 3.544176290228776*^9}, {3.544176347281579*^9, 
   3.544176365487884*^9}, 3.544176453718964*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{20., -2.3652464931617176`}, {22., -2.7011894007600667`}, {
      24., -3.0403126993647596`}, {26., -3.3860915869804695`}, {
      28., -3.768239893085268}, {30., -3.2574066170520313`}, {
      32., -4.219155389314761}, {34., -4.544605132158968}, {
      36., -4.812126145277952}, {38., -5.016482107093687}, {
      40., -5.147040231383079}, {42., -5.2105580946206285`}, {
      44., -5.22810033201244}, {45., -5.27465952622496}, {
      46., -5.220015857775237}, {48., -5.199045340696988}, {
      50., -5.170554922853165}, {55., -5.051450441494966}}]}, {}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVxX8403kcAHBj1qSYme1Tcig8/XARi52h9zbjW3tCUem6oqRGrno6HR33
PKqR/KqHckqSuI50aNgjOt6VRFjPkXEUl9QRmks/0Jy7++P1vGz3Hdkaoa+n
p7f5P/+/L0u6UE+PDyzzeFlpBh05K5yYu/T5sLTs2+qpc3R8WEUYKjofVkjC
rLyz6Liye4wWbcQH9++k2s4cOr7lZc30sPmwu8s0W1dAxxP5AyMV9nwozS7u
C1DS8XxJ7KNQGR9EHHXkRw0dGxtKFY05fIixsE2R2BiiMGbT0i891kNV9VSe
S6MhTuYfWtvcuR6c0nyiLwUxMHFC9iFM7gZHI6ZpvFcMdGqW95QudIfMZ72H
R08tQGLOEHxx3R1GUt1zXblMtBkdrAJfAVhr7ud21jDR4FXc0P6/BGBpf3tP
ylYjtN6Wda76x68guMzqRc2wEX7tP7JDaeMBcrXKQ3B6IarrG67213pA7Up1
oAvPGK0CgnMZ/kJQJ1OOkhJjTDvk8OugVgj3TmoHSqSL0EUXB8PJnqCt4vgn
9y7CaQumNme1F8ycOnChNnYxXtq2PVDW5gWt2yyv0TgmGGNk77xmrzdoQv3l
9382wcO+zmvuGGyARkb5gl6JKRZ+qi8+lrcBhofTwiN6THGG3F82YQ3wzknW
ViRkIas1CQuPAmzXnvSzSWWhpOrsivF6gJDHnwpDuljIGFpzIWOxCFqmDOT1
y83w9SaTpqadItAIAhb1RZthlW9gR0KxCJrnZeaKGjNknXEeTvsgAgeLwaQQ
OhvP0rbUOYvEsNz3tmZkMxuz0PSqY7YYMh8uyS7KZ2MKe+2u0pdieNbsqhwd
Y2Pe1fSe+rUSaHmZXjHGN0evI2f32idKYHlAAiEKc9SdaL5p1y6BpZqboXpq
cyzhhXcUc33g/UCqUQyXg8Mz+XPxB33A241mzY7goCd3ycSI0gfsSlXs6HIO
2sW6vLlFl0JclP6xyTkOrmKn32BskUK0X0aFM2WBliD1fJEnBfGN1gDdeQvM
V14ZZE9IITnoyq53gxYoDOWL+wS+IF9WLi1excXIwCjldKov1Lpuz0s8wUXF
0/nPP/X7wnh7RdDIIy7ezeqmdzj4QcNJ6o2xGQ9PX9xouTPOD3SK2PGdYTw8
2Dk3+UOTH/QVvWoPv8lDwXWza1amFFz2MWTNvOPhJdWDb3hhFLS41jfUigjy
DFW9N8oouOBdKeOnERwo9PaavkXBXU9mZEI6wWLvR4UbyykY8ghLbsog6BLX
GzVeSYGLO+te8HmC/mOzunUqCjqdjrodv0gw6fcNtr8hBSa2zraqAoJT+a2R
Xd0UpBhUfnSvJljnsVVt10NBJY3JSawhmNjT5/J9LwWa+dB1LSqCJmbjn0k/
BQ460+iQOwRXK0wy9/xJQdP7Iy/iGgjujQpSjr6hQP+1U/udFoIrFzzjCscp
WD18ZpT2mODbov3x6RMUBA4NMja1EUx4ftzHaZKCawPnRH0dBHMDczUxHyjw
7tGqZjsJhk7YCJs/UnCg2++p+ClBh9TSAt40BZldBX+ndhOsflAnr5ulYOBJ
gKNlL8H4MEmHsY4ChvqXjeF/EBTPta3bPUeBY/v8gbI+gszLwTnl/1AQ/HiH
Yqqf4BO357Pz8xQktFQUCp8T/Bch5kBn
      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{20., 0},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Print",
 CellChangeTimes->{
  3.544176109899528*^9, {3.544176151352537*^9, 3.544176163498295*^9}, {
   3.544176262846974*^9, 3.544176290228776*^9}, {3.544176347281579*^9, 
   3.544176365487884*^9}, 3.544176453719986*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\<\"var = \"\>", "\[InvisibleSpace]", "\<\"S\"\>", 
    "\[InvisibleSpace]", "\<\"\\n\\nFit = \"\>", "\[InvisibleSpace]", 
    "0.18008767213250101`"}], "\[VeryThinSpace]", "-", 
   RowBox[{
    RowBox[{"0.12081808172928657`", " ", "x"}], 
    "\[InvisibleSpace]", "\<\"\\n\"\>"}]}],
  SequenceForm[
  "var = ", "S", "\n\nFit = ", 0.18008767213250101` - 
   0.12081808172928657` $CellContext`x, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.544176109899528*^9, {3.544176151352537*^9, 3.544176163498295*^9}, {
   3.544176262846974*^9, 3.544176290228776*^9}, {3.544176347281579*^9, 
   3.544176365487884*^9}, 3.544176453725088*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{20., -2.0191158867005297`}, {22., -2.3601808555777617`}, {
      24., -2.7035781920252733`}, {26., -3.052918186226427}, {
      28., -3.438371006494509}, {30., -2.9214911102666488`}, {
      32., -3.8869190776384266`}, {34., -4.209627768939144}, {
      36., -4.4714875659904845`}, {38., -4.668874070307102}, {
      40., -4.794188717756379}, {42., -4.85627367129964}, {
      44., -4.875363065252577}, {45., -4.917519092871204}, {
      46., -4.870162526159771}, {48., -4.852167417853797}, {
      50., -4.8266113250930704`}, {
      55., -4.712359198721414}}]}, {}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVynk4FHgYwHHjGOOIMYMfQ0WOR1SOJoaJXjOOn6ySJUsrV3JVylOLVZue
DqS2VikqMiVlO2yj9bQmvBvpUY3dbEylayNXM+XJQ85s+8f3+fzztU7ICEtS
V1NTC/na/yYU++uqqfEhvya6qreXgcY2zqwN6nxYf79/l2M/A+/VmTHrNflg
8y4zcMcgAx263jO26PChyapo+IuSgR9I8aSCw4ex0zIX3jgDc8pfDdba8SHx
kGVjKEsdj1/Juh8bzAefxFddjUvUsbmp5kDzqa+/ZYJ26S51FO5czVvqtQKe
99gpj3I1cKQ8fVlb5wp4YSlj61/WwDxV8Fhciju0ynlFlzw00bktRVGj6wE2
D9zz855oohmXKVhwwQMk1Lald7MWWg29roMAAZRwOvIKtJio8S777aYBAWR8
IzpJJUxcGFF87NYeT0hhFQwcd9PG6DWDkVIrL+g2PHyH97c2dsiaKnpue0Fi
WczjJYksnL82vJS5RghdxdPC6FEWFqXbX3/9UQhNigiH9mM66DaTDX2HVsK9
in3haK2LEyasj6ccvUF8M1V9slkXyyLWhwY/9Ibq5ZbMkA16uFPHzsUp3gcc
BJVBi5V6uC3AxekPjVVgXfDGILBQHyWfZVWZZ1eBIPoTV2UxDyfN7lqqFgK0
ZuGZJw3zkN1+ECXbAQRaUVmK9QYoriu0UcoAHhi3nEgYNEDmW6eTR+f5QmfG
kKvzIUPsX23Q2hrlC3uqR7Tv6rOxLiBUvrvKFzTkj62nwtnIznfpKxrzBX/z
X2bCLrKxkLGuwcVXBCX2np8zlGwsRsOKJSdEIIlqll4XGmEBZ9mGml4RVLY6
mucUGuHZiiMK2TIx3Bj56Tyr0wi9Mwrj7fLEkCW62X/bioMzOW2/2j4Sw9qI
RyFL0zh4hSTKq0z9gFf5KNZZysG+yfLZ3GQ/kLCvuoWpcXGlqblqUOoH7qJM
O88gLtpmuQ1f0/SH/DLyDEq5uJhzpJq5zh8Gbl66pv+Wixbgv/Lfs/7gpW7u
tNnRGMul515zVP5As9PS3mQbozCWL3ouCICk2qr2BXeNMTU0TTpxOAB89BuH
9hiZ4IEnc9OnewJAR9JwKy3WBO8Ud2nK7QOhb7zyvMUVE9xfEmQRlR0IOZlJ
wapxE0zunB35sTUQFtRyyH4wRcEFo8r5hhR+t7l0tLrAFMvqW74ncRRYTSb3
hrtNkWjVP62+SiHdPMNydCHBVxIf74lrFLIE33l4WhOs8rkvCbpBYX+kb9je
RQTdsp+mKX+jcK6EW6BnR3DN+6kZ13oKHUa3R20cCR58vMq6ESm46TIehvMJ
jpa3p/7TRWFyqjinnhJs8ArrsFVQYPJ2n5wJIpineO72w1MKHM+kWlEwQQMj
5bRZDwWnLI93HSEEHQ8Y/LzxDYWY0Z7QgTCC8WnfSoeGKfz53tbBLIagg/YL
U6GSglzXQLxxI8EPFzflHlFReLb4c0xVLMHdL3f5OY9Q+JTcfsIlgWBpaGn3
zjEKtn1b52gywViVlbBtnIKrRiTvWApB+8M158kEBZ9FsKIrleCtloaUhikK
kXGc9PgtBHPjxHK9GQqJe6cPXt5KUDT70DVmlsL2ir5K1TaCrDPhp258oZDb
KJct307wL/eXU3NzFApe1Hfn7CD4H6pdLY4=
      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{20., 0},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Print",
 CellChangeTimes->{
  3.544176109899528*^9, {3.544176151352537*^9, 3.544176163498295*^9}, {
   3.544176262846974*^9, 3.544176290228776*^9}, {3.544176347281579*^9, 
   3.544176365487884*^9}, 3.5441764537261467`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1011, 851},
WindowMargins->{{67, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 154, 2, 26, "Subsubtitle"],
Cell[736, 26, 20847, 513, 1861, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[21620, 544, 196, 3, 26, "Subsubtitle"],
Cell[21819, 549, 254, 5, 27, "Input"],
Cell[22076, 556, 264, 5, 27, "Input"],
Cell[CellGroupData[{
Cell[22365, 565, 1648, 23, 27, "Input"],
Cell[24016, 590, 1963, 29, 58, "Output"]
}, Open  ]],
Cell[25994, 622, 669, 17, 58, "Input"],
Cell[CellGroupData[{
Cell[26688, 643, 853, 23, 118, "Input"],
Cell[27544, 668, 403, 6, 70, "Print"],
Cell[27950, 676, 2918, 59, 70, "Output"],
Cell[30871, 737, 401, 6, 70, "Print"],
Cell[31275, 745, 2922, 60, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34234, 810, 761, 22, 118, "Input"],
Cell[34998, 834, 371, 5, 70, "Print"],
Cell[35372, 841, 1916, 46, 70, "Output"],
Cell[37291, 889, 371, 5, 70, "Print"],
Cell[37665, 896, 1920, 45, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39622, 946, 753, 22, 118, "Input"],
Cell[40378, 970, 401, 6, 70, "Print"],
Cell[40782, 978, 1945, 46, 70, "Output"],
Cell[42730, 1026, 401, 6, 70, "Print"],
Cell[43134, 1034, 1948, 46, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45119, 1085, 512, 12, 58, "Input"],
Cell[45634, 1099, 428, 6, 70, "Print"],
Cell[46065, 1107, 6320, 167, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52422, 1279, 429, 11, 58, "Input"],
Cell[52854, 1292, 380, 6, 70, "Print"],
Cell[53237, 1300, 6118, 165, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[59392, 1470, 369, 10, 58, "Input"],
Cell[59764, 1482, 182, 2, 70, "Print"],
Cell[59949, 1486, 982, 17, 70, "Message"],
Cell[60934, 1505, 15320, 354, 70, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[76303, 1865, 196, 3, 26, "Subsubtitle"],
Cell[76502, 1870, 948, 23, 27, "Input"],
Cell[77453, 1895, 364, 11, 27, "Input"],
Cell[CellGroupData[{
Cell[77842, 1910, 2718, 61, 148, "Input"],
Cell[CellGroupData[{
Cell[80585, 1975, 1936, 37, 234, "Print"],
Cell[82524, 2014, 1935, 37, 229, "Print"],
Cell[84462, 2053, 1936, 37, 231, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[86447, 2096, 2762, 61, 148, "Input"],
Cell[CellGroupData[{
Cell[89234, 2161, 1040, 24, 234, "Print"],
Cell[90277, 2187, 1043, 24, 231, "Print"],
Cell[91323, 2213, 1040, 24, 236, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[92412, 2243, 2203, 65, 118, "Input"],
Cell[94618, 2310, 694, 11, 27, "Output"],
Cell[95315, 2323, 2981, 56, 234, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[98333, 2384, 2151, 64, 118, "Input"],
Cell[100487, 2450, 629, 9, 27, "Output"],
Cell[101119, 2461, 2898, 54, 238, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[104054, 2520, 159, 5, 27, "Input"],
Cell[104216, 2527, 6192, 165, 163, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[110445, 2697, 3357, 90, 358, "Input"],
Cell[CellGroupData[{
Cell[113827, 2791, 528, 7, 81, "Print"],
Cell[114358, 2800, 899, 17, 66, "Print"],
Cell[115260, 2819, 3055, 56, 228, "Print"],
Cell[118318, 2877, 895, 17, 66, "Print"],
Cell[119216, 2896, 3080, 56, 231, "Print"],
Cell[122299, 2954, 923, 18, 66, "Print"],
Cell[123225, 2974, 3066, 55, 223, "Print"],
Cell[126294, 3031, 921, 18, 66, "Print"],
Cell[127218, 3051, 3075, 56, 223, "Print"],
Cell[130296, 3109, 899, 17, 66, "Print"],
Cell[131198, 3128, 3055, 56, 228, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[134302, 3190, 3799, 96, 418, "Input"],
Cell[CellGroupData[{
Cell[138126, 3290, 307, 5, 81, "Print"],
Cell[138436, 3297, 700, 16, 66, "Print"],
Cell[139139, 3315, 2828, 53, 228, "Print"],
Cell[141970, 3370, 698, 16, 66, "Print"],
Cell[142671, 3388, 2824, 53, 228, "Print"],
Cell[145498, 3443, 678, 15, 66, "Print"],
Cell[146179, 3460, 2820, 53, 228, "Print"],
Cell[149002, 3515, 701, 16, 66, "Print"],
Cell[149706, 3533, 2836, 54, 228, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
