(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     85448,       2156]
NotebookOptionsPosition[     83484,       2086]
NotebookOutlinePosition[     83839,       2102]
CellTagsIndexPosition[     83796,       2099]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Load Routine - RS", "Subsubtitle",
 CellChangeTimes->{{3.539899260141288*^9, 3.53989929032763*^9}, {
  3.542451227865471*^9, 3.542451228546563*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"analyse", "[", "filename_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", "\"\<~/Work\>\"", "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"SetDirectory", "[", "filename", "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"file1", "=", 
     RowBox[{"OpenRead", "[", 
      RowBox[{"\"\<patch.dat\>\"", ",", 
       RowBox[{"BinaryFormat", "\[Rule]", "True"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"NR", ",", "NA"}], "}"}], "=", 
     RowBox[{"BinaryReadList", "[", 
      RowBox[{"file1", ",", "\"\<Integer32\>\"", ",", "2"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmplist", "=", 
     RowBox[{"Partition", "[", 
      RowBox[{
       RowBox[{"BinaryReadList", "[", 
        RowBox[{"file1", ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<Real64\>\"", ",", "\"\<Real64\>\"", ",", "\"\<Integer32\>\"", 
           ",", "\"\<Integer32\>\"", ",", "\"\<Integer32\>\"", ",", 
           "\"\<Integer32\>\"", ",", "\"\<Integer32\>\""}], "}"}]}], "]"}], 
       ",", "NA"}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Close", "[", "file1", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"rpatch", "=", 
     RowBox[{"tmplist", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "All", ",", "1"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"apatch", "=", 
     RowBox[{"tmplist", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "All", ",", "2"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"garr", "=", 
     RowBox[{"Import", "[", 
      RowBox[{"\"\<data.out\>\"", ",", "\"\<Real64\>\""}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"garr", "=", 
     RowBox[{"Partition", "[", 
      RowBox[{
       RowBox[{"Partition", "[", 
        RowBox[{
         RowBox[{"Partition", "[", 
          RowBox[{"garr", ",", "NA"}], "]"}], ",", "NR"}], "]"}], ",", "5"}], 
      "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"sizedata", "=", 
     RowBox[{"Length", "[", "garr", "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"\[Phi]2arr", "=", 
     RowBox[{"Import", "[", 
      RowBox[{"\"\<phi.out\>\"", ",", "\"\<Real64\>\""}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"\[Phi]2arr", "=", 
     RowBox[{"Partition", "[", 
      RowBox[{
       RowBox[{"Partition", "[", 
        RowBox[{"\[Phi]2arr", ",", "NA"}], "]"}], ",", "NR"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Ricciarr", "=", 
     RowBox[{"Import", "[", 
      RowBox[{"\"\<Ricci.out\>\"", ",", "\"\<Real64\>\""}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Ricciarr", "=", 
     RowBox[{"Partition", "[", 
      RowBox[{
       RowBox[{"Partition", "[", 
        RowBox[{"Ricciarr", ",", "NA"}], "]"}], ",", "NR"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"R2sqrarr", "=", 
     RowBox[{"Import", "[", 
      RowBox[{"\"\<R2sqr.out\>\"", ",", "\"\<Real64\>\""}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"R2sqrarr", "=", 
     RowBox[{"Partition", "[", 
      RowBox[{
       RowBox[{"Partition", "[", 
        RowBox[{"R2sqrarr", ",", "NA"}], "]"}], ",", "NR"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"R4sqrarr", "=", 
     RowBox[{"Import", "[", 
      RowBox[{"\"\<R4sqr.out\>\"", ",", "\"\<Real64\>\""}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"R4sqrarr", "=", 
     RowBox[{"Partition", "[", 
      RowBox[{
       RowBox[{"Partition", "[", 
        RowBox[{"R4sqrarr", ",", "NA"}], "]"}], ",", "NR"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tval", "=", 
     RowBox[{"-", "1"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    
    RowBox[{"gdat", "=", 
     RowBox[{"garr", "[", 
      RowBox[{"[", "tval", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"\[Phi]", "=", 
     RowBox[{"\[Phi]2arr", "[", 
      RowBox[{"[", "tval", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Tdat", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", "rpatch", "]"}], ",", 
        RowBox[{"Flatten", "[", "apatch", "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"gdat", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Adat", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", "rpatch", "]"}], ",", 
        RowBox[{"Flatten", "[", "apatch", "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"gdat", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Bdat", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", "rpatch", "]"}], ",", 
        RowBox[{"Flatten", "[", "apatch", "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"gdat", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "]"}]}], "}"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Fdat", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", "rpatch", "]"}], ",", 
        RowBox[{"Flatten", "[", "apatch", "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"gdat", "[", 
          RowBox[{"[", "4", "]"}], "]"}], "]"}]}], "}"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Sdat", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", "rpatch", "]"}], ",", 
        RowBox[{"Flatten", "[", "apatch", "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"gdat", "[", 
          RowBox[{"[", "5", "]"}], "]"}], "]"}]}], "}"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Afn", "=", 
     RowBox[{"Interpolation", "[", 
      RowBox[{"Adat", ",", 
       RowBox[{"InterpolationOrder", "\[Rule]", 
        RowBox[{"NR", "-", "1"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"\[Phi]dat", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", "rpatch", "]"}], ",", 
        RowBox[{"Flatten", "[", "apatch", "]"}], ",", 
        RowBox[{"Flatten", "[", "\[Phi]", "]"}]}], "}"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Riccidat", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", "rpatch", "]"}], ",", 
        RowBox[{"Flatten", "[", "apatch", "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"Ricciarr", "[", 
           RowBox[{"[", "tval", "]"}], "]"}], "+", "20"}], "]"}]}], "}"}], 
      "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"R2sqrdat", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", "rpatch", "]"}], ",", 
        RowBox[{"Flatten", "[", "apatch", "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"R2sqrarr", "[", 
           RowBox[{"[", "tval", "]"}], "]"}], "-", "80"}], "]"}]}], "}"}], 
      "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"R4sqrdat", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", "rpatch", "]"}], ",", 
        RowBox[{"Flatten", "[", "apatch", "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"R4sqrarr", "[", 
          RowBox[{"[", "tval", "]"}], "]"}], "]"}]}], "}"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"\[Phi]datCUT", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{"rpatch", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", 
             RowBox[{"NR", "-", "1"}]}], ",", 
            RowBox[{"2", ";;", "NA"}]}], "]"}], "]"}], "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"apatch", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", 
             RowBox[{"NR", "-", "1"}]}], ",", 
            RowBox[{"2", ";;", "NA"}]}], "]"}], "]"}], "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"\[Phi]", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", 
             RowBox[{"NR", "-", "1"}]}], ",", 
            RowBox[{"2", ";;", "NA"}]}], "]"}], "]"}], "]"}]}], "}"}], 
      "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"RiccidatCUT", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{"rpatch", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", 
             RowBox[{"NR", "-", "1"}]}], ",", 
            RowBox[{"2", ";;", 
             RowBox[{"NA", "-", "1"}]}]}], "]"}], "]"}], "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"apatch", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", 
             RowBox[{"NR", "-", "1"}]}], ",", 
            RowBox[{"2", ";;", 
             RowBox[{"NA", "-", "1"}]}]}], "]"}], "]"}], "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Ricciarr", "[", 
            RowBox[{"[", "tval", "]"}], "]"}], "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"2", ";;", 
              RowBox[{"NR", "-", "1"}]}], ",", 
             RowBox[{"2", ";;", 
              RowBox[{"NA", "-", "1"}]}]}], "]"}], "]"}], "+", "20"}], 
         "]"}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"R2sqrdatCUT", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{"rpatch", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", 
             RowBox[{"NR", "-", "1"}]}], ",", 
            RowBox[{"2", ";;", 
             RowBox[{"NA", "-", "1"}]}]}], "]"}], "]"}], "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"apatch", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", 
             RowBox[{"NR", "-", "1"}]}], ",", 
            RowBox[{"2", ";;", 
             RowBox[{"NA", "-", "1"}]}]}], "]"}], "]"}], "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"R2sqrarr", "[", 
            RowBox[{"[", "tval", "]"}], "]"}], "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"2", ";;", 
              RowBox[{"NR", "-", "1"}]}], ",", 
             RowBox[{"2", ";;", 
              RowBox[{"NA", "-", "1"}]}]}], "]"}], "]"}], "-", "80"}], 
         "]"}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"R4sqrdatCUT", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{"rpatch", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", 
             RowBox[{"NR", "-", "1"}]}], ",", 
            RowBox[{"2", ";;", 
             RowBox[{"NA", "-", "1"}]}]}], "]"}], "]"}], "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"apatch", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", 
             RowBox[{"NR", "-", "1"}]}], ",", 
            RowBox[{"2", ";;", 
             RowBox[{"NA", "-", "1"}]}]}], "]"}], "]"}], "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"R4sqrarr", "[", 
           RowBox[{"[", "tval", "]"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", 
             RowBox[{"NR", "-", "1"}]}], ",", 
            RowBox[{"2", ";;", 
             RowBox[{"NA", "-", "1"}]}]}], "]"}], "]"}], "]"}]}], "}"}], 
      "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp", "=", "\[Phi]datCUT"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"tmp2", "=", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", 
          RowBox[{"Abs", "[", "z", "]"}]}], "}"}]}], "]"}], "@@@", "tmp"}]}], 
    ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"fn", "=", 
     RowBox[{"Interpolation", "[", "tmp2", "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"rmin", "=", 
     RowBox[{"fn", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1", ",", "1"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"rmax", "=", 
     RowBox[{"fn", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"errPhi", "=", 
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{"fn", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "rmin", ",", "rmax"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "rmin", ",", "rmax"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp", "=", "RiccidatCUT"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"tmp2", "=", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", 
          RowBox[{"Abs", "[", "z", "]"}]}], "}"}]}], "]"}], "@@@", "tmp"}]}], 
    ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"fn", "=", 
     RowBox[{"Interpolation", "[", "tmp2", "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"rmin", "=", 
     RowBox[{"fn", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1", ",", "1"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"rmax", "=", 
     RowBox[{"fn", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"errRicci", "=", 
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{"fn", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "rmin", ",", "rmax"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "rmin", ",", "rmax"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp", "=", "R2sqrdatCUT"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"tmp2", "=", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", 
          RowBox[{"Abs", "[", "z", "]"}]}], "}"}]}], "]"}], "@@@", "tmp"}]}], 
    ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"fn", "=", 
     RowBox[{"Interpolation", "[", "tmp2", "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"rmin", "=", 
     RowBox[{"fn", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1", ",", "1"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"rmax", "=", 
     RowBox[{"fn", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"errR2", "=", 
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{"fn", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "rmin", ",", "rmax"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "rmin", ",", "rmax"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"errlist", "=", 
     RowBox[{"{", 
      RowBox[{"NR", ",", 
       RowBox[{"Max", "[", 
        RowBox[{"\[Phi]datCUT", "[", 
         RowBox[{"[", 
          RowBox[{"All", ",", "3"}], "]"}], "]"}], "]"}], ",", 
       RowBox[{"Max", "[", 
        RowBox[{"RiccidatCUT", "[", 
         RowBox[{"[", 
          RowBox[{"All", ",", "3"}], "]"}], "]"}], "]"}], ",", 
       RowBox[{"Max", "[", 
        RowBox[{"R2sqrdatCUT", "[", 
         RowBox[{"[", 
          RowBox[{"All", ",", "3"}], "]"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"gdat", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"gdat", "[", 
           RowBox[{"[", "5", "]"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"gdat", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "NA"}], "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"gdat", "[", 
           RowBox[{"[", "5", "]"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "NA"}], "]"}], "]"}]}], "}"}], ",", "errPhi", 
       ",", "errRicci", ",", "errR2"}], "}"}]}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 CellChangeTimes->{{3.539899030396741*^9, 3.5398990443893137`*^9}, {
  3.5398991023021727`*^9, 3.5398992264442663`*^9}, {3.539899333317923*^9, 
  3.539899333749195*^9}, {3.539899500962047*^9, 3.539899531604052*^9}, {
  3.5399011372972927`*^9, 3.539901169990121*^9}, {3.539901200012993*^9, 
  3.539901223636487*^9}, {3.539901636607029*^9, 3.539901637019285*^9}, {
  3.539901677444491*^9, 3.539901677595982*^9}, {3.539949578760297*^9, 
  3.539949580863264*^9}, {3.53998661392113*^9, 3.53998666371027*^9}, {
  3.539986845981512*^9, 3.539986848235993*^9}, {3.5400405601054583`*^9, 
  3.54004060240615*^9}, {3.540751064031855*^9, 3.54075112588262*^9}, {
  3.541397418339259*^9, 3.541397433892971*^9}, {3.541397480594281*^9, 
  3.541397480989303*^9}, {3.541840407130921*^9, 3.5418404099301777`*^9}, {
  3.5419279388387527`*^9, 3.541927944025823*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Load Routine - Soliton", "Subsubtitle",
 CellChangeTimes->{{3.539899260141288*^9, 3.53989929032763*^9}, {
  3.542451227865471*^9, 3.542451234586872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"analyseSoliton", "[", "filename_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", "\"\<~/Work\>\"", "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"SetDirectory", "[", "filename", "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"file1", "=", 
     RowBox[{"OpenRead", "[", 
      RowBox[{"\"\<patch.dat\>\"", ",", 
       RowBox[{"BinaryFormat", "\[Rule]", "True"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"NR", ",", "NA"}], "}"}], "=", 
     RowBox[{"BinaryReadList", "[", 
      RowBox[{"file1", ",", "\"\<Integer32\>\"", ",", "2"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmplist", "=", 
     RowBox[{"Partition", "[", 
      RowBox[{
       RowBox[{"BinaryReadList", "[", 
        RowBox[{"file1", ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<Real64\>\"", ",", "\"\<Real64\>\"", ",", "\"\<Integer32\>\"", 
           ",", "\"\<Integer32\>\"", ",", "\"\<Integer32\>\"", ",", 
           "\"\<Integer32\>\"", ",", "\"\<Integer32\>\""}], "}"}]}], "]"}], 
       ",", "NA"}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Close", "[", "file1", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"rpatch", "=", 
     RowBox[{"tmplist", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "All", ",", "1"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"apatch", "=", 
     RowBox[{"tmplist", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "All", ",", "2"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"garr", "=", 
     RowBox[{"Import", "[", 
      RowBox[{"\"\<data.out\>\"", ",", "\"\<Real64\>\""}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"garr", "=", 
     RowBox[{"Partition", "[", 
      RowBox[{
       RowBox[{"Partition", "[", 
        RowBox[{
         RowBox[{"Partition", "[", 
          RowBox[{"garr", ",", "NA"}], "]"}], ",", "NR"}], "]"}], ",", "5"}], 
      "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"sizedata", "=", 
     RowBox[{"Length", "[", "garr", "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"\[Phi]2arr", "=", 
     RowBox[{"Import", "[", 
      RowBox[{"\"\<phi.out\>\"", ",", "\"\<Real64\>\""}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"\[Phi]2arr", "=", 
     RowBox[{"Partition", "[", 
      RowBox[{
       RowBox[{"Partition", "[", 
        RowBox[{"\[Phi]2arr", ",", "NA"}], "]"}], ",", "NR"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Ricciarr", "=", 
     RowBox[{"Import", "[", 
      RowBox[{"\"\<Ricci.out\>\"", ",", "\"\<Real64\>\""}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Ricciarr", "=", 
     RowBox[{"Partition", "[", 
      RowBox[{
       RowBox[{"Partition", "[", 
        RowBox[{"Ricciarr", ",", "NA"}], "]"}], ",", "NR"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"R2sqrarr", "=", 
     RowBox[{"Import", "[", 
      RowBox[{"\"\<R2sqr.out\>\"", ",", "\"\<Real64\>\""}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"R2sqrarr", "=", 
     RowBox[{"Partition", "[", 
      RowBox[{
       RowBox[{"Partition", "[", 
        RowBox[{"R2sqrarr", ",", "NA"}], "]"}], ",", "NR"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"R4sqrarr", "=", 
     RowBox[{"Import", "[", 
      RowBox[{"\"\<R4sqr.out\>\"", ",", "\"\<Real64\>\""}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"R4sqrarr", "=", 
     RowBox[{"Partition", "[", 
      RowBox[{
       RowBox[{"Partition", "[", 
        RowBox[{"R4sqrarr", ",", "NA"}], "]"}], ",", "NR"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tval", "=", 
     RowBox[{"-", "1"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    
    RowBox[{"gdat", "=", 
     RowBox[{"garr", "[", 
      RowBox[{"[", "tval", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"\[Phi]", "=", 
     RowBox[{"\[Phi]2arr", "[", 
      RowBox[{"[", "tval", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Tdat", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", "rpatch", "]"}], ",", 
        RowBox[{"Flatten", "[", "apatch", "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"gdat", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Adat", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", "rpatch", "]"}], ",", 
        RowBox[{"Flatten", "[", "apatch", "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"gdat", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Bdat", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", "rpatch", "]"}], ",", 
        RowBox[{"Flatten", "[", "apatch", "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"gdat", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "]"}]}], "}"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Fdat", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", "rpatch", "]"}], ",", 
        RowBox[{"Flatten", "[", "apatch", "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"gdat", "[", 
          RowBox[{"[", "4", "]"}], "]"}], "]"}]}], "}"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Sdat", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", "rpatch", "]"}], ",", 
        RowBox[{"Flatten", "[", "apatch", "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"gdat", "[", 
          RowBox[{"[", "5", "]"}], "]"}], "]"}]}], "}"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Afn", "=", 
     RowBox[{"Interpolation", "[", 
      RowBox[{"Adat", ",", 
       RowBox[{"InterpolationOrder", "\[Rule]", 
        RowBox[{"NR", "-", "1"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"\[Phi]dat", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", "rpatch", "]"}], ",", 
        RowBox[{"Flatten", "[", "apatch", "]"}], ",", 
        RowBox[{"Flatten", "[", "\[Phi]", "]"}]}], "}"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Riccidat", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", "rpatch", "]"}], ",", 
        RowBox[{"Flatten", "[", "apatch", "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"Ricciarr", "[", 
           RowBox[{"[", "tval", "]"}], "]"}], "+", "20"}], "]"}]}], "}"}], 
      "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"R2sqrdat", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", "rpatch", "]"}], ",", 
        RowBox[{"Flatten", "[", "apatch", "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"R2sqrarr", "[", 
           RowBox[{"[", "tval", "]"}], "]"}], "-", "80"}], "]"}]}], "}"}], 
      "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"R4sqrdat", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", "rpatch", "]"}], ",", 
        RowBox[{"Flatten", "[", "apatch", "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"R4sqrarr", "[", 
          RowBox[{"[", "tval", "]"}], "]"}], "]"}]}], "}"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"\[Phi]datCUT", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{"rpatch", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", 
             RowBox[{"NR", "-", "1"}]}], ",", 
            RowBox[{"2", ";;", 
             RowBox[{"NA", "-", "1"}]}]}], "]"}], "]"}], "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"apatch", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", 
             RowBox[{"NR", "-", "1"}]}], ",", 
            RowBox[{"2", ";;", 
             RowBox[{"NA", "-", "1"}]}]}], "]"}], "]"}], "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"\[Phi]", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", 
             RowBox[{"NR", "-", "1"}]}], ",", 
            RowBox[{"2", ";;", 
             RowBox[{"NA", "-", "1"}]}]}], "]"}], "]"}], "]"}]}], "}"}], 
      "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"RiccidatCUT", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{"rpatch", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", 
             RowBox[{"NR", "-", "1"}]}], ",", 
            RowBox[{"2", ";;", 
             RowBox[{"NA", "-", "1"}]}]}], "]"}], "]"}], "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"apatch", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", 
             RowBox[{"NR", "-", "1"}]}], ",", 
            RowBox[{"2", ";;", 
             RowBox[{"NA", "-", "1"}]}]}], "]"}], "]"}], "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Ricciarr", "[", 
            RowBox[{"[", "tval", "]"}], "]"}], "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"2", ";;", 
              RowBox[{"NR", "-", "1"}]}], ",", 
             RowBox[{"2", ";;", 
              RowBox[{"NA", "-", "1"}]}]}], "]"}], "]"}], "+", "20"}], 
         "]"}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"R2sqrdatCUT", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{"rpatch", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", 
             RowBox[{"NR", "-", "1"}]}], ",", 
            RowBox[{"2", ";;", 
             RowBox[{"NA", "-", "1"}]}]}], "]"}], "]"}], "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"apatch", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", 
             RowBox[{"NR", "-", "1"}]}], ",", 
            RowBox[{"2", ";;", 
             RowBox[{"NA", "-", "1"}]}]}], "]"}], "]"}], "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"R2sqrarr", "[", 
            RowBox[{"[", "tval", "]"}], "]"}], "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"2", ";;", 
              RowBox[{"NR", "-", "1"}]}], ",", 
             RowBox[{"2", ";;", 
              RowBox[{"NA", "-", "1"}]}]}], "]"}], "]"}], "-", "80"}], 
         "]"}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"R4sqrdatCUT", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{"rpatch", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", 
             RowBox[{"NR", "-", "1"}]}], ",", 
            RowBox[{"2", ";;", 
             RowBox[{"NA", "-", "1"}]}]}], "]"}], "]"}], "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"apatch", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", 
             RowBox[{"NR", "-", "1"}]}], ",", 
            RowBox[{"2", ";;", 
             RowBox[{"NA", "-", "1"}]}]}], "]"}], "]"}], "]"}], ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"R4sqrarr", "[", 
           RowBox[{"[", "tval", "]"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"2", ";;", 
             RowBox[{"NR", "-", "1"}]}], ",", 
            RowBox[{"2", ";;", 
             RowBox[{"NA", "-", "1"}]}]}], "]"}], "]"}], "]"}]}], "}"}], 
      "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp", "=", "\[Phi]datCUT"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"tmp2", "=", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", 
          RowBox[{"Abs", "[", "z", "]"}]}], "}"}]}], "]"}], "@@@", "tmp"}]}], 
    ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"fn", "=", 
     RowBox[{"Interpolation", "[", "tmp2", "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"rmin", "=", 
     RowBox[{"fn", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1", ",", "1"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"rmax", "=", 
     RowBox[{"fn", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"errPhi", "=", 
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{"fn", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "rmin", ",", "rmax"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "rmin", ",", "rmax"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp", "=", "RiccidatCUT"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"tmp2", "=", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", 
          RowBox[{"Abs", "[", "z", "]"}]}], "}"}]}], "]"}], "@@@", "tmp"}]}], 
    ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"fn", "=", 
     RowBox[{"Interpolation", "[", "tmp2", "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"rmin", "=", 
     RowBox[{"fn", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1", ",", "1"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"rmax", "=", 
     RowBox[{"fn", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"errRicci", "=", 
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{"fn", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "rmin", ",", "rmax"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "rmin", ",", "rmax"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmp", "=", "R2sqrdatCUT"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"tmp2", "=", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", 
          RowBox[{"Abs", "[", "z", "]"}]}], "}"}]}], "]"}], "@@@", "tmp"}]}], 
    ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"fn", "=", 
     RowBox[{"Interpolation", "[", "tmp2", "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"rmin", "=", 
     RowBox[{"fn", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1", ",", "1"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"rmax", "=", 
     RowBox[{"fn", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"errR2", "=", 
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{"fn", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "rmin", ",", "rmax"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "rmin", ",", "rmax"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"errlist", "=", 
     RowBox[{"{", 
      RowBox[{"NR", ",", 
       RowBox[{"Max", "[", 
        RowBox[{"\[Phi]datCUT", "[", 
         RowBox[{"[", 
          RowBox[{"All", ",", "3"}], "]"}], "]"}], "]"}], ",", 
       RowBox[{"Max", "[", 
        RowBox[{"RiccidatCUT", "[", 
         RowBox[{"[", 
          RowBox[{"All", ",", "3"}], "]"}], "]"}], "]"}], ",", 
       RowBox[{"Max", "[", 
        RowBox[{"R2sqrdatCUT", "[", 
         RowBox[{"[", 
          RowBox[{"All", ",", "3"}], "]"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"gdat", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"gdat", "[", 
           RowBox[{"[", "5", "]"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"gdat", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "NA"}], "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"gdat", "[", 
           RowBox[{"[", "5", "]"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "NA"}], "]"}], "]"}]}], "}"}], ",", "errPhi", 
       ",", "errRicci", ",", "errR2"}], "}"}]}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 CellChangeTimes->{{3.539899030396741*^9, 3.5398990443893137`*^9}, {
  3.5398991023021727`*^9, 3.5398992264442663`*^9}, {3.539899333317923*^9, 
  3.539899333749195*^9}, {3.539899500962047*^9, 3.539899531604052*^9}, {
  3.5399011372972927`*^9, 3.539901169990121*^9}, {3.539901200012993*^9, 
  3.539901223636487*^9}, {3.539901636607029*^9, 3.539901637019285*^9}, {
  3.539901677444491*^9, 3.539901677595982*^9}, {3.539949578760297*^9, 
  3.539949580863264*^9}, {3.53998661392113*^9, 3.53998666371027*^9}, {
  3.539986845981512*^9, 3.539986848235993*^9}, {3.5400405601054583`*^9, 
  3.54004060240615*^9}, {3.540751064031855*^9, 3.54075112588262*^9}, {
  3.541397418339259*^9, 3.541397433892971*^9}, {3.541397480594281*^9, 
  3.541397480989303*^9}, {3.541840407130921*^9, 3.5418404099301777`*^9}, {
  3.5419279388387527`*^9, 3.541927944025823*^9}, {3.542451244783697*^9, 
  3.542451274808074*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Run New", "Subsubtitle",
 CellChangeTimes->{{3.539899260141288*^9, 3.539899297289146*^9}, {
  3.541840445367931*^9, 3.541840450071163*^9}, {3.5424448759337378`*^9, 
  3.542444876074532*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"dir", "=", "\"\<SpecTest4/\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.541840483485058*^9, 3.541840488677471*^9}, {
  3.541840570225803*^9, 3.541840572312664*^9}, {3.5419279027094297`*^9, 
  3.5419279027506657`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"\"\<~/Work/\>\"", "<>", "dir"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.542449058767048*^9, 3.542449063874609*^9}, {
   3.542449117626239*^9, 3.5424491230075617`*^9}, 3.542449185263421*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"filelist", "=", 
  RowBox[{"FileNames", "[", "\"\<test_even_03_*\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.542449026399249*^9, 3.54244903840585*^9}, {
   3.542449071418521*^9, 3.542449083130803*^9}, {3.5424491337890987`*^9, 
   3.5424491770316563`*^9}, {3.5424493575869713`*^9, 3.542449445412077*^9}, {
   3.542449490803844*^9, 3.542449491080214*^9}, 3.542450981702395*^9, {
   3.542451353301111*^9, 3.542451353516149*^9}, {3.542451410215209*^9, 
   3.54245141033298*^9}, {3.5424516122247458`*^9, 3.5424516123493633`*^9}, {
   3.54245257154423*^9, 3.542452571725466*^9}, {3.542453041437951*^9, 
   3.542453041624668*^9}, {3.5424553548092203`*^9, 3.542455354894165*^9}, {
   3.5424553853276854`*^9, 3.542455388879409*^9}, {3.5424554215624647`*^9, 
   3.542455421925193*^9}, {3.5424554896354103`*^9, 3.542455489971911*^9}, {
   3.542455861797517*^9, 3.542455861932611*^9}, {3.542456813941805*^9, 
   3.5424568140533457`*^9}, {3.5424568604449863`*^9, 3.542456860620646*^9}, {
   3.542456900989393*^9, 3.542456901690639*^9}, {3.542457136717547*^9, 
   3.5424571367979383`*^9}, {3.542457893387538*^9, 3.5424578939206657`*^9}, {
   3.543666895163241*^9, 3.543666895258054*^9}, {3.5436682888360367`*^9, 
   3.543668288930764*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"test_even_03_20\"\>", ",", "\<\"test_even_03_22\"\>", 
   ",", "\<\"test_even_03_24\"\>", ",", "\<\"test_even_03_26\"\>", 
   ",", "\<\"test_even_03_28\"\>", ",", "\<\"test_even_03_30\"\>", 
   ",", "\<\"test_even_03_32\"\>", ",", "\<\"test_even_03_34\"\>", 
   ",", "\<\"test_even_03_36\"\>", ",", "\<\"test_even_03_38\"\>", 
   ",", "\<\"test_even_03_40\"\>", ",", "\<\"test_even_03_42\"\>", 
   ",", "\<\"test_even_03_44\"\>", ",", "\<\"test_even_03_45\"\>", 
   ",", "\<\"test_even_03_46\"\>", ",", "\<\"test_even_03_48\"\>", 
   ",", "\<\"test_even_03_50\"\>", ",", "\<\"test_even_03_55\"\>", 
   ",", "\<\"test_even_03_60\"\>"}], "}"}]], "Output",
 CellChangeTimes->{{3.542449029368087*^9, 3.542449083635357*^9}, {
   3.5424491348820677`*^9, 3.542449146835939*^9}, 3.542449189906624*^9, {
   3.5424493581542997`*^9, 3.5424493792601347`*^9}, {3.542449412597877*^9, 
   3.542449448815455*^9}, 3.542449494587245*^9, {3.542450480007914*^9, 
   3.542450512192162*^9}, 3.54245099241393*^9, 3.542451181683421*^9, 
   3.54245128475766*^9, 3.542451374824274*^9, 3.542451414583747*^9, 
   3.5424516152286777`*^9, 3.5424525785646677`*^9, 3.5424530535579653`*^9, 
   3.5424539113135767`*^9, 3.5424553605803013`*^9, 3.542455394038323*^9, 
   3.5424554246559887`*^9, 3.5424554971249723`*^9, 3.542455878480865*^9, 
   3.542456562056175*^9, 3.54245682389496*^9, 3.542456869459092*^9, 
   3.542456910695994*^9, 3.542457143920931*^9, 3.5424579018118963`*^9, 
   3.543666907050514*^9, 3.543667148352335*^9, 3.543668298089851*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"datnew", "=", 
  RowBox[{"Table", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"analyse", "[", 
     RowBox[{"dir", "<>", 
      RowBox[{"filelist", "[", 
       RowBox[{"[", "ii", "]"}], "]"}]}], "]"}], "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"ii", ",", "1", ",", 
      RowBox[{"Length", "[", "filelist", "]"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.54184045916241*^9, 3.54184052697576*^9}, {
  3.5418405621280603`*^9, 3.541840584867428*^9}, {3.542456906237458*^9, 
  3.542456907029269*^9}, {3.542457140444964*^9, 3.542457140748765*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "20", ",", "0.000020252169770031507`", ",", "0.11364027066895943`", ",", 
     "0.9893294549731309`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.0293460215232613`"}], ",", "1.2446884484921032`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.054230587097750256`"}], ",", "0.029416462726374756`"}],
       "}"}], ",", "2.0037566978216018`*^-6", ",", "0.007871430180056496`", 
     ",", "0.06300031856471988`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "22", ",", "5.0482005300351496`*^-6", ",", "0.05968926714803047`", ",", 
     "0.5203202990730205`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.0350809420765628`"}], ",", "1.248817013667423`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.049511817731470203`"}], ",", "0.034633279168760335`"}],
       "}"}], ",", "4.793706068540397`*^-7", ",", "0.004064182121186931`", 
     ",", "0.032520354254398434`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "24", ",", "1.2257468702276422`*^-6", ",", "0.03196822339870664`", ",", 
     "0.2691889997032746`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.039168543916748`"}], ",", "1.2516349892664098`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.04734737156927936`"}], ",", "0.03703553010810552`"}], 
      "}"}], ",", "1.1400706526247543`*^-7", ",", "0.002073377180851065`", 
     ",", "0.016588721262801996`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "26", ",", "2.8997906071101426`*^-7", ",", "0.016851043444823688`", ",", 
     "0.1375634889932229`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.0422236062877843`"}], ",", "1.2536783197062302`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.04635814716827557`"}], ",", "0.03814678289266451`"}], 
      "}"}], ",", "2.7032644887078713`*^-8", ",", "0.0010484442104047183`", 
     ",", "0.00838796667163897`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "28", ",", "7.016529730021988`*^-8", ",", "0.008770278163492407`", ",", 
     "0.069640718248408`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.0445890923864076`"}], ",", "1.2552317152665229`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.04589041361041494`"}], ",", "0.03868312719012953`"}], 
      "}"}], ",", "6.400079743704482`*^-9", ",", "0.0005277516278796719`", 
     ",", "0.004222118346136756`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "30", ",", "4.69524857643538`*^-8", ",", "0.004519826857457332`", ",", 
     "0.034970723028294515`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.046499278580157`"}], ",", "1.2563618958051088`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.04674982481983015`"}], ",", "0.03786354870753848`"}], 
      "}"}], ",", "1.601520626350537`*^-9", ",", "0.0002710247398252662`", 
     ",", "0.002168230508811773`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "32", ",", "3.988855341674403`*^-9", ",", "0.002307801137256149`", ",", 
     "0.017723084716834592`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.0480001172810427`"}], ",", "1.2574252919321125`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.04570288040293155`"}], ",", "0.0389420627552283`"}], 
      "}"}], ",", "3.583724067058346`*^-10", ",", "0.00013272574504327587`", 
     ",", "0.001061811515499227`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "34", ",", "9.555480057741325`*^-10", ",", "0.0011706163742353226`", ",", 
     "0.00915115996352256`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.04925822196767`"}], ",", "1.258233808239982`"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.045647104219020025`"}], ",", "0.039019292391383034`"}],
       "}"}], ",", "8.474468976547495`*^-11", ",", "0.00006617911644468987`", 
     ",", "0.0005294341831514378`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "36", ",", "2.2884586011858852`*^-10", ",", "0.000590354535493276`", ",", 
     "0.004692125939214975`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.0503092442691844`"}], ",", "1.2589067138589556`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.045628126478559114`"}], ",", "0.039054993231502605`"}],
       "}"}], ",", "2.004464329005305`*^-11", ",", "0.00003293549597255331`", 
     ",", "0.0002634842566334458`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "38", ",", "5.4214535871802535`*^-11", ",", "0.0002962818181053706`", ",",
      "0.0023912852925604966`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.05119673381811`"}], ",", "1.2594739916863151`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.0456227827146307`"}], ",", "0.039073906253197524`"}], 
      "}"}], ",", "4.742621243777621`*^-12", ",", "0.000016377318641624827`", 
     ",", "0.00013101861532105894`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "40", ",", "1.2916111860754523`*^-11", ",", "0.0001480915109048908`", ",",
      "0.0012123028239443556`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.0519531955954426`"}], ",", "1.2599571141066703`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.04562309626574171`"}], ",", "0.039084899827115896`"}], 
      "}"}], ",", "1.1228784693659356`*^-12", ",", "8.145519128725012`*^-6", 
     ",", "0.00006516417062985302`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "42", ",", "3.0819153377247488`*^-12", ",", "0.00007434861992550168`", 
     ",", "0.0006117940369847474`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.0526033310260856`"}], ",", "1.2603721464371649`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.04562571825690083`"}], ",", "0.03909187574314964`"}], 
      "}"}], ",", "2.6634088766445785`*^-13", ",", "4.052855931267222`*^-6", 
     ",", "0.000032422851503864965`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "44", ",", "7.279570343202302`*^-13", ",", "0.00003781408835834554`", ",",
      "0.0003075122069446934`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.0531662199519536`"}], ",", "1.2607313952651682`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.045629180757427903`"}], ",", "0.039096664051427255`"}],
       "}"}], ",", "6.354397816741263`*^-14", ",", "2.0190830288592456`*^-6", 
     ",", "0.000016152665094343244`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "45", ",", "3.55717249086441`*^-13", ",", "0.000026959290206463038`", ",",
      "0.00021755655160404785`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.053419927651995`"}], ",", "1.2608933940628941`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.045629835752117306`"}], ",", "0.039099782945733644`"}],
       "}"}], ",", "3.1233253603496305`*^-14", ",", "1.4289272047105844`*^-6",
      ",", "0.000011431417995815623`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "46", ",", "1.7274760831420994`*^-13", ",", "0.00001915307503352892`", 
     ",", "0.0001540230393004549`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.053656822487554`"}], ",", "1.2610444649892902`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.04563285103517562`"}], ",", "0.03910015603745262`"}], 
      "}"}], ",", "1.547025911266728`*^-14", ",", "1.011662884300423`*^-6", 
     ",", "8.093303293278659`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "48", ",", "9.473779883997894`*^-14", ",", "9.66606363306255`*^-6", ",", 
     "0.00007690037823238072`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.054087009664104`"}], ",", "1.2613189540871823`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.04563648171151474`"}], ",", "0.039102788612726556`"}], 
      "}"}], ",", "4.055238153219937`*^-15", ",", "5.148958574373787`*^-7", 
     ",", "4.119166943354759`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "50", ",", "1.201711084221932`*^-13", ",", "4.862923418613718`*^-6", ",", 
     "0.00003828299772123955`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.0544663181101863`"}], ",", "1.2615609556749916`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.045640028137288784`"}], ",", "0.03910476092471686`"}], 
      "}"}], ",", "1.3077596852115865`*^-15", ",", "2.702133679189438`*^-7", 
     ",", "2.1617070207223756`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "55", ",", "8.012699901675182`*^-13", ",", "8.597654677089395`*^-7", ",", 
     "6.854388345800544`*^-6", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.055239262306402`"}], ",", "1.2620538521860576`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.045649973035188`"}], ",", "0.03910603289141522`"}], 
      "}"}], ",", "1.0401876232152153`*^-15", ",", "9.287322413083641`*^-8", 
     ",", "7.429855854464351`*^-7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "60", ",", "5.979927291682673`*^-12", ",", "7.88167252352423`*^-7", ",", 
     "8.970364433480427`*^-6", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.05582557172874`"}], ",", "1.2624300869399903`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.04563477013123619`"}], ",", "0.03912979825577393`"}], 
      "}"}], ",", "7.013826987829877`*^-15", ",", "1.0857964527213701`*^-7", 
     ",", "8.686368501162562`*^-7"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.541840479262891*^9, {3.541840531555607*^9, 3.541840587642853*^9}, 
   3.541842027546479*^9, 3.5418429614683113`*^9, 3.541928798294837*^9, 
   3.541929015867506*^9, 3.5424408585433187`*^9, {3.542444892808907*^9, 
   3.542444954246806*^9}, 3.542445044569036*^9, {3.54244705912576*^9, 
   3.5424470663304996`*^9}, 3.5424471026511993`*^9, 3.54244719337759*^9, 
   3.542447411066594*^9, 3.542449149632354*^9, 3.542449195042211*^9, 
   3.542449383759947*^9, {3.5424494158541803`*^9, 3.542449451376375*^9}, 
   3.542449517005858*^9, {3.542449557402953*^9, 3.542449561725409*^9}, {
   3.5424504968507957`*^9, 3.5424505212960253`*^9}, 3.5424509962857533`*^9, 
   3.5424511880523157`*^9, 3.542451379698039*^9, 3.542451428372284*^9, 
   3.542451618652093*^9, 3.542452592728232*^9, 3.542453063533029*^9, 
   3.5424539130073*^9, {3.542455376360299*^9, 3.5424554297385178`*^9}, 
   3.542455512952731*^9, 3.5424558966526203`*^9, 3.542456567273329*^9, 
   3.5424568268761683`*^9, 3.542456870275257*^9, 3.542456911633438*^9, 
   3.5424571446542063`*^9, 3.542457905545882*^9, 3.5436669188060226`*^9, 
   3.5436671509207783`*^9, 3.543668301480494*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"datnew", "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.54244087777771*^9, 3.542440884872513*^9}, {
  3.542450538146228*^9, 3.542450539311035*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"20", ",", "0.000020252169770031507`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "5.0482005300351496`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "1.2257468702276422`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", "2.8997906071101426`*^-7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "7.016529730021988`*^-8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30", ",", "4.69524857643538`*^-8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", "3.988855341674403`*^-9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"34", ",", "9.555480057741325`*^-10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"36", ",", "2.2884586011858852`*^-10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"38", ",", "5.4214535871802535`*^-11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "1.2916111860754523`*^-11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"42", ",", "3.0819153377247488`*^-12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"44", ",", "7.279570343202302`*^-13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"45", ",", "3.55717249086441`*^-13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"46", ",", "1.7274760831420994`*^-13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"48", ",", "9.473779883997894`*^-14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"50", ",", "1.201711084221932`*^-13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"55", ",", "8.012699901675182`*^-13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"60", ",", "5.979927291682673`*^-12"}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{
  3.542440885280212*^9, {3.542444913036989*^9, 3.5424449551586514`*^9}, 
   3.5424450461187267`*^9, 3.542447069537778*^9, 3.542447103696225*^9, 
   3.542447194259089*^9, 3.5424474134892397`*^9, 3.54244915190106*^9, 
   3.542449195995562*^9, 3.542449385515627*^9, {3.542449416017282*^9, 
   3.542449451669491*^9}, 3.542449564622425*^9, {3.5424504976924477`*^9, 
   3.5424505403006353`*^9}, 3.5424509968721457`*^9, 3.54245130230337*^9, 
   3.542451380200798*^9, 3.542451428893146*^9, 3.542451618958194*^9, 
   3.5424525933568287`*^9, 3.542453064131105*^9, 3.54245391313307*^9, {
   3.5424554059472857`*^9, 3.542455429873788*^9}, 3.542455513083509*^9, 
   3.5424558975459337`*^9, 3.5424565675228777`*^9, 3.5424568270871162`*^9, 
   3.5424568703204823`*^9, 3.542456911747376*^9, 3.5424571447096453`*^9, 
   3.542457905757406*^9, 3.543666924452667*^9, 3.543667152115453*^9, 
   3.5436683016277637`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"datnew", "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{3.542440889641802*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"20", ",", "0.11364027066895943`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "0.05968926714803047`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "0.03196822339870664`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", "0.016851043444823688`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "0.008770278163492407`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30", ",", "0.004519826857457332`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", "0.002307801137256149`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"34", ",", "0.0011706163742353226`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"36", ",", "0.000590354535493276`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"38", ",", "0.0002962818181053706`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "0.0001480915109048908`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"42", ",", "0.00007434861992550168`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"44", ",", "0.00003781408835834554`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"45", ",", "0.000026959290206463038`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"46", ",", "0.00001915307503352892`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"48", ",", "9.66606363306255`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"50", ",", "4.862923418613718`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"55", ",", "8.597654677089395`*^-7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"60", ",", "7.88167252352423`*^-7"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.542440890100046*^9, {3.5424449139637327`*^9, 3.542444957077367*^9}, 
   3.542445046945858*^9, 3.542447073518511*^9, 3.542447104533642*^9, 
   3.542447194848877*^9, 3.542447414440753*^9, 3.542449152564803*^9, 
   3.542449196627326*^9, {3.5424493861316566`*^9, 3.542449451800539*^9}, 
   3.542449565157639*^9, {3.542450498444474*^9, 3.54245054245187*^9}, 
   3.542450997043789*^9, 3.542451303024694*^9, 3.5424513807607193`*^9, 
   3.542451428953644*^9, 3.5424516191371593`*^9, 3.5424525935220623`*^9, 
   3.542453064299242*^9, 3.5424539131762543`*^9, {3.5424554060503283`*^9, 
   3.54245542994421*^9}, 3.5424555132174788`*^9, 3.542455897661892*^9, 
   3.542456567555414*^9, 3.542456827132901*^9, 3.542456870355793*^9, 
   3.5424569117946568`*^9, 3.5424571447705173`*^9, 3.542457905825324*^9, 
   3.543666926922798*^9, 3.5436671534971*^9, 3.54366830166568*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"datnew", "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{3.542440896834086*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"20", ",", "0.9893294549731309`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "0.5203202990730205`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "0.2691889997032746`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", "0.1375634889932229`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "0.069640718248408`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30", ",", "0.034970723028294515`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", "0.017723084716834592`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"34", ",", "0.00915115996352256`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"36", ",", "0.004692125939214975`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"38", ",", "0.0023912852925604966`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "0.0012123028239443556`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"42", ",", "0.0006117940369847474`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"44", ",", "0.0003075122069446934`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"45", ",", "0.00021755655160404785`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"46", ",", "0.0001540230393004549`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"48", ",", "0.00007690037823238072`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"50", ",", "0.00003828299772123955`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"55", ",", "6.854388345800544`*^-6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"60", ",", "8.970364433480427`*^-6"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.542440897131227*^9, {3.542444917255405*^9, 3.5424449577188*^9}, 
   3.542445047695307*^9, {3.5424470771226387`*^9, 3.542447105541175*^9}, 
   3.542447195384787*^9, 3.542447415341098*^9, 3.5424491531519337`*^9, 
   3.5424491971620626`*^9, {3.542449387330824*^9, 3.542449451881259*^9}, 
   3.542449565626628*^9, {3.542450498580698*^9, 3.542450543719541*^9}, 
   3.5424509971324883`*^9, 3.5424513035203238`*^9, 3.542451382506474*^9, 
   3.542451429175064*^9, 3.542451619274877*^9, 3.542452593621578*^9, 
   3.5424530644546013`*^9, 3.542453913245871*^9, {3.542455406217649*^9, 
   3.5424554300849543`*^9}, 3.542455513329844*^9, 3.542455898072315*^9, 
   3.542456567588847*^9, 3.542456827236044*^9, 3.542456870434675*^9, 
   3.542456911845127*^9, 3.542457144837475*^9, 3.542457905892352*^9, 
   3.543666929285446*^9, 3.543667181100588*^9, 3.54366830171684*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Process", "Subsubtitle",
 CellChangeTimes->{{3.539899260141288*^9, 3.539899297289146*^9}, {
  3.541840445367931*^9, 3.541840450071163*^9}, {3.541840628970079*^9, 
  3.5418406299368773`*^9}}],

Cell[BoxData[
 RowBox[{"(*", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"{", 
   RowBox[{"NR", ",", 
    RowBox[{"Max", "[", 
     RowBox[{"\[Phi]datCUT", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "3"}], "]"}], "]"}], "]"}], ",", 
    RowBox[{"Max", "[", 
     RowBox[{"RiccidatCUT", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "3"}], "]"}], "]"}], "]"}], ",", 
    RowBox[{"Max", "[", 
     RowBox[{"R2sqrdatCUT", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "3"}], "]"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"gdat", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{"gdat", "[", 
        RowBox[{"[", "5", "]"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"gdat", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "NA"}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{"gdat", "[", 
        RowBox[{"[", "5", "]"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "NA"}], "]"}], "]"}]}], "}"}], ",", "errPhi", ",", 
    "errRicci", ",", "errR2", ",", "avdA", ",", "vardA"}], "}"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", "*)"}]], "Input",
 CellChangeTimes->{{3.541840631715877*^9, 3.541840636435766*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"datlist", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "\"\<N\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "\"\<|\[Phi]|\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "\"\<Ricci\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "\"\<R2\>\""}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.541840702890521*^9, 3.5418407245534763`*^9}, 
   3.541840791667498*^9, {3.541843007465967*^9, 3.541843019433546*^9}, {
   3.541843086288761*^9, 3.541843141797089*^9}, {3.5419279543755293`*^9, 
   3.5419279588970203`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"fn", "=", 
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Log", "[", 
        RowBox[{"10", ",", "y"}], "]"}]}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5398967726403*^9, 3.539896811850618*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pos1", "=", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"plt2", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"fn", "@@@", 
        RowBox[{"Thread", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"datnew", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", 
              RowBox[{"datlist", "[", 
               RowBox[{"[", 
                RowBox[{"pos1", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}], ",", 
           RowBox[{"datnew", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", 
              RowBox[{"datlist", "[", 
               RowBox[{"[", 
                RowBox[{"pos2", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}]}], 
          "}"}], "]"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Hue", "[", "0.6", "]"}], "}"}]}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"Show", "[", 
      RowBox[{"plt2", ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"datlist", "[", 
           RowBox[{"[", 
            RowBox[{"pos1", ",", "2"}], "]"}], "]"}], ",", 
          RowBox[{"datlist", "[", 
           RowBox[{"[", 
            RowBox[{"pos2", ",", "2"}], "]"}], "]"}]}], "}"}]}]}], "]"}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
   RowBox[{"{", 
    RowBox[{"pos2", ",", "2", ",", 
     RowBox[{"Length", "[", "datlist", "]"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.5398967561531057`*^9, 3.539896796444601*^9}, 
   3.539898439637827*^9, {3.539949826885099*^9, 3.539949847532065*^9}, {
   3.539949905899968*^9, 3.53994995217867*^9}, {3.539957734047173*^9, 
   3.539957797230307*^9}, {3.53995950255326*^9, 3.539959514617424*^9}, {
   3.5399812304344473`*^9, 3.5399812530821333`*^9}, {3.5399839966998158`*^9, 
   3.5399840134090977`*^9}, {3.5400464442327843`*^9, 3.540046458208152*^9}, {
   3.541840665888206*^9, 3.541840676823649*^9}, {3.54184072921821*^9, 
   3.541840913286421*^9}, {3.5418429139676533`*^9, 3.541842928335372*^9}, {
   3.541842971005507*^9, 3.541842990671466*^9}, {3.541843026803639*^9, 
   3.541843033133144*^9}, {3.541843159575173*^9, 3.5418431984702673`*^9}, {
   3.541843229468863*^9, 3.541843241358378*^9}, 3.541843276700141*^9, {
   3.541843357315482*^9, 3.541843361355706*^9}, {3.542441082905068*^9, 
   3.542441129430141*^9}, {3.5424417361283703`*^9, 3.542441736262867*^9}, {
   3.542450559283257*^9, 3.542450570852919*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQDQEmDtt/ng3UOSZ0AMI3c/AIXfX1j74olG/hcCHE
xLlqqTiUb+XgeVYuplNNCsq3cUie801i0lwZKN/O4cdbnt0WAbJQvoNDmhjb
3NgzClC+o4Ndy+lwGS4lKN/J4crOKz9euitD+c4Olaf1fit2qED5Lg4mk5bv
ljyuCuW7Ouy99NprJ6s6lO/mcGdTqPAsNw0Iv8HNgdvPZfLVp1A+g7vD5kN7
3ha2aUL5Hg5G9quVWXm0oHxPhxkSIkUq16HyDd4OhodlnjobwvT7OcTOk3sV
UqR2AAAQf1S2
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"N\"", TraditionalForm], 
    FormBox["\"|\[Phi]|\"", TraditionalForm]},
  AxesOrigin->{20., 0},
  PlotRange->{{20., 60.}, {-13.023476709989698`, 0}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Print",
 CellChangeTimes->{{3.541843199097535*^9, 3.5418432102216597`*^9}, 
   3.5418432429247828`*^9, 3.541843277588459*^9, 3.541843361923048*^9, 
   3.541928833511001*^9, 3.5419290218013697`*^9, {3.5424410652305613`*^9, 
   3.542441130079093*^9}, 3.542441737278977*^9, {3.5424505501332912`*^9, 
   3.542450571556435*^9}, 3.5424513230920763`*^9, 3.54245138744206*^9, 
   3.542451461837307*^9, 3.542451621567634*^9, 3.542452596658401*^9, 
   3.5424530833657427`*^9, 3.542453917214725*^9, {3.542455409583921*^9, 
   3.542455435053499*^9}, 3.54245551385142*^9, 3.542455904501981*^9, 
   3.54245656793717*^9, 3.542456701501598*^9, 3.5424568273830976`*^9, 
   3.542456870552787*^9, 3.542456916977112*^9, 3.542457149437358*^9, 
   3.542457914936095*^9, 3.543666936803714*^9, 3.543667184793209*^9, 
   3.5436683103964767`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQDQEmDsv8LTJFLN/th/DNHCSeGl58O/UzlG/h8O/d
c681b75D+VYOwfv4p+yJ/wPl2zjc9fTI2FrCcADCt3NwnbO0wf8QE5Tv4BCX
aF6kLcEK5Ts6bHzQw/O4mB3Kd3Iw4v918NAVTijf2cH9Y9WuT5Y8UL6LQ9rR
yyIHF/FB+a4OFhlrOS42C0D5bg7VN09NqN4gCOE3uDl8//s55oubEFTe3eHu
BrN7f+7B+B4ONi5226X4RaB8T4cplw5/nesgCtXv7RB6/exjQ2cJqLyfw/vC
ZffuZEocAADBQV6U
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"N\"", TraditionalForm], 
    FormBox["\"Ricci\"", TraditionalForm]},
  AxesOrigin->{20., 0},
  PlotRange->{{20., 60.}, {-6.1033816136446, 0}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Print",
 CellChangeTimes->{{3.541843199097535*^9, 3.5418432102216597`*^9}, 
   3.5418432429247828`*^9, 3.541843277588459*^9, 3.541843361923048*^9, 
   3.541928833511001*^9, 3.5419290218013697`*^9, {3.5424410652305613`*^9, 
   3.542441130079093*^9}, 3.542441737278977*^9, {3.5424505501332912`*^9, 
   3.542450571556435*^9}, 3.5424513230920763`*^9, 3.54245138744206*^9, 
   3.542451461837307*^9, 3.542451621567634*^9, 3.542452596658401*^9, 
   3.5424530833657427`*^9, 3.542453917214725*^9, {3.542455409583921*^9, 
   3.542455435053499*^9}, 3.54245551385142*^9, 3.542455904501981*^9, 
   3.54245656793717*^9, 3.542456701501598*^9, 3.5424568273830976`*^9, 
   3.542456870552787*^9, 3.542456916977112*^9, 3.542457149437358*^9, 
   3.542457914936095*^9, 3.543666936803714*^9, 3.543667184793209*^9, 
   3.543668310402349*^9}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQDQEmDspzwgQSRYv3Q/hmDkEPTi+dp3EJyrdwaOCu
K/lh8wjKt3Lwe+RwLHHiayjfxkHrYfLVhc2foHw7B+W21Sl/fL5D+Q4OT9gF
l/xm/QPlOzq8ec8+46kfwwEI38mh4l73R46FTFC+s0Pr021SE36wQPkuDsVb
7248HMIO5bs6nPn+xJ9jKyeU7+ZwYWrRvNsSPBB+g5vDywunvi3z4YXKuzt4
JbMKX67ng/I9HHSU07TOlwhA+Z4OZbMu1zKsFoTq93b4wHHs4vflIlB5P4dr
GQW9QQYiBwAJW11n
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"N\"", TraditionalForm], 
    FormBox["\"R2\"", TraditionalForm]},
  AxesOrigin->{20., 0},
  PlotRange->{{20., 60.}, {-5.164031293594448, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Print",
 CellChangeTimes->{{3.541843199097535*^9, 3.5418432102216597`*^9}, 
   3.5418432429247828`*^9, 3.541843277588459*^9, 3.541843361923048*^9, 
   3.541928833511001*^9, 3.5419290218013697`*^9, {3.5424410652305613`*^9, 
   3.542441130079093*^9}, 3.542441737278977*^9, {3.5424505501332912`*^9, 
   3.542450571556435*^9}, 3.5424513230920763`*^9, 3.54245138744206*^9, 
   3.542451461837307*^9, 3.542451621567634*^9, 3.542452596658401*^9, 
   3.5424530833657427`*^9, 3.542453917214725*^9, {3.542455409583921*^9, 
   3.542455435053499*^9}, 3.54245551385142*^9, 3.542455904501981*^9, 
   3.54245656793717*^9, 3.542456701501598*^9, 3.5424568273830976`*^9, 
   3.542456870552787*^9, 3.542456916977112*^9, 3.542457149437358*^9, 
   3.542457914936095*^9, 3.543666936803714*^9, 3.543667184793209*^9, 
   3.543668310408455*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{"Fit", "[", 
    RowBox[{
     RowBox[{"fn", "@@@", 
      RowBox[{"Thread", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"datnew", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", 
            RowBox[{"datlist", "[", 
             RowBox[{"[", 
              RowBox[{"pos1", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}], ",", 
         RowBox[{"datnew", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", 
            RowBox[{"datlist", "[", 
             RowBox[{"[", 
              RowBox[{"3", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}]}], "}"}], 
       "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "x"}], "}"}], ",", "x"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{"tmp", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "20", ",", "50"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"fn", "@@@", 
       RowBox[{"Thread", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"datnew", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", 
             RowBox[{"datlist", "[", 
              RowBox[{"[", 
               RowBox[{"pos1", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}], ",", 
          
          RowBox[{"datnew", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", 
             RowBox[{"datlist", "[", 
              RowBox[{"[", 
               RowBox[{"3", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}]}], "}"}],
         "]"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Hue", "[", "0.6", "]"}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.54245674720265*^9, 3.5424568034490767`*^9}, {
  3.5424569232397614`*^9, 3.542456923303692*^9}, {3.543666947760214*^9, 
  3.543666951628304*^9}}],

Cell[BoxData[
 RowBox[{"1.8300112539496587`", "\[VeryThinSpace]", "-", 
  RowBox[{"0.1404157289328228`", " ", "x"}]}]], "Output",
 CellChangeTimes->{
  3.5424568350034533`*^9, 3.542456870688485*^9, {3.542456917066584*^9, 
   3.542456923825878*^9}, 3.542457149874111*^9, 3.54245791500002*^9, {
   3.54366694080194*^9, 3.543666952219605*^9}, 3.543667188447228*^9, 
   3.54366831045052*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV0flbzAkcwPFRmSazTTV9O2xUqB5El6FRmj5N11etaVg2ZLdSdCBtxjaY
bE8qUmzPxGyHoprFKKGSTOn7UWQtlUXHIjli02HGKjUdWn54P68/4D1v6+51
27RoNNqaL311q9R3Fo3GAcuNa4b5AhVFLHBkhGhxQBZlH961UUXdrjKn1+hw
gJWo17orQkUtbB+YsVOPA+Mnb5/LFauo92ZSTSebA08eeYS8L1FR+wqf912y
5YA0yKExb1RFZZ9PvBMayIFDpbqkWKimqAZFKiXjwER+n0mbRk25iwK+Xeq2
HFbOF2drov+j1IU7HJofLgeLz0ud2qiPVPJQ4EhY9ApIyx90GTAYoRybozsV
s1zBq01MpEo+UebGdK5liSuUbrS3+PPBKGX9rqcK/LgQvL+MluGlobTfiF9F
/suFnC2c1dll45TVBulv1UkrYU/O6xr+1AS1WdAXXGntBqVbw7QTdkxRrXUN
RU9r3WBfuvbe725+puYGrc+lC9wh9mqnfAWDhpk77C72qNyhcc+JgzMbaOgy
KYbe9FWwc0tvvyJqBo6ZMFSyxR7AMypozrLSwrwNPwgD73nAeruOR+zHWijS
s3WyD+dBwzb5njiJNsb5Odlf1/YE4c//pDCW6WDxaJ08ocATOOeKbcTdOqgx
b5wzZAUAigfL7WQz0fBuGhbHA0iZqeLEQDp6V2UsGKwD4OT+taZomI70V/Yn
jul7Ae1DolS7XBffBrBu3drkBdai2hheMAOr/IQtErkXpAQnJcyZZqDhYafe
zBEvMNRV9HOv6mHGjLVKJy8+DL6IGlkcOgulaFC0JIcPw+nHdoeYMfEI2yFE
8ZoPvGOuFo73mVhQlNVZ5+ANz26INnWJvkGP3RnhtsneUKI010V7fZzc13zB
5r43KF8G+Sd16ON5s4gWuakPEDHM691JLOzVFE4diPKB/Pql+ZJlBrjKdPZQ
X6UPxLu91v/wzABtEl36y3V8wbXx17G1AYa4iJ11lr7WF8IlwctMzxiiBfiu
elngC+XbP9CXDBtiYeWpHvaQLzCv8djhQUboHsrhP+H6wYlT7W+T5UYYI4yt
HDvqB859Vh8pGhtTH09P/P7UD1QRS3KFIWysl7brtNj5Q5cohX7/EhsPnVxt
sUnsD48HMsu3M40x6uGUev8tf9CMPrcYDDNGbonRmbkG5JcBwwuaqo0xr6Zp
i1kYCac66iOuGxBoNrOm62wZCfNZbTvzIwl8XszzGCsnwU4m2GWynUA5707x
6goSFlm27sqOItBF3BU7eJkEZ4eWuPRYAgUD45PONSTwBffiE+IJTPvbc94N
JCH8+B1RgITAj4V3Yx61k1DMQsl4DoFKt3WtNp0k/CHzTNp7ksDkzicuv3SR
cN6SSlLLCGQZDU6YPyXhskPDwbd5BC5OZR3/6QUJNwX1yQ9PExge+33lu34S
Xh6vTb1QRuBC3Wem7oMkvDHlptleJPB9aeSBrCES+oqupZ2pIFDSvdfHUU2C
uqImXXaFwFxhbodohARaW/WRlGsEhg5Zuzd/IkEnmJMxVUug3VHFabMxEvR6
qjLESgKrm5TRynESjFSVR+NuEHggzLuFOUmCSaJL5rsGAvlT95x/nCJh9vSV
zEgkkJG/XlbxmYQ5h52zem4S2Laie3x6mgRrgytZm5sI/B+AekiA
      "]]}}, {{}, 
    {Hue[0.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQDQEmDsv8LTJFLN/th/DNHCSeGl58O/UzlG/h8O/d
c681b75D+VYOwfv4p+yJ/wPl2zjc9fTI2FrCcADCt3NwnbO0wf8QE5Tv4BCX
aF6kLcEK5Ts6bHzQw/O4mB3Kd3Iw4v918NAVTijf2cH9Y9WuT5Y8UL6LQ9rR
yyIHF/FB+a4OFhlrOS42C0D5bg7VN09NqN4gCOE3uDl8//s55oubEFTe3eHu
BrN7f+7B+B4ONi5226X4RaB8T4cplw5/nesgCtXv7RB6/exjQ2cJqLyfw/vC
ZffuZEocAADBQV6U
      "]]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{20., -5.2},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5424568350034533`*^9, 3.542456870688485*^9, {3.542456917066584*^9, 
   3.542456923825878*^9}, 3.542457149874111*^9, 3.54245791500002*^9, {
   3.54366694080194*^9, 3.543666952219605*^9}, 3.543667188447228*^9, 
   3.543668310452166*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{"Fit", "[", 
    RowBox[{
     RowBox[{"fn", "@@@", 
      RowBox[{"Thread", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"datnew", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", 
            RowBox[{"datlist", "[", 
             RowBox[{"[", 
              RowBox[{"pos1", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}], ",", 
         RowBox[{"datnew", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", 
            RowBox[{"datlist", "[", 
             RowBox[{"[", 
              RowBox[{"3", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}]}], "}"}], 
       "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "x"}], "}"}], ",", "x"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{"tmp", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "30", ",", "50"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"fn", "@@@", 
       RowBox[{"Thread", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"datnew", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", 
             RowBox[{"datlist", "[", 
              RowBox[{"[", 
               RowBox[{"pos1", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}], ",", 
          
          RowBox[{"datnew", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", 
             RowBox[{"datlist", "[", 
              RowBox[{"[", 
               RowBox[{"3", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}]}], "}"}],
         "]"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Hue", "[", "0.6", "]"}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.54245674720265*^9, 3.5424568034490767`*^9}, {
  3.543666957948079*^9, 3.54366696265212*^9}}],

Cell[BoxData[
 RowBox[{"1.8300112539496587`", "\[VeryThinSpace]", "-", 
  RowBox[{"0.1404157289328228`", " ", "x"}]}]], "Output",
 CellChangeTimes->{{3.542456773379547*^9, 3.5424568039193974`*^9}, 
   3.542457149977521*^9, 3.542457915076902*^9, {3.543666955002363*^9, 
   3.543666963287323*^9}, 3.543667191069242*^9, 3.543668310504661*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx30w1HkcwHFaxGLtrh+nBwyj1FC0dbpSP59ddvd7dYgeVOK4KMqsUyHO
aXuSNnKhMxl2R2dtxRpK66nVJ5vDkZn2StaU1F50TqW6njx13R/vec/L7Yfk
8Pg5JiYmwV/6/wIbg4WJCQ3b8iNlYjsGstoPmRea0jBWIF1ozWGgIZ1t5sGg
IatQWdvHZeCPRrEpsaChsuSVfqsjAxUtmqkCGxr+rTi+IM6ZgdMJxROu82go
1lTXSL0YqOkIHQzg0aB/PNXXLGag15Hf1UfiaNjEK7P3ljIwO/jhnoN3aWAz
e88VTDLwg3159/LVAVB3ybKzP8kMI+S8kH9KA2AJjzgPPzRDjuDwm3wGQMLL
tISEbeZoVV/DZfoB5KZc3Xev0xw1we/8MQlA4vko9qbAAiO+W/I+7SKAdxcz
M6nVAq07fU+euwfQ6yP8dsZrLh5KDnYeYfKB94fE1rZqLk4UBcjk6/mQ6aXM
NXGyxJj5C3MjkvlQmj7koTlliSf7bAo2KPmQ/d5CM2ZihdpZ/b6KB3wQrVs3
O+eAFV7ZpQ7lsQSgb4jxLx23QtnCAx26QAH4OeVeeBvHxOztNuzmVAFkCW7U
+t5nomd7y+7n1QKQKR43jYdYo1FF5/00JIDDOrvMPLTGLa39WuIQCN7zfXyr
/W2wyXeH1HFjIGgiw+bmNdigj3v9V+TnQHCPk57ftMgWI/nOTdeuBcIWhdyp
WGGLpQ+jlx0fCYQ9Fd3hrRwW3jHIVm52CoLwsx/UlUdZeN2sRxAVEgRmtdSs
zRQL66qHF/dIg+DXYtp8R5IdxkiZ1MHGIJhQR5h6jNqhWaNL4YIXQcA2rCkY
8GFja6LlM09XIZTSIZ/YCWz03GDBl2wVQs76wUeWSjZWVRlSnHKFYFSMl795
xMZ58SUrdc1CUKdLJVoHDvLDEmdVr4RgeH6mWRzOwaxmtnzCTQRpWudhnYyD
SaG9ooPbv9jL8+jnTg4mx0bd3nFGBCPTmhlvUy7G3x/Qg1YE7YFdMv81XGSn
J4zFvhWBqUdYoVUaF/uK7/SPLBJD3d6Y1O5aLvKHRb3KXWLQBY3qyTgXL+Vf
CY8vFAO/5BVcXmKP7o1Gde5tMawIzpZNxdhjGGsFd2RSDMfLToTYyu2x6Mnm
japlBEShnJfsB/bY7RjrkPg9gdR0V/k7FoUNGceex50nYLlG2XVhI4VXt2f8
cruTgHV0fZ/PCQpX31qarewiwGLVZ3ifpPDG0sH9Od0EOG11HktzKOyYXCsm
PQQcXeoy3XMpHCibnunpI+A2VLvYIY/CmeEj+/+8T2B1dE32ZBGFJDFH9NRI
YHe0annHbxTeueu3SvcXgT0sleFWJYXha0fdKp8RSGyrOtGmpDDSmszEjxKQ
uFQNNqoolKitGv4eI5A5VJlzpZrC4td5bq9fEzgXfXGo4BqF83aut9O/IVDM
ung6r4FCefuL6atvCZS0Vaw6fZ1CVVHIwKF3BMpcKmTHGils+Zpd8PEjAdWQ
wi+1lUJajlmGTwQun1U8SblBoc4iZV/LJIEaWpEn0VLY++CuMGuaQL1c/nTv
TQrD4NjKqBkC10Pk+XFIYf8lnhs9S6Bptvyb2FsU7uQYWa6fCbTUlhuj2il8
nFE0/fmLtdHlZ3fqKPwPTiU6XQ==
      "]]}}, {{}, 
    {Hue[0.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQDQEmDsv8LTJFLN/th/DNHCSeGl58O/UzlG/h8O/d
c681b75D+VYOwfv4p+yJ/wPl2zjc9fTI2FrCcADCt3NwnbO0wf8QE5Tv4BCX
aF6kLcEK5Ts6bHzQw/O4mB3Kd3Iw4v918NAVTijf2cH9Y9WuT5Y8UL6LQ9rR
yyIHF/FB+a4OFhlrOS42C0D5bg7VN09NqN4gCOE3uDl8//s55oubEFTe3eHu
BrN7f+7B+B4ONi5226X4RaB8T4cplw5/nesgCtXv7RB6/exjQ2cJqLyfw/vC
ZffuZEocAADBQV6U
      "]]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{30., -5.2},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.542456773379547*^9, 3.5424568039193974`*^9}, 
   3.542457149977521*^9, 3.542457915076902*^9, {3.543666955002363*^9, 
   3.543666963287323*^9}, 3.543667191069242*^9, 3.543668310506109*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1011, 851},
WindowMargins->{{99, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 154, 2, 26, "Subsubtitle"],
Cell[736, 26, 19115, 486, 1798, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[19888, 517, 159, 2, 26, "Subsubtitle"],
Cell[20050, 521, 19273, 490, 1798, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[39360, 1016, 196, 3, 26, "Subsubtitle"],
Cell[39559, 1021, 254, 5, 27, "Input"],
Cell[39816, 1028, 264, 5, 27, "Input"],
Cell[CellGroupData[{
Cell[40105, 1037, 1252, 18, 27, "Input"],
Cell[41360, 1057, 1560, 23, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42957, 1085, 605, 13, 58, "Input"],
Cell[43565, 1100, 10974, 266, 473, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54576, 1371, 273, 7, 27, "Input"],
Cell[54852, 1380, 2532, 55, 93, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[57421, 1440, 201, 6, 27, "Input"],
Cell[57625, 1448, 2466, 53, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60128, 1506, 201, 6, 27, "Input"],
Cell[60332, 1514, 2454, 53, 69, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[62835, 1573, 196, 3, 26, "Subsubtitle"],
Cell[63034, 1578, 1489, 42, 103, "Input"],
Cell[64526, 1622, 642, 16, 27, "Input"],
Cell[65171, 1640, 364, 11, 27, "Input"],
Cell[CellGroupData[{
Cell[65560, 1655, 2708, 61, 148, "Input"],
Cell[CellGroupData[{
Cell[68293, 1720, 1574, 32, 231, "Print"],
Cell[69870, 1754, 1569, 32, 234, "Print"],
Cell[71442, 1788, 1569, 32, 234, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[73060, 1826, 2203, 65, 118, "Input"],
Cell[75266, 1893, 387, 7, 27, "Output"],
Cell[75656, 1902, 2670, 52, 234, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[78363, 1959, 2151, 64, 118, "Input"],
Cell[80517, 2025, 339, 5, 27, "Output"],
Cell[80859, 2032, 2597, 50, 238, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
