(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     95312,       1730]
NotebookOptionsPosition[     93174,       1655]
NotebookOutlinePosition[     93639,       1674]
CellTagsIndexPosition[     93596,       1671]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Setup", "Subtitle",
 CellChangeTimes->{{3.416403828173414*^9, 3.416403828643074*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", "\"\<~/Work/SpecTest4/test\>\"", "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.409835087809119*^9, 3.409835115977159*^9}, {
   3.416635847241798*^9, 3.416635847680189*^9}, {3.416751046313847*^9, 
   3.416751049251234*^9}, {3.41836232060072*^9, 3.418362320711351*^9}, {
   3.418486850393906*^9, 3.418486851779914*^9}, {3.418535577405376*^9, 
   3.418535577746089*^9}, {3.418574367565178*^9, 3.418574368706373*^9}, {
   3.4186214723269167`*^9, 3.418621472499281*^9}, {3.4192663858873158`*^9, 
   3.419266389876519*^9}, {3.419326971190641*^9, 3.419326973802593*^9}, {
   3.419605883653659*^9, 3.419605885561534*^9}, {3.4199156484205427`*^9, 
   3.419915648680475*^9}, 3.420523854010706*^9, {3.4235478181390657`*^9, 
   3.423547822240744*^9}, {3.424172940026578*^9, 3.42417294057707*^9}, {
   3.424431263258628*^9, 3.424431267504211*^9}, 3.424519386242628*^9, {
   3.424535860866909*^9, 3.4245358720246077`*^9}, {3.42499546283073*^9, 
   3.424995489603842*^9}, 3.426742538602508*^9, 3.426759496610849*^9, {
   3.4283183180535088`*^9, 3.4283183189711637`*^9}, {3.428320695235765*^9, 
   3.428320695507463*^9}, {3.4318629462543087`*^9, 3.4318629470119257`*^9}, {
   3.460303998463634*^9, 3.4603040021800823`*^9}, {3.484635971000168*^9, 
   3.484635972632184*^9}, {3.4850827099415216`*^9, 3.485082710571054*^9}, {
   3.485082845894058*^9, 3.485082853858954*^9}, {3.485084750723681*^9, 
   3.485084751419438*^9}, {3.4850847870602283`*^9, 3.485084787363426*^9}, {
   3.48508484378804*^9, 3.4850848442193947`*^9}, {3.4850853154933653`*^9, 
   3.4850853157235527`*^9}, {3.4850862979816923`*^9, 3.485086298411607*^9}, {
   3.4852379817325687`*^9, 3.485237982018005*^9}, {3.485238222820307*^9, 
   3.485238227450156*^9}, {3.485238285876103*^9, 3.485238286130093*^9}, {
   3.485492172661565*^9, 3.4854921747716303`*^9}, {3.485492586589404*^9, 
   3.4854926069003983`*^9}, {3.4854936724221067`*^9, 3.48549367973215*^9}, {
   3.485501832609168*^9, 3.4855018530829563`*^9}, {3.4856010005462933`*^9, 
   3.4856010008130407`*^9}, {3.488091756301991*^9, 3.488091761429865*^9}, 
   3.488094133694298*^9, {3.497955269653586*^9, 3.497955274461647*^9}, {
   3.497958575907033*^9, 3.497958600913637*^9}, {3.5014868931896048`*^9, 
   3.460389663369878*^9}, {3.460389704896336*^9, 3.4603897129904003`*^9}, {
   3.4603922204453993`*^9, 3.460392222344493*^9}, {3.460392266905756*^9, 
   3.460392268705435*^9}, {3.460395642267106*^9, 3.460395644287435*^9}, {
   3.460614454521058*^9, 3.4602566779379683`*^9}, {3.503228431551488*^9, 
   3.503228436524933*^9}, {3.503228542222742*^9, 3.503228547597383*^9}, {
   3.503228702822233*^9, 3.5032287080770693`*^9}, {3.5032287634326363`*^9, 
   3.5032287920373917`*^9}, {3.503299083324341*^9, 3.503299083377543*^9}, {
   3.5033154761664057`*^9, 3.460430240132947*^9}, {3.504000649484867*^9, 
   3.504000651714735*^9}, {3.50400241569261*^9, 3.5040024158027687`*^9}, 
   3.5040027171264467`*^9, {3.504002957838019*^9, 3.504002957886496*^9}, {
   3.504003228813936*^9, 3.504003233062228*^9}, {3.504005134614668*^9, 
   3.504005134676628*^9}, {3.5175503277697363`*^9, 3.517550337172287*^9}, 
   3.5176352333015833`*^9, 3.517639677724669*^9, {3.517639794622183*^9, 
   3.460393412544794*^9}, {3.4603934588614264`*^9, 3.46039345896203*^9}, {
   3.4603948227264013`*^9, 3.4603948230063047`*^9}, {3.46039592023744*^9, 
   3.4603541260154552`*^9}, {3.460367929082286*^9, 3.4603679423512897`*^9}, {
   3.460396139843549*^9, 3.460396160173218*^9}, {3.460731696071714*^9, 
   3.4603939054442244`*^9}, {3.460394059231945*^9, 3.4603384186103573`*^9}, 
   3.4603530188161173`*^9, {3.518956097590767*^9, 3.518956107182001*^9}, {
   3.539245006551964*^9, 3.539245009414372*^9}, {3.539379784340918*^9, 
   3.5393797901478987`*^9}, {3.539394718158538*^9, 3.539394719693591*^9}, {
   3.5396134068005257`*^9, 3.53961341814257*^9}, 3.539625316423122*^9, {
   3.53962615543636*^9, 3.539626155731797*^9}, {3.539640153234454*^9, 
   3.539640153345796*^9}, {3.5396496449365673`*^9, 3.5396496641372337`*^9}, {
   3.541517005127461*^9, 3.5415170071657887`*^9}, {3.54182839407207*^9, 
   3.541828420569337*^9}, {3.54183493241658*^9, 3.541834932606698*^9}, {
   3.541870768434225*^9, 3.541870779922611*^9}, {3.541912601399901*^9, 
   3.541912611920711*^9}, {3.5419139560859213`*^9, 3.541913956460087*^9}, {
   3.541913988386959*^9, 3.5419139884405107`*^9}, {3.5419148135760517`*^9, 
   3.541914817054488*^9}, {3.542449743865834*^9, 3.5424497780463057`*^9}, {
   3.543238365475522*^9, 3.54323837012247*^9}}],

Cell[CellGroupData[{

Cell["Parameters", "Subsubtitle"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"NR", "=", "30"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NA", "=", "NR"}], ";"}]}], "Input",
 CellChangeTimes->{{3.424684990943314*^9, 3.424685009641644*^9}, {
   3.428318366564241*^9, 3.428318370011374*^9}, {3.428320712332115*^9, 
   3.428320715035392*^9}, {3.428321609205154*^9, 3.428321610107437*^9}, {
   3.428321674253334*^9, 3.428321675187348*^9}, {3.428321777829453*^9, 
   3.428321782491363*^9}, {3.428321839877284*^9, 3.428321840587597*^9}, {
   3.42832189311731*^9, 3.428321898123312*^9}, 3.428322313917461*^9, {
   3.428397018991701*^9, 3.428397020326198*^9}, {3.428397073942317*^9, 
   3.428397074694132*^9}, {3.460371958003951*^9, 3.460371958104797*^9}, {
   3.4603720457079563`*^9, 3.460372047763648*^9}, {3.460372291684161*^9, 
   3.4603722931075287`*^9}, {3.460373302919477*^9, 3.460373302961478*^9}, {
   3.483951885437055*^9, 3.4839518875161753`*^9}, {3.484635968744611*^9, 
   3.484635969751956*^9}, 3.484636118744149*^9, 3.4846444100228777`*^9, {
   3.48508339416341*^9, 3.485083405491086*^9}, {3.485085303245249*^9, 
   3.485085306867683*^9}, {3.485086291710342*^9, 3.485086292659472*^9}, {
   3.4857577241095247`*^9, 3.485757725149055*^9}, {3.485758783294825*^9, 
   3.485758784293087*^9}, 3.485759025703066*^9, 3.4880230790722647`*^9, 
   3.488086808303135*^9, 3.488086945397163*^9, {3.4880886681110888`*^9, 
   3.488088668973008*^9}, {3.488089655230998*^9, 3.48808967203694*^9}, {
   3.488090547486993*^9, 3.4880905489652843`*^9}, {3.488091733751837*^9, 
   3.4880917397892227`*^9}, 3.488094127399479*^9, 3.4880955406078587`*^9, {
   3.4881052425606747`*^9, 3.4603495742220793`*^9}, {3.4603772971183653`*^9, 
   3.460377297227178*^9}, 3.4979562919256783`*^9, {3.4979585224756393`*^9, 
   3.497958524569262*^9}, {3.4979585911458397`*^9, 3.497958598760956*^9}, {
   3.498203857267253*^9, 3.49820385849557*^9}, 3.4982043460411587`*^9, 
   3.501488944020187*^9, 3.501489830225535*^9, 3.5014900392614527`*^9, 
   3.501490243933486*^9, 3.501493626245994*^9, {3.501495368255561*^9, 
   3.460393880613859*^9}, {3.460425905279276*^9, 3.460425906781336*^9}, {
   3.4604263479019117`*^9, 3.460426349274165*^9}, {3.460427514603363*^9, 
   3.4604275157856207`*^9}, {3.46042835113421*^9, 3.460428353035425*^9}, {
   3.460428406350349*^9, 3.460428406483911*^9}, {3.46042878514904*^9, 
   3.460389716765705*^9}, {3.46039222478507*^9, 3.460392225887754*^9}, {
   3.4603922709392242`*^9, 3.460392272256014*^9}, {3.460395646183907*^9, 
   3.4603956484449043`*^9}, {3.460614458000266*^9, 3.4602566845177383`*^9}, {
   3.503228440852928*^9, 3.50322844168471*^9}, {3.503228700455751*^9, 
   3.503228701285274*^9}, {3.503228770421946*^9, 3.5032287869591722`*^9}, {
   3.503315601106969*^9, 3.4604302437808437`*^9}, 3.504001606028618*^9, {
   3.5040024183547163`*^9, 3.504002419426552*^9}, {3.504002718123205*^9, 
   3.504002719294922*^9}, {3.504002959579298*^9, 3.5040029603639727`*^9}, {
   3.504003234322874*^9, 3.504003235035746*^9}, {3.5040051360529833`*^9, 
   3.504005136955735*^9}, {3.5175503407724*^9, 3.517550342588212*^9}, {
   3.517551062813801*^9, 3.517551070812138*^9}, {3.517551762238002*^9, 
   3.517551763276243*^9}, {3.517552941606324*^9, 3.517552944940358*^9}, {
   3.517553307598083*^9, 3.517553308396409*^9}, {3.517553683910129*^9, 
   3.5175536888029633`*^9}, {3.517553768380892*^9, 3.517553768492237*^9}, 
   3.517577392571465*^9, 3.517578754428321*^9, 3.5175790848847923`*^9, {
   3.517581643676695*^9, 3.517581643778459*^9}, 3.517635234940303*^9, 
   3.517635534227796*^9, 3.517636363309367*^9, 3.517636442389475*^9, 
   3.5176373300849743`*^9, {3.517639450429591*^9, 3.517639452172172*^9}, {
   3.5176395531660633`*^9, 3.517639575508013*^9}, {3.51763967439633*^9, 
   3.517639674571863*^9}, 3.5176397869823837`*^9, {3.51764011045453*^9, 
   3.517640111805228*^9}, {3.517640584390574*^9, 3.517640584477027*^9}, {
   3.5176406399181757`*^9, 3.5176406774624853`*^9}, {3.517640898573501*^9, 
   3.517640913868524*^9}, {3.517640947422961*^9, 3.460393414496331*^9}, {
   3.4603934605062513`*^9, 3.4603934605698643`*^9}, {3.460394820898333*^9, 
   3.460394820974127*^9}, {3.460395922145459*^9, 3.460354124191135*^9}, {
   3.4603679310624847`*^9, 3.460367944183139*^9}, {3.460396155591207*^9, 
   3.460396155724887*^9}, 3.460439830617852*^9, {3.46045354331511*^9, 
   3.460453543461433*^9}, 3.4604560183373537`*^9, {3.4604602249050207`*^9, 
   3.460460226534424*^9}, {3.460460380780724*^9, 3.4604603808901463`*^9}, 
   3.460471936672646*^9, {3.460484026129711*^9, 3.460484027013692*^9}, 
   3.4604840582817802`*^9, {3.460484112355485*^9, 3.4604841125202007`*^9}, 
   3.460484500647767*^9, {3.4604846354686403`*^9, 3.460484636016966*^9}, 
   3.460484743552031*^9, 3.4604849156056337`*^9, 3.4607151460111113`*^9, {
   3.460715254677723*^9, 3.460715255130488*^9}, {3.460715448330154*^9, 
   3.460715448815824*^9}, {3.460716809145631*^9, 3.46071680920612*^9}, {
   3.4607188297627*^9, 3.460718830975819*^9}, {3.460731476434578*^9, 
   3.460731477631373*^9}, {3.460731535050942*^9, 3.4607315352561626`*^9}, {
   3.460731591798522*^9, 3.460731591978981*^9}, {3.460731691809689*^9, 
   3.460731694043305*^9}, {3.460736515451126*^9, 3.4603384213839273`*^9}, {
   3.460338489699533*^9, 3.460338489832295*^9}, 3.460340221148301*^9, 
   3.460340285657992*^9, 3.4603403652724752`*^9, {3.460340459731537*^9, 
   3.4603404633364153`*^9}, {3.460352931502083*^9, 3.4603529315946712`*^9}, {
   3.460353020181643*^9, 3.460353020255084*^9}, 3.51895670764672*^9, 
   3.519020014317944*^9, {3.519021381139086*^9, 3.519021381290501*^9}, {
   3.5190226040322847`*^9, 3.51902260415872*^9}, 3.5190255564670877`*^9, {
   3.519032026001388*^9, 3.51903202605582*^9}, 3.519036342972139*^9, {
   3.519036695494561*^9, 3.5190367021324778`*^9}, {3.519037572725209*^9, 
   3.519037572888605*^9}, {3.5190393466024427`*^9, 3.519039346722732*^9}, {
   3.519103601940345*^9, 3.519103604243354*^9}, {3.5191045289590816`*^9, 
   3.5191045298785553`*^9}, {3.519105638036515*^9, 3.519105641547327*^9}, 
   3.51910628414396*^9, 3.519114894247081*^9, {3.539245028581167*^9, 
   3.5392450286841516`*^9}, {3.539289457389844*^9, 3.539289457468582*^9}, 
   3.5393374768268747`*^9, {3.539338487870781*^9, 3.539338488989737*^9}, {
   3.539378710394084*^9, 3.539378719746093*^9}, {3.539378781692828*^9, 
   3.539378781931951*^9}, {3.539379405710493*^9, 3.5393794057975893`*^9}, {
   3.5393797780686283`*^9, 3.539379778118677*^9}, {3.539394710254491*^9, 
   3.5393947103492928`*^9}, {3.539394880288023*^9, 3.539394919621388*^9}, {
   3.5396134116784153`*^9, 3.539613420030156*^9}, {3.539625318640456*^9, 
   3.539625345215991*^9}, {3.5396261603605843`*^9, 3.5396261604713783`*^9}, {
   3.539649646527404*^9, 3.5396496661210127`*^9}, {3.541517009365698*^9, 
   3.541517009428812*^9}, {3.5415651682620163`*^9, 3.541565168467697*^9}, {
   3.5418284009352016`*^9, 3.5418284221530848`*^9}, 3.541870782073855*^9, {
   3.541911305687109*^9, 3.541911307198903*^9}, {3.5419115497148848`*^9, 
   3.541911549785179*^9}, {3.541912474327354*^9, 3.541912484216498*^9}, {
   3.541912599359333*^9, 3.541912613544551*^9}, {3.54191395817878*^9, 
   3.5419139583019342`*^9}, {3.54191399041671*^9, 3.541913990512431*^9}, {
   3.541914819086384*^9, 3.541914820190258*^9}, {3.541915237175747*^9, 
   3.541915237237919*^9}, {3.541915392397889*^9, 3.5419153924954863`*^9}, {
   3.5424497617261744`*^9, 3.542449779785103*^9}, {3.5432383675381002`*^9, 
   3.543238367650148*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Coordinates ", "Subsubtitle",
 CellChangeTimes->{{3.517556505886075*^9, 3.517556509091404*^9}, {
   3.5176375867460747`*^9, 3.517637607251473*^9}, {3.517639483331715*^9, 
   3.517639500939227*^9}, 3.541911237345125*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NN", "=", 
   RowBox[{
    RowBox[{"2", "*", "NR"}], "-", "1"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.51763841954007*^9, 3.517638421220167*^9}, {
  3.541867909490724*^9, 3.541867909737905*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Cos", "[", 
       FractionBox[
        RowBox[{"\[Pi]", " ", "ii"}], "NN"], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "NN", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", "tmp", "]"}]}], "Input",
 CellChangeTimes->{{3.5175504275379143`*^9, 3.517550473868642*^9}, {
   3.5175505088539352`*^9, 3.51755057150263*^9}, {3.5175531815270977`*^9, 
   3.517553182781066*^9}, {3.5175532841430807`*^9, 3.517553285717567*^9}, {
   3.5175533447190742`*^9, 3.517553345933249*^9}, {3.517553478839162*^9, 
   3.5175534801413918`*^9}, {3.517553697086974*^9, 3.5175537300535307`*^9}, {
   3.517636043667302*^9, 3.517636082342285*^9}, {3.517636156121964*^9, 
   3.517636163909718*^9}, 3.517636245951754*^9, {3.517637708503521*^9, 
   3.517637710805746*^9}, {3.5176384245898523`*^9, 3.5176384266140013`*^9}, {
   3.517639920088458*^9, 3.517639921413632*^9}, {3.517639981975692*^9, 
   3.517640027901559*^9}, {3.541866466359578*^9, 3.541866474631075*^9}, {
   3.541867064951294*^9, 3.54186708120842*^9}, {3.541867294404078*^9, 
   3.541867297420402*^9}, {3.541911164249337*^9, 3.5419111664803133`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.`"}], ",", 
   RowBox[{"-", "0.9985826956767619`"}], ",", 
   RowBox[{"-", "0.9943348002101371`"}], ",", 
   RowBox[{"-", "0.9872683547213446`"}], ",", 
   RowBox[{"-", "0.9774033898178667`"}], ",", 
   RowBox[{"-", "0.9647678688145159`"}], ",", 
   RowBox[{"-", "0.9493976084683813`"}], ",", 
   RowBox[{"-", "0.9313361774523384`"}], ",", 
   RowBox[{"-", "0.9106347728549132`"}], ",", 
   RowBox[{"-", "0.8873520750565715`"}], ",", 
   RowBox[{"-", "0.8615540813938061`"}], ",", 
   RowBox[{"-", "0.833313919082515`"}], ",", 
   RowBox[{"-", "0.8027116379309637`"}], ",", 
   RowBox[{"-", "0.7698339834299062`"}], ",", 
   RowBox[{"-", "0.7347741508630673`"}], ",", 
   RowBox[{"-", "0.6976315211349847`"}], ",", 
   RowBox[{"-", "0.6585113790650386`"}], ",", 
   RowBox[{"-", "0.6175246149461918`"}], ",", 
   RowBox[{"-", "0.5747874102144069`"}], ",", 
   RowBox[{"-", "0.5304209081197424`"}], ",", 
   RowBox[{"-", "0.48455087033265015`"}], ",", 
   RowBox[{"-", "0.4373073204588554`"}], ",", 
   RowBox[{"-", "0.38882417547332065`"}], ",", 
   RowBox[{"-", "0.3392388661180303`"}], ",", 
   RowBox[{"-", "0.288691947339621`"}], ",", 
   RowBox[{"-", "0.23732669987111482`"}], ",", 
   RowBox[{"-", "0.18528872408711433`"}], ",", 
   RowBox[{"-", "0.13272552728372197`"}], ",", 
   RowBox[{"-", "0.07978610555308309`"}], ",", 
   RowBox[{"-", "0.026620521437774766`"}], ",", "0.026620521437774766`", ",", 
   "0.07978610555308309`", ",", "0.13272552728372197`", ",", 
   "0.18528872408711433`", ",", "0.23732669987111482`", ",", 
   "0.288691947339621`", ",", "0.3392388661180303`", ",", 
   "0.38882417547332065`", ",", "0.4373073204588554`", ",", 
   "0.48455087033265015`", ",", "0.5304209081197424`", ",", 
   "0.5747874102144069`", ",", "0.6175246149461918`", ",", 
   "0.6585113790650386`", ",", "0.6976315211349847`", ",", 
   "0.7347741508630673`", ",", "0.7698339834299062`", ",", 
   "0.8027116379309637`", ",", "0.833313919082515`", ",", 
   "0.8615540813938061`", ",", "0.8873520750565715`", ",", 
   "0.9106347728549132`", ",", "0.9313361774523384`", ",", 
   "0.9493976084683813`", ",", "0.9647678688145159`", ",", 
   "0.9774033898178667`", ",", "0.9872683547213446`", ",", 
   "0.9943348002101371`", ",", "0.9985826956767619`", ",", "1.`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.517640028276527*^9, 3.5176400307574472`*^9}, 
   3.5176401192797947`*^9, 3.517640187400107*^9, 3.5176403286587887`*^9, 
   3.51764054665143*^9, 3.5176405877817802`*^9, {3.517640651778982*^9, 
   3.5176406971378527`*^9}, {3.517640900375371*^9, 3.517640914846417*^9}, {
   3.5176409484999027`*^9, 3.4603934316299887`*^9}, 3.4603934620571413`*^9, 
   3.46039482839856*^9, {3.4603959236531153`*^9, 3.4603541273622*^9}, 
   3.460355606391925*^9, {3.460367932321252*^9, 3.460367945459139*^9}, 
   3.460396180756915*^9, 3.460439831890929*^9, 3.4604531632344923`*^9, 
   3.460453544514656*^9, {3.4604560202941093`*^9, 3.460456043888818*^9}, 
   3.460460227643118*^9, 3.46046038187729*^9, 3.4604719384546957`*^9, 
   3.460472301309268*^9, 3.4604755273342113`*^9, 3.460478447533989*^9, 
   3.460478526543737*^9, 3.460478873323823*^9, 3.460484028240882*^9, 
   3.460484059977518*^9, 3.460484113541607*^9, 3.4604845025668097`*^9, 
   3.460484637836646*^9, 3.460484745433052*^9, 3.4604849169178057`*^9, {
   3.460715149005042*^9, 3.4607151699749002`*^9}, 3.460715256955172*^9, 
   3.460715458533717*^9, 3.460716810853174*^9, {3.460718833272346*^9, 
   3.460718862160503*^9}, {3.460731479852737*^9, 3.460731536591123*^9}, 
   3.460731597465933*^9, {3.4607316975834703`*^9, 3.460393906745388*^9}, {
   3.460394069276783*^9, 3.4603384430378428`*^9}, 3.460338491846697*^9, 
   3.4603402907480507`*^9, 3.460340366294363*^9, 3.460340467475129*^9, 
   3.460352940974895*^9, 3.460353029735114*^9, 3.51895631918708*^9, 
   3.518956712523686*^9, 3.519020027793808*^9, 3.519021391497527*^9, 
   3.5190226052121983`*^9, 3.519025557684658*^9, 3.519032027695396*^9, 
   3.519036344158661*^9, 3.5190367081589527`*^9, 3.519037574162319*^9, 
   3.51903934818014*^9, 3.5191035518500757`*^9, 3.519103605153915*^9, 
   3.5191045359008713`*^9, 3.519105646498334*^9, 3.5191062882302017`*^9, 
   3.519114895485839*^9, 3.539245039974567*^9, 3.539289226094124*^9, 
   3.5392894586001577`*^9, 3.539337478349811*^9, {3.539378711449586*^9, 
   3.539378720733491*^9}, 3.5393787828777523`*^9, 3.539379407431119*^9, {
   3.539379779566827*^9, 3.539379791040307*^9}, {3.5393947112938957`*^9, 
   3.539394721485684*^9}, {3.539394881921783*^9, 3.539394904071868*^9}, {
   3.539613413403973*^9, 3.539613420833047*^9}, {3.539625320509782*^9, 
   3.53962534614544*^9}, 3.5396261634623413`*^9, {3.5396496480165*^9, 
   3.539649667334529*^9}, 3.539972213379868*^9, {3.5407346098597813`*^9, 
   3.540734625085709*^9}, 3.540734788554344*^9, 3.54073506626033*^9, 
   3.5407353233160343`*^9, 3.540735543949161*^9, 3.540735681231738*^9, 
   3.54073574218594*^9, 3.5407359147213383`*^9, 3.540735959686926*^9, {
   3.5407359950249233`*^9, 3.5407360473153477`*^9}, 3.540736239157056*^9, {
   3.540736274473997*^9, 3.540736303081781*^9}, 3.540736358623269*^9, 
   3.540736718946526*^9, 3.540736795074223*^9, 3.5407368394776163`*^9, 
   3.540745828204028*^9, {3.540745861936976*^9, 3.540745903032221*^9}, {
   3.540746001867158*^9, 3.540746039975122*^9}, {3.5407460908901978`*^9, 
   3.540746113734376*^9}, 3.541314843963317*^9, 3.5413149873599443`*^9, 
   3.541315341483013*^9, 3.541315792911289*^9, 3.541317806230768*^9, 
   3.5413178717741547`*^9, 3.541317967707746*^9, 3.541318196139876*^9, 
   3.541318345113411*^9, 3.54131846429566*^9, 3.5413185558751163`*^9, 
   3.5414804660950413`*^9, 3.541500626438019*^9, 3.541507802060275*^9, 
   3.541752699274287*^9, 3.54186648491119*^9, 3.5418670393088617`*^9, {
   3.541867069403451*^9, 3.541867081722392*^9}, {3.541867298326605*^9, 
   3.541867319542163*^9}, {3.541867419811458*^9, 3.541867441374737*^9}, 
   3.541867916401897*^9, 3.541867949732029*^9, 3.5418690378665237`*^9, 
   3.541869797318714*^9, {3.541870844951251*^9, 3.5418708615909777`*^9}, 
   3.5419096401686277`*^9, 3.541911178465125*^9, 3.541911267862749*^9, 
   3.54191130840769*^9, 3.541911550721786*^9, {3.5419124755018663`*^9, 
   3.541912485198053*^9}, {3.541912604751053*^9, 3.541912614453186*^9}, 
   3.5419139594501143`*^9, 3.541913991708296*^9, 3.541914836564538*^9, 
   3.5419152383857603`*^9, 3.5419153995431004`*^9, {3.542449749659905*^9, 
   3.542449781029901*^9}, 3.543238373789281*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChebR", "=", 
  RowBox[{"N", "[", 
   RowBox[{"tmp", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"NR", "+", "1"}], ";;", 
      RowBox[{"NN", "+", "1"}]}], "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.541911169653157*^9, 3.5419112024679003`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.026620521437774766`", ",", "0.07978610555308309`", ",", 
   "0.13272552728372197`", ",", "0.18528872408711433`", ",", 
   "0.23732669987111482`", ",", "0.288691947339621`", ",", 
   "0.3392388661180303`", ",", "0.38882417547332065`", ",", 
   "0.4373073204588554`", ",", "0.48455087033265015`", ",", 
   "0.5304209081197424`", ",", "0.5747874102144069`", ",", 
   "0.6175246149461918`", ",", "0.6585113790650386`", ",", 
   "0.6976315211349847`", ",", "0.7347741508630673`", ",", 
   "0.7698339834299062`", ",", "0.8027116379309637`", ",", 
   "0.833313919082515`", ",", "0.8615540813938061`", ",", 
   "0.8873520750565715`", ",", "0.9106347728549132`", ",", 
   "0.9313361774523384`", ",", "0.9493976084683813`", ",", 
   "0.9647678688145159`", ",", "0.9774033898178667`", ",", 
   "0.9872683547213446`", ",", "0.9943348002101371`", ",", 
   "0.9985826956767619`", ",", "1.`"}], "}"}]], "Output",
 CellChangeTimes->{{3.541911191863738*^9, 3.541911202849278*^9}, 
   3.541911267905757*^9, 3.541911308438216*^9, 3.541911550759536*^9, {
   3.541912475539275*^9, 3.5419124852255*^9}, {3.541912604774131*^9, 
   3.541912614478016*^9}, 3.54191395951645*^9, 3.541913991835885*^9, 
   3.541914836597172*^9, 3.541915238427869*^9, 3.5419153995724783`*^9, {
   3.54244974981036*^9, 3.542449781098936*^9}, 3.543238373829032*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"rarr", "=", "ChebR"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aarr", "=", "ChebR"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5419112392421103`*^9, 3.5419112505930147`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Setup patches", "Subsubtitle"],

Cell[BoxData[
 RowBox[{
  RowBox[{"patch", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"rarr", "[", 
        RowBox[{"[", "ii", "]"}], "]"}], ",", 
       RowBox[{"aarr", "[", 
        RowBox[{"[", "jj", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", "1", ",", "NR"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"jj", ",", "1", ",", "NA"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.418646820545536*^9, 3.418646822319734*^9}, {
  3.428319160860737*^9, 3.428319164787752*^9}, {3.5175542129112988`*^9, 
  3.517554218533983*^9}, {3.517554506951466*^9, 3.517554510917528*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"mask", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"r", "<", "1."}], "&&", 
         RowBox[{"a", "<", "1."}]}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"r", "\[Rule]", 
           RowBox[{"rarr", "[", 
            RowBox[{"[", "ii", "]"}], "]"}]}], ",", 
          RowBox[{"a", "\[Rule]", 
           RowBox[{"aarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}]}]}], "}"}]}], ",", "1", ",", 
       "0"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", "1", ",", "NR"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"jj", ",", "1", ",", "NA"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.415878683028904*^9, 3.415878705834999*^9}, {
   3.415879392422065*^9, 3.415879401244133*^9}, {3.416587327360105*^9, 
   3.416587342286736*^9}, 3.418449265952444*^9, {3.4184516448017693`*^9, 
   3.4184516503039703`*^9}, {3.418451680856798*^9, 3.418451681031104*^9}, {
   3.418451733120633*^9, 3.418451756447001*^9}, {3.418451804592523*^9, 
   3.4184518059355392`*^9}, {3.418451857297715*^9, 3.4184518651215563`*^9}, {
   3.4186468242581882`*^9, 3.418646827481415*^9}, {3.4186500370661077`*^9, 
   3.418650040819312*^9}, {3.424172519127236*^9, 3.424172552797269*^9}, {
   3.4283191783676453`*^9, 3.428319182300681*^9}, {3.428319223574359*^9, 
   3.4283192354124947`*^9}, {3.460349604646447*^9, 3.4603496070172033`*^9}, 
   3.504001264078267*^9, {3.517554223960393*^9, 3.517554259176518*^9}, {
   3.517554513247904*^9, 3.517554518793303*^9}, {3.517636454495966*^9, 
   3.460453155099374*^9}, 3.460472299167761*^9, 3.460475503694417*^9, 
   3.460478870371244*^9, {3.541914827728504*^9, 3.541914830296536*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Setup vector masks and index", "Subsubtitle",
 CellChangeTimes->{{3.42417260741921*^9, 3.4241726101600018`*^9}, 
   3.424172648438816*^9, {3.42417321520971*^9, 3.424173216328911*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"disp", "[", "mat_", "]"}], ":=", 
  RowBox[{"MatrixForm", "[", 
   RowBox[{"Chop", "[", 
    RowBox[{
     RowBox[{"Reverse", "[", "mat", "]"}], ",", "2"}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.517554333398487*^9, 3.5175543357648*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"vecmask", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"mask", ",", 
     RowBox[{"{", 
      RowBox[{"var", ",", "1", ",", "5"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.424172616095664*^9, 3.42417264843913*^9}, {
   3.428319357069024*^9, 3.4283193605637503`*^9}, 3.460475516994877*^9, 
   3.460478872229726*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"disp", "[", 
   RowBox[{"vecmask", "[", 
    RowBox[{"[", "2", "]"}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"disp", "[", 
  RowBox[{"vecmask", "[", 
   RowBox[{"[", "4", "]"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.424172948110396*^9, 3.424172953744746*^9}, {
   3.424173051690943*^9, 3.4241730517514544`*^9}, {3.4241731064211473`*^9, 
   3.4241731246255627`*^9}, {3.4241731726352243`*^9, 
   3.4241731780033417`*^9}, {3.428319368387994*^9, 3.4283193749394283`*^9}, {
   3.428320726860293*^9, 3.428320728347766*^9}, 3.460475524947082*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.485491864301392*^9, {3.485492194424671*^9, 3.485492203600923*^9}, 
   3.485492614623082*^9, 3.48549368095347*^9, 3.485501840207075*^9, 
   3.4855187490858583`*^9, 3.485601005478911*^9, 3.4856010728665648`*^9, 
   3.485601563509389*^9, 3.4856016057723627`*^9, 3.485602639964013*^9, {
   3.4856041412863092`*^9, 3.4856041433110437`*^9}, 3.4856055977144327`*^9, 
   3.4857577267252398`*^9, 3.485758790011026*^9, {3.4857588554186487`*^9, 
   3.485759027118742*^9}, 3.488022992996626*^9, 3.488023082461605*^9, 
   3.4880868114960003`*^9, 3.488086946662936*^9, 3.488088673112059*^9, {
   3.488089656730801*^9, 3.488089673051313*^9}, 3.488090564156822*^9, {
   3.488091743864738*^9, 3.488091764346541*^9}, 3.488094135430737*^9, 
   3.488094339766486*^9, 3.488094390338008*^9, 3.488094661984242*^9, 
   3.488095139631012*^9, {3.488095534102748*^9, 3.488095541795362*^9}, 
   3.488100679583063*^9, 3.4881052496521463`*^9, {3.4881053804700603`*^9, 
   3.460349610440978*^9}, 3.460349689838066*^9, {3.4603497291000977`*^9, 
   3.46034977971763*^9}, 3.46034981901026*^9, 3.460349997938003*^9, {
   3.460367074095797*^9, 3.4603671353705063`*^9}, 3.460369223165945*^9, 
   3.460369797222683*^9, 3.460373147764389*^9, 3.460376301780631*^9, 
   3.46037729980206*^9, 3.4603773842721167`*^9, 3.460379557889228*^9, {
   3.460381548675118*^9, 3.4603816340233803`*^9}, {3.4603816789323473`*^9, 
   3.460381683513525*^9}, 3.460382646284061*^9, 3.460383836969322*^9, 
   3.460384010185211*^9, 3.460384080617732*^9, 3.460384182551626*^9, 
   3.460384337552655*^9, 3.460384575951867*^9, 3.460385907006112*^9, 
   3.460386052598714*^9, 3.460386427804043*^9, 3.460387410692741*^9, 
   3.4603879584961348`*^9, 3.4603886743563633`*^9, 3.460389048396307*^9, 
   3.460389646672159*^9, 3.460389963065598*^9, {3.497955260848908*^9, 
   3.497955275689596*^9}, 3.497955404576795*^9, {3.497955439691234*^9, 
   3.4979554621044903`*^9}, 3.497955596137746*^9, {3.4979556707872877`*^9, 
   3.497955684127451*^9}, 3.49795580825077*^9, 3.497956297104539*^9, {
   3.497957000681266*^9, 3.497957002562714*^9}, {3.497957572661827*^9, 
   3.4979575899678097`*^9}, 3.49795772547722*^9, 3.497957761534357*^9, 
   3.497957796014789*^9, 3.497958526075027*^9, {3.497958577187643*^9, 
   3.497958593238682*^9}, 3.4982038605705557`*^9, 3.498203902660976*^9, {
   3.498204347690165*^9, 3.4982043589273977`*^9}, 3.498204392175687*^9, 
   3.4982044341144257`*^9, 3.498204622939752*^9, {3.5014870570382433`*^9, 
   3.501487074547287*^9}, {3.5014871389281797`*^9, 3.501487147355729*^9}, {
   3.501487227562582*^9, 3.501487248015787*^9}, {3.5014872920604067`*^9, 
   3.501487308863119*^9}, 3.501488106296698*^9, 3.501488143381166*^9, 
   3.5014882223947906`*^9, 3.501488254548698*^9, {3.501488286404793*^9, 
   3.501488306587175*^9}, 3.501488382903673*^9, 3.5014885298070602`*^9, {
   3.501488565420887*^9, 3.50148859236976*^9}, {3.501488644922762*^9, 
   3.501488822716926*^9}, 3.501488945575447*^9, 3.501489833778697*^9, 
   3.501490041113618*^9, 3.501490245350789*^9, 3.5014930887213984`*^9, 
   3.5014931857353163`*^9, 3.5014932564094067`*^9, 3.501493326979061*^9, 
   3.501493405617869*^9, {3.501493627459387*^9, 3.501493652510063*^9}, {
   3.501493710286697*^9, 3.50149373564848*^9}, 3.5014942547647047`*^9, 
   3.5015025741640177`*^9, {3.5015027207188168`*^9, 3.50150273648623*^9}, 
   3.501502802963146*^9, 3.501502990031888*^9, 3.5015031675418253`*^9, {
   3.501503234067651*^9, 3.5015032809652557`*^9}, {3.501503319691927*^9, 
   3.501503340790675*^9}, {3.501503394110121*^9, 3.501503423050543*^9}, 
   3.501503491308098*^9, 3.501503542246965*^9, {3.5015035724701633`*^9, 
   3.501503591835827*^9}, {3.5015036316679707`*^9, 3.460391460778592*^9}, 
   3.460391552512026*^9, {3.460391620874823*^9, 3.460391726111676*^9}, 
   3.460391766433282*^9, 3.460391805655349*^9, {3.460391899134183*^9, 
   3.460391904423318*^9}, 3.460392449011526*^9, 3.460392491911765*^9, 
   3.460392539303013*^9, 3.460392592164415*^9, 3.4603926545201817`*^9, 
   3.460392722850359*^9, 3.460392780968513*^9, 3.46039353471695*^9, 
   3.460393828875861*^9, 3.46039388509589*^9, 3.460393944763908*^9, 
   3.460394705901523*^9, 3.460394759957761*^9, 3.460394958351165*^9, 
   3.4603950842337523`*^9, 3.4603952392886963`*^9, 3.460395389654508*^9, 
   3.460425925164006*^9, {3.46042602305262*^9, 3.460426140870483*^9}, 
   3.4604263508711576`*^9, 3.460427504771038*^9, 3.460427544505268*^9, 
   3.4604283657349453`*^9, 3.46042840800635*^9, 3.460428788724392*^9, {
   3.460428833422472*^9, 3.460389722909161*^9}, {3.4603922278406076`*^9, 
   3.4603922427047367`*^9}, 3.460392273890826*^9, 3.4603956506989603`*^9, {
   3.4606144524182587`*^9, 3.4602566908889008`*^9}, 3.4602570051447153`*^9, 
   3.503228443860219*^9, {3.5032285405059853`*^9, 3.503228548603945*^9}, {
   3.503228705371221*^9, 3.503228709267578*^9}, {3.503228774142935*^9, 
   3.5032287957631693`*^9}, {3.503299081024961*^9, 3.503299085356143*^9}, {
   3.50331561918917*^9, 3.460358821395665*^9}, 3.504000653220525*^9, {
   3.504000801904839*^9, 3.504000905340579*^9}, {3.504000958667583*^9, 
   3.5040009844387217`*^9}, {3.504001071312477*^9, 3.504001075441142*^9}, {
   3.504001269919468*^9, 3.504001274665419*^9}, 3.504001608823883*^9, 
   3.504002422596731*^9, 3.5040027233811693`*^9, 3.504002961724537*^9, {
   3.504003230741403*^9, 3.5040032361572113`*^9}, 3.504005138958823*^9, 
   3.517554265697289*^9, {3.517554337500514*^9, 3.517554351987936*^9}, {
   3.5175545231040697`*^9, 3.51755453989081*^9}, 3.517554705327265*^9, 
   3.517555341452415*^9, 3.5175683552388153`*^9, 3.517577421041807*^9, 
   3.517582231926661*^9, 3.51763524151375*^9, 3.517635556595634*^9, {
   3.5176364674651413`*^9, 3.517636493291709*^9}, 3.5176373324100533`*^9, 
   3.517639757514833*^9, 3.517640668250793*^9, 3.517640707908297*^9, {
   3.5176409047988*^9, 3.517640919785956*^9}, {3.517640953017754*^9, 
   3.4603934332944098`*^9}, 3.460393463908436*^9, 3.4603948297579393`*^9, {
   3.460395927797202*^9, 3.4603541284929256`*^9}, 3.4603556071558533`*^9, {
   3.4603679375298777`*^9, 3.460367953597089*^9}, 3.460396181975419*^9, 
   3.460439832589082*^9, 3.460453163716153*^9, 3.4604535451489058`*^9, {
   3.460456020938459*^9, 3.4604560444289217`*^9}, 3.460460228835271*^9, 
   3.4604603825066633`*^9, 3.4604719390896063`*^9, 3.460472301840584*^9, 
   3.4604755278961143`*^9, 3.4604784481075974`*^9, 3.460478527123383*^9, 
   3.460478873828088*^9, 3.460484028816951*^9, 3.460484060586214*^9, 
   3.460484114212631*^9, 3.4604845031689663`*^9, 3.4604846384876213`*^9, 
   3.460484746043729*^9, 3.4604849174940977`*^9, 3.4607151708050137`*^9, 
   3.460715257511959*^9, 3.46071546012398*^9, 3.460716811480632*^9, 
   3.460718862658382*^9, {3.460731510358283*^9, 3.460731537378489*^9}, 
   3.460731597992169*^9, {3.460731698375935*^9, 3.460393907924903*^9}, {
   3.460394070070269*^9, 3.460338444545535*^9}, 3.460338492438815*^9, 
   3.4603402915831003`*^9, 3.460340366868927*^9, 3.460340468299581*^9, 
   3.460352942615267*^9, 3.460353032121888*^9, 3.518956321045685*^9, 
   3.518956717427435*^9, 3.519020032031831*^9, 3.5190214013930492`*^9, 
   3.519022606810871*^9, 3.5190255620252*^9, 3.519032033630352*^9, 
   3.519036346937253*^9, 3.51903671225138*^9, 3.519037578841022*^9, 
   3.5190393531768*^9, 3.5191035561052237`*^9, 3.5191036086897993`*^9, 
   3.519104540989696*^9, 3.519105651285398*^9, 3.519106292148252*^9, 
   3.5191148988689623`*^9, 3.5392450405792847`*^9, 3.5392892268293467`*^9, 
   3.539289459617178*^9, 3.539337478794712*^9, {3.539378711871846*^9, 
   3.53937872115454*^9}, 3.53937878339888*^9, 3.539379407851843*^9, {
   3.5393797801219797`*^9, 3.539379791578126*^9}, {3.539394712254738*^9, 
   3.539394722506558*^9}, {3.539394882405622*^9, 3.5393949044989023`*^9}, {
   3.5396134150247383`*^9, 3.5396134227912827`*^9}, {3.53962532115784*^9, 
   3.539625346759416*^9}, 3.539626166086252*^9, {3.539649650224518*^9, 
   3.539649670297758*^9}, 3.5415170152143173`*^9, 3.541517103918021*^9, 
   3.5415651699913607`*^9, {3.541828397566525*^9, 3.5418284241223297`*^9}, {
   3.541834923396179*^9, 3.541834936226203*^9}, 3.541870783369664*^9, {
   3.5419112800415907`*^9, 3.541911308570372*^9}, 3.541911550891054*^9, {
   3.5419124756525908`*^9, 3.541912485338724*^9}, {3.541912604907995*^9, 
   3.5419126145768843`*^9}, 3.54191395972225*^9, 3.541913992269548*^9, 
   3.541914836779171*^9, 3.541915238601329*^9, 3.54191539984062*^9, {
   3.542449750987159*^9, 3.5424497815294943`*^9}, 3.543238374003751*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"},
     {"1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", "1", 
      "1", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.485491864301392*^9, {3.485492194424671*^9, 3.485492203600923*^9}, 
   3.485492614623082*^9, 3.48549368095347*^9, 3.485501840207075*^9, 
   3.4855187490858583`*^9, 3.485601005478911*^9, 3.4856010728665648`*^9, 
   3.485601563509389*^9, 3.4856016057723627`*^9, 3.485602639964013*^9, {
   3.4856041412863092`*^9, 3.4856041433110437`*^9}, 3.4856055977144327`*^9, 
   3.4857577267252398`*^9, 3.485758790011026*^9, {3.4857588554186487`*^9, 
   3.485759027118742*^9}, 3.488022992996626*^9, 3.488023082461605*^9, 
   3.4880868114960003`*^9, 3.488086946662936*^9, 3.488088673112059*^9, {
   3.488089656730801*^9, 3.488089673051313*^9}, 3.488090564156822*^9, {
   3.488091743864738*^9, 3.488091764346541*^9}, 3.488094135430737*^9, 
   3.488094339766486*^9, 3.488094390338008*^9, 3.488094661984242*^9, 
   3.488095139631012*^9, {3.488095534102748*^9, 3.488095541795362*^9}, 
   3.488100679583063*^9, 3.4881052496521463`*^9, {3.4881053804700603`*^9, 
   3.460349610440978*^9}, 3.460349689838066*^9, {3.4603497291000977`*^9, 
   3.46034977971763*^9}, 3.46034981901026*^9, 3.460349997938003*^9, {
   3.460367074095797*^9, 3.4603671353705063`*^9}, 3.460369223165945*^9, 
   3.460369797222683*^9, 3.460373147764389*^9, 3.460376301780631*^9, 
   3.46037729980206*^9, 3.4603773842721167`*^9, 3.460379557889228*^9, {
   3.460381548675118*^9, 3.4603816340233803`*^9}, {3.4603816789323473`*^9, 
   3.460381683513525*^9}, 3.460382646284061*^9, 3.460383836969322*^9, 
   3.460384010185211*^9, 3.460384080617732*^9, 3.460384182551626*^9, 
   3.460384337552655*^9, 3.460384575951867*^9, 3.460385907006112*^9, 
   3.460386052598714*^9, 3.460386427804043*^9, 3.460387410692741*^9, 
   3.4603879584961348`*^9, 3.4603886743563633`*^9, 3.460389048396307*^9, 
   3.460389646672159*^9, 3.460389963065598*^9, {3.497955260848908*^9, 
   3.497955275689596*^9}, 3.497955404576795*^9, {3.497955439691234*^9, 
   3.4979554621044903`*^9}, 3.497955596137746*^9, {3.4979556707872877`*^9, 
   3.497955684127451*^9}, 3.49795580825077*^9, 3.497956297104539*^9, {
   3.497957000681266*^9, 3.497957002562714*^9}, {3.497957572661827*^9, 
   3.4979575899678097`*^9}, 3.49795772547722*^9, 3.497957761534357*^9, 
   3.497957796014789*^9, 3.497958526075027*^9, {3.497958577187643*^9, 
   3.497958593238682*^9}, 3.4982038605705557`*^9, 3.498203902660976*^9, {
   3.498204347690165*^9, 3.4982043589273977`*^9}, 3.498204392175687*^9, 
   3.4982044341144257`*^9, 3.498204622939752*^9, {3.5014870570382433`*^9, 
   3.501487074547287*^9}, {3.5014871389281797`*^9, 3.501487147355729*^9}, {
   3.501487227562582*^9, 3.501487248015787*^9}, {3.5014872920604067`*^9, 
   3.501487308863119*^9}, 3.501488106296698*^9, 3.501488143381166*^9, 
   3.5014882223947906`*^9, 3.501488254548698*^9, {3.501488286404793*^9, 
   3.501488306587175*^9}, 3.501488382903673*^9, 3.5014885298070602`*^9, {
   3.501488565420887*^9, 3.50148859236976*^9}, {3.501488644922762*^9, 
   3.501488822716926*^9}, 3.501488945575447*^9, 3.501489833778697*^9, 
   3.501490041113618*^9, 3.501490245350789*^9, 3.5014930887213984`*^9, 
   3.5014931857353163`*^9, 3.5014932564094067`*^9, 3.501493326979061*^9, 
   3.501493405617869*^9, {3.501493627459387*^9, 3.501493652510063*^9}, {
   3.501493710286697*^9, 3.50149373564848*^9}, 3.5014942547647047`*^9, 
   3.5015025741640177`*^9, {3.5015027207188168`*^9, 3.50150273648623*^9}, 
   3.501502802963146*^9, 3.501502990031888*^9, 3.5015031675418253`*^9, {
   3.501503234067651*^9, 3.5015032809652557`*^9}, {3.501503319691927*^9, 
   3.501503340790675*^9}, {3.501503394110121*^9, 3.501503423050543*^9}, 
   3.501503491308098*^9, 3.501503542246965*^9, {3.5015035724701633`*^9, 
   3.501503591835827*^9}, {3.5015036316679707`*^9, 3.460391460778592*^9}, 
   3.460391552512026*^9, {3.460391620874823*^9, 3.460391726111676*^9}, 
   3.460391766433282*^9, 3.460391805655349*^9, {3.460391899134183*^9, 
   3.460391904423318*^9}, 3.460392449011526*^9, 3.460392491911765*^9, 
   3.460392539303013*^9, 3.460392592164415*^9, 3.4603926545201817`*^9, 
   3.460392722850359*^9, 3.460392780968513*^9, 3.46039353471695*^9, 
   3.460393828875861*^9, 3.46039388509589*^9, 3.460393944763908*^9, 
   3.460394705901523*^9, 3.460394759957761*^9, 3.460394958351165*^9, 
   3.4603950842337523`*^9, 3.4603952392886963`*^9, 3.460395389654508*^9, 
   3.460425925164006*^9, {3.46042602305262*^9, 3.460426140870483*^9}, 
   3.4604263508711576`*^9, 3.460427504771038*^9, 3.460427544505268*^9, 
   3.4604283657349453`*^9, 3.46042840800635*^9, 3.460428788724392*^9, {
   3.460428833422472*^9, 3.460389722909161*^9}, {3.4603922278406076`*^9, 
   3.4603922427047367`*^9}, 3.460392273890826*^9, 3.4603956506989603`*^9, {
   3.4606144524182587`*^9, 3.4602566908889008`*^9}, 3.4602570051447153`*^9, 
   3.503228443860219*^9, {3.5032285405059853`*^9, 3.503228548603945*^9}, {
   3.503228705371221*^9, 3.503228709267578*^9}, {3.503228774142935*^9, 
   3.5032287957631693`*^9}, {3.503299081024961*^9, 3.503299085356143*^9}, {
   3.50331561918917*^9, 3.460358821395665*^9}, 3.504000653220525*^9, {
   3.504000801904839*^9, 3.504000905340579*^9}, {3.504000958667583*^9, 
   3.5040009844387217`*^9}, {3.504001071312477*^9, 3.504001075441142*^9}, {
   3.504001269919468*^9, 3.504001274665419*^9}, 3.504001608823883*^9, 
   3.504002422596731*^9, 3.5040027233811693`*^9, 3.504002961724537*^9, {
   3.504003230741403*^9, 3.5040032361572113`*^9}, 3.504005138958823*^9, 
   3.517554265697289*^9, {3.517554337500514*^9, 3.517554351987936*^9}, {
   3.5175545231040697`*^9, 3.51755453989081*^9}, 3.517554705327265*^9, 
   3.517555341452415*^9, 3.5175683552388153`*^9, 3.517577421041807*^9, 
   3.517582231926661*^9, 3.51763524151375*^9, 3.517635556595634*^9, {
   3.5176364674651413`*^9, 3.517636493291709*^9}, 3.5176373324100533`*^9, 
   3.517639757514833*^9, 3.517640668250793*^9, 3.517640707908297*^9, {
   3.5176409047988*^9, 3.517640919785956*^9}, {3.517640953017754*^9, 
   3.4603934332944098`*^9}, 3.460393463908436*^9, 3.4603948297579393`*^9, {
   3.460395927797202*^9, 3.4603541284929256`*^9}, 3.4603556071558533`*^9, {
   3.4603679375298777`*^9, 3.460367953597089*^9}, 3.460396181975419*^9, 
   3.460439832589082*^9, 3.460453163716153*^9, 3.4604535451489058`*^9, {
   3.460456020938459*^9, 3.4604560444289217`*^9}, 3.460460228835271*^9, 
   3.4604603825066633`*^9, 3.4604719390896063`*^9, 3.460472301840584*^9, 
   3.4604755278961143`*^9, 3.4604784481075974`*^9, 3.460478527123383*^9, 
   3.460478873828088*^9, 3.460484028816951*^9, 3.460484060586214*^9, 
   3.460484114212631*^9, 3.4604845031689663`*^9, 3.4604846384876213`*^9, 
   3.460484746043729*^9, 3.4604849174940977`*^9, 3.4607151708050137`*^9, 
   3.460715257511959*^9, 3.46071546012398*^9, 3.460716811480632*^9, 
   3.460718862658382*^9, {3.460731510358283*^9, 3.460731537378489*^9}, 
   3.460731597992169*^9, {3.460731698375935*^9, 3.460393907924903*^9}, {
   3.460394070070269*^9, 3.460338444545535*^9}, 3.460338492438815*^9, 
   3.4603402915831003`*^9, 3.460340366868927*^9, 3.460340468299581*^9, 
   3.460352942615267*^9, 3.460353032121888*^9, 3.518956321045685*^9, 
   3.518956717427435*^9, 3.519020032031831*^9, 3.5190214013930492`*^9, 
   3.519022606810871*^9, 3.5190255620252*^9, 3.519032033630352*^9, 
   3.519036346937253*^9, 3.51903671225138*^9, 3.519037578841022*^9, 
   3.5190393531768*^9, 3.5191035561052237`*^9, 3.5191036086897993`*^9, 
   3.519104540989696*^9, 3.519105651285398*^9, 3.519106292148252*^9, 
   3.5191148988689623`*^9, 3.5392450405792847`*^9, 3.5392892268293467`*^9, 
   3.539289459617178*^9, 3.539337478794712*^9, {3.539378711871846*^9, 
   3.53937872115454*^9}, 3.53937878339888*^9, 3.539379407851843*^9, {
   3.5393797801219797`*^9, 3.539379791578126*^9}, {3.539394712254738*^9, 
   3.539394722506558*^9}, {3.539394882405622*^9, 3.5393949044989023`*^9}, {
   3.5396134150247383`*^9, 3.5396134227912827`*^9}, {3.53962532115784*^9, 
   3.539625346759416*^9}, 3.539626166086252*^9, {3.539649650224518*^9, 
   3.539649670297758*^9}, 3.5415170152143173`*^9, 3.541517103918021*^9, 
   3.5415651699913607`*^9, {3.541828397566525*^9, 3.5418284241223297`*^9}, {
   3.541834923396179*^9, 3.541834936226203*^9}, 3.541870783369664*^9, {
   3.5419112800415907`*^9, 3.541911308570372*^9}, 3.541911550891054*^9, {
   3.5419124756525908`*^9, 3.541912485338724*^9}, {3.541912604907995*^9, 
   3.5419126145768843`*^9}, 3.54191395972225*^9, 3.541913992269548*^9, 
   3.541914836779171*^9, 3.541915238601329*^9, 3.54191539984062*^9, {
   3.542449750987159*^9, 3.5424497815294943`*^9}, 3.543238374009367*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", "\"\<Setup indexing\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.4241732289624367`*^9, 3.424173231200769*^9}}],

Cell[BoxData["\<\"Setup indexing\"\>"], "Print",
 CellChangeTimes->{
  3.48549186444991*^9, {3.485492194596924*^9, 3.485492203751793*^9}, 
   3.4854926147737923`*^9, 3.485493681108342*^9, 3.485501840376239*^9, 
   3.4855187492266397`*^9, 3.4856010056889563`*^9, 3.485601073043092*^9, 
   3.485601563666898*^9, 3.485601605947206*^9, 3.4856026401181498`*^9, {
   3.485604141470397*^9, 3.48560414348111*^9}, 3.485605597942691*^9, 
   3.485757726909301*^9, 3.485758790164316*^9, {3.485758855586247*^9, 
   3.485759027273329*^9}, 3.488022993173729*^9, 3.48802308264497*^9, 
   3.488086811645616*^9, 3.488086946849565*^9, 3.488088673264732*^9, {
   3.4880896569006968`*^9, 3.488089673220818*^9}, 3.488090564333641*^9, {
   3.488091744047267*^9, 3.488091764510744*^9}, 3.488094135613678*^9, 
   3.488094339934761*^9, 3.488094390510603*^9, 3.488094662168508*^9, 
   3.488095139814911*^9, {3.488095534285245*^9, 3.4880955419790773`*^9}, 
   3.488100679737061*^9, 3.488105249836144*^9, {3.4881053806238213`*^9, 
   3.460349610734213*^9}, 3.460349690024995*^9, {3.460349729261188*^9, 
   3.4603497798940687`*^9}, 3.46034981916617*^9, 3.4603499981259527`*^9, {
   3.4603670742734003`*^9, 3.460367135548759*^9}, 3.460369223334889*^9, 
   3.460369797383963*^9, 3.460373147937584*^9, 3.460376301933537*^9, 
   3.460377299955887*^9, 3.460377384457337*^9, 3.4603795580641737`*^9, {
   3.460381548859643*^9, 3.4603816342141237`*^9}, {3.460381679104022*^9, 
   3.460381683664069*^9}, 3.4603826464562063`*^9, 3.460383837140031*^9, 
   3.4603840103723307`*^9, 3.460384080771638*^9, 3.460384182708193*^9, 
   3.460384337740016*^9, 3.4603845760898333`*^9, 3.460385907194635*^9, 
   3.460386052787087*^9, 3.460386427955613*^9, 3.4603874108660727`*^9, 
   3.460387958669462*^9, 3.46038867452934*^9, 3.460389048568261*^9, 
   3.460389646825343*^9, 3.460389963286134*^9, {3.497955261022197*^9, 
   3.497955275872984*^9}, 3.497955404758271*^9, {3.49795543989392*^9, 
   3.497955462325844*^9}, 3.497955596507049*^9, {3.497955670990365*^9, 
   3.497955684329842*^9}, 3.497955808475504*^9, 3.497956297278043*^9, {
   3.4979570008684387`*^9, 3.497957002749538*^9}, {3.497957572848906*^9, 
   3.49795759015147*^9}, 3.497957725682578*^9, 3.497957761717013*^9, 
   3.49795779623995*^9, 3.497958526264824*^9, {3.497958577399723*^9, 
   3.497958593418519*^9}, 3.498203860735721*^9, 3.4982039028815403`*^9, {
   3.4982043478580112`*^9, 3.498204359117839*^9}, 3.498204392361959*^9, 
   3.498204434300363*^9, 3.49820462310849*^9, {3.50148705721662*^9, 
   3.501487074733334*^9}, {3.501487139109315*^9, 3.501487147522293*^9}, {
   3.501487227734466*^9, 3.501487248197352*^9}, {3.5014872922296886`*^9, 
   3.501487309043365*^9}, 3.501488106476782*^9, 3.5014881435934277`*^9, 
   3.5014882225747423`*^9, 3.501488254729999*^9, {3.501488286585175*^9, 
   3.501488306768462*^9}, 3.5014883830836763`*^9, 3.5014885299746637`*^9, {
   3.5014885655950603`*^9, 3.501488592551371*^9}, {3.501488645103723*^9, 
   3.501488822897668*^9}, 3.501488945742882*^9, 3.501489833946011*^9, 
   3.501490041293325*^9, 3.501490245536353*^9, 3.501493088885075*^9, 
   3.50149318591581*^9, 3.501493256588037*^9, 3.501493327158307*^9, 
   3.501493405777059*^9, {3.501493627627602*^9, 3.501493652706259*^9}, {
   3.5014937104721003`*^9, 3.501493735802681*^9}, 3.5014942549443502`*^9, 
   3.50150257438236*^9, {3.5015027209089737`*^9, 3.5015027367071*^9}, 
   3.501502803151804*^9, 3.5015029902217913`*^9, 3.501503167731443*^9, {
   3.5015032342689657`*^9, 3.501503281127874*^9}, {3.50150331987696*^9, 
   3.501503340992333*^9}, {3.501503394312825*^9, 3.501503423259095*^9}, 
   3.5015034914978228`*^9, 3.501503542448709*^9, {3.50150357267264*^9, 
   3.5015035920225897`*^9}, {3.501503631875483*^9, 3.460391460970986*^9}, 
   3.460391552720172*^9, {3.460391621078779*^9, 3.460391726287615*^9}, 
   3.4603917666105967`*^9, 3.460391805827429*^9, {3.460391899287566*^9, 
   3.460391904595593*^9}, 3.460392449172194*^9, 3.460392492053596*^9, 
   3.4603925394581137`*^9, 3.460392592300302*^9, 3.460392654660954*^9, 
   3.46039272302168*^9, 3.460392781124544*^9, 3.460393534932046*^9, 
   3.46039382910993*^9, 3.460393885386883*^9, 3.460393945012211*^9, 
   3.460394706107294*^9, 3.460394760180485*^9, 3.460394958514222*^9, 
   3.4603950844079227`*^9, 3.460395239446701*^9, 3.4603953898609133`*^9, 
   3.460425925306163*^9, {3.4604260231934433`*^9, 3.460426141038088*^9}, 
   3.460426351117642*^9, 3.4604275049216633`*^9, 3.4604275446618233`*^9, 
   3.4604283658997307`*^9, 3.460428408180849*^9, 3.460428788971787*^9, {
   3.460428833682366*^9, 3.460389723071286*^9}, {3.460392228157208*^9, 
   3.460392242957851*^9}, 3.4603922742469397`*^9, 3.46039565111409*^9, {
   3.46061445290495*^9, 3.4602566911272917`*^9}, 3.460257005347209*^9, 
   3.503228443990052*^9, {3.503228540639957*^9, 3.503228548754016*^9}, {
   3.5032287055362997`*^9, 3.503228709383216*^9}, {3.503228774521452*^9, 
   3.50322879646906*^9}, {3.503299081373168*^9, 3.503299085720685*^9}, {
   3.503315619476438*^9, 3.460358821579195*^9}, 3.504000653397421*^9, {
   3.5040008020668697`*^9, 3.504000905509727*^9}, {3.504000958842523*^9, 
   3.5040009847395372`*^9}, {3.504001071509983*^9, 3.5040010756085463`*^9}, {
   3.504001270185782*^9, 3.504001274951264*^9}, 3.5040016089897203`*^9, 
   3.504002422823588*^9, 3.5040027235488358`*^9, 3.504002962135096*^9, {
   3.504003231015675*^9, 3.504003236326325*^9}, 3.504005140076313*^9, 
   3.517554540455584*^9, 3.5175547058431377`*^9, 3.517555341541911*^9, 
   3.517568355275724*^9, 3.517577421099505*^9, 3.517582231973879*^9, 
   3.5176352415720377`*^9, 3.5176355566619787`*^9, {3.517636469134677*^9, 
   3.5176364933353853`*^9}, 3.517637332463048*^9, 3.517639757645129*^9, 
   3.5176406683207693`*^9, 3.517640708001689*^9, {3.517640904876151*^9, 
   3.517640919866222*^9}, {3.517640953081418*^9, 3.4603934333728743`*^9}, 
   3.460393463961011*^9, 3.460394829811267*^9, {3.460395927893836*^9, 
   3.46035412854456*^9}, 3.460355607212244*^9, {3.4603679376121597`*^9, 
   3.460367953689075*^9}, 3.460396182031837*^9, 3.4604398326483297`*^9, 
   3.4604531637767057`*^9, 3.460453545188818*^9, {3.460456020985993*^9, 
   3.460456044494657*^9}, 3.460460228978368*^9, 3.4604603825514936`*^9, 
   3.460471939129608*^9, 3.4604723019280376`*^9, 3.460475528018701*^9, 
   3.460478448222014*^9, 3.460478527212001*^9, 3.4604788739122963`*^9, 
   3.4604840288649473`*^9, 3.460484060635577*^9, 3.4604841142653103`*^9, 
   3.4604845032243433`*^9, 3.460484638527903*^9, 3.460484746089799*^9, 
   3.460484917542013*^9, 3.460715170851823*^9, 3.4607152575590563`*^9, 
   3.460715460168688*^9, 3.4607168115240507`*^9, 3.460718862702586*^9, {
   3.46073151041184*^9, 3.4607315374393597`*^9}, 3.4607315980376387`*^9, {
   3.460731698418704*^9, 3.460393907967842*^9}, {3.4603940701163816`*^9, 
   3.46033844459739*^9}, 3.4603384924844847`*^9, 3.460340291715214*^9, 
   3.460340366915494*^9, 3.460340468344779*^9, 3.4603529426657667`*^9, 
   3.460353032185107*^9, 3.518956321091804*^9, 3.51895671752492*^9, 
   3.519020032092123*^9, 3.51902140143934*^9, 3.519022606865237*^9, 
   3.519025562084976*^9, 3.519032033712627*^9, 3.519036346993087*^9, 
   3.519036712375546*^9, 3.5190375788972673`*^9, 3.519039353220909*^9, 
   3.519103556150572*^9, 3.51910360873593*^9, 3.519104541079023*^9, 
   3.5191056513515*^9, 3.5191062922233543`*^9, 3.519114898933902*^9, 
   3.539245040615582*^9, 3.5392892268606863`*^9, 3.539289459652264*^9, 
   3.5393374788331947`*^9, {3.539378711908342*^9, 3.539378721191929*^9}, 
   3.539378783436545*^9, 3.53937940788862*^9, {3.539379780158864*^9, 
   3.539379791614255*^9}, {3.5393947122904797`*^9, 3.539394722541338*^9}, {
   3.539394882441496*^9, 3.5393949045345383`*^9}, {3.539613415082837*^9, 
   3.539613422840911*^9}, {3.5396253212121267`*^9, 3.5396253467989264`*^9}, 
   3.539626166319779*^9, {3.5396496502804956`*^9, 3.539649670350758*^9}, 
   3.54151701524925*^9, 3.5415171039536552`*^9, 3.5415651700326357`*^9, {
   3.541828397593423*^9, 3.541828424181016*^9}, {3.541834923446064*^9, 
   3.541834936278634*^9}, 3.541870783397767*^9, {3.541911281494725*^9, 
   3.541911308604541*^9}, 3.5419115509256487`*^9, {3.541912475690289*^9, 
   3.541912485374765*^9}, {3.54191260494156*^9, 3.541912614629837*^9}, 
   3.541913959801094*^9, 3.541913992418036*^9, 3.541914836818961*^9, 
   3.541915238652768*^9, 3.5419153998938828`*^9, {3.542449751502007*^9, 
   3.542449781645215*^9}, 3.543238374047834*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vecpos", "=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"index", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"vecmask", "[", 
          RowBox[{"[", 
           RowBox[{"var", ",", "ii", ",", "jj"}], "]"}], "]"}], "\[Equal]", 
         "1"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"vecmask", "[", 
            RowBox[{"[", 
             RowBox[{"var", ",", "ii", ",", "jj"}], "]"}], "]"}], "=", 
           "vecpos"}], ";", 
          RowBox[{"vecpos", "+=", "1"}], ";", "\[IndentingNewLine]", 
          RowBox[{"AppendTo", "[", 
           RowBox[{"index", ",", 
            RowBox[{"{", 
             RowBox[{"var", ",", "ii", ",", "jj"}], "}"}]}], "]"}], ";"}], 
         "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"vecmask", "[", 
           RowBox[{"[", 
            RowBox[{"var", ",", "ii", ",", "jj"}], "]"}], "]"}], "=", 
          RowBox[{"-", "1"}]}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"var", ",", "1", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", "1", ",", "NR"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"jj", ",", "1", ",", "NA"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vecsize", "=", "vecpos"}], ";"}]}], "Input",
 CellChangeTimes->{{3.424173246682961*^9, 3.424173388972734*^9}, {
  3.424174868655298*^9, 3.424174876214829*^9}, {3.42831944485699*^9, 
  3.42831945012503*^9}, {3.517554630104658*^9, 3.517554701601007*^9}}],

Cell[CellGroupData[{

Cell[BoxData["vecsize"], "Input",
 CellChangeTimes->{{3.424174990077484*^9, 3.424174992364398*^9}}],

Cell[BoxData["4205"], "Output",
 CellChangeTimes->{
  3.485491864499879*^9, {3.485492194659657*^9, 3.485492203802053*^9}, 
   3.485492614823539*^9, 3.4854936811705027`*^9, 3.485501840422061*^9, 
   3.4855187492729*^9, 3.485601005754499*^9, 3.4856010731089087`*^9, 
   3.485601563729447*^9, 3.4856016060086403`*^9, 3.485602640184093*^9, {
   3.485604141570228*^9, 3.4856041435480623`*^9}, 3.485605598037871*^9, 
   3.4857577269777107`*^9, 3.485758790227397*^9, {3.48575885565315*^9, 
   3.485759027336043*^9}, 3.488022993239367*^9, 3.48802308271222*^9, 
   3.488086811696905*^9, 3.488086946911653*^9, 3.4880886733272552`*^9, {
   3.488089656963088*^9, 3.488089673284503*^9}, 3.488090564400703*^9, {
   3.488091744113245*^9, 3.488091764579571*^9}, 3.488094135680079*^9, 
   3.488094340000927*^9, 3.48809439057285*^9, 3.4880946622340527`*^9, 
   3.488095139882264*^9, {3.488095534351461*^9, 3.488095542044449*^9}, 
   3.48810067978903*^9, 3.488105249915885*^9, {3.488105380686635*^9, 
   3.460349610800487*^9}, 3.460349690091467*^9, {3.460349729328854*^9, 
   3.460349779961299*^9}, 3.460349819209786*^9, 3.460349998191186*^9, {
   3.460367074339834*^9, 3.460367135616495*^9}, 3.460369223377343*^9, 
   3.460369797448278*^9, 3.460373148119031*^9, 3.460376301999527*^9, 
   3.460377300003271*^9, 3.4603773845248947`*^9, 3.460379558128873*^9, {
   3.4603815489460087`*^9, 3.46038163427836*^9}, {3.46038167917103*^9, 
   3.460381683713455*^9}, 3.460382646519182*^9, 3.46038383720644*^9, 
   3.460384010438901*^9, 3.460384080838688*^9, 3.460384182774126*^9, 
   3.4603843378075314`*^9, 3.460384576143118*^9, 3.460385907260777*^9, 
   3.460386052855343*^9, 3.460386428009042*^9, 3.4603874109295387`*^9, 
   3.4603879587338552`*^9, 3.460388674594417*^9, 3.460389048633237*^9, 
   3.4603896468919077`*^9, 3.460389963352913*^9, {3.497955261084875*^9, 
   3.497955275938571*^9}, 3.497955404824863*^9, {3.497955439972863*^9, 
   3.4979554624026327`*^9}, 3.4979555965861893`*^9, {3.497955671070225*^9, 
   3.4979556844075317`*^9}, 3.497955808548027*^9, 3.497956297340969*^9, {
   3.497957000934719*^9, 3.4979570028150167`*^9}, {3.497957572927402*^9, 
   3.4979575902169123`*^9}, 3.497957725759966*^9, 3.497957761782693*^9, 
   3.497957796315083*^9, 3.4979585263277884`*^9, {3.4979585774663486`*^9, 
   3.4979585934857616`*^9}, 3.498203860786607*^9, 3.498203902929991*^9, {
   3.49820434792102*^9, 3.498204359177663*^9}, 3.498204392424384*^9, 
   3.498204434366929*^9, 3.498204623171793*^9, {3.50148705728255*^9, 
   3.501487074799033*^9}, {3.501487139175457*^9, 3.50148714758506*^9}, {
   3.50148722779812*^9, 3.501487248264027*^9}, {3.501487292291771*^9, 
   3.501487309110154*^9}, 3.501488106543702*^9, 3.5014881436445704`*^9, 
   3.501488222640769*^9, 3.50148825479666*^9, {3.501488286651271*^9, 
   3.50148830683492*^9}, 3.501488383150793*^9, 3.501488530037619*^9, {
   3.501488565657015*^9, 3.501488592618739*^9}, {3.501488645170162*^9, 
   3.501488822964006*^9}, 3.501488945805892*^9, 3.5014898340091047`*^9, 
   3.501490041360859*^9, 3.5014902455975246`*^9, 3.501493088951889*^9, 
   3.501493185982728*^9, 3.501493256670595*^9, 3.501493327225874*^9, 
   3.5014934058387737`*^9, {3.501493627677985*^9, 3.50149365277239*^9}, {
   3.501493710539455*^9, 3.5014937358657217`*^9}, 3.501494255011202*^9, 
   3.501502574462784*^9, {3.501502720984528*^9, 3.5015027367868433`*^9}, 
   3.50150280321093*^9, 3.501502990297853*^9, 3.501503167808969*^9, {
   3.501503234366169*^9, 3.501503281179495*^9}, {3.501503319958014*^9, 
   3.5015033410556297`*^9}, {3.50150339439253*^9, 3.501503423350531*^9}, 
   3.5015034915737743`*^9, 3.501503542529114*^9, {3.5015035727528477`*^9, 
   3.5015035921024427`*^9}, {3.501503631950811*^9, 3.460391461059949*^9}, 
   3.4603915528103647`*^9, {3.460391621121441*^9, 3.4603917263463097`*^9}, 
   3.460391766684615*^9, 3.460391805889*^9, {3.4603918993338327`*^9, 
   3.4603919046565657`*^9}, 3.460392449217477*^9, 3.4603924921158037`*^9, 
   3.460392539502195*^9, 3.460392592368026*^9, 3.460392654723373*^9, 
   3.460392723068843*^9, 3.460392781186492*^9, 3.4603935349983587`*^9, 
   3.460393829177154*^9, 3.460393885481565*^9, 3.460393945078885*^9, 
   3.4603947061838093`*^9, 3.4603947602474403`*^9, 3.460394958559992*^9, 
   3.460395084475357*^9, 3.460395239497776*^9, 3.4603953899117727`*^9, 
   3.460425925368684*^9, {3.460426023256579*^9, 3.460426141102438*^9}, 
   3.4604263511829367`*^9, 3.4604275049687777`*^9, 3.4604275447282763`*^9, 
   3.460428365948271*^9, 3.460428408246579*^9, 3.460428789101941*^9, {
   3.460428833810162*^9, 3.460389723114533*^9}, {3.460392228219595*^9, 
   3.4603922430226593`*^9}, 3.4603922744316063`*^9, 3.460395651710585*^9, {
   3.460614453380598*^9, 3.460256691193602*^9}, 3.4602570053901367`*^9, 
   3.503228444039742*^9, {3.5032285406922493`*^9, 3.503228548804441*^9}, {
   3.503228705602944*^9, 3.503228709433791*^9}, {3.503228774639256*^9, 
   3.503228796890299*^9}, {3.503299082457919*^9, 3.503299086022812*^9}, {
   3.503315619570413*^9, 3.460358821642325*^9}, 3.504000653468182*^9, {
   3.5040008021309233`*^9, 3.504000905568285*^9}, {3.504000958909286*^9, 
   3.5040009848061333`*^9}, {3.50400107157432*^9, 3.504001075658141*^9}, {
   3.5040012702681293`*^9, 3.504001275028758*^9}, 3.504001609056674*^9, 
   3.5040024228910227`*^9, 3.50400272360896*^9, 3.50400296229618*^9, {
   3.504003231177822*^9, 3.50400323639686*^9}, 3.504005140936699*^9, 
   3.517554547864876*^9, {3.517554677434679*^9, 3.517554707142516*^9}, 
   3.5175553416343727`*^9, 3.517568355355501*^9, 3.5175774211741877`*^9, 
   3.517582232673287*^9, 3.517635241645693*^9, 3.517635556940659*^9, {
   3.517636471466091*^9, 3.517636493412558*^9}, 3.517637332543367*^9, 
   3.5176397582318363`*^9, 3.517640669143568*^9, 3.5176407268259163`*^9, {
   3.517640907139456*^9, 3.517640922754386*^9}, {3.517640955962098*^9, 
   3.460393433439617*^9}, 3.460393464026575*^9, 3.4603948298816423`*^9, {
   3.4603959280152617`*^9, 3.4603541286077967`*^9}, 3.460355607278473*^9, {
   3.460367939085072*^9, 3.4603679600926847`*^9}, 3.4603961821353827`*^9, 
   3.4604398327143497`*^9, 3.46045316389764*^9, 3.4604535452546673`*^9, {
   3.460456021051869*^9, 3.460456044580763*^9}, 3.4604602290494204`*^9, 
   3.460460382615521*^9, 3.46047193919445*^9, 3.460472302038213*^9, 
   3.4604755281293907`*^9, 3.460478448332489*^9, 3.46047852732279*^9, 
   3.460478874022287*^9, 3.460484028929134*^9, 3.460484060698938*^9, 
   3.460484114331842*^9, 3.4604845032908707`*^9, 3.460484638593625*^9, 
   3.46048474615514*^9, 3.460484917606554*^9, 3.460715170975029*^9, 
   3.460715257622995*^9, 3.460715460233697*^9, 3.460716811591667*^9, 
   3.4607188627444067`*^9, {3.460731510461267*^9, 3.460731537580867*^9}, 
   3.4607315981039677`*^9, {3.4607316985520897`*^9, 3.460393908062264*^9}, {
   3.4603940702674417`*^9, 3.460338444661536*^9}, 3.4603384925309887`*^9, 
   3.460340291751153*^9, 3.460340366964736*^9, 3.460340468485935*^9, 
   3.460352942723748*^9, 3.460353032989044*^9, 3.518956321748373*^9, 
   3.518956720662437*^9, 3.519020033538562*^9, 3.519021401645186*^9, 
   3.519022607523741*^9, 3.519025564940188*^9, 3.5190320344892397`*^9, 
   3.519036348383449*^9, 3.519036712813787*^9, 3.5190375817363234`*^9, 
   3.5190393534324303`*^9, 3.5191035563557863`*^9, 3.519103610943158*^9, 
   3.519104542993074*^9, 3.519105652817423*^9, 3.519106292919355*^9, 
   3.5191149004403667`*^9, 3.539245040678595*^9, 3.539289226922536*^9, 
   3.5392894597174883`*^9, 3.539337478895033*^9, {3.539378711969783*^9, 
   3.539378721254752*^9}, 3.539378783481576*^9, 3.539379407951611*^9, {
   3.539379780220991*^9, 3.539379791678053*^9}, {3.53939471235341*^9, 
   3.539394722589364*^9}, {3.539394882503873*^9, 3.539394904597978*^9}, {
   3.539613415564784*^9, 3.539613423562879*^9}, {3.539625321291978*^9, 
   3.5396253468594847`*^9}, 3.539626166465756*^9, {3.539649651242449*^9, 
   3.539649671696088*^9}, 3.541517015349262*^9, 3.5415171040511627`*^9, 
   3.541565170079391*^9, {3.5418283976312227`*^9, 3.541828424579524*^9}, {
   3.541834924152247*^9, 3.54183493696598*^9}, 3.541870783433387*^9, {
   3.541911287339384*^9, 3.5419113086524878`*^9}, 3.54191155098875*^9, {
   3.541912475806052*^9, 3.541912485438281*^9}, {3.541912605006493*^9, 
   3.541912614797728*^9}, 3.541913960269115*^9, 3.541913993286357*^9, 
   3.541914836914657*^9, 3.5419152389369583`*^9, 3.541915400573695*^9, {
   3.542449756417103*^9, 3.5424497820352287`*^9}, 3.543238374147691*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Write Out", "Subsubtitle"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"file1", "=", 
    RowBox[{"OpenWrite", "[", 
     RowBox[{"\"\<patch.dat\>\"", ",", 
      RowBox[{"BinaryFormat", "\[Rule]", "True"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "file1", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BinaryWrite", "[", 
    RowBox[{"file1", ",", 
     RowBox[{"{", 
      RowBox[{"NR", ",", "NA"}], "}"}], ",", "\"\<Integer32\>\""}], "]"}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file1", ",", 
        RowBox[{"patch", "[", 
         RowBox[{"[", 
          RowBox[{"ii", ",", "jj"}], "]"}], "]"}], ",", "\"\<Real64\>\""}], 
       "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"BinaryWrite", "[", 
          RowBox[{"file1", ",", 
           RowBox[{"vecmask", "[", 
            RowBox[{"[", 
             RowBox[{"var", ",", "ii", ",", "jj"}], "]"}], "]"}], ",", 
           "\"\<Integer32\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
        "\[IndentingNewLine]", ",", 
        RowBox[{"{", 
         RowBox[{"var", ",", "1", ",", "5"}], "}"}]}], "]"}], ";"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", "1", ",", "NR"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"jj", ",", "1", ",", "NA"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Close", "[", "file1", "]"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.4098352392508907`*^9, {3.4241735296917467`*^9, 3.42417354366833*^9}, {
   3.424174546396842*^9, 3.424174546492543*^9}, {3.424174639487041*^9, 
   3.424174639612245*^9}, {3.428319483319551*^9, 3.42831949821423*^9}, 
   3.517555383294497*^9}],

Cell[BoxData[
 RowBox[{"OutputStream", "[", 
  RowBox[{"\<\"patch.dat\"\>", ",", "21"}], "]"}]], "Print",
 CellChangeTimes->{
  3.4854918645492983`*^9, {3.48549219471355*^9, 3.485492203839162*^9}, 
   3.485492614861432*^9, 3.485493681225198*^9, 3.48550184045982*^9, 
   3.485518749309884*^9, 3.485601005819017*^9, 3.4856010731600523`*^9, 
   3.48560156377967*^9, 3.485601606059523*^9, 3.485602640238764*^9, {
   3.485604141616178*^9, 3.48560414359846*^9}, 3.4856055981137047`*^9, 
   3.4857577270155773`*^9, 3.485758790282036*^9, {3.485758855690428*^9, 
   3.485759027373125*^9}, 3.48802299329425*^9, 3.488023082761506*^9, 
   3.48808681174655*^9, 3.4880869469653063`*^9, 3.488088673381858*^9, {
   3.488089657017668*^9, 3.488089673321178*^9}, 3.488090564450447*^9, {
   3.4880917441644077`*^9, 3.4880917646336393`*^9}, 3.488094135730473*^9, 
   3.488094340050995*^9, 3.48809439062672*^9, 3.4880946622849417`*^9, 
   3.488095139931328*^9, {3.488095534401939*^9, 3.488095542097365*^9}, 
   3.488100679832859*^9, 3.488105249969412*^9, {3.488105380741272*^9, 
   3.460349610853056*^9}, 3.460349690123514*^9, {3.46034972936548*^9, 
   3.460349779994309*^9}, 3.460349819265752*^9, 3.460349998241066*^9, {
   3.460367074390511*^9, 3.46036713565096*^9}, 3.460369223423543*^9, 
   3.460369797480749*^9, 3.4603731481723013`*^9, 3.4603763020318613`*^9, 
   3.460377300053214*^9, 3.460377384571219*^9, 3.46037955816087*^9, {
   3.4603815489949827`*^9, 3.460381634326611*^9}, {3.460381679203827*^9, 
   3.460381683762228*^9}, 3.4603826465688467`*^9, 3.4603838372543364`*^9, 
   3.4603840104877453`*^9, 3.460384080886105*^9, 3.460384182804916*^9, 
   3.460384337856057*^9, 3.460384576180641*^9, 3.460385907308751*^9, 
   3.4603860529015007`*^9, 3.460386428057003*^9, 3.460387410976676*^9, 
   3.460387958782723*^9, 3.460388674642592*^9, 3.460389048681576*^9, 
   3.460389646939399*^9, 3.460389963400716*^9, {3.4979552611346197`*^9, 
   3.4979552759888773`*^9}, 3.497955404878851*^9, {3.497955440027972*^9, 
   3.497955462440918*^9}, 3.497955596643219*^9, {3.497955671128986*^9, 
   3.497955684446039*^9}, 3.497955808586617*^9, 3.497956297391856*^9, {
   3.497957000985477*^9, 3.49795700286723*^9}, {3.497957572981833*^9, 
   3.497957590268284*^9}, 3.49795772579669*^9, 3.497957761832877*^9, 
   3.497957796351511*^9, 3.497958526377233*^9, {3.4979585775175056`*^9, 
   3.4979585935354548`*^9}, 3.498203860831514*^9, 3.498203902975028*^9, {
   3.4982043479760513`*^9, 3.498204359220125*^9}, 3.498204392479539*^9, 
   3.498204434421365*^9, 3.498204623228737*^9, {3.5014870573365297`*^9, 
   3.5014870748495617`*^9}, {3.5014871392260323`*^9, 
   3.5014871476348133`*^9}, {3.501487227852206*^9, 3.5014872483139963`*^9}, {
   3.501487292342412*^9, 3.501487309160214*^9}, 3.501488106593137*^9, 
   3.501488143697016*^9, 3.501488222691819*^9, 3.501488254846558*^9, {
   3.501488286701931*^9, 3.5014883068843613`*^9}, 3.501488383200532*^9, 
   3.501488530092507*^9, {3.5014885657111464`*^9, 3.5014885926665707`*^9}, {
   3.5014886452202673`*^9, 3.501488823015194*^9}, 3.501488945842948*^9, 
   3.501489834063323*^9, 3.5014900414158*^9, 3.501490245648302*^9, 
   3.501493089002304*^9, 3.501493186020743*^9, 3.501493256721252*^9, 
   3.501493327275485*^9, 3.501493405894359*^9, {3.501493627733333*^9, 
   3.5014936528237658`*^9}, {3.5014937105889*^9, 3.50149373592094*^9}, 
   3.501494255060707*^9, 3.501502574499866*^9, {3.5015027210201483`*^9, 
   3.5015027368407907`*^9}, 3.501502803248629*^9, 3.501502990350889*^9, 
   3.501503167865058*^9, {3.501503234419342*^9, 3.501503281233141*^9}, {
   3.501503320011099*^9, 3.5015033411139803`*^9}, {3.5015033944290247`*^9, 
   3.501503423407461*^9}, 3.501503491609754*^9, 3.5015035425656023`*^9, {
   3.501503572792142*^9, 3.501503592138995*^9}, {3.501503631987571*^9, 
   3.460391461100932*^9}, 3.4603915528512*^9, {3.460391621182597*^9, 
   3.460391726384142*^9}, 3.4603917667193413`*^9, 3.4603918059229097`*^9, {
   3.4603918993891172`*^9, 3.4603919047121763`*^9}, 3.460392449272854*^9, 
   3.4603924921560087`*^9, 3.460392539540311*^9, 3.460392592416616*^9, 
   3.460392654777666*^9, 3.4603927231049633`*^9, 3.4603927812208433`*^9, 
   3.460393535050625*^9, 3.460393829225335*^9, 3.4603938855286837`*^9, 
   3.460393945126144*^9, 3.460394706237048*^9, 3.460394760295681*^9, 
   3.460394958594301*^9, 3.4603950845065413`*^9, 3.460395239529314*^9, 
   3.46039538994477*^9, 3.460425925418676*^9, {3.4604260232866697`*^9, 
   3.46042614113664*^9}, 3.460426351231572*^9, 3.4604275050083637`*^9, 
   3.460427544777648*^9, 3.4604283659777803`*^9, 3.460428408288698*^9, 
   3.460428789150981*^9, {3.460428833864509*^9, 3.460389723150337*^9}, {
   3.460392228269724*^9, 3.460392243071309*^9}, 3.460392274476532*^9, 
   3.460395651746223*^9, {3.460614453433044*^9, 3.460256691241763*^9}, 
   3.460257005428955*^9, 3.503228444077649*^9, {3.503228540724351*^9, 
   3.503228548838046*^9}, {3.503228705637252*^9, 3.503228709486827*^9}, {
   3.5032287747107277`*^9, 3.503228796971507*^9}, {3.503299082504994*^9, 
   3.50329908617488*^9}, {3.5033156196444902`*^9, 3.460358821693692*^9}, 
   3.504000653514469*^9, {3.504000802182077*^9, 3.504000905607587*^9}, {
   3.504000958959773*^9, 3.5040009848546*^9}, {3.504001071634042*^9, 
   3.504001075695167*^9}, {3.504001270306122*^9, 3.504001275067092*^9}, 
   3.504001609106369*^9, 3.504002422942068*^9, 3.504002723663578*^9, 
   3.5040029623394823`*^9, {3.504003231216441*^9, 3.504003236445689*^9}, 
   3.5040051410279913`*^9, 3.517555404779688*^9, 3.517556640927807*^9, 
   3.517568355396585*^9, 3.51757742123337*^9, 3.517582232706675*^9, 
   3.517635241704118*^9, 3.517635557045293*^9, {3.517636472852532*^9, 
   3.517636493451439*^9}, 3.517637332601433*^9, 3.517639758302993*^9, 
   3.5176406692202673`*^9, 3.517640726883173*^9, {3.517640907189739*^9, 
   3.517640922797249*^9}, {3.517640956013267*^9, 3.46039343349259*^9}, 
   3.460393464077565*^9, 3.460394829946105*^9, {3.4603959280867968`*^9, 
   3.460354128662952*^9}, 3.4603556073296413`*^9, {3.460367939166497*^9, 
   3.460367960149581*^9}, 3.46039618220369*^9, 3.460439832764451*^9, 
   3.4604531639437838`*^9, 3.460453545304175*^9, {3.4604560211022673`*^9, 
   3.4604560446283216`*^9}, 3.460460229095767*^9, 3.4604603826664543`*^9, 
   3.4604719392442513`*^9, 3.4604723020792503`*^9, 3.460475528304225*^9, 
   3.460478448371739*^9, 3.460478527363607*^9, 3.460478874063025*^9, 
   3.4604840289805*^9, 3.460484060750099*^9, 3.460484114381403*^9, 
   3.460484503340457*^9, 3.460484638643188*^9, 3.460484746207703*^9, 
   3.460484917660537*^9, 3.460715171021275*^9, 3.460715257657908*^9, 
   3.460715460282489*^9, 3.460716811640711*^9, 3.460718862781959*^9, {
   3.4607315104972897`*^9, 3.4607315376252813`*^9}, 3.460731598154105*^9, {
   3.460731698584456*^9, 3.460393908117523*^9}, {3.460394070314364*^9, 
   3.460338444710916*^9}, 3.460338492564919*^9, 3.460340291781704*^9, 
   3.4603403670144987`*^9, 3.4603404685270443`*^9, 3.460352942764675*^9, 
   3.460353033032119*^9, 3.518956321778748*^9, 3.518956720731655*^9, 
   3.5190200335740213`*^9, 3.519021401689411*^9, 3.519022607565502*^9, 
   3.5190255649649773`*^9, 3.519032034532403*^9, 3.519036348409244*^9, 
   3.5190367129055433`*^9, 3.5190375817784853`*^9, 3.519039353470305*^9, 
   3.5191035563829403`*^9, 3.519103610968693*^9, 3.519104543034802*^9, 
   3.519105652851575*^9, 3.519106292945162*^9, 3.5191149004658737`*^9, 
   3.539245040697979*^9, 3.539289226960998*^9, 3.5392894597527103`*^9, 
   3.539337478931611*^9, {3.539378712008725*^9, 3.539378721293133*^9}, 
   3.539378783518528*^9, 3.5393794079725647`*^9, {3.539379780242848*^9, 
   3.5393797917145653`*^9}, {3.539394712374157*^9, 3.539394722607901*^9}, {
   3.539394882525867*^9, 3.539394904618844*^9}, {3.539613415727571*^9, 
   3.5396134236018543`*^9}, {3.539625321387272*^9, 3.5396253469003983`*^9}, 
   3.539626166610462*^9, {3.539649651287148*^9, 3.539649671730451*^9}, 
   3.541517015384426*^9, 3.541517104084301*^9, 3.541565170113679*^9, {
   3.541828397659676*^9, 3.541828424601201*^9}, {3.541834924352767*^9, 
   3.5418349370198317`*^9}, 3.541870783459485*^9, 3.541911308688046*^9, 
   3.54191155103024*^9, {3.54191247583851*^9, 3.541912485475387*^9}, {
   3.541912605042197*^9, 3.541912614828416*^9}, 3.541913960302166*^9, 
   3.541913993394969*^9, 3.5419148369504013`*^9, 3.541915238969872*^9, 
   3.541915400609642*^9, {3.5424497567088118`*^9, 3.542449782169627*^9}, 
   3.543238374182967*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Initial data and diffeo", "Subtitle",
 CellChangeTimes->{{3.416201497074218*^9, 3.416201497824654*^9}, {
  3.416542505841861*^9, 3.416542507993703*^9}, {3.416543211651227*^9, 
  3.4165432155708933`*^9}, {3.51755655628972*^9, 3.517556557270051*^9}}],

Cell["Hmm", "Text",
 CellChangeTimes->{{3.416156133618108*^9, 3.416156155985187*^9}, {
  3.416541983733342*^9, 3.4165419838822527`*^9}, {3.416542494955113*^9, 
  3.416542495618685*^9}, {3.4165428386978407`*^9, 3.416542839025936*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{"r_", ",", "a_"}], "]"}], ":=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"A", "[", 
     RowBox[{"r_", ",", "a_"}], "]"}], ":=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"B", "[", 
     RowBox[{"r_", ",", "a_"}], "]"}], ":=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"F", "[", 
     RowBox[{"r_", ",", "a_"}], "]"}], ":=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{"r_", ",", "a_"}], "]"}], ":=", "0"}], ";"}]}], "Input",
 CellChangeTimes->{{3.50150322725357*^9, 3.4603922412792788`*^9}, {
  3.503315605433838*^9, 3.503315607959084*^9}, {3.517568343196952*^9, 
  3.517568345810051*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"cond", "[", 
     RowBox[{"ii_", ",", "jj_"}], "]"}], ":=", 
    RowBox[{"mask", "[", 
     RowBox[{"[", 
      RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TarrP", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"T", "[", 
       RowBox[{
        RowBox[{"rarr", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", 
        RowBox[{"aarr", "[", 
         RowBox[{"[", "jj", "]"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", "NR"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"jj", ",", "1", ",", "NA"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AarrP", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"A", "[", 
       RowBox[{
        RowBox[{"rarr", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", 
        RowBox[{"aarr", "[", 
         RowBox[{"[", "jj", "]"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", "NR"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"jj", ",", "1", ",", "NA"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BarrP", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"B", "[", 
       RowBox[{
        RowBox[{"rarr", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", 
        RowBox[{"aarr", "[", 
         RowBox[{"[", "jj", "]"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", "NR"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"jj", ",", "1", ",", "NA"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FarrP", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"F", "[", 
       RowBox[{
        RowBox[{"rarr", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", 
        RowBox[{"aarr", "[", 
         RowBox[{"[", "jj", "]"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", "NR"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"jj", ",", "1", ",", "NA"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SarrP", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{
        RowBox[{"rarr", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", 
        RowBox[{"aarr", "[", 
         RowBox[{"[", "jj", "]"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", "NR"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"jj", ",", "1", ",", "NA"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"T", ",", "A", ",", "B", ",", "F", ",", "S"}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.419243440769643*^9, 3.419243441126568*^9}, {
   3.41924650090946*^9, 3.419246507788535*^9}, {3.425111051261951*^9, 
   3.425111075431073*^9}, {3.425112042288032*^9, 3.425112112696601*^9}, {
   3.425112161064046*^9, 3.42511216276613*^9}, {3.4253455950042562`*^9, 
   3.425345666296413*^9}, {3.42534625280408*^9, 3.425346323534213*^9}, {
   3.4253463553201637`*^9, 3.425346419926309*^9}, {3.428320919691051*^9, 
   3.4283209276663857`*^9}, {3.460370699137353*^9, 3.4603707111641493`*^9}, {
   3.4603707568565493`*^9, 3.460370811785021*^9}, {3.460371542092176*^9, 
   3.4603715524224787`*^9}, {3.460371724929913*^9, 3.460371740207704*^9}, 
   3.460371827750123*^9, {3.4603718580066833`*^9, 3.4603718580944242`*^9}, {
   3.46037189355579*^9, 3.460371893861116*^9}, {3.460371935721509*^9, 
   3.460371935801627*^9}, {3.460372026504945*^9, 3.4603720266113033`*^9}, {
   3.46037208202713*^9, 3.4603720821124067`*^9}, {3.4603723509975967`*^9, 
   3.460372496294924*^9}, {3.460373322355191*^9, 3.460373331738413*^9}, {
   3.460374856918042*^9, 3.460374860148785*^9}, {3.483950721507805*^9, 
   3.4839507855294323`*^9}, 3.483950876847892*^9, {3.483950935064024*^9, 
   3.483950955896113*^9}, {3.483951924906913*^9, 3.483951925229123*^9}, {
   3.4846359562531567`*^9, 3.484635964922209*^9}, {3.4846360829399443`*^9, 
   3.4846361048970833`*^9}, 3.48463646990626*^9, {3.4846430018329763`*^9, 
   3.484643009613092*^9}, {3.484644413264166*^9, 3.484644414055235*^9}, {
   3.484644608675035*^9, 3.484644612856049*^9}, 3.485082784531608*^9, {
   3.485082856074562*^9, 3.485082857255785*^9}, {3.4850833163717422`*^9, 
   3.485083341399725*^9}, {3.4850847078452587`*^9, 3.460349676121657*^9}, {
   3.460349764502083*^9, 3.460349766827506*^9}, {3.5014930852749357`*^9, 
   3.501493087033044*^9}, {3.5014931419151*^9, 3.501493143410679*^9}, {
   3.501493183545929*^9, 3.501493184497134*^9}, {3.501493253610351*^9, 
   3.50149325484044*^9}, {3.5014933085461407`*^9, 3.501493325144472*^9}, {
   3.501493397585026*^9, 3.501493404276683*^9}, {3.5014936485775957`*^9, 
   3.501493651127699*^9}, {3.501493696370013*^9, 3.501493708450797*^9}, {
   3.501502136321148*^9, 3.501502152252358*^9}, {3.501502554624*^9, 
   3.5015025682493687`*^9}, {3.501502622968598*^9, 3.501502624463874*^9}, {
   3.50331561388099*^9, 3.5033156147166777`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"file2", "=", 
    RowBox[{"OpenWrite", "[", 
     RowBox[{"\"\<init.dat\>\"", ",", 
      RowBox[{"BinaryFormat", "\[Rule]", "True"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"BinaryWrite", "[", 
    RowBox[{"file2", ",", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Flatten", "[", "TarrP", "]"}], ",", 
         RowBox[{"Flatten", "[", "AarrP", "]"}], ",", 
         RowBox[{"Flatten", "[", "BarrP", "]"}], ",", 
         RowBox[{"Flatten", "[", "FarrP", "]"}], ",", 
         RowBox[{"Flatten", "[", "SarrP", "]"}]}], "}"}], "]"}], "]"}], ",", 
     "\"\<Real64\>\""}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Close", "[", "file2", "]"}], ";"}]}], "Input",
 CellChangeTimes->{3.5015025322727547`*^9}]
}, Open  ]]
},
WindowSize->{867, 767},
WindowMargins->{{Automatic, 13}, {Automatic, 0}},
DockedCells->(FrontEndExecute[{
   FrontEnd`NotebookApply[
    FrontEnd`InputNotebook[], #, Placeholder]}]& ),
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 91, 1, 46, "Subtitle"],
Cell[661, 25, 4545, 63, 27, "Input"],
Cell[CellGroupData[{
Cell[5231, 92, 33, 0, 26, "Subsubtitle"],
Cell[5267, 94, 7509, 106, 58, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12813, 205, 225, 3, 26, "Subsubtitle"],
Cell[13041, 210, 232, 6, 27, "Input"],
Cell[CellGroupData[{
Cell[13298, 220, 1310, 25, 79, "Input"],
Cell[14611, 247, 6517, 105, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21165, 357, 288, 8, 27, "Input"],
Cell[21456, 367, 1362, 23, 70, "Output"]
}, Open  ]],
Cell[22833, 393, 261, 7, 58, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[23131, 405, 36, 0, 26, "Subsubtitle"],
Cell[23170, 407, 666, 17, 27, "Input"],
Cell[23839, 426, 1775, 37, 27, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25651, 468, 189, 2, 26, "Subsubtitle"],
Cell[25843, 472, 285, 8, 27, "Input"],
Cell[26131, 482, 364, 9, 27, "Input"],
Cell[CellGroupData[{
Cell[26520, 495, 620, 13, 58, "Input"],
Cell[27143, 510, 14191, 223, 505, "Output"],
Cell[41337, 735, 14191, 223, 505, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[55565, 963, 147, 2, 27, "Input"],
Cell[55715, 967, 8441, 117, 20, "Print"]
}, Open  ]],
Cell[64171, 1087, 2019, 54, 253, "Input"],
Cell[CellGroupData[{
Cell[66215, 1145, 99, 1, 27, "Input"],
Cell[66317, 1148, 8446, 117, 27, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[74812, 1271, 32, 0, 26, "Subsubtitle"],
Cell[CellGroupData[{
Cell[74869, 1275, 2100, 54, 298, "Input"],
Cell[76972, 1331, 8443, 119, 20, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[85476, 1457, 254, 3, 46, "Subtitle"],
Cell[85733, 1462, 233, 3, 26, "Text"],
Cell[85969, 1467, 959, 31, 148, "Input"],
Cell[86931, 1500, 5290, 125, 208, "Input"],
Cell[92224, 1627, 934, 25, 118, "Input"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
