(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32769,        709]
NotebookOptionsPosition[     31506,        664]
NotebookOutlinePosition[     31973,        683]
CellTagsIndexPosition[     31930,        680]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Setup Auto", "Subtitle",
 CellChangeTimes->{{3.416403828173414*^9, 3.416403828643074*^9}, {
  3.542448004131977*^9, 3.542448004713743*^9}}],

Cell["Hmm", "Text",
 CellChangeTimes->{{3.542447936142048*^9, 3.5424479418133373`*^9}}],

Cell[CellGroupData[{

Cell["Load Routine", "Subsubtitle",
 CellChangeTimes->{{3.542447910618824*^9, 3.542447913838582*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"disp", "[", "mat_", "]"}], ":=", 
  RowBox[{"MatrixForm", "[", 
   RowBox[{"Chop", "[", 
    RowBox[{
     RowBox[{"Reverse", "[", "mat", "]"}], ",", "2"}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.517554333398487*^9, 3.5175543357648*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"setup", "[", "Npts_", "]"}], ":=", 
    RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Setting up for NN = \>\"", ",", "Npts"}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"NR", "=", "Npts"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"NA", "=", "Npts"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"NN", "=", 
       RowBox[{
        RowBox[{"2", "*", "NR"}], "-", "1"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"tmp", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{"\[Pi]", " ", "ii"}], "NN"], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "NN", ",", "0", ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]",
       "\[IndentingNewLine]", 
      RowBox[{"ChebR", "=", 
       RowBox[{"N", "[", 
        RowBox[{"tmp", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"NR", "+", "1"}], ";;", 
           RowBox[{"NN", "+", "1"}]}], "]"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"rarr", "=", "ChebR"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"aarr", "=", "ChebR"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"patch", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"rarr", "[", 
            RowBox[{"[", "ii", "]"}], "]"}], ",", 
           RowBox[{"aarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", "NR"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"jj", ",", "1", ",", "NA"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"mask", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"r", "<", "1."}], "/.", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"r", "\[Rule]", 
               RowBox[{"rarr", "[", 
                RowBox[{"[", "ii", "]"}], "]"}]}], ",", 
              RowBox[{"a", "\[Rule]", 
               RowBox[{"aarr", "[", 
                RowBox[{"[", "jj", "]"}], "]"}]}]}], "}"}]}], ",", "1", ",", 
           "0"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", "NR"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"jj", ",", "1", ",", "NA"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"vecmask", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"mask", ",", 
         RowBox[{"{", 
          RowBox[{"var", ",", "1", ",", "5"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"vecpos", "=", "0"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"index", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"vecmask", "[", 
             RowBox[{"[", 
              RowBox[{"var", ",", "ii", ",", "jj"}], "]"}], "]"}], "\[Equal]",
             "1"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"vecmask", "[", 
               RowBox[{"[", 
                RowBox[{"var", ",", "ii", ",", "jj"}], "]"}], "]"}], "=", 
              "vecpos"}], ";", 
             RowBox[{"vecpos", "+=", "1"}], ";", "\[IndentingNewLine]", 
             RowBox[{"AppendTo", "[", 
              RowBox[{"index", ",", 
               RowBox[{"{", 
                RowBox[{"var", ",", "ii", ",", "jj"}], "}"}]}], "]"}], ";"}], 
            "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"vecmask", "[", 
              RowBox[{"[", 
               RowBox[{"var", ",", "ii", ",", "jj"}], "]"}], "]"}], "=", 
             RowBox[{"-", "1"}]}], ";"}]}], "\[IndentingNewLine]", "]"}], 
         ";"}], "\[IndentingNewLine]", ",", 
        RowBox[{"{", 
         RowBox[{"var", ",", "1", ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "NR"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "1", ",", "NA"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"vecsize", "=", "vecpos"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"file1", "=", 
       RowBox[{"OpenWrite", "[", 
        RowBox[{"\"\<patch.dat\>\"", ",", 
         RowBox[{"BinaryFormat", "\[Rule]", "True"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", "file1", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file1", ",", 
        RowBox[{"{", 
         RowBox[{"NR", ",", "NA"}], "}"}], ",", "\"\<Integer32\>\""}], "]"}], 
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"BinaryWrite", "[", 
          RowBox[{"file1", ",", 
           RowBox[{"patch", "[", 
            RowBox[{"[", 
             RowBox[{"ii", ",", "jj"}], "]"}], "]"}], ",", "\"\<Real64\>\""}],
           "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"BinaryWrite", "[", 
             RowBox[{"file1", ",", 
              RowBox[{"vecmask", "[", 
               RowBox[{"[", 
                RowBox[{"var", ",", "ii", ",", "jj"}], "]"}], "]"}], ",", 
              "\"\<Integer32\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
           "\[IndentingNewLine]", ",", 
           RowBox[{"{", 
            RowBox[{"var", ",", "1", ",", "5"}], "}"}]}], "]"}], ";"}], 
        "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "NR"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "1", ",", "NA"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Close", "[", "file1", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"T", "[", 
        RowBox[{"r_", ",", "a_"}], "]"}], ":=", "0"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"A", "[", 
        RowBox[{"r_", ",", "a_"}], "]"}], ":=", "0"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"B", "[", 
        RowBox[{"r_", ",", "a_"}], "]"}], ":=", "0"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"F", "[", 
        RowBox[{"r_", ",", "a_"}], "]"}], ":=", "0"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"S", "[", 
        RowBox[{"r_", ",", "a_"}], "]"}], ":=", "0"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"cond", "[", 
        RowBox[{"ii_", ",", "jj_"}], "]"}], ":=", 
       RowBox[{"mask", "[", 
        RowBox[{"[", 
         RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"TarrP", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{
           RowBox[{"rarr", "[", 
            RowBox[{"[", "ii", "]"}], "]"}], ",", 
           RowBox[{"aarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", "NR"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"jj", ",", "1", ",", "NA"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"AarrP", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"A", "[", 
          RowBox[{
           RowBox[{"rarr", "[", 
            RowBox[{"[", "ii", "]"}], "]"}], ",", 
           RowBox[{"aarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", "NR"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"jj", ",", "1", ",", "NA"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"BarrP", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"B", "[", 
          RowBox[{
           RowBox[{"rarr", "[", 
            RowBox[{"[", "ii", "]"}], "]"}], ",", 
           RowBox[{"aarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", "NR"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"jj", ",", "1", ",", "NA"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"FarrP", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"F", "[", 
          RowBox[{
           RowBox[{"rarr", "[", 
            RowBox[{"[", "ii", "]"}], "]"}], ",", 
           RowBox[{"aarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", "NR"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"jj", ",", "1", ",", "NA"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"SarrP", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{
           RowBox[{"rarr", "[", 
            RowBox[{"[", "ii", "]"}], "]"}], ",", 
           RowBox[{"aarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", "NR"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"jj", ",", "1", ",", "NA"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Clear", "[", 
       RowBox[{"T", ",", "A", ",", "B", ",", "F", ",", "S"}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"file2", "=", 
       RowBox[{"OpenWrite", "[", 
        RowBox[{"\"\<init.dat\>\"", ",", 
         RowBox[{"BinaryFormat", "\[Rule]", "True"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"BinaryWrite", "[", 
       RowBox[{"file2", ",", 
        RowBox[{"Flatten", "[", 
         RowBox[{"Transpose", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Flatten", "[", "TarrP", "]"}], ",", 
            RowBox[{"Flatten", "[", "AarrP", "]"}], ",", 
            RowBox[{"Flatten", "[", "BarrP", "]"}], ",", 
            RowBox[{"Flatten", "[", "FarrP", "]"}], ",", 
            RowBox[{"Flatten", "[", "SarrP", "]"}]}], "}"}], "]"}], "]"}], 
        ",", "\"\<Real64\>\""}], "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"Close", "[", "file2", "]"}], ";"}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", ")"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.424684990943314*^9, 3.424685009641644*^9}, {
   3.428318366564241*^9, 3.428318370011374*^9}, {3.428320712332115*^9, 
   3.428320715035392*^9}, {3.428321609205154*^9, 3.428321610107437*^9}, {
   3.428321674253334*^9, 3.428321675187348*^9}, {3.428321777829453*^9, 
   3.428321782491363*^9}, {3.428321839877284*^9, 3.428321840587597*^9}, {
   3.42832189311731*^9, 3.428321898123312*^9}, 3.428322313917461*^9, {
   3.428397018991701*^9, 3.428397020326198*^9}, {3.428397073942317*^9, 
   3.428397074694132*^9}, {3.460371958003951*^9, 3.460371958104797*^9}, {
   3.4603720457079563`*^9, 3.460372047763648*^9}, {3.460372291684161*^9, 
   3.4603722931075287`*^9}, {3.460373302919477*^9, 3.460373302961478*^9}, {
   3.483951885437055*^9, 3.4839518875161753`*^9}, {3.484635968744611*^9, 
   3.484635969751956*^9}, 3.484636118744149*^9, 3.4846444100228777`*^9, {
   3.48508339416341*^9, 3.485083405491086*^9}, {3.485085303245249*^9, 
   3.485085306867683*^9}, {3.485086291710342*^9, 3.485086292659472*^9}, {
   3.4857577241095247`*^9, 3.485757725149055*^9}, {3.485758783294825*^9, 
   3.485758784293087*^9}, 3.485759025703066*^9, 3.4880230790722647`*^9, 
   3.488086808303135*^9, 3.488086945397163*^9, {3.4880886681110888`*^9, 
   3.488088668973008*^9}, {3.488089655230998*^9, 3.48808967203694*^9}, {
   3.488090547486993*^9, 3.4880905489652843`*^9}, {3.488091733751837*^9, 
   3.4880917397892227`*^9}, 3.488094127399479*^9, 3.4880955406078587`*^9, {
   3.4881052425606747`*^9, 3.4603495742220793`*^9}, {3.4603772971183653`*^9, 
   3.460377297227178*^9}, 3.4979562919256783`*^9, {3.4979585224756393`*^9, 
   3.497958524569262*^9}, {3.4979585911458397`*^9, 3.497958598760956*^9}, {
   3.498203857267253*^9, 3.49820385849557*^9}, 3.4982043460411587`*^9, 
   3.501488944020187*^9, 3.501489830225535*^9, 3.5014900392614527`*^9, 
   3.501490243933486*^9, 3.501493626245994*^9, {3.501495368255561*^9, 
   3.460393880613859*^9}, {3.460425905279276*^9, 3.460425906781336*^9}, {
   3.4604263479019117`*^9, 3.460426349274165*^9}, {3.460427514603363*^9, 
   3.4604275157856207`*^9}, {3.46042835113421*^9, 3.460428353035425*^9}, {
   3.460428406350349*^9, 3.460428406483911*^9}, {3.46042878514904*^9, 
   3.460389716765705*^9}, {3.46039222478507*^9, 3.460392225887754*^9}, {
   3.4603922709392242`*^9, 3.460392272256014*^9}, {3.460395646183907*^9, 
   3.4603956484449043`*^9}, {3.460614458000266*^9, 3.4602566845177383`*^9}, {
   3.503228440852928*^9, 3.50322844168471*^9}, {3.503228700455751*^9, 
   3.503228701285274*^9}, {3.503228770421946*^9, 3.5032287869591722`*^9}, {
   3.503315601106969*^9, 3.4604302437808437`*^9}, 3.504001606028618*^9, {
   3.5040024183547163`*^9, 3.504002419426552*^9}, {3.504002718123205*^9, 
   3.504002719294922*^9}, {3.504002959579298*^9, 3.5040029603639727`*^9}, {
   3.504003234322874*^9, 3.504003235035746*^9}, {3.5040051360529833`*^9, 
   3.504005136955735*^9}, {3.5175503407724*^9, 3.517550342588212*^9}, {
   3.517551062813801*^9, 3.517551070812138*^9}, {3.517551762238002*^9, 
   3.517551763276243*^9}, {3.517552941606324*^9, 3.517552944940358*^9}, {
   3.517553307598083*^9, 3.517553308396409*^9}, {3.517553683910129*^9, 
   3.5175536888029633`*^9}, {3.517553768380892*^9, 3.517553768492237*^9}, 
   3.517577392571465*^9, 3.517578754428321*^9, 3.5175790848847923`*^9, {
   3.517581643676695*^9, 3.517581643778459*^9}, 3.517635234940303*^9, 
   3.517635534227796*^9, 3.517636363309367*^9, 3.517636442389475*^9, 
   3.5176373300849743`*^9, {3.517639450429591*^9, 3.517639452172172*^9}, {
   3.5176395531660633`*^9, 3.517639575508013*^9}, {3.51763967439633*^9, 
   3.517639674571863*^9}, 3.5176397869823837`*^9, {3.51764011045453*^9, 
   3.517640111805228*^9}, {3.517640584390574*^9, 3.517640584477027*^9}, {
   3.5176406399181757`*^9, 3.5176406774624853`*^9}, {3.517640898573501*^9, 
   3.517640913868524*^9}, {3.517640947422961*^9, 3.460393414496331*^9}, {
   3.4603934605062513`*^9, 3.4603934605698643`*^9}, {3.460394820898333*^9, 
   3.460394820974127*^9}, {3.460395922145459*^9, 3.460354124191135*^9}, {
   3.4603679310624847`*^9, 3.460367944183139*^9}, {3.460396155591207*^9, 
   3.460396155724887*^9}, 3.460439830617852*^9, {3.46045354331511*^9, 
   3.460453543461433*^9}, 3.4604560183373537`*^9, {3.4604602249050207`*^9, 
   3.460460226534424*^9}, {3.460460380780724*^9, 3.4604603808901463`*^9}, 
   3.460471936672646*^9, {3.460484026129711*^9, 3.460484027013692*^9}, 
   3.4604840582817802`*^9, {3.460484112355485*^9, 3.4604841125202007`*^9}, 
   3.460484500647767*^9, {3.4604846354686403`*^9, 3.460484636016966*^9}, 
   3.460484743552031*^9, 3.4604849156056337`*^9, 3.4607151460111113`*^9, {
   3.460715254677723*^9, 3.460715255130488*^9}, {3.460715448330154*^9, 
   3.460715448815824*^9}, {3.460716809145631*^9, 3.46071680920612*^9}, {
   3.4607188297627*^9, 3.460718830975819*^9}, {3.460731476434578*^9, 
   3.460731477631373*^9}, {3.460731535050942*^9, 3.4607315352561626`*^9}, {
   3.460731591798522*^9, 3.460731591978981*^9}, {3.460731691809689*^9, 
   3.460731694043305*^9}, {3.460736515451126*^9, 3.4603384213839273`*^9}, {
   3.460338489699533*^9, 3.460338489832295*^9}, 3.460340221148301*^9, 
   3.460340285657992*^9, 3.4603403652724752`*^9, {3.460340459731537*^9, 
   3.4603404633364153`*^9}, {3.460352931502083*^9, 3.4603529315946712`*^9}, {
   3.460353020181643*^9, 3.460353020255084*^9}, 3.51895670764672*^9, 
   3.519020014317944*^9, {3.519021381139086*^9, 3.519021381290501*^9}, {
   3.5190226040322847`*^9, 3.51902260415872*^9}, 3.5190255564670877`*^9, {
   3.519032026001388*^9, 3.51903202605582*^9}, 3.519036342972139*^9, {
   3.519036695494561*^9, 3.5190367021324778`*^9}, {3.519037572725209*^9, 
   3.519037572888605*^9}, {3.5190393466024427`*^9, 3.519039346722732*^9}, {
   3.519103601940345*^9, 3.519103604243354*^9}, {3.5191045289590816`*^9, 
   3.5191045298785553`*^9}, {3.519105638036515*^9, 3.519105641547327*^9}, 
   3.51910628414396*^9, 3.519114894247081*^9, {3.539245028581167*^9, 
   3.5392450286841516`*^9}, {3.539289457389844*^9, 3.539289457468582*^9}, 
   3.5393374768268747`*^9, {3.539338487870781*^9, 3.539338488989737*^9}, {
   3.539378710394084*^9, 3.539378719746093*^9}, {3.539378781692828*^9, 
   3.539378781931951*^9}, {3.539379405710493*^9, 3.5393794057975893`*^9}, {
   3.5393797780686283`*^9, 3.539379778118677*^9}, {3.539394710254491*^9, 
   3.5393947103492928`*^9}, {3.539394880288023*^9, 3.539394919621388*^9}, {
   3.5396134116784153`*^9, 3.539613420030156*^9}, {3.539625318640456*^9, 
   3.539625345215991*^9}, {3.5396261603605843`*^9, 3.5396261604713783`*^9}, {
   3.539649646527404*^9, 3.5396496661210127`*^9}, {3.541517009365698*^9, 
   3.541517009428812*^9}, {3.5415651682620163`*^9, 3.541565168467697*^9}, {
   3.5418284009352016`*^9, 3.5418284221530848`*^9}, 3.541870782073855*^9, {
   3.541911305687109*^9, 3.541911307198903*^9}, {3.5419115497148848`*^9, 
   3.541911549785179*^9}, {3.541912474327354*^9, 3.541912484216498*^9}, {
   3.541912599359333*^9, 3.541912613544551*^9}, {3.5419161561744537`*^9, 
   3.541916156318416*^9}, {3.5419162526035347`*^9, 3.5419162526665382`*^9}, {
   3.541916441968193*^9, 3.541916442118971*^9}, {3.541916752837326*^9, 
   3.541916796144848*^9}, {3.541918552050511*^9, 3.5419185525222387`*^9}, {
   3.5419186082170963`*^9, 3.541918608264206*^9}, {3.541919412229344*^9, 
   3.541919440431713*^9}, {3.541920769330167*^9, 3.541920769481142*^9}, {
   3.5419211178035088`*^9, 3.5419211178743973`*^9}, {3.541921225975322*^9, 
   3.541921226058124*^9}, {3.54192144430783*^9, 3.541921444409841*^9}, {
   3.5419215282309523`*^9, 3.54192152830191*^9}, {3.541921892908183*^9, 
   3.5419218929794197`*^9}, {3.541922060350636*^9, 3.541922060413685*^9}, {
   3.54192236603757*^9, 3.541922366124473*^9}, {3.5419277532356157`*^9, 
   3.541927776709906*^9}, {3.5419303023844643`*^9, 3.541930330393117*^9}, {
   3.541930801202978*^9, 3.5419308255567093`*^9}, {3.54243846820387*^9, 
   3.542438468282099*^9}, {3.542438575167843*^9, 3.5424385752390623`*^9}, {
   3.542438717953643*^9, 3.542438718016432*^9}, {3.5424389945629883`*^9, 
   3.542438999329215*^9}, {3.542439108706463*^9, 3.542439113220336*^9}, {
   3.542441187915663*^9, 3.5424412156580963`*^9}, {3.5424419789126387`*^9, 
   3.5424420158723087`*^9}, {3.542445345146346*^9, 3.542445354509186*^9}, {
   3.542445464798695*^9, 3.542445478022511*^9}, {3.542446825298019*^9, 
   3.5424468367655087`*^9}, {3.542447753181514*^9, 3.542447757485127*^9}, {
   3.542447798963118*^9, 3.542447927268675*^9}, {3.5424479683095827`*^9, 
   3.542447968702836*^9}, {3.542448295349522*^9, 3.542448311355104*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Display vector masks", "Subsubtitle",
 CellChangeTimes->{{3.42417260741921*^9, 3.4241726101600018`*^9}, 
   3.424172648438816*^9, {3.42417321520971*^9, 3.424173216328911*^9}, {
   3.542447899065187*^9, 3.5424479068028183`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"minpt", "=", "26"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"maxpt", "=", "50"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"skip", "=", "8"}], ";"}]}], "Input",
 CellChangeTimes->{{3.542448715294797*^9, 3.5424487263628807`*^9}, {
  3.5424489156597548`*^9, 3.542448931441702*^9}, {3.542450695781166*^9, 
  3.5424506958540154`*^9}, {3.542450727080407*^9, 3.54245074341199*^9}, {
  3.5424517090326843`*^9, 3.542451709142646*^9}, {3.5424518092496634`*^9, 
  3.542451819905518*^9}, {3.54245191563769*^9, 3.5424519273730927`*^9}, {
  3.54245199696535*^9, 3.5424520546768293`*^9}, {3.5424550470773487`*^9, 
  3.5424550653122473`*^9}, {3.5436655805118017`*^9, 3.543665580585504*^9}, {
  3.5436656405248632`*^9, 3.5436656497708282`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"dir1", "=", "\"\<~/Work/SpecTest4/\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.542448325046568*^9, 3.5424483320860786`*^9}, {
  3.5424486450120993`*^9, 3.54244864756999*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"dir2", "=", "\"\<test_even_02_\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.542448651579027*^9, 3.542448652867107*^9}, {
  3.5424506995327177`*^9, 3.542450699916737*^9}, {3.542451706760519*^9, 
  3.5424517069205914`*^9}, {3.542455036613574*^9, 3.542455036716016*^9}, {
  3.543665327584467*^9, 3.543665327638582*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dir", "=", 
    RowBox[{"dir1", "<>", "dir2"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"text", "=", "\"\<\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"dirname", "=", 
       RowBox[{"dir", "<>", 
        RowBox[{"ToString", "[", "NumPts", "]"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"CreateDirectory", "[", "dirname", "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"SetDirectory", "[", "dirname", "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"setup", "[", "NumPts", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"CopyFile", "[", 
       RowBox[{
        RowBox[{"dir", "<>", "\"\<30/a.out\>\""}], ",", 
        RowBox[{"dir", "<>", 
         RowBox[{"ToString", "[", "NumPts", "]"}], "<>", "\"\</a.out\>\""}]}],
        "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"text", "=", 
       RowBox[{
       "text", "<>", "\"\<cd \>\"", "<>", "dirname", "<>", "\"\<\\n\>\""}]}], 
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"text", "=", 
       RowBox[{"text", "<>", "\"\<./a.out\>\"", "<>", "\"\<\\n\\n\>\""}]}], 
      ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"NumPts", ",", "minpt", ",", "maxpt", ",", "skip"}], "}"}]}], 
    "]"}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"dir1", "<>", "\"\<run\>\"", "<>", 
    RowBox[{"ToString", "[", "minpt", "]"}], "<>", "\"\<.scr\>\""}], ",", 
   "text", ",", "\"\<String\>\""}], "]"}]}], "Input",
 CellChangeTimes->{{3.54244824777421*^9, 3.5424482782290087`*^9}, {
  3.542448335349228*^9, 3.542448366337525*^9}, {3.542448447610668*^9, 
  3.542448485766094*^9}, {3.542448530252046*^9, 3.542448712902067*^9}, {
  3.5424487571352*^9, 3.5424487619172773`*^9}, {3.542448798586104*^9, 
  3.5424487991130667`*^9}, {3.54244886212081*^9, 3.5424488624818563`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Setting up for NN = \"\>", "\[InvisibleSpace]", "26"}],
  SequenceForm["Setting up for NN = ", 26],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5424483814735117`*^9, 3.542448505647297*^9, 3.542448730354548*^9, 
   3.542448762738896*^9, {3.5424488001962023`*^9, 3.5424488240918837`*^9}, 
   3.542448865184185*^9, {3.5424489179472923`*^9, 3.542448934125574*^9}, {
   3.5424507178210983`*^9, 3.542450745765334*^9}, {3.542451805352748*^9, 
   3.54245182095012*^9}, {3.542451916921734*^9, 3.542451928391088*^9}, {
   3.5424520216736917`*^9, 3.54245205553813*^9}, {3.5424550516422586`*^9, 
   3.542455066351637*^9}, {3.543665636066003*^9, 3.543665650662356*^9}}],

Cell[BoxData[
 RowBox[{"OutputStream", "[", 
  RowBox[{"\<\"patch.dat\"\>", ",", "48"}], "]"}]], "Print",
 CellChangeTimes->{
  3.5424483814735117`*^9, 3.542448505647297*^9, 3.542448730354548*^9, 
   3.542448762738896*^9, {3.5424488001962023`*^9, 3.5424488240918837`*^9}, 
   3.542448865184185*^9, {3.5424489179472923`*^9, 3.542448934125574*^9}, {
   3.5424507178210983`*^9, 3.542450745765334*^9}, {3.542451805352748*^9, 
   3.54245182095012*^9}, {3.542451916921734*^9, 3.542451928391088*^9}, {
   3.5424520216736917`*^9, 3.54245205553813*^9}, {3.5424550516422586`*^9, 
   3.542455066351637*^9}, {3.543665636066003*^9, 3.543665650695702*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Setting up for NN = \"\>", "\[InvisibleSpace]", "34"}],
  SequenceForm["Setting up for NN = ", 34],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5424483814735117`*^9, 3.542448505647297*^9, 3.542448730354548*^9, 
   3.542448762738896*^9, {3.5424488001962023`*^9, 3.5424488240918837`*^9}, 
   3.542448865184185*^9, {3.5424489179472923`*^9, 3.542448934125574*^9}, {
   3.5424507178210983`*^9, 3.542450745765334*^9}, {3.542451805352748*^9, 
   3.54245182095012*^9}, {3.542451916921734*^9, 3.542451928391088*^9}, {
   3.5424520216736917`*^9, 3.54245205553813*^9}, {3.5424550516422586`*^9, 
   3.542455066351637*^9}, {3.543665636066003*^9, 3.543665650729224*^9}}],

Cell[BoxData[
 RowBox[{"OutputStream", "[", 
  RowBox[{"\<\"patch.dat\"\>", ",", "50"}], "]"}]], "Print",
 CellChangeTimes->{
  3.5424483814735117`*^9, 3.542448505647297*^9, 3.542448730354548*^9, 
   3.542448762738896*^9, {3.5424488001962023`*^9, 3.5424488240918837`*^9}, 
   3.542448865184185*^9, {3.5424489179472923`*^9, 3.542448934125574*^9}, {
   3.5424507178210983`*^9, 3.542450745765334*^9}, {3.542451805352748*^9, 
   3.54245182095012*^9}, {3.542451916921734*^9, 3.542451928391088*^9}, {
   3.5424520216736917`*^9, 3.54245205553813*^9}, {3.5424550516422586`*^9, 
   3.542455066351637*^9}, {3.543665636066003*^9, 3.543665650876401*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Setting up for NN = \"\>", "\[InvisibleSpace]", "42"}],
  SequenceForm["Setting up for NN = ", 42],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5424483814735117`*^9, 3.542448505647297*^9, 3.542448730354548*^9, 
   3.542448762738896*^9, {3.5424488001962023`*^9, 3.5424488240918837`*^9}, 
   3.542448865184185*^9, {3.5424489179472923`*^9, 3.542448934125574*^9}, {
   3.5424507178210983`*^9, 3.542450745765334*^9}, {3.542451805352748*^9, 
   3.54245182095012*^9}, {3.542451916921734*^9, 3.542451928391088*^9}, {
   3.5424520216736917`*^9, 3.54245205553813*^9}, {3.5424550516422586`*^9, 
   3.542455066351637*^9}, {3.543665636066003*^9, 3.54366565094576*^9}}],

Cell[BoxData[
 RowBox[{"OutputStream", "[", 
  RowBox[{"\<\"patch.dat\"\>", ",", "52"}], "]"}]], "Print",
 CellChangeTimes->{
  3.5424483814735117`*^9, 3.542448505647297*^9, 3.542448730354548*^9, 
   3.542448762738896*^9, {3.5424488001962023`*^9, 3.5424488240918837`*^9}, 
   3.542448865184185*^9, {3.5424489179472923`*^9, 3.542448934125574*^9}, {
   3.5424507178210983`*^9, 3.542450745765334*^9}, {3.542451805352748*^9, 
   3.54245182095012*^9}, {3.542451916921734*^9, 3.542451928391088*^9}, {
   3.5424520216736917`*^9, 3.54245205553813*^9}, {3.5424550516422586`*^9, 
   3.542455066351637*^9}, {3.543665636066003*^9, 3.54366565128347*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Setting up for NN = \"\>", "\[InvisibleSpace]", "50"}],
  SequenceForm["Setting up for NN = ", 50],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5424483814735117`*^9, 3.542448505647297*^9, 3.542448730354548*^9, 
   3.542448762738896*^9, {3.5424488001962023`*^9, 3.5424488240918837`*^9}, 
   3.542448865184185*^9, {3.5424489179472923`*^9, 3.542448934125574*^9}, {
   3.5424507178210983`*^9, 3.542450745765334*^9}, {3.542451805352748*^9, 
   3.54245182095012*^9}, {3.542451916921734*^9, 3.542451928391088*^9}, {
   3.5424520216736917`*^9, 3.54245205553813*^9}, {3.5424550516422586`*^9, 
   3.542455066351637*^9}, {3.543665636066003*^9, 3.543665651392188*^9}}],

Cell[BoxData[
 RowBox[{"OutputStream", "[", 
  RowBox[{"\<\"patch.dat\"\>", ",", "54"}], "]"}]], "Print",
 CellChangeTimes->{
  3.5424483814735117`*^9, 3.542448505647297*^9, 3.542448730354548*^9, 
   3.542448762738896*^9, {3.5424488001962023`*^9, 3.5424488240918837`*^9}, 
   3.542448865184185*^9, {3.5424489179472923`*^9, 3.542448934125574*^9}, {
   3.5424507178210983`*^9, 3.542450745765334*^9}, {3.542451805352748*^9, 
   3.54245182095012*^9}, {3.542451916921734*^9, 3.542451928391088*^9}, {
   3.5424520216736917`*^9, 3.54245205553813*^9}, {3.5424550516422586`*^9, 
   3.542455066351637*^9}, {3.543665636066003*^9, 3.5436656520900507`*^9}}]
}, Open  ]],

Cell[BoxData["\<\"~/Work/SpecTest4/run26.scr\"\>"], "Output",
 CellChangeTimes->{
  3.542448731479684*^9, 3.542448763797154*^9, {3.542448801097568*^9, 
   3.542448825038484*^9}, 3.54244886611446*^9, {3.542448919633339*^9, 
   3.5424489366677303`*^9}, {3.542450720498996*^9, 3.542450747463521*^9}, {
   3.542451806655302*^9, 3.5424518225547447`*^9}, {3.542451917926568*^9, 
   3.542451929942739*^9}, {3.542452022790723*^9, 3.542452057135933*^9}, {
   3.5424550529271717`*^9, 3.542455068027417*^9}, {3.543665637146997*^9, 
   3.5436656522518272`*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{867, 767},
WindowMargins->{{Automatic, 207}, {Automatic, 18}},
DockedCells->(FrontEndExecute[{
   FrontEnd`NotebookApply[
    FrontEnd`InputNotebook[], #, Placeholder]}]& ),
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 145, 2, 46, "Subtitle"],
Cell[715, 26, 87, 1, 26, "Text"],
Cell[CellGroupData[{
Cell[827, 31, 101, 1, 26, "Subsubtitle"],
Cell[931, 34, 285, 8, 27, "Input"],
Cell[1219, 44, 20214, 402, 1496, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[21470, 451, 233, 3, 26, "Subsubtitle"],
Cell[21706, 456, 866, 18, 88, "Input"],
Cell[22575, 476, 212, 4, 27, "Input"],
Cell[22790, 482, 353, 6, 27, "Input"],
Cell[CellGroupData[{
Cell[23168, 492, 2260, 50, 358, "Input"],
Cell[CellGroupData[{
Cell[25453, 546, 715, 12, 20, "Print"],
Cell[26171, 560, 642, 10, 20, "Print"],
Cell[26816, 572, 715, 12, 20, "Print"],
Cell[27534, 586, 642, 10, 20, "Print"],
Cell[28179, 598, 714, 12, 20, "Print"],
Cell[28896, 612, 641, 10, 20, "Print"],
Cell[29540, 624, 715, 12, 20, "Print"],
Cell[30258, 638, 644, 10, 20, "Print"]
}, Open  ]],
Cell[30917, 651, 549, 8, 27, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
