(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    279280,       6760]
NotebookOptionsPosition[    276247,       6674]
NotebookOutlinePosition[    276604,       6690]
CellTagsIndexPosition[    276561,       6687]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
\[LineSeparator]Scan analysis


For letter
\
\>", "Subtitle",
 CellChangeTimes->{{3.54427213185037*^9, 3.54427213892061*^9}, 
   3.5444618317918243`*^9, {3.548580456344001*^9, 3.5485804594071827`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"OUTPUT", "=", "0"}], ";"}]], "Input",
 CellChangeTimes->{{3.548573327255831*^9, 3.5485733292007313`*^9}, 
   3.548580186146782*^9, 3.548581643157302*^9, 3.548582454113212*^9, 
   3.5485826501462593`*^9, {3.5485826945229807`*^9, 3.548582712360552*^9}, {
   3.548582872704689*^9, 3.548582878655058*^9}, 3.5494192543203382`*^9, 
   3.5498694171286297`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", "\"\<~/Work/AdSCMTDyn4/C/quench34/\>\"", "]"}],
   ";"}]], "Input",
 CellChangeTimes->{{3.544249620731719*^9, 3.5442496296828117`*^9}, {
  3.5444337692758408`*^9, 3.544433769691721*^9}, {3.5449363846034613`*^9, 
  3.544936387362348*^9}, {3.54494007366164*^9, 3.5449400740680227`*^9}, {
  3.5449580132483463`*^9, 3.544958013558321*^9}, {3.544958177972954*^9, 
  3.5449581787397947`*^9}, {3.5449582590000563`*^9, 3.544958259102805*^9}, {
  3.544958320687495*^9, 3.54495832104539*^9}, {3.5463241440150213`*^9, 
  3.54632414480059*^9}, {3.546324289708584*^9, 3.546324289875299*^9}, {
  3.547482427984264*^9, 3.547482428276815*^9}, {3.547482488529839*^9, 
  3.547482488604369*^9}, {3.549688521736394*^9, 3.549688521807005*^9}, {
  3.549689058730146*^9, 3.549689059296988*^9}, {3.5498694139792128`*^9, 
  3.549869414416556*^9}, {3.549946382727355*^9, 3.5499463847097197`*^9}}],

Cell[CellGroupData[{

Cell["Load data", "Subsubtitle",
 CellChangeTimes->{{3.5485737366707153`*^9, 3.548573770512974*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"param", "=", 
    RowBox[{"Import", "[", 
     RowBox[{"\"\<param.dat\>\"", ",", "\"\<Real64\>\""}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<output.dat\>\"", ",", "\"\<Real64\>\""}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.544249633815199*^9, 3.544249656358367*^9}, {
  3.54426115396392*^9, 3.54426115789116*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Nz", "=", 
   RowBox[{"Round", "[", 
    RowBox[{"param", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aval", "=", 
   RowBox[{"param", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zarr", "=", 
   RowBox[{"param", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", "+", "1"}], ";;", 
      RowBox[{"2", "+", "Nz"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"Partition", "[", 
     RowBox[{
      RowBox[{"param", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "+", "Nz"}], ")"}], "+", "1"}], ";;", 
         RowBox[{"-", "1"}]}], "]"}], "]"}], ",", "3"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"amplist", "=", 
   RowBox[{"tmp", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"sizelist", "=", 
  RowBox[{"Round", "[", 
   RowBox[{"tmp", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "3"}], "]"}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.544249909424734*^9, 3.544249937894285*^9}, {
   3.544250143442418*^9, 3.544250166410213*^9}, 3.544250631147397*^9, {
   3.544252414987821*^9, 3.544252415283758*^9}, {3.544261162213182*^9, 
   3.544261164237224*^9}, {3.54426135018777*^9, 3.544261398042145*^9}, {
   3.544261660073123*^9, 3.544261663392272*^9}, {3.544264643931826*^9, 
   3.5442646753100233`*^9}, {3.544266744571554*^9, 3.544266748617033*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"data", "[", 
      RowBox[{"[", 
       RowBox[{"1", ";;", 
        RowBox[{"-", "1"}]}], "]"}], "]"}], ",", 
     RowBox[{"(", 
      RowBox[{"2", "+", 
       RowBox[{"13", "*", "Nz"}]}], ")"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.544265027772296*^9, 3.5442650316110067`*^9}, {
   3.544328340049923*^9, 3.544328340101346*^9}, 3.544936378260817*^9}],

Cell[BoxData[
 RowBox[{"Dimensions", "[", "data2", "]"}]], "Input",
 CellChangeTimes->{{3.5442650343341837`*^9, 3.5442650371861267`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"varr", "=", 
    RowBox[{"{", "}"}]}], ";", 
   RowBox[{"\[Mu]arr", "=", 
    RowBox[{"{", "}"}]}], ";", 
   RowBox[{"fdat", "=", 
    RowBox[{"{", "}"}]}], ";", 
   RowBox[{"hdat", "=", 
    RowBox[{"{", "}"}]}], ";", 
   RowBox[{"adat", "=", 
    RowBox[{"{", "}"}]}], ";", 
   RowBox[{"tdat", "=", 
    RowBox[{"{", "}"}]}], ";", 
   RowBox[{"sdat", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"count", "=", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"AppendTo", "[", 
       RowBox[{"varr", ",", 
        RowBox[{"data2", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"count", ";;", 
            RowBox[{"count", "-", "1", "+", 
             RowBox[{"sizelist", "[", 
              RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", "1"}], "]"}], "]"}]}],
        "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"\[Mu]arr", ",", 
        RowBox[{"data2", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"count", ";;", 
            RowBox[{"count", "-", "1", "+", 
             RowBox[{"sizelist", "[", 
              RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", "2"}], "]"}], "]"}]}],
        "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"fdat", ",", 
        RowBox[{"data2", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"count", ";;", 
            RowBox[{"count", "-", "1", "+", 
             RowBox[{"sizelist", "[", 
              RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
           RowBox[{
            RowBox[{"2", "+", "1"}], ";;", 
            RowBox[{"2", "+", "Nz"}]}]}], "]"}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"hdat", ",", 
        RowBox[{"data2", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"count", ";;", 
            RowBox[{"count", "-", "1", "+", 
             RowBox[{"sizelist", "[", 
              RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
           RowBox[{
            RowBox[{"2", "+", "Nz", "+", "1"}], ";;", 
            RowBox[{"2", "+", 
             RowBox[{"2", "Nz"}]}]}]}], "]"}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"adat", ",", 
        RowBox[{"data2", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"count", ";;", 
            RowBox[{"count", "-", "1", "+", 
             RowBox[{"sizelist", "[", 
              RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
           RowBox[{
            RowBox[{"2", "+", 
             RowBox[{"2", "Nz"}], "+", "1"}], ";;", 
            RowBox[{"2", "+", 
             RowBox[{"3", "Nz"}]}]}]}], "]"}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"tdat", ",", 
        RowBox[{"data2", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"count", ";;", 
            RowBox[{"count", "-", "1", "+", 
             RowBox[{"sizelist", "[", 
              RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
           RowBox[{
            RowBox[{"2", "+", 
             RowBox[{"3", "Nz"}], "+", "1"}], ";;", 
            RowBox[{"2", "+", 
             RowBox[{"4", "Nz"}]}]}]}], "]"}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"sdat", ",", 
        RowBox[{"data2", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"count", ";;", 
            RowBox[{"count", "-", "1", "+", 
             RowBox[{"sizelist", "[", 
              RowBox[{"[", "ii", "]"}], "]"}]}]}], ",", 
           RowBox[{
            RowBox[{"2", "+", 
             RowBox[{"4", "Nz"}], "+", "1"}], ";;", 
            RowBox[{"2", "+", 
             RowBox[{"5", "Nz"}]}]}]}], "]"}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"count", "+=", 
       RowBox[{"sizelist", "[", 
        RowBox[{"[", "ii", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", ",", 
     
     RowBox[{"{", 
      RowBox[{"ii", ",", "1", ",", 
       RowBox[{"Length", "[", "sizelist", "]"}]}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Psi]dat", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"fdat", "^", "2"}], "+", 
     RowBox[{"hdat", "^", "2"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5442647527119904`*^9, 3.5442647800605373`*^9}, {
  3.5442649948756237`*^9, 3.544265118416362*^9}, {3.544266860840364*^9, 
  3.544266862071999*^9}, {3.544266893310627*^9, 3.5442668935742273`*^9}, {
  3.5442669338570232`*^9, 3.544267013660307*^9}, {3.544267323546688*^9, 
  3.544267351282713*^9}, {3.54478046359175*^9, 3.5447805182309847`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"run", "=", "5"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varr2", "=", 
    RowBox[{"varr", "[", 
     RowBox[{"[", "run", "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fdat2", "=", 
    RowBox[{"fdat", "[", 
     RowBox[{"[", "run", "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hdat2", "=", 
    RowBox[{"hdat", "[", 
     RowBox[{"[", "run", "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"adat2", "=", 
    RowBox[{"adat", "[", 
     RowBox[{"[", "run", "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tdat2", "=", 
    RowBox[{"tdat", "[", 
     RowBox[{"[", "run", "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sdat2", "=", 
    RowBox[{"sdat", "[", 
     RowBox[{"[", "run", "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Psi]dat2", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"fdat2", "^", "2"}], "+", 
     RowBox[{"hdat2", "^", "2"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5442620947460938`*^9, 3.544262158203375*^9}, 
   3.54426281461913*^9, 3.544268574564596*^9, 3.54427007162061*^9, 
   3.544271084558489*^9, {3.54432845066856*^9, 3.5443284507640953`*^9}, 
   3.544423251666473*^9, {3.547486395017419*^9, 3.5474863952321167`*^9}, {
   3.547533305451786*^9, 3.5475333056582947`*^9}, {3.5480256501830063`*^9, 
   3.5480256502704163`*^9}, {3.548348911791821*^9, 3.548348923302332*^9}, 
   3.549869454138691*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"size", "=", 
    RowBox[{"sizelist", "[", 
     RowBox[{"[", "run", "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"skip", "=", 
    RowBox[{"Round", "[", 
     RowBox[{"size", "/", "50"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]plt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr2", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"\[Psi]dat2", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr2", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"fdat2", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr2", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"hdat2", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"aplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr2", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"adat2", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr2", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"tdat2", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"splt", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"varr2", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], ",", 
         RowBox[{"zarr", "[", 
          RowBox[{"[", "jj", "]"}], "]"}], ",", 
         RowBox[{"sdat2", "[", 
          RowBox[{"[", 
           RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5442504582349873`*^9, 3.544250584036578*^9}, 
   3.544250626644371*^9, {3.544250822560841*^9, 3.544250823367763*^9}, {
   3.5442509165343533`*^9, 3.544251133374446*^9}, {3.544251467199772*^9, 
   3.544251471241907*^9}, {3.544252339447783*^9, 3.544252348921164*^9}, {
   3.544252422297391*^9, 3.544252437776615*^9}, {3.544262042155575*^9, 
   3.544262059275323*^9}, 3.544262159662603*^9, {3.5442725505372*^9, 
   3.5442725719280167`*^9}, 3.544423253152224*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]divzplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr2", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          FractionBox[
           RowBox[{
            RowBox[{"\[Psi]dat2", "[", 
             RowBox[{"[", 
              RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "-", 
            RowBox[{"\[Psi]dat2", "[", 
             RowBox[{"[", 
              RowBox[{"ii", ",", "1"}], "]"}], "]"}]}], 
           RowBox[{"zarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hdivzplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr2", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          FractionBox[
           RowBox[{
            RowBox[{"hdat2", "[", 
             RowBox[{"[", 
              RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "-", 
            RowBox[{"hdat2", "[", 
             RowBox[{"[", 
              RowBox[{"ii", ",", "1"}], "]"}], "]"}]}], 
           RowBox[{"zarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tdivzplt", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"varr2", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], ",", 
         RowBox[{"zarr", "[", 
          RowBox[{"[", "jj", "]"}], "]"}], ",", 
         FractionBox[
          RowBox[{
           RowBox[{"tdat2", "[", 
            RowBox[{"[", 
             RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "+", 
           RowBox[{"0.5", "*", 
            RowBox[{
             RowBox[{"\[Psi]dat2", "[", 
              RowBox[{"[", 
               RowBox[{"ii", ",", "1"}], "]"}], "]"}], "^", "2"}]}]}], 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}]]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.544251411197404*^9, 3.544251411947116*^9}, {
  3.544251477266673*^9, 3.544251480034252*^9}, {3.544251510785811*^9, 
  3.544251516905808*^9}, {3.544252191194234*^9, 3.544252193250115*^9}, {
  3.5442523498747063`*^9, 3.5442523551794043`*^9}, {3.54425243931746*^9, 
  3.5442524454290133`*^9}, {3.544255229404937*^9, 3.544255232188203*^9}, {
  3.5442553627725763`*^9, 3.5442553698450527`*^9}, {3.5442620466080112`*^9, 
  3.5442620703603983`*^9}, {3.54426216770219*^9, 3.544262171446186*^9}, {
  3.5444232548845778`*^9, 3.5444232590050373`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"gttplt", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"varr2", "[", 
            RowBox[{"[", "ii", "]"}], "]"}], ",", 
           RowBox[{"zarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}], ",", 
           RowBox[{"1", "+", 
            RowBox[{
             RowBox[{
              RowBox[{"zarr", "[", 
               RowBox[{"[", "jj", "]"}], "]"}], "^", "2"}], "*", 
             RowBox[{"tdat2", "[", 
              RowBox[{"[", 
               RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", "size", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
      "]"}], ",", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"varr2", "[", 
             RowBox[{"[", "ii", "]"}], "]"}]}], ",", 
           RowBox[{"zarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}], ",", 
           RowBox[{"1", "+", 
            RowBox[{
             RowBox[{
              RowBox[{"zarr", "[", 
               RowBox[{"[", "jj", "]"}], "]"}], "^", "2"}], "*", 
             RowBox[{"tdat2", "[", 
              RowBox[{"[", 
               RowBox[{"1", ",", "jj"}], "]"}], "]"}]}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", "size", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
      "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.547533187952179*^9, 3.547533220655731*^9}, {
   3.548025330646315*^9, 3.548025340340247*^9}, 3.548025468366762*^9, 
   3.5480255207661133`*^9, {3.548026096752771*^9, 3.548026125353094*^9}}],

Cell[BoxData[
 RowBox[{"Tfn", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"gttplt", ",", 
    RowBox[{"InterpolationOrder", "\[Rule]", "2"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.548021708411763*^9, 3.5480217243208437`*^9}, {
   3.548024170967751*^9, 3.548024174487664*^9}, 3.548024726783135*^9, 
   3.5480251525609207`*^9, {3.548025269182692*^9, 3.548025269218115*^9}, 
   3.5480253563792353`*^9}],

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Tfn", "[", 
    RowBox[{"v", ",", "u"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "10"}], ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0.01", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.54802208108836*^9, 3.548022128247752*^9}, {
  3.54802428058578*^9, 3.548024280695554*^9}, {3.548026132935565*^9, 
  3.548026133247072*^9}, {3.5480266585307837`*^9, 3.548026658833892*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"skip2", "=", "5"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Psi]plttmp", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"zarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}], ",", 
           RowBox[{"-", 
            RowBox[{"varr2", "[", 
             RowBox[{"[", "ii", "]"}], "]"}]}], ",", 
           RowBox[{"\[Psi]dat2", "[", 
            RowBox[{"[", 
             RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", "20", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
      "]"}], ",", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"zarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}], ",", 
           RowBox[{"varr2", "[", 
            RowBox[{"[", "ii", "]"}], "]"}], ",", 
           RowBox[{"\[Psi]dat2", "[", 
            RowBox[{"[", 
             RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", "size", ",", "skip2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
      "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.547533647743915*^9, 3.5475338294727583`*^9}, {
   3.5475341560660563`*^9, 3.547534159779655*^9}, {3.547929215686483*^9, 
   3.5479292426452217`*^9}, 3.5484079029450283`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"txt", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<Re \[Psi]\>\"", ",", 
         RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.8", ",", "6"}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt", "=", 
    RowBox[{"ListContourPlot", "[", 
     RowBox[{"\[Psi]plttmp", ",", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<z\>\"", ",", "\"\<v\>\""}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"All", ",", "8"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"Contours", "\[Rule]", "20"}], ",", 
      RowBox[{"InterpolationOrder", "\[Rule]", "10"}], ",", 
      RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}], ",", 
      RowBox[{"FrameStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"FontSize", "\[Rule]", "20"}], "]"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"plt2", "=", 
  RowBox[{"Show", "[", 
   RowBox[{"plt", ",", "txt"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.5475332632279577`*^9, 3.5475332933311443`*^9}, {
   3.5475333438024063`*^9, 3.547533520997335*^9}, {3.547533554341462*^9, 
   3.547533619098226*^9}, 3.547533673706337*^9, {3.547533733151265*^9, 
   3.5475337335191393`*^9}, 3.547533833871921*^9, {3.547534192835417*^9, 
   3.547534192979085*^9}, {3.547929224468104*^9, 3.547929258356827*^9}, {
   3.548349904430388*^9, 3.5483499048061447`*^9}, {3.5483500871932173`*^9, 
   3.548350131206275*^9}, {3.548350255663413*^9, 3.5483502953229628`*^9}, {
   3.5483503593796177`*^9, 3.54835037408117*^9}, {3.548407887073105*^9, 
   3.548407962350965*^9}}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"OUTPUT", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<~/Work/AdSCMTDyn4/figs/quenchplot_scalarcontour.jpg\>\"", ",", 
      "plt2"}], "]"}], ";"}]}], "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.548349957077589*^9, 3.5483499839439983`*^9}, 
   3.5483506141773653`*^9, {3.548407976296783*^9, 3.548407984952736*^9}, {
   3.548573320474183*^9, 3.548573321809126*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Eqm solns", "Subsubtitle",
 CellChangeTimes->{{3.5485737366707153`*^9, 3.5485737619931507`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"veclist2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "1.8680000000000001048050535246147774159908294677734375`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.07411330906905750805528686249503216386`14.326192424441803", ",", 
         "2.12016507792186221390187484097793631177`16.47718391661858", ",", 
         "0.99796320130955900159331767623389558243`16.715318055597518", ",", 
         RowBox[{
         "-", "0.13209937938569916105382152751329064856`14.31923330520756"}], 
         ",", "0.10971872892433415470058146805050040232`14.34010883366393", 
         ",", "1.8798562291257884753566922400474836126`16.225477372597936", 
         ",", 
         RowBox[{
         "-", "1.888355040258515462451511094912192968`15.992851155640812"}], 
         ",", 
         RowBox[{
         "-", "1.85478334540629843678088177220096843475`16.101725599279643"}]}\
], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.8630000000000002113864638886298052966594696044921875`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.10093199055116359638313995927643015462`15.251494706516034", ",", 
         "2.11844378652555617736638883301174267458`17.133443052399105", ",", 
         "0.99622293311212926892826336337702598548`17.371449943823315", ",", 
         RowBox[{
         "-", "0.18046038644985925200717760098132491477`15.238821226494226"}],
          ",", "0.14926728581976344531720303581649411192`15.277964674901558", 
         ",", "1.8849846927960238367218611952024618712`16.88360993731486", 
         ",", 
         RowBox[{
         "-", "1.90076704206111583878434760877275451315`16.652539350540785"}],
          ",", 
         RowBox[{
         "-", "1.88237633977656224242531307084894409022`15.85783967338347"}]}]\
, "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.858000000000000095923269327613525092601776123046875`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.12199045918483495224516296834588158096`15.253637153684723", ",", 
         "2.11671658993000242128413418612924511845`16.97048919700237", ",", 
         "0.99448318500333806012060388516254336826`17.208343038792712", ",", 
         RowBox[{
         "-", "0.2187948645905994226409824183373027453`15.235068921355648"}], 
         ",", "0.18022302786116541935647313294084328945`15.291392089571447", 
         ",", "1.89010859559361017472642128431240810911`16.722584595490652", 
         ",", 
         RowBox[{
         "-", "1.91319261263229983916624843980006316836`16.4930179610158"}], 
         ",", 
         RowBox[{
         "-", "1.88437500465045399112855459401196007507`16.316594726680073"}]}\
], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.853000000000000202504679691628552973270416259765625`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.13991576713419054084245553563368722548`15.38181056332753", ",", 
         "2.11498297927250553844836268134173834758`16.978899208273017", ",", 
         "0.99274381096901775461278558217817537759`17.21661556795727", ",", 
         RowBox[{
         "-", "0.25172799604099884747324163039078816474`15.357683997408886"}],
          ",", "0.20649202997496315579816058779614053049`15.432427773366074", 
         ",", "1.89522877971216019457341676809689363194`16.732894334291423", 
         ",", 
         RowBox[{
         "-", "1.92563319179856206319114446254080895885`16.50483872033326"}], 
         ",", 
         RowBox[{
         "-", "1.8878965915867283981924135241093264572`16.352165142992806"}]}]\
, "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.8480000000000000870414851306122727692127227783203125`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.15579334346754175063462306313342457019`15.610383714902092", ",", 
         "2.11324296288793644279252943435821675997`17.113364019767168", ",", 
         "0.9910048056839301499961531060587797237`17.350944932955475", ",", 
         RowBox[{
         "-", "0.28116545224831504481352145987519850752`15.580775425714707"}],
          ",", "0.22968863191484381180672704660144137516`15.674266653455481", 
         ",", "1.90034526852153828503436179803776477794`16.86924692868054", 
         ",", 
         RowBox[{
         "-", "1.93808881401953367641335008167534475133`16.642699885115864"}],
          ",", 
         RowBox[{
         "-", "1.89773036065659079317490457248365223331`16.455190607755846"}]}\
], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.8430000000000001936228954946273006498813629150390625`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.17019742179613482450853823651986226362`15.806440488096658", ",", 
         "2.11149653822486333267894028943391605368`17.23216816291728", ",", 
         "0.98926616087521054743847689925554868564`17.46960304705473", ",", 
         RowBox[{
         "-", "0.30811124659492882681148876759183679352`15.771481352516474"}],
          ",", "0.25066555449818615547664621091564764723`15.883947513862413", 
         ",", "1.90545810232984220601269490016037752895`16.989942582787045", 
         ",", 
         RowBox[{
         "-", "1.95055954328911708597865832563439658007`16.76488606608109"}], 
         ",", 
         RowBox[{
         "-", "1.90683987472600559199182989537750274515`16.57847237494558"}]}]\
, "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.8400000000000000799360577730112709105014801025390625`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.17828278684262861879077467436400554714`16.251921820956955", ",", 
         "2.11044561989789831156683534188409343627`17.636955871647505", ",", 
         "0.98822314724654096036085869961129492882`17.874307963278522", ",", 
         RowBox[{
         "-", "0.32334476336249416437441453836577975597`16.21380028597947"}], 
         ",", "0.26241017956446175421250490868892723208`16.337953802086584", 
         ",", "1.90852404375198503358211702204047461519`17.395850726351757", 
         ",", 
         RowBox[{
         "-", "1.95804922244882316033396106390754045012`17.171687672368638"}],
          ",", 
         RowBox[{
         "-", "1.91224522456097946294891657886099788111`16.983031341606697"}]}\
], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.8200000000000000621724893790087662637233734130859375`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.2248871242520674325608414519530784661`16.524470462542862", ",", 
         "2.10338061108329026418784046980480457334`17.705321719978574", ",", 
         "0.98127286780838501924245806066004331253`17.9421005441343", ",", 
         RowBox[{
         "-", "0.41286641199398390775733609251996392482`16.46602847817066"}], 
         ",", "0.32962189245119322956564013368432375269`16.672390901167958", 
         ",", "1.92893081467624616243830793843897631093`17.471657384788184", 
         ",", 
         RowBox[{
         "-", "2.00812065378420755880495678474977719229`17.25334455638746"}], 
         ",", 
         RowBox[{
         "-", "1.95008285917872265670607646823526689988`16.903975128986314"}]}\
], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.8000000000000000444089209850062616169452667236328125`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.26339295244316498263101438730067507221`16.65736202733004", ",", 
         "2.09621328715245037653060587661846917204`17.69855531869447", ",", 
         "0.97432773676760922267749023661003208619`17.93475401904883", ",", 
         RowBox[{
         "-", "0.48937151973333877727700086742256102293`16.580308948571627"}],
          ",", "0.38441272033861098628153050512384195883`16.88116948648869", 
         ",", "1.94928191400913924726761362732956800696`17.4722164041785", 
         ",", 
         RowBox[{
         "-", "2.05843833793654962676522095820764036885`17.25961117775782"}], 
         ",", 
         RowBox[{
         "-", "1.98408323193533652300769630940661306495`17.056040113405725"}]}\
], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.7800000000000000266453525910037569701671600341796875`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.29697363542613545937691590416647227748`17.20250397781238", ",", 
         "2.08894358534780424367318105192768800917`18.13685924825164", ",", 
         "0.96738725367736208075386374888031263026`18.372428591509202", ",", 
         RowBox[{
         "-", "0.55827474229845810904233306344697176166`17.107865265240648"}],
          ",", "0.43154252960170968610754051615184673972`17.519179915607896", 
         ",", "1.96957958849580014784243259519123048591`17.91790748377006", 
         ",", 
         RowBox[{
         "-", "2.10900610437849584091238444794489094089`17.710818168552525"}],
          ",", 
         RowBox[{
         "-", "2.02035177575709567233601406563594564888`17.505433280375204"}]}\
], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.7600000000000000088817841970012523233890533447265625`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.32715506322265831229462771441610398015`17.20832747851357", ",", 
         "2.08157143537179335400124860083477622047`18.056334104290265", ",", 
         "0.96045091676191235789585078033962481963`18.29129646744951", ",", 
         RowBox[{
         "-", "0.62213847567579594647092220010982680025`17.0973636153675"}], 
         ",", "0.47330415476606789076799640680911111984`17.648873248692926", 
         ",", "1.98982601097481700219697385241151902168`17.844510709601344", 
         ",", 
         RowBox[{
         "-", "2.15982780246051701954103028935855434595`17.64284256611091"}], 
         ",", 
         RowBox[{
         "-", "2.05743385035649288716247419937204420797`17.42797396146049"}]}]\
, "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.720000000000000195399252334027551114559173583984375`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.38049799741116376354869518937556089724`17.49740479979275", ",", 
         "2.06651929658068084437451544884263863412`18.20931845190998", ",", 
         "0.94658861851412682692475101783991534577`18.44297294978196", ",", 
         RowBox[{
         "-", "0.73999151191467187429825098565681139441`17.356494640477976"}],
          ",", "0.54551860070055572207363011263075249428`18.432696274452756", 
         ",", "2.03017370559790365680727296239132079899`18.01169561426882", 
         ",", 
         RowBox[{
         "-", "2.26224899621370819611153774465436043979`17.820399964565663"}],
          ",", 
         RowBox[{
         "-", "2.13389069929999320206336089184133748583`17.591850311477607"}]}\
], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.70000000000000017763568394002504646778106689453125`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.40459586980154246115743472933891963089`17.52426997315635", ",", 
         "2.05883885819431098507509411760056722106`18.180572177810767", ",", 
         "0.93966157120144206642000851972032723903`18.413587785399997", ",", 
         RowBox[{
         "-", "0.79549671451042462919790330766953056915`17.369896452424634"}],
          ",", "0.5773902455448454570484318531945772088`18.582111030729966", 
         ",", "2.0502793816238022858316374334351942539`17.989813942047277", 
         ",", 
         RowBox[{
         "-", "2.31385705624528610467399059071937561936`17.80356222840824"}], 
         ",", 
         RowBox[{
         "-", "2.17332141846192802816602036763739723574`17.566116020665532"}]}\
], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.680000000000000159872115546022541821002960205078125`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.42737839012100260833514486892065341877`17.679418700629384", ",", 
         "2.05105511055748318155823166750779870665`18.2858783844253", ",", 
         "0.93273650806150606814240589686007920856`18.518221698785872", ",", 
         RowBox[{
         "-", "0.84935632890443882996283777847100478914`17.512117675318613"}],
          ",", "0.60704687116084402601046287533793905789`18.401154568007335", 
         ",", "2.07034255650449391412137961810136463142`18.10194831776329", 
         ",", 
         RowBox[{
         "-", "2.36573607942681794681248876955822404639`17.920596860228084"}],
          ",", 
         RowBox[{
         "-", "2.21329292965605249412327925708326793691`17.67655530214034"}]}]\
, "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.660000000000000142108547152020037174224853515625`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.44905044156931725813710104537822449892`18.114692428854053", ",", 
         "2.04316770968692976758822207327536658647`18.67558593036391", ",", 
         "0.92581285299639975326189988848394583236`18.90718999074594", ",", 
         RowBox[{
         "-", "0.90188824865230558189161559610463161577`17.93489687366816"}], 
         ",", "0.63480208031824589988635141731748677258`18.64205363440187", 
         ",", "2.09036540845464942641216960561665598646`18.49856549191562", 
         ",", 
         RowBox[{
         "-", "2.41789070492861081268419722826424575636`18.321915000355304"}],
          ",", 
         RowBox[{
         "-", "2.25444613515807330171781050227794000237`18.076814337144018"}]}\
], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.62000000000000010658141036401502788066864013671875`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.4896633873048487264712487114637754745`17.872845897572994", ",", 
         "2.0270801055189352936490608066944448954`18.35388915954576", ",", 
         "0.91196733367799396891559516022038539563`18.584098914165917", ",", 
         RowBox[{
         "-", "1.00389863726385837123881277062251144841`17.670132250091147"}],
          ",", "0.68553719164958750505432078267226436961`18.112104467503148", 
         ",", "2.13029915393905554714043245331949345229`18.19025589109148", 
         ",", 
         RowBox[{
         "-", "2.5230466465334194830341539388471180601`18.02283048279319"}], 
         ",", 
         RowBox[{
         "-", "2.33948697718619670691201046566200221748`17.760929690049753"}]}\
], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.600000000000000088817841970012523233890533447265625`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.508831069508077668034223235603962635`17.948736702945077", ",", 
         "2.01887886294798121898246115467688925267`18.394840481074457", ",", 
         "0.90504421789767688399925236373387604582`18.624341273429838", ",", 
         RowBox[{
         "-", "1.05370446177755217374023782741581045213`17.73545499261132"}], 
         ",", "0.70885831186657554997165753010965902062`18.088217678886984", 
         ",", "2.15021452540582134149576599731207918029`18.237452138290827", 
         ",", 
         RowBox[{
         "-", "2.57605828148083083547679260616917517093`18.074576957939083"}],
          ",", 
         RowBox[{
         "-", "2.3836530599497101673316459306712155232`17.805970777273036"}]}]\
, "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.5800000000000000710542735760100185871124267578125`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.52735687338474434719461395095789170192`17.807916316276525", ",", 
         "2.01057184111291033047949969492805378953`18.22016899338401", ",", 
         "0.89811999419753555611460402453445625112`18.448851055091932", ",", 
         RowBox[{
         "-", "1.10288621786640007987646508382885863372`17.584125983332836"}],
          ",", "0.7309981296266608745782669108449622867`17.865170789057846", 
         ",", "2.17009860168785823438875965544715894958`18.06951100726139", 
         ",", 
         RowBox[{
         "-", "2.62936628391131718336350308323112570887`17.91084182775893"}], 
         ",", 
         RowBox[{
         "-", "2.42809696853502171120375809624186506045`17.691805017629385"}]}\
], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.560000000000000053290705182007513940334320068359375`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.545310587073965956620783127365204026`17.880731409477967", ",", 
         "2.00215836784537484328121731756801008046`18.261512084090416", ",", 
         "0.89119399166074576009570249706275138021`18.489433416322694", ",", 
         RowBox[{
         "-", "1.15154518901352409062840790108615319458`17.646782640724137"}],
          ",", "0.75206739010711454981942382631589970013`17.866918197248943", 
         ",", "2.18995364686244387977029687061737480485`18.117321373273004", 
         ",", 
         RowBox[{
         "-", "2.68297629783243294979502355043363016858`17.96286885877346"}], 
         ",", 
         RowBox[{
         "-", "2.47424507719914175251685792359143946093`17.68796083062032"}]}]\
, "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.520000000000000017763568394002504646778106689453125`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.57972979839149390659923888111319953779`18.050551085882255", ",", 
         "1.98500893496313668525634136568617686868`18.37372237038883", ",", 
         "0.87733383717736855793901759945279392666`18.600106022158492", ",", 
         RowBox[{
         "-", "1.24761725243500018364273131298167367751`17.79791781843477"}], 
         ",", "0.79134720225551886735707031870505529415`17.916875960347312", 
         ",", "2.22958594750243890284791897785903389351`18.242101961722017", 
         ",", 
         RowBox[{
         "-", "2.79112627307350639713715083019652531221`18.095861556988115"}],
          ",", 
         RowBox[{
         "-", "2.56957876658576800999978933910963456387`17.809967890386503"}]}\
], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.5`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.59628983587464635361421601530394331891`18.268890304694786", ",", 
         "1.97627123699459299278612634556010944256`18.565295954210214", ",", 
         "0.87039822607896974942961405367601865118`18.790878591437778", ",", 
         RowBox[{
         "-", "1.29516130507370651954247532975523156528`18.007437913596473"}],
          ",", "0.80970717722937590889178777352817901044`18.083230056478516", 
         ",", "2.24936790277851780700266688959021682016`18.439924373397236", 
         ",", 
         RowBox[{
         "-", "2.84567875252191372977330482189511497874`18.297620799381907"}],
          ",", 
         RowBox[{
         "-", "2.61947416762935498766858713075820760058`18.266259779172653"}]}\
], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.479999999999999982236431605997495353221893310546875`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.61246979813564840891350819652326817048`18.60128474025309", ",", 
         "1.96742360020856145695595253669276070856`18.871765743056436", ",", 
         "0.86345791450583732229297797154152890894`19.096642112753326", ",", 
         RowBox[{
         "-", "1.3424525385995278859272496452603217817`18.331263137685486"}], 
         ",", "0.8273010438624391403132285665872021793`18.367232018082884", 
         ",", "2.26913024126254834337793939528873035433`18.75259543558266", 
         ",", 
         RowBox[{
         "-", "2.90055831214302485331782637189251483561`18.614154891379286"}],
          ",", 
         RowBox[{
         "-", "2.67560265465207171244253822058639612896`18.315968031133767"}]}\
], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.439999999999999946709294817992486059665679931640625`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.64382090737219924983116416545423468496`18.397025822401744", ",", 
         "1.94939421711113520229560535314380970447`18.619650247068783", ",", 
         "0.8495600175246892147335321804359778506`18.842714796937805", ",", 
         RowBox[{
         "-", "1.43644174493942741935353353907178463106`18.109894606974184"}],
          ",", "0.86036809268437975638569889231071810453`18.08150870384997", 
         ",", "2.30860574334548061407146783635227814726`18.512661324362742", 
         ",", 
         RowBox[{
         "-", "3.01132640401246015859122412074176201415`18.381525416548794"}],
          ",", 
         RowBox[{
         "-", "2.7757122847741935101958620496542447446`18.082786178305085"}]}]\
, "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.4200000000000001509903313490212894976139068603515625`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.65904895083926992626575422714464114085`18.463319556253296", ",", 
         "1.94021010126469388341962340153820787307`18.66350452972537", ",", 
         "0.84260077672272207790140378091621192594`18.88570110783847", ",", 
         RowBox[{
         "-", "1.48322039054881271722702772797517679844`18.167517374885914"}],
          ",", "0.87594211422651609401692814939056302992`18.112180911786847", 
         ",", "2.32832385703345765562194509824970508034`18.56250865934653", 
         ",", 
         RowBox[{
         "-", "3.06722953242090273666356691433685508977`18.43497029165014"}], 
         ",", 
         RowBox[{
         "-", "2.82877805358194320597695642697632531611`17.80107797116388"}]}]\
, "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.3800000000000001154631945610162802040576934814453125`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.68873142726227187656028435037627427234`18.460127116260786", ",", 
         "1.92149646216590976929949501825122778151`18.61710477837906", ",", 
         "0.82865736883821744005115831487063935826`18.83758207630158", ",", 
         RowBox[{
         "-", "1.57650078515258567821497372400626780689`18.149431953363123"}],
          ",", "0.90535929523525631184328886046365283091`18.03659347407603", 
         ",", "2.36773344839156554720600519301002360248`18.5279617800122", 
         ",", 
         RowBox[{
         "-", "3.18011258282389328784387386064645897433`18.4072263819936"}], 
         ",", 
         RowBox[{
         "-", "2.93757408674391524499850308241373236706`18.095258866266146"}]}\
], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.3600000000000000976996261670137755572795867919921875`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.70322780516793435182408136524578451468`18.46819967194731", ",", 
         "1.91196404479595939482802578087300253907`18.604744774704518", ",", 
         "0.82167137770573278017743982221526215688`18.82434132832704", ",", 
         RowBox[{
         "-", "1.62305924996949594509038828761912985549`18.150026737510284"}],
          ",", "0.9192712465199205979944140988958833809`18.012243068430415", 
         ",", "2.38743010428085601967370101117323037137`18.521410492194637", 
         ",", 
         RowBox[{
         "-", "3.23710888148969636886309509656405552241`18.403973462265462"}],
          ",", 
         RowBox[{
         "-", "2.99433302043442986889182535023712679663`18.087501918332475"}]}\
], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.3400000000000000799360577730112709105014801025390625`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.71751929780597530660008693401615326892`18.778847709826024", ",", 
         "1.9023124637777905471949512581522167995`18.89591980783119", ",", 
         "0.8146745912835192581727601038335749534`19.114615150597384", ",", 
         RowBox[{
         "-", "1.66959606725807137947833905650430488288`18.453478196245495"}],
          ",", "0.93269213127628404784852022767957100618`18.29197664406691", 
         ",", "2.40712487453315616436741582003221361105`18.81822280522023", 
         ",", 
         RowBox[{
         "-", "3.29448651666826392879383617270193309105`18.704101629139544"}],
          ",", 
         RowBox[{
         "-", "3.05241509581518337548460512349273481908`18.384443153934832"}]}\
], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.3200000000000000621724893790087662637233734130859375`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.73162281847973311089329878899990946144`18.78165725871974", ",", 
         "1.89254004314606623048117649626036577698`18.87879934434302", ",", 
         "0.80766602171905087328392458047626278865`19.096612108209033", ",", 
         RowBox[{
         "-", "1.71613308361671838210210373903774659063`18.448817587174215"}],
          ",", "0.94564821735253227911160764959089122005`18.264904444090114", 
         ",", "2.42682044739463732088623509385992403926`18.806977622226718", 
         ",", 
         RowBox[{
         "-", "3.35225447936183325740832827874393565026`18.695794785702958"}],
          ",", 
         RowBox[{
         "-", "3.11136698259082654150281928186822456416`18.373110785819414"}]}\
], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.2800000000000000266453525910037569701671600341796875`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.75932763210644095433284329663186231737`18.64884845631909", ",", 
         "1.87262534312052112294092237471004951811`18.70917307237871", ",", 
         "0.79360937763113399582120307491983462022`18.925118810858223", ",", 
         RowBox[{
         "-", "1.80929019609338276247466908161668548428`18.30186257992574"}], 
         ",", "0.97026853758908287608226157997545473555`18.076096846928507", 
         ",", "2.46622515924860959723845742530439844683`18.64854356052602", 
         ",", 
         RowBox[{
         "-", "3.46899946620862236768581765567256769327`18.543421154196896"}],
          ",", 
         RowBox[{
         "-", "3.2338612394432893633163618320073172872`18.21568960543686"}]}],
         "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.229999999999999982236431605997495353221893310546875`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.79315964559703912313281017239087985678`18.979124418394985", ",", 
         "1.8470177282818883401952452236562921133`18.994858808363134", ",", 
         "0.7759531701000266048475110008392918823676784173217103942527`19.\
208417585279914", ",", 
         RowBox[{
         "-", "1.92608355535282094730517281469331771682`18.67835506330257"}], 
         ",", "0.99884530842038083300667340207997431849`18.310558488719366", 
         ",", "2.51553616990199707911896385976472366003`18.94830466807443", 
         ",", 
         RowBox[{
         "-", "3.61730234358377954475036198368891917038`18.84998657501925"}], 
         ",", 
         RowBox[{
         "-", "3.39185966361422235423055992096238290538`18.82458322000194"}]}]\
, "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.1799999999999999378275106209912337362766265869140625`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.826283465282041556448077749870430434`19.080746832915803", ",", 
         "1.82058354089626615307208660762536270625`19.058143791420452", ",", 
         "0.7581848246115099316074367575122677298879462640116067988276`19.\
27001897188364", ",", 
         RowBox[{
         "-", "2.04371569473449635714535454133623582278`18.699394613251368"}],
          ",", "1.0253784823154466696775021537555491094`18.377029392158455", 
         ",", "2.56495241362759367009152688428904507511`19.02950304717009", 
         ",", 
         RowBox[{
         "-", "3.7684012752079647281959900984018759471`18.93950960992625"}], 
         ",", 
         RowBox[{
         "-", "3.56276923877901352897573858926378852105`18.56683589645808"}]}]\
, "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.0300000000000000266453525910037569701671600341796875`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.92305001384527226332918428467676863032`19.208915334308756", ",", 
         "1.73588343347923330461440135480917077847`19.069341503957123", ",", 
         "0.7039933697520359459613974757504187011197599704644839295697`19.\
273312021097116", ",", 
         RowBox[{
         "-", "2.40215163145886304675966360623624005127`18.778265169621232"}],
          ",", "1.0943120467525076722894678274184454956`18.345938555155247", 
         ",", "2.71435448070333938252112934351744694326`19.07915142712122", 
         ",", 
         RowBox[{
         "-", "4.2404952949385330490316419672889217101`19.005176499666444"}], 
         ",", 
         RowBox[{
         "-", "4.11403427381797909682428151391260099497`18.631039945650603"}]}\
], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.979999999999999982236431605997495353221893310546875`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.9549300364529635084816177449768269579563192644122935385028`19.\
249232759484237", ",", 
         "1.70567014830465192805011084796466743067`19.074927300472126", ",", 
         "0.6855508966047843211492325341167320286213596448490782151355`19.\
275992226416985", ",", 
         RowBox[{
         "-", "2.5244685484565634551600154320590657577`18.80281713257124"}], 
         ",", "1.11459859189517704509025513255878689927`18.337177460668435", 
         ",", "2.76473478388451048199053008131996229579`19.097361412210542", 
         ",", 
         RowBox[{
         "-", "4.40492376169181898813556697660073597965`19.028823403165617"}],
          ",", 
         RowBox[{
         "-", "4.31712553749551694891017525241803401171`18.649237218076216"}]}\
], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.9299999999999999378275106209912337362766265869140625`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.98685780370282752267019223366231754961`19.167506354119638", ",", 
         "1.67435478013948338032285261289224576332`18.95526213663414", ",", 
         "0.6668699612914541335971313028180963281637763082659236508289`19.\
153564129310585", ",", 
         RowBox[{
         "-", "2.64859197640651796485532912118621823715`18.70187606578796"}], 
         ",", "1.13387145954400061499380057677116333279`18.207535843870698", 
         ",", "2.81551634879218597073420969900244849847`18.990818750620498", 
         ",", 
         RowBox[{
         "-", "4.57336062507622320205250208929077116027`18.9251058092542"}], 
         ",", 
         RowBox[{
         "-", "4.53094005184907296826662586551771347192`18.54946052300428"}]}]\
, "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.88000000000000000444089209850062616169452667236328125`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.01897670241351551459974021583150568154`19.144664388295794", ",", 
         "1.64185365154945147692147369910208074172`18.898322402062856", ",", 
         "0.647915368592266632556979294123480300078866209768580190376`19.\
09349044878369", ",", 
         RowBox[{
         "-", "2.7747994832193873389172494441532238017`18.661948970599628"}], 
         ",", "1.15232497464308537765203032645303613493`18.138550940206603", 
         ",", "2.86677671775689111108263725722459384244`18.945988580865976", 
         ",", 
         RowBox[{
         "-", "4.7461502442497914151752061594710817143`18.88437171978516"}], 
         ",", 
         RowBox[{
         "-", "4.75471713677362468694141461256050561376`18.507230877059545"}]}\
], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.8300000000000000710542735760100185871124267578125`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.0514372429042203375562594196243562228373953569940051398153`19.\
575737080677218", ",", 
         "1.60806906929638127795544371494463124145`19.292411507784227", ",", 
         "0.6286470349209578111109977926158731683829688337958375306897`19.\
484682135155662", ",", 
         RowBox[{
         "-", "2.90336942339238371772102781826423056419`19.07274839606759"}], 
         ",", "1.17014687176092472413088338629161576568`18.52453289805585", 
         ",", "2.91860268717924982569977129865931673798`19.35231759205413", 
         ",", 
         RowBox[{
         "-", "4.92368667325038081812426738727014797736`19.292355909532297"}],
          ",", 
         RowBox[{
         "-", "4.99184034619885460045701727438889923335`18.95896208462151"}]}]\
, "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.7800000000000000266453525910037569701671600341796875`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.0844016680768961437220490702955711933439400168414485519033`19.\
69444847864245", ",", 
         "1.57288626670664111054871669583818503063`19.374982946465924", ",", 
         "0.6090189265217211949424114427723515177499817188408813623032`19.\
56417262047879", ",", 
         RowBox[{
         "-", "3.03462796533385920338183320776320644365`19.170872787839464"}],
          ",", "1.18752563775068671666348194309470149828`18.598867776715757", 
         ",", "2.97109240469970745531731947046494817996`19.447117550761984", 
         ",", 
         RowBox[{
         "-", "5.10642425884591876352675132408982159266`19.388706451320846"}],
          ",", 
         RowBox[{
         "-", "5.24032175505505190230431652811132312574`19.024215418289376"}]}\
], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.729999999999999982236431605997495353221893310546875`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.1180494335737042122483853610393497059333010192152024983466`19.\
56854379232997", ",", 
         "1.5361694334683948174562934507597505689`19.211467875698922", ",", 
         "0.5889776886951550734121138418171345487581911711361247277809`19.\
39768077452383", ",", 
         RowBox[{
         "-", "3.16892302661978081431784821859117760006`19.022290784318994"}],
          ",", "1.2046529638223746886687648187123254026`18.428862366504468", 
         ",", "3.02435805104580740831729060424552887307`19.296107643662598", 
         ",", 
         RowBox[{
         "-", "5.29489118494366426624428670774105805222`19.237844105023548"}],
          ",", 
         RowBox[{
         "-", "5.50450364954771824479898067586571319318`18.874381917291476"}]}\
], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.6799999999999999378275106209912337362766265869140625`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.1525840725228305749318431532101631910472029911715348028518`19.\
81978286745331", ",", 
         "1.49775645566507371719704915467825303501`19.42284565702389", ",", 
         "0.5684608391053546083331492017435875968367509020297115947761`19.\
606250626423172", ",", 
         RowBox[{
         "-", "3.30667988124532110819742393600684359672`19.248732126696297"}],
          ",", "1.22173313132896432177326426181137126942`18.635444396170403", 
         ",", "3.07852935717537479681996040930788712916`19.52011303931315", 
         ",", 
         RowBox[{
         "-", "5.48970739725775660997543129417838935892`19.46005683261738"}], 
         ",", 
         RowBox[{
         "-", "5.78290938012974678189649635801084258419`19.17852819520189"}]}]\
, "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.63000000000000000444089209850062616169452667236328125`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.1882422182136936991290026929716905517004216935518072489155`19.\
47275709898281", ",", 
         "1.45745175063817752631962109364116275569`19.04241797808694", ",", 
         "0.5473943283315488237598277267274028739702322330965580927536`19.\
222002803217492", ",", 
         RowBox[{
         "-", "3.44837705800855289500834807591027217791`18.88077521405457"}], 
         ",", "1.23898197155275483119106016361849086433`18.244931068961534", 
         ",", "3.13375836110038056239421472028589401855`19.152198816709475", 
         ",", 
         RowBox[{
         "-", "5.69160857658172789717114139349401777044`19.094879133320894"}],
          ",", 
         RowBox[{
         "-", "6.07813657821745922948594834775313900464`18.726525972373032"}]}\
], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.57999999999999996003197111349436454474925994873046875`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.2253058947497144503322547840588956117586597177113848223468`19.\
646536291361837", ",", 
         "1.41501644235034231750721107662086559325`19.176785839292044", ",", 
         "0.5256892109490594429566410835797417324739607569218655397278`19.\
35313226641829", ",", 
         RowBox[{
         "-", "3.59459594770407954047158669664555788581`19.02823183898328"}], 
         ",", "1.25663965021175515337040247336408769358`18.3744478928404", 
         ",", "3.19022584550706115976205353661083121306`19.299394385535173", 
         ",", 
         RowBox[{
         "-", "5.90147885179951971056866809529405802234`19.24056870035239"}], 
         ",", 
         RowBox[{
         "-", "6.39244027148596286770004323554531228798`18.87761059682739"}]}]\
, "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.5300000000000000266453525910037569701671600341796875`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.2641199229982967514599358689241155660248273145279227954964`19.\
638601987544696", ",", 
         "1.3701544447912793340751943560111503499`19.127720960664305", ",", 
         "0.503236964416952288407344295752381700775440641224744493281`19.\
300805953577058", ",", 
         RowBox[{
         "-", "3.74602547324217754215738136726710478257`18.991594099637492"}],
          ",", "1.27497306424028809481591786065504874471`18.32150907665784", 
         ",", "3.24815036640076113703422521700398734845`19.263643322347352", 
         ",", 
         RowBox[{
         "-", "6.12039655462396303623094564662817544907`19.202474652873814"}],
          ",", 
         RowBox[{
         "-", "6.72884132789914146782707467662065861549`18.83969712608064"}]}]\
, "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.479999999999999982236431605997495353221893310546875`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.3051174932185953708831914066627180868419992325877725462079`19.\
783483534652955", ",", 
         "1.3224922064864913165548009047503789969`19.23108603557688", ",", 
         "0.4799027254414612244166700200568828052337071569415068104667`19.\
40074111653657", ",", 
         RowBox[{
         "-", "3.90352398353636707355883838547517379615`19.107017010116113"}],
          ",", "1.29428991253300041812361404050678117927`18.42155179471691", 
         ",", "3.30780126623244256934214686104729270455`19.38016886909206", 
         ",", 
         RowBox[{
         "-", "6.34970008911286836203810206377279939561`19.316350278018945"}],
          ",", 
         RowBox[{
         "-", "7.0888062803752998069015528986751269394`18.956886235152655"}]}]\
, "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.4299999999999999378275106209912337362766265869140625`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.3488592489910629388202713593165128159193856280824015683829`19.\
88783383075497", ",", 
         "1.27154828969074910920004621101370491264`19.294006432544563", ",", 
         "0.4555152050500040722843039988197949538594731067614635376726`19.\
459831355676293", ",", 
         RowBox[{
         "-", "4.06817316686962201019109992496106174817`19.182437290814516"}],
          ",", "1.31495893443206061980767347285505840953`18.4800842543204", 
         ",", "3.36951797442152405412791321935400687026`19.457323275140272", 
         ",", 
         RowBox[{
         "-", "6.59108568072754519425109301526865849165`19.391732522384324"}],
          ",", 
         RowBox[{
         "-", "7.47686941871520728014482640593567034805`19.03434684833617"}]}]\
, "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.38000000000000000444089209850062616169452667236328125`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.3960958044141990525802234319768943507227191027545263389836`19.\
718933507245396", ",", 
         "1.21668578316308199443670771258363999273`19.079838437319786", ",", 
         "0.4298510376065657949688846739609087386836731815784352522747`19.\
241994201014606", ",", 
         RowBox[{
         "-", "4.24136643597375378942436395418550226889`18.980145274311973"}],
          ",", "1.33743358064830886539040874595788704732`18.263898152831548", 
         ",", "3.43373983313631819300450736404010246792`19.25768149823831", 
         ",", 
         RowBox[{
         "-", "6.84675829388160667050905028283205572206`19.188388271188515"}],
          ",", 
         RowBox[{
         "-", "7.89813113785110921961393638594212771499`18.964808609952772"}]}\
], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.2800000000000000266453525910037569701671600341796875`30.", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.5057237131236946149572585277001824715547604249937523528014`20.\
198489839014602", ",", 
         "1.0913520186069008169023962405756889384286004585925752288334`19.\
45425754351719", ",", 
         "0.3733671977741275317827716090449990681224663915491298672491`19.\
609798741566237", ",", 
         RowBox[{
         "-", "4.62160136115503603924571522000341036396`19.37673763017697"}], 
         ",", "1.3903207060443585196081175574042790746`18.643859092522224", 
         ",", "3.57228115704934353697166528552304459294`19.66148809577124", 
         ",", 
         RowBox[{
         "-", "7.41397203469514625133211363434975096847`19.578083192017885"}],
          ",", 
         RowBox[{
         "-", "8.86898196995222814779997966770086529663`19.23867673419304"}]}]\
, "}"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.546436519444852*^9, 3.5464365416209*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"evaldata", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "1.`", ",", "0.013355427030609502`", ",", "1.9860966307206008`*^-6", 
       ",", "1.089789031882011`", ",", "0.8167471017601661`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "2.`", ",", "0.024863880157155523`", ",", "1.981798887721658`*^-6", ",",
        "1.0862811376870731`", ",", "0.8200124961943811`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "3.`", ",", "0.036488952817266065`", ",", "1.991322423598302`*^-6", ",",
        "1.0826996974564858`", ",", "0.8233215388353586`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "4.`", ",", "0.048233993006196386`", ",", "1.9893267668598008`*^-6", 
       ",", "1.0790512780431512`", ",", "0.8266640959611817`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "5.`", ",", "0.060100523895738674`", ",", "1.997550590183286`*^-6", ",",
        "1.0753274710016987`", ",", "0.8300622492816359`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "6.`", ",", "0.07210047440601176`", ",", "1.995823015305307`*^-6", ",", 
       "1.0715277385680346`", ",", "0.8335148927287811`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "7.`", ",", "0.07932786064730332`", ",", "1.992559498181968`*^-6", ",", 
       "1.0692162004004249`", ",", "0.8356023819252281`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "8.`", ",", "0.12880399681349508`", ",", "1.9927423348921807`*^-6", ",",
        "1.0531136756838586`", ",", "0.850029531340391`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "9.`", ",", "0.18025444926618495`", ",", "1.992271477540408`*^-6", ",", 
       "1.0358320985720118`", ",", "0.8653680568755421`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "10.`", ",", "0.23356901840447203`", ",", "1.9987513485873957`*^-6", 
       ",", "1.0173656439992187`", ",", "0.8819402682577396`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "11.`", ",", "0.2887511827033691`", ",", "2.009293554856655`*^-6", ",", 
       "0.9978109328409334`", ",", "0.8999820987298613`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "12.`", ",", "0.4031302700216593`", ",", "2.006831217325212`*^-6", ",", 
       "0.9560907310211755`", ",", "0.9409296952850229`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "13.`", ",", "0.4611567158269449`", ",", "2.0188526136830535`*^-6", ",",
        "0.9345150251209703`", ",", "0.9643244207676307`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "14.`", ",", "0.5187547246408238`", ",", "2.0100499530528477`*^-6", ",",
        "0.9129721447213588`", ",", "0.9897489824487526`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "15.`", ",", "0.5750817231523991`", ",", "2.051139907071463`*^-6", ",", 
       "0.8918946312794616`", ",", "1.0171024864713747`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "16.`", ",", "0.6811653295730736`", ",", "2.0079234251954254`*^-6", ",",
        "0.8525624867211421`", ",", "1.0765901399556308`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "17.`", ",", "0.7301343720530127`", ",", "2.0004754316410604`*^-6", ",",
        "0.8347384181246352`", ",", "1.1080478219686238`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "18.`", ",", "0.7762686445916074`", ",", "2.083423994617962`*^-6", ",", 
       "0.8182600403755962`", ",", "1.1401398101990141`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "19.`", ",", "0.8196884370580693`", ",", "1.989712625657631`*^-6", ",", 
       "0.8030796422533432`", ",", "1.172568829826647`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "20.`", ",", "0.8992171834800822`", ",", "2.0301736799143564`*^-6", ",",
        "0.7762543001516762`", ",", "1.2374766358576499`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "21.`", ",", "0.9360717995312261`", ",", "2.04074159850976`*^-6", ",", 
       "0.764359827114243`", ",", "1.2696316415226445`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "22.`", ",", "0.971415823581929`", ",", "1.9464700593225457`*^-6", ",", 
       "0.753331912450557`", ",", "1.3014340369026258`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "23.`", ",", "0.9875163262956634`", ",", "0.000012529246627683165`", 
       ",", "0.7334519907872498`", ",", "1.363740187617995`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "24.`", ",", "0.9825984218731308`", ",", "2.1530639930923587`*^-6", ",",
        "0.7244207892404195`", ",", "1.3941790650255137`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "25.`", ",", "0.9726312951891297`", ",", "1.861694067757406`*^-6", ",", 
       "0.707839251312378`", ",", "1.4535489272252362`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "26.`", ",", "0.9676032724692676`", ",", "2.0236163008197642`*^-6", ",",
        "0.7001730148426325`", ",", "1.4824782981755653`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "27.`", ",", "0.9624790234034787`", ",", "2.0090998033847226`*^-6", ",",
        "0.6928615643422419`", ",", "1.5108862183950513`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "28.`", ",", "0.9573206057670106`", ",", "2.0082763398795613`*^-6", ",",
        "0.6858814510235705`", ",", "1.5388240367494934`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "29.`", ",", "0.9655554985487668`", ",", "1.9967442436782586`*^-6", ",",
        "0.672781500816147`", ",", "1.5932586786210479`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "30.`", ",", "0.9511738001159835`", ",", "2.0099571188810713`*^-6", ",",
        "0.6577874193682531`", ",", "1.6587853370968457`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "31.`", ",", "0.9364416075889883`", ",", "9.8953417417658`*^-7", ",", 
       "0.6441324527870885`", ",", "1.7216645007986824`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "32.`", ",", "0.9589246173620162`", ",", "1.9873268059218668`*^-6", ",",
        "0.6097333361828048`", ",", "1.8969928795112032`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "33.`", ",", "0.9412018574046571`", ",", "2.0166984892892893`*^-6", ",",
        "0.6002217748641081`", ",", "1.9516962198942012`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "34.`", ",", "0.923104799721937`", ",", "2.021486987909141`*^-6", ",", 
       "0.5916518255972307`", ",", "2.004870753065489`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "35.`", ",", "0.9046413587640635`", ",", "2.0267460205007787`*^-6", ",",
        "0.5840070133857772`", ",", "2.056707227265943`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "36.`", ",", "0.8857727542209854`", ",", "2.0347780582398325`*^-6", ",",
        "0.5772900533639685`", ",", "2.1073974796336308`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "37.`", ",", "0.8664581795389469`", ",", "2.046271610260587`*^-6", ",", 
       "0.5715229045070065`", ",", "2.1571321381328703`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "38.`", ",", "0.8466265636335253`", ",", "2.0339184510776367`*^-6", ",",
        "0.5667354868863977`", ",", "2.206113710732417`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "39.`", ",", "0.8262595526024176`", ",", "2.048908213283839`*^-6", ",", 
       "0.5629656258151441`", ",", "2.254562169822297`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "40.`", ",", "0.8052506322703827`", ",", "2.0408957327099424`*^-6", ",",
        "0.5602410237055435`", ",", "2.302691154004069`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "41.`", ",", "0.783551752676484`", ",", "2.0764216706023143`*^-6", ",", 
       "0.5586045180359029`", ",", "2.3507361736089183`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "42.`", ",", "0.7610222409970961`", ",", "2.109146950199457`*^-6", ",", 
       "0.5581090022833366`", ",", "2.399027655193278`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "43.`", ",", "0.7375307334489988`", ",", "0.00002815072323011789`", ",",
        "0.5587831144489958`", ",", "2.447895836101554`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "44.`", ",", "0.7128841323389946`", ",", "0.000028211859861294432`", 
       ",", "0.5606698646554756`", ",", "2.4976790807285782`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "45.`", ",", "0.7512740134054828`", ",", "0.000035581009449229136`", 
       ",", "0.5637703717819552`", ",", "2.5488462247916743`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "46.`", ",", "0.6964757325356659`", ",", "2.0491045054357296`*^-6", ",",
        "0.5739486923526856`", ",", "2.6576367039002093`"}], "}"}]}], "}"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.546479660817749*^9, 3.546479674412341*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"evaldata3", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "1.`", ",", "0.21605069199765736`", ",", "0.37428439350777076`", ",", 
       "1.7523585173374012`", ",", "1.2166499539477766`", ",", 
       "3.574905730502188`", ",", "1.8487623152016188`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "2.`", ",", "0.21499319240620987`", ",", "0.37294233117137143`", ",", 
       "1.7496397066138143`", ",", "1.2150524513035923`", ",", 
       "3.570433271131741`", ",", "1.8471360041741793`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "3.`", ",", "0.2139382416908635`", ",", "0.3715976162161407`", ",", 
       "1.7469215006452903`", ",", "1.2134550014615`", ",", 
       "3.565839487079291`", ",", "1.8448247276697267`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "4.`", ",", "0.2128850848221563`", ",", "0.3702522119393653`", ",", 
       "1.744206474763501`", ",", "1.211857901864979`", ",", 
       "3.5613711624188187`", ",", "1.8421645897868637`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "5.`", ",", "0.2118338521940498`", ",", "0.3689062548566291`", ",", 
       "1.741493092940252`", ",", "1.2102612958081487`", ",", 
       "3.5570430689887997`", ",", "1.8394993627597864`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "6.`", ",", "0.21078449810811287`", ",", "0.3675597114237296`", ",", 
       "1.738781445148096`", ",", "1.2086653705015926`", ",", 
       "3.5527788420906075`", ",", "1.8369893406992717`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "7.`", ",", "0.20973699354577785`", ",", "0.36621255673785924`", ",", 
       "1.7360715572764085`", ",", "1.2070701460289717`", ",", 
       "3.5485242715130414`", ",", "1.8346329055007569`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "8.`", ",", "0.20869133575351825`", ",", "0.3648647886150636`", ",", 
       "1.7333634149728774`", ",", "1.2054755724398132`", ",", 
       "3.544249435569466`", ",", "1.8323592555354926`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "9.`", ",", "0.20764752649039525`", ",", "0.36351640934555024`", ",", 
       "1.7306570001186876`", ",", "1.203881607831645`", ",", 
       "3.539945499621197`", ",", "1.8300920306943869`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "10.`", ",", "0.2066055653636672`", ",", "0.3621674195492166`", ",", 
       "1.7279523044306067`", ",", "1.2022882385051814`", ",", 
       "3.5356237214911066`", ",", "1.8277921800886754`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "11.`", ",", "0.20556545088488473`", ",", "0.3608178188961524`", ",", 
       "1.725249327321593`", ",", "1.2006954667865692`", ",", 
       "3.531300773462671`", ",", "1.8254555810722117`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "12.`", ",", "0.20452718156558822`", ",", "0.3594676070272367`", ",", 
       "1.722548070045974`", ",", "1.1991032960257073`", ",", 
       "3.526986126919747`", ",", "1.8231013285067872`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "13.`", ",", "0.2034907560652889`", ",", "0.3581167836880261`", ",", 
       "1.7198485325262527`", ",", "1.1975117252288532`", ",", 
       "3.522681987547848`", ",", "1.820747788694495`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "14.`", ",", "0.20245617308641795`", ",", "0.35676534865145487`", ",", 
       "1.7171507132969461`", ",", "1.1959207500918114`", ",", 
       "3.5183855894689793`", ",", "1.8184056248314702`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "15.`", ",", "0.2014234313307457`", ",", "0.35541330168062746`", ",", 
       "1.714454610326144`", ",", "1.1943303656684452`", ",", 
       "3.5140926827944408`", ",", "1.8160754857578207`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "16.`", ",", "0.2003925295038187`", ",", "0.3540606425328895`", ",", 
       "1.711760221695985`", ",", "1.1927405676993714`", ",", 
       "3.509801049572556`", ",", "1.8137529132350492`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "17.`", ",", "0.19936346631839522`", ",", "0.3527073709611304`", ",", 
       "1.7090675457102114`", ",", "1.1911513526162862`", ",", 
       "3.5055099165041033`", ",", "1.8114329383376162`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "18.`", ",", "0.19833624049725015`", ",", "0.3513534867175282`", ",", 
       "1.7063765807561304`", ",", "1.1895627169525407`", ",", 
       "3.5012200307657695`", ",", "1.8091129587960486`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "19.`", ",", "0.19731085077104218`", ",", "0.3499989895496564`", ",", 
       "1.7036873252767388`", ",", "1.1879746574043482`", ",", 
       "3.496932330514959`", ",", "1.8067929052483298`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "20.`", ",", "0.19628729587996027`", ",", "0.3486438792033225`", ",", 
       "1.700999777623369`", ",", "1.1863871703575803`", ",", 
       "3.4926475244278863`", ",", "1.804473796328725`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "21.`", ",", "0.19526557457192523`", ",", "0.34728815542269`", ",", 
       "1.6983139360526998`", ",", "1.1848002522575545`", ",", 
       "3.488365852803198`", ",", "1.8021568404630426`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "22.`", ",", "0.19424568560393538`", ",", "0.3459318179477473`", ",", 
       "1.6956297988842945`", ",", "1.1832138997041508`", ",", 
       "3.484087034636466`", ",", "1.7998426613959253`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "23.`", ",", "0.1932276277418824`", ",", "0.3445748665141909`", ",", 
       "1.6929473643925768`", ",", "1.181628109247731`", ",", 
       "3.4798108035413065`", ",", "1.7975312463840876`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "24.`", ",", "0.19221139975884208`", ",", "0.3432173008582047`", ",", 
       "1.6902666308204666`", ",", "1.1800428774063023`", ",", 
       "3.475537010178252`", ",", "1.7952221881043886`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "25.`", ",", "0.19119700043756024`", ",", "0.3418591207117104`", ",", 
       "1.6875875964605798`", ",", "1.178458200804409`", ",", 
       "3.471265567611088`", ",", "1.7929152791609388`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "26.`", ",", "0.19018442856844264`", ",", "0.3405003258020358`", ",", 
       "1.6849102594988674`", ",", "1.1768740760468444`", ",", 
       "3.466996544311794`", ",", "1.7906103833343063`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "27.`", ",", "0.18917368295046294`", ",", "0.3391409158550245`", ",", 
       "1.6822346182191086`", ",", "1.1752904998823133`", ",", 
       "3.4627301042037457`", ",", "1.7883074740466307`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "28.`", ",", "0.18816476239125055`", ",", "0.33778089059435074`", ",", 
       "1.679560670777551`", ",", "1.173707468906063`", ",", 
       "3.4584662544511477`", ",", "1.7860064916986944`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "29.`", ",", "0.1871576657062651`", ",", "0.33642024973789897`", ",", 
       "1.6768884154238561`", ",", "1.1721249799088787`", ",", 
       "3.4542049344351384`", ",", "1.7837075686265955`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "30.`", ",", "0.18615239171997544`", ",", "0.33505899300366143`", ",", 
       "1.6742178503399685`", ",", "1.1705430295970858`", ",", 
       "3.449946078600454`", ",", "1.7814106929047964`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "31.`", ",", "0.18514893926400966`", ",", "0.3336971201039062`", ",", 
       "1.6715489736882305`", ",", "1.1689616147912165`", ",", 
       "3.4456897217660907`", ",", "1.7791158902966677`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "32.`", ",", "0.18414730717931152`", ",", "0.3323346307492071`", ",", 
       "1.6688817836152616`", ",", "1.167380732311201`", ",", 
       "3.4414358423925875`", ",", "1.776823155669296`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "33.`", ",", "0.18314749431469904`", ",", "0.33097152464674434`", ",", 
       "1.6662162783279988`", ",", "1.1658003789455924`", ",", 
       "3.4371844624134718`", ",", "1.7745322839506785`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "34.`", ",", "0.18214949952671866`", ",", "0.32960780149910157`", ",", 
       "1.6635524558838362`", ",", "1.1642205514918325`", ",", 
       "3.432935570233188`", ",", "1.7722433518245406`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "35.`", ",", "0.18115332168037948`", ",", "0.32824346100757906`", ",", 
       "1.6608903144356815`", ",", "1.1626412468703293`", ",", 
       "3.4286891750235764`", ",", "1.7699564150527376`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "36.`", ",", "0.18015895964885248`", ",", "0.32687850286984643`", ",", 
       "1.6582298521427068`", ",", "1.1610624621409087`", ",", 
       "3.424445292530597`", ",", "1.7676714132941962`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "37.`", ",", "0.1791664123132706`", ",", "0.3255129267784359`", ",", 
       "1.6555710670455777`", ",", "1.1594841941094718`", ",", 
       "3.4202039196094938`", ",", "1.7653882458402663`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "38.`", ",", "0.17817567856337582`", ",", "0.324146732424455`", ",", 
       "1.6529139572834852`", ",", "1.157906439702186`", ",", 
       "3.4159650041532528`", ",", "1.7631069030610467`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "39.`", ",", "0.17718675729584157`", ",", "0.32277991949538704`", ",", 
       "1.650258520908726`", ",", "1.1563291960035615`", ",", 
       "3.4117285708367087`", ",", "1.760827428685683`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "40.`", ",", "0.17619964741651845`", ",", "0.3214124876730412`", ",", 
       "1.6476047560441847`", ",", "1.1547524600369963`", ",", 
       "3.4074945540541153`", ",", "1.7585497977269404`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "41.`", ",", "0.17521434783777853`", ",", "0.32004443663923`", ",", 
       "1.644952660702822`", ",", "1.1531762287656246`", ",", 
       "3.403262953450135`", ",", "1.7562740064159967`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "42.`", ",", "0.17423085748121223`", ",", "0.3186757660698963`", ",", 
       "1.642302232936395`", ",", "1.1516004993261986`", ",", 
       "3.3990338077325135`", ",", "1.7540000821711625`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "43.`", ",", "0.17324917527592218`", ",", "0.3173064756379951`", ",", 
       "1.6396534707896262`", ",", "1.15002526884331`", ",", 
       "3.3948071073603416`", ",", "1.7517278920299257`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "44.`", ",", "0.17226930015924705`", ",", "0.3159365650126832`", ",", 
       "1.6370063723128498`", ",", "1.1484505344177216`", ",", 
       "3.3905829197988178`", ",", "1.7494574312647762`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "45.`", ",", "0.17129123107547242`", ",", "0.31456603386075266`", ",", 
       "1.6343609355065039`", ",", "1.146876293218766`", ",", 
       "3.3863611707163073`", ",", "1.7471887272209372`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "46.`", ",", "0.1703149669766031`", ",", "0.3131948818432432`", ",", 
       "1.6317171584102839`", ",", "1.14530254242247`", ",", 
       "3.3821418542806203`", ",", "1.744921762552202`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "47.`", ",", "0.16934050682378807`", ",", "0.3118231086193094`", ",", 
       "1.6290750390178745`", ",", "1.1437292792268656`", ",", 
       "3.377924968175581`", ",", "1.7426565208217786`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "48.`", ",", "0.16836784958486115`", ",", "0.31045071384380185`", ",", 
       "1.6264345753078002`", ",", "1.142156500884553`", ",", 
       "3.373710444011985`", ",", "1.7403929966573386`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "49.`", ",", "0.1673969942358982`", ",", "0.30907769716709893`", ",", 
       "1.6237957652904684`", ",", "1.1405842046961965`", ",", 
       "3.3694983329896155`", ",", "1.738131191717227`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "50.`", ",", "0.16642793976003453`", ",", "0.3077040582370109`", ",", 
       "1.6211586069204533`", ",", "1.1390123879084262`", ",", 
       "3.3652886366229957`", ",", "1.7358710175664385`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "51.`", ",", "0.16546068514869575`", ",", "0.30632979669655525`", ",", 
       "1.618523098175211`", ",", "1.137441047874681`", ",", 
       "3.3610813220481224`", ",", "1.7336124548831233`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "52.`", ",", "0.16449522940105496`", ",", "0.30495491218550935`", ",", 
       "1.6158892370304718`", ",", "1.1358701819350507`", ",", 
       "3.3568764759027725`", ",", "1.7313555514227899`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "53.`", ",", "0.16353157152215078`", ",", "0.3035794043397063`", ",", 
       "1.6132570214223203`", ",", "1.1342997874273961`", ",", 
       "3.3526739991383074`", ",", "1.7291002786218694`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "54.`", ",", "0.16256971052688302`", ",", "0.30220327279043163`", ",", 
       "1.6106264492941689`", ",", "1.1327298617790365`", ",", 
       "3.348473888277641`", ",", "1.7268466102912436`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "55.`", ",", "0.16160964543708103`", ",", "0.3008265171651624`", ",", 
       "1.6079975185865423`", ",", "1.1311604023959585`", ",", 
       "3.3442760858024574`", ",", "1.7245944836422795`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "56.`", ",", "0.16065137528122714`", ",", "0.29944913708834753`", ",", 
       "1.6053702272878814`", ",", "1.1295914067645665`", ",", 
       "3.3400806904354616`", ",", "1.7223439985927924`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "57.`", ",", "0.1596948990960047`", ",", "0.29807113218015124`", ",", 
       "1.6027445732639987`", ",", "1.1280228723684684`", ",", 
       "3.335887672673342`", ",", "1.7200950635031669`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "58.`", ",", "0.15874021592590384`", ",", "0.29669250205457387`", ",", 
       "1.6001205544438022`", ",", "1.1264547967107128`", ",", 
       "3.3316970246398023`", ",", "1.7178476392707673`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "59.`", ",", "0.15778732482108437`", ",", "0.29531324632502426`", ",", 
       "1.59749816873652`", ",", "1.1248871773109195`", ",", 
       "3.3275087306294453`", ",", "1.7156017387551252`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "60.`", ",", "0.156836224840962`", ",", "0.29393336459784913`", ",", 
       "1.5948774140321587`", ",", "1.123320011678871`", ",", 
       "3.3233227761587867`", ",", "1.713357375178266`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "61.`", ",", "0.15588691505153432`", ",", "0.29255285647707036`", ",", 
       "1.592258288271841`", ",", "1.1217532974383375`", ",", 
       "3.3191391461448867`", ",", "1.7111144864181216`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "62.`", ",", "0.1549393945262944`", ",", "0.2911717215603317`", ",", 
       "1.5896407893370335`", ",", "1.1201870322341296`", ",", 
       "3.314957825872654`", ",", "1.7088730883343806`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "63.`", ",", "0.1539936623466892`", ",", "0.2897899594437289`", ",", 
       "1.587024915075736`", ",", "1.118621213658101`", ",", 
       "3.310778866440551`", ",", "1.7066331781441884`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "64.`", ",", "0.15304971759951438`", ",", "0.28840756971743453`", ",", 
       "1.5844106633765496`", ",", "1.1170558393871866`", ",", 
       "3.306602247925212`", ",", "1.7043946778302927`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "65.`", ",", "0.15210755938089157`", ",", "0.2870245519679539`", ",", 
       "1.5817980321539211`", ",", "1.115490907146148`", ",", 
       "3.3024279005767583`", ",", "1.7021576263604037`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "66.`", ",", "0.15116718679254057`", ",", "0.28564090577688206`", ",", 
       "1.579187019270391`", ",", "1.1139264146053878`", ",", 
       "3.2982558702559697`", ",", "1.699922017225116`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "67.`", ",", "0.15022859894461238`", ",", "0.2842566307219951`", ",", 
       "1.5765776225713353`", ",", "1.1123623595087848`", ",", 
       "3.2940861306499643`", ",", "1.6976878666565913`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "68.`", ",", "0.14929179495349956`", ",", "0.28287172637579455`", ",", 
       "1.5739698399175774`", ",", "1.1107987396511212`", ",", 
       "3.2899186778569423`", ",", "1.69545510147588`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "69.`", ",", "0.14835677394383937`", ",", "0.28148619230703764`", ",", 
       "1.5713636691656825`", ",", "1.1092355527998783`", ",", 
       "3.2857535181218744`", ",", "1.6932236977376307`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "70.`", ",", "0.1474235350461641`", ",", "0.28010002808074735`", ",", 
       "1.5687591081471697`", ",", "1.1076727967641145`", ",", 
       "3.2815906322330735`", ",", "1.6909936680773185`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "71.`", ",", "0.14649207739847533`", ",", "0.27871323325575875`", ",", 
       "1.5661561547496967`", ",", "1.1061104693874761`", ",", 
       "3.277429997534364`", ",", "1.688765008791783`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "72.`", ",", "0.1455624001458281`", ",", "0.2773258073873415`", ",", 
       "1.5635548067695682`", ",", "1.104548568578658`", ",", 
       "3.2732716429782114`", ",", "1.6865376818305633`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "73.`", ",", "0.14463450244075968`", ",", "0.27593775002590054`", ",", 
       "1.560955062072972`", ",", "1.1029870922136489`", ",", 
       "3.269115555913135`", ",", "1.684311727192545`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "74.`", ",", "0.1437083834411555`", ",", "0.2745490607177022`", ",", 
       "1.5583569185053385`", ",", "1.1014260381898977`", ",", 
       "3.264961691937576`", ",", "1.6820871149064893`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "75.`", ",", "0.14278404231349778`", ",", "0.2731597390037485`", ",", 
       "1.5557603738806225`", ",", "1.0998654044853717`", ",", 
       "3.2608100940577778`", ",", "1.6798637803831271`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "76.`", ",", "0.1418614782310235`", ",", "0.27176978442030125`", ",", 
       "1.5531654260034202`", ",", "1.0983051890594187`", ",", 
       "3.2566607104281218`", ",", "1.6776417546076994`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "77.`", ",", "0.14094069037324386`", ",", "0.2703791964994615`", ",", 
       "1.550572072709071`", ",", "1.0967453898811803`", ",", 
       "3.2525135490732806`", ",", "1.6754210016604143`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "78.`", ",", "0.14002167792679449`", ",", "0.26898797476803893`", ",", 
       "1.5479803118355442`", ",", "1.0951860049947453`", ",", 
       "3.248368610285987`", ",", "1.6732015338437685`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "79.`", ",", "0.13910444008461928`", ",", "0.26759611874915684`", ",", 
       "1.5453901411567035`", ",", "1.0936270324593331`", ",", 
       "3.2442258926749843`", ",", "1.6709833245475432`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "80.`", ",", "0.13818897604723462`", ",", "0.26620362795894786`", ",", 
       "1.5428015585144916`", ",", "1.0920684703480277`", ",", 
       "3.240085360817192`", ",", "1.6687663495395804`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "81.`", ",", "0.13727528502179304`", ",", "0.26481050191036004`", ",", 
       "1.5402145617059195`", ",", "1.0905103167406078`", ",", 
       "3.235947025220552`", ",", "1.6665506092464315`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "82.`", ",", "0.13636336622151443`", ",", "0.26341674011100413`", ",", 
       "1.5376291485280817`", ",", "1.0889525697478104`", ",", 
       "3.231810892190701`", ",", "1.6643361132336172`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "83.`", ",", "0.13545321886647185`", ",", "0.2620223420636951`", ",", 
       "1.5350453168137073`", ",", "1.0873952275221064`", ",", 
       "3.227676967066704`", ",", "1.6621228662434833`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "84.`", ",", "0.13454484218456306`", ",", "0.26062730726557376`", ",", 
       "1.5324630643713357`", ",", "1.0858382882724011`", ",", 
       "3.2235452248787118`", ",", "1.6599108126831321`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "85.`", ",", "0.13363823540837005`", ",", "0.25923163521021886`", ",", 
       "1.5298823889691133`", ",", "1.084281750174378`", ",", 
       "3.219415647160745`", ",", "1.6576999482103496`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "86.`", ",", "0.13273339777814708`", ",", "0.25783532538487286`", ",", 
       "1.5273032883929336`", ",", "1.0827256114105273`", ",", 
       "3.21528818350784`", ",", "1.6554902454061786`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "87.`", ",", "0.1318303285407722`", ",", "0.25643837727183544`", ",", 
       "1.5247257604761155`", ",", "1.081169870265028`", ",", 
       "3.211162873339221`", ",", "1.6532817441342549`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "88.`", ",", "0.13092902694972017`", ",", "0.255040790348597`", ",", 
       "1.52215011624538`", ",", "1.0796145778361261`", ",", 
       "3.207039734227216`", ",", "1.6510744162582798`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "89.`", ",", "0.13002949226450808`", ",", "0.2536425640869925`", ",", 
       "1.5195756097367308`", ",", "1.0780595916454234`", ",", 
       "3.2029187242233257`", ",", "1.6488682478069727`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "90.`", ",", "0.12913172375123727`", ",", "0.25224369795500384`", ",", 
       "1.5170026149498952`", ",", "1.0765050084025427`", ",", 
       "3.198799830627113`", ",", "1.6466631956191857`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "91.`", ",", "0.12823572068274144`", ",", "0.25084419141409603`", ",", 
       "1.514431616810371`", ",", "1.074950897127964`", ",", 
       "3.1946830727947573`", ",", "1.6444592737426733`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "92.`", ",", "0.12734148233756196`", ",", "0.24944404392052044`", ",", 
       "1.5118618047841834`", ",", "1.0733970889445095`", ",", 
       "3.1905684472089333`", ",", "1.6422564744048398`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "93.`", ",", "0.12644900800133752`", ",", "0.24804325492593002`", ",", 
       "1.5092935125464475`", ",", "1.0718436739507957`", ",", 
       "3.1864559408229463`", ",", "1.6400547957629297`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "94.`", ",", "0.12555829696656748`", ",", "0.24664182387620318`", ",", 
       "1.5067271993157627`", ",", "1.070290722035385`", ",", 
       "3.182345543335991`", ",", "1.6378542243778693`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "95.`", ",", "0.1246693485302552`", ",", "0.24523975021080227`", ",", 
       "1.50416206021529`", ",", "1.0687380709551892`", ",", 
       "3.178237212560747`", ",", "1.6356547489873154`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "96.`", ",", "0.12378216199646279`", ",", "0.24383703336556015`", ",", 
       "1.5015987314203476`", ",", "1.0671858618058665`", ",", 
       "3.174130947097979`", ",", "1.6334563673582054`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "97.`", ",", "0.1228967366770483`", ",", "0.24243367277134498`", ",", 
       "1.499036634846213`", ",", "1.065633971487025`", ",", 
       "3.170026775704521`", ",", "1.6312590389715411`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "98.`", ",", "0.12201307188713383`", ",", "0.2410296678507307`", ",", 
       "1.496476417023079`", ",", "1.0640825292080238`", ",", 
       "3.165924668619524`", ",", "1.629062784279196`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "99.`", ",", "0.1211311669506764`", ",", "0.23962501802304986`", ",", 
       "1.4939174298475315`", ",", "1.062531399134565`", ",", 
       "3.161824629119189`", ",", "1.6268675806146482`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "100.`", ",", "0.1202510211962671`", ",", "0.23821972270163755`", ",", 
       "1.491360304430927`", ",", "1.0609807103827091`", ",", 
       "3.1577266621396216`", ",", "1.6246734254792352`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "101.`", ",", "0.1193726339594714`", ",", "0.23681378129331568`", ",", 
       "1.4888044024228333`", ",", "1.0594303323406296`", ",", 
       "3.1536307474058276`", ",", "1.622480300933752`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "102.`", ",", "0.11849600458110794`", ",", "0.23540719320097916`", ",", 
       "1.48625035603533`", ",", "1.0578803934465102`", ",", 
       "3.149536861809862`", ",", "1.6202882252168902`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "103.`", ",", "0.11762113240808532`", ",", "0.23399995781986074`", ",", 
       "1.4836975306031253`", ",", "1.0563307630388328`", ",", 
       "3.1454450336660056`", ",", "1.618097161118789`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "104.`", ",", "0.11674801679428944`", ",", "0.23259207454067277`", ",", 
       "1.4811465561779489`", ",", "1.0547815682757269`", ",", 
       "3.141355195031547`", ",", "1.6159071260391358`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "105.`", ",", "0.11587665709879819`", ",", "0.23118354274839692`", ",", 
       "1.478596799175709`", ",", "1.0532326797334963`", ",", 
       "3.137267386859046`", ",", "1.6137180759181016`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "106.`", ",", "0.1150070526859988`", ",", "0.22977436182202554`", ",", 
       "1.4760488875611828`", ",", "1.0516842237237884`", ",", 
       "3.1331815839432666`", ",", "1.6115300294202115`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "107.`", ",", "0.11413920292799203`", ",", "0.22836453113492064`", ",", 
       "1.4735021899288567`", ",", "1.050136071901496`", ",", 
       "3.1290978031949606`", ",", "1.6093429711749652`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "108.`", ",", "0.11327310720055356`", ",", "0.22695405005372846`", ",", 
       "1.4709573322104725`", ",", "1.0485883495973407`", ",", 
       "3.1250160221528525`", ",", "1.6071568907094533`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "109.`", ",", "0.11240876488770961`", ",", "0.2255429179406303`", ",", 
       "1.4684136850645984`", ",", "1.047040929493186`", ",", 
       "3.1209362306922634`", ",", "1.6049717696129076`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "110.`", ",", "0.11154617537729573`", ",", "0.22413113415073949`", ",", 
       "1.4658718724594852`", ",", "1.045493936003232`", ",", 
       "3.1168583980584055`", ",", "1.6027876305701094`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "111.`", ",", "0.11068533806380115`", ",", "0.22271869803393088`", ",", 
       "1.4633312669731813`", ",", "1.0439472427750232`", ",", 
       "3.112782557883379`", ",", "1.6006044473307344`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "112.`", ",", "0.10982625234648481`", ",", "0.22130560893307794`", ",", 
       "1.4607924905852325`", ",", "1.0424009734066804`", ",", 
       "3.1087086752621915`", ",", "1.5984222068883822`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "113.`", ",", "0.10896891763192092`", ",", "0.21989186618628617`", ",", 
       "1.4582549178936686`", ",", "1.040855002380779`", ",", 
       "3.104636750244103`", ",", "1.5962408914434054`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "114.`", ",", "0.10811333333144835`", ",", "0.21847746912495164`", ",", 
       "1.4557191688955682`", ",", "1.03930945253306`", ",", 
       "3.1005667732603692`", ",", "1.594060497375831`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "115.`", ",", "0.10725949886140604`", ",", "0.21706241707424845`", ",", 
       "1.4531848523591808`", ",", "1.0377642338419617`", ",", 
       "3.0964987449519774`", ",", "1.5918810429730332`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "116.`", ",", "0.10640741364489906`", ",", "0.2156467093530803`", ",", 
       "1.4506517342705454`", ",", "1.0362193271191007`", ",", 
       "3.092432661617314`", ",", "1.5897025139473826`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "117.`", ",", "0.10555707711048996`", ",", "0.2142303452742902`", ",", 
       "1.4481204972914172`", ",", "1.0346748542046567`", ",", 
       "3.0883685141671626`", ",", "1.5875249140693548`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "118.`", ",", "0.10470848869113714`", ",", "0.21281332414579643`", ",", 
       "1.4455907082027142`", ",", "1.033130706390983`", ",", 
       "3.0843062787490485`", ",", "1.5853482181364855`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "119.`", ",", "0.10386164782665686`", ",", "0.21139564526684063`", ",", 
       "1.4430623388952708`", ",", "1.0315869018593329`", ",", 
       "3.0802459518338536`", ",", "1.583172414263427`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "120.`", ",", "0.10301655396072318`", ",", "0.20997730793231942`", ",", 
       "1.4405354524138476`", ",", "1.030043454459644`", ",", 
       "3.076187541405393`", ",", "1.5809974804755054`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "121.`", ",", "0.10217320654408443`", ",", "0.20855831142939507`", ",", 
       "1.438010071460941`", ",", "1.028500360968271`", ",", 
       "3.072131020048065`", ",", "1.5788234293471808`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "122.`", ",", "0.10133160503169322`", ",", "0.20713865503974419`", ",", 
       "1.4354861909950443`", ",", "1.0269576178481103`", ",", 
       "3.0680763990797604`", ",", "1.576650266554413`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "123.`", ",", "0.10049174888421955`", ",", "0.20571833803900144`", ",", 
       "1.432963803850053`", ",", "1.025415224449976`", ",", 
       "3.064023672391216`", ",", "1.5744779841264294`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "124.`", ",", "0.09965363756813317`", ",", "0.20429735969438004`", ",", 
       "1.4304429068231066`", ",", "1.0238731805343628`", ",", 
       "3.0599728180062304`", ",", "1.5723065693057257`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "125.`", ",", "0.09881727055463584`", ",", "0.202875719269369`", ",", 
       "1.4279234982370392`", ",", "1.0223314853404175`", ",", 
       "3.0559238447786683`", ",", "1.5701360035948464`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "126.`", ",", "0.09798264732028183`", ",", "0.2014534160182063`", ",", 
       "1.425405576201084`", ",", "1.020790137942783`", ",", 
       "3.0518767234994293`", ",", "1.5679662766642426`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "127.`", ",", "0.09714976734606191`", ",", "0.20003044919197602`", ",", 
       "1.4228891385511515`", ",", "1.019249137419339`", ",", 
       "3.0478314536592475`", ",", "1.5657973854453027`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "128.`", ",", "0.0963186301191748`", ",", "0.19860681803134725`", ",", 
       "1.4203741830547578`", ",", "1.0177084829735648`", ",", 
       "3.0437880375000788`", ",", "1.5636293407312873`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "129.`", ",", "0.09548923513219292`", ",", "0.19718252177236212`", ",", 
       "1.41786070752957`", ",", "1.0161681738761519`", ",", 
       "3.039746474397108`", ",", "1.5614621477459585`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "130.`", ",", "0.09466158188230729`", ",", "0.1957575596445641`", ",", 
       "1.4153488367771023`", ",", "1.014628219742569`", ",", 
       "3.0357067440969008`", ",", "1.5592957870350532`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "131.`", ",", "0.09383566987009571`", ",", "0.19433193086936454`", ",", 
       "1.4128382276743099`", ",", "1.0130885856064782`", ",", 
       "3.031668836201277`", ",", "1.5571302363489319`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "132.`", ",", "0.09301149860360367`", ",", "0.19290563466215188`", ",", 
       "1.4103293298691524`", ",", "1.011549321831584`", ",", 
       "3.0276327571681056`", ",", "1.5549654982815009`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "133.`", ",", "0.09218906759501945`", ",", "0.19147867023320972`", ",", 
       "1.4078216152993117`", ",", "1.0100103713418787`", ",", 
       "3.0235984903148165`", ",", "1.5528015694451578`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "134.`", ",", "0.09136837636082452`", ",", "0.19005103678378807`", ",", 
       "1.4053157066312856`", ",", "1.0084717864671413`", ",", 
       "3.019566023093627`", ",", "1.550638455795716`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "135.`", ",", "0.09054942442310722`", ",", "0.18862273350762093`", ",", 
       "1.4028107093351367`", ",", "1.0069334853434053`", ",", 
       "3.0155353582583015`", ",", "1.5484761389262496`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "136.`", ",", "0.08973221130864967`", ",", "0.18719375959417414`", ",", 
       "1.4003078974123702`", ",", "1.0053956194436366`", ",", 
       "3.0115064866536394`", ",", "1.5463146091062527`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "137.`", ",", "0.0889167365492122`", ",", "0.18576411422502753`", ",", 
       "1.3978058710633467`", ",", "1.0038580066850973`", ",", 
       "3.0074793966400457`", ",", "1.5441538791797893`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "138.`", ",", "0.08810299968033365`", ",", "0.18433379657256332`", ",", 
       "1.`", ",", "0.`", ",", "3.0034540805800614`", ",", 
       "1.5419939243963252`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "139.`", ",", "0.08729100024328272`", ",", "0.18290280580571697`", ",", 
       "1.295366022458477`", ",", 
       RowBox[{"-", "0.00021608380394078574`"}], ",", "2.9994305411374773`", 
       ",", "1.5398347424202046`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "140.`", ",", "0.08648073778351502`", ",", "0.18147114108373566`", ",", 
       "1.5209504794926427`", ",", "1.032828481675987`*^-6", ",", 
       "2.995408767157927`", ",", "1.5376763375568183`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "141.`", ",", "0.08567221185222494`", ",", "0.18003880155949875`", ",", 
       "1.7697780144809327`", ",", "0.00006525441043529329`", ",", 
       "2.9913887803519734`", ",", "1.5355187136366222`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "142.`", ",", "0.0848654220038029`", ",", "0.17860578637887528`", ",", 
       "1.9466607035111558`", ",", "1.993528777271531`*^-6", ",", 
       "2.9873705229871907`", ",", "1.533361858365862`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "143.`", ",", "0.08406036779777917`", ",", "0.17717209468018094`", ",", 
       "1.9466100571812983`", ",", "1.8853764832352504`*^-6", ",", 
       "2.9833540030152967`", ",", "1.5312057577705263`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "144.`", ",", "0.08325704879754958`", ",", "0.17573772559505166`", ",", 
       "1.9465199060328326`", ",", "1.8856505462150767`*^-6", ",", 
       "2.9793392217118275`", ",", "1.5290503985851385`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "145.`", ",", "0.08245546457196`", ",", "0.17430267824752563`", ",", 
       "1.946429477185791`", ",", "1.942932534347336`*^-6", ",", 
       "2.975326169161975`", ",", "1.5268957895557587`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "146.`", ",", "0.08165561469502772`", ",", "0.17286695175441863`", ",", 
       "1.9463584076365565`", ",", "2.001815700408596`*^-6", ",", 
       "2.971314838765779`", ",", "1.5247419341307071`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "147.`", ",", "0.08085749874190887`", ",", "0.17143054522510387`", ",", 
       "1.9463068286120393`", ",", "2.0323288526247953`*^-6", ",", 
       "2.9673052275520124`", ",", "1.5225888209419138`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "148.`", ",", "0.08006111629604512`", ",", "0.1699934577618344`", ",", 
       "1.9462650492160338`", ",", "2.0322121366862294`*^-6", ",", 
       "2.963297333672724`", ",", "1.5204364491349276`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "149.`", ",", "0.0792664669425416`", ",", "0.16855568845828`", ",", 
       "1.94622329031768`", ",", "2.016048481903217`*^-6", ",", 
       "2.959291139077566`", ",", "1.5182848055039415`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "150.`", ",", "0.0784735502728461`", ",", "0.16711723640274131`", ",", 
       "1.9461766216437955`", ",", "1.999457544813037`*^-6", ",", 
       "2.9552866437806036`", ",", "1.5161338918261298`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "151.`", ",", "0.07768236587991607`", ",", "0.1656781006742316`", ",", 
       "1.9461250091684323`", ",", "1.9909679960790363`*^-6", ",", 
       "2.951283835505345`", ",", "1.5139836935222004`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "152.`", ",", "0.07689291336316682`", ",", "0.16423828034484997`", ",", 
       "1.9460708836702816`", ",", "1.9910076032216798`*^-6", ",", 
       "2.9472827094809326`", ",", "1.5118342187934688`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "153.`", ",", "0.0761051923254933`", ",", "0.1627977744783216`", ",", 
       "1.9460166917432895`", ",", "1.995507801851516`*^-6", ",", 
       "2.9432832537637643`", ",", "1.509685470178997`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "154.`", ",", "0.07531920237382722`", ",", "0.16135658213300896`", ",", 
       "1.9459636646018794`", ",", "2.0000984194651134`*^-6", ",", 
       "2.9392854765464174`", ",", "1.5075374350288424`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "155.`", ",", "0.07453494311835626`", ",", "0.1599147023569293`", ",", 
       "1.945911810741559`", ",", "2.0024429096733`*^-6", ",", 
       "2.9352893597821734`", ",", "1.5053900965972824`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "156.`", ",", "0.07375241417549713`", ",", "0.15847213419175513`", ",", 
       "1.9458605230094126`", ",", "2.002444846198756`*^-6", ",", 
       "2.931294911920526`", ",", "1.5032434653051414`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "157.`", ",", "0.07297161516299377`", ",", "0.1570288766716088`", ",", 
       "1.945809189861338`", ",", "2.001221473459399`*^-6", ",", 
       "2.9273021089338744`", ",", "1.5010975318690039`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "158.`", ",", "0.072192545703739`", ",", "0.15558492882232802`", ",", 
       "1.9457575034438812`", ",", "1.9999701816641014`*^-6", ",", 
       "2.9233109557228274`", ",", "1.4989522981188421`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "159.`", ",", "0.0714152054251219`", ",", "0.15414028966068322`", ",", 
       "1.9457054616441627`", ",", "1.99933331392544`*^-6", ",", 
       "2.919321430259205`", ",", "1.4968077648476552`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "160.`", ",", "0.07063959395759943`", ",", "0.1526949581985689`", ",", 
       "1.9456532163442146`", ",", "1.9993355077883533`*^-6", ",", 
       "2.9153335271892393`", ",", "1.4946639230296677`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "161.`", ",", "0.0698657109350405`", ",", "0.15124893343738516`", ",", 
       "1.945600920458025`", ",", "1.9996625959692704`*^-6", ",", 
       "2.911347256098432`", ",", "1.4925207669748901`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "162.`", ",", "0.06909355599539409`", ",", "0.14980221437158697`", ",", 
       "1.9455486509722937`", ",", "2.000001398404918`*^-6", ",", 
       "2.9073626056729727`", ",", "1.4903782872421487`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "163.`", ",", "0.06832312878024269`", ",", "0.14835479998726284`", ",", 
       "1.9454964084371231`", ",", "2.0001822710596075`*^-6", ",", 
       "2.903379576935094`", ",", "1.4882364883481727`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "164.`", ",", "0.06755442893634352`", ",", "0.1469066892633567`", ",", 
       "1.945444154931423`", ",", "2.0001869850804805`*^-6", ",", 
       "2.8993981506055007`", ",", "1.4860953743049776`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "165.`", ",", "0.06678745611190458`", ",", "0.14545788116973773`", ",", 
       "1.9453918522492801`", ",", "2.000098968936218`*^-6", ",", 
       "2.8954183283165005`", ",", "1.4839549331644186`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "166.`", ",", "0.06602220995907983`", ",", "0.14400837466873684`", ",", 
       "1.9453394811605031`", ",", "2.00000382543107`*^-6", ",", 
       "2.8914400873396247`", ",", "1.481815160229573`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "167.`", ",", "0.06525869013389356`", ",", "0.1425581687132728`", ",", 
       "1.945287041557754`", ",", "1.9999568383744197`*^-6", ",", 
       "2.887463437313885`", ",", "1.4796760587149693`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "168.`", ",", "0.06449689629646853`", ",", "0.1411072622508126`", ",", 
       "1.9452345429684024`", ",", "1.9999467423800803`*^-6", ",", 
       "2.8834883718024433`", ",", "1.4775376181872415`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "169.`", ",", "0.06373682810963222`", ",", "0.13965565421716272`", ",", 
       "1.9451819949574993`", ",", "1.999969387647748`*^-6", ",", 
       "2.8795148741496126`", ",", "1.4753998442878833`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "170.`", ",", "0.06297848523917397`", ",", "0.1382033435421425`", ",", 
       "1.9451294023771906`", ",", "1.999996919566301`*^-6", ",", 
       "2.875542951428476`", ",", "1.473262737288458`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "171.`", ",", "0.06222186735419751`", ",", "0.13675032914655363`", ",", 
       "1.945076765271839`", ",", "2.000010825985557`*^-6", ",", 
       "2.8715725946276778`", ",", "1.4711262819312931`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "172.`", ",", "0.06146697412886147`", ",", "0.1352966099437336`", ",", 
       "1.9450240812820585`", ",", "2.0000045713360583`*^-6", ",", 
       "2.867603791262976`", ",", "1.468990479718156`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "173.`", ",", "0.06071380523822643`", ",", "0.13384218483694393`", ",", 
       "1.9449713480335573`", ",", "1.9999930539728788`*^-6", ",", 
       "2.8636365369268475`", ",", "1.466855325435055`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "174.`", ",", "0.05996236036147152`", ",", "0.1323870527221787`", ",", 
       "1.9449185643759481`", ",", "1.999987990737246`*^-6", ",", 
       "2.859670824728429`", ",", "1.464720813938977`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "175.`", ",", "0.059212639181358925`", ",", "0.13093121248612694`", ",",
        "1.9448657302991506`", ",", "1.9999867422953306`*^-6", ",", 
       "2.8557066637366133`", ",", "1.4625869456373115`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "176.`", ",", "0.05846464138296353`", ",", "0.1294746630074854`", ",", 
       "1.9448128464360834`", ",", "1.9999866562894085`*^-6", ",", 
       "2.8517440306470982`", ",", "1.4604537309523504`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "177.`", ",", "0.057718366653999716`", ",", "0.12801740315752747`", ",",
        "1.9447599134027622`", ",", "1.99998434134998`*^-6", ",", 
       "2.8477829240271695`", ",", "1.458321159043973`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "178.`", ",", "0.05697381468650987`", ",", "0.1265594317970435`", ",", 
       "1.9447069315434427`", ",", "1.9999866441973627`*^-6", ",", 
       "2.843823334603758`", ",", "1.4561892262485296`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "179.`", ",", "0.05623098517392645`", ",", "0.12510074777843913`", ",", 
       "1.944653900875411`", ",", "1.9999862389213768`*^-6", ",", 
       "2.8398652564902873`", ",", "1.454057922287901`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "180.`", ",", "0.05548987781395094`", ",", "0.12364134994646728`", ",", 
       "1.944600821253959`", ",", "1.999992208108941`*^-6", ",", 
       "2.8359086907562476`", ",", "1.4519272615911323`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "181.`", ",", "0.05475049230593718`", ",", "0.12218123713616705`", ",", 
       "1.9445476925302883`", ",", "1.9999930115997074`*^-6", ",", 
       "2.83195362798713`", ",", "1.449797231557912`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "182.`", ",", "0.05401282835236855`", ",", "0.12072040817419083`", ",", 
       "1.9444945146670323`", ",", "1.9999894281078016`*^-6", ",", 
       "2.828000073749635`", ",", "1.4476678288158071`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "183.`", ",", "0.05327688565854318`", ",", "0.11925886187845294`", ",", 
       "1.9444412877134227`", ",", "1.9999922324096803`*^-6", ",", 
       "2.8240480090229347`", ",", "1.4455390543372462`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "184.`", ",", "0.052542663932916706`", ",", "0.11779659705813882`", ",",
        "1.944388011724334`", ",", "1.9999952317049407`*^-6", ",", 
       "2.820097431545554`", ",", "1.4434109052119362`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "185.`", ",", "0.051810162884593114`", ",", "0.11633361251278385`", ",",
        "1.9443346867472044`", ",", "1.9999970360484784`*^-6", ",", 
       "2.816148333530931`", ",", "1.4412833797801394`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "186.`", ",", "0.051079382227650294`", ",", "0.11486990703353978`", ",",
        "1.9442813128390204`", ",", "2.000003101148714`*^-6", ",", 
       "2.812200705586291`", ",", "1.439156479457959`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "187.`", ",", "0.05035032167662294`", ",", "0.11340547940397866`", ",", 
       "1.9442278900030203`", ",", "1.999999883933031`*^-6", ",", 
       "2.808254552538815`", ",", "1.4370301971605752`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "188.`", ",", "0.049622980949555945`", ",", "0.11194032839569643`", ",",
        "1.9441744182519118`", ",", "1.9999932340733955`*^-6", ",", 
       "2.804309860301682`", ",", "1.4349045328610193`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "189.`", ",", "0.04889735976594237`", ",", "0.11047445277325657`", ",", 
       "1.9441208976142637`", ",", "1.999994626157809`*^-6", ",", 
       "2.800366632199624`", ",", "1.432779487056792`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "190.`", ",", "0.048173457850224546`", ",", "0.10900785129097654`", ",",
        "1.9440673280972185`", ",", "1.9999944358825123`*^-6", ",", 
       "2.7964248595623373`", ",", "1.4306550551492008`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "191.`", ",", "0.047451274925536864`", ",", "0.10754052269573748`", ",",
        "1.9440137096966903`", ",", "1.9999962288159525`*^-6", ",", 
       "2.7924845324250653`", ",", "1.428531232476355`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "192.`", ",", "0.04673081071844926`", ",", "0.10607246572387467`", ",", 
       "1.9439600424771641`", ",", "1.999999472743403`*^-6", ",", 
       "2.788545642800159`", ",", "1.4264080238253167`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "193.`", ",", "0.046012064958077074`", ",", "0.10460367910195684`", ",",
        "1.9439063264460668`", ",", "2.000004062372748`*^-6", ",", 
       "2.784608193251562`", ",", "1.424285423336344`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "194.`", ",", "0.04529503737556441`", ",", "0.10313416154917897`", ",", 
       "1.9438525616535158`", ",", "1.999997638377911`*^-6", ",", 
       "2.7806721746960417`", ",", "1.4221634325711952`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "195.`", ",", "0.044579727704699305`", ",", "0.10166391177412583`", ",",
        "1.9437987480949053`", ",", "1.9999955511573274`*^-6", ",", 
       "2.7767375905587315`", ",", "1.4200420515597745`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "196.`", ",", "0.04386613567900669`", ",", "0.10019292847626414`", ",", 
       "1.943744885784467`", ",", "1.9999858274017124`*^-6", ",", 
       "2.7728044264140324`", ",", "1.4179212749099404`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "197.`", ",", "0.04315426103640865`", ",", "0.09872121034521887`", ",", 
       "1.9436909747428572`", ",", "1.999976930230095`*^-6", ",", 
       "2.768872673459991`", ",", "1.4158011005073203`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "198.`", ",", "0.04244410351495193`", ",", "0.09724875606204567`", ",", 
       "1.9436370150098712`", ",", "1.9999833561366367`*^-6", ",", 
       "2.764942327178093`", ",", "1.4136815317331817`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "199.`", ",", "0.04173566285497863`", ",", "0.09577556429826423`", ",", 
       "1.9435830066037312`", ",", "1.9999961447200575`*^-6", ",", 
       "2.761013395174928`", ",", "1.4115625618167498`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "200.`", ",", "0.041028938799076604`", ",", "0.09430163371467787`", ",",
        "1.9435289495258468`", ",", "2.0000012214219897`*^-6", ",", 
       "2.7570858626448933`", ",", "1.4094441911510838`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "201.`", ",", "0.04032393109112225`", ",", "0.09282696296425583`", ",", 
       "1.9434748438255993`", ",", "1.999996757791173`*^-6", ",", 
       "2.753159727419363`", ",", "1.4073264211825474`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "202.`", ",", "0.03962063947560394`", ",", "0.0913515506890524`", ",", 
       "1.9434206895247286`", ",", "1.9999933437535294`*^-6", ",", 
       "2.749234982527333`", ",", "1.405209247523387`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "203.`", ",", "0.038919063699944786`", ",", "0.08987539552196407`", ",",
        "1.9433664866241782`", ",", "1.9999882349176736`*^-6", ",", 
       "2.7453116210005333`", ",", "1.4030926683473433`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "204.`", ",", "0.03821920351169119`", ",", "0.0883984960858908`", ",", 
       "1.9433122351571719`", ",", "1.9999857053635724`*^-6", ",", 
       "2.7413896368454798`", ",", "1.4009766829890327`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "205.`", ",", "0.03752105866156568`", ",", "0.0869208509949371`", ",", 
       "1.9432579351289476`", ",", "1.9999940099020648`*^-6", ",", 
       "2.7374690297652826`", ",", "1.3988612996491718`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "206.`", ",", "0.036824628899719984`", ",", "0.08544245885311756`", ",",
        "1.9432035865784378`", ",", "2.000006318605683`*^-6", ",", 
       "2.7335497964631355`", ",", "1.3967465060468423`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "207.`", ",", "0.03612991397857814`", ",", "0.08396331825348598`", ",", 
       "1.9431491895161372`", ",", "2.0000046797762083`*^-6", ",", 
       "2.7296319346079945`", ",", "1.394632303596775`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "208.`", ",", "0.035436913651563144`", ",", "0.08248342777988439`", ",",
        "1.9430947439738926`", ",", "2.0000057604967133`*^-6", ",", 
       "2.725715431392257`", ",", "1.3925186911621015`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "209.`", ",", "0.03474562767281616`", ",", "0.08100278600832841`", ",", 
       "1.9430402499783084`", ",", "2.0000036162718623`*^-6", ",", 
       "2.721800286354616`", ",", "1.3904056710626471`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "210.`", ",", "0.03405605579875855`", ",", "0.07952139150113538`", ",", 
       "1.9429857075326569`", ",", "2.000006794157178`*^-6", ",", 
       "2.717886476348138`", ",", "1.3882932408953557`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "211.`", ",", "0.03336819778478124`", ",", "0.07803924281358644`", ",", 
       "1.9429311166804353`", ",", "2.0000014927115308`*^-6", ",", 
       "2.7139740163584727`", ",", "1.3861813984362947`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "212.`", ",", "0.03268205338888017`", ",", "0.07655633849043944`", ",", 
       "1.942876477415388`", ",", "2.00000656691729`*^-6", ",", 
       "2.7100628997677263`", ",", "1.384070146320744`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "213.`", ",", "0.031997622370172625`", ",", "0.07507267706493329`", ",",
        "1.942821789747521`", ",", "1.999997009558577`*^-6", ",", 
       "2.706153127950332`", ",", "1.3819594808593298`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "214.`", ",", "0.03131490448650767`", ",", "0.07358825706201984`", ",", 
       "1.9427670537114967`", ",", "1.9999844762917566`*^-6", ",", 
       "2.7022446900153696`", ",", "1.3798494027391046`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "215.`", ",", "0.030633899498537825`", ",", "0.07210307699565822`", ",",
        "1.942712269364619`", ",", "1.999987367660298`*^-6", ",", 
       "2.6983375783323855`", ",", "1.3777399075614585`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "216.`", ",", "0.029954607166791995`", ",", "0.07061713536904994`", ",",
        "1.94265743673098`", ",", "2.0000004443954448`*^-6", ",", 
       "2.6944317887276203`", ",", "1.3756309988557196`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "217.`", ",", "0.029277027251601306`", ",", "0.06913043067623213`", ",",
        "1.9426025557798905`", ",", "2.000010895284778`*^-6", ",", 
       "2.690527318074838`", ",", "1.3735226761558081`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "218.`", ",", "0.02860115951456221`", ",", "0.06764296140236178`", ",", 
       "1.942547626541504`", ",", "2.0000076034590864`*^-6", ",", 
       "2.6866241629263032`", ",", "1.371414934959108`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "219.`", ",", "0.027927003718414785`", ",", "0.06615472601872543`", ",",
        "1.9424926490458418`", ",", "1.999998434374389`*^-6", ",", 
       "2.6827223145189203`", ",", "1.3693077763847605`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "220.`", ",", "0.027254559625200788`", ",", "0.06466572298880456`", ",",
        "1.9424376232928726`", ",", "1.9999951206463755`*^-6", ",", 
       "2.6788217722272654`", ",", "1.3672011971862157`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "221.`", ",", "0.0265838269968881`", ",", "0.06317595076559238`", ",", 
       "1.9423825493353912`", ",", "1.999990296004855`*^-6", ",", 
       "2.6749225309531535`", ",", "1.3650952012167756`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "222.`", ",", "0.02591480559740197`", ",", "0.06168540779078606`", ",", 
       "1.942327427199411`", ",", "1.9999884580506388`*^-6", ",", 
       "2.671024581723892`", ",", "1.3629897926637804`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "223.`", ",", "0.02524749518913959`", ",", "0.06019409249616167`", ",", 
       "1.9422722569060946`", ",", "1.9999922392786673`*^-6", ",", 
       "2.6671279265018377`", ",", "1.3608849680810544`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "224.`", ",", "0.02458189553584719`", ",", "0.05870200330305717`", ",", 
       "1.9422170384233257`", ",", "1.999999547828667`*^-6", ",", 
       "2.663232559612108`", ",", "1.3587807228500728`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "225.`", ",", "0.02391800639925819`", ",", "0.057209138622492606`", ",",
        "1.942161771825235`", ",", "2.0000008935019078`*^-6", ",", 
       "2.6593384796969293`", ",", "1.3566770558236645`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "226.`", ",", "0.023255827543583848`", ",", "0.055715496854533524`", 
       ",", "1.9421064571025979`", ",", "1.999992342268687`*^-6", ",", 
       "2.655445678152651`", ",", "1.3545739709687123`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "227.`", ",", "0.022595358731128314`", ",", "0.05422107638892074`", ",",
        "1.9420510942941553`", ",", "1.999978842824453`*^-6", ",", 
       "2.6515541446686894`", ",", "1.3524714638523632`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "228.`", ",", "0.02193659972419106`", ",", "0.052725875604943476`", ",",
        "1.9419956834396712`", ",", "1.999979230790422`*^-6", ",", 
       "2.6476638822243403`", ",", "1.3503695407663212`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "229.`", ",", "0.0212795502860355`", ",", "0.05122989287091528`", ",", 
       "1.9419402245223691`", ",", "1.9999922158792436`*^-6", ",", 
       "2.6437748931472767`", ",", "1.348268197133727`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "230.`", ",", "0.020624210178989466`", ",", "0.04973312654360848`", ",",
        "1.941884717557774`", ",", "2.0000106970612384`*^-6", ",", 
       "2.639887162874433`", ",", "1.3461674333838052`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "231.`", ",", "0.019970579163692055`", ",", "0.04823557497150842`", ",",
        "1.9418291625679733`", ",", "2.0000135928113132`*^-6", ",", 
       "2.6360006898867363`", ",", "1.3440672461015057`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "232.`", ",", "0.01931865700125873`", ",", "0.04673723649009638`", ",", 
       "1.9417735595824797`", ",", "2.0000004055083765`*^-6", ",", 
       "2.632115473982845`", ",", "1.3419676378233172`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "233.`", ",", "0.018668443452327294`", ",", "0.04523810942491258`", ",",
        "1.94171790862012`", ",", "1.999984204635081`*^-6", ",", 
       "2.6282315068365163`", ",", "1.339868610888083`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "234.`", ",", "0.018019938276894718`", ",", "0.04373819209035869`", ",",
        "1.9416622097202123`", ",", "1.999972386592075`*^-6", ",", 
       "2.6243487835551327`", ",", "1.337770162785051`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "235.`", ",", "0.017373141234844063`", ",", "0.04223748279138489`", ",",
        "1.9416064628994765`", ",", "1.9999692668414756`*^-6", ",", 
       "2.6204673007200143`", ",", "1.3356722954261506`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "236.`", ",", "0.016728052082621545`", ",", "0.040735979820493734`", 
       ",", "1.941550668148003`", ",", "1.999973486167045`*^-6", ",", 
       "2.616587056567595`", ",", "1.3335750057786273`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "237.`", ",", "0.016084670580746415`", ",", "0.03923368145947004`", ",",
        "1.9414948254951425`", ",", "1.9999836557501163`*^-6", ",", 
       "2.6127080484927463`", ",", "1.331478293328947`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "238.`", ",", "0.015442996482919117`", ",", "0.03773058597841592`", ",",
        "1.941438934967499`", ",", "1.999982149670835`*^-6", ",", 
       "2.6088302724177415`", ",", "1.3293821629021956`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "239.`", ",", "0.01480302954601181`", ",", "0.03622669164034429`", ",", 
       "1.941382996591109`", ",", "1.9999836484094438`*^-6", ",", 
       "2.6049537205732185`", ",", "1.3272866143720152`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "240.`", ",", "0.014164769525367302`", ",", "0.03472199669264367`", ",",
        "1.9413270103881008`", ",", "1.999982885926129`*^-6", ",", 
       "2.601078390010197`", ",", "1.3251916465426525`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "241.`", ",", "0.013528216174462086`", ",", "0.033216499373927365`", 
       ",", "1.9412709763478608`", ",", "1.999976535915363`*^-6", ",", 
       "2.5972042763466874`", ",", "1.3230972573470807`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "242.`", ",", "0.01289336924690332`", ",", "0.031710197912707176`", ",",
        "1.9412148945095165`", ",", "1.9999828982667577`*^-6", ",", 
       "2.593331380603517`", ",", "1.3210034430594368`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "243.`", ",", "0.012260228493946283`", ",", "0.030203090521687105`", 
       ",", "1.9411587649016766`", ",", "1.9999829521687344`*^-6", ",", 
       "2.5894596990254395`", ",", "1.3189102087043394`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "244.`", ",", "0.01162879366592816`", ",", "0.028695175411387587`", ",",
        "1.9411025875297754`", ",", "1.9999967188953097`*^-6", ",", 
       "2.5855892242282366`", ",", "1.3168175539316802`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "245.`", ",", "0.01099906451301185`", ",", "0.027186450774323707`", ",",
        "1.9410463624276522`", ",", "1.999994633027985`*^-6", ",", 
       "2.581719948552782`", ",", "1.3147254835910844`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "246.`", ",", "0.01037104078535783`", ",", "0.025676914793658325`", ",",
        "1.9409900896073509`", ",", "1.9999954005097247`*^-6", ",", 
       "2.5778518732179276`", ",", "1.3126339920441712`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "247.`", ",", "0.00974472223239464`", ",", "0.024166565641842653`", ",",
        "1.9409337691042758`", ",", "1.9999910603697867`*^-6", ",", 
       "2.5739849961287704`", ",", "1.3105430805326637`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "248.`", ",", "0.00912010860181184`", ",", "0.022655401482071708`", ",",
        "1.9408774009116239`", ",", "1.999992443815188`*^-6", ",", 
       "2.5701193117831442`", ",", "1.3084527509671493`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "249.`", ",", "0.008497199644287018`", ",", "0.021143420465401356`", 
       ",", "1.9408209850126343`", ",", "1.999987389839111`*^-6", ",", 
       "2.5662548148044992`", ",", "1.306363005007907`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "250.`", ",", "0.007875995109529`", ",", "0.019630620734472342`", ",", 
       "1.9407645214712534`", ",", "1.999990793923864`*^-6", ",", 
       "2.5623915070464984`", ",", "1.3042738423071136`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "251.`", ",", "0.007256494754111129`", ",", "0.018117000417687705`", 
       ",", "1.9407080103151317`", ",", "1.999988847173941`*^-6", ",", 
       "2.5585293810403837`", ",", "1.302185260633053`"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.54748373167715*^9, 3.547483743742975*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"qarr", "=", 
    RowBox[{"{", 
     RowBox[{
     "1.35`", ",", "1.352`", ",", "1.354`", ",", "1.356`", ",", "1.358`", ",",
       "1.36`", ",", "1.362`", ",", "1.364`", ",", "1.366`", ",", "1.368`", 
      ",", "1.37`", ",", "1.372`", ",", "1.374`", ",", "1.3760000000000001`", 
      ",", "1.3780000000000001`", ",", "1.3800000000000001`", ",", 
      "1.3820000000000001`", ",", "1.3840000000000001`", ",", 
      "1.3860000000000001`", ",", "1.3880000000000001`", ",", 
      "1.3900000000000001`", ",", "1.3920000000000001`", ",", 
      "1.3940000000000001`", ",", "1.3960000000000001`", ",", 
      "1.3980000000000001`", ",", "1.4000000000000001`", ",", 
      "1.4020000000000001`", ",", "1.4040000000000001`", ",", 
      "1.4060000000000001`", ",", "1.4080000000000001`", ",", 
      "1.4100000000000001`", ",", "1.4120000000000001`", ",", 
      "1.4140000000000001`", ",", "1.4160000000000001`", ",", 
      "1.4180000000000001`", ",", "1.4200000000000002`", ",", 
      "1.4220000000000002`", ",", "1.4240000000000002`", ",", 
      "1.4260000000000002`", ",", "1.4280000000000002`", ",", 
      "1.4300000000000002`", ",", "1.4320000000000002`", ",", 
      "1.4340000000000002`", ",", "1.4360000000000002`", ",", 
      "1.4380000000000002`", ",", "1.4400000000000002`", ",", 
      "1.4420000000000002`", ",", "1.4440000000000002`", ",", 
      "1.4460000000000002`", ",", "1.4480000000000002`", ",", 
      "1.4500000000000002`", ",", "1.4520000000000002`", ",", 
      "1.4540000000000002`", ",", "1.4560000000000002`", ",", 
      "1.4580000000000002`", ",", "1.4600000000000002`", ",", 
      "1.4620000000000002`", ",", "1.4640000000000002`", ",", 
      "1.4660000000000002`", ",", "1.4680000000000002`", ",", 
      "1.4700000000000002`", ",", "1.472`", ",", "1.4740000000000002`", ",", 
      "1.476`", ",", "1.4780000000000002`", ",", "1.48`", ",", 
      "1.4820000000000002`", ",", "1.484`", ",", "1.4860000000000002`", ",", 
      "1.488`", ",", "1.4900000000000002`", ",", "1.492`", ",", 
      "1.4940000000000002`", ",", "1.496`", ",", "1.498`", ",", "1.5`", ",", 
      "1.502`", ",", "1.504`", ",", "1.506`", ",", "1.508`", ",", "1.51`", 
      ",", "1.512`", ",", "1.514`", ",", "1.516`", ",", "1.518`", ",", 
      "1.52`", ",", "1.522`", ",", "1.524`", ",", "1.526`", ",", "1.528`", 
      ",", "1.53`", ",", "1.532`", ",", "1.534`", ",", "1.536`", ",", 
      "1.538`", ",", "1.54`", ",", "1.542`", ",", "1.544`", ",", "1.546`", 
      ",", "1.548`", ",", "1.55`", ",", "1.552`", ",", "1.554`", ",", 
      "1.556`", ",", "1.558`", ",", "1.56`", ",", "1.562`", ",", "1.564`", 
      ",", "1.566`", ",", "1.568`", ",", "1.57`", ",", "1.572`", ",", 
      "1.574`", ",", "1.576`", ",", "1.578`", ",", "1.58`", ",", "1.582`", 
      ",", "1.584`", ",", "1.586`", ",", "1.588`", ",", "1.59`", ",", 
      "1.592`", ",", "1.594`", ",", "1.596`", ",", "1.598`", ",", "1.6`", ",",
       "1.602`", ",", "1.604`", ",", "1.606`", ",", "1.608`", ",", "1.61`", 
      ",", "1.612`", ",", "1.614`", ",", "1.616`", ",", "1.618`", ",", 
      "1.62`", ",", "1.622`", ",", "1.624`", ",", "1.6260000000000001`", ",", 
      "1.6280000000000001`", ",", "1.6300000000000001`", ",", 
      "1.6320000000000001`", ",", "1.6340000000000001`", ",", 
      "1.6360000000000001`", ",", "1.6380000000000001`", ",", 
      "1.6400000000000001`", ",", "1.6420000000000001`", ",", 
      "1.6440000000000001`", ",", "1.6460000000000001`", ",", 
      "1.6480000000000001`", ",", "1.6500000000000001`", ",", 
      "1.6520000000000001`", ",", "1.6540000000000001`", ",", 
      "1.6560000000000001`", ",", "1.6580000000000001`", ",", 
      "1.6600000000000001`", ",", "1.6620000000000001`", ",", 
      "1.6640000000000001`", ",", "1.6660000000000001`", ",", 
      "1.6680000000000001`", ",", "1.6700000000000002`", ",", 
      "1.6720000000000002`", ",", "1.6740000000000002`", ",", 
      "1.6760000000000002`", ",", "1.6780000000000002`", ",", 
      "1.6800000000000002`", ",", "1.6820000000000002`", ",", 
      "1.6840000000000002`", ",", "1.6860000000000002`", ",", 
      "1.6880000000000002`", ",", "1.6900000000000002`", ",", 
      "1.6920000000000002`", ",", "1.6940000000000002`", ",", 
      "1.6960000000000002`", ",", "1.6980000000000002`", ",", 
      "1.7000000000000002`", ",", "1.702`", ",", "1.7040000000000002`", ",", 
      "1.706`", ",", "1.7080000000000002`", ",", "1.71`", ",", 
      "1.7120000000000002`", ",", "1.714`", ",", "1.7160000000000002`", ",", 
      "1.718`", ",", "1.7200000000000002`", ",", "1.722`", ",", 
      "1.7240000000000002`", ",", "1.726`", ",", "1.7280000000000002`", ",", 
      "1.73`", ",", "1.7320000000000002`", ",", "1.734`", ",", 
      "1.7360000000000002`", ",", "1.738`", ",", "1.7400000000000002`", ",", 
      "1.742`", ",", "1.7440000000000002`", ",", "1.746`", ",", 
      "1.7480000000000002`", ",", "1.75`", ",", "1.7520000000000002`", ",", 
      "1.754`", ",", "1.7560000000000002`", ",", "1.758`", ",", 
      "1.7600000000000002`", ",", "1.762`", ",", "1.7640000000000002`", ",", 
      "1.766`", ",", "1.768`", ",", "1.77`", ",", "1.772`", ",", "1.774`", 
      ",", "1.776`", ",", "1.778`", ",", "1.78`", ",", "1.782`", ",", 
      "1.784`", ",", "1.786`", ",", "1.788`", ",", "1.79`", ",", "1.792`", 
      ",", "1.794`", ",", "1.796`", ",", "1.798`", ",", "1.8`", ",", "1.802`",
       ",", "1.804`", ",", "1.806`", ",", "1.808`", ",", "1.81`", ",", 
      "1.812`", ",", "1.814`", ",", "1.816`", ",", "1.818`", ",", "1.82`", 
      ",", "1.822`", ",", "1.824`", ",", "1.826`", ",", "1.828`", ",", 
      "1.83`", ",", "1.832`", ",", "1.834`", ",", "1.836`", ",", "1.838`", 
      ",", "1.84`", ",", "1.842`", ",", "1.844`", ",", "1.846`", ",", 
      "1.848`", ",", "1.85`"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Mu]Eqmarr", "=", "qarr"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Toverq", "=", 
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "q", "}"}], ",", 
       RowBox[{
        RowBox[{"Sqrt", "[", "q", "]"}], 
        RowBox[{"(", 
         RowBox[{
          FractionBox["3", "q"], "-", 
          FractionBox["q", "4"]}], ")"}]}]}], "]"}], "@", "qarr"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tover\[Mu]", "=", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "q", "}"}], ",", 
      RowBox[{"(", 
       RowBox[{
        FractionBox["3", "q"], "-", 
        FractionBox["q", "4"]}], ")"}]}], "]"}], "@", "qarr"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.546534455709744*^9, 3.546534495617879*^9}, {
   3.5465347694750767`*^9, 3.546534803715756*^9}, 3.546534874436294*^9, {
   3.546535047187317*^9, 3.546535052715231*^9}, {3.548107477696239*^9, 
   3.548107499284542*^9}, {3.548575138753029*^9, 3.548575158713624*^9}, {
   3.548575282194725*^9, 3.548575282498541*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"hort1", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"veclist2", "[", 
       RowBox[{"[", 
        RowBox[{"ii", ",", "2", ",", "2"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "veclist2", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"asymscalre", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"veclist2", "[", 
       RowBox[{"[", 
        RowBox[{"ii", ",", "2", ",", "4"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "veclist2", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"asymscalim", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"veclist2", "[", 
       RowBox[{"[", 
        RowBox[{"ii", ",", "2", ",", "5"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "veclist2", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"asymscal", "=", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"asymscalre", "^", "2"}], "+", 
      RowBox[{"asymscalim", "^", "2"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"asym\[Mu]", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"veclist2", "[", 
       RowBox[{"[", 
        RowBox[{"ii", ",", "2", ",", "6"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "veclist2", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"asymq", "=", 
    RowBox[{"-", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"veclist2", "[", 
        RowBox[{"[", 
         RowBox[{"ii", ",", "2", ",", "7"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", 
         RowBox[{"Length", "[", "veclist2", "]"}]}], "}"}]}], "]"}]}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"asym\[Rho]", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"veclist2", "[", 
      RowBox[{"[", 
       RowBox[{"ii", ",", "2", ",", "8"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", "1", ",", 
       RowBox[{"Length", "[", "veclist2", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.54385840855757*^9, 3.543858478411048*^9}, {
   3.5438629561121693`*^9, 3.543862967887542*^9}, {3.5438667569267807`*^9, 
   3.543866769631545*^9}, {3.543993923118877*^9, 3.543993930541388*^9}, {
   3.544418567406822*^9, 3.544418572688039*^9}, {3.54442344203242*^9, 
   3.54442345380746*^9}, {3.544503790725836*^9, 3.544503795868767*^9}, {
   3.5464796979811697`*^9, 3.546479711932115*^9}, 3.548573923360705*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Tc", "=", 
   RowBox[{
    RowBox[{"(", 
     FractionBox["hort1", "asym\[Mu]"], ")"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tcq", "=", 
   RowBox[{
    RowBox[{"(", 
     FractionBox["hort1", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"-", "asymq"}], "]"}]], ")"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Sc", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"asym\[Mu]", "^", "2"}], ")"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.544939828505229*^9, 3.5449398538400106`*^9}, {
  3.544943013927876*^9, 3.544943052422511*^9}, {3.548107394056617*^9, 
  3.548107406113064*^9}, {3.5481075423690987`*^9, 3.5481075424245358`*^9}}],

Cell[BoxData[
 RowBox[{"fit", "=", 
  RowBox[{"FindFit", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["hort1", "asym\[Mu]"], ",", 
        FractionBox["asymscal", 
         RowBox[{"asym\[Mu]", "^", "2"}]]}], "}"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ";;", "10"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", " ", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"x0", "-", "x"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x0", ",", "1.15"}], "}"}], ",", "b"}], "}"}], ",", "x"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.548416186427705*^9, 3.5484162038553762`*^9}, {
  3.548416246055118*^9, 3.548416272318399*^9}, {3.5484163464942827`*^9, 
  3.5484164142680902`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Tc", "=", "1.133"}], ";"}]], "Input",
 CellChangeTimes->{{3.548416418360384*^9, 3.548416423123701*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["hort1", "asym\[Mu]"], ",", 
         FractionBox["asymscal", 
          RowBox[{"asym\[Mu]", "^", "2"}]]}], "}"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ";;", "10"}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", " ", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"x0", "-", "x"}], "]"}]}], "/.", "fit"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "1", ",", "1.133"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"tmp", ",", "tmp2", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.5484161724929447`*^9, 3.548416228518188*^9}, {
  3.548416281224411*^9, 3.548416321603837*^9}, {3.548416428924604*^9, 
  3.548416440859836*^9}}],

Cell[BoxData[
 RowBox[{"fit", "=", 
  RowBox[{"FindFit", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["hort1", 
         RowBox[{"Sqrt", "[", "asymq", "]"}]], ",", 
        FractionBox["asymscal", "asymq"]}], "}"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ";;", "10"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", " ", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"x0", "-", "x"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x0", ",", "1.55"}], "}"}], ",", "b"}], "}"}], ",", "x"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.548416186427705*^9, 3.5484162038553762`*^9}, {
  3.548416246055118*^9, 3.548416272318399*^9}, {3.5484163464942827`*^9, 
  3.5484164142680902`*^9}, {3.5484166015552683`*^9, 3.548416647463231*^9}, {
  3.548573882575467*^9, 3.548573934638321*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Tcq", "=", "1.552"}], ";"}]], "Input",
 CellChangeTimes->{{3.548416615037114*^9, 3.548416616400682*^9}, {
  3.548416656015119*^9, 3.5484166606458597`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["hort1", 
          RowBox[{"Sqrt", "[", "asymq", "]"}]], ",", 
         FractionBox["asymscal", "asymq"]}], "}"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ";;", "10"}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", " ", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"x0", "-", "x"}], "]"}]}], "/.", "fit"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "1.4", ",", "1.552"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"tmp", ",", "tmp2", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.5484161724929447`*^9, 3.548416228518188*^9}, {
  3.548416281224411*^9, 3.548416321603837*^9}, {3.548416428924604*^9, 
  3.548416440859836*^9}, {3.5484166679432287`*^9, 3.5484166821268883`*^9}, {
  3.548573893487329*^9, 3.54857389884725*^9}, {3.548573936782649*^9, 
  3.548573938286229*^9}}],

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       FractionBox["1", "Tc"], 
       FractionBox["hort1", "asym\[Mu]"]}], ",", 
      FractionBox["asymscal", 
       RowBox[{"asym\[Mu]", "^", "2"}]]}], "}"}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1.1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0.5"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.548579575478263*^9, 3.548579630939002*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plttmp", "=", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.81", ",", "y"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Dashing", "[", 
         RowBox[{"{", 
          RowBox[{"0.01", ",", "0.01"}], "}"}], "]"}], "}"}]}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          FractionBox["1", "Tc"], 
          FractionBox["hort1", "asym\[Mu]"]}], ",", 
         FractionBox[
          RowBox[{"evaldata", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "5"}], "]"}], "]"}], "asym\[Mu]"]}], "}"}], 
       "]"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "All"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "All"}], "}"}]}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"evalpltIm", "=", 
  RowBox[{"Show", "[", 
   RowBox[{"plt1", ",", "plttmp", ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<\!\(\*FractionBox[SubscriptBox[\(T\), \(f\)], SubscriptBox[\(T\), \
\(c\)]]\)\>\"", ",", "\"\<\!\(\*FractionBox[\(l\), \(\[Mu]\)]\)\>\""}], 
      "}"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{
  3.5464801428483477`*^9, {3.546480214336381*^9, 3.54648023092848*^9}, {
   3.546480300809188*^9, 3.54648031843134*^9}, {3.546480405989953*^9, 
   3.5464804190364532`*^9}, {3.5464810669853897`*^9, 3.546481069470916*^9}, {
   3.5481075079463654`*^9, 3.548107525234508*^9}, {3.548107556497712*^9, 
   3.54810756388938*^9}, {3.548573942927915*^9, 3.548573961901465*^9}, {
   3.548575077907845*^9, 3.548575092835096*^9}}],

Cell[BoxData[
 RowBox[{"QNMRe", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       FractionBox["1", "Tc"], 
       FractionBox["hort1", "asym\[Mu]"]}], ",", 
      FractionBox[
       RowBox[{"evaldata", "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "5"}], "]"}], "]"}], "asym\[Mu]"]}], "}"}], 
    "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.547483892529757*^9, 3.5474839056324883`*^9}, {
  3.548107570311344*^9, 3.548107579041032*^9}, {3.548575029770596*^9, 
  3.548575032170287*^9}, {3.5485750973937817`*^9, 3.548575100768489*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           FractionBox["1", "Tc"], 
           FractionBox["hort1", "asym\[Mu]"]}], ",", 
          FractionBox[
           RowBox[{"evaldata", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", "2"}], "]"}], "]"}], "asym\[Mu]"]}], "}"}], 
        "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "22"}], "]"}], "]"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Hue", "[", "0", "]"}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          FractionBox["1", "Tc"], 
          FractionBox["hort1", "asym\[Mu]"]}], ",", 
         FractionBox[
          RowBox[{"evaldata", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "4"}], "]"}], "]"}], "asym\[Mu]"]}], "}"}], 
       "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ";;", 
        RowBox[{"-", "1"}]}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt3", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{
         FractionBox[
          RowBox[{"Tover\[Mu]", "[", 
           RowBox[{"[", 
            RowBox[{"1", ";;", 
             RowBox[{"Length", "[", "evaldata3", "]"}]}], "]"}], "]"}], "Tc"],
          ",", 
         FractionBox[
          RowBox[{"evaldata3", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "2"}], "]"}], "]"}], 
          RowBox[{"\[Mu]Eqmarr", "[", 
           RowBox[{"[", 
            RowBox[{"1", ";;", 
             RowBox[{"Length", "[", "evaldata3", "]"}]}], "]"}], "]"}]]}], 
        "}"}], "]"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Hue", "[", "0", "]"}], "}"}]}], ",", 
      RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plttmp", "=", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.81", ",", "y"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Dashing", "[", 
         RowBox[{"{", 
          RowBox[{"0.01", ",", "0.01"}], "}"}], "]"}], "}"}]}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"evalpltRe", "=", 
  RowBox[{"Show", "[", 
   RowBox[{"plt1", ",", "plt2", ",", "plt3", ",", "plttmp", ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.", ",", "All"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0.65"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"AxesOrigin", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<\!\(\*FractionBox[SubscriptBox[\(T\), \(f\)], SubscriptBox[\(T\), \
\(c\)]]\)\>\"", ",", "\"\<\!\(\*FractionBox[\(k\), \(\[Mu]\)]\)\>\""}], 
      "}"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.546480015377842*^9, 3.546480019108459*^9}, {
   3.546480259544948*^9, 3.546480297814343*^9}, {3.54648033851818*^9, 
   3.546480386830659*^9}, {3.54648042933034*^9, 3.546480502224004*^9}, {
   3.5464807105595007`*^9, 3.546480765933242*^9}, {3.546480845454652*^9, 
   3.546480850765236*^9}, {3.5464809430762033`*^9, 3.546480968946266*^9}, {
   3.5464810537460546`*^9, 3.5464810616967163`*^9}, {3.546534957805511*^9, 
   3.5465349590283318`*^9}, {3.547483624965397*^9, 3.547483629468766*^9}, {
   3.5481075840698338`*^9, 3.5481076639021597`*^9}, {3.5485750354626083`*^9, 
   3.548575041014279*^9}, {3.5485751031410637`*^9, 3.548575116654299*^9}, {
   3.548575168324375*^9, 3.548575192303289*^9}, 3.548575290054297*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           FractionBox["1", "Tc"], 
           FractionBox["hort1", "asym\[Mu]"]}], ",", 
          FractionBox[
           RowBox[{"evaldata", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", "2"}], "]"}], "]"}], "asym\[Mu]"]}], "}"}], 
        "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", "22"}], "]"}], "]"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Hue", "[", "0", "]"}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          FractionBox["1", "Tc"], 
          FractionBox["hort1", "asym\[Mu]"]}], ",", 
         FractionBox[
          RowBox[{"evaldata", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "4"}], "]"}], "]"}], "asym\[Mu]"]}], "}"}], 
       "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"10", ";;", 
        RowBox[{"-", "1"}]}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt3", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{
         FractionBox[
          RowBox[{"Tover\[Mu]", "[", 
           RowBox[{"[", 
            RowBox[{"1", ";;", 
             RowBox[{"Length", "[", "evaldata3", "]"}]}], "]"}], "]"}], "Tc"],
          ",", 
         FractionBox[
          RowBox[{"evaldata3", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "2"}], "]"}], "]"}], 
          RowBox[{"\[Mu]Eqmarr", "[", 
           RowBox[{"[", 
            RowBox[{"1", ";;", 
             RowBox[{"Length", "[", "evaldata3", "]"}]}], "]"}], "]"}]]}], 
        "}"}], "]"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Hue", "[", "0", "]"}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plttmp", "=", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.81", ",", "y"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Dashing", "[", 
         RowBox[{"{", 
          RowBox[{"0.01", ",", "0.01"}], "}"}], "]"}], "}"}]}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"evalpltRe", "=", 
  RowBox[{"Show", "[", 
   RowBox[{"plt1", ",", "plt2", ",", "plt3", ",", "plttmp", ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.", ",", "All"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0.5"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"AxesOrigin", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<\!\(\*SubscriptBox[\(T\), \(f\)]\)/\!\(\*SubscriptBox[\(T\), \
\(c\)]\)\>\"", ",", "\"\<k/\[Mu]\>\""}], "}"}]}], ",", 
    RowBox[{"AxesStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Directive", "[", 
       RowBox[{"FontSize", "->", "20"}], "]"}], "}"}]}]}], "]"}]}]}], "Input",\

 CellChangeTimes->{{3.546480015377842*^9, 3.546480019108459*^9}, {
   3.546480259544948*^9, 3.546480297814343*^9}, {3.54648033851818*^9, 
   3.546480386830659*^9}, {3.54648042933034*^9, 3.546480502224004*^9}, {
   3.5464807105595007`*^9, 3.546480765933242*^9}, {3.546480845454652*^9, 
   3.546480850765236*^9}, {3.5464809430762033`*^9, 3.546480968946266*^9}, {
   3.5464810537460546`*^9, 3.5464810616967163`*^9}, {3.546534957805511*^9, 
   3.5465349590283318`*^9}, {3.547483624965397*^9, 3.547483629468766*^9}, {
   3.5481075840698338`*^9, 3.5481076639021597`*^9}, {3.5485750354626083`*^9, 
   3.548575041014279*^9}, {3.5485751031410637`*^9, 3.548575116654299*^9}, {
   3.548575168324375*^9, 3.548575192303289*^9}, 3.548575290054297*^9, {
   3.548580546904159*^9, 3.548580623153006*^9}, {3.548590592477453*^9, 
   3.5485906191362553`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"QNMOsc", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         FractionBox["1", "Tc"], 
         FractionBox["hort1", "asym\[Mu]"]}], ",", 
        FractionBox[
         RowBox[{"evaldata", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", "4"}], "]"}], "]"}], "asym\[Mu]"]}], "}"}], 
      "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ";;", 
       RowBox[{"-", "1"}]}], "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QNMDamp", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         FractionBox["1", "Tc"], 
         FractionBox["hort1", "asym\[Mu]"]}], ",", 
        FractionBox[
         RowBox[{"evaldata", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", "2"}], "]"}], "]"}], "asym\[Mu]"]}], "}"}], 
      "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ";;", "22"}], "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"QNMQuench", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      FractionBox[
       RowBox[{"Tover\[Mu]", "[", 
        RowBox[{"[", 
         RowBox[{"1", ";;", 
          RowBox[{"Length", "[", "evaldata3", "]"}]}], "]"}], "]"}], "Tc"], 
      ",", 
      FractionBox[
       RowBox[{"evaldata3", "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "2"}], "]"}], "]"}], 
       RowBox[{"\[Mu]Eqmarr", "[", 
        RowBox[{"[", 
         RowBox[{"1", ";;", 
          RowBox[{"Length", "[", "evaldata3", "]"}]}], "]"}], "]"}]]}], "}"}],
     "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.547483914960328*^9, 3.54748395520357*^9}, {
   3.547484050992107*^9, 3.5474840580717688`*^9}, {3.5481076865479527`*^9, 
   3.5481077077335463`*^9}, {3.548575047764097*^9, 3.548575053131789*^9}, {
   3.548575211732408*^9, 3.5485752385490313`*^9}, 3.54857529323622*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Analyse data", "Subsubtitle",
 CellChangeTimes->{{3.5485737366707153`*^9, 3.548573744104053*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"EndPos", "=", 
   RowBox[{"Round", "[", 
    RowBox[{"0.65", "*", 
     RowBox[{"Length", "[", 
      RowBox[{"tdat", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.544936546029869*^9, 3.544936569380289*^9}, {
   3.54494037544573*^9, 3.54494037802952*^9}, {3.544940424359735*^9, 
   3.544940425263344*^9}, {3.544942341517995*^9, 3.544942341653623*^9}, {
   3.544942389892935*^9, 3.544942450517997*^9}, 3.549899585028603*^9, {
   3.5499048896751223`*^9, 3.549904890594207*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"horizpos", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"templist", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Rho]list", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"qlist", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Mu]list", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"tmpfn", "=", 
       RowBox[{"Interpolation", "[", 
        RowBox[{"Transpose", "[", 
         RowBox[{"{", 
          RowBox[{"zarr", ",", 
           RowBox[{"1", "+", 
            RowBox[{
             RowBox[{"zarr", "^", "2"}], "*", 
             RowBox[{"tdat", "[", 
              RowBox[{"[", 
               RowBox[{"run", ",", "EndPos", ",", "All"}], "]"}], "]"}]}]}]}],
           "}"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"tmpfn", "[", "z", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"z", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"root", "=", 
       RowBox[{"FindRoot", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"tmpfn", "[", "z", "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{"{", 
          RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"temp", "=", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{
          RowBox[{"tmpfn", "'"}], "[", "z", "]"}]}], "/.", "root"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<run = \>\"", ",", "run", ",", "\"\< -> horiz = \>\"", ",", 
        RowBox[{"z", "/.", "root"}], ",", "\"\<   temp = \>\"", ",", "temp"}],
        "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"horizpos", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"amplist", "[", 
           RowBox[{"[", "run", "]"}], "]"}], ",", 
          RowBox[{"z", "/.", "root"}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"templist", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"amplist", "[", 
           RowBox[{"[", "run", "]"}], "]"}], ",", "temp"}], "}"}]}], "]"}], 
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"\[Rho]val", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Interpolation", "[", 
          RowBox[{"Transpose", "[", 
           RowBox[{"{", 
            RowBox[{"zarr", ",", 
             RowBox[{"tdat", "[", 
              RowBox[{"[", 
               RowBox[{"run", ",", "EndPos", ",", "All"}], "]"}], "]"}]}], 
            "}"}], "]"}], "]"}], "'"}], "[", "0", "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"qval", "=", 
       RowBox[{"-", 
        RowBox[{
         RowBox[{
          RowBox[{"Interpolation", "[", 
           RowBox[{"Transpose", "[", 
            RowBox[{"{", 
             RowBox[{"zarr", ",", 
              RowBox[{"adat", "[", 
               RowBox[{"[", 
                RowBox[{"run", ",", "EndPos", ",", "All"}], "]"}], "]"}]}], 
             "}"}], "]"}], "]"}], "'"}], "[", "0", "]"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         FractionBox["temp", 
          RowBox[{"Sqrt", "[", "qval", "]"}]], "<", "Tcq"}], ",", 
        RowBox[{
         RowBox[{"\[Mu]val", "=", 
          RowBox[{"\[Mu]arr", "[", 
           RowBox[{"[", 
            RowBox[{"run", ",", "EndPos"}], "]"}], "]"}]}], ";"}], ",", 
        RowBox[{
         RowBox[{"\[Mu]val", "=", 
          RowBox[{"qval", "*", 
           RowBox[{"horizpos", "[", 
            RowBox[{"[", 
             RowBox[{"run", ",", "2"}], "]"}], "]"}]}]}], ";"}]}], "]"}], ";",
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"\[Rho]list", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"amplist", "[", 
           RowBox[{"[", "run", "]"}], "]"}], ",", "\[Rho]val"}], "}"}]}], 
       "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"qlist", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"amplist", "[", 
           RowBox[{"[", "run", "]"}], "]"}], ",", "qval"}], "}"}]}], "]"}], 
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"\[Mu]list", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"amplist", "[", 
           RowBox[{"[", "run", "]"}], "]"}], ",", "\[Mu]val"}], "}"}]}], 
       "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"run", ",", "1", ",", 
       RowBox[{"Length", "[", "sizelist", "]"}]}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", "horizpos"}], "Input",
 CellChangeTimes->{{3.544422807746285*^9, 3.544423057165472*^9}, {
   3.544423316520194*^9, 3.5444233903675003`*^9}, {3.544504469992114*^9, 
   3.5445044898728113`*^9}, {3.5445045256185837`*^9, 3.544504593591118*^9}, 
   3.544936575905455*^9, {3.544939101980242*^9, 3.544939173323639*^9}, 
   3.54810725945717*^9, {3.548573439147429*^9, 3.5485734415170383`*^9}, {
   3.548573556982484*^9, 3.548573660047915*^9}, {3.549899800245474*^9, 
   3.5498998120879107`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]list", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fit", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Mu]val", "=", 
      RowBox[{"\[Mu]list", "[", 
       RowBox[{"[", 
        RowBox[{"run", ",", "2"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]",
      "\[IndentingNewLine]", 
     RowBox[{"qval", "=", 
      RowBox[{"qlist", "[", 
       RowBox[{"[", 
        RowBox[{"run", ",", "2"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]",
      "\[IndentingNewLine]", 
     RowBox[{"boundaryf", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", 
            RowBox[{"run", ",", "pos"}], "]"}], "]"}], ",", 
          FractionBox[
           RowBox[{
            RowBox[{
             RowBox[{"Interpolation", "[", 
              RowBox[{"Transpose", "[", 
               RowBox[{"{", 
                RowBox[{"zarr", ",", 
                 RowBox[{"fdat", "[", 
                  RowBox[{"[", 
                   RowBox[{"run", ",", "pos", ",", "All"}], "]"}], "]"}]}], 
                "}"}], "]"}], "]"}], "'"}], "[", "0", "]"}], 
           RowBox[{"\[Mu]val", "^", "2"}]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"pos", ",", "1", ",", "EndPos"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"boundaryh", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", 
            RowBox[{"run", ",", "pos"}], "]"}], "]"}], ",", 
          FractionBox[
           RowBox[{
            RowBox[{
             RowBox[{"Interpolation", "[", 
              RowBox[{"Transpose", "[", 
               RowBox[{"{", 
                RowBox[{"zarr", ",", 
                 RowBox[{"hdat", "[", 
                  RowBox[{"[", 
                   RowBox[{"run", ",", "pos", ",", "All"}], "]"}], "]"}]}], 
                "}"}], "]"}], "]"}], "'"}], "[", "0", "]"}], 
           RowBox[{"\[Mu]val", "^", "2"}]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"pos", ",", "1", ",", "EndPos"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Temp (/Tc) = \>\"", ",", 
       RowBox[{"Temp", "=", 
        RowBox[{
         FractionBox[
          RowBox[{"templist", "[", 
           RowBox[{"[", 
            RowBox[{"run", ",", "2"}], "]"}], "]"}], "\[Mu]val"], "/", 
         "Tc"}]}], ",", "\"\<  \[Delta]/\[Mu] = \>\"", ",", 
       FractionBox[
        RowBox[{"amplist", "[", 
         RowBox[{"[", "run", "]"}], "]"}], "\[Mu]val"]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"asymval", "=", 
      RowBox[{"boundaryf", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "2"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"Temp", "<", "0.81"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"decay", "=", 
         RowBox[{
          RowBox[{"QNMOsc", "[", "Temp", "]"}], "*", "\[Mu]val"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"osc", "=", 
         RowBox[{
          RowBox[{"QNMRe", "[", "Temp", "]"}], "*", "\[Mu]val"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"fitfn", "=", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"osc", " ", 
             RowBox[{"(", 
              RowBox[{"t", "-", "t0"}], ")"}]}], "]"}], 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{"-", "decay"}], " ", "t"}], "]"}]}]}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"decay", ",", " ", "\"\< \>\"", ",", "osc"}], "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"fit", "=", 
         RowBox[{"FindFit", "[", 
          RowBox[{
           RowBox[{"boundaryf", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"Round", "[", 
               RowBox[{
                FractionBox["1", "3"], "EndPos"}], "]"}], ";;", 
              RowBox[{"Round", "[", "EndPos", "]"}]}], "]"}], "]"}], ",", 
           "fitfn", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"a", ",", "asymval"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"b", ",", 
               RowBox[{"-", "0.17"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"t0", ",", "3.5"}], "}"}]}], "}"}], ",", "t"}], "]"}]}],
         ";"}], "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Temp", "<", "0.99"}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"decay", "=", 
            RowBox[{
             RowBox[{"QNMDamp", "[", "Temp", "]"}], "*", "\[Mu]val"}]}], ";", 
           "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"fitfn", "=", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", 
              RowBox[{"Exp", "[", 
               RowBox[{
                RowBox[{"-", "decay"}], " ", "t"}], "]"}]}]}]}], ";", 
           "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"fit", "=", 
            RowBox[{"FindFit", "[", 
             RowBox[{
              RowBox[{"boundaryf", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"Round", "[", 
                  RowBox[{
                   FractionBox["1", "3"], "EndPos"}], "]"}], ";;", 
                 RowBox[{"Round", "[", "EndPos", "]"}]}], "]"}], "]"}], ",", 
              "fitfn", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"a", ",", "asymval"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"b", ",", 
                  RowBox[{"-", "0.17"}]}], "}"}]}], "}"}], ",", "t"}], 
             "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
          ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"decay", "=", 
            RowBox[{
             RowBox[{"QNMQuench", "[", "Temp", "]"}], "*", "\[Mu]val"}]}], 
           ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"fitfn", "=", 
            RowBox[{"b", " ", 
             RowBox[{"Exp", "[", 
              RowBox[{
               RowBox[{"-", "k"}], " ", "t"}], "]"}]}]}], ";", 
           "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"fit", "=", 
            RowBox[{"Join", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"a", "\[Rule]", "0"}], "}"}], ",", 
              RowBox[{"FindFit", "[", 
               RowBox[{
                RowBox[{"boundaryf", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"Round", "[", 
                    RowBox[{
                    FractionBox["1", "3"], "EndPos"}], "]"}], ";;", 
                   RowBox[{"Round", "[", "EndPos", "]"}]}], "]"}], "]"}], ",",
                 "fitfn", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"b", ",", "0.17"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"k", ",", "0.1"}], "}"}]}], "}"}], ",", "t"}], 
               "]"}]}], "]"}]}], ";"}]}], "\[IndentingNewLine]", 
         "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"\[Psi]list", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"amplist", "[", 
          RowBox[{"[", "run", "]"}], "]"}], ",", 
         FractionBox[
          RowBox[{"templist", "[", 
           RowBox[{"[", 
            RowBox[{"run", ",", "2"}], "]"}], "]"}], "\[Mu]val"], ",", 
         RowBox[{"a", "/.", "fit"}], ",", 
         RowBox[{"b", "/.", "fit"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"k", "/.", "fit"}], ")"}], "===", "k"}], ",", "0", ",", 
           RowBox[{"k", "/.", "fit"}]}], "]"}]}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<run = \>\"", ",", "run", ",", "\"\<  amp2 = \>\"", ",", 
       RowBox[{"amplist", "[", 
        RowBox[{"[", "run", "]"}], "]"}], ",", "\"\< -> fit = \>\"", ",", 
       "fit"}], "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"plt1", "=", 
      RowBox[{"ListPlot", "[", "boundaryf", "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"plt2", "=", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"fitfn", "/.", "fit"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "1", ",", "10"}], "}"}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Hue", "[", "0", "]"}], "}"}]}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"txt", "=", 
      RowBox[{"Graphics", "[", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"\"\<\[Delta] = \>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{"-", 
            RowBox[{"amplist", "[", 
             RowBox[{"[", "run", "]"}], "]"}]}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", 
           RowBox[{"Max", "[", 
            RowBox[{"boundaryf", "[", 
             RowBox[{"[", 
              RowBox[{"All", ",", "2"}], "]"}], "]"}], "]"}]}], "}"}]}], 
        "]"}], "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"figplt", "=", 
      RowBox[{"Show", "[", 
       RowBox[{"plt1", ",", "plt2", ",", "txt", ",", 
        RowBox[{"AxesLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
          "\"\<t\>\"", ",", 
           "\"\<|<O>|/\!\(\*SuperscriptBox[\(\[Mu]\), \(2\)]\)\>\""}], 
          "}"}]}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"All", ",", "All"}], "}"}]}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "figplt", "]"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"OUTPUT", "\[Equal]", "1"}], ",", 
       RowBox[{"Export", "[", 
        RowBox[{
         RowBox[{"\"\<~/Work/AdSCMTDyn4/figs/psievolution_\>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{"amplist", "[", 
            RowBox[{"[", "run", "]"}], "]"}], "]"}], "<>", "\"\<.jpg\>\""}], 
         ",", "figplt"}], "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"run", ",", "1", ",", 
      RowBox[{"Length", "[", "sizelist", "]"}]}], "}"}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.544936848291461*^9, 3.544937021406467*^9}, {
   3.544937304553576*^9, 3.544937691584041*^9}, 3.5449377318394213`*^9, {
   3.544937771278882*^9, 3.5449377996285677`*^9}, {3.544937908503346*^9, 
   3.5449379929989347`*^9}, {3.5449380271089907`*^9, 
   3.5449380857732286`*^9}, {3.544938127549938*^9, 3.544938221246296*^9}, 
   3.5449382589832687`*^9, {3.5449382945814543`*^9, 3.544938397912859*^9}, {
   3.544938430834364*^9, 3.544938503943112*^9}, {3.544938606151692*^9, 
   3.544938609279997*^9}, {3.544938718288323*^9, 3.544938802171164*^9}, {
   3.5449388919358273`*^9, 3.544938896383234*^9}, {3.544938977461822*^9, 
   3.544938979363138*^9}, {3.544940174132766*^9, 3.544940198212538*^9}, {
   3.544940533363143*^9, 3.544940606003181*^9}, {3.544940735355381*^9, 
   3.5449407402497463`*^9}, {3.5449427972278023`*^9, 
   3.5449428167903757`*^9}, {3.5449744414500628`*^9, 3.5449744484937*^9}, {
   3.545133386471233*^9, 3.545133411869952*^9}, 3.5451336989356413`*^9, 
   3.545134680922399*^9, {3.5463250115811253`*^9, 3.546325046615491*^9}, {
   3.5463251061395884`*^9, 3.546325129014317*^9}, {3.546325813828804*^9, 
   3.546325825299838*^9}, {3.546325855684808*^9, 3.5463259004576063`*^9}, {
   3.546326145091032*^9, 3.5463261677848043`*^9}, {3.546326976069386*^9, 
   3.546326988881566*^9}, {3.546327041500339*^9, 3.5463270899766293`*^9}, {
   3.548107287672161*^9, 3.548107322379943*^9}, {3.5481073570998898`*^9, 
   3.54810735837986*^9}, {3.5483468264358273`*^9, 3.5483468816119003`*^9}, {
   3.548346929645993*^9, 3.548346930485323*^9}, {3.548346973316136*^9, 
   3.548346985200776*^9}, {3.548347106778081*^9, 3.548347115950851*^9}, {
   3.5483472192796583`*^9, 3.548347220481011*^9}, {3.5483473476606607`*^9, 
   3.548347349263041*^9}, {3.54834739558209*^9, 3.548347413987114*^9}, {
   3.5483475029811373`*^9, 3.54834752526553*^9}, 3.548347585781539*^9, {
   3.5483476472269297`*^9, 3.54834767534653*^9}, {3.548347757411798*^9, 
   3.5483477830583487`*^9}, {3.548347846966033*^9, 3.548347865442213*^9}, {
   3.548348077303007*^9, 3.548348079679048*^9}, {3.54834814183397*^9, 
   3.548348162342268*^9}, {3.548575366628316*^9, 3.548575468096586*^9}, {
   3.54857832260196*^9, 3.548578335721197*^9}, {3.548578734251273*^9, 
   3.548578793374186*^9}, {3.548578845442197*^9, 3.548578848382723*^9}, {
   3.54857907614775*^9, 3.548579112289042*^9}, {3.54857917441453*^9, 
   3.548579246044443*^9}, {3.5485800881560993`*^9, 3.548580094091527*^9}, {
   3.548581585494996*^9, 3.548581587126598*^9}, {3.549418612528224*^9, 
   3.5494186550735273`*^9}, {3.5498998355243807`*^9, 3.5498998500588818`*^9}, 
   3.549946565940462*^9}],

Cell[BoxData["\[Psi]list"], "Input",
 CellChangeTimes->{
  3.544938622283557*^9, {3.5449387889168243`*^9, 3.54493878914083*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Static figures", "Subsubtitle",
 CellChangeTimes->{{3.548580799854521*^9, 3.5485808117421227`*^9}, {
  3.548580850227366*^9, 3.548580850865933*^9}, {3.549946587907324*^9, 
  3.549946588810355*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Mu]RN", "[", "q_", "]"}], ":=", "q"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"horizRN", "[", "q_", "]"}], ":=", "1"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tempRN", "[", "q_", "]"}], ":=", 
   RowBox[{"3", "-", 
    FractionBox[
     SuperscriptBox["q", "2"], "4"]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Rho]RN", "[", "q_", "]"}], ":=", 
  RowBox[{"1", "+", 
   FractionBox[
    SuperscriptBox["q", "2"], "4"]}]}]}], "Input",
 CellChangeTimes->{{3.5449408950295677`*^9, 3.544940959802903*^9}, {
  3.5449409929853563`*^9, 3.544941009680831*^9}, {3.544941396727065*^9, 
  3.544941397981904*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plttmp", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{
         FractionBox[
          RowBox[{"\[Psi]list", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "1"}], "]"}], "]"}], 
          RowBox[{"\[Mu]list", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "2"}], "]"}], "]"}]], ",", 
         RowBox[{"\[Psi]list", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", "3"}], "]"}], "]"}]}], "}"}], "]"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\[Delta]/\[Mu]\>\"", ",", 
         "\"\<|<O\!\(\*SubscriptBox[\(>\), \(f\)]\)|/\!\(\*SuperscriptBox[\(\
\[Mu]\), \(2\)]\)\>\""}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0.5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.01"}], ",", "0.4"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"PointSize", "[", "0.015", "]"}], "}"}]}], ",", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"FontSize", "\[Rule]", "20"}], "]"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plttmp2", "=", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.18", ",", "y"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "0.5"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Dashing", "[", 
         RowBox[{"{", 
          RowBox[{"0.01", ",", "0.01"}], "}"}], "]"}], "}"}]}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"txt", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\!\(\*SubscriptBox[\(\[Delta]\), \(*\)]\)\>\"", ",", 
         RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.115", ",", "0.35"}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plttmp3", "=", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.28", ",", "y"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "0.5"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Dashing", "[", 
         RowBox[{"{", 
          RowBox[{"0.01", ",", "0.01"}], "}"}], "]"}], "}"}]}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"txt2", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\!\(\*SubscriptBox[\(\[Delta]\), \(c\)]\)\>\"", ",", 
         RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.165", ",", "0.35"}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"txta", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<I\>\"", ",", 
         RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.05", ",", "0.1"}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"txtb", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<II\>\"", ",", 
         RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.125", ",", "0.1"}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"txtc", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<III\>\"", ",", 
         RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.23", ",", "0.1"}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"quenchplot\[Delta]", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
   "plttmp", ",", "plttmp2", ",", "plttmp3", ",", "txt", ",", "txt2", ",", 
    "txta", ",", "txtb", ",", "txtc"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.5444215636393538`*^9, 3.544421569089308*^9}, {
   3.544422488069322*^9, 3.544422573150066*^9}, {3.544423589583453*^9, 
   3.5444235977267323`*^9}, {3.544457402827943*^9, 3.544457403867681*^9}, {
   3.544938552975791*^9, 3.544938558676785*^9}, {3.544938704191484*^9, 
   3.5449387081352177`*^9}, 3.5449389031029663`*^9, {3.544939007789065*^9, 
   3.544939013933467*^9}, {3.545133450037649*^9, 3.545133453844442*^9}, {
   3.546325533345529*^9, 3.546325553025828*^9}, {3.546325931034614*^9, 
   3.546325985383993*^9}, {3.546326034815887*^9, 3.5463260514316797`*^9}, {
   3.546326446223225*^9, 3.546326446511672*^9}, {3.548058509983054*^9, 
   3.54805852541197*^9}, {3.548058648859913*^9, 3.548058676950252*^9}, {
   3.548058894695551*^9, 3.548058919838689*^9}, {3.5480631985800657`*^9, 
   3.548063210963484*^9}, {3.548106821686902*^9, 3.548106825422409*^9}, {
   3.548309391518218*^9, 3.5483093941498013`*^9}, {3.548309490252808*^9, 
   3.548309497740344*^9}, {3.548399504059202*^9, 3.54839968433508*^9}, {
   3.5483997636534863`*^9, 3.54839976399776*^9}, {3.548405140361693*^9, 
   3.548405141680488*^9}, {3.5484053113338547`*^9, 3.548405360944015*^9}, {
   3.548580859808642*^9, 3.5485809084056273`*^9}, {3.5494183081537113`*^9, 
   3.5494183425659103`*^9}, {3.54941850546906*^9, 3.549418579471999*^9}, {
   3.5494187355329723`*^9, 3.549418816202477*^9}, {3.5498997450941143`*^9, 
   3.549899745613083*^9}, {3.54989991040674*^9, 3.5498999721001863`*^9}, {
   3.5499049444540586`*^9, 3.5499049455895643`*^9}, {3.5499057394624577`*^9, 
   3.549905743766859*^9}}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"OUTPUT", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<~/Work/AdSCMTDyn4/figs/figdata4.txt\>\"", ",", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{
         FractionBox[
          RowBox[{"\[Psi]list", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "1"}], "]"}], "]"}], 
          RowBox[{"\[Mu]list", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "2"}], "]"}], "]"}]], ",", 
         RowBox[{"\[Psi]list", "[", 
          RowBox[{"[", 
           RowBox[{"All", ",", "3"}], "]"}], "]"}]}], "}"}], "]"}], ",", 
      "\"\<Table\>\""}], "]"}], ";"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.549537411210243*^9, 3.549537415450842*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plttmp", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           FractionBox["x", "Tc"], ",", "y"}], "}"}]}], "]"}], "@@@", 
       RowBox[{"Transpose", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[Psi]list", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", 
          FractionBox[
           RowBox[{"\[Psi]list", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", "1"}], "]"}], "]"}], 
           RowBox[{"\[Mu]list", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", "2"}], "]"}], "]"}]]}], "}"}], "]"}]}], ",", 
      
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*SubscriptBox[\(T\), \(f\)]\)/\!\(\*SubscriptBox[\(T\), \(c\
\)]\)\>\"", ",", "\"\<\[Delta]/\[Mu]\>\""}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0.6"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"PointSize", "[", "0.015", "]"}], "}"}]}], ",", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"FontSize", "\[Rule]", "20"}], "]"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plttmp2", "=", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"y", ",", "0.175"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Dashing", "[", 
         RowBox[{"{", 
          RowBox[{"0.01", ",", "0.01"}], "}"}], "]"}], "}"}]}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plttmp3", "=", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"y", ",", "0.285"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Dashing", "[", 
         RowBox[{"{", 
          RowBox[{"0.01", ",", "0.01"}], "}"}], "]"}], "}"}]}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"txt", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{
        "\"\<\!\(\*SubscriptBox[\(\[Delta]\), \(c\)]\)/\[Mu]\>\"", ",", 
         RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.8", ",", "0.18"}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plttmp4", "=", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.81", ",", "x"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "0.6"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Dashing", "[", 
         RowBox[{"{", 
          RowBox[{"0.01", ",", "0.01"}], "}"}], "]"}], "}"}]}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plttmp5", "=", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "x"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "0.6"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Dashing", "[", 
         RowBox[{"{", 
          RowBox[{"0.01", ",", "0.01"}], "}"}], "]"}], "}"}]}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"txt3", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{
        "\"\<\!\(\*SubscriptBox[\(\[Delta]\), \(*\)]\)/\[Mu]\>\"", ",", 
         RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.8", ",", "0.06"}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"quenchplotTvsdelta", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
   "plttmp", ",", "plttmp2", ",", "plttmp3", ",", "plttmp4", ",", "plttmp5", 
    ",", "txt", ",", "txt3"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.544939752027379*^9, 3.544939782290246*^9}, {
   3.544939868184664*^9, 3.544939889856497*^9}, {3.544942898965711*^9, 
   3.544942906267229*^9}, {3.5463254097409067`*^9, 3.546325469347815*^9}, {
   3.546325997811071*^9, 3.54632600809555*^9}, 3.548063220348528*^9, {
   3.548309504764577*^9, 3.548309505204496*^9}, {3.548399732188911*^9, 
   3.548399776488078*^9}, {3.54840513489999*^9, 3.548405136050025*^9}, {
   3.548580923838805*^9, 3.54858095271672*^9}, {3.548581396385219*^9, 
   3.5485814955745792`*^9}, {3.549418859789197*^9, 3.549418923040245*^9}, {
   3.5494189545833673`*^9, 3.54941911993559*^9}, {3.549419172705216*^9, 
   3.5494192261373796`*^9}, {3.5494192780067244`*^9, 3.549419303954887*^9}, {
   3.549900022269937*^9, 3.549900022477849*^9}, {3.5499049527275877`*^9, 
   3.549904956887858*^9}, {3.5499057002304897`*^9, 3.549905728004183*^9}, {
   3.549946508957737*^9, 3.549946521212748*^9}}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"OUTPUT", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<~/Work/AdSCMTDyn4/figs/figdata5.txt\>\"", ",", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           FractionBox["x", "Tc"], ",", "y"}], "}"}]}], "]"}], "@@@", 
       RowBox[{"Transpose", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[Psi]list", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", 
          FractionBox[
           RowBox[{"\[Psi]list", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", "1"}], "]"}], "]"}], 
           RowBox[{"\[Mu]list", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", "2"}], "]"}], "]"}]]}], "}"}], "]"}]}], ",", 
      "\"\<Table\>\""}], "]"}], ";"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.549537442913763*^9, 3.5495374449284267`*^9}}],

Cell[BoxData[
 RowBox[{"quenchplotT", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["x", "Tc"], ",", "y"}], "}"}]}], "]"}], "@@@", 
     RowBox[{"\[Psi]list", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<\!\(\*FractionBox[SubscriptBox[\(T\), \(f\)], SubscriptBox[\(T\), \
\(c\)]]\)\>\"", ",", 
       "\"\<|<O\!\(\*SubscriptBox[\(>\), \(f\)]\)|/\!\(\*SuperscriptBox[\(\
\[Mu]\), \(2\)]\)\[InvisibleComma]\>\""}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"PointSize", "[", "0.015", "]"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5449389096054287`*^9, 3.5449389354518213`*^9}, {
   3.544938990595005*^9, 3.5449390178685207`*^9}, {3.544939390362321*^9, 
   3.544939436649398*^9}, {3.544939914752791*^9, 3.544939935193069*^9}, {
   3.5451334593170023`*^9, 3.545133462436883*^9}, {3.546326016703146*^9, 
   3.546326029085306*^9}, {3.546326203740283*^9, 3.54632621057078*^9}, 
   3.548063232442711*^9, 3.548063270017824*^9, {3.548309400693569*^9, 
   3.548309403063032*^9}, {3.548399151825823*^9, 3.548399161952598*^9}, {
   3.5485809833692293`*^9, 3.548580996287634*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plt", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           FractionBox["1", "Tc"], 
           FractionBox["hort1", "asym\[Mu]"]}], ",", 
          FractionBox["asymscal", 
           RowBox[{"asym\[Mu]", "^", "2"}]]}], "}"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", 
         RowBox[{"-", "1"}]}], "]"}], "]"}], ",", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Hue", "[", "0", "]"}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plttmp2", "=", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.81", ",", "y"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Dashing", "[", 
         RowBox[{"{", 
          RowBox[{"0.01", ",", "0.01"}], "}"}], "]"}], "}"}]}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"txt", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{
        "\"\<\!\(\*SubscriptBox[\(T\), \(*\)]\)/\!\(\*SubscriptBox[\(T\), \(c\
\)]\)\>\"", ",", 
         RowBox[{"FontSize", "\[Rule]", "18"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.65", ",", "0.2"}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plttmp3", "=", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "y"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Dashing", "[", 
         RowBox[{"{", 
          RowBox[{"0.01", ",", "0.01"}], "}"}], "]"}], "}"}]}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"txt2", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\!\(\*SubscriptBox[\(\[Delta]\), \(c\)]\)\>\"", ",", 
         RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.48", ",", "0.35"}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"txta", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<I\>\"", ",", 
         RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5", ",", "0.05"}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"txtb", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<II\>\"", ",", 
         RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.9", ",", "0.05"}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"txtc", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<III\>\"", ",", 
         RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.3", ",", "0.05"}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"quenchplotT2", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
   "plt", ",", "plttmp2", ",", "plttmp3", ",", "quenchplotT", ",", "txt", ",",
     "txta", ",", "txtb", ",", "txtc", ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0.4"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<\!\(\*SubscriptBox[\(T\), \(f\)]\)/\!\(\*SubscriptBox[\(T\), \
\(c\)]\)\>\"", ",", 
       "\"\<|<O\!\(\*SubscriptBox[\(>\), \(f\)]\)|/\!\(\*SuperscriptBox[\(\
\[Mu]\), \(2\)]\)\>\""}], "}"}]}], ",", 
    RowBox[{"AxesStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"FontSize", "\[Rule]", "18"}], "]"}]}], ",", 
    RowBox[{"AxesOrigin", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.5449392341500607`*^9, 3.54493924408554*^9}, {
   3.544939277101267*^9, 3.5449394080144863`*^9}, 3.544939448166963*^9, {
   3.5449398986256123`*^9, 3.544939906088724*^9}, {3.5449428889985332`*^9, 
   3.544942890092244*^9}, {3.545133469565208*^9, 3.545133472805127*^9}, {
   3.545134090136752*^9, 3.545134099240748*^9}, {3.546326230228609*^9, 
   3.5463262351251173`*^9}, {3.546326423672961*^9, 3.546326424807605*^9}, {
   3.548059072119445*^9, 3.548059093478755*^9}, {3.5480591853470507`*^9, 
   3.548059188250532*^9}, {3.548063244003677*^9, 3.5480632575073357`*^9}, 
   3.548098412701686*^9, {3.548106846463702*^9, 3.548106852758565*^9}, {
   3.548309409269063*^9, 3.548309438456068*^9}, {3.548399135633473*^9, 
   3.548399144716498*^9}, {3.548399807062695*^9, 3.548399937714033*^9}, {
   3.548581001745524*^9, 3.548581022993453*^9}, {3.548581059859969*^9, 
   3.548581190900847*^9}}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"OUTPUT", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<~/Work/AdSCMTDyn4/figs/figdata6.txt\>\"", ",", 
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           FractionBox["1", "Tc"], 
           FractionBox["hort1", "asym\[Mu]"]}], ",", 
          FractionBox["asymscal", 
           RowBox[{"asym\[Mu]", "^", "2"}]]}], "}"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", 
         RowBox[{"-", "1"}]}], "]"}], "]"}], ",", "\"\<Table\>\""}], "]"}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<~/Work/AdSCMTDyn4/figs/figdata7.txt\>\"", ",", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           FractionBox["x", "Tc"], ",", "y"}], "}"}]}], "]"}], "@@@", 
       RowBox[{"\[Psi]list", "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}]}], ",", 
      "\"\<Table\>\""}], "]"}], ";"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.549537459178137*^9, 3.5495374618026047`*^9}, {
  3.549537536291494*^9, 3.549537555438589*^9}}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"OUTPUT", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<~/Work/AdSCMTDyn4/figs/quenchplot_delta.jpg\>\"", ",", 
      "quenchplot\[Delta]"}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<~/Work/AdSCMTDyn4/figs/quenchplot_T.jpg\>\"", ",", "quenchplotT2"}],
      "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<~/Work/AdSCMTDyn4/figs/quenchplot_Tvsdelta.jpg\>\"", ",", 
      "quenchplotTvsdelta"}], "]"}], ";"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.544942834531548*^9, 3.544942930379356*^9}, {
   3.544943127390402*^9, 3.5449431385032063`*^9}, {3.544943296191196*^9, 
   3.5449433029535923`*^9}, 3.545133667624461*^9, 3.5451346656290293`*^9, {
   3.5463264655894737`*^9, 3.546326467998281*^9}, {3.548309370901958*^9, 
   3.548309376805841*^9}, {3.548309416567338*^9, 3.548309420492691*^9}, {
   3.548309518955407*^9, 3.548309521444385*^9}, 3.548405021609619*^9, 
   3.5484051500547743`*^9, {3.548405398848028*^9, 3.548405400441011*^9}, {
   3.548581255260763*^9, 3.5485812599046717`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           FractionBox["1", "Tc"], 
           FractionBox["hort1", "asym\[Mu]"]}], ",", 
          FractionBox["asym\[Rho]", 
           RowBox[{"asym\[Mu]", "^", "3"}]]}], "}"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", 
         RowBox[{"-", "1"}]}], "]"}], "]"}], ",", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Hue", "[", "0", "]"}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           FractionBox["1", "Tc"], 
           RowBox[{"\[Psi]list", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", "2"}], "]"}], "]"}]}], ",", 
          FractionBox[
           RowBox[{"\[Rho]list", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", "2"}], "]"}], "]"}], 
           RowBox[{
            RowBox[{"\[Mu]list", "[", 
             RowBox[{"[", 
              RowBox[{"All", ",", "2"}], "]"}], "]"}], "^", "3"}]]}], "}"}], 
        "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", 
         RowBox[{"-", "1"}]}], "]"}], "]"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"PointSize", "[", "0.015", "]"}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt3", "=", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         FractionBox["1", "Tc"], 
         FractionBox[
          RowBox[{"tempRN", "[", "q", "]"}], "q"]}], ",", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"\[Rho]RN", "[", "q", "]"}], 
          RowBox[{"q", "^", "3"}]]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"q", ",", "0.8", ",", "3.4"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2", ",", "plt3", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.544939494961252*^9, 3.5449395840247*^9}, {
   3.544941185228245*^9, 3.544941280295475*^9}, {3.544941439304017*^9, 
   3.544941447767956*^9}, {3.544958079323764*^9, 3.544958079491789*^9}, 
   3.546325598799754*^9, {3.548063414885769*^9, 3.548063462564125*^9}, {
   3.548581270702758*^9, 3.5485813069808283`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Dynamical figures - final \[Mu]", "Subsubtitle",
 CellChangeTimes->{{3.548580799854521*^9, 3.5485808117421227`*^9}, {
  3.5485821517340317`*^9, 3.548582164914527*^9}, {3.549905129075362*^9, 
  3.549905129586628*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"EndPos", "=", 
    RowBox[{"Round", "[", 
     RowBox[{
      RowBox[{"Length", "[", 
       RowBox[{"tdat", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "]"}], "*", "0.65"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"EndPos2", "=", 
   RowBox[{"Round", "[", 
    RowBox[{"Length", "[", 
     RowBox[{"tdat", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.547485659621134*^9, 3.547485664893497*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"run", "=", "18"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Mu]val", "=", 
    RowBox[{"\[Mu]list", "[", 
     RowBox[{"[", 
      RowBox[{"run", ",", "2"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"boundaryf", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"varr", "[", 
         RowBox[{"[", 
          RowBox[{"run", ",", "pos"}], "]"}], "]"}], ",", 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"Interpolation", "[", 
            RowBox[{"Transpose", "[", 
             RowBox[{"{", 
              RowBox[{"zarr", ",", 
               RowBox[{"fdat", "[", 
                RowBox[{"[", 
                 RowBox[{"run", ",", "pos", ",", "All"}], "]"}], "]"}]}], 
              "}"}], "]"}], "]"}], "'"}], "[", "0", "]"}], 
         RowBox[{"\[Mu]val", "^", "2"}]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"pos", ",", "1", ",", "EndPos"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<run = \>\"", ",", "run", ",", "\"\<  amp2 = \>\"", ",", 
     RowBox[{"-", 
      RowBox[{"amplist", "[", 
       RowBox[{"[", "run", "]"}], "]"}]}]}], "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fitfn", "=", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"l", " ", 
        RowBox[{"(", 
         RowBox[{"t", "-", "t0"}], ")"}]}], "]"}], 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "k"}], " ", "t"}], "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fit", "=", 
    RowBox[{"FindFit", "[", 
     RowBox[{
      RowBox[{"boundaryf", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"Round", "[", 
          RowBox[{
           FractionBox["1", "3"], "*", "EndPos"}], "]"}], ";;", 
         RowBox[{"Round", "[", "EndPos", "]"}]}], "]"}], "]"}], ",", "fitfn", 
      ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", ",", 
          RowBox[{"boundaryf", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "2"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"b", ",", "0.1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "0.7"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"l", ",", "0.8"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t0", ",", "0"}], "}"}]}], "}"}], ",", "t"}], "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"ListPlot", "[", "boundaryf", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"fitfn", "/.", "fit"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "1", ",", "10"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Hue", "[", "0", "]"}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"txt", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"\"\<\[Delta] = \>\"", "<>", 
        RowBox[{"ToString", "[", 
         RowBox[{"-", 
          RowBox[{"amplist", "[", 
           RowBox[{"[", "run", "]"}], "]"}]}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", 
         RowBox[{"Max", "[", 
          RowBox[{"boundaryf", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "2"}], "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"figplt", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"plt1", ",", "plt2", ",", "txt", ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<t\>\"", ",", 
         "\"\<|<O>|/\!\(\*SuperscriptBox[\(\[Mu]\), \(2\)]\)\>\""}], "}"}]}], 
      ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"All", ",", "All"}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "figplt", "]"}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\< -> fit = \>\"", ",", "fit"}], "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Temp (/Tc) = \>\"", ",", 
     RowBox[{"Temp", "=", 
      RowBox[{
       RowBox[{"\[Psi]list", "[", 
        RowBox[{"[", 
         RowBox[{"run", ",", "2"}], "]"}], "]"}], "/", "Tc"}]}], ",", 
     "\"\<  \[Delta]/\[Mu] = \>\"", ",", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"amplist", "[", 
        RowBox[{"[", "run", "]"}], "]"}]}], "/", "\[Mu]val"}]}], "]"}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"decay", "=", 
    RowBox[{"QNMOsc", "[", "Temp", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"osc", "=", 
    RowBox[{"QNMRe", "[", "Temp", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"asymval", "=", 
    RowBox[{"boundaryf", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "2"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<  -> decay, osc, asymval = \>\"", ",", "decay", ",", "\"\<, \>\"", 
     ",", "osc", ",", "\"\< , \>\"", ",", "asymval", ",", "\"\<\\n\\n\>\""}], 
    "]"}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"boundaryf", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"varr", "[", 
            RowBox[{"[", 
             RowBox[{"run", ",", "pos"}], "]"}], "]"}], "-", "2"}], ")"}], 
         "*", "\[Mu]val"}], ",", 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"Interpolation", "[", 
            RowBox[{"Transpose", "[", 
             RowBox[{"{", 
              RowBox[{"zarr", ",", 
               RowBox[{"fdat", "[", 
                RowBox[{"[", 
                 RowBox[{"run", ",", "pos", ",", "All"}], "]"}], "]"}]}], 
              "}"}], "]"}], "]"}], "'"}], "[", "0", "]"}], 
         RowBox[{"\[Mu]val", "^", "2"}]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"pos", ",", "1", ",", "EndPos2"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fitfn", "=", 
    RowBox[{"asymval", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"osc", " ", 
        RowBox[{"(", 
         RowBox[{"t", "-", "t0"}], ")"}]}], "]"}], 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "decay"}], " ", "t"}], "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fit", "=", 
    RowBox[{"FindFit", "[", 
     RowBox[{
      RowBox[{"boundaryf", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"Round", "[", 
          RowBox[{
           FractionBox["1", "3"], "EndPos"}], "]"}], ";;", 
         RowBox[{"Round", "[", "EndPos", "]"}]}], "]"}], "]"}], ",", "fitfn", 
      ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"b", ",", 
          RowBox[{"-", "0.17"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t0", ",", "3.5"}], "}"}]}], "}"}], ",", "t"}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"ListPlot", "[", "boundaryf", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"fitfn", "/.", "fit"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "5", ",", "40"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Hue", "[", "0", "]"}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"txt", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{
         RowBox[{
         "\"\<T < \!\(\*SubscriptBox[\(T\), \(*\)]\)     \[Delta] = \>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{"-", 
            RowBox[{"amplist", "[", 
             RowBox[{"[", "run", "]"}], "]"}]}], "]"}]}], ",", 
         RowBox[{"FontSize", "\[Rule]", "18"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"25", ",", 
         RowBox[{"0.98", 
          RowBox[{"Max", "[", 
           RowBox[{"boundaryf", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", "2"}], "]"}], "]"}], "]"}]}]}], "}"}]}], 
      "]"}], "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"quenchplotOvst", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"plt1", ",", "plt2", ",", "txt", ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\[Mu] t\>\"", ",", 
         "\"\<|<O>|/\!\(\*SuperscriptBox[\(\[Mu]\), \(2\)]\)\>\""}], "}"}]}], 
      ",", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"FontSize", "\[Rule]", "18"}], "]"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"All", ",", "40"}], "}"}], ",", "All"}], "}"}]}]}], "]"}]}],
    ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "quenchplotOvst", "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\< -> fit = \>\"", ",", "fit"}], "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plttmp", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            FractionBox["x", "Tc"], ",", "y"}], "}"}]}], "]"}], "@@", 
        RowBox[{"\[Psi]list", "[", 
         RowBox[{"[", 
          RowBox[{"run", ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*FractionBox[SubscriptBox[\(T\), \(f\)], \
SubscriptBox[\(T\), \(c\)]]\)\>\"", ",", 
         "\"\<|<O\!\(\*SubscriptBox[\(>\), \(f\)]\)|/\!\(\*SuperscriptBox[\(\
\[Mu]\), \(2\)]\)\[InvisibleComma]\>\""}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"PointSize", "[", "0.015", "]"}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           FractionBox["1", "Tc"], 
           FractionBox["hort1", "asym\[Mu]"]}], ",", 
          FractionBox["asymscal", 
           RowBox[{"asym\[Mu]", "^", "2"}]]}], "}"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", 
         RowBox[{"-", "1"}]}], "]"}], "]"}], ",", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Hue", "[", "0", "]"}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plttmp2", "=", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.81", ",", "y"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Dashing", "[", 
         RowBox[{"{", 
          RowBox[{"0.01", ",", "0.01"}], "}"}], "]"}], "}"}]}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"plt", ",", "plttmp2", ",", "plttmp", ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0.5"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<\!\(\*FractionBox[SubscriptBox[\(T\), \(f\)], SubscriptBox[\(T\), \
\(c\)]]\)\>\"", ",", 
       "\"\<|<O\!\(\*SubscriptBox[\(>\), \(f\)]\)|/\!\(\*SuperscriptBox[\(\
\[Mu]\), \(2\)]\)\>\""}], "}"}]}], ",", 
    RowBox[{"AxesOrigin", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"CForm", "[", 
  RowBox[{
   RowBox[{"fitfn", "/.", "fit"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", "x_", "]"}], "\[Rule]", 
      RowBox[{"exp", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"Cos", "[", "x_", "]"}], "\[Rule]", 
      RowBox[{"cos", "[", "x", "]"}]}]}], "}"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.544936848291461*^9, 3.544937021406467*^9}, {
   3.544937304553576*^9, 3.544937691584041*^9}, 3.5449377318394213`*^9, {
   3.544937771278882*^9, 3.5449377996285677`*^9}, {3.544937908503346*^9, 
   3.5449379929989347`*^9}, {3.5449380271089907`*^9, 
   3.5449380857732286`*^9}, {3.544938127549938*^9, 3.544938221246296*^9}, 
   3.5449382589832687`*^9, {3.5449382945814543`*^9, 3.544938397912859*^9}, {
   3.544938430834364*^9, 3.544938503943112*^9}, {3.544938606151692*^9, 
   3.544938609279997*^9}, {3.544938718288323*^9, 3.544938802171164*^9}, {
   3.5449388919358273`*^9, 3.544938896383234*^9}, {3.544938977461822*^9, 
   3.544938979363138*^9}, {3.544940174132766*^9, 3.544940198212538*^9}, {
   3.544940533363143*^9, 3.544940606003181*^9}, {3.544940735355381*^9, 
   3.5449407402497463`*^9}, {3.5449427972278023`*^9, 
   3.5449428167903757`*^9}, {3.5449744414500628`*^9, 3.5449744484937*^9}, {
   3.545133386471233*^9, 3.545133411869952*^9}, 3.5451336989356413`*^9, 
   3.545134680922399*^9, {3.5463250115811253`*^9, 3.546325046615491*^9}, {
   3.5463251061395884`*^9, 3.546325129014317*^9}, {3.546325813828804*^9, 
   3.546325825299838*^9}, {3.546325855684808*^9, 3.5463259004576063`*^9}, {
   3.546326145091032*^9, 3.5463261677848043`*^9}, {3.546326976069386*^9, 
   3.546326988881566*^9}, {3.546327041500339*^9, 3.5463270899766293`*^9}, {
   3.5474826483943233`*^9, 3.547482673156975*^9}, {3.547482806275882*^9, 
   3.54748281037961*^9}, {3.5474828961041193`*^9, 3.547482896497819*^9}, {
   3.547482949984146*^9, 3.547483038348847*^9}, {3.547483172473914*^9, 
   3.547483172970001*^9}, {3.547483977652306*^9, 3.547483996347494*^9}, {
   3.547484153187508*^9, 3.547484180856929*^9}, {3.547484215730803*^9, 
   3.547484216194283*^9}, {3.5474842471770678`*^9, 3.547484339092814*^9}, {
   3.54748437632909*^9, 3.54748440390933*^9}, {3.547484435111659*^9, 
   3.547484442695919*^9}, {3.547484475919044*^9, 3.54748450350534*^9}, {
   3.547484539599859*^9, 3.547484547475049*^9}, {3.547484624079526*^9, 
   3.5474846707285423`*^9}, {3.547484707150975*^9, 3.547484736691194*^9}, {
   3.547484811235588*^9, 3.547484815251421*^9}, {3.5474848649982347`*^9, 
   3.547485031631118*^9}, {3.547485071556024*^9, 3.547485122590734*^9}, 
   3.547485166194747*^9, 3.547485224360722*^9, {3.5474853028865633`*^9, 
   3.547485306126203*^9}, {3.547485346780439*^9, 3.547485381934841*^9}, {
   3.547485679845316*^9, 3.547485705674404*^9}, {3.547485869617684*^9, 
   3.547485869713935*^9}, {3.547532173220029*^9, 3.5475321929085293`*^9}, {
   3.547532922336244*^9, 3.547532923709529*^9}, {3.5475330106412373`*^9, 
   3.547533027373088*^9}, {3.548107716035658*^9, 3.548107809745397*^9}, {
   3.548107872727478*^9, 3.548107939742345*^9}, 3.5483096731725903`*^9, {
   3.548309728590725*^9, 3.548309735215045*^9}, {3.5483098991042547`*^9, 
   3.548309899219246*^9}, {3.5483099476667233`*^9, 3.548310045592876*^9}, {
   3.54839778792918*^9, 3.5483978348947*^9}, {3.548397868738587*^9, 
   3.548397907624153*^9}, {3.548397943793056*^9, 3.548398154362715*^9}, {
   3.548398193316477*^9, 3.548398217792245*^9}, {3.5483983729477787`*^9, 
   3.54839839757838*^9}, {3.548406841960539*^9, 3.54840684342432*^9}, {
   3.548579298421275*^9, 3.548579414368573*^9}, {3.548579491639333*^9, 
   3.548579491862507*^9}, {3.54857966842817*^9, 3.54857967099577*^9}, {
   3.5485797386357317`*^9, 3.548579753105755*^9}, {3.548582173096776*^9, 
   3.548582174126391*^9}, {3.5485822413610487`*^9, 3.5485822823913517`*^9}, {
   3.548582363699355*^9, 3.548582366172765*^9}, {3.548582818661442*^9, 
   3.548582829094322*^9}, {3.549443394259301*^9, 3.549443424354149*^9}, 
   3.549443509711862*^9, {3.549443608105151*^9, 3.5494436373442593`*^9}, {
   3.5494437071838713`*^9, 3.549443722948359*^9}, {3.549505915825801*^9, 
   3.549505915937608*^9}, {3.5495171269231997`*^9, 3.549517127261281*^9}, {
   3.549536993066761*^9, 3.549537018549944*^9}, {3.5499051393060617`*^9, 
   3.549905145086413*^9}, 3.5499051957185793`*^9, 3.549905267324183*^9, {
   3.549905297811572*^9, 3.54990532091929*^9}, {3.5499053666266603`*^9, 
   3.549905400719282*^9}, {3.5499466322241383`*^9, 3.549946632315217*^9}, {
   3.549946736129116*^9, 3.549946750199356*^9}, {3.54996753738435*^9, 
   3.549967556056509*^9}, {3.549967598660719*^9, 3.549967599443755*^9}}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"OUTPUT", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<~/Work/AdSCMTDyn4/figs/quenchplot_Ovst1.jpg\>\"", ",", 
      "quenchplotOvst"}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<~/Work/AdSCMTDyn4/figs/figdata1.txt\>\"", ",", "boundaryf", ",", 
      "\"\<Table\>\""}], "]"}], ";"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.548309692205179*^9, 3.54830974567402*^9}, 
   3.54830977860218*^9, {3.54839823971669*^9, 3.5483982440696507`*^9}, {
   3.5483984033974667`*^9, 3.548398407373201*^9}, {3.548398674038618*^9, 
   3.5483986935900593`*^9}, {3.5483989884603367`*^9, 3.548398991692354*^9}, {
   3.5484068494934387`*^9, 3.548406852116497*^9}, {3.548579769670792*^9, 
   3.548579773134576*^9}, 3.548582339724761*^9, {3.548582448720519*^9, 
   3.548582449208548*^9}, {3.549516995212634*^9, 3.549517005431147*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"run", "=", "38"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Mu]val", "=", 
    RowBox[{"\[Mu]list", "[", 
     RowBox[{"[", 
      RowBox[{"run", ",", "2"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"boundaryf", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"varr", "[", 
         RowBox[{"[", 
          RowBox[{"run", ",", "pos"}], "]"}], "]"}], ",", 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"Interpolation", "[", 
            RowBox[{"Transpose", "[", 
             RowBox[{"{", 
              RowBox[{"zarr", ",", 
               RowBox[{"fdat", "[", 
                RowBox[{"[", 
                 RowBox[{"run", ",", "pos", ",", "All"}], "]"}], "]"}]}], 
              "}"}], "]"}], "]"}], "'"}], "[", "0", "]"}], 
         RowBox[{"\[Mu]val", "^", "2"}]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"pos", ",", "1", ",", "EndPos2"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<run = \>\"", ",", "run", ",", "\"\<  amp2 = \>\"", ",", 
     RowBox[{"-", 
      RowBox[{"amplist", "[", 
       RowBox[{"[", "run", "]"}], "]"}]}]}], "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fitfn", "=", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "k"}], " ", "t"}], "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fit", "=", 
    RowBox[{"FindFit", "[", 
     RowBox[{
      RowBox[{"boundaryf", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"Round", "[", 
          RowBox[{
           FractionBox["2", "3"], "*", "EndPos2"}], "]"}], ";;", 
         RowBox[{"Round", "[", "EndPos2", "]"}]}], "]"}], "]"}], ",", "fitfn",
       ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", ",", 
          RowBox[{"boundaryf", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "2"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"b", ",", "0.1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "1"}], "}"}]}], "}"}], ",", "t"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"ListPlot", "[", "boundaryf", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"fitfn", "/.", "fit"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "1", ",", "20"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Hue", "[", "0", "]"}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"txt", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{
       "\"\<\!\(\*SubscriptBox[\(T\), \(*\)]\) < T < \
\!\(\*SubscriptBox[\(T\), \(c\)]\)   \[Delta] = \>\"", "<>", 
        RowBox[{"ToString", "[", 
         RowBox[{"-", 
          RowBox[{"amplist", "[", 
           RowBox[{"[", "run", "]"}], "]"}]}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", 
         RowBox[{"Max", "[", 
          RowBox[{"boundaryf", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "2"}], "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"figplt", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"plt1", ",", "plt2", ",", "txt", ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<t\>\"", ",", 
         "\"\<|<O>|/\!\(\*SuperscriptBox[\(\[Mu]\), \(2\)]\)\>\""}], "}"}]}], 
      ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"All", ",", "All"}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "figplt", "]"}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\< -> fit = \>\"", ",", "fit"}], "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Temp (/Tc) = \>\"", ",", 
     RowBox[{"Temp", "=", 
      RowBox[{
       RowBox[{"\[Psi]list", "[", 
        RowBox[{"[", 
         RowBox[{"run", ",", "2"}], "]"}], "]"}], "/", "Tc"}]}], ",", 
     "\"\<  \[Delta]/\[Mu] = \>\"", ",", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"amplist", "[", 
        RowBox[{"[", "run", "]"}], "]"}]}], "/", "\[Mu]val"}]}], "]"}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"decay", "=", 
    RowBox[{"QNMDamp", "[", "Temp", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"asymval", "=", 
    RowBox[{"boundaryf", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "2"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<  -> decay, osc, asymval = \>\"", ",", "decay", ",", "\"\<, \>\"", 
     ",", "osc", ",", "\"\< , \>\"", ",", "asymval", ",", "\"\<\\n\\n\>\""}], 
    "]"}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"boundaryf", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"varr", "[", 
            RowBox[{"[", 
             RowBox[{"run", ",", "pos"}], "]"}], "]"}], "-", "2"}], ")"}], 
         "*", "\[Mu]val"}], ",", 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"Interpolation", "[", 
            RowBox[{"Transpose", "[", 
             RowBox[{"{", 
              RowBox[{"zarr", ",", 
               RowBox[{"fdat", "[", 
                RowBox[{"[", 
                 RowBox[{"run", ",", "pos", ",", "All"}], "]"}], "]"}]}], 
              "}"}], "]"}], "]"}], "'"}], "[", "0", "]"}], 
         RowBox[{"\[Mu]val", "^", "2"}]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"pos", ",", "1", ",", "EndPos2"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fitfn", "=", 
    RowBox[{"asymval", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "decay"}], " ", "t"}], "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fit", "=", 
    RowBox[{"FindFit", "[", 
     RowBox[{
      RowBox[{"boundaryf", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"Round", "[", 
          RowBox[{
           FractionBox["1", "3"], "EndPos"}], "]"}], ";;", 
         RowBox[{"Round", "[", "EndPos", "]"}]}], "]"}], "]"}], ",", "fitfn", 
      ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"b", ",", 
         RowBox[{"-", "0.17"}]}], "}"}], "}"}], ",", "t"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"ListPlot", "[", "boundaryf", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"fitfn", "/.", "fit"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "5", ",", "40"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Hue", "[", "0", "]"}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"txt", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(T\), \(*\)]\) < T < \!\(\*SubscriptBox[\(T\
\), \(c\)]\)   \[Delta] = \>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{"-", 
            RowBox[{"amplist", "[", 
             RowBox[{"[", "run", "]"}], "]"}]}], "]"}]}], ",", 
         RowBox[{"FontSize", "\[Rule]", "18"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"25", ",", 
         RowBox[{"0.9", 
          RowBox[{"Max", "[", 
           RowBox[{"boundaryf", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", "2"}], "]"}], "]"}], "]"}]}]}], "}"}]}], 
      "]"}], "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"quenchplotOvst", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"plt1", ",", "plt2", ",", "txt", ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\[Mu] t\>\"", ",", 
         "\"\<|<O>|/\!\(\*SuperscriptBox[\(\[Mu]\), \(2\)]\)\>\""}], "}"}]}], 
      ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"All", ",", "40"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0.5"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"FontSize", "\[Rule]", "18"}], "]"}]}], ",", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "quenchplotOvst", "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\< -> fit = \>\"", ",", "fit"}], "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plttmp", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            FractionBox["x", "Tc"], ",", "y"}], "}"}]}], "]"}], "@@", 
        RowBox[{"\[Psi]list", "[", 
         RowBox[{"[", 
          RowBox[{"run", ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*FractionBox[SubscriptBox[\(T\), \(f\)], \
SubscriptBox[\(T\), \(c\)]]\)\>\"", ",", 
         "\"\<|<O\!\(\*SubscriptBox[\(>\), \(f\)]\)|/\!\(\*SuperscriptBox[\(\
\[Mu]\), \(2\)]\)\[InvisibleComma]\>\""}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"PointSize", "[", "0.015", "]"}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           FractionBox["1", "Tc"], 
           FractionBox["hort1", "asym\[Mu]"]}], ",", 
          FractionBox["asymscal", 
           RowBox[{"asym\[Mu]", "^", "2"}]]}], "}"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", 
         RowBox[{"-", "1"}]}], "]"}], "]"}], ",", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Hue", "[", "0", "]"}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plttmp2", "=", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.8", ",", "y"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Dashing", "[", 
         RowBox[{"{", 
          RowBox[{"0.01", ",", "0.01"}], "}"}], "]"}], "}"}]}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"plt", ",", "plttmp2", ",", "plttmp", ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0.5"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<\!\(\*FractionBox[SubscriptBox[\(T\), \(f\)], SubscriptBox[\(T\), \
\(c\)]]\)\>\"", ",", 
       "\"\<|<O\!\(\*SubscriptBox[\(>\), \(f\)]\)|/\!\(\*SuperscriptBox[\(\
\[Mu]\), \(2\)]\)\>\""}], "}"}]}], ",", 
    RowBox[{"AxesOrigin", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"CForm", "[", 
  RowBox[{
   RowBox[{"fitfn", "/.", "fit"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", "x_", "]"}], "\[Rule]", 
      RowBox[{"exp", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"Cos", "[", "x_", "]"}], "\[Rule]", 
      RowBox[{"cos", "[", "x", "]"}]}]}], "}"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.544936848291461*^9, 3.544937021406467*^9}, {
   3.544937304553576*^9, 3.544937691584041*^9}, 3.5449377318394213`*^9, {
   3.544937771278882*^9, 3.5449377996285677`*^9}, {3.544937908503346*^9, 
   3.5449379929989347`*^9}, {3.5449380271089907`*^9, 
   3.5449380857732286`*^9}, {3.544938127549938*^9, 3.544938221246296*^9}, 
   3.5449382589832687`*^9, {3.5449382945814543`*^9, 3.544938397912859*^9}, {
   3.544938430834364*^9, 3.544938503943112*^9}, {3.544938606151692*^9, 
   3.544938609279997*^9}, {3.544938718288323*^9, 3.544938802171164*^9}, {
   3.5449388919358273`*^9, 3.544938896383234*^9}, {3.544938977461822*^9, 
   3.544938979363138*^9}, {3.544940174132766*^9, 3.544940198212538*^9}, {
   3.544940533363143*^9, 3.544940606003181*^9}, {3.544940735355381*^9, 
   3.5449407402497463`*^9}, {3.5449427972278023`*^9, 
   3.5449428167903757`*^9}, {3.5449744414500628`*^9, 3.5449744484937*^9}, {
   3.545133386471233*^9, 3.545133411869952*^9}, 3.5451336989356413`*^9, 
   3.545134680922399*^9, {3.5463250115811253`*^9, 3.546325046615491*^9}, {
   3.5463251061395884`*^9, 3.546325129014317*^9}, {3.546325813828804*^9, 
   3.546325825299838*^9}, {3.546325855684808*^9, 3.5463259004576063`*^9}, {
   3.546326145091032*^9, 3.5463261677848043`*^9}, {3.546326976069386*^9, 
   3.546326988881566*^9}, {3.546327041500339*^9, 3.5463270899766293`*^9}, {
   3.5474826483943233`*^9, 3.547482673156975*^9}, {3.547482806275882*^9, 
   3.54748281037961*^9}, {3.5474828961041193`*^9, 3.547482896497819*^9}, {
   3.547482949984146*^9, 3.547483038348847*^9}, {3.547483172473914*^9, 
   3.547483172970001*^9}, {3.547483977652306*^9, 3.547483996347494*^9}, {
   3.547484153187508*^9, 3.547484180856929*^9}, {3.547484215730803*^9, 
   3.547484216194283*^9}, {3.5474842471770678`*^9, 3.547484339092814*^9}, {
   3.54748437632909*^9, 3.54748440390933*^9}, {3.547484435111659*^9, 
   3.547484442695919*^9}, {3.547484475919044*^9, 3.54748450350534*^9}, {
   3.547484539599859*^9, 3.547484547475049*^9}, {3.547484624079526*^9, 
   3.5474846707285423`*^9}, {3.547484707150975*^9, 3.547484736691194*^9}, {
   3.547484811235588*^9, 3.547484815251421*^9}, {3.5474848649982347`*^9, 
   3.547485031631118*^9}, {3.547485071556024*^9, 3.547485122590734*^9}, 
   3.547485166194747*^9, 3.547485224360722*^9, {3.5474853028865633`*^9, 
   3.547485306126203*^9}, {3.547485346780439*^9, 3.5474854771856413`*^9}, {
   3.547485716747055*^9, 3.547485727225531*^9}, {3.547485833734025*^9, 
   3.547485833813645*^9}, {3.547486154356531*^9, 3.5474862022079353`*^9}, {
   3.547532141226663*^9, 3.547532143475094*^9}, {3.54810815269619*^9, 
   3.548108255742517*^9}, {3.548108395298585*^9, 3.548108396776271*^9}, 
   3.548309667829475*^9, {3.548309756509492*^9, 3.548309760349256*^9}, {
   3.548398262464838*^9, 3.548398294065289*^9}, {3.5483984346646843`*^9, 
   3.5483984598728724`*^9}, {3.548398582837555*^9, 3.548398627845725*^9}, {
   3.548406856214567*^9, 3.548406857503107*^9}, {3.548406927060706*^9, 
   3.5484069284420223`*^9}, {3.548579779415326*^9, 3.5485798794041862`*^9}, {
   3.548580171680125*^9, 3.548580171767952*^9}, {3.548582385388748*^9, 
   3.548582388111471*^9}, {3.5485827726875896`*^9, 3.548582798866806*^9}, {
   3.549443455878339*^9, 3.549443462232823*^9}, 3.54944350454428*^9, {
   3.5494435977832127`*^9, 3.5494435979112988`*^9}, {3.5494436507337627`*^9, 
   3.549443690371729*^9}, {3.549443737240169*^9, 3.549443739184127*^9}, {
   3.549505904255782*^9, 3.549505904504346*^9}, {3.549517047014805*^9, 
   3.5495171038024693`*^9}, 3.549537034001513*^9, {3.5499051525313263`*^9, 
   3.5499051574297657`*^9}, 3.549905289372435*^9, {3.549905418928738*^9, 
   3.549905457590323*^9}, {3.549905491974289*^9, 3.5499055097459707`*^9}, {
   3.549906611534639*^9, 3.549906631889084*^9}, {3.549946647385664*^9, 
   3.549946664320897*^9}, {3.549946718741954*^9, 3.549946718986442*^9}, {
   3.549967567973158*^9, 3.54996757995654*^9}}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"OUTPUT", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<~/Work/AdSCMTDyn4/figs/quenchplot_Ovst2.jpg\>\"", ",", 
      "quenchplotOvst"}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<~/Work/AdSCMTDyn4/figs/figdata2.txt\>\"", ",", "boundaryf", ",", 
      "\"\<Table\>\""}], "]"}], ";"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.548309792690009*^9, 3.548309795074026*^9}, {
  3.5483984787557983`*^9, 3.548398484938795*^9}, {3.548398669494684*^9, 
  3.548398687758388*^9}, {3.548398996300137*^9, 3.5483989982450867`*^9}, {
  3.54840686366026*^9, 3.548406865900359*^9}, {3.548406933242816*^9, 
  3.548406934707575*^9}, {3.548579886124084*^9, 3.548579890219895*^9}, {
  3.549517013399925*^9, 3.549517017039796*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"run", "=", "61"}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "\[Mu]val", " ", "determined", " ", "from", " ", "charge", " ", "for", " ",
     "RN", " ", 
    RowBox[{"solution", "!!"}]}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Mu]val", "=", 
    RowBox[{"\[Mu]list", "[", 
     RowBox[{"[", 
      RowBox[{"run", ",", "2"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"boundaryf", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"varr", "[", 
         RowBox[{"[", 
          RowBox[{"run", ",", "pos"}], "]"}], "]"}], ",", 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"Interpolation", "[", 
            RowBox[{"Transpose", "[", 
             RowBox[{"{", 
              RowBox[{"zarr", ",", 
               RowBox[{"fdat", "[", 
                RowBox[{"[", 
                 RowBox[{"run", ",", "pos", ",", "All"}], "]"}], "]"}]}], 
              "}"}], "]"}], "]"}], "'"}], "[", "0", "]"}], 
         RowBox[{"\[Mu]val", "^", "2"}]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"pos", ",", "1", ",", "EndPos"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<run = \>\"", ",", "run", ",", "\"\<  amp2 = \>\"", ",", 
     RowBox[{"-", 
      RowBox[{"amplist", "[", 
       RowBox[{"[", "run", "]"}], "]"}]}]}], "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fitfn", "=", 
    RowBox[{"b", " ", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "k"}], " ", "t"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fit", "=", 
    RowBox[{"FindFit", "[", 
     RowBox[{
      RowBox[{"boundaryf", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"Round", "[", 
          RowBox[{
           FractionBox["1", "2"], "*", "EndPos"}], "]"}], ";;", 
         RowBox[{"Round", "[", "EndPos", "]"}]}], "]"}], "]"}], ",", "fitfn", 
      ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"b", ",", "0.1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "1"}], "}"}]}], "}"}], ",", "t"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{"boundaryf", ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"fitfn", "/.", "fit"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "1", ",", "20"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Hue", "[", "0", "]"}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"txt", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"\"\<\[Delta] = \>\"", "<>", 
        RowBox[{"ToString", "[", 
         RowBox[{"-", 
          RowBox[{"amplist", "[", 
           RowBox[{"[", "run", "]"}], "]"}]}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", 
         RowBox[{"Max", "[", 
          RowBox[{"boundaryf", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "2"}], "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"figplt", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"plt1", ",", "plt2", ",", "txt", ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<t\>\"", ",", 
         "\"\<|<O>|/\!\(\*SuperscriptBox[\(\[Mu]\), \(2\)]\)\>\""}], "}"}]}], 
      ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"All", ",", "All"}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "figplt", "]"}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\< -> fit = \>\"", ",", "fit"}], "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Temp (/Tc) = \>\"", ",", 
     RowBox[{"Temp", "=", 
      RowBox[{
       RowBox[{"\[Psi]list", "[", 
        RowBox[{"[", 
         RowBox[{"run", ",", "2"}], "]"}], "]"}], "/", "Tc"}]}], ",", 
     "\"\<  \[Delta]/\[Mu] = \>\"", ",", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"amplist", "[", 
        RowBox[{"[", "run", "]"}], "]"}]}], "/", "\[Mu]val"}]}], "]"}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"decay", "=", 
    RowBox[{"QNMQuench", "[", "Temp", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<  -> decay = \>\"", ",", "decay", ",", "\"\<\\n\\n\>\""}], 
    "]"}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"boundaryf", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"varr", "[", 
            RowBox[{"[", 
             RowBox[{"run", ",", "pos"}], "]"}], "]"}], "-", "2"}], ")"}], 
         "*", "\[Mu]val"}], ",", 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"Interpolation", "[", 
            RowBox[{"Transpose", "[", 
             RowBox[{"{", 
              RowBox[{"zarr", ",", 
               RowBox[{"fdat", "[", 
                RowBox[{"[", 
                 RowBox[{"run", ",", "pos", ",", "All"}], "]"}], "]"}]}], 
              "}"}], "]"}], "]"}], "'"}], "[", "0", "]"}], 
         RowBox[{"\[Mu]val", "^", "2"}]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"pos", ",", "1", ",", "EndPos2"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fitfn", "=", 
    RowBox[{"b", " ", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "decay"}], " ", "t"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fit", "=", 
    RowBox[{"FindFit", "[", 
     RowBox[{
      RowBox[{"boundaryf", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"Round", "[", 
          RowBox[{
           FractionBox["1", "3"], "EndPos"}], "]"}], ";;", 
         RowBox[{"Round", "[", "EndPos", "]"}]}], "]"}], "]"}], ",", "fitfn", 
      ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"b", ",", 
         RowBox[{"-", "0.17"}]}], "}"}], "}"}], ",", "t"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt1", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{"boundaryf", ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"fitfn", "/.", "fit"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "5", ",", "40"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Hue", "[", "0", "]"}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"txt", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{
         RowBox[{
         "\"\<\!\(\*SubscriptBox[\(T\), \(c\)]\) < T     \[Delta] = \>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{"-", 
            RowBox[{"amplist", "[", 
             RowBox[{"[", "run", "]"}], "]"}]}], "]"}]}], ",", 
         RowBox[{"FontSize", "\[Rule]", "18"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"25", ",", 
         RowBox[{"0.8", 
          RowBox[{"Max", "[", 
           RowBox[{"boundaryf", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", "2"}], "]"}], "]"}], "]"}]}]}], "}"}]}], 
      "]"}], "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"quenchplotOvst", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"plt1", ",", "plt2", ",", "txt", ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\[Mu] t\>\"", ",", 
         "\"\<|<O>|/\!\(\*SuperscriptBox[\(\[Mu]\), \(2\)]\)\>\""}], "}"}]}], 
      ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"All", ",", "40"}], "}"}], ",", "All"}], "}"}]}], ",", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"FontSize", "\[Rule]", "18"}], "]"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "quenchplotOvst", "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\< -> fit = \>\"", ",", "fit"}], "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plttmp", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            FractionBox["x", "Tc"], ",", "y"}], "}"}]}], "]"}], "@@", 
        RowBox[{"\[Psi]list", "[", 
         RowBox[{"[", 
          RowBox[{"run", ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*FractionBox[SubscriptBox[\(T\), \(f\)], \
SubscriptBox[\(T\), \(c\)]]\)\>\"", ",", 
         "\"\<|<O\!\(\*SubscriptBox[\(>\), \(f\)]\)|/\!\(\*SuperscriptBox[\(\
\[Mu]\), \(2\)]\)\[InvisibleComma]\>\""}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"PointSize", "[", "0.015", "]"}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           FractionBox["1", "Tc"], 
           FractionBox["hort1", "asym\[Mu]"]}], ",", 
          FractionBox["asymscal", 
           RowBox[{"asym\[Mu]", "^", "2"}]]}], "}"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ";;", 
         RowBox[{"-", "1"}]}], "]"}], "]"}], ",", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Hue", "[", "0", "]"}], "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plttmp2", "=", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.8", ",", "y"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Dashing", "[", 
         RowBox[{"{", 
          RowBox[{"0.01", ",", "0.01"}], "}"}], "]"}], "}"}]}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"plt", ",", "plttmp2", ",", "plttmp", ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.01"}], ",", "0.5"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<\!\(\*FractionBox[SubscriptBox[\(T\), \(f\)], SubscriptBox[\(T\), \
\(c\)]]\)\>\"", ",", 
       "\"\<|<O\!\(\*SubscriptBox[\(>\), \(f\)]\)|/\!\(\*SuperscriptBox[\(\
\[Mu]\), \(2\)]\)\>\""}], "}"}]}], ",", 
    RowBox[{"AxesOrigin", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"CForm", "[", 
  RowBox[{
   RowBox[{"fitfn", "/.", "fit"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", "x_", "]"}], "\[Rule]", 
      RowBox[{"exp", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"Cos", "[", "x_", "]"}], "\[Rule]", 
      RowBox[{"cos", "[", "x", "]"}]}]}], "}"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.544936848291461*^9, 3.544937021406467*^9}, {
   3.544937304553576*^9, 3.544937691584041*^9}, 3.5449377318394213`*^9, {
   3.544937771278882*^9, 3.5449377996285677`*^9}, {3.544937908503346*^9, 
   3.5449379929989347`*^9}, {3.5449380271089907`*^9, 
   3.5449380857732286`*^9}, {3.544938127549938*^9, 3.544938221246296*^9}, 
   3.5449382589832687`*^9, {3.5449382945814543`*^9, 3.544938397912859*^9}, {
   3.544938430834364*^9, 3.544938503943112*^9}, {3.544938606151692*^9, 
   3.544938609279997*^9}, {3.544938718288323*^9, 3.544938802171164*^9}, {
   3.5449388919358273`*^9, 3.544938896383234*^9}, {3.544938977461822*^9, 
   3.544938979363138*^9}, {3.544940174132766*^9, 3.544940198212538*^9}, {
   3.544940533363143*^9, 3.544940606003181*^9}, {3.544940735355381*^9, 
   3.5449407402497463`*^9}, {3.5449427972278023`*^9, 
   3.5449428167903757`*^9}, {3.5449744414500628`*^9, 3.5449744484937*^9}, {
   3.545133386471233*^9, 3.545133411869952*^9}, 3.5451336989356413`*^9, 
   3.545134680922399*^9, {3.5463250115811253`*^9, 3.546325046615491*^9}, {
   3.5463251061395884`*^9, 3.546325129014317*^9}, {3.546325813828804*^9, 
   3.546325825299838*^9}, {3.546325855684808*^9, 3.5463259004576063`*^9}, {
   3.546326145091032*^9, 3.5463261677848043`*^9}, {3.546326976069386*^9, 
   3.546326988881566*^9}, {3.546327041500339*^9, 3.5463270899766293`*^9}, {
   3.5474826483943233`*^9, 3.547482673156975*^9}, {3.547482806275882*^9, 
   3.54748281037961*^9}, {3.5474828961041193`*^9, 3.547482896497819*^9}, {
   3.547482949984146*^9, 3.547483038348847*^9}, {3.547483172473914*^9, 
   3.547483172970001*^9}, {3.547483977652306*^9, 3.547483996347494*^9}, {
   3.547484153187508*^9, 3.547484180856929*^9}, {3.547484215730803*^9, 
   3.547484216194283*^9}, {3.5474842471770678`*^9, 3.547484339092814*^9}, {
   3.54748437632909*^9, 3.54748440390933*^9}, {3.547484435111659*^9, 
   3.547484442695919*^9}, {3.547484475919044*^9, 3.54748450350534*^9}, {
   3.547484539599859*^9, 3.547484547475049*^9}, {3.547484624079526*^9, 
   3.5474846707285423`*^9}, {3.547484707150975*^9, 3.547484736691194*^9}, {
   3.547484811235588*^9, 3.547484815251421*^9}, {3.5474848649982347`*^9, 
   3.547485031631118*^9}, {3.547485071556024*^9, 3.547485122590734*^9}, 
   3.547485166194747*^9, 3.547485224360722*^9, {3.5474853028865633`*^9, 
   3.547485306126203*^9}, {3.547485346780439*^9, 3.5474854771856413`*^9}, {
   3.5474855264494257`*^9, 3.547485540472034*^9}, {3.547485753133864*^9, 
   3.547485794225959*^9}, {3.547486242763658*^9, 3.547486309592772*^9}, {
   3.547486477464699*^9, 3.547486481453341*^9}, {3.5474865672599173`*^9, 
   3.5474865673763437`*^9}, {3.547486674501272*^9, 3.547486684787087*^9}, {
   3.547486736657618*^9, 3.547486753992478*^9}, {3.54748679843888*^9, 
   3.547486840271871*^9}, {3.5474869148103867`*^9, 3.547486942758349*^9}, 
   3.547486980504993*^9, {3.547487037507815*^9, 3.547487037655882*^9}, 
   3.547487095644691*^9, {3.54748724861931*^9, 3.547487248831293*^9}, {
   3.547489030232368*^9, 3.547489095200231*^9}, {3.547530013073132*^9, 
   3.547530014185749*^9}, {3.547531889980318*^9, 3.54753196249135*^9}, {
   3.547531996865737*^9, 3.5475320294450502`*^9}, {3.547532065688562*^9, 
   3.5475321139406652`*^9}, {3.548108270530408*^9, 3.548108366314497*^9}, {
   3.54810842625907*^9, 3.548108444421207*^9}, 3.548309658611165*^9, {
   3.5483097664150248`*^9, 3.5483097693819447`*^9}, {3.548398496566667*^9, 
   3.5483985587420893`*^9}, {3.548398644331143*^9, 3.5483986524504347`*^9}, {
   3.548406869622139*^9, 3.548406871072301*^9}, {3.548406911831195*^9, 
   3.5484069131504707`*^9}, {3.548579893907915*^9, 3.548579984086335*^9}, {
   3.5485800225540123`*^9, 3.548580023369701*^9}, {3.548580164820024*^9, 
   3.548580164961975*^9}, {3.548582396077992*^9, 3.548582424027884*^9}, {
   3.549443476635725*^9, 3.54944349114011*^9}, {3.549443586871173*^9, 
   3.549443586990237*^9}, {3.549443675377179*^9, 3.5494436982755117`*^9}, {
   3.549443746967564*^9, 3.5494437481912813`*^9}, {3.549505894672875*^9, 
   3.5495058947705183`*^9}, {3.549517113426159*^9, 3.549517114562524*^9}, 
   3.5495370448851423`*^9, {3.5499051637225933`*^9, 3.5499051681773653`*^9}, {
   3.549905519364214*^9, 3.549905536972725*^9}, {3.5499055705359488`*^9, 
   3.549905587071629*^9}, {3.549946685052466*^9, 3.549946703469841*^9}, {
   3.549967613021468*^9, 3.549967627915636*^9}}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"OUTPUT", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<~/Work/AdSCMTDyn4/figs/quenchplot_Ovst3.jpg\>\"", ",", 
      "quenchplotOvst"}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{
     "\"\<~/Work/AdSCMTDyn4/figs/figdata3.txt\>\"", ",", "boundaryf", ",", 
      "\"\<Table\>\""}], "]"}], ";"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.548309801377833*^9, 3.548309804042121*^9}, {
   3.5483986617588882`*^9, 3.548398683295289*^9}, {3.548399002875886*^9, 
   3.548399005425995*^9}, {3.548406875803855*^9, 3.5484068785077553`*^9}, {
   3.548406916723206*^9, 3.5484069185869303`*^9}, {3.548580058401428*^9, 
   3.548580059280458*^9}, 3.5485826980962048`*^9, {3.5495170231776657`*^9, 
   3.5495170261697273`*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1192, 892},
WindowMargins->{{Automatic, -241}, {Automatic, 7}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 211, 8, 171, "Subtitle"],
Cell[793, 32, 388, 7, 27, "Input"],
Cell[1184, 41, 925, 14, 27, "Input"],
Cell[CellGroupData[{
Cell[2134, 59, 100, 1, 26, "Subsubtitle"],
Cell[2237, 62, 479, 13, 58, "Input"],
Cell[2719, 77, 1736, 49, 178, "Input"],
Cell[4458, 128, 470, 13, 27, "Input"],
Cell[4931, 143, 137, 2, 27, "Input"],
Cell[5071, 147, 4947, 137, 253, "Input"],
Cell[10021, 286, 1804, 53, 238, "Input"],
Cell[11828, 341, 5180, 144, 253, "Input"],
Cell[17011, 487, 3550, 93, 159, "Input"],
Cell[20564, 582, 2009, 54, 43, "Input"],
Cell[22576, 638, 410, 8, 27, "Input"],
Cell[22989, 648, 601, 15, 27, "Input"],
Cell[23593, 665, 1756, 48, 73, "Input"],
Cell[25352, 715, 1980, 46, 103, "Input"],
Cell[27335, 763, 506, 11, 58, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[27878, 779, 102, 1, 26, "Subsubtitle"],
Cell[27983, 782, 41207, 905, 3478, "Input"],
Cell[69193, 1689, 8744, 190, 703, "Input"],
Cell[77940, 1881, 62874, 1262, 3778, "Input"],
Cell[140817, 3145, 7041, 124, 557, "Input"],
Cell[147861, 3271, 3029, 86, 208, "Input"],
Cell[150893, 3359, 842, 24, 139, "Input"],
Cell[151738, 3385, 818, 24, 49, "Input"],
Cell[152559, 3411, 138, 3, 27, "Input"],
Cell[152700, 3416, 1114, 32, 112, "Input"],
Cell[153817, 3450, 915, 25, 49, "Input"],
Cell[154735, 3477, 190, 4, 27, "Input"],
Cell[154928, 3483, 1263, 34, 112, "Input"],
Cell[156194, 3519, 596, 18, 49, "Input"],
Cell[156793, 3539, 2041, 55, 136, "Input"],
Cell[158837, 3596, 621, 16, 49, "Input"],
Cell[159461, 3614, 4222, 115, 244, "Input"],
Cell[163686, 3731, 4384, 120, 237, "Input"],
Cell[168073, 3853, 2080, 61, 159, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[170190, 3919, 103, 1, 26, "Subsubtitle"],
Cell[170296, 3922, 566, 12, 27, "Input"],
Cell[170865, 3936, 6128, 160, 675, "Input"],
Cell[176996, 4098, 14198, 331, 1266, "Input"],
Cell[191197, 4431, 128, 2, 27, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[191362, 4438, 203, 3, 26, "Subsubtitle"],
Cell[191568, 4443, 778, 23, 166, "Input"],
Cell[192349, 4468, 6211, 156, 317, "Input"],
Cell[198563, 4626, 837, 22, 102, "Input"],
Cell[199403, 4650, 5608, 150, 287, "Input"],
Cell[205014, 4802, 1103, 30, 102, "Input"],
Cell[206120, 4834, 1536, 35, 75, "Input"],
Cell[207659, 4871, 5630, 152, 317, "Input"],
Cell[213292, 5025, 1401, 38, 137, "Input"],
Cell[214696, 5065, 1225, 25, 88, "Input"],
Cell[215924, 5092, 2790, 79, 191, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[218751, 5176, 222, 3, 26, "Subsubtitle"],
Cell[218976, 5181, 548, 16, 58, "Input"],
Cell[219527, 5199, 18520, 483, 1240, "Input"],
Cell[238050, 5684, 1007, 20, 73, "Input"],
Cell[239060, 5706, 17661, 464, 1215, "Input"],
Cell[256724, 6172, 904, 19, 73, "Input"],
Cell[257631, 6193, 17691, 456, 1209, "Input"],
Cell[275325, 6651, 894, 19, 73, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
