(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    122347,       3331]
NotebookOptionsPosition[    118476,       3223]
NotebookOutlinePosition[    118831,       3239]
CellTagsIndexPosition[    118788,       3236]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Single analysis", "Subtitle",
 CellChangeTimes->{{3.54427213185037*^9, 3.544272144801621*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", "\"\<~/Work/AdSCMTDyn4/C/test/\>\"", "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.544249620731719*^9, 3.5442496296828117`*^9}, {
  3.544435547687385*^9, 3.544435570714677*^9}, {3.544435689768095*^9, 
  3.544435690989039*^9}, {3.544435987954439*^9, 3.54443603731295*^9}, {
  3.5444360740980577`*^9, 3.5444360742327433`*^9}, {3.5444371183631287`*^9, 
  3.54443711885909*^9}, {3.5444373455772667`*^9, 3.5444373457442427`*^9}, {
  3.5444597878972054`*^9, 3.544459787955711*^9}, {3.544461980719421*^9, 
  3.544461981157084*^9}, {3.5444620570832787`*^9, 3.5444620572017527`*^9}, {
  3.544462221654078*^9, 3.5444622220776167`*^9}, {3.544506907679791*^9, 
  3.5445069079363213`*^9}, {3.544507074583951*^9, 3.544507074919623*^9}, {
  3.544507297824565*^9, 3.544507297968317*^9}, {3.5448908212523127`*^9, 
  3.544890821355631*^9}, {3.548054860643013*^9, 3.5480548608422213`*^9}, {
  3.549689644788163*^9, 3.549689645081114*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"param", "=", 
    RowBox[{"Import", "[", 
     RowBox[{"\"\<param.dat\>\"", ",", "\"\<Real64\>\""}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"data", "=", 
    RowBox[{"Import", "[", 
     RowBox[{"\"\<output.dat\>\"", ",", "\"\<Real64\>\""}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"geodata", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<geo.dat\>\"", ",", "\"\<Real64\>\""}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.544249633815199*^9, 3.544249656358367*^9}, {
  3.54426115396392*^9, 3.54426115789116*^9}, {3.548055133097349*^9, 
  3.548055137599826*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Nz", "=", 
   RowBox[{"Round", "[", 
    RowBox[{"param", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aval", "=", 
   RowBox[{"param", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zarr", "=", 
   RowBox[{"param", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", "+", "1"}], ";;", 
      RowBox[{"2", "+", "Nz"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"Partition", "[", 
     RowBox[{
      RowBox[{"param", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "+", "Nz"}], ")"}], "+", "1"}], ";;", 
         RowBox[{"-", "1"}]}], "]"}], "]"}], ",", "3"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"amplist", "=", 
   RowBox[{"tmp", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"sizelist", "=", 
  RowBox[{"Round", "[", 
   RowBox[{"tmp", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "3"}], "]"}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.544249909424734*^9, 3.544249937894285*^9}, {
   3.544250143442418*^9, 3.544250166410213*^9}, 3.544250631147397*^9, {
   3.544252414987821*^9, 3.544252415283758*^9}, {3.544261162213182*^9, 
   3.544261164237224*^9}, {3.54426135018777*^9, 3.544261398042145*^9}, {
   3.544261660073123*^9, 3.544261663392272*^9}, {3.544264643931826*^9, 
   3.5442646753100233`*^9}, {3.544266744571554*^9, 3.544266748617033*^9}}],

Cell[BoxData[
 RowBox[{"size", "=", 
  RowBox[{"Floor", "[", 
   RowBox[{
    RowBox[{"Length", "[", "data", "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"2", "+", 
      RowBox[{"13", "Nz"}]}], ")"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5442724391246243`*^9, 3.544272461406993*^9}, {
   3.544286060300911*^9, 3.54428606037925*^9}, 3.544780605229023*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"data", "[", 
      RowBox[{"[", 
       RowBox[{"1", ";;", 
        RowBox[{"-", "1"}]}], "]"}], "]"}], ",", 
     RowBox[{"(", 
      RowBox[{"2", "+", 
       RowBox[{"13", "*", "Nz"}]}], ")"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.544265027772296*^9, 3.5442650316110067`*^9}, {
   3.544286062011446*^9, 3.544286062156925*^9}, 3.544780608573022*^9}],

Cell[BoxData[
 RowBox[{"Dimensions", "[", "data2", "]"}]], "Input",
 CellChangeTimes->{{3.5442650343341837`*^9, 3.5442650371861267`*^9}}],

Cell[BoxData[
 RowBox[{"Floor", "[", 
  RowBox[{
   RowBox[{"Length", "[", "geodata", "]"}], "/", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"3", "Nz"}]}], ")"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5442724391246243`*^9, 3.544272461406993*^9}, {
   3.544286060300911*^9, 3.54428606037925*^9}, 3.544780605229023*^9, {
   3.548055157336234*^9, 3.548055163263048*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"geodata2", "=", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"geodata", "[", 
      RowBox[{"[", 
       RowBox[{"1", ";;", 
        RowBox[{"-", "1"}]}], "]"}], "]"}], ",", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"3", "*", "Nz"}]}], ")"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.544265027772296*^9, 3.5442650316110067`*^9}, {
   3.544286062011446*^9, 3.544286062156925*^9}, 3.544780608573022*^9, {
   3.54805516764705*^9, 3.54805517838256*^9}}],

Cell[BoxData[
 RowBox[{"Dimensions", "[", "geodata2", "]"}]], "Input",
 CellChangeTimes->{{3.5442650343341837`*^9, 3.5442650371861267`*^9}, 
   3.5480551815042048`*^9, 3.54805538063878*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"varr", "=", 
    RowBox[{"data2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "1"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Mu]arr", "=", 
    RowBox[{"data2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "2"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fdat", "=", 
    RowBox[{"data2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{
        RowBox[{"2", "+", "1"}], ";;", 
        RowBox[{"2", "+", "Nz"}]}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hdat", "=", 
    RowBox[{"data2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{
        RowBox[{"2", "+", "Nz", "+", "1"}], ";;", 
        RowBox[{"2", "+", 
         RowBox[{"2", "Nz"}]}]}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"adat", "=", 
    RowBox[{"data2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{
        RowBox[{"2", "+", 
         RowBox[{"2", "Nz"}], "+", "1"}], ";;", 
        RowBox[{"2", "+", 
         RowBox[{"3", "Nz"}]}]}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tdat", "=", 
    RowBox[{"data2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{
        RowBox[{"2", "+", 
         RowBox[{"3", "Nz"}], "+", "1"}], ";;", 
        RowBox[{"2", "+", 
         RowBox[{"4", "Nz"}]}]}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sdat", "=", 
    RowBox[{"data2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{
        RowBox[{"2", "+", 
         RowBox[{"4", "Nz"}], "+", "1"}], ";;", 
        RowBox[{"2", "+", 
         RowBox[{"5", "Nz"}]}]}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Psi]dat", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"fdat", "^", "2"}], "+", 
     RowBox[{"hdat", "^", "2"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5442721840563507`*^9, 3.544272253424959*^9}, {
  3.544272369283926*^9, 3.544272381483509*^9}, {3.5447805312979593`*^9, 
  3.544780553008657*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eq1", "=", 
    RowBox[{"data2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{
        RowBox[{"2", "+", 
         RowBox[{"5", "Nz"}], "+", "1"}], ";;", 
        RowBox[{"2", "+", 
         RowBox[{"6", "Nz"}]}]}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eq2", "=", 
    RowBox[{"data2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{
        RowBox[{"2", "+", 
         RowBox[{"6", "Nz"}], "+", "1"}], ";;", 
        RowBox[{"2", "+", 
         RowBox[{"7", "Nz"}]}]}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eq3", "=", 
    RowBox[{"data2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{
        RowBox[{"2", "+", 
         RowBox[{"7", "Nz"}], "+", "1"}], ";;", 
        RowBox[{"2", "+", 
         RowBox[{"8", "Nz"}]}]}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eq4", "=", 
    RowBox[{"data2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{
        RowBox[{"2", "+", 
         RowBox[{"8", "Nz"}], "+", "1"}], ";;", 
        RowBox[{"2", "+", 
         RowBox[{"9", "Nz"}]}]}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eq5", "=", 
    RowBox[{"data2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{
        RowBox[{"2", "+", 
         RowBox[{"9", "Nz"}], "+", "1"}], ";;", 
        RowBox[{"2", "+", 
         RowBox[{"10", "Nz"}]}]}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"const1", "=", 
    RowBox[{"data2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{
        RowBox[{"2", "+", 
         RowBox[{"10", "Nz"}], "+", "1"}], ";;", 
        RowBox[{"2", "+", 
         RowBox[{"11", "Nz"}]}]}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"const2", "=", 
    RowBox[{"data2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{
        RowBox[{"2", "+", 
         RowBox[{"11", "Nz"}], "+", "1"}], ";;", 
        RowBox[{"2", "+", 
         RowBox[{"12", "Nz"}]}]}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"const3", "=", 
   RowBox[{"data2", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", 
      RowBox[{
       RowBox[{"2", "+", 
        RowBox[{"12", "Nz"}], "+", "1"}], ";;", 
       RowBox[{"2", "+", 
        RowBox[{"13", "Nz"}]}]}]}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.544286081602502*^9, 3.544286129930849*^9}, {
  3.544780558374906*^9, 3.544780573680916*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tdat2", "=", 
    RowBox[{"geodata2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{
        RowBox[{"1", "+", "1"}], ";;", 
        RowBox[{"1", "+", "Nz"}]}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tzdat2", "=", 
    RowBox[{"geodata2", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       RowBox[{
        RowBox[{"1", "+", "Nz", "+", "1"}], ";;", 
        RowBox[{"1", "+", 
         RowBox[{"2", "Nz"}]}]}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tvdat2", "=", 
   RowBox[{"geodata2", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", 
      RowBox[{
       RowBox[{"1", "+", 
        RowBox[{"2", "Nz"}], "+", "1"}], ";;", 
       RowBox[{"1", "+", 
        RowBox[{"3", "Nz"}]}]}]}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.548055406782138*^9, 3.548055442029106*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Export", "[", 
    RowBox[{
    "\"\<~/Work/AdSCMTDyn2/figs/psievolution_pos10.jpg\>\"", ",", "plt"}], 
    "]"}], "*)"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.544425566996078*^9, 3.544425652263814*^9}, {
  3.5444257709465*^9, 3.5444257838339148`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"solfit", "=", 
   RowBox[{"FindFit", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"varr", ",", 
         FractionBox[
          RowBox[{"\[Psi]dat", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "2"}], "]"}], "]"}], 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "2", "]"}], "]"}]]}], "}"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"Round", "[", 
         RowBox[{"size", "/", "2"}], "]"}], ";;", "size"}], "]"}], "]"}], ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{"-", "k"}], " ", "t"}], "]"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "k"}], "}"}], ",", "t"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"scalarfinal", "=", 
  RowBox[{"a", "/.", "solfit"}]}]}], "Input",
 CellChangeTimes->{{3.544435821406659*^9, 3.54443587962794*^9}}],

Cell[BoxData[
 RowBox[{"rhofinal", "=", 
  FractionBox[
   RowBox[{"tdat", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "2"}], "]"}], "]"}], 
   RowBox[{"zarr", "[", 
    RowBox[{"[", "2", "]"}], "]"}]]}]], "Input",
 CellChangeTimes->{{3.544435946301601*^9, 3.54443595605868*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmpfn", "=", 
    RowBox[{"Interpolation", "[", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"zarr", ",", 
        RowBox[{"1", "+", 
         RowBox[{
          RowBox[{"zarr", "^", "2"}], "*", 
          RowBox[{"tdat", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "All"}], "]"}], "]"}]}]}]}], "}"}], 
      "]"}], "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"tmpfn", "[", "z", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"solh", "=", 
    RowBox[{"FindRoot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpfn", "[", "z", "]"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"horiz", "=", 
   RowBox[{"z", "/.", "solh"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"temp", "=", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{
     RowBox[{"tmpfn", "'"}], "[", "z", "]"}]}], "/.", "solh"}]}]}], "Input",
 CellChangeTimes->{{3.5444357756400423`*^9, 3.544435780915472*^9}, {
  3.544435885398581*^9, 3.5444358879043503`*^9}, {3.544512292346345*^9, 
  3.5445123412738733`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Nz", ",", "aval", ",", "scalarfinal", ",", "horiz", ",", "rhofinal"}], 
  "}"}]], "Input",
 CellChangeTimes->{{3.5444358916989822`*^9, 3.544435905131508*^9}, {
  3.544435963426516*^9, 3.5444359851457157`*^9}}],

Cell[BoxData[
 RowBox[{"plt", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"varr", ",", "\[Mu]arr"}], "}"}], "]"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<v\>\"", ",", "\"\<\[Mu]\>\""}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.544780646036179*^9, 3.5447806481480837`*^9}, {
  3.544788826051283*^9, 3.544788826266304*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Mu]boundary", "=", 
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"varr", ",", "\[Mu]arr"}], "}"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fboundary", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"varr", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"Interpolation", "[", 
           RowBox[{"Transpose", "[", 
            RowBox[{"{", 
             RowBox[{"zarr", ",", 
              RowBox[{"fdat", "[", 
               RowBox[{"[", 
                RowBox[{"ii", ",", "All"}], "]"}], "]"}]}], "}"}], "]"}], 
           "]"}], "'"}], "[", "0", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "varr", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hboundary", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"varr", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"Interpolation", "[", 
           RowBox[{"Transpose", "[", 
            RowBox[{"{", 
             RowBox[{"zarr", ",", 
              RowBox[{"hdat", "[", 
               RowBox[{"[", 
                RowBox[{"ii", ",", "All"}], "]"}], "]"}]}], "}"}], "]"}], 
           "]"}], "'"}], "[", "0", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "varr", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"aboundary", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"varr", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"Interpolation", "[", 
           RowBox[{"Transpose", "[", 
            RowBox[{"{", 
             RowBox[{"zarr", ",", 
              RowBox[{"adat", "[", 
               RowBox[{"[", 
                RowBox[{"ii", ",", "All"}], "]"}], "]"}]}], "}"}], "]"}], 
           "]"}], "'"}], "[", "0", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "varr", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{"fboundary", ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{"hboundary", ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"aboundary", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.544787360133041*^9, 3.544787409208097*^9}, {
  3.544788926425774*^9, 3.544788938444278*^9}, {3.544804390732342*^9, 
  3.544804403149317*^9}, {3.544804440469006*^9, 3.5448044422588663`*^9}, {
  3.5448045664050903`*^9, 3.544804569821814*^9}, {3.549709946925117*^9, 
  3.549709960329073*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]fn", "[", "x_", "]"}], ":=", 
  FractionBox[
   RowBox[{
    RowBox[{"Interpolation", "[", "fboundary", "]"}], "[", "x", "]"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Interpolation", "[", "\[Mu]boundary", "]"}], "[", "x", "]"}], 
     ")"}], "^", "2"}]]}]], "Input",
 CellChangeTimes->{{3.5448045816400213`*^9, 3.544804633482654*^9}, {
  3.549709854867222*^9, 3.549709860668097*^9}, {3.549709901369066*^9, 
  3.549709911290333*^9}, {3.549709968169529*^9, 3.549709968711198*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"\[Psi]fn", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"Min", "[", "varr", "]"}], ",", 
     RowBox[{"Max", "[", "varr", "]"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5448044622910137`*^9, 3.544804489015725*^9}, {
  3.544804530513311*^9, 3.544804545770091*^9}, {3.544804626532361*^9, 
  3.5448046368359137`*^9}, {3.544804704428176*^9, 3.5448047103316927`*^9}, {
  3.544890868730145*^9, 3.54489086908169*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"varr", ",", 
       RowBox[{"adat", "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "2"}], "]"}], "]"}]}], "}"}], "]"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<v\>\"", ",", "\"\<<a>\>\""}], "}"}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"varr", ",", 
       FractionBox[
        RowBox[{"tdat", "[", 
         RowBox[{"[", 
          RowBox[{"All", ",", "2"}], "]"}], "]"}], 
        RowBox[{"zarr", "[", 
         RowBox[{"[", "2", "]"}], "]"}]]}], "}"}], "]"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<v\>\"", ",", "\"\<<\[Rho]>\>\""}], "}"}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"varr", ",", 
      FractionBox[
       RowBox[{"sdat", "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "2"}], "]"}], "]"}], 
       RowBox[{
        RowBox[{"zarr", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "^", "2"}]]}], "}"}], "]"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<v\>\"", ",", "\"\<<P>\>\""}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.544267085486063*^9, 3.544267142082458*^9}, {
   3.544267255753426*^9, 3.544267279936776*^9}, {3.5442674915298367`*^9, 
   3.544267572829974*^9}, {3.544268545882472*^9, 3.5442685694641027`*^9}, {
   3.544269667167377*^9, 3.544269686606105*^9}, 3.544271078850075*^9, {
   3.5442722618201933`*^9, 3.5442722918907967`*^9}, {3.5443458651060867`*^9, 
   3.5443458898718224`*^9}, {3.54435573466862*^9, 3.5443557458271303`*^9}, {
   3.544425563775131*^9, 3.544425564148943*^9}, {3.544508023172616*^9, 
   3.544508023781629*^9}, {3.544890889195553*^9, 3.544890889531776*^9}}],

Cell[CellGroupData[{

Cell["Load", "Section",
 CellChangeTimes->{{3.544508687636112*^9, 3.5445087090959663`*^9}, {
  3.544892277742435*^9, 3.544892279613476*^9}, {3.548057642465873*^9, 
  3.548057644960784*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"veclist", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.868`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.07409605574209051`", ",", "2.120168551991567`", ",", 
         "0.9979641465626632`", ",", 
         RowBox[{"-", "0.13206619699953426`"}], ",", "0.1096803066408052`", 
         ",", "1.8798507183251827`", ",", 
         RowBox[{"-", "1.8883455741980362`"}], ",", 
         RowBox[{"-", "1.8849422184581242`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8630000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.10094946961325645`", ",", "2.11843896557585`", ",", 
         "0.996221622879231`", ",", 
         RowBox[{"-", "0.1804917165177124`"}], ",", "0.1492701497125977`", 
         ",", "1.884992279481818`", ",", 
         RowBox[{"-", "1.9007800178918746`"}], ",", 
         RowBox[{"-", "1.8930351877297216`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.858`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.12197000170131408`", ",", "2.1167233983193694`", ",", 
         "0.9944850339762491`", ",", 
         RowBox[{"-", "0.21876327909130314`"}], ",", "0.1801886009746716`", 
         ",", "1.8900978504268293`", ",", 
         RowBox[{"-", "1.9131742069140136`"}], ",", 
         RowBox[{"-", "1.9016726924990976`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8530000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.13991378424453033`", ",", "2.1149837348926606`", ",", 
         "0.9927440162648846`", ",", 
         RowBox[{"-", "0.2517293820681301`"}], ",", "0.20648020601257608`", 
         ",", "1.8952275889273653`", ",", 
         RowBox[{"-", "1.9256311591239745`"}], ",", 
         RowBox[{"-", "1.909808191488722`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.848`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.1558346013771002`", ",", "2.113225412671581`", ",", 
         "0.9910000469003952`", ",", 
         RowBox[{"-", "0.28124731545350495`"}], ",", "0.22972733575964316`", 
         ",", "1.900372935353736`", ",", 
         RowBox[{"-", "1.9381362448249575`"}], ",", 
         RowBox[{"-", "1.9180104248625407`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8430000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.17016875000194848`", ",", "2.1115098780778703`", ",", 
         "0.9892697750637398`", ",", 
         RowBox[{"-", "0.3080592423512553`"}], ",", "0.2506153749130479`", 
         ",", "1.9054371593492085`", ",", 
         RowBox[{"-", "1.9505236948034614`"}], ",", 
         RowBox[{"-", "1.9261627936566683`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.84`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.17826167507411272`", ",", "2.1104559051192573`", ",", 
         "0.9882259326796118`", ",", 
         RowBox[{"-", "0.32330581600520547`"}], ",", "0.26236779856342607`", 
         ",", "1.9085078859494449`", ",", 
         RowBox[{"-", "1.9580215612745053`"}], ",", 
         RowBox[{"-", "1.931121256897245`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.82`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.22488694197749054`", ",", "2.103380714521802`", ",", 
         "0.9812728968525489`", ",", 
         RowBox[{"-", "0.41286781222427793`"}], ",", "0.3296044742182707`", 
         ",", "1.9289306281682954`", ",", 
         RowBox[{"-", "2.008120303091178`"}], ",", 
         RowBox[{"-", "1.9650601848404534`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.8`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.263403558765456`", ",", "2.096205608174961`", ",", 
         "0.9743256730333851`", ",", 
         RowBox[{"-", "0.48939211154605033`"}], ",", "0.3843975474769295`", 
         ",", "1.9492937907951573`", ",", 
         RowBox[{"-", "2.05845848599753`"}], ",", 
         RowBox[{"-", "1.9995561358962997`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.78`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.29697518455095745`", ",", "2.0889423128476263`", ",", 
         "0.9673869185290676`", ",", 
         RowBox[{"-", "0.558279652709024`"}], ",", "0.4315291947985173`", ",",
          "1.9695814694547868`", ",", 
         RowBox[{"-", "2.1090091196394116`"}], ",", 
         RowBox[{"-", "2.0352685093571585`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.76`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.3271598204456268`", ",", "2.081567124294121`", ",", 
         "0.9604497669481518`", ",", 
         RowBox[{"-", "0.6221486306454592`"}], ",", "0.47328486423405836`", 
         ",", "1.9898325723528631`", ",", 
         RowBox[{"-", "2.1598388644472086`"}], ",", 
         RowBox[{"-", "2.071552595488018`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.7200000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.3805021914087528`", ",", "2.066514870321669`", ",", 
         "0.9465874464830879`", ",", 
         RowBox[{"-", "0.7400039977668367`"}], ",", "0.5455047926770815`", 
         ",", "2.0301803808864767`", ",", 
         RowBox[{"-", "2.2622601874863317`"}], ",", 
         RowBox[{"-", "2.1473061767619304`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.7000000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.4046128853375105`", ",", "2.0588198731087877`", ",", 
         "0.9396565452523309`", ",", 
         RowBox[{"-", "0.795537154126863`"}], ",", "0.5773661902403812`", ",",
          "2.0503081121045224`", ",", 
         RowBox[{"-", "2.3139052814335432`"}], ",", 
         RowBox[{"-", "2.186433658947585`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.6800000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.42738986570203724`", ",", "2.0510415737040817`", ",", 
         "0.932732941463491`", ",", 
         RowBox[{"-", "0.8493817405747806`"}], ",", "0.607017515193857`", ",",
          "2.070362854344421`", ",", 
         RowBox[{"-", "2.3657698062065`"}], ",", 
         RowBox[{"-", "2.226488748803607`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.6600000000000001`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.4490644897242795`", ",", "2.0431503052332096`", ",", 
         "0.9258082749841597`", ",", 
         RowBox[{"-", "0.9019290716600774`"}], ",", "0.6347851658005186`", 
         ",", "2.090391510684943`", ",", 
         RowBox[{"-", "2.4179342410329308`"}], ",", 
         RowBox[{"-", "2.2678968345073445`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.62`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.48966127102623513`", ",", "2.0270829673417428`", ",", 
         "0.9119680934315914`", ",", 
         RowBox[{"-", "1.0038852676290009`"}], ",", "0.6855185237246182`", 
         ",", "2.13029486109991`", ",", 
         RowBox[{"-", "2.5230393049728153`"}], ",", 
         RowBox[{"-", "2.3528071117321376`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.6`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5088314372895092`", ",", "2.018878236095998`", ",", 
         "0.9050440626366997`", ",", 
         RowBox[{"-", "1.0536960221886291`"}], ",", "0.7088332820279133`", 
         ",", "2.1502152257033487`", ",", 
         RowBox[{"-", "2.5760592963152127`"}], ",", 
         RowBox[{"-", "2.3967672740185004`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.58`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5273545275263245`", ",", "2.010575258529651`", ",", 
         "0.8981208966176263`", ",", 
         RowBox[{"-", "1.1028793495786011`"}], ",", "0.7309985511711032`", 
         ",", "2.170093522850811`", ",", 
         RowBox[{"-", "2.6293577550798335`"}], ",", 
         RowBox[{"-", "2.442127737440482`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.56`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5453077255774209`", ",", "2.0021626572013895`", ",", 
         "0.8911951179108348`", ",", 
         RowBox[{"-", "1.1515364877849836`"}], ",", "0.7520675842519604`", 
         ",", "2.189947276035549`", ",", 
         RowBox[{"-", "2.682965705949222`"}], ",", 
         RowBox[{"-", "2.4880947291761606`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.52`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5797281594432059`", ",", "1.9850115064241494`", ",", 
         "0.8773345210374353`", ",", 
         RowBox[{"-", "1.2476078725156199`"}], ",", "0.7913395670399445`", 
         ",", "2.229582003315571`", ",", 
         RowBox[{"-", "2.791119378501514`"}], ",", 
         RowBox[{"-", "2.5830794221371645`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.5`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.5962865178030728`", ",", "1.9762766204423838`", ",", 
         "0.8703996350381962`", ",", 
         RowBox[{"-", "1.2951477748864133`"}], ",", "0.8097010177996378`", 
         ",", "2.2493599143445286`", ",", 
         RowBox[{"-", "2.845665400722957`"}], ",", 
         RowBox[{"-", "2.6321062777511957`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.48`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.6124714214301092`", ",", "1.9674207398689028`", ",", 
         "0.8634571985828617`", ",", 
         RowBox[{"-", "1.3424501191023754`"}], ",", "0.8272732318349333`", 
         ",", "2.2691341396915985`", ",", 
         RowBox[{"-", "2.9005642737031407`"}], ",", 
         RowBox[{"-", "2.6822204172706203`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.44`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.6438209671286115`", ",", "1.9493940340092228`", ",", 
         "0.849559994780463`", ",", 
         RowBox[{"-", "1.4364446858730455`"}], ",", "0.8603685854903844`", 
         ",", "2.308605812587862`", ",", 
         RowBox[{"-", "3.011326105997462`"}], ",", 
         RowBox[{"-", "2.7860539537726856`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.4200000000000002`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.6590456785721874`", ",", "1.9402159607617797`", ",", 
         "0.8426022906426062`", ",", 
         RowBox[{"-", "1.4832140488394734`"}], ",", "0.8759550669907962`", 
         ",", "2.328315490980453`", ",", 
         RowBox[{"-", "3.067216233533839`"}], ",", 
         RowBox[{"-", "2.839376372487654`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.3800000000000001`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.6887287617582241`", ",", "1.9215013977136444`", ",", 
         "0.8286586577921988`", ",", 
         RowBox[{"-", "1.5764938761555642`"}], ",", "0.9053719458902377`", 
         ",", "2.367726088123225`", ",", 
         RowBox[{"-", "3.1801001723213007`"}], ",", 
         RowBox[{"-", "2.9494204405805933`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.36`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.7032264406191593`", ",", "1.911966636481573`", ",", 
         "0.8216720594144495`", ",", 
         RowBox[{"-", "1.6230575588931981`"}], ",", "0.9192800184979449`", 
         ",", "2.3874262771487995`", ",", 
         RowBox[{"-", "3.2371024942745943`"}], ",", 
         RowBox[{"-", "3.0061441868231955`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.34`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.7175184633466903`", ",", "1.9023140363077047`", ",", 
         "0.8146750132812847`", ",", 
         RowBox[{"-", "1.6695961776918746`"}], ",", "0.9326989945280368`", 
         ",", "2.4071224483050213`", ",", 
         RowBox[{"-", "3.2944823760345705`"}], ",", 
         RowBox[{"-", "3.0640137430428847`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.32`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.7316236278236997`", ",", "1.892538357642916`", ",", 
         "0.8076656225360733`", ",", 
         RowBox[{"-", "1.716138544533985`"}], ",", "0.9456473034737107`", ",",
          "2.4268225920081994`", ",", 
         RowBox[{"-", "3.352257372105316`"}], ",", 
         RowBox[{"-", "3.1230544109686846`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.28`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.759327630044047`", ",", "1.8726252884090915`", ",", 
         "0.7936093988176277`", ",", 
         RowBox[{"-", "1.8092946252978641`"}], ",", "0.9702715256209089`", 
         ",", "2.4662250249723754`", ",", 
         RowBox[{"-", "3.468998672177377`"}], ",", 
         RowBox[{"-", "3.244691808425779`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.23`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.793157516173759`", ",", "1.8470221833116771`", ",", 
         "0.7759543195536678`", ",", 
         RowBox[{"-", "1.926084168284337`"}], ",", "0.9988649230120109`", ",",
          "2.5155298343116375`", ",", 
         RowBox[{"-", "3.6172923759074913`"}], ",", 
         RowBox[{"-", "3.403639782925374`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.18`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.8262833012364006`", ",", "1.8205837200802935`", ",", 
         "0.7581849149437223`", ",", 
         RowBox[{"-", "2.043517834789346`"}], ",", "1.0252809707518953`", ",",
          "2.564951928019079`", ",", 
         RowBox[{"-", "3.768399956744153`"}], ",", 
         RowBox[{"-", "3.5705963723620657`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.03`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.9230488688213225`", ",", "1.73588609398436`", ",", 
         "0.7039940643249193`", ",", 
         RowBox[{"-", "2.4019805149276023`"}], ",", "1.0942543883857436`", 
         ",", "2.7143508760863733`", ",", 
         RowBox[{"-", "4.240489973931262`"}], ",", 
         RowBox[{"-", "4.123436603974003`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.98`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.9549279981238569`", ",", "1.7056750601798654`", ",", 
         "0.6855521428817635`", ",", 
         RowBox[{"-", "2.5242985092271657`"}], ",", "1.114555308899134`", ",",
          "2.7647280495543316`", ",", 
         RowBox[{"-", "4.404914229188696`"}], ",", 
         RowBox[{"-", "4.326628213569345`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.9299999999999999`", ",", 
       RowBox[{"{", 
        RowBox[{
        "0.986857615616634`", ",", "1.6743550719995128`", ",", 
         "0.6668700888623107`", ",", 
         RowBox[{"-", "2.6484410797834674`"}], ",", "1.1338173625182217`", 
         ",", "2.815515897460275`", ",", 
         RowBox[{"-", "4.573359485184544`"}], ",", 
         RowBox[{"-", "4.540306961248853`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.88`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.0189782070091018`", ",", "1.6418495888986004`", ",", 
         "0.6479144619747503`", ",", 
         RowBox[{"-", "2.7746598884801315`"}], ",", "1.1522566054543582`", 
         ",", "2.8667820124242054`", ",", 
         RowBox[{"-", "4.746155719065648`"}], ",", 
         RowBox[{"-", "4.76514244154874`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.8300000000000001`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.0514363539949725`", ",", "1.6080712188475348`", ",", 
         "0.6286476155983801`", ",", 
         RowBox[{"-", "2.903241545154152`"}], ",", "1.1701212378997488`", ",",
          "2.9185998862859255`", ",", 
         RowBox[{"-", "4.923682903219094`"}], ",", 
         RowBox[{"-", "5.002008900278566`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.78`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.0844010454097461`", ",", "1.572887661093316`", ",", 
         "0.6090193365955197`", ",", 
         RowBox[{"-", "3.034504887082299`"}], ",", "1.1875031258439983`", ",",
          "2.971090532668834`", ",", 
         RowBox[{"-", "5.106421449956452`"}], ",", 
         RowBox[{"-", "5.251811873544956`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.73`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.1180479966266779`", ",", "1.5361730163991627`", ",", 
         "0.588978613592471`", ",", 
         RowBox[{"-", "3.1688120759508878`"}], ",", "1.2046503944973106`", 
         ",", "3.024353579034675`", ",", 
         RowBox[{"-", "5.294886464737035`"}], ",", 
         RowBox[{"-", "5.515627155864887`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.6799999999999999`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.1525837188902464`", ",", "1.4977570080308695`", ",", 
         "0.568461058774028`", ",", 
         RowBox[{"-", "3.306576091782493`"}], ",", "1.2217108459212238`", ",",
          "3.078528825897698`", ",", 
         RowBox[{"-", "5.489706657652221`"}], ",", 
         RowBox[{"-", "5.794792774146105`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.63`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.1882418065099052`", ",", "1.4574526479500487`", ",", 
         "0.5473946051470174`", ",", 
         RowBox[{"-", "3.44828153950453`"}], ",", "1.2389675741800101`", ",", 
         "3.1337571079417206`", ",", 
         RowBox[{"-", "5.69160646740515`"}], ",", 
         RowBox[{"-", "6.091006264154231`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.58`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.225305531795742`", ",", "1.415017305618747`", ",", 
         "0.5256894636474833`", ",", 
         RowBox[{"-", "3.5945070249561994`"}], ",", "1.2566285813178981`", 
         ",", "3.190224734457376`", ",", 
         RowBox[{"-", "5.901477288136015`"}], ",", 
         RowBox[{"-", "6.406073534076588`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.53`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.2641202878210855`", ",", "1.3701532912838383`", ",", 
         "0.5032367592682069`", ",", 
         RowBox[{"-", "3.745944023702552`"}], ",", "1.2749492456089138`", ",",
          "3.2481515787097424`", ",", 
         RowBox[{"-", "6.12039536605819`"}], ",", 
         RowBox[{"-", "6.742346946394514`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.48`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.3051173605423914`", ",", "1.3224924070876931`", ",", 
         "0.47990281899507703`", ",", 
         RowBox[{"-", "3.903453166116109`"}], ",", "1.2942804705700126`", ",",
          "3.3078010338537096`", ",", 
         RowBox[{"-", "6.3496994746537645`"}], ",", 
         RowBox[{"-", "7.102722008787847`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.42999999999999994`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.3488591460162878`", ",", "1.271548393431121`", ",", 
         "0.4555152710323542`", ",", 
         RowBox[{"-", "4.0681096407769`"}], ",", "1.3149514902873514`", ",", 
         "3.3695179164521227`", ",", 
         RowBox[{"-", "6.591085402958407`"}], ",", 
         RowBox[{"-", "7.490873737285019`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.38`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.3960957591064582`", ",", "1.216685753047732`", ",", 
         "0.42985107157498326`", ",", 
         RowBox[{"-", "4.241312742141526`"}], ",", "1.337427292084789`", ",", 
         "3.4337399590177204`", ",", 
         RowBox[{"-", "6.84675801294185`"}], ",", 
         RowBox[{"-", "7.911597762080053`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.32999999999999996`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.447873230106782`", ",", "1.1570340351583543`", ",", 
         "0.4026093032641672`", ",", 
         RowBox[{"-", "4.4249325467136185`"}], ",", "1.3622900283129145`", 
         ",", "3.501054633931335`", ",", 
         RowBox[{"-", "7.119675995248774`"}], ",", 
         RowBox[{"-", "8.371305919012228`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.28`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.5057236960045268`", ",", "1.0913518674675085`", ",", 
         "0.373367196787542`", ",", 
         RowBox[{"-", "4.621576053138501`"}], ",", "1.390318997704208`", ",", 
         "3.572281474924267`", ",", 
         RowBox[{"-", "7.413971974028285`"}], ",", 
         RowBox[{"-", "8.878975020794677`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.22999999999999998`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.57203980735116`", ",", "1.0177678673734798`", ",", 
         "0.34149736181382523`", ",", 
         RowBox[{"-", "4.835076798074535`"}], ",", "1.4226214179605465`", ",",
          "3.6486273990264926`", ",", 
         RowBox[{"-", "7.735734242987447`"}], ",", 
         RowBox[{"-", "9.44782848881641`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.07999999999999985`", ",", 
       RowBox[{"{", 
        RowBox[{
        "1.8892842980600542`", ",", "0.7021647764329307`", ",", 
         "0.21477094825370602`", ",", 
         RowBox[{"-", "5.668698911077289`"}], ",", "1.571068461292025`", ",", 
         "3.937321470523456`", ",", 
         RowBox[{"-", "9.011955267383346`"}], ",", 
         RowBox[{"-", "11.838448294690265`"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.030000000000000027`", ",", 
       RowBox[{"{", 
        RowBox[{
        "2.14505629502275`", ",", "0.5002442116584971`", ",", 
         "0.14210334806045316`", ",", 
         RowBox[{"-", "6.127329861034945`"}], ",", "1.6695931030439755`", ",",
          "4.090153831975672`", ",", 
         RowBox[{"-", "9.72589898707181`"}], ",", 
         RowBox[{"-", "13.263510038735388`"}]}], "}"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.543993657871076*^9, 3.543993663845245*^9}, {
  3.543993852715075*^9, 3.54399385931518*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"hort1", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"veclist", "[", 
       RowBox[{"[", 
        RowBox[{"ii", ",", "2", ",", "2"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "veclist", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"asymscalre", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"veclist", "[", 
       RowBox[{"[", 
        RowBox[{"ii", ",", "2", ",", "4"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "veclist", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"asymscalim", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"veclist", "[", 
       RowBox[{"[", 
        RowBox[{"ii", ",", "2", ",", "5"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "veclist", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"asymscal", "=", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"asymscalre", "^", "2"}], "+", 
      RowBox[{"asymscalim", "^", "2"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"asym\[Mu]", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"veclist", "[", 
       RowBox[{"[", 
        RowBox[{"ii", ",", "2", ",", "6"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "veclist", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"asymq", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"veclist", "[", 
       RowBox[{"[", 
        RowBox[{"ii", ",", "2", ",", "7"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", 
        RowBox[{"Length", "[", "veclist", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"asym\[Rho]", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"veclist", "[", 
      RowBox[{"[", 
       RowBox[{"ii", ",", "2", ",", "8"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ii", ",", "1", ",", 
       RowBox[{"Length", "[", "veclist", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.54385840855757*^9, 3.543858478411048*^9}, {
  3.5438629561121693`*^9, 3.543862967887542*^9}, {3.5438667569267807`*^9, 
  3.543866769631545*^9}, {3.543993923118877*^9, 3.543993930541388*^9}, {
  3.544418567406822*^9, 3.544418572688039*^9}, {3.54442344203242*^9, 
  3.54442345380746*^9}, {3.544503790725836*^9, 3.544503795868767*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Compare to equilibrium", "Section",
 CellChangeTimes->{{3.544508687636112*^9, 3.54450872500736*^9}}],

Cell[BoxData[
 RowBox[{"Length", "[", "tdat", "]"}]], "Input",
 CellChangeTimes->{{3.544789639707897*^9, 3.544789643951127*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"poscalc", "=", 
   RowBox[{"-", "1"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.544789602807448*^9, 3.544789610951926*^9}, {
  3.544789646255394*^9, 3.5447896761025553`*^9}, {3.544790023350255*^9, 
  3.544790023742097*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Tfn", "=", 
    RowBox[{"Interpolation", "[", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"zarr", ",", 
        RowBox[{"tdat", "[", 
         RowBox[{"[", 
          RowBox[{"poscalc", ",", "All"}], "]"}], "]"}]}], "}"}], "]"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"afn", "=", 
    RowBox[{"Interpolation", "[", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"zarr", ",", 
        RowBox[{"adat", "[", 
         RowBox[{"[", 
          RowBox[{"poscalc", ",", "All"}], "]"}], "]"}]}], "}"}], "]"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ffn", "=", 
    RowBox[{"Interpolation", "[", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"zarr", ",", 
        RowBox[{"fdat", "[", 
         RowBox[{"[", 
          RowBox[{"poscalc", ",", "All"}], "]"}], "]"}]}], "}"}], "]"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hfn", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"zarr", ",", 
       RowBox[{"hdat", "[", 
        RowBox[{"[", 
         RowBox[{"poscalc", ",", "All"}], "]"}], "]"}]}], "}"}], "]"}], 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.544508753288253*^9, 3.544508755631455*^9}, {
  3.544511950827201*^9, 3.5445119569475594`*^9}, {3.544789614137649*^9, 
  3.5447896212741623`*^9}}],

Cell[BoxData[
 RowBox[{"\[Psi]val", "=", 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ffn", "'"}], "[", "0", "]"}], "^", "2"}], "+", 
    RowBox[{
     RowBox[{
      RowBox[{"hfn", "'"}], "[", "0", "]"}], "^", "2"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.544511928510941*^9, 3.544511929970373*^9}, {
  3.544511961713673*^9, 3.544511969978005*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"hfn", "'"}], "[", "0", "]"}]], "Input",
 CellChangeTimes->{{3.5447896297771063`*^9, 3.544789632191317*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Mu]val", "=", 
   RowBox[{"\[Mu]arr", "[", 
    RowBox[{"[", "poscalc", "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5446212374916983`*^9, 3.544621249192658*^9}, {
   3.544789203401483*^9, 3.544789205235156*^9}, {3.544789246416588*^9, 
   3.544789259936138*^9}, 3.544789625234049*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"plt1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["asym\[Rho]", 
         RowBox[{"asym\[Mu]", "^", "3"}]], ",", 
        FractionBox["asymscal", 
         RowBox[{"asym\[Mu]", "^", "2"}]]}], "}"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ";;", 
       RowBox[{"-", "15"}]}], "]"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plt2", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"Tfn", "'"}], "[", "0", "]"}], 
          RowBox[{"\[Mu]val", "^", "3"}]], ",", 
         FractionBox["\[Psi]val", 
          RowBox[{"\[Mu]val", "^", "2"}]]}], "}"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.54450396954886*^9, 3.54450397015753*^9}, {
   3.54450400691886*^9, 3.5445040473402243`*^9}, {3.544504078545775*^9, 
   3.5445040983215113`*^9}, {3.544504174830225*^9, 3.544504182656066*^9}, {
   3.5445118943893013`*^9, 3.544511917356346*^9}, 3.54451198268474*^9, {
   3.5446212086401176`*^9, 3.544621209471713*^9}, {3.544892112347378*^9, 
   3.544892155548527*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"plt1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"asym\[Mu]", ",", 
        FractionBox["asymscal", 
         RowBox[{"asym\[Mu]", "^", "2"}]]}], "}"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ";;", 
       RowBox[{"-", "15"}]}], "]"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plt2", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[Mu]val", "*", "horiz"}], ",", 
         FractionBox["\[Psi]val", 
          RowBox[{"\[Mu]val", "^", "2"}]]}], "}"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.54450396954886*^9, 3.54450397015753*^9}, {
  3.54450400691886*^9, 3.5445040473402243`*^9}, {3.544504078545775*^9, 
  3.5445040983215113`*^9}, {3.544504174830225*^9, 3.544504182656066*^9}, {
  3.5445043966711407`*^9, 3.544504407578034*^9}, {3.54450595783915*^9, 
  3.5445059624872*^9}, {3.544506347956093*^9, 3.544506403466036*^9}, {
  3.544512000253228*^9, 3.544512029971548*^9}, {3.544621212591342*^9, 
  3.544621213567589*^9}, {3.544892225971506*^9, 3.544892228881425*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"plt1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"asym\[Mu]", ",", 
        FractionBox["asym\[Rho]", 
         RowBox[{"asym\[Mu]", "^", "3"}]]}], "}"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ";;", 
       RowBox[{"-", "15"}]}], "]"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plt2", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[Mu]val", "*", "horiz"}], ",", 
         FractionBox[
          RowBox[{
           RowBox[{"Tfn", "'"}], "[", "0", "]"}], 
          RowBox[{"\[Mu]val", "^", "3"}]]}], "}"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5445044250704536`*^9, 3.5445044350603247`*^9}, 
   3.544505982962347*^9, {3.544512122233067*^9, 3.544512135182517*^9}, {
   3.544621216703223*^9, 3.544621217711388*^9}, {3.544892231138051*^9, 
   3.544892233561352*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"plt1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"asym\[Mu]", ",", 
        FractionBox["hort1", "asym\[Mu]"]}], "}"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ";;", 
       RowBox[{"-", "15"}]}], "]"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plt2", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[Mu]val", "*", "horiz"}], ",", 
         FractionBox["temp", "\[Mu]val"]}], "}"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.544504681904351*^9, 3.544504699711619*^9}, {
   3.544504757935499*^9, 3.544504758847192*^9}, {3.54450479222648*^9, 
   3.544504796569023*^9}, 3.5445059872023363`*^9, {3.544512159872115*^9, 
   3.5445121903497257`*^9}, {3.544512352250084*^9, 3.544512354568919*^9}, {
   3.5446212213993273`*^9, 3.5446212221990643`*^9}, {3.5448922366169357`*^9, 
   3.544892239353188*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"plt1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"asym\[Mu]", ",", 
        FractionBox["asymq", 
         RowBox[{"asym\[Mu]", "^", "2"}]]}], "}"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ";;", 
       RowBox[{"-", "15"}]}], "]"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plt2", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[Mu]val", "*", "horiz"}], ",", 
          FractionBox[
           RowBox[{
            RowBox[{"afn", "'"}], "[", "0", "]"}], 
           RowBox[{"\[Mu]val", "^", "2"}]]}], "}"}], "]"}]}], "}"}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plt1", ",", "plt2", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.544512390912447*^9, 3.54451243596096*^9}, {
   3.544621224823292*^9, 3.54462122581495*^9}, 3.544892170475994*^9, {
   3.544892245705551*^9, 3.5448922473931847`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Functions", "Section",
 CellChangeTimes->{{3.544508687636112*^9, 3.5445086932253113`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"skip", "=", 
    RowBox[{"Round", "[", 
     RowBox[{"size", "/", "50"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]plt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"\[Psi]dat", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"fdat", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"hdat", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"aplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"adat", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"tdat", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"splt", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"varr", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], ",", 
         RowBox[{"zarr", "[", 
          RowBox[{"[", "jj", "]"}], "]"}], ",", 
         RowBox[{"sdat", "[", 
          RowBox[{"[", 
           RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5442504582349873`*^9, 3.544250584036578*^9}, 
   3.544250626644371*^9, {3.544250822560841*^9, 3.544250823367763*^9}, {
   3.5442509165343533`*^9, 3.544251133374446*^9}, {3.544251467199772*^9, 
   3.544251471241907*^9}, {3.544252339447783*^9, 3.544252348921164*^9}, {
   3.544252422297391*^9, 3.544252437776615*^9}, {3.544262042155575*^9, 
   3.544262059275323*^9}, 3.544262159662603*^9, {3.5442724024879303`*^9, 
   3.544272416568007*^9}, {3.544891644953578*^9, 3.54489164778538*^9}, {
   3.544891706368863*^9, 3.544891707304266*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eq1plt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"eq1", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eq2plt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"eq2", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eq3plt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"eq3", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eq4plt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"eq4", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eq5plt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"eq5", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"const1plt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"const1", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"const2plt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          RowBox[{"const2", "[", 
           RowBox[{"[", 
            RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"const3plt", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"varr", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], ",", 
         RowBox[{"zarr", "[", 
          RowBox[{"[", "jj", "]"}], "]"}], ",", 
         RowBox[{"const3", "[", 
          RowBox[{"[", 
           RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5442504582349873`*^9, 3.544250584036578*^9}, 
   3.544250626644371*^9, {3.544250822560841*^9, 3.544250823367763*^9}, {
   3.5442509165343533`*^9, 3.544251133374446*^9}, {3.544251467199772*^9, 
   3.544251471241907*^9}, {3.544252339447783*^9, 3.544252348921164*^9}, {
   3.544252422297391*^9, 3.544252437776615*^9}, {3.544262042155575*^9, 
   3.544262059275323*^9}, 3.544262159662603*^9, {3.5442724024879303`*^9, 
   3.544272416568007*^9}, {3.544286163741596*^9, 3.544286224774358*^9}, {
   3.544461804009173*^9, 3.5444618115893793`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]divzplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          FractionBox[
           RowBox[{"\[Psi]dat", "[", 
            RowBox[{"[", 
             RowBox[{"ii", ",", "jj"}], "]"}], "]"}], 
           RowBox[{"zarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fdivzplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          FractionBox[
           RowBox[{"fdat", "[", 
            RowBox[{"[", 
             RowBox[{"ii", ",", "jj"}], "]"}], "]"}], 
           RowBox[{"zarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hdivzplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          FractionBox[
           RowBox[{
            RowBox[{"hdat", "[", 
             RowBox[{"[", 
              RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "-", 
            RowBox[{"hdat", "[", 
             RowBox[{"[", 
              RowBox[{"ii", ",", "1"}], "]"}], "]"}]}], 
           RowBox[{"zarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tdivzplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          FractionBox[
           RowBox[{"tdat", "[", 
            RowBox[{"[", 
             RowBox[{"ii", ",", "jj"}], "]"}], "]"}], 
           RowBox[{"zarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sdivzplt", "=", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"varr", "[", 
           RowBox[{"[", "ii", "]"}], "]"}], ",", 
          RowBox[{"zarr", "[", 
           RowBox[{"[", "jj", "]"}], "]"}], ",", 
          FractionBox[
           RowBox[{"sdat", "[", 
            RowBox[{"[", 
             RowBox[{"ii", ",", "jj"}], "]"}], "]"}], 
           RowBox[{"zarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gttplt", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"varr", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], ",", 
         RowBox[{"zarr", "[", 
          RowBox[{"[", "jj", "]"}], "]"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{
           RowBox[{"tdat", "[", 
            RowBox[{"[", 
             RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{"zarr", "[", 
             RowBox[{"[", "jj", "]"}], "]"}], "^", "2"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ii", ",", "1", ",", "size", ",", "skip"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"jj", ",", "2", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQAWIQrRSY1iSf8crxmF8dmJ7WsaILRM+QYOwG0bGqN/tA
dOKfOf0gWsv82WMQ/ZFB4wlY3d/d30H0ur2pP0D0Io1XTApAumrXWmYQbfd1
TbwikD7EypYAoj/tiCgA0Wu4rAtB9JWSy5tVgHRSx+ltIDq84tshEK3hnncY
RN+tNjyrCTJX8hqYPhQx30ALSP9brWwIojftK70PogNfvnsMom94S78F0fdc
Bd6D6DX9VofcgbSqL9dhEF3Yv+Q4iO4oKjsFok9e+3MORAdoMZ4H0SGpPSbe
IHUnfUxBdFGVykpfIL1DNWIViHb/4vUgIf+V4+TEWDANAIOunPs=
  "]],

Cell[BoxData[
 RowBox[{
  RowBox[{"niceplot", "[", 
   RowBox[{"x_", ",", "rng_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmpplt1", "=", 
     RowBox[{"ListPlot3D", "[", 
      RowBox[{"x", ",", 
       RowBox[{"PlotRange", "\[Rule]", "rng"}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<v\>\"", ",", "\"\<z\>\""}], "}"}]}], ",", 
       RowBox[{"Mesh", "\[Rule]", "False"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpplt2", "=", 
     RowBox[{"ListPointPlot3D", "[", 
      RowBox[{"x", ",", 
       RowBox[{"PlotRange", "\[Rule]", "rng"}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<v\>\"", ",", "\"\<z\>\""}], "}"}]}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Show", "[", 
     RowBox[{"tmpplt1", ",", "tmpplt2"}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 CellChangeTimes->{{3.544250849419471*^9, 3.544250878676875*^9}, {
  3.544250911535594*^9, 3.544250912334264*^9}}],

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"gttplt", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5442747337418118`*^9, 3.5442747484038467`*^9}, {
  3.5442748165352716`*^9, 3.544274817414777*^9}, {3.5443562022437887`*^9, 
  3.544356203011685*^9}}],

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"\[Psi]plt", ",", "All"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"fplt", ",", "All"}], "]"}]], "Input",
 CellChangeTimes->{{3.544339657524955*^9, 3.54433965771593*^9}, {
  3.544340888655362*^9, 3.544340891214654*^9}, {3.5445068028831787`*^9, 
  3.544506807113859*^9}}],

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"hplt", ",", "All"}], "]"}]], "Input",
 CellChangeTimes->{{3.544250892870241*^9, 3.5442508937173033`*^9}}],

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"tplt", ",", "All"}], "]"}]], "Input",
 CellChangeTimes->{{3.544250900254099*^9, 3.544250901741186*^9}}],

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"splt", ",", "All"}], "]"}]], "Input",
 CellChangeTimes->{{3.544251241052889*^9, 3.54425124118081*^9}}],

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"eq1plt", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "30"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5442747337418118`*^9, 3.5442747484038467`*^9}, {
  3.5442748165352716`*^9, 3.544274817414777*^9}, {3.544286238287201*^9, 
  3.544286253613558*^9}, {3.544333492240798*^9, 3.54433353232554*^9}, {
  3.544459882803976*^9, 3.544459895043614*^9}, {3.5448909496091146`*^9, 
  3.544890956423335*^9}, {3.544891685811844*^9, 3.5448916859076767`*^9}, {
  3.548059498894204*^9, 3.548059504676461*^9}}],

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"eq2plt", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5442747337418118`*^9, 3.5442747484038467`*^9}, {
  3.5442748165352716`*^9, 3.544274817414777*^9}, {3.544286238287201*^9, 
  3.544286269125443*^9}, {3.54433351191805*^9, 3.544333513133665*^9}}],

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"eq3plt", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5442862769332447`*^9, 3.544286277010398*^9}, {
  3.544333522750016*^9, 3.544333523589601*^9}}],

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"eq4plt", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.544286283765098*^9, 3.544286283836957*^9}, {
  3.544333542726009*^9, 3.544333543669018*^9}}],

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"eq5plt", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5442862872769623`*^9, 3.54428628735721*^9}, {
  3.544333546357566*^9, 3.544333547237039*^9}}],

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"const1plt", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.544286294405795*^9, 3.544286296020711*^9}, {
  3.5443335526935873`*^9, 3.544333553708819*^9}}],

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"const2plt", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.54428630474966*^9, 3.544286304800226*^9}, {
  3.5443335595253153`*^9, 3.54433356046904*^9}}],

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"const3plt", ",", "All"}], "]"}]], "Input",
 CellChangeTimes->{{3.544286311829405*^9, 3.544286311884392*^9}, {
  3.5443335666214247`*^9, 3.5443335674285297`*^9}, {3.5480576984179983`*^9, 
  3.5480576998966427`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pictures", "Section",
 CellChangeTimes->{{3.544508687636112*^9, 3.5445086932253113`*^9}, {
  3.548055541136179*^9, 3.548055542006695*^9}}],

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"z", "^", "2"}], " ", 
     RowBox[{"t", "[", "z", "]"}]}]}], ",", "z"}], "]"}]], "Input",
 CellChangeTimes->{{3.548055806412435*^9, 3.548055836324275*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Tplt", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"varr", "[", 
            RowBox[{"[", "ii", "]"}], "]"}], ",", 
           RowBox[{"zarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}], ",", 
           RowBox[{"1", "+", 
            RowBox[{
             RowBox[{
              RowBox[{"zarr", "[", 
               RowBox[{"[", "jj", "]"}], "]"}], "^", "2"}], "*", 
             RowBox[{"tdat2", "[", 
              RowBox[{"[", 
               RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", "size", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
      "]"}], ",", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"varr", "[", 
             RowBox[{"[", "ii", "]"}], "]"}]}], ",", 
           RowBox[{"zarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}], ",", 
           RowBox[{"1", "+", 
            RowBox[{
             RowBox[{
              RowBox[{"zarr", "[", 
               RowBox[{"[", "jj", "]"}], "]"}], "^", "2"}], "*", 
             RowBox[{"tdat2", "[", 
              RowBox[{"[", 
               RowBox[{"1", ",", "jj"}], "]"}], "]"}]}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", "size", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
      "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.547533187952179*^9, 3.547533220655731*^9}, {
   3.548025330646315*^9, 3.548025340340247*^9}, 3.548025468366762*^9, 
   3.5480255207661133`*^9, {3.548026096752771*^9, 3.548026125353094*^9}, {
   3.548055709316435*^9, 3.548055744739951*^9}, 3.548055962174685*^9, {
   3.5481060402385187`*^9, 3.5481060417714577`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Tzplt", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"varr", "[", 
            RowBox[{"[", "ii", "]"}], "]"}], ",", 
           RowBox[{"zarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{"2", 
             RowBox[{"zarr", "[", 
              RowBox[{"[", "jj", "]"}], "]"}], "*", 
             RowBox[{"tdat2", "[", 
              RowBox[{"[", 
               RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{
              RowBox[{"zarr", "[", 
               RowBox[{"[", "jj", "]"}], "]"}], "^", "2"}], "*", 
             RowBox[{"tzdat2", "[", 
              RowBox[{"[", 
               RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", "size", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
      "]"}], ",", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"varr", "[", 
             RowBox[{"[", "ii", "]"}], "]"}]}], ",", 
           RowBox[{"zarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{"2", 
             RowBox[{"zarr", "[", 
              RowBox[{"[", "jj", "]"}], "]"}], "*", 
             RowBox[{"tdat2", "[", 
              RowBox[{"[", 
               RowBox[{"1", ",", "jj"}], "]"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{
              RowBox[{"zarr", "[", 
               RowBox[{"[", "jj", "]"}], "]"}], "^", "2"}], "*", 
             RowBox[{"tzdat2", "[", 
              RowBox[{"[", 
               RowBox[{"1", ",", "jj"}], "]"}], "]"}]}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", "size", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
      "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.54805576768906*^9, 3.548055767815837*^9}, {
  3.548055798335226*^9, 3.5480558046311827`*^9}, {3.548055841574407*^9, 
  3.548055876273972*^9}, {3.548055965926633*^9, 3.548055967366311*^9}, {
  3.548106044781793*^9, 3.548106045478355*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Tvplt", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"varr", "[", 
            RowBox[{"[", "ii", "]"}], "]"}], ",", 
           RowBox[{"zarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"zarr", "[", 
              RowBox[{"[", "jj", "]"}], "]"}], "^", "2"}], "*", 
            RowBox[{"tvdat2", "[", 
             RowBox[{"[", 
              RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", "size", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
      "]"}], ",", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"varr", "[", 
             RowBox[{"[", "ii", "]"}], "]"}]}], ",", 
           RowBox[{"zarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"zarr", "[", 
              RowBox[{"[", "jj", "]"}], "]"}], "^", "2"}], "*", 
            RowBox[{"tvdat2", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "jj"}], "]"}], "]"}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", "size", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
      "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.547533187952179*^9, 3.547533220655731*^9}, {
   3.548025330646315*^9, 3.548025340340247*^9}, 3.548025468366762*^9, 
   3.5480255207661133`*^9, {3.548026096752771*^9, 3.548026125353094*^9}, {
   3.548055709316435*^9, 3.548055801063457*^9}, 3.5480558842414427`*^9, 
   3.548055968661653*^9, {3.5480560137424107`*^9, 3.548056021821735*^9}, {
   3.548056652854456*^9, 3.5480566557181873`*^9}, {3.548106123338814*^9, 
   3.548106124857519*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Tfn", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"Tplt", ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "4"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tzfn", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"Tzplt", ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "4"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Tvfn", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"Tvplt", ",", 
    RowBox[{"InterpolationOrder", "\[Rule]", "4"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.548021708411763*^9, 3.5480217243208437`*^9}, {
   3.548024170967751*^9, 3.548024174487664*^9}, 3.548024726783135*^9, 
   3.5480251525609207`*^9, {3.548025269182692*^9, 3.548025269218115*^9}, 
   3.5480253563792353`*^9, {3.548055783863082*^9, 3.54805579426138*^9}, {
   3.548056052035397*^9, 3.548056054067409*^9}}],

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Tfn", "[", 
    RowBox[{"v", ",", "u"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0.01", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.54802208108836*^9, 3.548022128247752*^9}, {
  3.54802428058578*^9, 3.548024280695554*^9}, {3.548026132935565*^9, 
  3.548026133247072*^9}, {3.5480266585307837`*^9, 3.548026658833892*^9}, {
  3.548060962137986*^9, 3.5480609622735653`*^9}}],

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["Tfn", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"v", ",", "u"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0.01", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "60"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5480559256064672`*^9, 3.548055927708364*^9}, {
  3.548056060155539*^9, 3.548056075938951*^9}, {3.5480609653058*^9, 
  3.5480609654790916`*^9}}],

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Tzfn", "[", 
    RowBox[{"v", ",", "u"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0.01", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "60"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5480558943017263`*^9, 3.548055900652677*^9}, {
  3.548056067692999*^9, 3.5480560782987127`*^9}, {3.5480609692015963`*^9, 
  3.548060969369231*^9}}],

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["Tfn", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"v", ",", "u"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "10"}], ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0.01", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "60"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5480566403494377`*^9, 3.548056641356707*^9}}],

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Tvfn", "[", 
    RowBox[{"v", ",", "u"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "10"}], ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0.01", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "60"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.548055895564794*^9, 3.548055904484447*^9}, 
   3.548056721291841*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"niceplot", "[", 
   RowBox[{"x_", ",", "rng_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmpplt1", "=", 
     RowBox[{"ListPlot3D", "[", 
      RowBox[{"x", ",", 
       RowBox[{"PlotRange", "\[Rule]", "rng"}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<v\>\"", ",", "\"\<z\>\""}], "}"}]}], ",", 
       RowBox[{"Mesh", "\[Rule]", "False"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpplt2", "=", 
     RowBox[{"ListPointPlot3D", "[", 
      RowBox[{"x", ",", 
       RowBox[{"PlotRange", "\[Rule]", "rng"}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<v\>\"", ",", "\"\<z\>\""}], "}"}]}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Show", "[", 
     RowBox[{"tmpplt1", ",", "tmpplt2"}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 CellChangeTimes->{{3.544250849419471*^9, 3.544250878676875*^9}, {
  3.544250911535594*^9, 3.544250912334264*^9}}],

Cell[BoxData[
 RowBox[{"niceplot", "[", 
  RowBox[{"Tplt", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.547486410156229*^9, 3.547486437849792*^9}, {
  3.547533227334484*^9, 3.547533235164658*^9}, {3.548056332760767*^9, 
  3.548056333456337*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Tfn", "[", 
    RowBox[{"5", ",", "u"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0.01", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.548024396541224*^9, 3.548024419686103*^9}, 
   3.5480268914051857`*^9}],

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Tfn", "[", 
     RowBox[{"10", ",", "u"}], "]"}], "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0.8"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.548025406668971*^9, 3.5480254136654663`*^9}, 
   3.5480256145333233`*^9, {3.548025709581003*^9, 3.548025709756229*^9}, 
   3.548025816160837*^9, 3.5480258573702497`*^9, 3.548026006061595*^9, 
   3.54802689577234*^9, {3.548056465437566*^9, 3.548056465548317*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"geoeq", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["V", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "\[Lambda]", "]"}], "\[Equal]", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["V", "\[Prime]",
            MultilineFunction->None], "[", "\[Lambda]", "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            RowBox[{"Tfn", "[", 
             RowBox[{
              RowBox[{"V", "[", "\[Lambda]", "]"}], ",", 
              RowBox[{"Z", "[", "\[Lambda]", "]"}]}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"Z", "[", "\[Lambda]", "]"}], " ", 
            RowBox[{
             SuperscriptBox["Tfn", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{
              RowBox[{"V", "[", "\[Lambda]", "]"}], ",", 
              RowBox[{"Z", "[", "\[Lambda]", "]"}]}], "]"}]}]}], ")"}]}], 
        RowBox[{"2", " ", 
         RowBox[{"Z", "[", "\[Lambda]", "]"}]}]]}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox["Z", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "\[Lambda]", "]"}], "\[Equal]", 
       RowBox[{
        FractionBox["1", 
         RowBox[{"2", " ", 
          RowBox[{"Z", "[", "\[Lambda]", "]"}]}]], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"Tfn", "[", 
             RowBox[{
              RowBox[{"V", "[", "\[Lambda]", "]"}], ",", 
              RowBox[{"Z", "[", "\[Lambda]", "]"}]}], "]"}], "2"], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["V", "\[Prime]",
              MultilineFunction->None], "[", "\[Lambda]", "]"}], "2"]}], "+", 
          
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["Z", "\[Prime]",
              MultilineFunction->None], "[", "\[Lambda]", "]"}], "2"]}], "-", 
          
          RowBox[{"2", " ", 
           RowBox[{"Z", "[", "\[Lambda]", "]"}], " ", 
           RowBox[{
            SuperscriptBox["V", "\[Prime]",
             MultilineFunction->None], "[", "\[Lambda]", "]"}], " ", 
           RowBox[{
            SuperscriptBox["Z", "\[Prime]",
             MultilineFunction->None], "[", "\[Lambda]", "]"}], " ", 
           RowBox[{
            SuperscriptBox["Tfn", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{
             RowBox[{"V", "[", "\[Lambda]", "]"}], ",", 
             RowBox[{"Z", "[", "\[Lambda]", "]"}]}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"Tfn", "[", 
            RowBox[{
             RowBox[{"V", "[", "\[Lambda]", "]"}], ",", 
             RowBox[{"Z", "[", "\[Lambda]", "]"}]}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["V", "\[Prime]",
             MultilineFunction->None], "[", "\[Lambda]", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              RowBox[{
               SuperscriptBox["Z", "\[Prime]",
                MultilineFunction->None], "[", "\[Lambda]", "]"}]}], "-", 
             RowBox[{
              RowBox[{"Z", "[", "\[Lambda]", "]"}], " ", 
              RowBox[{
               SuperscriptBox["V", "\[Prime]",
                MultilineFunction->None], "[", "\[Lambda]", "]"}], " ", 
              RowBox[{
               SuperscriptBox["Tfn", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{
                RowBox[{"V", "[", "\[Lambda]", "]"}], ",", 
                RowBox[{"Z", "[", "\[Lambda]", "]"}]}], "]"}]}]}], ")"}]}], 
          "-", 
          RowBox[{
           RowBox[{"Z", "[", "\[Lambda]", "]"}], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["V", "\[Prime]",
              MultilineFunction->None], "[", "\[Lambda]", "]"}], "2"], " ", 
           RowBox[{
            SuperscriptBox["Tfn", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{
             RowBox[{"V", "[", "\[Lambda]", "]"}], ",", 
             RowBox[{"Z", "[", "\[Lambda]", "]"}]}], "]"}]}]}], ")"}]}]}]}], 
     "}"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"norm", "=", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{
       SuperscriptBox["V", "\[Prime]",
        MultilineFunction->None], "[", "\[Lambda]", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"Tfn", "[", 
          RowBox[{
           RowBox[{"V", "[", "\[Lambda]", "]"}], ",", 
           RowBox[{"Z", "[", "\[Lambda]", "]"}]}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["V", "\[Prime]",
           MultilineFunction->None], "[", "\[Lambda]", "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["Z", "\[Prime]",
           MultilineFunction->None], "[", "\[Lambda]", "]"}]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"Z", "[", "\[Lambda]", "]"}], "2"]]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.548023814687351*^9, 3.548023848167901*^9}, 
   3.548056496162695*^9, 3.548056558017995*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"geoeq2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["V", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "\[Lambda]", "]"}], "\[Equal]", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["V", "\[Prime]",
           MultilineFunction->None], "[", "\[Lambda]", "]"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           RowBox[{"Tfn", "[", 
            RowBox[{
             RowBox[{"V", "[", "\[Lambda]", "]"}], ",", 
             RowBox[{"Z", "[", "\[Lambda]", "]"}]}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"Z", "[", "\[Lambda]", "]"}], " ", 
           RowBox[{"Tzfn", "[", 
            RowBox[{
             RowBox[{"V", "[", "\[Lambda]", "]"}], ",", 
             RowBox[{"Z", "[", "\[Lambda]", "]"}]}], "]"}]}]}], ")"}]}], 
       RowBox[{"2", " ", 
        RowBox[{"Z", "[", "\[Lambda]", "]"}]}]]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["Z", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "\[Lambda]", "]"}], "\[Equal]", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"2", " ", 
         RowBox[{"Z", "[", "\[Lambda]", "]"}]}]], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"Tfn", "[", 
            RowBox[{
             RowBox[{"V", "[", "\[Lambda]", "]"}], ",", 
             RowBox[{"Z", "[", "\[Lambda]", "]"}]}], "]"}], "2"], " ", 
          SuperscriptBox[
           RowBox[{
            SuperscriptBox["V", "\[Prime]",
             MultilineFunction->None], "[", "\[Lambda]", "]"}], "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox[
           RowBox[{
            SuperscriptBox["Z", "\[Prime]",
             MultilineFunction->None], "[", "\[Lambda]", "]"}], "2"]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{"Z", "[", "\[Lambda]", "]"}], " ", 
          RowBox[{
           SuperscriptBox["V", "\[Prime]",
            MultilineFunction->None], "[", "\[Lambda]", "]"}], " ", 
          RowBox[{
           SuperscriptBox["Z", "\[Prime]",
            MultilineFunction->None], "[", "\[Lambda]", "]"}], 
          RowBox[{"Tzfn", "[", 
           RowBox[{
            RowBox[{"V", "[", "\[Lambda]", "]"}], ",", 
            RowBox[{"Z", "[", "\[Lambda]", "]"}]}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"Tfn", "[", 
           RowBox[{
            RowBox[{"V", "[", "\[Lambda]", "]"}], ",", 
            RowBox[{"Z", "[", "\[Lambda]", "]"}]}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["V", "\[Prime]",
            MultilineFunction->None], "[", "\[Lambda]", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             RowBox[{
              SuperscriptBox["Z", "\[Prime]",
               MultilineFunction->None], "[", "\[Lambda]", "]"}]}], "-", 
            RowBox[{
             RowBox[{"Z", "[", "\[Lambda]", "]"}], " ", 
             RowBox[{
              SuperscriptBox["V", "\[Prime]",
               MultilineFunction->None], "[", "\[Lambda]", "]"}], " ", 
             RowBox[{"Tzfn", "[", 
              RowBox[{
               RowBox[{"V", "[", "\[Lambda]", "]"}], ",", 
               RowBox[{"Z", "[", "\[Lambda]", "]"}]}], "]"}]}]}], ")"}]}], 
         "-", 
         RowBox[{
          RowBox[{"Z", "[", "\[Lambda]", "]"}], " ", 
          SuperscriptBox[
           RowBox[{
            SuperscriptBox["V", "\[Prime]",
             MultilineFunction->None], "[", "\[Lambda]", "]"}], "2"], " ", 
          RowBox[{"Tvfn", "[", 
           RowBox[{
            RowBox[{"V", "[", "\[Lambda]", "]"}], ",", 
            RowBox[{"Z", "[", "\[Lambda]", "]"}]}], "]"}]}]}], ")"}]}]}]}], 
    "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.548023814687351*^9, 3.548023848167901*^9}, {
  3.5480565397371197`*^9, 3.548056569551244*^9}}],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"norm", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"V", "[", "\[Lambda]", "]"}], "\[Rule]", 
         RowBox[{"+", "10"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"V", "'"}], "[", "\[Lambda]", "]"}], "\[Rule]", 
         RowBox[{"-", "1"}]}], ",", 
        RowBox[{
         RowBox[{"Z", "[", "\[Lambda]", "]"}], "->", "0.7054763971945555`"}], 
        ",", 
        RowBox[{
         RowBox[{
          RowBox[{"Z", "'"}], "[", "\[Lambda]", "]"}], "\[Rule]", "x"}]}], 
       "}"}]}], ")"}], "\[Equal]", "0"}], ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.548026437064468*^9, 3.5480266384261208`*^9}, {
   3.5480266867462997`*^9, 3.548026790919293*^9}, {3.548026842820799*^9, 
   3.54802687126021*^9}, 3.548026904654461*^9, {3.548056469053248*^9, 
   3.548056474118168*^9}, 3.5496903610299273`*^9, 3.5496909059999857`*^9, {
   3.5497976167837753`*^9, 3.549797617487722*^9}, 3.549956139773233*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Lambda]max", "=", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"geo", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"Join", "[", 
      RowBox[{"geoeq", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"V", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"+", "10"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"V", "'"}], "[", "0", "]"}], "\[Equal]", 
          RowBox[{"-", "10"}]}], ",", 
         RowBox[{
          RowBox[{"Z", "[", "0", "]"}], "\[Equal]", "0.7054763971945555`"}], 
         ",", 
         RowBox[{
          RowBox[{
           RowBox[{"Z", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"V", ",", "Z"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Lambda]", ",", "0", ",", "\[Lambda]max"}], "}"}], ",", 
     RowBox[{"Method", "\[Rule]", "\"\<Adams\>\""}], ",", 
     RowBox[{"MaxSteps", "\[Rule]", "1000000"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"\[Lambda]max", "=", 
  RowBox[{"geo", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "1", ",", "2", ",", "1", ",", "1", ",", "2"}], "]"}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.548021755010849*^9, 3.5480218329711523`*^9}, {
   3.5480218724580727`*^9, 3.5480219597138433`*^9}, {3.548022193090219*^9, 
   3.548022214225978*^9}, {3.5480223189455957`*^9, 3.548022434622855*^9}, {
   3.548023823564242*^9, 3.548023831283435*^9}, {3.548023892597785*^9, 
   3.5480239063811817`*^9}, {3.5480239651283083`*^9, 
   3.5480239662400227`*^9}, {3.54802400507942*^9, 3.5480240473388987`*^9}, {
   3.548024085122321*^9, 3.5480241637607393`*^9}, {3.5480242085616083`*^9, 
   3.5480242144474163`*^9}, {3.548024245854224*^9, 3.54802424645181*^9}, {
   3.548024318491024*^9, 3.5480243492558727`*^9}, {3.548024431150794*^9, 
   3.5480245125133543`*^9}, {3.548024543075897*^9, 3.548024558395254*^9}, {
   3.548024740446789*^9, 3.548024775941045*^9}, {3.548024818990225*^9, 
   3.548024916995923*^9}, {3.548024954443345*^9, 3.548025013745838*^9}, {
   3.54802506263608*^9, 3.548025118155381*^9}, {3.548025167833295*^9, 
   3.54802530635021*^9}, {3.548025391438075*^9, 3.548025434573848*^9}, 
   3.5480254899184713`*^9, 3.548025542990066*^9, {3.548025604886669*^9, 
   3.5480256250868797`*^9}, {3.548025678079151*^9, 3.548025727149036*^9}, 
   3.5480257783089933`*^9, {3.548025821539781*^9, 3.548025862861125*^9}, {
   3.548025948129396*^9, 3.548026048673966*^9}, {3.548026164287611*^9, 
   3.5480263536246862`*^9}, {3.548026395852891*^9, 3.548026420381743*^9}, {
   3.548026498493555*^9, 3.548026643876835*^9}, {3.548026691563951*^9, 
   3.5480267961134*^9}, {3.5480268281818943`*^9, 3.5480269136293583`*^9}, {
   3.548026954833962*^9, 3.548026958057887*^9}, {3.5480269948922462`*^9, 
   3.548027029325629*^9}, {3.5480564772395067`*^9, 3.5480564788378153`*^9}, {
   3.548060980074815*^9, 3.548060981626422*^9}, {3.549690352115505*^9, 
   3.549690365415715*^9}, {3.549690469118184*^9, 3.5496904693582153`*^9}, 
   3.549690883304922*^9, {3.549690949463673*^9, 3.5496909668816*^9}, 
   3.5497976209939737`*^9, 3.5499561419913197`*^9}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"norm", "/.", "geo"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]", ",", "0", ",", "\[Lambda]max"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5480239328994627`*^9, 3.548023943961924*^9}}],

Cell[BoxData[
 RowBox[{"horizplt", "=", 
  RowBox[{"ParametricPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Z", "[", "\[Lambda]", "]"}], ",", 
       RowBox[{"V", "[", "\[Lambda]", "]"}]}], "}"}], "/.", "geo"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Lambda]", ",", "0", ",", "\[Lambda]max"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "10"}], ",", "20"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", "1000000"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"RGBColor", "[", 
        RowBox[{"0", ",", "0", ",", "0"}], "]"}], ",", 
       RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}]}]}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.54802193921094*^9, 3.548021999437368*^9}, {
  3.548022225653833*^9, 3.548022252500766*^9}, {3.5480224255457907`*^9, 
  3.548022426202599*^9}, {3.548023914574546*^9, 3.548023921580474*^9}, {
  3.548023981151528*^9, 3.548023997550971*^9}, {3.54802615876692*^9, 
  3.548026159022753*^9}, {3.549690389688952*^9, 3.549690483613414*^9}, {
  3.5496905171689377`*^9, 3.549690537692376*^9}, {3.5496909277621813`*^9, 
  3.5496909915415487`*^9}, {3.549797631049327*^9, 3.5497976537888403`*^9}, {
  3.549956163497068*^9, 3.5499561705780153`*^9}, {3.549956249173521*^9, 
  3.5499562510050793`*^9}, {3.549956585051055*^9, 3.5499566032118883`*^9}, {
  3.549956671795822*^9, 3.549956675964603*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"skip2", "=", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gttplttmp", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"zarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}], ",", 
           RowBox[{"-", 
            RowBox[{"varr", "[", 
             RowBox[{"[", "ii", "]"}], "]"}]}], ",", 
           RowBox[{"1", "+", 
            RowBox[{
             RowBox[{
              RowBox[{"zarr", "[", 
               RowBox[{"[", "jj", "]"}], "]"}], "^", "2"}], "*", 
             RowBox[{"tdat2", "[", 
              RowBox[{"[", 
               RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", "20", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
      "]"}], ",", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"zarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}], ",", 
           RowBox[{"varr", "[", 
            RowBox[{"[", "ii", "]"}], "]"}], ",", 
           RowBox[{"1", "+", 
            RowBox[{
             RowBox[{
              RowBox[{"zarr", "[", 
               RowBox[{"[", "jj", "]"}], "]"}], "^", "2"}], "*", 
             RowBox[{"tdat2", "[", 
              RowBox[{"[", 
               RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", "400", ",", "skip2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
      "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.547533647743915*^9, 3.5475338294727583`*^9}, {
  3.5475338979646063`*^9, 3.547533918125414*^9}, {3.5475339627376833`*^9, 
  3.547533962817822*^9}, {3.5475339991489267`*^9, 3.547533999223785*^9}, {
  3.5475340945457687`*^9, 3.547534143380232*^9}, {3.5479291810095387`*^9, 
  3.547929189839451*^9}, {3.548106149442205*^9, 3.548106151232904*^9}}],

Cell[BoxData[
 RowBox[{"ListContourPlot", "[", 
  RowBox[{"gttplttmp", ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<v\>\"", ",", "\"\<z\>\""}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"All", ",", "8"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Contours", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "Thick"}], "}"}], ",", "0.1", ",", "0.2", ",", "0.3",
       ",", "0.4", ",", "0.5", ",", "0.6", ",", "0.7", ",", "0.8", ",", "0.9",
       ",", "0.99"}], "}"}]}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "10"}], ",", 
   RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5475332632279577`*^9, 3.5475332933311443`*^9}, {
   3.5475333438024063`*^9, 3.547533520997335*^9}, {3.547533554341462*^9, 
   3.547533619098226*^9}, 3.547533673706337*^9, {3.547533733151265*^9, 
   3.5475337335191393`*^9}, 3.547533833871921*^9, {3.5475339042120953`*^9, 
   3.547533933315961*^9}, {3.547533976094866*^9, 3.5475339911632967`*^9}, {
   3.547534035666317*^9, 3.547534047529936*^9}, {3.547534185724454*^9, 
   3.5475341858753767`*^9}, {3.5479291975329723`*^9, 3.547929200277375*^9}, {
   3.548106172433131*^9, 3.548106191184854*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"skip2", "=", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Psi]plttmp", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"zarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}], ",", 
           RowBox[{"-", 
            RowBox[{"varr", "[", 
             RowBox[{"[", "ii", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"zarr", "[", 
             RowBox[{"[", "jj", "]"}], "]"}], 
            RowBox[{"\[Psi]dat", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "jj"}], "]"}], "]"}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", "200", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
      "]"}], ",", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"zarr", "[", 
            RowBox[{"[", "jj", "]"}], "]"}], ",", 
           RowBox[{"varr", "[", 
            RowBox[{"[", "ii", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{"zarr", "[", 
             RowBox[{"[", "jj", "]"}], "]"}], 
            RowBox[{"\[Psi]dat", "[", 
             RowBox[{"[", 
              RowBox[{"ii", ",", "jj"}], "]"}], "]"}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", "size", ",", "skip2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"jj", ",", "1", ",", "Nz"}], "}"}]}], "]"}], ",", "1"}], 
      "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.547533647743915*^9, 3.5475338294727583`*^9}, {
  3.5475341560660563`*^9, 3.547534159779655*^9}, {3.547929215686483*^9, 
  3.5479292426452217`*^9}, {3.548106212298506*^9, 3.54810622047431*^9}, {
  3.548106332400104*^9, 3.5481063345351048`*^9}, {3.549956329105115*^9, 
  3.549956331552094*^9}, {3.549956373860619*^9, 3.549956375380666*^9}, {
  3.54995643203831*^9, 3.5499564321183023`*^9}, {3.5499564703359623`*^9, 
  3.5499564704640083`*^9}}],

Cell[BoxData[
 RowBox[{"scalarplt", "=", 
  RowBox[{"ListContourPlot", "[", 
   RowBox[{"\[Psi]plttmp", ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<z\>\"", ",", "\"\<v\>\""}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"All", ",", "10"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Contours", "\[Rule]", "10"}], ",", 
    RowBox[{"InterpolationOrder", "\[Rule]", "10"}], ",", 
    RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.5475332632279577`*^9, 3.5475332933311443`*^9}, {
   3.5475333438024063`*^9, 3.547533520997335*^9}, {3.547533554341462*^9, 
   3.547533619098226*^9}, 3.547533673706337*^9, {3.547533733151265*^9, 
   3.5475337335191393`*^9}, 3.547533833871921*^9, {3.547534192835417*^9, 
   3.547534192979085*^9}, {3.547929224468104*^9, 3.547929258356827*^9}, {
   3.548106209042119*^9, 3.548106209129395*^9}, {3.5499562691293097`*^9, 
   3.54995627091267*^9}, {3.549956438461975*^9, 3.54995643856603*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"txt1", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<event horizon\>\"", ",", 
        RowBox[{"FontSize", "\[Rule]", "22"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.75", ",", "6"}], "}"}], ",", "Automatic", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "8"}], "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.549956803591971*^9, 3.5499568985364723`*^9}, {
  3.54995699245977*^9, 3.5499569973951902`*^9}, {3.5499570717516317`*^9, 
  3.549957197934332*^9}}],

Cell[BoxData[
 RowBox[{"plt", "=", 
  RowBox[{"Show", "[", 
   RowBox[{"scalarplt", ",", "horizplt", ",", "txt1", ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"All", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "4"}], ",", "10"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Frame", "\[Rule]", "False"}], ",", 
    RowBox[{"Axes", "\[Rule]", "True"}], ",", 
    RowBox[{"AxesStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"FontSize", "\[Rule]", "22"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.549956272915156*^9, 3.5499562800810423`*^9}, {
  3.549956390533701*^9, 3.549956418986808*^9}, {3.549956571568026*^9, 
  3.549956578752819*^9}, {3.549956757740888*^9, 3.5499567934824667`*^9}, {
  3.549956844072487*^9, 3.549956871620278*^9}, {3.549956915842814*^9, 
  3.5499569800462847`*^9}, {3.549957132089159*^9, 3.5499571439626293`*^9}, {
  3.5499572073142433`*^9, 3.549957207646359*^9}}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"1", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<~/Work/AdSCMTDyn4/figs/scalar.jpg\>\"", ",", "plt"}], "]"}],
     ";"}]}], "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.5499572112578077`*^9, 3.549957248647828*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1067, 859},
WindowMargins->{{42, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 100, 1, 46, "Subtitle"],
Cell[682, 25, 977, 15, 27, "Input"],
Cell[1662, 42, 730, 20, 88, "Input"],
Cell[2395, 64, 1736, 49, 178, "Input"],
Cell[4134, 115, 360, 9, 27, "Input"],
Cell[4497, 126, 470, 13, 27, "Input"],
Cell[4970, 141, 137, 2, 27, "Input"],
Cell[5110, 145, 381, 9, 27, "Input"],
Cell[5494, 156, 523, 14, 27, "Input"],
Cell[6020, 172, 189, 3, 27, "Input"],
Cell[6212, 177, 2423, 80, 238, "Input"],
Cell[8638, 259, 2868, 96, 238, "Input"],
Cell[11509, 357, 994, 32, 88, "Input"],
Cell[12506, 391, 348, 8, 58, "Input"],
Cell[12857, 401, 1005, 29, 82, "Input"],
Cell[13865, 432, 304, 9, 49, "Input"],
Cell[14172, 443, 1624, 49, 148, "Input"],
Cell[15799, 494, 252, 6, 27, "Input"],
Cell[16054, 502, 491, 12, 27, "Input"],
Cell[16548, 516, 3295, 94, 208, "Input"],
Cell[19846, 612, 540, 13, 49, "Input"],
Cell[20389, 627, 561, 12, 27, "Input"],
Cell[20953, 641, 2043, 52, 133, "Input"],
Cell[CellGroupData[{
Cell[23021, 697, 189, 3, 67, "Section"],
Cell[23213, 702, 21943, 507, 1528, "Input"],
Cell[45159, 1211, 2910, 84, 208, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[48106, 1300, 106, 1, 37, "Section"],
Cell[48215, 1303, 128, 2, 27, "Input"],
Cell[48346, 1307, 258, 6, 27, "Input"],
Cell[48607, 1315, 1556, 46, 118, "Input"],
Cell[50166, 1363, 387, 11, 27, "Input"],
Cell[50556, 1376, 142, 3, 27, "Input"],
Cell[50701, 1381, 331, 7, 27, "Input"],
Cell[51035, 1390, 1512, 41, 121, "Input"],
Cell[52550, 1433, 1466, 37, 120, "Input"],
Cell[54019, 1472, 1269, 36, 119, "Input"],
Cell[55291, 1510, 1292, 34, 120, "Input"],
Cell[56586, 1546, 1260, 36, 134, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[57883, 1587, 96, 1, 37, "Section"],
Cell[57982, 1590, 5067, 139, 223, "Input"],
Cell[63052, 1731, 6340, 175, 238, "Input"],
Cell[69395, 1908, 5586, 157, 302, "Input"],
Cell[74984, 2067, 1148, 27, 148, "Input"],
Cell[76135, 2096, 310, 7, 27, "Input"],
Cell[76448, 2105, 94, 2, 27, "Input"],
Cell[76545, 2109, 254, 5, 27, "Input"],
Cell[76802, 2116, 157, 3, 27, "Input"],
Cell[76962, 2121, 155, 3, 27, "Input"],
Cell[77120, 2126, 154, 3, 27, "Input"],
Cell[77277, 2131, 573, 11, 27, "Input"],
Cell[77853, 2144, 374, 8, 27, "Input"],
Cell[78230, 2154, 276, 7, 27, "Input"],
Cell[78509, 2163, 274, 7, 27, "Input"],
Cell[78786, 2172, 275, 7, 27, "Input"],
Cell[79064, 2181, 279, 7, 27, "Input"],
Cell[79346, 2190, 277, 7, 27, "Input"],
Cell[79626, 2199, 266, 5, 27, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[79929, 2209, 144, 2, 67, "Section"],
Cell[80076, 2213, 249, 7, 27, "Input"],
Cell[80328, 2222, 2131, 56, 43, "Input"],
Cell[82462, 2280, 2519, 67, 88, "Input"],
Cell[84984, 2349, 2180, 56, 43, "Input"],
Cell[87167, 2407, 927, 21, 88, "Input"],
Cell[88097, 2430, 652, 16, 27, "Input"],
Cell[88752, 2448, 701, 20, 33, "Input"],
Cell[89456, 2470, 563, 14, 27, "Input"],
Cell[90022, 2486, 603, 18, 33, "Input"],
Cell[90628, 2506, 485, 13, 27, "Input"],
Cell[91116, 2521, 1148, 27, 148, "Input"],
Cell[92267, 2550, 300, 7, 27, "Input"],
Cell[92570, 2559, 413, 12, 27, "Input"],
Cell[92986, 2573, 510, 11, 27, "Input"],
Cell[93499, 2586, 5756, 155, 190, "Input"],
Cell[99258, 2743, 3988, 104, 132, "Input"],
Cell[103249, 2849, 1050, 26, 27, "Input"],
Cell[104302, 2877, 3245, 65, 103, "Input"],
Cell[107550, 2944, 259, 7, 27, "Input"],
Cell[107812, 2953, 1646, 37, 43, "Input"],
Cell[109461, 2992, 2280, 60, 73, "Input"],
Cell[111744, 3054, 1394, 30, 43, "Input"],
Cell[113141, 3086, 2232, 58, 73, "Input"],
Cell[115376, 3146, 1152, 24, 43, "Input"],
Cell[116531, 3172, 602, 15, 27, "Input"],
Cell[117136, 3189, 959, 20, 27, "Input"],
Cell[118098, 3211, 350, 8, 58, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
