/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.impl;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.UndirectedEdge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.AbstractSparseVertex;
import edu.uci.ics.jung.graph.predicates.ParallelEdgePredicate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SimpleUndirectedSparseVertex
extends AbstractSparseVertex {
    private Map mNeighborsToEdges;

    public Set getPredecessors() {
        return Collections.unmodifiableSet(this.getNeighborsToEdges().keySet());
    }

    public int numPredecessors() {
        return this.getPredecessors().size();
    }

    public Set getSuccessors() {
        return Collections.unmodifiableSet(this.getNeighborsToEdges().keySet());
    }

    public int numSuccessors() {
        return this.getSuccessors().size();
    }

    public Set getInEdges() {
        return Collections.unmodifiableSet(new HashSet(this.getEdges_internal()));
    }

    public Set getOutEdges() {
        return Collections.unmodifiableSet(new HashSet(this.getEdges_internal()));
    }

    public int inDegree() {
        return this.getNeighborsToEdges().values().size();
    }

    public int outDegree() {
        return this.getNeighborsToEdges().values().size();
    }

    public boolean isSuccessorOf(Vertex v) {
        return this.getNeighborsToEdges().containsKey(v);
    }

    public boolean isPredecessorOf(Vertex v) {
        return this.getNeighborsToEdges().containsKey(v);
    }

    public boolean isSource(Edge e) {
        return this.isIncident(e);
    }

    public boolean isDest(Edge e) {
        return this.isIncident(e);
    }

    public Edge findEdge(Vertex v) {
        return (Edge)this.getNeighborsToEdges().get(v);
    }

    public Set findEdgeSet(Vertex v) {
        HashSet<Edge> s = new HashSet<Edge>();
        Edge e = this.findEdge(v);
        if (e != null) {
            s.add(e);
        }
        return Collections.unmodifiableSet(s);
    }

    protected void initialize() {
        super.initialize();
        this.setNeighborsToEdges(null);
    }

    protected Collection getNeighbors_internal() {
        return this.getNeighborsToEdges().keySet();
    }

    protected Collection getEdges_internal() {
        return this.getNeighborsToEdges().values();
    }

    protected void addNeighbor_internal(Edge e, Vertex v) {
        if (ParallelEdgePredicate.getInstance().evaluate(e)) {
            throw new IllegalArgumentException("This vertex implementation does not support parallel edges");
        }
        if (!(e instanceof UndirectedEdge)) {
            throw new IllegalArgumentException("This vertex implementation only accepts undirected edges");
        }
        this.getNeighborsToEdges().put(v, e);
    }

    protected void removeNeighbor_internal(Edge connectingEdge, Vertex neighbor) {
        if (connectingEdge != this.getNeighborsToEdges().get(neighbor)) {
            if (this == neighbor) {
                return;
            }
            throw new FatalException("Internal error: edge " + connectingEdge + " not incident to vertex " + neighbor);
        }
        this.getNeighborsToEdges().remove(neighbor);
    }

    protected Map getNeighborsToEdges() {
        if (this.mNeighborsToEdges == null) {
            this.setNeighborsToEdges(new HashMap(5));
        }
        return this.mNeighborsToEdges;
    }

    protected void setNeighborsToEdges(Map neighborsToEdges) {
        this.mNeighborsToEdges = neighborsToEdges;
    }
}

