/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.jlibeps.epsgraphics;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Hashtable;
import java.util.Map;
import org.sourceforge.jlibeps.epsgraphics.EpsDocument;
import org.sourceforge.jlibeps.epsgraphics.EpsException;

public class EpsGraphics2D
extends Graphics2D {
    public static final String VERSION = "0.1";
    public static final int BLACK_AND_WHITE = 1;
    public static final int GRAYSCALE = 2;
    public static final int RGB = 3;
    private Color _color;
    private Color _backgroundColor;
    private Paint _paint;
    private Composite _composite;
    private BasicStroke _stroke;
    private Font _font;
    private Shape _clip;
    private AffineTransform _clipTransform;
    private AffineTransform _transform;
    private boolean _accurateTextMode;
    private int _colorDepth;
    private EpsDocument _document;
    private static FontRenderContext _fontRenderContext = new FontRenderContext(null, false, true);

    public EpsGraphics2D() {
        this("Untitled");
    }

    public EpsGraphics2D(String string) {
        this._document = new EpsDocument(string);
        this._backgroundColor = Color.white;
        this._clip = null;
        this._transform = new AffineTransform();
        this._clipTransform = new AffineTransform();
        this._accurateTextMode = true;
        this._colorDepth = 3;
        this.setColor(Color.black);
        this.setPaint(Color.black);
        this.setComposite(AlphaComposite.getInstance(1));
        this.setFont(Font.decode(null));
        this.setStroke(new BasicStroke());
    }

    public EpsGraphics2D(String string, File file, int n, int n2, int n3, int n4) throws IOException {
        this(string, new FileOutputStream(file), n, n2, n3, n4);
    }

    public EpsGraphics2D(String string, OutputStream outputStream, int n, int n2, int n3, int n4) throws IOException {
        this(string);
        this._document = new EpsDocument(string, outputStream, n, n2, n3, n4);
    }

    protected EpsGraphics2D(EpsGraphics2D epsGraphics2D) {
        this._document = epsGraphics2D._document;
        this._backgroundColor = epsGraphics2D._backgroundColor;
        this._clip = epsGraphics2D._clip;
        this._clipTransform = (AffineTransform)epsGraphics2D._clipTransform.clone();
        this._transform = (AffineTransform)epsGraphics2D._transform.clone();
        this._color = epsGraphics2D._color;
        this._paint = epsGraphics2D._paint;
        this._composite = epsGraphics2D._composite;
        this._font = epsGraphics2D._font;
        this._stroke = epsGraphics2D._stroke;
        this._accurateTextMode = epsGraphics2D._accurateTextMode;
        this._colorDepth = epsGraphics2D._colorDepth;
    }

    private void methodNotSupported() {
        EpsException epsException = new EpsException("Method not currently supported by jlibeps version 0.1");
        epsException.printStackTrace(System.err);
    }

    public void setAccurateTextMode(boolean bl) {
        this._accurateTextMode = bl;
        if (!this.getAccurateTextMode()) {
            this.setFont(this.getFont());
        }
    }

    public boolean getAccurateTextMode() {
        return this._accurateTextMode;
    }

    public void setColorDepth(int n) {
        if (n == 3 || n == 2 || n == 1) {
            this._colorDepth = n;
        }
    }

    public int getColorDepth() {
        return this._colorDepth;
    }

    public void flush() throws IOException {
        this._document.flush();
    }

    public void close() throws IOException {
        this.flush();
        this._document.close();
    }

    private void append(String string) {
        this._document.append(this, string);
    }

    private Point2D transform(float f, float f2) {
        Point2D point2D = new Point2D.Float(f, f2);
        point2D = this._transform.transform(point2D, point2D);
        point2D.setLocation(point2D.getX(), -point2D.getY());
        return point2D;
    }

    private void draw(Shape shape, String string) {
        if (shape != null) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            if (!this._transform.isIdentity()) {
                shape = this._transform.createTransformedShape(shape);
            }
            if (!string.equals("clip")) {
                Rectangle2D rectangle2D = shape.getBounds2D();
                object4 = rectangle2D;
                if (this._clip != null) {
                    Rectangle2D rectangle2D2 = this._clip.getBounds2D();
                    object4 = rectangle2D.createIntersection(rectangle2D2);
                }
                float f = this._stroke.getLineWidth() / 2.0f;
                object3 = (float)((RectangularShape)object4).getMinX() - f;
                object2 = (float)((RectangularShape)object4).getMinY() - f;
                float f2 = (float)((RectangularShape)object4).getMaxX() + f;
                object = (float)((RectangularShape)object4).getMaxY() + f;
                this._document.updateBounds((double)object3, -object2);
                this._document.updateBounds(f2, (double)(-object));
            }
            this.append("newpath");
            int n = 0;
            object4 = new float[6];
            PathIterator pathIterator = shape.getPathIterator(null);
            object3 = 0.0f;
            object2 = 0.0f;
            int n2 = 0;
            while (!pathIterator.isDone()) {
                n = pathIterator.currentSegment((float[])object4);
                object = object4[0];
                Object object5 = -object4[1];
                Object object6 = object4[2];
                Object object7 = -object4[3];
                Object object8 = object4[4];
                Object object9 = -object4[5];
                if (n == 4) {
                    this.append("closepath");
                    ++n2;
                } else if (n == 3) {
                    this.append((float)object + " " + (float)object5 + " " + (float)object6 + " " + (float)object7 + " " + (float)object8 + " " + (float)object9 + " curveto");
                    ++n2;
                    object3 = object8;
                    object2 = object9;
                } else if (n == 1) {
                    this.append((float)object + " " + (float)object5 + " lineto");
                    ++n2;
                    object3 = object;
                    object2 = object5;
                } else if (n == 0) {
                    this.append((float)object + " " + (float)object5 + " moveto");
                    ++n2;
                    object3 = object;
                    object2 = object5;
                } else if (n == 2) {
                    float f = object3 + 0.6666667f * (object - object3);
                    float f3 = object2 + 0.6666667f * (object5 - object2);
                    reference var17_21 = object + 0.33333334f * (object6 - object);
                    reference var18_22 = object5 + 0.33333334f * (object7 - object5);
                    Object object10 = object6;
                    Object object11 = object7;
                    this.append(f + " " + f3 + " " + (float)var17_21 + " " + (float)var18_22 + " " + (float)object10 + " " + (float)object11 + " curveto");
                    ++n2;
                    object3 = object10;
                    object2 = object11;
                } else if (n == 0 || n == 1) {
                    // empty if block
                }
                pathIterator.next();
            }
            this.append(string);
            this.append("newpath");
        }
    }

    private String toHexString(int n) {
        String string = Integer.toString(n, 16);
        while (string.length() < 2) {
            string = "0" + string;
        }
        return string;
    }

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        Color color = this.getColor();
        Stroke stroke = this.getStroke();
        this.setStroke(new BasicStroke(1.0f));
        if (bl) {
            this.setColor(color.brighter());
        } else {
            this.setColor(color.darker());
        }
        this.drawLine(n, n2, n + n3, n2);
        this.drawLine(n, n2, n, n2 + n4);
        if (bl) {
            this.setColor(color.darker());
        } else {
            this.setColor(color.brighter());
        }
        this.drawLine(n + n3, n2 + n4, n, n2 + n4);
        this.drawLine(n + n3, n2 + n4, n + n3, n2);
        this.setColor(color);
        this.setStroke(stroke);
    }

    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        Color color = this.getColor();
        if (bl) {
            this.setColor(color.brighter());
        } else {
            this.setColor(color.darker());
        }
        this.draw(new Rectangle(n, n2, n3, n4), "fill");
        this.setColor(color);
        this.draw3DRect(n, n2, n3, n4, bl);
    }

    public void draw(Shape shape) {
        this.draw(shape, "stroke");
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        AffineTransform affineTransform2 = this.getTransform();
        this.transform(affineTransform);
        boolean bl = this.drawImage(image, 0, 0, imageObserver);
        this.setTransform(affineTransform2);
        return bl;
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        BufferedImage bufferedImage2 = bufferedImageOp.filter(bufferedImage, null);
        this.drawImage(bufferedImage2, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, n, n2), null);
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        String[] stringArray = renderedImage.getPropertyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            hashtable.put(stringArray[i], renderedImage.getProperty(stringArray[i]));
        }
        ColorModel colorModel = renderedImage.getColorModel();
        WritableRaster writableRaster = renderedImage.copyData(null);
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), hashtable);
        AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(renderedImage.getMinX(), renderedImage.getMinY());
        affineTransform2.preConcatenate(affineTransform);
        this.drawImage(bufferedImage, affineTransform2, null);
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.drawRenderedImage(renderableImage.createDefaultRendering(), affineTransform);
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    public void drawString(String string, float f, float f2) {
        if (string != null && string.length() > 0) {
            AttributedString attributedString = new AttributedString(string);
            attributedString.addAttribute(TextAttribute.FONT, this.getFont());
            this.drawString(attributedString.getIterator(), f, f2);
        }
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.drawString(attributedCharacterIterator, (float)n, (float)n2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        if (this.getAccurateTextMode()) {
            TextLayout textLayout = new TextLayout(attributedCharacterIterator, this.getFontRenderContext());
            Shape shape = textLayout.getOutline(AffineTransform.getTranslateInstance(f, f2));
            this.draw(shape, "fill");
        } else {
            this.append("newpath");
            Point2D point2D = this.transform(f, f2);
            this.append(point2D.getX() + " " + point2D.getY() + " moveto");
            StringBuffer stringBuffer = new StringBuffer();
            char c = attributedCharacterIterator.first();
            while (c != '\uffff') {
                if (c == '(' || c == ')') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
                c = attributedCharacterIterator.next();
            }
            this.append("(" + stringBuffer.toString() + ") show");
        }
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        Shape shape = glyphVector.getOutline(f, f2);
        this.draw(shape, "fill");
    }

    public void fill(Shape shape) {
        this.draw(shape, "fill");
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        return shape.intersects(rectangle);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        GraphicsConfiguration graphicsConfiguration = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            GraphicsDevice graphicsDevice = graphicsDeviceArray[i];
            GraphicsConfiguration[] graphicsConfigurationArray = graphicsDevice.getConfigurations();
            if (graphicsConfigurationArray.length <= 0) continue;
            return graphicsConfigurationArray[0];
        }
        return graphicsConfiguration;
    }

    public void setComposite(Composite composite) {
        this._composite = composite;
    }

    public void setPaint(Paint paint) {
        this._paint = paint;
        if (paint instanceof Color) {
            this.setColor((Color)paint);
        }
    }

    public void setStroke(Stroke stroke) {
        if (stroke instanceof BasicStroke) {
            this._stroke = (BasicStroke)stroke;
            this.append(this._stroke.getLineWidth() + " setlinewidth");
            float f = this._stroke.getMiterLimit();
            if (f < 1.0f) {
                f = 1.0f;
            }
            this.append(f + " setmiterlimit");
            this.append(this._stroke.getLineJoin() + " setlinejoin");
            this.append(this._stroke.getEndCap() + " setlinecap");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[ ");
            float[] fArray = this._stroke.getDashArray();
            if (fArray != null) {
                for (int i = 0; i < fArray.length; ++i) {
                    stringBuffer.append(fArray[i] + " ");
                }
            }
            stringBuffer.append("]");
            this.append(stringBuffer.toString() + " 0 setdash");
        }
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return null;
    }

    public void setRenderingHints(Map map) {
    }

    public void addRenderingHints(Map map) {
    }

    public RenderingHints getRenderingHints() {
        return new RenderingHints(null);
    }

    public void translate(int n, int n2) {
        this.translate((double)n, (double)n2);
    }

    public void translate(double d, double d2) {
        this.transform(AffineTransform.getTranslateInstance(d, d2));
    }

    public void rotate(double d) {
        this.rotate(d, 0.0, 0.0);
    }

    public void rotate(double d, double d2, double d3) {
        this.transform(AffineTransform.getRotateInstance(d, d2, d3));
    }

    public void scale(double d, double d2) {
        this.transform(AffineTransform.getScaleInstance(d, d2));
    }

    public void shear(double d, double d2) {
        this.transform(AffineTransform.getShearInstance(d, d2));
    }

    public void transform(AffineTransform affineTransform) {
        this._transform.concatenate(affineTransform);
        this.setTransform(this.getTransform());
    }

    public void setTransform(AffineTransform affineTransform) {
        this._transform = affineTransform == null ? new AffineTransform() : new AffineTransform(affineTransform);
        this.setStroke(this.getStroke());
        this.setFont(this.getFont());
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this._transform);
    }

    public Paint getPaint() {
        return this._paint;
    }

    public Composite getComposite() {
        return this._composite;
    }

    public void setBackground(Color color) {
        if (color == null) {
            color = Color.black;
        }
        this._backgroundColor = color;
    }

    public Color getBackground() {
        return this._backgroundColor;
    }

    public Stroke getStroke() {
        return this._stroke;
    }

    public void clip(Shape shape) {
        if (this._clip == null) {
            this.setClip(shape);
        } else {
            Area area = new Area(this._clip);
            area.intersect(new Area(shape));
            this.setClip(area);
        }
    }

    public FontRenderContext getFontRenderContext() {
        return _fontRenderContext;
    }

    public Graphics create() {
        return new EpsGraphics2D(this);
    }

    public Graphics create(int n, int n2, int n3, int n4) {
        Graphics graphics = this.create();
        graphics.translate(n, n2);
        graphics.clipRect(0, 0, n3, n4);
        return graphics;
    }

    public Color getColor() {
        return this._color;
    }

    public void setColor(Color color) {
        if (color == null) {
            color = Color.black;
        }
        this._color = color;
        if (this.getColorDepth() == 1) {
            float f = 0.0f;
            if ((double)(color.getRed() + color.getGreen() + color.getBlue()) > 381.5) {
                f = 1.0f;
            }
            this.append(f + " setgray");
        } else if (this.getColorDepth() == 2) {
            float f = (float)(color.getRed() + color.getGreen() + color.getBlue()) / 765.0f;
            this.append(f + " setgray");
        } else {
            this.append((float)color.getRed() / 255.0f + " " + (float)color.getGreen() / 255.0f + " " + (float)color.getBlue() / 255.0f + " setrgbcolor");
        }
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color color) {
        this.methodNotSupported();
    }

    public Font getFont() {
        return this._font;
    }

    public void setFont(Font font) {
        if (font == null) {
            font = Font.decode(null);
        }
        this._font = font;
        if (!this.getAccurateTextMode()) {
            this.append("/" + this._font.getPSName() + " findfont " + this._font.getSize() + " scalefont setfont");
        }
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    public FontMetrics getFontMetrics(Font font) {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 1);
        Graphics graphics = bufferedImage.getGraphics();
        return graphics.getFontMetrics(font);
    }

    public Rectangle getClipBounds() {
        if (this._clip == null) {
            return null;
        }
        return this.getClip().getBounds();
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.clip(new Rectangle(n, n2, n3, n4));
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip(new Rectangle(n, n2, n3, n4));
    }

    public Shape getClip() {
        if (this._clip == null) {
            return null;
        }
        try {
            AffineTransform affineTransform = this._transform.createInverse();
            affineTransform.concatenate(this._clipTransform);
            return affineTransform.createTransformedShape(this._clip);
        }
        catch (Exception exception) {
            throw new EpsException("Unable to get inverse of matrix: " + this._transform);
        }
    }

    public void setClip(Shape shape) {
        if (shape != null) {
            if (this._document.isClipSet()) {
                this.append("grestore");
                this.append("gsave");
            } else {
                this._document.setClipSet(true);
                this.append("gsave");
            }
            this.draw(shape, "clip");
            this._clip = shape;
            this._clipTransform = (AffineTransform)this._transform.clone();
        } else {
            if (this._document.isClipSet()) {
                this.append("grestore");
                this._document.setClipSet(false);
            }
            this._clip = null;
        }
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.methodNotSupported();
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        Line2D.Float float_ = new Line2D.Float(n, n2, n3, n4);
        this.draw(float_);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        this.draw(rectangle, "fill");
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        this.draw(rectangle);
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        Color color = this.getColor();
        this.setColor(this.getBackground());
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        this.draw(rectangle, "fill");
        this.setColor(color);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6);
        this.draw(float_);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6);
        this.draw(float_, "fill");
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        Ellipse2D.Float float_ = new Ellipse2D.Float(n, n2, n3, n4);
        this.draw(float_);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        Ellipse2D.Float float_ = new Ellipse2D.Float(n, n2, n3, n4);
        this.draw(float_, "fill");
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        Arc2D.Float float_ = new Arc2D.Float(n, n2, n3, n4, n5, n6, 0);
        this.draw(float_);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        Arc2D.Float float_ = new Arc2D.Float(n, n2, n3, n4, n5, n6, 2);
        this.draw(float_, "fill");
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        if (n > 0) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(nArray[0], nArray2[0]);
            for (int i = 1; i < n; ++i) {
                generalPath.lineTo(nArray[i], nArray2[i]);
            }
            this.draw(generalPath);
        }
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        Polygon polygon = new Polygon(nArray, nArray2, n);
        this.draw(polygon);
    }

    public void drawPolygon(Polygon polygon) {
        this.draw(polygon);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        Polygon polygon = new Polygon(nArray, nArray2, n);
        this.draw(polygon, "fill");
    }

    public void fillPolygon(Polygon polygon) {
        this.draw(polygon, "fill");
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        String string = new String(cArray, n, n2);
        this.drawString(string, n3, n4);
    }

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        String string = new String(byArray, n, n2);
        this.drawString(string, n3, n4);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, Color.white, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, Color.white, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        return this.drawImage(image, n, n2, n3, n4, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n + n3, n2 + n4, 0, 0, n3, n4, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, Color.white, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        if (n >= n3) {
            throw new IllegalArgumentException("dx1 >= dx2");
        }
        if (n5 >= n7) {
            throw new IllegalArgumentException("sx1 >= sx2");
        }
        if (n2 >= n4) {
            throw new IllegalArgumentException("dy1 >= dy2");
        }
        if (n6 >= n8) {
            throw new IllegalArgumentException("sy1 >= sy2");
        }
        this.append("gsave");
        int n9 = n7 - n5;
        int n10 = n8 - n6;
        int n11 = n3 - n;
        int n12 = n4 - n2;
        int[] nArray = new int[n9 * n10];
        PixelGrabber pixelGrabber = new PixelGrabber(image, n5, n6, n7 - n5, n8 - n6, nArray, 0, n9);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        AffineTransform affineTransform = new AffineTransform(this._transform);
        affineTransform.translate(n, n2);
        affineTransform.scale((double)n11 / (double)n9, (double)n12 / (double)n10);
        double[] dArray = new double[6];
        try {
            affineTransform = affineTransform.createInverse();
        }
        catch (Exception exception) {
            throw new EpsException("Unable to get inverse of matrix: " + affineTransform);
        }
        affineTransform.scale(1.0, -1.0);
        affineTransform.getMatrix(dArray);
        String string = "8";
        this.append(n9 + " " + n10 + " " + string + " [" + dArray[0] + " " + dArray[1] + " " + dArray[2] + " " + dArray[3] + " " + dArray[4] + " " + dArray[5] + "]");
        Color color2 = this.getColor();
        this.setColor(this.getBackground());
        this.fillRect(n, n2, n11, n12);
        this.setColor(color2);
        if (this.getColorDepth() == 1) {
            this.append("{currentfile " + n9 + " string readhexstring pop} bind");
            this.append("image");
        } else if (this.getColorDepth() == 2) {
            this.append("{currentfile " + n9 + " string readhexstring pop} bind");
            this.append("image");
        } else {
            this.append("{currentfile 3 " + n9 + " mul string readhexstring pop} bind");
            this.append("false 3 colorimage");
        }
        System.err.println(this.getColorDepth());
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n10; ++i) {
            for (int j = 0; j < n9; ++j) {
                Color color3 = new Color(nArray[j + n9 * i]);
                if (this.getColorDepth() == 1) {
                    if ((double)(color3.getRed() + color3.getGreen() + color3.getBlue()) > 381.5) {
                        stringBuffer.append("ff");
                    } else {
                        stringBuffer.append("00");
                    }
                } else if (this.getColorDepth() == 2) {
                    stringBuffer.append(this.toHexString((color3.getRed() + color3.getGreen() + color3.getBlue()) / 3));
                } else {
                    stringBuffer.append(this.toHexString(color3.getRed()) + this.toHexString(color3.getGreen()) + this.toHexString(color3.getBlue()));
                }
                if (stringBuffer.length() <= 64) continue;
                this.append(stringBuffer.toString());
                stringBuffer = new StringBuffer();
            }
        }
        if (stringBuffer.length() > 0) {
            this.append(stringBuffer.toString());
        }
        this.append("grestore");
        return true;
    }

    public void dispose() {
        this._document = null;
    }

    public void finalize() {
        super.finalize();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        try {
            this._document.write(stringWriter);
            this._document.flush();
            this._document.close();
        }
        catch (IOException iOException) {
            throw new EpsException(iOException.toString());
        }
        return stringWriter.toString();
    }

    public boolean hitClip(int n, int n2, int n3, int n4) {
        if (this._clip == null) {
            return true;
        }
        return this.hit(new Rectangle(n, n2, n3, n4), this._clip, true);
    }

    public Rectangle getClipBounds(Rectangle rectangle) {
        if (this._clip == null) {
            return rectangle;
        }
        Rectangle rectangle2 = this.getClipBounds();
        rectangle.setLocation((int)rectangle2.getX(), (int)rectangle2.getY());
        rectangle.setSize((int)rectangle2.getWidth(), (int)rectangle2.getHeight());
        return rectangle;
    }
}

