/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities;

public class TimTiming {
    long initialtime = -1L;
    long currenttime = -1L;
    boolean intervalTimerOn = false;
    double intervalTimeSecs;
    double nextTimeSecs = this.intervalTimeSecs = 300.0;

    public TimTiming() {
        this.initialtime = System.currentTimeMillis();
    }

    public void setInitialTime() {
        this.initialtime = System.currentTimeMillis();
    }

    public void setIntervalTimeMinutes(double d) {
        if (d <= 0.0) {
            this.intervalTimerOn = false;
        }
        this.intervalTimerOn = true;
        this.nextTimeSecs = this.intervalTimeSecs = d * 60.0;
    }

    public boolean testIntervalTime() {
        if (!this.intervalTimerOn || this.elapsedTime() < this.nextTimeSecs) {
            return false;
        }
        this.nextTimeSecs = this.elapsedTime() + this.intervalTimeSecs;
        return true;
    }

    public void test() {
        String string = TimTiming.runTimeString(0.0);
    }

    public void setCurrentTime() {
        this.currenttime = System.currentTimeMillis();
    }

    public double elapsedTime() {
        this.setCurrentTime();
        return (double)(this.currenttime - this.initialtime) / 1000.0;
    }

    public String elapsedTimeString() {
        return TimTiming.runTimeString(this.elapsedTime());
    }

    public String estimateRemainingTimeString(double d) {
        double d2 = this.estimateRemainingTime(d);
        if (d2 < 0.0) {
            return "gave zero fraction of process elapsed";
        }
        return TimTiming.runTimeString(d2);
    }

    public double estimateRemainingTime(double d) {
        if (d == 0.0) {
            return -1.0;
        }
        return this.elapsedTime() * (1.0 - d) / d;
    }

    public String runTimeString() {
        return TimTiming.runTimeString(this.elapsedTime());
    }

    public static String runTimeString(double d) {
        int n = (int)(d + 0.5);
        int n2 = n % 60;
        int n3 = (n /= 60) % 60;
        int n4 = (n /= 60) % 24;
        int n5 = n / 24;
        String string = "";
        if (n4 > 0) {
            string = string + n4 + "h";
        }
        if (n3 > 0) {
            string = string + n3 + "m ";
        }
        string = string + n2 + "s";
        return string;
    }
}

