/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities;

import java.io.PrintStream;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class TimMessage {
    private int infolevel = 0;
    String lineStart = "";
    String ERROR = "*** ERROR *** ";
    String WARNING = "--- WARNING --- ";
    String Warning = "... Warning ...";

    public TimMessage(int n) {
        this.infolevel = n;
    }

    public void setInformationLevel(int n) {
        this.infolevel = n;
    }

    public int getInformationLevel() {
        return this.infolevel;
    }

    public boolean testInformationLevel(int n) {
        return n <= this.infolevel;
    }

    public void println(int n, String string) {
        if (this.testInformationLevel(n)) {
            System.out.println(this.lineStart + string);
        }
    }

    public void println(String string) {
        System.out.println(this.lineStart + string);
    }

    public void println(PrintStream printStream, String string) {
        printStream.println(this.lineStart + string);
    }

    public void printERROR(String string) {
        System.out.println(this.lineStart + this.ERROR + string);
    }

    public void printWARNING(String string) {
        System.out.println(this.lineStart + this.WARNING + string);
    }

    public void printWarning(int n, String string) {
        this.println(n, this.Warning + string);
    }

    public void printInformationLevel() {
        this.printInformationLevel(System.out);
    }

    public void printInformationLevel(PrintStream printStream) {
        switch (this.infolevel) {
            case -2: {
                this.println(printStream, "Quiet Mode - No information: " + this.infolevel);
                break;
            }
            case -1: {
                this.println(printStream, "Fairly Quiet Mode - Very Little information: " + this.infolevel);
                break;
            }
            case 0: {
                this.println(printStream, "Normal Mode - Some information: " + this.infolevel);
                break;
            }
            case 1: {
                this.println(printStream, "Light Debugging Mode - Extra information: " + this.infolevel);
                break;
            }
            case 2: {
                this.println(printStream, "Full Debugging Mode - Maximum information: " + this.infolevel);
                break;
            }
            default: {
                this.println(printStream, "Unknown level of information: " + this.infolevel);
            }
        }
    }

    public void infoErrorBox(int n, String string, String string2) {
        if (this.getInformationLevel() >= n) {
            JOptionPane.showMessageDialog(null, string, string2, 0);
        }
    }

    public void infoErrorBox(int n, JFrame jFrame, String string, String string2) {
        if (this.getInformationLevel() >= n) {
            JOptionPane.showMessageDialog(jFrame, string, string2, 0);
        }
    }

    public void infoWarningBox(int n, String string, String string2) {
        if (this.getInformationLevel() >= n) {
            JOptionPane.showMessageDialog(null, string, string2, 2);
        }
    }

    public void infoWarningBox(int n, JFrame jFrame, String string, String string2) {
        if (this.getInformationLevel() >= n) {
            JOptionPane.showMessageDialog(jFrame, string, string2, 2);
        }
    }

    public void infoMessageBox(int n, String string, String string2) {
        if (this.getInformationLevel() >= n) {
            JOptionPane.showMessageDialog(null, string);
        }
    }

    public void infoMessageBox(int n, JFrame jFrame, String string) {
        if (this.getInformationLevel() >= n) {
            JOptionPane.showMessageDialog(jFrame, string);
        }
    }
}

