/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities;

public class TimCounting {
    final int totalCount;
    final int dotInterval;
    final int newLineInterval;
    private int currentCount = -1;
    final String DOT;
    boolean messagesOn = true;

    public TimCounting(int n, boolean bl) {
        this.totalCount = n;
        this.dotInterval = n < 100 ? 1 : n / 100;
        this.DOT = ".";
        this.newLineInterval = n < 10 ? 1 : n / 10;
        this.currentCount = 0;
        this.messagesOn = bl;
    }

    public boolean increment() {
        ++this.currentCount;
        if (this.isEndOfLine()) {
            return true;
        }
        if (this.messagesOn && this.isDot()) {
            System.out.print(this.DOT);
        }
        return false;
    }

    public int getCount() {
        return this.currentCount;
    }

    public boolean isDot() {
        return this.currentCount % this.dotInterval == 0;
    }

    public boolean isEndOfLine() {
        return this.currentCount % this.newLineInterval == 0 || this.currentCount == this.totalCount;
    }

    public boolean isFinished() {
        return this.currentCount >= this.totalCount;
    }
}

