/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities.StringUtilities.Filters;

import JavaNotes.TextReader;
import TimUtilities.FileUtilities.FileOutput;
import TimUtilities.StringUtilities.Filters.ImperialPapersFilter;
import TimUtilities.StringUtilities.Filters.StringFilter;
import TimUtilities.StringUtilities.Stemmers.Porter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFileProcessor {
    public int nmax = 1000;

    public static void main(String[] stringArray) {
        String string;
        System.out.println("TextFileProcessor Arguments: inputFileName outputFileName");
        String string2 = "input/MSC-2010subclassinputBVNLS.dat";
        int n = 0;
        if (stringArray.length > n) {
            string2 = stringArray[n];
        }
        System.out.println("--- Using input file " + string2);
        String string3 = "output/MSC-2010subclass";
        if (stringArray.length > ++n) {
            string3 = stringArray[n];
        }
        System.out.println("--- Using output file name root " + string3);
        int n2 = 1;
        if (stringArray.length > ++n) {
            n2 = Integer.parseInt(stringArray[n]);
        }
        System.out.println("--- Ignoring column " + n2);
        int n3 = -1;
        String string4 = "UNKNOWN";
        if (string2.endsWith("inputELS.dat")) {
            n3 = 1;
            string4 = "outputELS.dat";
        }
        if (string2.endsWith(".txt")) {
            n3 = 1;
            string4 = ".txt";
        }
        if (string2.endsWith("inputBVNLS.dat")) {
            n3 = 2;
            string4 = "outputBVNLS.dat";
        }
        boolean bl = false;
        if (stringArray.length > ++n) {
            bl = StringFilter.trueString(stringArray[n].charAt(1));
        }
        System.out.println("--- Porter stemming " + StringFilter.onOffString(bl));
        String string5 = "\t";
        String string6 = "\t";
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        TreeMap<String, Integer> treeMap2 = new TreeMap<String, Integer>();
        ImperialPapersFilter imperialPapersFilter = new ImperialPapersFilter(2, 3, true);
        int n4 = 1;
        boolean bl2 = true;
        boolean bl3 = false;
        switch (n3) {
            case 1: {
                System.out.println("--- Processing file assuming simple list of words ");
                bl3 = false;
                TextFileProcessor.processWordListFile(string2, string3 + string4, n2, bl3, string6, treeMap, treeMap2, imperialPapersFilter, n4, bl2);
                break;
            }
            case 2: {
                System.out.println("--- Processing file assuming index column ");
                TextFileProcessor.processIndexSentenceFile(string2, string3 + string4, string5, string6, bl, treeMap, treeMap2, imperialPapersFilter, n4, bl2);
                break;
            }
            default: {
                throw new RuntimeException("Unknown mode " + n3);
            }
        }
        System.out.println("Applied Filter " + imperialPapersFilter.description());
        if (treeMap != null) {
            string = string3 + "ptStemMap.dat";
            FileOutput.FileOutputMap(string, string6, treeMap, true);
        }
        if (treeMap2 != null) {
            string = string3 + "AcceptedCountMap.dat";
            FileOutput.FileOutputMap(string, string6, treeMap2, true);
        }
        string = string3 + "ptRejectList.dat";
        imperialPapersFilter.FileOutputRejectedList(string, bl2);
    }

    public static void processIndexSentenceFile(String string, String string2, String string3, String string4, boolean bl, Map<String, String> map, Map<String, Integer> map2, StringFilter stringFilter, int n, boolean bl2) {
        PrintStream printStream;
        TextReader textReader;
        boolean bl3 = true;
        if (map == null) {
            bl3 = false;
        }
        boolean bl4 = true;
        if (n < 2) {
            bl4 = false;
        }
        boolean bl5 = true;
        if (map2 == null) {
            bl5 = false;
        }
        int n2 = -1;
        TreeSet<String> treeSet = new TreeSet<String>();
        Porter porter = null;
        if (bl) {
            porter = new Porter();
        }
        try {
            System.out.println(" Opening Input File:  " + string);
            textReader = new TextReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("Input file " + string + " not found, " + fileNotFoundException);
        }
        try {
            System.out.println(" Opening Output File: " + string2);
            printStream = new PrintStream(new FileOutputStream(string2));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("Output file " + string2 + " not found, " + fileNotFoundException);
        }
        int n3 = 0;
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer(200);
        int n5 = 0;
        try {
            while (!textReader.eof()) {
                n4 = 0;
                String string5 = textReader.getln();
                if (bl4 && ++n3 % n != 1) continue;
                n5 = string5.indexOf(string3);
                if (n5 < 0) {
                    throw new RuntimeException("*** Too few columns on line " + n3 + " wanted at least two columns.");
                }
                String string6 = string5.substring(0, n5);
                if (treeSet.contains(string6)) continue;
                treeSet.add(string6);
                printStream.print(string6);
                if (bl2) {
                    System.out.print(n3 + ": \t" + string6 + "- \t");
                }
                ++n5;
                while (n5 < string5.length()) {
                    stringBuffer.setLength(0);
                    while (n5 < string5.length()) {
                        char c;
                        if ((c = string5.charAt(n5++)) >= 'a' && c <= 'z') {
                            stringBuffer.append(c);
                            continue;
                        }
                        if (c >= 'A' && c <= 'Z') {
                            stringBuffer.append((char)(c + 32));
                            continue;
                        }
                        if (c >= '0' && c <= '9') {
                            stringBuffer.append(c);
                            continue;
                        }
                        if (c == '\'' || c == '-' || c == '?') continue;
                    }
                    if (stringBuffer.length() == 0) continue;
                    String string7 = stringBuffer.toString();
                    if (stringFilter.isAcceptableElseRemember(string7)) {
                        String string8 = bl ? porter.stem(string7) : string7;
                        printStream.print(string4 + string8);
                        if (bl5) {
                            n2 = 1;
                            if (map2.containsKey(string8)) {
                                n2 = map2.get(string8) + 1;
                            }
                            map2.put(string8, n2);
                        }
                        if (bl2 && string8.length() != string7.length()) {
                            System.out.print("\t" + string7 + "->" + string8 + " ");
                        }
                        if (!bl3 || string8.length() == string7.length()) continue;
                        map.put(string7, string8);
                        continue;
                    }
                    if (!bl2) continue;
                    System.out.print("\t" + string7 + "<-### ");
                }
                if (bl2) {
                    System.out.println();
                }
                printStream.println();
            }
        }
        catch (TextReader.Error error) {
            throw new RuntimeException("*** Input Error on line " + n3 + " column " + n4 + ": " + error.getMessage());
        }
        finally {
            textReader.close();
            printStream.close();
        }
        System.out.println(" Finished " + string2 + " processed " + treeSet.size() + " sentences, stemmed " + map.size() + " words and filtered out " + stringFilter.numberRejectedString() + " words");
    }

    public static void processWordListFile(String string, String string2, int n, boolean bl, String string3, Map<String, String> map, Map<String, Integer> map2, StringFilter stringFilter, int n2, boolean bl2) {
        PrintStream printStream;
        TextReader textReader;
        boolean bl3 = true;
        if (map == null) {
            bl3 = false;
        }
        boolean bl4 = true;
        if (map2 == null) {
            bl4 = false;
        }
        int n3 = -1;
        boolean bl5 = true;
        if (n2 < 2) {
            bl5 = false;
        }
        Porter porter = new Porter();
        try {
            System.out.println(" Opening Input File:  " + string);
            textReader = new TextReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("Input file " + string + " not found, " + fileNotFoundException);
        }
        try {
            System.out.println(" Opening Output File: " + string2);
            printStream = new PrintStream(new FileOutputStream(string2));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("Output file " + string2 + " not opened, " + fileNotFoundException);
        }
        int n4 = 0;
        int n5 = 0;
        try {
            while (!textReader.eof()) {
                n5 = 0;
                if (bl5 && ++n4 % n2 != 1) {
                    textReader.getln();
                    continue;
                }
                if (bl2) {
                    System.out.print(n4 + ": ");
                }
                while (!textReader.eoln()) {
                    String string4 = textReader.getWord();
                    ++n5;
                    if (bl2) {
                        System.out.print("\t" + string4);
                    }
                    if (n5 == n) {
                        if (bl) {
                            printStream.print(n4 - 1 + string3);
                            continue;
                        }
                        printStream.print(string4 + string3);
                        continue;
                    }
                    if (stringFilter.isAcceptableElseRemember(string4)) {
                        String string5 = porter.stem(string4);
                        printStream.print(string5 + string3);
                        if (bl4) {
                            n3 = 1;
                            if (map2.containsKey(string5)) {
                                n3 = map2.get(string5) + 1;
                            }
                            map2.put(string5, n3);
                        }
                        if (bl2 && string5.length() != string4.length()) {
                            System.out.print("->" + string5);
                        }
                        if (!bl3 || string5.length() == string4.length()) continue;
                        map.put(string4, string5);
                        continue;
                    }
                    if (!bl2) continue;
                    System.out.print("<-### " + string3);
                }
                if (bl2) {
                    System.out.println();
                }
                printStream.println();
            }
        }
        catch (TextReader.Error error) {
            throw new RuntimeException("*** Input Error on line " + n4 + " column " + n5 + ": " + error.getMessage());
        }
        finally {
            textReader.close();
            printStream.close();
        }
        System.out.println(" Finished " + string2 + " stemmed " + map.size() + " words and filtered out " + stringFilter.numberRejectedString() + " words");
    }

    public static void printMap(PrintStream printStream, String string, Map<String, String> map) {
        Set<String> set = map.keySet();
        for (String string2 : set) {
            printStream.println(string2 + string + map.get(string2));
        }
    }

    public static boolean isAlphabetic(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isLetter(string.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

