/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities.StringUtilities.Filters;

import JavaNotes.TextReader;
import TimUtilities.FileUtilities.FileOutput;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.TreeSet;

public class StringFilter {
    protected TreeSet<String> rejectedList;

    protected StringFilter() {
    }

    protected StringFilter(boolean bl) {
        if (bl) {
            this.rejectedList = new TreeSet();
        }
    }

    public boolean hasRejectedList() {
        return this.rejectedList != null;
    }

    public boolean isAcceptable(String string) {
        return false;
    }

    public boolean isAcceptableElseRemember(String string) {
        if (this.rejectedList != null) {
            this.rejectedList.add(string);
        }
        return false;
    }

    public String description() {
        return "Basic String filter, always false, rejection list " + (this.hasRejectedList() ? "on" : "off");
    }

    public static boolean hasLetter(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (!Character.isLetter(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLetters(String string, int n) {
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (!Character.isLetter(string.charAt(i)) || --n != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isDigit(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLetter(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isLetter(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLetterOrDigit(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isLetterOrDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String afterLastString(String string, String string2) {
        int n = string.lastIndexOf(string2);
        n = n < 0 ? 0 : (n += string2.length());
        if (n < string.length()) {
            return string.substring(n);
        }
        return "";
    }

    public static String beforeLastString(String string, String string2) {
        int n = string.lastIndexOf(string2);
        if (n < 0) {
            n = string.length();
        }
        return string.substring(0, n);
    }

    public String numberRejectedString() {
        if (this.rejectedList == null) {
            return "unknown";
        }
        return Integer.toString(this.rejectedList.size());
    }

    public void printRejectedList(PrintStream printStream) {
        if (this.rejectedList != null) {
            for (String string : this.rejectedList) {
                printStream.println(string);
            }
        }
    }

    public void FileOutputRejectedList(String string, boolean bl) {
        if (this.rejectedList == null) {
            if (bl) {
                System.err.println("!!! Warning no rejected strings list in StringFilter, no file " + string + " produced");
            }
            return;
        }
        FileOutput.FileOutputCollection(string, this.rejectedList, bl);
    }

    public static boolean trueString(String string) {
        if (string.length() < 1) {
            return false;
        }
        return StringFilter.trueString(string.charAt(0));
    }

    public static boolean trueString(char c) {
        return c == 't' || c == 'T' || c == 'y' || c == 'Y';
    }

    public static String onOffString(boolean bl) {
        return bl ? "ON" : "OFF";
    }

    public static String toDecimal(String string, String string2) {
        if (string.length() < 1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(String.format("%3d", Character.valueOf(string.charAt(0))));
        for (int i = 1; i < string.length(); ++i) {
            stringBuffer.append(string2);
            stringBuffer.append(String.format("%3d", Character.valueOf(string.charAt(i))));
        }
        return stringBuffer.toString();
    }

    public static String toHex(String string, String string2) {
        if (string.length() < 1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(String.format("%02x", string.charAt(0)));
        for (int i = 1; i < string.length(); ++i) {
            stringBuffer.append(string2);
            stringBuffer.append(String.format("%02x", string.charAt(i)));
        }
        return stringBuffer.toString();
    }

    public static String stripSpaces() {
        return null;
    }

    public static void processStringFile(String string, String string2, int n, String string3, StringFilter stringFilter, int n2, boolean bl) {
        PrintStream printStream;
        TextReader textReader;
        boolean bl2 = n2 >= 2;
        try {
            System.out.println(" Opening Input File:  " + string);
            textReader = new TextReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("Input file " + string + " not found, " + fileNotFoundException);
        }
        try {
            System.out.println(" Opening Output File: " + string2);
            printStream = new PrintStream(new FileOutputStream(string2));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("Output file " + string2 + " not found, " + fileNotFoundException);
        }
        int n3 = 0;
        int n4 = 0;
        try {
            while (!textReader.eof()) {
                if (bl2 && ++n3 % n2 != 1) {
                    textReader.getln();
                    continue;
                }
                if (bl) {
                    System.out.print(n3 + ": ");
                }
                while (!textReader.eoln()) {
                    String string4 = textReader.getWord();
                    ++n4;
                    if (bl) {
                        System.out.print("\t" + string4);
                    }
                    if (n4 == n || stringFilter.isAcceptableElseRemember(string4)) {
                        printStream.print(string4 + string3);
                        continue;
                    }
                    if (!bl) continue;
                    System.out.print("<-### ");
                }
                if (bl) {
                    System.out.println();
                }
                printStream.println();
            }
        }
        catch (TextReader.Error error) {
            throw new RuntimeException("*** Input Error on line " + n3 + " column " + n4 + ": " + error.getMessage());
        }
        finally {
            textReader.close();
            printStream.close();
        }
    }
}

