/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities.StringUtilities.Filters;

import TimUtilities.StringUtilities.Filters.StopWords;
import TimUtilities.StringUtilities.Filters.StringFilter;
import java.util.TreeSet;

public class ImperialPapersFilter
extends StringFilter {
    public final int minLength;
    public final int minLetters;
    public final boolean keepRejectList;
    public String[] stopWordList;

    public ImperialPapersFilter(int n, int n2, boolean bl) {
        this.minLength = n;
        this.minLetters = n2;
        this.keepRejectList = bl;
        if (this.keepRejectList) {
            this.rejectedList = new TreeSet();
        }
        this.stopWordList = StopWords.MySQL_STOP_WORDS_EDITED;
    }

    public ImperialPapersFilter(int n, int n2, String[] stringArray, boolean bl) {
        this.minLength = n;
        this.minLetters = n2;
        this.keepRejectList = bl;
        if (this.keepRejectList) {
            this.rejectedList = new TreeSet();
        }
        this.stopWordList = stringArray;
    }

    public boolean isAcceptable(String string) {
        int n = string.length();
        if (n < this.minLength) {
            this.rejectedList.add(string);
            return false;
        }
        if (this.isStopWord(string)) {
            this.rejectedList.add(string);
            return false;
        }
        int n2 = this.minLetters;
        for (int i = 0; i < n; ++i) {
            if (!Character.isLetter(string.charAt(i)) || --n2 != 0) continue;
            return true;
        }
        return false;
    }

    public boolean isAcceptableElseRemember(String string) {
        int n = string.length();
        if (n < this.minLength) {
            if (this.hasRejectedList()) {
                this.rejectedList.add(string);
            }
            return false;
        }
        if (this.isStopWord(string)) {
            if (this.hasRejectedList()) {
                this.rejectedList.add(string);
            }
            return false;
        }
        int n2 = this.minLetters;
        for (int i = 0; i < n; ++i) {
            if (!Character.isLetter(string.charAt(i)) || --n2 != 0) continue;
            return true;
        }
        if (this.hasRejectedList()) {
            this.rejectedList.add(string);
        }
        return false;
    }

    public boolean isStopWord(String string) {
        for (int i = 0; i < this.stopWordList.length; ++i) {
            if (!this.stopWordList[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public String description() {
        return "Imperial Papers filter, rejects strings with less than " + this.minLength + " letters, and not in StopWords.MySQL_STOP_WORDS_EDITED, rejected list " + (this.hasRejectedList() ? "on" : "off");
    }
}

