/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities;

public class StatisticalQuantity {
    static double MAX = 7.0E99;
    public int count;
    private double total;
    private double squaretotal;
    public double maximum;
    public double minimum;
    private double average;
    private double sigma;
    private double error;
    private double secondmoment;
    private boolean updatestatistics;

    public StatisticalQuantity() {
        this.setDefaultValues(MAX, -MAX);
    }

    public StatisticalQuantity(double d, double d2) {
        this.setDefaultValues(d2, d);
    }

    public StatisticalQuantity(StatisticalQuantity statisticalQuantity) {
        if (statisticalQuantity == null) {
            this.setDefaultValues(MAX, -MAX);
            return;
        }
        this.total = statisticalQuantity.total;
        this.squaretotal = statisticalQuantity.squaretotal;
        this.count = statisticalQuantity.count;
        this.maximum = statisticalQuantity.maximum;
        this.minimum = statisticalQuantity.minimum;
        this.updatestatistics = true;
        this.average = 0.0;
        this.secondmoment = 0.0;
        this.sigma = 0.0;
        this.error = 0.0;
    }

    public void setDefaultValues(double d, double d2) {
        this.total = 0.0;
        this.squaretotal = 0.0;
        this.count = 0;
        this.average = 0.0;
        this.secondmoment = 0.0;
        this.sigma = 0.0;
        this.error = 0.0;
        this.maximum = d2;
        this.minimum = d;
        this.updatestatistics = false;
    }

    public void add(double d) {
        this.updatestatistics = true;
        this.total += d;
        this.squaretotal += d * d;
        ++this.count;
        if (this.count > 1) {
            if (this.maximum < d) {
                this.maximum = d;
            }
            if (this.minimum > d) {
                this.minimum = d;
            }
        } else {
            this.maximum = d;
            this.minimum = d;
        }
    }

    public double getTotal() {
        return this.total;
    }

    public double getAverage() {
        if (this.updatestatistics) {
            this.calcStatistics();
        }
        return this.average;
    }

    public double getSecondMoment() {
        if (this.updatestatistics) {
            this.calcStatistics();
        }
        return this.secondmoment;
    }

    public double getSigma() {
        if (this.updatestatistics) {
            this.calcStatistics();
        }
        return this.sigma;
    }

    public double getError() {
        if (this.updatestatistics) {
            this.calcStatistics();
        }
        return this.error;
    }

    private void calcStatistics() {
        if (!this.updatestatistics) {
            return;
        }
        this.updatestatistics = false;
        if (this.count == 0) {
            return;
        }
        this.average = this.total / (double)this.count;
        this.secondmoment = this.squaretotal / (double)this.count;
        if (this.count > 1) {
            this.sigma = Math.sqrt(this.secondmoment - this.average * this.average);
            this.error = this.sigma / Math.sqrt(this.count);
        } else {
            this.sigma = 0.0;
            this.error = 0.0;
        }
    }
}

