/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities;

public class Range {
    public double min;
    public double max;
    public double step;
    public double value;
    public int type = -1;

    public Range() {
        this.min = 8.0E99;
        this.max = -this.min;
        this.step = 1.0;
        this.value = this.min;
        this.type = -1;
    }

    public Range(double d) {
        if (Math.abs(d) > 1.0E-6) {
            this.min = d;
            this.max = Math.abs(d) * 0.1 + d;
            this.step = d;
            this.value = d;
        } else {
            this.min = d;
            this.max = d + 2.0E-6;
            this.step = 1.0E-5;
            this.value = d;
        }
        this.type = -1;
    }

    public Range(Range range) {
        this.min = range.min;
        this.max = range.max;
        this.step = range.step;
        this.value = range.value;
        this.type = range.type;
    }

    public String toString(String string) {
        String string2 = this.min + string + this.max + string + this.step + string + this.value + string + this.getTypeString() + string + this.count();
        return string2;
    }

    public String getTypeString() {
        String string = "Unknown";
        switch (this.type) {
            case -1: {
                string = "one value";
                break;
            }
            case 1: {
                string = "multiply";
                break;
            }
            case 0: {
                string = "add";
                break;
            }
            default: {
                string = "UNKNOWN";
            }
        }
        return string;
    }

    public int count() {
        int n;
        switch (this.type) {
            case -1: {
                n = 1;
                break;
            }
            case 1: {
                n = (int)(Math.log(this.max / this.min) / Math.log(this.step)) + 1;
                break;
            }
            case 0: {
                n = (int)((this.max - this.min) / this.step) + 1;
                break;
            }
            default: {
                n = 999;
            }
        }
        return n > 1 ? n : 1;
    }

    public double nextValue() {
        switch (this.type) {
            case -1: {
                this.value = this.max * 2.0;
                break;
            }
            case 1: {
                this.value *= this.step;
                break;
            }
            case 0: {
                this.value += this.step;
                break;
            }
            default: {
                this.value = this.max * 2.0;
            }
        }
        return this.value;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getStep() {
        return this.step;
    }

    public double getValue() {
        return this.value;
    }
}

