/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities;

import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class LookAndFeel {
    static String LOOKANDFEEL;

    public LookAndFeel() {
        LOOKANDFEEL = "System";
    }

    public LookAndFeel(String string) {
        LOOKANDFEEL = string;
    }

    public static void initLookAndFeel() {
        String string = null;
        if (LOOKANDFEEL != null) {
            if (LOOKANDFEEL.equals("Metal")) {
                LookAndFeel.metalLookAndFeel();
                return;
            }
            if (LOOKANDFEEL.equals("System")) {
                LookAndFeel.systemLookAndFeel();
                return;
            }
            if (LOOKANDFEEL.equals("Motif")) {
                string = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
            } else if (LOOKANDFEEL.equals("GTK+")) {
                string = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
            } else {
                System.err.println("Unexpected value of LOOKANDFEEL specified: " + LOOKANDFEEL);
                string = UIManager.getCrossPlatformLookAndFeelClassName();
            }
        }
        LookAndFeel.tryLookAndFeel(string);
    }

    public static void systemLookAndFeel() {
        LookAndFeel.tryLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }

    public static void metalLookAndFeel() {
        LookAndFeel.tryLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
    }

    public static void tryLookAndFeel(String string) {
        try {
            UIManager.setLookAndFeel(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Couldn't find class for specified look and feel:" + string);
            System.err.println("Did you include the L&F library in the class path?");
            System.err.println("Using the default look and feel.");
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            System.err.println("Can't use the specified look and feel (" + string + ") on this platform.");
            System.err.println("Using the default look and feel.");
        }
        catch (Exception exception) {
            System.err.println("Couldn't get specified look and feel (" + string + "), for some reason.");
            System.err.println("Using the default look and feel.");
            exception.printStackTrace();
        }
    }
}

