/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities;

import java.io.PrintStream;

public class KMLGenerator {
    static final String firstLine = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    static final String secondLine = "<kml xmlns=\"http://www.opengis.net/kml/2.2\">";

    public static String startTag(String string) {
        return "<" + string + ">";
    }

    public static String endTag(String string) {
        return "</" + string + ">";
    }

    public static void printlnStartTag(PrintStream printStream, String string) {
        printStream.println(KMLGenerator.startTag(string));
    }

    public static void printlnEndTag(PrintStream printStream, String string) {
        printStream.println(KMLGenerator.endTag(string));
    }

    public static void printInitialLines(PrintStream printStream) {
        printStream.println(firstLine);
        printStream.println(secondLine);
        KMLGenerator.printlnStartTag(printStream, "Document");
    }

    public static void printFinalLines(PrintStream printStream) {
        KMLGenerator.printlnEndTag(printStream, "Document");
        KMLGenerator.printlnEndTag(printStream, "kml");
    }

    public static void printTextTag(PrintStream printStream, String string, String string2) {
        KMLGenerator.printlnStartTag(printStream, string);
        printStream.println(string2);
        KMLGenerator.printlnEndTag(printStream, string);
    }

    public static String textTag(String string, String string2) {
        return KMLGenerator.startTag(string) + string2 + KMLGenerator.endTag(string);
    }

    public static void printName(PrintStream printStream, String string) {
        KMLGenerator.printTextTag(printStream, "name", string);
    }

    public static void printDescription(PrintStream printStream, String string) {
        KMLGenerator.printTextTag(printStream, "description", string);
    }

    public static void printLookAt(PrintStream printStream, double d, double d2, double d3) {
        String string = "LookAt";
        KMLGenerator.printlnStartTag(printStream, string);
        printStream.println(KMLGenerator.textTag("longitude", Double.toString(d2)));
        printStream.println(KMLGenerator.textTag("latitude", Double.toString(d)));
        printStream.println(KMLGenerator.textTag("altitude", Double.toString(d3)));
        KMLGenerator.printlnEndTag(printStream, string);
    }

    public static void printPlacemarkStart(PrintStream printStream) {
        KMLGenerator.printlnStartTag(printStream, "Placemark");
    }

    public static void printPlacemarkStart(PrintStream printStream, String string, String string2) {
        KMLGenerator.printlnStartTag(printStream, "Placemark");
        KMLGenerator.printTextTag(printStream, "name", string);
        KMLGenerator.printTextTag(printStream, "description", string2);
    }

    public static void printPlacemarkEnd(PrintStream printStream) {
        KMLGenerator.printlnEndTag(printStream, "Placemark");
    }

    public static void printPlacemarkPoint(PrintStream printStream, String string, String string2, double d, double d2) {
        KMLGenerator.printPlacemarkStart(printStream, string, string2);
        KMLGenerator.printPoint(printStream, d, d2);
        KMLGenerator.printPlacemarkEnd(printStream);
    }

    public static void printPoint(PrintStream printStream, double d, double d2) {
        String string = "Point";
        KMLGenerator.printlnStartTag(printStream, string);
        KMLGenerator.printCoordinates(printStream, d, d2);
        KMLGenerator.printlnEndTag(printStream, string);
    }

    public static String coordinateString(double d, double d2) {
        return d2 + ", " + d + ", 0";
    }

    public static void printCoordinates(PrintStream printStream, double d, double d2) {
        String string = "coordinates";
        printStream.println(KMLGenerator.startTag(string) + KMLGenerator.coordinateString(d, d2) + KMLGenerator.endTag(string));
    }

    public static void printCoordinates(PrintStream printStream, double d, double d2, double d3, double d4) {
        String string = "coordinates";
        KMLGenerator.printlnStartTag(printStream, string);
        printStream.println(KMLGenerator.coordinateString(d, d2));
        printStream.println(KMLGenerator.coordinateString(d3, d4));
        KMLGenerator.printlnEndTag(printStream, string);
    }

    public static void printCoordinates(PrintStream printStream, double[] dArray, double[] dArray2) {
        String string = "coordinates";
        KMLGenerator.printlnStartTag(printStream, string);
        for (int i = 0; i < dArray.length; ++i) {
            printStream.println(KMLGenerator.coordinateString(dArray[i], dArray2[i]));
        }
        KMLGenerator.printlnEndTag(printStream, string);
    }

    public static void printPlacemarkLine(PrintStream printStream, boolean bl, String string, String string2, double d, double d2, double d3, double d4) {
        KMLGenerator.printPlacemarkStart(printStream, string, string2);
        String string3 = "LineString";
        KMLGenerator.printlnStartTag(printStream, string3);
        printStream.println(KMLGenerator.startTag("tessellate") + (bl ? 1 : 0) + KMLGenerator.endTag("tessellate"));
        KMLGenerator.printCoordinates(printStream, d, d2, d3, d4);
        KMLGenerator.printlnEndTag(printStream, string3);
        KMLGenerator.printPlacemarkEnd(printStream);
    }
}

