/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities;

import java.awt.Color;
import java.io.PrintStream;

public class JavaColours {
    static final int NUMBERSHADES = 6;
    static final int MAXDEVIATION = 204;
    static final Color[] FIXEDCOLOUR = new Color[]{Color.WHITE, Color.RED, Color.GREEN, Color.BLUE, Color.MAGENTA, Color.CYAN, Color.PINK, Color.ORANGE, Color.YELLOW, Color.GRAY, Color.DARK_GRAY, Color.LIGHT_GRAY, Color.BLACK};
    static final Color DARKRED = new Color(96, 0, 0);
    static final Color DARKGREEN = new Color(0, 96, 0);
    static final Color DARKBLUE = new Color(0, 0, 96);
    static final Color X11DARKORANGE = new Color(255, 140, 0);
    static final Color X11PURPLE = new Color(128, 0, 128);
    static final Color OLIVE = new Color(102, 102, 0);
    static final Color X11DARKGOLDENROD = new Color(184, 134, 11);
    static final Color X11PINK = new Color(155, 192, 203);
    static final Color[] TIMCOLOUR = new Color[]{Color.WHITE, Color.RED, Color.GREEN, Color.BLUE, Color.CYAN, Color.MAGENTA, Color.YELLOW, DARKRED, DARKGREEN, DARKBLUE, X11DARKORANGE, X11PURPLE, OLIVE, X11DARKGOLDENROD, X11PINK, Color.DARK_GRAY, Color.LIGHT_GRAY, Color.BLACK};
    private final int numberColours;
    private final int shadeScale;
    public Color[] javaColour;

    public JavaColours() {
        this.numberColours = TIMCOLOUR.length - 1;
        this.shadeScale = -1;
        this.javaColour = new Color[this.numberColours + 1];
        System.arraycopy(TIMCOLOUR, 0, this.javaColour, 0, TIMCOLOUR.length);
    }

    public JavaColours(int n, boolean bl) {
        if (bl && n < TIMCOLOUR.length) {
            this.shadeScale = -1;
            this.numberColours = n;
            this.javaColour = new Color[this.numberColours + 1];
            this.javaColour[0] = Color.WHITE;
            this.javaColour[this.numberColours] = Color.BLACK;
            System.arraycopy(TIMCOLOUR, 1, this.javaColour, 1, this.numberColours - 1);
        } else {
            this.numberColours = n >= 1224 ? 1224 : n;
            if (this.numberColours - 2 < 6) {
                this.shadeScale = 0;
            } else {
                int n2 = (this.numberColours - 2) / 6;
                this.shadeScale = Math.round(204.0f / (float)n2);
            }
            this.setColours();
        }
    }

    public int getNumberColours() {
        return this.numberColours;
    }

    public Color getColour(int n) {
        if (n < 0) {
            return this.javaColour[0];
        }
        if (n >= this.numberColours) {
            return this.javaColour[this.numberColours];
        }
        return this.javaColour[n];
    }

    private void setColours() {
        this.javaColour = new Color[this.numberColours + 1];
        this.javaColour[0] = Color.WHITE;
        this.javaColour[this.numberColours] = Color.BLACK;
        for (int i = 1; i < this.numberColours; ++i) {
            this.javaColour[i] = this.selectColour(i);
        }
    }

    public Color selectColour(int n) {
        if (n >= this.numberColours) {
            return Color.BLACK;
        }
        if (n <= 0) {
            return Color.WHITE;
        }
        int n2 = 255 - (n - 1) / 6 * this.shadeScale;
        Color color = Color.BLACK;
        switch ((n - 1) % 6) {
            case 0: {
                color = new Color(n2, 0, 0);
                break;
            }
            case 1: {
                color = new Color(0, n2, 0);
                break;
            }
            case 2: {
                color = new Color(0, 0, n2);
                break;
            }
            case 3: {
                color = new Color(n2, n2, 0);
                break;
            }
            case 4: {
                color = new Color(0, n2, n2);
                break;
            }
            case 5: {
                color = new Color(n2, 0, n2);
                break;
            }
            case 6: {
                color = n2 < 255 ? new Color(n2, n2, n2) : Color.BLACK;
            }
        }
        return color;
    }

    public String RGB(int n) {
        Color color = this.javaColour[n % this.javaColour.length];
        return JavaColours.RGB(color);
    }

    public static String RGB(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        String string = String.format("%02x%02x%02x", n, n2, n3);
        return string;
    }

    public Color getFixedColour(int n) {
        if (n >= FIXEDCOLOUR.length || n >= this.numberColours) {
            return Color.BLACK;
        }
        if (n <= 0) {
            return Color.WHITE;
        }
        return FIXEDCOLOUR[n];
    }

    public Color getTimColour(int n) {
        if (n >= TIMCOLOUR.length || n >= this.numberColours) {
            return Color.BLACK;
        }
        if (n <= 0) {
            return Color.WHITE;
        }
        return TIMCOLOUR[n];
    }

    public void printColourInfo(PrintStream printStream) {
        printStream.println("Number of Colours " + this.numberColours + ", using " + (this.shadeScale < 0 ? "fixed" : "variable") + " colour scheme");
    }

    public void printColour(PrintStream printStream, int n) {
        Color color = this.javaColour[n];
        printStream.println("Colour " + n + ", R=" + color.getRed() + ", G=" + color.getGreen() + ", B=" + color.getBlue() + ", RGB=" + this.RGB(n));
    }

    public void printAllColours(PrintStream printStream) {
        for (int i = 0; i <= this.numberColours; ++i) {
            this.printColour(printStream, i);
        }
    }
}

