/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities;

import java.io.PrintStream;

public class GeneralMode {
    private int uniqueNameLength = 3;
    private int number = 0;
    public String[] name;
    String[] longName;

    public GeneralMode() {
    }

    public GeneralMode(String[] stringArray, String[] stringArray2) {
        this.setUp(stringArray, stringArray2, 0);
    }

    public GeneralMode(String[] stringArray, String[] stringArray2, int n) {
        this.setUp(stringArray, stringArray2, n);
    }

    public GeneralMode(GeneralMode generalMode) {
        this.name = generalMode.name;
        this.longName = generalMode.longName;
        this.uniqueNameLength = generalMode.uniqueNameLength;
        this.set(generalMode.number);
    }

    protected void setUp(String[] stringArray, String[] stringArray2, int n) {
        this.name = stringArray;
        this.longName = stringArray2;
        if (this.name.length != this.longName.length) {
            throw new IllegalArgumentException("name and longName have different lengths" + this.name.length + " != " + this.longName.length);
        }
        this.set(n);
    }

    protected void setUp(String[] stringArray, String[] stringArray2, String string) {
        this.name = stringArray;
        this.longName = stringArray2;
        if (this.name.length != this.longName.length) {
            throw new IllegalArgumentException("name and longName have different lengths" + this.name.length + " != " + this.longName.length);
        }
        this.setFromName(string);
    }

    public void set(double d) {
        this.set(Math.round(d));
    }

    public void set(int n) {
        if (!this.testModeNumber(n)) {
            throw new IllegalArgumentException("Mode number must be between 0 and " + this.getNumberModes());
        }
        this.number = n;
    }

    public void setFromDouble(String string) {
        this.set(Double.parseDouble(string));
    }

    public void setFromName(String string) {
        this.set(this.getIndex(string));
    }

    public boolean setFromExactName(String string) {
        int n = this.getIndexFromExactName(string);
        if (n < 0) {
            return false;
        }
        this.set(n);
        return true;
    }

    public boolean testModeNumber(int n) {
        return n >= 0 && n < this.name.length;
    }

    public int getNumber() {
        return this.number;
    }

    public int getIndex(String string) {
        String string2 = string.substring(0, this.uniqueNameLength);
        for (int i = 0; i < this.name.length; ++i) {
            if (!this.name[i].startsWith(string2)) continue;
            return i;
        }
        return -1;
    }

    public static int getIndex(String string, String[] stringArray, int n) {
        String string2 = string.substring(0, n);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(string2)) continue;
            return i;
        }
        return -1;
    }

    public int getIndexFromExactName(String string) {
        for (int i = 0; i < this.name.length; ++i) {
            if (!this.name[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public void setUniqueNameLength(int n) {
        this.uniqueNameLength = n;
    }

    public boolean isMode(String string) {
        int n = this.getIndex(string);
        return this.number == n;
    }

    public void print(PrintStream printStream, String string) {
        printStream.println(string + " Output mode is " + this.getNumber());
    }

    public String toString() {
        return this.name[this.number];
    }

    public String toLongString() {
        return this.longName[this.number];
    }

    public void listAll(PrintStream printStream, String string, String string2) {
        for (int i = 0; i < this.name.length; ++i) {
            printStream.println(string + this.longName[i] + " (" + this.name[i] + ")");
        }
    }

    public String listAllShort(String string, String string2) {
        String string3 = this.name[0] + string + "0";
        for (int i = 1; i < this.name.length; ++i) {
            string3 = string3 + string2 + this.name[i] + string + i;
        }
        return string3;
    }

    public String getString(int n) {
        return this.name[n];
    }

    public String getLongString(int n) {
        return this.longName[n];
    }

    public int getNumberModes() {
        return this.name.length;
    }
}

