/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities.FileUtilities;

import TimUtilities.FileUtilities.FileUtilities;
import java.io.File;

public class FileNameSequence {
    private String directoryroot;
    private String directoryend;
    private String nameroot;
    private String nameend;

    public FileNameSequence(FileNameSequence fileNameSequence) {
        this.setFileName(fileNameSequence);
    }

    public FileNameSequence(String string, String string2, String string3) {
        this.setFileName(string, string2, string3);
    }

    public FileNameSequence(String string, String string2, String string3, String string4) {
        this.setFileName(string, string2, string3, string4);
    }

    public void setFileName(FileNameSequence fileNameSequence) {
        this.setFileName(fileNameSequence.getDirectoryRoot(), fileNameSequence.getDirectoryEnd(), fileNameSequence.getNameRoot(), fileNameSequence.getNameRoot());
    }

    public void setFileName(String string, String string2, String string3) {
        this.setDirectoryRoot(string);
        this.directoryend = "";
        this.nameroot = string2;
        this.nameend = string3;
    }

    public void setFileName(String string, String string2, String string3, String string4) {
        this.setDirectoryRoot(string);
        this.setDirectoryEnd(string2);
        this.nameroot = string3;
        this.nameend = string4;
    }

    public boolean setFullFileName(String string, String[] stringArray) {
        String[] stringArray2 = FileUtilities.slashSplit(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray2[0].endsWith(stringArray[i])) continue;
            int n = stringArray2[0].length() - stringArray[i].length();
            this.nameroot = stringArray2[0].substring(0, n);
            this.nameend = stringArray[i];
            if (stringArray2.length > 1) {
                this.setDirectory(stringArray2[1]);
            }
            return true;
        }
        return false;
    }

    public boolean setFullFileNameNoEnding(String string) {
        String[] stringArray = FileUtilities.slashSplit(string);
        this.nameroot = stringArray[0];
        if (stringArray.length > 1) {
            this.setDirectory(stringArray[1]);
        }
        return true;
    }

    public String getDirectoryFull() {
        return this.directoryroot + this.directoryend;
    }

    public String getDirectoryRoot() {
        return this.directoryroot;
    }

    public String getDirectoryEnd() {
        return this.directoryend;
    }

    public String getNameRoot() {
        return this.nameroot;
    }

    public String getNameEnd() {
        return this.nameend;
    }

    public String getNameRootFullPath() {
        return this.directoryroot + this.directoryend + this.nameroot;
    }

    public String getFullFileName() {
        return this.directoryroot + this.directoryend + this.nameroot + this.nameend;
    }

    public String setDirectoryRoot(String string) {
        this.directoryroot = FileNameSequence.makeDirectory(string);
        return this.directoryroot;
    }

    public String setDirectoryEnd(String string) {
        this.directoryend = FileNameSequence.makeDirectory(string);
        return this.directoryroot;
    }

    public String setDirectory(String string) {
        String[] stringArray;
        int n = string.length();
        if (n < 1) {
            return string;
        }
        if (string.charAt(n - 1) == '/' || string.charAt(n - 1) == '\\') {
            --n;
        }
        if ((stringArray = FileUtilities.slashSplit(string.substring(0, n))).length > 0) {
            return this.setDirectory(stringArray[1], stringArray[0]);
        }
        return this.setDirectory("", stringArray[0]);
    }

    public String setDirectory(String string, String string2) {
        this.setDirectoryRoot(string);
        this.setDirectoryEnd(string2);
        return this.directoryroot + this.directoryend;
    }

    public static String makeDirectory(String string) {
        int n = string.length();
        if (n < 1) {
            return string;
        }
        if (!string.substring(n - 1, n).equals("/")) {
            string = string + "/";
        }
        return string;
    }

    public static boolean makeDirectory(String string, boolean bl) {
        String string2 = FileNameSequence.makeDirectory(string);
        if (bl) {
            return true;
        }
        File file = new File(string2);
        return file.mkdirs();
    }

    public boolean makeDirectories() {
        File file = new File(this.getDirectoryFull());
        return file.mkdirs();
    }

    public void setNameRoot(String string) {
        this.nameroot = string;
    }

    public void appendToNameRoot(String string) {
        this.nameroot = this.nameroot + string;
    }

    public void setNameEnd(String string) {
        this.nameend = string;
    }

    public boolean testDirectoryRoot() {
        File file = new File(this.directoryroot);
        return file.isDirectory();
    }

    public boolean testDirectoryFull() {
        File file = new File(this.directoryroot + this.directoryend);
        return file.isDirectory();
    }

    public boolean testFullFileName() {
        File file = new File(this.getFullFileName());
        return file.exists();
    }
}

