/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class FileChooser
extends JPanel
implements ActionListener {
    private static final String newline = "\n";
    JButton openButton;
    JTextArea log = new JTextArea(5, 20);
    JFileChooser fc;

    public FileChooser() {
        super(new BorderLayout());
        this.log.setMargin(new Insets(5, 5, 5, 5));
        this.log.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.log);
        this.fc = new JFileChooser();
        this.openButton = new JButton("Open a File...", FileChooser.createImageIcon("images/Open16.gif"));
        this.openButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(this.openButton);
        this.add((Component)jPanel, "First");
        this.add((Component)jScrollPane, "Center");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.openButton) {
            int n = this.fc.showOpenDialog(this);
            if (n == 0) {
                File file = this.fc.getSelectedFile();
                this.log.append("Opening: " + file.getName() + "." + newline);
            } else {
                this.log.append("Open command cancelled by user.\n");
            }
            this.log.setCaretPosition(this.log.getDocument().getLength());
        }
    }

    protected static ImageIcon createImageIcon(String string) {
        URL uRL = FileChooser.class.getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }

    private static void createAndShowGUI() {
        JFrame jFrame = new JFrame("FileChooserDemo");
        jFrame.setDefaultCloseOperation(3);
        FileChooser fileChooser = new FileChooser();
        fileChooser.setOpaque(true);
        jFrame.setContentPane(fileChooser);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FileChooser.createAndShowGUI();
            }
        });
    }
}

