/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities;

import TimUtilities.GeneralMode;

public class BinaryMode
extends GeneralMode {
    private int number = 0;
    private int[] bit;

    public BinaryMode(String[] stringArray, String[] stringArray2) {
        this.setUp(stringArray, stringArray2, 0);
    }

    public BinaryMode(String[] stringArray, String[] stringArray2, int n) {
        this.setUp(stringArray, stringArray2, n);
    }

    public BinaryMode(BinaryMode binaryMode) {
        this.set(binaryMode.number);
    }

    protected void setUp(String[] stringArray, String[] stringArray2, int n) {
        this.longName = stringArray2;
        if (this.name.length != this.longName.length) {
            throw new IllegalArgumentException("name and longName have different lengths" + this.name.length + " != " + this.longName.length);
        }
        this.bit[0] = 1;
        for (int i = 1; i < this.name.length; ++i) {
            this.bit[i] = this.bit[i - 1] << 1;
        }
        this.set(n);
    }

    public void setAllOn(String[] stringArray) {
        this.number = (1 << stringArray.length) - 1;
    }

    public void setAllOff() {
        this.number = 0;
    }

    public void setModeOn(String string) {
        this.setModeOn(this.getIndex(string));
    }

    public void setModeOn(int n) {
        if (this.testModeNumber(n)) {
            this.number |= this.bit[n];
        }
    }

    public void setModeOff(String string) {
        this.setModeOff(this.getIndex(string));
    }

    public void setModeOff(int n) {
        if (this.testModeNumber(n)) {
            this.number -= this.number & this.bit[n];
        }
    }

    public boolean isSet(int n) {
        if (n < 0 || n >= this.name.length) {
            return false;
        }
        return (this.bit[n] & this.number) > 0;
    }

    public String toString(String string) {
        String string2 = "";
        for (int i = 0; i < this.name.length; ++i) {
            if (!this.isSet(i)) continue;
            string2 = string2 + this.name[i] + string;
        }
        return string2;
    }
}

