/*
 * Decompiled with CFR 0.152.
 */
package TimGraph;

import JavaNotes.TextReader;
import TimGraph.Community.Partition;
import TimGraph.Community.VertexPartition;
import TimGraph.Coordinate;
import TimGraph.DegreeDistribution;
import TimGraph.EdgeValue;
import TimGraph.OutputMode;
import TimGraph.RandomWalk;
import TimGraph.Rank;
import TimGraph.VertexLabel;
import TimGraph.algorithms.LineGraphProjector;
import TimGraph.io.FileInput;
import TimGraph.io.FileOutput;
import TimGraph.io.GraphViz;
import TimGraph.io.InputFileType;
import TimUtilities.FileUtilities.FileNameSequence;
import TimUtilities.NumbersToString;
import TimUtilities.StringUtilities.Filters.StringFilter;
import TimUtilities.TimMessage;
import TimUtilities.TimTime;
import TimUtilities.TimTiming;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class timgraph {
    static final String VERSION = "tg110504";
    static final int MININT = Integer.MAX_VALUE;
    static final int MAXINT = Integer.MIN_VALUE;
    boolean DEBUG = false;
    public static final String SEP = "\t ";
    public static final String NONAME = "timgraph";
    public static final String COMMENTCHARACTER = "#";
    public static final char TIMGRAPH_ARGUMENT = '-';
    public static final char[] NOT_TIMGRAPH_ARGUMENT = new char[]{'*', '^', ':'};
    static NumbersToString n2s = new NumbersToString();
    static final int MAXEDGETARGET = Integer.MAX_VALUE;
    static final int MAXEDGESOURCE = 0x7FFFFFFE;
    public static final int IUNSET = -135798642;
    public static final double DUNSET = -3.57986421E8;
    public static final String SUNSET = "UNSET";
    Date date = new Date();
    TimTiming timing = new TimTiming();
    public RandomWalk randomWalk;
    public Random Rnd;
    private int TotalNumberVertices = 0;
    private int TotalNumberStubs = 0;
    private double TotalWeight = -3.57986421E8;
    private double degreeSecondMoment = -3.57986421E8;
    private int TotalNumberTriangles = -135798642;
    private int TotalNumberSquares = -135798642;
    private double ccGlobal = -3.57986421E8;
    IntArrayList[] vertexList;
    IntArrayList[] vertexSourceList;
    private boolean vertexEdgeListOn = false;
    IntArrayList[] vertexEdgeList;
    IntArrayList[] vertexInEdgeList;
    VertexLabel[] vertexLabelList;
    IntArrayList[] strengthlist;
    IntArrayList[] rvertexList;
    int[] stubSourceList;
    EdgeValue[] edgeValuetList;
    int[] edgerandomlist;
    boolean directedGraph = false;
    boolean vertexlabels = false;
    boolean weightedEdges = false;
    boolean labelledEdges = false;
    boolean selfLoops = true;
    boolean multiEdge = true;
    private boolean bipartiteGraph = false;
    private int numberVertexType1 = -1;
    private String nameVertexType1 = "Type1";
    private int numberVertexType2 = -1;
    private String nameVertexType2 = "Type2";
    protected VertexLabel minimumVertexLabel = null;
    protected VertexLabel maximumVertexLabel = null;
    protected EdgeValue minimumEdgeValue = null;
    protected EdgeValue maximumEdgeValue = null;
    DegreeDistribution DDtotal;
    DegreeDistribution DDin;
    DegreeDistribution DDout;
    DegreeDistribution DD1total;
    DegreeDistribution DD2total;
    int LogBinVerticesMinimum = 99;
    IntArrayList weightdarr = new IntArrayList();
    IntArrayList rddarr = new IntArrayList();
    int maxmoment = 10;
    int weightmaximum = -1;
    int maxonewalk = -2;
    int[] vertexdistance;
    IntArrayList distancedist;
    DoubleArrayList ringdegree;
    int[] vertexComponent;
    IntArrayList componentSize;
    IntArrayList componentEdges;
    IntArrayList componentmu2;
    IntArrayList componentSource;
    IntArrayList componentDist;
    int componentsize;
    int componentSizeMax;
    int componentSourceMax;
    int componentDiameterMax;
    int componentGCCIndex;
    double componentGCCDist;
    int componentSingleNumber;
    int diameter;
    double distanceaverage = 0.0;
    double distanceerror = 0.0;
    double distancesigma = 0.0;
    int nsamples;
    DoubleArrayList avdistancedist;
    double onesdistanceav = 0.0;
    double onesdistanceerror = 0.0;
    double onesdistancesigma = 0.0;
    DoubleArrayList totdistancedist;
    DoubleArrayList totdistance2dist;
    double totdistanceaverage = 0.0;
    double totdistanceerror = 0.0;
    double totdistancesigma = 0.0;
    IntArrayList diameterdist;
    int diametermax;
    int diametermin;
    double diameteraverage;
    double diametererror;
    double diametersigma;
    double DijkstraMaxDist;
    double MAXDISTANCE = 1.0E99;
    double[][] distance;
    int CCnsamples;
    double CCaverage;
    double CCerror;
    double CCsigma;
    int CCEdgensamples;
    double CCEdgeaverage;
    double CCEdgeerror;
    double CCEdgesigma;
    double averagesteplength;
    public FileNameSequence inputName;
    public InputFileType inputFileType = new InputFileType(0);
    public static final String[] pajekColour = new String[]{"White", "Yellow", "Pink", "Cyan", "Orange", "Magenta", "Purple", "Green", "Blue", "Brown", "Black"};
    public FileNameSequence outputName;
    private int maximumVertices = 1000;
    private int maximumStubs = 1000;
    int maximumconnectivity = 1000;
    double connectivity = 2.0;
    double maxexpectededges = (double)this.maximumVertices * this.connectivity * 2.0;
    double maxexpectedvertices = this.maximumVertices;
    int numevents = 0;
    double averageWalkLength = 1.0;
    int maxWalkLength = (int)(this.averageWalkLength + 0.5) * 3;
    double rankingProbabilityLengthScale = -1.0;
    public int binomialNumber = 1;
    int numruns = 1;
    double probnewvertex = 1.0;
    double probpp = 1.0;
    double probpr = 0.0;
    double probpra = 0.0;
    double probqp = 1.0;
    double probqra = 0.0;
    int initialgraph = 1;
    int initialConnectivity = -1;
    int initialVertices = -1;
    int initialXsize = -1;
    int initialYsize = -1;
    int initialEdges = -1;
    TimMessage message = new TimMessage(0);
    public int infoLevel;
    public OutputMode outputControl;
    boolean WeightCalcOn = true;
    double logbinratio = 1.1;
    boolean SourceVertex = true;
    int randomWalkMode = 1;
    int edgegenerator = 0;

    public timgraph() {
        this.initialiseRandomGenerator();
        this.initialiseSomeParameters("test", System.getProperty("user.dir"), 0, 0);
    }

    public timgraph(String[] stringArray) {
        this.initialiseRandomGenerator();
        this.initialiseSomeParameters("test", System.getProperty("user.dir"), 0, 0);
        this.parseParam(stringArray);
    }

    public timgraph(long l) {
        this.Rnd = new Random(l);
        this.initialiseSomeParameters("test", System.getProperty("user.dir"), 0, 0);
    }

    public timgraph(String string, String string2, int n, int n2) {
        this.initialiseRandomGenerator();
        this.initialiseSomeParameters(string, string2, n, n2);
        if (this.infoLevel > 2) {
            System.out.println("Uses time to seed Rnd");
        }
    }

    public timgraph(String string, String string2, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n3, int n4) {
        this.initialiseRandomGenerator();
        this.initialiseSomeParameters(string, string2, n, n2);
        if (this.infoLevel > 0) {
            System.out.println("Uses time to seed Rnd");
        }
        this.maximumVertices = n3;
        this.maximumStubs = n4;
        this.directedGraph = bl;
        this.vertexlabels = bl2;
        this.weightedEdges = bl3;
        this.vertexEdgeListOn = bl4;
        this.setNetwork();
    }

    public timgraph(String string, String string2, int n, int n2, boolean bl, boolean bl2, boolean bl3, int n3, int[] nArray) {
        this.initialiseRandomGenerator();
        this.directedGraph = bl;
        this.vertexlabels = bl2;
        this.weightedEdges = bl3;
        this.maximumVertices = n3;
        this.maximumStubs = nArray.length >> 1 << 1;
        this.directedGraph = bl;
        this.vertexlabels = false;
        this.weightedEdges = bl3;
        boolean bl4 = true;
        this.setNetwork(this.maximumVertices, nArray, bl4);
    }

    public timgraph(timgraph timgraph2, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        int n3;
        this.initialiseRandomGenerator();
        this.infoLevel = timgraph2.infoLevel;
        if (this.infoLevel > 0) {
            System.out.println("Uses time to seed Rnd");
        }
        boolean bl4 = false;
        this.vertexlabels = timgraph2.vertexlabels;
        if (bl2) {
            this.vertexlabels = false;
        }
        this.directedGraph = timgraph2.directedGraph;
        if (bl) {
            this.directedGraph = false;
        }
        this.inputName = new FileNameSequence(timgraph2.inputName);
        this.outputName = new FileNameSequence(timgraph2.outputName);
        int n4 = timgraph2.TotalNumberVertices;
        int n5 = timgraph2.TotalNumberStubs;
        this.setNetwork(Math.max(n4, n), Math.max(n5, n2));
        this.outputControl = new OutputMode(timgraph2.outputControl);
        this.vertexList = new IntArrayList[n4];
        if (this.vertexEdgeListOn) {
            this.vertexEdgeList = new IntArrayList[n4];
            if (this.directedGraph) {
                this.vertexInEdgeList = new IntArrayList[n4];
            }
        }
        if (this.directedGraph) {
            this.vertexSourceList = new IntArrayList[n4];
        }
        if (this.vertexlabels) {
            this.vertexLabelList = new VertexLabel[n4];
            if (timgraph2.minimumVertexLabel != null) {
                this.minimumVertexLabel = new VertexLabel(this.minimumVertexLabel);
            }
            if (timgraph2.maximumVertexLabel != null) {
                this.maximumVertexLabel = new VertexLabel(this.maximumVertexLabel);
            }
        }
        this.TotalNumberVertices = 0;
        if (this.vertexlabels) {
            for (n3 = 0; n3 < n4; ++n3) {
                this.addVertex(timgraph2.vertexLabelList[n3]);
            }
        } else {
            for (n3 = 0; n3 < n4; ++n3) {
                this.addVertex();
            }
        }
        this.stubSourceList = new int[n5];
        this.TotalNumberStubs = 0;
        n3 = -1;
        int n6 = -1;
        EdgeValue edgeValue = new EdgeValue();
        EdgeValue edgeValue2 = new EdgeValue();
        if (this.weightedEdges) {
            int n7 = 0;
            while (n7 < timgraph2.TotalNumberStubs) {
                n3 = timgraph2.stubSourceList[n7];
                edgeValue = timgraph2.edgeValuetList[n7++];
                n6 = timgraph2.stubSourceList[n7];
                edgeValue2 = timgraph2.edgeValuetList[n7++];
                if (bl3) {
                    this.addEdge(n6, n3, edgeValue);
                    continue;
                }
                this.addEdge(n3, n6, edgeValue);
            }
        } else {
            int n8 = 0;
            while (n8 < timgraph2.TotalNumberStubs) {
                n3 = timgraph2.stubSourceList[n8++];
                n6 = timgraph2.stubSourceList[n8++];
                if (bl3) {
                    this.addEdge(n6, n3);
                    continue;
                }
                this.addEdge(n3, n6);
            }
        }
        if (n5 != this.TotalNumberStubs) {
            bl4 = true;
            System.out.println("*** Total Number Edges wrong in timgraph constructor");
        }
        if (this.bipartiteGraph) {
            this.setBipartite(timgraph2.getNumberVerticesType1(), timgraph2.getNumberVerticesType2(), timgraph2.getNameVerticesType1(), timgraph2.getNameVerticesType2());
        }
        if (timgraph2.vertexEdgeListOn) {
            this.createVertexGlobalEdgeList();
        }
    }

    public timgraph(timgraph timgraph2, int[] nArray, int n, boolean bl, boolean bl2) {
        int n2;
        this.infoLevel = timgraph2.infoLevel;
        this.vertexEdgeListOn = true;
        this.initialiseRandomGenerator();
        this.directedGraph = timgraph2.directedGraph;
        if (bl) {
            this.directedGraph = false;
        }
        this.weightedEdges = !bl2;
        this.vertexlabels = false;
        this.inputName = new FileNameSequence(timgraph2.inputName);
        this.outputName = new FileNameSequence(timgraph2.outputName);
        this.maximumVertices = n;
        this.maximumStubs = this.directedGraph ? this.maximumVertices * this.maximumVertices * 2 : this.maximumVertices * (this.maximumVertices + 1);
        this.setNetwork();
        for (n2 = 0; n2 < n; ++n2) {
            this.addVertex();
        }
        this.TotalNumberStubs = 0;
        n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        double d = 1.0;
        for (int i = 0; i < timgraph2.TotalNumberStubs; ++i) {
            n2 = timgraph2.getVertexFromEdge(i++);
            n3 = timgraph2.getVertexFromEdge(i);
            n4 = nArray[n2];
            n5 = nArray[n3];
            if (this.weightedEdges) {
                double d2 = d = timgraph2.weightedEdges ? timgraph2.getEdgeWeight(i) : 1.0;
                if (!timgraph2.isDirected() && n4 == n5 && n2 != n3) {
                    d += d;
                }
                this.increaseEdgeWeight(n4, n5, d);
                continue;
            }
            this.addEdgeUnique(n4, n5);
        }
    }

    public timgraph(timgraph timgraph2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        int n;
        int n2;
        if (!timgraph2.isVertexEdgeListOn()) {
            System.err.println("*** timgraph Line Graph constructor needs vertexEdgeList to be on.");
        }
        this.infoLevel = timgraph2.infoLevel;
        this.vertexEdgeListOn = true;
        this.initialiseRandomGenerator();
        this.directedGraph = timgraph2.directedGraph;
        if (bl) {
            this.directedGraph = false;
        }
        this.weightedEdges = !bl2;
        this.vertexlabels = false;
        this.inputName = new FileNameSequence(timgraph2.inputName);
        this.outputName = new FileNameSequence(timgraph2.outputName);
        int n3 = 1;
        if (bl3) {
            n3 = 0;
        }
        this.maximumVertices = timgraph2.getNumberStubs() / 2;
        this.maximumStubs = 0;
        if (this.directedGraph) {
            for (n2 = 0; n2 < timgraph2.getNumberVertices(); ++n2) {
                this.maximumStubs += timgraph2.getVertexInDegree(n2) * timgraph2.getVertexOutDegree(n2);
            }
        } else {
            for (n2 = 0; n2 < timgraph2.getNumberVertices(); ++n2) {
                n = timgraph2.getVertexDegree(n2);
                this.maximumStubs += n * (n - n3) / 2;
            }
        }
        this.maximumStubs *= 2;
        this.setNetwork();
        for (n2 = 0; n2 < this.maximumVertices; ++n2) {
            this.addVertex();
        }
        this.TotalNumberStubs = 0;
        n2 = -1;
        n = -1;
        double d = 1.0;
        if (timgraph2.isDirected()) {
            int n4 = -1;
            int n5 = -1;
            for (int i = 0; i < timgraph2.getNumberVertices(); ++i) {
                n4 = timgraph2.getVertexDegree(i);
                if (n4 < 1 || (n5 = timgraph2.getVertexDegree(i)) < 1) continue;
                if (this.weightedEdges) {
                    d = 1.0 / Math.sqrt((double)n4 * (double)n5);
                }
                for (int j = 0; j < timgraph2.vertexInEdgeList[i].size(); ++j) {
                    n2 = timgraph2.vertexInEdgeList[i].get(j);
                    for (int k = 0; k < timgraph2.vertexEdgeList[i].size(); ++k) {
                        n = timgraph2.vertexEdgeList[i].get(k);
                        if (this.weightedEdges) {
                            this.increaseEdgeWeight(n2 / 2, n / 2, d);
                            continue;
                        }
                        this.addEdgeUnique(n2 / 2, n / 2);
                    }
                }
            }
        } else {
            int n6 = -1;
            for (int i = 0; i < timgraph2.getNumberVertices(); ++i) {
                n6 = timgraph2.getVertexDegree(i);
                if (n6 < 1 + n3) continue;
                if (this.weightedEdges) {
                    d = 1.0 / (double)(n6 - n3);
                }
                for (int j = 0; j < timgraph2.vertexEdgeList[i].size(); ++j) {
                    n2 = timgraph2.vertexEdgeList[i].get(j);
                    for (int k = j + n3; k < timgraph2.vertexEdgeList[i].size(); ++k) {
                        n = timgraph2.vertexEdgeList[i].get(k);
                        if (this.weightedEdges) {
                            this.increaseEdgeWeight(n2 / 2, n / 2, d);
                            continue;
                        }
                        this.addEdgeUnique(n2 / 2, n / 2);
                    }
                }
            }
        }
    }

    private void initialiseRandomGenerator() {
        this.Rnd = new Random();
        if (this.infoLevel > 2) {
            System.out.println("Uses time to seed Rnd");
        }
    }

    public void initialiseSomeParameters(String string, String string2, int n, int n2) {
        String string3 = FileNameSequence.makeDirectory(string2);
        this.initialiseSomeParameters(string, string3, string, string3, n, n2);
    }

    public void initialiseSomeParameters(String string, String string2, String string3, String string4, int n, int n2) {
        this.inputName = new FileNameSequence(string2, "input/", string, "");
        this.outputName = new FileNameSequence(string4, "output/", string3, "");
        this.infoLevel = n;
        this.message.setInformationLevel(n);
        this.outputControl = new OutputMode(n2);
    }

    public void createVertexGlobalEdgeList() {
        int n;
        this.vertexEdgeListOn = true;
        this.vertexEdgeList = new IntArrayList[this.maximumVertices];
        for (n = 0; n < this.TotalNumberVertices; ++n) {
            this.vertexEdgeList[n] = new IntArrayList(this.getVertexDegree(n));
        }
        if (this.directedGraph) {
            this.vertexInEdgeList = new IntArrayList[this.maximumVertices];
            for (n = 0; n < this.TotalNumberVertices; ++n) {
                this.vertexInEdgeList[n] = new IntArrayList(this.getVertexInDegree(n));
            }
        }
        n = -1;
        int n2 = -1;
        for (int i = 0; i < this.TotalNumberStubs; ++i) {
            n = this.stubSourceList[i];
            this.vertexEdgeList[n].add(i);
            n2 = this.stubSourceList[++i];
            if (this.directedGraph) {
                this.vertexInEdgeList[n2].add(i);
                continue;
            }
            this.vertexEdgeList[n2].add(i);
        }
    }

    public String informationString() {
        return "timgraph version tg110504 on " + this.date;
    }

    public static void main(String[] stringArray) {
        System.out.println("\n***********************************************************");
        timgraph timgraph2 = new timgraph();
        if (timgraph2.DEBUG) {
            timgraph2.testtimgraph();
        } else {
            System.out.println("       STARTING " + timgraph2.informationString());
            if (timgraph2.parseParam(stringArray) > 0) {
                return;
            }
        }
        timgraph2.doOneRun(0);
        timgraph2.OutputGraphInfo(System.out, COMMENTCHARACTER, 0.0);
        timgraph2.generalOutput(COMMENTCHARACTER, 0.0);
    }

    public void testtimgraph() {
        System.out.println(" ### TESTING timgraph version tg110504 on " + this.date);
        System.out.println(" ###  ");
        String[] stringArray = new String[]{"-gn-5", "-gv27", "-gm1", "-e0", "-o8", "-xi2"};
        if (this.parseParam(stringArray) > 0) {
            return;
        }
    }

    public void doOneRun() {
        this.doOneRun(0);
    }

    public void doOneRun(int n) {
        if (this.infoLevel > 1) {
            this.printParam();
        }
        this.setNetwork(this.initialgraph);
        if (this.infoLevel > 0) {
            this.printParam();
        }
        switch (n) {
            case 1: {
                this.numevents -= this.TotalNumberVertices;
                break;
            }
        }
        this.calcNumberVertices();
        this.calcNumberEdges();
        double d = -1.0;
        if (this.numevents > 0) {
            this.initialEdges = this.TotalNumberStubs;
            this.initialVertices = this.TotalNumberVertices;
            d = this.addAll(0.01);
            if (this.infoLevel > -2) {
                System.out.println("--- Finished " + this.outputName.getNameRootFullPath() + " in " + d + "sec.");
            }
            if (this.infoLevel > -1) {
                int n2 = this.calcNumberEdges();
                int n3 = this.calcNumberVertices();
                int n4 = n3 - this.initialVertices;
                int n5 = n2 - this.initialEdges;
                System.out.println("    " + n4 + " vertices added, " + NumbersToString.toString(this.probnewvertex * (double)this.numevents, 2) + " expected, " + NumbersToString.toString(100.0 - 100.0 * (double)n4 / (this.probnewvertex * (double)this.numevents), 2) + "% deviation.");
                System.out.println("    " + n5 + " stubs added, requested " + NumbersToString.toString(this.connectivity * (double)this.numevents * 2.0, 2) + ", " + NumbersToString.toString(100.0 - 100.0 * (double)n5 / (this.connectivity * (double)this.numevents * 2.0), 2) + "% failed.");
                System.out.println(" Average step length " + this.averagesteplength);
            }
        } else if (this.infoLevel > 0) {
            System.out.println("--- No vertices added to initial graph ---");
        }
        this.generalOutput(COMMENTCHARACTER, d);
    }

    public void generalOutput(String string, double d) {
        if (this.infoLevel > -1) {
            this.OutputGraphInfo(System.out, "-  ", d);
        }
        this.FileOutputGraphInfo(string, d);
        this.calcMinMaxVertexLabel();
        if (this.outputControl.componentsOn) {
            if (this.infoLevel > -1) {
                System.out.println("\n >>> Component analysis ");
            }
            this.timing.setInitialTime();
            this.calcComponents();
            if (this.infoLevel > -1) {
                this.printComponentInfo();
            }
            this.FileOutputComponentInfo(string, false, false);
            if (this.infoLevel > -1) {
                System.out.println(" Component analysis took " + this.timing.runTimeString());
            }
        }
        if (this.outputControl.distancesOn) {
            if (this.infoLevel > -1) {
                System.out.println("\n >>> Distance sample randomly ");
            }
            this.timing.setInitialTime();
            int n = 100;
            if (n > this.numevents) {
                n = this.numevents / 2;
            }
            this.calcDistanceSample(0.01, n, this.numevents);
            if (this.infoLevel > -1) {
                this.printDistanceTotalDistribution(false);
            }
            this.FileOutputDistanceTotalDistribution(string);
            this.FileOutputDistanceStatistics(string);
            if (this.infoLevel > -1) {
                System.out.print(" Distance sample took " + this.timing.runTimeString());
            }
        }
        if (this.outputControl.clusteringOn) {
            if (this.infoLevel > -1) {
                System.out.println("\n >>> Cluster Coefficient randomly ");
            }
            this.timing.setInitialTime();
            this.calcCCSample(0.01, 1000, this.numevents);
            this.calcCCEdgeSample(0.01, 1000, this.numevents);
            if (this.infoLevel > -1) {
                this.printCC();
            }
            this.FileOutputCC(string);
            if (this.infoLevel > -1) {
                System.out.print(" Cluster Coefficient sample took " + this.timing.runTimeString());
            }
        }
        if (this.outputControl.degreeDistributionOn) {
            if (this.infoLevel > -1) {
                System.out.println("\n >>> Degree distribution ");
            }
            this.timing.setInitialTime();
            this.calcDegreeDistribution();
            if (this.infoLevel > -1) {
                System.out.println("*** Total Degree Distribution");
            }
            if (this.infoLevel > -1) {
                this.DDtotal.outputInformation(System.out, "... ", SEP, 3);
            }
            this.FileOutputDegreeDistribution(string, false, true);
            if (this.TotalNumberVertices >= this.LogBinVerticesMinimum) {
                this.FileOutputLogBinnedDegreeDistribution(string, 1.1, true, true);
            }
        }
        if (this.outputControl.pajekFileOn) {
            if (this.infoLevel > -1) {
                System.out.println("\n >>> Pajek file output ");
            }
            this.timing.setInitialTime();
            FileOutput fileOutput = new FileOutput(this);
            fileOutput.pajek();
            if (this.infoLevel > -1) {
                System.out.print(" Pajek File output took " + this.timing.runTimeString());
            }
        }
        if (this.outputControl.rankingOn) {
            if (this.averageWalkLength < 0.0) {
                this.averageWalkLength = this.diameter;
            }
            if (this.averageWalkLength < 2.0) {
                this.averageWalkLength = 2.0;
            }
            if (this.rankingProbabilityLengthScale < 0.0) {
                this.rankingProbabilityLengthScale = this.distanceaverage;
            }
            if (this.rankingProbabilityLengthScale < 2.0) {
                this.rankingProbabilityLengthScale = 2.0;
            }
            int n = this.TotalNumberStubs * 100;
            int n2 = -1;
            if (this.infoLevel > -1) {
                System.out.println("\n >>> Random Walk Ranking file output ");
            }
            if (this.infoLevel > -1) {
                System.out.println("randomWalkMode, averageWalkLength, rankingProbabilityLengthScale, totalNumberaverageWalkLength, startVertex = \t " + this.randomWalkMode + SEP + this.averageWalkLength + SEP + this.rankingProbabilityLengthScale + SEP + n + SEP + n2);
            }
            this.timing.setInitialTime();
            this.DoRandomWalk(n, n2);
            if (this.TotalNumberStubs < 40) {
                this.FileOutputNetwork(true, true, true);
            } else {
                this.FileOutputVertices(false, false, false);
            }
            if (this.vertexlabels) {
                this.FileOutputPajekVertexData();
            }
            if (this.infoLevel > -1) {
                System.out.print(" Random Walk Ranking file output took " + this.timing.runTimeString());
            }
        }
        if (this.outputControl.adjacencyFileOn) {
            if (this.infoLevel > -1) {
                System.out.println("\n >>> Adjacency file output ");
            }
            this.timing.setInitialTime();
            FileOutput fileOutput = new FileOutput(this);
            fileOutput.adjacencyMatrix(SEP, true, true);
            if (this.infoLevel > -1) {
                System.out.print(" Adjacency File output took " + this.timing.runTimeString());
            }
        }
    }

    double DoRun(double d) {
        int n;
        int n2;
        System.out.println("--- Starting doRun ");
        boolean bl = (this.randomWalkMode & 1) > 0;
        boolean bl2 = (this.randomWalkMode & 2) > 0;
        boolean bl3 = (this.randomWalkMode & 4) > 0;
        boolean bl4 = (this.randomWalkMode & 8) > 0;
        boolean bl5 = true;
        if (this.probnewvertex < 1.0) {
            bl5 = false;
        }
        if (this.infoLevel > 2) {
            this.printParam();
            System.out.println("StartWalkWithVertex, always_new_walk_start, markov_walk, random_connectivity " + bl + SEP + bl2 + SEP + bl3 + SEP + bl4);
        }
        double d2 = (this.connectivity - 1.0) / this.connectivity;
        int[] nArray = new int[this.maximumconnectivity];
        int[] nArray2 = new int[this.maximumconnectivity];
        int n3 = (int)(this.averageWalkLength + 0.5);
        int n4 = (int)(this.connectivity + 0.5);
        int n5 = this.TotalNumberStubs;
        this.initialVertices = this.TotalNumberVertices;
        boolean bl6 = false;
        Runtime runtime = Runtime.getRuntime();
        int n6 = this.numevents + 1;
        if (d > 0.0) {
            n6 = (int)((double)this.numevents * d);
        }
        if (n6 < 1) {
            n6 = 1;
        }
        double d3 = this.averageWalkLength / (1.0 + this.averageWalkLength);
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        this.maxonewalk = -1;
        int n11 = -1;
        boolean bl7 = false;
        this.timing.setInitialTime();
        for (n2 = 0; n2 < this.numevents; ++n2) {
            int n12;
            if (bl4) {
                n4 = 1;
                while (this.Rnd.nextDouble() < d2) {
                    ++n4;
                }
            }
            n8 += n4;
            if (n11 < n4) {
                n11 = n4;
            }
            if (n4 > this.maximumconnectivity) {
                n4 = this.maximumconnectivity;
                System.out.println("!!! WARNING in DoRun attempted actual connectivity of " + n4 + ", limited to the maximum of " + this.maximumconnectivity);
            }
            if (this.TotalNumberStubs + n4 >= this.maximumStubs || this.TotalNumberVertices >= this.maximumVertices) break;
            for (n = 0; n < n4; ++n) {
                if (bl2 || n == 0) {
                    n9 = bl ? this.Rnd.nextInt(this.TotalNumberVertices) : this.stubSourceList[this.Rnd.nextInt(this.TotalNumberStubs)];
                }
                if (bl3) {
                    n3 = 0;
                    while (this.Rnd.nextDouble() < d3) {
                        ++n3;
                    }
                }
                n7 += n3;
                if (this.maxonewalk < n3) {
                    this.maxonewalk = n3;
                }
                for (n12 = 0; n12 < n3 && this.vertexList[n9].size() > 0; ++n12) {
                    n9 = this.vertexList[n9].getQuick(this.Rnd.nextInt(this.vertexList[n9].size()));
                }
                nArray[n] = n9;
                if (!this.weightedEdges) continue;
                nArray2[n] = n3;
            }
            if (bl5 || this.Rnd.nextDouble() < this.probnewvertex) {
                this.vertexList[this.TotalNumberVertices] = new IntArrayList();
                ++this.TotalNumberVertices;
                bl7 = true;
            } else {
                n10 = this.SourceVertex ? this.Rnd.nextInt(this.TotalNumberVertices) : this.stubSourceList[this.Rnd.nextInt(this.TotalNumberStubs)];
                bl7 = false;
            }
            for (n = 0; n < n4; ++n) {
                n12 = nArray[n];
                this.vertexList[n10].add(n12);
                this.vertexList[n12].add(n10);
                if (this.weightedEdges) {
                    this.edgeValuetList[this.TotalNumberStubs] = bl7 ? new EdgeValue(1, nArray2[n]) : new EdgeValue(2, nArray2[n]);
                }
                this.stubSourceList[this.TotalNumberStubs++] = n10;
                if (this.weightedEdges) {
                    this.edgeValuetList[this.TotalNumberStubs] = bl7 ? new EdgeValue(1, nArray2[n]) : new EdgeValue(2, nArray2[n]);
                }
                this.stubSourceList[this.TotalNumberStubs++] = n12;
            }
        }
        this.timing.setCurrentTime();
        n2 = this.TotalNumberVertices - this.initialVertices;
        n = this.TotalNumberStubs - n5;
        System.out.println("Added " + n2 + " vertices and " + n + " edges in " + this.timing.runTimeString());
        double d4 = (double)n / ((double)n2 * 2.0);
        System.out.println("Average new connectivity = " + NumbersToString.toString(d4, 3) + ", largest one connectivity = " + n11);
        this.averagesteplength = 2.0 * (double)n7 / (double)n;
        System.out.println("average step = " + NumbersToString.toString(this.averagesteplength, 3) + ", longest single walk  = " + this.maxonewalk);
        if (this.infoLevel > 1) {
            long l = runtime.freeMemory();
            long l2 = runtime.totalMemory();
            System.out.println("\nFree memory " + l + " out of " + l2 + " total");
            int n13 = this.TotalNumberStubs;
            int n14 = this.TotalNumberVertices;
            int n15 = n14 - this.initialVertices;
            int n16 = n13 - n5;
            System.out.println("*** Finished Run in " + this.timing.runTimeString());
            System.out.println("    " + this.numevents + " events.");
            System.out.println("    " + (n14 - this.initialVertices) + " vertices added.");
            System.out.println("    " + (n13 - n5) + " edges added, expected " + (double)bl6 * this.connectivity);
        }
        return 0.0;
    }

    public void initialiseRandomWalk(int n, double d, double d2) {
        this.randomWalk = new RandomWalk(this, n, d, d2);
    }

    public double DoRandomWalk(int n, int n2) {
        int n3;
        Runtime runtime = Runtime.getRuntime();
        if (this.infoLevel > 0) {
            System.out.println("--- Starting DoRandomWalk ");
        }
        boolean bl = (this.randomWalkMode & 1) > 0;
        boolean bl2 = (this.randomWalkMode & 2) > 0;
        boolean bl3 = (this.randomWalkMode & 4) > 0;
        boolean bl4 = true;
        boolean bl5 = (this.randomWalkMode & 0x10) > 0;
        double d = this.averageWalkLength / (1.0 + this.averageWalkLength);
        this.maxWalkLength = (int)(this.averageWalkLength + 0.5) * 3;
        int n4 = (int)(this.averageWalkLength + 0.5);
        if (bl3) {
            this.maxWalkLength = n;
        }
        this.maxonewalk = -1;
        double d2 = this.rankingProbabilityLengthScale / (1.0 + this.rankingProbabilityLengthScale);
        if (n2 >= this.TotalNumberVertices) {
            System.out.println("*** Error startVertex " + n2 + ">=" + this.TotalNumberVertices + " TotalNumberVertices");
            return -1.0;
        }
        if (n2 < 0) {
            bl4 = false;
        }
        if (this.infoLevel > 2) {
            this.printParam();
            System.out.println("StartWalkWithVertex, always_new_walk_start, markov_walk, random_connectivity " + bl + SEP + bl3);
        }
        int n5 = -1;
        int n6 = -1;
        int n7 = 0;
        if (this.vertexlabels) {
            for (n3 = 0; n3 < this.TotalNumberVertices; ++n3) {
                this.vertexLabelList[n3].setRank(new Rank());
            }
        }
        n3 = -1;
        double d3 = 1.0;
        int n8 = 0;
        this.timing.setInitialTime();
        for (int i = 0; i < n; ++i) {
            if (n3 < 0) {
                ++n8;
                n3 = bl3 ? (bl5 ? this.getRandomBinomial(this.averageWalkLength, this.binomialNumber) : this.getRandomMarkov(d, this.binomialNumber)) : n4;
                d3 = 1.0;
                if (bl2 || n6 < 1) {
                    if (bl) {
                        n7 = bl4 ? (n7 = n2) : this.Rnd.nextInt(this.TotalNumberVertices);
                    } else {
                        n5 = this.directedGraph ? this.makeEven(this.Rnd.nextInt(this.TotalNumberStubs)) : this.Rnd.nextInt(this.TotalNumberStubs);
                        n7 = this.stubSourceList[n5];
                    }
                }
                if (this.maxonewalk < n3) {
                    this.maxonewalk = n3;
                }
            } else {
                --n3;
                d3 *= d2;
                n7 = this.vertexList[n7].getQuick(this.Rnd.nextInt(n6));
            }
            n6 = this.vertexList[n7].size();
            if (this.vertexlabels) {
                this.vertexLabelList[n7].rank.updateRanking(n3, d3);
            }
            if (n6 != 0) continue;
            n3 = -1;
        }
        this.timing.setCurrentTime();
        String string = this.timing.runTimeString();
        this.averagesteplength = n8 > 0 ? (double)(n / n8) : (double)(-n);
        System.out.println("No. walks \t " + n8 + SEP + " average step = " + SEP + NumbersToString.toString(this.averagesteplength, 3) + SEP + " longest single walk " + SEP + this.maxonewalk);
        if (this.infoLevel > 1) {
            long l = runtime.freeMemory();
            long l2 = runtime.totalMemory();
            System.out.println("\nFree memory " + l + " out of " + l2 + " total");
            System.out.println("*** Finished DoRandomWalk in " + string);
        }
        return this.timing.elapsedTime();
    }

    public VertexLabel getMinimumVertexLabel() {
        return this.minimumVertexLabel;
    }

    public VertexLabel getMaximumVertexLabel() {
        return this.maximumVertexLabel;
    }

    public int getMinimumVertexNumber() {
        if (this.minimumVertexLabel != null && this.minimumVertexLabel.hasNumber()) {
            return this.minimumVertexLabel.getNumber();
        }
        return -135798642;
    }

    public int getMaximumVertexNumber() {
        if (this.maximumVertexLabel != null && this.maximumVertexLabel.hasNumber()) {
            return this.maximumVertexLabel.getNumber();
        }
        return -135798642;
    }

    public Coordinate getMinimumVertexCoordinate() {
        if (this.minimumVertexLabel != null && this.minimumVertexLabel.hasPosition()) {
            return this.minimumVertexLabel.getPosition();
        }
        return null;
    }

    public Coordinate getMaximumVertexCoordinate() {
        if (this.maximumVertexLabel != null && this.maximumVertexLabel.hasPosition()) {
            return this.maximumVertexLabel.getPosition();
        }
        return null;
    }

    public void calcMinimumVertexLabel() {
        if (!this.isVertexLabelled()) {
            this.minimumVertexLabel = null;
            return;
        }
        this.minimumVertexLabel = new VertexLabel();
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            this.vertexLabelList[i].setMinimum(this.minimumVertexLabel);
        }
    }

    public void calcMaximumVertexLabel() {
        if (!this.isVertexLabelled()) {
            this.maximumVertexLabel = null;
            return;
        }
        this.maximumVertexLabel = new VertexLabel();
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            this.vertexLabelList[i].setMaximum(this.maximumVertexLabel);
        }
    }

    public void calcMinMaxVertexLabel() {
        this.calcMinimumVertexLabel();
        this.calcMaximumVertexLabel();
    }

    public EdgeValue getMinimumEdgeValue() {
        return this.minimumEdgeValue;
    }

    public EdgeValue getMaximumEdgeValue() {
        return this.maximumEdgeValue;
    }

    public double getMinimumEdgeWeight() {
        if (this.minimumEdgeValue != null && this.minimumEdgeValue.hasWeight()) {
            return this.minimumEdgeValue.getWeight();
        }
        return -3.57986421E8;
    }

    public double getMaximumEdgeWeight() {
        if (this.maximumEdgeValue != null && this.maximumEdgeValue.hasWeight()) {
            return this.maximumEdgeValue.getWeight();
        }
        return -3.57986421E8;
    }

    public int getMinimumEdgeLabel() {
        if (this.minimumEdgeValue != null && this.minimumEdgeValue.hasLabel()) {
            return this.minimumEdgeValue.getLabel();
        }
        return -135798642;
    }

    public int getMaximumEdgeLabel() {
        if (this.maximumEdgeValue != null && this.maximumEdgeValue.hasLabel()) {
            return this.maximumEdgeValue.getLabel();
        }
        return -135798642;
    }

    public void calcMinimumEdgeValue() {
        if (!this.isWeighted()) {
            this.minimumEdgeValue = null;
            return;
        }
        this.minimumEdgeValue = new EdgeValue();
        for (int i = 0; i < this.TotalNumberStubs; ++i) {
            this.edgeValuetList[i].setMinimum(this.minimumEdgeValue);
        }
    }

    public void calcMaximumEdgeValue() {
        if (!this.isWeighted()) {
            this.maximumEdgeValue = null;
            return;
        }
        this.maximumEdgeValue = new EdgeValue();
        for (int i = 0; i < this.TotalNumberStubs; ++i) {
            this.edgeValuetList[i].setMaximum(this.maximumEdgeValue);
        }
    }

    public void adjustZeroWalkWeights() {
        int n = this.maxonewalk * 2 + 1;
        for (int i = 0; i < this.TotalNumberStubs; ++i) {
            if (this.edgeValuetList[i].weight != 0.0) continue;
            this.edgeValuetList[i].weight += (double)n;
        }
    }

    public void printWalkInfo(int n, int n2, int n3, long l, Runtime runtime, int n4, int n5) {
        if (n5 > 1) {
            this.calcNumberVertices();
        }
        this.calcNumberEdges();
        if (n5 > 0 && (n + 1) % n4 == 0) {
            System.out.print(".");
            if ((n + 1) % (10 * n4) == 0) {
                long l2 = runtime.freeMemory();
                long l3 = runtime.totalMemory();
                int n6 = this.TotalNumberStubs - n3;
                double d = (double)n6 / ((double)(2 * this.numevents) * this.connectivity);
                double d2 = this.timing.elapsedTime() * (1.0 / (d * d) - 1.0);
                System.out.println(" M:" + (l3 - l2) + "/" + l3 + ", " + this.timing.runTimeString() + " - " + TimTiming.runTimeString(d2) + " )");
                System.out.println("           Ev:" + n + "/" + this.numevents + ", V:" + (this.TotalNumberVertices - n2) + ", E:" + n6 + "/" + (double)(2 * n) * this.connectivity + ", (Tot " + (int)(0.5 + d * 100.0) + "% ?)");
            }
        }
    }

    double DoER(double d) {
        int n;
        int n2;
        System.out.println("--- Starting doER ");
        int[] nArray = new int[this.maximumconnectivity];
        int n3 = (int)(this.averageWalkLength + 0.5);
        int n4 = (int)(this.connectivity + 0.5);
        int n5 = this.TotalNumberStubs;
        this.initialVertices = this.TotalNumberVertices;
        boolean bl = false;
        Runtime runtime = Runtime.getRuntime();
        int n6 = this.numevents + 1;
        if (d > 0.0) {
            n6 = (int)((double)this.numevents * d);
        }
        if (n6 < 1) {
            n6 = 1;
        }
        long l = System.currentTimeMillis();
        int n7 = -1;
        for (n2 = 0; n2 < this.numevents; ++n2) {
            this.addVertex();
        }
        n2 = this.TotalNumberVertices - this.initialVertices;
        int n8 = (int)(this.connectivity * (double)this.numevents);
        for (n = 0; n < n8; ++n) {
            int n9 = this.Rnd.nextInt(this.TotalNumberVertices);
            int n10 = this.Rnd.nextInt(this.TotalNumberVertices);
            if (this.weightedEdges) {
                this.addEdge(n9, n10, new EdgeValue(1, 1.0));
                continue;
            }
            this.addEdge(n9, n10);
        }
        n = this.TotalNumberStubs - n5;
        long l2 = System.currentTimeMillis();
        double d2 = n2s.TruncDecimal((double)(l2 - l) / 1000.0, 2);
        System.out.println("Added " + n2 + " vertices and " + n + " edges in " + d2 + "sec");
        double d3 = (double)n / ((double)n2 * 2.0);
        System.out.println("Average new connectivity = " + NumbersToString.toString(d3, 3) + ", largest one connectivity = " + n7);
        if (this.infoLevel > 1) {
            long l3 = runtime.freeMemory();
            long l4 = runtime.totalMemory();
            System.out.println("\nFree memory " + l3 + " out of " + l4 + " total");
            int n11 = this.TotalNumberStubs;
            int n12 = this.TotalNumberVertices;
            int n13 = n12 - this.initialVertices;
            int n14 = n11 - n5;
            System.out.println("*** Finished Run in " + this.timing.runTimeString());
            System.out.println("    " + this.numevents + " events.");
            System.out.println("    " + (n12 - this.initialVertices) + " vertices added.");
            System.out.println("    " + (n11 - n5) + " edges added, expected " + (double)bl * this.connectivity);
        }
        return d2;
    }

    double DoBPCopyModel(double d) {
        int n;
        if (!this.bipartiteGraph) {
            System.out.println("--- not a bipartite graph for DoBPCopyModel ");
            return -1.0;
        }
        System.out.println("--- Starting DoBPCopyModel ");
        double d2 = this.probpra + this.probpp;
        double d3 = d2 + this.probpr;
        Runtime runtime = Runtime.getRuntime();
        int n2 = this.numevents + 1;
        if (d > 0.0) {
            n2 = (int)((double)this.numevents * d);
        }
        if (n2 < 1) {
            n2 = 1;
        }
        long l = System.currentTimeMillis();
        this.initialVertices = this.TotalNumberVertices;
        int n3 = this.TotalNumberStubs;
        int n4 = this.numevents;
        for (n = 0; n < n4; ++n) {
            int n5 = this.Rnd.nextInt(this.TotalNumberStubs) >> 1 << 1;
            if ((n5 & 1) == 1) {
                System.out.println("ERROR edge not even in DoBPCopyModel");
            }
            if (this.stubSourceList[n5] >= this.numberVertexType1) {
                System.out.println("ERROR edge source not type 2");
            }
            int n6 = 0;
            double d4 = this.Rnd.nextDouble();
            if (d4 < this.probpp) {
                ++n6;
            }
            if (d4 < d2) {
                ++n6;
            }
            if (d4 < d3) {
                ++n6;
            }
            int n7 = -1;
            switch (n6) {
                case 0: {
                    System.out.println(" ... pbar event new type 2 vertex, " + n6);
                    n7 = this.addVertex();
                    ++this.numberVertexType2;
                    break;
                }
                case 1: {
                    System.out.println("... pr event random type 2 vertex, " + n6);
                    n7 = this.Rnd.nextInt(this.numberVertexType2) + this.numberVertexType1;
                    break;
                }
                case 2: 
                case 3: {
                    System.out.println("... Preferential attachment, copying, " + n6);
                    int n8 = this.Rnd.nextInt(this.TotalNumberStubs) | 1;
                    n7 = this.stubSourceList[n8];
                    if (n7 >= this.numberVertexType1) break;
                    --n7;
                }
            }
            if (n7 < 1) {
                System.out.println("--- vnew <0 in DoBPCopyModel ");
                return -1.0;
            }
            if (n7 < this.numberVertexType1) {
                System.out.println("ERROR new vertex not type 2");
            }
            this.rewireEdgeTarget(n5, n7);
        }
        n = this.TotalNumberVertices - this.initialVertices;
        int n9 = this.TotalNumberStubs - n3;
        long l2 = System.currentTimeMillis();
        double d5 = n2s.TruncDecimal((double)(l2 - l) / 1000.0, 2);
        System.out.println("Added " + n + " vertices and " + n9 + " edges in " + d5 + "sec");
        if (this.infoLevel > 1) {
            long l3 = runtime.freeMemory();
            long l4 = runtime.totalMemory();
            System.out.println("\nFree memory " + l3 + " out of " + l4 + " total");
            int n10 = this.TotalNumberStubs;
            int n11 = this.TotalNumberVertices;
            int n12 = n11 - this.initialVertices;
            int n13 = n10 - n3;
            System.out.println("*** Finished Run in " + this.timing.runTimeString());
            System.out.println("    " + this.numevents + " events.");
            System.out.println("    " + (n11 - this.initialVertices) + " vertices added.");
            System.out.println("    " + (n10 - n3) + " edges added");
        }
        return d5;
    }

    double addAll(double d) {
        double d2 = -1.0;
        switch (this.edgegenerator) {
            case 0: {
                d2 = this.DoRun(d);
                break;
            }
            case 1: {
                d2 = this.DoER(d);
                break;
            }
            default: {
                System.out.println(" *** Edge generator " + this.edgegenerator + " unknown ***");
            }
        }
        return d2;
    }

    private void addVertexBasic() {
        this.vertexList[this.TotalNumberVertices] = new IntArrayList();
        if (this.directedGraph) {
            this.vertexSourceList[this.TotalNumberVertices] = new IntArrayList();
        }
        if (this.vertexEdgeListOn) {
            this.vertexEdgeList[this.TotalNumberVertices] = new IntArrayList();
            if (this.directedGraph) {
                this.vertexInEdgeList[this.TotalNumberVertices] = new IntArrayList();
            }
        }
        if (this.vertexlabels) {
            this.vertexLabelList[this.TotalNumberVertices] = new VertexLabel();
        }
    }

    public int addVertex() {
        this.addVertexBasic();
        if (this.vertexlabels) {
            this.vertexLabelList[this.TotalNumberVertices] = new VertexLabel(this.TotalNumberVertices);
        }
        return this.TotalNumberVertices++;
    }

    public int addVertex(VertexLabel vertexLabel) {
        this.addVertexBasic();
        this.vertexLabelList[this.TotalNumberVertices] = new VertexLabel(vertexLabel);
        return this.TotalNumberVertices++;
    }

    public int addVertex(double d, Coordinate coordinate) {
        this.addVertexBasic();
        String string = "(" + coordinate.x + "," + coordinate.y + ")";
        this.vertexLabelList[this.TotalNumberVertices] = new VertexLabel(string, d, coordinate);
        return this.TotalNumberVertices++;
    }

    public int addVertex(String string) {
        this.addVertexBasic();
        this.vertexLabelList[this.TotalNumberVertices] = new VertexLabel(string, this.TotalNumberVertices);
        return this.TotalNumberVertices++;
    }

    public int addVertex(String string, int n) {
        this.addVertexBasic();
        this.vertexLabelList[this.TotalNumberVertices] = new VertexLabel(string, n);
        return this.TotalNumberVertices++;
    }

    private void addEdgeSourceBasic(int n, int n2) {
        this.vertexList[n].add(n2);
        if (this.vertexEdgeListOn) {
            this.vertexEdgeList[n].add(this.TotalNumberStubs);
        }
        this.stubSourceList[this.TotalNumberStubs] = n;
    }

    private void addEdgeTargetBasic(int n, int n2) {
        if (!this.directedGraph) {
            this.vertexList[n2].add(n);
        } else {
            this.vertexSourceList[n2].add(n);
        }
        if (this.vertexEdgeListOn) {
            if (this.directedGraph) {
                this.vertexInEdgeList[n2].add(this.TotalNumberStubs);
            } else {
                this.vertexEdgeList[n2].add(this.TotalNumberStubs);
            }
        }
        this.stubSourceList[this.TotalNumberStubs] = n2;
    }

    public void addEdge(int n, int n2) {
        if (n == n2 && !this.selfLoops) {
            return;
        }
        this.addEdgeSourceBasic(n, n2);
        if (this.weightedEdges) {
            this.edgeValuetList[this.TotalNumberStubs] = new EdgeValue();
        }
        ++this.TotalNumberStubs;
        this.addEdgeTargetBasic(n, n2);
        if (this.weightedEdges) {
            this.edgeValuetList[this.TotalNumberStubs] = new EdgeValue();
        }
        ++this.TotalNumberStubs;
    }

    public void addEdgeUnweighted(int n, int n2) {
        if (n == n2 && !this.selfLoops) {
            return;
        }
        this.addEdgeSourceBasic(n, n2);
        ++this.TotalNumberStubs;
        this.addEdgeTargetBasic(n, n2);
        ++this.TotalNumberStubs;
    }

    public void addEdge(int n, int n2, EdgeValue edgeValue) {
        if (n == n2 && !this.selfLoops) {
            return;
        }
        this.addEdgeSourceBasic(n, n2);
        this.edgeValuetList[this.TotalNumberStubs++] = edgeValue;
        this.addEdgeTargetBasic(n, n2);
        this.edgeValuetList[this.TotalNumberStubs++] = edgeValue;
    }

    public void addEdge(int n, int n2, double d) {
        EdgeValue edgeValue = new EdgeValue(d);
        this.addEdge(n, n2, edgeValue);
    }

    public void addEdge(int n, int n2, EdgeValue edgeValue, EdgeValue edgeValue2) {
        if (!this.weightedEdges) {
            System.err.println("*** Adding weighted edge when it is not a weighted graph);");
        }
        this.addEdgeSourceBasic(n, n2);
        this.edgeValuetList[this.TotalNumberStubs++] = edgeValue;
        this.addEdgeTargetBasic(n, n2);
        this.edgeValuetList[this.TotalNumberStubs++] = edgeValue2;
    }

    public void increaseEdgeWeight(int n, int n2, double d) {
        if (n == n2 && !this.selfLoops) {
            return;
        }
        int n3 = this.getFirstEdgeGlobal(n, n2);
        if (n3 < 0) {
            if (this.weightedEdges) {
                this.addEdge(n, n2, d);
            } else {
                this.addEdge(n, n2);
            }
        } else if (this.weightedEdges) {
            this.edgeValuetList[n3++].weight += d;
        }
        if (this.infoLevel > 2) {
            System.out.print("Edge from " + n + " to " + n2);
            if (this.weightedEdges) {
                if (n3 < 1) {
                    n3 = this.TotalNumberStubs - 1;
                }
                System.out.println(", edge index " + (n3 - 1) + ", has had weight increased by " + d + " to become " + this.edgeValuetList[n3 - 1].weight);
                System.out.print("Edge from " + n + " to " + n2);
                System.out.println(", edge index " + n3 + ", has had weight increased by " + d + " to become " + this.edgeValuetList[n3].weight);
            } else {
                System.out.println(" now exists.");
            }
        }
    }

    public int addEdgeUnique(int n, int n2) {
        if (n == n2 && !this.selfLoops) {
            return -1;
        }
        if (!this.edgeExists(n, n2)) {
            this.addEdge(n, n2);
            return this.TotalNumberStubs;
        }
        return -1;
    }

    public void addEdgeWithTests(int n, int n2, double d) {
        if (!this.weightedEdges) {
            this.addEdgeWithTests(n, n2);
            return;
        }
        if (this.multiEdge) {
            this.addEdge(n, n2, d);
        } else {
            this.increaseEdgeWeight(n, n2, d);
        }
    }

    public int addEdgeWithTests(int n, int n2) {
        if (!this.multiEdge) {
            return this.addEdgeUnique(n, n2);
        }
        this.addEdge(n, n2);
        return this.TotalNumberStubs;
    }

    public boolean edgeExists(int n, int n2) {
        return this.getFirstEdgeLocal(n, n2) >= 0;
    }

    public int copySomeEdges(timgraph timgraph2, int[] nArray, int n) {
        int n2 = timgraph2.TotalNumberVertices;
        int n3 = 0;
        this.stubSourceList = new int[n];
        this.TotalNumberStubs = 0;
        int n4 = 0;
        while (n4 < timgraph2.TotalNumberStubs) {
            if (nArray[n4] != 0) {
                this.stubSourceList[this.TotalNumberStubs++] = timgraph2.stubSourceList[n4++];
                this.stubSourceList[this.TotalNumberStubs++] = timgraph2.stubSourceList[n4++];
                continue;
            }
            n4 += 2;
        }
        if (n != this.TotalNumberStubs) {
            n3 = 1;
            System.out.println("*** Total Number Edges wrong in copySomeEdges");
        }
        this.TotalNumberVertices = n2;
        this.vertexList = new IntArrayList[n2];
        this.vertexEdgeListOn = false;
        for (n4 = 0; n4 < n2; ++n4) {
            this.vertexList[n4] = new IntArrayList();
        }
        int n5 = 0;
        while (n5 < n) {
            n4 = this.stubSourceList[n5++];
            int n6 = this.stubSourceList[n5++];
            this.vertexList[n4].add(n6);
            this.vertexList[n6].add(n4);
        }
        return n3;
    }

    public int copyLabelledRandomEdges(timgraph timgraph2, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = timgraph2.TotalNumberVertices;
        int n7 = timgraph2.TotalNumberStubs / 2;
        int n8 = 0;
        this.stubSourceList = new int[n];
        if (this.weightedEdges) {
            this.edgeValuetList = new EdgeValue[n];
        }
        this.TotalNumberStubs = 0;
        for (n5 = 0; this.TotalNumberStubs < n && n5 != n7; ++n5) {
            n4 = timgraph2.edgerandomlist[n5] * 2;
            if (timgraph2.edgeValuetList[n4].label != n2) continue;
            this.edgeValuetList[this.TotalNumberStubs] = new EdgeValue(timgraph2.edgeValuetList[n4]);
            this.stubSourceList[this.TotalNumberStubs++] = timgraph2.stubSourceList[n4++];
            this.edgeValuetList[this.TotalNumberStubs] = new EdgeValue(timgraph2.edgeValuetList[n4]);
            this.stubSourceList[this.TotalNumberStubs++] = timgraph2.stubSourceList[n4];
        }
        if (n != this.TotalNumberStubs) {
            n8 = -1;
        }
        for (n5 = 0; this.TotalNumberStubs < n && n5 != n7; ++n5) {
            n4 = timgraph2.edgerandomlist[n5] * 2;
            if (timgraph2.edgeValuetList[n4].label == n2) continue;
            this.edgeValuetList[this.TotalNumberStubs] = new EdgeValue(timgraph2.edgeValuetList[n4]);
            this.stubSourceList[this.TotalNumberStubs++] = timgraph2.stubSourceList[n4++];
            this.edgeValuetList[this.TotalNumberStubs] = new EdgeValue(timgraph2.edgeValuetList[n4]);
            this.stubSourceList[this.TotalNumberStubs++] = timgraph2.stubSourceList[n4];
        }
        if (n != this.TotalNumberStubs) {
            n8 = -2;
        }
        this.TotalNumberVertices = n6;
        this.vertexList = new IntArrayList[n6];
        for (n3 = 0; n3 < n6; ++n3) {
            this.vertexList[n3] = new IntArrayList();
        }
        this.vertexEdgeListOn = false;
        n4 = 0;
        while (n4 < this.TotalNumberStubs) {
            n3 = this.stubSourceList[n4++];
            int n9 = this.stubSourceList[n4++];
            this.vertexList[n3].add(n9);
            this.vertexList[n9].add(n3);
        }
        return n8;
    }

    public void calcRandomEdgeOrder() {
        int n;
        int n2 = this.TotalNumberStubs / 2;
        if (this.edgerandomlist == null) {
            this.edgerandomlist = new int[n2];
        }
        for (n = 0; n < n2; ++n) {
            this.edgerandomlist[n] = n;
        }
        for (n = 0; n < n2; ++n) {
            int n3 = this.Rnd.nextInt(n2);
            if (n3 == n) continue;
            int n4 = this.edgerandomlist[n3];
            this.edgerandomlist[n3] = this.edgerandomlist[n];
            this.edgerandomlist[n] = n4;
        }
    }

    public void calcReverseEdgeOrder() {
        int n = this.TotalNumberStubs / 2;
        for (int i = 0; i < n / 2; ++i) {
            int n2 = n - 1 - i;
            int n3 = this.edgerandomlist[n2];
            this.edgerandomlist[n2] = this.edgerandomlist[i];
            this.edgerandomlist[i] = n3;
        }
    }

    public void calcRandomEdgeWeightOrder(int n) {
        int n2;
        int n3 = this.TotalNumberStubs / 2;
        if (this.edgerandomlist == null) {
            this.edgerandomlist = new int[n3];
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.edgerandomlist[n2] = n2;
        }
        for (int i = 0; i < n3; ++i) {
            int n4 = this.Rnd.nextInt(n3);
            if (n4 == i) continue;
            n2 = this.edgerandomlist[n4];
            this.edgerandomlist[n4] = this.edgerandomlist[i];
            this.edgerandomlist[i] = n2;
        }
        if (n > -1) {
            this.QuickSort(n, this.edgerandomlist, 0, n3 - 1);
        }
    }

    private void QuickSort(int n, int[] nArray, int n2, int n3) {
        int n4 = n2;
        int n5 = n3;
        if (n3 > n2) {
            EdgeValue edgeValue = this.edgeValuetList[nArray[(n2 + n3) / 2] * 2];
            while (n4 <= n5) {
                while (n4 < n3 && this.compareWeights(n, this.edgeValuetList[nArray[n4] * 2], edgeValue)) {
                    ++n4;
                }
                while (n5 > n2 && this.compareWeights(n, edgeValue, this.edgeValuetList[nArray[n5] * 2])) {
                    --n5;
                }
                if (n4 > n5) continue;
                int n6 = nArray[n4];
                nArray[n4] = nArray[n5];
                nArray[n5] = n6;
                ++n4;
                --n5;
            }
            if (n2 < n5) {
                this.QuickSort(n, nArray, n2, n5);
            }
            if (n4 < n3) {
                this.QuickSort(n, nArray, n4, n3);
            }
        }
    }

    public boolean compareWeights(int n, EdgeValue edgeValue, EdgeValue edgeValue2) {
        double d = -1.0;
        switch (n) {
            case 0: {
                d = edgeValue.weight - edgeValue2.weight;
                break;
            }
            case 1: {
                d = edgeValue2.weight - edgeValue.weight;
                break;
            }
            case 2: {
                d = edgeValue.label - edgeValue2.label;
                break;
            }
            case 3: {
                d = edgeValue2.label - edgeValue.label;
                break;
            }
            default: {
                System.out.println("*** ERROR in compareWeights, criteria " + n + "unknown");
            }
        }
        return d > 0.0;
    }

    public void randomiseGraph() {
        int n = -1;
        for (int i = 0; i < this.TotalNumberStubs; ++i) {
            n = -1;
            while (n < 0) {
                n = this.rewireEdgePair(i, this.Rnd.nextInt(this.TotalNumberStubs));
            }
        }
        if (this.vertexEdgeListOn) {
            this.createVertexGlobalEdgeList();
        }
    }

    public int rewireEdgePair(int n, int n2) {
        if (n >= this.TotalNumberStubs || n2 >= this.TotalNumberStubs) {
            return -1;
        }
        if (n < 0 || n2 < 0) {
            return -2;
        }
        int n3 = n >> 1;
        int n4 = n2 >> 1;
        if (n3 == n4) {
            return -3;
        }
        int n5 = n;
        int n6 = n2;
        if (this.directedGraph) {
            n5 = n3 << 1;
            n6 = n4 << 1;
        }
        int n7 = n5 ^ 1;
        int n8 = n6 ^ 1;
        int n9 = this.stubSourceList[n5];
        int n10 = this.stubSourceList[n7];
        int n11 = this.stubSourceList[n6];
        int n12 = this.stubSourceList[n8];
        if (this.infoLevel > 1) {
            System.out.println(n9 + SEP + n10 + SEP + n11 + SEP + n12);
        }
        int n13 = this.vertexList[n9].indexOfFromTo(n10, 0, this.vertexList[n9].size() - 1);
        int n14 = this.vertexList[n10].indexOfFromTo(n9, 0, this.vertexList[n10].size() - 1);
        int n15 = this.vertexList[n11].indexOfFromTo(n12, 0, this.vertexList[n11].size() - 1);
        int n16 = this.vertexList[n12].indexOfFromTo(n11, 0, this.vertexList[n12].size() - 1);
        if (this.infoLevel > 1) {
            System.out.println(n14 + SEP + n13 + SEP + n16 + SEP + n15);
            System.out.println(this.vertexList[n9]);
            System.out.println(this.vertexList[n10]);
            System.out.println(this.vertexList[n11]);
            System.out.println(this.vertexList[n12]);
        }
        boolean bl = this.Rnd.nextBoolean();
        int n17 = 0;
        if (bl) {
            if (n9 == n12 || n11 == n10) {
                return -3;
            }
            this.stubSourceList[n5] = n11;
            this.stubSourceList[n6] = n9;
            this.vertexList[n9].set(n13, n12);
            this.vertexList[n10].set(n14, n11);
            this.vertexList[n11].set(n15, n10);
            this.vertexList[n12].set(n16, n9);
            n17 = 3;
        } else {
            if (n9 == n11 || n12 == n10) {
                return -4;
            }
            this.stubSourceList[n6] = n10;
            this.stubSourceList[n7] = n11;
            this.vertexList[n9].set(n13, n11);
            this.vertexList[n10].set(n14, n12);
            this.vertexList[n11].set(n15, n9);
            this.vertexList[n12].set(n16, n10);
            n17 = 4;
        }
        return n17;
    }

    public int rewireEdgeTarget(int n, int n2) {
        System.out.println(" e, vnew " + n + " : " + n2);
        if (n >= this.TotalNumberStubs || n < 0) {
            return -1;
        }
        int n3 = n;
        int n4 = n3 ^ 1;
        int n5 = this.stubSourceList[n4];
        int n6 = this.stubSourceList[n3];
        this.vertexList[n5].delete(n6);
        this.vertexList[n2].add(n6);
        int n7 = this.vertexList[n6].indexOf(n5);
        this.vertexList[n6].set(n7, n2);
        this.stubSourceList[n4] = n2;
        System.out.println("efixed :emove = vfixed - vmove -> vnew  |  " + n3 + ":" + n4 + " = " + n6 + " - " + n5 + " -> " + n2);
        return 0;
    }

    public double calcAverage(int n, int n2) {
        return (double)n / (double)n2;
    }

    public double calcAverage(long l, long l2) {
        return (double)l / (double)l2;
    }

    public double calcError(long l, long l2, long l3) {
        return this.calcError((double)l, (double)l2, (double)l3);
    }

    public double calcError(int n, int n2, int n3) {
        return this.calcError((double)n, (double)n2, (double)n3);
    }

    public double calcError(double d, double d2, double d3) {
        if (d3 > 1.0) {
            return this.calcSigma(d, d2, d3) / Math.sqrt(d3 - 1.0);
        }
        return 0.0;
    }

    public double calcSigma(double d, double d2, double d3) {
        return Math.sqrt((d2 - d * d / d3) / d3);
    }

    public int calcNumberVertices() {
        int n;
        for (n = 0; n < this.vertexList.length && this.vertexList[n] != null; ++n) {
        }
        if (this.TotalNumberVertices != n) {
            System.out.println("*** Error in calcNumberVertices, number of vertices inconsistent");
            System.out.println("     TNV=" + this.TotalNumberVertices + ", calc = " + n);
        }
        return n;
    }

    public int calcNumberEdges() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            if (this.vertexList[i] != null) {
                n += this.vertexList[i].size();
            }
            if (!this.directedGraph || this.vertexSourceList[i] == null) continue;
            n2 += this.vertexSourceList[i].size();
        }
        if (this.TotalNumberStubs != n2 + n) {
            System.out.println("*** Error in calcNumberEdges, number of edges inconsistent");
            System.out.println("     TNS=" + this.TotalNumberStubs + ", calc out = " + n + ", in = " + n2);
        }
        return n2 + n;
    }

    private void calcDistanceNext(int n, int n2, int n3, IntArrayList intArrayList) {
        int n4;
        IntArrayList intArrayList2 = new IntArrayList(100);
        int n5 = 0;
        int n6 = 0;
        long l = 0L;
        for (int i = 0; i < intArrayList.size() && this.vertexdistance[n4 = intArrayList.get(i)] <= -1; ++i) {
            this.vertexdistance[n4] = n;
            this.vertexComponent[n4] = n3;
            ++n5;
            n6 = this.vertexList[n4].size();
            l += (long)n6;
            for (int j = 0; j < n6; ++j) {
                int n7 = this.vertexList[n4].get(j);
                if (this.vertexdistance[n7] >= -1) continue;
                this.vertexdistance[n7] = -1;
                intArrayList2.add(n7);
            }
        }
        this.distancedist.add(n5);
        this.componentsize += n5;
        if (intArrayList2.size() > 0 && n < n2) {
            this.calcDistanceNext(n + 1, n2, n3, intArrayList2);
        }
    }

    private void calcDistanceOne(int n, int n2) {
        int n3;
        this.vertexdistance = new int[this.TotalNumberVertices];
        this.vertexComponent = new int[this.TotalNumberVertices];
        this.distancedist = new IntArrayList();
        IntArrayList intArrayList = new IntArrayList(100);
        intArrayList.add(n);
        int n4 = 1;
        this.componentsize = 0;
        for (n3 = 0; n3 < this.TotalNumberVertices; ++n3) {
            this.vertexdistance[n3] = -999999;
        }
        this.vertexdistance[n] = -1;
        this.calcDistanceNext(0, n2, n4, intArrayList);
        this.diameter = this.distancedist.size() - 1;
        n3 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 1; i < this.distancedist.size(); ++i) {
            int n7 = this.distancedist.get(i);
            n6 += n7;
            n3 += n7 * i;
            n5 += n7 * i * i;
        }
        if (n6 > 0) {
            this.distanceaverage = this.calcAverage(n3, n6);
            this.distanceerror = this.calcError(n3, n5, n6);
            this.distancesigma = this.calcSigma(n3, n5, n6);
        } else {
            this.distanceaverage = 0.0;
            this.distanceerror = 0.0;
            this.distancesigma = 0.0;
        }
    }

    private void calcDistanceNextComponent(int n, int n2) {
        this.componentSource.add(n);
        int n3 = this.componentSource.size() - 1;
        this.distancedist = new IntArrayList();
        IntArrayList intArrayList = new IntArrayList(100);
        intArrayList.add(n);
        this.componentsize = 0;
        if (this.vertexdistance[n] > -99) {
            System.out.println("*** Error in calcDistanceNextComponent ");
        }
        this.vertexdistance[n] = -1;
        this.calcDistanceNext(0, n2, n3, intArrayList);
        this.componentSize.add(this.componentsize);
        if (this.componentSizeMax < this.componentsize) {
            this.componentSizeMax = this.componentsize;
            this.componentSourceMax = n;
            this.componentDiameterMax = this.distancedist.size() - 1;
            this.componentGCCIndex = n3;
        }
        this.componentDist.add(this.distancedist.size() - 1);
        if (this.infoLevel > 1) {
            System.out.println("Finished looking at component " + this.componentSize.size() + " around vertex " + n);
        }
    }

    public void calcComponents() {
        int n;
        int n2;
        this.vertexdistance = new int[this.TotalNumberVertices];
        this.vertexComponent = new int[this.TotalNumberVertices];
        this.distancedist = new IntArrayList();
        this.componentSize = new IntArrayList();
        this.componentSource = new IntArrayList();
        this.componentDist = new IntArrayList();
        IntArrayList intArrayList = new IntArrayList(100);
        this.componentSizeMax = -1;
        this.componentSourceMax = -1;
        this.componentGCCDist = -1.0;
        this.componentGCCIndex = -1;
        this.componentSingleNumber = -1;
        for (n2 = 0; n2 < this.TotalNumberVertices; ++n2) {
            this.vertexdistance[n2] = -999999;
            this.vertexComponent[n2] = -999999;
        }
        for (n2 = 0; n2 < this.TotalNumberVertices; ++n2) {
            if (this.vertexComponent[n2] >= 0) continue;
            this.calcDistanceNextComponent(n2, this.TotalNumberVertices);
        }
        n2 = 0;
        this.componentSingleNumber = 0;
        for (n = 0; n < this.componentSize.size(); ++n) {
            n2 += this.componentSize.get(n);
            if (this.componentSize.get(n) != 1) continue;
            ++this.componentSingleNumber;
        }
        if (n2 != this.TotalNumberVertices) {
            System.out.println("!!! Warning components have total " + n2 + " out of " + this.TotalNumberVertices + " vertices");
        }
        n2 = 0;
        n = 0;
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            if (this.vertexComponent[i] != this.componentGCCIndex) continue;
            n += this.vertexdistance[i];
            ++n2;
        }
        if (n2 != this.componentSizeMax) {
            System.out.println("!!! Warning GCC component has total " + n2 + " vertices but recorded as " + this.componentSizeMax + " vertices");
        }
        if (this.componentSizeMax > 0) {
            this.componentGCCDist = n / this.componentSizeMax;
        }
    }

    public void calcRing(int n, int n2) {
        int n3;
        this.vertexdistance = new int[this.TotalNumberVertices];
        this.vertexComponent = new int[this.TotalNumberVertices];
        this.distancedist = new IntArrayList();
        this.componentSize = new IntArrayList();
        this.componentSource = new IntArrayList();
        this.componentDist = new IntArrayList();
        IntArrayList intArrayList = new IntArrayList(100);
        this.componentSizeMax = -1;
        this.componentSourceMax = -1;
        this.componentGCCDist = -1.0;
        this.componentGCCIndex = -1;
        this.componentSingleNumber = -1;
        for (n3 = 0; n3 < this.TotalNumberVertices; ++n3) {
            this.vertexdistance[n3] = -999999;
            this.vertexComponent[n3] = -999999;
        }
        this.calcDistanceNextComponent(n, n2);
        n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            if (this.vertexComponent[i] != this.componentGCCIndex) continue;
            n4 += this.vertexdistance[i];
            ++n3;
        }
        if (n3 != this.componentSizeMax) {
            System.out.println("!!! Warning GCC component has total " + n3 + " vertices but recorded as " + this.componentSizeMax + " vertices");
        }
        if (this.componentSizeMax > 0) {
            this.componentGCCDist = n4 / this.componentSizeMax;
        }
    }

    public TreeSet<Integer> getGCC() {
        return this.getComponent(this.componentGCCIndex);
    }

    public TreeSet<Integer> getComponent(int n) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            if (this.vertexComponent[i] != n) continue;
            treeSet.add(i);
        }
        return treeSet;
    }

    public int getVertexComponentLabel(int n) {
        return this.vertexComponent[n];
    }

    public TreeSet<Integer> getRing(int n, int n2) {
        this.calcDistanceOne(n, n2);
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            if (this.vertexdistance[i] < 0) continue;
            treeSet.add(i);
        }
        return treeSet;
    }

    public TreeSet<Integer> getEdgeSubGraph(Set<Integer> set) {
        if (!this.weightedEdges) {
            throw new IllegalArgumentException("*** getEdgeSubGraph needed edges to have labels");
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int i = 0; i < this.TotalNumberStubs; i += 2) {
            if (!set.contains(this.edgeValuetList[i].label)) continue;
            treeSet.add(this.stubSourceList[i]);
            treeSet.add(this.stubSourceList[i + 1]);
        }
        return treeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDijkstra() {
        int n = 0;
        double d = -1.0;
        double d2 = 0.0;
        this.DijkstraMaxDist = 0.0;
        this.distance = new double[this.TotalNumberVertices][this.TotalNumberVertices];
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            int n2;
            int n3 = i;
            double d3 = this.MAXDISTANCE;
            boolean[] blArray = new boolean[this.TotalNumberVertices];
            for (n2 = 0; n2 < this.TotalNumberVertices; ++n2) {
                this.distance[i][n2] = this.MAXDISTANCE;
                blArray[n2] = true;
            }
            this.distance[i][i] = 0.0;
            for (n2 = 0; n2 < this.TotalNumberVertices; ++n2) {
                int n4;
                d3 = this.MAXDISTANCE;
                for (n4 = 0; n4 < this.TotalNumberVertices; ++n4) {
                    if (!blArray[n4] || !(this.distance[i][n4] < d3)) continue;
                    d3 = this.distance[i][n4];
                    n3 = n4;
                }
                if (d3 == this.MAXDISTANCE) break;
                blArray[n3] = false;
                d = this.vertexList[n3].size();
                d2 += d;
                n4 = 0;
                while ((double)n4 < d) {
                    int n5 = this.vertexList[n3].get(n4);
                    double d4 = this.MAXDISTANCE * 1.0001;
                    switch (n) {
                        default: 
                    }
                    d4 = d3 + 0.0;
                    if (this.distance[i][n5] > d4) {
                        this.distance[i][n5] = d4;
                    }
                    ++n4;
                }
            }
            if (!(this.DijkstraMaxDist < d3)) continue;
            this.DijkstraMaxDist = d3;
        }
    }

    void calcRingParameters(int n) {
        int n2;
        int n3;
        this.vertexdistance = new int[this.TotalNumberVertices];
        this.vertexComponent = new int[this.TotalNumberVertices];
        this.distancedist = new IntArrayList();
        this.componentSize = new IntArrayList();
        this.componentSource = new IntArrayList();
        this.componentDist = new IntArrayList();
        IntArrayList intArrayList = new IntArrayList(100);
        for (n3 = 0; n3 < this.TotalNumberVertices; ++n3) {
            this.vertexdistance[n3] = -999999;
            this.vertexComponent[n3] = -999999;
        }
        this.calcDistanceNextComponent(n, this.TotalNumberVertices + 1);
        this.ringdegree = new DoubleArrayList();
        for (n2 = 0; n2 < this.TotalNumberVertices; ++n2) {
            if (this.vertexComponent[n2] < 0) continue;
            int n4 = this.vertexdistance[n2];
            n3 = this.vertexList[n2].size();
            while (this.ringdegree.size() <= n4) {
                this.ringdegree.add(0.0);
            }
            double d = this.ringdegree.get(n4);
            this.ringdegree.set(n4, d + (double)n3);
        }
        for (n2 = 0; n2 < this.ringdegree.size(); ++n2) {
            this.ringdegree.set(n2, this.ringdegree.get(n2) / (double)this.distancedist.get(n2));
        }
    }

    void updateRingStats(int n, int n2) {
        while (this.ringdegree.size() < n) {
            this.ringdegree.add(0.0);
        }
        this.ringdegree.get(n);
    }

    public void calcDistanceSample(double d, int n, int n2) {
        boolean bl = false;
        int n3 = n;
        int n4 = n2;
        if (d > 1.0) {
            bl = true;
            n4 = this.TotalNumberVertices;
            n3 = this.TotalNumberVertices;
        }
        this.totdistancedist = new DoubleArrayList(100);
        this.totdistance2dist = new DoubleArrayList(100);
        this.nsamples = 0;
        int n5 = 0;
        int n6 = 0;
        this.totdistanceaverage = 0.0;
        this.totdistanceerror = 0.0;
        this.totdistancesigma = 0.0;
        this.diameteraverage = 0.0;
        this.diametersigma = 0.0;
        this.diametererror = 0.0;
        this.diametermin = 9999999;
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        IntArrayList intArrayList = new IntArrayList();
        double d2 = 0.0;
        double d3 = 0.0;
        do {
            int n7;
            ++this.nsamples;
            if (bl) {
                this.calcDistanceOne(this.nsamples - 1, this.TotalNumberVertices + 1);
            } else if (this.nsamples == 1 || this.componentSourceMax < 0) {
                this.calcDistanceOne(this.Rnd.nextInt(this.TotalNumberVertices), this.TotalNumberVertices + 1);
            } else {
                this.calcDistanceOne(this.componentSourceMax, this.TotalNumberVertices + 1);
            }
            doubleArrayList.add(this.distanceaverage);
            d2 += this.distanceaverage;
            d3 += this.distanceaverage * this.distanceaverage;
            double d4 = 0.0;
            double d5 = 0.0;
            int n8 = this.distancedist.size();
            int n9 = this.totdistancedist.size();
            if (n9 < n8) {
                n8 = n9;
            }
            for (n7 = 0; n7 < n8; ++n7) {
                d4 = this.distancedist.get(n7);
                d5 = d4 * d4;
                this.totdistancedist.set(n7, d4 += this.totdistancedist.get(n7));
                this.totdistance2dist.set(n7, d5 += this.totdistance2dist.get(n7));
            }
            for (n7 = n8; n7 < this.distancedist.size(); ++n7) {
                d4 = this.distancedist.get(n7);
                d5 = d4 * d4;
                this.totdistancedist.add(d4);
                this.totdistance2dist.add(d5);
            }
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            for (int i = 1; i < this.totdistancedist.size(); ++i) {
                d4 = this.totdistancedist.get(i);
                d8 += d4;
                d6 += d4 * (double)i;
                d7 += d4 * (double)i * (double)i;
            }
            this.totdistanceaverage = d6 / d8;
            this.totdistanceerror = this.calcError(d6, d7, d8);
            this.totdistancesigma = this.calcSigma(d6, d7, d8);
            n5 += this.diameter;
            n6 += this.diameter * this.diameter;
            intArrayList.add(this.diameter);
            if (this.diametermin > this.diameter) {
                this.diametermin = this.diameter;
            }
            this.diameteraverage = this.calcAverage(n5, this.nsamples);
            this.diametererror = this.calcError(n5, n6, this.nsamples);
            this.diametersigma = this.calcSigma(n5, n6, this.nsamples);
        } while (this.nsamples < n4 && (this.totdistanceerror > this.totdistanceaverage * d || this.nsamples < n3));
        this.onesdistanceav = d2 / (double)this.nsamples;
        this.onesdistanceerror = this.calcError(d2, d3, (double)this.nsamples);
        this.onesdistancesigma = this.calcSigma(d2, d3, this.nsamples);
        this.diametermax = this.totdistancedist.size() - 1;
    }

    double calcCCOneOld(int n) {
        int n2 = 0;
        int n3 = 0;
        if (n < 0 || n >= this.TotalNumberVertices) {
            System.out.println("*** Error in calcCCOne vertex " + n + " invalid with " + this.TotalNumberVertices + " total vertices");
            return -2.0;
        }
        int n4 = this.vertexList[n].size();
        if (n4 < 2) {
            return -1.0;
        }
        for (int i = 0; i < n4 - 1; ++i) {
            int n5 = this.vertexList[n].get(i);
            int n6 = this.vertexList[n5].size();
            block1: for (int j = i + 1; j < n4; ++j) {
                int n7;
                int n8;
                int n9;
                ++n2;
                int n10 = this.vertexList[n].get(j);
                int n11 = this.vertexList[n10].size();
                if (n6 < n11) {
                    n9 = n5;
                    n8 = n10;
                    n7 = n6;
                } else {
                    n9 = n10;
                    n8 = n5;
                    n7 = n11;
                }
                for (int k = 0; k < n7; ++k) {
                    if (this.vertexList[n9].get(k) != n8) continue;
                    ++n3;
                    continue block1;
                }
            }
        }
        return (double)n3 / (double)n2;
    }

    double calcCCOne(int n) {
        int n2 = 0;
        int n3 = 0;
        if (n < 0 || n >= this.TotalNumberVertices) {
            throw new RuntimeException("*** Error in calcCCOne vertex " + n + " invalid with " + this.TotalNumberVertices + " total vertices");
        }
        int n4 = this.vertexList[n].size();
        if (n4 < 2) {
            return -1.0;
        }
        for (int i = 0; i < n4 - 1; ++i) {
            int n5 = this.vertexList[n].get(i);
            int n6 = this.vertexList[n5].size();
            for (int j = i + 1; j < n4; ++j) {
                ++n2;
                int n7 = this.vertexList[n].get(j);
                for (int k = 0; k < n6; ++k) {
                    if (this.vertexList[n5].get(k) != n7) continue;
                    ++n3;
                }
            }
        }
        return (double)n3 / (double)n2;
    }

    int calcTriangles(int n) {
        boolean bl = false;
        int n2 = 0;
        if (n < 0 || n >= this.TotalNumberVertices) {
            throw new RuntimeException("*** Error in calcTriangles vertex " + n + " invalid with " + this.TotalNumberVertices + " total vertices");
        }
        int n3 = this.vertexList[n].size();
        if (n3 < 2) {
            return 0;
        }
        for (int i = 0; i < n3 - 1; ++i) {
            int n4 = this.vertexList[n].get(i);
            int n5 = this.vertexList[n4].size();
            for (int j = i + 1; j < n3; ++j) {
                int n6 = this.vertexList[n].get(j);
                for (int k = 0; k < n5; ++k) {
                    if (this.vertexList[n4].get(k) != n6) continue;
                    ++n2;
                }
            }
        }
        return n2;
    }

    int[] calcTrianglesSquares(int n) {
        int[] nArray = new int[]{0, 0};
        int n2 = -1;
        if (n < 0 || n >= this.TotalNumberVertices) {
            throw new RuntimeException("*** Error in calcSquares vertex " + n + " invalid with " + this.TotalNumberVertices + " total vertices");
        }
        int n3 = this.vertexList[n].size();
        if (n3 < 2) {
            return nArray;
        }
        for (int i = 0; i < n3 - 1; ++i) {
            int n4 = this.vertexList[n].get(i);
            int n5 = this.vertexList[n4].size();
            IntArrayList intArrayList = this.vertexList[n4];
            for (int j = i + 1; j < n3; ++j) {
                int n6 = this.vertexList[n].get(j);
                for (int k = 0; k < n5; ++k) {
                    n2 = this.vertexList[n4].get(k);
                    if (n2 == n6) {
                        nArray[0] = nArray[0] + 1;
                        continue;
                    }
                    if (n2 == n || !this.vertexList[n6].contains(n2)) continue;
                    nArray[1] = nArray[1] + 1;
                }
            }
        }
        return nArray;
    }

    public void calcCCSample(double d, int n, int n2) {
        boolean bl = false;
        int n3 = n;
        int n4 = n2;
        if (d >= 1.0) {
            bl = true;
            n4 = this.TotalNumberVertices;
            n3 = this.TotalNumberVertices;
        }
        int n5 = 0;
        this.CCnsamples = 0;
        this.CCaverage = 0.0;
        this.CCerror = 0.0;
        this.CCsigma = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        do {
            double d4 = bl ? this.calcCCOne(n5) : this.calcCCOne(this.Rnd.nextInt(this.TotalNumberVertices));
            ++n5;
            if (d4 < 0.0) continue;
            ++this.CCnsamples;
            this.CCaverage = (d2 += d4) / (double)this.CCnsamples;
            this.CCerror = this.calcError(d2, d3 += d4 * d4, (double)this.CCnsamples);
            this.CCsigma = this.calcSigma(d2, d3, this.CCnsamples);
            if (n5 >= n4) break;
        } while (this.CCerror > this.CCaverage * d || n5 < n3);
    }

    int unweightedEdgeSource(int n) {
        if (n % 2 == 1) {
            return n - 1;
        }
        return n;
    }

    double calcCCEdgeOne(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl = false;
        int n6 = 0;
        if (n < 0 || n >= this.TotalNumberStubs) {
            System.out.println("*** Error in calcCCOne vertex " + n + " invalid with " + this.TotalNumberStubs + " total edges");
            return -2.0;
        }
        int n7 = n / 2 * 2;
        int n8 = this.stubSourceList[n7];
        int n9 = this.stubSourceList[n7 + 1];
        int n10 = this.vertexList[n8].size();
        int n11 = this.vertexList[n9].size();
        if (n10 == 0 && n11 == 0) {
            return -1.0;
        }
        for (n5 = 0; n5 < n10 - 1; ++n5) {
            n4 = this.vertexList[n8].get(n5);
            for (n3 = 0; n3 < n11; ++n3) {
                n2 = this.vertexList[n9].get(n3);
                if (n4 != n2) continue;
                ++n6;
            }
        }
        n5 = n8;
        n8 = n9;
        n9 = n5;
        n10 = this.vertexList[n8].size();
        n11 = this.vertexList[n9].size();
        if (n10 == 0 && n11 == 0) {
            return -1.0;
        }
        for (n3 = 0; n3 < n10 - 1; ++n3) {
            n4 = this.vertexList[n8].get(n3);
            for (int i = 0; i < n11; ++i) {
                n2 = this.vertexList[n9].get(i);
                if (n4 != n2) continue;
                ++n6;
            }
        }
        return (double)n6 / ((double)n11 * (double)n10);
    }

    public void calcCCEdgeSample(double d, int n, int n2) {
        boolean bl = false;
        int n3 = n;
        int n4 = n2;
        if (d >= 1.0) {
            bl = true;
            n4 = this.TotalNumberStubs;
            n3 = this.TotalNumberStubs;
        }
        int n5 = 0;
        this.CCEdgensamples = 0;
        this.CCEdgeaverage = 0.0;
        this.CCEdgeerror = 0.0;
        this.CCEdgesigma = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (this.TotalNumberStubs == 0) {
            return;
        }
        do {
            double d4 = bl ? this.calcCCEdgeOne(n5) : this.calcCCEdgeOne(this.Rnd.nextInt(this.TotalNumberStubs));
            ++n5;
            if (d4 < 0.0) continue;
            ++this.CCEdgensamples;
            this.CCEdgeaverage = (d2 += d4) / (double)this.CCEdgensamples;
            this.CCEdgeerror = this.calcError(d2, d3 += d4 * d4, (double)this.CCEdgensamples);
            this.CCEdgesigma = this.calcSigma(d2, d3, this.CCEdgensamples);
            if (n5 >= n4) break;
        } while (this.CCerror > this.CCaverage * d || n5 < n3);
    }

    public double calcDegreeFirstMoment() {
        return (double)this.TotalNumberStubs / (double)this.TotalNumberVertices;
    }

    public double getDegreeFirstMoment() {
        return this.calcDegreeFirstMoment();
    }

    public double getAverageDegree() {
        if (this.TotalNumberVertices == 1) {
            return -3.57986421E8;
        }
        if (this.directedGraph) {
            return (double)this.getNumberEdges() / (double)this.TotalNumberVertices;
        }
        return (double)this.TotalNumberStubs / (double)this.TotalNumberVertices;
    }

    public double getDegreeSecondMoment() {
        if (this.degreeSecondMoment < 0.0) {
            this.calcDegreeSecondMoment();
        }
        return this.degreeSecondMoment;
    }

    public double calcDegreeSecondMoment() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            n2 = this.getVertexDegree(i);
            n += n2 * n2;
        }
        this.degreeSecondMoment = (double)n / (double)this.TotalNumberVertices;
        return this.degreeSecondMoment;
    }

    public void calcDegreeDistribution() {
        this.calcDegreeDistributionUnipartite();
        this.calcDegreeDistributionBipartite();
    }

    public void calcDegreeDistributionBipartite() {
        String string = this.inputName.getNameRoot();
        if (!this.bipartiteGraph) {
            return;
        }
        this.DD1total = new DegreeDistribution(string + "Type1Total");
        this.DD1total.calcDegreeDistribution(this.vertexList, 0, this.numberVertexType1);
        this.DD2total = new DegreeDistribution(string + "Type2Total");
        this.DD2total.calcDegreeDistribution(this.vertexList, this.numberVertexType1, this.TotalNumberVertices);
    }

    public void calcDegreeDistributionUnipartite() {
        String string = this.inputName.getNameRoot();
        if (this.directedGraph) {
            this.DDout = new DegreeDistribution(string + "Out");
            this.DDout.calcDegreeDistribution(this.vertexList, this.TotalNumberVertices);
            this.DDin = new DegreeDistribution(string + "In");
            this.DDin.calcDegreeDistribution(this.vertexSourceList, this.TotalNumberVertices);
            int n = Math.max(this.DDin.maximum, this.DDout.maximum);
            this.DDtotal = new DegreeDistribution(string + "Total", n);
            this.DDtotal.calcDegreeDistribution(this.vertexList, this.vertexSourceList, this.TotalNumberVertices);
        } else {
            this.DDtotal = new DegreeDistribution(string + "Total");
            this.DDtotal.calcDegreeDistribution(this.vertexList, this.TotalNumberVertices);
        }
    }

    void ordervertexList() {
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            if (this.vertexList[i] == null) {
                System.out.println("In ordervertexList null vertexList " + i);
                return;
            }
            int n = this.vertexList[i].size();
            for (int j = 0; j < n; ++j) {
                int n2 = this.vertexList[i].get(j);
                for (int k = j; k < n; ++k) {
                    if (n2 <= this.vertexList[i].get(k)) continue;
                    n2 = this.vertexList[i].get(k);
                    this.vertexList[i].set(k, this.vertexList[i].get(j));
                    this.vertexList[i].set(j, n2);
                }
            }
        }
    }

    void calcMultipleLinkDistribution() {
        this.ordervertexList();
        this.weightmaximum = -1;
        this.weightdarr = new IntArrayList();
        this.weightdarr.add(0);
        this.rddarr = new IntArrayList();
        this.rddarr.add(0);
        this.rvertexList = new IntArrayList[this.maximumVertices];
        this.strengthlist = new IntArrayList[this.maximumVertices];
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            this.rvertexList[i] = new IntArrayList();
            this.strengthlist[i] = new IntArrayList();
            if (this.vertexList[i] == null) {
                this.addExtendIntArrayList(this.weightdarr, 0, 1);
                break;
            }
            int n = this.vertexList[i].size();
            int n2 = this.vertexList[i].get(0);
            int n3 = 1;
            for (int j = 1; j < n; ++j) {
                int n4 = this.vertexList[i].get(j);
                if (n2 == n4) {
                    ++n3;
                    continue;
                }
                this.strengthlist[i].add(n3);
                this.rvertexList[i].add(n2);
                this.addExtendIntArrayList(this.weightdarr, n3, 1);
                n2 = n4;
                n3 = 1;
            }
            this.strengthlist[i].add(n3);
            this.rvertexList[i].add(n2);
            this.addExtendIntArrayList(this.weightdarr, n3, 1);
            this.addExtendIntArrayList(this.rddarr, this.rvertexList[i].size(), 1);
        }
        this.weightmaximum = this.weightdarr.size();
    }

    void calcReducedWeightDistribution() {
        this.weightmaximum = -1;
        this.weightdarr = new IntArrayList();
        this.weightdarr.add(0);
        this.strengthlist = new IntArrayList[this.maximumVertices];
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            this.rvertexList[i] = new IntArrayList();
            this.strengthlist[i] = new IntArrayList();
            if (this.vertexList[i] == null) {
                this.addExtendIntArrayList(this.weightdarr, 0, 1);
                break;
            }
            int n = this.vertexList[i].size();
            int n2 = this.vertexList[i].get(0);
            int n3 = 1;
            for (int j = 1; j < n; ++j) {
                int n4 = this.vertexList[i].get(j);
                if (n2 == n4) {
                    ++n3;
                    continue;
                }
                this.strengthlist[i].add(n3);
                this.rvertexList[i].add(n2);
                this.addExtendIntArrayList(this.weightdarr, n3, 1);
                n2 = n4;
                n3 = 1;
            }
            this.strengthlist[i].add(n3);
            this.rvertexList[i].add(n2);
            this.addExtendIntArrayList(this.weightdarr, n3, 1);
            this.addExtendIntArrayList(this.rddarr, this.rvertexList[i].size(), 1);
        }
        this.weightmaximum = this.weightdarr.size();
    }

    public void calcStrength() {
        if (!this.vertexlabels) {
            System.err.println("!!! WARNING calcStrength() requires vertex labels to be on");
            return;
        }
        if (!this.weightedEdges) {
            for (int i = 0; i < this.TotalNumberVertices; ++i) {
                this.vertexLabelList[i].setStrength(this.getVertexDegree(i));
            }
            this.TotalWeight = this.TotalNumberStubs;
            return;
        }
        if (this.vertexEdgeListOn) {
            this.TotalWeight = 0.0;
            double d = -1.0;
            for (int i = 0; i < this.TotalNumberVertices; ++i) {
                d = this.getVertexOutStrength(i);
                this.vertexLabelList[i].setStrength(d);
                this.TotalWeight += d;
            }
            return;
        }
        this.calcStrengthDirectly();
    }

    public void calcStrengthDirectly() {
        int n;
        if (!this.vertexlabels) {
            System.out.println("!!! WARNING calcStrengthDirectly() requires vertex labels to be on");
            return;
        }
        if (!this.weightedEdges) {
            for (int i = 0; i < this.TotalNumberVertices; ++i) {
                this.vertexLabelList[i].setStrength(this.getVertexDegree(i));
            }
            this.TotalWeight = this.TotalNumberStubs;
            return;
        }
        for (n = 0; n < this.TotalNumberVertices; ++n) {
            this.vertexLabelList[n].setStrength(0.0);
        }
        n = -1;
        int n2 = -1;
        double d = -1.0;
        this.TotalWeight = 0.0;
        for (int i = 0; i < this.TotalNumberStubs; ++i) {
            d = this.edgeValuetList[i].weight;
            this.TotalWeight += d;
            n = this.stubSourceList[i++];
            this.vertexLabelList[n].addStrength(d);
            if (this.isDirected() || n == (n2 = this.stubSourceList[i])) continue;
            this.vertexLabelList[n2].addStrength(d);
        }
    }

    public void calcTotalWeight() {
        if (this.isWeighted()) {
            this.TotalWeight = 0.0;
            double d = -1.0;
            int n = -1;
            int n2 = -1;
            for (int i = 0; i < this.TotalNumberStubs; ++i) {
                n = this.stubSourceList[i];
                d = this.edgeValuetList[i++].weight;
                this.TotalWeight += d;
                if (this.isDirected() || n == (n2 = this.stubSourceList[i])) continue;
                this.TotalWeight += d;
            }
        } else {
            this.TotalWeight = this.TotalNumberStubs / 2;
        }
    }

    public int calcTrianglesTotal() {
        int n = 0;
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            n += this.calcTriangles(i);
        }
        this.TotalNumberTriangles = n / 3;
        return this.TotalNumberTriangles;
    }

    public int calcTrianglesSquaresTotal() {
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[]{0, 0};
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            nArray = this.calcTrianglesSquares(i);
            n2 += nArray[0];
            n += nArray[1];
        }
        this.TotalNumberTriangles = n2 / 3;
        this.TotalNumberSquares = n / 4;
        return this.TotalNumberTriangles;
    }

    public int getNumberTriangles() {
        if (this.TotalNumberTriangles < 0) {
            return this.calcTrianglesTotal();
        }
        return this.TotalNumberTriangles;
    }

    public int getNumberSquares() {
        if (this.TotalNumberSquares < 0) {
            return this.calcTrianglesSquaresTotal();
        }
        return this.TotalNumberSquares;
    }

    public double getCCGlobal() {
        if (this.ccGlobal < 0.0) {
            return this.calcCCGlobal();
        }
        return this.ccGlobal;
    }

    public double calcCCGlobal() {
        try {
            int n = this.getNumberTriangles() / this.TotalNumberVertices;
            this.ccGlobal = (double)(6 * n) / (this.getDegreeSecondMoment() - this.getDegreeFirstMoment());
        }
        catch (RuntimeException runtimeException) {
            this.ccGlobal = Double.NaN;
        }
        return this.ccGlobal;
    }

    public void calcRanking() {
        if (this.averageWalkLength < 0.0) {
            this.averageWalkLength = this.diameter;
        }
        if (this.averageWalkLength < 2.0) {
            this.averageWalkLength = 2.0;
        }
        if (this.rankingProbabilityLengthScale < 0.0) {
            this.rankingProbabilityLengthScale = this.distanceaverage;
        }
        if (this.rankingProbabilityLengthScale < 2.0) {
            this.rankingProbabilityLengthScale = 2.0;
        }
        int n = this.TotalNumberStubs * 100;
        int n2 = -1;
        if (this.infoLevel > -2) {
            System.out.println("randomrandomWalk.randomWalkMode, averageWalkLength, rankingProbabilityLengthScale, totalNumberaverageWalkLength, startVertex = \t " + this.randomWalkMode + SEP + this.averageWalkLength + SEP + this.rankingProbabilityLengthScale + SEP + n + SEP + n2);
        }
        this.DoRandomWalk(n, n2);
        this.calcMaximumVertexLabel();
    }

    void addExtendIntArrayList(IntArrayList intArrayList, int n, int n2) {
        int n3 = intArrayList.size();
        if (n == 0 && n3 == 0) {
            intArrayList.add(n2);
            return;
        }
        for (int i = n3; i <= n; ++i) {
            intArrayList.add(0);
        }
        intArrayList.set(n, intArrayList.get(n) + n2);
    }

    public boolean isWeighted() {
        return this.weightedEdges;
    }

    public boolean isEdgeLabelled() {
        return this.labelledEdges;
    }

    public boolean isMultiEdge() {
        return this.multiEdge;
    }

    public boolean isSelfLooped() {
        return this.selfLoops;
    }

    public boolean isDirected() {
        return this.directedGraph;
    }

    public boolean isVertexEdgeListOn() {
        return this.vertexEdgeListOn;
    }

    public boolean isVertexLabelled() {
        return this.vertexlabels;
    }

    public boolean hasVertexPositions() {
        if (!this.vertexlabels) {
            return false;
        }
        if (this.vertexLabelList == null) {
            return false;
        }
        return this.vertexLabelList[0].hasPosition();
    }

    public boolean hasVertexNames() {
        if (!this.vertexlabels) {
            return false;
        }
        if (this.vertexLabelList == null) {
            return false;
        }
        return this.vertexLabelList[0].hasName();
    }

    public boolean isBipartite() {
        return this.bipartiteGraph;
    }

    public boolean checkSelfLoops() {
        for (int i = 0; i < this.TotalNumberStubs; ++i) {
            if (!this.isStubSelfLoop(i)) continue;
            return true;
        }
        return false;
    }

    public boolean checkNegativeWeights() {
        if (!this.weightedEdges) {
            return false;
        }
        for (int i = 0; i < this.TotalNumberStubs; ++i) {
            if (!(this.getEdgeWeight(i) < 0.0)) continue;
            return true;
        }
        return false;
    }

    public boolean checkMultiEdges() {
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            if (this.getFirstEdgeLocal(i, i) < 0) continue;
            return true;
        }
        return false;
    }

    public boolean isType1(int n) {
        return this.bipartiteGraph && n < this.numberVertexType1;
    }

    public boolean isType2(int n) {
        return this.bipartiteGraph && n >= this.numberVertexType1;
    }

    public boolean isInfoLeveLGreaterThan(int n) {
        return this.infoLevel > n;
    }

    public void setWeightedEdges(boolean bl) {
        this.weightedEdges = bl;
    }

    public void setLabelledEdges(boolean bl) {
        this.labelledEdges = bl;
    }

    public void setMultiEdge(boolean bl) {
        this.multiEdge = bl;
    }

    public void setSelfLoops(boolean bl) {
        this.selfLoops = bl;
    }

    public void setDirectedGraph(boolean bl) {
        this.directedGraph = bl;
    }

    public void setVertexEdgeList(boolean bl) {
        this.vertexEdgeListOn = bl;
    }

    public void setVertexlabels(boolean bl) {
        this.vertexlabels = bl;
    }

    public void setGraphProperties(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.directedGraph = bl;
        this.vertexlabels = bl2;
        this.weightedEdges = bl3;
        this.vertexEdgeListOn = bl4;
    }

    public void setBipartite(int n, int n2) {
        this.numberVertexType1 = n;
        this.numberVertexType2 = n2;
    }

    public void setBipartite(int n, int n2, String string, String string2) {
        this.numberVertexType1 = n;
        this.numberVertexType2 = n2;
        this.setBipartiteVertexNames(string, string2);
        this.bipartiteGraph = true;
    }

    public void setBipartiteVertexNames(String string, String string2) {
        this.nameVertexType1 = string;
        this.nameVertexType2 = string2;
    }

    public void setNameRoot(String string) {
        this.inputName.setNameRoot(string);
        this.outputName.setNameRoot(string);
    }

    public void addToNameRoot(String string) {
        this.inputName.setNameRoot(this.inputName.getNameRoot() + string);
        this.outputName.setNameRoot(this.outputName.getNameRoot() + string);
    }

    public int getNumberVertices() {
        return this.TotalNumberVertices;
    }

    public int getNumberVerticesType1() {
        return this.numberVertexType1;
    }

    public int getNumberVerticesType2() {
        return this.numberVertexType2;
    }

    public String getNameVerticesType1() {
        return this.nameVertexType1;
    }

    public String getNameVerticesType2() {
        return this.nameVertexType2;
    }

    public int getNumberStubs() {
        return this.TotalNumberStubs;
    }

    public int getNumberEdges() {
        return this.TotalNumberStubs >> 1;
    }

    public double getTotalWeight() {
        if (this.TotalWeight == -3.57986421E8) {
            this.calcTotalWeight();
        }
        return this.TotalWeight;
    }

    public int getNumberDistinctEdges() {
        return this.directedGraph ? this.TotalNumberStubs : this.TotalNumberStubs / 2;
    }

    public int getInformationLevel() {
        return this.infoLevel;
    }

    public void setInformationLevel(int n) {
        this.infoLevel = n;
    }

    public int getRandomEdge() {
        return this.Rnd.nextInt(this.TotalNumberStubs);
    }

    public int getFirstEdgeGlobal(int n, int n2) {
        int n3;
        for (n3 = 0; n3 < this.vertexList[n].size() && this.vertexList[n].getQuick(n3) != n2; ++n3) {
        }
        if (n3 == this.vertexList[n].size()) {
            return -1;
        }
        return this.vertexEdgeList[n].get(n3);
    }

    public double getAdjacencyMatrixEntry(int n, int n2) {
        double d = 0.0;
        for (int i = 0; i < this.vertexList[n].size(); ++i) {
            if (this.vertexList[n].getQuick(i) != n2) continue;
            d += this.getEdgeWeight(this.vertexEdgeList[n].get(i));
        }
        return d;
    }

    public int getGlobalEdgeFromLocal(int n, int n2) {
        return this.vertexEdgeList[n].get(n2);
    }

    public int getFirstEdgeLocal(int n, int n2) {
        for (int i = 0; i < this.vertexList[n].size(); ++i) {
            if (this.vertexList[n].getQuick(i) != n2) continue;
            return i;
        }
        return -1;
    }

    public int getNextEdgeLocal(int n, int n2, int n3) {
        if (n < 0 || n >= this.vertexList[n2].size()) {
            return -2;
        }
        for (int i = n; i < this.vertexList[n2].size(); ++i) {
            if (this.vertexList[n2].getQuick(i) != n3) continue;
            return i;
        }
        return -1;
    }

    public int getEdge(int n, int n2) {
        return this.vertexEdgeList[n].getQuick(n2);
    }

    public int getInEdge(int n, int n2) {
        return this.vertexInEdgeList[n].getQuick(n2);
    }

    public String getEdgeLabelString(int n) {
        return Integer.toString(this.getEdgeLabel(n));
    }

    public int getEdgeLabel(int n) {
        if (!this.weightedEdges) {
            return n / 2;
        }
        int n2 = this.edgeValuetList[n].label;
        if (n2 == -98542182) {
            return n / 2;
        }
        return n2;
    }

    public int getEdgeLabelSimple(int n) {
        if (!this.weightedEdges) {
            return -98542182;
        }
        return this.edgeValuetList[n].label;
    }

    public int getEdgeLabelOrZero(int n, int n2) {
        if (!this.weightedEdges) {
            return n2;
        }
        int n3 = this.edgeValuetList[n].label;
        if (n3 == -98542182) {
            return n2;
        }
        return n3;
    }

    public int getRandomVertex() {
        return this.Rnd.nextInt(this.TotalNumberVertices);
    }

    public int getRandomNeighbour(int n) {
        int n2 = this.vertexList[n].size();
        if (n2 > 0) {
            return this.vertexList[n].get(this.Rnd.nextInt(this.vertexList[n].size()));
        }
        return -1;
    }

    public int getRandomVertexFromEdge() {
        return this.stubSourceList[this.Rnd.nextInt(this.TotalNumberStubs)];
    }

    public int getSourceRandomEdge() {
        int n = this.Rnd.nextInt(this.TotalNumberStubs);
        int n2 = n - n % 2;
        return this.stubSourceList[n2];
    }

    public int getTargetRandomEdge() {
        int n = this.Rnd.nextInt(this.TotalNumberStubs);
        int n2 = n - n % 2 + 1;
        return this.stubSourceList[n2];
    }

    public int getOtherStubFromEdge(int n) {
        return n ^ 1;
    }

    public int getStubType1(int n) {
        if (this.stubSourceList[n] < this.numberVertexType1) {
            return n;
        }
        int n2 = this.getOtherStubFromEdge(n);
        if (this.stubSourceList[n2] < this.numberVertexType1) {
            return n2;
        }
        System.err.println("Stub " + n + " has no type one vertices");
        return -135798642;
    }

    public int getStubType2(int n) {
        if (this.stubSourceList[n] >= this.numberVertexType1) {
            return n;
        }
        int n2 = this.getOtherStubFromEdge(n);
        if (this.stubSourceList[n2] >= this.numberVertexType1) {
            return n2;
        }
        System.err.println("Stub " + n + " has no type two vertices");
        return -135798642;
    }

    public int getVertexFromEdge(int n) {
        return this.stubSourceList[n];
    }

    public int getOtherVertexFromEdge(int n) {
        return this.stubSourceList[n ^ 1];
    }

    public int getSourceVertexFromEdge(int n) {
        int n2 = n >> 1 << 1;
        return this.stubSourceList[n2];
    }

    public int getTargetVertexFromEdge(int n) {
        int n2 = n | 1;
        return this.stubSourceList[n2];
    }

    public int getVertexFromName(String string) {
        int n;
        if (!this.vertexlabels) {
            throw new IllegalArgumentException("graph with labelled vertices needed to find named vertex.");
        }
        for (n = 0; n < this.getNumberVertices() && !this.getVertexName(n).equalsIgnoreCase(string); ++n) {
        }
        if (n == this.getNumberVertices()) {
            System.err.println("*** NOT FOUND VERTEX " + string);
        }
        return n;
    }

    public TreeMap<String, Integer> getVertexNameIndexMap() {
        if (!this.vertexlabels) {
            throw new IllegalArgumentException("graph with labelled vertices needed to find named vertex.");
        }
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        for (int i = 0; i < this.getNumberVertices(); ++i) {
            treeMap.put(this.getVertexName(i), i);
        }
        return treeMap;
    }

    public int getVertexDegree(int n) {
        if (this.vertexList[n] == null) {
            return 0;
        }
        return this.vertexList[n].size();
    }

    public String getVertexName(int n) {
        if (!this.vertexlabels) {
            return Integer.toString(n);
        }
        String string = this.vertexLabelList[n].getName();
        if (string.equals("")) {
            return Integer.toString(n);
        }
        return string;
    }

    public String[] getVertexNameArray() {
        String[] stringArray = new String[this.TotalNumberVertices];
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            stringArray[i] = this.getVertexName(i);
        }
        return stringArray;
    }

    public int getVertexNumber(int n, int n2) {
        if (!this.vertexlabels) {
            return n2;
        }
        VertexLabel vertexLabel = this.vertexLabelList[n];
        if (vertexLabel.hasNumber()) {
            return vertexLabel.getNumber();
        }
        return n2;
    }

    public Coordinate getVertexPosition(int n) {
        if (!this.vertexlabels) {
            return null;
        }
        VertexLabel vertexLabel = this.vertexLabelList[n];
        if (vertexLabel.hasPosition()) {
            return vertexLabel.getPosition();
        }
        return null;
    }

    public VertexLabel getVertexLabel(int n) {
        if (this.vertexlabels) {
            return this.vertexLabelList[n];
        }
        return null;
    }

    public int getVertexOutDegree(int n) {
        if (this.vertexList[n] == null) {
            return 0;
        }
        return this.vertexList[n].size();
    }

    public int getVertexInDegree(int n) {
        if (this.vertexSourceList[n] == null) {
            return 0;
        }
        return this.vertexSourceList[n].size();
    }

    public double getVertexOutStrength(int n) {
        if (!this.weightedEdges) {
            return this.getVertexOutDegree(n);
        }
        int n2 = -1;
        double d = 0.0;
        for (int i = 0; i < this.vertexEdgeList[n].size(); ++i) {
            n2 = this.vertexEdgeList[n].get(i);
            d += this.edgeValuetList[n2].weight;
        }
        return d;
    }

    public double getVertexSelfLoopStrength(int n) {
        if (!this.weightedEdges) {
            return this.getVertexOutDegree(n);
        }
        int n2 = -1;
        double d = 0.0;
        for (int i = 0; i < this.vertexEdgeList[n].size(); ++i) {
            n2 = this.vertexEdgeList[n].get(i);
            if (!this.isStubSelfLoop(n2)) continue;
            d += this.weightedEdges ? this.edgeValuetList[n2].weight : 1.0;
        }
        return d;
    }

    public boolean isStubSelfLoop(int n) {
        return this.stubSourceList[n] == this.stubSourceList[n ^ 1];
    }

    public double getVertexInStrength(int n) {
        if (!this.directedGraph) {
            return this.getVertexOutStrength(n);
        }
        if (!this.weightedEdges) {
            return this.getVertexInDegree(n);
        }
        int n2 = -1;
        double d = 0.0;
        for (int i = 0; i < this.vertexInEdgeList[n].size(); ++i) {
            n2 = this.vertexInEdgeList[n].get(i);
        }
        return d += this.edgeValuetList[n2].weight;
    }

    public int[] getStubSourceList() {
        return this.stubSourceList;
    }

    public double getEdgeWeightQuick(int n) {
        return this.edgeValuetList[n].weight;
    }

    public double getEdgeWeight(int n) {
        return this.weightedEdges ? this.edgeValuetList[n].weight : 1.0;
    }

    public double getEdgeWeightSlow(int n) {
        if (n < 0 || n >= this.TotalNumberStubs) {
            return -3.57986421E8;
        }
        return this.weightedEdges ? this.edgeValuetList[n].weight : 1.0;
    }

    public EdgeValue getEdgeWeightAll(int n) {
        return this.edgeValuetList[n];
    }

    public int getNeighbour(int n, int n2) {
        if (n2 < this.vertexList[n].size() && n2 >= 0) {
            return this.vertexList[n].get(n2);
        }
        return -1;
    }

    public int getNeighbourQuick(int n, int n2) {
        return this.vertexList[n].get(n2);
    }

    public int getInitialVertices() {
        return this.initialVertices;
    }

    public void setInitialVertices(int n) {
        this.initialVertices = n;
    }

    public int getMaximumStubs() {
        return this.maximumStubs;
    }

    public void setMaximumStubs(int n) {
        this.maximumStubs = n;
    }

    public int getMaximumVertices() {
        return this.maximumVertices;
    }

    public void setMaximumVertices(int n) {
        this.maximumVertices = n;
    }

    public void setNumberEvents(int n) {
        this.numevents = n;
    }

    public void setVertexNumber(int n, int n2) {
        if (this.vertexLabelList[n] == null) {
            this.vertexLabelList[n] = new VertexLabel(n2);
        } else {
            this.vertexLabelList[n].setNumber(n2);
        }
    }

    public void setVertexNumbers(int n) {
        if (!this.vertexlabels) {
            this.vertexlabels = true;
            this.vertexLabelList = new VertexLabel[this.TotalNumberVertices];
        }
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            this.setVertexNumber(i, n);
        }
    }

    public void setVertexNumberQuick(int n, int n2) {
        this.vertexLabelList[n].setNumber(n2);
    }

    public void setVertexPositionQuick(int n, Coordinate coordinate) {
        this.vertexLabelList[n].setPosition(coordinate);
    }

    public void setVertexLabelQuick(int n, VertexLabel vertexLabel) {
        this.vertexLabelList[n] = vertexLabel;
    }

    public void setEdgeLabelQuick(int n, int n2) {
        this.edgeValuetList[n].label = n2;
    }

    public void setEdgeLabels(Partition partition) {
        if (partition.getNumberElements() != this.getNumberEdges()) {
            throw new RuntimeException("partition has " + partition.getNumberElements() + " elements which is not equal to number of edges " + this.getNumberEdges());
        }
        if (!this.weightedEdges) {
            this.weightedEdges = true;
            this.edgeValuetList = new EdgeValue[this.maximumStubs];
            for (int i = 0; i < this.TotalNumberStubs; ++i) {
                EdgeValue edgeValue = new EdgeValue();
                this.edgeValuetList[i++] = edgeValue;
                this.edgeValuetList[i] = edgeValue;
            }
        }
        int[] nArray = partition.getCommunity();
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            this.edgeValuetList[n++].setLabel(nArray[i]);
            this.edgeValuetList[n++].setLabel(nArray[i]);
        }
    }

    public void setEdgeLabels(int n) {
        if (!this.weightedEdges) {
            this.weightedEdges = true;
            this.labelledEdges = true;
            this.edgeValuetList = new EdgeValue[this.maximumStubs];
            for (int i = 0; i < this.TotalNumberStubs; ++i) {
                EdgeValue edgeValue = new EdgeValue(n);
                this.edgeValuetList[i++] = edgeValue;
                this.edgeValuetList[i] = edgeValue;
            }
            return;
        }
        this.labelledEdges = true;
        for (int i = 0; i < this.TotalNumberStubs; ++i) {
            EdgeValue edgeValue = this.edgeValuetList[i++];
            edgeValue.setLabel(n);
        }
    }

    public void setEdgeWeights(int n) {
        if (!this.weightedEdges) {
            this.weightedEdges = true;
            this.labelledEdges = false;
            this.edgeValuetList = new EdgeValue[this.maximumStubs];
        }
        for (int i = 0; i < this.TotalNumberStubs; ++i) {
            EdgeValue edgeValue = this.edgeValuetList[i];
            if (edgeValue == null) {
                edgeValue = new EdgeValue(n);
            } else {
                edgeValue.weight = n;
            }
            this.edgeValuetList[i++] = edgeValue;
            this.edgeValuetList[i] = edgeValue;
        }
    }

    public void setVertexNumbers(VertexPartition vertexPartition) {
        if (vertexPartition.getNumberElements() != this.TotalNumberVertices) {
            throw new RuntimeException("Wrong number of elements in vertex partition " + vertexPartition.getName() + ", " + vertexPartition.getNumberElements());
        }
        if (!this.vertexlabels) {
            this.initialiseVertexLabels();
        }
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            this.vertexLabelList[i].setNumber(vertexPartition.getCommunity(i));
        }
    }

    public void initialiseVertexLabels() {
        this.vertexlabels = true;
        this.vertexLabelList = new VertexLabel[this.maximumVertices];
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            this.vertexLabelList[i] = new VertexLabel();
        }
    }

    public void setVertexPositionsFromPartition(VertexPartition vertexPartition, double d, double d2) {
        if (vertexPartition.getNumberElements() != this.TotalNumberVertices) {
            throw new RuntimeException("Wrong number of elements in vertex partition " + vertexPartition.getName() + ", " + vertexPartition.getNumberElements());
        }
        if (!this.vertexlabels) {
            this.initialiseVertexLabels();
        }
        vertexPartition.setCommunityLocalLabel();
        vertexPartition.analyse();
        double d3 = vertexPartition.getNumberCommunities();
        double d4 = -3.57986421E8;
        int n = -135798642;
        double d5 = -3.57986421E8;
        double d6 = -3.57986421E8;
        double d7 = -3.57986421E8;
        double d8 = -3.57986421E8;
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            n = vertexPartition.getCommunity(i);
            d4 = vertexPartition.getNumberElementsInCommunity(n);
            d5 = (double)vertexPartition.getCommunityLocalLabel(i) / d4;
            d6 = (double)n / d3;
            d7 = Math.cos(d5 * 2.0 * Math.PI) * d + Math.cos(d6 * 2.0 * Math.PI) * d2;
            d8 = Math.sin(d5 * 2.0 * Math.PI) * d + Math.sin(d6 * 2.0 * Math.PI) * d2;
            this.setVertexPositionQuick(i, new Coordinate(d7, d8));
        }
    }

    public void setVertexPositions(ArrayList<Double> arrayList, ArrayList<Double> arrayList2) {
        if (arrayList.size() != this.TotalNumberVertices || arrayList2.size() != this.TotalNumberVertices) {
            throw new RuntimeException("Wrong number of x or y coordinates, found " + arrayList.size() + ", " + arrayList2.size());
        }
        if (!this.vertexlabels) {
            this.initialiseVertexLabels();
        }
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            this.vertexLabelList[i].setPosition(arrayList.get(i), arrayList2.get(i));
        }
    }

    public void setVertexPositions(ArrayList<String> arrayList) {
        if (arrayList.size() != 2 * this.TotalNumberVertices) {
            throw new RuntimeException("Wrong number of x and  y coordinates, found " + arrayList.size());
        }
        if (!this.vertexlabels) {
            this.initialiseVertexLabels();
        }
        int n = 0;
        double d = -3.57986421E8;
        double d2 = -3.57986421E8;
        String string = SUNSET;
        String string2 = SUNSET;
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            string = arrayList.get(n++);
            string2 = arrayList.get(n++);
            try {
                d = Double.parseDouble(string);
                d2 = Double.parseDouble(string2);
            }
            catch (Exception exception) {
                System.err.println("!!! WARNING setVertexPositions found vertex " + i + " coordinates " + string + ", " + string2);
                d = -3.57986421E8;
                d2 = -3.57986421E8;
            }
            this.vertexLabelList[i].setPosition(d, d2);
        }
    }

    public void setVertexPositionsFromFile(String string, String string2, int n, int n2, boolean bl, boolean bl2) {
        int[] nArray = new int[]{n, n2};
        boolean bl3 = false;
        ArrayList<String> arrayList = FileInput.readStringColumnsFromFile(string, string2, nArray, bl3, bl, bl2);
        this.setVertexPositions(arrayList);
    }

    public void setVertexNames(ArrayList<String> arrayList) {
        if (arrayList.size() != this.TotalNumberVertices) {
            throw new RuntimeException("Wrong number of names, found " + arrayList.size());
        }
        if (!this.vertexlabels) {
            this.initialiseVertexLabels();
        }
        int n = 0;
        String string = SUNSET;
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            try {
                string = arrayList.get(n++);
            }
            catch (Exception exception) {
                System.err.println("!!! WARNING setVertexNamess found vertex " + i + " name " + string);
                string = SUNSET;
            }
            this.vertexLabelList[i].setName(string);
        }
    }

    public void setVertexNamesFromFile(String string, String string2, int n, boolean bl, boolean bl2) {
        String string3 = this.inputName.getNameRootFullPath() + string;
        int[] nArray = new int[]{n};
        boolean bl3 = false;
        ArrayList<String> arrayList = FileInput.readStringColumnsFromFile(string3, string2, nArray, bl3, bl, bl2);
        this.setVertexNames(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int inputSimpleNetwork(String string, Character c, int n, int n2, int n3) {
        TextReader textReader;
        this.message.println(0, "Starting to search for range of vertex numbers in " + string);
        String string2 = "";
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        String string3 = "";
        int n7 = -2;
        int n8 = -2;
        double d = -2.0;
        int n9 = Integer.MIN_VALUE;
        int n10 = -2147483647;
        int n11 = Integer.MIN_VALUE;
        int n12 = Integer.MAX_VALUE;
        try {
            textReader = new TextReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.message.printWarning(-1, "Can't find file " + string);
            return 1;
        }
        try {
            while (!textReader.eof()) {
                ++n6;
                n4 = 0;
                Character c2 = Character.valueOf(textReader.peek());
                if (c2 == c) {
                    string2 = textReader.getln();
                    this.message.println(2, n6 + ": Comment: " + string2);
                    continue;
                }
                n7 = -1;
                n8 = -1;
                while (!textReader.eoln()) {
                    if (n4 == n) {
                        n7 = textReader.getInt();
                        continue;
                    }
                    if (n4 == n2) {
                        n8 = textReader.getInt();
                        continue;
                    }
                    if (n4 == n3) {
                        d = textReader.getDouble();
                        continue;
                    }
                    string3 = textReader.getWord();
                }
                ++n5;
                n9 = Math.min(n9, n7);
                n10 = Math.max(n10, n7);
                n11 = Math.min(n11, n7);
                n12 = Math.max(n12, n7);
            }
            this.message.println(0, "Finished reading from " + string);
        }
        catch (TextReader.Error error) {
            this.message.printERROR("Input Error: line " + n6 + ", " + error.getMessage());
            bl = true;
        }
        finally {
            textReader.close();
        }
        int n13 = Math.min(n9, n11);
        int n14 = Math.max(n10, n12);
        int n15 = n14 - n13 + 1;
        this.message.println(0, "Finished reading from " + string);
        this.message.println(0, "Found " + n15 + " vertices and " + n5 + " edges");
        this.inputSimpleNetwork(string, c, n, n2, n3, n13, n15);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int inputSimpleNetwork(String string, Character c, int n, int n2, int n3, int n4, int n5) {
        TextReader textReader;
        this.message.println(0, "Starting to read edges and weights from " + string);
        String string2 = "";
        int n6 = -1;
        int n7 = 0;
        int n8 = 0;
        String string3 = "";
        int n9 = -2;
        int n10 = -2;
        double d = -2.0;
        int n11 = Integer.MIN_VALUE;
        int n12 = -2147483647;
        int n13 = Integer.MIN_VALUE;
        int n14 = Integer.MAX_VALUE;
        try {
            textReader = new TextReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.message.printWarning(-1, "Can't find file " + string);
            return 1;
        }
        try {
            while (!textReader.eof()) {
                ++n7;
                Character c2 = Character.valueOf(textReader.peek());
                if (c2 == c) {
                    string2 = textReader.getln();
                    this.message.println(2, n7 + ": Comment: " + string2);
                    continue;
                }
                n6 = 0;
                n9 = -1;
                n10 = -1;
                while (!textReader.eoln()) {
                    if (n6 == n) {
                        n9 = textReader.getInt();
                        continue;
                    }
                    if (n6 == n2) {
                        n10 = textReader.getInt();
                        continue;
                    }
                    if (n6 == n3) {
                        d = textReader.getDouble();
                        continue;
                    }
                    string3 = textReader.getWord();
                }
                n11 = Math.min(n11, n9);
                n12 = Math.max(n12, n9);
                n13 = Math.min(n13, n9);
                n14 = Math.max(n14, n9);
                this.message.printERROR("Line " + n7 + " of unknowntype");
                n8 = -1;
            }
            this.message.println(0, "Finished reading from " + string);
        }
        catch (TextReader.Error error) {
            this.message.printERROR("Input Error: " + error.getMessage());
            n8 = 1;
        }
        finally {
            textReader.close();
        }
        return 0;
    }

    public void FileOutputDegreeDistribution(String string, boolean bl, boolean bl2) {
        String string2 = bl ? ".Jndd.dat" : ".Jdd.dat";
        this.outputName.setNameEnd(string2);
        this.DDtotal.FileOutputDegreeDistribution(this.outputName.getFullFileName(), string, SEP, bl, bl2);
        if (this.directedGraph) {
            this.outputName.setNameEnd("IN" + string2);
            this.DDin.FileOutputDegreeDistribution(this.outputName.getFullFileName(), string, SEP, bl, bl2);
            this.outputName.setNameEnd("OUT" + string2);
            this.DDout.FileOutputDegreeDistribution(this.outputName.getFullFileName(), string, SEP, bl, bl2);
        }
        if (this.bipartiteGraph) {
            this.outputName.setNameEnd(this.nameVertexType1 + string2);
            this.DD1total.FileOutputDegreeDistribution(this.outputName.getFullFileName(), string, SEP, bl, bl2);
            this.outputName.setNameEnd(this.nameVertexType2 + string2);
            this.DD2total.FileOutputDegreeDistribution(this.outputName.getFullFileName(), string, SEP, bl, bl2);
        }
    }

    public void FileOutputLogBinnedDegreeDistribution(String string, double d, boolean bl, boolean bl2) {
        String string2 = "lbdd.dat";
        this.outputName.setNameEnd(string2);
        this.DDtotal.FileOutputLogBinnedDegreeDistribution(this.outputName.getFullFileName(), string, SEP, d, bl, bl2);
        if (this.directedGraph) {
            this.outputName.setNameEnd("IN" + string2);
            this.DDin.FileOutputLogBinnedDegreeDistribution(this.outputName.getFullFileName(), string, SEP, d, bl, bl2);
            this.outputName.setNameEnd("OUT" + string2);
            this.DDout.FileOutputLogBinnedDegreeDistribution(this.outputName.getFullFileName(), string, SEP, d, bl, bl2);
        }
        if (this.bipartiteGraph) {
            this.outputName.setNameEnd(this.nameVertexType1 + string2);
            this.DD1total.FileOutputLogBinnedDegreeDistribution(this.outputName.getFullFileName(), string, SEP, d, bl, bl2);
            this.outputName.setNameEnd(this.nameVertexType2 + string2);
            this.DD2total.FileOutputLogBinnedDegreeDistribution(this.outputName.getFullFileName(), string, SEP, d, bl, bl2);
        }
    }

    void printDegreeDistribution(String string, boolean bl) {
        this.DDtotal.print(string, SEP, bl);
        if (this.directedGraph) {
            this.DDin.print(string, SEP, bl);
            this.DDout.print(string, SEP, bl);
        }
        if (this.bipartiteGraph) {
            this.DD1total.print(string, SEP, bl);
            this.DD2total.print(string, SEP, bl);
        }
    }

    void FileOutputReducedDegreeDistribution(String string, boolean bl) {
        String string2 = bl ? ".Jnrdd.dat" : ".Jrdd.dat";
        this.outputName.setNameEnd(string2);
        String string3 = this.outputName.getFullFileName();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.outputName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            int n = 0;
            double d = 0.0;
            printStream.println(string + " timgraph.java version " + SEP + VERSION + SEP + " produced on " + SEP + this.date);
            printStream.println(string + " No. vertices: " + SEP + this.TotalNumberVertices + " No. edges: " + SEP + this.TotalNumberStubs);
            if (this.TotalNumberVertices < 1) {
                return;
            }
            if (bl) {
                printStream.println(string + " k " + SEP + "rp(k)    Reduced Normalised Degree Distribution ");
            } else {
                printStream.println(string + " k " + SEP + "rn(k)     Reduced Unnormalised Degree Distribution ");
            }
            for (int i = 0; i < this.rddarr.size(); ++i) {
                if (bl) {
                    d = (double)this.rddarr.get(i) / (double)this.TotalNumberVertices;
                    if (!(d > 0.0)) continue;
                    printStream.println(i + SEP + d);
                    continue;
                }
                n = (int)((double)this.rddarr.get(i) + 0.5);
                if (n <= 0) continue;
                printStream.println(i + SEP + n);
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing reduced degree distribution to " + string3);
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error with " + string3);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string3);
            return;
        }
    }

    void FileOutputWeightDistribution(String string, boolean bl) {
        String string2 = bl ? ".Jnwd.dat" : ".Jwd.dat";
        this.outputName.setNameEnd(string2);
        String string3 = this.outputName.getFullFileName();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            PrintStream printStream = new PrintStream(fileOutputStream);
            int n = 0;
            printStream.println(string + " timgraph.java version " + SEP + VERSION + SEP + " produced on " + SEP + this.date);
            printStream.println(string + " No. vertices: " + SEP + this.TotalNumberVertices + " No. edges: " + SEP + this.TotalNumberStubs);
            printStream.println(string + SEP + this.weightmaximum + SEP + " = weightmaximum");
            if (bl) {
                printStream.println(string + " w " + SEP + "p(w)    Normalised Weight Distribution ");
            } else {
                printStream.println(string + " w " + SEP + "w(w)     Unnormalised Weight Distribution ");
            }
            for (int i = 0; i < this.weightdarr.size(); ++i) {
                if (bl) {
                    double d = (double)this.weightdarr.get(i) / (double)this.TotalNumberVertices;
                    if (!(d > 0.0)) continue;
                    printStream.println(i + SEP + d);
                    continue;
                }
                n = (int)((double)this.weightdarr.get(i) + 0.5);
                if (n <= 0) continue;
                printStream.println(i + SEP + n);
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing weight distribution to " + string3);
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error with " + string3);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string3);
            return;
        }
    }

    void FileOutputComponentDistributionOLD(String string) {
        this.outputName.setNameEnd(".Jcompdist.dat");
        String string2 = this.outputName.getFullFileName();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            boolean bl = false;
            printStream.println(string + " timgraph.java version " + SEP + VERSION + SEP + " produced on " + SEP + this.date);
            printStream.println(string + " No. vertices: " + SEP + this.TotalNumberVertices + " No. edges: " + SEP + this.TotalNumberStubs);
            printStream.println(string + " walk mode: " + SEP + this.randomWalk.randomWalkMode);
            printStream.println(string + "Number of Components " + SEP + this.componentSize.size());
            printStream.println(string + " c" + SEP + "n(c)" + SEP + "v in c" + SEP + "diam_min");
            for (int i = 0; i < this.componentSize.size(); ++i) {
                printStream.println(i + SEP + this.componentSize.get(i) + SEP + this.componentSource.get(i) + SEP + this.componentDist.get(i));
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing component distribution data to " + string2);
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string2);
            return;
        }
    }

    public void FileOutputComponentDistribution(String string) {
        this.outputName.setNameEnd(".Jcompdist.dat");
        String string2 = this.outputName.getFullFileName();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println(string + " timgraph.java version " + SEP + VERSION + SEP + " produced on " + SEP + this.date);
            this.printComponentDistribution(printStream);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing component information to " + string2);
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string2);
            return;
        }
    }

    public void FileOutputVertexToComponentList(String string) {
        this.outputName.setNameEnd(".Jv2comp.dat");
        String string2 = this.outputName.getFullFileName();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println(string + " timgraph.java version " + SEP + VERSION + SEP + " produced on " + SEP + this.date);
            this.printVertexToComponentList(printStream);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing component information to " + string2);
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string2);
            return;
        }
    }

    public void FileOutputComponentInfo(String string) {
        this.FileOutputComponentInfo(string, false, false);
    }

    public void FileOutputComponentInfo(String string, boolean bl, boolean bl2) {
        this.outputName.setNameEnd(".Jcompinfo.dat");
        String string2 = this.outputName.getFullFileName();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println(string + " timgraph.java version " + SEP + VERSION + SEP + " produced on " + SEP + this.date);
            this.printComponentInfo(printStream, bl, bl2);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing component information to " + string2);
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string2);
            return;
        }
    }

    void FileOutputRingInfo(String string, int n) {
        this.outputName.setNameEnd(".Jrinfo.dat");
        String string2 = this.outputName.getFullFileName();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println(string + " timgraph.java version " + SEP + VERSION + SEP + " produced on " + SEP + this.date);
            this.printRingInfo(printStream, n);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing ring information to " + string2);
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string2);
            return;
        }
    }

    public void FileOutputDistanceTotalDistribution(String string) {
        this.outputName.setNameEnd(".Jtotdistd.dat");
        String string2 = this.outputName.getFullFileName();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.printDistanceTotalDistribution(printStream, string);
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string2);
            return;
        }
        if (this.infoLevel > -2) {
            System.out.println("Finished writing total distance data to " + string2);
        }
    }

    public void printDistanceTotalDistribution(PrintStream printStream, String string) {
        printStream.println(string + " timgraph.java version " + SEP + VERSION + SEP + " produced on " + SEP + this.date);
        printStream.println(string + " No. vertices: " + SEP + this.TotalNumberVertices + " No. edges: " + SEP + this.TotalNumberStubs);
        printStream.println(string + " walk mode: " + SEP + (this.randomWalk == null ? " NOT DEFINED" : Integer.valueOf(this.randomWalk.randomWalkMode)));
        printStream.println(string + "diameter maximum, minimum, average " + SEP + this.diametermax + SEP + this.diametermin + SEP + this.diameteraverage + SEP + " +/- " + this.diametererror + SEP + ", sigma " + this.diametersigma);
        printStream.println(string + "average distance " + SEP + this.totdistanceaverage + SEP + " +/- " + SEP + this.totdistanceerror + ", sigma " + SEP + this.totdistancesigma);
        printStream.println(string + "Average distance from one vertex " + SEP + this.onesdistanceav + SEP + " +/- " + SEP + this.onesdistanceerror + SEP + ", sigma=" + SEP + this.onesdistancesigma);
        printStream.println(string + " d" + SEP + " n(d) " + SEP + " n2(d) " + SEP + "<n(d)>" + SEP + " +/- " + SEP + "[" + this.nsamples + " samples]");
        for (int i = 0; i < this.totdistancedist.size(); ++i) {
            double d = this.totdistancedist.get(i);
            double d2 = this.totdistance2dist.get(i);
            double d3 = d / (double)this.nsamples;
            double d4 = this.calcError(d, d2, (double)this.nsamples);
            printStream.println(i + SEP + d + SEP + d2 + SEP + d3 + SEP + d4);
        }
    }

    public void FileOutputCC(String string) {
        this.outputName.setNameEnd(".JCCd.dat");
        String string2 = this.outputName.getFullFileName();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            boolean bl = false;
            printStream.println(string + " timgraph.java version " + SEP + VERSION + SEP + " produced on " + SEP + this.date);
            printStream.println(string + " No. vertices: " + SEP + this.TotalNumberVertices + " No. edges: " + SEP + this.TotalNumberStubs);
            printStream.println(string + " walk mode: " + SEP + this.randomWalkMode);
            printStream.println(string + "Average CC " + SEP + this.CCaverage + SEP + " +/- " + SEP + this.CCerror + ", sigma " + SEP + this.CCsigma);
            printStream.println(string + "Average Edge CC " + SEP + this.CCEdgeaverage + SEP + " +/- " + SEP + this.CCEdgeerror + ", sigma " + SEP + this.CCEdgesigma);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing average CC info to " + string2);
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string2);
            return;
        }
    }

    public void FileOutputDistanceStatistics(String string) {
        this.outputName.setNameEnd(".Jdiststat.dat");
        String string2 = this.outputName.getFullFileName();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println(string + " timgraph.java version " + SEP + VERSION + SEP + " produced on " + SEP + this.date);
            printStream.println(this.diametermax + SEP + this.diametermin + SEP + this.diameteraverage + SEP + this.diametererror + SEP + this.diametersigma + SEP + string + "diameter maximum, minimum, average , error in av, sigma for average");
            printStream.println(this.totdistanceaverage + SEP + this.totdistanceerror + SEP + this.totdistancesigma + SEP + string + " average distance over all paths:  average, error, sigma");
            printStream.println(this.onesdistanceav + SEP + this.onesdistanceerror + SEP + this.onesdistancesigma + SEP + string + " average distance from one vertex: average, error, sigma");
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing distance statistics to " + string2);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string2);
            return;
        }
    }

    void FileOutputGraphInfo(String string, double d) {
        if (this.outputControl.getNumber() == 0) {
            return;
        }
        this.outputName.setNameEnd(".Jinfo.dat");
        String string2 = this.outputName.getFullFileName();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.OutputGraphInfo(printStream, string, d);
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing general graph info to " + string2);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string2);
            return;
        }
    }

    public void outputGraph(String string) {
        this.calcDegreeDistribution();
        this.printDegreeDistribution(string, false);
        this.FileOutputDegreeDistribution(string, false, true);
        if (this.TotalNumberVertices >= this.LogBinVerticesMinimum) {
            this.FileOutputLogBinnedDegreeDistribution(string, 1.1, true, true);
        }
        FileOutput fileOutput = new FileOutput(this);
        fileOutput.pajek();
        this.calcDistanceSample(0.01, 10, 100);
        this.FileOutputDistanceStatistics(string);
        this.FileOutputDistanceTotalDistribution(string);
        this.calcComponents();
        this.FileOutputComponentDistribution(string);
        this.calcRanking();
        boolean bl = true;
        if (this.TotalNumberStubs < 40) {
            this.FileOutputNetwork(true, true, true);
        } else {
            this.FileOutputVertices(false, false, false);
        }
        this.FileOutputPajekVertexData();
        this.calcCCEdgeSample(0.01, 100, 10000);
        this.FileOutputCC(string);
        this.FileOutputGraphInfo(string, 0.0);
    }

    public void OutputGraphInfo(PrintStream printStream, String string, double d) {
        this.printWalkGraphInfo(printStream, string, d);
    }

    public void printWalkGraphInfo(PrintStream printStream, String string, double d) {
        if (this.infoLevel < 0) {
            return;
        }
        printStream.println(string + " timgraph.java" + SEP + "version " + SEP + VERSION + SEP + " produced on " + SEP + this.date);
        printStream.println(string + "Graph type:" + SEP + this.graphType(SEP));
        this.printRandomWalkMode(printStream, string);
        if (d >= 0.0) {
            printStream.println(d + SEP + string + " Time taken sec. ");
        }
        printStream.println(this.numevents + SEP + string + " Number of events");
        printStream.println(this.probnewvertex + SEP + string + " input probability of new vertex ");
        printStream.println(this.TotalNumberVertices + SEP + string + " actual No. vertices");
        printStream.println(this.TotalNumberStubs + SEP + string + " actual No. edges");
        printStream.println(this.connectivity + SEP + string + " k: input average degree requested");
        printStream.println(this.averageWalkLength + SEP + string + " averageWalkLength: number of random walk averageWalkLength on average");
        printStream.println(this.binomialNumber + SEP + string + " no. of dice used in binomial random numbers generator");
        printStream.println(this.averagesteplength + SEP + string + " average no. averageWalkLength per walk");
        printStream.println(this.edgegenerator + SEP + string + "edge generator");
        printStream.println(this.randomWalkMode + SEP + string + "walk mode");
        if (this.vertexlabels && this.minimumVertexLabel.hasPosition()) {
            printStream.println(this.minimumVertexLabel.position.printString(SEP) + SEP + string + "minimum vertex coordinate");
        }
        if (this.vertexlabels && this.maximumVertexLabel.hasPosition()) {
            printStream.println(this.maximumVertexLabel.position.printString(SEP) + SEP + string + "maximum vertex coordinate");
        }
        printStream.println(this.initialgraph + SEP + string + " initial graph type " + this.initialGraphString(this.initialgraph));
        printStream.println(this.initialConnectivity + SEP + string + " initial graph Connectivity");
        printStream.println(this.initialVertices + SEP + string + " initial graph Vertices");
        printStream.println(this.initialXsize + SEP + string + " initial graph X size");
        printStream.println(this.initialYsize + SEP + string + " initial graph Y size");
        printStream.println(this.initialEdges + SEP + string + " initial graph Edges ");
    }

    public void printGeneralGraphInfo(PrintStream printStream, String string) {
        printStream.println(string + " timgraph.java" + SEP + "version " + SEP + VERSION + SEP + " produced on " + SEP + this.date);
        printStream.println(string + "Graph type:" + SEP + this.graphType(SEP));
        printStream.println(this.numevents + SEP + string + " Number of events");
        printStream.println(this.probnewvertex + SEP + string + " input probability of new vertex ");
        printStream.println(this.TotalNumberVertices + SEP + string + " actual No. vertices");
        if (this.bipartiteGraph) {
            printStream.println(this.numberVertexType1 + string + " No. " + this.nameVertexType1 + " (type 1) vertices");
        }
        if (this.bipartiteGraph) {
            printStream.println(this.numberVertexType2 + string + " No. " + this.nameVertexType2 + " (type 2) vertices");
        }
        printStream.println(this.TotalNumberStubs + SEP + string + " actual No. edges");
        printStream.println(this.connectivity + SEP + string + " k: input average degree requested");
        printStream.println(this.averageWalkLength + SEP + string + " averageWalkLength: number of random walk averageWalkLength on average");
        printStream.println(this.averagesteplength + SEP + string + " average no. averageWalkLength per walk");
        printStream.println(this.edgegenerator + SEP + string + "edge generator");
        if (this.vertexlabels) {
            printStream.println(this.minimumVertexLabel.position.printString(SEP) + SEP + string + "minimum vertex coordinate");
        }
        if (this.vertexlabels) {
            printStream.println(this.maximumVertexLabel.position.printString(SEP) + SEP + string + "maximum vertex coordinate");
        }
    }

    public String graphType(String string) {
        String string2 = "";
        string2 = this.directedGraph ? "directed" : "undirected";
        string2 = this.vertexlabels ? string2 + string + "vertex labels" : string2 + string + "no vertex labels";
        string2 = this.weightedEdges ? string2 + string + "edge weights" : string2 + string + "no edge weights";
        string2 = this.bipartiteGraph ? string2 + string + "bipartite" : string2 + string + "unipartite";
        return string2;
    }

    public void FileOutputGraphVizOld() {
        GraphViz graphViz = new GraphViz();
        this.outputName.setNameEnd(".gv");
        String string = this.outputName.getFullFileName();
        if (this.infoLevel > -2) {
            System.out.println("Writing GraphViz file to " + string);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            graphViz.output(printStream, this, true);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing GraphViz file to " + string);
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("*** File Error with " + string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string);
            return;
        }
    }

    void FileOutputPajekOLD() {
        this.outputName.setNameEnd(".net");
        String string = this.outputName.getFullFileName();
        try {
            int n;
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println("*Vertices " + this.TotalNumberVertices);
            for (n = 1; n <= this.TotalNumberVertices; ++n) {
                printStream.print(n);
                if (this.vertexlabels) {
                    printStream.print(" " + this.vertexLabelList[n - 1].pajekString(this.minimumVertexLabel.position, this.maximumVertexLabel.position));
                }
                printStream.println();
            }
            if (this.directedGraph) {
                printStream.println("*Arcs");
            } else {
                printStream.println("*Edges");
            }
            for (n = 0; n < this.TotalNumberStubs; n += 2) {
                printStream.print(this.stubSourceList[n] + 1 + "   " + (this.stubSourceList[n + 1] + 1));
                if (this.weightedEdges) {
                    printStream.println("  " + this.edgeValuetList[n].weight + "  c " + this.getPajekColour(this.edgeValuetList[n].label));
                    continue;
                }
                printStream.println();
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing Pajek file to " + string);
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string);
            return;
        }
    }

    public void FileOutputPajekVertexData() {
        for (int i = 0; i < 3; ++i) {
            this.FileOutputPajekVertexVector(i);
            this.FileOutputPajekVertexPartition(i, 10);
        }
    }

    void FileOutputPajekVertexVector(int n) {
        this.outputName.setNameEnd("ERROR");
        switch (n) {
            case 2: {
                this.outputName.setNameEnd("value2.vec");
                break;
            }
            case 1: {
                this.outputName.setNameEnd("value.vec");
                break;
            }
            case 0: {
                this.outputName.setNameEnd("visits.vec");
            }
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.outputName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println("*Vertices " + this.TotalNumberVertices);
            double d = this.maximumVertexLabel.getRank().visits;
            double d2 = this.maximumVertexLabel.getRank().value;
            double d3 = this.maximumVertexLabel.getRank().value2;
            block14: for (int i = 1; i <= this.TotalNumberVertices; ++i) {
                switch (n) {
                    case 0: {
                        printStream.println(" " + (double)this.vertexLabelList[i - 1].rank.visits / d);
                        continue block14;
                    }
                    case 1: {
                        printStream.println(" " + this.vertexLabelList[i - 1].rank.value / d2);
                        continue block14;
                    }
                    case 2: {
                        printStream.println(" " + this.vertexLabelList[i - 1].rank.value2 / d3);
                    }
                }
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing vertex info to Pajek style file " + this.outputName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + this.outputName.getFullFileName());
            return;
        }
    }

    void FileOutputPajekVertexPartition(int n, int n2) {
        this.outputName.setNameEnd("ERROR");
        switch (n) {
            case 2: {
                this.outputName.setNameEnd("value2.clu");
                break;
            }
            case 1: {
                this.outputName.setNameEnd("value.clu");
                break;
            }
            case 0: {
                this.outputName.setNameEnd("visits.clu");
            }
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.outputName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println("*Vertices " + this.TotalNumberVertices);
            double d = this.maximumVertexLabel.getRank().visits;
            double d2 = this.maximumVertexLabel.getRank().value;
            double d3 = this.maximumVertexLabel.getRank().value2;
            block14: for (int i = 1; i <= this.TotalNumberVertices; ++i) {
                switch (n) {
                    case 0: {
                        printStream.println(" " + (int)(0.5 + (double)(n2 * this.vertexLabelList[i - 1].rank.visits) / d));
                        continue block14;
                    }
                    case 1: {
                        printStream.println(" " + (int)(0.5 + (double)n2 * this.vertexLabelList[i - 1].rank.value / d2));
                        continue block14;
                    }
                    case 2: {
                        printStream.println(" " + (int)(0.5 + (double)n2 * this.vertexLabelList[i - 1].rank.value2 / d3));
                    }
                }
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing vertex info to Pajek style file " + this.outputName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + this.outputName.getFullFileName());
            return;
        }
    }

    void FileOutputPajekUnweighted() {
        this.outputName.setNameEnd("w.net");
        String string = this.outputName.getFullFileName();
        int n = pajekColour.length + 1;
        try {
            int n2;
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println("*Vertices " + this.TotalNumberVertices);
            for (n2 = 1; n2 <= this.TotalNumberVertices; ++n2) {
                printStream.println(n2);
            }
            printStream.println("*Arcs");
            for (n2 = 0; n2 < this.TotalNumberVertices; ++n2) {
                for (int i = 0; i < this.rvertexList[n2].size(); ++i) {
                    int n3 = this.strengthlist[n2].get(i);
                    int n4 = n3 % (n + 1);
                    printStream.println(n2 + 1 + "   " + (this.rvertexList[n2].get(i) + 1) + "   " + n3 + "  c " + this.getPajekColour(n3));
                }
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing weighted Pajek file to " + string);
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string);
            return;
        }
    }

    public String getPajekColour(int n) {
        if (n <= 0) {
            return pajekColour[0];
        }
        return pajekColour[1 + (n - 1) % (pajekColour.length - 1)];
    }

    public static boolean isTIMGRAPH_ARGUMENT(String string) {
        return string.charAt(0) == '-';
    }

    public static boolean isOtherArgument(String string) {
        for (int i = 0; i < NOT_TIMGRAPH_ARGUMENT.length; ++i) {
            if (string.charAt(0) != NOT_TIMGRAPH_ARGUMENT[i]) continue;
            return true;
        }
        return false;
    }

    public static String otherArguments(String string) {
        String string2 = "" + NOT_TIMGRAPH_ARGUMENT[0];
        for (int i = 1; i < NOT_TIMGRAPH_ARGUMENT.length; ++i) {
            string2 = string2 + string + NOT_TIMGRAPH_ARGUMENT[i];
        }
        return string2;
    }

    public int parseParam(String[] stringArray) {
        int n;
        if (this.infoLevel > -1) {
            for (n = 0; n < stringArray.length; ++n) {
                System.out.println("Argument " + n + " = " + stringArray[n]);
            }
        }
        n = -1;
        try {
            for (n = 0; n < stringArray.length; ++n) {
                this.parseParam(stringArray[n]);
            }
        }
        catch (RuntimeException runtimeException) {
            System.err.println(" parseParameter problem at argument " + n + ": " + runtimeException.getMessage());
            this.printUsage();
            throw new RuntimeException("parseParameter problem: " + runtimeException.getMessage());
        }
        if (!this.inputName.testDirectoryRoot()) {
            throw new IllegalArgumentException("*** Error input directory root " + this.inputName.getDirectoryRoot() + " is not a directory");
        }
        if (!this.inputName.testDirectoryFull()) {
            throw new IllegalArgumentException("*** Error full input directory " + this.inputName.getDirectoryFull() + " is not a directory");
        }
        if (!this.outputName.testDirectoryRoot()) {
            throw new IllegalArgumentException("*** Error output directory root " + this.outputName.getDirectoryRoot() + " is not a directory");
        }
        if (!this.outputName.testDirectoryFull()) {
            throw new IllegalArgumentException("*** Error full output directory " + this.outputName.getDirectoryFull() + " is not a directory");
        }
        this.parseParameterFile();
        return 0;
    }

    public void parseParameterFile() {
        FileNameSequence fileNameSequence = new FileNameSequence(this.inputName);
        fileNameSequence.setNameEnd("param.dat");
        if (fileNameSequence.testFullFileName()) {
            ArrayList<String> arrayList = FileInput.readStringList(fileNameSequence.getFullFileName());
            if (this.infoLevel > -1) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    System.out.println("File Argument " + i + " = " + arrayList.get(i));
                }
            }
            for (String string : arrayList) {
                this.parseParam(string);
            }
        } else if (this.infoLevel > -1) {
            System.out.println(" Parameter file " + fileNameSequence.getFullFileName() + " not found");
        }
    }

    private void parseParam(String string) {
        if (timgraph.isOtherArgument(string)) {
            System.out.println("!!! Ignoring argument \"" + string + "\" as it starts with character indicating a different class argument " + string);
            return;
        }
        if (!timgraph.isTIMGRAPH_ARGUMENT(string)) {
            throw new IllegalArgumentException("*** Argument \"" + string + "\" does not start with " + timgraph.otherArguments(", ") + " or " + '-');
        }
        switch (string.charAt(1)) {
            case 'e': {
                this.numevents = Integer.parseInt(string.substring(2));
                break;
            }
            case 'f': {
                if (string.charAt(2) == 'i') {
                    if (string.charAt(3) == 'n' && !this.inputName.setFullFileName(string.substring(4), InputFileType.extensionList)) {
                        throw new IllegalArgumentException("*** Full file name \"" + string.substring(4) + "\" does not have recognised ending\n" + InputFileType.listAllExtensions(" - ", "\n"));
                    }
                    if (string.charAt(3) == 'r') {
                        this.inputName.setNameRoot(string.substring(4));
                    }
                    if (string.charAt(3) == 'd') {
                        this.inputName.setDirectoryRoot(string.substring(4));
                    }
                    if (string.charAt(3) == 's') {
                        this.inputName.setDirectoryEnd(string.substring(4));
                    }
                    if (string.charAt(3) == 'e') {
                        this.inputName.setNameEnd(string.substring(4));
                    }
                }
                if (string.charAt(2) != 'o') break;
                if (string.charAt(3) == 'n') {
                    this.outputName.setFullFileNameNoEnding(string.substring(4));
                }
                if (string.charAt(3) == 'r') {
                    this.outputName.setNameRoot(string.substring(4));
                }
                if (string.charAt(3) == 'd') {
                    this.outputName.setDirectoryRoot(string.substring(4));
                }
                if (string.charAt(3) == 's') {
                    this.outputName.setDirectoryEnd(string.substring(4));
                }
                if (string.charAt(3) != 'e') break;
                this.outputName.setNameEnd(string.substring(4));
                break;
            }
            case 'g': {
                if (string.charAt(2) == 'v') {
                    if (string.charAt(3) == 'e') {
                        boolean bl = this.vertexEdgeListOn = string.charAt(4) == 't';
                    }
                    if (string.charAt(3) == 'l') {
                        boolean bl = this.vertexlabels = string.charAt(4) == 't';
                    }
                    if (string.charAt(3) == 'v') {
                        this.initialVertices = Integer.parseInt(string.substring(4));
                    }
                }
                if (string.charAt(2) == 'e') {
                    if (string.charAt(3) == 'l') {
                        boolean bl = this.labelledEdges = string.charAt(4) == 't';
                    }
                    if (string.charAt(3) == 'm') {
                        boolean bl = this.multiEdge = string.charAt(4) == 't';
                    }
                    if (string.charAt(3) == 's') {
                        boolean bl = this.selfLoops = string.charAt(4) == 't';
                    }
                    if (string.charAt(3) == 'w') {
                        boolean bl = this.weightedEdges = string.charAt(4) == 't';
                    }
                }
                if (string.charAt(2) == 'b') {
                    boolean bl = this.bipartiteGraph = string.charAt(3) == 't';
                }
                if (string.charAt(2) == '1') {
                    this.nameVertexType1 = string.substring(3);
                }
                if (string.charAt(2) == '2') {
                    this.nameVertexType2 = string.substring(3);
                }
                if (string.charAt(2) == 'd') {
                    boolean bl = this.directedGraph = string.charAt(3) == 't';
                }
                if (string.charAt(2) == 'n') {
                    this.initialgraph = Integer.parseInt(string.substring(3));
                }
                if (string.charAt(2) == 'm') {
                    this.initialConnectivity = Integer.parseInt(string.substring(3));
                }
                if (string.charAt(2) == 'x') {
                    this.initialXsize = Integer.parseInt(string.substring(3));
                }
                if (string.charAt(2) != 'y') break;
                this.initialYsize = Integer.parseInt(string.substring(3));
                break;
            }
            case 'k': {
                this.connectivity = Double.parseDouble(string.substring(2)) / 2.0;
                break;
            }
            case 'l': {
                if (string.charAt(2) == 'w') {
                    this.averageWalkLength = Double.parseDouble(string.substring(3));
                }
                if (string.charAt(2) != 'r') break;
                this.rankingProbabilityLengthScale = Double.parseDouble(string.substring(3));
                break;
            }
            case 'm': {
                this.connectivity = Double.parseDouble(string.substring(2));
                System.err.println("!!! Warning: Argument " + string + " is -im is deprecated, use -k for degree instead");
                break;
            }
            case 'o': {
                this.outputControl.set(Integer.parseInt(string.substring(2)));
                break;
            }
            case 'p': {
                this.probnewvertex = Double.parseDouble(string.substring(2));
                break;
            }
            case 'v': {
                if (string.charAt(2) == 'w') {
                    this.randomWalk.randomWalkMode = Integer.parseInt(string.substring(3));
                }
                if (string.charAt(2) == 'e') {
                    this.edgegenerator = Integer.parseInt(string.substring(3));
                }
                if (string.charAt(2) != 'e') break;
                this.binomialNumber = Integer.parseInt(string.substring(3));
                break;
            }
            case 'x': {
                if (string.charAt(2) == 'i') {
                    this.infoLevel = Integer.parseInt(string.substring(3));
                    this.message.setInformationLevel(this.infoLevel);
                }
                if (string.charAt(2) == 'v') {
                    this.maximumVertices = Integer.parseInt(string.substring(3));
                }
                if (string.charAt(2) != 'e') break;
                this.maximumStubs = Integer.parseInt(string.substring(3));
                break;
            }
            case '?': {
                this.printUsage();
                System.exit(1);
            }
            default: {
                throw new IllegalArgumentException("Unknown argument \"" + string + "\"");
            }
        }
    }

    public void printUsage() {
        this.printUsage(System.out);
    }

    public void printUsage(PrintStream printStream) {
        timgraph timgraph2 = new timgraph();
        RandomWalk randomWalk = new RandomWalk(timgraph2);
        printStream.println("OPTIONS for timgraph version tg110504\n");
        printStream.println(" -e<int> number of events (time steps), default " + timgraph2.numevents);
        printStream.println(" -f?n<FullName> full filename, directories optional, ?=i input or ?=o output, default input=" + timgraph2.inputName.getNameRoot() + ", output=" + timgraph2.outputName.getNameRoot());
        printStream.println(" -f?r<NameRoot> root of filename, ?=i input or ?=o output, default input=" + timgraph2.inputName.getNameRoot() + ", output=" + timgraph2.outputName.getNameRoot());
        printStream.println(" -f?e<Ending>  ending used for files, ?=i input or ?=o output, default  input=" + timgraph2.inputName.getNameEnd() + ", output=" + timgraph2.outputName.getNameEnd());
        printStream.println(" -f?s<SubDirName>  sub directory using forward slashes for ?=i input or ?=o output, default  input=" + timgraph2.inputName.getDirectoryEnd() + ", output=" + timgraph2.outputName.getDirectoryEnd());
        printStream.println(" -f?d<DirName>  root of directory using forward slashes for ?=i input or ?=o output, default  input=" + timgraph2.inputName.getDirectoryRoot() + ", output=" + timgraph2.outputName.getDirectoryRoot());
        printStream.println("                full file names are DirName/SubDirName/NameRootEnding");
        printStream.println(" -gb<String> make a bipartite graph, \"t\"=true, otherwise false, default " + timgraph2.isDirected());
        printStream.println(" -g1<String> name of type one vertices in a bipartite graph, default " + timgraph2.getNameVerticesType1());
        printStream.println(" -g2<String> name of type two vertices in a bipartite graph, default " + timgraph2.getNameVerticesType2());
        printStream.println(" -gd<String> make a directed graph, \"t\"=true, otherwise false, default " + timgraph2.isDirected());
        printStream.println(" -gn<int> initial graph, default " + timgraph2.initialgraph);
        printStream.println(" -gm<int> connectivity m for initial graph, default " + timgraph2.initialConnectivity);
        printStream.println(" -gve<String> for each vertex create a list of incident edges by their global label, \"t\"=true, otherwise false, default " + timgraph2.isVertexEdgeListOn());
        printStream.println(" -gvl<String> use vertex labels, \"t\"=true, otherwise false, default " + timgraph2.isVertexLabelled());
        printStream.println(" -gvv<int> number vertices for initial graph, default " + timgraph2.initialVertices);
        printStream.println(" -gel<String> make a edges labelled, \"t\"=true, otherwise false, default " + timgraph2.isEdgeLabelled());
        printStream.println(" -gem<String> allow multi edges, \"t\"=true, otherwise false, default " + timgraph2.isMultiEdge());
        printStream.println(" -ges<String> allow self loops, \"t\"=true, otherwise false, default " + timgraph2.isSelfLooped());
        printStream.println(" -gew<String> make a weighted graph, \"t\"=true, otherwise false, default " + timgraph2.isWeighted());
        printStream.println(" -gx<int> x dimension for initial graph (-1 = make square or cube root of size), default " + timgraph2.initialXsize);
        printStream.println(" -gy<int> y dimension for initial graph (-1 = make equal to x dimension), default " + timgraph2.initialYsize);
        printStream.println(" -k<float> average degree, default " + timgraph2.connectivity / 2.0);
        printStream.println(" -lr<float> average walk length equivalent for ranking prob.(<0 = diameter/2), default " + timgraph2.rankingProbabilityLengthScale);
        printStream.println(" -lw<float> average walk length for random walks (<0 = diameter/2), default " + timgraph2.averageWalkLength);
        printStream.println(" -o<int> output modes (see below), default " + timgraph2.outputControl);
        printStream.println(" -p<float> probability in walks of adding a new vertex per event, default " + timgraph2.probnewvertex);
        printStream.println(" -ve<int> edge generator: 0 Walk, 1 ER, default " + timgraph2.edgegenerator);
        printStream.println(" -vw<int> walk modes (see below), default " + randomWalk.randomWalkMode);
        printStream.println(" -vn<int> binomial distribution integer, default " + timgraph2.binomialNumber);
        printStream.println(" -xe<maxEdges>     maximum no. edges,                   default " + timgraph2.maximumStubs);
        printStream.println(" -xi<infoLevel>    level for information, >0 debugging, default " + timgraph2.infoLevel);
        printStream.println(" -xv<maxVertices>  maximum no. vertices,                default " + timgraph2.maximumVertices);
        printStream.println("gn graph types:");
        printStream.println("          0= empty no vertices, no edges");
        printStream.println("         +1= one initial vertex with no edges");
        printStream.println("         +2= two edges between two initial vertices");
        printStream.println("         +3= one edge between two initial vertices");
        printStream.println("       4..9= various small fixed graphs");
        printStream.println("         99= read in from file");
        printStream.println("         -1= line of numevents vertices and 2*gm neighbours");
        printStream.println("         -2= ring of numevents vertices and 2*gm neighbours");
        printStream.println("         -3= 2-dimensional lattice of side approx sqrt(numevents) vertices and 4*gm neighbours");
        printStream.println("         -4= 2-dimensional torus of side approx sqrt(numevents) vertices and 4*gm neighbours");
        printStream.println("         -5= 3-dimensional lattice of side approx sqrt(numevents) vertices and 4*gm neighbours");
        printStream.println("         -6= 3-dimensional torus of side approx sqrt(numevents) vertices and 4*gm neighbours");
        printStream.println("        -11= line of gx complete subgraphs connected to 2*gm nearest neighbour communities");
        printStream.println("        -12= ring of gx complete subgraphs connected to 2*gm nearest neighbour communities");
        printStream.println("vw modes: (vw& 1) ? Starts walks from random vertex : (end of random edge)");
        printStream.println("        : (vw& 2) ? Starts new walk for every edge : (only for every event)");
        printStream.println("        : (vw& 4) ? Markovian walk, yes : (or no)");
        printStream.println("        : (vw& 8) ? Random number edges per vertex, yes : (or no)");
        printStream.println("        : (vw&16) ? Binomial (Markovian) walk length distribution, yes : (or no)");
        printStream.println("Default modes are:");
        randomWalk.printAllModes(printStream, "        : ");
        printStream.println(" o modes:");
        timgraph2.outputControl.printUsage(printStream, "         ");
        printStream.print("Default outputs are:");
        timgraph2.outputControl.printMode(printStream, "");
        printStream.print("Deprecated :");
        printStream.println(" -m<float> average connectivity, default " + timgraph2.connectivity);
    }

    void printReducedDegreeDistribution() {
        int n = 0;
        System.out.println("Reduced Degree Distribution");
        System.out.println(" k \t  n(k)");
        for (int i = 0; i < this.rddarr.size(); ++i) {
            n = this.rddarr.get(i);
            if (n <= 0) continue;
            System.out.println(i + SEP + n);
        }
    }

    void printWeightDistribution() {
        int n = 0;
        System.out.println("Weight Distribution");
        System.out.println(" w \t  n(w)");
        for (int i = 0; i < this.weightdarr.size(); ++i) {
            n = this.weightdarr.get(i);
            if (n <= 0) continue;
            System.out.println(i + SEP + n);
        }
    }

    void printDistanceDistribution(boolean bl) {
        System.out.println("diameter \t " + this.diameter);
        System.out.println("Distance Distribution [one sample]");
        System.out.println("From totals: average distance \t " + NumbersToString.toString(this.distanceaverage, 2) + SEP + " +/- " + SEP + NumbersToString.toString(this.distanceerror, 2) + ", sigma " + SEP + NumbersToString.toString(this.distancesigma, 2));
        System.out.println("Average distance from one vertex \t " + NumbersToString.toString(this.onesdistanceav, 2) + SEP + " +/- " + SEP + NumbersToString.toString(this.onesdistanceerror, 2) + SEP + ", sigma=" + SEP + NumbersToString.toString(this.onesdistancesigma, 2));
        System.out.println("Diameter \t " + NumbersToString.toString(this.diameter, 2) + SEP + " +/- " + SEP + NumbersToString.toString(this.diametererror, 2) + SEP + ", sigma " + SEP + NumbersToString.toString(this.diametersigma, 2));
        if (bl) {
            System.out.println(" d\t n(d)");
            for (int i = 0; i < this.distancedist.size(); ++i) {
                System.out.println(i + SEP + this.distancedist.get(i));
            }
        }
    }

    public void printComponentInfo() {
        this.printComponentInfo(System.out);
    }

    public void printComponentInfo(PrintStream printStream) {
        this.printComponentInfo(printStream, true, false);
    }

    public void printComponentInfo(PrintStream printStream, boolean bl, boolean bl2) {
        printStream.println("Number of Components \t " + this.componentSize.size());
        printStream.println("     Vertices in GCC \t " + this.componentSizeMax);
        printStream.println("     Diameter of GCC \t " + this.componentDiameterMax);
        printStream.println(" Av. Distance of GCC \t " + this.componentGCCDist);
        printStream.println("   GCC Component No. \t " + this.componentGCCIndex);
        if (bl) {
            this.printComponentDistribution(printStream);
        }
        if (bl2) {
            this.printVertexToComponentList(printStream);
        }
    }

    void printVertexToComponentList(PrintStream printStream) {
        printStream.println("v\t c");
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            printStream.println(i + SEP + this.getVertexComponentLabel(i));
        }
    }

    void printComponentDistribution(PrintStream printStream) {
        printStream.println(" c\t n(c)\t v in c\t diam_min");
        int n = 0;
        for (int i = 0; i < this.componentSize.size(); ++i) {
            printStream.println(i + SEP + this.componentSize.get(i) + SEP + this.componentSource.get(i) + SEP + this.componentDist.get(i));
            n += this.componentSize.get(i);
        }
        printStream.println("Tot\t " + n);
    }

    public int getNumberComponents() {
        return this.componentSize.size();
    }

    public double getAverageComponentSize() {
        return (double)this.TotalNumberVertices / (double)this.componentSize.size();
    }

    public int getNumberSingleComponents() {
        return this.componentSingleNumber;
    }

    public double getAverageMultiComponentSize() {
        int n = this.componentSize.size() - this.componentSingleNumber;
        if (n > 0) {
            return (double)(this.TotalNumberVertices - this.componentSingleNumber) / (double)n;
        }
        return n;
    }

    public int getNumberMultiComponents() {
        return this.componentSize.size() - this.componentSingleNumber;
    }

    public int getNumberGCCVertices() {
        return this.componentSizeMax;
    }

    public int getGCCDiameter() {
        return this.componentDiameterMax;
    }

    public double getGCCDistance() {
        return this.componentGCCDist;
    }

    public String componentInfoString(String string) {
        return this.componentSize.size() + string + this.componentSizeMax + string + this.componentDiameterMax + string + this.componentGCCDist;
    }

    public String componentInfoStringLabel(String string) {
        return "No.Comp." + string + "No.GCC Vert" + string + "GCC Diam." + string + "GCC Dist.";
    }

    void printComponentDistribution() {
        this.printComponentDistribution(System.out);
    }

    void printRingInfo(PrintStream printStream, int n) {
        printStream.println("Ring source \t " + n + SEP + " degree" + SEP + this.vertexList[n].size());
        printStream.println("Ring diameter \t " + (this.distancedist.size() - 1));
        printStream.println("ring\t n(r)\t <k(r)>\t Edges");
        int n2 = 0;
        double d = 0.0;
        int n3 = 0;
        double d2 = 0.0;
        for (int i = 0; i < this.distancedist.size(); ++i) {
            n3 = this.distancedist.get(i);
            d2 = this.ringdegree.get(i);
            n2 += n3;
            d += (double)n3 * d2;
            printStream.println(i + SEP + n3 + SEP + d2 + SEP + NumbersToString.toString((double)n3 * d2, 1));
        }
        printStream.println("Total Vertices\t " + n2 + SEP + ", Total Edges " + NumbersToString.toString(d, 2) + ", Average degree " + d / (double)n2);
    }

    void printDistanceTotalDistribution(boolean bl) {
        System.out.println("Distance Distribution [" + this.totdistancedist.get(0) + " samples]");
        System.out.println("diameter maximum, minimum, average \t " + NumbersToString.toString(this.diametermax, 2) + SEP + NumbersToString.toString(this.diametermin, 2) + SEP + NumbersToString.toString(this.diameteraverage, 2) + SEP + ", sigma= " + NumbersToString.toString(this.diametersigma, 2));
        System.out.println("average distance \t " + NumbersToString.toString(this.totdistanceaverage, 2) + SEP + ", sigma= " + SEP + NumbersToString.toString(this.totdistancesigma, 2));
        if (bl) {
            System.out.println(" d\t n(d)\t  sum_sample (n(d))^2");
            for (int i = 0; i < this.totdistancedist.size(); ++i) {
                System.out.println(i + SEP + this.totdistancedist.get(i) + SEP + this.totdistance2dist.get(i));
            }
        }
    }

    void printDistanceList() {
        System.out.println(" v \t d");
        for (int i = 0; i < this.vertexdistance.length; ++i) {
            System.out.println(i + SEP + this.vertexdistance[i]);
        }
    }

    void printCC() {
        System.out.println("CC Values [" + this.CCnsamples + " samples]");
        System.out.println("average CC \t " + this.CCaverage + SEP + " +/- " + SEP + this.CCerror + SEP + ", sigma= " + SEP + this.CCsigma);
        System.out.println("Edge CC Values [" + this.CCEdgensamples + " samples]");
        System.out.println("average Edge CC \t " + this.CCEdgeaverage + SEP + " +/- " + SEP + this.CCEdgeerror + SEP + ", sigma= " + SEP + this.CCEdgesigma);
    }

    public void printNetwork(boolean bl) {
        boolean bl2 = true;
        boolean bl3 = true;
        this.printVertices(System.out, bl2, bl3, bl);
        this.printEdges(System.out);
        System.out.println("***\t \t \t ***");
    }

    void FileOutputNetwork(boolean bl, boolean bl2, boolean bl3) {
        this.outputName.setNameEnd("net.dat");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.outputName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.printVertices(printStream, bl, bl2, bl3);
            this.printEdges(printStream);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing Network list to " + this.outputName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + this.outputName.getFullFileName());
            return;
        }
    }

    void FileOutputVertices(boolean bl, boolean bl2, boolean bl3) {
        this.outputName.setNameEnd("vertices.dat");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.outputName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.printVertices(printStream, bl, bl2, bl3);
            if (this.infoLevel > -2) {
                System.err.println("Finished writing vertex information to " + this.outputName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Error opening output file " + this.outputName.getFullFileName());
            return;
        }
    }

    public void printVertices(PrintStream printStream, boolean bl, boolean bl2, boolean bl3) {
        this.printVertices(printStream, "", SEP, bl, bl2, bl3);
    }

    public void printVertices(PrintStream printStream, String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        printStream.print(this.getVertexStringLabel(string, string2, bl, bl2, false, this.weightedEdges, bl3));
        printStream.println(string2 + "No. Vertices = " + string2 + this.TotalNumberVertices);
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            printStream.println(this.getVertexString(string, string2, i, -135798642, bl, bl2, this.weightedEdges, bl3));
        }
    }

    public void printVertices(PrintStream printStream, String string, String string2, VertexPartition vertexPartition, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
        boolean bl9 = vertexPartition != null;
        printStream.print(this.getVertexStringLabel(string, string2, bl, bl2, bl9, bl3, bl4, bl5, bl6, bl7, bl8));
        printStream.println(string2 + "No. Vertices = " + string2 + this.TotalNumberVertices);
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            printStream.println(this.getVertexString(string, string2, i, bl9 ? vertexPartition.getCommunity(i) : -135798642, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8));
        }
    }

    public void printVertexCommunity(PrintStream printStream, ArrayList<ArrayList<Integer>> arrayList) {
        String string = "";
        String string2 = SEP;
        int n = -135798642;
        boolean bl = this.isWeighted();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        printStream.println(this.getVertexStringLabel(string, string2, bl3, bl4, false, bl, bl2) + string2 + "Community" + string2 + "C.Frac.");
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            ArrayList<Integer> arrayList2 = arrayList.get(i);
            if (arrayList2.size() > 0) {
                for (Integer n2 : arrayList2) {
                    printStream.println(this.getVertexString(string, string2, i, n, bl3, bl4, bl, bl2) + string2 + n2 + string2 + 1.0 / (double)arrayList2.size());
                }
                continue;
            }
            printStream.println(this.getVertexString(string, string2, i, n, bl3, bl4, bl, bl2) + string2 + (-1 - i) + string2 + "1.0");
        }
    }

    public String getVertexString(String string, String string2, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        if (this.isVertexLabelled()) {
            VertexLabel vertexLabel = this.getVertexLabel(0);
            bl5 = vertexLabel.hasName();
            bl6 = vertexLabel.hasNumber();
            bl7 = vertexLabel.hasPosition();
            bl3 = vertexLabel.hasStrength();
            bl8 = vertexLabel.hasRank();
        }
        return this.getVertexString(string, string2, n, n2, bl, bl2, bl5, bl6, bl7, bl3, bl8, bl4);
    }

    public String getVertexString(String string, String string2, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
        String string3 = Integer.toString(n);
        if (n2 != -135798642) {
            string3 = string3 + string2 + n2;
        }
        string3 = string3 + string2 + this.vertexList[n].size();
        if (bl) {
            if (bl2) {
                int[] nArray = this.calcTrianglesSquares(n);
                string3 = string3 + string2 + nArray[0] + string2 + nArray[1];
            } else {
                string3 = string3 + string2 + this.calcTriangles(n);
            }
        }
        if (this.vertexlabels) {
            string3 = string3 + string2 + this.vertexLabelList[n].printString(string2, bl3, bl4, bl5, bl6, bl7);
        } else if (bl6) {
            string3 = string3 + string2 + this.getVertexOutStrength(n);
        }
        if (bl8) {
            for (int i = 0; i < this.vertexList[n].size(); ++i) {
                string3 = string3 + string2 + this.vertexList[n].get(i);
            }
        }
        return string3;
    }

    public String getVertexStringLabel(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        if (this.isVertexLabelled()) {
            VertexLabel vertexLabel = this.getVertexLabel(0);
            bl6 = vertexLabel.hasName();
            bl7 = vertexLabel.hasNumber();
            bl8 = vertexLabel.hasPosition();
            bl4 = vertexLabel.hasStrength();
            bl9 = vertexLabel.hasRank();
        }
        return this.getVertexStringLabel(string, string2, bl, bl2, bl3, bl6, bl7, bl8, bl4, bl9, bl5);
    }

    public String getVertexStringLabel(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9) {
        String string3 = "index";
        if (bl3) {
            string3 = string3 + string2 + "Community";
        }
        string3 = string3 + string2 + "degree";
        if (bl) {
            string3 = string3 + string2 + "triangles";
            if (bl2) {
                string3 = string3 + string2 + "squares";
            }
        }
        if (this.vertexlabels) {
            string3 = string3 + string2 + VertexLabel.labelString(string2, bl4, bl5, bl6, bl7, bl8);
        }
        if (bl9) {
            string3 = string3 + string2 + "n.n.";
        }
        return string3;
    }

    public void printEdges() {
        this.printEdges(System.out);
    }

    public void printEdges(PrintStream printStream) {
        this.printEdges(printStream, COMMENTCHARACTER, SEP, -3.57986421E8, true, true, true, true, true);
    }

    public void printEdgesSimple(PrintStream printStream) {
        this.printEdges(printStream, COMMENTCHARACTER, SEP, -3.57986421E8, true, false, true, false, false);
    }

    public void printEdges(PrintStream printStream, String string, String string2, double d, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        boolean bl6 = bl & this.vertexlabels;
        if (bl2) {
            printStream.println(string + "Edges    = " + string2 + this.TotalNumberStubs + string2 + this.stubSourceList.length);
        }
        if (bl3) {
            if (bl4) {
                printStream.print(" e1 " + string2 + " e2" + string2);
            }
            printStream.print(" Source " + string2 + " Target ");
            if (this.weightedEdges) {
                printStream.print(string2 + "Weight");
            }
            if (this.weightedEdges && bl5) {
                printStream.print(string2 + "Label");
            }
            printStream.println();
        }
        double d2 = 1.0;
        boolean bl7 = d != -3.57986421E8;
        for (int i = 0; i < this.TotalNumberStubs; i += 2) {
            if (this.weightedEdges) {
                d2 = this.edgeValuetList[i].weight;
                if (bl7 && d2 < d) continue;
            }
            if (bl4) {
                printStream.print(i + string2 + (i + 1) + string2);
            }
            int n = this.stubSourceList[i];
            int n2 = this.stubSourceList[i + 1];
            if (bl6) {
                printStream.print(this.vertexLabelList[n].getName() + string2 + this.vertexLabelList[n2].getName());
            } else {
                printStream.print(n + string2 + n2);
            }
            if (this.weightedEdges) {
                printStream.print(string2 + d2);
            }
            if (this.weightedEdges && bl5) {
                printStream.print(string2 + this.edgeValuetList[i].label);
            }
            printStream.println();
        }
    }

    public void printEdgeCommunityStats(PrintStream printStream, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (!this.weightedEdges) {
            throw new IllegalArgumentException("*** printEdgeCommunityStats needed edges to have labels");
        }
        if (!this.vertexEdgeListOn) {
            throw new IllegalArgumentException("*** printEdgeCommunityStats needed vertexEdgeList");
        }
        if (bl) {
            printStream.println(this.edgeCommunityStatsLabel(string));
        }
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            if (this.bipartiteGraph && bl3 && (bl4 ? this.isType2(i) : this.isType1(i))) continue;
            this.printEdgeCommunityStats(printStream, string, i, bl2);
        }
    }

    private void printEdgeCommunityStats(PrintStream printStream, String string, int n, boolean bl) {
        int n2;
        String string2 = "";
        string2 = bl ? this.getVertexName(n) : string2 + n;
        int n3 = this.getVertexDegree(n);
        if (n3 == 0) {
            int n4 = -1 - n;
            int n5 = 0;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 1.0;
            double d4 = 1.0;
            double d5 = 0.0;
            printStream.println(string2 + string + n4 + string + n3 + string + n5 + string + d4 + string + d2 + string + d + string + d3 + string + d5);
            return;
        }
        IntArrayList intArrayList = new IntArrayList(n3);
        DoubleArrayList doubleArrayList = new DoubleArrayList(n3);
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        IntArrayList intArrayList2 = new IntArrayList(n3);
        IntArrayList intArrayList3 = this.vertexEdgeList[n];
        double d = 0.0;
        for (int i = 0; i < intArrayList3.size(); ++i) {
            int n6 = intArrayList3.getQuick(i);
            int n7 = this.edgeValuetList[n6].label;
            double d6 = this.edgeValuetList[n6].weight;
            d += d6;
            if (treeMap.containsKey(n7)) {
                int n8 = (Integer)treeMap.get(n7);
                intArrayList.setQuick(n8, intArrayList.getQuick(n8) + 1);
                doubleArrayList.setQuick(n8, doubleArrayList.getQuick(n8) + d6);
                continue;
            }
            treeMap.put(n7, intArrayList.size());
            intArrayList2.add(n7);
            intArrayList.add(1);
            doubleArrayList.add(d6);
        }
        double d7 = n3;
        double d8 = 1.0;
        double d9 = -1.0;
        for (n2 = 0; n2 < intArrayList2.size(); ++n2) {
            double d10 = doubleArrayList.getQuick(n2) / d;
            if (!(d10 > 1.0E-20)) continue;
            d8 += -d10 * Math.log(d10);
        }
        for (n2 = 0; n2 < intArrayList2.size(); ++n2) {
            int n9 = intArrayList2.get(n2);
            int n10 = intArrayList.getQuick(n2);
            d9 = doubleArrayList.getQuick(n2);
            printStream.println(string2 + string + n9 + string + n3 + string + n10 + string + (double)n10 / d7 + string + d + string + d9 + string + d9 / d + string + d8);
        }
    }

    private String edgeCommunityStatsLabel(String string) {
        return "Name" + string + "Community" + string + "Degree k" + string + "k in C." + string + "Frac.k In C." + string + "Strength" + string + "S.in C." + string + "Frac.S. in C." + string + "S.Entropy";
    }

    public void printOrderedWeightedNetwork() {
        int n;
        int n2;
        System.out.println("# Vertices = \t " + this.TotalNumberVertices + SEP + this.vertexList.length);
        System.out.println("# Edges    = \t " + this.TotalNumberStubs + SEP + this.stubSourceList.length);
        for (n2 = 0; n2 < this.TotalNumberVertices; ++n2) {
            System.out.println("Vertex " + n2 + " has degree " + this.vertexList[n2].size() + " and is connected to:");
            for (n = 0; n < this.vertexList[n2].size(); ++n) {
                System.out.print(this.vertexList[n2].get(n) + SEP);
            }
            System.out.println();
        }
        System.out.println("Edges ");
        System.out.print(" e1 \t  e2\t  Sou \t  Tar ");
        if (this.weightedEdges) {
            System.out.println("\t  Lab \t  Wei ");
        }
        for (n = 0; n < this.TotalNumberStubs / 2; ++n) {
            n2 = this.edgerandomlist[n] * 2;
            System.out.println(n2 + SEP + (n2 + 1) + SEP + this.stubSourceList[n2] + SEP + this.stubSourceList[n2 + 1]);
            if (!this.weightedEdges) continue;
            System.out.println(SEP + this.edgeValuetList[n2].label + SEP + this.edgeValuetList[n2].weight);
        }
        System.out.println("***                      ***");
    }

    void printReducedNetwork() {
        System.out.println("*** Reduced Network Data ***");
        System.out.println("# Vertices = \t " + this.TotalNumberVertices);
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            System.out.println("Vertex " + i + " has reduced degree " + this.rvertexList[i].size() + " and strength" + this.vertexList[i].size() + " and is connected to:");
            for (int j = 0; j < this.rvertexList[i].size(); ++j) {
                System.out.print(this.rvertexList[i].get(j) + " (" + this.strengthlist[i].get(j) + ") " + SEP);
            }
            System.out.println();
        }
        System.out.println("\n***                      ***");
    }

    public void printParametersBasic() {
        this.printParametersBasic(System.out, "\t  ");
    }

    public void printParametersBasic(PrintStream printStream, String string) {
        TimTime timTime = new TimTime(string);
        printStream.println("Programme version " + string + VERSION + string + timTime.fullString(string));
        printStream.println(this.inputName.getNameRoot() + " initial Graph " + string + this.initialgraph + string + this.initialGraphString());
        printStream.println("Number Vertices " + string + this.TotalNumberVertices + string + "Stubs" + string + this.TotalNumberStubs + string + "Total Weight" + string + this.getTotalWeight());
        if (this.bipartiteGraph) {
            printStream.println("Number " + this.nameVertexType1 + " (type 1) and " + this.nameVertexType2 + " (type 2) vertices" + string + this.numberVertexType1 + string + this.numberVertexType2);
        }
        printStream.println("Average Out degree " + string + this.calcDegreeFirstMoment() + string + ", Second Moment of D.D." + string + this.calcDegreeSecondMoment());
        printStream.println("Total Number of Triangles " + string + this.getNumberTriangles() + ", global clustering coefficient " + string + this.getCCGlobal());
        printStream.println(this.graphTypeString(string));
        printStream.println(this.stringOfChecks(string));
    }

    public String stringOfChecks(String string) {
        return "Dynamical checks:" + string + " multi edges - " + string + (this.checkMultiEdges() ? "yes" : "no") + string + " negative weights - " + string + (this.checkNegativeWeights() ? "yes" : "no") + string + " self loops - " + string + (this.checkSelfLoops() ? "yes" : "no");
    }

    public String stringDirected() {
        return (this.isDirected() ? "" : "un") + "directed";
    }

    public String stringWeighted() {
        return (this.isWeighted() ? "" : "un") + "weighted";
    }

    public String stringLabelled() {
        return "vertices " + (this.isVertexLabelled() ? "" : "un") + "labelled";
    }

    public String stringVertexEdgeList() {
        return " vertex->edge list " + (this.isVertexEdgeListOn() ? "on" : "off");
    }

    public String stringEdgeLabelled() {
        return "edges " + (this.isEdgeLabelled() ? "" : "un") + "labelled";
    }

    public String stringMultiEdge() {
        return "multiedges " + (this.isMultiEdge() ? "" : "not ") + "allowed";
    }

    public String stringSelfLoops() {
        return "self loops " + (this.isSelfLooped() ? "" : "not ") + "allowed";
    }

    public String stringBipartite() {
        return this.isBipartite() ? "bipartite" : "unipartite";
    }

    public String graphTypeString(String string) {
        return this.stringDirected() + string + this.stringWeighted() + string + this.stringLabelled() + string + this.stringEdgeLabelled() + string + this.stringMultiEdge() + string + this.stringSelfLoops() + string + this.stringVertexEdgeList() + string + this.stringBipartite();
    }

    public void printParam() {
        this.printParametersBasic();
        System.out.println("Walk has \t " + this.numevents + SEP + " events,  ");
        this.printRandomWalkMode();
        System.out.println(this.connectivity + SEP + " edges added per event, " + SEP + this.averageWalkLength + SEP + " averageWalkLength, " + SEP + this.probnewvertex + SEP + " new vertex prob.");
        System.out.println("Info level is \t " + this.infoLevel);
        System.out.println(this.binomialNumber + SEP + " no. of dice used in binomial random numbers generator");
        if (this.probnewvertex < 1.0) {
            System.out.print("Prob of new vertex is \t " + this.probnewvertex + SEP + " using old ");
            if (this.SourceVertex) {
                System.out.println("random vertices");
            } else {
                System.out.println("vertices at end of random edges");
            }
        }
        this.outputControl.printMode(System.out, "");
    }

    public void printRandomWalkMode() {
        this.printRandomWalkMode(System.out, "");
    }

    public void printRandomWalkMode(PrintStream printStream, String string) {
        if ((this.randomWalkMode & 1) > 0) {
            printStream.println(string + "   Start every walk from random vertex");
        } else {
            printStream.println(string + "   Start every walk from random end of random edge");
        }
        if ((this.randomWalkMode & 2) > 0) {
            printStream.println(string + "   Jump to new vertex when walk length reached (every new edge)");
        } else {
            printStream.println(string + "   Do not jump to new vertex when walk length reached (unless new event in walk graph creation or no exits in random walk");
        }
        if ((this.randomWalkMode & 4) > 0) {
            printStream.println(string + "   Walk length variable, average fixed");
        } else {
            printStream.println(string + "   Walk length fixed");
        }
        if ((this.randomWalkMode & 8) > 0) {
            printStream.println(string + "   No. of edges added to each new vertex variable, average fixed");
        } else {
            printStream.println(string + "   No. of edges added to each new vertex fixed");
        }
        if ((this.randomWalkMode & 0x10) > 0) {
            printStream.println(string + "   Binomial distributed walk lengths");
        } else {
            printStream.println(string + "   Markovian walk lengths");
        }
    }

    public void printEdgeGenerator(PrintStream printStream) {
        System.out.print("Edge generator is \t " + this.edgegenerator);
        if (this.edgegenerator == 0) {
            printStream.println("   Walk routine used");
        }
        if (this.edgegenerator == 1) {
            printStream.println("   ER generator used");
        }
    }

    public String initialGraphString() {
        return this.initialGraphString(this.initialgraph);
    }

    public String initialGraphString(int n) {
        String string = "???";
        switch (n) {
            case 0: {
                string = "Empty";
                break;
            }
            case 1: {
                string = "One vertex, no edges";
                break;
            }
            case 2: {
                string = "Two vertices with two edges (both degree=2)";
                break;
            }
            case 3: {
                string = "Two vertices, one edge";
                break;
            }
            case 4: {
                string = "Four vertices, eight edges (all degrees=4)";
                break;
            }
            case 5: {
                string = "Two vertices, four edges (both degree=4)";
                break;
            }
            case 6: {
                string = "Five vertices, four edges (star shape)";
                break;
            }
            case 7: {
                string = "Five vertices, four edges";
                break;
            }
            case 8: {
                string = "BowTie - Five vertices, six edges (two triangles with common vertex)";
                break;
            }
            case 9: {
                string = "Long BowTie - Six vertices, seven edges (two triangles with edge between two of their vertices)";
                break;
            }
            case 10: {
                string = "Nuclear - seven vertices, nine edges (three triangles with single common vertex)";
                break;
            }
            case 99: {
                string = "Input graph from file of specified extension, input file name " + this.inputName.getFullFileName();
                break;
            }
            case 100: {
                string = "Graph constructed from algorithm, graph name " + this.inputName.getNameRoot();
                break;
            }
            case -1: {
                string = "Line";
                break;
            }
            case -2: {
                string = "Ring";
                break;
            }
            case -3: {
                string = "2D rectangular lattice";
                break;
            }
            case -4: {
                string = "2D Torus";
                break;
            }
            case -5: {
                string = "3D rectangular lattice";
                break;
            }
            case -6: {
                string = "3D Torus";
                break;
            }
            case -11: {
                string = "CaveMan Line";
                break;
            }
            case -12: {
                string = "CaveMan Ring";
                break;
            }
            case -13: {
                string = "CaveMan Common Vertex Line";
                break;
            }
            case -14: {
                string = "CaveMan Common Vertex Ring";
                break;
            }
            default: {
                string = "Unknown Type";
            }
        }
        return string;
    }

    public void setInitialGraph(int n) {
        this.initialgraph = n;
    }

    public void setInitialGraphExternalAlgorithm() {
        this.initialgraph = 100;
    }

    public void setNetworkInitialGraph(boolean bl) {
        this.setNetwork(this.initialgraph);
        if (bl) {
            this.calcNumberVertices();
            this.calcNumberEdges();
        }
    }

    public int setNetworkOnlyFromInputFile() {
        this.initialgraph = 99;
        int n = -1;
        if (!this.inputFileType.setFromExactName(this.inputName.getNameEnd())) {
            throw new RuntimeException("Input file extension " + this.inputName.getNameEnd() + " unknown");
        }
        System.out.println("Setting up from input file:- " + this.inputFileType.toLongString());
        switch (this.inputFileType.getNumber()) {
            case 0: {
                n = this.setNetworkPajek(this.inputName.getNameEnd(), this.directedGraph, this.weightedEdges);
                this.initialVertices = this.TotalNumberVertices;
                this.initialEdges = this.TotalNumberStubs;
                return n;
            }
            case 1: {
                n = this.setNetworkEdgeList(this.inputName.getNameEnd(), this.directedGraph, this.weightedEdges, this.vertexlabels, this.labelledEdges, true);
                this.initialVertices = this.TotalNumberVertices;
                this.initialEdges = this.TotalNumberStubs;
                return n;
            }
            case 2: {
                n = this.setNetworkEdgeList(this.inputName.getNameEnd(), this.directedGraph, this.weightedEdges, this.vertexlabels, this.labelledEdges, false);
                this.initialVertices = this.TotalNumberVertices;
                this.initialEdges = this.TotalNumberStubs;
                return n;
            }
            case 3: {
                n = this.setNetworkGMLInput(this.inputName.getNameEnd(), this.weightedEdges, this.vertexlabels);
                this.initialVertices = this.TotalNumberVertices;
                this.initialEdges = this.TotalNumberStubs;
                return n;
            }
            case 4: {
                n = this.setNetworkMatrixInput();
                this.initialVertices = this.TotalNumberVertices;
                this.initialEdges = this.TotalNumberStubs;
                return n;
            }
            case 5: {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = true;
                boolean bl4 = false;
                n = this.setNetworkVertexNeighbourList(this.inputName.getNameEnd(), this.weightedEdges, this.directedGraph, this.multiEdge, this.vertexlabels, bl, bl2, bl3, false, 1, null, null, null);
                this.initialVertices = this.TotalNumberVertices;
                this.initialEdges = this.TotalNumberStubs;
                return n;
            }
            case 6: {
                boolean bl = false;
                boolean bl5 = true;
                boolean bl6 = true;
                boolean bl7 = true;
                n = this.setNetworkVertexNeighbourList(this.inputName.getNameEnd(), this.weightedEdges, this.directedGraph, this.multiEdge, this.vertexlabels, bl, bl5, bl6, false, 1, null, null, null);
                this.initialVertices = this.TotalNumberVertices;
                this.initialEdges = this.TotalNumberStubs;
                return n;
            }
            case 7: {
                boolean bl = true;
                boolean bl8 = true;
                boolean bl9 = true;
                n = this.setNetworkMatrixInput(bl, bl8, bl9);
                this.initialVertices = this.TotalNumberVertices;
                this.initialEdges = this.TotalNumberStubs;
                return n;
            }
        }
        return n;
    }

    public int setNetworkFromInputFile() {
        int n = 1;
        int n2 = 2;
        int n3 = 1;
        boolean bl = false;
        boolean bl2 = false;
        return this.setNetworkFromInputFile(n, n2, n3, bl, bl2);
    }

    public int setNetworkFromInputFile(int n, int n2, int n3, boolean bl, boolean bl2) {
        int n4 = this.setNetworkOnlyFromInputFile();
        String string = this.inputName.getNameRootFullPath() + "inputXY.dat";
        try {
            this.setVertexPositionsFromFile(string, COMMENTCHARACTER, n, n2, bl, bl2);
        }
        catch (Exception exception) {
            System.out.println("Unable to set vertex coordinates from file " + string + " - " + exception);
        }
        try {
            this.setVertexNamesFromFile("inputNames.dat", COMMENTCHARACTER, n3, bl, bl2);
        }
        catch (Exception exception) {
            System.out.println("Unable to set vertex names from file - " + exception);
        }
        return n4;
    }

    void setNetwork(int n) {
        int n2;
        if (this.infoLevel > -1) {
            System.out.println("Initial Graph Type " + n + ": " + this.initialGraphString(n));
        }
        if (n == 99) {
            this.setNetworkFromInputFile();
            return;
        }
        switch (n) {
            case -14: 
            case -13: {
                n2 = this.initialVertices / this.initialXsize;
                this.initialEdges = (n2 * (n2 + 1) + 2 * this.initialConnectivity) * this.initialXsize + 1;
                break;
            }
            case -12: 
            case -11: {
                n2 = this.initialVertices / this.initialXsize;
                this.initialEdges = (n2 * (n2 - 1) + 2 * this.initialConnectivity) * this.initialXsize;
                break;
            }
            case -6: 
            case -5: {
                this.initialEdges = this.initialVertices * 6 * this.initialConnectivity;
                break;
            }
            case -4: 
            case -3: {
                this.initialEdges = this.initialVertices * 4 * this.initialConnectivity;
                break;
            }
            case -2: 
            case -1: {
                this.initialEdges = this.initialVertices * 2 * this.initialConnectivity;
                break;
            }
            case 0: {
                this.initialVertices = 0;
                this.initialEdges = 0;
                break;
            }
            case 1: {
                this.initialVertices = 1;
                this.initialEdges = 0;
                break;
            }
            case 2: {
                this.initialVertices = 2;
                this.initialEdges = 4;
                break;
            }
            case 3: {
                this.initialVertices = 2;
                this.initialEdges = 2;
                break;
            }
            case 4: {
                this.initialVertices = 4;
                this.initialEdges = 8;
                break;
            }
            case 5: {
                this.initialVertices = 2;
                this.initialEdges = 8;
                break;
            }
            case 6: {
                this.initialVertices = 5;
                this.initialEdges = 8;
                break;
            }
            case 7: {
                this.initialVertices = 5;
                this.initialEdges = 8;
                break;
            }
            case 8: {
                this.initialVertices = 5;
                this.initialEdges = 12;
                break;
            }
            case 9: {
                this.initialVertices = 6;
                this.initialEdges = 14;
                break;
            }
            case 10: {
                this.initialVertices = 7;
                this.initialEdges = 18;
                break;
            }
            default: {
                System.err.println("***ERROR unknown initial graph type");
                return;
            }
        }
        this.maximumVertices = this.numevents + this.initialVertices;
        this.maxexpectedvertices = this.probnewvertex * (double)this.numevents + (double)this.initialVertices;
        this.maxexpectededges = (double)this.numevents * this.connectivity * 2.0 + (double)this.initialEdges;
        this.maximumStubs = (int)(this.maxexpectededges + 5.0 * Math.sqrt(this.maxexpectededges) + 0.5);
        if (this.infoLevel > -1) {
            System.out.println("Initial vertices and edges are " + this.initialVertices + SEP + this.initialEdges);
            System.out.println("Maximum vertices and edges are " + this.maximumVertices + SEP + this.maximumStubs);
        }
        if (n < 0) {
            switch (this.initialgraph) {
                case -1: {
                    this.setNetworkLine(false);
                    break;
                }
                case -2: {
                    this.setNetworkLine(true);
                    break;
                }
                case -3: {
                    this.setNetworkSquareLattice(false);
                    break;
                }
                case -4: {
                    this.setNetworkSquareLattice(true);
                    break;
                }
                case -5: {
                    this.setNetworkCubicLattice(false);
                    break;
                }
                case -6: {
                    this.setNetworkCubicLattice(true);
                    break;
                }
                case -11: {
                    this.setNetworkCaveManLine(false);
                    break;
                }
                case -12: {
                    this.setNetworkCaveManLine(true);
                    break;
                }
                case -13: {
                    this.setNetworkCaveManCommonVertex(false);
                    break;
                }
                case -14: {
                    this.setNetworkCaveManCommonVertex(true);
                }
            }
            this.initialEdges = this.TotalNumberStubs;
            this.initialVertices = this.TotalNumberVertices;
            return;
        }
        this.setNetwork();
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                n2 = this.addVertex();
                break;
            }
            case 3: {
                n2 = this.addVertex();
                int n3 = this.addVertex();
                this.addEdge(n2, n3);
                break;
            }
            case 4: {
                n2 = this.addVertex();
                int n3 = this.addVertex();
                int n4 = this.addVertex();
                int n5 = this.addVertex();
                this.addEdge(n2, n3);
                this.addEdge(n3, n2);
                this.addEdge(n3, n4);
                this.addEdge(n4, n5);
                this.addEdge(n5, n4);
                this.addEdge(n5, n2);
                this.addEdge(n2, n4);
                this.addEdge(n3, n5);
                break;
            }
            case 5: {
                n2 = this.addVertex();
                int n3 = this.addVertex();
                this.addEdge(n2, n3);
                this.addEdge(n2, n3);
                this.addEdge(n3, n2);
                this.addEdge(n3, n2);
                break;
            }
            case 6: {
                n2 = this.addVertex();
                int n3 = this.addVertex();
                int n4 = this.addVertex();
                int n5 = this.addVertex();
                int n6 = this.addVertex();
                this.addEdge(n2, n3);
                this.addEdge(n2, n4);
                this.addEdge(n2, n5);
                this.addEdge(n2, n6);
                break;
            }
            case 7: {
                n2 = this.addVertex();
                int n3 = this.addVertex();
                int n4 = this.addVertex();
                int n5 = this.addVertex();
                int n6 = this.addVertex();
                this.addEdge(n2, n3);
                this.addEdge(n2, n4);
                this.addEdge(n2, n5);
                this.addEdge(n2, n6);
                break;
            }
            case 8: {
                n2 = this.addVertex();
                int n3 = this.addVertex();
                int n4 = this.addVertex();
                int n5 = this.addVertex();
                int n6 = this.addVertex();
                this.addEdge(n2, n3);
                this.addEdge(n2, n4);
                this.addEdge(n3, n4);
                this.addEdge(n4, n5);
                this.addEdge(n4, n6);
                this.addEdge(n5, n6);
                break;
            }
            case 9: {
                n2 = this.addVertex();
                int n3 = this.addVertex();
                int n4 = this.addVertex();
                int n5 = this.addVertex();
                int n6 = this.addVertex();
                int n7 = this.addVertex();
                this.addEdge(n2, n3);
                this.addEdge(n2, n4);
                this.addEdge(n3, n4);
                this.addEdge(n4, n7);
                this.addEdge(n7, n5);
                this.addEdge(n7, n6);
                this.addEdge(n5, n6);
                break;
            }
            case 10: {
                n2 = this.addVertex();
                int n3 = this.addVertex();
                int n4 = this.addVertex();
                int n5 = this.addVertex();
                int n6 = this.addVertex();
                int n7 = this.addVertex();
                int n8 = this.addVertex();
                this.addEdge(n2, n3);
                this.addEdge(n2, n4);
                this.addEdge(n3, n4);
                this.addEdge(n2, n5);
                this.addEdge(n2, n6);
                this.addEdge(n5, n6);
                this.addEdge(n2, n7);
                this.addEdge(n2, n8);
                this.addEdge(n7, n8);
                break;
            }
            default: {
                n2 = this.addVertex();
                int n3 = this.addVertex();
                this.addEdge(n2, n3);
                this.addEdge(n3, n2);
            }
        }
        if (this.weightedEdges) {
            for (n2 = 0; n2 < this.TotalNumberStubs; ++n2) {
                this.edgeValuetList[n2] = new EdgeValue(0, 1.0);
            }
        }
        if (this.initialVertices != this.TotalNumberVertices) {
            System.out.println("*** ERROR initialVertices != TotalNumberVertices " + this.initialVertices + SEP + this.TotalNumberVertices);
        }
        if (this.initialEdges != this.TotalNumberStubs) {
            System.out.println("*** ERROR initialEdges    != TotalNumberEdges " + this.initialEdges + SEP + this.TotalNumberStubs);
        }
        this.initialEdges = this.TotalNumberStubs;
        this.initialVertices = this.TotalNumberVertices;
    }

    public void setNetworkWithVertices(int n, int n2) {
        this.setNetwork(n, n2);
        if (this.vertexlabels) {
            for (int i = 0; i < this.maximumVertices; ++i) {
                this.addVertex(new VertexLabel());
            }
        } else {
            for (int i = 0; i < this.maximumVertices; ++i) {
                this.addVertex();
            }
        }
    }

    public void setNetwork(int n, int n2) {
        this.maximumVertices = n;
        this.maximumStubs = n2;
        this.setNetwork();
    }

    public void setNetwork() {
        this.vertexList = new IntArrayList[this.maximumVertices];
        if (this.vertexEdgeListOn) {
            this.vertexEdgeList = new IntArrayList[this.maximumVertices];
            if (this.directedGraph) {
                this.vertexInEdgeList = new IntArrayList[this.maximumVertices];
            }
        }
        if (this.directedGraph) {
            this.vertexSourceList = new IntArrayList[this.maximumVertices];
        }
        if (this.vertexlabels) {
            this.vertexLabelList = new VertexLabel[this.maximumVertices];
        }
        this.TotalNumberVertices = 0;
        this.stubSourceList = new int[this.maximumStubs];
        if (this.weightedEdges) {
            this.edgeValuetList = new EdgeValue[this.maximumStubs];
        }
        this.TotalNumberStubs = 0;
    }

    public void setNetworkFromMatrix(double[][] dArray) {
        this.setNetworkFromMatrix(null, dArray);
    }

    public void setNetworkFromMatrix(String[] stringArray, double[][] dArray) {
        int n;
        int n2 = dArray[0].length;
        boolean bl = false;
        if (stringArray != null) {
            bl = true;
        }
        if (bl && stringArray.length != n2) {
            throw new RuntimeException("*** number of names " + stringArray.length + " does not match dimension of matrix " + n2 + " in setNetworkFromMatrix");
        }
        this.maximumVertices = n2;
        this.maximumStubs = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = true;
        for (int i = 0; i < n2; ++i) {
            for (n = 0; n < n2; ++n) {
                if (dArray[i][n] != 0.0) {
                    if (i == n) {
                        ++n3;
                    } else {
                        ++n4;
                    }
                }
                if (this.isDirected() || !bl2 || dArray[i][n] == dArray[n][i]) continue;
                System.out.println("!!!Warning undirected graph by unsymmetrical matrix, entry " + i + ", " + n);
                bl2 = false;
            }
        }
        this.maximumStubs = this.isDirected() ? 2 * (n4 + n3) : n4 + 2 * n3;
        this.setNetwork();
        VertexLabel vertexLabel = new VertexLabel();
        if (this.vertexlabels) {
            for (n = 0; n < n2; ++n) {
                if (bl) {
                    vertexLabel.setName(stringArray[n]);
                } else {
                    vertexLabel.setName(Integer.toString(n));
                }
                this.addVertex(vertexLabel);
            }
        } else {
            for (n = 0; n < n2; ++n) {
                this.addVertex();
            }
        }
        for (n = 0; n < n2; ++n) {
            int n5;
            int n6 = n5 = this.isDirected() ? 0 : n;
            while (n5 < n2) {
                if (dArray[n][n5] != 0.0) {
                    if (this.isWeighted()) {
                        this.addEdge(n, n5, dArray[n][n5]);
                    } else {
                        this.addEdge(n, n5);
                    }
                }
                ++n5;
            }
        }
    }

    void setNetwork(int n, int[] nArray, boolean bl) {
        int n2;
        this.setNetwork();
        if (this.vertexlabels) {
            for (n2 = 0; n2 < n; ++n2) {
                this.addVertex(new VertexLabel());
            }
        } else {
            for (n2 = 0; n2 < n; ++n2) {
                this.addVertex();
            }
        }
        n2 = -1;
        int n3 = -1;
        EdgeValue edgeValue = new EdgeValue();
        EdgeValue edgeValue2 = new EdgeValue();
        int n4 = nArray.length >> 1 << 1;
        if (bl) {
            double d = nArray.length;
            int n5 = -999;
            int n6 = -1;
            int n7 = 0;
            while ((double)n7 < d) {
                n6 = (int)(Math.random() * d);
                n5 = nArray[n7];
                nArray[n7] = nArray[n6];
                nArray[n6] = n5;
                ++n7;
            }
        }
        int n8 = 0;
        while (n8 < n4) {
            n2 = nArray[n8++];
            n3 = nArray[n8++];
            if (this.weightedEdges) {
                this.addEdge(n2, n3, edgeValue, edgeValue2);
                continue;
            }
            this.addEdge(n2, n3);
        }
    }

    public int setNetworkPajek(String string, boolean bl, boolean bl2) {
        FileInput fileInput = new FileInput(this.infoLevel);
        return fileInput.processPajekFile(this, string, bl, bl2);
    }

    public int setNetworkEdgeList(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        FileInput fileInput = new FileInput(this.infoLevel);
        if (bl5) {
            return FileInput.processIntEdgeFile(this, string, 1, 2, bl2 ? 3 : -1, bl4 ? 4 : -1, bl, bl3, this.infoLevel > 1);
        }
        return fileInput.processStringEdgeFile(this, string, 1, 2, bl2 ? 3 : -1, bl4 ? 4 : -1, bl, bl3);
    }

    public int setNetworkVertexNeighbourList(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, StringFilter stringFilter, StringFilter stringFilter2, TreeSet<String> treeSet) {
        FileInput fileInput = new FileInput(this.infoLevel);
        if (bl5) {
            return -952384;
        }
        return fileInput.processStringVertexNeighbourFile(this, string, bl, bl2, this.multiEdge, bl4, bl6, bl7, bl8, n, stringFilter, stringFilter2, treeSet);
    }

    public int setNetworkMatrixInput() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        return this.setNetworkMatrixInput(bl, bl2, bl3);
    }

    public int setNetworkMatrixInput(boolean bl, boolean bl2, boolean bl3) {
        FileInput fileInput = new FileInput(this.infoLevel);
        return fileInput.processAdjacencyMatrixTabSeparated(this, bl, bl2, bl3);
    }

    public int setNetworkGMLInput(String string, boolean bl, boolean bl2) {
        FileInput fileInput = new FileInput(this.infoLevel);
        return fileInput.processGMLFile(this, string, bl, bl2);
    }

    public void setNetworkLine(boolean bl) {
        this.setNetworkLine(this.initialVertices, this.initialConnectivity, bl);
    }

    public void setNetworkLine(int n, int n2, boolean bl) {
        int n3;
        int n4;
        if (n > this.maximumVertices) {
            this.maximumVertices = n;
        }
        if (this.maximumStubs < (n4 = n * n2 * 2)) {
            this.maximumStubs = n4;
        }
        this.setNetwork();
        for (n3 = 0; n3 < n; ++n3) {
            this.addVertex();
        }
        n3 = -1;
        for (int i = 0; i < n; ++i) {
            for (int j = 1; j <= n2; ++j) {
                n3 = i + j;
                if (n3 >= n && !bl) continue;
                this.addEdge(i, n3 %= n);
            }
        }
    }

    public void setNetworkSquareLattice(boolean bl) {
        int n = this.initialXsize;
        if (n < 1) {
            n = (int)(0.5 + Math.sqrt(this.initialVertices));
        }
        this.setNetworkSquareLattice(this.initialVertices, this.initialConnectivity, n, bl);
    }

    public void setNetworkSquareLattice(int n, int n2, int n3, boolean bl) {
        int n4;
        int n5;
        if (n > this.maximumVertices) {
            this.maximumVertices = n;
        }
        if ((n5 = n3) > n) {
            n5 = (int)Math.sqrt(n);
        }
        int n6 = (n - 1) / n5 + 1;
        int n7 = n * n2 * 2;
        if (this.maximumStubs < n7) {
            this.maximumStubs = n7;
        }
        this.setNetwork();
        for (n4 = 0; n4 < n; ++n4) {
            this.addVertex();
        }
        n4 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        for (int i = 0; i < n6; ++i) {
            for (int j = 0; j < n5; ++j) {
                n4 = j + n5 * i;
                if (n4 >= n) {
                    return;
                }
                for (int k = 1; k <= n2; ++k) {
                    n9 = j + k;
                    if ((n9 < n5 || bl) && ((n8 = n9 % n5 + n5 * i) < n || bl)) {
                        this.addEdge(n4, n8 % n);
                    }
                    if ((n10 = i + k) >= n6 && !bl || (n8 = j + n5 * (n10 % n6)) >= n && !bl) continue;
                    this.addEdge(n4, n8 % n);
                }
            }
        }
    }

    public void setNetworkSquareLatticeOLD(int n, int n2, int n3, boolean bl) {
        int n4;
        if (n > this.maximumVertices) {
            this.maximumVertices = n;
        }
        int n5 = (n - 1) / n3 + 1;
        int n6 = n * n2 * 4;
        if (this.maximumStubs < n6) {
            this.maximumStubs = n6;
        }
        this.setNetwork();
        for (n4 = 0; n4 < n; ++n4) {
            this.addVertex();
        }
        n4 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n3; ++j) {
                n4 = j + i * n3;
                if (n4 > n) continue;
                for (int k = 1; k <= n2; ++k) {
                    n8 = j + k;
                    if ((n8 < n3 || bl) && ((n7 = n8 % n3 + i * n3) < n || bl)) {
                        this.addEdge(n4, n7 % n);
                    }
                    if ((n7 = j + (i + k) * n3) >= n && !bl) continue;
                    this.addEdge(n4, n7 % n);
                }
            }
        }
    }

    public void setNetworkCubicLattice(boolean bl) {
        int n = this.initialXsize;
        int n2 = this.initialYsize;
        if (n < 1) {
            n = (int)(0.5 + Math.pow(this.initialVertices, 0.3333333333333));
        }
        if (n2 < 1) {
            n2 = n;
        }
        if (this.initialXsize < 0) {
            n = (int)(0.5 + Math.pow(this.initialVertices, 0.3333333333333));
        }
        this.setNetworkCubicLattice(this.initialVertices, this.initialConnectivity, n, n2, bl);
    }

    public void setNetworkCubicLattice(int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        int n6;
        int n7;
        int n8;
        if (n > this.maximumVertices) {
            this.maximumVertices = n;
        }
        if ((n8 = (n7 = n3) * (n6 = n4)) > n) {
            n6 = n7 = (int)Math.sqrt(n);
            n8 = n7 * n6;
        }
        int n9 = (n - 1) / n8 + 1;
        int n10 = n * n2 * 4;
        if (this.maximumStubs < n10) {
            this.maximumStubs = n10;
        }
        this.setNetwork();
        for (n5 = 0; n5 < n; ++n5) {
            this.addVertex();
        }
        n5 = -1;
        int n11 = -1;
        int n12 = -1;
        int n13 = -1;
        int n14 = -1;
        for (int i = 0; i < n9; ++i) {
            for (int j = 0; j < n6; ++j) {
                for (int k = 0; k < n7; ++k) {
                    n5 = k + n7 * (j + i * n6);
                    if (n5 >= n) {
                        return;
                    }
                    for (int i2 = 1; i2 <= n2; ++i2) {
                        n12 = k + i2;
                        if ((n12 < n7 || bl) && ((n11 = n12 % n7 + n7 * (j + i * n6)) < n || bl)) {
                            this.addEdge(n5, n11 % n);
                        }
                        if (((n13 = j + i2) < n6 || bl) && ((n11 = k + n7 * (n13 % n6 + i * n6)) < n || bl)) {
                            this.addEdge(n5, n11 % n);
                        }
                        if ((n14 = i + i2) >= n9 && !bl || (n11 = k + n7 * (j + n14 % n9 * n6)) >= n && !bl) continue;
                        this.addEdge(n5, n11 % n);
                    }
                }
            }
        }
    }

    public void setNetworkCaveManLine(boolean bl) {
        this.setNetworkCaveManLine(this.initialVertices, this.initialXsize, this.initialConnectivity, bl);
    }

    public void setNetworkCaveManCommonVertex(boolean bl) {
        this.setNetworkCaveManLine(this.initialVertices, this.initialXsize, this.initialConnectivity, bl);
    }

    public void setNetworkCaveManLine(int n, int n2, int n3, boolean bl) {
        int n4;
        if (n > this.maximumVertices) {
            this.maximumVertices = n;
        }
        int n5 = n / n2;
        n = n2 * n5;
        int n6 = (n5 * (n5 - 1) + 2 * n3) * n2;
        if (this.maximumStubs < n6) {
            this.maximumStubs = n6;
        }
        this.setNetwork();
        for (n4 = 0; n4 < n; ++n4) {
            this.addVertex();
        }
        n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n7;
            int n8;
            n4 = i * n5;
            for (n8 = 0; n8 < n5; ++n8) {
                for (n7 = n8 + 1; n7 < n5; ++n7) {
                    if (n8 == n7) continue;
                    this.addEdge(n4 + n8, n4 + n7);
                }
            }
            n8 = -1;
            for (n7 = 1; n7 <= n3; ++n7) {
                n8 = (i + n7) * n5 + this.Rnd.nextInt(n5);
                if (n8 >= n && !bl) continue;
                this.addEdge(n4 + this.Rnd.nextInt(n5), n8 %= n);
            }
        }
    }

    public void setNetworkCaveManCommonVertex(int n, int n2, int n3, boolean bl) {
        int n4;
        if (n > this.maximumVertices) {
            this.maximumVertices = n;
        }
        int n5 = n / n2;
        n = n2 * n5 + (bl ? 0 : 1);
        int n6 = n5 * (n5 + 1) * n2;
        if (this.maximumStubs < n6) {
            this.maximumStubs = n6;
        }
        this.setNetwork();
        for (n4 = 0; n4 < n; ++n4) {
            this.addVertex();
        }
        n4 = 0;
        int n7 = 0;
        int n8 = 0;
        for (int i = 0; i < n2; ++i) {
            n4 = i * n5;
            int n9 = n4 + n5 + this.Rnd.nextInt(n5);
            if (bl) {
                n9 %= n;
            } else if (i >= n) {
                n9 = n - 1;
            }
            for (int j = 0; j <= n5; ++j) {
                int n10 = 0;
                while (n10 < n3) {
                    n7 = this.Rnd.nextInt(n5 + 1);
                    if (n7 == n5) {
                        n7 = n9;
                    }
                    n8 = (n4 + n7) % n;
                    this.addEdge(n4 + j, n8);
                    ++n6;
                }
            }
        }
    }

    public timgraph projectSubgraph(String string, TreeSet<Integer> treeSet, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Object object;
        int n = 0;
        Object object2 = treeSet.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            n += this.getVertexDegree((Integer)object);
        }
        if (this.directedGraph) {
            n += n;
        }
        if (((String)(object2 = string)).length() == 0) {
            object2 = "proj";
        }
        object = new timgraph(this.outputName.getNameRoot() + (String)object2, this.outputName.getDirectoryRoot(), this.infoLevel, this.outputControl.getNumber(), bl, bl2, bl3, bl4, treeSet.size(), n);
        VertexLabel vertexLabel = new VertexLabel();
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        for (Integer n2 : treeSet) {
            treeMap.put(n2, ((timgraph)object).TotalNumberVertices);
            if (this.infoLevel > 1) {
                System.out.println("old=" + n2 + "  new=" + ((timgraph)object).TotalNumberVertices);
            }
            if (bl2) {
                if (this.vertexlabels) {
                    vertexLabel = new VertexLabel(this.vertexLabelList[n2]);
                }
                vertexLabel.setNumber(n2);
                ((timgraph)object).addVertex(vertexLabel);
                continue;
            }
            ((timgraph)object).addVertex();
        }
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        for (int i = 0; i < this.TotalNumberStubs; ++i) {
            n3 = this.stubSourceList[i];
            n4 = this.stubSourceList[++i];
            if (!treeSet.contains(n3) || !treeSet.contains(n4)) continue;
            n5 = (Integer)treeMap.get(n3);
            n6 = (Integer)treeMap.get(n4);
            if (this.infoLevel > 1) {
                System.out.println("old=" + n3 + " " + n4 + "   new=" + n5 + " " + n6);
            }
            if (bl3) {
                if (this.weightedEdges) {
                    ((timgraph)object).addEdge(n5, n6, this.edgeValuetList[i]);
                    continue;
                }
                ((timgraph)object).addEdge(n5, n6, new EdgeValue());
                continue;
            }
            ((timgraph)object).addEdge(n5, n6);
        }
        return object;
    }

    void setBiPartite(int n, int n2, String string, String string2, int n3) {
        int n4;
        this.bipartiteGraph = true;
        this.numberVertexType1 = n;
        this.numberVertexType2 = n2;
        this.initialVertices = n + n2;
        int n5 = this.initialVertices + this.numevents;
        this.vertexList = new IntArrayList[n5];
        this.TotalNumberVertices = 0;
        this.stubSourceList = new int[this.maximumStubs];
        this.TotalNumberStubs = 0;
        for (n4 = 0; n4 < this.initialVertices; ++n4) {
            this.addVertex();
        }
        for (int i = 0; i < n; ++i) {
            int n6;
            switch (n3) {
                case 1: {
                    n4 = i;
                    n6 = this.Rnd.nextInt(n2) + n;
                }
            }
            n4 = i;
            n6 = n + i % n2;
            this.addEdge(n4, n6);
        }
        if (this.numberVertexType1 + this.numberVertexType2 != this.TotalNumberVertices) {
            System.out.println("*** ERROR in setBiPartite: \n                 number of type1 + type 2 vertices  != TotalNumberVertices " + this.initialVertices + SEP + this.TotalNumberVertices);
        }
    }

    public timgraph makeIncidenceGraph() {
        return this.makeIncidenceGraph(this.directedGraph, this.vertexlabels, this.weightedEdges, this.vertexEdgeListOn);
    }

    public timgraph makeIncidenceGraph(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n;
        timgraph timgraph2 = new timgraph(this.inputName.getNameRoot() + "Inc", this.inputName.getDirectoryRoot(), this.infoLevel, this.outputControl.getNumber());
        timgraph2.setGraphProperties(bl, bl2, bl3, bl4);
        int n2 = this.TotalNumberVertices;
        int n3 = this.TotalNumberStubs / 2;
        int n4 = n2 + n3;
        int n5 = this.TotalNumberStubs * 2;
        if (this.infoLevel > 0) {
            System.out.println("#Type 1 =" + n2 + ", #Type 2 =" + n3 + ",  #stubs =" + n5);
        }
        timgraph2.setBipartite(n2, n3, "OldVertices", "OldEdges");
        timgraph2.setNetwork(n4, n5);
        for (n = 0; n < n2; ++n) {
            if (timgraph2.vertexlabels) {
                if (this.isVertexLabelled()) {
                    timgraph2.addVertex(this.vertexLabelList[n]);
                    continue;
                }
                timgraph2.addVertex("v" + n, n);
                continue;
            }
            this.addVertex();
        }
        for (n = 0; n < n3; ++n) {
            if (timgraph2.vertexlabels) {
                timgraph2.addVertex("e" + n * 2);
                continue;
            }
            timgraph2.addVertex();
        }
        if (timgraph2.isWeighted()) {
            System.err.println("*** incidence graph not yet designed for weighted graphs, weighting switched off");
            timgraph2.setWeightedEdges(false);
        }
        n = -1;
        int n6 = -1;
        int n7 = -1;
        for (int i = 0; i < this.TotalNumberStubs; ++i) {
            n = this.stubSourceList[i++];
            n6 = this.stubSourceList[i];
            n7 = n2 + i / 2;
            if (this.infoLevel > 0) {
                System.out.println("Old edge " + n + " " + n6 + ", adding to new edge vertex " + n7);
            }
            timgraph2.addEdge(n, n7);
            timgraph2.addEdge(n6, n7);
        }
        return timgraph2;
    }

    public timgraph makeLineGraph(int n, boolean bl) {
        int n2;
        int n3;
        if (!this.isVertexEdgeListOn()) {
            throw new RuntimeException("*** makeLineGraph needs vertexEdgeList to be on.");
        }
        if (this.isWeighted()) {
            throw new RuntimeException("*** makeLineGraph does not yet consider weights.");
        }
        int n4 = 0;
        if (n > 0 && n < LineGraphProjector.lgExtensionList.length) {
            n4 = n;
        }
        timgraph timgraph2 = new timgraph();
        timgraph2.infoLevel = this.infoLevel;
        timgraph2.setVertexEdgeList(true);
        timgraph2.directedGraph = this.directedGraph;
        if (bl) {
            timgraph2.directedGraph = false;
        }
        timgraph2.weightedEdges = n4 >= 2;
        timgraph2.vertexlabels = false;
        timgraph2.inputName = new FileNameSequence(this.inputName);
        timgraph2.outputName = new FileNameSequence(this.outputName);
        timgraph2.inputName.appendToNameRoot(LineGraphProjector.lgExtensionList[n4]);
        timgraph2.outputName.appendToNameRoot(LineGraphProjector.lgExtensionList[n4]);
        int n5 = 1;
        int n6 = -1;
        if (n4 == 1 || n4 == 3) {
            n6 = 1;
            n5 = 0;
        }
        timgraph2.maximumVertices = this.getNumberStubs() / 2;
        timgraph2.maximumStubs = 0;
        if (timgraph2.directedGraph) {
            for (n3 = 0; n3 < this.getNumberVertices(); ++n3) {
                timgraph2.maximumStubs += this.getVertexInDegree(n3) * this.getVertexOutDegree(n3);
            }
            timgraph2.maximumStubs *= 2;
        } else {
            for (n3 = 0; n3 < this.getNumberVertices(); ++n3) {
                n2 = this.getVertexDegree(n3);
                timgraph2.maximumStubs += n2 * (n2 + n6);
            }
        }
        if (this.infoLevel > -1) {
            System.out.println("Predicting " + timgraph2.maximumVertices + " vertices and " + timgraph2.maximumStubs + " edges in line graph ");
        }
        timgraph2.setNetwork();
        for (n3 = 0; n3 < timgraph2.maximumVertices; ++n3) {
            timgraph2.addVertex();
        }
        n3 = -1;
        n2 = -1;
        double d = 1.0;
        if (this.isDirected()) {
            int n7 = -1;
            int n8 = -1;
            for (int i = 0; i < this.getNumberVertices(); ++i) {
                n7 = this.getVertexDegree(i);
                if (n7 < 1 || (n8 = this.getVertexDegree(i)) < 1) continue;
                if (timgraph2.weightedEdges) {
                    d = 1.0 / (double)n8;
                }
                for (int j = 0; j < this.vertexInEdgeList[i].size(); ++j) {
                    n3 = this.vertexInEdgeList[i].get(j);
                    for (int k = 0; k < this.vertexEdgeList[i].size(); ++k) {
                        n2 = this.vertexEdgeList[i].get(k);
                        if (timgraph2.weightedEdges) {
                            timgraph2.increaseEdgeWeight(n3 / 2, n2 / 2, d);
                            continue;
                        }
                        timgraph2.addEdgeUnique(n3 / 2, n2 / 2);
                    }
                }
            }
        } else {
            int n9 = -1;
            for (int i = 0; i < this.getNumberVertices(); ++i) {
                n9 = this.getVertexDegree(i);
                if (n9 <= n5) continue;
                if (timgraph2.weightedEdges) {
                    d = 1.0 / (double)(n9 - n5);
                }
                for (int j = 0; j < this.vertexEdgeList[i].size(); ++j) {
                    n3 = this.vertexEdgeList[i].get(j);
                    for (int k = j + n5; k < this.vertexEdgeList[i].size(); ++k) {
                        n2 = this.vertexEdgeList[i].get(k);
                        if (timgraph2.weightedEdges) {
                            timgraph2.increaseEdgeWeight(n3 / 2, n2 / 2, d);
                            continue;
                        }
                        timgraph2.addEdgeUnique(n3 / 2, n2 / 2);
                    }
                }
            }
        }
        return timgraph2;
    }

    public timgraph makeConsolidated(double d, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n;
        timgraph timgraph2 = new timgraph();
        timgraph2.infoLevel = this.infoLevel;
        timgraph2.setVertexEdgeList(bl4);
        timgraph2.directedGraph = this.directedGraph;
        if (bl) {
            timgraph2.directedGraph = false;
        }
        timgraph2.weightedEdges = true;
        timgraph2.vertexlabels = bl2;
        timgraph2.inputName = new FileNameSequence(this.inputName);
        timgraph2.outputName = new FileNameSequence(this.outputName);
        timgraph2.maximumVertices = this.TotalNumberVertices;
        timgraph2.maximumStubs = this.TotalNumberStubs;
        timgraph2.setNetwork();
        for (n = 0; n < timgraph2.maximumVertices; ++n) {
            if (timgraph2.vertexlabels) {
                if (this.isVertexLabelled()) {
                    timgraph2.addVertex(this.vertexLabelList[n]);
                    continue;
                }
                timgraph2.addVertex("v" + n, n);
                continue;
            }
            timgraph2.addVertex();
        }
        n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        double d2 = -1.0;
        for (int i = 0; i < this.TotalNumberStubs; ++i) {
            d2 = this.weightedEdges ? this.edgeValuetList[i].weight : 1.0;
            n = this.stubSourceList[i++];
            n2 = this.stubSourceList[i];
            if (bl && n > n2) {
                timgraph2.increaseEdgeWeight(n2, n, d2);
                continue;
            }
            timgraph2.increaseEdgeWeight(n, n2, d2);
        }
        if (bl3) {
            return timgraph2;
        }
        return timgraph2.makeUnweighted(d, bl, bl2, bl4);
    }

    public timgraph makeUnweighted(double d, boolean bl, boolean bl2, boolean bl3) {
        int n;
        if (!this.weightedEdges) {
            System.err.println("*** timgraph makeUnweighted graph needs original to be weighted.");
            return null;
        }
        timgraph timgraph2 = new timgraph();
        timgraph2.infoLevel = this.infoLevel;
        timgraph2.setVertexEdgeList(bl3);
        timgraph2.directedGraph = this.directedGraph;
        if (bl) {
            timgraph2.directedGraph = false;
        }
        timgraph2.weightedEdges = false;
        timgraph2.vertexlabels = bl2;
        timgraph2.inputName = new FileNameSequence(this.inputName);
        timgraph2.outputName = new FileNameSequence(this.outputName);
        timgraph2.maximumVertices = this.TotalNumberVertices;
        timgraph2.maximumStubs = 0;
        for (n = 0; n < this.TotalNumberStubs; ++n) {
            if (!(this.edgeValuetList[n].weight >= d)) continue;
            ++timgraph2.maximumStubs;
        }
        if (this.infoLevel > -1) {
            System.out.println("Predicting " + timgraph2.maximumStubs + " edges in weight cut graph");
        }
        timgraph2.setNetwork();
        for (n = 0; n < timgraph2.maximumVertices; ++n) {
            if (timgraph2.vertexlabels) {
                if (this.isVertexLabelled()) {
                    timgraph2.addVertex(this.vertexLabelList[n]);
                    continue;
                }
                timgraph2.addVertex("v" + n, n);
                continue;
            }
            timgraph2.addVertex();
        }
        n = -1;
        int n2 = -1;
        for (int i = 0; i < this.TotalNumberStubs; ++i) {
            if (this.edgeValuetList[i].weight < d) {
                ++i;
                continue;
            }
            n = this.stubSourceList[i++];
            if (this.edgeValuetList[i].weight < d) continue;
            n2 = this.stubSourceList[i];
            timgraph2.addEdgeUnweighted(n, n2);
        }
        return timgraph2;
    }

    public void makeUnlabelled() {
        this.vertexlabels = false;
        this.vertexLabelList = null;
    }

    public void makeLabelsUnnamed() {
        if (!this.vertexlabels) {
            return;
        }
        for (int i = 0; i < this.maximumVertices; ++i) {
            this.vertexLabelList[i].removeName();
        }
    }

    public timgraph makeRing(String string, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n2 = this.getVertexFromName(string);
        TreeSet<Integer> treeSet = this.getRing(n2, n);
        if (this.infoLevel > 0) {
            System.out.println("Component of " + this.inputName.getNameRoot() + " centred on vertex " + string + " number " + n2 + " upto distance " + n + " found " + treeSet.size() + " vertices");
        }
        timgraph timgraph2 = this.projectSubgraph("Ring", treeSet, bl, bl3, bl2, bl4);
        return timgraph2;
    }

    public timgraph makeEdgeSubGraph(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (!this.vertexlabels) {
            throw new IllegalArgumentException("graph with labelled vertices needed to make a ring.");
        }
        int n = this.getVertexFromName(string);
        HashMap<Integer, Integer> hashMap = this.getEdgeLabelMap(n);
        int n2 = hashMap.size();
        TreeSet<Integer> treeSet = this.getEdgeSubGraph(hashMap.keySet());
        if (this.infoLevel > 0) {
            System.out.println("Component of " + this.inputName.getNameRoot() + " centred on vertex " + string + " number " + n + " had " + n2 + " different incident edge labels making subset of " + treeSet.size() + " vertices");
        }
        timgraph timgraph2 = this.projectSubgraph("proj", treeSet, bl, bl3, bl2, bl4);
        timgraph2.setNameRoot(timgraph2.inputName.getNameRoot() + "_" + string + "ESG");
        return timgraph2;
    }

    public HashMap<Integer, Integer> getEdgeLabelMap(int n) {
        if (!this.vertexEdgeListOn) {
            throw new IllegalArgumentException("graph with vertex edge list needed in getEdgeLabelMap.");
        }
        if (!this.weightedEdges) {
            throw new IllegalArgumentException("graph with labelled edges needed in getEdgeLabelMap.");
        }
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n2 = 0;
        for (int i = 0; i < this.getVertexDegree(n); ++i) {
            int n3 = this.vertexEdgeList[n].getQuick(i);
            int n4 = this.edgeValuetList[n3].label;
            if (hashMap.containsKey(n4)) continue;
            hashMap.put(n4, n2++);
        }
        return hashMap;
    }

    public TreeSet<Integer> getEdgeLabelSet() {
        if (!this.vertexEdgeListOn) {
            throw new IllegalArgumentException("graph with vertex edge list needed in getEdgeLabelSet.");
        }
        if (!this.weightedEdges) {
            throw new IllegalArgumentException("graph with labelled edges needed in getEdgeLabelSet.");
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        boolean bl = false;
        for (int i = 0; i < this.TotalNumberStubs; i += 2) {
            treeSet.add(this.edgeValuetList[i].label);
        }
        return treeSet;
    }

    public void relabelEdges(Map<Integer, Integer> map, int n) {
        for (int i = 0; i < this.TotalNumberStubs; i += 2) {
            int n2 = this.edgeValuetList[i].label;
            Integer n3 = map.get(n2);
            if (n3 == null) {
                n3 = n;
            }
            this.edgeValuetList[i].label = n3;
        }
    }

    public int relabelEdges(String string) {
        int n = this.getVertexFromName(string);
        HashMap<Integer, Integer> hashMap = this.getEdgeLabelMap(n);
        this.relabelEdges(hashMap, hashMap.size());
        return hashMap.size();
    }

    public timgraph makeEdgeLabelToVertexSubGraph(double d, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        if (!this.weightedEdges) {
            throw new IllegalArgumentException("graph with weighted edges needed to make a vertex set  sub graph based on edge communities.");
        }
        if (!this.vertexEdgeListOn) {
            throw new IllegalArgumentException("graph with vertexEdgeList needed to make a vertex set  sub graph based on edge communities.");
        }
        TreeSet<Integer> treeSet = this.edgeLabelToVertexSet(d, bl, bl2);
        timgraph timgraph2 = this.projectSubgraph("proj", treeSet, bl3, bl5, bl4, bl6);
        timgraph2.setNameRoot(timgraph2.inputName.getNameRoot() + "_" + "EPTOVPSG");
        return timgraph2;
    }

    private int edgeToVertexLabel(int n, double d, boolean bl, boolean bl2) {
        int n2;
        double d2;
        int n3;
        int n4 = this.getVertexDegree(n);
        DoubleArrayList doubleArrayList = new DoubleArrayList(n4);
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        IntArrayList intArrayList = new IntArrayList(n4);
        IntArrayList intArrayList2 = this.vertexEdgeList[n];
        double d3 = 0.0;
        for (n3 = 0; n3 < intArrayList2.size(); ++n3) {
            int n5 = intArrayList2.getQuick(n3);
            int n6 = this.edgeValuetList[n5].label;
            d2 = bl2 ? this.edgeValuetList[n5].weight : 1.0;
            d3 += d2;
            if (treeMap.containsKey(n6)) {
                n2 = (Integer)treeMap.get(n6);
                doubleArrayList.setQuick(n2, doubleArrayList.getQuick(n2) + d2);
                continue;
            }
            treeMap.put(n6, doubleArrayList.size());
            intArrayList.add(n6);
            doubleArrayList.add(d2);
        }
        if (d3 < 1.0E-6) {
            return -789456123;
        }
        n3 = -789456123;
        if (!bl) {
            d3 = 1.0;
        }
        double d4 = d * d3;
        d2 = n4;
        for (n2 = 0; n2 < intArrayList.size(); ++n2) {
            int n7 = intArrayList.get(n2);
            double d5 = doubleArrayList.getQuick(n2);
            if (d4 > d5 || d4 == d5 && this.Rnd.nextDouble() < 0.5) continue;
            d4 = d5;
            n3 = n7;
        }
        return n3;
    }

    public TreeSet<Integer> edgeLabelToVertexSet(double d, boolean bl, boolean bl2) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int i = 0; i < this.TotalNumberVertices; ++i) {
            int n = this.edgeToVertexLabel(i, d, bl, bl2);
            if (n < 0) continue;
            treeSet.add(i);
        }
        return treeSet;
    }

    public int getRandomBinomial(double d, int n) {
        if (n < 1) {
            return (int)(d + 1.0E-6);
        }
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d2 += this.Rnd.nextDouble();
        }
        return (int)(d2 * d / (double)n);
    }

    public int getRandomMarkov(double d, int n) {
        if (n < 0) {
            return -n;
        }
        int n2 = 0;
        for (n2 = 0; n2 < n && !(this.Rnd.nextDouble() > d); ++n2) {
        }
        return n2;
    }

    public double calcEllapsedTime(long l) {
        return 1000.0 * (double)(System.currentTimeMillis() - l);
    }

    public int makeEven(int n) {
        return n - (n | 1);
    }

    public class DegreeDistributionOLD {
        String name = "unspecified";
        IntArrayList ddarr;
        int minimum = 9999999;
        int maximum;
        int continuous = this.maximum = -1;
        int totalvertices = 0;
        int totaledges = 0;
        double average = 0.0;
        double secondmoment = 0.0;

        public DegreeDistributionOLD(String string) {
            this.ddarr = new IntArrayList();
            this.name = string;
        }

        public DegreeDistributionOLD(String string, int n) {
            this.ddarr = new IntArrayList(n);
            this.name = string;
        }

        void calcDegreeDistribution(IntArrayList[] intArrayListArray, int n) {
            this.maximum = -1;
            this.ddarr.add(0);
            for (int i = 0; i < n; ++i) {
                if (intArrayListArray[i] == null) {
                    this.ddarr.set(0, this.ddarr.get(0) + 1);
                    break;
                }
                int n2 = intArrayListArray[i].size();
                timgraph.this.addExtendIntArrayList(this.ddarr, n2, 1);
            }
            this.calcValues();
            if (this.totalvertices != n) {
                System.out.println("*** Error in calcDegreeDistribution vertex totals mismatch");
                System.out.println("     TNV=" + timgraph.this.TotalNumberVertices + ", calc = " + this.totalvertices);
            }
        }

        void calcDegreeDistribution(IntArrayList[] intArrayListArray, IntArrayList[] intArrayListArray2, int n) {
            this.maximum = -1;
            this.ddarr.add(0);
            int n2 = -1;
            for (int i = 0; i < n; ++i) {
                n2 = 0;
                if (intArrayListArray[i] != null) {
                    n2 = intArrayListArray[i].size();
                }
                if (intArrayListArray2[i] != null) {
                    n2 += intArrayListArray2[i].size();
                }
                timgraph.this.addExtendIntArrayList(this.ddarr, n2, 1);
            }
            this.calcValues();
            if (this.totalvertices != n) {
                System.out.println("*** Error in calcDegreeDistribution vertex totals mismatch");
                System.out.println("     TNV=" + timgraph.this.TotalNumberVertices + ", calc = " + this.totalvertices);
            }
        }

        void calcValues() {
            this.totalvertices = 0;
            this.totaledges = 0;
            int n = 0;
            double d = 0.0;
            this.continuous = this.maximum + 1;
            this.minimum = 0;
            while (this.ddarr.get(this.minimum) == 0) {
                ++this.minimum;
            }
            for (int i = this.minimum; i < this.ddarr.size(); ++i) {
                n = this.ddarr.get(i);
                this.totalvertices += n;
                this.totaledges += n * i;
                d += (double)(n * i * i);
                if (n == 0 && i < this.continuous) {
                    this.continuous = i;
                }
                if (n <= 0) continue;
                this.maximum = i;
            }
            this.average = (double)this.totaledges / (double)this.totalvertices;
            this.secondmoment = d / (double)this.totalvertices;
        }

        void printDegreeDistribution(String string, boolean bl) {
            this.outputDegreeDistribution(System.out, string, bl);
        }

        void FileOutputDegreeDistribution(String string, String string2, boolean bl) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                PrintStream printStream = new PrintStream(fileOutputStream);
                this.outputDegreeDistribution(printStream, string2, bl);
                if (timgraph.this.infoLevel > -2) {
                    System.out.println("Finished writing " + this.name + " degree distribution to " + string);
                }
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    System.out.println("File Error with " + string);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Error opening output file " + string);
                return;
            }
        }

        void outputDegreeDistribution(PrintStream printStream, String string, boolean bl) {
            double d = 0.0;
            int n = 0;
            printStream.println(string + " timgraph" + timgraph.SEP + "version " + timgraph.SEP + timgraph.VERSION + timgraph.SEP + " date " + timgraph.SEP + timgraph.this.date);
            this.outputInformation(printStream, string, 2);
            if (this.totalvertices < 1) {
                return;
            }
            if (bl) {
                printStream.println(string + " k " + timgraph.SEP + "p(k)    Normalised " + this.name + " Degree Distribution (not reduced = strength)");
            } else {
                printStream.println(string + " k " + timgraph.SEP + "n(k)     Unnormalised " + this.name + " Degree Distribution  (not reduced = strength)");
            }
            for (int i = 0; i < this.ddarr.size(); ++i) {
                if (bl) {
                    d = (double)this.ddarr.get(i) / (double)this.totalvertices;
                    if (!(d > 0.0)) continue;
                    printStream.println(i + timgraph.SEP + d);
                    continue;
                }
                n = (int)((double)this.ddarr.get(i) + 0.5);
                if (n <= 0) continue;
                printStream.println(i + timgraph.SEP + n);
            }
        }

        public void outputInformation(PrintStream printStream, String string, int n) {
            printStream.println(string + "Degree" + timgraph.SEP + "distribution" + timgraph.SEP + this.name);
            printStream.println(string + timgraph.SEP + "Total Vertices" + timgraph.SEP + this.totalvertices + timgraph.SEP + "Total Edges" + timgraph.SEP + this.totaledges);
            printStream.println(string + timgraph.SEP + "k_min" + timgraph.SEP + "k_cont" + timgraph.SEP + "k_max" + timgraph.SEP + "<k>" + timgraph.SEP + "<k^2>");
            printStream.println(string + timgraph.SEP + this.minimum + timgraph.SEP + this.continuous + timgraph.SEP + this.maximum + timgraph.SEP + NumbersToString.toString(this.average, n) + timgraph.SEP + NumbersToString.toString(this.secondmoment, n));
        }
    }

    public class StatQuant {
        double total = 0.0;
        double squaretotal = 0.0;
        int count = 0;
        double average = 0.0;
        double sigma = 0.0;
        double error = 0.0;
        double secondmoment = 0.0;

        public void add(double d) {
            this.total += d;
            this.squaretotal += d * d;
            ++this.count;
            this.average = this.total / (double)this.count;
            this.secondmoment = this.squaretotal / (double)this.count;
            if (this.count > 1) {
                this.sigma = (this.secondmoment - this.average * this.average) / Math.sqrt(this.count - 1);
                this.error = this.sigma / Math.sqrt(this.count);
            } else {
                this.sigma = 0.0;
                this.error = 0.0;
            }
        }
    }
}

