/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run;

import TimGraph.Community.Community;
import TimGraph.Community.QualitySparse;
import TimGraph.Community.QualityType;
import TimGraph.Community.VertexPartition;
import TimGraph.io.FileOutput;
import TimGraph.run.LineGraphCommunities;
import TimGraph.run.SetUpNetwork;
import TimGraph.timgraph;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class VertexCommunities {
    static final String SEP = "\t";
    static String basicroot = "UNSET";
    static timgraph tg;
    static int infoLevel;

    public VertexCommunities(timgraph timgraph2) {
        tg = timgraph2;
    }

    public static void usage(PrintStream printStream) {
        char c = timgraph.NOT_TIMGRAPH_ARGUMENT[0];
        printStream.println("VertexCommunities " + c + "<filename> " + c + "<method> " + c + "<lineGraphType> " + c + "<quality> " + c + "<lambda> -<timgraphArgument> ...");
        printStream.println("Arguments for this class start with any of " + timgraph.otherArguments(", ") + ", but " + c + " used for example here.");
        printStream.println("First " + c + " argument is the network number for the setup routine OR ? for this help");
        printStream.println("Second " + c + " argument is the method used to find communities, 0=Louvain/Greedy, 1= Simulated Annealing");
        printStream.println("Third " + c + " argument is definition of quality to use, 0=Q(A), 1=Q(A" + c + "A-A)");
        printStream.println("Fourth " + c + " argument is type of quality class to use, 0=basic (dense matrix), 1=sparse matrix, 2=minimal memory ");
        printStream.println("Fifth " + c + " argument is value of lambda, scaling parameter of null model.");
        printStream.println("Remaining arguments should start with a - and are parsed by <tt>timgraph</tt>.");
        SetUpNetwork.printNetworkTypes(printStream, "", "  ");
    }

    public static void main(String[] stringArray) {
        System.out.println("VertexCommunities Arguments :<networknumber> :<method> :<qualitydef> :<qualitytype> :<lambdaMin> :<lambdaMax> :<lambdaStep>");
        int n = 201;
        int n2 = 0;
        if (stringArray.length > n2) {
            if (timgraph.isOtherArgument(stringArray[n2])) {
                if (stringArray[n2].charAt(1) == '?') {
                    VertexCommunities.usage(System.out);
                    return;
                }
                n = Integer.parseInt(stringArray[n2].substring(1, stringArray[n2].length()));
            } else {
                n = 0;
            }
        }
        System.out.println("--- Using network  " + SetUpNetwork.typeString(n));
        int n3 = 0;
        if (stringArray.length > ++n2 && timgraph.isOtherArgument(stringArray[n2])) {
            n3 = Integer.parseInt(stringArray[n2].substring(1, stringArray[n2].length()));
        }
        System.out.println("--- Using community method " + LineGraphCommunities.COMMUNITYMETHOD[n3]);
        int n4 = 0;
        if (stringArray.length > ++n2 && timgraph.isOtherArgument(stringArray[n2])) {
            n4 = Integer.parseInt(stringArray[n2].substring(1, stringArray[n2].length()));
        }
        System.out.println("--- Quality definition used " + QualitySparse.QdefinitionString[n4]);
        int n5 = 1;
        if (stringArray.length > ++n2 && timgraph.isOtherArgument(stringArray[n2])) {
            n5 = Integer.parseInt(stringArray[n2].substring(1, stringArray[n2].length()));
        }
        System.out.println("--- Quality class type " + QualityType.qualityLongName[n5]);
        double d = 1.0;
        if (stringArray.length > ++n2 && timgraph.isOtherArgument(stringArray[n2])) {
            d = Double.parseDouble(stringArray[n2].substring(1, stringArray[n2].length()));
        }
        double d2 = d + 1.0;
        if (stringArray.length > ++n2 && timgraph.isOtherArgument(stringArray[n2])) {
            d2 = Double.parseDouble(stringArray[n2].substring(1, stringArray[n2].length()));
        }
        double d3 = 0.001;
        double d4 = d2 - d;
        if (stringArray.length > ++n2 && timgraph.isOtherArgument(stringArray[n2])) {
            d4 = Double.parseDouble(stringArray[n2].substring(1, stringArray[n2].length()));
        }
        if (Math.abs(d4) < d3) {
            throw new RuntimeException("Step size must be greater than " + d3 + " in magnitude");
        }
        System.out.println("--- Modularity null model scaling lambda min, max step =" + d + "  " + d2 + "  " + d4);
        SetUpNetwork setUpNetwork = new SetUpNetwork(infoLevel);
        tg = SetUpNetwork.setUpNetwork(n, stringArray);
        tg.calcStrength();
        FileOutput fileOutput = new FileOutput(tg);
        fileOutput.fileName.setNameEnd("lambda_" + d + "_" + d2 + "_" + d4 + ".dat");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(fileOutput.fileName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            Community community = new Community(tg, n4, d, n5, infoLevel);
            printStream.println("name\t" + community.informationNumbersLabel("", SEP));
            boolean bl = false;
            for (double d5 = d; d5 <= d2 && !(d5 <= 0.0); d5 += d4) {
                System.out.println("-------------------------------------------------------");
                VertexPartition vertexPartition = VertexCommunities.calculateVertexPartition(tg, n4, n5, d5, n3, infoLevel, bl);
                printStream.println(vertexPartition.getName() + SEP + vertexPartition.informationNumbers("", SEP));
            }
            if (infoLevel > -2) {
                System.out.println("Finished writing VP various lambda information file to " + fileOutput.fileName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + fileOutput.fileName.getFullFileName() + ", " + fileNotFoundException.getMessage());
            return;
        }
    }

    public static VertexPartition calculateVertexPartition(timgraph timgraph2, int n, int n2, double d, int n3, int n4, boolean bl) {
        FileOutput fileOutput = new FileOutput(timgraph2);
        VertexPartition vertexPartition = VertexPartition.calculate(timgraph2, n, n2, d, n3, n4);
        timgraph2.setVertexNumbers(vertexPartition);
        fileOutput.informationPartition(vertexPartition, "", SEP, true);
        fileOutput.printPartitionStats(vertexPartition, "", SEP, true, true);
        fileOutput.printVertices("", SEP, false, true, vertexPartition, false);
        fileOutput.printVertices("", SEP, false, false, vertexPartition, true);
        fileOutput.informationGeneral("", SEP);
        if (timgraph2.outputControl.pajekFileOn) {
            fileOutput.pajekPartition(vertexPartition.getName() + ".clu", vertexPartition);
        }
        if (bl) {
            fileOutput.graphMLVertexPartition(vertexPartition);
        }
        timgraph timgraph3 = vertexPartition.getVertexPartitionGraph();
        fileOutput = new FileOutput(timgraph3);
        fileOutput.informationGeneral("", SEP);
        fileOutput.graphML();
        return vertexPartition;
    }

    static {
        infoLevel = 0;
    }
}

