/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run;

import TimGraph.run.Paper;
import TimUtilities.FileUtilities.FileNameSequence;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetOfPapers {
    TreeMap<String, Paper> paperMap = new TreeMap();
    int numberPapers = 0;
    int infoLevel = 0;

    public Collection<Paper> getPapers() {
        return this.paperMap.values();
    }

    public Paper getPaper(String string) {
        return this.paperMap.get(string);
    }

    public TreeSet<Integer> getAllUnitsUsed() {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (Paper paper : this.paperMap.values()) {
            treeSet.addAll(paper.getSections());
        }
        return treeSet;
    }

    public void addUnitsToPaper(String string, int n) {
        Paper paper = this.getPaper(string);
        if (paper == null) {
            paper = new Paper(this.numberPapers++, string, n);
            this.paperMap.put(string, paper);
        } else {
            paper.addSection(n);
        }
    }

    public void sortSections() {
        for (Paper paper : this.paperMap.values()) {
            paper.sortSections();
        }
    }

    public void print(PrintStream printStream, String string, boolean bl, boolean bl2) {
        Collection<Paper> collection = this.paperMap.values();
        if (bl) {
            printStream.println(Paper.toStringLabel(string) + (bl2 ? string + "sections" : ""));
        }
        for (Paper paper : collection) {
            printStream.println(paper.toString(string) + (bl2 ? string + paper.stringOfSections(string) : ""));
        }
    }

    public void outputPapers(FileNameSequence fileNameSequence, String string, boolean bl, boolean bl2) {
        fileNameSequence.setNameEnd("papers.dat");
        this.outputPapers(fileNameSequence.getFullFileName(), string, bl, bl2);
    }

    public void outputPapers(String string, String string2, boolean bl, boolean bl2) {
        if (this.infoLevel > -2) {
            System.out.println("Writing list of all known units to " + string);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.print(printStream, string2, bl, bl2);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing list of all known papers to " + string);
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("*** File Error with " + string + ", " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + string + ", " + fileNotFoundException.getMessage());
            return;
        }
    }

    public static void outputGRCList(FileNameSequence fileNameSequence, String string, Collection<Paper> collection, boolean bl, boolean bl2) {
        fileNameSequence.setNameEnd("grc.dat");
        SetOfPapers.outputGRCYList(fileNameSequence.getFullFileName(), string, collection, bl, false, bl2);
    }

    public static void outputGRCYList(FileNameSequence fileNameSequence, String string, Collection<Paper> collection, boolean bl, boolean bl2, boolean bl3) {
        fileNameSequence.setNameEnd("grc" + (bl2 ? "y" : "") + ".dat");
        SetOfPapers.outputGRCYList(fileNameSequence.getFullFileName(), string, collection, bl, bl2, bl3);
    }

    public void outputAllGRCYList(FileNameSequence fileNameSequence, String string, boolean bl, boolean bl2, boolean bl3) {
        fileNameSequence.setNameEnd("grc" + (bl2 ? "y" : "") + ".dat");
        SetOfPapers.outputGRCYList(fileNameSequence.getFullFileName(), string, this.paperMap.values(), bl, bl2, bl3);
    }

    public static void outputGRCYList(String string, String string2, Collection<Paper> collection, boolean bl, boolean bl2, boolean bl3) {
        if (bl3) {
            System.out.println("Writing gid-reference-citation" + (bl2 ? "-year" : "") + " list to " + string);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            if (bl) {
                printStream.println("gid" + string2 + "References" + string2 + "Citations" + (bl2 ? string2 + "year" : ""));
            }
            for (Paper paper : collection) {
                printStream.println(paper.gid + string2 + paper.getReferences() + string2 + paper.getCitations() + (bl2 ? string2 + paper.getYear() : ""));
            }
            if (bl3) {
                System.out.println("Finished gid-reference-citation" + (bl2 ? "-year" : "") + " list to " + string);
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("*** File Error with " + string + ", " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + string + ", " + fileNotFoundException.getMessage());
            return;
        }
    }

    public void makeGraphEdgeList(FileNameSequence fileNameSequence, String string, int n) {
        fileNameSequence.setNameEnd("inputBVNLS.dat");
        this.makeGraphEdgeList(fileNameSequence.getFullFileName(), string, n);
    }

    public void makeGraphEdgeList(String string, String string2, int n) {
        if (this.infoLevel > -2) {
            System.out.println("Writing bipartite vertex neighbour list of strings, paper-section, to " + string);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            for (Paper paper : this.paperMap.values()) {
                int n2 = paper.getNumberAuthors();
                if (n2 == 0) continue;
                printStream.println(paper.gid + string2 + paper.stringOfSections(string2, n));
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished bipartite vertex neighbour list of strings, paper-section, to " + string);
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("*** File Error with " + string + ", " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + string + ", " + fileNotFoundException.getMessage());
            return;
        }
    }
}

