/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Paper {
    public static final int UNSET = -912345687;
    int id = -912345687;
    String gid = "";
    int year = -912345687;
    String date = "";
    int ref = -912345687;
    int cite = -912345687;
    ArrayList<Integer> sectionNumber;

    public Paper(int n, String string) {
        this.id = n;
        this.gid = string;
        this.sectionNumber = new ArrayList();
    }

    public Paper(int n, String string, int n2) {
        this.id = n;
        this.gid = string;
        this.sectionNumber = new ArrayList();
        this.addSection(n2);
    }

    public void setReferences(int n) {
        this.ref = n;
    }

    public void setCitations(int n) {
        this.cite = n;
    }

    public void setYear(int n) {
        this.year = n;
    }

    public void setDate(String string) {
        this.date = string;
    }

    public int getReferences() {
        return this.ref;
    }

    public int getCitations() {
        return this.cite;
    }

    public int getYear() {
        return this.year;
    }

    public String getDate() {
        return this.date;
    }

    public int getNumberAuthors() {
        return this.sectionNumber.size();
    }

    public Collection<Integer> getSections() {
        return this.sectionNumber;
    }

    public void addSection(int n) {
        this.sectionNumber.add(n);
    }

    public void sortSections() {
        Collections.sort(this.sectionNumber);
    }

    public boolean isInSection(int n) {
        return this.sectionNumber.contains(n);
    }

    public String toString(String string) {
        return this.id + string + this.gid + string + this.year + string + this.date + string + this.getNumberAuthors() + string + this.cite + string + this.ref;
    }

    public static String toStringLabel(String string) {
        return "id" + string + "gid" + string + "year" + string + "date" + string + "no.authors" + string + "cite" + string + "ref";
    }

    public String stringOfSections(String string) {
        return this.stringOfSections(string, 1);
    }

    public String stringOfSections(String string, int n) {
        if (this.sectionNumber.size() == 0) {
            return "";
        }
        String string2 = "";
        for (Integer n2 : this.sectionNumber) {
            string2 = string2 + (string2.length() > 0 ? string : " ") + n2 / n;
        }
        return string2;
    }
}

