/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run;

import TimGraph.Community.VertexPartition;
import TimGraph.io.FileOutput;
import TimGraph.timgraph;
import TimUtilities.StringUtilities.Filters.StringFilter;

public class MakeVertexPartitionFromVertexPartition {
    static final String SEP = "\t";
    static String basicroot = "UNSET";
    static timgraph tg;
    static int infoLevel;

    public static void main(String[] stringArray) {
        System.out.println("MakeVertexCommunityFromVertexPartition Arguments :<VPfilename> :<VertexIndexColumn> :<PartitionIndexColumn> :<preGammaString> :graphMLOn :edgeWeightMinimum :vertexPositionFile");
        int n = 0;
        String string = "input/UKHEIiikpinvnslLouvainQS2000r0vertices.dat";
        if (stringArray.length > n && timgraph.isOtherArgument(stringArray[n])) {
            string = stringArray[n].substring(1, stringArray[n].length());
        }
        System.out.println("--- Vertex partition from file " + string);
        int n2 = 1;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            n2 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        System.out.println("--- Column with vertex index  " + n2);
        int n3 = 2;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            n3 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        System.out.println("--- Column with partition index  " + n3);
        boolean bl = false;
        int n4 = 2;
        String string2 = "LouvainQS";
        double d = -1.0;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            try {
                d = Double.parseDouble(stringArray[n].substring(1, stringArray[n].length()));
            }
            catch (RuntimeException runtimeException) {
                string2 = stringArray[n].substring(1, stringArray[n].length());
            }
        }
        if (d < 0.0) {
            int n5 = string.lastIndexOf(string2) + string2.length();
            int n6 = string.lastIndexOf(".dat");
            String string3 = string.substring(n5, n6);
            d = Double.parseDouble(string3);
            System.out.println("--- Modularity null model scaling gamma =" + d);
        } else {
            System.out.println("--- No modularity null model scaling gamma ");
        }
        boolean bl2 = true;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            bl2 = StringFilter.trueString(stringArray[n].charAt(1));
        }
        System.out.println("--- graphML output is " + StringFilter.onOffString(bl2));
        double d2 = -3.57986421E8;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            d2 = Double.parseDouble(stringArray[n].substring(1, stringArray[n].length()));
        }
        System.out.println("--- graphML output has minimum edge weight of  " + d2);
        String string4 = "UKHEIiikpinvnsl";
        String[] stringArray2 = new String[]{"-fin" + string4, "-fieinputELS.dat", "-o23", "-xi0"};
        if (stringArray.length > 0) {
            stringArray2 = stringArray;
        }
        tg = new timgraph();
        tg.parseParam(stringArray2);
        tg.setNameRoot(MakeVertexPartitionFromVertexPartition.tg.inputName.getNameRoot());
        System.out.println("Reading basic graph from file" + MakeVertexPartitionFromVertexPartition.tg.inputName.getFullFileName());
        int n7 = 1;
        int n8 = 2;
        boolean bl3 = false;
        boolean bl4 = false;
        int n9 = 1;
        tg.setNetworkFromInputFile(n7, n8, n9, bl3, bl4);
        tg.printParametersBasic();
        boolean bl5 = false;
        bl3 = false;
        if (string.endsWith("inputBVNLS.dat")) {
            bl3 = false;
            bl5 = true;
            n2 = 1;
            n3 = 2;
        }
        if (string.endsWith("vertices.dat")) {
            bl5 = false;
            bl3 = true;
            n2 = 1;
            n3 = 2;
        }
        boolean bl6 = false;
        MakeVertexPartitionFromVertexPartition.makePartition(tg, string, n2, n3, d2, bl5, bl2, bl3, bl6);
    }

    public static void makePartition(timgraph timgraph2, String string, int n, int n2, double d, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        FileOutput fileOutput;
        String string2 = timgraph2.inputName.getNameRoot();
        VertexPartition vertexPartition = new VertexPartition(timgraph2);
        String string3 = "VP";
        int n3 = -1;
        try {
            n3 = string.indexOf(string2);
            string3 = "VP" + string.substring(n3 + string2.length(), string.length() - 4);
        }
        catch (RuntimeException runtimeException) {
            string3 = "VP" + string;
        }
        vertexPartition.setName(string3);
        boolean bl5 = true;
        if (bl) {
            vertexPartition.readStringPartition(string, n, n2, bl3);
        } else {
            vertexPartition.readIntPartition(string, n, n2, bl3, bl5);
        }
        int n4 = vertexPartition.hasNegativeCommunityLabels();
        if (n4 >= 0) {
            System.err.println("*** Found negative partition label for " + vertexPartition.getNameOfElements() + " number " + n4);
        }
        boolean bl6 = true;
        bl3 = true;
        if (bl4) {
            fileOutput = new FileOutput(timgraph2.outputName);
            bl6 = true;
            bl3 = true;
            fileOutput.printPartitionStats(vertexPartition, SEP, SEP, bl6, bl3);
        }
        if (vertexPartition.getNumberElements() != timgraph2.getNumberVertices()) {
            throw new RuntimeException("vertex partition has " + vertexPartition.getNumberElements() + " elements which is not equal to number of vertices " + timgraph2.getNumberVertices());
        }
        timgraph2.setVertexNumbers(vertexPartition);
        fileOutput = new FileOutput(timgraph2);
        boolean bl7 = false;
        fileOutput.printVertices("", SEP, bl6, bl3, vertexPartition, bl7);
        boolean bl8 = true;
        bl3 = true;
        boolean bl9 = false;
        boolean bl10 = false;
        if (bl4) {
            fileOutput.printPartitionStats(vertexPartition, "", SEP, bl6, bl3);
        }
        if (bl2) {
            fileOutput.graphMLVertexPartition(vertexPartition);
        }
        if (bl2) {
            fileOutput.graphML(vertexPartition.getCommunityName(n3) + "B", d);
        }
        boolean bl11 = false;
    }

    static {
        infoLevel = 3;
    }
}

