/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run;

import TimGraph.Community.Community;
import TimGraph.Community.QualitySparse;
import TimGraph.Community.QualityType;
import TimGraph.Community.VertexPartition;
import TimGraph.io.FileOutput;
import TimGraph.run.LineGraphCommunities;
import TimGraph.timgraph;
import TimUtilities.StringUtilities.Filters.StringFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class MakeVertexPartition {
    static final String SEP = "\t";
    static String basicroot = "UNSET";
    static timgraph tg;
    static int infoLevel;

    public static void main(String[] stringArray) {
        System.out.println("MakeVertexCommunities Arguments :<method> :<qualitydef> :<qualitytype> :<gammaMin> :<gammaMax> :<gammaStep> :numberRuns :<graphMLOn>");
        int n = 0;
        int n2 = 0;
        if (stringArray.length > n && timgraph.isOtherArgument(stringArray[n])) {
            n2 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        System.out.println("--- Using community method " + LineGraphCommunities.COMMUNITYMETHOD[n2]);
        int n3 = 0;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            n3 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        System.out.println("--- Quality definition used " + QualitySparse.QdefinitionString[n3]);
        int n4 = 1;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            n4 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        System.out.println("--- Quality class type " + QualityType.qualityLongName[n4]);
        double d = 1.0;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            d = Double.parseDouble(stringArray[n].substring(1, stringArray[n].length()));
        }
        double d2 = d + 1.0;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            d2 = Double.parseDouble(stringArray[n].substring(1, stringArray[n].length()));
        }
        double d3 = 0.001;
        double d4 = d2 - d + 1.0;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            d4 = Double.parseDouble(stringArray[n].substring(1, stringArray[n].length()));
        }
        if (Math.abs(d4) < d3) {
            throw new RuntimeException("Step size must be greater than " + d3 + " in magnitude");
        }
        System.out.println("--- Modularity null model scaling gamma min, max step =" + d + "  " + d2 + "  " + d4);
        int n5 = 1;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            n5 = Math.max(1, Integer.parseInt(stringArray[n].substring(1, stringArray[n].length())));
        }
        System.out.println("--- Number of runs for each gamma value =" + n5);
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            bl2 = StringFilter.trueString(stringArray[n].charAt(1));
        }
        System.out.println("--- file output is " + StringFilter.onOffString(bl));
        System.out.println("--- graphML output is " + StringFilter.onOffString(bl2));
        System.out.println("--- projected graph output is " + StringFilter.onOffString(bl3));
        String string = "BowTieWD";
        String[] stringArray2 = new String[]{"-gvet", "-gdt", "-gewt", "-gvlt", "-gbf", "-fin" + string, "-fieinputELS.dat", "-gn99", "-e0", "-o23", "-xi0"};
        if (stringArray.length > 0) {
            stringArray2 = stringArray;
        }
        tg = new timgraph();
        tg.parseParam(stringArray2);
        if (!tg.isVertexEdgeListOn()) {
            System.err.println("\n *** Vertex Edge List NOT on and it is required, use -vgvet option ***\n");
        }
        tg.setNameRoot(MakeVertexPartition.tg.inputName.getNameRoot());
        tg.setNetworkFromInputFile();
        tg.printParametersBasic();
        tg.calcStrength();
        FileOutput fileOutput = new FileOutput(tg);
        String string2 = "_" + Math.round(1000.0 * d) + "_" + Math.round(1000.0 * d2) + "_" + Math.round(1000.0 * d4) + "_gamma.dat";
        fileOutput.fileName.setNameEnd(string2);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(fileOutput.fileName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            Community community = new Community(tg, n3, d, n4, infoLevel);
            printStream.println("name\t" + community.informationNumbersLabel("", SEP));
            for (double d5 = d; d5 <= d2 && !(d5 <= 0.0); d5 += d4) {
                System.out.println("\n--- gamma=" + String.format("%6.3f", d5) + " ----------------------------------------------------");
                for (int i = 0; i < n5; ++i) {
                    VertexPartition vertexPartition = MakeVertexPartition.calculateVertexPartition(tg, n3, n4, d5, n2, i, infoLevel, bl, bl2, bl3);
                    printStream.println(i + SEP + vertexPartition.getName() + SEP + vertexPartition.informationNumbers("", SEP));
                }
            }
            if (infoLevel > -2) {
                System.out.println("Finished writing VP various gamma information file to " + fileOutput.fileName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + fileOutput.fileName.getFullFileName() + ", " + fileNotFoundException.getMessage());
            return;
        }
    }

    public static VertexPartition calculateVertexPartition(timgraph timgraph2, int n, int n2, double d, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3) {
        FileOutput fileOutput;
        VertexPartition vertexPartition = VertexPartition.calculate(timgraph2, n, n2, d, n3, n5);
        if (n4 >= 0) {
            vertexPartition.setName(vertexPartition.getName() + "r" + n4);
        }
        timgraph2.setVertexNumbers(vertexPartition);
        if (!timgraph2.hasVertexPositions()) {
            timgraph2.setVertexPositionsFromPartition(vertexPartition, 30.0, 90.0);
        }
        if (bl) {
            fileOutput = new FileOutput(timgraph2);
            fileOutput.informationPartition(vertexPartition, "", SEP, true);
            fileOutput.printPartitionStats(vertexPartition, "", SEP, true, true);
            fileOutput.printVertices("", SEP, false, false, vertexPartition, true);
            fileOutput.printVertices("", SEP, false, true, vertexPartition, false);
            if (timgraph2.outputControl.pajekFileOn) {
                fileOutput.pajekPartition(vertexPartition.getName() + ".clu", vertexPartition);
            }
            if (bl2) {
                fileOutput.graphMLVertexPartition(vertexPartition);
            }
        }
        if (bl3) {
            fileOutput = new FileOutput(timgraph2);
            timgraph timgraph3 = vertexPartition.getVertexPartitionGraph();
            fileOutput = new FileOutput(timgraph3);
            fileOutput.informationGeneral("", SEP);
        }
        return vertexPartition;
    }

    static {
        infoLevel = 2;
    }
}

