/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run;

import TimGraph.Community.Community;
import TimGraph.Community.VertexCommunity;
import TimGraph.Community.VertexPartition;
import TimGraph.algorithms.Projections;
import TimGraph.io.FileInput;
import TimGraph.io.FileOutput;
import TimGraph.timgraph;
import TimUtilities.StringUtilities.Filters.StringFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeVertexCommunityFromCliqueGraph {
    static final String SEP = "\t";
    static String basicroot = "UNSET";
    static timgraph tg;
    static int infoLevel;

    public static void main(String[] stringArray) {
        System.out.println("MakeVertexCommunityFromCliquePartition Arguments :<RootName> :<CliqueGraphType> :<CliqueSize> :<gammaMin> :<gammaMax> :<gammaStep> :<GraphMLOn>");
        int n = -1;
        String string = "N17";
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            string = stringArray[n].substring(1, stringArray[n].length());
        }
        System.out.println("Core root of file names is " + string);
        int n2 = 2;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            n2 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        System.out.println("Clique type " + n2 + ", " + MakeVertexCommunityFromCliqueGraph.cliqueGraphTypeString(n2));
        int n3 = 3;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            n3 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        String string2 = "t" + n2 + "c" + n3;
        System.out.println("Clique size " + n3 + ", cgtype =" + string2);
        String string3 = string + "_" + string2;
        String string4 = string3 + "CG";
        System.out.println("--- Clique Graph from file with name root " + string4);
        String string5 = "input/" + string3 + "CIMinputEL.dat";
        System.out.println("--- Clique Incidence Matrix from file " + string5);
        boolean bl = false;
        int n4 = 0;
        int n5 = 2;
        double d = 0.25;
        double d2 = 2.0;
        double d3 = 0.25;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            d = Double.parseDouble(stringArray[n].substring(1, stringArray[n].length()));
        }
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            d2 = Double.parseDouble(stringArray[n].substring(1, stringArray[n].length()));
        }
        double d4 = 0.001;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            d3 = Double.parseDouble(stringArray[n].substring(1, stringArray[n].length()));
        }
        if (Math.abs(d3) < d4) {
            throw new RuntimeException("Step size must be greater than " + d4 + " in magnitude");
        }
        System.out.println("--- Modularity null model scaling gamma min, max, step = " + d + ", " + d2 + ", " + d3);
        boolean bl2 = true;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            bl2 = StringFilter.trueString(stringArray[n].charAt(1));
        }
        System.out.println("--- graphML output is " + StringFilter.onOffString(bl2));
        String string6 = string;
        String[] stringArray2 = new String[]{"-gvet", "-gdf", "-gewf", "-gvlt", "-gbf", "-fin" + string6, "-fieinputEL.dat", "-gn99", "-e0", "-o255", "-xi0"};
        tg = new timgraph();
        tg.parseParam(stringArray2);
        tg.setNameRoot(MakeVertexCommunityFromCliqueGraph.tg.inputName.getNameRoot());
        System.out.println("Reading basic graph from file" + MakeVertexCommunityFromCliqueGraph.tg.inputName.getFullFileName());
        int n6 = 1;
        int n7 = 2;
        boolean bl3 = false;
        boolean bl4 = false;
        int n8 = 1;
        tg.setNetworkFromInputFile(n6, n7, n8, bl3, bl4);
        tg.printParametersBasic();
        String string7 = "inputEL.dat";
        boolean bl5 = true;
        VertexCommunity vertexCommunity = MakeVertexCommunityFromCliqueGraph.makeCommunity(tg, string2, string4, string7, n2, n4, n5, d, d2, d3, string5, bl, bl2, bl5);
    }

    public static VertexCommunity makeCommunity(timgraph timgraph2, String string, String string2, String string3, int n, int n2, int n3, double d, double d2, double d3, String string4, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        boolean bl5;
        boolean bl6;
        int n4;
        int n5;
        boolean bl7 = false;
        ArrayList<Integer> arrayList = null;
        ArrayList<ArrayList<Integer>> arrayList2 = new ArrayList<ArrayList<Integer>>();
        ArrayList<ArrayList<Integer>> arrayList3 = new ArrayList<ArrayList<Integer>>();
        boolean bl8 = false;
        FileInput.readIntIndexNeighbourList(string4, arrayList, arrayList2, arrayList3, bl, bl8, infoLevel);
        System.out.println("Clique to Vertex matrix, size " + arrayList2.size());
        int n6 = arrayList2.size();
        if (n6 < 20) {
            int n7 = 0;
            for (ArrayList<Integer> arrayList4 : arrayList2) {
                System.out.print(n7++ + ": ");
                for (Integer n8 : arrayList4) {
                    System.out.print(n8 + " ");
                }
                System.out.println();
            }
        }
        timgraph timgraph3 = new timgraph();
        timgraph3.inputName.setFileName(timgraph2.inputName);
        timgraph3.setNameRoot(string2);
        timgraph3.setVertexEdgeList(true);
        int n9 = 1;
        int n10 = 2;
        int n11 = 3;
        if (n == 0 || n == 1) {
            n11 = -99;
        }
        if ((n5 = FileInput.processIntEdgeFile(timgraph3, n6, string3, n9, n10, n11, n4 = -99, bl6 = false, bl5 = false, bl4 = false)) <= 0) {
            throw new RuntimeException("FileInput.processIntEdgeFile returned maximum vertex index as " + n5);
        }
        String string5 = "";
        VertexCommunity vertexCommunity = new VertexCommunity(timgraph2);
        int n12 = arrayList2.get(0).size();
        System.out.println("Clique size is " + n12);
        double d4 = (double)n12 - 1.1;
        FileOutput fileOutput = new FileOutput(timgraph3);
        String string6 = "_" + Math.round(1000.0 * d) + "_" + Math.round(1000.0 * d2) + "_" + Math.round(1000.0 * d3) + "_gamma.dat";
        fileOutput.fileName.setNameEnd(string6);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(fileOutput.fileName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            Community community = new Community(timgraph2, n2, d, n3, infoLevel);
            printStream.println("gamma\t" + community.informationNumbersLabel("", SEP));
            if (bl3 && n == 4) {
                vertexCommunity = MakeVertexCommunityFromCliqueGraph.makeCliquePercolationCommunity(timgraph2, timgraph3, string, arrayList2, d4, bl2);
                printStream.println("PERC\t" + vertexCommunity.getName() + SEP + vertexCommunity.informationNumbers("", SEP));
                System.out.println("--- PERC, found " + vertexCommunity.getNumberCommunities() + " communities");
            }
            for (double d5 = d; d5 <= d2; d5 += d3) {
                string5 = "CP" + string + "l" + Math.round(d5 * 1000.0);
                vertexCommunity.setName(string5);
                vertexCommunity = MakeVertexCommunityFromCliqueGraph.makeLouvainCliqueCommunity(timgraph2, timgraph3, string, arrayList2, n2, n3, d5, bl2);
                System.out.println("--- gamma=" + d5 + ", found " + vertexCommunity.getNumberCommunities() + " communities");
                printStream.println(d5 + SEP + vertexCommunity.getName() + SEP + vertexCommunity.informationNumbers("", SEP));
            }
            if (infoLevel > -2) {
                System.out.println("Finished writing VP various gamma information file to " + fileOutput.fileName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + fileOutput.fileName.getFullFileName() + ", " + fileNotFoundException.getMessage());
            return null;
        }
        return vertexCommunity;
    }

    static VertexCommunity makeLouvainCliqueCommunity(timgraph timgraph2, timgraph timgraph3, String string, ArrayList<ArrayList<Integer>> arrayList, int n, int n2, double d, boolean bl) {
        VertexCommunity vertexCommunity = new VertexCommunity(timgraph2);
        int n3 = timgraph3.getNumberVertices();
        if (n3 != arrayList.size()) {
            throw new RuntimeException("Number of cliques not consistent " + timgraph3.getNumberVertices() + " != " + arrayList.size());
        }
        int n4 = 0;
        VertexPartition vertexPartition = VertexPartition.calculate(timgraph3, n, n2, d, n4, infoLevel);
        if (timgraph3.getNumberVertices() < 20) {
            vertexPartition.printVertices(System.out, " ", SEP, true, true);
        }
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = vertexPartition.getCommunity(i);
        }
        String string2 = "CP" + string + "l" + Math.round(d * 1000.0);
        vertexCommunity.setName(string2);
        boolean bl2 = true;
        boolean bl3 = true;
        vertexCommunity.setUp(timgraph2.getNumberVertices(), arrayList, nArray, bl2, bl3);
        MakeVertexCommunityFromCliqueGraph.printCliqueCommunity(timgraph2, string2, arrayList, nArray, vertexCommunity, bl);
        MakeVertexCommunityFromCliqueGraph.setEdgeLabelsFromCliqueCommunity(timgraph2, arrayList, nArray);
        MakeVertexCommunityFromCliqueGraph.setVertexNumbersFromCliqueCommunity(timgraph2, arrayList, nArray);
        if (bl) {
            FileOutput fileOutput = new FileOutput(timgraph2);
            double d2 = -3.57986421E8;
            fileOutput.graphML(string2, d2);
        }
        return vertexCommunity;
    }

    static void setEdgeLabelsFromCliqueCommunity(timgraph timgraph2, ArrayList<ArrayList<Integer>> arrayList, int[] nArray) {
        if (nArray.length != arrayList.size()) {
            throw new RuntimeException("Different numbers of communities in cliqueToCommunity and cliqueToVertex.size() " + nArray.length + ", " + arrayList.size());
        }
        timgraph2.setEdgeLabels(-1);
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        for (int i = 0; i < nArray.length; ++i) {
            int n5 = nArray[i] + 1;
            ArrayList<Integer> arrayList2 = arrayList.get(i);
            for (int j = 0; j < arrayList2.size(); ++j) {
                n = arrayList2.get(j);
                for (int k = j + 1; k < arrayList2.size(); ++k) {
                    n2 = arrayList2.get(k);
                    n3 = timgraph2.getFirstEdgeGlobal(n, n2);
                    if (n3 < 0) {
                        throw new RuntimeException("Looking at vertices " + n + " and " + n2 + ", the " + j + " and " + k + "  vertices of clique " + i);
                    }
                    n4 = timgraph2.getEdgeLabel(n3);
                    if (n4 < 0) {
                        timgraph2.setEdgeLabelQuick(n3, n5);
                        continue;
                    }
                    if (n4 == n5) continue;
                    timgraph2.setEdgeLabelQuick(n3, 0);
                }
            }
        }
    }

    static void setVertexNumbersFromCliqueCommunity(timgraph timgraph2, ArrayList<ArrayList<Integer>> arrayList, int[] nArray) {
        if (nArray.length != arrayList.size()) {
            throw new RuntimeException("Different numbers of communities in cliqueToCommunity and cliqueToVertex.size() " + nArray.length + ", " + arrayList.size());
        }
        timgraph2.setVertexNumbers(-1);
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i] + 1;
            ArrayList<Integer> arrayList2 = arrayList.get(i);
            for (int j = 0; j < arrayList2.size(); ++j) {
                n = arrayList2.get(j);
                n2 = timgraph2.getVertexNumber(n, -1);
                if (n2 < 0) {
                    timgraph2.setVertexNumberQuick(n, n3);
                    continue;
                }
                if (n2 == n3) continue;
                timgraph2.setVertexNumberQuick(n, 0);
            }
        }
    }

    static VertexCommunity makeCliquePercolationCommunity(timgraph timgraph2, timgraph timgraph3, String string, ArrayList<ArrayList<Integer>> arrayList, double d, boolean bl) {
        VertexCommunity vertexCommunity = new VertexCommunity(timgraph2);
        int n = timgraph3.getNumberVertices();
        if (n != arrayList.size()) {
            throw new RuntimeException("Number of cliques not consistent " + timgraph3.getNumberVertices() + " != " + arrayList.size());
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        timgraph timgraph4 = Projections.minimumEdgeWeight(timgraph3, d, bl2, bl3, bl4);
        timgraph4.calcComponents();
        boolean bl5 = true;
        boolean bl6 = true;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = timgraph4.getVertexComponentLabel(i);
        }
        String string2 = "CP" + string + "Perc";
        vertexCommunity.setName(string2);
        boolean bl7 = true;
        boolean bl8 = true;
        vertexCommunity.setUp(timgraph2.getNumberVertices(), arrayList, nArray, bl7, bl8);
        MakeVertexCommunityFromCliqueGraph.printCliqueCommunity(timgraph2, string2, arrayList, nArray, vertexCommunity, bl);
        MakeVertexCommunityFromCliqueGraph.setEdgeLabelsFromCliqueCommunity(timgraph2, arrayList, nArray);
        MakeVertexCommunityFromCliqueGraph.setVertexNumbersFromCliqueCommunity(timgraph2, arrayList, nArray);
        if (bl) {
            FileOutput fileOutput = new FileOutput(timgraph2);
            double d2 = -3.57986421E8;
            fileOutput.graphML(string2, d2);
        }
        return vertexCommunity;
    }

    static void printCliqueCommunity(timgraph timgraph2, String string, ArrayList<ArrayList<Integer>> arrayList, int[] nArray, VertexCommunity vertexCommunity, boolean bl) {
        String string2 = "";
        String string3 = SEP;
        String string4 = "_" + string + "CliqueList.dat";
        boolean bl2 = false;
        FileOutput fileOutput = new FileOutput(timgraph2);
        boolean bl3 = true;
        bl2 = true;
        fileOutput.printMotifs(string2, string3, string4, nArray, arrayList, bl3, bl2);
        string2 = "";
        string3 = SEP;
        bl2 = true;
        boolean bl4 = true;
        fileOutput.printVertexCommunity(vertexCommunity, string2, string3, bl2, bl4);
    }

    public static String cliqueGraphTypeString(int n) {
        switch (n) {
            case 0: {
                return "Unweighted and no self loops (C of eqn 8)";
            }
            case 1: {
                return "Unweighted with self-loops (\\tilde{C} of footnote 2)";
            }
            case 2: {
                return "Low Weighted and no self loops (D of eqn 11)";
            }
            case 3: {
                return "Low Weighted with self-loops (E of eqn 14)";
            }
            case 4: {
                return "Weighted and no self loops (incidence counts)";
            }
            case 5: {
                return "Weighted with self-loops (incidence counts)";
            }
        }
        return "*** UNKNOWN Clique Graph Type";
    }

    static {
        infoLevel = 0;
    }
}

