/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run;

import TimGraph.Community.QualitySparse;
import TimGraph.Community.QualityType;
import TimGraph.Community.VertexCommunity;
import TimGraph.Community.VertexPartition;
import TimGraph.OutputMode;
import TimGraph.algorithms.LineGraphProjector;
import TimGraph.io.FileOutput;
import TimGraph.run.LineGraphCommunities;
import TimGraph.run.SetUpNetwork;
import TimGraph.timgraph;
import TimUtilities.StringUtilities.Filters.StringFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class MakeEdgePartition {
    static final String[] COMMUNITYMETHOD = new String[]{"Louvain", "SimAn"};
    static final String SEP = "\t";
    static String basicroot = "UNSET";
    static timgraph tg;
    static timgraph lineGraphtg;
    static int infoLevel;

    public MakeEdgePartition(timgraph timgraph2) {
        tg = timgraph2;
    }

    public static void usage(PrintStream printStream) {
        char c = timgraph.NOT_TIMGRAPH_ARGUMENT[0];
        printStream.println("LineGraphCommunities " + c + "<filename> " + c + "<method> " + c + "<lineGraphType> " + c + "<quality> " + c + "<lambda> -<timgraphArgument> ...");
        printStream.println("Arguments for this class start with any of " + timgraph.otherArguments(", ") + ", but " + c + " used for example here.");
        printStream.println("First " + c + " argument is the type of line graph");
        printStream.println("Second " + c + " argument is the method used to find communities, 0=Louvain/Greedy, 1= Simulated Annealing");
        printStream.println("Third " + c + " argument is type of line graph to use 0=C, 1=Ctilde, 2=D, 3=E (Dtilde)");
        printStream.println("Fourth " + c + " argument is definition of quality to use, 0=Q(A), 1=Q(A" + c + "A-A)");
        printStream.println("Fifth " + c + " argument is type of quality class to use, 0=basic (dense matrix), 1=sparse matrix, 2=minimal memory ");
        printStream.println("Sixth " + c + " argument is value of lambda, scaling parameter of null model.");
        printStream.println("Remaining arguments should start with a - and are parsed by <tt>timgraph</tt>.");
        SetUpNetwork.printNetworkTypes(printStream, "", "  ");
    }

    public static void main(String[] stringArray) {
        System.out.println("MakeEdgePartition Arguments :<method> :<qualitydef> :<qualitytype> :<gammaMin> :<gammaMax> :<gammaStep> :numberRuns :<graphMLOn>");
        int n = 0;
        int n2 = 2;
        if (stringArray.length > n && timgraph.isOtherArgument(stringArray[n])) {
            n2 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        System.out.println("--- Using Line Graph type " + LineGraphProjector.lgExtensionDescription[n2]);
        int n3 = 0;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            n3 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        System.out.println("--- Using community method " + LineGraphCommunities.COMMUNITYMETHOD[n3]);
        int n4 = 0;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            n4 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        System.out.println("--- Quality definition used " + QualitySparse.QdefinitionString[n4]);
        int n5 = 2;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            n5 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        System.out.println("--- Quality class type " + QualityType.qualityLongName[n5]);
        double d = 1.0;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            d = Double.parseDouble(stringArray[n].substring(1, stringArray[n].length()));
        }
        double d2 = 1.1;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            d2 = Double.parseDouble(stringArray[n].substring(1, stringArray[n].length()));
        }
        double d3 = 0.001;
        double d4 = 1.0;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            d4 = Double.parseDouble(stringArray[n].substring(1, stringArray[n].length()));
        }
        if (Math.abs(d4) < d3) {
            throw new RuntimeException("Step size must be greater than " + d3 + " in magnitude");
        }
        System.out.println("--- Modularity null model scaling gamma min, max step =" + d + "  " + d2 + "  " + d4);
        int n6 = 1;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            n6 = Math.max(1, Integer.parseInt(stringArray[n].substring(1, stringArray[n].length())));
        }
        System.out.println("--- Number of runs for each gamma value =" + n6);
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            bl2 = StringFilter.trueString(stringArray[n].charAt(1));
        }
        System.out.println("--- file output is " + StringFilter.onOffString(bl));
        System.out.println("--- graphML output is " + StringFilter.onOffString(bl2));
        System.out.println("--- projected graph output is " + StringFilter.onOffString(bl3));
        String string = "BowTie";
        String[] stringArray2 = new String[]{"-fin" + string, "-fieinputELS.dat", "-o0", "-xi0"};
        if (stringArray.length > 0) {
            stringArray2 = stringArray;
        }
        tg = new timgraph();
        tg.parseParam(stringArray2);
        if (!tg.isVertexEdgeListOn()) {
            System.err.println("\n *** Vertex Edge List NOT on and it is required, use -vgvet option ***\n");
        }
        tg.setNameRoot(MakeEdgePartition.tg.inputName.getNameRoot());
        int n7 = 1;
        int n8 = 2;
        boolean bl4 = false;
        boolean bl5 = false;
        int n9 = 1;
        tg.setNetworkFromInputFile(n7, n8, n9, bl4, bl5);
        tg.printParametersBasic();
        tg.calcStrength();
        FileOutput fileOutput = new FileOutput(tg);
        String string2 = "_" + Math.round(1000.0 * d) + "_" + Math.round(1000.0 * d2) + "_" + Math.round(1000.0 * d4) + "_gamma.dat";
        fileOutput.fileName.setNameEnd(string2);
        boolean bl6 = true;
        boolean bl7 = true;
        boolean bl8 = true;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = true;
        MakeEdgePartition.analyseManyEdgePartitions(n6, n3, n2, n4, n5, d, d2, d4, bl6, bl7, bl8, bl9, bl10, bl11, bl12, bl13);
    }

    public static void analyseManyEdgePartitions(int n, int n2, int n3, int n4, int n5, double d, double d2, double d3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
        basicroot = MakeEdgePartition.tg.inputName.getNameRoot();
        FileOutput fileOutput = new FileOutput(tg);
        OutputMode outputMode = null;
        fileOutput.informationGeneral("", SEP, bl, bl2, bl3, bl4, bl5, outputMode);
        if (tg.isVertexLabelled()) {
            fileOutput.printEdges(true, false, false, false, false);
        } else {
            fileOutput.edgeListSimple();
        }
        System.out.println("\n *** \n *** Making Line Graph type " + LineGraphProjector.lgExtensionDescription[n3] + " *** \n");
        lineGraphtg = LineGraphProjector.makeLineGraph(tg, n3, true);
        FileOutput fileOutput2 = new FileOutput(lineGraphtg);
        if (bl5) {
            fileOutput2.graphML();
        }
        fileOutput2.printEdges(true, true, true, true, true);
        String string = "_" + Math.round(1000.0 * d) + "_" + Math.round(1000.0 * d2) + "_" + Math.round(1000.0 * d3) + "_gamma.dat";
        fileOutput.fileName.setNameEnd(string);
        VertexPartition vertexPartition = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(fileOutput.fileName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            for (double d4 = d; d4 <= d2 && !(d4 <= 0.0); d4 += d3) {
                System.out.println("\n--- gamma=" + String.format("%6.3f", d4) + " ----------------------------------------------------");
                vertexPartition = VertexPartition.calculate(tg, n4, n5, d4, n2, infoLevel);
                MakeEdgePartition.vertexPartitionGraphML(tg, vertexPartition);
                for (int i = 0; i < n; ++i) {
                    VertexPartition vertexPartition2 = MakeEdgePartition.analyseOneEdgePartition(i, n2, n3, n4, n5, d4, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, vertexPartition);
                    printStream.println(i + SEP + vertexPartition2.getName() + SEP + vertexPartition2.informationNumbers("", SEP));
                }
            }
            if (infoLevel > -2) {
                System.out.println("Finished writing EP various gamma information file to " + fileOutput.fileName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + fileOutput.fileName.getFullFileName() + ", " + fileNotFoundException.getMessage());
            return;
        }
    }

    public static VertexPartition analyseOneEdgePartition(int n, int n2, int n3, int n4, int n5, double d, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, VertexPartition vertexPartition) {
        FileOutput fileOutput = new FileOutput(tg);
        FileOutput fileOutput2 = new FileOutput(lineGraphtg);
        System.out.println("*** Line Graph partition of type " + QualitySparse.QdefinitionString[n4] + ", gamma=" + d);
        VertexPartition vertexPartition2 = VertexPartition.calculate(lineGraphtg, n4, n5, d, n2, infoLevel);
        vertexPartition2.setName(vertexPartition2.getName() + LineGraphProjector.lgExtensionList[n3] + (n < 0 ? "" : "r" + n));
        System.out.println("    Communities info: " + vertexPartition2.informationNumbers("", SEP));
        if (bl8) {
            tg.setEdgeLabels(vertexPartition2);
            fileOutput = new FileOutput(tg);
            fileOutput.printEdges(true, true, true, true, vertexPartition2.getName());
            fileOutput.printVertices("", SEP, null, bl, bl2, false);
            boolean bl9 = false;
            boolean bl10 = false;
            fileOutput.printEdgeCommunityStats(vertexPartition2.getName(), true, true, bl9, bl10);
            MakeEdgePartition.edgePartitionGraphML(tg, vertexPartition2);
            if (bl5) {
                fileOutput2.graphMLVertexPartition(vertexPartition2);
            }
            fileOutput2.informationPartition(vertexPartition2, "", SEP, true);
            fileOutput2.printVertices("", SEP, vertexPartition2, bl, bl2, false);
            if (vertexPartition != null) {
                try {
                    MakeEdgePartition.vertexEdgePartitionGraphML(tg, vertexPartition, vertexPartition2);
                }
                catch (RuntimeException runtimeException) {
                    System.err.println("*** Tried and failed to produce vertex and edge parttioned graphML file, " + runtimeException);
                }
            }
        }
        if (bl6) {
            System.out.println("Trying a projection from edge partition to vertex community");
            MakeEdgePartition.doEP2VC(fileOutput, tg, vertexPartition2, n4, d, n5);
        } else {
            System.out.println("No projection from edge partition to vertex community");
        }
        if (bl7) {
            System.out.println("\n *** \n *** Incidence Graph\n *** ");
            MakeEdgePartition.incidenceGraph(n2);
        } else {
            System.out.println("No incidence graph");
        }
        return vertexPartition2;
    }

    public static void analyseGraph(timgraph timgraph2, int n, int n2, int n3, int n4, double d) {
        System.out.println("\n *** Analysing vertex and edge partitions of graph " + timgraph2.inputName.getNameRoot());
        VertexPartition vertexPartition = VertexPartition.calculate(timgraph2, n3, n4, d, n, infoLevel);
        MakeEdgePartition.vertexPartitionGraphML(timgraph2, vertexPartition);
        FileOutput fileOutput = new FileOutput(timgraph2);
        fileOutput.pajekPartition(vertexPartition.getName(), vertexPartition);
        System.out.println("\n *** Making Line Graph type " + LineGraphProjector.lgExtensionDescription[n2] + " *** \n");
        timgraph timgraph3 = LineGraphProjector.makeLineGraph(timgraph2, n2, true);
        FileOutput fileOutput2 = new FileOutput(timgraph3);
        fileOutput2.graphML();
        fileOutput2.printEdges(true, true, true, true, true);
        System.out.println("\n ***  Line Graph partition of type " + QualitySparse.QdefinitionString[n3] + ", quality type =" + QualityType.qualityLongName[n4] + ", lambda=" + d);
        VertexPartition vertexPartition2 = VertexPartition.calculate(timgraph3, n3, n4, d, n, infoLevel);
        vertexPartition2.setName(vertexPartition2.getName() + LineGraphProjector.lgExtensionList[n2]);
        timgraph2.setEdgeLabels(vertexPartition2);
        fileOutput.printEdges(true, true, true, true, vertexPartition2.getName());
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = true;
        fileOutput.printVertices("", SEP, null, bl2, bl3, bl);
        boolean bl4 = false;
        boolean bl5 = false;
        fileOutput.printEdgeCommunityStats(true, true, bl4, bl5);
        MakeEdgePartition.edgePartitionGraphML(timgraph2, vertexPartition2);
        MakeEdgePartition.vertexEdgePartitionGraphML(timgraph2, vertexPartition, vertexPartition2);
        fileOutput2.graphMLVertexPartition(vertexPartition2);
        fileOutput2.informationPartition(vertexPartition2, "", SEP, true);
        System.out.println("*** Finished analysing vertex and edge partitions of graph " + timgraph2.inputName.getNameRoot());
    }

    public static void doEP2VC(FileOutput fileOutput, timgraph timgraph2, VertexPartition vertexPartition, int n, double d, int n2) {
        VertexCommunity vertexCommunity = new VertexCommunity(timgraph2, vertexPartition, n, n2, d);
        vertexCommunity.calcQuality();
        fileOutput.informationVertexCommunity(vertexCommunity, "", SEP, true);
    }

    public static void doEP2VCandVP(FileOutput fileOutput, timgraph timgraph2, VertexPartition vertexPartition, int n, double d, int n2) {
        VertexCommunity vertexCommunity = new VertexCommunity(timgraph2, vertexPartition, n, n2, d);
        vertexCommunity.calcQuality();
        fileOutput.informationVertexCommunity(vertexCommunity, "", SEP, true);
        VertexPartition vertexPartition2 = new VertexPartition(timgraph2, vertexPartition);
        vertexPartition2.calcQuality();
        fileOutput.graphMLVertexPartition(vertexPartition2);
        MakeEdgePartition.vertexEdgePartitionGraphML(timgraph2, vertexPartition2, vertexPartition);
    }

    public static void vertexPartitionGraphML(timgraph timgraph2, VertexPartition vertexPartition) {
        FileOutput fileOutput = new FileOutput(timgraph2);
        fileOutput.graphMLVertexPartition(vertexPartition);
        fileOutput.printPartitionStats(vertexPartition, "", SEP, true, true);
        fileOutput.informationPartition(vertexPartition, "", SEP, true);
    }

    public static void edgePartitionGraphML(timgraph timgraph2, VertexPartition vertexPartition) {
        FileOutput fileOutput = new FileOutput(timgraph2);
        fileOutput.graphMLEdgePartition(vertexPartition);
        fileOutput.informationEdgePartition(vertexPartition, "", SEP, true);
    }

    public static void vertexEdgePartitionGraphML(timgraph timgraph2, VertexPartition vertexPartition, VertexPartition vertexPartition2) {
        FileOutput fileOutput = new FileOutput(timgraph2);
        fileOutput.graphMLVertexEdgePartition(vertexPartition, vertexPartition2);
        fileOutput.informationVertexEdgePartition(vertexPartition, vertexPartition2, "", SEP, true);
    }

    public static void incidenceVertexPartitionGraphML(timgraph timgraph2, VertexPartition vertexPartition) {
        FileOutput fileOutput = new FileOutput(timgraph2);
        fileOutput.graphMLIncidencePartition(vertexPartition);
        fileOutput.informationIncidenceVertexPartition(vertexPartition, "", SEP, true);
    }

    public static void incidenceGraph(int n) {
        timgraph timgraph2 = tg.makeIncidenceGraph(tg.isDirected(), true, tg.isWeighted(), true);
        if (infoLevel > 1 && timgraph2.getNumberVertices() < 21) {
            timgraph2.printNetwork(true);
        }
        FileOutput fileOutput = new FileOutput(timgraph2);
        fileOutput.informationNetworkBasic("", SEP);
        fileOutput.graphML();
        fileOutput.edgeListSimple();
        fileOutput.printVertices("", SEP, null, true, true, true, false, false, false, false, true);
        VertexPartition vertexPartition = VertexPartition.calculate(timgraph2, 0, n, infoLevel);
        MakeEdgePartition.vertexPartitionGraphML(timgraph2, vertexPartition);
        MakeEdgePartition.incidenceVertexPartitionGraphML(tg, vertexPartition);
    }

    static {
        infoLevel = 0;
    }
}

