/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run;

import TimGraph.Community.LouvainVertexPartition;
import TimGraph.Community.QualitySparse;
import TimGraph.Community.QualityType;
import TimGraph.Community.SimulatedAnnealingvertexPartition;
import TimGraph.Community.VertexCommunity;
import TimGraph.Community.VertexPartition;
import TimGraph.OutputMode;
import TimGraph.algorithms.LineGraphProjector;
import TimGraph.io.FileOutput;
import TimGraph.io.GraphMLGenerator;
import TimGraph.io.GraphViz;
import TimGraph.run.SetUpNetwork;
import TimGraph.timgraph;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class LineGraphCommunities {
    static final String[] COMMUNITYMETHOD = new String[]{"Louvain", "SimAn"};
    static final String SEP = "\t";
    static String basicroot = "UNSET";
    static timgraph tg;
    static timgraph lineGraphtg;
    static int infoLevel;

    public LineGraphCommunities(timgraph timgraph2) {
        tg = timgraph2;
    }

    public static void usage(PrintStream printStream) {
        char c = timgraph.NOT_TIMGRAPH_ARGUMENT[0];
        printStream.println("LineGraphCommunities " + c + "<filename> " + c + "<method> " + c + "<lineGraphType> " + c + "<quality> " + c + "<lambda> -<timgraphArgument> ...");
        printStream.println("Arguments for this class start with any of " + timgraph.otherArguments(", ") + ", but " + c + " used for example here.");
        printStream.println("First " + c + " argument is the network number for the setup routine OR ? for this help");
        printStream.println("Second " + c + " argument is the method used to find communities, 0=Louvain/Greedy, 1= Simulated Annealing");
        printStream.println("Third " + c + " argument is type of line graph to use 0=C, 1=Ctilde, 2=D, 3=E (Dtilde)");
        printStream.println("Fourth " + c + " argument is definition of quality to use, 0=Q(A), 1=Q(A" + c + "A-A)");
        printStream.println("Fifth " + c + " argument is type of quality class to use, 0=basic (dense matrix), 1=sparse matrix, 2=minimal memory ");
        printStream.println("Sixth " + c + " argument is value of lambda, scaling parameter of null model.");
        printStream.println("Remaining arguments should start with a - and are parsed by <tt>timgraph</tt>.");
        SetUpNetwork.printNetworkTypes(printStream, "", "  ");
    }

    public static void main(String[] stringArray) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        System.out.println("LineGraphCommunities Arguments :networknumber :method :linegraphtype :qualitydef :qualityclass :lambda");
        int n = 142;
        int n2 = 0;
        if (stringArray.length > n2) {
            if (timgraph.isOtherArgument(stringArray[n2])) {
                if (stringArray[n2].charAt(1) == '?') {
                    LineGraphCommunities.usage(System.out);
                    return;
                }
                n = Integer.parseInt(stringArray[n2].substring(1, stringArray[n2].length()));
            } else {
                n = 0;
            }
        }
        System.out.println("--- Using network  " + SetUpNetwork.typeString(n));
        int n3 = 0;
        if (stringArray.length > ++n2 && timgraph.isOtherArgument(stringArray[n2])) {
            n3 = Integer.parseInt(stringArray[n2].substring(1, stringArray[n2].length()));
        }
        System.out.println("--- Using community method " + COMMUNITYMETHOD[n3]);
        int n4 = 2;
        if (stringArray.length > ++n2 && timgraph.isOtherArgument(stringArray[n2])) {
            n4 = Integer.parseInt(stringArray[n2].substring(1, stringArray[n2].length()));
        }
        System.out.println("--- Using Line Graph type " + LineGraphProjector.lgExtensionDescription[n4]);
        int n5 = 0;
        if (stringArray.length > ++n2 && timgraph.isOtherArgument(stringArray[n2])) {
            n5 = Integer.parseInt(stringArray[n2].substring(1, stringArray[n2].length()));
        }
        System.out.println("--- Quality definition used " + QualitySparse.QdefinitionString[n5]);
        int n6 = 2;
        if (stringArray.length > ++n2 && timgraph.isOtherArgument(stringArray[n2])) {
            n6 = Integer.parseInt(stringArray[n2].substring(1, stringArray[n2].length()));
        }
        System.out.println("--- Quality class type " + QualityType.qualityLongName[n6]);
        double d = 1.0;
        if (stringArray.length > ++n2 && timgraph.isOtherArgument(stringArray[n2])) {
            d = Double.parseDouble(stringArray[n2].substring(1, stringArray[n2].length()));
        }
        System.out.println("--- Line Graph null model scaling lambda=" + d);
        SetUpNetwork setUpNetwork = new SetUpNetwork(infoLevel);
        tg = SetUpNetwork.setUpNetwork(n, stringArray);
        basicroot = LineGraphCommunities.tg.inputName.getNameRoot();
        FileOutput fileOutput = new FileOutput(tg);
        boolean bl5 = true;
        boolean bl6 = true;
        boolean bl7 = false;
        boolean bl8 = false;
        OutputMode outputMode = null;
        fileOutput.informationGeneral("", SEP, bl5, bl5, bl6, bl7, bl8, outputMode);
        if (tg.isVertexLabelled()) {
            fileOutput.printEdges(true, false, false, false, false);
        } else {
            fileOutput.edgeListSimple();
        }
        System.out.println("\n *** \n *** Making Line Graph type " + LineGraphProjector.lgExtensionDescription[n4] + " *** \n");
        lineGraphtg = LineGraphProjector.makeLineGraph(tg, n4, true);
        FileOutput fileOutput2 = new FileOutput(lineGraphtg);
        if (bl8) {
            fileOutput2.graphML();
        }
        fileOutput2.printEdges(true, true, true, true, true);
        System.out.println("*** Line Graph partition of type " + QualitySparse.QdefinitionString[n5] + ", lambda=" + d);
        VertexPartition vertexPartition = VertexPartition.calculate(lineGraphtg, n5, n6, d, n3, infoLevel);
        vertexPartition.setName(vertexPartition.getName() + LineGraphProjector.lgExtensionList[n4]);
        boolean bl9 = true;
        if (n >= 140 && n < 150) {
            bl9 = true;
        }
        if (bl9) {
            tg.setEdgeLabels(vertexPartition);
            fileOutput = new FileOutput(tg);
            fileOutput.printEdges(true, true, true, true, vertexPartition.getName());
            bl5 = false;
            fileOutput.printVertices("", SEP, null, bl5, bl5, false);
            bl4 = false;
            bl3 = false;
            fileOutput.printEdgeCommunityStats(vertexPartition.getName(), true, true, bl4, bl3);
            LineGraphCommunities.edgePartitionGraphML(tg, vertexPartition);
            if (bl8) {
                fileOutput2.graphMLVertexPartition(vertexPartition);
            }
            fileOutput2.informationPartition(vertexPartition, "", SEP, true);
            fileOutput2.printVertices("", SEP, vertexPartition, bl5, bl5, false);
            VertexPartition vertexPartition2 = VertexPartition.calculate(tg, n5, n6, d, n3, infoLevel);
            LineGraphCommunities.vertexPartitionGraphML(tg, vertexPartition2);
            LineGraphCommunities.vertexEdgePartitionGraphML(tg, vertexPartition2, vertexPartition);
        }
        bl4 = false;
        if (n >= 140 && n < 150) {
            bl4 = true;
        }
        if (bl4) {
            System.out.println("Trying a projection from edge partition to vertex community");
            LineGraphCommunities.doEP2VC(fileOutput, tg, vertexPartition, n5, d, n6);
        } else {
            System.out.println("No projection from edge partition to vertex community");
        }
        bl3 = true;
        if (bl3) {
            if (basicroot.startsWith("karate")) {
                LineGraphCommunities.karateActualVP(fileOutput, fileOutput2, n3, vertexPartition);
            }
        } else {
            System.out.println("No actual partition for karate dealt with");
        }
        if (bl2 = true) {
            if (basicroot.startsWith("karate")) {
                LineGraphCommunities.karateBestVP(fileOutput, fileOutput2, n3, vertexPartition);
            }
        } else {
            System.out.println("No best  partition for karate dealt with");
        }
        if (bl = false) {
            System.out.println("\n *** \n *** Incidence Graph\n *** ");
            LineGraphCommunities.incidenceGraph(n3);
        } else {
            System.out.println("No incidence graph");
        }
    }

    public static void analyseGraph(timgraph timgraph2, int n, int n2, int n3, int n4, double d) {
        System.out.println("\n *** Analysing vertex and edge partitions of graph " + timgraph2.inputName.getNameRoot());
        VertexPartition vertexPartition = VertexPartition.calculate(timgraph2, n3, n4, d, n, infoLevel);
        LineGraphCommunities.vertexPartitionGraphML(timgraph2, vertexPartition);
        FileOutput fileOutput = new FileOutput(timgraph2);
        fileOutput.pajekPartition(vertexPartition.getName(), vertexPartition);
        System.out.println("\n *** Making Line Graph type " + LineGraphProjector.lgExtensionDescription[n2] + " *** \n");
        timgraph timgraph3 = LineGraphProjector.makeLineGraph(timgraph2, n2, true);
        FileOutput fileOutput2 = new FileOutput(timgraph3);
        fileOutput2.graphML();
        fileOutput2.printEdges(true, true, true, true, true);
        System.out.println("\n ***  Line Graph partition of type " + QualitySparse.QdefinitionString[n3] + ", quality type =" + QualityType.qualityLongName[n4] + ", lambda=" + d);
        VertexPartition vertexPartition2 = VertexPartition.calculate(timgraph3, n3, n4, d, n, infoLevel);
        vertexPartition2.setName(vertexPartition2.getName() + LineGraphProjector.lgExtensionList[n2]);
        timgraph2.setEdgeLabels(vertexPartition2);
        fileOutput.printEdges(true, true, true, true, vertexPartition2.getName());
        boolean bl = false;
        boolean bl2 = true;
        fileOutput.printVertices("", SEP, null, bl2, bl2, bl);
        boolean bl3 = false;
        boolean bl4 = false;
        fileOutput.printEdgeCommunityStats(true, true, bl3, bl4);
        LineGraphCommunities.edgePartitionGraphML(timgraph2, vertexPartition2);
        LineGraphCommunities.vertexEdgePartitionGraphML(timgraph2, vertexPartition, vertexPartition2);
        fileOutput2.graphMLVertexPartition(vertexPartition2);
        fileOutput2.informationPartition(vertexPartition2, "", SEP, true);
        System.out.println("*** Finished analysing vertex and edge partitions of graph " + timgraph2.inputName.getNameRoot());
    }

    public static void doEP2VC(FileOutput fileOutput, timgraph timgraph2, VertexPartition vertexPartition, int n, double d, int n2) {
        VertexCommunity vertexCommunity = new VertexCommunity(timgraph2, vertexPartition, n, n2, d);
        vertexCommunity.calcQuality();
        fileOutput.informationVertexCommunity(vertexCommunity, "", SEP, true);
    }

    public static void doEP2VCandVP(FileOutput fileOutput, timgraph timgraph2, VertexPartition vertexPartition, int n, double d, int n2) {
        VertexCommunity vertexCommunity = new VertexCommunity(timgraph2, vertexPartition, n, n2, d);
        vertexCommunity.calcQuality();
        fileOutput.informationVertexCommunity(vertexCommunity, "", SEP, true);
        VertexPartition vertexPartition2 = new VertexPartition(timgraph2, vertexPartition);
        vertexPartition2.calcQuality();
        fileOutput.graphMLVertexPartition(vertexPartition2);
        LineGraphCommunities.vertexEdgePartitionGraphML(timgraph2, vertexPartition2, vertexPartition);
    }

    public static void testLambda(int n) {
        int n2;
        double[] dArray = new double[]{0.001, 0.1, 0.2, 0.3, 0.4, 0.425, 0.45, 0.5, 0.55, 0.6, 0.7, 0.8, 0.9, 1.0, 2.0, 4.0, 10.0, 20.0, 100.0};
        double[] dArray2 = new double[dArray.length];
        int[] nArray = new int[dArray.length];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            double d = dArray[n2];
            VertexPartition vertexPartition = VertexPartition.calculate(lineGraphtg, 0, 1, d, n, infoLevel);
            dArray2[n2] = vertexPartition.calcQuality();
            nArray[n2] = vertexPartition.getNumberOfCommunities();
        }
        System.out.println("lambda\tQ\tNo.Comm.");
        for (n2 = 0; n2 < dArray.length; ++n2) {
            System.out.println(dArray[n2] + SEP + dArray2[n2] + SEP + nArray[n2]);
        }
    }

    public static VertexPartition karateActualVP(FileOutput fileOutput, FileOutput fileOutput2, int n, VertexPartition vertexPartition) {
        String string = "Actualvp";
        VertexPartition vertexPartition2 = LineGraphCommunities.readVP(tg, "karate", string);
        vertexPartition2.recalculateCommunityLabels();
        vertexPartition2.calcQuality();
        LineGraphCommunities.vertexPartitionGraphML(tg, vertexPartition2);
        LineGraphCommunities.vertexEdgePartitionGraphML(tg, vertexPartition2, vertexPartition);
        return vertexPartition2;
    }

    public static VertexPartition karateBestVP(FileOutput fileOutput, FileOutput fileOutput2, int n, VertexPartition vertexPartition) {
        String string = "AK07BestQvp";
        VertexPartition vertexPartition2 = LineGraphCommunities.readVP(tg, "karate", string);
        vertexPartition2.recalculateCommunityLabels();
        vertexPartition2.calcQuality();
        LineGraphCommunities.vertexPartitionGraphML(tg, vertexPartition2);
        LineGraphCommunities.vertexEdgePartitionGraphML(tg, vertexPartition2, vertexPartition);
        return vertexPartition2;
    }

    public static void otherKarateTests(FileOutput fileOutput, FileOutput fileOutput2, int n, VertexPartition vertexPartition) {
        String string = "AK07BestQvp";
        VertexPartition vertexPartition2 = LineGraphCommunities.readVP(tg, "karate", string);
        vertexPartition2.recalculateCommunityLabels();
        vertexPartition2.calcQuality();
        LineGraphCommunities.vertexPartitionGraphML(tg, vertexPartition2);
        string = "Other";
        LineGraphCommunities.lineGraphtg.inputName.setNameRoot("karateNeATLG");
        VertexPartition vertexPartition3 = LineGraphCommunities.readVP(lineGraphtg, LineGraphCommunities.lineGraphtg.inputName.getNameRoot(), string);
        vertexPartition3.recalculateCommunityLabels();
        vertexPartition3.calcQuality();
        LineGraphCommunities.vertexPartitionGraphML(lineGraphtg, vertexPartition3);
        vertexPartition3.printInformation(System.out, " ", "  ");
        string = "Otherep";
        LineGraphCommunities.tg.inputName.setNameRoot("karateNeAT" + string);
        VertexPartition vertexPartition4 = LineGraphCommunities.readEP(tg, string);
        vertexPartition4.printInformation(System.out, " ", "  ");
        tg.setEdgeLabels(vertexPartition4);
        fileOutput.fileName.setNameRoot(LineGraphCommunities.tg.outputName.getNameRoot());
        fileOutput.printEdges(true, true, true, true, vertexPartition4.getName());
        LineGraphCommunities.edgePartitionGraphML(tg, vertexPartition4);
        fileOutput2.fileName.setNameRoot(basicroot + "LG");
        fileOutput2.graphMLVertexPartition(vertexPartition4);
        LineGraphCommunities.vertexEdgePartitionGraphML(tg, vertexPartition2, vertexPartition);
        LineGraphCommunities.vertexEdgePartitionGraphML(tg, vertexPartition2, vertexPartition4);
    }

    public static VertexPartition readVP(timgraph timgraph2, String string, String string2) {
        VertexPartition vertexPartition = new VertexPartition(timgraph2);
        vertexPartition.initialise(timgraph2);
        vertexPartition.setName(string2);
        boolean bl = true;
        vertexPartition.readIntPartition(timgraph2.inputName.getDirectoryFull() + string + string2 + "inputVP.dat", 1, 2, true, bl);
        vertexPartition.calcQuality();
        return vertexPartition;
    }

    public static VertexPartition readEP(timgraph timgraph2, String string) {
        boolean bl = false;
        boolean bl2 = false;
        timgraph timgraph3 = new timgraph(timgraph2, false, bl, bl2, false, false);
        VertexPartition vertexPartition = new VertexPartition(timgraph3);
        vertexPartition.initialise(timgraph3);
        vertexPartition.setName(string);
        boolean bl3 = true;
        vertexPartition.readIntPartition(timgraph2.inputName.getNameRootFullPath() + "inputEP.dat", 1, 2, true, bl3);
        vertexPartition.calcQuality();
        return vertexPartition;
    }

    public static void graphML(timgraph timgraph2) {
        FileOutput fileOutput = new FileOutput(timgraph2);
        fileOutput.graphML();
    }

    public static void vertexPartitionGraphML(timgraph timgraph2, VertexPartition vertexPartition) {
        FileOutput fileOutput = new FileOutput(timgraph2);
        fileOutput.graphMLVertexPartition(vertexPartition);
        fileOutput.printPartitionStats(vertexPartition, "", SEP, true, true);
        fileOutput.informationPartition(vertexPartition, "", SEP, true);
    }

    public static void edgePartitionGraphML(timgraph timgraph2, VertexPartition vertexPartition) {
        FileOutput fileOutput = new FileOutput(timgraph2);
        fileOutput.graphMLEdgePartition(vertexPartition);
        fileOutput.informationEdgePartition(vertexPartition, "", SEP, true);
    }

    public static void vertexEdgePartitionGraphML(timgraph timgraph2, VertexPartition vertexPartition, VertexPartition vertexPartition2) {
        FileOutput fileOutput = new FileOutput(timgraph2);
        fileOutput.graphMLVertexEdgePartition(vertexPartition, vertexPartition2);
        fileOutput.informationVertexEdgePartition(vertexPartition, vertexPartition2, "", SEP, true);
    }

    public static void incidenceVertexPartitionGraphML(timgraph timgraph2, VertexPartition vertexPartition) {
        FileOutput fileOutput = new FileOutput(timgraph2);
        fileOutput.graphMLIncidencePartition(vertexPartition);
        fileOutput.informationIncidenceVertexPartition(vertexPartition, "", SEP, true);
    }

    public static void incidenceGraph(int n) {
        timgraph timgraph2 = tg.makeIncidenceGraph(tg.isDirected(), true, tg.isWeighted(), true);
        if (infoLevel > 1 && timgraph2.getNumberVertices() < 21) {
            timgraph2.printNetwork(true);
        }
        FileOutput fileOutput = new FileOutput(timgraph2);
        fileOutput.informationNetworkBasic("", SEP);
        fileOutput.graphML();
        fileOutput.edgeListSimple();
        fileOutput.printVertices("", SEP, null, true, true, true, false, false, false, false, true);
        VertexPartition vertexPartition = VertexPartition.calculate(timgraph2, 0, n, infoLevel);
        LineGraphCommunities.vertexPartitionGraphML(timgraph2, vertexPartition);
        LineGraphCommunities.incidenceVertexPartitionGraphML(tg, vertexPartition);
    }

    public static void testLineGraphity() {
        tg.printEdges();
        System.out.println("*** LineGraph Graph");
        boolean bl = false;
        boolean bl2 = false;
        String string = "LG" + (bl ? "uw" : "w") + (bl2 ? "sl" : "nsl");
        timgraph timgraph2 = new timgraph(tg, false, bl, bl2, false, false);
        timgraph2.setNameRoot(basicroot + string);
        timgraph2.printEdges();
    }

    public VertexPartition testLouvainCommunityTwoSteps() {
        Object object;
        VertexPartition vertexPartition;
        int n = 1;
        switch (n) {
            default: {
                LouvainVertexPartition louvainVertexPartition = new LouvainVertexPartition(tg, 0, 1, 2);
                louvainVertexPartition.calculate();
                vertexPartition = louvainVertexPartition;
                break;
            }
            case 2: {
                object = new SimulatedAnnealingvertexPartition(tg);
                ((SimulatedAnnealingvertexPartition)object).calc(10, 0.5);
                vertexPartition = object;
            }
        }
        vertexPartition.recalculateCommunityLabels();
        boolean bl = true;
        vertexPartition.relabelCommunities(bl);
        System.out.println("*** now Projected Graph");
        object = new timgraph(tg, vertexPartition.getCommunity(), vertexPartition.getNumberOfCommunities(), false, false);
        ((timgraph)object).printEdges(System.out);
        switch (n) {
            default: {
                LouvainVertexPartition louvainVertexPartition = new LouvainVertexPartition((timgraph)object, 0, 1, 2);
                louvainVertexPartition.calculate();
                vertexPartition = louvainVertexPartition;
                break;
            }
            case 2: {
                SimulatedAnnealingvertexPartition simulatedAnnealingvertexPartition = new SimulatedAnnealingvertexPartition((timgraph)object);
                simulatedAnnealingvertexPartition.calc(10, 0.5);
                vertexPartition = simulatedAnnealingvertexPartition;
            }
        }
        vertexPartition.relabelCommunities(bl);
        return vertexPartition;
    }

    public static void testLineGraphGraphMLOld(timgraph timgraph2, VertexPartition vertexPartition) {
        GraphMLGenerator graphMLGenerator = new GraphMLGenerator();
        timgraph2.outputName.setNameEnd(".graphml");
        if (timgraph2.getInformationLevel() > -2) {
            System.out.println("Writing LineGraphGraphML file to " + timgraph2.outputName.getFullFileName());
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(timgraph2.outputName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            graphMLGenerator.outputEdgePartition(printStream, timgraph2, vertexPartition);
            if (timgraph2.getInformationLevel() > -2) {
                System.out.println("Finished writing LineGraphGraphML file to " + timgraph2.outputName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("*** File Error with " + timgraph2.outputName.getFullFileName());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Error opening output file " + timgraph2.outputName.getFullFileName());
            return;
        }
    }

    public static void testGraphViz(timgraph timgraph2, VertexPartition vertexPartition) {
        GraphViz graphViz = new GraphViz();
        timgraph2.inputName.setNameEnd(".gv");
        if (timgraph2.getInformationLevel() > -2) {
            System.out.println("Writing GraphViz file to " + timgraph2.outputName.getFullFileName());
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(timgraph2.outputName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            graphViz.outputVertexCommunity(printStream, timgraph2, vertexPartition, true);
            if (timgraph2.getInformationLevel() > -2) {
                System.out.println("Finished writing GraphViz file to " + timgraph2.outputName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("*** File Error with " + timgraph2.outputName.getFullFileName());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Error opening output file " + timgraph2.outputName.getFullFileName());
            return;
        }
    }

    static {
        infoLevel = 0;
    }
}

