/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run.ImperialPapers;

import TimUtilities.FileUtilities.FileNameSequence;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniversityOrganisation {
    public static final String[] levelName = new String[]{"Faculty", "Department", "Section"};
    public static final String[] levelNamePlural = new String[]{"Faculties", "Departments", "Sections"};
    static final int NUMBERLEVELS = levelName.length;
    static final String NOUNIT = "(NO UNIT)";
    static final String NO_UNIT = "(NO_UNIT)";
    TreeSet<String> facultySet = new TreeSet();
    TreeSet<String> departmentSet = new TreeSet();
    TreeSet<String> sectionSet = new TreeSet();
    ArrayList<String> faculty;
    ArrayList<String> department;
    ArrayList<String> section;
    boolean fixedSections = false;
    int nMax = -1;
    int infoLevel = 0;

    public UniversityOrganisation() {
        this.facultySet.add(NOUNIT);
        this.departmentSet.add(NOUNIT);
        this.sectionSet.add(NOUNIT);
    }

    public void addSection(String string, String string2, String string3) {
        if (this.fixedSections) {
            throw new RuntimeException("Sections fixed, can not add more sections");
        }
        String string4 = UniversityOrganisation.cleanUp(string3);
        this.sectionSet.add(string4);
        String string5 = UniversityOrganisation.cleanUp(string);
        this.facultySet.add(string5);
        String string6 = UniversityOrganisation.cleanUp(string2);
        if (string6.equals(NOUNIT) && !string4.equals(NOUNIT)) {
            string6 = string5;
        }
        this.departmentSet.add(string6);
    }

    public static String cleanUp(String string) {
        if (string.length() == 0 || string.equals("")) {
            return NOUNIT;
        }
        if (string.charAt(0) < 'A') {
            if (string.charAt(string.length() - 1) < 'A') {
                return string.substring(1, string.length() - 1);
            }
            return string.substring(1);
        }
        return string;
    }

    public static String toFileName(String string) {
        String string2 = UniversityOrganisation.cleanUp(string);
        string2 = string2.replace(" ", "_");
        string2 = string2.replace("&", "and");
        return string2;
    }

    public void finishSetUp() {
        this.fixedSections = true;
        this.nMax = this.sectionSet.size() * this.departmentSet.size() * this.facultySet.size();
        this.faculty = new ArrayList<String>(this.facultySet);
        this.department = new ArrayList<String>(this.departmentSet);
        this.section = new ArrayList<String>(this.sectionSet);
    }

    public int getNumber(int n) {
        switch (n) {
            case 0: {
                return this.faculty.size();
            }
            case 1: {
                return this.department.size();
            }
            case 2: {
                return this.section.size();
            }
        }
        return -1;
    }

    public int[] unitIndices(int n) {
        int n2;
        int n3;
        int n4;
        if (n < 0) {
            throw new RuntimeException("Section index must not be negative");
        }
        if (n >= this.nMax) {
            throw new RuntimeException("Section index too large, maximum is " + this.nMax);
        }
        int[] nArray = new int[NUMBERLEVELS];
        nArray[2] = n4 = n % this.section.size();
        int n5 = n / this.section.size();
        nArray[1] = n3 = n5 % this.department.size();
        int n6 = n5 / this.department.size();
        nArray[0] = n2 = n6 % this.department.size();
        return nArray;
    }

    public String getLevelName(int n) {
        if (n < 0 || n >= NUMBERLEVELS) {
            throw new RuntimeException("Level must not be negative or less than " + NUMBERLEVELS + ", given level " + n);
        }
        return levelName[n];
    }

    public String getLevelNamePlural(int n) {
        if (n < 0 || n >= NUMBERLEVELS) {
            throw new RuntimeException("Level must not be negative or less than " + NUMBERLEVELS + ", given level " + n);
        }
        return levelNamePlural[n];
    }

    public String getNameFromLocalIndex(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.faculty.get(n);
            }
            case 1: {
                return this.department.get(n);
            }
            case 2: {
                return this.section.get(n);
            }
        }
        throw new RuntimeException("Level must not be negative or less than " + NUMBERLEVELS + ", given level " + n2);
    }

    public String getNameFromGlobalIndex(int n, int n2) {
        int n3 = this.getLocalIndexFromGlobal(n, n2);
        return this.getNameFromLocalIndex(n3, n2);
    }

    public String[] getName(int n) {
        if (n < 0) {
            throw new RuntimeException("Section index must not be negative");
        }
        if (n >= this.nMax) {
            throw new RuntimeException("Section index too large, maximum is " + this.nMax);
        }
        int[] nArray = this.unitIndices(n);
        String[] stringArray = new String[NUMBERLEVELS];
        for (int i = 0; i < NUMBERLEVELS; ++i) {
            stringArray[i] = this.getNameFromGlobalIndex(n, i);
        }
        return stringArray;
    }

    public String[] getName(int n, int n2) {
        if (n2 < 0 || n2 >= NUMBERLEVELS) {
            throw new RuntimeException("Level must be between 0 and " + NUMBERLEVELS);
        }
        if (n < 0) {
            throw new RuntimeException("Section index must not be negative");
        }
        if (n >= this.nMax) {
            throw new RuntimeException("Section index too large, maximum is " + this.nMax);
        }
        int[] nArray = this.unitIndices(n);
        String[] stringArray = new String[n2 + 1];
        for (int i = 0; i < n2 + 1; ++i) {
            stringArray[i] = this.getNameFromGlobalIndex(n, i);
        }
        return stringArray;
    }

    public int getLocalIndexFromGlobal(int n, int n2) {
        if (n < 0) {
            throw new RuntimeException("Section index must not be negative");
        }
        if (n >= this.nMax) {
            throw new RuntimeException("Section index too large, maximum is " + this.nMax);
        }
        if (n2 < 0 || n2 >= NUMBERLEVELS) {
            throw new RuntimeException("Level must not be negative or less than " + NUMBERLEVELS + ", given level " + n2);
        }
        int n3 = n;
        for (int i = NUMBERLEVELS - 1; i > n2; --i) {
            n3 /= this.getNumber(i);
        }
        return n3 % this.getNumber(n2);
    }

    public boolean isInUnit(int n, int n2, int n3) {
        int n4 = this.getLocalIndexFromGlobal(n, n3);
        return n4 == n2;
    }

    public boolean testGlobalIndex(int n) {
        return n >= 0 && n < this.nMax;
    }

    public int getFilterFactor(int n) {
        int n2 = 1;
        for (int i = n + 1; i < levelName.length; ++i) {
            n2 *= this.getNumber(i);
        }
        return n2;
    }

    public int getUnitIndex(String string, String string2, String string3) {
        String[] stringArray = new String[]{string, string2, string3};
        return this.getUnitIndex(stringArray);
    }

    public int getUnitIndex(String[] stringArray) {
        if (stringArray.length == 0) {
            return -2;
        }
        if (stringArray.length > NUMBERLEVELS) {
            throw new RuntimeException("Section level " + stringArray.length + "too large, maximum level is " + NUMBERLEVELS);
        }
        int n = this.getSection(stringArray[0], this.faculty);
        int n2 = 0;
        if (stringArray.length > 0) {
            n2 = this.getSection(stringArray[1], this.department);
        }
        int n3 = 0;
        if (stringArray.length > 1) {
            n3 = this.getSection(stringArray[2], this.section);
        }
        if (n2 == 0 && n3 > 0) {
            n2 = n;
        }
        if (n < 0 || n2 < 0 || n3 < 0) {
            return -1;
        }
        return n3 + this.section.size() * (n2 + this.department.size() * n);
    }

    private int getSection(String string, ArrayList<String> arrayList) {
        String string2 = UniversityOrganisation.cleanUp(string);
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!arrayList.get(i).equalsIgnoreCase(string2)) continue;
            return i;
        }
        return -1;
    }

    public String informationSetString(String string) {
        return "Number Faculties " + string + this.facultySet.size() + string + "Number Departments" + string + this.departmentSet.size() + string + "Number Sections " + string + this.sectionSet.size();
    }

    public String informationString(String string) {
        return "Number Faculties " + string + this.faculty.size() + string + "Number Departments" + string + this.department.size() + string + "Number Sections " + string + this.section.size();
    }

    public String levelNameString(String string) {
        String string2 = levelName[0];
        for (int i = 1; i < levelName.length; ++i) {
            string2 = string + levelName[i];
        }
        return string2;
    }

    private void printNames(PrintStream printStream, String string, ArrayList<String> arrayList, boolean bl, String string2) {
        if (bl) {
            printStream.println("Index" + string + "Name" + (string2.length() > 0 ? string + "Level" : ""));
        }
        String string3 = "";
        if (string2.length() > 0) {
            string3 = string + string2;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            printStream.println(i + string + arrayList.get(i) + string3);
        }
    }

    public void printNames(PrintStream printStream, String string, int n, boolean bl, boolean bl2) {
        if (bl) {
            printStream.println("Index" + string + "Name" + (bl2 ? string + "Level" : ""));
        }
        switch (n) {
            case 0: {
                this.printNames(printStream, string, this.faculty, bl, bl2 ? "faculty" : "");
                return;
            }
            case 1: {
                this.printNames(printStream, string, this.department, bl, bl2 ? "department" : "");
                return;
            }
            case 2: {
                this.printNames(printStream, string, this.section, bl, bl2 ? "section" : "");
                return;
            }
        }
        throw new RuntimeException("level " + n + " unknown, must be between 0 and " + (NUMBERLEVELS - 1));
    }

    public void printAllNames(PrintStream printStream, String string, boolean bl, boolean bl2) {
        if (bl) {
            printStream.println("Index" + string + "Name" + (bl2 ? string + "Level" : ""));
        }
        for (int i = 0; i < NUMBERLEVELS; ++i) {
            this.printNames(printStream, string, i, false, bl2);
        }
    }

    public void outputFile(FileNameSequence fileNameSequence, String string, boolean bl, boolean bl2) {
        fileNameSequence.setNameEnd("organisation.dat");
        this.outputFile(fileNameSequence.getFullFileName(), string, bl, bl2);
    }

    public void outputFile(String string, String string2, boolean bl, boolean bl2) {
        if (this.infoLevel > -2) {
            System.out.println("Writing list of all known units to " + string);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.printAllNames(printStream, string2, bl, bl2);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing list of all known units to " + string);
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("*** File Error with " + string + ", " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + string + ", " + fileNotFoundException.getMessage());
            return;
        }
    }
}

