/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run.ImperialPapers;

import TimGraph.Community.QualitySparse;
import TimGraph.Community.QualityType;
import TimGraph.Community.VertexPartition;
import TimGraph.algorithms.LineGraphProjector;
import TimGraph.io.FileOutput;
import TimGraph.run.SetUpNetwork;
import TimGraph.timgraph;

public class LineGraphCommunity {
    static final String[] COMMUNITYMETHOD = new String[]{"Louvain", "SimAn"};
    static final String SEP = "\t";
    static int infoLevel = 0;

    public static void main(String[] stringArray) {
        System.out.println("ImperialPapers.LineGraphCommunity Arguments <filenameroot> <method> <linegraphtype> <qualitydef> <qualityclass> <lambda>");
        String string = "BowTie";
        int n = 0;
        if (stringArray.length > n) {
            string = stringArray[n];
        }
        System.out.println("--- Using network  " + string);
        int n2 = 0;
        if (stringArray.length > ++n) {
            n2 = Integer.parseInt(stringArray[n]);
        }
        System.out.println("--- Using community method " + COMMUNITYMETHOD[n2]);
        int n3 = 2;
        if (stringArray.length > ++n) {
            n3 = Integer.parseInt(stringArray[n]);
        }
        System.out.println("--- Using Line Graph type " + LineGraphProjector.lgExtensionDescription[n3]);
        int n4 = 0;
        if (stringArray.length > ++n) {
            n4 = Integer.parseInt(stringArray[n]);
        }
        System.out.println("--- Quality definition used " + QualitySparse.QdefinitionString[n4]);
        int n5 = 2;
        if (stringArray.length > ++n) {
            n5 = Integer.parseInt(stringArray[n]);
        }
        System.out.println("--- Quality class type " + QualityType.qualityLongName[n5]);
        double d = 1.0;
        if (stringArray.length > ++n) {
            d = Double.parseDouble(stringArray[n]);
        }
        System.out.println("--- Line Graph null model scaling lambda=" + d);
        timgraph timgraph2 = new timgraph();
        String[] stringArray2 = new String[]{"-gvet", "-gdf", "-gewt", "-gvlt", "-gbf", "-fin" + string, "-fieinputELS.dat", "-gn99", "-e0", "-o23", "-xi0"};
        SetUpNetwork.initialise(timgraph2, string, stringArray2, infoLevel);
        System.out.println("\n *** \n *** Making Line Graph type " + LineGraphProjector.lgExtensionDescription[n3] + " (type " + n3 + ") *** \n");
        timgraph timgraph3 = LineGraphProjector.makeLineGraph(timgraph2, n3, true);
        FileOutput fileOutput = new FileOutput(timgraph3);
        System.out.println("*** Line Graph partition of type " + QualitySparse.QdefinitionString[n4] + ", lambda=" + d);
        VertexPartition vertexPartition = VertexPartition.calculate(timgraph3, n4, n5, d, n2, infoLevel);
        vertexPartition.setName(vertexPartition.getName() + LineGraphProjector.lgExtensionList[n3]);
        timgraph2.setEdgeLabels(vertexPartition);
        FileOutput fileOutput2 = new FileOutput(timgraph2);
        fileOutput2.printEdges(true, true, true, true, vertexPartition.getName());
        fileOutput2.printVertices("", SEP, null, false, false, false);
        boolean bl = false;
        boolean bl2 = false;
        fileOutput2.printEdgeCommunityStats(vertexPartition.getName(), true, true, bl, bl2);
    }
}

