/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run.ImperialPapers;

import TimGraph.Community.VertexPartition;
import TimGraph.OutputMode;
import TimGraph.algorithms.BipartiteTransformations;
import TimGraph.algorithms.Projections;
import TimGraph.run.BasicAnalysis;
import TimGraph.run.LineGraphCommunities;
import TimGraph.run.SetUpNetwork;
import TimGraph.timgraph;
import TimUtilities.FileUtilities.FileOutput;
import TimUtilities.StringUtilities.Filters.ImperialPapersFilter;
import TimUtilities.StringUtilities.Filters.TextFileProcessor;
import cern.colt.list.DoubleArrayList;
import java.util.TreeMap;

public class General {
    static final String SEP = "\t";
    static final Double LOG26 = Math.log(26.0);
    static final int ACHAR = 65;
    static String basicroot = "UNSET";
    static int infoLevel = 0;

    public static void main(String[] stringArray) {
        System.out.println("ImperialPapers.General Arguments :<networknumber> :<outputMode> :<basicAnalysis> :<minWeight> :<lambda>");
        int n = 111;
        int n2 = 0;
        if (stringArray.length > n2) {
            if (timgraph.isOtherArgument(stringArray[n2])) {
                if (stringArray[n2].charAt(1) == '?') {
                    SetUpNetwork.printNetworkTypes(System.out, "", "  ");
                    n = 0;
                } else {
                    n = Integer.parseInt(stringArray[n2].substring(1, stringArray[n2].length()));
                }
            } else {
                n = 0;
            }
        }
        System.out.println("--- Using network  " + SetUpNetwork.typeString(n));
        int n3 = 3;
        if (stringArray.length > ++n2 && timgraph.isOtherArgument(stringArray[n2])) {
            n3 = Integer.parseInt(stringArray[n2].substring(1, stringArray[n2].length()));
        }
        OutputMode outputMode = new OutputMode(n3);
        System.out.println("--- Output Mode " + n3 + ": " + outputMode.getModeString(" "));
        boolean bl = true;
        if (stringArray.length > ++n2 && timgraph.isOtherArgument(stringArray[n2]) && stringArray[n2].charAt(1) == 'y') {
            bl = true;
        }
        System.out.println("--- Basic analysis is " + (bl ? "on" : "off"));
        double d = 0.0;
        if (stringArray.length > ++n2 && timgraph.isOtherArgument(stringArray[n2])) {
            d = Double.parseDouble(stringArray[n2].substring(1, stringArray[n2].length()));
        }
        if (d > 0.0) {
            System.out.println("--- Minimum Weight is  " + d);
        } else {
            System.out.println("--- No Minimum Weight cut ");
        }
        double d2 = 0.0;
        if (stringArray.length > ++n2 && timgraph.isOtherArgument(stringArray[n2])) {
            d2 = Double.parseDouble(stringArray[n2].substring(1, stringArray[n2].length()));
        }
        if (d2 > 0.0) {
            System.out.println("--- lambda is  " + d2);
        } else {
            System.out.println("--- No lambda, no vertex partitions ");
        }
        if (d > 0.0) {
            DoubleArrayList doubleArrayList = new DoubleArrayList();
            double d3 = d;
            for (int i = 0; i < 4; ++i) {
                doubleArrayList.add(d3);
                doubleArrayList.add(d3 / 2.0);
                doubleArrayList.add(d3 / 5.0);
                d3 /= 10.0;
            }
            General.minEdgeWeight(n, doubleArrayList, n3, bl, stringArray);
            Runtime.getRuntime().exit(0);
        }
        if (n == 111 || n == 114) {
            SetUpNetwork.setUpNetwork(n, stringArray);
            --n;
        }
        if (n >= 110 && n < 120) {
            General.processOriginalFile(n, n3, bl, d2, stringArray);
        }
        if (n >= 120 && n < 130) {
            General.processTermTerm(n, n3, bl, d2, stringArray);
        }
        if (n >= 130 && n < 140) {
            General.processSections(n, n3, bl, stringArray);
        }
        if (n >= 140 && n < 150) {
            General.processPaperPaper(n, n3, bl, d2, stringArray);
        }
    }

    public static void processSections(int n, int n2, boolean bl, String[] stringArray) {
        SetUpNetwork setUpNetwork = new SetUpNetwork(infoLevel);
        System.out.println("\n *** Processing paper-unit graphs");
        timgraph timgraph2 = SetUpNetwork.setUpNetwork(n, stringArray);
        if (timgraph2.getNumberVertices() < 20) {
            timgraph2.printNetwork(true);
        }
        timgraph2.calcStrength();
        if (bl) {
            BasicAnalysis.analyse(timgraph2);
        }
        basicroot = timgraph2.inputName.getNameRoot();
        int n3 = basicroot.lastIndexOf(95);
        String string = basicroot.substring(n3 + 2, basicroot.length());
        String string2 = basicroot.substring(0, n3);
        BipartiteTransformations bipartiteTransformations = new BipartiteTransformations();
        int n4 = 0;
        int n5 = 2;
        int n6 = 0;
        int n7 = 2;
        double d = 1.0;
        System.out.println("\n *** " + string + "-" + string + " projection");
        timgraph timgraph3 = BipartiteTransformations.project(timgraph2, false, timgraph2.isVertexLabelled(), true, timgraph2.isVertexEdgeListOn(), true);
        timgraph3.setNameRoot(string2 + "_" + string);
        if (timgraph3.getNumberVertices() < 20) {
            timgraph3.printNetwork(true);
        }
        if (bl) {
            BasicAnalysis.analyse(timgraph3);
            TimGraph.io.FileOutput fileOutput = new TimGraph.io.FileOutput(timgraph3);
            fileOutput.pajek(false, false);
        }
        timgraph3.calcStrength();
        LineGraphCommunities.analyseGraph(timgraph3, n4, n5, n6, n7, d);
    }

    public static void processPaperPaper(int n, int n2, boolean bl, double d, String[] stringArray) {
        SetUpNetwork setUpNetwork = new SetUpNetwork(infoLevel);
        System.out.println("\n *** analysing paper-paper projection vertex partition");
        timgraph timgraph2 = SetUpNetwork.setUpNetwork(n, stringArray);
        if (timgraph2.getNumberVertices() < 20) {
            timgraph2.printNetwork(true);
        }
        if (bl) {
            BasicAnalysis.analyse(timgraph2);
        }
        timgraph2.calcStrength();
        if (d > 0.0) {
            System.out.println("\n *** Analysing vertex partitions of graph " + timgraph2.inputName.getNameRoot());
            int n3 = 0;
            int n4 = 2;
            int n5 = 0;
            int n6 = 2;
            VertexPartition vertexPartition = VertexPartition.calculate(timgraph2, n5, n6, d, n3, infoLevel);
            LineGraphCommunities.vertexPartitionGraphML(timgraph2, vertexPartition);
        }
    }

    public static void processTermTerm(int n, int n2, boolean bl, double d, String[] stringArray) {
        SetUpNetwork setUpNetwork = new SetUpNetwork(infoLevel);
        System.out.println("\n *** analysing term-term projection vertex partition");
        timgraph timgraph2 = SetUpNetwork.setUpNetwork(n, stringArray);
        if (timgraph2.getNumberVertices() < 20) {
            timgraph2.printNetwork(true);
        }
        if (bl) {
            BasicAnalysis.analyse(timgraph2);
        }
        timgraph2.calcStrength();
        if (d > 0.0) {
            System.out.println("\n *** Analysing vertex partitions of graph " + timgraph2.inputName.getNameRoot());
            int n3 = 0;
            int n4 = 2;
            int n5 = 0;
            int n6 = 2;
            VertexPartition vertexPartition = VertexPartition.calculate(timgraph2, n5, n6, d, n3, infoLevel);
            LineGraphCommunities.vertexPartitionGraphML(timgraph2, vertexPartition);
        }
    }

    public static void minEdgeWeight(int n, double d, int n2, boolean bl, String[] stringArray) {
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        doubleArrayList.add(d);
        General.minEdgeWeight(n, doubleArrayList, n2, bl, stringArray);
    }

    public static void minEdgeWeight(int n, DoubleArrayList doubleArrayList, int n2, boolean bl, String[] stringArray) {
        SetUpNetwork setUpNetwork = new SetUpNetwork(infoLevel);
        System.out.print("\n *** " + SetUpNetwork.typeString(n) + " projection cut on minimum edge weights of: ");
        for (int i = 0; i < doubleArrayList.size(); ++i) {
            System.out.print(doubleArrayList.get(i));
        }
        System.out.println();
        timgraph timgraph2 = SetUpNetwork.setUpNetwork(n, stringArray);
        if (timgraph2.getNumberVertices() < 20) {
            timgraph2.printNetwork(true);
        }
        boolean bl2 = timgraph2.isVertexLabelled();
        boolean bl3 = timgraph2.isWeighted();
        boolean bl4 = false;
        for (int i = 0; i < doubleArrayList.size(); ++i) {
            double d = doubleArrayList.get(i);
            timgraph timgraph3 = Projections.minimumEdgeWeight(timgraph2, d, bl2, bl3, bl4);
            timgraph3.setNameRoot(timgraph2.inputName.getNameRoot() + "ew" + Math.round(d * 1000.0));
            if (timgraph3.getNumberVertices() < 20) {
                timgraph3.printNetwork(true);
            }
            timgraph3.calcStrength();
            if (!bl) continue;
            BasicAnalysis.analyse(timgraph3);
        }
    }

    public static void preProcess(timgraph timgraph2, String string, boolean bl, int n, boolean bl2) {
        String string2 = timgraph2.inputName.getDirectoryFull() + string + "ptinputBVNLS.dat";
        String string3 = string + (bl ? "np" : "") + (n > 1 ? Integer.valueOf(n) : "") + "stem";
        String string4 = timgraph2.inputName.getDirectoryFull() + string3 + "ptinputBVNLS.dat";
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        TreeMap<String, Integer> treeMap2 = new TreeMap<String, Integer>();
        int n2 = 1;
        String string5 = SEP;
        ImperialPapersFilter imperialPapersFilter = new ImperialPapersFilter(2, 3, true);
        TextFileProcessor.processWordListFile(string2, string4, n2, bl, "\t ", treeMap, treeMap2, imperialPapersFilter, n, false);
        System.out.println("Stemming file " + string2 + ", taking every " + n + " lines only, paper gid " + (bl ? "converted to simple index" : "left as original string"));
        System.out.println("Applied " + imperialPapersFilter.description());
        System.out.println("Producing file " + string4);
        String string6 = timgraph2.outputName.getDirectoryFull() + string3 + "ptStemMap.dat";
        FileOutput.FileOutputMap(string6, string5, treeMap, true);
        string6 = timgraph2.outputName.getDirectoryFull() + string3 + "ptRejectList.dat";
        imperialPapersFilter.FileOutputRejectedList(string6, bl2);
    }

    public static void processOriginalFile(int n, int n2, boolean bl, double d, String[] stringArray) {
        SetUpNetwork setUpNetwork = new SetUpNetwork(infoLevel);
        timgraph timgraph2 = SetUpNetwork.setUpNetwork(n, stringArray);
        basicroot = timgraph2.inputName.getNameRoot();
        if (!timgraph2.inputName.getNameRoot().startsWith("IC")) {
            throw new RuntimeException("*** File read in does not start with IC, it was " + basicroot);
        }
        if (n2 >= 0) {
            timgraph2.outputControl.set(n2);
        }
        if (timgraph2.getNumberVertices() < 40) {
            timgraph2.printNetwork(true);
        }
        String string = basicroot.substring(0, basicroot.length() - 2);
        boolean bl2 = true;
        if (!bl2) {
            timgraph2.makeUnlabelled();
            string = string + "UL";
        }
        System.out.println("\n *** term-term projection");
        timgraph timgraph3 = BipartiteTransformations.project(timgraph2, false, timgraph2.isVertexLabelled(), true, timgraph2.isVertexEdgeListOn(), true);
        timgraph3.setNameRoot(string + "tt");
        if (timgraph3.getNumberVertices() < 20) {
            timgraph3.printNetwork(true);
        }
        if (bl) {
            BasicAnalysis.analyse(timgraph3);
        }
        System.out.println("\n *** paper-paper " + (bl2 ? "" : "unlabelled ") + "projection");
        timgraph timgraph4 = BipartiteTransformations.project(timgraph2, true, bl2, true, timgraph2.isVertexEdgeListOn(), true);
        timgraph4.setNameRoot(string + "pp");
        if (timgraph4.getNumberVertices() < 20) {
            timgraph4.printNetwork(true);
        }
        if (bl) {
            BasicAnalysis.analyse(timgraph4);
        }
        if (d <= 0.0) {
            return;
        }
        System.out.println("\n *** Vertex Communities");
        int n3 = 0;
        int n4 = 2;
        int n5 = 0;
        int n6 = 2;
        timgraph3.calcStrength();
        LineGraphCommunities.analyseGraph(timgraph3, n3, n4, n5, n6, d);
        timgraph4.calcStrength();
        LineGraphCommunities.analyseGraph(timgraph4, n3, n4, n5, n6, d);
        if (bl) {
            BasicAnalysis.analyse(timgraph2);
        }
    }
}

