/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run.ImperialPapers;

import JavaNotes.TextReader;
import JavaNotes.TextReaderTabSeparated;
import TimGraph.io.FileInput;
import TimGraph.run.ImperialPapers.Paper;
import TimGraph.run.ImperialPapers.SetOfPapers;
import TimGraph.run.ImperialPapers.UniversityOrganisation;
import TimUtilities.FileUtilities.FileNameSequence;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CitationReferences {
    static final String SEP = "\t";
    static String dirRoot = "/PRG/networks/timgraph/";
    UniversityOrganisation organisation;
    SetOfPapers setOfPapers;
    int infoLevel = 0;
    FileNameSequence inputName;
    FileNameSequence outputName;

    public static void main(String[] stringArray) {
        System.out.println("*** ImperialPapersCR");
        CitationReferences citationReferences = new CitationReferences();
        boolean bl = false;
        String string = "IC20090521";
        if (bl) {
            string = "ICtest20090521";
        }
        citationReferences.inputName = new FileNameSequence(dirRoot, "input/", string, "");
        citationReferences.outputName = new FileNameSequence(dirRoot, "output/", string, "");
        citationReferences.readPaperSectionFile(true);
        citationReferences.readPaperSectionFile(false);
        citationReferences.readPaperCitationsFile();
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        citationReferences.setOfPapers.outputPapers(citationReferences.outputName, SEP, bl2, bl3);
        citationReferences.organisation.outputFile(citationReferences.outputName, SEP, bl2, bl4);
        citationReferences.outputUnits(SEP, bl2);
        citationReferences.outputName.setNameRoot(string + "_psec");
        citationReferences.setOfPapers.makeGraphEdgeList(citationReferences.outputName, SEP, 1);
        citationReferences.outputName.setNameRoot(string + "_pdept");
        citationReferences.outputUnits(SEP, bl2, 1);
        citationReferences.setOfPapers.makeGraphEdgeList(citationReferences.outputName, SEP, citationReferences.organisation.getFilterFactor(1));
        citationReferences.outputName.setNameRoot(string);
        citationReferences.makeAllGRCYList();
        citationReferences.makeLevelGRCYList(0);
        citationReferences.makeLevelGRCYList(1);
    }

    public void makeLevelGRCYList(int n) {
        String string = this.organisation.getLevelName(n);
        this.outputName.setDirectoryEnd("output/" + string + "/");
        this.outputName.makeDirectories();
        int n2 = this.organisation.getNumber(n);
        for (int i = 1; i < n2; ++i) {
            HashSet<Paper> hashSet = this.makeUnitSubList(i, n);
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = true;
            String string2 = this.organisation.getNameFromLocalIndex(i, n);
            string2 = UniversityOrganisation.toFileName(string2);
            this.outputName.setNameRoot(this.inputName.getNameRoot() + string2);
            SetOfPapers.outputGRCYList(this.outputName, SEP, hashSet, bl, bl2, bl3);
        }
    }

    public void makeAllGRCYList() {
        this.outputName.setDirectoryEnd("output/");
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        this.outputName.setNameRoot(this.inputName.getNameRoot() + "All");
        this.setOfPapers.outputAllGRCYList(this.outputName, SEP, bl, bl2, bl3);
    }

    public HashSet<Paper> makeUnitSubList(int n, int n2) {
        HashSet<Paper> hashSet = new HashSet<Paper>();
        Collection<Paper> collection = this.setOfPapers.getPapers();
        block0: for (Paper paper : collection) {
            for (Integer n3 : paper.getSections()) {
                if (!this.organisation.isInUnit(n3, n, n2)) continue;
                hashSet.add(paper);
                continue block0;
            }
        }
        return hashSet;
    }

    public void printUnits(PrintStream printStream, String string, boolean bl, int n) {
        TreeSet<Integer> treeSet = this.setOfPapers.getAllUnitsUsed();
        if (bl) {
            printStream.println("index" + string + this.organisation.levelNameString(string));
        }
        TreeSet<Object> treeSet2 = new TreeSet();
        int n2 = this.organisation.getFilterFactor(n);
        if (n2 == 1) {
            treeSet2 = treeSet;
        } else {
            for (Integer n3 : treeSet) {
                treeSet2.add(n3 / n2);
            }
        }
        for (Integer n3 : treeSet2) {
            printStream.print(n3);
            String[] stringArray = this.organisation.getName(n3 * n2, n);
            for (int i = 0; i < stringArray.length; ++i) {
                printStream.print(string + stringArray[i]);
            }
            printStream.println();
        }
    }

    public void outputUnits(String string, boolean bl) {
        this.outputName.setNameEnd("UsedUnits.dat");
        this.outputUnits(this.outputName.getFullFileName(), string, bl, UniversityOrganisation.NUMBERLEVELS - 1);
    }

    public void outputUnits(String string, boolean bl, int n) {
        this.outputName.setNameEnd("UsedUnits.dat");
        this.outputUnits(this.outputName.getFullFileName(), string, bl, n);
    }

    public void outputUnits(String string, String string2, boolean bl, int n) {
        if (this.infoLevel > -2) {
            System.out.println("Writing list of all " + this.organisation.getLevelNamePlural(n) + " used to " + string);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.printUnits(printStream, string2, bl, n);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing list of all " + this.organisation.getLevelNamePlural(n) + " units used to " + string);
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("*** File Error with " + string + ", " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + string + ", " + fileNotFoundException.getMessage());
            return;
        }
    }

    public int readPaperSectionFile(boolean bl) {
        this.inputName.setNameEnd("sections.txt");
        return this.readPaperSectionFile(this.inputName.getFullFileName(), bl);
    }

    public int readPaperSectionFile(String string, boolean bl) {
        int n = 4;
        if (bl) {
            this.organisation = new UniversityOrganisation();
        } else {
            this.setOfPapers = new SetOfPapers();
        }
        int n2 = 0;
        TextReaderTabSeparated textReaderTabSeparated = FileInput.openTabSeparatedFile(string);
        if (textReaderTabSeparated == null) {
            return -1;
        }
        if (n2 < 0) {
            return n2;
        }
        System.out.println("Starting to read paper section list from " + string + " and " + (bl ? "creating orgainisation" : "setting up set of papers"));
        try {
            System.out.println(" File: " + string);
            int n3 = 0;
            while (!textReaderTabSeparated.eof()) {
                ++n3;
                if (this.infoLevel > 2) {
                    System.out.println(n3 + ": ");
                }
                int n4 = 0;
                String string2 = textReaderTabSeparated.getln();
                String[] stringArray = string2.split(SEP, n + 1);
                if (stringArray.length > n) {
                    System.out.println("!!! Warning - line " + n3 + " does not have " + n + " columns but has " + stringArray.length);
                }
                if (this.infoLevel > 1) {
                    System.out.print(n3);
                    for (int i = 0; i < stringArray.length; ++i) {
                        System.out.print(", " + stringArray[i]);
                    }
                    System.out.println();
                }
                try {
                    if (stringArray.length < 4) {
                        System.out.println("!!! Warning too few columns on line " + n3 + ", found " + n4 + ", column 0=" + stringArray[0]);
                        String[] stringArray2 = new String[n];
                        for (int i = stringArray.length; i < n; ++i) {
                            stringArray2[i] = i < stringArray.length ? stringArray[i] : "";
                        }
                        stringArray = stringArray2;
                    }
                    if (bl) {
                        if (stringArray[2].length() == 0 && stringArray[3].length() > 0) {
                            System.out.println("at line " + n3);
                        }
                        this.organisation.addSection(stringArray[1], stringArray[2], stringArray[3]);
                        continue;
                    }
                    int n5 = this.organisation.getUnitIndex(stringArray[1], stringArray[2], stringArray[3]);
                    this.setOfPapers.addUnitsToPaper(stringArray[0], n5);
                }
                catch (RuntimeException runtimeException) {
                    throw new RuntimeException("*** PROBLEM on line " + n3 + ", " + runtimeException.getMessage());
                }
            }
            System.out.println("Finished reading Paper-Sections File from " + string);
            if (bl) {
                System.out.println("... " + this.organisation.informationSetString(" "));
            }
        }
        catch (TextReader.Error error) {
            throw new RuntimeException("*** Input Error: " + error.getMessage());
        }
        finally {
            textReaderTabSeparated.close();
        }
        if (bl) {
            this.organisation.finishSetUp();
            System.out.println("... finished setting up organisation");
        } else {
            this.setOfPapers.sortSections();
            System.out.println("... finished setting up set of papers");
        }
        return n2;
    }

    public int readPaperCitationsFile() {
        this.inputName.setNameEnd("citations.txt");
        return this.readPaperCitationsFile(this.inputName.getFullFileName());
    }

    public int readPaperCitationsFile(String string) {
        int n = 5;
        int n2 = 0;
        TextReaderTabSeparated textReaderTabSeparated = FileInput.openTabSeparatedFile(string);
        if (textReaderTabSeparated == null) {
            return -1;
        }
        if (n2 < 0) {
            return n2;
        }
        System.out.println("Starting to read paper citations list from " + string);
        try {
            System.out.println(" File: " + string);
            int n3 = 0;
            while (!textReaderTabSeparated.eof()) {
                ++n3;
                if (this.infoLevel > 2) {
                    System.out.println(n3 + ": ");
                }
                boolean bl = false;
                String string2 = textReaderTabSeparated.getln();
                String[] stringArray = string2.split(SEP, n + 1);
                if (this.infoLevel > 1) {
                    System.out.print(n3);
                    for (int i = 0; i < stringArray.length; ++i) {
                        System.out.print(", " + stringArray[i]);
                    }
                    System.out.println();
                }
                try {
                    if (stringArray.length != n) {
                        System.out.println("!!! WARNING Wrong number of columns on line " + n3 + ", found " + stringArray.length);
                        n2 = -10;
                    }
                    String string3 = stringArray[0];
                    int n4 = this.tryIntegerParse(stringArray[1], "year", n3);
                    String string4 = stringArray[2];
                    int n5 = this.tryIntegerParse(stringArray[3], "citations", n3);
                    int n6 = this.tryIntegerParse(stringArray[4], "references", n3);
                    Paper paper = this.setOfPapers.getPaper(string3);
                    paper.setYear(n4);
                    paper.setDate(string4);
                    paper.setCitations(n5);
                    paper.setReferences(n6);
                }
                catch (RuntimeException runtimeException) {
                    throw new RuntimeException("*** PROBLEM on line " + n3 + ", " + runtimeException.getMessage());
                }
            }
            System.out.println("Finished reading Paper-Sections File from " + string);
        }
        catch (TextReader.Error error) {
            throw new RuntimeException("*** Input Error: " + error.getMessage());
        }
        finally {
            textReaderTabSeparated.close();
        }
        return n2;
    }

    private int tryIntegerParse(String string, String string2, int n) {
        int n2 = -1;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (RuntimeException runtimeException) {
            System.out.println("!!! WARNING problem with " + string2 + " \"" + string + "\" on line " + n);
        }
        return n2;
    }
}

