/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run;

import DataAnalysis.EntropyStatistics;
import DataAnalysis.MutualInformation;
import DataAnalysis.MutualInformationStatistics;
import TimGraph.Community.Community;
import TimGraph.Community.QualitySparse;
import TimGraph.Community.QualityType;
import TimGraph.Community.VertexPartition;
import TimGraph.io.FileOutput;
import TimGraph.run.LineGraphCommunities;
import TimGraph.run.MakeVertexPartition;
import TimGraph.timgraph;
import TimUtilities.StringUtilities.Filters.StringFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class CompareVertexPartitions {
    static final String SEP = "\t";
    static String basicroot = "UNSET";
    int infoLevel = 0;
    EntropyStatistics sStats;
    EntropyStatistics sStatsTwo;
    MutualInformationStatistics miStats;

    public static void main(String[] stringArray) {
        boolean bl = true;
        System.out.println("CompareVertexPartitions Arguments :<method> :<qualitydef> :<qualitytype> :<gammaMin> :<gammaMax> :<gammaStep> :<graphMLOn> :<numberRuns>");
        int n = 0;
        int n2 = 0;
        if (stringArray.length > n && timgraph.isOtherArgument(stringArray[n])) {
            n2 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        System.out.println("--- Using community method " + LineGraphCommunities.COMMUNITYMETHOD[n2]);
        int n3 = 0;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            n3 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        System.out.println("--- Quality definition used " + QualitySparse.QdefinitionString[n3]);
        int n4 = 2;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            n4 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        System.out.println("--- Quality class type " + QualityType.qualityLongName[n4]);
        double d = 1.0;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            d = Double.parseDouble(stringArray[n].substring(1, stringArray[n].length()));
        }
        double d2 = d + 0.25;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            d2 = Double.parseDouble(stringArray[n].substring(1, stringArray[n].length()));
        }
        double d3 = 0.001;
        double d4 = 0.1;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            d4 = Double.parseDouble(stringArray[n].substring(1, stringArray[n].length()));
        }
        if (Math.abs(d4) < d3) {
            throw new RuntimeException("Step size must be greater than " + d3 + " in magnitude");
        }
        System.out.println("--- Modularity null model scaling gamma min, max step =" + d + "  " + d2 + "  " + d4);
        int n5 = 3;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            n5 = Math.max(1, Integer.parseInt(stringArray[n].substring(1, stringArray[n].length())));
        }
        System.out.println("--- Number of runs for each gamma value =" + n5);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            bl3 = StringFilter.trueString(stringArray[n].charAt(1));
        }
        System.out.println("--- file output is " + StringFilter.onOffString(bl2));
        System.out.println("--- graphML output is " + StringFilter.onOffString(bl3));
        System.out.println("--- projected graph output is " + StringFilter.onOffString(bl4));
        String string = "karateTSE";
        String[] stringArray2 = new String[]{"-gvet", "-gdf", "-gewf", "-gvlt", "-gelf", "-gbf", "-fin" + string, "-fieinputELS.dat", "-gn99", "-e0", "-o23", "-xi0"};
        if (stringArray.length > 0) {
            stringArray2 = stringArray;
        }
        timgraph timgraph2 = new timgraph();
        timgraph2.parseParam(stringArray2);
        if (!timgraph2.isVertexEdgeListOn()) {
            System.err.println("\n *** Vertex Edge List NOT on and it is required, use -vgvet option ***\n");
        }
        timgraph2.setNameRoot(timgraph2.inputName.getNameRoot());
        timgraph2.setNetworkFromInputFile();
        timgraph2.printParametersBasic();
        timgraph2.calcStrength();
        CompareVertexPartitions compareVertexPartitions = new CompareVertexPartitions();
        compareVertexPartitions.compareUsingMethodFluctuations(timgraph2, n3, n4, d, d2, d4, n2, n5, bl2, bl3, bl4);
        compareVertexPartitions.compareUsingLouvainDeltaGamma(timgraph2, n3, n4, d, d2, d4, n2, n5, bl2, bl3, bl4);
        compareVertexPartitions.compareUsingRandomisedGraph(timgraph2, n3, n4, d, d2, d4, n2, n5, bl2, bl3, bl4);
    }

    public void compareUsingRandomisedGraph(timgraph timgraph2, int n, int n2, double d, double d2, double d3, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        System.out.println("Comparing Vertex Partitions against randomised graphs");
        FileOutput fileOutput = new FileOutput(timgraph2);
        String string = "_r" + n4 + "_" + Math.round(1000.0 * d) + "_" + Math.round(1000.0 * d2) + "_" + Math.round(1000.0 * d3) + "Rand_gamma.dat";
        fileOutput.fileName.setNameEnd(string);
        VertexPartition[] vertexPartitionArray = new VertexPartition[n4];
        VertexPartition[] vertexPartitionArray2 = new VertexPartition[n4];
        this.sStats = new EntropyStatistics("G(g)_");
        this.sStatsTwo = new EntropyStatistics("Rand_");
        this.miStats = new MutualInformationStatistics();
        timgraph timgraph3 = timgraph2;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(fileOutput.fileName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println("name\tgamma\t" + this.sStats.toLabel(SEP) + SEP + this.sStatsTwo.toLabel(SEP) + SEP + this.miStats.toLabel(SEP));
            for (double d4 = d; d4 <= d2 && !(d4 <= 0.0); d4 += d3) {
                System.out.println("\n--- gamma=" + String.format("%6.3f", d4) + " ----------------------------------------------------");
                for (int i = 0; i < n4; ++i) {
                    VertexPartition vertexPartition;
                    vertexPartitionArray[i] = vertexPartition = MakeVertexPartition.calculateVertexPartition(timgraph2, n, n2, d4, n3, i, this.infoLevel, bl, bl2, bl3);
                    timgraph3 = new timgraph(timgraph2, timgraph2.getMaximumVertices(), timgraph2.getMaximumStubs(), false, false, false);
                    timgraph3.randomiseGraph();
                    timgraph3.addToNameRoot("Rand");
                    VertexPartition vertexPartition2 = MakeVertexPartition.calculateVertexPartition(timgraph3, n, n2, d4, n3, i, this.infoLevel, bl, bl2, bl3);
                    vertexPartitionArray2[i] = vertexPartition;
                }
                this.doComparison(vertexPartitionArray, vertexPartitionArray2);
                System.out.println(this.sStats.averagesLabel(SEP) + SEP + this.sStatsTwo.averagesLabel(SEP) + SEP + this.miStats.averagesLabel(SEP));
                System.out.println(this.sStats.averagesString(SEP) + SEP + this.sStatsTwo.averagesString(SEP) + SEP + this.miStats.averagesString(SEP));
                printStream.println(vertexPartitionArray[0].getName() + SEP + d4 + SEP + this.sStats.toString(SEP) + SEP + this.sStatsTwo.toString(SEP) + SEP + this.miStats.toString(SEP));
            }
            if (this.infoLevel > -1) {
                System.out.println("Finished writing VP various gamma information file to " + fileOutput.fileName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + fileOutput.fileName.getFullFileName() + ", " + fileNotFoundException.getMessage());
            return;
        }
    }

    public void compareUsingLouvainDeltaGamma(timgraph timgraph2, int n, int n2, double d, double d2, double d3, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        System.out.println("Comparing Vertex Partitions for gamma against gamma-delta gamma");
        FileOutput fileOutput = new FileOutput(timgraph2);
        String string = "_r" + n4 + "_" + Math.round(1000.0 * d) + "_" + Math.round(1000.0 * d2) + "_" + Math.round(1000.0 * d3) + "dgamma_gamma.dat";
        fileOutput.fileName.setNameEnd(string);
        VertexPartition[] vertexPartitionArray = new VertexPartition[n4];
        VertexPartition[] vertexPartitionArray2 = new VertexPartition[n4];
        this.sStats = new EntropyStatistics("G(g)_");
        this.sStatsTwo = new EntropyStatistics("G(g-dg)_");
        this.miStats = new MutualInformationStatistics();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(fileOutput.fileName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println("name1\tname2\tgamma\t" + this.sStats.toLabel(SEP) + SEP + this.sStatsTwo.toLabel(SEP) + SEP + this.miStats.toLabel(SEP));
            for (double d4 = d; d4 <= d2 && !(d4 <= 0.0); d4 += d3) {
                System.out.println("\n--- gamma=" + String.format("%6.3f", d4) + " ----------------------------------------------------");
                for (int i = 0; i < n4; ++i) {
                    VertexPartition vertexPartition = MakeVertexPartition.calculateVertexPartition(timgraph2, n, n2, d4, n3, i, this.infoLevel, bl, bl2, bl3);
                    vertexPartitionArray2[i] = vertexPartitionArray[i];
                    vertexPartitionArray[i] = vertexPartition;
                }
                if (!(d4 > d)) continue;
                this.doComparison(vertexPartitionArray, vertexPartitionArray2);
                System.out.println(this.sStats.averagesLabel(SEP) + SEP + this.sStatsTwo.averagesLabel(SEP) + SEP + this.miStats.averagesLabel(SEP));
                System.out.println(this.sStats.averagesString(SEP) + SEP + this.sStatsTwo.averagesString(SEP) + SEP + this.miStats.averagesString(SEP));
                printStream.println(vertexPartitionArray[0].getName() + SEP + vertexPartitionArray2[0].getName() + SEP + d4 + SEP + this.sStats.toString(SEP) + SEP + this.sStatsTwo.toString(SEP) + SEP + this.miStats.toString(SEP));
            }
            if (this.infoLevel > -1) {
                System.out.println("Finished writing VP various gamma information file to " + fileOutput.fileName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + fileOutput.fileName.getFullFileName() + ", " + fileNotFoundException.getMessage());
            return;
        }
    }

    public void compareUsingMethodFluctuations(timgraph timgraph2, int n, int n2, double d, double d2, double d3, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        System.out.println("Comparing Vertex Partitions for gamma against each other");
        FileOutput fileOutput = new FileOutput(timgraph2);
        String string = "_r" + n4 + "_" + Math.round(1000.0 * d) + "_" + Math.round(1000.0 * d2) + "_" + Math.round(1000.0 * d3) + "_gamma.dat";
        fileOutput.fileName.setNameEnd(string);
        VertexPartition[] vertexPartitionArray = new VertexPartition[n4];
        VertexPartition[] vertexPartitionArray2 = new VertexPartition[n4];
        this.sStats = new EntropyStatistics("G(g)_");
        this.miStats = new MutualInformationStatistics();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(fileOutput.fileName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println("name\tgamma\t" + this.sStats.toLabel(SEP) + SEP + this.miStats.toLabel(SEP));
            for (double d4 = d; d4 <= d2 && !(d4 <= 0.0); d4 += d3) {
                System.out.println("\n--- gamma=" + String.format("%6.3f", d4) + " ----------------------------------------------------");
                for (int i = 0; i < n4; ++i) {
                    VertexPartition vertexPartition;
                    vertexPartitionArray[i] = vertexPartition = MakeVertexPartition.calculateVertexPartition(timgraph2, n, n2, d4, n3, i, this.infoLevel, bl, bl2, bl3);
                }
                this.doComparison(vertexPartitionArray);
                System.out.println(this.sStats.averagesLabel(SEP) + SEP + this.miStats.averagesLabel(SEP));
                System.out.println(this.sStats.averagesString(SEP) + SEP + this.miStats.averagesString(SEP));
                printStream.println(vertexPartitionArray[0].getName() + SEP + d4 + SEP + this.sStats.toString(SEP) + SEP + this.miStats.toString(SEP));
            }
            if (this.infoLevel > -1) {
                System.out.println("Finished writing VP various gamma information file to " + fileOutput.fileName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + fileOutput.fileName.getFullFileName() + ", " + fileNotFoundException.getMessage());
            return;
        }
    }

    public void doComparison(VertexPartition[] vertexPartitionArray) {
        int n = vertexPartitionArray.length;
        this.miStats.reset();
        this.sStats.reset();
        for (int i = 0; i < vertexPartitionArray.length; ++i) {
            for (int j = i + 1; j < vertexPartitionArray.length; ++j) {
                MutualInformation mutualInformation = Community.calcMutualInformation(vertexPartitionArray[i], vertexPartitionArray[j], null);
                this.miStats.add(mutualInformation);
                if (j != i + 1) continue;
                this.sStats.addTwo(mutualInformation);
                if (i != 0) continue;
                this.sStats.addOne(mutualInformation);
            }
        }
    }

    public void doComparison(VertexPartition[] vertexPartitionArray, VertexPartition[] vertexPartitionArray2) {
        this.miStats.reset();
        this.sStats.reset();
        this.sStatsTwo.reset();
        for (int i = 0; i < vertexPartitionArray.length; ++i) {
            for (int j = 0; j < vertexPartitionArray2.length; ++j) {
                MutualInformation mutualInformation = Community.calcMutualInformation(vertexPartitionArray[i], vertexPartitionArray2[j], null);
                this.miStats.add(mutualInformation);
                if (j != i) continue;
                this.sStatsTwo.addTwo(mutualInformation);
                this.sStats.addOne(mutualInformation);
            }
        }
    }
}

