/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.run;

import DataAnalysis.MutualInformation;
import TimGraph.Community.Community;
import TimGraph.Community.VertexCommunity;
import TimGraph.run.BasicAnalysis;
import TimGraph.run.SetUpNetwork;
import TimGraph.timgraph;
import TimUtilities.StringUtilities.Filters.StringFilter;
import java.util.TreeMap;

public class CompareVertexCommunities {
    static final String SEP = "\t";
    static String basicroot = "UNSET";
    static int infoLevel = 0;

    public static void main(String[] stringArray) {
        System.out.println("CompareVertexCommunities Arguments: fileName1 fileName2 outputNameRoot");
        String string = "input/TestVertexPartition1inputBVNLS.dat";
        int n = 0;
        if (stringArray.length > n) {
            string = stringArray[n];
        }
        System.out.println("--- Using network one " + string);
        String string2 = "input/TestVertexPartition2inputBVNLS.dat";
        if (stringArray.length > ++n) {
            string2 = stringArray[n];
        }
        System.out.println("--- Using network two " + string2);
        String string3 = "output/TestVP_1_2";
        if (stringArray.length > ++n) {
            string3 = stringArray[n];
        }
        System.out.println("--- Output to  " + string3);
        MutualInformation mutualInformation = CompareVertexCommunities.doComparision(string, string2);
        System.out.println(MutualInformation.toStringLabelDescriptive(" : "));
        if (mutualInformation.getOrderOne() < 10 && mutualInformation.getOrderTwo() < 10) {
            System.out.println(MutualInformation.toStringLabel(" : "));
            System.out.println(mutualInformation.toString(" : "));
        }
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        mutualInformation.printToFile(string3, "", SEP, bl, bl2, bl3, bl4, bl5);
        mutualInformation.printToFile(string3, "", SEP, bl, !bl2, bl3, bl4, bl5);
        mutualInformation.printSummary(System.out, "", SEP, bl);
    }

    public static MutualInformation doComparision(String string, String string2) {
        TreeMap<String, Integer> treeMap = null;
        boolean bl = true;
        boolean bl2 = true;
        VertexCommunity vertexCommunity = new VertexCommunity(string);
        String string3 = StringFilter.beforeLastString(StringFilter.afterLastString(string, "/"), ".");
        vertexCommunity.setName(string3);
        vertexCommunity.readVertexCommunity(string, treeMap, bl, bl2);
        if (vertexCommunity.getNumberElements() < 20) {
            vertexCommunity.printCommunityMatrix(System.out, "", " : ");
        }
        VertexCommunity vertexCommunity2 = new VertexCommunity(string2);
        String string4 = StringFilter.beforeLastString(StringFilter.afterLastString(string2, "/"), ".");
        vertexCommunity2.setName(string4);
        vertexCommunity2.readVertexCommunity(string2, treeMap, bl, bl2);
        if (vertexCommunity2.getNumberElements() < 20) {
            vertexCommunity2.printCommunityMatrix(System.out, "", " : ");
        }
        return CompareVertexCommunities.doComparision(vertexCommunity, vertexCommunity2);
    }

    static MutualInformation doComparision(VertexCommunity vertexCommunity, VertexCommunity vertexCommunity2) {
        MutualInformation mutualInformation = Community.calcMutualInformation(vertexCommunity, vertexCommunity2, null);
        if (mutualInformation == null) {
            throw new RuntimeException("Community.calcMutualInformation failed to produce anything");
        }
        int n = mutualInformation.checkNormalisations();
        if (n > 0) {
            throw new RuntimeException("Normalisation failure, " + mutualInformation.checkNormalisationsString(n));
        }
        System.out.println(" --- " + mutualInformation.checkNormalisationsString(n));
        n = mutualInformation.checkConsistentcy();
        if (n < 0) {
            throw new RuntimeException("Consistency Failure");
        }
        System.out.println(" --- Consistent probabilties");
        return mutualInformation;
    }

    public static timgraph makeVertexPartition(int n, int n2, boolean bl, String[] stringArray) {
        SetUpNetwork setUpNetwork = new SetUpNetwork(infoLevel);
        timgraph timgraph2 = SetUpNetwork.setUpNetwork(n, stringArray);
        if (n2 >= 0) {
            timgraph2.outputControl.set(n2);
        }
        if (timgraph2.getNumberVertices() < 40) {
            timgraph2.printNetwork(true);
        }
        if (bl) {
            BasicAnalysis.analyse(timgraph2);
        }
        return timgraph2;
    }

    public static timgraph processNetworkFile(int n, int n2, boolean bl, String[] stringArray) {
        SetUpNetwork setUpNetwork = new SetUpNetwork(infoLevel);
        timgraph timgraph2 = SetUpNetwork.setUpNetwork(n, stringArray);
        if (n2 >= 0) {
            timgraph2.outputControl.set(n2);
        }
        if (timgraph2.getNumberVertices() < 40) {
            timgraph2.printNetwork(true);
        }
        if (bl) {
            BasicAnalysis.analyse(timgraph2);
        }
        return timgraph2;
    }
}

