/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.io;

import JavaNotes.TextReader;
import TimGraph.VertexLabel;
import TimGraph.timgraph;
import java.util.ArrayList;
import java.util.TreeMap;

public class InputGML {
    static final String UNSET = "UNSET";
    static final int IUNSET = -918273645;
    static final double DUNSET = -9.182736E45;
    static final String STARTSTRING = "[";
    static final String ENDSTRING = "]";
    boolean weightsOn = false;
    public boolean directedGraph = false;
    public int infoLevel = 0;
    TextReader data;
    public TreeMap<Integer, Integer> nodeIDToIndex;
    public ArrayList<Integer> nodeID;
    public ArrayList<String> nodeLabel;
    public ArrayList<Integer> nodeValue;
    public TreeMap<Integer, Integer> edgeIDToIndex;
    public ArrayList<Integer> edgeSource;
    public ArrayList<Integer> edgeTarget;
    public ArrayList<Double> edgeWeight;

    public InputGML(TextReader textReader, boolean bl) {
        this.weightsOn = bl;
        this.data = textReader;
    }

    public void findGraph() {
        String string = UNSET;
        String string2 = "graph";
        if (this.findNextWord(string2).startsWith(UNSET)) {
            throw new RuntimeException("No line stating with " + string2 + " found before end of file");
        }
        if (this.findNextWord(STARTSTRING).startsWith(UNSET)) {
            throw new RuntimeException("Object " + string2 + " had no starting string " + STARTSTRING + " before end of file");
        }
        if (this.infoLevel > 1) {
            System.out.println("Found " + string2 + " object and start string " + STARTSTRING);
        }
        this.nodeIDToIndex = new TreeMap();
        this.nodeID = new ArrayList();
        this.nodeLabel = new ArrayList();
        this.nodeValue = new ArrayList();
        this.edgeSource = new ArrayList();
        this.edgeTarget = new ArrayList();
        if (this.weightsOn) {
            this.edgeWeight = new ArrayList();
        }
        while (!this.data.eof()) {
            string = this.data.getWord();
            if (this.infoLevel > 1) {
                System.out.println("s=\"" + string + "\"");
            }
            if (string.startsWith(ENDSTRING)) break;
            if (string.startsWith("directed")) {
                string = this.data.getWord();
                if (string.startsWith("1")) {
                    this.directedGraph = true;
                }
                if (string.startsWith("0")) {
                    this.directedGraph = false;
                }
                if (this.infoLevel <= 1) continue;
                System.out.println("Found directed keyword, value=" + (this.directedGraph ? "true" : "false"));
                continue;
            }
            if (string.startsWith("node")) {
                this.nodeObject();
                continue;
            }
            if (!string.startsWith("edge")) continue;
            this.edgeObject();
        }
        if (!string.startsWith(ENDSTRING)) {
            throw new RuntimeException("File ended before " + string2 + "  closed by " + ENDSTRING);
        }
        if (this.infoLevel > 1) {
            System.out.println("Found end string " + string + " for object " + string2);
        }
    }

    private void nodeObject() {
        String string = UNSET;
        String string2 = "node";
        if (this.findNextWord(STARTSTRING).equals(UNSET)) {
            throw new RuntimeException("No opening [ found for " + string2);
        }
        int n = -918273645;
        String string3 = UNSET;
        int n2 = -918273645;
        while (!this.data.eof() && !(string = this.data.getWord()).startsWith(ENDSTRING)) {
            if (string.startsWith("id")) {
                n = this.data.getInt();
                continue;
            }
            if (string.startsWith("label")) {
                string3 = this.processLabel(this.data.getWord());
                continue;
            }
            if (!string.startsWith("value")) continue;
            n2 = this.data.getInt();
        }
        if (!string.startsWith(ENDSTRING)) {
            throw new RuntimeException("File ended before " + string2 + "  closed by " + ENDSTRING);
        }
        this.nodeIDToIndex.put(n, this.nodeID.size());
        this.nodeLabel.add(string3);
        this.nodeValue.add(n2);
        this.nodeID.add(n);
        if (this.infoLevel > 1) {
            System.out.println("Found node " + (this.nodeID.size() - 1) + " id=" + this.valueString(n) + " label=" + string3);
        }
    }

    private void edgeObject() {
        String string = UNSET;
        String string2 = "edge";
        if (this.findNextWord(STARTSTRING).equals(UNSET)) {
            throw new RuntimeException("No opening [ found for " + string2);
        }
        int n = -918273645;
        int n2 = -918273645;
        double d = -9.182736E45;
        while (!this.data.eof() && !(string = this.data.getWord()).startsWith(ENDSTRING)) {
            if (string.startsWith("source")) {
                n = this.data.getInt();
                continue;
            }
            if (string.startsWith("target")) {
                n2 = this.data.getInt();
                continue;
            }
            if (!string.startsWith("value")) continue;
            d = this.data.getDouble();
        }
        if (!string.startsWith(ENDSTRING)) {
            throw new RuntimeException("File ended before " + string2 + "  closed by " + ENDSTRING);
        }
        if (n == -918273645 || n2 == -918273645) {
            throw new RuntimeException("Edge " + this.edgeSource.size() + " has bad source or target vertex");
        }
        if (this.weightsOn && d == -9.182736E45) {
            throw new RuntimeException("Edge " + this.edgeSource.size() + " has bad weight ");
        }
        this.edgeSource.add(n);
        this.edgeTarget.add(n2);
        if (this.weightsOn) {
            this.edgeWeight.add(d);
        }
        if (this.infoLevel > 1) {
            string = " source=" + this.valueString(n) + " target=" + this.valueString(n2);
            if (this.weightsOn) {
                string = string + " weight=" + this.valueString(d);
            }
            System.out.println("Found edge " + (this.edgeSource.size() - 1) + string);
        }
    }

    private String findNextWord(String string) {
        while (!this.data.eof()) {
            String string2 = this.data.getWord();
            if (this.infoLevel > 1) {
                System.out.println("s=\"" + string2 + "\"");
            }
            if (!string2.startsWith(string)) continue;
            return string2;
        }
        return UNSET;
    }

    public int setTimGraph(timgraph timgraph2, boolean bl, boolean bl2) {
        int n;
        timgraph2.setDirectedGraph(this.directedGraph);
        timgraph2.setNetwork(this.nodeID.size(), this.edgeSource.size() * 2);
        Integer n2 = new Integer(-918273645);
        Integer n3 = new Integer(-918273645);
        VertexLabel vertexLabel = new VertexLabel();
        for (n = 0; n < this.nodeID.size(); ++n) {
            if (timgraph2.isVertexLabelled()) {
                n2 = this.nodeID.get(n);
                if (n2 == -918273645) {
                    n2 = n;
                }
                n3 = this.nodeValue.get(n);
                String string = this.nodeLabel.get(n);
                if (string.equals(UNSET)) {
                    string = Integer.toString(n);
                }
                vertexLabel.setName(string);
                if (n3 == -918273645) {
                    vertexLabel.setNumber(n2);
                } else {
                    vertexLabel.setNumber(n3);
                }
                timgraph2.addVertex(vertexLabel);
                continue;
            }
            timgraph2.addVertex();
        }
        n = -918273645;
        int n4 = -918273645;
        int n5 = -918273645;
        int n6 = -918273645;
        double d = -9.182736E45;
        for (int i = 0; i < this.edgeSource.size(); ++i) {
            n = this.edgeSource.get(i);
            n4 = this.edgeTarget.get(i);
            n5 = this.nodeIDToIndex.get(n);
            n6 = this.nodeIDToIndex.get(n4);
            if (timgraph2.isWeighted()) {
                timgraph2.addEdge(n5, n6, this.edgeWeight.get(i));
                continue;
            }
            timgraph2.addEdge(n5, n6);
        }
        return 0;
    }

    public String processLabel(String string) {
        int n;
        int n2 = 0;
        if (string.charAt(0) == '\"') {
            n2 = 1;
        }
        if (string.charAt((n = string.length()) - 1) == '\"') {
            --n;
        }
        return string.substring(n2, n);
    }

    public int getNumberVertices() {
        return this.nodeID.size();
    }

    public int getNumberEdges() {
        return this.edgeSource.size();
    }

    private String valueString(int n) {
        String string = n == -918273645 ? "Unset" : Integer.toString(n);
        return string;
    }

    private String valueString(double d) {
        String string = d == -9.182736E45 ? "Unset" : Double.toString(d);
        return string;
    }
}

