/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.io;

import TimGraph.Community.VertexPartition;
import TimGraph.timgraph;
import TimUtilities.JavaColours;
import java.io.PrintStream;

public class GraphViz {
    public void output(PrintStream printStream, timgraph timgraph2, boolean bl) {
        String string = "";
        string = "\"" + timgraph2.outputName.getNameRoot() + "\"";
        printStream.println("graph " + string + "{");
        this.edgeList(printStream, timgraph2, bl);
        printStream.println("}");
    }

    public void outputVertexCommunity(PrintStream printStream, timgraph timgraph2, VertexPartition vertexPartition, boolean bl) {
        String string = "";
        string = "\"" + timgraph2.outputName.getNameRoot() + "\"";
        printStream.println("graph " + string + "{");
        this.vertexList(printStream, timgraph2, vertexPartition);
        this.edgeList(printStream, timgraph2, bl);
        printStream.println("}");
    }

    public void vertexList(PrintStream printStream, timgraph timgraph2, VertexPartition vertexPartition) {
        JavaColours javaColours = new JavaColours(vertexPartition.getNumberOfCommunities() + 2, true);
        javaColours.printAllColours(System.out);
        for (int i = 0; i < timgraph2.getNumberVertices(); ++i) {
            printStream.println(i + "  [ color = \"#" + javaColours.RGB(vertexPartition.getCommunity(i) + 1) + "\" ]");
        }
    }

    public void edgeList(PrintStream printStream, timgraph timgraph2, boolean bl) {
        JavaColours javaColours = new JavaColours(20, false);
        javaColours.printAllColours(System.out);
        String string = " -- ";
        if (timgraph2.isDirected()) {
            string = " -> ";
        }
        String string2 = "";
        String string3 = "";
        String string4 = "";
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < timgraph2.getNumberStubs(); i += 2) {
            n = timgraph2.getVertexFromEdge(i);
            n2 = timgraph2.getVertexFromEdge(i + 1);
            string2 = javaColours.RGB(i + 1);
            System.out.println("e=" + i + ", c string = " + string2);
            if (timgraph2.isWeighted()) {
                string3 = "\n weight=" + timgraph2.getEdgeWeight(i);
            }
            if (bl) {
                string4 = "\n label = \"" + i + "\"";
            }
            printStream.println(n + string + n2 + " [ \n color = \"#" + string2 + "\"  " + string3 + string4 + "\n ]");
        }
    }

    private void printSingleLineComment(PrintStream printStream, String string) {
        printStream.println("// " + string);
    }

    private void printMultiLineComment(PrintStream printStream, String[] stringArray) {
        printStream.println("/*");
        for (int i = 0; i < stringArray.length; ++i) {
            printStream.println(" * " + stringArray[i]);
        }
        printStream.println("*/");
    }
}

