/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.io;

import TimGraph.Community.Partition;
import TimGraph.Community.VertexPartition;
import TimGraph.Coordinate;
import TimGraph.VertexLabel;
import TimGraph.timgraph;
import TimUtilities.JavaColours;
import java.awt.Color;
import java.io.PrintStream;

public class GraphMLGenerator {
    static final String[] firstLines = new String[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns/graphml\" xmlns:visone=\"http://visone.info/xmlns\" xmlns:y=\"http://www.yworks.com/xml/graphml\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns/graphml http://www.yworks.com/xml/schema/graphml/1.0/ygraphml.xsd\">"};
    static final String[] keyDefinitions = new String[]{"<key id=\"d0\" for=\"node\" yfiles.type=\"nodegraphics\"/>", "<key id=\"d1\" for=\"node\" attr.name=\"id\" attr.type=\"string\"></key>", "<key id=\"d2\" for=\"edge\" yfiles.type=\"edgegraphics\"/>", "<key id=\"d5\" for=\"edge\" attr.name=\"id\" attr.type=\"string\"></key>"};
    int indent = 1;
    static final double DUNSET = -9.753472E48;
    static final double ARCFACTOR = -0.01;
    static final String indentString = "                                                        ";
    static final String DEFAULTEDGECOLOUR = JavaColours.RGB(Color.BLACK);
    static final String DEFAULTEDGEGREY = JavaColours.RGB(Color.LIGHT_GRAY);
    static final String DEFAULTVERTEXCOLOUR = JavaColours.RGB(Color.RED);
    public static final double DEFAULT_VERTEX_SIZE = 30.0;
    public static final double DEFAULT_LAYOUT_SCALE = 300.0;
    public static final String[] shapeTypes = new String[]{"ellipse", "roundrectangle", "triangle", "diamond", "hexagon", "octagon", "trapezoid", "parallelogram", "trapezoid2"};
    public static final int DEFAULT_SHAPE_INDEX = 0;
    public static final String DEFAULT_SHAPE = GraphMLGenerator.getNodeShape(0);
    public static final int DEFAULT_GREY_SHAPE_INDEX = shapeTypes.length - 1;
    public static final String DEFAULT_GREY_SHAPE = GraphMLGenerator.getNodeShape(DEFAULT_GREY_SHAPE_INDEX);

    public void outputGraph(PrintStream printStream, timgraph timgraph2, double d, boolean bl) {
        double d2 = 1.0E-44;
        double d3 = 1.0;
        if (timgraph2.getMaximumVertexLabel() == null) {
            timgraph2.calcMaximumVertexLabel();
        }
        int n = timgraph2.getMaximumVertexNumber();
        if (timgraph2.getMaximumEdgeValue() == null) {
            timgraph2.calcMaximumEdgeValue();
        }
        int n2 = timgraph2.getMaximumEdgeLabel();
        this.outputGraph(printStream, timgraph2, n, n2, d3, d2, d, bl);
    }

    public void outputGraph(PrintStream printStream, timgraph timgraph2, int n, int n2, double d, boolean bl) {
        double d2 = 1.0E-44;
        double d3 = 1.0;
        this.outputGraph(printStream, timgraph2, n, n2, d3, d2, d, bl);
    }

    public void outputGraph(PrintStream printStream, timgraph timgraph2, int n, int n2, double d, double d2, double d3, boolean bl) {
        int n3;
        JavaColours javaColours = null;
        if (n2 > 1) {
            javaColours = new JavaColours(n2 + 1, true);
        }
        JavaColours javaColours2 = null;
        if (n > 1) {
            javaColours2 = new JavaColours(n + 1, true);
        }
        if (timgraph2.isInfoLeveLGreaterThan(1)) {
            if (n2 > 1) {
                javaColours.printAllColours(System.out);
            }
            if (n > 1) {
                javaColours2.printAllColours(System.out);
            }
        }
        this.printInitialLines(printStream, timgraph2.outputName.getNameRoot(), timgraph2.isDirected());
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 30.0;
        double d7 = 0.0;
        double d8 = Math.PI * 2 / (double)timgraph2.getNumberVertices();
        double d9 = 30.0 / d8;
        VertexLabel vertexLabel = new VertexLabel();
        int n4 = 0;
        String string = "";
        String string2 = DEFAULTVERTEXCOLOUR;
        String string3 = DEFAULTEDGECOLOUR;
        String string4 = DEFAULT_SHAPE;
        for (n3 = 0; n3 < timgraph2.getNumberVertices(); ++n3) {
            d7 = d8 * (double)n3;
            d4 = d9 * Math.cos(d7);
            d5 = d9 * Math.sin(d7);
            string2 = DEFAULTVERTEXCOLOUR;
            string4 = DEFAULT_SHAPE;
            string = timgraph2.getVertexName(n3);
            if (timgraph2.isVertexLabelled()) {
                vertexLabel = timgraph2.getVertexLabel(n3);
                if (vertexLabel.hasPosition()) {
                    d4 = d * vertexLabel.getPosition().getX();
                    d5 = d * vertexLabel.getPosition().getY();
                }
                if (vertexLabel.hasNumber()) {
                    n4 = vertexLabel.getNumber();
                    if (n4 < 0) {
                        string2 = DEFAULTEDGEGREY;
                        string4 = DEFAULT_GREY_SHAPE;
                    } else {
                        string2 = javaColours2 == null ? DEFAULTVERTEXCOLOUR : javaColours2.RGB(n4 + 1);
                        string4 = shapeTypes[n4 % shapeTypes.length];
                    }
                }
            }
            this.printNodeColoured(printStream, n3, timgraph2.getNumberVertices(), d4, d5, d6, d6, string, string2, string4);
        }
        n3 = -1;
        int n5 = -1;
        int n6 = -1;
        double d10 = timgraph2.isDirected() ? -0.01 : -9.753472E48;
        for (int i = 0; i < timgraph2.getNumberStubs(); ++i) {
            n3 = timgraph2.getVertexFromEdge(i++);
            n5 = timgraph2.getVertexFromEdge(i);
            Coordinate coordinate = timgraph2.getVertexPosition(n3);
            Coordinate coordinate2 = timgraph2.getVertexPosition(n5);
            string3 = DEFAULTEDGECOLOUR;
            double d11 = timgraph2.getEdgeWeightSlow(i);
            if (d11 < d2) continue;
            d11 *= d3;
            if (timgraph2.isEdgeLabelled()) {
                n6 = timgraph2.getEdgeLabel(i);
                string3 = n6 < 0 ? DEFAULTEDGEGREY : (javaColours == null ? DEFAULTEDGECOLOUR : javaColours.RGB(n6 + 1));
            }
            this.printEdgeColoured(printStream, i - 1, n3, n5, coordinate, coordinate2, d10, timgraph2.getEdgeLabelString(i), d11, timgraph2.isDirected(), string3);
        }
        this.printFinalLines(printStream);
    }

    public void outputVertexPartition(PrintStream printStream, timgraph timgraph2, Partition partition) {
        int n;
        JavaColours javaColours = new JavaColours(partition.getNumberOfCommunities() + 2, true);
        if (timgraph2.isInfoLeveLGreaterThan(1)) {
            javaColours.printAllColours(System.out);
        }
        this.printInitialLines(printStream, timgraph2.outputName.getNameRoot(), timgraph2.isDirected());
        for (n = 0; n < timgraph2.getNumberVertices(); ++n) {
            this.printNodeColoured(printStream, n, timgraph2.getNumberVertices(), timgraph2.getVertexLabel(n), partition.getCommunity(n) + 1, -1, javaColours);
        }
        n = -1;
        int n2 = -1;
        String string = "";
        double d = timgraph2.isDirected() ? -0.01 : -9.753472E48;
        for (int i = 0; i < timgraph2.getNumberStubs(); ++i) {
            n = timgraph2.getVertexFromEdge(i++);
            n2 = timgraph2.getVertexFromEdge(i);
            Coordinate coordinate = timgraph2.getVertexPosition(n);
            Coordinate coordinate2 = timgraph2.getVertexPosition(n2);
            double d2 = timgraph2.getEdgeWeightSlow(i);
            this.printEdgeColoured(printStream, i - 1, n, n2, coordinate, coordinate2, d, timgraph2.getEdgeLabelString(i), d2, timgraph2.isDirected(), DEFAULTEDGECOLOUR);
        }
        this.printFinalLines(printStream);
    }

    public void outputEdgePartition(PrintStream printStream, timgraph timgraph2, Partition partition) {
        int n;
        JavaColours javaColours = new JavaColours(partition.getNumberOfCommunities() + 2, true);
        if (timgraph2.isInfoLeveLGreaterThan(1)) {
            javaColours.printAllColours(System.out);
        }
        this.printInitialLines(printStream, timgraph2.outputName.getNameRoot(), timgraph2.isDirected());
        for (n = 0; n < timgraph2.getNumberVertices(); ++n) {
            this.printNodeColoured(printStream, n, timgraph2.getNumberVertices(), timgraph2.getVertexLabel(n), null);
        }
        n = -1;
        int n2 = -1;
        double d = timgraph2.isDirected() ? -0.01 : -9.753472E48;
        for (int i = 0; i < timgraph2.getNumberStubs(); ++i) {
            n = timgraph2.getVertexFromEdge(i++);
            n2 = timgraph2.getVertexFromEdge(i);
            Coordinate coordinate = timgraph2.getVertexPosition(n);
            Coordinate coordinate2 = timgraph2.getVertexPosition(n2);
            double d2 = timgraph2.getEdgeWeightSlow(i);
            this.printEdgeColoured(printStream, i - 1, n, n2, coordinate, coordinate2, d, timgraph2.getEdgeLabelString(i), d2, timgraph2.isDirected(), javaColours.RGB(partition.getCommunity(i / 2) + 1));
        }
        this.printFinalLines(printStream);
    }

    public void outputEdgeLabels(PrintStream printStream, timgraph timgraph2, int n) {
        int n2;
        JavaColours javaColours = new JavaColours(n + 1, true);
        if (timgraph2.isInfoLeveLGreaterThan(1)) {
            javaColours.printAllColours(System.out);
        }
        this.printInitialLines(printStream, timgraph2.outputName.getNameRoot(), timgraph2.isDirected());
        for (n2 = 0; n2 < timgraph2.getNumberVertices(); ++n2) {
            this.printNodeColoured(printStream, n2, timgraph2.getNumberVertices(), timgraph2.getVertexLabel(n2), null);
        }
        n2 = -1;
        int n3 = -1;
        double d = timgraph2.isDirected() ? -0.01 : -9.753472E48;
        for (int i = 0; i < timgraph2.getNumberStubs(); ++i) {
            n2 = timgraph2.getVertexFromEdge(i++);
            n3 = timgraph2.getVertexFromEdge(i);
            Coordinate coordinate = timgraph2.getVertexPosition(n2);
            Coordinate coordinate2 = timgraph2.getVertexPosition(n3);
            double d2 = timgraph2.getEdgeWeightSlow(i);
            this.printEdgeColoured(printStream, i - 1, n2, n3, coordinate, coordinate2, d, timgraph2.getEdgeLabelString(i), d2, timgraph2.isDirected(), javaColours.RGB(timgraph2.getEdgeLabel(i) + 1));
        }
        this.printFinalLines(printStream);
    }

    public void outputVertexEdgePartition(PrintStream printStream, timgraph timgraph2, VertexPartition vertexPartition, VertexPartition vertexPartition2) {
        int n;
        int n2;
        JavaColours javaColours = new JavaColours(Math.max(vertexPartition.getNumberOfCommunities(), vertexPartition2.getNumberOfCommunities()) + 1, true);
        if (timgraph2.isInfoLeveLGreaterThan(1)) {
            System.out.println("no vp = " + vertexPartition.getNumberOfCommunities() + ", no. EP = " + vertexPartition2.getNumberOfCommunities());
            javaColours.printColourInfo(System.out);
        }
        this.printInitialLines(printStream, timgraph2.outputName.getNameRoot(), timgraph2.isDirected());
        for (n2 = 0; n2 < timgraph2.getNumberVertices(); ++n2) {
            n = vertexPartition.getCommunity(n2);
            this.printNodeColoured(printStream, n2, timgraph2.getNumberVertices(), timgraph2.getVertexLabel(n2), javaColours);
        }
        n2 = 1;
        n = -1;
        int n3 = -1;
        double d = timgraph2.isDirected() ? -0.01 : -9.753472E48;
        for (int i = 0; i < timgraph2.getNumberStubs(); ++i) {
            n = timgraph2.getVertexFromEdge(i++);
            n3 = timgraph2.getVertexFromEdge(i);
            double d2 = timgraph2.getEdgeWeightSlow(i);
            Coordinate coordinate = timgraph2.getVertexPosition(n);
            Coordinate coordinate2 = timgraph2.getVertexPosition(n3);
            this.printEdgeColoured(printStream, i - 1, n, n3, coordinate, coordinate2, d, timgraph2.getEdgeLabelString(i), d2, timgraph2.isDirected(), javaColours.RGB(vertexPartition2.getCommunity(i / 2) + n2));
        }
        this.printFinalLines(printStream);
    }

    public void outputIncidenceVertexPartition(PrintStream printStream, timgraph timgraph2, VertexPartition vertexPartition) {
        int n;
        int n2;
        JavaColours javaColours = new JavaColours(vertexPartition.getNumberOfCommunities() + 2, true);
        if (timgraph2.isInfoLeveLGreaterThan(1)) {
            System.out.println("no ip = " + vertexPartition.getNumberOfCommunities());
            javaColours.printColourInfo(System.out);
        }
        this.printInitialLines(printStream, timgraph2.outputName.getNameRoot(), timgraph2.isDirected());
        int n3 = timgraph2.getNumberVertices();
        for (n2 = 0; n2 < n3; ++n2) {
            n = vertexPartition.getCommunity(n2);
            this.printNodeColoured(printStream, n2, timgraph2.getNumberVertices(), timgraph2.getVertexLabel(n2), javaColours);
        }
        n2 = 1;
        n = -1;
        int n4 = -1;
        double d = timgraph2.isDirected() ? -0.01 : -9.753472E48;
        for (int i = 0; i < timgraph2.getNumberStubs(); ++i) {
            n = timgraph2.getVertexFromEdge(i++);
            n4 = timgraph2.getVertexFromEdge(i);
            Coordinate coordinate = timgraph2.getVertexPosition(n);
            Coordinate coordinate2 = timgraph2.getVertexPosition(n4);
            double d2 = timgraph2.getEdgeWeightSlow(i);
            this.printEdgeColoured(printStream, i - 1, n, n4, coordinate, coordinate2, d, timgraph2.getEdgeLabelString(i), d2, timgraph2.isDirected(), javaColours.RGB(vertexPartition.getCommunity(n3 + i / 2) + n2));
        }
        this.printFinalLines(printStream);
    }

    public static String startTag(String string) {
        return "<" + string + ">";
    }

    public static String startEndTag(String string) {
        return "<" + string + "/>";
    }

    public static String endTag(String string) {
        return "</" + string + ">";
    }

    public void printlnStartTag(PrintStream printStream, String string) {
        printStream.println(indentString.substring(0, this.indent++) + GraphMLGenerator.startTag(string));
    }

    public void printlnEndTag(PrintStream printStream, String string) {
        printStream.println(indentString.substring(0, --this.indent) + GraphMLGenerator.endTag(string));
    }

    public void printlnStartEndTag(PrintStream printStream, String string) {
        printStream.println(indentString.substring(0, this.indent) + GraphMLGenerator.startEndTag(string));
    }

    public void printlnStartEndTag(PrintStream printStream, String string, String string2) {
        this.printlnStartTag(printStream, string);
        printStream.println(indentString.substring(0, this.indent) + string2);
        this.printlnEndTag(printStream, string);
    }

    public void printlnDataTag(PrintStream printStream, String string, String string2) {
        printStream.println(indentString.substring(0, this.indent) + GraphMLGenerator.startTag("data key=\"" + string + "\" ") + string2 + GraphMLGenerator.endTag("data"));
    }

    public static String valueString(String string, int n) {
        return string + "=\"" + n + "\"";
    }

    public static String valueString(String string, String string2) {
        return string + "=\"" + string2 + "\"";
    }

    public static String valueString(String string, double d) {
        return string + "=\"" + d + "\"";
    }

    public static String valueString(String string, float f) {
        return string + "=\"" + f + "\"";
    }

    public void printInitialLines(PrintStream printStream, String string, boolean bl) {
        int n;
        for (n = 0; n < firstLines.length; ++n) {
            printStream.println(firstLines[n]);
        }
        for (n = 0; n < keyDefinitions.length; ++n) {
            printStream.println(keyDefinitions[n]);
        }
        String string2 = "";
        if (!bl) {
            string2 = "un";
        }
        this.printlnStartTag(printStream, "graph id=\"" + string + "\" edgedefault=\"" + string2 + "directed\"");
    }

    public void printFinalLines(PrintStream printStream) {
        this.printlnEndTag(printStream, "graph");
        this.printlnEndTag(printStream, "graphml");
    }

    public String processNodeName(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            string2 = c == '&' ? string2 + "and" : string2 + c;
        }
        return string2;
    }

    public void printNodeNameTag(PrintStream printStream, String string) {
        if (string.length() == 0) {
            return;
        }
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            string2 = c == '&' ? string2 + "and" : string2 + c;
        }
        this.printlnDataTag(printStream, "d1", string);
    }

    public void printNode(PrintStream printStream, int n, String string) {
        this.printlnStartTag(printStream, "node " + GraphMLGenerator.valueString("id", "n" + n));
        this.printNodeNameTag(printStream, string);
        this.printNodeNameTag(printStream, string);
        this.printlnEndTag(printStream, "node");
    }

    public void printNodeColoured(PrintStream printStream, int n, int n2, VertexLabel vertexLabel, JavaColours javaColours) {
        double d;
        double d2 = d = 30.0;
        this.printNodeColoured(printStream, n, n2, vertexLabel, -1, -1, d, d2, javaColours);
    }

    public void printNodeColoured(PrintStream printStream, int n, int n2, VertexLabel vertexLabel, int n3, int n4, JavaColours javaColours) {
        double d;
        double d2 = d = 30.0;
        this.printNodeColoured(printStream, n, n2, vertexLabel, n3, n4, d, d2, javaColours);
    }

    public void printNodeColoured(PrintStream printStream, int n, int n2, VertexLabel vertexLabel, int n3, int n4, double d, double d2, JavaColours javaColours) {
        double d3 = 300.0 * (double)n / (double)n2;
        double d4 = 0.0;
        if (vertexLabel != null && vertexLabel.hasPosition()) {
            d3 = vertexLabel.getPosition().getX();
            d4 = vertexLabel.getPosition().getY();
        } else {
            double d5 = 300.0;
            double d6 = Math.PI * 2 * (double)n / (double)n2;
            d3 = d5 * Math.sin(d6);
            d4 = d5 * Math.cos(d6);
        }
        String string = vertexLabel != null && vertexLabel.hasName() ? vertexLabel.getName() : Integer.toString(n);
        String string2 = DEFAULTVERTEXCOLOUR;
        int n5 = -1;
        if (vertexLabel != null && javaColours != null && vertexLabel.hasNumber()) {
            int n6 = n5 = n4 < 0 ? vertexLabel.getNumber() : n4;
            if (n3 < 1 || n3 > javaColours.getNumberColours()) {
                n3 = n5 + 1;
            }
            string2 = javaColours.RGB(n3);
        }
        this.printNodeColoured(printStream, n, n2, d3, d4, d, d2, string, string2, n5);
    }

    public void printNodeColouredOLD(PrintStream printStream, int n, int n2, String string, String string2, int n3) {
        this.printlnStartTag(printStream, "node " + GraphMLGenerator.valueString("id", "n" + n));
        this.printlnStartTag(printStream, "data key=\"d0\" ");
        this.printlnStartTag(printStream, "visone:shapeNode ");
        this.printlnStartTag(printStream, "y:ShapeNode ");
        this.printNodePosition(printStream, n, n2);
        if (string2.length() == 6) {
            this.printlnStartEndTag(printStream, "y:Fill color=\"#" + string2 + "\"  transparent=\"false\"");
        } else {
            this.printlnStartEndTag(printStream, "y:Fill hasColor=\"false\"  transparent=\"false\"");
        }
        this.printlnStartEndTag(printStream, "y:Shape type=\"" + GraphMLGenerator.getNodeShape(n3) + "\"");
        this.printlnEndTag(printStream, "y:ShapeNode ");
        this.printlnEndTag(printStream, "visone:shapeNode ");
        this.printlnEndTag(printStream, "data");
        this.printNodeNameTag(printStream, string);
        this.printlnEndTag(printStream, "node");
    }

    public void printNodeColoured(PrintStream printStream, int n, int n2, double d, double d2, double d3, double d4, String string, String string2, int n3) {
        this.printNodeColoured(printStream, n, n2, d, d2, d3, d4, string, string2, GraphMLGenerator.getNodeShape(n3));
    }

    public void printNodeColoured(PrintStream printStream, int n, int n2, double d, double d2, double d3, double d4, String string, String string2, String string3) {
        this.printlnStartTag(printStream, "node " + GraphMLGenerator.valueString("id", "n" + n));
        this.printlnStartTag(printStream, "data key=\"d0\" ");
        this.printlnStartTag(printStream, "visone:shapeNode ");
        this.printlnStartTag(printStream, "y:ShapeNode ");
        if (d3 > 0.0 && d4 > 0.0) {
            this.printNodePosition(printStream, d, d2, d3, d4);
        } else {
            this.printNodePosition(printStream, n, n2);
        }
        if (string2.length() == 6) {
            this.printlnStartEndTag(printStream, "y:Fill color=\"#" + string2 + "\"  transparent=\"false\"");
        } else {
            this.printlnStartEndTag(printStream, "y:Fill hasColor=\"false\"  transparent=\"false\"");
        }
        this.printlnStartEndTag(printStream, "y:Shape type=\"" + GraphMLGenerator.shape(string3) + "\"");
        this.printlnEndTag(printStream, "y:ShapeNode ");
        this.printlnEndTag(printStream, "visone:shapeNode ");
        this.printlnEndTag(printStream, "data");
        this.printNodeNameTag(printStream, string);
        this.printlnEndTag(printStream, "node");
    }

    private static String getNodeShape(int n) {
        if (n < 0 || n >= shapeTypes.length) {
            return shapeTypes[0];
        }
        return shapeTypes[n];
    }

    public static String shape(String string) {
        String string2 = string;
        for (int i = 0; i < shapeTypes.length; ++i) {
            if (!shapeTypes[i].equalsIgnoreCase(string2)) continue;
            return shapeTypes[i];
        }
        return shapeTypes[0];
    }

    private void printNodePosition(PrintStream printStream, int n, int n2) {
        double d = 30.0;
        double d2 = 30.0;
        double d3 = 300.0;
        double d4 = Math.PI * 2 * (double)n / (double)n2;
        double d5 = d3 * Math.sin(d4);
        double d6 = d3 * Math.cos(d4);
        this.printNodePosition(printStream, d5, d6, d, d2);
    }

    public void printNodePosition(PrintStream printStream, double d, double d2, double d3, double d4) {
        this.printlnStartEndTag(printStream, "y:Geometry  " + GraphMLGenerator.valueString("x", d) + " " + GraphMLGenerator.valueString("y", d2) + " " + GraphMLGenerator.valueString("width", d3) + " " + GraphMLGenerator.valueString("height", d4));
    }

    private void printNodeLabel(PrintStream printStream, String string) {
        this.printlnStartEndTag(printStream, "y:Geometry", string);
    }

    public void printEdgeSimple(PrintStream printStream, int n, int n2, int n3, String string) {
        this.printlnStartTag(printStream, "edge " + GraphMLGenerator.valueString("id", "e" + n) + " " + GraphMLGenerator.valueString("source", "n" + n2) + " " + GraphMLGenerator.valueString("target", "n" + n3) + " ");
        if (string.length() > 0) {
            this.printlnDataTag(printStream, "d5", string);
        }
        this.printlnEndTag(printStream, "edge");
    }

    public void printEdgeSimple(PrintStream printStream, int n, int n2, int n3, String string, boolean bl) {
        this.printEdgeColoured(printStream, n, n2, n3, null, null, -9.753472E48, string, 1.0, bl, DEFAULTEDGECOLOUR);
    }

    public void printEdgeColoured(PrintStream printStream, int n, int n2, int n3, Coordinate coordinate, Coordinate coordinate2, double d, String string, double d2, boolean bl, String string2) {
        if (d == -9.753472E48 || coordinate == null || coordinate2 == null) {
            this.printPolyLineEdge(printStream, n, n2, n3, string, d2, bl, string2);
        } else {
            this.printArcEdge(printStream, n, n2, n3, coordinate, coordinate2, d, string, d2, bl, string2);
        }
    }

    public void printPolyLineEdge(PrintStream printStream, int n, int n2, int n3, String string, double d, boolean bl, String string2) {
        this.printlnStartTag(printStream, "edge " + GraphMLGenerator.valueString("id", "e" + n) + " " + GraphMLGenerator.valueString("source", "n" + n2) + " " + GraphMLGenerator.valueString("target", "n" + n3) + " ");
        this.printlnStartTag(printStream, "data key=\"d2\" ");
        this.printlnStartTag(printStream, "visone:polyLineEdge ");
        this.printlnStartTag(printStream, "y:PolyLineEdge ");
        double d2 = d < 1.0 ? 1.0 : d;
        this.printlnStartEndTag(printStream, "y:LineStyle type=\"line\" " + GraphMLGenerator.valueString("width", d2) + " color=\"#" + (string2.length() == 6 ? string2 : DEFAULTEDGECOLOUR) + "\"");
        if (bl) {
            this.printlnStartEndTag(printStream, "y:Arrows source=\"none\" target=\"StandardArrow\"");
        }
        this.printlnEndTag(printStream, "y:PolyLineEdge ");
        this.printlnEndTag(printStream, "visone:polyLineEdge ");
        this.printlnEndTag(printStream, "data");
        if (string.length() > 0) {
            this.printlnDataTag(printStream, "d5", string);
        }
        this.printlnEndTag(printStream, "edge");
    }

    public void printArcEdge(PrintStream printStream, int n, int n2, int n3, Coordinate coordinate, Coordinate coordinate2, double d, String string, double d2, boolean bl, String string2) {
        this.printlnStartTag(printStream, "edge " + GraphMLGenerator.valueString("id", "e" + n) + " " + GraphMLGenerator.valueString("source", "n" + n2) + " " + GraphMLGenerator.valueString("target", "n" + n3) + " ");
        this.printlnStartTag(printStream, "data key=\"d2\" ");
        this.printlnStartTag(printStream, "visone:arcEdge");
        this.printlnStartTag(printStream, "y:ArcEdge");
        this.printlnStartTag(printStream, "y:Path sx=\"-0.0\" sy=\"0.0\" tx=\"-0.0\" ty=\"0.0\" ");
        Coordinate coordinate3 = Coordinate.calcArc2DCoordinate(coordinate, coordinate2, d);
        this.printlnStartEndTag(printStream, "y:Point x=\"" + coordinate3.getX() + "\" y=\"" + coordinate3.getY() + "\" ");
        this.printlnEndTag(printStream, "y:Path");
        double d3 = d2 < 1.0 ? 1.0 : d2;
        this.printlnStartEndTag(printStream, "y:LineStyle type=\"line\" " + GraphMLGenerator.valueString("width", d3) + " color=\"#" + (string2.length() == 6 ? string2 : DEFAULTEDGECOLOUR) + "\"");
        if (bl) {
            this.printlnStartEndTag(printStream, "y:Arrows source=\"none\" target=\"StandardArrow\"");
        }
        this.printlnEndTag(printStream, "y:ArcEdge");
        this.printlnEndTag(printStream, "visone:arcEdge");
        this.printlnEndTag(printStream, "data");
        if (string.length() > 0) {
            this.printlnDataTag(printStream, "d5", string);
        }
        this.printlnEndTag(printStream, "edge");
    }

    public void printTextTag(PrintStream printStream, String string, String string2) {
        this.printlnStartTag(printStream, string);
        printStream.println(string2);
        this.printlnEndTag(printStream, string);
    }

    public static String textTag(String string, String string2) {
        return GraphMLGenerator.startTag(string) + string2 + GraphMLGenerator.endTag(string);
    }

    public void printName(PrintStream printStream, String string) {
        this.printTextTag(printStream, "name", string);
    }

    public void printDescription(PrintStream printStream, String string) {
        this.printTextTag(printStream, "description", string);
    }
}

