/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.io;

import TimGraph.AdjacencyMatrix;
import TimGraph.Community.Community;
import TimGraph.Community.Partition;
import TimGraph.Community.VertexPartition;
import TimGraph.OutputMode;
import TimGraph.VertexLabel;
import TimGraph.io.GraphMLGenerator;
import TimGraph.io.GraphViz;
import TimGraph.timgraph;
import TimUtilities.FileUtilities.FileNameSequence;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileOutput {
    private static final String NOEDGELABELLINGNAME = "NOEDGELABELLINGNAME";
    timgraph tg;
    int infoLevel = 0;
    public FileNameSequence fileName;

    public FileOutput(timgraph timgraph2) {
        this.tg = timgraph2;
        this.infoLevel = timgraph2.infoLevel;
        this.fileName = new FileNameSequence(this.tg.outputName);
    }

    public FileOutput(FileNameSequence fileNameSequence) {
        this.fileName = new FileNameSequence(fileNameSequence);
    }

    public static void map(Map map, String string, String[] stringArray, String string2, boolean bl) {
        if (bl) {
            System.out.println("Writing file of map to " + string);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            for (int i = 0; i < stringArray.length; ++i) {
                printStream.println(stringArray[i]);
            }
            for (Object k : map.keySet()) {
                printStream.println(k + string2 + map.get(k));
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("*** File Error with " + string + " " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("*** Error opening output file " + string + " " + fileNotFoundException.getMessage());
        }
        if (bl) {
            System.out.println("Finished writing file of map to " + string);
        }
    }

    public void graphViz() {
        GraphViz graphViz = new GraphViz();
        this.fileName.setNameEnd("output.gv");
        if (this.infoLevel > -2) {
            System.out.println("Writing GraphViz file to " + this.fileName.getFullFileName());
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            graphViz.output(printStream, this.tg, true);
            if (this.infoLevel > -2) {
                System.err.println("Finished writing GraphViz file to " + this.fileName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + ", " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + ", " + fileNotFoundException.getMessage());
            return;
        }
    }

    public void adjacencyMatrix(String string, boolean bl, boolean bl2) {
        this.fileName.setNameEnd("outputAdjMat.dat");
        String[] stringArray = null;
        if (bl && bl2) {
            stringArray = this.tg.getVertexNameArray();
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            AdjacencyMatrix adjacencyMatrix = new AdjacencyMatrix(this.tg);
            adjacencyMatrix.printMatrix(printStream, string, stringArray, bl2);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing adjacecncy matrix file to " + this.fileName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + ", " + fileNotFoundException.getMessage());
            return;
        }
    }

    public void pajek() {
        this.pajek(true, true);
    }

    public void pajek(boolean bl, boolean bl2) {
        this.fileName.setNameEnd("output.net");
        try {
            String string;
            int n;
            FileOutputStream fileOutputStream = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println("*Vertices " + this.tg.getNumberVertices());
            this.tg.calcMinMaxVertexLabel();
            for (n = 1; n <= this.tg.getNumberVertices(); ++n) {
                printStream.print(n);
                if (this.tg.isVertexLabelled()) {
                    string = bl && this.tg.getMaximumVertexCoordinate() != null ? " " + this.tg.getVertexLabel(n - 1).pajekString(this.tg.getMinimumVertexCoordinate(), this.tg.getMaximumVertexCoordinate()) : " " + this.tg.getVertexLabel(n - 1).quotedNameString();
                    printStream.print(string);
                }
                printStream.println();
            }
            if (this.tg.isDirected()) {
                printStream.println("*Arcs " + this.tg.getNumberEdges());
            } else {
                printStream.println("*Edges " + this.tg.getNumberEdges());
            }
            n = -1;
            int n2 = -1;
            int n3 = -1;
            for (int i = 0; i < this.tg.getNumberStubs(); i += 2) {
                n = this.tg.getVertexFromEdge(i);
                n2 = this.tg.getVertexFromEdge(i + 1);
                if (!this.tg.isDirected() && n > n2) {
                    printStream.print(n2 + 1 + "   " + (n + 1));
                } else {
                    printStream.print(n + 1 + "   " + (n2 + 1));
                }
                if (this.tg.isWeighted()) {
                    string = "  " + this.tg.getEdgeWeight(i);
                    if (bl2) {
                        string = string + "  c " + this.tg.getPajekColour(this.tg.getEdgeLabel(i));
                    }
                    printStream.println(string);
                    continue;
                }
                printStream.println();
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing pajek file to " + this.fileName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + ", " + fileNotFoundException.getMessage());
            return;
        }
    }

    public void pajekPartition(String string, int[] nArray) {
        if (nArray.length != this.tg.getNumberVertices()) {
            System.err.println("*** Error length of partition " + nArray.length + " not equal to number of vertices " + this.tg.getNumberVertices());
            return;
        }
        this.fileName.setNameEnd(string);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println("*Vertices " + this.tg.getNumberVertices());
            for (int i = 0; i < this.tg.getNumberVertices(); ++i) {
                printStream.println(nArray[i]);
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing edge list file to " + this.fileName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + ", " + fileNotFoundException.getMessage());
            return;
        }
    }

    public void pajekPartition(String string, VertexPartition vertexPartition) {
        if (vertexPartition.getNumberVertices() != this.tg.getNumberVertices()) {
            System.err.println("*** Error vertices in partition " + vertexPartition.getNumberVertices() + " not equal to number of vertices " + this.tg.getNumberVertices());
            return;
        }
        this.pajekPartition(string, vertexPartition.getCommunity());
    }

    public void edgeListSimple() {
        this.printEdges(-3.57986421E8, false, false, false, false, "");
    }

    public void edgeListSimple(boolean bl) {
        this.printEdges(-3.57986421E8, bl, false, false, false, "");
    }

    public void printEdges(double d, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        if (bl5) {
            this.printEdges(d, bl, bl2, bl3, bl4, NOEDGELABELLINGNAME);
        } else {
            this.printEdges(d, bl, bl2, bl3, bl4, "");
        }
    }

    public void printEdges(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        if (bl5) {
            this.printEdges(-3.57986421E8, bl, bl2, bl3, bl4, NOEDGELABELLINGNAME);
        } else {
            this.printEdges(-3.57986421E8, bl, bl2, bl3, bl4, "");
        }
    }

    public void printEdges(boolean bl, boolean bl2, boolean bl3, boolean bl4, String string) {
        this.printEdges(-3.57986421E8, bl, bl2, bl3, bl4, string);
    }

    public void printEdges(double d, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string) {
        boolean bl5;
        boolean bl6 = false;
        String string2 = this.fileName.getNameRootFullPath();
        if (string.length() > 0) {
            bl6 = true;
            if (!string.equals(NOEDGELABELLINGNAME)) {
                string2 = string2 + string;
            }
        }
        string2 = (bl5 = bl & this.tg.isVertexLabelled()) ? string2 + "outputELS.dat" : string2 + "outputEL.dat";
        if (this.infoLevel > -2) {
            System.out.println("Writing edge list file with vertex " + (bl5 ? "labels" : "numbers") + " to " + string2);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.tg.printEdges(printStream, "#", " \t", d, bl5, bl2, bl3, bl4, bl6);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing edge list file to " + string2);
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("*** File Error with " + string2 + ", " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + string2 + ", " + fileNotFoundException.getMessage());
            return;
        }
    }

    public void printPartitionStats(Partition partition, String string, String string2, boolean bl, boolean bl2) {
        String string3 = this.fileName.getNameRootFullPath() + partition.getName() + "stats.dat";
        if (this.infoLevel > -2) {
            System.out.println("Writing partition statistics to " + string3);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            PrintStream printStream = new PrintStream(fileOutputStream);
            partition.printStatistics(printStream, string, string2, bl, bl2);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing partition statistics to " + string3);
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("*** File Error with " + string3 + ", " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + string3 + ", " + fileNotFoundException.getMessage());
            return;
        }
    }

    public void printEdgeCommunityStats(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.printEdgeCommunityStats("", bl, bl2, bl3, bl4);
    }

    public void printEdgeCommunityStats(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string2 = this.fileName.getNameRootFullPath();
        boolean bl5 = bl & this.tg.isVertexLabelled();
        string2 = bl5 ? string2 + "_" + string + "output.vcis" : string2 + "_" + string + "output.vci";
        if (this.infoLevel > -2) {
            System.out.println("Writing edge community information by vertex " + (bl5 ? "labels" : "numbers") + " to " + string2);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.tg.printEdgeCommunityStats(printStream, "\t", bl2, bl5, bl3, bl4);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing edge community information by vertex file to " + string2);
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("*** File Error with " + string2 + ", " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + string2 + ", " + fileNotFoundException.getMessage());
            return;
        }
    }

    public void graphML() {
        this.graphML("", -3.57986421E8);
    }

    public void graphML(String string, double d) {
        GraphMLGenerator graphMLGenerator = new GraphMLGenerator();
        if (d > 0.0) {
            this.fileName.setNameEnd(string + "ew" + d + ".graphML");
        } else {
            this.fileName.setNameEnd(string + ".graphML");
        }
        boolean bl = this.tg.isDirected();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            graphMLGenerator.outputGraph(printStream, this.tg, d, bl);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing GraphML file to " + this.fileName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + " " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Error opening output file " + this.fileName.getFullFileName() + " " + fileNotFoundException.getMessage());
            return;
        }
    }

    public void graphMLVertexPartition(Partition partition) {
        GraphMLGenerator graphMLGenerator = new GraphMLGenerator();
        this.fileName.setNameEnd("_" + partition.getName() + "VP.graphML");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            graphMLGenerator.outputVertexPartition(printStream, this.tg, partition);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing GraphML file to " + this.fileName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + " " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Error opening output file " + this.fileName.getFullFileName() + " " + fileNotFoundException.getMessage());
            return;
        }
    }

    public void graphMLEdgePartition(Partition partition) {
        GraphMLGenerator graphMLGenerator = new GraphMLGenerator();
        this.fileName.setNameEnd("_" + partition.getName() + "EP.graphML");
        if (this.infoLevel > -2) {
            System.out.println("Writing edge partition GraphML file to " + this.fileName.getFullFileName());
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            graphMLGenerator.outputEdgePartition(printStream, this.tg, partition);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing edge partition GraphML file to " + this.fileName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + " " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + " " + fileNotFoundException.getMessage());
            return;
        }
    }

    public void graphMLEdgePartition(int n) {
        GraphMLGenerator graphMLGenerator = new GraphMLGenerator();
        this.fileName.setNameEnd("_EP.graphML");
        if (this.infoLevel > -2) {
            System.out.println("Writing edge partition GraphML file to " + this.fileName.getFullFileName());
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            graphMLGenerator.outputEdgeLabels(printStream, this.tg, n);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing edge partition GraphML file to " + this.fileName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + " " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + " " + fileNotFoundException.getMessage());
            return;
        }
    }

    public void graphMLVertexEdgePartition(VertexPartition vertexPartition, VertexPartition vertexPartition2) {
        GraphMLGenerator graphMLGenerator = new GraphMLGenerator();
        this.fileName.setNameEnd("_" + vertexPartition.getName() + "VP_" + vertexPartition2.getName() + "EP.graphML");
        if (this.infoLevel > -2) {
            System.out.println("Writing DualGraphML file to " + this.fileName.getFullFileName());
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            graphMLGenerator.outputVertexEdgePartition(printStream, this.tg, vertexPartition, vertexPartition2);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing DualGraphML file to " + this.fileName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + " " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + " " + fileNotFoundException.getMessage());
            return;
        }
    }

    public void graphMLIncidencePartition(VertexPartition vertexPartition) {
        GraphMLGenerator graphMLGenerator = new GraphMLGenerator();
        this.fileName.setNameEnd("_" + vertexPartition.getName() + "IVP.graphML");
        if (this.infoLevel > -2) {
            System.out.println("Writing incidence matrix vertex partition GraphML file to " + this.fileName.getFullFileName());
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            graphMLGenerator.outputIncidenceVertexPartition(printStream, this.tg, vertexPartition);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing incidence matrix vertex partition GraphML file to " + this.fileName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + " " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + " " + fileNotFoundException.getMessage());
            return;
        }
    }

    public void informationNetworkBasic(String string, String string2) {
        this.fileName.setNameEnd("info.dat");
        if (this.infoLevel > -2) {
            System.out.println("Writing basic network information file to " + this.fileName.getFullFileName());
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println(string + this.fileName.getNameRoot());
            this.tg.printParametersBasic(printStream, string2);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing vertex and edge information file to " + this.fileName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + " " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + " " + fileNotFoundException.getMessage());
            return;
        }
    }

    public void informationVertexEdgePartition(VertexPartition vertexPartition, VertexPartition vertexPartition2, String string, String string2, boolean bl) {
        this.fileName.setNameEnd("_" + vertexPartition.getName() + "VP_" + vertexPartition2.getName() + "EP_info.dat");
        if (this.infoLevel > -2) {
            System.out.println("Writing vertex and edge partition information file to " + this.fileName.getFullFileName());
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println(string + this.fileName.getNameRoot());
            vertexPartition.printInformation(printStream, string + vertexPartition.getName() + " Vertex Partition" + string2, string2);
            vertexPartition2.printInformation(printStream, string + vertexPartition2.getName() + " Edge Partition" + string2, string2);
            if (bl) {
                printStream.println(string + this.fileName.getNameRoot() + string2 + "Vertex Partition");
                vertexPartition.printCommunityMatrix(printStream, string, string2);
                printStream.println(string + this.fileName.getNameRoot() + string2 + "Edge Partition");
                vertexPartition2.printCommunityMatrix(printStream, string, string2);
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing vertex and edge information file to " + this.fileName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + " " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + " " + fileNotFoundException.getMessage());
            return;
        }
    }

    public void informationVertexCommunity(Community community, String string, String string2, boolean bl) {
        this.fileName.setNameEnd("_" + community.getName() + "VC_info.dat");
        if (this.infoLevel > -2) {
            System.out.println("Writing vertex community information file to " + this.fileName.getFullFileName());
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println(string + this.fileName.getNameRoot());
            community.printInformation(printStream, string + community.getName() + "Vertex Community" + string2, string2);
            if (bl) {
                printStream.println(string + this.fileName.getNameRoot() + string2 + "Vertex Community");
                community.printCommunityMatrix(printStream, string, string2);
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing vertex community information file to " + this.fileName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + " " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + " " + fileNotFoundException.getMessage());
            return;
        }
    }

    public void printVertexCommunity(Community community, String string, String string2, boolean bl, boolean bl2) {
        this.fileName.setNameEnd("_" + community.getName() + "VC.dat");
        if (this.infoLevel > -2) {
            System.out.println("Writing vertex community to file " + this.fileName.getFullFileName());
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            community.printCommunityMatrixSparse(printStream, string, string2, bl, bl2);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing vertex community information file to " + this.fileName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + " " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + " " + fileNotFoundException.getMessage());
            return;
        }
    }

    public void informationPartition(Partition partition, String string, String string2, boolean bl) {
        this.fileName.setNameEnd("_" + partition.getName() + "P_info.dat");
        if (this.infoLevel > -2) {
            System.out.println("Writing partition information file to " + this.fileName.getFullFileName());
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println(string + this.fileName.getNameRoot());
            partition.printInformation(printStream, string + partition.getName() + "Partition" + string2, string2);
            if (bl) {
                printStream.println(string + this.fileName.getNameRoot() + string2 + "Vertex Partition");
                partition.printCommunityMatrix(printStream, string, string2);
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing partition information file to " + this.fileName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + " " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + " " + fileNotFoundException.getMessage());
            return;
        }
    }

    public void informationEdgePartition(Partition partition, String string, String string2, boolean bl) {
        this.fileName.setNameEnd("_" + partition.getName() + "EP_info.dat");
        if (this.infoLevel > -2) {
            System.out.println("Writing edge partition information file to " + this.fileName.getFullFileName());
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println(string + this.fileName.getNameRoot());
            partition.printInformation(printStream, string + partition.getName() + "  Edge Partition" + string2, string2);
            if (bl) {
                printStream.println(string + this.fileName.getNameRoot() + string2 + "Edge Partition");
                partition.printCommunityMatrix(printStream, string, string2);
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing vertex partition information file to " + this.fileName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + " " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + " " + fileNotFoundException.getMessage());
            return;
        }
    }

    public void informationIncidenceVertexPartition(VertexPartition vertexPartition, String string, String string2, boolean bl) {
        this.fileName.setNameEnd("_" + vertexPartition.getName() + "IVP_info.dat");
        if (this.infoLevel > -2) {
            System.out.println("Writing incidence matrix vertex partition information file to " + this.fileName.getFullFileName());
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println(string + this.fileName.getNameRoot());
            vertexPartition.printInformation(printStream, string + vertexPartition.getName() + "Incidence Matrix Vertex Partition" + string2, string2);
            if (bl) {
                printStream.println(string + this.fileName.getNameRoot() + string2 + "Incidence Matrix Vertex Partition");
                vertexPartition.printCommunityMatrix(printStream, string, string2);
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing vertex information file to " + this.fileName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + " " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + " " + fileNotFoundException.getMessage());
            return;
        }
    }

    public void printVertices(String string, String string2, boolean bl, boolean bl2, VertexPartition vertexPartition, boolean bl3) {
        String string3 = bl3 ? "inputBVNLS.dat" : "vertices.dat";
        this.fileName.setNameEnd((vertexPartition == null ? "" : vertexPartition.getName()) + string3);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            if (bl3) {
                vertexPartition.printSimpleVertexCommunityList(printStream, string, string2, bl, bl2);
            } else {
                vertexPartition.printVertices(printStream, string, string2, bl, bl2);
            }
            if (this.infoLevel > -2) {
                if (bl3) {
                    System.out.println("Finished writing simple list of vertex - partition pairs to file " + this.fileName.getFullFileName());
                } else {
                    System.out.println("Finished writing vertices and their vertex partition information to file " + this.fileName.getFullFileName());
                }
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + ", " + fileNotFoundException.getMessage());
            return;
        }
    }

    public void printVertices(String string, String string2, VertexPartition vertexPartition, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        if (this.tg.isVertexLabelled()) {
            VertexLabel vertexLabel = this.tg.getVertexLabel(0);
            bl4 = vertexLabel.hasName();
            bl5 = vertexLabel.hasNumber();
            bl6 = vertexLabel.hasPosition();
            bl7 = vertexLabel.hasStrength();
            bl8 = vertexLabel.hasRank();
        }
        this.printVertices(string, string2, vertexPartition, bl, bl2, bl4, bl5, bl6, bl7, bl8, bl3);
    }

    public void printVertices(String string, String string2, VertexPartition vertexPartition, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
        this.fileName.setNameEnd((vertexPartition == null ? "" : "_" + vertexPartition.getName()) + "vertices.dat");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.tg.printVertices(printStream, string, string2, vertexPartition, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing vertex information file to " + this.fileName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + ", " + fileNotFoundException.getMessage());
            return;
        }
    }

    public void printMotifs(String string, String string2, String string3, int[] nArray, ArrayList<ArrayList<Integer>> arrayList, boolean bl, boolean bl2) {
        this.fileName.setNameEnd(string3);
        if (this.infoLevel > -2) {
            System.out.println("Writing motifs to file " + this.fileName.getFullFileName());
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fileName.getFullFileName());
            PrintStream printStream = new PrintStream(fileOutputStream);
            int n = -9753257;
            boolean bl3 = false;
            if (nArray.length > 0) {
                bl3 = true;
                n = nArray.length;
            }
            boolean bl4 = false;
            if (arrayList != null) {
                bl4 = true;
                if (n > 0) {
                    if (n != arrayList.size()) {
                        throw new RuntimeException("Two different numbers of motifs " + n + " and " + arrayList.size());
                    }
                } else {
                    n = arrayList.size();
                }
            }
            if (n <= 0) {
                System.err.println("Nothing to print in printMotifs");
                return;
            }
            if (bl2) {
                printStream.println((bl ? "Motif_Index" + string2 : "") + (bl3 ? "Motif_Label" + string2 : "") + (bl3 ? "Motif_Vertex_List" : ""));
            }
            for (int i = 0; i < n; ++i) {
                printStream.print((bl ? i + string2 : "") + (bl3 ? nArray[i] + string2 : ""));
                ArrayList<Integer> arrayList2 = arrayList.get(i);
                for (int j = 0; j < arrayList2.size(); ++j) {
                    printStream.print((j == 0 ? "" : string2) + arrayList2.get(j));
                }
                printStream.println();
            }
            if (this.infoLevel > -2) {
                System.out.println("Finished writing motif file to " + this.fileName.getFullFileName());
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("*** File Error with " + this.fileName.getFullFileName() + " " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Error opening output file " + this.fileName.getFullFileName() + " " + fileNotFoundException.getMessage());
            return;
        }
    }

    public void informationGeneral(String string, String string2) {
        this.informationGeneral(string, string2, true, true, true, true, false, null);
    }

    public void informationGeneral(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, OutputMode outputMode) {
        this.informationNetworkBasic(string, string2);
        if (bl4) {
            this.edgeListSimple();
            if (this.tg.isVertexLabelled()) {
                this.edgeListSimple(true);
            }
        }
        if (this.tg.isWeighted() && this.tg.isVertexLabelled()) {
            this.tg.calcStrength();
        }
        boolean bl6 = false;
        if (bl3) {
            this.printVertices(string, string2, null, bl, bl2, bl6);
        }
        boolean bl7 = true;
        boolean bl8 = true;
        OutputMode outputMode2 = outputMode == null ? this.tg.outputControl : outputMode;
        if (bl5 || outputMode2.graphMLFileOn) {
            this.graphML();
        }
        try {
            if (outputMode2.degreeDistributionOn) {
                this.tg.calcDegreeDistribution();
                boolean bl9 = false;
                this.tg.FileOutputDegreeDistribution(string, bl9, bl8);
                double d = 1.1;
                if (this.tg.getNumberVertices() > 100) {
                    this.tg.FileOutputLogBinnedDegreeDistribution(string, d, bl7, bl8);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            System.err.println("*** Error in informationGeneral calculating degree distribution: " + runtimeException);
        }
        try {
            if (outputMode2.distancesOn) {
                this.tg.calcDistanceSample(0.01, 10, 100);
                this.tg.FileOutputDistanceStatistics(string);
                this.tg.FileOutputDistanceTotalDistribution(string);
            }
        }
        catch (RuntimeException runtimeException) {
            System.err.println("*** Error in informationGeneral calculating distances: " + runtimeException);
        }
        try {
            if (outputMode2.componentsOn) {
                this.tg.calcComponents();
                this.tg.FileOutputComponentInfo(string);
                this.tg.FileOutputComponentDistribution(string);
                this.tg.FileOutputVertexToComponentList(string);
            }
        }
        catch (RuntimeException runtimeException) {
            System.err.println("*** Error in informationGeneral calculating components: " + runtimeException);
        }
        try {
            if (outputMode2.rankingOn) {
                this.tg.calcRanking();
            }
        }
        catch (RuntimeException runtimeException) {
            System.err.println("*** Error in informationGeneral calculating ranking: " + runtimeException);
        }
        try {
            if (outputMode2.pajekFileOn) {
                this.pajek();
            }
        }
        catch (RuntimeException runtimeException) {
            System.err.println("*** Error in informationGeneral calculating pajek output: " + runtimeException);
        }
        try {
            if (outputMode2.adjacencyFileOn) {
                this.adjacencyMatrix("\t ", true, true);
            }
        }
        catch (RuntimeException runtimeException) {
            System.err.println("*** Error in informationGeneral calculating adjacency matrix output: " + runtimeException);
        }
        try {
            if (outputMode2.clusteringOn) {
                this.tg.calcCCEdgeSample(0.01, 100, 10000);
                this.tg.FileOutputCC(string);
            }
        }
        catch (RuntimeException runtimeException) {
            System.err.println("*** Error in informationGeneral calculating clustering: " + runtimeException);
        }
    }
}

