/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.io;

import JavaNotes.TextReader;
import JavaNotes.TextReaderTabSeparated;
import TimGraph.Coordinate;
import TimGraph.EdgeValue;
import TimGraph.VertexLabel;
import TimGraph.io.FileOutput;
import TimGraph.io.InputGML;
import TimGraph.timgraph;
import TimUtilities.StringUtilities.Filters.StringFilter;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileInput {
    private String SEP = "\t";
    static final int UNSET = -975573;
    TextReader data;
    private int infoLevel = 0;
    public static int nmax = 1000;

    public FileInput(int n) {
        this.infoLevel = n;
    }

    public FileInput(timgraph timgraph2) {
        this.infoLevel = timgraph2.infoLevel;
    }

    public static TextReader openFile(String string) {
        TextReader textReader;
        System.out.println("Starting to read from " + string);
        try {
            textReader = new TextReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("*** Can't find file " + string + ", " + fileNotFoundException.getMessage());
        }
        return textReader;
    }

    public static TextReaderTabSeparated openTabSeparatedFile(String string) {
        TextReaderTabSeparated textReaderTabSeparated;
        System.out.println("Starting to read from " + string);
        try {
            textReaderTabSeparated = new TextReaderTabSeparated(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** Can't find file " + string);
            return null;
        }
        return textReaderTabSeparated;
    }

    public static ArrayList<String> readStringList(String string) {
        TextReader textReader = FileInput.openFile(string);
        if (textReader == null) {
            return null;
        }
        System.out.println("Starting to read list of strings from " + string);
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            while (!textReader.eof()) {
                arrayList.add(textReader.getWord());
            }
            System.out.println("Finished reading list of strings from file " + string + " found " + arrayList.size() + " words");
        }
        catch (TextReader.Error error) {
            throw new RuntimeException("*** Input Error: readStringList failed after " + arrayList.size() + " words, " + error.getMessage());
        }
        finally {
            textReader.close();
        }
        return arrayList;
    }

    public int processAdjacencyMatrixOld(timgraph timgraph2) {
        FileReader fileReader;
        int n = 0;
        String string = timgraph2.inputName.getFullFileName();
        try {
            fileReader = new FileReader(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("*** Can't find file " + string + ", " + fileNotFoundException);
        }
        Scanner scanner = new Scanner(fileReader);
        System.out.println("Starting to read " + (timgraph2.isWeighted() ? "" : "un") + "weighted adjacency matrix file from " + string);
        double[][] dArray = new double[1][1];
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = -1;
        int n4 = 0;
        try {
            while (scanner.hasNextLine()) {
                ++n2;
                String string2 = scanner.nextLine();
                int n5 = 0;
                int n6 = 0;
                arrayList.clear();
                while (n6 < string2.length()) {
                    n6 = string2.indexOf(9, n5);
                    if (n6 < 0) {
                        n6 = string2.length();
                    }
                    arrayList.add(string2.substring(n5, n6));
                    n5 = n6 + 1;
                }
                if (this.infoLevel > 1) {
                    System.out.print(n2);
                    for (String string3 : arrayList) {
                        System.out.print(", " + string3);
                    }
                    System.out.println();
                }
                try {
                    if (n3 < 0) {
                        n3 = arrayList.size();
                        dArray = new double[n3][n3];
                    } else if (arrayList.size() != n3) {
                        throw new RuntimeException(" found " + arrayList.size() + " columns, wanted dimension " + n3);
                    }
                    if (n4 == n3) {
                        System.out.println("!!!Warning, found one row too many, wanted only " + n3 + ", ignoring remaining lines");
                        break;
                    }
                    for (int i = 0; i < n3; ++i) {
                        dArray[n4][i] = Double.parseDouble((String)arrayList.get(i));
                    }
                    ++n4;
                }
                catch (RuntimeException runtimeException) {
                    throw new RuntimeException("*** PROBLEM on line " + n2 + ", " + runtimeException.getMessage());
                }
            }
            System.out.println("Finished adjacency file input from " + string + " found " + n3 + " rows and columns ");
        }
        catch (Error error) {
            throw new RuntimeException("*** Input Error on line " + n2 + ", " + error.getMessage());
        }
        finally {
            scanner.close();
        }
        timgraph2.setNetworkFromMatrix(dArray);
        return n;
    }

    public int processAdjacencyMatrixTabSeparated(timgraph timgraph2) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        return this.processAdjacencyMatrix(timgraph2, '\t', bl, bl2, bl3);
    }

    public int processAdjacencyMatrixTabSeparated(timgraph timgraph2, boolean bl, boolean bl2, boolean bl3) {
        return this.processAdjacencyMatrix(timgraph2, '\t', bl, bl2, bl3);
    }

    /*
     * Unable to fully structure code
     */
    public int processAdjacencyMatrix(timgraph var1_1, char var2_2, boolean var3_3, boolean var4_4, boolean var5_5) {
        var6_6 = 0;
        var7_7 = var1_1.inputName.getFullFileName();
        try {
            var8_8 = new FileReader(var7_7);
        }
        catch (FileNotFoundException var9_9) {
            throw new RuntimeException("*** Can't find file " + var7_7 + ", " + var9_9);
        }
        var9_10 = new Scanner(var8_8);
        System.out.println("Starting to read " + (var1_1.isWeighted() != false ? "" : "un") + "weighted adjacency matrix file from " + var7_7);
        System.out.println("   word separator character is " + var2_2 + ", header labels " + StringFilter.onOffString(var3_3) + ", row labels on " + StringFilter.onOffString(var4_4) + ", trimming white space from labels " + StringFilter.onOffString(var5_5));
        var11_11 = new ArrayList<String>();
        var12_12 = new TreeSet<String>();
        var15_13 = -1;
        var16_14 = 0;
        var10_15 = null;
        var17_16 = 0;
        var13_17 = null;
        var14_18 = var4_4 != false ? 1 : 0;
lbl19:
        // 2 sources

        try {
            while (var9_10.hasNextLine()) {
                ++var16_14;
                var18_19 = var9_10.nextLine();
                var19_21 = 0;
                var20_22 = 0;
                var11_11.clear();
                while (var20_22 < var18_19.length()) {
                    var20_22 = var18_19.indexOf(9, var19_21);
                    if (var20_22 < 0) {
                        var20_22 = var18_19.length();
                    }
                    var11_11.add(var18_19.substring(var19_21, var20_22));
                    var19_21 = var20_22 + 1;
                }
                if (this.infoLevel > 1) {
                    System.out.print(var16_14);
                    for (var21_23 = 0; var21_23 < var11_11.size(); ++var21_23) {
                        System.out.print(", " + (String)var11_11.get(var21_23));
                    }
                    System.out.println();
                }
                try {
                    block35: {
                        block34: {
                            if (var15_13 >= 0) break block34;
                            var15_13 = var11_11.size() - var14_18;
                            var10_15 = new double[var15_13][var15_13];
                            if (!var3_3) break block35;
                            var13_17 = new String[var15_13];
                            if (var5_5) {
                                for (var21_23 = 0; var21_23 < var15_13; ++var21_23) {
                                    var13_17[var21_23] = ((String)var11_11.get(var21_23 + var14_18)).trim();
                                }
                            }
                            for (var21_23 = 0; var21_23 < var15_13; ++var21_23) {
                                var22_27 = (String)var11_11.get(var21_23 + var14_18);
                                if (var22_27.length() < 1) {
                                    var22_27 = "v" + var21_23;
                                    System.err.println("!!!Warning, on column " + var21_23 + " column label is null, using \"" + var22_27 + "\" instead");
                                }
                                var13_17[var21_23] = var22_27;
                            }
                            ** GOTO lbl19
                        }
                        if (var11_11.size() != var15_13 + var14_18) {
                            throw new RuntimeException(" found " + var11_11.size() + " columns, wanted " + (var15_13 + var14_18));
                        }
                    }
                    if (var17_16 == var15_13) {
                        System.err.println("!!!Warning, found one row too many, wanted only " + var15_13 + ", ignoring remaining lines");
                        break;
                    }
                    if (var4_4) {
                        var21_24 = (String)var11_11.get(0);
                        var22_27 = var3_3 != false ? var13_17[var17_16] : var21_24;
                        var23_28 = var21_24;
                        if (!var21_24.equals(var22_27)) {
                            if (var21_24.length() > var22_27.length()) {
                                if (var21_24.startsWith(var22_27)) {
                                    System.err.println("!!!Warning, on row " + var17_16 + " column label \"" + var22_27 + "\" is a substring of the label \"" + var21_24 + "\", using longer row string");
                                } else {
                                    System.err.println("!!!Warning, on row " + var17_16 + " column label \"" + var22_27 + "\" is not substring of the label \"" + var21_24 + "\", using longer row string");
                                }
                                var23_28 = var21_24;
                            } else {
                                if (var22_27.startsWith(var21_24)) {
                                    System.err.println("!!!Warning, on row " + var17_16 + " row label \"" + var21_24 + "\" is a substring of the label \"" + var22_27 + "\", using longer col string");
                                } else {
                                    System.err.println("!!!Warning, on row " + var17_16 + " row label \"" + var21_24 + "\" is not a substring of the label \"" + var22_27 + "\", using longer col string");
                                }
                                var23_28 = var21_24;
                            }
                        }
                        if (var12_12.contains(var23_28)) {
                            System.err.println("!!!Warning, on row " + var17_16 + " new label \"" + var23_28 + "\" is not unique, already used.  Will use for a ditinct vertex.");
                        }
                        var13_17[var17_16] = var23_28;
                        var12_12.add(var23_28);
                    }
                    for (var21_23 = 0; var21_23 < var15_13; ++var21_23) {
                        var22_27 = (String)var11_11.get(var21_23 + var14_18);
                        if (var22_27.length() == 0) {
                            var10_15[var17_16][var21_23] = 0.0;
                            continue;
                        }
                        try {
                            var10_15[var17_16][var21_23] = Double.parseDouble(var22_27);
                            continue;
                        }
                        catch (RuntimeException var23_29) {
                            System.err.println("!!!Warning, entry \"" + var22_27 + "\" is not a double at line " + var16_14 + ", column " + (var21_23 + var14_18) + ", row " + var17_16 + ", treated as zero.");
                            var10_15[var17_16][var21_23] = 0.0;
                        }
                    }
                    ++var17_16;
                }
                catch (RuntimeException var21_26) {
                    throw new RuntimeException("*** PROBLEM on line " + var16_14 + ", " + var21_26.getMessage());
                }
            }
            System.out.println("Finished adjacency file input from " + var7_7 + " found " + var15_13 + " rows and columns ");
        }
        catch (TextReader.Error var18_20) {
            throw new RuntimeException("*** Input Error: " + var18_20.getMessage());
        }
        finally {
            var9_10.close();
        }
        var1_1.setNetworkFromMatrix(var13_17, var10_15);
        return var6_6;
    }

    /*
     * Unable to fully structure code
     */
    public int processAdjacencyMatrixOld(timgraph var1_1, String var2_2, boolean var3_3, boolean var4_4, boolean var5_5) {
        var6_6 = 0;
        var7_7 = var1_1.inputName.getFullFileName();
        try {
            var8_8 = new FileReader(var7_7);
        }
        catch (FileNotFoundException var9_9) {
            throw new RuntimeException("*** Can't find file " + var7_7 + ", " + var9_9);
        }
        var9_10 = new Scanner(var8_8);
        System.out.println("Starting to read " + (var1_1.isWeighted() != false ? "" : "un") + "weighted adjacency matrix file from " + var7_7);
        System.out.println("  " + var2_2.length() + " word separator characters are " + StringFilter.toHex(var2_2, " ") + ", header labels " + StringFilter.onOffString(var3_3) + ", row labels on " + StringFilter.onOffString(var4_4) + ", trimming white space from labels " + StringFilter.onOffString(var5_5));
        var14_11 = -1;
        var15_12 = 0;
        var10_13 = null;
        var16_14 = 0;
        var11_15 = null;
        var13_16 = var4_4 != false ? 1 : 0;
lbl17:
        // 2 sources

        try {
            while (var9_10.hasNextLine()) {
                ++var15_12;
                var17_18 = var9_10.nextLine();
                var12_17 = var17_18.split(var2_2);
                if (this.infoLevel > -1) {
                    System.out.print(var15_12);
                    for (var18_20 = 0; var18_20 < var12_17.length; ++var18_20) {
                        System.out.print(", " + var12_17[var18_20]);
                    }
                    System.out.println();
                }
                try {
                    block25: {
                        block24: {
                            if (var14_11 >= 0) break block24;
                            var14_11 = var12_17.length - var13_16;
                            var10_13 = new double[var14_11][var14_11];
                            if (!var3_3) break block25;
                            var11_15 = new String[var14_11];
                            if (var5_5) {
                                for (var18_20 = 0; var18_20 < var14_11; ++var18_20) {
                                    var11_15[var18_20] = var12_17[var18_20 + var13_16].trim();
                                }
                            }
                            for (var18_20 = 0; var18_20 < var14_11; ++var18_20) {
                                var11_15[var18_20] = var12_17[var18_20 + var13_16];
                            }
                            ** GOTO lbl17
                        }
                        if (var12_17.length != var14_11 + var13_16) {
                            throw new RuntimeException(" found " + var12_17.length + " columns, wanted " + (var14_11 + var13_16));
                        }
                    }
                    if (var16_14 == var14_11) {
                        System.err.println("!!!Warning, found one row too many, wanted only " + var14_11 + ", ignoring remaining lines");
                        break;
                    }
                    if (!var12_17[0].equals(var11_15[var16_14])) {
                        System.err.println("!!!Warning, row " + var16_14 + " label \"" + var12_17[0] + "\" does not match column label \"" + var11_15[var16_14] + "\"");
                        if (var11_15[var16_14].length() > var12_17[0].length()) {
                            System.err.println("!!!         switching to use the longer row label");
                            var11_15[var16_14] = var12_17[0];
                        }
                    }
                    for (var18_20 = 0; var18_20 < var14_11; ++var18_20) {
                        var19_22 = var12_17[var18_20 + var13_16];
                        if (var19_22.length() == 0) {
                            var10_13[var16_14][var18_20] = 0.0;
                            continue;
                        }
                        try {
                            var10_13[var16_14][var18_20] = Double.parseDouble(var19_22);
                            continue;
                        }
                        catch (RuntimeException var20_23) {
                            System.err.println("!!!Warning, entry \"" + var19_22 + "\" is not a double at line " + var15_12 + ", column " + (var18_20 + var13_16) + ", row " + var16_14 + ", treated as zero.");
                            var10_13[var16_14][var18_20] = 0.0;
                        }
                    }
                    ++var16_14;
                }
                catch (RuntimeException var18_21) {
                    throw new RuntimeException("*** PROBLEM on line " + var15_12 + ", " + var18_21.getMessage());
                }
            }
            System.out.println("Finished adjacency file input from " + var7_7 + " found " + var14_11 + " rows and columns ");
        }
        catch (TextReader.Error var17_19) {
            throw new RuntimeException("*** Input Error: " + var17_19.getMessage());
        }
        finally {
            var9_10.close();
        }
        var1_1.setNetworkFromMatrix(var11_15, var10_13);
        return var6_6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processGMLFile(timgraph timgraph2, String string, boolean bl, boolean bl2) {
        int n = 0;
        String string2 = timgraph2.inputName.getFullFileName();
        this.data = FileInput.openFile(string2);
        if (this.data == null) {
            return -1;
        }
        InputGML inputGML = new InputGML(this.data, bl);
        System.out.println("Starting to read " + (timgraph2.isWeighted() ? "" : "un") + "weighted gml network file from " + string2);
        try {
            System.out.println(" File: " + string2);
            inputGML.findGraph();
            System.out.println("Finished GML file input from " + string2 + " found " + inputGML.getNumberVertices() + " vertices, " + inputGML.getNumberEdges() + " edges");
        }
        catch (TextReader.Error error) {
            System.err.println("*** Input Error: " + error.getMessage());
            n = -2;
        }
        finally {
            this.data.close();
        }
        inputGML.setTimGraph(timgraph2, bl, bl2);
        FileOutput fileOutput = new FileOutput(timgraph2);
        fileOutput.printVertices("", "\t", null, false, false, false);
        return 0;
    }

    public static int processIntEdgeFile(timgraph timgraph2, String string, int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        return FileInput.processIntEdgeFile(timgraph2, -987654321, string, n, n2, n3, n4, bl, bl2, bl3);
    }

    public static int processIntEdgeFile(timgraph timgraph2, int n, String string, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3) {
        int n6;
        boolean bl4 = true;
        if (n4 < 0) {
            bl4 = false;
        }
        boolean bl5 = true;
        if (n5 < 0) {
            bl5 = false;
        }
        timgraph2.setWeightedEdges(bl4 | bl5);
        timgraph2.setVertexlabels(bl2);
        timgraph2.setDirectedGraph(bl);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        IntArrayList intArrayList = new IntArrayList();
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        int n7 = FileInput.readIntEdgeFile(timgraph2, string, n2, n3, n4, n5, treeSet, arrayList, doubleArrayList, intArrayList, bl3);
        if (n7 <= 0) {
            throw new RuntimeException("FileInput.processIntEdgeFile returned maximum vertex index as " + n7);
        }
        int n8 = Math.max(n7 + 1, n);
        System.out.println("Largest vertex index was " + n7 + " creating graph with " + n8 + " vertices");
        timgraph2.setMaximumVertices(n8);
        timgraph2.setMaximumStubs(arrayList.size());
        timgraph2.setNetwork();
        for (n6 = 0; n6 < n8; ++n6) {
            timgraph2.addVertex();
        }
        n6 = -1;
        int n9 = -1;
        double d = -1.0;
        int n10 = -1;
        for (int i = 0; i < arrayList.size(); ++i) {
            n6 = arrayList.get(i++);
            n9 = arrayList.get(i);
            if (timgraph2.isWeighted()) {
                d = bl4 ? doubleArrayList.get(i / 2) : 1.0;
                n10 = bl5 ? intArrayList.get(i / 2) : 0;
                timgraph2.addEdge(n6, n9, new EdgeValue(n10, d));
                continue;
            }
            timgraph2.addEdge(n6, n9);
        }
        return n8;
    }

    public static int readIntEdgeFile(timgraph timgraph2, String string, int n, int n2, int n3, int n4, TreeSet<Integer> treeSet, ArrayList<Integer> arrayList, DoubleArrayList doubleArrayList, IntArrayList intArrayList, boolean bl) {
        boolean bl2 = true;
        if (n3 < 0) {
            bl2 = false;
        }
        boolean bl3 = true;
        if (n4 < 0) {
            bl3 = false;
        }
        int n5 = -9999999;
        int n6 = 0;
        timgraph2.inputName.setNameEnd(string);
        String string2 = timgraph2.inputName.getFullFileName();
        TextReader textReader = FileInput.openFile(string2);
        if (textReader == null) {
            return -1;
        }
        System.out.println("Starting to read " + (timgraph2.isDirected() ? "" : "un") + "directed " + (timgraph2.isWeighted() ? "" : "un") + "weighted network file using an edge list from " + string2);
        try {
            System.out.println(" File: " + string2);
            int n7 = 0;
            String[] stringArray = new String[nmax];
            Integer n8 = new Integer(-975573);
            Integer n9 = new Integer(-975573);
            double d = -97531.0;
            int n10 = -86420;
            while (!textReader.eof()) {
                ++n7;
                int n11 = 0;
                while (!textReader.eoln()) {
                    stringArray[n11++] = textReader.getWord();
                }
                if (bl) {
                    System.out.print(n7);
                    for (int i = 0; i < n11; ++i) {
                        System.out.print(", " + stringArray[i]);
                    }
                    System.out.println();
                }
                try {
                    if (n > n11) {
                        n6 = -10;
                        arrayList.add(-975573);
                        throw new RuntimeException("*** Too few columns on line " + n7 + " expected edge source in " + n + " found " + n11);
                    }
                    n8 = Integer.parseInt(stringArray[n - 1]);
                    arrayList.add(n8);
                    treeSet.add(n8);
                    n5 = Math.max(n5, n8);
                    if (n2 > n11) {
                        arrayList.add(-975573);
                        n6 = -11;
                        throw new RuntimeException("*** Too few columns on line " + n7 + " expected edge target in " + n2 + " found " + n11);
                    }
                    n9 = Integer.parseInt(stringArray[n2 - 1]);
                    arrayList.add(n9);
                    treeSet.add(n9);
                    n5 = Math.max(n5, n9);
                    if (bl2) {
                        if (n3 <= n11) {
                            d = Double.parseDouble(stringArray[n3 - 1]);
                            doubleArrayList.add(d);
                        } else {
                            n6 = -12;
                            throw new RuntimeException("*** Too few columns on line " + n7 + " expected weight in" + n3 + " found " + n11);
                        }
                    }
                    if (!bl3) continue;
                    if (n4 <= n11) {
                        n10 = Integer.parseInt(stringArray[n4 - 1]);
                        intArrayList.add(n10);
                        continue;
                    }
                    n6 = -13;
                    throw new RuntimeException("*** Too few columns on line " + n7 + " expected label in " + n4 + " found " + n11);
                }
                catch (RuntimeException runtimeException) {
                    throw new RuntimeException("*** PROBLEM on line " + n7 + ", " + runtimeException.getMessage());
                }
            }
            if (n6 == 0) {
                n6 = treeSet.size();
            }
            System.out.println("Finished edge list file input from " + string2 + " found " + treeSet.size() + " vertices, " + arrayList.size() + " stubs");
        }
        catch (TextReader.Error error) {
            n6 = -2;
            throw new RuntimeException("*** Input Error: " + error.getMessage());
        }
        finally {
            textReader.close();
        }
        return n5;
    }

    public int processStringEdgeFile(timgraph timgraph2, String string, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        boolean bl3 = true;
        if (n3 < 0) {
            bl3 = false;
        }
        boolean bl4 = true;
        if (n4 < 0) {
            bl4 = false;
        }
        timgraph2.setWeightedEdges(bl3 | bl4);
        timgraph2.setVertexlabels(bl2);
        timgraph2.setDirectedGraph(bl);
        ArrayList<String> arrayList = new ArrayList<String>();
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        IntArrayList intArrayList = new IntArrayList();
        TreeSet<String> treeSet = new TreeSet<String>();
        timgraph2.inputName.setNameEnd(string);
        String string2 = timgraph2.inputName.getFullFileName();
        int n5 = this.readStringEdgeFile(string2, n, n2, n3, n4, treeSet, null, arrayList, doubleArrayList, intArrayList);
        if (n5 < 0) {
            return n5;
        }
        timgraph2.setMaximumVertices(treeSet.size());
        timgraph2.setMaximumStubs(arrayList.size());
        timgraph2.setNetwork();
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        Iterator<String> iterator = treeSet.iterator();
        int n6 = 0;
        String string3 = "NOTUSED";
        VertexLabel vertexLabel = new VertexLabel();
        while (iterator.hasNext()) {
            string3 = iterator.next();
            treeMap.put(string3, n6++);
            if (timgraph2.isVertexLabelled()) {
                vertexLabel.setName(string3);
                timgraph2.addVertex(vertexLabel);
                continue;
            }
            timgraph2.addVertex();
        }
        int n7 = -1;
        int n8 = -1;
        double d = -1.0;
        int n9 = -1;
        int n10 = 20;
        n5 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            if ((n7 = ((Integer)treeMap.get(arrayList.get(i++))).intValue()) == (n8 = ((Integer)treeMap.get(arrayList.get(i))).intValue()) && timgraph2.isSelfLooped()) continue;
            if (timgraph2.isWeighted()) {
                d = bl3 ? doubleArrayList.get(i / 2) : 1.0;
                n9 = bl4 ? intArrayList.get(i / 2) : -98542182;
                if (timgraph2.isMultiEdge() || !timgraph2.edgeExists(n7, n8)) {
                    timgraph2.addEdge(n7, n8, new EdgeValue(n9, d));
                    continue;
                }
                if (n5 > -n10 && this.infoLevel > -2) {
                    System.out.println("!!! second edge from " + n7 + " to " + n8 + " is ignored");
                }
                if (n5 == -n10) {
                    System.out.println("!!! Reached maximum number of warnings, " + -n5 + ", no more given.");
                }
                --n5;
                continue;
            }
            if (timgraph2.isMultiEdge() || !timgraph2.edgeExists(n7, n8)) {
                timgraph2.addEdge(n7, n8);
                continue;
            }
            if (n5 > -n10 && this.infoLevel > -2) {
                System.out.println("!!! second edge from " + n7 + " to " + n8 + " is ignored");
            }
            if (n5 == -n10) {
                System.out.println("!!! Reached maximum number of warnings, " + -n5 + ", no more given.");
            }
            --n5;
        }
        return n5 - n10;
    }

    public int readStringEdgeFile(String string, int n, int n2, int n3, int n4, TreeSet<String> treeSet, TreeSet<String> treeSet2, ArrayList<String> arrayList, DoubleArrayList doubleArrayList, IntArrayList intArrayList) {
        boolean bl = false;
        return this.readStringEdgeFile(string, n, n2, n3, n4, treeSet, treeSet2, arrayList, doubleArrayList, intArrayList, bl);
    }

    public int readStringEdgeFile(String string, int n, int n2, int n3, int n4, TreeSet<String> treeSet, TreeSet<String> treeSet2, ArrayList<String> arrayList, DoubleArrayList doubleArrayList, IntArrayList intArrayList, boolean bl) {
        boolean bl2 = true;
        if (n3 < 0) {
            bl2 = false;
        }
        boolean bl3 = true;
        if (n4 < 0) {
            bl3 = false;
        }
        boolean bl4 = true;
        if (treeSet2 == null) {
            bl4 = false;
        }
        int n5 = 9999999;
        int n6 = -n5;
        int n7 = 0;
        this.data = FileInput.openFile(string);
        if (this.data == null) {
            return -1;
        }
        System.out.println("Starting to read edge list with string vertex labels from " + string);
        try {
            System.out.println(" File: " + string);
            int n8 = 0;
            String[] stringArray = new String[nmax];
            String string2 = "NOTSET";
            String string3 = "NOTSET";
            double d = -97531.0;
            int n9 = -86420;
            if (bl) {
                this.data.getln();
                ++n8;
            }
            while (!this.data.eof()) {
                ++n8;
                if (this.infoLevel > 2) {
                    System.out.println(n8 + ": ");
                }
                int n10 = 0;
                while (!this.data.eoln()) {
                    stringArray[n10++] = this.data.getWord();
                }
                if (this.infoLevel > 1) {
                    System.out.print(n8);
                    for (int i = 0; i < n10; ++i) {
                        System.out.print(", " + stringArray[i]);
                    }
                    System.out.println();
                }
                try {
                    if (n > n10) {
                        n7 = -10;
                        arrayList.add("T.F.C. line " + n8);
                        throw new RuntimeException("*** Too few columns on line " + n8 + " expected " + n + " found " + n10);
                    }
                    string2 = stringArray[n - 1];
                    arrayList.add(string2);
                    treeSet.add(string2);
                    if (n2 > n10) {
                        arrayList.add("T.F.C. line " + n8);
                        n7 = -11;
                        throw new RuntimeException("*** Too few columns on line " + n8 + " expected " + n2 + " found " + n10);
                    }
                    string3 = stringArray[n2 - 1];
                    arrayList.add(string3);
                    if (bl4) {
                        treeSet2.add(string3);
                    } else {
                        treeSet.add(string3);
                    }
                    if (bl2) {
                        if (n3 <= n10) {
                            d = Double.parseDouble(stringArray[n3 - 1]);
                            doubleArrayList.add(d);
                        } else {
                            n7 = -12;
                            throw new RuntimeException("*** Too few columns on line " + n8 + " expected weight in" + n3 + " found " + n10);
                        }
                    }
                    if (!bl3) continue;
                    if (n4 <= n10) {
                        n9 = Integer.parseInt(stringArray[n4 - 1]);
                        intArrayList.add(n9);
                        continue;
                    }
                    n7 = -13;
                    throw new RuntimeException("*** Too few columns on line " + n8 + " expected label in " + n4 + " found " + n10);
                }
                catch (RuntimeException runtimeException) {
                    throw new RuntimeException("*** PROBLEM on line " + n8 + ", " + runtimeException.getMessage());
                }
            }
            if (n7 == 0) {
                n7 = treeSet.size();
            }
            System.out.println("Finished edge list file input from " + string + " found " + treeSet.size() + " vertices, " + arrayList.size() + " stubs");
        }
        catch (TextReader.Error error) {
            n7 = -2;
            throw new RuntimeException("*** Input Error: " + error.getMessage());
        }
        finally {
            this.data.close();
        }
        return n7;
    }

    public ArrayList<String> readStringColumnFromFile(String string, String string2, int n, boolean bl) {
        int n2 = 0;
        this.data = FileInput.openFile(string);
        if (this.data == null) {
            throw new RuntimeException("Failed to open " + string);
        }
        System.out.println("Starting to read edge list with string vertex labels from " + string);
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = true;
        if (string2.length() < 1) {
            bl2 = false;
        }
        try {
            int n3 = 0;
            String[] stringArray = new String[nmax];
            while (!this.data.eof()) {
                ++n3;
                if (this.infoLevel > 2) {
                    System.out.println(n3 + ": ");
                }
                int n4 = 0;
                while (!this.data.eoln()) {
                    stringArray[n4++] = this.data.getWord();
                }
                if (this.infoLevel > 1) {
                    System.out.print(n3);
                    for (int i = 0; i < n4; ++i) {
                        System.out.print(", " + stringArray[i]);
                    }
                    System.out.println();
                }
                try {
                    if (bl2 && stringArray[0].startsWith(string2)) continue;
                    if (n > n4) {
                        n2 = -10;
                        arrayList.add("T.F.C. line " + n3);
                        throw new RuntimeException("*** Too few columns on line " + n3 + " expected " + arrayList + " found " + n4);
                    }
                    String string3 = stringArray[n - 1];
                    if (bl) {
                        arrayList.add(string3.toLowerCase());
                        continue;
                    }
                    arrayList.add(string3);
                }
                catch (RuntimeException runtimeException) {
                    throw new RuntimeException("*** PROBLEM on line " + n3 + ", " + runtimeException.getMessage());
                }
            }
            if (n2 == 0) {
                n2 = arrayList.size();
            }
            System.out.println("Finished reading column +" + n + " from input file " + string + " found " + n3 + " lines but took only " + arrayList.size() + " entries");
        }
        catch (TextReader.Error error) {
            n2 = -2;
            throw new RuntimeException("*** Input Error: " + error.getMessage());
        }
        finally {
            this.data.close();
        }
        return arrayList;
    }

    public ArrayList<String> readStringColumnsFromFile(String string, String string2, Set<Integer> set, boolean bl) {
        int[] nArray = new int[set.size()];
        int n = 0;
        for (Integer n2 : set) {
            nArray[n++] = n2;
        }
        return FileInput.readStringColumnsFromFile(string, string2, nArray, bl, false, this.infoLevel > 1);
    }

    public static ArrayList<String> readStringColumnsFromFile(String string, String string2, int[] nArray, boolean bl, boolean bl2, boolean bl3) {
        int n;
        int n2 = 0;
        TextReader textReader = FileInput.openFile(string);
        if (textReader == null) {
            throw new RuntimeException("Failed to open " + string);
        }
        System.out.print("Starting to read columns ");
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = -1;
        int n4 = -1;
        for (n = 0; n < nArray.length; ++n) {
            n3 = nArray[n];
            if (n3 < 1) {
                throw new RuntimeException("\nFirst column is numbered 1, specified one column as number " + n3);
            }
            n4 = Math.max(n3, n4);
            System.out.print(n3 + ", ");
        }
        System.out.println(" of file " + string);
        n = 1;
        if (string2.length() < 1) {
            n = 0;
        }
        try {
            int n5;
            int n6 = 0;
            String[] stringArray = new String[nmax];
            while (!textReader.eof()) {
                int n7;
                ++n6;
                if (bl3) {
                    System.out.println(n6 + ": ");
                }
                n5 = 0;
                while (!textReader.eoln()) {
                    stringArray[n5++] = textReader.getWord();
                }
                if (bl3) {
                    System.out.print(n6);
                    for (n7 = 0; n7 < n5; ++n7) {
                        System.out.print(", " + stringArray[n7]);
                    }
                    System.out.println();
                }
                if (bl2 && n6 == 1) continue;
                try {
                    if (n != 0 && stringArray[0].startsWith(string2)) continue;
                    if (n4 > n5) {
                        n2 = -10;
                        arrayList.add("TooFewColumnsOnLine" + n6);
                        throw new RuntimeException("*** Too few columns on line " + n6 + " expected " + arrayList + " found " + n5);
                    }
                    for (n7 = 0; n7 < nArray.length; ++n7) {
                        String string3 = stringArray[nArray[n7] - 1];
                        if (bl) {
                            arrayList.add(string3.toLowerCase());
                            continue;
                        }
                        arrayList.add(string3);
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw new RuntimeException("*** PROBLEM on line " + n6 + ", " + runtimeException.getMessage());
                }
            }
            if (n2 == 0) {
                n2 = arrayList.size();
            }
            System.out.print("Finished reading columns ");
            for (n5 = 0; n5 < nArray.length; ++n5) {
                System.out.print(nArray[n5] + ", ");
            }
            System.out.println(" of file " + string);
            System.out.println(" Found " + n6 + " lines but took only " + arrayList.size() + " entries");
        }
        catch (TextReader.Error error) {
            n2 = -2;
            throw new RuntimeException("*** Input Error: " + error.getMessage());
        }
        finally {
            textReader.close();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readStringIndexLabelList(String string, int n, int n2, ArrayList<String> arrayList, ArrayList<String> arrayList2, boolean bl) {
        int n3 = 0;
        this.data = FileInput.openFile(string);
        if (this.data == null) {
            return -1;
        }
        System.out.println("Starting to read index and label list as strings from " + string);
        try {
            System.out.println(" File: " + string);
            int n4 = 0;
            String[] stringArray = new String[nmax];
            String string2 = "NOTSET";
            String string3 = "NOTSET";
            if (bl) {
                System.out.println("Header Line = " + this.data.getln());
                ++n4;
            }
            while (!this.data.eof()) {
                ++n4;
                if (this.infoLevel > 1) {
                    System.out.println(n4 + ": ");
                }
                int n5 = 0;
                while (!this.data.eoln()) {
                    stringArray[n5++] = this.data.getWord();
                }
                if (this.infoLevel > 1) {
                    System.out.print(n4);
                    for (int i = 0; i < n5; ++i) {
                        System.out.print(", " + stringArray[i]);
                    }
                    System.out.println();
                }
                try {
                    if (n > n5) {
                        System.out.println("*** Too few columns on line " + n4 + " expected " + n + " found " + n5);
                        n3 = -10;
                        arrayList.add("T.F.C. line " + n4);
                    } else {
                        string2 = stringArray[n - 1];
                        arrayList.add(string2);
                    }
                    if (n2 > n5) {
                        System.out.println("*** Too few columns on line " + n4 + " expected " + n2 + " found " + n5);
                        arrayList2.add("T.F.C. line " + n4);
                        n3 = -11;
                        continue;
                    }
                    string3 = stringArray[n2 - 1];
                    arrayList2.add(string3);
                }
                catch (RuntimeException runtimeException) {
                    System.err.println("*** PROBLEM on line " + n4 + ", " + runtimeException.getMessage());
                    int n6 = -100;
                    this.data.close();
                    return n6;
                }
            }
            if (n3 == 0) {
                n3 = arrayList.size();
            }
            System.out.println("Finished index/label list file input from " + string + " found " + arrayList.size() + " indices, " + arrayList2.size() + " labels");
        }
        catch (TextReader.Error error) {
            System.err.println("*** Input Error: " + error.getMessage());
            n3 = -2;
        }
        finally {
            this.data.close();
        }
        if (arrayList.size() != arrayList2.size()) {
            System.err.println("*** Two lists have different sizes");
        }
        return n3;
    }

    public int readIntIndexLabelList(String string, int n, int n2, ArrayList<Integer> arrayList, ArrayList<Integer> arrayList2, boolean bl) {
        String string2 = "";
        return FileInput.readIntIndexLabelList(string, n, n2, arrayList, arrayList2, bl, string2, this.infoLevel);
    }

    public static int readIntIndexLabelList(String string, int n, int n2, ArrayList<Integer> arrayList, ArrayList<Integer> arrayList2, String string2, int n3) {
        boolean bl = false;
        return FileInput.readIntIndexLabelList(string, n, n2, arrayList, arrayList2, bl, string2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readIntIndexLabelList(String string, int n, int n2, ArrayList<Integer> arrayList, ArrayList<Integer> arrayList2, boolean bl, String string2, int n3) {
        if (n2 < 1) {
            throw new RuntimeException("Column number must be between 1 and number of columns in file");
        }
        int n4 = 0;
        TextReader textReader = FileInput.openFile(string);
        if (textReader == null) {
            return -1;
        }
        boolean bl2 = true;
        if (arrayList == null) {
            bl2 = false;
        }
        boolean bl3 = true;
        if (arrayList2 == null) {
            bl3 = false;
        }
        boolean bl4 = true;
        if (string2 == null || string2.length() == 0) {
            bl4 = false;
        }
        System.out.println("Starting to read integer " + (bl2 ? "index" : "") + " " + (bl3 ? "label" : "") + " from " + string);
        try {
            System.out.println(" File: " + string);
            int n5 = 0;
            String[] stringArray = new String[nmax];
            Integer n6 = -975573;
            Integer n7 = -975573;
            if (bl) {
                System.out.println("--- Ignoring first (header) line = " + textReader.getln());
                ++n5;
            }
            while (!textReader.eof()) {
                ++n5;
                int n8 = 0;
                while (!textReader.eoln()) {
                    stringArray[n8++] = textReader.getWord();
                }
                if (n3 > 1) {
                    System.out.print(n5 + ":");
                }
                if (n3 > 2) {
                    for (int i = 0; i < n8; ++i) {
                        System.out.print(", " + stringArray[i]);
                    }
                }
                if (n3 > 1) {
                    System.out.println();
                }
                try {
                    if (bl4 && n8 > 0 && stringArray[0].startsWith(string2)) {
                        System.out.println("--- Ignoring comment on line " + n5 + " is " + stringArray[0]);
                        continue;
                    }
                    if (bl2) {
                        if (n > n8) {
                            System.out.println("*** Too few columns on line " + n5 + " expected " + n + " found " + n8);
                            n4 = -10;
                            arrayList.add(-975573);
                        } else {
                            n6 = n < 1 ? n5 - 1 : new Integer(stringArray[n - 1]);
                            arrayList.add(n6);
                        }
                    }
                    if (!bl3) continue;
                    if (n2 > n8) {
                        System.out.println("*** Too few columns on line " + n5 + " expected " + n2 + " found " + n8);
                        arrayList2.add(-975573);
                        n4 = -11;
                        continue;
                    }
                    n7 = new Integer(stringArray[n2 - 1]);
                    arrayList2.add(n7);
                }
                catch (RuntimeException runtimeException) {
                    System.out.println("*** PROBLEM on line " + n5 + ", " + runtimeException.getMessage());
                    int n9 = -100;
                    textReader.close();
                    return n9;
                }
            }
            if (n4 == 0) {
                n4 = arrayList.size();
            }
            System.out.print("Finished index/label list file input from " + string + " found");
            if (bl2) {
                System.out.print(" : " + arrayList.size() + " indices");
            }
            if (bl2) {
                System.out.print(" : " + arrayList2.size() + " labels");
            }
            System.out.println();
        }
        catch (TextReader.Error error) {
            System.out.println("*** Input Error: " + error.getMessage());
            n4 = -2;
        }
        finally {
            textReader.close();
        }
        if (arrayList.size() != arrayList2.size()) {
            System.err.println("*** Two lists have different sizes");
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readIntIndexNeighbourList(String string, ArrayList<Integer> arrayList, ArrayList<ArrayList<Integer>> arrayList2, ArrayList<ArrayList<Integer>> arrayList3, boolean bl, boolean bl2, int n) {
        int n2 = 0;
        TextReader textReader = FileInput.openFile(string);
        if (textReader == null) {
            return -1;
        }
        boolean bl3 = arrayList != null;
        System.out.println("Starting to read integer " + (bl ? "index" : "") + " label lists from " + string);
        boolean bl4 = false;
        if (arrayList3 != null) {
            bl4 = true;
            System.out.println("Creating label to index list");
        }
        boolean bl5 = false;
        if (arrayList2 != null) {
            bl5 = true;
            System.out.println("Creating index to label list");
        }
        try {
            System.out.println(" File: " + string);
            int n3 = 0;
            String[] stringArray = new String[nmax];
            int n4 = -1;
            int n5 = -975573;
            int n6 = -975573;
            int n7 = -975573;
            if (bl2) {
                System.out.println("Header Line = " + textReader.getln());
                ++n3;
            }
            while (!textReader.eof()) {
                int n8;
                ++n3;
                n6 = 0;
                while (!textReader.eoln()) {
                    stringArray[n6++] = textReader.getWord();
                }
                if (n6 == 0) {
                    System.err.println("Empty line at line number " + n3);
                    continue;
                }
                if (n > 1) {
                    System.out.print(n3 + ":");
                }
                if (n > 2) {
                    for (n8 = 0; n8 < n6; ++n8) {
                        System.out.print(", " + stringArray[n8]);
                    }
                }
                if (n > 1) {
                    System.out.println();
                }
                try {
                    n5 = 0;
                    n4 = bl ? Integer.parseInt(stringArray[n5++]) : ++n4;
                    for (n8 = n5; n8 < n6; ++n8) {
                        n7 = Integer.parseInt(stringArray[n8]);
                        if (bl3) {
                            if (n7 < 0 || n7 >= arrayList.size()) {
                                System.err.println("*** found label " + n7 + " but do not have a labelToLabel entry for it");
                            }
                            n7 = arrayList.get(n7);
                        }
                        if (bl5) {
                            while (n4 >= arrayList2.size()) {
                                arrayList2.add(new ArrayList());
                            }
                            arrayList2.get(n4).add(n7);
                        }
                        if (!bl4) continue;
                        while (n7 >= arrayList3.size()) {
                            arrayList3.add(new ArrayList());
                        }
                        arrayList3.get(n7).add(n4);
                    }
                }
                catch (RuntimeException runtimeException) {
                    System.out.println("*** PROBLEM on line " + n3 + ", " + runtimeException.getMessage());
                    int n9 = -100;
                    textReader.close();
                    return n9;
                }
            }
            if (n2 == 0) {
                n2 = arrayList3.size();
            }
            System.out.println("Finished index/label int neighbour list file input from " + string + " found " + arrayList3.size() + " indices on " + n3 + " lines");
        }
        catch (TextReader.Error error) {
            System.out.println("*** Input Error: " + error.getMessage());
            n2 = -2;
        }
        finally {
            textReader.close();
        }
        return n2;
    }

    public int processStringVertexNeighbourFileUnipartite(timgraph timgraph2, String string, boolean bl, boolean bl2) {
        timgraph2.setWeightedEdges(false);
        timgraph2.setVertexlabels(bl2);
        timgraph2.setDirectedGraph(bl);
        ArrayList<String> arrayList = new ArrayList<String>();
        TreeSet<String> treeSet = new TreeSet<String>();
        int n = this.readStringVertexNeighbourFileUnipartite(timgraph2, string, treeSet, arrayList);
        if (n < 0) {
            return n;
        }
        timgraph2.setMaximumVertices(treeSet.size());
        timgraph2.setMaximumStubs(arrayList.size());
        timgraph2.setNetwork();
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        Iterator<String> iterator = treeSet.iterator();
        int n2 = 0;
        String string2 = "NOTUSED";
        VertexLabel vertexLabel = new VertexLabel();
        while (iterator.hasNext()) {
            string2 = iterator.next();
            System.out.println(n2 + " " + string2);
            treeMap.put(string2, n2++);
            if (timgraph2.isVertexLabelled()) {
                vertexLabel.setName(string2);
                timgraph2.addVertex(vertexLabel);
                continue;
            }
            timgraph2.addVertex();
        }
        int n3 = -1;
        int n4 = -1;
        for (int i = 0; i < arrayList.size(); ++i) {
            n3 = (Integer)treeMap.get(arrayList.get(i++));
            n4 = (Integer)treeMap.get(arrayList.get(i));
            timgraph2.addEdge(n3, n4);
        }
        return 0;
    }

    public int processStringVertexNeighbourFile(timgraph timgraph2, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n, StringFilter stringFilter, StringFilter stringFilter2, TreeSet<String> treeSet) {
        timgraph2.setWeightedEdges(bl);
        timgraph2.setVertexlabels(bl4);
        timgraph2.setDirectedGraph(bl2);
        timgraph2.setMultiEdge(bl3);
        ArrayList<String> arrayList = new ArrayList<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        TreeSet<String> treeSet3 = bl5 ? new TreeSet<String>() : null;
        DoubleArrayList doubleArrayList = bl ? new DoubleArrayList() : null;
        timgraph2.inputName.setNameEnd(string);
        String string2 = timgraph2.inputName.getFullFileName();
        int n2 = FileInput.readStringVertexNeighbourFile(string2, treeSet2, treeSet3, arrayList, doubleArrayList, bl6, bl7, n, stringFilter, stringFilter2, treeSet, this.infoLevel > 1);
        if (n2 < 0) {
            return n2;
        }
        if (bl5) {
            timgraph2.setBipartite(treeSet2.size(), treeSet3.size());
            timgraph2.setMaximumVertices(treeSet2.size() + treeSet3.size());
        } else {
            timgraph2.setMaximumVertices(treeSet2.size());
        }
        timgraph2.setMaximumStubs(arrayList.size());
        timgraph2.setNetwork();
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        this.addVertices(treeSet2, treeMap, timgraph2);
        if (bl5) {
            this.addVertices(treeSet3, treeMap, timgraph2);
        }
        int n3 = -1;
        int n4 = -1;
        double d = 1.0;
        for (int i = 0; i < arrayList.size(); ++i) {
            n3 = treeMap.get(arrayList.get(i++));
            n4 = treeMap.get(arrayList.get(i));
            if (bl) {
                doubleArrayList.getQuick(i / 2);
            }
            timgraph2.addEdgeWithTests(n3, n4, d);
        }
        return 0;
    }

    private void addVertices(Collection<String> collection, TreeMap<String, Integer> treeMap, timgraph timgraph2) {
        Iterator<String> iterator = collection.iterator();
        int n = timgraph2.getNumberVertices();
        String string = "NOTUSED";
        VertexLabel vertexLabel = new VertexLabel();
        while (iterator.hasNext()) {
            string = iterator.next();
            if (this.infoLevel > 0) {
                System.out.println(n + " " + string);
            }
            if (timgraph2.getMaximumVertices() == timgraph2.getNumberVertices()) {
                System.err.println("*** Imminent failure - reached capacity of " + timgraph2.getNumberVertices() + " vertices, " + string + " vertex is one too many");
            }
            treeMap.put(string, n++);
            if (this.infoLevel > 0) {
                System.out.println(n + " " + string);
            }
            if (timgraph2.isVertexLabelled()) {
                vertexLabel.setName(string);
                timgraph2.addVertex(vertexLabel);
                continue;
            }
            timgraph2.addVertex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readStringVertexNeighbourFile(String string, Set<String> set, Set<String> set2, ArrayList<String> arrayList, DoubleArrayList doubleArrayList, boolean bl, boolean bl2, int n, StringFilter stringFilter, StringFilter stringFilter2, TreeSet<String> treeSet, boolean bl3) {
        int n2 = 9999999;
        int n3 = -n2;
        int n4 = 0;
        boolean bl4 = true;
        if (set2 == null) {
            bl4 = false;
        }
        boolean bl5 = true;
        if (n < 2) {
            bl5 = false;
        }
        boolean bl6 = stringFilter != null;
        boolean bl7 = stringFilter2 != null;
        TextReader textReader = FileInput.openFile(string);
        if (textReader == null) {
            return -1;
        }
        System.out.println("Starting to read " + (bl4 ? "bipartite" : "unipartite") + " vertex neighbour list with string vertex labels from " + string);
        try {
            System.out.println(" File: " + string);
            int n5 = 0;
            String[] stringArray = new String[nmax];
            String string2 = "NOTSET";
            String string3 = "NOTSET";
            while (!textReader.eof()) {
                ++n5;
                if (bl3) {
                    System.out.println(n5 + ": ");
                }
                if (bl5 && n5 % n != 1) {
                    textReader.getln();
                    continue;
                }
                int n6 = 0;
                if (bl) {
                    while (!textReader.eoln()) {
                        stringArray[n6++] = textReader.getWord().toLowerCase();
                    }
                } else {
                    while (!textReader.eoln()) {
                        stringArray[n6++] = textReader.getWord();
                    }
                }
                if (bl3) {
                    for (int i = 0; i < n6; ++i) {
                        System.out.print(", " + stringArray[i]);
                    }
                    System.out.println();
                }
                try {
                    if (n6 < 1) {
                        System.err.println("*** Too few columns on line " + n5 + " expected at least one, found " + n6);
                        n4 = -10;
                        arrayList.add("T.F.C. line " + n5);
                        continue;
                    }
                    string2 = stringArray[0];
                    if (bl6 && !stringFilter.isAcceptable(string2)) {
                        if (treeSet == null) continue;
                        treeSet.add(string2);
                        continue;
                    }
                    set.add(string2);
                    double d = 1.0 / (double)(n6 - 1);
                    for (int i = 1; i < n6; ++i) {
                        string3 = stringArray[i];
                        arrayList.add(string2);
                        arrayList.add(string3);
                        if (bl7 && !stringFilter2.isAcceptable(string3)) {
                            if (treeSet == null) continue;
                            treeSet.add(string3);
                            continue;
                        }
                        if (doubleArrayList != null) {
                            doubleArrayList.add(d);
                        }
                        if (bl4) {
                            set2.add(string3);
                            continue;
                        }
                        set.add(string3);
                    }
                }
                catch (RuntimeException runtimeException) {
                    System.err.println("*** PROBLEM on line " + n5 + ", " + runtimeException.getMessage());
                    int n7 = -100;
                    textReader.close();
                    return n7;
                }
            }
            if (n4 == 0) {
                n4 = set.size();
            }
            System.out.println("Finished vertex neighbour list file input from " + string + " found " + set.size() + " vertices, " + arrayList.size() + " stubs");
        }
        catch (TextReader.Error error) {
            System.err.println("*** Input Error: " + error.getMessage());
            n4 = -2;
        }
        finally {
            textReader.close();
        }
        if (bl4 && bl2) {
            if (FileInput.checkBiPartite(set, set2)) {
                System.out.println("--- Bipartite structure OK");
            } else {
                System.err.println("*** Requested bipartite structure not found");
                n4 = -3;
            }
        }
        return n4;
    }

    public TreeSet<String> readStringVerticesFile(String string) {
        boolean bl = false;
        int n = 1;
        boolean bl2 = true;
        return this.readStringVerticesFile(string, bl2, bl, n);
    }

    public TreeSet<String> readStringVerticesFile(String string, boolean bl, boolean bl2, int n) {
        System.out.println("Starting to read list with vertices in first column from " + string);
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        StringFilter stringFilter = null;
        StringFilter stringFilter2 = null;
        TreeSet<String> treeSet3 = null;
        FileInput.readStringVertexNeighbourFile(string, treeSet, treeSet2, arrayList, doubleArrayList, bl, bl2, n, stringFilter, stringFilter2, treeSet3, this.infoLevel > 1);
        return treeSet;
    }

    public static boolean checkBiPartite(Collection<String> collection, Collection<String> collection2) {
        Collection<String> collection3;
        Collection<String> collection4;
        boolean bl = true;
        if (collection.size() > collection2.size()) {
            collection4 = collection;
            collection3 = collection2;
        } else {
            collection3 = collection;
            collection4 = collection2;
        }
        for (String string : collection3) {
            if (!collection4.contains(string)) continue;
            bl = false;
            System.out.println("checkBiPartite: both vertex sets contain \"" + string + "\"");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readStringVertexNeighbourFileUnipartite(timgraph timgraph2, String string, TreeSet<String> treeSet, ArrayList<String> arrayList) {
        int n = 9999999;
        int n2 = -n;
        timgraph2.inputName.setNameEnd(string);
        String string2 = timgraph2.inputName.getFullFileName();
        this.data = FileInput.openFile(string2);
        if (this.data == null) {
            return -1;
        }
        int n3 = 0;
        System.out.println("Starting to read vertex neighbour list with string vertex labels from " + string2);
        try {
            System.out.println(" File: " + string2);
            int n4 = 0;
            String[] stringArray = new String[nmax];
            String string3 = "NOTSET";
            String string4 = "NOTSET";
            while (!this.data.eof()) {
                int n5;
                ++n4;
                if (this.infoLevel > 2) {
                    System.out.println(n4 + ": ");
                }
                int n6 = 0;
                while (!this.data.eoln()) {
                    stringArray[n6++] = this.data.getWord();
                }
                if (this.infoLevel > 1) {
                    System.out.print(n4);
                    for (n5 = 0; n5 < n6; ++n5) {
                        System.out.print(", " + stringArray[n5]);
                    }
                    System.out.println();
                }
                try {
                    if (n6 < 1) {
                        System.err.println("*** Too few columns on line " + n4 + " expected at least one, found " + n6);
                        n3 = -10;
                        arrayList.add("T.F.C. line " + n4);
                        continue;
                    }
                    string3 = stringArray[0];
                    treeSet.add(string3);
                    for (n5 = 1; n5 < n6; ++n5) {
                        string4 = stringArray[n5];
                        arrayList.add(string3);
                        arrayList.add(string4);
                        treeSet.add(string4);
                    }
                }
                catch (RuntimeException runtimeException) {
                    System.err.println("*** PROBLEM on line " + n4 + ", " + runtimeException.getMessage());
                    int n7 = -100;
                    this.data.close();
                    return n7;
                }
            }
            if (n3 == 0) {
                n3 = treeSet.size();
            }
            System.out.println("Finished vertex neighbour list file input from " + string2 + " found " + treeSet.size() + " vertices, " + arrayList.size() + " stubs");
        }
        catch (TextReader.Error error) {
            System.err.println("*** Input Error: " + error.getMessage());
            n3 = -2;
        }
        finally {
            this.data.close();
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processPajekFile(timgraph timgraph2, String string, boolean bl, boolean bl2) {
        timgraph2.setVertexlabels(true);
        timgraph2.setDirectedGraph(bl);
        timgraph2.setNetwork();
        timgraph2.inputName.setNameEnd(string);
        String string2 = timgraph2.inputName.getFullFileName();
        System.out.println("Starting to read " + (bl ? "" : "un") + "directed " + (bl2 ? "" : "un") + "weighted Pajek Network file from " + string2);
        int n = 0;
        this.data = FileInput.openFile(string2);
        if (this.data == null) {
            return -1;
        }
        int n2 = 1;
        try {
            System.out.println(" File: " + string2);
            int n3 = -1;
            String string3 = this.data.getWord();
            if (string3.charAt(0) != '*') {
                System.err.println("*** ERROR line " + n2 + " first word should not be _" + string3 + "_");
                int n4 = -1;
                return n4;
            }
            n3 = this.data.getlnInt();
            if (n3 < 1) {
                System.err.println("*** ERROR line " + n2 + "  total number of vertices should not be " + n3);
                int n5 = -2;
                return n5;
            }
            System.out.println("Vertex Section starts on line " + n2 + " Total number of vertices given as " + n3);
            int n6 = -1;
            ++n2;
            while (n2 < n3 + 2) {
                if (this.infoLevel > 2) {
                    System.out.println(n2 + "/" + n3 + ": ");
                }
                if (this.data.eof()) {
                    System.err.println("*** ERROR line " + n2 + "  end of file encountered before all" + n3 + " vertices read.");
                    int n7 = -3;
                    return n7;
                }
                String string4 = "[" + n2 + "]";
                n6 = -1;
                string3 = "";
                double d = 0.0;
                double d2 = 0.0;
                double d3 = n2;
                int n8 = 1;
                while (!this.data.eoln()) {
                    switch (n8) {
                        case 1: {
                            n6 = this.data.getInt();
                            break;
                        }
                        case 2: {
                            String string5 = this.data.getWord();
                            string4 = string5.substring(1, string5.length() - 1);
                            break;
                        }
                        case 3: {
                            d = this.data.getDouble();
                            break;
                        }
                        case 4: {
                            d2 = this.data.getDouble();
                            break;
                        }
                        case 5: {
                            d3 = this.data.getDouble();
                            break;
                        }
                        default: {
                            string3 = this.data.getWord();
                        }
                    }
                    ++n8;
                }
                if (n6 != n2 - 1 || n6 > n3 + 1) {
                    System.err.println("*** ERROR line " + n2 + "  vertex number should not be " + n6);
                    n8 = -4;
                    return n8;
                }
                Coordinate coordinate = new Coordinate(d, d2, d3);
                timgraph2.addVertex(new VertexLabel(string4, coordinate));
                ++n2;
            }
            string3 = this.data.getWord();
            if (string3.charAt(0) != '*') {
                System.err.println("*** ERROR line " + n2 + " next word should be start of edge/arc section, not _" + string3 + "_");
                int n9 = -5;
                return n9;
            }
            boolean bl3 = false;
            if (string3.charAt(1) == 'A') {
                bl3 = true;
            } else if (string3.charAt(1) == 'E') {
                bl3 = false;
            } else {
                System.err.println("*** ERROR line " + n2 + "  first word of edge section should not be " + string3);
                int n10 = -6;
                return n10;
            }
            if (bl3 != timgraph2.isDirected()) {
                System.out.println("--- WARNING line " + n2 + "  file requests " + string3 + " but graph will set to be opposite");
            }
            int n11 = -1;
            n11 = this.data.getInt();
            if (n11 < 1) {
                System.err.println("*** ERROR line " + n2 + "  total number of edges should not be " + n11);
                int n12 = -7;
                return n12;
            }
            System.out.println("Starting to read edges on line " + n2 + " graph Type is " + timgraph2.graphType(this.SEP));
            int n13 = -1;
            int n14 = -1;
            int n15 = -1;
            int n16 = -1;
            while (!this.data.eof()) {
                ++n2;
                if (this.infoLevel > 2) {
                    System.out.println(n2 + ": ");
                }
                if ((n14 = this.data.getInt()) < 1 || n14 > timgraph2.getNumberVertices()) {
                    System.err.println("*** ERROR line " + n2 + "  source vertex number of " + n14 + " when total is " + timgraph2.getNumberVertices());
                    int n17 = -8;
                    return n17;
                }
                n15 = this.data.getlnInt();
                if (n15 < 1 || n15 > timgraph2.getNumberVertices()) {
                    System.err.println("*** ERROR line " + n2 + "  target vertex number of " + n15 + " when total is " + timgraph2.getNumberVertices());
                    int n18 = -9;
                    return n18;
                }
                if (bl2) {
                    n16 = this.data.getlnInt();
                    if (n15 < 1 || n15 > timgraph2.getNumberVertices()) {
                        System.err.println("*** ERROR line " + n2 + "  weight " + n16 + " of edge from " + n14 + " to " + n15 + " when total is " + timgraph2.getNumberVertices());
                        int n19 = -10;
                        return n19;
                    }
                    timgraph2.addEdge(n14 - 1, n15 - 1, n16);
                    continue;
                }
                this.data.getln();
                timgraph2.addEdge(n14 - 1, n15 - 1);
            }
            System.out.println("Finished reading pajek file " + string2 + "  number of lines was " + n2);
        }
        catch (TextReader.Error error) {
            System.err.println("*** Input Error " + string2 + " on line " + n2 + " " + error.getMessage());
            n = -99;
        }
        finally {
            this.data.close();
        }
        timgraph2.calcMinimumVertexLabel();
        timgraph2.calcMaximumVertexLabel();
        if (timgraph2.getMinimumVertexCoordinate().distance2D(timgraph2.getMaximumVertexCoordinate()) < 1.0E-6) {
            double d = 0.0;
            for (int i = 0; i < timgraph2.getNumberVertices(); ++i) {
                double d4 = (double)i / (double)timgraph2.getNumberVertices();
                d = Math.PI * 2 * d4;
                timgraph2.setVertexPositionQuick(i, new Coordinate(0.5 + Math.cos(d) / 2.0, 0.5 + Math.sin(d) / 2.0, d4));
            }
            timgraph2.getMinimumVertexCoordinate().set(0.0, 0.0, 0.0);
            timgraph2.getMaximumVertexCoordinate().set(1.0, 1.0, 1.0);
        }
        return n;
    }
}

